--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: data_point; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE data_point (
    created_at timestamp without time zone NOT NULL,
    id integer NOT NULL,
    value numeric NOT NULL,
    series_id integer,
    device_id integer
);


--
-- Name: data_point_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE data_point_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: data_point_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE data_point_id_seq OWNED BY data_point.id;


--
-- Name: device; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE device (
    created_at timestamp without time zone NOT NULL,
    id integer NOT NULL,
    name character varying(20),
    device_type integer,
    device_sub_type integer,
    device_id character varying(20) NOT NULL
);


--
-- Name: device_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE device_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE device_id_seq OWNED BY device.id;


--
-- Name: series; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE series (
    created_at timestamp without time zone NOT NULL,
    id integer NOT NULL,
    name character varying(20) NOT NULL
);


--
-- Name: series_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE series_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: series_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE series_id_seq OWNED BY series.id;


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY data_point ALTER COLUMN id SET DEFAULT nextval('data_point_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY device ALTER COLUMN id SET DEFAULT nextval('device_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY series ALTER COLUMN id SET DEFAULT nextval('series_id_seq'::regclass);


--
-- Data for Name: data_point; Type: TABLE DATA; Schema: public; Owner: -
--

COPY data_point (created_at, id, value, series_id, device_id) FROM stdin;
2014-03-24 22:13:55.850279	1	21.6	1	1
2014-03-24 22:13:56.170751	2	53	2	1
2014-03-24 22:14:34.34784	3	21.6	1	1
2014-03-24 22:14:34.582955	4	53	2	1
2014-03-24 22:15:13.349451	5	21.6	1	1
2014-03-24 22:15:13.579546	6	53	2	1
2014-03-24 22:15:20.911071	7	804	3	2
2014-03-24 22:15:32.973013	8	1963	3	2
2014-03-24 22:15:44.851207	9	692	3	2
2014-03-24 22:15:56.846111	10	676	3	2
2014-03-24 22:16:08.84758	11	724	3	2
2014-03-24 22:16:20.975857	12	1931	3	2
2014-03-24 22:16:32.861562	13	692	3	2
2014-03-24 22:16:44.978984	14	659	3	2
2014-03-24 22:16:56.97429	15	1818	3	2
2014-03-24 22:17:08.847892	16	676	3	2
2014-03-24 22:17:20.84703	17	659	3	2
2014-03-24 22:17:32.850551	18	1818	3	2
2014-03-24 22:17:44.850275	19	627	3	2
2014-03-24 22:17:49.341863	20	21.6	1	1
2014-03-24 22:17:49.563937	21	54	2	1
2014-03-24 22:17:56.848686	22	627	3	2
2014-03-24 22:18:08.848205	23	659	3	2
2014-03-24 22:18:20.850294	24	1802	3	2
2014-03-24 22:18:28.342306	25	21.5	1	1
2014-03-24 22:18:28.56414	26	54	2	1
2014-03-24 22:18:32.848971	27	515	3	2
2014-03-24 22:18:44.853117	28	434	3	2
2014-03-24 22:18:56.846362	29	434	3	2
2014-03-24 22:19:07.336311	30	21.5	1	1
2014-03-24 22:19:07.582021	31	54	2	1
2014-03-24 22:19:32.850865	32	434	3	2
2014-03-24 22:19:46.347017	33	21.5	1	1
2014-03-24 22:19:46.57143	34	54	2	1
2014-03-24 22:20:25.332586	35	21.5	1	1
2014-03-24 22:20:25.554199	36	54	2	1
2014-03-24 22:20:32.850399	37	418	3	2
2014-03-24 22:20:56.853566	38	466	3	2
2014-03-24 22:21:04.333993	39	21.5	1	1
2014-03-24 22:21:04.556445	40	54	2	1
2014-03-24 22:21:08.852473	41	482	3	2
2014-03-24 22:21:32.85203	42	466	3	2
2014-03-24 22:21:43.339436	43	21.5	1	1
2014-03-24 22:21:43.811343	44	54	2	1
2014-03-24 22:22:22.337916	45	21.4	1	1
2014-03-24 22:22:22.560142	46	54	2	1
2014-03-24 22:22:32.850394	47	466	3	2
2014-03-24 22:22:56.869118	48	595	3	2
2014-03-24 22:23:01.341642	49	21.4	1	1
2014-03-24 22:23:01.562292	50	54	2	1
2014-03-24 22:23:08.851545	51	595	3	2
2014-03-24 22:23:32.853614	52	595	3	2
2014-03-24 22:23:40.340086	53	21.4	1	1
2014-03-24 22:23:40.572435	54	54	2	1
2014-03-24 22:23:56.849202	55	643	3	2
2014-03-24 22:24:19.482082	56	21.4	1	1
2014-03-24 22:24:19.97999	57	54	2	1
2014-03-24 22:24:20.979964	58	531	3	2
2014-03-24 22:24:32.855329	59	515	3	2
2014-03-24 22:24:58.139659	60	547	3	2
2014-03-24 22:24:58.453566	61	21.4	1	1
2014-03-24 22:24:58.67631	62	54	2	1
2014-03-24 22:25:08.853375	63	547	3	2
2014-03-24 22:25:32.849011	64	498	3	2
2014-03-24 22:25:37.330121	65	21.4	1	1
2014-03-24 22:25:37.561591	66	54	2	1
2014-03-24 22:25:44.851397	67	498	3	2
2014-03-24 22:26:16.329342	68	21.3	1	1
2014-03-24 22:26:16.575216	69	54	2	1
2014-03-24 22:26:32.85029	70	498	3	2
2014-03-24 22:26:44.850727	71	402	3	2
2014-03-24 22:26:55.329779	72	21.3	1	1
2014-03-24 22:26:55.565922	73	54	2	1
2014-03-24 22:27:08.850227	74	498	3	2
2014-03-24 22:27:34.138544	75	482	3	2
2014-03-24 22:27:34.451276	76	21.3	1	1
2014-03-24 22:27:34.687598	77	54	2	1
2014-03-24 22:28:13.330422	78	21.3	1	1
2014-03-24 22:28:13.556188	79	54	2	1
2014-03-24 22:28:20.849501	80	402	3	2
2014-03-24 22:28:32.845401	81	402	3	2
2014-03-24 22:28:52.333726	82	21.3	1	1
2014-03-24 22:28:52.557197	83	54	2	1
2014-03-24 22:29:08.848305	84	370	3	2
2014-03-24 22:29:20.849952	85	338	3	2
2014-03-24 22:29:31.329945	86	21.3	1	1
2014-03-24 22:29:31.55296	87	54	2	1
2014-03-24 22:29:32.844906	88	338	3	2
2014-03-24 22:30:10.331422	89	21.2	1	1
2014-03-24 22:30:10.553327	90	54	2	1
2014-03-24 22:30:32.848924	91	338	3	2
2014-03-24 22:30:49.334444	92	21.2	1	1
2014-03-24 22:30:49.555987	93	54	2	1
2014-03-24 22:31:28.326609	94	21.2	1	1
2014-03-24 22:31:28.561332	95	54	2	1
2014-03-24 22:31:32.848514	96	338	3	2
2014-03-24 22:32:07.457552	97	21.2	1	1
2014-03-24 22:32:07.890007	98	54	2	1
2014-03-24 22:32:32.971978	99	338	3	2
2014-03-24 22:32:46.329981	100	21.2	1	1
2014-03-24 22:32:46.560128	101	54	2	1
2014-03-24 22:33:25.329086	102	21.2	1	1
2014-03-24 22:33:25.563749	103	54	2	1
2014-03-24 22:33:32.847537	104	305	3	2
2014-03-24 22:33:44.847575	105	305	3	2
2014-03-24 22:34:04.328018	106	21.2	1	1
2014-03-24 22:34:04.561267	107	54	2	1
2014-03-24 22:34:32.849378	108	305	3	2
2014-03-24 22:34:43.326144	109	21.2	1	1
2014-03-24 22:34:43.550926	110	54	2	1
2014-03-24 22:35:22.323715	111	21.1	1	1
2014-03-24 22:35:22.5507	112	54	2	1
2014-03-24 22:35:32.846155	113	305	3	2
2014-03-24 22:36:01.322595	114	21.1	1	1
2014-03-24 22:36:01.562701	115	54	2	1
2014-03-24 22:36:20.848273	116	434	3	2
2014-03-24 22:36:32.849324	117	450	3	2
2014-03-24 22:36:40.322523	118	21.1	1	1
2014-03-24 22:36:40.72982	119	54	2	1
2014-03-24 22:37:19.32354	120	21.1	1	1
2014-03-24 22:37:19.550577	121	54	2	1
2014-03-24 22:37:32.848116	122	450	3	2
2014-03-24 22:37:58.324145	123	21.1	1	1
2014-03-24 22:37:58.557548	124	54	2	1
2014-03-24 22:38:32.846092	125	434	3	2
2014-03-24 22:38:37.322383	126	21.1	1	1
2014-03-24 22:38:37.550743	127	54	2	1
2014-03-24 22:39:16.32718	128	21.1	1	1
2014-03-24 22:39:16.547407	129	54	2	1
2014-03-24 22:39:32.84581	130	434	3	2
2014-03-24 22:39:55.320923	131	21.0	1	1
2014-03-24 22:39:55.544481	132	54	2	1
2014-03-24 22:40:32.845755	133	418	3	2
2014-03-24 22:40:34.320906	134	21.0	1	1
2014-03-24 22:40:34.544471	135	54	2	1
2014-03-24 22:41:13.320256	136	21.0	1	1
2014-03-24 22:41:13.550669	137	54	2	1
2014-03-24 22:41:32.848162	138	418	3	2
2014-03-24 22:41:52.317912	139	21.0	1	1
2014-03-24 22:41:52.540713	140	54	2	1
2014-03-24 22:41:56.849186	141	370	3	2
2014-03-24 22:42:08.845999	142	370	3	2
2014-03-24 22:42:31.319983	143	21.0	1	1
2014-03-24 22:42:31.552296	144	54	2	1
2014-03-24 22:42:32.849361	145	370	3	2
2014-03-24 22:43:10.322047	146	21.0	1	1
2014-03-24 22:43:10.553136	147	54	2	1
2014-03-24 22:43:32.845769	148	370	3	2
2014-03-24 22:43:49.328872	149	21.0	1	1
2014-03-24 22:43:49.553132	150	54	2	1
2014-03-24 22:44:28.318849	151	21.0	1	1
2014-03-24 22:44:28.539363	152	54	2	1
2014-03-24 22:44:32.844088	153	370	3	2
2014-03-24 22:45:07.319536	154	21.0	1	1
2014-03-24 22:45:07.540939	155	54	2	1
2014-03-24 22:45:32.845682	156	370	3	2
2014-03-24 22:45:46.328713	157	21.0	1	1
2014-03-24 22:45:46.608634	158	54	2	1
2014-03-24 22:46:25.32097	159	20.9	1	1
2014-03-24 22:46:25.582832	160	54	2	1
2014-03-24 22:46:32.845735	161	370	3	2
2014-03-24 22:47:04.319032	162	20.9	1	1
2014-03-24 22:47:04.900711	163	54	2	1
2014-03-24 22:47:32.846588	164	370	3	2
2014-03-24 22:47:43.319743	165	20.9	1	1
2014-03-24 22:47:43.543839	166	54	2	1
2014-03-24 22:48:22.316602	167	20.9	1	1
2014-03-24 22:48:22.539347	168	54	2	1
2014-03-24 22:48:32.846679	169	370	3	2
2014-03-24 22:49:01.318967	170	20.9	1	1
2014-03-24 22:49:01.540158	171	54	2	1
2014-03-24 22:49:08.846646	172	434	3	2
2014-03-24 22:49:20.845089	173	418	3	2
2014-03-24 22:49:32.844053	174	418	3	2
2014-03-24 22:49:40.318612	175	20.9	1	1
2014-03-24 22:49:40.547895	176	54	2	1
2014-03-24 22:49:56.844895	177	354	3	2
2014-03-24 22:50:08.847043	178	354	3	2
2014-03-24 22:50:19.317817	179	20.9	1	1
2014-03-24 22:50:19.555098	180	54	2	1
2014-03-24 22:50:32.847101	181	370	3	2
2014-03-24 22:50:58.313942	182	20.9	1	1
2014-03-24 22:50:58.535743	183	54	2	1
2014-03-24 22:51:32.842843	184	354	3	2
2014-03-24 22:51:37.315765	185	20.9	1	1
2014-03-24 22:51:37.539691	186	54	2	1
2014-03-24 22:52:16.31598	187	20.9	1	1
2014-03-24 22:52:16.551123	188	54	2	1
2014-03-24 22:52:32.843037	189	354	3	2
2014-03-24 22:52:55.314701	190	20.8	1	1
2014-03-24 22:52:55.538305	191	54	2	1
2014-03-24 22:53:32.841863	192	354	3	2
2014-03-24 22:53:34.316733	193	20.8	1	1
2014-03-24 22:53:34.53832	194	54	2	1
2014-03-24 22:53:44.843864	195	305	3	2
2014-03-24 22:53:56.845795	196	305	3	2
2014-03-24 22:54:13.316925	197	20.8	1	1
2014-03-24 22:54:13.541426	198	54	2	1
2014-03-24 22:54:32.84496	199	305	3	2
2014-03-24 22:54:52.316773	200	20.8	1	1
2014-03-24 22:54:52.539442	201	54	2	1
2014-03-24 22:55:31.316742	202	20.8	1	1
2014-03-24 22:55:31.550378	203	54	2	1
2014-03-24 22:55:32.846767	204	305	3	2
2014-03-24 22:56:10.315323	205	20.8	1	1
2014-03-24 22:56:10.539066	206	54	2	1
2014-03-24 22:56:32.843856	207	338	3	2
2014-03-24 22:56:44.843963	208	305	3	2
2014-03-24 22:56:49.314102	209	20.8	1	1
2014-03-24 22:56:49.548833	210	54	2	1
2014-03-24 22:56:56.843981	211	305	3	2
2014-03-24 22:57:28.310777	212	20.8	1	1
2014-03-24 22:57:28.531837	213	54	2	1
2014-03-24 22:57:32.843677	214	305	3	2
2014-03-24 22:58:07.313315	215	20.8	1	1
2014-03-24 22:58:07.538423	216	54	2	1
2014-03-24 22:58:32.846476	217	305	3	2
2014-03-24 22:58:46.439978	218	20.8	1	1
2014-03-24 22:58:46.864044	219	54	2	1
2014-03-24 22:59:25.310025	220	20.8	1	1
2014-03-24 22:59:25.54054	221	54	2	1
2014-03-24 22:59:32.844731	222	305	3	2
2014-03-24 23:00:04.31375	223	20.8	1	1
2014-03-24 23:00:04.537203	224	54	2	1
2014-03-24 23:00:32.842789	225	305	3	2
2014-03-24 23:00:43.311157	226	20.8	1	1
2014-03-24 23:00:43.53245	227	54	2	1
2014-03-24 23:00:44.842259	228	354	3	2
2014-03-24 23:00:56.846433	229	354	3	2
2014-03-24 23:01:22.313676	230	20.8	1	1
2014-03-24 23:01:22.546803	231	54	2	1
2014-03-24 23:01:32.843979	232	354	3	2
2014-03-24 23:02:01.312053	233	20.7	1	1
2014-03-24 23:02:01.54269	234	54	2	1
2014-03-24 23:02:32.844828	235	354	3	2
2014-03-24 23:02:40.35412	236	20.7	1	1
2014-03-24 23:02:40.580865	237	54	2	1
2014-03-24 23:03:19.313387	238	20.7	1	1
2014-03-24 23:03:19.546302	239	54	2	1
2014-03-24 23:03:32.843953	240	354	3	2
2014-03-24 23:03:58.311697	241	20.7	1	1
2014-03-24 23:03:58.532907	242	54	2	1
2014-03-24 23:04:32.842872	243	370	3	2
2014-03-24 23:04:37.311555	244	20.7	1	1
2014-03-24 23:04:37.534381	245	54	2	1
2014-03-24 23:05:16.315022	246	20.7	1	1
2014-03-24 23:05:16.548057	247	54	2	1
2014-03-24 23:05:20.843628	248	305	3	2
2014-03-24 23:05:32.843749	249	305	3	2
2014-03-24 23:05:55.31086	250	20.7	1	1
2014-03-24 23:05:55.544145	251	54	2	1
2014-03-24 23:06:32.841486	252	289	3	2
2014-03-24 23:06:34.311934	253	20.7	1	1
2014-03-24 23:06:34.537845	254	54	2	1
2014-03-24 23:07:13.305516	255	20.7	1	1
2014-03-24 23:07:13.530091	256	54	2	1
2014-03-24 23:07:32.84241	257	289	3	2
2014-03-24 23:07:52.308751	258	20.7	1	1
2014-03-24 23:07:52.533377	259	54	2	1
2014-03-24 23:08:31.304695	260	20.7	1	1
2014-03-24 23:08:31.537345	261	54	2	1
2014-03-24 23:08:32.844963	262	289	3	2
2014-03-24 23:09:10.305273	263	20.7	1	1
2014-03-24 23:09:10.527307	264	54	2	1
2014-03-24 23:09:32.842985	265	289	3	2
2014-03-24 23:09:49.303906	266	20.6	1	1
2014-03-24 23:09:49.52733	267	54	2	1
2014-03-24 23:10:28.305311	268	20.6	1	1
2014-03-24 23:10:28.53889	269	54	2	1
2014-03-24 23:10:32.844908	270	289	3	2
2014-03-24 23:11:07.307401	271	20.6	1	1
2014-03-24 23:11:07.539323	272	54	2	1
2014-03-24 23:11:32.843547	273	289	3	2
2014-03-24 23:11:46.304562	274	20.6	1	1
2014-03-24 23:11:46.527458	275	54	2	1
2014-03-24 23:12:20.842316	276	338	3	2
2014-03-24 23:12:25.302706	277	20.6	1	1
2014-03-24 23:12:25.527621	278	54	2	1
2014-03-24 23:12:32.844926	279	354	3	2
2014-03-24 23:13:32.842274	280	354	3	2
2014-03-24 23:13:43.306504	281	20.6	1	1
2014-03-24 23:13:43.538651	282	54	2	1
2014-03-24 23:14:22.302555	283	20.6	1	1
2014-03-24 23:14:22.525666	284	54	2	1
2014-03-24 23:14:32.844646	285	354	3	2
2014-03-24 23:15:01.299698	286	20.6	1	1
2014-03-24 23:15:01.525085	287	54	2	1
2014-03-24 23:15:32.843778	288	354	3	2
2014-03-24 23:15:40.305364	289	20.6	1	1
2014-03-24 23:15:40.527356	290	54	2	1
2014-03-24 23:16:19.304547	291	20.6	1	1
2014-03-24 23:16:19.534496	292	54	2	1
2014-03-24 23:16:32.842456	293	354	3	2
2014-03-24 23:16:58.304846	294	20.6	1	1
2014-03-24 23:16:58.528133	295	54	2	1
2014-03-24 23:17:32.842565	296	354	3	2
2014-03-24 23:17:37.298324	297	20.6	1	1
2014-03-24 23:17:37.526126	298	54	2	1
2014-03-24 23:18:16.301394	299	20.6	1	1
2014-03-24 23:18:16.533915	300	54	2	1
2014-03-24 23:18:32.840486	301	354	3	2
2014-03-24 23:18:44.843196	302	305	3	2
2014-03-24 23:18:55.302562	303	20.6	1	1
2014-03-24 23:18:55.536119	304	54	2	1
2014-03-24 23:18:56.842531	305	305	3	2
2014-03-24 23:19:32.844594	306	305	3	2
2014-03-24 23:19:34.298207	307	20.6	1	1
2014-03-24 23:19:34.530516	308	54	2	1
2014-03-24 23:20:13.300238	309	20.6	1	1
2014-03-24 23:20:13.523188	310	54	2	1
2014-03-24 23:20:32.841363	311	305	3	2
2014-03-24 23:20:52.299523	312	20.6	1	1
2014-03-24 23:20:52.52337	313	54	2	1
2014-03-24 23:21:31.301236	314	20.5	1	1
2014-03-24 23:21:31.52155	315	54	2	1
2014-03-24 23:21:32.842032	316	305	3	2
2014-03-24 23:22:10.358508	317	20.5	1	1
2014-03-24 23:22:10.581169	318	54	2	1
2014-03-24 23:22:32.845947	319	305	3	2
2014-03-24 23:22:49.30136	320	20.5	1	1
2014-03-24 23:22:49.527526	321	54	2	1
2014-03-24 23:23:28.299045	322	20.5	1	1
2014-03-24 23:23:28.523657	323	54	2	1
2014-03-24 23:23:32.8383	324	305	3	2
2014-03-24 23:24:07.295724	325	20.5	1	1
2014-03-24 23:24:07.518526	326	54	2	1
2014-03-24 23:24:32.838977	327	305	3	2
2014-03-24 23:24:46.300692	328	20.5	1	1
2014-03-24 23:24:46.522758	329	54	2	1
2014-03-24 23:25:25.299263	330	20.5	1	1
2014-03-24 23:25:25.542214	331	54	2	1
2014-03-24 23:25:32.842405	332	305	3	2
2014-03-24 23:26:04.299345	333	20.5	1	1
2014-03-24 23:26:04.531663	334	54	2	1
2014-03-24 23:26:08.842909	335	354	3	2
2014-03-24 23:26:20.840735	336	354	3	2
2014-03-24 23:26:32.8392	337	370	3	2
2014-03-24 23:26:43.296731	338	20.5	1	1
2014-03-24 23:26:43.518869	339	54	2	1
2014-03-24 23:27:20.839788	340	434	3	2
2014-03-24 23:27:22.296931	341	20.5	1	1
2014-03-24 23:27:22.518913	342	54	2	1
2014-03-24 23:27:32.841956	343	434	3	2
2014-03-24 23:28:01.299998	344	20.5	1	1
2014-03-24 23:28:01.524743	345	54	2	1
2014-03-24 23:28:40.102459	346	434	3	2
2014-03-24 23:28:40.41611	347	20.5	1	1
2014-03-24 23:28:40.700032	348	54	2	1
2014-03-24 23:29:19.296759	349	20.5	1	1
2014-03-24 23:29:19.519496	350	54	2	1
2014-03-24 23:29:32.840656	351	434	3	2
2014-03-24 23:29:58.29414	352	20.5	1	1
2014-03-24 23:29:58.518301	353	54	2	1
2014-03-24 23:30:32.842074	354	418	3	2
2014-03-24 23:30:37.291385	355	20.5	1	1
2014-03-24 23:30:37.525192	356	54	2	1
2014-03-24 23:31:16.294269	357	20.5	1	1
2014-03-24 23:31:16.51766	358	54	2	1
2014-03-24 23:31:20.840054	359	370	3	2
2014-03-24 23:31:32.839046	360	370	3	2
2014-03-24 23:31:55.291974	361	20.5	1	1
2014-03-24 23:31:55.513683	362	54	2	1
2014-03-24 23:31:56.844521	363	402	3	2
2014-03-24 23:32:08.841165	364	370	3	2
2014-03-24 23:32:20.842063	365	370	3	2
2014-03-24 23:32:32.840454	366	402	3	2
2014-03-24 23:32:34.290404	367	20.4	1	1
2014-03-24 23:32:34.510664	368	54	2	1
2014-03-24 23:32:44.840351	369	402	3	2
2014-03-24 23:33:08.841381	370	370	3	2
2014-03-24 23:33:13.29483	371	20.4	1	1
2014-03-24 23:33:13.518057	372	54	2	1
2014-03-24 23:33:20.841685	373	402	3	2
2014-03-24 23:33:32.839752	374	402	3	2
2014-03-24 23:33:52.289796	375	20.4	1	1
2014-03-24 23:33:52.512348	376	54	2	1
2014-03-24 23:34:31.291875	377	20.4	1	1
2014-03-24 23:34:31.513961	378	54	2	1
2014-03-24 23:34:32.837421	379	402	3	2
2014-03-24 23:35:10.291456	380	20.4	1	1
2014-03-24 23:35:10.52079	381	54	2	1
2014-03-24 23:35:32.842584	382	402	3	2
2014-03-24 23:35:49.293948	383	20.4	1	1
2014-03-24 23:35:49.527085	384	54	2	1
2014-03-24 23:36:28.290768	385	20.4	1	1
2014-03-24 23:36:28.510241	386	54	2	1
2014-03-24 23:36:32.84254	387	402	3	2
2014-03-24 23:37:07.287623	388	20.4	1	1
2014-03-24 23:37:07.508685	389	54	2	1
2014-03-24 23:37:46.291028	390	20.4	1	1
2014-03-24 23:37:46.518546	391	54	2	1
2014-03-24 23:38:25.293144	392	20.4	1	1
2014-03-24 23:38:25.516188	393	54	2	1
2014-03-24 23:38:32.837543	394	450	3	2
2014-03-24 23:38:44.842018	395	434	3	2
2014-03-24 23:39:04.285875	396	20.4	1	1
2014-03-24 23:39:04.514273	397	54	2	1
2014-03-24 23:39:32.839051	398	434	3	2
2014-03-24 23:39:43.288941	399	20.4	1	1
2014-03-24 23:39:43.533948	400	54	2	1
2014-03-24 23:40:22.2857	401	20.4	1	1
2014-03-24 23:40:22.508949	402	54	2	1
2014-03-24 23:40:32.838309	403	434	3	2
2014-03-24 23:41:01.28434	404	20.4	1	1
2014-03-24 23:41:01.508939	405	54	2	1
2014-03-24 23:41:08.838168	406	370	3	2
2014-03-24 23:41:20.839532	407	370	3	2
2014-03-24 23:41:32.840482	408	370	3	2
2014-03-24 23:41:40.285343	409	20.4	1	1
2014-03-24 23:41:40.51165	410	54	2	1
2014-03-24 23:42:19.284841	411	20.4	1	1
2014-03-24 23:42:19.507112	412	54	2	1
2014-03-24 23:42:32.838304	413	370	3	2
2014-03-24 23:42:58.282956	414	20.4	1	1
2014-03-24 23:42:58.505192	415	54	2	1
2014-03-24 23:43:32.839562	416	338	3	2
2014-03-24 23:43:37.289875	417	20.4	1	1
2014-03-24 23:43:37.513402	418	54	2	1
2014-03-24 23:43:44.840704	419	338	3	2
2014-03-24 23:44:16.285341	420	20.4	1	1
2014-03-24 23:44:16.509389	421	54	2	1
2014-03-24 23:44:32.83846	422	338	3	2
2014-03-24 23:44:44.841821	423	305	3	2
2014-03-24 23:44:55.284944	424	20.4	1	1
2014-03-24 23:44:55.517331	425	54	2	1
2014-03-24 23:44:56.839343	426	338	3	2
2014-03-24 23:45:08.839537	427	338	3	2
2014-03-24 23:45:20.838293	428	305	3	2
2014-03-24 23:45:32.840717	429	305	3	2
2014-03-24 23:45:34.287184	430	20.4	1	1
2014-03-24 23:45:34.508958	431	54	2	1
2014-03-24 23:46:13.285999	432	20.4	1	1
2014-03-24 23:46:13.509014	433	54	2	1
2014-03-24 23:46:32.842597	434	305	3	2
2014-03-24 23:46:52.285612	435	20.4	1	1
2014-03-24 23:46:52.507395	436	54	2	1
2014-03-24 23:47:31.284023	437	20.4	1	1
2014-03-24 23:47:31.506763	438	54	2	1
2014-03-24 23:47:32.838606	439	305	3	2
2014-03-24 23:48:10.285616	440	20.3	1	1
2014-03-24 23:48:10.506706	441	54	2	1
2014-03-24 23:48:32.835176	442	305	3	2
2014-03-24 23:48:49.286714	443	20.3	1	1
2014-03-24 23:48:49.508149	444	54	2	1
2014-03-24 23:49:28.28633	445	20.3	1	1
2014-03-24 23:49:28.51865	446	54	2	1
2014-03-24 23:49:32.842545	447	305	3	2
2014-03-24 23:50:07.292406	448	20.3	1	1
2014-03-24 23:50:07.5172	449	54	2	1
2014-03-24 23:50:32.839255	450	305	3	2
2014-03-24 23:50:46.284049	451	20.3	1	1
2014-03-24 23:50:46.513315	452	54	2	1
2014-03-24 23:50:56.839844	453	354	3	2
2014-03-24 23:51:08.835196	454	354	3	2
2014-03-24 23:51:25.280883	455	20.3	1	1
2014-03-24 23:51:25.522687	456	54	2	1
2014-03-24 23:51:32.839031	457	354	3	2
2014-03-24 23:52:04.283835	458	20.3	1	1
2014-03-24 23:52:04.505768	459	54	2	1
2014-03-24 23:52:32.843556	460	354	3	2
2014-03-24 23:52:43.281964	461	20.3	1	1
2014-03-24 23:52:43.505089	462	54	2	1
2014-03-24 23:53:22.283055	463	20.3	1	1
2014-03-24 23:53:22.506518	464	54	2	1
2014-03-24 23:53:32.836378	465	338	3	2
2014-03-24 23:54:01.283442	466	20.3	1	1
2014-03-24 23:54:01.51591	467	54	2	1
2014-03-24 23:54:32.841248	468	338	3	2
2014-03-24 23:54:40.281289	469	20.3	1	1
2014-03-24 23:54:40.504097	470	54	2	1
2014-03-24 23:55:08.839126	471	289	3	2
2014-03-24 23:55:19.282333	472	20.3	1	1
2014-03-24 23:55:19.506929	473	54	2	1
2014-03-24 23:55:20.839771	474	289	3	2
2014-03-24 23:55:32.838472	475	289	3	2
2014-03-24 23:55:58.278119	476	20.3	1	1
2014-03-24 23:55:58.502944	477	54	2	1
2014-03-24 23:56:32.837844	478	289	3	2
2014-03-24 23:56:37.28073	479	20.3	1	1
2014-03-24 23:56:37.507448	480	54	2	1
2014-03-24 23:57:16.281207	481	20.3	1	1
2014-03-24 23:57:16.510541	482	54	2	1
2014-03-24 23:57:32.841233	483	305	3	2
2014-03-24 23:57:55.280927	484	20.3	1	1
2014-03-24 23:57:55.505547	485	54	2	1
2014-03-24 23:58:32.836892	486	305	3	2
2014-03-24 23:58:34.277215	487	20.3	1	1
2014-03-24 23:58:34.500438	488	54	2	1
2014-03-24 23:59:13.275584	489	20.3	1	1
2014-03-24 23:59:13.498669	490	54	2	1
2014-03-24 23:59:32.836201	491	305	3	2
2014-03-24 23:59:52.277952	492	20.3	1	1
2014-03-24 23:59:52.50092	493	54	2	1
2014-03-25 00:00:31.275046	494	20.3	1	1
2014-03-25 00:00:31.500677	495	54	2	1
2014-03-25 00:00:32.836298	496	305	3	2
2014-03-25 00:01:10.274465	497	20.3	1	1
2014-03-25 00:01:10.498957	498	54	2	1
2014-03-25 00:01:32.835947	499	305	3	2
2014-03-25 00:01:49.274773	500	20.3	1	1
2014-03-25 00:01:49.498704	501	54	2	1
2014-03-25 00:01:56.83942	502	354	3	2
2014-03-25 00:02:08.839136	503	354	3	2
2014-03-25 00:02:28.277916	504	20.2	1	1
2014-03-25 00:02:28.503751	505	54	2	1
2014-03-25 00:02:32.839166	506	354	3	2
2014-03-25 00:03:07.276492	507	20.2	1	1
2014-03-25 00:03:07.505122	508	54	2	1
2014-03-25 00:03:32.84113	509	354	3	2
2014-03-25 00:03:46.276232	510	20.2	1	1
2014-03-25 00:03:46.512072	511	54	2	1
2014-03-25 00:04:25.275793	512	20.2	1	1
2014-03-25 00:04:25.505539	513	54	2	1
2014-03-25 00:04:32.838223	514	354	3	2
2014-03-25 00:05:04.279603	515	20.2	1	1
2014-03-25 00:05:04.504135	516	54	2	1
2014-03-25 00:05:32.83951	517	354	3	2
2014-03-25 00:05:43.275624	518	20.2	1	1
2014-03-25 00:05:43.499004	519	54	2	1
2014-03-25 00:06:22.273289	520	20.2	1	1
2014-03-25 00:06:22.507433	521	54	2	1
2014-03-25 00:06:32.838835	522	354	3	2
2014-03-25 00:07:01.274141	523	20.2	1	1
2014-03-25 00:07:01.496646	524	54	2	1
2014-03-25 00:07:08.836352	525	305	3	2
2014-03-25 00:07:20.836804	526	305	3	2
2014-03-25 00:07:32.837229	527	305	3	2
2014-03-25 00:07:40.276586	528	20.2	1	1
2014-03-25 00:07:40.502381	529	54	2	1
2014-03-25 00:08:19.275067	530	20.2	1	1
2014-03-25 00:08:19.507561	531	54	2	1
2014-03-25 00:08:32.837206	532	305	3	2
2014-03-25 00:08:58.272301	533	20.2	1	1
2014-03-25 00:08:58.495315	534	54	2	1
2014-03-25 00:09:32.836528	535	305	3	2
2014-03-25 00:09:37.271928	536	20.2	1	1
2014-03-25 00:09:37.49506	537	54	2	1
2014-03-25 00:10:16.273662	538	20.2	1	1
2014-03-25 00:10:16.515516	539	54	2	1
2014-03-25 00:10:32.834522	540	305	3	2
2014-03-25 00:10:44.836868	541	338	3	2
2014-03-25 00:10:55.270779	542	20.2	1	1
2014-03-25 00:10:55.502657	543	54	2	1
2014-03-25 00:10:56.834044	544	338	3	2
2014-03-25 00:11:08.83702	545	305	3	2
2014-03-25 00:11:32.695632	546	305	3	2
2014-03-25 00:11:33.012163	547	305	3	2
2014-03-25 00:11:34.268079	548	20.2	1	1
2014-03-25 00:11:34.491502	549	54	2	1
2014-03-25 00:12:13.268584	550	20.2	1	1
2014-03-25 00:12:13.50263	551	54	2	1
2014-03-25 00:12:32.834705	552	305	3	2
2014-03-25 00:12:52.271771	553	20.2	1	1
2014-03-25 00:12:52.492986	554	54	2	1
2014-03-25 00:13:31.270353	555	20.2	1	1
2014-03-25 00:13:31.490166	556	54	2	1
2014-03-25 00:13:32.83434	557	305	3	2
2014-03-25 00:14:10.26779	558	20.2	1	1
2014-03-25 00:14:10.499451	559	54	2	1
2014-03-25 00:14:20.830352	560	370	3	2
2014-03-25 00:14:49.077626	561	370	3	2
2014-03-25 00:14:49.383351	562	20.2	1	1
2014-03-25 00:14:49.617721	563	54	2	1
2014-03-25 00:15:20.836237	564	402	3	2
2014-03-25 00:15:28.270493	565	20.2	1	1
2014-03-25 00:15:28.491364	566	54	2	1
2014-03-25 00:15:32.837821	567	402	3	2
2014-03-25 00:15:44.837117	568	370	3	2
2014-03-25 00:15:56.833482	569	354	3	2
2014-03-25 00:16:07.272615	570	20.2	1	1
2014-03-25 00:16:07.494645	571	54	2	1
2014-03-25 00:16:32.836682	572	354	3	2
2014-03-25 00:16:46.268253	573	20.2	1	1
2014-03-25 00:16:46.490967	574	54	2	1
2014-03-25 00:17:25.266785	575	20.2	1	1
2014-03-25 00:17:25.491261	576	54	2	1
2014-03-25 00:17:32.841126	577	354	3	2
2014-03-25 00:18:04.264436	578	20.2	1	1
2014-03-25 00:18:04.488285	579	54	2	1
2014-03-25 00:18:32.835013	580	354	3	2
2014-03-25 00:18:43.269093	581	20.2	1	1
2014-03-25 00:18:43.490775	582	54	2	1
2014-03-25 00:19:08.835656	583	434	3	2
2014-03-25 00:19:20.839394	584	434	3	2
2014-03-25 00:19:22.268047	585	20.2	1	1
2014-03-25 00:19:22.498046	586	54	2	1
2014-03-25 00:19:32.836117	587	434	3	2
2014-03-25 00:20:01.26959	588	20.2	1	1
2014-03-25 00:20:01.492767	589	54	2	1
2014-03-25 00:20:08.839723	590	370	3	2
2014-03-25 00:20:20.83404	591	370	3	2
2014-03-25 00:20:32.836043	592	370	3	2
2014-03-25 00:20:40.268015	593	20.2	1	1
2014-03-25 00:20:40.489784	594	54	2	1
2014-03-25 00:21:19.266244	595	20.1	1	1
2014-03-25 00:21:19.498048	596	54	2	1
2014-03-25 00:21:32.839259	597	370	3	2
2014-03-25 00:21:58.267113	598	20.1	1	1
2014-03-25 00:21:58.492157	599	54	2	1
2014-03-25 00:22:32.834691	600	370	3	2
2014-03-25 00:22:37.26739	601	20.1	1	1
2014-03-25 00:22:37.494764	602	54	2	1
2014-03-25 00:23:16.267971	603	20.1	1	1
2014-03-25 00:23:16.50153	604	54	2	1
2014-03-25 00:23:32.837862	605	370	3	2
2014-03-25 00:23:55.26184	606	20.1	1	1
2014-03-25 00:23:55.483859	607	54	2	1
2014-03-25 00:24:32.835525	608	370	3	2
2014-03-25 00:24:34.265901	609	20.1	1	1
2014-03-25 00:24:34.488569	610	54	2	1
2014-03-25 00:25:13.262137	611	20.1	1	1
2014-03-25 00:25:13.486731	612	54	2	1
2014-03-25 00:25:32.833024	613	370	3	2
2014-03-25 00:25:52.264342	614	20.1	1	1
2014-03-25 00:25:52.487039	615	54	2	1
2014-03-25 00:26:31.264993	616	20.1	1	1
2014-03-25 00:26:31.487285	617	54	2	1
2014-03-25 00:26:58.989748	618	370	3	2
2014-03-25 00:27:10.263142	619	20.1	1	1
2014-03-25 00:27:10.48807	620	54	2	1
2014-03-25 00:27:32.833575	621	418	3	2
2014-03-25 00:27:44.832149	622	418	3	2
2014-03-25 00:27:49.262067	623	20.1	1	1
2014-03-25 00:27:49.505675	624	54	2	1
2014-03-25 00:28:28.261887	625	20.1	1	1
2014-03-25 00:28:28.484092	626	54	2	1
2014-03-25 00:28:32.830777	627	418	3	2
2014-03-25 00:29:07.258502	628	20.1	1	1
2014-03-25 00:29:07.482228	629	54	2	1
2014-03-25 00:29:46.065484	630	418	3	2
2014-03-25 00:29:46.380543	631	20.1	1	1
2014-03-25 00:29:46.602016	632	54	2	1
2014-03-25 00:30:25.260032	633	20.1	1	1
2014-03-25 00:30:25.483629	634	54	2	1
2014-03-25 00:30:32.832648	635	418	3	2
2014-03-25 00:31:04.259178	636	20.1	1	1
2014-03-25 00:31:04.482574	637	54	2	1
2014-03-25 00:31:32.835821	638	418	3	2
2014-03-25 00:31:43.258855	639	20.1	1	1
2014-03-25 00:31:43.482836	640	54	2	1
2014-03-25 00:32:22.270289	641	20.1	1	1
2014-03-25 00:32:22.49831	642	54	2	1
2014-03-25 00:32:56.69348	643	418	3	2
2014-03-25 00:32:57.00326	644	354	3	2
2014-03-25 00:33:01.258159	645	20.1	1	1
2014-03-25 00:33:01.482151	646	54	2	1
2014-03-25 00:33:08.834674	647	289	3	2
2014-03-25 00:33:20.834786	648	305	3	2
2014-03-25 00:33:32.833153	649	305	3	2
2014-03-25 00:33:40.257965	650	20.1	1	1
2014-03-25 00:33:40.479463	651	54	2	1
2014-03-25 00:34:19.256258	652	20.1	1	1
2014-03-25 00:34:19.478186	653	54	2	1
2014-03-25 00:34:32.83263	654	305	3	2
2014-03-25 00:34:58.26	655	20.1	1	1
2014-03-25 00:34:58.491876	656	54	2	1
2014-03-25 00:35:32.832512	657	305	3	2
2014-03-25 00:35:37.259859	658	20.1	1	1
2014-03-25 00:35:37.48149	659	54	2	1
2014-03-25 00:36:16.25891	660	20.1	1	1
2014-03-25 00:36:16.481553	661	54	2	1
2014-03-25 00:36:32.831677	662	289	3	2
2014-03-25 00:36:55.259969	663	20.1	1	1
2014-03-25 00:36:55.482765	664	54	2	1
2014-03-25 00:37:32.831859	665	289	3	2
2014-03-25 00:37:34.255771	666	20.1	1	1
2014-03-25 00:37:34.498226	667	54	2	1
2014-03-25 00:38:13.255536	668	20.1	1	1
2014-03-25 00:38:13.48351	669	54	2	1
2014-03-25 00:38:32.834918	670	289	3	2
2014-03-25 00:38:52.258949	671	20.1	1	1
2014-03-25 00:38:52.484269	672	54	2	1
2014-03-25 00:39:31.253014	673	20.0	1	1
2014-03-25 00:39:31.480224	674	54	2	1
2014-03-25 00:39:32.834118	675	289	3	2
2014-03-25 00:40:10.255581	676	20.0	1	1
2014-03-25 00:40:10.481377	677	54	2	1
2014-03-25 00:40:20.836084	678	354	3	2
2014-03-25 00:40:32.834257	679	354	3	2
2014-03-25 00:40:49.254951	680	20.0	1	1
2014-03-25 00:40:49.479791	681	54	2	1
2014-03-25 00:41:28.254274	682	20.0	1	1
2014-03-25 00:41:28.504297	683	54	2	1
2014-03-25 00:41:32.834231	684	338	3	2
2014-03-25 00:42:07.257947	685	20.0	1	1
2014-03-25 00:42:07.48242	686	54	2	1
2014-03-25 00:42:46.059791	687	354	3	2
2014-03-25 00:42:46.37181	688	20.0	1	1
2014-03-25 00:42:46.596677	689	54	2	1
2014-03-25 00:43:25.253929	690	20.0	1	1
2014-03-25 00:43:25.490971	691	54	2	1
2014-03-25 00:43:32.833038	692	338	3	2
2014-03-25 00:44:04.251376	693	20.0	1	1
2014-03-25 00:44:04.476573	694	54	2	1
2014-03-25 00:44:32.834986	695	354	3	2
2014-03-25 00:44:43.254713	696	20.0	1	1
2014-03-25 00:44:43.477738	697	54	2	1
2014-03-25 00:45:22.253852	698	20.0	1	1
2014-03-25 00:45:22.477405	699	54	2	1
2014-03-25 00:45:32.832376	700	289	3	2
2014-03-25 00:45:44.833303	701	289	3	2
2014-03-25 00:46:01.249696	702	20.0	1	1
2014-03-25 00:46:01.472616	703	54	2	1
2014-03-25 00:46:32.832918	704	289	3	2
2014-03-25 00:46:40.252563	705	20.0	1	1
2014-03-25 00:46:40.475058	706	54	2	1
2014-03-25 00:47:19.250271	707	20.0	1	1
2014-03-25 00:47:19.472827	708	54	2	1
2014-03-25 00:47:32.831448	709	289	3	2
2014-03-25 00:47:58.252704	710	20.0	1	1
2014-03-25 00:47:58.477383	711	54	2	1
2014-03-25 00:48:32.833932	712	289	3	2
2014-03-25 00:48:37.247455	713	20.0	1	1
2014-03-25 00:48:37.471839	714	54	2	1
2014-03-25 00:49:16.249518	715	20.0	1	1
2014-03-25 00:49:16.473436	716	54	2	1
2014-03-25 00:49:32.83186	717	289	3	2
2014-03-25 00:49:55.246487	718	20.0	1	1
2014-03-25 00:49:55.467628	719	54	2	1
2014-03-25 00:50:32.832928	720	289	3	2
2014-03-25 00:50:34.247404	721	20.0	1	1
2014-03-25 00:50:34.477321	722	54	2	1
2014-03-25 00:51:13.31381	723	20.0	1	1
2014-03-25 00:51:13.548707	724	54	2	1
2014-03-25 00:51:32.834058	725	289	3	2
2014-03-25 00:51:52.244869	726	20.0	1	1
2014-03-25 00:51:52.467314	727	54	2	1
2014-03-25 00:52:31.244899	728	20.0	1	1
2014-03-25 00:52:31.465781	729	54	2	1
2014-03-25 00:52:32.832855	730	289	3	2
2014-03-25 00:52:56.832285	731	354	3	2
2014-03-25 00:53:08.83423	732	354	3	2
2014-03-25 00:53:10.24953	733	20.0	1	1
2014-03-25 00:53:10.479183	734	54	2	1
2014-03-25 00:53:32.832624	735	354	3	2
2014-03-25 00:53:49.257652	736	20.0	1	1
2014-03-25 00:53:49.78306	737	54	2	1
2014-03-25 00:54:28.247321	738	20.0	1	1
2014-03-25 00:54:28.507188	739	54	2	1
2014-03-25 00:54:32.832666	740	354	3	2
2014-03-25 00:55:07.246437	741	20.0	1	1
2014-03-25 00:55:07.524208	742	54	2	1
2014-03-25 00:55:32.833023	743	338	3	2
2014-03-25 00:55:46.245507	744	20.0	1	1
2014-03-25 00:55:46.467542	745	54	2	1
2014-03-25 00:56:25.24064	746	20.0	1	1
2014-03-25 00:56:25.465033	747	54	2	1
2014-03-25 00:56:32.834031	748	338	3	2
2014-03-25 00:57:04.244108	749	20.0	1	1
2014-03-25 00:57:04.467039	750	54	2	1
2014-03-25 00:57:32.83418	751	338	3	2
2014-03-25 00:57:43.2813	752	20.0	1	1
2014-03-25 00:57:43.522212	753	54	2	1
2014-03-25 00:57:44.833345	754	289	3	2
2014-03-25 00:57:56.831943	755	305	3	2
2014-03-25 00:58:20.829952	756	273	3	2
2014-03-25 00:58:22.243489	757	20.0	1	1
2014-03-25 00:58:22.475035	758	54	2	1
2014-03-25 00:58:32.832584	759	289	3	2
2014-03-25 00:59:01.24616	760	20.0	1	1
2014-03-25 00:59:01.46929	761	54	2	1
2014-03-25 00:59:32.832352	762	305	3	2
2014-03-25 00:59:40.243065	763	20.0	1	1
2014-03-25 00:59:40.467549	764	54	2	1
2014-03-25 01:00:19.242307	765	20.0	1	1
2014-03-25 01:00:19.466457	766	54	2	1
2014-03-25 01:00:32.830434	767	289	3	2
2014-03-25 01:00:58.243129	768	20.0	1	1
2014-03-25 01:00:58.46474	769	54	2	1
2014-03-25 01:01:32.832559	770	289	3	2
2014-03-25 01:01:37.240618	771	19.9	1	1
2014-03-25 01:01:37.475568	772	54	2	1
2014-03-25 01:02:16.242832	773	19.9	1	1
2014-03-25 01:02:16.465785	774	54	2	1
2014-03-25 01:02:32.830567	775	289	3	2
2014-03-25 01:02:55.24117	776	19.9	1	1
2014-03-25 01:02:55.464543	777	54	2	1
2014-03-25 01:03:32.830698	778	305	3	2
2014-03-25 01:03:34.244653	779	19.9	1	1
2014-03-25 01:03:34.467921	780	54	2	1
2014-03-25 01:04:13.244226	781	19.9	1	1
2014-03-25 01:04:13.512208	782	54	2	1
2014-03-25 01:04:32.832544	783	289	3	2
2014-03-25 01:04:52.242502	784	19.9	1	1
2014-03-25 01:04:52.4672	785	54	2	1
2014-03-25 01:05:08.831809	786	354	3	2
2014-03-25 01:05:20.829907	787	354	3	2
2014-03-25 01:05:31.253851	788	19.9	1	1
2014-03-25 01:05:32.233284	789	54	2	1
2014-03-25 01:05:32.830834	790	338	3	2
2014-03-25 01:06:10.24145	791	19.9	1	1
2014-03-25 01:06:10.463814	792	54	2	1
2014-03-25 01:06:32.831089	793	354	3	2
2014-03-25 01:06:49.239824	794	19.9	1	1
2014-03-25 01:06:49.463164	795	54	2	1
2014-03-25 01:07:28.242329	796	19.9	1	1
2014-03-25 01:07:28.464013	797	54	2	1
2014-03-25 01:07:32.835206	798	338	3	2
2014-03-25 01:08:07.239232	799	19.9	1	1
2014-03-25 01:08:07.472652	800	54	2	1
2014-03-25 01:08:32.829702	801	338	3	2
2014-03-25 01:08:46.23605	802	19.9	1	1
2014-03-25 01:08:46.458833	803	54	2	1
2014-03-25 01:09:20.834106	804	289	3	2
2014-03-25 01:09:25.241063	805	19.9	1	1
2014-03-25 01:09:25.464423	806	54	2	1
2014-03-25 01:09:32.830968	807	289	3	2
2014-03-25 01:10:04.236865	808	19.9	1	1
2014-03-25 01:10:04.46301	809	54	2	1
2014-03-25 01:10:32.833888	810	289	3	2
2014-03-25 01:10:43.238758	811	19.9	1	1
2014-03-25 01:10:43.464275	812	54	2	1
2014-03-25 01:11:22.237915	813	19.9	1	1
2014-03-25 01:11:22.469215	814	54	2	1
2014-03-25 01:11:32.825618	815	354	3	2
2014-03-25 01:11:44.829947	816	354	3	2
2014-03-25 01:12:01.235449	817	19.9	1	1
2014-03-25 01:12:01.470132	818	53	2	1
2014-03-25 01:12:32.833878	819	354	3	2
2014-03-25 01:12:40.236459	820	19.9	1	1
2014-03-25 01:12:40.460297	821	53	2	1
2014-03-25 01:13:32.829183	822	354	3	2
2014-03-25 01:13:58.23281	823	19.9	1	1
2014-03-25 01:13:58.455893	824	53	2	1
2014-03-25 01:14:32.830379	825	354	3	2
2014-03-25 01:14:37.233705	826	19.9	1	1
2014-03-25 01:14:37.463893	827	53	2	1
2014-03-25 01:15:32.828874	828	370	3	2
2014-03-25 01:15:55.232464	829	19.9	1	1
2014-03-25 01:15:55.457375	830	53	2	1
2014-03-25 01:16:20.830672	831	418	3	2
2014-03-25 01:16:32.83012	832	418	3	2
2014-03-25 01:16:34.235139	833	19.9	1	1
2014-03-25 01:16:34.45804	834	53	2	1
2014-03-25 01:17:13.232381	835	19.9	1	1
2014-03-25 01:17:13.458181	836	53	2	1
2014-03-25 01:17:32.830712	837	418	3	2
2014-03-25 01:17:52.235129	838	19.9	1	1
2014-03-25 01:17:52.460029	839	53	2	1
2014-03-25 01:18:31.234659	840	19.9	1	1
2014-03-25 01:18:31.476268	841	53	2	1
2014-03-25 01:18:32.838262	842	418	3	2
2014-03-25 01:19:10.234037	843	19.9	1	1
2014-03-25 01:19:10.457411	844	53	2	1
2014-03-25 01:19:32.829535	845	418	3	2
2014-03-25 01:19:49.23427	846	19.9	1	1
2014-03-25 01:19:49.462565	847	53	2	1
2014-03-25 01:20:32.829734	848	354	3	2
2014-03-25 01:20:44.827313	849	354	3	2
2014-03-25 01:21:07.274504	850	19.9	1	1
2014-03-25 01:21:07.538992	851	53	2	1
2014-03-25 01:21:32.830999	852	354	3	2
2014-03-25 01:21:46.229392	853	19.9	1	1
2014-03-25 01:21:46.573126	854	53	2	1
2014-03-25 01:22:25.226254	855	19.9	1	1
2014-03-25 01:22:25.491638	856	53	2	1
2014-03-25 01:22:32.829961	857	354	3	2
2014-03-25 01:23:04.229555	858	19.9	1	1
2014-03-25 01:23:04.452761	859	53	2	1
2014-03-25 01:23:32.832023	860	354	3	2
2014-03-25 01:23:43.23066	861	19.9	1	1
2014-03-25 01:23:43.463042	862	53	2	1
2014-03-25 01:24:32.828862	863	354	3	2
2014-03-25 01:25:01.227504	864	19.9	1	1
2014-03-25 01:25:01.451485	865	53	2	1
2014-03-25 01:25:32.830685	866	354	3	2
2014-03-25 01:25:40.272202	867	19.8	1	1
2014-03-25 01:25:40.495042	868	53	2	1
2014-03-25 01:26:08.692794	869	289	3	2
2014-03-25 01:26:09.011278	870	289	3	2
2014-03-25 01:26:19.230687	871	19.8	1	1
2014-03-25 01:26:19.461091	872	53	2	1
2014-03-25 01:26:32.826528	873	289	3	2
2014-03-25 01:26:58.226739	874	19.8	1	1
2014-03-25 01:26:58.45179	875	53	2	1
2014-03-25 01:27:32.829533	876	354	3	2
2014-03-25 01:27:37.228643	877	19.8	1	1
2014-03-25 01:27:37.453709	878	53	2	1
2014-03-25 01:27:44.827964	879	354	3	2
2014-03-25 01:28:16.223084	880	19.8	1	1
2014-03-25 01:28:16.445284	881	53	2	1
2014-03-25 01:28:32.826148	882	305	3	2
2014-03-25 01:28:44.830536	883	354	3	2
2014-03-25 01:28:55.227338	884	19.8	1	1
2014-03-25 01:28:55.448716	885	53	2	1
2014-03-25 01:28:56.829825	886	354	3	2
2014-03-25 01:29:08.831575	887	305	3	2
2014-03-25 01:29:20.827185	888	354	3	2
2014-03-25 01:29:32.827401	889	354	3	2
2014-03-25 01:29:34.230769	890	19.8	1	1
2014-03-25 01:29:34.452601	891	53	2	1
2014-03-25 01:30:13.226521	892	19.8	1	1
2014-03-25 01:30:13.448279	893	53	2	1
2014-03-25 01:30:32.829064	894	338	3	2
2014-03-25 01:30:52.227198	895	19.8	1	1
2014-03-25 01:30:52.448971	896	53	2	1
2014-03-25 01:31:31.222958	897	19.8	1	1
2014-03-25 01:31:31.456933	898	53	2	1
2014-03-25 01:31:40.238286	899	354	3	2
2014-03-25 01:32:10.224974	900	19.8	1	1
2014-03-25 01:32:10.451301	901	53	2	1
2014-03-25 01:32:20.82737	902	289	3	2
2014-03-25 01:32:32.826286	903	273	3	2
2014-03-25 01:32:44.827785	904	305	3	2
2014-03-25 01:32:49.223122	905	19.8	1	1
2014-03-25 01:32:49.451311	906	53	2	1
2014-03-25 01:32:56.826567	907	305	3	2
2014-03-25 01:33:28.221547	908	19.8	1	1
2014-03-25 01:33:28.457804	909	53	2	1
2014-03-25 01:33:32.827949	910	305	3	2
2014-03-25 01:33:56.82682	911	273	3	2
2014-03-25 01:34:07.225956	912	19.8	1	1
2014-03-25 01:34:07.459655	913	53	2	1
2014-03-25 01:34:08.826611	914	305	3	2
2014-03-25 01:34:20.82942	915	289	3	2
2014-03-25 01:34:32.833077	916	289	3	2
2014-03-25 01:34:46.220844	917	19.8	1	1
2014-03-25 01:34:46.444125	918	53	2	1
2014-03-25 01:35:25.266066	919	19.8	1	1
2014-03-25 01:35:25.487578	920	53	2	1
2014-03-25 01:35:32.825573	921	289	3	2
2014-03-25 01:36:04.221594	922	19.8	1	1
2014-03-25 01:36:04.444914	923	53	2	1
2014-03-25 01:36:32.827996	924	289	3	2
2014-03-25 01:36:43.225034	925	19.8	1	1
2014-03-25 01:36:43.448613	926	53	2	1
2014-03-25 01:37:22.222306	927	19.8	1	1
2014-03-25 01:37:22.447756	928	53	2	1
2014-03-25 01:37:32.826823	929	289	3	2
2014-03-25 01:38:01.221755	930	19.8	1	1
2014-03-25 01:38:01.449288	931	53	2	1
2014-03-25 01:38:32.828873	932	289	3	2
2014-03-25 01:38:40.233343	933	19.8	1	1
2014-03-25 01:38:40.455759	934	53	2	1
2014-03-25 01:39:19.222644	935	19.8	1	1
2014-03-25 01:39:19.445959	936	53	2	1
2014-03-25 01:39:32.829321	937	289	3	2
2014-03-25 01:39:44.828897	938	338	3	2
2014-03-25 01:39:56.827271	939	354	3	2
2014-03-25 01:39:58.221678	940	19.8	1	1
2014-03-25 01:39:58.44354	941	53	2	1
2014-03-25 01:40:32.827303	942	354	3	2
2014-03-25 01:40:37.263798	943	19.8	1	1
2014-03-25 01:40:37.486168	944	53	2	1
2014-03-25 01:41:16.217688	945	19.8	1	1
2014-03-25 01:41:16.450702	946	53	2	1
2014-03-25 01:41:32.825548	947	354	3	2
2014-03-25 01:41:55.221066	948	19.8	1	1
2014-03-25 01:41:55.444317	949	53	2	1
2014-03-25 01:42:32.82808	950	354	3	2
2014-03-25 01:42:34.220638	951	19.8	1	1
2014-03-25 01:42:34.443382	952	53	2	1
2014-03-25 01:43:13.216976	953	19.8	1	1
2014-03-25 01:43:13.444441	954	53	2	1
2014-03-25 01:43:32.827955	955	354	3	2
2014-03-25 01:43:44.876361	956	305	3	2
2014-03-25 01:43:52.220576	957	19.8	1	1
2014-03-25 01:43:52.463941	958	53	2	1
2014-03-25 01:43:56.828702	959	305	3	2
2014-03-25 01:44:31.261462	960	19.8	1	1
2014-03-25 01:44:31.48317	961	53	2	1
2014-03-25 01:44:32.828621	962	305	3	2
2014-03-25 01:45:10.21736	963	19.8	1	1
2014-03-25 01:45:10.450225	964	53	2	1
2014-03-25 01:45:32.834389	965	289	3	2
2014-03-25 01:45:49.217854	966	19.8	1	1
2014-03-25 01:45:49.442593	967	53	2	1
2014-03-25 01:46:32.82757	968	289	3	2
2014-03-25 01:47:07.219078	969	19.8	1	1
2014-03-25 01:47:07.441413	970	53	2	1
2014-03-25 01:47:32.828806	971	305	3	2
2014-03-25 01:47:46.219055	972	19.8	1	1
2014-03-25 01:47:46.447452	973	53	2	1
2014-03-25 01:48:32.830457	974	305	3	2
2014-03-25 01:49:04.215066	975	19.8	1	1
2014-03-25 01:49:04.44376	976	53	2	1
2014-03-25 01:49:32.825765	977	305	3	2
2014-03-25 01:49:43.21243	978	19.8	1	1
2014-03-25 01:49:43.443807	979	53	2	1
2014-03-25 01:50:22.21396	980	19.7	1	1
2014-03-25 01:50:22.43719	981	53	2	1
2014-03-25 01:50:32.827185	982	289	3	2
2014-03-25 01:50:44.827839	983	354	3	2
2014-03-25 01:50:56.824547	984	354	3	2
2014-03-25 01:51:01.21388	985	19.7	1	1
2014-03-25 01:51:01.445309	986	53	2	1
2014-03-25 01:51:32.822362	987	354	3	2
2014-03-25 01:51:40.21197	988	19.7	1	1
2014-03-25 01:51:40.443581	989	53	2	1
2014-03-25 01:52:19.210854	990	19.7	1	1
2014-03-25 01:52:19.433329	991	53	2	1
2014-03-25 01:52:32.82318	992	354	3	2
2014-03-25 01:52:58.211521	993	19.7	1	1
2014-03-25 01:52:58.435063	994	53	2	1
2014-03-25 01:53:32.823749	995	354	3	2
2014-03-25 01:53:37.212039	996	19.7	1	1
2014-03-25 01:53:37.438127	997	53	2	1
2014-03-25 01:54:16.212356	998	19.7	1	1
2014-03-25 01:54:16.444406	999	53	2	1
2014-03-25 01:54:32.821387	1000	354	3	2
2014-03-25 01:54:55.212141	1001	19.7	1	1
2014-03-25 01:54:55.44309	1002	53	2	1
2014-03-25 01:55:32.828745	1003	289	3	2
2014-03-25 01:55:34.20958	1004	19.7	1	1
2014-03-25 01:55:34.43979	1005	53	2	1
2014-03-25 01:55:44.829427	1006	305	3	2
2014-03-25 01:56:13.207465	1007	19.7	1	1
2014-03-25 01:56:13.439147	1008	53	2	1
2014-03-25 01:56:32.82577	1009	305	3	2
2014-03-25 01:56:52.20705	1010	19.7	1	1
2014-03-25 01:56:53.323609	1011	53	2	1
2014-03-25 01:57:31.20844	1012	19.7	1	1
2014-03-25 01:57:31.48408	1013	53	2	1
2014-03-25 01:57:32.826777	1014	305	3	2
2014-03-25 01:58:10.209811	1015	19.7	1	1
2014-03-25 01:58:10.432554	1016	53	2	1
2014-03-25 01:58:32.825042	1017	289	3	2
2014-03-25 01:58:49.21039	1018	19.7	1	1
2014-03-25 01:58:49.444277	1019	53	2	1
2014-03-25 01:59:28.208746	1020	19.7	1	1
2014-03-25 01:59:28.431055	1021	53	2	1
2014-03-25 01:59:32.822686	1022	289	3	2
2014-03-25 02:00:07.207053	1023	19.7	1	1
2014-03-25 02:00:07.428559	1024	53	2	1
2014-03-25 02:00:32.823195	1025	305	3	2
2014-03-25 02:00:46.207955	1026	19.7	1	1
2014-03-25 02:00:46.42921	1027	53	2	1
2014-03-25 02:01:25.207418	1028	19.7	1	1
2014-03-25 02:01:25.435952	1029	53	2	1
2014-03-25 02:01:32.827747	1030	305	3	2
2014-03-25 02:02:04.207135	1031	19.7	1	1
2014-03-25 02:02:04.428174	1032	53	2	1
2014-03-25 02:02:32.822466	1033	354	3	2
2014-03-25 02:02:43.212545	1034	19.7	1	1
2014-03-25 02:02:43.436075	1035	53	2	1
2014-03-25 02:02:44.822349	1036	354	3	2
2014-03-25 02:03:22.207079	1037	19.7	1	1
2014-03-25 02:03:22.429374	1038	53	2	1
2014-03-25 02:03:32.82511	1039	354	3	2
2014-03-25 02:04:01.202745	1040	19.7	1	1
2014-03-25 02:04:01.436906	1041	53	2	1
2014-03-25 02:04:32.821815	1042	354	3	2
2014-03-25 02:04:40.205321	1043	19.7	1	1
2014-03-25 02:04:40.427889	1044	53	2	1
2014-03-25 02:05:08.823247	1045	418	3	2
2014-03-25 02:05:19.205036	1046	19.7	1	1
2014-03-25 02:05:19.426781	1047	53	2	1
2014-03-25 02:05:20.826409	1048	434	3	2
2014-03-25 02:05:32.822942	1049	434	3	2
2014-03-25 02:05:58.202486	1050	19.7	1	1
2014-03-25 02:05:58.424458	1051	53	2	1
2014-03-25 02:06:32.824908	1052	434	3	2
2014-03-25 02:06:37.2034	1053	19.7	1	1
2014-03-25 02:06:37.423764	1054	53	2	1
2014-03-25 02:06:56.826485	1055	370	3	2
2014-03-25 02:07:08.823599	1056	370	3	2
2014-03-25 02:07:16.203376	1057	19.7	1	1
2014-03-25 02:07:16.434657	1058	53	2	1
2014-03-25 02:07:32.821425	1059	370	3	2
2014-03-25 02:07:55.20244	1060	19.7	1	1
2014-03-25 02:07:55.426329	1061	53	2	1
2014-03-25 02:08:32.827282	1062	370	3	2
2014-03-25 02:08:34.204479	1063	19.7	1	1
2014-03-25 02:08:34.425647	1064	53	2	1
2014-03-25 02:09:13.202807	1065	19.7	1	1
2014-03-25 02:09:13.426192	1066	53	2	1
2014-03-25 02:09:32.826306	1067	370	3	2
2014-03-25 02:09:52.202589	1068	19.7	1	1
2014-03-25 02:09:52.424966	1069	53	2	1
2014-03-25 02:10:31.202266	1070	19.7	1	1
2014-03-25 02:10:31.423248	1071	53	2	1
2014-03-25 02:10:32.825427	1072	370	3	2
2014-03-25 02:11:10.200815	1073	19.7	1	1
2014-03-25 02:11:10.423347	1074	53	2	1
2014-03-25 02:11:32.825948	1075	370	3	2
2014-03-25 02:11:49.198152	1076	19.7	1	1
2014-03-25 02:11:49.420902	1077	53	2	1
2014-03-25 02:12:28.199395	1078	19.7	1	1
2014-03-25 02:12:28.431994	1079	53	2	1
2014-03-25 02:12:32.823379	1080	354	3	2
2014-03-25 02:13:07.200236	1081	19.7	1	1
2014-03-25 02:13:07.423601	1082	53	2	1
2014-03-25 02:13:32.821622	1083	354	3	2
2014-03-25 02:13:46.199733	1084	19.7	1	1
2014-03-25 02:13:46.421589	1085	53	2	1
2014-03-25 02:14:08.822299	1086	418	3	2
2014-03-25 02:14:20.822499	1087	434	3	2
2014-03-25 02:14:25.198535	1088	19.7	1	1
2014-03-25 02:14:25.430096	1089	53	2	1
2014-03-25 02:14:32.823874	1090	418	3	2
2014-03-25 02:15:04.199427	1091	19.7	1	1
2014-03-25 02:15:04.423845	1092	53	2	1
2014-03-25 02:15:32.825039	1093	418	3	2
2014-03-25 02:15:43.202706	1094	19.7	1	1
2014-03-25 02:15:43.424702	1095	53	2	1
2014-03-25 02:16:22.196727	1096	19.7	1	1
2014-03-25 02:16:22.418112	1097	53	2	1
2014-03-25 02:17:01.003116	1098	418	3	2
2014-03-25 02:17:01.3267	1099	19.7	1	1
2014-03-25 02:17:01.637229	1100	53	2	1
2014-03-25 02:17:32.820482	1101	418	3	2
2014-03-25 02:17:40.199555	1102	19.7	1	1
2014-03-25 02:17:40.422848	1103	53	2	1
2014-03-25 02:18:19.205273	1104	19.6	1	1
2014-03-25 02:18:19.427893	1105	53	2	1
2014-03-25 02:18:32.821444	1106	370	3	2
2014-03-25 02:18:44.823449	1107	354	3	2
2014-03-25 02:18:58.196998	1108	19.6	1	1
2014-03-25 02:18:58.419672	1109	53	2	1
2014-03-25 02:19:32.823299	1110	354	3	2
2014-03-25 02:19:37.200004	1111	19.6	1	1
2014-03-25 02:19:37.432925	1112	53	2	1
2014-03-25 02:19:44.821267	1113	305	3	2
2014-03-25 02:19:56.823029	1114	289	3	2
2014-03-25 02:20:16.198514	1115	19.6	1	1
2014-03-25 02:20:16.433536	1116	53	2	1
2014-03-25 02:20:32.822288	1117	305	3	2
2014-03-25 02:20:44.821882	1118	338	3	2
2014-03-25 02:20:55.193405	1119	19.6	1	1
2014-03-25 02:20:55.437721	1120	53	2	1
2014-03-25 02:20:56.820109	1121	338	3	2
2014-03-25 02:21:08.82446	1122	305	3	2
2014-03-25 02:21:20.822402	1123	305	3	2
2014-03-25 02:21:32.822525	1124	305	3	2
2014-03-25 02:21:34.193212	1125	19.6	1	1
2014-03-25 02:21:34.418623	1126	53	2	1
2014-03-25 02:22:13.193956	1127	19.6	1	1
2014-03-25 02:22:13.415181	1128	53	2	1
2014-03-25 02:22:32.823307	1129	305	3	2
2014-03-25 02:22:52.190044	1130	19.6	1	1
2014-03-25 02:22:52.413362	1131	53	2	1
2014-03-25 02:23:08.825074	1132	338	3	2
2014-03-25 02:23:20.822902	1133	305	3	2
2014-03-25 02:23:31.191531	1134	19.6	1	1
2014-03-25 02:23:31.413303	1135	53	2	1
2014-03-25 02:23:32.824265	1136	305	3	2
2014-03-25 02:24:10.193733	1137	19.6	1	1
2014-03-25 02:24:10.416298	1138	53	2	1
2014-03-25 02:24:32.822042	1139	305	3	2
2014-03-25 02:24:49.197597	1140	19.6	1	1
2014-03-25 02:24:49.422801	1141	53	2	1
2014-03-25 02:25:20.826707	1142	354	3	2
2014-03-25 02:25:28.192132	1143	19.6	1	1
2014-03-25 02:25:28.416232	1144	53	2	1
2014-03-25 02:25:32.823285	1145	354	3	2
2014-03-25 02:26:07.19118	1146	19.6	1	1
2014-03-25 02:26:07.414187	1147	53	2	1
2014-03-25 02:26:32.820487	1148	354	3	2
2014-03-25 02:26:46.23851	1149	19.6	1	1
2014-03-25 02:26:46.469319	1150	53	2	1
2014-03-25 02:27:25.189123	1151	19.6	1	1
2014-03-25 02:27:25.431511	1152	53	2	1
2014-03-25 02:27:32.823628	1153	354	3	2
2014-03-25 02:28:04.187834	1154	19.6	1	1
2014-03-25 02:28:04.411813	1155	53	2	1
2014-03-25 02:28:32.822787	1156	354	3	2
2014-03-25 02:28:43.188474	1157	19.6	1	1
2014-03-25 02:28:43.421552	1158	53	2	1
2014-03-25 02:29:22.187064	1159	19.6	1	1
2014-03-25 02:29:22.411399	1160	53	2	1
2014-03-25 02:29:32.822737	1161	354	3	2
2014-03-25 02:30:01.19	1162	19.6	1	1
2014-03-25 02:30:01.41304	1163	53	2	1
2014-03-25 02:30:08.820325	1164	305	3	2
2014-03-25 02:30:20.822458	1165	305	3	2
2014-03-25 02:30:32.822068	1166	305	3	2
2014-03-25 02:30:40.187274	1167	19.6	1	1
2014-03-25 02:30:40.420759	1168	53	2	1
2014-03-25 02:31:19.191983	1169	19.6	1	1
2014-03-25 02:31:19.414961	1170	53	2	1
2014-03-25 02:31:32.820864	1171	305	3	2
2014-03-25 02:31:58.185117	1172	19.6	1	1
2014-03-25 02:31:58.406672	1173	53	2	1
2014-03-25 02:32:32.82204	1174	305	3	2
2014-03-25 02:32:37.193827	1175	19.6	1	1
2014-03-25 02:32:37.429658	1176	53	2	1
2014-03-25 02:33:16.187206	1177	19.6	1	1
2014-03-25 02:33:16.46406	1178	53	2	1
2014-03-25 02:33:54.993438	1179	305	3	2
2014-03-25 02:33:55.31218	1180	19.6	1	1
2014-03-25 02:33:55.533272	1181	53	2	1
2014-03-25 02:34:32.819884	1182	305	3	2
2014-03-25 02:34:34.187713	1183	19.6	1	1
2014-03-25 02:34:34.408817	1184	53	2	1
2014-03-25 02:35:13.189157	1185	19.6	1	1
2014-03-25 02:35:13.443408	1186	53	2	1
2014-03-25 02:35:32.822213	1187	305	3	2
2014-03-25 02:35:52.185746	1188	19.6	1	1
2014-03-25 02:35:52.406922	1189	53	2	1
2014-03-25 02:36:31.18462	1190	19.6	1	1
2014-03-25 02:36:31.412394	1191	53	2	1
2014-03-25 02:36:32.821417	1192	305	3	2
2014-03-25 02:37:08.818513	1193	338	3	2
2014-03-25 02:37:10.18614	1194	19.6	1	1
2014-03-25 02:37:10.405838	1195	53	2	1
2014-03-25 02:37:20.823363	1196	370	3	2
2014-03-25 02:37:32.822112	1197	354	3	2
2014-03-25 02:37:49.184204	1198	19.6	1	1
2014-03-25 02:37:49.417283	1199	53	2	1
2014-03-25 02:38:28.183523	1200	19.6	1	1
2014-03-25 02:38:28.405165	1201	53	2	1
2014-03-25 02:38:32.820297	1202	354	3	2
2014-03-25 02:39:07.184248	1203	19.6	1	1
2014-03-25 02:39:07.407679	1204	53	2	1
2014-03-25 02:39:32.821579	1205	354	3	2
2014-03-25 02:39:46.185776	1206	19.6	1	1
2014-03-25 02:39:46.418006	1207	53	2	1
2014-03-25 02:40:25.185309	1208	19.6	1	1
2014-03-25 02:40:25.407535	1209	53	2	1
2014-03-25 02:40:32.818238	1210	354	3	2
2014-03-25 02:41:04.186065	1211	19.6	1	1
2014-03-25 02:41:04.40712	1212	53	2	1
2014-03-25 02:41:32.821532	1213	354	3	2
2014-03-25 02:41:43.186002	1214	19.6	1	1
2014-03-25 02:41:43.411538	1215	53	2	1
2014-03-25 02:41:44.822023	1216	305	3	2
2014-03-25 02:41:56.821142	1217	305	3	2
2014-03-25 02:42:22.181161	1218	19.6	1	1
2014-03-25 02:42:22.406828	1219	53	2	1
2014-03-25 02:42:32.819026	1220	289	3	2
2014-03-25 02:43:01.18348	1221	19.6	1	1
2014-03-25 02:43:01.407833	1222	53	2	1
2014-03-25 02:43:32.824411	1223	289	3	2
2014-03-25 02:43:40.182657	1224	19.6	1	1
2014-03-25 02:43:40.438571	1225	53	2	1
2014-03-25 02:44:19.183299	1226	19.6	1	1
2014-03-25 02:44:19.416051	1227	53	2	1
2014-03-25 02:44:32.82338	1228	289	3	2
2014-03-25 02:44:58.182363	1229	19.6	1	1
2014-03-25 02:44:58.404357	1230	53	2	1
2014-03-25 02:45:32.820529	1231	289	3	2
2014-03-25 02:45:37.17858	1232	19.6	1	1
2014-03-25 02:45:37.400515	1233	53	2	1
2014-03-25 02:46:16.181896	1234	19.6	1	1
2014-03-25 02:46:16.41506	1235	53	2	1
2014-03-25 02:46:32.820551	1236	289	3	2
2014-03-25 02:46:55.178866	1237	19.6	1	1
2014-03-25 02:46:55.403005	1238	53	2	1
2014-03-25 02:47:32.823589	1239	289	3	2
2014-03-25 02:47:34.180667	1240	19.6	1	1
2014-03-25 02:47:34.405929	1241	53	2	1
2014-03-25 02:48:13.178772	1242	19.5	1	1
2014-03-25 02:48:13.403501	1243	53	2	1
2014-03-25 02:48:32.822953	1244	289	3	2
2014-03-25 02:48:44.821248	1245	354	3	2
2014-03-25 02:48:52.175998	1246	19.5	1	1
2014-03-25 02:48:52.398553	1247	53	2	1
2014-03-25 02:48:56.821416	1248	354	3	2
2014-03-25 02:49:31.177319	1249	19.5	1	1
2014-03-25 02:49:31.399178	1250	53	2	1
2014-03-25 02:49:32.822077	1251	354	3	2
2014-03-25 02:50:10.178248	1252	19.5	1	1
2014-03-25 02:50:10.412515	1253	53	2	1
2014-03-25 02:50:32.820134	1254	354	3	2
2014-03-25 02:50:49.180089	1255	19.5	1	1
2014-03-25 02:50:49.403565	1256	53	2	1
2014-03-25 02:51:28.177521	1257	19.5	1	1
2014-03-25 02:51:28.400472	1258	53	2	1
2014-03-25 02:51:32.820157	1259	354	3	2
2014-03-25 02:52:07.178734	1260	19.5	1	1
2014-03-25 02:52:07.415686	1261	53	2	1
2014-03-25 02:52:32.821934	1262	354	3	2
2014-03-25 02:52:46.173286	1263	19.5	1	1
2014-03-25 02:52:46.398716	1264	53	2	1
2014-03-25 02:53:25.176229	1265	19.5	1	1
2014-03-25 02:53:25.396715	1266	53	2	1
2014-03-25 02:53:32.822031	1267	354	3	2
2014-03-25 02:53:56.819796	1268	289	3	2
2014-03-25 02:54:04.17178	1269	19.5	1	1
2014-03-25 02:54:04.403719	1270	53	2	1
2014-03-25 02:54:08.819128	1271	289	3	2
2014-03-25 02:54:32.821631	1272	305	3	2
2014-03-25 02:54:43.171144	1273	19.5	1	1
2014-03-25 02:54:43.402127	1274	53	2	1
2014-03-25 02:55:22.174667	1275	19.5	1	1
2014-03-25 02:55:22.402504	1276	53	2	1
2014-03-25 02:55:32.817268	1277	305	3	2
2014-03-25 02:56:01.172473	1278	19.5	1	1
2014-03-25 02:56:01.393314	1279	53	2	1
2014-03-25 02:56:32.822245	1280	289	3	2
2014-03-25 02:56:40.175544	1281	19.5	1	1
2014-03-25 02:56:40.398312	1282	53	2	1
2014-03-25 02:57:19.176256	1283	19.5	1	1
2014-03-25 02:57:19.407439	1284	53	2	1
2014-03-25 02:57:32.819499	1285	289	3	2
2014-03-25 02:57:58.174405	1286	19.5	1	1
2014-03-25 02:57:58.400857	1287	53	2	1
2014-03-25 02:58:32.826103	1288	289	3	2
2014-03-25 02:58:37.172071	1289	19.5	1	1
2014-03-25 02:58:37.394457	1290	53	2	1
2014-03-25 02:59:16.174271	1291	19.5	1	1
2014-03-25 02:59:16.396846	1292	53	2	1
2014-03-25 02:59:20.815983	1293	370	3	2
2014-03-25 02:59:32.821509	1294	370	3	2
2014-03-25 02:59:55.171116	1295	19.5	1	1
2014-03-25 02:59:55.393786	1296	53	2	1
2014-03-25 03:00:32.822624	1297	370	3	2
2014-03-25 03:00:34.170353	1298	19.5	1	1
2014-03-25 03:00:34.391846	1299	53	2	1
2014-03-25 03:00:56.821465	1300	434	3	2
2014-03-25 03:01:08.820896	1301	434	3	2
2014-03-25 03:01:13.171965	1302	19.5	1	1
2014-03-25 03:01:13.394297	1303	53	2	1
2014-03-25 03:01:32.818838	1304	434	3	2
2014-03-25 03:01:52.172241	1305	19.5	1	1
2014-03-25 03:01:52.399822	1306	53	2	1
2014-03-25 03:02:31.174296	1307	19.5	1	1
2014-03-25 03:02:31.417147	1308	53	2	1
2014-03-25 03:02:32.821603	1309	434	3	2
2014-03-25 03:03:10.172379	1310	19.5	1	1
2014-03-25 03:03:10.413921	1311	53	2	1
2014-03-25 03:03:32.819904	1312	434	3	2
2014-03-25 03:03:49.169034	1313	19.5	1	1
2014-03-25 03:03:49.393661	1314	53	2	1
2014-03-25 03:04:28.170917	1315	19.5	1	1
2014-03-25 03:04:28.39372	1316	53	2	1
2014-03-25 03:04:32.822493	1317	434	3	2
2014-03-25 03:05:07.171021	1318	19.5	1	1
2014-03-25 03:05:07.395216	1319	53	2	1
2014-03-25 03:05:32.821936	1320	434	3	2
2014-03-25 03:05:44.821115	1321	370	3	2
2014-03-25 03:05:46.169167	1322	19.5	1	1
2014-03-25 03:05:46.395036	1323	53	2	1
2014-03-25 03:05:56.822033	1324	370	3	2
2014-03-25 03:06:25.171458	1325	19.5	1	1
2014-03-25 03:06:25.395804	1326	53	2	1
2014-03-25 03:06:32.820179	1327	370	3	2
2014-03-25 03:07:04.168121	1328	19.5	1	1
2014-03-25 03:07:04.390802	1329	53	2	1
2014-03-25 03:07:32.820695	1330	370	3	2
2014-03-25 03:07:43.172022	1331	19.5	1	1
2014-03-25 03:07:43.396186	1332	53	2	1
2014-03-25 03:08:22.164808	1333	19.5	1	1
2014-03-25 03:08:22.398529	1334	53	2	1
2014-03-25 03:08:32.820957	1335	370	3	2
2014-03-25 03:09:01.169847	1336	19.5	1	1
2014-03-25 03:09:01.394325	1337	53	2	1
2014-03-25 03:09:32.820524	1338	370	3	2
2014-03-25 03:09:40.165074	1339	19.5	1	1
2014-03-25 03:09:40.388098	1340	53	2	1
2014-03-25 03:10:19.16383	1341	19.5	1	1
2014-03-25 03:10:19.386633	1342	53	2	1
2014-03-25 03:10:32.820219	1343	370	3	2
2014-03-25 03:10:58.166456	1344	19.5	1	1
2014-03-25 03:10:58.390713	1345	53	2	1
2014-03-25 03:11:32.822746	1346	370	3	2
2014-03-25 03:11:37.163929	1347	19.5	1	1
2014-03-25 03:11:37.387211	1348	53	2	1
2014-03-25 03:12:16.165459	1349	19.5	1	1
2014-03-25 03:12:16.387072	1350	53	2	1
2014-03-25 03:12:32.819537	1351	370	3	2
2014-03-25 03:12:55.1652	1352	19.5	1	1
2014-03-25 03:12:55.393814	1353	53	2	1
2014-03-25 03:12:56.816935	1354	418	3	2
2014-03-25 03:13:08.818861	1355	434	3	2
2014-03-25 03:13:32.822049	1356	418	3	2
2014-03-25 03:13:34.16429	1357	19.5	1	1
2014-03-25 03:13:34.387226	1358	53	2	1
2014-03-25 03:13:56.822672	1359	354	3	2
2014-03-25 03:14:08.81865	1360	354	3	2
2014-03-25 03:14:13.162455	1361	19.5	1	1
2014-03-25 03:14:13.387799	1362	52	2	1
2014-03-25 03:14:32.820247	1363	354	3	2
2014-03-25 03:14:52.162774	1364	19.5	1	1
2014-03-25 03:14:52.385474	1365	52	2	1
2014-03-25 03:15:31.163682	1366	19.5	1	1
2014-03-25 03:15:31.385236	1367	52	2	1
2014-03-25 03:15:32.815243	1368	354	3	2
2014-03-25 03:16:10.161971	1369	19.5	1	1
2014-03-25 03:16:10.383623	1370	52	2	1
2014-03-25 03:16:32.817923	1371	354	3	2
2014-03-25 03:16:49.164689	1372	19.5	1	1
2014-03-25 03:16:49.387195	1373	52	2	1
2014-03-25 03:17:28.160083	1374	19.5	1	1
2014-03-25 03:17:28.392288	1375	52	2	1
2014-03-25 03:17:32.819247	1376	354	3	2
2014-03-25 03:17:44.819272	1377	305	3	2
2014-03-25 03:17:56.819316	1378	305	3	2
2014-03-25 03:18:07.171736	1379	19.5	1	1
2014-03-25 03:18:07.394814	1380	52	2	1
2014-03-25 03:18:32.817759	1381	305	3	2
2014-03-25 03:18:46.165515	1382	19.5	1	1
2014-03-25 03:18:46.400026	1383	52	2	1
2014-03-25 03:19:25.159215	1384	19.5	1	1
2014-03-25 03:19:25.387456	1385	52	2	1
2014-03-25 03:19:32.818015	1386	305	3	2
2014-03-25 03:20:04.163553	1387	19.5	1	1
2014-03-25 03:20:04.385487	1388	52	2	1
2014-03-25 03:20:32.816277	1389	289	3	2
2014-03-25 03:20:43.159211	1390	19.5	1	1
2014-03-25 03:20:43.382256	1391	52	2	1
2014-03-25 03:21:22.157836	1392	19.5	1	1
2014-03-25 03:21:22.38153	1393	52	2	1
2014-03-25 03:21:32.815264	1394	273	3	2
2014-03-25 03:22:01.158616	1395	19.4	1	1
2014-03-25 03:22:01.381443	1396	52	2	1
2014-03-25 03:22:32.815323	1397	289	3	2
2014-03-25 03:22:40.160543	1398	19.4	1	1
2014-03-25 03:22:40.38448	1399	52	2	1
2014-03-25 03:22:44.813809	1400	338	3	2
2014-03-25 03:22:56.814941	1401	305	3	2
2014-03-25 03:23:08.813003	1402	305	3	2
2014-03-25 03:23:19.157551	1403	19.4	1	1
2014-03-25 03:23:19.390005	1404	52	2	1
2014-03-25 03:23:20.816441	1405	338	3	2
2014-03-25 03:23:32.816731	1406	305	3	2
2014-03-25 03:23:44.818547	1407	305	3	2
2014-03-25 03:23:56.815687	1408	338	3	2
2014-03-25 03:23:58.162629	1409	19.4	1	1
2014-03-25 03:23:58.384612	1410	52	2	1
2014-03-25 03:24:08.820121	1411	338	3	2
2014-03-25 03:24:20.814959	1412	289	3	2
2014-03-25 03:24:32.817274	1413	289	3	2
2014-03-25 03:24:37.159321	1414	19.4	1	1
2014-03-25 03:24:37.383297	1415	52	2	1
2014-03-25 03:24:56.820289	1416	338	3	2
2014-03-25 03:25:08.817087	1417	354	3	2
2014-03-25 03:25:16.159939	1418	19.4	1	1
2014-03-25 03:25:16.384599	1419	52	2	1
2014-03-25 03:25:32.814588	1420	354	3	2
2014-03-25 03:25:55.159175	1421	19.4	1	1
2014-03-25 03:25:55.381762	1422	52	2	1
2014-03-25 03:26:32.817742	1423	354	3	2
2014-03-25 03:26:34.155985	1424	19.4	1	1
2014-03-25 03:26:34.387321	1425	52	2	1
2014-03-25 03:27:13.155969	1426	19.4	1	1
2014-03-25 03:27:13.379745	1427	52	2	1
2014-03-25 03:27:32.82	1428	338	3	2
2014-03-25 03:27:52.155446	1429	19.4	1	1
2014-03-25 03:27:52.381341	1430	52	2	1
2014-03-25 03:28:31.15385	1431	19.4	1	1
2014-03-25 03:28:31.395528	1432	52	2	1
2014-03-25 03:28:32.819774	1433	354	3	2
2014-03-25 03:29:10.158551	1434	19.4	1	1
2014-03-25 03:29:10.380385	1435	52	2	1
2014-03-25 03:29:32.816213	1436	305	3	2
2014-03-25 03:29:44.813739	1437	305	3	2
2014-03-25 03:29:49.15801	1438	19.4	1	1
2014-03-25 03:29:49.392513	1439	52	2	1
2014-03-25 03:30:28.155418	1440	19.4	1	1
2014-03-25 03:30:28.379506	1441	52	2	1
2014-03-25 03:30:32.818764	1442	305	3	2
2014-03-25 03:31:07.156871	1443	19.4	1	1
2014-03-25 03:31:07.378032	1444	52	2	1
2014-03-25 03:31:32.81668	1445	305	3	2
2014-03-25 03:31:46.154867	1446	19.4	1	1
2014-03-25 03:31:46.389289	1447	52	2	1
2014-03-25 03:32:25.152203	1448	19.4	1	1
2014-03-25 03:32:25.378616	1449	52	2	1
2014-03-25 03:32:32.81863	1450	305	3	2
2014-03-25 03:33:04.152749	1451	19.4	1	1
2014-03-25 03:33:04.376924	1452	52	2	1
2014-03-25 03:33:32.814943	1453	305	3	2
2014-03-25 03:33:43.150483	1454	19.4	1	1
2014-03-25 03:33:43.37355	1455	52	2	1
2014-03-25 03:34:22.15302	1456	19.4	1	1
2014-03-25 03:34:22.376299	1457	52	2	1
2014-03-25 03:34:32.8197	1458	305	3	2
2014-03-25 03:35:01.150845	1459	19.4	1	1
2014-03-25 03:35:01.376454	1460	52	2	1
2014-03-25 03:35:32.815042	1461	305	3	2
2014-03-25 03:35:40.148701	1462	19.4	1	1
2014-03-25 03:35:40.372657	1463	52	2	1
2014-03-25 03:36:19.154918	1464	19.4	1	1
2014-03-25 03:36:19.389351	1465	52	2	1
2014-03-25 03:36:32.812906	1466	354	3	2
2014-03-25 03:36:44.817391	1467	354	3	2
2014-03-25 03:36:58.152777	1468	19.4	1	1
2014-03-25 03:36:58.386504	1469	52	2	1
2014-03-25 03:37:32.819204	1470	370	3	2
2014-03-25 03:37:37.158143	1471	19.4	1	1
2014-03-25 03:37:37.384366	1472	52	2	1
2014-03-25 03:38:16.152794	1473	19.4	1	1
2014-03-25 03:38:16.397166	1474	52	2	1
2014-03-25 03:38:32.816165	1475	354	3	2
2014-03-25 03:38:55.152423	1476	19.4	1	1
2014-03-25 03:38:55.375693	1477	52	2	1
2014-03-25 03:39:32.817427	1478	354	3	2
2014-03-25 03:39:34.149403	1479	19.4	1	1
2014-03-25 03:39:34.382618	1480	52	2	1
2014-03-25 03:40:13.152047	1481	19.4	1	1
2014-03-25 03:40:13.37808	1482	52	2	1
2014-03-25 03:40:32.815806	1483	354	3	2
2014-03-25 03:40:52.149652	1484	19.4	1	1
2014-03-25 03:40:52.37542	1485	52	2	1
2014-03-25 03:41:20.814138	1486	305	3	2
2014-03-25 03:41:31.148694	1487	19.4	1	1
2014-03-25 03:41:31.383002	1488	52	2	1
2014-03-25 03:41:32.814143	1489	305	3	2
2014-03-25 03:42:10.148683	1490	19.4	1	1
2014-03-25 03:42:10.372748	1491	52	2	1
2014-03-25 03:42:32.819023	1492	305	3	2
2014-03-25 03:42:49.151943	1493	19.4	1	1
2014-03-25 03:42:49.377481	1494	52	2	1
2014-03-25 03:43:28.148712	1495	19.4	1	1
2014-03-25 03:43:28.382628	1496	52	2	1
2014-03-25 03:43:32.815369	1497	305	3	2
2014-03-25 03:43:56.816186	1498	338	3	2
2014-03-25 03:44:07.14875	1499	19.4	1	1
2014-03-25 03:44:07.38345	1500	52	2	1
2014-03-25 03:44:08.815497	1501	305	3	2
2014-03-25 03:44:20.81463	1502	305	3	2
2014-03-25 03:44:32.813036	1503	338	3	2
2014-03-25 03:44:44.815869	1504	305	3	2
2014-03-25 03:44:46.145401	1505	19.4	1	1
2014-03-25 03:44:46.36857	1506	52	2	1
2014-03-25 03:44:56.811643	1507	305	3	2
2014-03-25 03:45:25.149814	1508	19.4	1	1
2014-03-25 03:45:25.376735	1509	52	2	1
2014-03-25 03:45:32.814347	1510	305	3	2
2014-03-25 03:46:04.145401	1511	19.4	1	1
2014-03-25 03:46:04.37152	1512	52	2	1
2014-03-25 03:46:32.818021	1513	305	3	2
2014-03-25 03:46:43.145495	1514	19.4	1	1
2014-03-25 03:46:43.381604	1515	52	2	1
2014-03-25 03:47:22.145292	1516	19.4	1	1
2014-03-25 03:47:22.367545	1517	52	2	1
2014-03-25 03:47:32.815082	1518	305	3	2
2014-03-25 03:48:01.144157	1519	19.4	1	1
2014-03-25 03:48:01.368045	1520	52	2	1
2014-03-25 03:48:39.950031	1521	370	3	2
2014-03-25 03:48:40.273631	1522	19.4	1	1
2014-03-25 03:48:40.496966	1523	52	2	1
2014-03-25 03:48:44.815881	1524	370	3	2
2014-03-25 03:49:19.144696	1525	19.4	1	1
2014-03-25 03:49:19.37825	1526	52	2	1
2014-03-25 03:49:32.816387	1527	370	3	2
2014-03-25 03:49:58.141576	1528	19.4	1	1
2014-03-25 03:49:58.365771	1529	52	2	1
2014-03-25 03:50:36.950437	1530	370	3	2
2014-03-25 03:50:37.259592	1531	19.4	1	1
2014-03-25 03:50:37.481582	1532	52	2	1
2014-03-25 03:51:16.15415	1533	19.4	1	1
2014-03-25 03:51:16.388115	1534	52	2	1
2014-03-25 03:51:32.814794	1535	370	3	2
2014-03-25 03:51:55.142214	1536	19.4	1	1
2014-03-25 03:51:55.367309	1537	52	2	1
2014-03-25 03:52:32.817231	1538	370	3	2
2014-03-25 03:52:34.144691	1539	19.4	1	1
2014-03-25 03:52:34.367572	1540	52	2	1
2014-03-25 03:53:13.138586	1541	19.4	1	1
2014-03-25 03:53:13.363221	1542	52	2	1
2014-03-25 03:53:32.815574	1543	289	3	2
2014-03-25 03:53:44.814242	1544	289	3	2
2014-03-25 03:53:52.139774	1545	19.4	1	1
2014-03-25 03:53:52.36758	1546	52	2	1
2014-03-25 03:54:20.821351	1547	370	3	2
2014-03-25 03:54:31.143731	1548	19.4	1	1
2014-03-25 03:54:31.366998	1549	52	2	1
2014-03-25 03:54:32.817658	1550	370	3	2
2014-03-25 03:55:08.814442	1551	402	3	2
2014-03-25 03:55:10.142438	1552	19.4	1	1
2014-03-25 03:55:10.367214	1553	52	2	1
2014-03-25 03:55:20.814529	1554	402	3	2
2014-03-25 03:55:32.814549	1555	402	3	2
2014-03-25 03:55:49.146855	1556	19.4	1	1
2014-03-25 03:55:49.372626	1557	52	2	1
2014-03-25 03:56:28.138595	1558	19.4	1	1
2014-03-25 03:56:28.363849	1559	52	2	1
2014-03-25 03:56:32.813559	1560	402	3	2
2014-03-25 03:57:07.136518	1561	19.3	1	1
2014-03-25 03:57:07.361345	1562	52	2	1
2014-03-25 03:57:32.814146	1563	370	3	2
2014-03-25 03:57:44.81678	1564	402	3	2
2014-03-25 03:57:46.138847	1565	19.3	1	1
2014-03-25 03:57:46.361179	1566	52	2	1
2014-03-25 03:57:56.814619	1567	370	3	2
2014-03-25 03:58:08.814121	1568	370	3	2
2014-03-25 03:58:25.136289	1569	19.3	1	1
2014-03-25 03:58:25.367343	1570	52	2	1
2014-03-25 03:58:32.814319	1571	370	3	2
2014-03-25 03:59:04.138011	1572	19.3	1	1
2014-03-25 03:59:04.361107	1573	52	2	1
2014-03-25 03:59:32.812916	1574	370	3	2
2014-03-25 03:59:43.137771	1575	19.3	1	1
2014-03-25 03:59:43.359794	1576	52	2	1
2014-03-25 04:00:22.139619	1577	19.3	1	1
2014-03-25 04:00:22.3769	1578	52	2	1
2014-03-25 04:00:32.81666	1579	370	3	2
2014-03-25 04:00:44.813502	1580	434	3	2
2014-03-25 04:00:56.813513	1581	434	3	2
2014-03-25 04:01:01.134241	1582	19.3	1	1
2014-03-25 04:01:01.357911	1583	52	2	1
2014-03-25 04:01:32.814754	1584	434	3	2
2014-03-25 04:01:40.140488	1585	19.3	1	1
2014-03-25 04:01:40.395726	1586	52	2	1
2014-03-25 04:02:19.190727	1587	19.3	1	1
2014-03-25 04:02:19.424766	1588	52	2	1
2014-03-25 04:02:32.815016	1589	434	3	2
2014-03-25 04:02:58.137904	1590	19.3	1	1
2014-03-25 04:02:58.363274	1591	52	2	1
2014-03-25 04:03:32.816439	1592	434	3	2
2014-03-25 04:03:37.136413	1593	19.3	1	1
2014-03-25 04:03:37.358205	1594	52	2	1
2014-03-25 04:04:16.134876	1595	19.3	1	1
2014-03-25 04:04:16.356944	1596	52	2	1
2014-03-25 04:04:32.816209	1597	434	3	2
2014-03-25 04:04:55.137077	1598	19.3	1	1
2014-03-25 04:04:55.359511	1599	52	2	1
2014-03-25 04:05:32.815228	1600	434	3	2
2014-03-25 04:05:34.13364	1601	19.3	1	1
2014-03-25 04:05:34.356834	1602	52	2	1
2014-03-25 04:05:56.812772	1603	370	3	2
2014-03-25 04:06:08.81212	1604	370	3	2
2014-03-25 04:06:13.136413	1605	19.3	1	1
2014-03-25 04:06:13.359241	1606	52	2	1
2014-03-25 04:06:32.813171	1607	370	3	2
2014-03-25 04:06:52.137007	1608	19.3	1	1
2014-03-25 04:06:52.360383	1609	52	2	1
2014-03-25 04:07:31.141685	1610	19.3	1	1
2014-03-25 04:07:31.3771	1611	52	2	1
2014-03-25 04:07:32.810733	1612	370	3	2
2014-03-25 04:08:10.13304	1613	19.3	1	1
2014-03-25 04:08:10.357788	1614	52	2	1
2014-03-25 04:08:32.813447	1615	370	3	2
2014-03-25 04:08:44.813455	1616	402	3	2
2014-03-25 04:08:49.131888	1617	19.3	1	1
2014-03-25 04:08:49.417538	1618	52	2	1
2014-03-25 04:08:56.813107	1619	305	3	2
2014-03-25 04:09:08.81301	1620	305	3	2
2014-03-25 04:09:28.134501	1621	19.3	1	1
2014-03-25 04:09:28.368192	1622	52	2	1
2014-03-25 04:09:32.813418	1623	305	3	2
2014-03-25 04:10:07.130942	1624	19.3	1	1
2014-03-25 04:10:07.354984	1625	52	2	1
2014-03-25 04:10:32.816338	1626	305	3	2
2014-03-25 04:10:46.133252	1627	19.3	1	1
2014-03-25 04:10:46.356715	1628	52	2	1
2014-03-25 04:11:25.132432	1629	19.3	1	1
2014-03-25 04:11:25.355644	1630	52	2	1
2014-03-25 04:11:32.813656	1631	305	3	2
2014-03-25 04:12:04.13238	1632	19.3	1	1
2014-03-25 04:12:04.364427	1633	52	2	1
2014-03-25 04:12:32.815026	1634	305	3	2
2014-03-25 04:12:43.130317	1635	19.3	1	1
2014-03-25 04:12:43.355119	1636	52	2	1
2014-03-25 04:12:56.815469	1637	354	3	2
2014-03-25 04:13:08.813061	1638	354	3	2
2014-03-25 04:13:22.127942	1639	19.3	1	1
2014-03-25 04:13:22.361048	1640	52	2	1
2014-03-25 04:13:32.812365	1641	354	3	2
2014-03-25 04:14:01.133693	1642	19.3	1	1
2014-03-25 04:14:01.356277	1643	52	2	1
2014-03-25 04:14:32.812954	1644	354	3	2
2014-03-25 04:14:40.129626	1645	19.3	1	1
2014-03-25 04:14:40.353183	1646	52	2	1
2014-03-25 04:15:19.131962	1647	19.3	1	1
2014-03-25 04:15:19.355146	1648	52	2	1
2014-03-25 04:15:32.814875	1649	354	3	2
2014-03-25 04:15:58.125003	1650	19.3	1	1
2014-03-25 04:15:58.368814	1651	52	2	1
2014-03-25 04:16:32.814672	1652	354	3	2
2014-03-25 04:16:37.125877	1653	19.3	1	1
2014-03-25 04:16:37.348737	1654	52	2	1
2014-03-25 04:17:16.125319	1655	19.3	1	1
2014-03-25 04:17:16.347131	1656	52	2	1
2014-03-25 04:17:32.812928	1657	354	3	2
2014-03-25 04:17:55.127887	1658	19.3	1	1
2014-03-25 04:17:55.352044	1659	52	2	1
2014-03-25 04:17:56.815064	1660	305	3	2
2014-03-25 04:18:08.811724	1661	305	3	2
2014-03-25 04:18:32.812908	1662	305	3	2
2014-03-25 04:18:34.130309	1663	19.3	1	1
2014-03-25 04:18:34.353396	1664	52	2	1
2014-03-25 04:19:13.125241	1665	19.3	1	1
2014-03-25 04:19:13.356902	1666	52	2	1
2014-03-25 04:19:32.81589	1667	305	3	2
2014-03-25 04:19:52.124476	1668	19.3	1	1
2014-03-25 04:19:52.347372	1669	52	2	1
2014-03-25 04:20:31.124345	1670	19.3	1	1
2014-03-25 04:20:31.346161	1671	52	2	1
2014-03-25 04:20:32.815038	1672	305	3	2
2014-03-25 04:21:10.12069	1673	19.3	1	1
2014-03-25 04:21:10.342306	1674	52	2	1
2014-03-25 04:21:32.810364	1675	305	3	2
2014-03-25 04:21:49.124014	1676	19.3	1	1
2014-03-25 04:21:49.3463	1677	52	2	1
2014-03-25 04:22:28.125905	1678	19.3	1	1
2014-03-25 04:22:28.35511	1679	52	2	1
2014-03-25 04:22:32.815243	1680	305	3	2
2014-03-25 04:23:07.122521	1681	19.3	1	1
2014-03-25 04:23:07.347282	1682	52	2	1
2014-03-25 04:23:32.812146	1683	305	3	2
2014-03-25 04:23:46.121543	1684	19.3	1	1
2014-03-25 04:23:46.344972	1685	52	2	1
2014-03-25 04:24:25.133456	1686	19.3	1	1
2014-03-25 04:24:25.356878	1687	52	2	1
2014-03-25 04:24:32.810986	1688	305	3	2
2014-03-25 04:24:56.810732	1689	354	3	2
2014-03-25 04:25:04.12256	1690	19.3	1	1
2014-03-25 04:25:04.344594	1691	52	2	1
2014-03-25 04:25:08.812799	1692	354	3	2
2014-03-25 04:25:32.813318	1693	354	3	2
2014-03-25 04:25:43.120844	1694	19.3	1	1
2014-03-25 04:25:43.353163	1695	52	2	1
2014-03-25 04:26:22.118707	1696	19.3	1	1
2014-03-25 04:26:22.339493	1697	52	2	1
2014-03-25 04:26:32.810702	1698	354	3	2
2014-03-25 04:27:01.118184	1699	19.3	1	1
2014-03-25 04:27:01.339375	1700	52	2	1
2014-03-25 04:27:32.809491	1701	370	3	2
2014-03-25 04:27:40.117726	1702	19.3	1	1
2014-03-25 04:27:40.340197	1703	52	2	1
2014-03-25 04:28:19.121024	1704	19.3	1	1
2014-03-25 04:28:19.35021	1705	52	2	1
2014-03-25 04:28:32.812761	1706	370	3	2
2014-03-25 04:28:58.124218	1707	19.3	1	1
2014-03-25 04:28:58.349089	1708	52	2	1
2014-03-25 04:29:32.815011	1709	354	3	2
2014-03-25 04:29:37.118326	1710	19.3	1	1
2014-03-25 04:29:37.340978	1711	52	2	1
2014-03-25 04:30:08.811865	1712	305	3	2
2014-03-25 04:30:16.119883	1713	19.3	1	1
2014-03-25 04:30:16.342396	1714	52	2	1
2014-03-25 04:30:20.811171	1715	338	3	2
2014-03-25 04:30:44.674203	1716	338	3	2
2014-03-25 04:30:44.979429	1717	305	3	2
2014-03-25 04:30:55.117685	1718	19.3	1	1
2014-03-25 04:30:55.355444	1719	52	2	1
2014-03-25 04:30:56.810525	1720	305	3	2
2014-03-25 04:31:32.815339	1721	338	3	2
2014-03-25 04:31:34.121458	1722	19.3	1	1
2014-03-25 04:31:34.35408	1723	52	2	1
2014-03-25 04:31:44.812178	1724	305	3	2
2014-03-25 04:31:56.810456	1725	305	3	2
2014-03-25 04:32:13.116681	1726	19.3	1	1
2014-03-25 04:32:13.349559	1727	52	2	1
2014-03-25 04:32:32.810625	1728	305	3	2
2014-03-25 04:32:52.120215	1729	19.3	1	1
2014-03-25 04:32:52.344089	1730	52	2	1
2014-03-25 04:33:31.117453	1731	19.3	1	1
2014-03-25 04:33:31.338895	1732	52	2	1
2014-03-25 04:33:32.811157	1733	305	3	2
2014-03-25 04:34:10.118528	1734	19.3	1	1
2014-03-25 04:34:10.343726	1735	52	2	1
2014-03-25 04:34:32.813811	1736	305	3	2
2014-03-25 04:34:49.118831	1737	19.3	1	1
2014-03-25 04:34:49.353166	1738	52	2	1
2014-03-25 04:35:28.119281	1739	19.3	1	1
2014-03-25 04:35:28.342757	1740	52	2	1
2014-03-25 04:35:32.812577	1741	305	3	2
2014-03-25 04:36:07.114564	1742	19.3	1	1
2014-03-25 04:36:07.336501	1743	52	2	1
2014-03-25 04:36:32.812825	1744	305	3	2
2014-03-25 04:36:46.117864	1745	19.2	1	1
2014-03-25 04:36:46.351407	1746	52	2	1
2014-03-25 04:36:56.812524	1747	354	3	2
2014-03-25 04:37:08.814461	1748	354	3	2
2014-03-25 04:37:25.11491	1749	19.2	1	1
2014-03-25 04:37:25.35287	1750	52	2	1
2014-03-25 04:37:32.809781	1751	354	3	2
2014-03-25 04:38:04.114277	1752	19.2	1	1
2014-03-25 04:38:04.339143	1753	52	2	1
2014-03-25 04:38:32.811668	1754	354	3	2
2014-03-25 04:38:43.115261	1755	19.2	1	1
2014-03-25 04:38:43.337845	1756	52	2	1
2014-03-25 04:39:22.113787	1757	19.2	1	1
2014-03-25 04:39:22.347328	1758	52	2	1
2014-03-25 04:39:32.812622	1759	354	3	2
2014-03-25 04:40:01.115445	1760	19.2	1	1
2014-03-25 04:40:01.339453	1761	52	2	1
2014-03-25 04:40:32.812035	1762	354	3	2
2014-03-25 04:40:40.116007	1763	19.2	1	1
2014-03-25 04:40:40.340034	1764	52	2	1
2014-03-25 04:41:19.11323	1765	19.2	1	1
2014-03-25 04:41:19.346512	1766	52	2	1
2014-03-25 04:41:32.808282	1767	354	3	2
2014-03-25 04:41:58.111463	1768	19.2	1	1
2014-03-25 04:41:58.333696	1769	52	2	1
2014-03-25 04:42:32.80948	1770	354	3	2
2014-03-25 04:42:37.123745	1771	19.2	1	1
2014-03-25 04:42:37.363604	1772	52	2	1
2014-03-25 04:42:44.81186	1773	305	3	2
2014-03-25 04:42:56.811534	1774	305	3	2
2014-03-25 04:43:16.11366	1775	19.2	1	1
2014-03-25 04:43:16.346462	1776	52	2	1
2014-03-25 04:43:32.813826	1777	305	3	2
2014-03-25 04:43:55.113486	1778	19.2	1	1
2014-03-25 04:43:55.336116	1779	52	2	1
2014-03-25 04:44:32.809814	1780	305	3	2
2014-03-25 04:44:34.109952	1781	19.2	1	1
2014-03-25 04:44:34.383133	1782	52	2	1
2014-03-25 04:45:13.122084	1783	19.2	1	1
2014-03-25 04:45:13.348704	1784	52	2	1
2014-03-25 04:45:32.811054	1785	338	3	2
2014-03-25 04:45:44.811462	1786	305	3	2
2014-03-25 04:45:52.110576	1787	19.2	1	1
2014-03-25 04:45:52.331763	1788	52	2	1
2014-03-25 04:45:56.810885	1789	305	3	2
2014-03-25 04:46:31.108515	1790	19.2	1	1
2014-03-25 04:46:31.329439	1791	52	2	1
2014-03-25 04:46:32.81064	1792	305	3	2
2014-03-25 04:47:10.109221	1793	19.2	1	1
2014-03-25 04:47:10.330258	1794	52	2	1
2014-03-25 04:47:32.810799	1795	305	3	2
2014-03-25 04:47:49.10932	1796	19.2	1	1
2014-03-25 04:47:49.332455	1797	52	2	1
2014-03-25 04:48:28.109531	1798	19.2	1	1
2014-03-25 04:48:28.342799	1799	52	2	1
2014-03-25 04:48:32.811892	1800	305	3	2
2014-03-25 04:49:07.11107	1801	19.2	1	1
2014-03-25 04:49:07.333319	1802	52	2	1
2014-03-25 04:49:32.808463	1803	370	3	2
2014-03-25 04:49:44.81205	1804	434	3	2
2014-03-25 04:49:46.11054	1805	19.2	1	1
2014-03-25 04:49:46.343312	1806	52	2	1
2014-03-25 04:49:56.810956	1807	434	3	2
2014-03-25 04:50:25.109698	1808	19.2	1	1
2014-03-25 04:50:25.341782	1809	52	2	1
2014-03-25 04:50:32.811905	1810	434	3	2
2014-03-25 04:51:04.109712	1811	19.2	1	1
2014-03-25 04:51:04.331601	1812	52	2	1
2014-03-25 04:51:32.812438	1813	434	3	2
2014-03-25 04:51:43.104467	1814	19.2	1	1
2014-03-25 04:51:43.335077	1815	52	2	1
2014-03-25 04:52:22.109408	1816	19.2	1	1
2014-03-25 04:52:22.365048	1817	52	2	1
2014-03-25 04:52:32.809708	1818	434	3	2
2014-03-25 04:53:01.108807	1819	19.2	1	1
2014-03-25 04:53:01.333331	1820	52	2	1
2014-03-25 04:53:32.811388	1821	434	3	2
2014-03-25 04:53:40.106268	1822	19.2	1	1
2014-03-25 04:53:40.339127	1823	52	2	1
2014-03-25 04:54:19.109303	1824	19.2	1	1
2014-03-25 04:54:19.330561	1825	52	2	1
2014-03-25 04:54:32.812715	1826	434	3	2
2014-03-25 04:54:56.807926	1827	370	3	2
2014-03-25 04:54:58.107654	1828	19.2	1	1
2014-03-25 04:54:58.330235	1829	52	2	1
2014-03-25 04:55:08.812419	1830	370	3	2
2014-03-25 04:55:32.812127	1831	370	3	2
2014-03-25 04:55:37.104943	1832	19.2	1	1
2014-03-25 04:55:37.328293	1833	52	2	1
2014-03-25 04:56:16.103417	1834	19.2	1	1
2014-03-25 04:56:16.327201	1835	52	2	1
2014-03-25 04:56:32.812618	1836	354	3	2
2014-03-25 04:56:55.103633	1837	19.2	1	1
2014-03-25 04:56:55.328178	1838	52	2	1
2014-03-25 04:57:32.811407	1839	370	3	2
2014-03-25 04:57:34.10417	1840	19.2	1	1
2014-03-25 04:57:34.334124	1841	52	2	1
2014-03-25 04:58:13.102298	1842	19.2	1	1
2014-03-25 04:58:13.326023	1843	52	2	1
2014-03-25 04:58:32.809161	1844	370	3	2
2014-03-25 04:58:52.10429	1845	19.2	1	1
2014-03-25 04:58:52.326456	1846	52	2	1
2014-03-25 04:59:31.104392	1847	19.2	1	1
2014-03-25 04:59:31.337323	1848	52	2	1
2014-03-25 04:59:32.811831	1849	370	3	2
2014-03-25 05:00:10.102707	1850	19.2	1	1
2014-03-25 05:00:10.326012	1851	52	2	1
2014-03-25 05:00:32.809563	1852	370	3	2
2014-03-25 05:00:49.103298	1853	19.2	1	1
2014-03-25 05:00:49.328192	1854	52	2	1
2014-03-25 05:01:28.101383	1855	19.2	1	1
2014-03-25 05:01:28.325662	1856	52	2	1
2014-03-25 05:01:32.8124	1857	370	3	2
2014-03-25 05:01:44.808986	1858	418	3	2
2014-03-25 05:01:56.807584	1859	418	3	2
2014-03-25 05:02:07.101517	1860	19.2	1	1
2014-03-25 05:02:07.324685	1861	52	2	1
2014-03-25 05:02:32.812809	1862	418	3	2
2014-03-25 05:02:46.098312	1863	19.2	1	1
2014-03-25 05:02:46.322281	1864	52	2	1
2014-03-25 05:03:25.09936	1865	19.2	1	1
2014-03-25 05:03:25.32004	1866	52	2	1
2014-03-25 05:03:32.808053	1867	434	3	2
2014-03-25 05:04:04.103278	1868	19.2	1	1
2014-03-25 05:04:04.326624	1869	52	2	1
2014-03-25 05:04:20.808326	1870	338	3	2
2014-03-25 05:04:42.908848	1871	354	3	2
2014-03-25 05:04:43.22451	1872	19.2	1	1
2014-03-25 05:04:43.445798	1873	52	2	1
2014-03-25 05:05:22.100649	1874	19.2	1	1
2014-03-25 05:05:22.3233	1875	52	2	1
2014-03-25 05:05:32.807953	1876	354	3	2
2014-03-25 05:06:01.101765	1877	19.2	1	1
2014-03-25 05:06:01.327197	1878	52	2	1
2014-03-25 05:06:32.808491	1879	338	3	2
2014-03-25 05:06:40.098776	1880	19.2	1	1
2014-03-25 05:06:40.324483	1881	52	2	1
2014-03-25 05:06:56.810599	1882	305	3	2
2014-03-25 05:07:08.809384	1883	289	3	2
2014-03-25 05:07:19.09889	1884	19.2	1	1
2014-03-25 05:07:19.320902	1885	52	2	1
2014-03-25 05:07:32.811612	1886	289	3	2
2014-03-25 05:07:58.097285	1887	19.2	1	1
2014-03-25 05:07:58.320674	1888	52	2	1
2014-03-25 05:08:32.809887	1889	305	3	2
2014-03-25 05:08:37.099889	1890	19.2	1	1
2014-03-25 05:08:37.320596	1891	52	2	1
2014-03-25 05:09:16.098104	1892	19.2	1	1
2014-03-25 05:09:16.332699	1893	52	2	1
2014-03-25 05:09:32.813272	1894	289	3	2
2014-03-25 05:09:55.095945	1895	19.2	1	1
2014-03-25 05:09:55.319367	1896	52	2	1
2014-03-25 05:10:32.808683	1897	305	3	2
2014-03-25 05:10:34.098635	1898	19.2	1	1
2014-03-25 05:10:34.320756	1899	52	2	1
2014-03-25 05:11:13.100589	1900	19.2	1	1
2014-03-25 05:11:13.32829	1901	52	2	1
2014-03-25 05:11:32.810345	1902	305	3	2
2014-03-25 05:11:52.097515	1903	19.2	1	1
2014-03-25 05:11:52.3229	1904	52	2	1
2014-03-25 05:12:31.093547	1905	19.2	1	1
2014-03-25 05:12:31.326814	1906	52	2	1
2014-03-25 05:12:32.810829	1907	305	3	2
2014-03-25 05:13:10.094112	1908	19.2	1	1
2014-03-25 05:13:10.31759	1909	52	2	1
2014-03-25 05:13:32.808948	1910	305	3	2
2014-03-25 05:13:44.811098	1911	354	3	2
2014-03-25 05:13:49.095355	1912	19.1	1	1
2014-03-25 05:13:49.325563	1913	52	2	1
2014-03-25 05:13:56.806284	1914	354	3	2
2014-03-25 05:14:28.096012	1915	19.1	1	1
2014-03-25 05:14:28.31805	1916	52	2	1
2014-03-25 05:14:32.810256	1917	354	3	2
2014-03-25 05:15:07.094249	1918	19.1	1	1
2014-03-25 05:15:07.316427	1919	52	2	1
2014-03-25 05:15:32.806165	1920	354	3	2
2014-03-25 05:15:46.095015	1921	19.1	1	1
2014-03-25 05:15:46.326492	1922	52	2	1
2014-03-25 05:16:25.096279	1923	19.1	1	1
2014-03-25 05:16:25.319521	1924	52	2	1
2014-03-25 05:16:32.808244	1925	354	3	2
2014-03-25 05:17:04.090718	1926	19.1	1	1
2014-03-25 05:17:04.31474	1927	52	2	1
2014-03-25 05:17:32.809581	1928	354	3	2
2014-03-25 05:17:43.091948	1929	19.1	1	1
2014-03-25 05:17:43.317461	1930	52	2	1
2014-03-25 05:18:22.093525	1931	19.1	1	1
2014-03-25 05:18:22.326632	1932	52	2	1
2014-03-25 05:18:32.810222	1933	354	3	2
2014-03-25 05:18:56.810631	1934	273	3	2
2014-03-25 05:19:01.090866	1935	19.1	1	1
2014-03-25 05:19:01.323311	1936	52	2	1
2014-03-25 05:19:08.807856	1937	273	3	2
2014-03-25 05:19:32.806837	1938	289	3	2
2014-03-25 05:19:40.092545	1939	19.1	1	1
2014-03-25 05:19:40.324908	1940	52	2	1
2014-03-25 05:20:19.093284	1941	19.1	1	1
2014-03-25 05:20:19.316838	1942	52	2	1
2014-03-25 05:20:32.804869	1943	289	3	2
2014-03-25 05:20:58.092776	1944	19.1	1	1
2014-03-25 05:20:58.315141	1945	52	2	1
2014-03-25 05:21:32.809408	1946	273	3	2
2014-03-25 05:21:37.091894	1947	19.1	1	1
2014-03-25 05:21:37.31345	1948	52	2	1
2014-03-25 05:22:16.088718	1949	19.1	1	1
2014-03-25 05:22:16.31274	1950	52	2	1
2014-03-25 05:22:32.80277	1951	289	3	2
2014-03-25 05:22:55.089986	1952	19.1	1	1
2014-03-25 05:22:55.314069	1953	52	2	1
2014-03-25 05:23:32.808702	1954	305	3	2
2014-03-25 05:23:34.0873	1955	19.1	1	1
2014-03-25 05:23:34.307837	1956	52	2	1
2014-03-25 05:24:13.088658	1957	19.1	1	1
2014-03-25 05:24:13.311363	1958	52	2	1
2014-03-25 05:24:51.907748	1959	305	3	2
2014-03-25 05:24:52.214243	1960	19.1	1	1
2014-03-25 05:24:52.435691	1961	52	2	1
2014-03-25 05:25:31.089195	1962	19.1	1	1
2014-03-25 05:25:31.323681	1963	52	2	1
2014-03-25 05:25:32.811241	1964	305	3	2
2014-03-25 05:25:56.80874	1965	338	3	2
2014-03-25 05:26:08.806367	1966	354	3	2
2014-03-25 05:26:10.088826	1967	19.1	1	1
2014-03-25 05:26:10.310347	1968	52	2	1
2014-03-25 05:26:32.805032	1969	354	3	2
2014-03-25 05:26:49.087604	1970	19.1	1	1
2014-03-25 05:26:49.322364	1971	52	2	1
2014-03-25 05:27:28.088564	1972	19.1	1	1
2014-03-25 05:27:28.312852	1973	52	2	1
2014-03-25 05:27:32.806694	1974	338	3	2
2014-03-25 05:27:44.807869	1975	370	3	2
2014-03-25 05:27:56.807971	1976	370	3	2
2014-03-25 05:28:07.084736	1977	19.1	1	1
2014-03-25 05:28:07.318553	1978	52	2	1
2014-03-25 05:28:20.8062	1979	338	3	2
2014-03-25 05:28:32.807504	1980	354	3	2
2014-03-25 05:28:46.086404	1981	19.1	1	1
2014-03-25 05:28:46.32365	1982	52	2	1
2014-03-25 05:29:25.087836	1983	19.1	1	1
2014-03-25 05:29:25.313165	1984	52	2	1
2014-03-25 05:29:32.807313	1985	370	3	2
2014-03-25 05:29:56.806388	1986	338	3	2
2014-03-25 05:30:04.087564	1987	19.1	1	1
2014-03-25 05:30:04.312686	1988	52	2	1
2014-03-25 05:30:08.805219	1989	354	3	2
2014-03-25 05:30:32.806819	1990	354	3	2
2014-03-25 05:30:43.085946	1991	19.1	1	1
2014-03-25 05:30:43.327041	1992	52	2	1
2014-03-25 05:31:08.807512	1993	289	3	2
2014-03-25 05:31:20.809515	1994	305	3	2
2014-03-25 05:31:22.086332	1995	19.1	1	1
2014-03-25 05:31:22.319712	1996	52	2	1
2014-03-25 05:31:32.810336	1997	289	3	2
2014-03-25 05:32:01.325298	1998	19.1	1	1
2014-03-25 05:32:01.549196	1999	52	2	1
2014-03-25 05:32:32.80814	2000	305	3	2
2014-03-25 05:32:40.087071	2001	19.1	1	1
2014-03-25 05:32:40.311139	2002	52	2	1
2014-03-25 05:33:19.088696	2003	19.1	1	1
2014-03-25 05:33:19.312366	2004	52	2	1
2014-03-25 05:33:32.809127	2005	289	3	2
2014-03-25 05:33:58.081623	2006	19.1	1	1
2014-03-25 05:33:58.303312	2007	52	2	1
2014-03-25 05:34:32.811881	2008	305	3	2
2014-03-25 05:34:37.082478	2009	19.1	1	1
2014-03-25 05:34:37.303363	2010	52	2	1
2014-03-25 05:35:08.809313	2011	273	3	2
2014-03-25 05:35:16.083058	2012	19.1	1	1
2014-03-25 05:35:16.317411	2013	52	2	1
2014-03-25 05:35:20.809081	2014	289	3	2
2014-03-25 05:35:32.807438	2015	305	3	2
2014-03-25 05:35:55.081971	2016	19.1	1	1
2014-03-25 05:35:55.315171	2017	52	2	1
2014-03-25 05:36:32.810582	2018	338	3	2
2014-03-25 05:36:34.083873	2019	19.1	1	1
2014-03-25 05:36:34.307275	2020	52	2	1
2014-03-25 05:36:44.806344	2021	289	3	2
2014-03-25 05:36:56.809144	2022	305	3	2
2014-03-25 05:37:13.080091	2023	19.1	1	1
2014-03-25 05:37:13.313462	2024	52	2	1
2014-03-25 05:37:32.804734	2025	305	3	2
2014-03-25 05:37:52.084487	2026	19.1	1	1
2014-03-25 05:37:52.363172	2027	52	2	1
2014-03-25 05:37:56.808995	2028	370	3	2
2014-03-25 05:38:08.807621	2029	354	3	2
2014-03-25 05:38:31.079923	2030	19.1	1	1
2014-03-25 05:38:31.314612	2031	52	2	1
2014-03-25 05:38:32.802491	2032	354	3	2
2014-03-25 05:39:10.081404	2033	19.1	1	1
2014-03-25 05:39:10.305716	2034	51	2	1
2014-03-25 05:39:32.809544	2035	354	3	2
2014-03-25 05:39:49.089752	2036	19.1	1	1
2014-03-25 05:39:49.313105	2037	51	2	1
2014-03-25 05:40:08.808308	2038	402	3	2
2014-03-25 05:40:20.809057	2039	354	3	2
2014-03-25 05:40:28.077331	2040	19.1	1	1
2014-03-25 05:40:28.308725	2041	51	2	1
2014-03-25 05:40:32.806006	2042	354	3	2
2014-03-25 05:41:07.078566	2043	19.1	1	1
2014-03-25 05:41:07.300314	2044	51	2	1
2014-03-25 05:41:32.808568	2045	354	3	2
2014-03-25 05:41:46.079183	2046	19.1	1	1
2014-03-25 05:41:46.299651	2047	51	2	1
2014-03-25 05:42:25.077795	2048	19.1	1	1
2014-03-25 05:42:25.300642	2049	51	2	1
2014-03-25 05:42:32.807511	2050	338	3	2
2014-03-25 05:42:44.805605	2051	370	3	2
2014-03-25 05:42:56.807849	2052	338	3	2
2014-03-25 05:43:04.078648	2053	19.1	1	1
2014-03-25 05:43:04.301123	2054	51	2	1
2014-03-25 05:43:08.805045	2055	354	3	2
2014-03-25 05:43:20.805692	2056	289	3	2
2014-03-25 05:43:32.806158	2057	289	3	2
2014-03-25 05:43:43.079408	2058	19.1	1	1
2014-03-25 05:43:43.316087	2059	51	2	1
2014-03-25 05:44:20.805504	2060	338	3	2
2014-03-25 05:44:22.083136	2061	19.1	1	1
2014-03-25 05:44:22.330105	2062	51	2	1
2014-03-25 05:44:32.809355	2063	305	3	2
2014-03-25 05:44:44.808176	2064	289	3	2
2014-03-25 05:44:56.804035	2065	338	3	2
2014-03-25 05:45:01.07913	2066	19.1	1	1
2014-03-25 05:45:01.301938	2067	51	2	1
2014-03-25 05:45:08.807031	2068	305	3	2
2014-03-25 05:45:20.809609	2069	370	3	2
2014-03-25 05:45:39.89285	2070	370	3	2
2014-03-25 05:45:40.19986	2071	19.1	1	1
2014-03-25 05:45:40.432585	2072	51	2	1
2014-03-25 05:45:44.803499	2073	402	3	2
2014-03-25 05:45:56.807507	2074	402	3	2
2014-03-25 05:46:08.807446	2075	370	3	2
2014-03-25 05:46:19.075316	2076	19.1	1	1
2014-03-25 05:46:19.319256	2077	51	2	1
2014-03-25 05:46:20.80701	2078	370	3	2
2014-03-25 05:46:32.804257	2079	402	3	2
2014-03-25 05:46:44.807667	2080	370	3	2
2014-03-25 05:46:56.80905	2081	370	3	2
2014-03-25 05:46:58.078471	2082	19.1	1	1
2014-03-25 05:46:58.302119	2083	51	2	1
2014-03-25 05:47:32.805767	2084	370	3	2
2014-03-25 05:47:37.073011	2085	19.1	1	1
2014-03-25 05:47:37.305164	2086	51	2	1
2014-03-25 05:48:16.076251	2087	19.1	1	1
2014-03-25 05:48:16.300035	2088	51	2	1
2014-03-25 05:48:32.806471	2089	370	3	2
2014-03-25 05:48:55.072241	2090	19.1	1	1
2014-03-25 05:48:55.296824	2091	51	2	1
2014-03-25 05:49:32.810822	2092	370	3	2
2014-03-25 05:49:34.077301	2093	19.1	1	1
2014-03-25 05:49:34.300526	2094	51	2	1
2014-03-25 05:50:13.071827	2095	19.1	1	1
2014-03-25 05:50:13.294868	2096	51	2	1
2014-03-25 05:50:20.808963	2097	418	3	2
2014-03-25 05:50:32.804183	2098	434	3	2
2014-03-25 05:50:52.070779	2099	19.1	1	1
2014-03-25 05:50:52.294288	2100	51	2	1
2014-03-25 05:51:31.074639	2101	19.1	1	1
2014-03-25 05:51:31.307325	2102	51	2	1
2014-03-25 05:51:32.807214	2103	418	3	2
2014-03-25 05:52:10.074269	2104	19.1	1	1
2014-03-25 05:52:10.298311	2105	51	2	1
2014-03-25 05:52:32.805405	2106	434	3	2
2014-03-25 05:52:49.07205	2107	19.0	1	1
2014-03-25 05:52:49.296603	2108	51	2	1
2014-03-25 05:53:28.076693	2109	19.0	1	1
2014-03-25 05:53:28.298952	2110	51	2	1
2014-03-25 05:53:32.809075	2111	418	3	2
2014-03-25 05:54:07.077063	2112	19.0	1	1
2014-03-25 05:54:07.30892	2113	51	2	1
2014-03-25 05:54:32.80569	2114	434	3	2
2014-03-25 05:54:46.075105	2115	19.0	1	1
2014-03-25 05:54:46.319489	2116	51	2	1
2014-03-25 05:55:25.068838	2117	19.0	1	1
2014-03-25 05:55:25.293631	2118	51	2	1
2014-03-25 05:55:32.808083	2119	434	3	2
2014-03-25 05:56:04.072926	2120	19.0	1	1
2014-03-25 05:56:04.295445	2121	51	2	1
2014-03-25 05:56:08.806974	2122	370	3	2
2014-03-25 05:56:20.806838	2123	402	3	2
2014-03-25 05:56:32.806568	2124	370	3	2
2014-03-25 05:56:43.072415	2125	19.0	1	1
2014-03-25 05:56:43.297887	2126	51	2	1
2014-03-25 05:56:44.80371	2127	354	3	2
2014-03-25 05:56:56.806077	2128	402	3	2
2014-03-25 05:57:08.805681	2129	370	3	2
2014-03-25 05:57:20.802786	2130	354	3	2
2014-03-25 05:57:22.06907	2131	19.0	1	1
2014-03-25 05:57:22.293203	2132	51	2	1
2014-03-25 05:57:32.810025	2133	370	3	2
2014-03-25 05:58:00.878329	2134	338	3	2
2014-03-25 05:58:01.187057	2135	19.0	1	1
2014-03-25 05:58:01.42156	2136	51	2	1
2014-03-25 05:58:08.803348	2137	370	3	2
2014-03-25 05:58:20.810019	2138	370	3	2
2014-03-25 05:58:32.80812	2139	354	3	2
2014-03-25 05:58:40.070915	2140	19.0	1	1
2014-03-25 05:58:40.304045	2141	51	2	1
2014-03-25 05:59:19.072822	2142	19.0	1	1
2014-03-25 05:59:19.297037	2143	51	2	1
2014-03-25 05:59:20.808883	2144	402	3	2
2014-03-25 05:59:32.806717	2145	354	3	2
2014-03-25 05:59:44.80458	2146	370	3	2
2014-03-25 05:59:58.069798	2147	19.0	1	1
2014-03-25 05:59:58.303461	2148	51	2	1
2014-03-25 06:00:20.804915	2149	305	3	2
2014-03-25 06:00:32.805138	2150	289	3	2
2014-03-25 06:00:37.06905	2151	19.0	1	1
2014-03-25 06:00:37.304611	2152	51	2	1
2014-03-25 06:01:08.808207	2153	338	3	2
2014-03-25 06:01:16.070463	2154	19.0	1	1
2014-03-25 06:01:16.293921	2155	51	2	1
2014-03-25 06:01:20.80599	2156	289	3	2
2014-03-25 06:01:32.805289	2157	305	3	2
2014-03-25 06:01:55.067193	2158	19.0	1	1
2014-03-25 06:01:55.307545	2159	51	2	1
2014-03-25 06:02:32.805724	2160	289	3	2
2014-03-25 06:02:34.064711	2161	19.0	1	1
2014-03-25 06:02:34.286328	2162	51	2	1
2014-03-25 06:02:56.808002	2163	338	3	2
2014-03-25 06:03:08.807046	2164	354	3	2
2014-03-25 06:03:13.06649	2165	19.0	1	1
2014-03-25 06:03:13.300601	2166	51	2	1
2014-03-25 06:03:32.808672	2167	354	3	2
2014-03-25 06:03:52.066568	2168	19.0	1	1
2014-03-25 06:03:52.289364	2169	51	2	1
2014-03-25 06:04:31.066238	2170	19.0	1	1
2014-03-25 06:04:31.288213	2171	51	2	1
2014-03-25 06:04:32.805616	2172	354	3	2
2014-03-25 06:05:10.069431	2173	19.0	1	1
2014-03-25 06:05:10.294587	2174	51	2	1
2014-03-25 06:05:32.80928	2175	354	3	2
2014-03-25 06:05:49.066489	2176	19.0	1	1
2014-03-25 06:05:49.809639	2177	51	2	1
2014-03-25 06:06:28.069862	2178	19.0	1	1
2014-03-25 06:06:28.326443	2179	51	2	1
2014-03-25 06:07:06.871879	2180	354	3	2
2014-03-25 06:07:07.180116	2181	19.0	1	1
2014-03-25 06:07:07.400772	2182	51	2	1
2014-03-25 06:07:32.804266	2183	370	3	2
2014-03-25 06:07:46.069139	2184	19.0	1	1
2014-03-25 06:07:46.293276	2185	51	2	1
2014-03-25 06:07:56.808652	2186	305	3	2
2014-03-25 06:08:08.806912	2187	305	3	2
2014-03-25 06:08:25.06809	2188	19.0	1	1
2014-03-25 06:08:25.292131	2189	51	2	1
2014-03-25 06:08:32.808985	2190	305	3	2
2014-03-25 06:09:04.065227	2191	19.0	1	1
2014-03-25 06:09:04.287894	2192	51	2	1
2014-03-25 06:09:32.809789	2193	305	3	2
2014-03-25 06:09:43.064727	2194	19.0	1	1
2014-03-25 06:09:43.287928	2195	51	2	1
2014-03-25 06:10:22.063468	2196	19.0	1	1
2014-03-25 06:10:22.297811	2197	51	2	1
2014-03-25 06:10:32.803771	2198	305	3	2
2014-03-25 06:11:01.065815	2199	19.0	1	1
2014-03-25 06:11:01.2905	2200	51	2	1
2014-03-25 06:11:32.809182	2201	305	3	2
2014-03-25 06:11:40.063977	2202	19.0	1	1
2014-03-25 06:11:40.286981	2203	51	2	1
2014-03-25 06:12:19.064298	2204	19.0	1	1
2014-03-25 06:12:19.287692	2205	51	2	1
2014-03-25 06:12:32.805574	2206	305	3	2
2014-03-25 06:12:58.067195	2207	19.0	1	1
2014-03-25 06:12:58.328686	2208	51	2	1
2014-03-25 06:13:32.810126	2209	305	3	2
2014-03-25 06:13:37.064257	2210	19.0	1	1
2014-03-25 06:13:37.287578	2211	51	2	1
2014-03-25 06:14:16.06368	2212	19.0	1	1
2014-03-25 06:14:16.287334	2213	51	2	1
2014-03-25 06:14:32.805235	2214	354	3	2
2014-03-25 06:14:44.806102	2215	354	3	2
2014-03-25 06:14:55.064864	2216	19.0	1	1
2014-03-25 06:14:55.287445	2217	51	2	1
2014-03-25 06:15:32.808276	2218	370	3	2
2014-03-25 06:15:34.060656	2219	19.0	1	1
2014-03-25 06:15:34.286133	2220	51	2	1
2014-03-25 06:16:13.065266	2221	19.0	1	1
2014-03-25 06:16:13.289087	2222	51	2	1
2014-03-25 06:16:32.805258	2223	354	3	2
2014-03-25 06:16:52.060063	2224	19.0	1	1
2014-03-25 06:16:52.281944	2225	51	2	1
2014-03-25 06:17:31.061701	2226	19.0	1	1
2014-03-25 06:17:31.283998	2227	51	2	1
2014-03-25 06:17:32.804638	2228	354	3	2
2014-03-25 06:18:10.058071	2229	19.0	1	1
2014-03-25 06:18:10.284138	2230	51	2	1
2014-03-25 06:18:32.804646	2231	354	3	2
2014-03-25 06:18:49.06087	2232	19.0	1	1
2014-03-25 06:18:49.284435	2233	51	2	1
2014-03-25 06:19:28.055782	2234	19.0	1	1
2014-03-25 06:19:28.280553	2235	51	2	1
2014-03-25 06:19:32.812598	2236	370	3	2
2014-03-25 06:19:56.806967	2237	305	3	2
2014-03-25 06:20:07.061077	2238	19.0	1	1
2014-03-25 06:20:07.294978	2239	51	2	1
2014-03-25 06:20:08.804117	2240	305	3	2
2014-03-25 06:20:32.804287	2241	305	3	2
2014-03-25 06:20:46.059177	2242	19.0	1	1
2014-03-25 06:20:46.281462	2243	51	2	1
2014-03-25 06:21:25.055612	2244	19.0	1	1
2014-03-25 06:21:25.279819	2245	51	2	1
2014-03-25 06:21:32.80638	2246	305	3	2
2014-03-25 06:22:04.059187	2247	19.0	1	1
2014-03-25 06:22:04.284798	2248	51	2	1
2014-03-25 06:22:32.807769	2249	305	3	2
2014-03-25 06:22:43.055771	2250	19.0	1	1
2014-03-25 06:22:43.280341	2251	51	2	1
2014-03-25 06:23:22.056094	2252	19.0	1	1
2014-03-25 06:23:22.281298	2253	51	2	1
2014-03-25 06:23:32.804341	2254	289	3	2
2014-03-25 06:24:01.055654	2255	19.0	1	1
2014-03-25 06:24:01.2767	2256	51	2	1
2014-03-25 06:24:32.804344	2257	289	3	2
2014-03-25 06:24:40.058264	2258	19.0	1	1
2014-03-25 06:24:40.283391	2259	51	2	1
2014-03-25 06:25:19.058127	2260	19.0	1	1
2014-03-25 06:25:19.288891	2261	51	2	1
2014-03-25 06:25:32.806728	2262	305	3	2
2014-03-25 06:25:58.057973	2263	19.0	1	1
2014-03-25 06:25:58.280862	2264	51	2	1
2014-03-25 06:26:32.80502	2265	305	3	2
2014-03-25 06:26:37.055702	2266	19.0	1	1
2014-03-25 06:26:37.278703	2267	51	2	1
2014-03-25 06:26:56.806158	2268	354	3	2
2014-03-25 06:27:08.804773	2269	354	3	2
2014-03-25 06:27:16.055429	2270	19.0	1	1
2014-03-25 06:27:16.289666	2271	51	2	1
2014-03-25 06:27:32.805225	2272	354	3	2
2014-03-25 06:27:55.058125	2273	19.0	1	1
2014-03-25 06:27:55.290636	2274	51	2	1
2014-03-25 06:28:32.80563	2275	354	3	2
2014-03-25 06:28:34.053724	2276	19.0	1	1
2014-03-25 06:28:34.277697	2277	51	2	1
2014-03-25 06:29:13.055484	2278	19.0	1	1
2014-03-25 06:29:13.281846	2279	51	2	1
2014-03-25 06:29:32.806822	2280	354	3	2
2014-03-25 06:29:52.053811	2281	19.0	1	1
2014-03-25 06:29:52.278842	2282	51	2	1
2014-03-25 06:30:31.052765	2283	19.0	1	1
2014-03-25 06:30:31.274829	2284	51	2	1
2014-03-25 06:30:32.809385	2285	354	3	2
2014-03-25 06:31:10.056407	2286	19.0	1	1
2014-03-25 06:31:10.285466	2287	51	2	1
2014-03-25 06:31:32.805443	2288	354	3	2
2014-03-25 06:31:49.053768	2289	19.0	1	1
2014-03-25 06:31:49.277098	2290	51	2	1
2014-03-25 06:32:28.052526	2291	19.0	1	1
2014-03-25 06:32:28.276594	2292	51	2	1
2014-03-25 06:32:32.806229	2293	305	3	2
2014-03-25 06:32:44.803028	2294	305	3	2
2014-03-25 06:33:07.050461	2295	19.0	1	1
2014-03-25 06:33:07.282347	2296	51	2	1
2014-03-25 06:33:32.803708	2297	305	3	2
2014-03-25 06:33:46.052834	2298	19.0	1	1
2014-03-25 06:33:46.274575	2299	51	2	1
2014-03-25 06:34:25.047812	2300	19.0	1	1
2014-03-25 06:34:25.270933	2301	51	2	1
2014-03-25 06:34:32.804429	2302	305	3	2
2014-03-25 06:35:04.05029	2303	19.0	1	1
2014-03-25 06:35:04.273223	2304	51	2	1
2014-03-25 06:35:32.808548	2305	305	3	2
2014-03-25 06:35:43.051643	2306	19.0	1	1
2014-03-25 06:35:43.284933	2307	51	2	1
2014-03-25 06:36:22.049758	2308	19.0	1	1
2014-03-25 06:36:22.273515	2309	51	2	1
2014-03-25 06:36:32.803617	2310	305	3	2
2014-03-25 06:37:01.058218	2311	19.0	1	1
2014-03-25 06:37:01.283147	2312	51	2	1
2014-03-25 06:37:32.806853	2313	305	3	2
2014-03-25 06:37:40.048791	2314	19.0	1	1
2014-03-25 06:37:40.28523	2315	51	2	1
2014-03-25 06:38:19.047722	2316	19.0	1	1
2014-03-25 06:38:19.270619	2317	51	2	1
2014-03-25 06:38:32.80782	2318	305	3	2
2014-03-25 06:38:58.046678	2319	19.0	1	1
2014-03-25 06:38:58.270641	2320	51	2	1
2014-03-25 06:39:20.805154	2321	370	3	2
2014-03-25 06:39:32.802862	2322	370	3	2
2014-03-25 06:39:37.049402	2323	19.0	1	1
2014-03-25 06:39:37.27285	2324	51	2	1
2014-03-25 06:40:16.04509	2325	19.0	1	1
2014-03-25 06:40:16.289096	2326	51	2	1
2014-03-25 06:40:32.804093	2327	370	3	2
2014-03-25 06:40:55.045352	2328	19.0	1	1
2014-03-25 06:40:55.268913	2329	51	2	1
2014-03-25 06:41:32.80775	2330	354	3	2
2014-03-25 06:41:34.049782	2331	19.0	1	1
2014-03-25 06:41:34.273553	2332	51	2	1
2014-03-25 06:41:44.803445	2333	434	3	2
2014-03-25 06:41:56.804635	2334	434	3	2
2014-03-25 06:42:13.044759	2335	19.0	1	1
2014-03-25 06:42:13.269528	2336	51	2	1
2014-03-25 06:42:32.805454	2337	434	3	2
2014-03-25 06:42:52.047443	2338	19.0	1	1
2014-03-25 06:42:52.274827	2339	51	2	1
2014-03-25 06:43:31.041037	2340	19.0	1	1
2014-03-25 06:43:31.264647	2341	51	2	1
2014-03-25 06:43:32.807566	2342	434	3	2
2014-03-25 06:44:10.04373	2343	19.0	1	1
2014-03-25 06:44:10.267116	2344	51	2	1
2014-03-25 06:44:20.805874	2345	370	3	2
2014-03-25 06:44:32.805054	2346	370	3	2
2014-03-25 06:44:49.043931	2347	19.0	1	1
2014-03-25 06:44:49.26739	2348	51	2	1
2014-03-25 06:45:28.044643	2349	19.0	1	1
2014-03-25 06:45:28.269006	2350	51	2	1
2014-03-25 06:45:32.806436	2351	370	3	2
2014-03-25 06:46:07.043384	2352	19.0	1	1
2014-03-25 06:46:07.266742	2353	51	2	1
2014-03-25 06:46:32.80159	2354	370	3	2
2014-03-25 06:46:46.045397	2355	19.0	1	1
2014-03-25 06:46:46.269184	2356	51	2	1
2014-03-25 06:47:25.045328	2357	19.0	1	1
2014-03-25 06:47:25.276942	2358	51	2	1
2014-03-25 06:47:32.803124	2359	370	3	2
2014-03-25 06:48:32.806447	2360	370	3	2
2014-03-25 06:48:43.04405	2361	18.9	1	1
2014-03-25 06:48:43.280354	2362	52	2	1
2014-03-25 06:48:56.663722	2363	402	3	2
2014-03-25 06:48:56.973679	2364	354	3	2
2014-03-25 06:49:08.804806	2365	370	3	2
2014-03-25 06:49:20.80308	2366	402	3	2
2014-03-25 06:49:22.042321	2367	18.9	1	1
2014-03-25 06:49:22.265005	2368	52	2	1
2014-03-25 06:49:32.802927	2369	370	3	2
2014-03-25 06:49:44.803356	2370	354	3	2
2014-03-25 06:50:01.039323	2371	18.9	1	1
2014-03-25 06:50:01.457067	2372	52	2	1
2014-03-25 06:50:08.800827	2373	402	3	2
2014-03-25 06:50:20.801353	2374	370	3	2
2014-03-25 06:50:32.804075	2375	354	3	2
2014-03-25 06:50:40.038785	2376	18.9	1	1
2014-03-25 06:50:40.268258	2377	52	2	1
2014-03-25 06:50:44.802517	2378	418	3	2
2014-03-25 06:50:56.802512	2379	434	3	2
2014-03-25 06:51:19.037768	2380	18.9	1	1
2014-03-25 06:51:19.259486	2381	52	2	1
2014-03-25 06:51:32.814832	2382	434	3	2
2014-03-25 06:51:58.038486	2383	18.9	1	1
2014-03-25 06:51:58.271015	2384	52	2	1
2014-03-25 06:52:32.802374	2385	434	3	2
2014-03-25 06:52:37.041934	2386	18.9	1	1
2014-03-25 06:52:37.28267	2387	52	2	1
2014-03-25 06:53:16.04087	2388	18.9	1	1
2014-03-25 06:53:16.264139	2389	52	2	1
2014-03-25 06:53:32.803302	2390	434	3	2
2014-03-25 06:53:55.040922	2391	18.9	1	1
2014-03-25 06:53:55.26441	2392	52	2	1
2014-03-25 06:54:32.805271	2393	434	3	2
2014-03-25 06:54:34.039376	2394	18.9	1	1
2014-03-25 06:54:34.26057	2395	52	2	1
2014-03-25 06:55:13.039535	2396	18.9	1	1
2014-03-25 06:55:13.27937	2397	52	2	1
2014-03-25 06:55:32.804605	2398	434	3	2
2014-03-25 06:55:52.039891	2399	18.9	1	1
2014-03-25 06:55:52.260291	2400	52	2	1
2014-03-25 06:55:56.80171	2401	354	3	2
2014-03-25 06:56:08.803991	2402	370	3	2
2014-03-25 06:56:31.039756	2403	18.9	1	1
2014-03-25 06:56:31.269628	2404	52	2	1
2014-03-25 06:56:32.802428	2405	370	3	2
2014-03-25 06:56:44.806667	2406	289	3	2
2014-03-25 06:56:56.80693	2407	289	3	2
2014-03-25 06:57:10.038551	2408	18.9	1	1
2014-03-25 06:57:10.295136	2409	52	2	1
2014-03-25 06:57:32.799104	2410	305	3	2
2014-03-25 06:57:49.087931	2411	18.9	1	1
2014-03-25 06:57:49.488286	2412	52	2	1
2014-03-25 06:58:28.03865	2413	18.9	1	1
2014-03-25 06:58:28.266702	2414	52	2	1
2014-03-25 06:58:32.801243	2415	305	3	2
2014-03-25 06:58:56.804741	2416	338	3	2
2014-03-25 06:59:07.036668	2417	18.9	1	1
2014-03-25 06:59:07.259441	2418	52	2	1
2014-03-25 06:59:08.802477	2419	305	3	2
2014-03-25 06:59:20.800986	2420	305	3	2
2014-03-25 06:59:32.805055	2421	305	3	2
2014-03-25 06:59:46.038476	2422	18.9	1	1
2014-03-25 06:59:46.259112	2423	52	2	1
2014-03-25 07:00:25.111126	2424	18.9	1	1
2014-03-25 07:00:25.68235	2425	52	2	1
2014-03-25 07:00:32.80261	2426	305	3	2
2014-03-25 07:01:04.033585	2427	18.9	1	1
2014-03-25 07:01:04.263759	2428	52	2	1
2014-03-25 07:01:32.803638	2429	305	3	2
2014-03-25 07:01:43.036503	2430	18.9	1	1
2014-03-25 07:01:43.256341	2431	52	2	1
2014-03-25 07:02:22.032551	2432	18.9	1	1
2014-03-25 07:02:22.253968	2433	52	2	1
2014-03-25 07:02:32.806126	2434	370	3	2
2014-03-25 07:02:44.801369	2435	354	3	2
2014-03-25 07:03:01.035559	2436	18.9	1	1
2014-03-25 07:03:01.257223	2437	52	2	1
2014-03-25 07:03:32.802418	2438	354	3	2
2014-03-25 07:03:40.036937	2439	18.9	1	1
2014-03-25 07:03:40.268431	2440	52	2	1
2014-03-25 07:03:56.801998	2441	515	3	2
2014-03-25 07:04:08.803177	2442	515	3	2
2014-03-25 07:04:19.035146	2443	18.9	1	1
2014-03-25 07:04:19.270135	2444	52	2	1
2014-03-25 07:04:32.804048	2445	515	3	2
2014-03-25 07:04:58.038625	2446	18.9	1	1
2014-03-25 07:04:58.260632	2447	52	2	1
2014-03-25 07:05:37.032724	2448	18.9	1	1
2014-03-25 07:05:37.255158	2449	52	2	1
2014-03-25 07:06:16.032583	2450	18.9	1	1
2014-03-25 07:06:16.263306	2451	52	2	1
2014-03-25 07:06:55.088608	2452	18.9	1	1
2014-03-25 07:06:55.31199	2453	52	2	1
2014-03-25 07:07:32.802552	2454	515	3	2
2014-03-25 07:07:34.031825	2455	18.9	1	1
2014-03-25 07:07:34.253032	2456	52	2	1
2014-03-25 07:07:44.801573	2457	450	3	2
2014-03-25 07:07:56.799699	2458	450	3	2
2014-03-25 07:08:13.032748	2459	18.9	1	1
2014-03-25 07:08:13.254713	2460	52	2	1
2014-03-25 07:08:52.034151	2461	18.9	1	1
2014-03-25 07:08:52.266387	2462	52	2	1
2014-03-25 07:09:31.034801	2463	18.9	1	1
2014-03-25 07:09:31.258478	2464	52	2	1
2014-03-25 07:09:32.798776	2465	466	3	2
2014-03-25 07:10:10.03253	2466	18.9	1	1
2014-03-25 07:10:10.255882	2467	52	2	1
2014-03-25 07:10:32.796458	2468	450	3	2
2014-03-25 07:10:49.03035	2469	18.9	1	1
2014-03-25 07:10:49.252018	2470	52	2	1
2014-03-25 07:11:28.029323	2471	18.9	1	1
2014-03-25 07:11:28.251406	2472	52	2	1
2014-03-25 07:11:32.802296	2473	450	3	2
2014-03-25 07:12:07.029155	2474	18.9	1	1
2014-03-25 07:12:07.250601	2475	52	2	1
2014-03-25 07:12:32.802943	2476	450	3	2
2014-03-25 07:12:46.028894	2477	18.9	1	1
2014-03-25 07:12:46.251902	2478	52	2	1
2014-03-25 07:13:25.03215	2479	18.9	1	1
2014-03-25 07:13:25.319422	2480	52	2	1
2014-03-25 07:13:32.800213	2481	450	3	2
2014-03-25 07:14:04.028026	2482	18.9	1	1
2014-03-25 07:14:04.248527	2483	52	2	1
2014-03-25 07:14:20.796824	2484	498	3	2
2014-03-25 07:14:42.832774	2485	434	3	2
2014-03-25 07:14:43.141956	2486	18.9	1	1
2014-03-25 07:14:43.372993	2487	52	2	1
2014-03-25 07:14:44.8021	2488	450	3	2
2014-03-25 07:15:22.027837	2489	18.9	1	1
2014-03-25 07:15:22.260111	2490	52	2	1
2014-03-25 07:16:01.027535	2491	18.9	1	1
2014-03-25 07:16:01.249133	2492	52	2	1
2014-03-25 07:16:40.026151	2493	18.9	1	1
2014-03-25 07:16:40.257977	2494	52	2	1
2014-03-25 07:17:19.02362	2495	18.9	1	1
2014-03-25 07:17:19.247633	2496	52	2	1
2014-03-25 07:17:58.026044	2497	18.9	1	1
2014-03-25 07:17:58.270552	2498	52	2	1
2014-03-25 07:18:37.027856	2499	18.9	1	1
2014-03-25 07:18:37.248905	2500	52	2	1
2014-03-25 07:19:16.033489	2501	18.9	1	1
2014-03-25 07:19:16.264858	2502	52	2	1
2014-03-25 07:19:32.796142	2503	418	3	2
2014-03-25 07:19:55.024924	2504	18.9	1	1
2014-03-25 07:19:55.24881	2505	52	2	1
2014-03-25 07:20:32.799029	2506	418	3	2
2014-03-25 07:20:34.02334	2507	18.9	1	1
2014-03-25 07:20:34.244774	2508	52	2	1
2014-03-25 07:21:13.025627	2509	18.9	1	1
2014-03-25 07:21:13.246966	2510	52	2	1
2014-03-25 07:21:32.803879	2511	418	3	2
2014-03-25 07:21:52.028665	2512	18.9	1	1
2014-03-25 07:21:52.259922	2513	52	2	1
2014-03-25 07:22:08.798485	2514	466	3	2
2014-03-25 07:22:20.801343	2515	434	3	2
2014-03-25 07:22:31.022829	2516	18.9	1	1
2014-03-25 07:22:31.255627	2517	52	2	1
2014-03-25 07:22:32.799244	2518	434	3	2
2014-03-25 07:23:10.02481	2519	18.9	1	1
2014-03-25 07:23:10.247307	2520	52	2	1
2014-03-25 07:23:32.799869	2521	434	3	2
2014-03-25 07:23:49.023569	2522	18.9	1	1
2014-03-25 07:23:49.24585	2523	52	2	1
2014-03-25 07:24:28.022885	2524	18.9	1	1
2014-03-25 07:24:28.246737	2525	52	2	1
2014-03-25 07:25:07.024472	2526	18.9	1	1
2014-03-25 07:25:07.24671	2527	52	2	1
2014-03-25 07:25:20.804966	2528	338	3	2
2014-03-25 07:25:32.803887	2529	402	3	2
2014-03-25 07:25:44.805552	2530	402	3	2
2014-03-25 07:25:46.02334	2531	18.9	1	1
2014-03-25 07:25:46.245919	2532	52	2	1
2014-03-25 07:26:25.01968	2533	18.9	1	1
2014-03-25 07:26:25.253925	2534	52	2	1
2014-03-25 07:26:32.800945	2535	402	3	2
2014-03-25 07:27:04.019204	2536	18.9	1	1
2014-03-25 07:27:04.24157	2537	52	2	1
2014-03-25 07:27:32.804511	2538	402	3	2
2014-03-25 07:27:43.021845	2539	18.9	1	1
2014-03-25 07:27:43.246456	2540	52	2	1
2014-03-25 07:28:22.017974	2541	18.9	1	1
2014-03-25 07:28:22.248114	2542	52	2	1
2014-03-25 07:28:56.80504	2543	498	3	2
2014-03-25 07:29:01.022442	2544	18.9	1	1
2014-03-25 07:29:01.256867	2545	52	2	1
2014-03-25 07:29:32.804484	2546	498	3	2
2014-03-25 07:29:40.021688	2547	18.9	1	1
2014-03-25 07:29:40.243527	2548	52	2	1
2014-03-25 07:30:08.8043	2549	627	3	2
2014-03-25 07:30:19.022403	2550	18.9	1	1
2014-03-25 07:30:19.245356	2551	52	2	1
2014-03-25 07:30:20.802654	2552	627	3	2
2014-03-25 07:30:32.803168	2553	627	3	2
2014-03-25 07:30:44.805882	2554	579	3	2
2014-03-25 07:30:57.824225	2555	579	3	2
2014-03-25 07:30:58.141395	2556	18.9	1	1
2014-03-25 07:30:58.363111	2557	52	2	1
2014-03-25 07:31:32.805621	2558	579	3	2
2014-03-25 07:31:37.02022	2559	18.9	1	1
2014-03-25 07:31:37.25273	2560	52	2	1
2014-03-25 07:31:56.805677	2561	547	3	2
2014-03-25 07:32:08.80355	2562	547	3	2
2014-03-25 07:32:16.019273	2563	18.9	1	1
2014-03-25 07:32:16.253304	2564	52	2	1
2014-03-25 07:32:32.805856	2565	547	3	2
2014-03-25 07:32:55.018852	2566	18.9	1	1
2014-03-25 07:32:55.242172	2567	52	2	1
2014-03-25 07:33:32.810266	2568	579	3	2
2014-03-25 07:33:34.016773	2569	18.9	1	1
2014-03-25 07:33:34.237004	2570	52	2	1
2014-03-25 07:33:44.803279	2571	547	3	2
2014-03-25 07:33:56.803379	2572	547	3	2
2014-03-25 07:34:13.018715	2573	19.0	1	1
2014-03-25 07:34:13.250043	2574	51	2	1
2014-03-25 07:34:20.805089	2575	627	3	2
2014-03-25 07:34:32.809734	2576	627	3	2
2014-03-25 07:34:52.018693	2577	19.0	1	1
2014-03-25 07:34:52.251058	2578	51	2	1
2014-03-25 07:35:31.025246	2579	19.0	1	1
2014-03-25 07:35:31.247678	2580	51	2	1
2014-03-25 07:35:32.806167	2581	611	3	2
2014-03-25 07:36:10.019512	2582	19.0	1	1
2014-03-25 07:36:10.243474	2583	51	2	1
2014-03-25 07:36:20.805269	2584	2382	3	2
2014-03-25 07:36:32.802707	2585	2398	3	2
2014-03-25 07:36:49.017084	2586	19.0	1	1
2014-03-25 07:36:49.240308	2587	51	2	1
2014-03-25 07:37:08.802252	2588	2849	3	2
2014-03-25 07:37:20.801962	2589	2607	3	2
2014-03-25 07:37:28.014988	2590	19.0	1	1
2014-03-25 07:37:28.248408	2591	51	2	1
2014-03-25 07:37:32.80225	2592	2269	3	2
2014-03-25 07:37:44.804093	2593	2382	3	2
2014-03-25 07:37:56.806653	2594	2382	3	2
2014-03-25 07:38:07.012598	2595	19.0	1	1
2014-03-25 07:38:07.243354	2596	52	2	1
2014-03-25 07:38:32.8014	2597	2398	3	2
2014-03-25 07:38:46.014583	2598	19.0	1	1
2014-03-25 07:38:46.237035	2599	52	2	1
2014-03-25 07:39:25.013996	2600	19.0	1	1
2014-03-25 07:39:25.237615	2601	52	2	1
2014-03-25 07:39:32.8056	2602	2414	3	2
2014-03-25 07:40:04.010876	2603	19.0	1	1
2014-03-25 07:40:04.242748	2604	52	2	1
2014-03-25 07:40:08.803833	2605	2591	3	2
2014-03-25 07:40:20.801794	2606	2575	3	2
2014-03-25 07:40:32.808749	2607	2720	3	2
2014-03-25 07:40:43.013653	2608	19.0	1	1
2014-03-25 07:40:43.236263	2609	52	2	1
2014-03-25 07:40:44.80133	2610	2720	3	2
2014-03-25 07:41:08.806385	2611	2511	3	2
2014-03-25 07:41:20.804831	2612	2398	3	2
2014-03-25 07:41:22.010413	2613	19.1	1	1
2014-03-25 07:41:22.245027	2614	52	2	1
2014-03-25 07:41:32.804817	2615	2382	3	2
2014-03-25 07:42:01.012507	2616	19.1	1	1
2014-03-25 07:42:01.243831	2617	52	2	1
2014-03-25 07:42:08.797706	2618	611	3	2
2014-03-25 07:42:20.795996	2619	627	3	2
2014-03-25 07:42:32.800065	2620	611	3	2
2014-03-25 07:42:40.011663	2621	19.1	1	1
2014-03-25 07:42:40.234695	2622	52	2	1
2014-03-25 07:42:56.797618	2623	547	3	2
2014-03-25 07:43:08.801083	2624	547	3	2
2014-03-25 07:43:19.012672	2625	19.1	1	1
2014-03-25 07:43:19.236036	2626	52	2	1
2014-03-25 07:43:32.796066	2627	547	3	2
2014-03-25 07:43:44.796454	2628	579	3	2
2014-03-25 07:43:58.011725	2629	19.1	1	1
2014-03-25 07:43:58.23312	2630	52	2	1
2014-03-25 07:44:08.795508	2631	579	3	2
2014-03-25 07:44:20.802679	2632	547	3	2
2014-03-25 07:44:32.797896	2633	547	3	2
2014-03-25 07:44:37.010698	2634	19.1	1	1
2014-03-25 07:44:37.240746	2635	52	2	1
2014-03-25 07:45:16.010572	2636	19.1	1	1
2014-03-25 07:45:16.231684	2637	52	2	1
2014-03-25 07:45:32.804276	2638	547	3	2
2014-03-25 07:45:55.014642	2639	19.2	1	1
2014-03-25 07:45:55.237983	2640	52	2	1
2014-03-25 07:46:32.797778	2641	579	3	2
2014-03-25 07:46:34.006729	2642	19.2	1	1
2014-03-25 07:46:34.228222	2643	52	2	1
2014-03-25 07:46:44.803789	2644	547	3	2
2014-03-25 07:46:56.800133	2645	547	3	2
2014-03-25 07:47:13.007198	2646	19.2	1	1
2014-03-25 07:47:13.232476	2647	52	2	1
2014-03-25 07:47:32.803722	2648	547	3	2
2014-03-25 07:47:52.007883	2649	19.2	1	1
2014-03-25 07:47:52.233691	2650	52	2	1
2014-03-25 07:48:08.803528	2651	515	3	2
2014-03-25 07:48:20.79913	2652	547	3	2
2014-03-25 07:48:31.004633	2653	19.2	1	1
2014-03-25 07:48:31.226403	2654	52	2	1
2014-03-25 07:48:32.799534	2655	547	3	2
2014-03-25 07:48:44.799287	2656	579	3	2
2014-03-25 07:48:56.802525	2657	547	3	2
2014-03-25 07:49:08.798758	2658	547	3	2
2014-03-25 07:49:10.006492	2659	19.3	1	1
2014-03-25 07:49:10.226888	2660	52	2	1
2014-03-25 07:49:20.796861	2661	611	3	2
2014-03-25 07:49:32.800827	2662	611	3	2
2014-03-25 07:49:49.009822	2663	19.3	1	1
2014-03-25 07:49:49.240628	2664	52	2	1
2014-03-25 07:50:28.008465	2665	19.3	1	1
2014-03-25 07:50:28.231098	2666	52	2	1
2014-03-25 07:50:32.800706	2667	611	3	2
2014-03-25 07:51:07.003203	2668	19.3	1	1
2014-03-25 07:51:07.223866	2669	52	2	1
2014-03-25 07:51:32.794414	2670	611	3	2
2014-03-25 07:51:46.010332	2671	19.3	1	1
2014-03-25 07:51:46.232825	2672	52	2	1
2014-03-25 07:52:25.015915	2673	19.3	1	1
2014-03-25 07:52:25.988483	2674	52	2	1
2014-03-25 07:52:44.658138	2675	627	3	2
2014-03-25 07:52:44.96551	2676	531	3	2
2014-03-25 07:52:56.800592	2677	531	3	2
2014-03-25 07:53:04.006149	2678	19.3	1	1
2014-03-25 07:53:04.228767	2679	52	2	1
2014-03-25 07:53:32.803261	2680	531	3	2
2014-03-25 07:53:43.004916	2681	19.3	1	1
2014-03-25 07:53:43.237217	2682	52	2	1
2014-03-25 07:54:08.800439	2683	434	3	2
2014-03-25 07:54:20.800313	2684	418	3	2
2014-03-25 07:54:22.008224	2685	19.3	1	1
2014-03-25 07:54:22.241199	2686	52	2	1
2014-03-25 07:54:32.800839	2687	434	3	2
2014-03-25 07:54:56.803136	2688	370	3	2
2014-03-25 07:55:01.002934	2689	19.3	1	1
2014-03-25 07:55:01.23412	2690	52	2	1
2014-03-25 07:55:08.799454	2691	450	3	2
2014-03-25 07:55:20.801878	2692	434	3	2
2014-03-25 07:55:32.799796	2693	434	3	2
2014-03-25 07:55:40.004345	2694	19.3	1	1
2014-03-25 07:55:40.226556	2695	52	2	1
2014-03-25 07:56:19.004506	2696	19.3	1	1
2014-03-25 07:56:19.226889	2697	52	2	1
2014-03-25 07:56:32.803758	2698	434	3	2
2014-03-25 07:56:58.004972	2699	19.3	1	1
2014-03-25 07:56:58.226823	2700	52	2	1
2014-03-25 07:57:08.800823	2701	370	3	2
2014-03-25 07:57:20.803508	2702	370	3	2
2014-03-25 07:57:32.801716	2703	370	3	2
2014-03-25 07:57:37.000409	2704	19.3	1	1
2014-03-25 07:57:37.2452	2705	52	2	1
2014-03-25 07:58:16.004434	2706	19.4	1	1
2014-03-25 07:58:16.227471	2707	52	2	1
2014-03-25 07:58:32.802233	2708	354	3	2
2014-03-25 07:58:55.004967	2709	19.4	1	1
2014-03-25 07:58:55.226959	2710	52	2	1
2014-03-25 07:59:34.000045	2711	19.4	1	1
2014-03-25 07:59:34.240102	2712	52	2	1
2014-03-25 08:00:08.800716	2713	482	3	2
2014-03-25 08:00:13.239106	2714	19.4	1	1
2014-03-25 08:00:13.461148	2715	52	2	1
2014-03-25 08:00:20.792412	2716	354	3	2
2014-03-25 08:00:32.802475	2717	354	3	2
2014-03-25 08:00:44.795437	2718	498	3	2
2014-03-25 08:00:52.001704	2719	19.4	1	1
2014-03-25 08:00:52.223734	2720	52	2	1
2014-03-25 08:00:56.852564	2721	498	3	2
2014-03-25 08:01:31.001721	2722	19.4	1	1
2014-03-25 08:01:31.225246	2723	52	2	1
2014-03-25 08:01:44.656969	2724	547	3	2
2014-03-25 08:01:44.967728	2725	547	3	2
2014-03-25 08:02:10.005401	2726	19.5	1	1
2014-03-25 08:02:10.227981	2727	52	2	1
2014-03-25 08:02:32.799599	2728	531	3	2
2014-03-25 08:02:49.002631	2729	19.5	1	1
2014-03-25 08:02:49.224174	2730	52	2	1
2014-03-25 08:03:27.999192	2731	19.5	1	1
2014-03-25 08:03:28.22385	2732	52	2	1
2014-03-25 08:03:32.80052	2733	531	3	2
2014-03-25 08:04:07.002661	2734	19.5	1	1
2014-03-25 08:04:07.227167	2735	52	2	1
2014-03-25 08:04:32.799739	2736	515	3	2
2014-03-25 08:04:46.002735	2737	19.6	1	1
2014-03-25 08:04:46.227441	2738	52	2	1
2014-03-25 08:04:56.821951	2739	402	3	2
2014-03-25 08:05:24.805978	2740	402	3	2
2014-03-25 08:05:25.115481	2741	19.6	1	1
2014-03-25 08:05:25.348543	2742	52	2	1
2014-03-25 08:05:32.800184	2743	402	3	2
2014-03-25 08:06:03.999129	2744	19.6	1	1
2014-03-25 08:06:04.223624	2745	52	2	1
2014-03-25 08:06:32.802778	2746	402	3	2
2014-03-25 08:06:42.996748	2747	19.7	1	1
2014-03-25 08:06:43.219554	2748	52	2	1
2014-03-25 08:07:08.796764	2749	338	3	2
2014-03-25 08:07:20.800527	2750	338	3	2
2014-03-25 08:07:21.999057	2751	19.7	1	1
2014-03-25 08:07:22.24069	2752	52	2	1
2014-03-25 08:07:32.80097	2753	338	3	2
2014-03-25 08:08:00.997079	2754	19.7	1	1
2014-03-25 08:08:01.220753	2755	52	2	1
2014-03-25 08:08:32.799969	2756	338	3	2
2014-03-25 08:08:39.995966	2757	19.8	1	1
2014-03-25 08:08:40.219882	2758	52	2	1
2014-03-25 08:09:18.994121	2759	19.8	1	1
2014-03-25 08:09:19.220286	2760	52	2	1
2014-03-25 08:09:32.798966	2761	338	3	2
2014-03-25 08:09:57.995587	2762	19.8	1	1
2014-03-25 08:09:58.216705	2763	53	2	1
2014-03-25 08:10:32.795615	2764	338	3	2
2014-03-25 08:10:36.996686	2765	19.9	1	1
2014-03-25 08:10:37.236325	2766	53	2	1
2014-03-25 08:11:15.996796	2767	19.9	1	1
2014-03-25 08:11:16.219548	2768	53	2	1
2014-03-25 08:11:32.800554	2769	338	3	2
2014-03-25 08:11:54.997953	2770	19.9	1	1
2014-03-25 08:11:55.221273	2771	53	2	1
2014-03-25 08:12:32.800557	2772	338	3	2
2014-03-25 08:12:33.993696	2773	20.0	1	1
2014-03-25 08:12:34.2266	2774	52	2	1
2014-03-25 08:13:12.996432	2775	20.0	1	1
2014-03-25 08:13:13.220982	2776	52	2	1
2014-03-25 08:13:32.8009	2777	338	3	2
2014-03-25 08:13:44.793677	2778	402	3	2
2014-03-25 08:13:51.994394	2779	20.0	1	1
2014-03-25 08:13:52.21817	2780	52	2	1
2014-03-25 08:13:56.800057	2781	402	3	2
2014-03-25 08:14:30.994918	2782	20.1	1	1
2014-03-25 08:14:31.220779	2783	52	2	1
2014-03-25 08:14:32.797069	2784	370	3	2
2014-03-25 08:14:44.798562	2785	370	3	2
2014-03-25 08:15:08.799584	2786	402	3	2
2014-03-25 08:15:09.991713	2787	20.1	1	1
2014-03-25 08:15:10.225918	2788	52	2	1
2014-03-25 08:15:20.794555	2789	370	3	2
2014-03-25 08:15:32.798808	2790	402	3	2
2014-03-25 08:15:44.794903	2791	402	3	2
2014-03-25 08:15:48.994223	2792	20.1	1	1
2014-03-25 08:15:49.216323	2793	52	2	1
2014-03-25 08:16:27.994305	2794	20.1	1	1
2014-03-25 08:16:28.217074	2795	52	2	1
2014-03-25 08:16:32.799028	2796	402	3	2
2014-03-25 08:17:06.993069	2797	20.2	1	1
2014-03-25 08:17:07.217117	2798	52	2	1
2014-03-25 08:17:32.802082	2799	402	3	2
2014-03-25 08:17:45.990646	2800	20.2	1	1
2014-03-25 08:17:46.214301	2801	52	2	1
2014-03-25 08:18:24.992335	2802	20.2	1	1
2014-03-25 08:18:25.21531	2803	52	2	1
2014-03-25 08:18:32.799689	2804	402	3	2
2014-03-25 08:18:56.800857	2805	338	3	2
2014-03-25 08:19:03.992339	2806	20.2	1	1
2014-03-25 08:19:04.21694	2807	52	2	1
2014-03-25 08:19:08.801667	2808	338	3	2
2014-03-25 08:19:42.797533	2809	338	3	2
2014-03-25 08:19:43.105952	2810	20.3	1	1
2014-03-25 08:19:43.347571	2811	52	2	1
2014-03-25 08:20:21.990926	2812	20.3	1	1
2014-03-25 08:20:22.214317	2813	52	2	1
2014-03-25 08:20:32.797903	2814	338	3	2
2014-03-25 08:21:00.995401	2815	20.3	1	1
2014-03-25 08:21:01.219027	2816	52	2	1
2014-03-25 08:21:32.797125	2817	338	3	2
2014-03-25 08:21:39.991268	2818	20.3	1	1
2014-03-25 08:21:40.215888	2819	52	2	1
2014-03-25 08:22:18.990365	2820	20.4	1	1
2014-03-25 08:22:19.222411	2821	52	2	1
2014-03-25 08:22:32.801943	2822	338	3	2
2014-03-25 08:22:57.990356	2823	20.4	1	1
2014-03-25 08:22:58.21453	2824	52	2	1
2014-03-25 08:23:08.803569	2825	305	3	2
2014-03-25 08:23:20.800275	2826	305	3	2
2014-03-25 08:23:32.800096	2827	305	3	2
2014-03-25 08:23:36.990153	2828	20.4	1	1
2014-03-25 08:23:37.212985	2829	52	2	1
2014-03-25 08:24:15.992011	2830	20.4	1	1
2014-03-25 08:24:16.227398	2831	52	2	1
2014-03-25 08:24:32.798965	2832	305	3	2
2014-03-25 08:24:54.992649	2833	20.4	1	1
2014-03-25 08:24:55.237796	2834	52	2	1
2014-03-25 08:25:20.795838	2835	370	3	2
2014-03-25 08:25:32.797742	2836	370	3	2
2014-03-25 08:25:33.996264	2837	20.4	1	1
2014-03-25 08:25:34.230905	2838	52	2	1
2014-03-25 08:26:12.990016	2839	20.4	1	1
2014-03-25 08:26:13.213134	2840	52	2	1
2014-03-25 08:26:32.797514	2841	370	3	2
2014-03-25 08:26:51.984127	2842	20.5	1	1
2014-03-25 08:26:52.20532	2843	52	2	1
2014-03-25 08:27:08.795531	2844	515	3	2
2014-03-25 08:27:20.797694	2845	466	3	2
2014-03-25 08:27:30.985153	2846	20.5	1	1
2014-03-25 08:27:31.207473	2847	52	2	1
2014-03-25 08:27:32.797724	2848	466	3	2
2014-03-25 08:28:09.989046	2849	20.5	1	1
2014-03-25 08:28:10.214123	2850	52	2	1
2014-03-25 08:28:32.796947	2851	466	3	2
2014-03-25 08:28:48.984126	2852	20.5	1	1
2014-03-25 08:28:49.205853	2853	52	2	1
2014-03-25 08:29:27.988053	2854	20.5	1	1
2014-03-25 08:29:28.221365	2855	52	2	1
2014-03-25 08:29:32.795686	2856	482	3	2
2014-03-25 08:30:06.986495	2857	20.5	1	1
2014-03-25 08:30:07.209849	2858	52	2	1
2014-03-25 08:30:08.795971	2859	418	3	2
2014-03-25 08:30:32.654824	2860	418	3	2
2014-03-25 08:30:32.969934	2861	418	3	2
2014-03-25 08:30:45.988853	2862	20.5	1	1
2014-03-25 08:30:46.21789	2863	52	2	1
2014-03-25 08:31:08.800202	2864	1625	3	2
2014-03-25 08:31:24.791738	2865	1625	3	2
2014-03-25 08:31:25.102042	2866	20.5	1	1
2014-03-25 08:31:25.327245	2867	52	2	1
2014-03-25 08:31:32.800104	2868	4329	3	2
2014-03-25 08:31:44.798018	2869	4313	3	2
2014-03-25 08:32:03.986727	2870	20.5	1	1
2014-03-25 08:32:04.209657	2871	52	2	1
2014-03-25 08:32:08.798252	2872	4281	3	2
2014-03-25 08:32:20.798219	2873	3138	3	2
2014-03-25 08:32:32.798827	2874	3171	3	2
2014-03-25 08:32:42.982898	2875	20.5	1	1
2014-03-25 08:32:43.229642	2876	52	2	1
2014-03-25 08:32:44.797055	2877	4297	3	2
2014-03-25 08:32:56.800261	2878	3138	3	2
2014-03-25 08:33:08.800371	2879	3138	3	2
2014-03-25 08:33:21.983178	2880	20.5	1	1
2014-03-25 08:33:22.208808	2881	52	2	1
2014-03-25 08:33:32.795072	2882	3154	3	2
2014-03-25 08:33:44.79874	2883	4297	3	2
2014-03-25 08:33:56.797297	2884	3154	3	2
2014-03-25 08:34:00.985649	2885	20.5	1	1
2014-03-25 08:34:01.208784	2886	52	2	1
2014-03-25 08:34:08.79847	2887	3171	3	2
2014-03-25 08:34:32.793089	2888	3219	3	2
2014-03-25 08:34:39.979992	2889	20.5	1	1
2014-03-25 08:34:40.212936	2890	52	2	1
2014-03-25 08:34:44.796467	2891	3235	3	2
2014-03-25 08:35:08.792303	2892	659	3	2
2014-03-25 08:35:18.982461	2893	20.5	1	1
2014-03-25 08:35:19.217994	2894	52	2	1
2014-03-25 08:35:20.796	2895	1835	3	2
2014-03-25 08:35:32.798484	2896	676	3	2
2014-03-25 08:35:44.797454	2897	643	3	2
2014-03-25 08:35:56.796711	2898	676	3	2
2014-03-25 08:35:57.990684	2899	20.5	1	1
2014-03-25 08:35:58.215893	2900	52	2	1
2014-03-25 08:36:08.795755	2901	676	3	2
2014-03-25 08:36:32.800339	2902	724	3	2
2014-03-25 08:36:36.981955	2903	20.5	1	1
2014-03-25 08:36:37.204094	2904	52	2	1
2014-03-25 08:36:44.797205	2905	724	3	2
2014-03-25 08:37:15.984762	2906	20.5	1	1
2014-03-25 08:37:16.207321	2907	52	2	1
2014-03-25 08:37:32.79597	2908	1931	3	2
2014-03-25 08:37:44.794241	2909	724	3	2
2014-03-25 08:37:54.978868	2910	20.5	1	1
2014-03-25 08:37:55.202962	2911	52	2	1
2014-03-25 08:37:56.794652	2912	708	3	2
2014-03-25 08:38:32.796578	2913	708	3	2
2014-03-25 08:38:33.984148	2914	20.5	1	1
2014-03-25 08:38:34.205719	2915	52	2	1
2014-03-25 08:39:12.983947	2916	20.5	1	1
2014-03-25 08:39:13.217133	2917	52	2	1
2014-03-25 08:39:32.799317	2918	708	3	2
2014-03-25 08:39:51.987533	2919	20.5	1	1
2014-03-25 08:39:52.211957	2920	52	2	1
2014-03-25 08:40:30.982056	2921	20.6	1	1
2014-03-25 08:40:31.205189	2922	52	2	1
2014-03-25 08:40:32.801147	2923	724	3	2
2014-03-25 08:40:44.797761	2924	659	3	2
2014-03-25 08:40:56.799143	2925	643	3	2
2014-03-25 08:41:09.982928	2926	20.6	1	1
2014-03-25 08:41:10.208172	2927	52	2	1
2014-03-25 08:41:32.798195	2928	643	3	2
2014-03-25 08:41:48.983464	2929	20.6	1	1
2014-03-25 08:41:49.204844	2930	52	2	1
2014-03-25 08:42:08.800769	2931	595	3	2
2014-03-25 08:42:20.795893	2932	611	3	2
2014-03-25 08:42:28.040705	2933	20.6	1	1
2014-03-25 08:42:28.264253	2934	52	2	1
2014-03-25 08:42:32.801973	2935	595	3	2
2014-03-25 08:43:06.980584	2936	20.6	1	1
2014-03-25 08:43:07.215824	2937	52	2	1
2014-03-25 08:43:32.796704	2938	595	3	2
2014-03-25 08:43:45.979766	2939	20.6	1	1
2014-03-25 08:43:46.204121	2940	52	2	1
2014-03-25 08:44:08.799885	2941	482	3	2
2014-03-25 08:44:20.796608	2942	482	3	2
2014-03-25 08:44:24.977975	2943	20.6	1	1
2014-03-25 08:44:25.210051	2944	52	2	1
2014-03-25 08:44:32.797425	2945	498	3	2
2014-03-25 08:45:03.984234	2946	20.6	1	1
2014-03-25 08:45:04.20744	2947	52	2	1
2014-03-25 08:45:08.797111	2948	1625	3	2
2014-03-25 08:45:20.798451	2949	482	3	2
2014-03-25 08:45:32.795523	2950	482	3	2
2014-03-25 08:45:42.978214	2951	20.6	1	1
2014-03-25 08:45:43.200711	2952	52	2	1
2014-03-25 08:46:21.979758	2953	20.6	1	1
2014-03-25 08:46:22.214217	2954	52	2	1
2014-03-25 08:46:32.795416	2955	466	3	2
2014-03-25 08:47:00.979452	2956	20.6	1	1
2014-03-25 08:47:01.204237	2957	52	2	1
2014-03-25 08:47:32.797201	2958	450	3	2
2014-03-25 08:47:39.980139	2959	20.6	1	1
2014-03-25 08:47:40.205039	2960	52	2	1
2014-03-25 08:48:18.98181	2961	20.6	1	1
2014-03-25 08:48:19.216846	2962	52	2	1
2014-03-25 08:48:32.793987	2963	498	3	2
2014-03-25 08:48:44.797844	2964	498	3	2
2014-03-25 08:48:56.805114	2965	531	3	2
2014-03-25 08:48:57.972086	2966	20.6	1	1
2014-03-25 08:48:58.199165	2967	52	2	1
2014-03-25 08:49:08.795607	2968	531	3	2
2014-03-25 08:49:32.801577	2969	498	3	2
2014-03-25 08:49:36.974788	2970	20.6	1	1
2014-03-25 08:49:37.199609	2971	52	2	1
2014-03-25 08:49:44.797253	2972	1641	3	2
2014-03-25 08:50:08.652579	2973	482	3	2
2014-03-25 08:50:08.96356	2974	498	3	2
2014-03-25 08:50:15.975293	2975	20.6	1	1
2014-03-25 08:50:16.207343	2976	52	2	1
2014-03-25 08:50:32.796044	2977	498	3	2
2014-03-25 08:50:54.977853	2978	20.6	1	1
2014-03-25 08:50:55.200199	2979	52	2	1
2014-03-25 08:51:32.793543	2980	515	3	2
2014-03-25 08:51:33.978231	2981	20.6	1	1
2014-03-25 08:51:34.204041	2982	52	2	1
2014-03-25 08:52:12.975139	2983	20.6	1	1
2014-03-25 08:52:13.209703	2984	52	2	1
2014-03-25 08:52:20.796273	2985	482	3	2
2014-03-25 08:52:32.79848	2986	498	3	2
2014-03-25 08:52:51.973729	2987	20.6	1	1
2014-03-25 08:52:52.212104	2988	52	2	1
2014-03-25 08:53:30.97555	2989	20.6	1	1
2014-03-25 08:53:31.200872	2990	52	2	1
2014-03-25 08:53:32.79577	2991	515	3	2
2014-03-25 08:54:09.96997	2992	20.6	1	1
2014-03-25 08:54:10.193936	2993	52	2	1
2014-03-25 08:54:20.797614	2994	450	3	2
2014-03-25 08:54:32.796032	2995	450	3	2
2014-03-25 08:54:48.972901	2996	20.6	1	1
2014-03-25 08:54:49.197023	2997	52	2	1
2014-03-25 08:55:20.797376	2998	1609	3	2
2014-03-25 08:55:27.972509	2999	20.6	1	1
2014-03-25 08:55:28.485999	3000	52	2	1
2014-03-25 08:55:32.796606	3001	450	3	2
2014-03-25 08:55:44.794953	3002	450	3	2
2014-03-25 08:56:06.973555	3003	20.6	1	1
2014-03-25 08:56:07.243832	3004	52	2	1
2014-03-25 08:56:32.7957	3005	450	3	2
2014-03-25 08:56:45.972106	3006	20.6	1	1
2014-03-25 08:56:46.19703	3007	52	2	1
2014-03-25 08:57:24.970799	3008	20.6	1	1
2014-03-25 08:57:25.196492	3009	52	2	1
2014-03-25 08:57:32.793846	3010	466	3	2
2014-03-25 08:58:03.977194	3011	20.6	1	1
2014-03-25 08:58:04.219428	3012	52	2	1
2014-03-25 08:58:32.794925	3013	450	3	2
2014-03-25 08:58:42.9709	3014	20.6	1	1
2014-03-25 08:58:43.194956	3015	52	2	1
2014-03-25 08:59:21.971218	3016	20.6	1	1
2014-03-25 08:59:22.195116	3017	52	2	1
2014-03-25 08:59:32.793011	3018	547	3	2
2014-03-25 08:59:44.795753	3019	676	3	2
2014-03-25 08:59:56.795974	3020	659	3	2
2014-03-25 09:00:00.970798	3021	20.6	1	1
2014-03-25 09:00:01.206802	3022	52	2	1
2014-03-25 09:00:08.796491	3023	579	3	2
2014-03-25 09:00:20.796714	3024	547	3	2
2014-03-25 09:00:32.795674	3025	4378	3	2
2014-03-25 09:00:39.970428	3026	20.6	1	1
2014-03-25 09:00:40.193013	3027	52	2	1
2014-03-25 09:00:44.800479	3028	3348	3	2
2014-03-25 09:00:56.796385	3029	3171	3	2
2014-03-25 09:01:08.79627	3030	4329	3	2
2014-03-25 09:01:18.973984	3031	20.6	1	1
2014-03-25 09:01:19.206114	3032	52	2	1
2014-03-25 09:01:20.796055	3033	3154	3	2
2014-03-25 09:01:44.654105	3034	627	3	2
2014-03-25 09:01:44.966464	3035	611	3	2
2014-03-25 09:01:56.79498	3036	659	3	2
2014-03-25 09:01:57.969008	3037	20.5	1	1
2014-03-25 09:01:58.191495	3038	52	2	1
2014-03-25 09:02:08.79469	3039	1738	3	2
2014-03-25 09:02:20.795115	3040	1738	3	2
2014-03-25 09:02:32.794874	3041	611	3	2
2014-03-25 09:02:36.969849	3042	20.5	1	1
2014-03-25 09:02:37.203579	3043	52	2	1
2014-03-25 09:02:44.796468	3044	482	3	2
2014-03-25 09:02:56.797001	3045	482	3	2
2014-03-25 09:03:15.96815	3046	20.5	1	1
2014-03-25 09:03:16.192654	3047	52	2	1
2014-03-25 09:03:20.794952	3048	1641	3	2
2014-03-25 09:03:32.794416	3049	482	3	2
2014-03-25 09:03:44.796467	3050	482	3	2
2014-03-25 09:03:54.965251	3051	20.5	1	1
2014-03-25 09:03:55.18961	3052	52	2	1
2014-03-25 09:04:20.794254	3053	434	3	2
2014-03-25 09:04:32.79562	3054	434	3	2
2014-03-25 09:04:33.972765	3055	20.5	1	1
2014-03-25 09:04:34.194891	3056	52	2	1
2014-03-25 09:04:56.797766	3057	1625	3	2
2014-03-25 09:05:08.7925	3058	450	3	2
2014-03-25 09:05:12.965569	3059	20.5	1	1
2014-03-25 09:05:13.196998	3060	52	2	1
2014-03-25 09:05:20.794936	3061	434	3	2
2014-03-25 09:05:32.796512	3062	450	3	2
2014-03-25 09:05:51.967164	3063	20.5	1	1
2014-03-25 09:05:52.200691	3064	52	2	1
2014-03-25 09:05:56.800174	3065	402	3	2
2014-03-25 09:06:08.795225	3066	402	3	2
2014-03-25 09:06:30.968247	3067	20.5	1	1
2014-03-25 09:06:31.201629	3068	52	2	1
2014-03-25 09:06:32.796441	3069	402	3	2
2014-03-25 09:06:44.796534	3070	434	3	2
2014-03-25 09:06:56.79369	3071	434	3	2
2014-03-25 09:07:09.96329	3072	20.5	1	1
2014-03-25 09:07:10.187377	3073	52	2	1
2014-03-25 09:07:20.796727	3074	370	3	2
2014-03-25 09:07:32.794844	3075	434	3	2
2014-03-25 09:07:44.795387	3076	418	3	2
2014-03-25 09:07:48.970078	3077	20.6	1	1
2014-03-25 09:07:49.194033	3078	52	2	1
2014-03-25 09:07:56.796496	3079	1593	3	2
2014-03-25 09:08:08.796581	3080	418	3	2
2014-03-25 09:08:20.796672	3081	515	3	2
2014-03-25 09:08:27.965731	3082	20.6	1	1
2014-03-25 09:08:28.190864	3083	52	2	1
2014-03-25 09:08:32.797808	3084	498	3	2
2014-03-25 09:09:06.971043	3085	20.6	1	1
2014-03-25 09:09:07.194239	3086	52	2	1
2014-03-25 09:09:32.793969	3087	498	3	2
2014-03-25 09:09:45.965283	3088	20.5	1	1
2014-03-25 09:09:46.196979	3089	52	2	1
2014-03-25 09:10:24.968962	3090	20.5	1	1
2014-03-25 09:10:25.191434	3091	52	2	1
2014-03-25 09:10:32.790821	3092	547	3	2
2014-03-25 09:10:44.788688	3093	515	3	2
2014-03-25 09:10:56.79684	3094	434	3	2
2014-03-25 09:11:03.964172	3095	20.5	1	1
2014-03-25 09:11:04.196784	3096	52	2	1
2014-03-25 09:11:08.795677	3097	418	3	2
2014-03-25 09:11:32.798291	3098	402	3	2
2014-03-25 09:11:42.965691	3099	20.5	1	1
2014-03-25 09:11:43.198489	3100	52	2	1
2014-03-25 09:11:56.795967	3101	1480	3	2
2014-03-25 09:12:08.79657	3102	402	3	2
2014-03-25 09:12:20.793332	3103	450	3	2
2014-03-25 09:12:21.965144	3104	20.5	1	1
2014-03-25 09:12:22.187962	3105	52	2	1
2014-03-25 09:12:32.796178	3106	450	3	2
2014-03-25 09:13:00.96249	3107	20.5	1	1
2014-03-25 09:13:01.200047	3108	52	2	1
2014-03-25 09:13:32.794105	3109	434	3	2
2014-03-25 09:13:39.961854	3110	20.5	1	1
2014-03-25 09:13:40.186811	3111	52	2	1
2014-03-25 09:14:18.963724	3112	20.5	1	1
2014-03-25 09:14:19.186604	3113	52	2	1
2014-03-25 09:14:32.923265	3114	434	3	2
2014-03-25 09:14:57.962538	3115	20.5	1	1
2014-03-25 09:14:58.197346	3116	52	2	1
2014-03-25 09:15:32.79405	3117	434	3	2
2014-03-25 09:15:36.961037	3118	20.5	1	1
2014-03-25 09:15:37.18455	3119	52	2	1
2014-03-25 09:16:08.791637	3120	515	3	2
2014-03-25 09:16:15.964423	3121	20.5	1	1
2014-03-25 09:16:16.188062	3122	52	2	1
2014-03-25 09:16:20.797757	3123	498	3	2
2014-03-25 09:16:32.796794	3124	1657	3	2
2014-03-25 09:16:44.795268	3125	498	3	2
2014-03-25 09:16:54.959265	3126	20.5	1	1
2014-03-25 09:16:55.19435	3127	52	2	1
2014-03-25 09:16:56.794433	3128	515	3	2
2014-03-25 09:17:32.65273	3129	482	3	2
2014-03-25 09:17:32.962057	3130	515	3	2
2014-03-25 09:17:33.963829	3131	20.5	1	1
2014-03-25 09:17:34.19244	3132	52	2	1
2014-03-25 09:17:44.795831	3133	515	3	2
2014-03-25 09:18:08.795241	3134	466	3	2
2014-03-25 09:18:12.960152	3135	20.5	1	1
2014-03-25 09:18:13.184044	3136	52	2	1
2014-03-25 09:18:20.796844	3137	466	3	2
2014-03-25 09:18:32.792963	3138	466	3	2
2014-03-25 09:18:51.96335	3139	20.5	1	1
2014-03-25 09:18:52.187284	3140	52	2	1
2014-03-25 09:19:30.963967	3141	20.5	1	1
2014-03-25 09:19:31.185771	3142	52	2	1
2014-03-25 09:19:32.795998	3143	466	3	2
2014-03-25 09:20:09.965635	3144	20.5	1	1
2014-03-25 09:20:10.189006	3145	52	2	1
2014-03-25 09:20:32.79812	3146	450	3	2
2014-03-25 09:20:48.966404	3147	20.5	1	1
2014-03-25 09:20:49.189817	3148	52	2	1
2014-03-25 09:21:27.964652	3149	20.4	1	1
2014-03-25 09:21:28.187777	3150	52	2	1
2014-03-25 09:21:32.794741	3151	466	3	2
2014-03-25 09:21:44.80041	3152	1625	3	2
2014-03-25 09:21:56.798923	3153	450	3	2
2014-03-25 09:22:06.965861	3154	20.4	1	1
2014-03-25 09:22:07.191264	3155	52	2	1
2014-03-25 09:22:08.797058	3156	450	3	2
2014-03-25 09:22:32.793806	3157	450	3	2
2014-03-25 09:22:45.964187	3158	20.4	1	1
2014-03-25 09:22:46.191083	3159	52	2	1
2014-03-25 09:23:24.96292	3160	20.4	1	1
2014-03-25 09:23:25.198848	3161	52	2	1
2014-03-25 09:23:32.796231	3162	450	3	2
2014-03-25 09:24:03.960877	3163	20.4	1	1
2014-03-25 09:24:04.18445	3164	52	2	1
2014-03-25 09:24:32.794074	3165	450	3	2
2014-03-25 09:24:42.963685	3166	20.4	1	1
2014-03-25 09:24:43.185843	3167	52	2	1
2014-03-25 09:24:44.796614	3168	482	3	2
2014-03-25 09:24:56.796503	3169	482	3	2
2014-03-25 09:25:21.96002	3170	20.4	1	1
2014-03-25 09:25:22.184324	3171	52	2	1
2014-03-25 09:25:32.793158	3172	482	3	2
2014-03-25 09:26:00.965368	3173	20.4	1	1
2014-03-25 09:26:01.190363	3174	52	2	1
2014-03-25 09:26:32.795973	3175	498	3	2
2014-03-25 09:26:39.958275	3176	20.4	1	1
2014-03-25 09:26:40.181965	3177	52	2	1
2014-03-25 09:26:56.79544	3178	1641	3	2
2014-03-25 09:27:08.801749	3179	498	3	2
2014-03-25 09:27:18.962766	3180	20.4	1	1
2014-03-25 09:27:19.381367	3181	52	2	1
2014-03-25 09:27:20.798121	3182	498	3	2
2014-03-25 09:27:32.79874	3183	498	3	2
2014-03-25 09:27:57.960407	3184	20.3	1	1
2014-03-25 09:27:58.184277	3185	52	2	1
2014-03-25 09:28:32.793808	3186	482	3	2
2014-03-25 09:28:36.963956	3187	20.3	1	1
2014-03-25 09:28:37.186237	3188	52	2	1
2014-03-25 09:29:08.79422	3189	515	3	2
2014-03-25 09:29:15.949203	3190	20.3	1	1
2014-03-25 09:29:16.174159	3191	52	2	1
2014-03-25 09:29:20.793247	3192	498	3	2
2014-03-25 09:29:32.793975	3193	434	3	2
2014-03-25 09:29:44.794282	3194	450	3	2
2014-03-25 09:29:54.95022	3195	20.3	1	1
2014-03-25 09:29:55.173582	3196	52	2	1
2014-03-25 09:30:08.790087	3197	418	3	2
2014-03-25 09:30:20.790763	3198	402	3	2
2014-03-25 09:30:32.79393	3199	418	3	2
2014-03-25 09:30:34.193692	3200	20.3	1	1
2014-03-25 09:30:34.426969	3201	52	2	1
2014-03-25 09:31:12.951811	3202	20.3	1	1
2014-03-25 09:31:13.17531	3203	52	2	1
2014-03-25 09:31:32.792634	3204	402	3	2
2014-03-25 09:31:51.960549	3205	20.3	1	1
2014-03-25 09:31:52.18388	3206	52	2	1
2014-03-25 09:32:20.795411	3207	1480	3	2
2014-03-25 09:32:30.952539	3208	20.3	1	1
2014-03-25 09:32:31.176093	3209	51	2	1
2014-03-25 09:32:32.797578	3210	402	3	2
2014-03-25 09:32:44.792073	3211	370	3	2
2014-03-25 09:32:56.793296	3212	402	3	2
2014-03-25 09:33:08.791281	3213	402	3	2
2014-03-25 09:33:09.950636	3214	20.3	1	1
2014-03-25 09:33:10.183182	3215	51	2	1
2014-03-25 09:33:32.79255	3216	402	3	2
2014-03-25 09:33:48.95367	3217	20.3	1	1
2014-03-25 09:33:49.1937	3218	51	2	1
2014-03-25 09:34:08.791203	3219	370	3	2
2014-03-25 09:34:20.790347	3220	418	3	2
2014-03-25 09:34:27.949976	3221	20.3	1	1
2014-03-25 09:34:28.183507	3222	51	2	1
2014-03-25 09:34:32.791911	3223	418	3	2
2014-03-25 09:35:06.947628	3224	20.3	1	1
2014-03-25 09:35:07.169427	3225	51	2	1
2014-03-25 09:35:32.789688	3226	418	3	2
2014-03-25 09:35:46.188913	3227	20.2	1	1
2014-03-25 09:35:46.41246	3228	51	2	1
2014-03-25 09:36:24.948286	3229	20.2	1	1
2014-03-25 09:36:25.17091	3230	51	2	1
2014-03-25 09:36:32.78913	3231	418	3	2
2014-03-25 09:36:44.791209	3232	450	3	2
2014-03-25 09:36:56.793881	3233	450	3	2
2014-03-25 09:37:03.950701	3234	20.2	1	1
2014-03-25 09:37:04.182363	3235	51	2	1
2014-03-25 09:37:32.790776	3236	450	3	2
2014-03-25 09:37:42.945443	3237	20.2	1	1
2014-03-25 09:37:43.170294	3238	51	2	1
2014-03-25 09:37:44.794595	3239	1609	3	2
2014-03-25 09:37:56.79175	3240	466	3	2
2014-03-25 09:38:08.791425	3241	450	3	2
2014-03-25 09:38:21.94818	3242	20.2	1	1
2014-03-25 09:38:22.1691	3243	51	2	1
2014-03-25 09:38:32.793308	3244	450	3	2
2014-03-25 09:39:00.949433	3245	20.2	1	1
2014-03-25 09:39:01.18304	3246	51	2	1
2014-03-25 09:39:32.789383	3247	450	3	2
2014-03-25 09:39:39.947651	3248	20.2	1	1
2014-03-25 09:39:40.172463	3249	51	2	1
2014-03-25 09:40:18.948287	3250	20.2	1	1
2014-03-25 09:40:19.17266	3251	51	2	1
2014-03-25 09:40:32.791997	3252	450	3	2
2014-03-25 09:40:57.94792	3253	20.2	1	1
2014-03-25 09:40:58.178286	3254	51	2	1
2014-03-25 09:41:32.792298	3255	450	3	2
2014-03-25 09:41:36.943325	3256	20.2	1	1
2014-03-25 09:41:37.165295	3257	51	2	1
2014-03-25 09:41:56.790819	3258	418	3	2
2014-03-25 09:42:08.791558	3259	402	3	2
2014-03-25 09:42:15.950055	3260	20.2	1	1
2014-03-25 09:42:16.171941	3261	51	2	1
2014-03-25 09:42:32.792527	3262	418	3	2
2014-03-25 09:42:54.947214	3263	20.2	1	1
2014-03-25 09:42:55.172783	3264	51	2	1
2014-03-25 09:43:08.795668	3265	1496	3	2
2014-03-25 09:43:20.79404	3266	418	3	2
2014-03-25 09:43:32.792376	3267	402	3	2
2014-03-25 09:43:33.942726	3268	20.2	1	1
2014-03-25 09:43:34.174879	3269	51	2	1
2014-03-25 09:43:44.792233	3270	370	3	2
2014-03-25 09:43:56.789731	3271	370	3	2
2014-03-25 09:44:12.942449	3272	20.2	1	1
2014-03-25 09:44:13.175915	3273	51	2	1
2014-03-25 09:44:32.790701	3274	370	3	2
2014-03-25 09:44:51.942528	3275	20.2	1	1
2014-03-25 09:44:52.166621	3276	51	2	1
2014-03-25 09:45:30.941355	3277	20.2	1	1
2014-03-25 09:45:31.165618	3278	51	2	1
2014-03-25 09:45:32.790933	3279	370	3	2
2014-03-25 09:46:09.942935	3280	20.2	1	1
2014-03-25 09:46:10.175469	3281	51	2	1
2014-03-25 09:46:32.788863	3282	370	3	2
2014-03-25 09:46:44.789554	3283	402	3	2
2014-03-25 09:46:48.943273	3284	20.2	1	1
2014-03-25 09:46:49.177565	3285	51	2	1
2014-03-25 09:47:08.647946	3286	370	3	2
2014-03-25 09:47:08.953332	3287	370	3	2
2014-03-25 09:47:20.787472	3288	402	3	2
2014-03-25 09:47:27.938137	3289	20.2	1	1
2014-03-25 09:47:28.15988	3290	51	2	1
2014-03-25 09:47:32.789006	3291	370	3	2
2014-03-25 09:47:44.788056	3292	354	3	2
2014-03-25 09:48:06.940577	3293	20.2	1	1
2014-03-25 09:48:07.164021	3294	51	2	1
2014-03-25 09:48:20.789304	3295	1577	3	2
2014-03-25 09:48:32.789458	3296	418	3	2
2014-03-25 09:48:44.792301	3297	418	3	2
2014-03-25 09:48:45.942715	3298	20.2	1	1
2014-03-25 09:48:46.175526	3299	51	2	1
2014-03-25 09:49:24.943489	3300	20.2	1	1
2014-03-25 09:49:25.165407	3301	51	2	1
2014-03-25 09:49:32.792078	3302	418	3	2
2014-03-25 09:50:03.937846	3303	20.2	1	1
2014-03-25 09:50:04.163613	3304	51	2	1
2014-03-25 09:50:42.745584	3305	402	3	2
2014-03-25 09:50:43.063585	3306	20.2	1	1
2014-03-25 09:50:43.28725	3307	51	2	1
2014-03-25 09:51:21.942164	3308	20.2	1	1
2014-03-25 09:51:22.164305	3309	51	2	1
2014-03-25 09:51:32.789263	3310	402	3	2
2014-03-25 09:52:00.935226	3311	20.1	1	1
2014-03-25 09:52:01.157259	3312	51	2	1
2014-03-25 09:52:32.790148	3313	402	3	2
2014-03-25 09:52:39.941085	3314	20.1	1	1
2014-03-25 09:52:40.165227	3315	51	2	1
2014-03-25 09:53:18.942046	3316	20.1	1	1
2014-03-25 09:53:19.174187	3317	51	2	1
2014-03-25 09:53:32.789695	3318	434	3	2
2014-03-25 09:53:44.78977	3319	1464	3	2
2014-03-25 09:53:56.789479	3320	370	3	2
2014-03-25 09:53:57.936437	3321	20.1	1	1
2014-03-25 09:53:58.16001	3322	51	2	1
2014-03-25 09:54:32.648003	3323	370	3	2
2014-03-25 09:54:32.966391	3324	370	3	2
2014-03-25 09:54:36.937618	3325	20.1	1	1
2014-03-25 09:54:37.160459	3326	51	2	1
2014-03-25 09:55:15.939809	3327	20.1	1	1
2014-03-25 09:55:16.172343	3328	51	2	1
2014-03-25 09:55:32.786581	3329	370	3	2
2014-03-25 09:55:44.791124	3330	402	3	2
2014-03-25 09:55:54.936588	3331	20.1	1	1
2014-03-25 09:55:55.173457	3332	51	2	1
2014-03-25 09:55:56.787977	3333	370	3	2
2014-03-25 09:56:08.788989	3334	354	3	2
2014-03-25 09:56:32.790966	3335	370	3	2
2014-03-25 09:56:33.934273	3336	20.1	1	1
2014-03-25 09:56:34.163234	3337	51	2	1
2014-03-25 09:57:12.941616	3338	20.1	1	1
2014-03-25 09:57:13.165238	3339	51	2	1
2014-03-25 09:57:32.791365	3340	402	3	2
2014-03-25 09:57:44.788014	3341	370	3	2
2014-03-25 09:57:51.935672	3342	20.1	1	1
2014-03-25 09:57:52.168319	3343	51	2	1
2014-03-25 09:58:30.740797	3344	370	3	2
2014-03-25 09:58:31.048638	3345	20.1	1	1
2014-03-25 09:58:31.272305	3346	51	2	1
2014-03-25 09:58:32.786014	3347	370	3	2
2014-03-25 09:59:08.790267	3348	1464	3	2
2014-03-25 09:59:09.93257	3349	20.1	1	1
2014-03-25 09:59:10.167879	3350	51	2	1
2014-03-25 09:59:20.790513	3351	354	3	2
2014-03-25 09:59:32.791339	3352	370	3	2
2014-03-25 09:59:48.933204	3353	20.1	1	1
2014-03-25 09:59:49.166627	3354	51	2	1
2014-03-25 10:00:08.788646	3355	434	3	2
2014-03-25 10:00:20.790745	3356	434	3	2
2014-03-25 10:00:27.934774	3357	20.1	1	1
2014-03-25 10:00:28.167343	3358	51	2	1
2014-03-25 10:00:32.787555	3359	418	3	2
2014-03-25 10:01:06.93406	3360	20.1	1	1
2014-03-25 10:01:07.158565	3361	51	2	1
2014-03-25 10:01:32.787346	3362	434	3	2
2014-03-25 10:01:45.935491	3363	20.1	1	1
2014-03-25 10:01:46.162055	3364	51	2	1
2014-03-25 10:02:24.933067	3365	20.0	1	1
2014-03-25 10:02:25.157241	3366	51	2	1
2014-03-25 10:02:32.789944	3367	434	3	2
2014-03-25 10:02:56.785728	3368	402	3	2
2014-03-25 10:03:03.929808	3369	20.0	1	1
2014-03-25 10:03:04.154898	3370	51	2	1
2014-03-25 10:03:08.789875	3371	418	3	2
2014-03-25 10:03:32.782817	3372	418	3	2
2014-03-25 10:03:42.938042	3373	20.0	1	1
2014-03-25 10:03:43.160419	3374	51	2	1
2014-03-25 10:03:44.792206	3375	498	3	2
2014-03-25 10:03:56.789491	3376	498	3	2
2014-03-25 10:04:21.941896	3377	20.0	1	1
2014-03-25 10:04:22.173134	3378	51	2	1
2014-03-25 10:04:32.790672	3379	1641	3	2
2014-03-25 10:04:44.79457	3380	498	3	2
2014-03-25 10:04:56.792271	3381	498	3	2
2014-03-25 10:05:00.940421	3382	20.0	1	1
2014-03-25 10:05:01.163325	3383	51	2	1
2014-03-25 10:05:32.791938	3384	466	3	2
2014-03-25 10:05:39.936308	3385	20.0	1	1
2014-03-25 10:05:40.157452	3386	51	2	1
2014-03-25 10:05:44.787737	3387	450	3	2
2014-03-25 10:06:08.646234	3388	498	3	2
2014-03-25 10:06:08.954862	3389	370	3	2
2014-03-25 10:06:18.932435	3390	20.0	1	1
2014-03-25 10:06:19.166206	3391	51	2	1
2014-03-25 10:06:20.790702	3392	370	3	2
2014-03-25 10:06:32.785214	3393	370	3	2
2014-03-25 10:06:57.929337	3394	20.0	1	1
2014-03-25 10:06:58.162161	3395	51	2	1
2014-03-25 10:07:32.788781	3396	370	3	2
2014-03-25 10:07:36.955515	3397	20.0	1	1
2014-03-25 10:07:37.835426	3398	51	2	1
2014-03-25 10:08:15.928994	3399	20.0	1	1
2014-03-25 10:08:16.151577	3400	51	2	1
2014-03-25 10:08:32.78572	3401	434	3	2
2014-03-25 10:08:44.788405	3402	434	3	2
2014-03-25 10:08:54.926809	3403	20.0	1	1
2014-03-25 10:08:55.149525	3404	51	2	1
2014-03-25 10:09:32.785229	3405	418	3	2
2014-03-25 10:09:33.932041	3406	19.9	1	1
2014-03-25 10:09:34.165816	3407	51	2	1
2014-03-25 10:10:08.78615	3408	1577	3	2
2014-03-25 10:10:12.926691	3409	19.9	1	1
2014-03-25 10:10:13.148825	3410	51	2	1
2014-03-25 10:10:20.792192	3411	434	3	2
2014-03-25 10:10:32.788846	3412	434	3	2
2014-03-25 10:10:51.931302	3413	19.9	1	1
2014-03-25 10:10:52.16379	3414	51	2	1
2014-03-25 10:11:30.934257	3415	19.9	1	1
2014-03-25 10:11:31.157586	3416	51	2	1
2014-03-25 10:11:32.785355	3417	418	3	2
2014-03-25 10:11:56.78567	3418	466	3	2
2014-03-25 10:12:08.784432	3419	466	3	2
2014-03-25 10:12:09.969584	3420	19.9	1	1
2014-03-25 10:12:10.203439	3421	51	2	1
2014-03-25 10:12:32.785595	3422	466	3	2
2014-03-25 10:12:48.928289	3423	19.9	1	1
2014-03-25 10:12:49.15103	3424	51	2	1
2014-03-25 10:13:27.924691	3425	19.9	1	1
2014-03-25 10:13:28.147525	3426	51	2	1
2014-03-25 10:13:32.786207	3427	466	3	2
2014-03-25 10:14:06.92797	3428	19.9	1	1
2014-03-25 10:14:07.177112	3429	51	2	1
2014-03-25 10:14:32.785582	3430	466	3	2
2014-03-25 10:14:45.924305	3431	19.9	1	1
2014-03-25 10:14:46.147451	3432	51	2	1
2014-03-25 10:15:24.915932	3433	19.9	1	1
2014-03-25 10:15:25.14144	3434	51	2	1
2014-03-25 10:15:32.788293	3435	1625	3	2
2014-03-25 10:15:44.788454	3436	466	3	2
2014-03-25 10:15:56.787921	3437	466	3	2
2014-03-25 10:16:03.922668	3438	20.0	1	1
2014-03-25 10:16:04.145044	3439	51	2	1
2014-03-25 10:16:32.783053	3440	466	3	2
2014-03-25 10:16:42.927207	3441	20.0	1	1
2014-03-25 10:16:43.149843	3442	51	2	1
2014-03-25 10:17:20.787297	3443	418	3	2
2014-03-25 10:17:21.925361	3444	20.0	1	1
2014-03-25 10:17:22.149182	3445	51	2	1
2014-03-25 10:17:32.783352	3446	418	3	2
2014-03-25 10:18:00.922511	3447	20.0	1	1
2014-03-25 10:18:01.201445	3448	51	2	1
2014-03-25 10:18:32.783509	3449	418	3	2
2014-03-25 10:18:39.923143	3450	20.0	1	1
2014-03-25 10:18:40.155405	3451	51	2	1
2014-03-25 10:19:18.928254	3452	20.0	1	1
2014-03-25 10:19:19.149565	3453	51	2	1
2014-03-25 10:19:32.784791	3454	418	3	2
2014-03-25 10:19:57.921643	3455	20.0	1	1
2014-03-25 10:19:58.14423	3456	51	2	1
2014-03-25 10:20:32.787536	3457	418	3	2
2014-03-25 10:20:36.92148	3458	20.0	1	1
2014-03-25 10:20:37.158862	3459	51	2	1
2014-03-25 10:20:56.785857	3460	1577	3	2
2014-03-25 10:21:08.787573	3461	418	3	2
2014-03-25 10:21:15.922713	3462	20.0	1	1
2014-03-25 10:21:16.155895	3463	51	2	1
2014-03-25 10:21:20.790893	3464	418	3	2
2014-03-25 10:21:32.787712	3465	434	3	2
2014-03-25 10:21:54.925282	3466	20.0	1	1
2014-03-25 10:21:55.159831	3467	51	2	1
2014-03-25 10:22:32.786615	3468	418	3	2
2014-03-25 10:22:33.92167	3469	20.0	1	1
2014-03-25 10:22:34.144319	3470	51	2	1
2014-03-25 10:22:56.782259	3471	338	3	2
2014-03-25 10:23:08.783417	3472	338	3	2
2014-03-25 10:23:12.920839	3473	20.0	1	1
2014-03-25 10:23:13.154666	3474	51	2	1
2014-03-25 10:23:32.785618	3475	338	3	2
2014-03-25 10:23:44.782568	3476	370	3	2
2014-03-25 10:23:51.922478	3477	20.0	1	1
2014-03-25 10:23:52.163827	3478	51	2	1
2014-03-25 10:23:56.787847	3479	402	3	2
2014-03-25 10:24:08.785018	3480	418	3	2
2014-03-25 10:24:30.917951	3481	20.0	1	1
2014-03-25 10:24:31.180081	3482	51	2	1
2014-03-25 10:24:32.783691	3483	402	3	2
2014-03-25 10:25:09.923084	3484	20.0	1	1
2014-03-25 10:25:10.146207	3485	51	2	1
2014-03-25 10:25:32.785247	3486	418	3	2
2014-03-25 10:25:48.922498	3487	20.0	1	1
2014-03-25 10:25:49.146187	3488	51	2	1
2014-03-25 10:26:27.919476	3489	20.0	1	1
2014-03-25 10:26:28.144832	3490	51	2	1
2014-03-25 10:26:32.788698	3491	402	3	2
2014-03-25 10:27:06.921651	3492	20.0	1	1
2014-03-25 10:27:07.159862	3493	51	2	1
2014-03-25 10:27:32.783385	3494	402	3	2
2014-03-25 10:27:45.919439	3495	20.0	1	1
2014-03-25 10:27:46.144699	3496	51	2	1
2014-03-25 10:28:24.921165	3497	20.0	1	1
2014-03-25 10:28:25.148408	3498	51	2	1
2014-03-25 10:28:32.785629	3499	418	3	2
2014-03-25 10:29:03.920062	3500	20.0	1	1
2014-03-25 10:29:04.142846	3501	51	2	1
2014-03-25 10:29:20.783084	3502	354	3	2
2014-03-25 10:29:32.78392	3503	354	3	2
2014-03-25 10:29:42.917848	3504	20.0	1	1
2014-03-25 10:29:43.140067	3505	51	2	1
2014-03-25 10:30:21.918572	3506	20.0	1	1
2014-03-25 10:30:22.141653	3507	51	2	1
2014-03-25 10:30:32.786065	3508	354	3	2
2014-03-25 10:31:00.917979	3509	20.0	1	1
2014-03-25 10:31:01.141663	3510	51	2	1
2014-03-25 10:31:32.78564	3511	354	3	2
2014-03-25 10:31:39.917406	3512	20.0	1	1
2014-03-25 10:31:40.139578	3513	51	2	1
2014-03-25 10:32:18.921918	3514	20.0	1	1
2014-03-25 10:32:19.161938	3515	51	2	1
2014-03-25 10:32:32.785748	3516	354	3	2
2014-03-25 10:32:57.916658	3517	20.0	1	1
2014-03-25 10:32:58.143746	3518	51	2	1
2014-03-25 10:33:20.78675	3519	402	3	2
2014-03-25 10:33:32.783893	3520	370	3	2
2014-03-25 10:33:36.912889	3521	20.0	1	1
2014-03-25 10:33:37.161567	3522	51	2	1
2014-03-25 10:33:44.785473	3523	370	3	2
2014-03-25 10:33:56.7817	3524	402	3	2
2014-03-25 10:34:08.78256	3525	402	3	2
2014-03-25 10:34:15.916114	3526	20.0	1	1
2014-03-25 10:34:16.160331	3527	51	2	1
2014-03-25 10:34:32.782835	3528	370	3	2
2014-03-25 10:34:44.782547	3529	370	3	2
2014-03-25 10:34:54.911053	3530	20.0	1	1
2014-03-25 10:34:55.134897	3531	51	2	1
2014-03-25 10:34:56.783734	3532	418	3	2
2014-03-25 10:35:08.786272	3533	402	3	2
2014-03-25 10:35:32.783401	3534	402	3	2
2014-03-25 10:35:33.912808	3535	20.0	1	1
2014-03-25 10:35:34.146585	3536	51	2	1
2014-03-25 10:36:12.913501	3537	20.0	1	1
2014-03-25 10:36:13.137456	3538	51	2	1
2014-03-25 10:36:20.784956	3539	434	3	2
2014-03-25 10:36:32.785307	3540	434	3	2
2014-03-25 10:36:51.911435	3541	20.0	1	1
2014-03-25 10:36:52.133984	3542	52	2	1
2014-03-25 10:37:30.91596	3543	20.0	1	1
2014-03-25 10:37:31.150593	3544	52	2	1
2014-03-25 10:37:32.788693	3545	434	3	2
2014-03-25 10:38:09.933637	3546	20.0	1	1
2014-03-25 10:38:10.157654	3547	52	2	1
2014-03-25 10:38:32.785103	3548	450	3	2
2014-03-25 10:38:48.910963	3549	20.0	1	1
2014-03-25 10:38:49.135738	3550	52	2	1
2014-03-25 10:39:27.911678	3551	20.0	1	1
2014-03-25 10:39:28.136403	3552	52	2	1
2014-03-25 10:39:32.782656	3553	434	3	2
2014-03-25 10:40:06.913205	3554	20.0	1	1
2014-03-25 10:40:07.141441	3555	52	2	1
2014-03-25 10:40:45.714506	3556	434	3	2
2014-03-25 10:40:46.031634	3557	20.0	1	1
2014-03-25 10:40:46.254695	3558	52	2	1
2014-03-25 10:41:08.783422	3559	402	3	2
2014-03-25 10:41:20.78379	3560	402	3	2
2014-03-25 10:41:24.908561	3561	20.0	1	1
2014-03-25 10:41:25.133161	3562	52	2	1
2014-03-25 10:41:32.782894	3563	370	3	2
2014-03-25 10:41:44.783873	3564	402	3	2
2014-03-25 10:41:56.779875	3565	402	3	2
2014-03-25 10:42:03.909916	3566	20.0	1	1
2014-03-25 10:42:04.153613	3567	52	2	1
2014-03-25 10:42:32.785233	3568	402	3	2
2014-03-25 10:42:42.90646	3569	20.0	1	1
2014-03-25 10:42:43.132526	3570	52	2	1
2014-03-25 10:42:44.783369	3571	370	3	2
2014-03-25 10:42:56.785679	3572	370	3	2
2014-03-25 10:43:21.91116	3573	20.0	1	1
2014-03-25 10:43:22.135257	3574	52	2	1
2014-03-25 10:43:32.781381	3575	402	3	2
2014-03-25 10:43:44.782154	3576	402	3	2
2014-03-25 10:44:00.910781	3577	20.0	1	1
2014-03-25 10:44:01.134572	3578	52	2	1
2014-03-25 10:44:32.785779	3579	402	3	2
2014-03-25 10:44:39.908459	3580	20.0	1	1
2014-03-25 10:44:40.134012	3581	52	2	1
2014-03-25 10:44:44.782849	3582	370	3	2
2014-03-25 10:44:56.785709	3583	402	3	2
2014-03-25 10:45:08.782149	3584	370	3	2
2014-03-25 10:45:18.909892	3585	20.0	1	1
2014-03-25 10:45:19.133762	3586	52	2	1
2014-03-25 10:45:20.794562	3587	402	3	2
2014-03-25 10:45:32.783917	3588	402	3	2
2014-03-25 10:45:56.785	3589	370	3	2
2014-03-25 10:45:57.908287	3590	20.0	1	1
2014-03-25 10:45:58.140706	3591	52	2	1
2014-03-25 10:46:08.783195	3592	402	3	2
2014-03-25 10:46:20.782422	3593	402	3	2
2014-03-25 10:46:32.783502	3594	370	3	2
2014-03-25 10:46:36.905652	3595	20.0	1	1
2014-03-25 10:46:37.133321	3596	52	2	1
2014-03-25 10:46:44.783841	3597	402	3	2
2014-03-25 10:46:56.781468	3598	402	3	2
2014-03-25 10:47:08.783102	3599	370	3	2
2014-03-25 10:47:15.904828	3600	20.0	1	1
2014-03-25 10:47:16.136369	3601	52	2	1
2014-03-25 10:47:20.7843	3602	402	3	2
2014-03-25 10:47:32.783548	3603	434	3	2
2014-03-25 10:47:44.787421	3604	450	3	2
2014-03-25 10:47:54.90429	3605	20.0	1	1
2014-03-25 10:47:55.127595	3606	52	2	1
2014-03-25 10:48:32.785786	3607	450	3	2
2014-03-25 10:48:33.908031	3608	20.0	1	1
2014-03-25 10:48:34.14257	3609	52	2	1
2014-03-25 10:49:12.907186	3610	20.0	1	1
2014-03-25 10:49:13.662597	3611	52	2	1
2014-03-25 10:49:32.783081	3612	434	3	2
2014-03-25 10:49:51.903958	3613	20.0	1	1
2014-03-25 10:49:52.535634	3614	52	2	1
2014-03-25 10:50:30.908324	3615	20.0	1	1
2014-03-25 10:50:31.136299	3616	52	2	1
2014-03-25 10:50:32.784486	3617	434	3	2
2014-03-25 10:51:09.907934	3620	20.0	1	1
2014-03-25 10:51:10.142524	3621	52	2	1
2014-03-26 19:24:32.582011	29189	595	3	2
2014-03-25 10:51:32.782259	3624	418	3	2
2014-03-25 10:51:48.910034	3625	20.0	1	1
2014-03-25 10:51:49.13351	3626	52	2	1
2014-03-25 10:51:56.785321	3627	450	3	2
2014-03-25 10:52:08.783879	3628	434	3	2
2014-03-26 19:24:32.818529	29190	1086698.930548228	4	2
2014-03-26 19:24:47.054861	29191	21.3	1	9
2014-03-25 10:52:27.90652	3631	20.0	1	1
2014-03-25 10:52:28.130518	3632	52	2	1
2014-03-25 10:52:32.782474	3633	450	3	2
2014-03-26 19:24:47.28151	29192	50	2	9
2014-03-26 19:24:48.143121	29193	20.7	1	8
2014-03-25 10:53:06.905905	3638	20.1	1	1
2014-03-25 10:53:07.130297	3639	52	2	1
2014-03-26 19:24:48.39548	29194	52	2	8
2014-03-26 19:25:02.787864	29195	21.3	1	1
2014-03-25 10:53:32.783155	3644	434	3	2
2014-03-25 10:53:45.910982	3645	20.0	1	1
2014-03-25 10:53:46.140778	3646	52	2	1
2014-03-25 10:53:56.78481	3647	370	3	2
2014-03-26 19:25:03.015902	29196	49	2	1
2014-03-26 19:25:26.056436	29197	21.3	1	9
2014-03-25 10:54:08.781533	3652	370	3	2
2014-03-26 19:25:26.299517	29198	50	2	9
2014-03-26 19:25:27.153083	29199	20.7	1	8
2014-03-25 10:54:24.906934	3655	20.0	1	1
2014-03-25 10:54:25.144766	3656	52	2	1
2014-03-25 10:54:32.781633	3657	370	3	2
2014-03-26 19:25:27.376917	29200	52	2	8
2014-03-26 19:25:32.587683	29201	595	3	2
2014-03-25 10:55:03.903686	3662	20.0	1	1
2014-03-25 10:55:04.128465	3663	52	2	1
2014-03-26 19:25:32.821774	29202	1086708.1228259995	4	2
2014-03-26 19:25:41.792792	29203	21.4	1	1
2014-03-25 10:55:32.776515	3670	370	3	2
2014-03-25 10:55:42.905017	3671	20.0	1	1
2014-03-25 10:55:43.128583	3672	52	2	1
2014-03-25 10:50:52.533287	3618	17.8	1	9
2014-03-25 10:50:52.756468	3619	67	2	9
2014-03-25 10:51:31.509402	3622	18.7	1	9
2014-03-25 10:52:48.807432	3634	18.1	1	10
2014-03-25 10:52:49.033803	3635	65	2	10
2014-03-25 10:53:27.778163	3640	18.7	1	10
2014-03-25 10:53:28.002886	3641	68	2	10
2014-03-25 10:54:06.779386	3648	19.1	1	10
2014-03-25 10:54:07.005229	3649	67	2	10
2014-03-25 10:54:45.778106	3658	19.3	1	10
2014-03-25 10:54:46.004001	3659	67	2	10
2014-03-25 10:55:24.777926	3664	19.4	1	10
2014-03-25 10:55:25.00048	3665	66	2	10
2014-03-25 10:56:08.782689	3677	402	3	2
2014-03-25 10:56:20.781638	3678	402	3	2
2014-03-25 10:56:21.906932	3679	20.0	1	1
2014-03-25 10:56:22.139654	3680	52	2	1
2014-03-25 10:56:32.78195	3681	402	3	2
2014-03-26 19:25:42.015917	29204	49	2	1
2014-03-26 19:26:05.059946	29205	21.3	1	9
2014-03-25 10:57:01.03129	3686	20.0	1	1
2014-03-25 10:57:01.480139	3687	52	2	1
2014-03-26 19:26:05.291505	29206	50	2	9
2014-03-26 19:26:06.141289	29207	20.7	1	8
2014-03-25 10:57:32.779959	3692	402	3	2
2014-03-25 10:57:39.959795	3693	20.0	1	1
2014-03-25 10:57:40.678961	3694	52	2	1
2014-03-25 10:57:44.780106	3695	370	3	2
2014-03-25 10:57:56.778693	3696	370	3	2
2014-03-26 19:26:06.36313	29208	52	2	8
2014-03-26 19:26:20.785526	29209	21.4	1	1
2014-03-25 10:58:18.904544	3701	20.0	1	1
2014-03-25 10:58:19.13634	3702	52	2	1
2014-03-25 10:58:32.784724	3703	402	3	2
2014-03-26 19:26:21.018792	29210	49	2	1
2014-03-26 19:26:32.584377	29211	595	3	2
2014-03-25 10:58:44.782332	3708	370	3	2
2014-03-25 10:58:56.782216	3709	370	3	2
2014-03-25 10:58:57.901027	3710	20.0	1	1
2014-03-25 10:58:58.12811	3711	52	2	1
2014-03-26 19:26:32.815847	29212	1086718.4641384922	4	2
2014-03-26 19:26:44.055439	29213	21.3	1	9
2014-03-25 10:59:32.92146	3716	402	3	2
2014-03-25 10:59:36.904089	3717	20.0	1	1
2014-03-25 10:59:37.126421	3718	52	2	1
2014-03-25 10:59:44.780575	3719	370	3	2
2014-03-25 10:59:56.783565	3720	370	3	2
2014-03-26 19:26:44.287452	29214	50	2	9
2014-03-26 19:26:45.140871	29215	20.7	1	8
2014-03-25 11:00:15.899297	3725	20.0	1	1
2014-03-25 11:00:16.123554	3726	52	2	1
2014-03-25 11:00:32.779705	3727	418	3	2
2014-03-26 19:26:45.363772	29216	52	2	8
2014-03-26 19:26:59.776305	29217	21.4	1	1
2014-03-25 11:00:44.782861	3732	418	3	2
2014-03-25 11:00:54.901327	3733	20.0	1	1
2014-03-25 11:00:55.126669	3734	52	2	1
2014-03-26 19:27:00.010071	29218	49	2	1
2014-03-26 19:27:20.581989	29219	692	3	2
2014-03-25 11:01:33.701486	3739	434	3	2
2014-03-25 11:01:34.019551	3740	20.0	1	1
2014-03-25 11:01:34.244931	3741	52	2	1
2014-03-26 19:27:20.807939	29220	1086726.5073815421	4	2
2014-03-26 19:27:23.055145	29221	21.3	1	9
2014-03-25 11:02:12.898087	3746	20.0	1	1
2014-03-25 11:02:13.130228	3747	52	2	1
2014-03-25 11:02:32.782555	3748	482	3	2
2014-03-26 19:27:23.288136	29222	50	2	9
2014-03-26 19:27:24.142401	29223	20.7	1	8
2014-03-25 11:02:44.782828	3753	482	3	2
2014-03-25 11:02:51.899395	3754	20.0	1	1
2014-03-25 11:02:52.123554	3755	52	2	1
2014-03-26 19:27:24.366296	29224	52	2	8
2014-03-26 19:27:32.581574	29225	708	3	2
2014-03-25 11:03:30.902637	3760	20.0	1	1
2014-03-25 11:03:31.133899	3761	52	2	1
2014-03-25 11:03:32.779712	3762	515	3	2
2014-03-25 11:03:44.920162	3763	498	3	2
2014-03-26 19:27:32.823315	29226	1086728.805450985	4	2
2014-03-26 19:27:38.787063	29227	21.4	1	1
2014-03-25 11:04:09.898585	3768	20.0	1	1
2014-03-25 11:04:10.130358	3769	52	2	1
2014-03-26 19:27:39.016038	29228	49	2	1
2014-03-26 19:27:44.583342	29229	676	3	2
2014-03-25 11:04:32.783121	3774	498	3	2
2014-03-25 11:04:48.904773	3775	20.0	1	1
2014-03-25 11:04:49.131526	3776	52	2	1
2014-03-26 19:27:44.819471	29230	1086731.1035204278	4	2
2014-03-26 19:27:56.580809	29231	692	3	2
2014-03-25 11:05:27.896563	3781	20.0	1	1
2014-03-25 11:05:28.129445	3782	52	2	1
2014-03-25 11:05:32.782974	3783	498	3	2
2014-03-26 19:27:56.804688	29232	1086733.4015898707	4	2
2014-03-26 19:28:02.058437	29233	21.3	1	9
2014-03-26 19:28:02.294767	29234	50	2	9
2014-03-26 19:28:03.142209	29235	20.7	1	8
2014-03-25 11:05:56.782276	3790	450	3	2
2014-03-25 11:06:06.897534	3791	20.0	1	1
2014-03-25 11:06:07.122562	3792	52	2	1
2014-03-26 19:28:03.366447	29236	52	2	8
2014-03-26 19:28:17.786304	29237	21.4	1	1
2014-03-26 19:28:18.023472	29238	49	2	1
2014-03-25 11:06:32.848042	3797	450	3	2
2014-03-25 11:06:45.895331	3798	20.0	1	1
2014-03-25 11:06:46.118183	3799	52	2	1
2014-03-26 19:28:32.580801	29239	579	3	2
2014-03-26 19:28:32.812942	29240	1086740.295798199	4	2
2014-03-25 11:07:24.894259	3804	20.0	1	1
2014-03-25 11:07:25.126023	3805	52	2	1
2014-03-25 11:07:32.781059	3806	434	3	2
2014-03-25 10:56:04.503311	3675	19.7	1	9
2014-03-25 10:56:04.725434	3676	66	2	9
2014-03-25 10:56:03.778891	3673	19.6	1	10
2014-03-25 10:56:04.001313	3674	65	2	10
2014-03-25 10:56:42.782572	3682	19.7	1	10
2014-03-25 10:56:43.023893	3683	65	2	10
2014-03-25 10:57:21.781403	3688	19.8	1	10
2014-03-25 10:57:22.003909	3689	65	2	10
2014-03-25 10:58:00.779929	3697	19.8	1	10
2014-03-25 10:58:01.076308	3698	64	2	10
2014-03-25 10:58:39.780804	3704	19.9	1	10
2014-03-25 10:58:40.005249	3705	64	2	10
2014-03-25 10:59:18.909929	3712	20.0	1	10
2014-03-25 10:59:19.352843	3713	63	2	10
2014-03-25 10:59:57.780871	3721	20.1	1	10
2014-03-25 10:59:58.008784	3722	63	2	10
2014-03-25 11:00:36.779527	3728	20.1	1	10
2014-03-25 11:00:37.00336	3729	63	2	10
2014-03-25 11:01:15.780817	3735	20.2	1	10
2014-03-25 11:01:16.014338	3736	63	2	10
2014-03-25 11:01:54.779717	3742	20.2	1	10
2014-03-25 11:01:55.022593	3743	62	2	10
2014-03-25 11:02:33.780691	3749	20.3	1	10
2014-03-25 11:02:34.002333	3750	62	2	10
2014-03-25 11:03:12.78309	3756	20.3	1	10
2014-03-25 11:03:13.01493	3757	62	2	10
2014-03-25 11:03:51.91003	3764	20.4	1	10
2014-03-25 11:03:52.351315	3765	62	2	10
2014-03-25 11:04:31.09057	3770	20.4	1	10
2014-03-25 11:04:31.355015	3771	62	2	10
2014-03-25 11:05:09.785374	3777	20.4	1	10
2014-03-25 11:05:10.009324	3778	62	2	10
2014-03-25 11:05:48.781869	3784	20.5	1	10
2014-03-25 11:05:49.005488	3785	61	2	10
2014-03-25 11:06:27.781152	3793	20.5	1	10
2014-03-26 19:28:41.059925	29241	21.3	1	9
2014-03-26 19:28:41.294059	29242	50	2	9
2014-03-25 11:08:03.895729	3813	20.0	1	1
2014-03-25 11:08:04.119792	3814	52	2	1
2014-03-25 11:08:42.895531	3819	20.0	1	1
2014-03-25 11:08:43.127047	3820	52	2	1
2014-03-25 11:09:21.895293	3825	20.0	1	1
2014-03-25 11:09:22.118728	3826	52	2	1
2014-03-25 11:10:00.89872	3831	20.0	1	1
2014-03-25 11:10:01.144193	3832	52	2	1
2014-03-25 11:10:32.793878	3837	434	3	2
2014-03-25 11:10:39.898155	3838	20.0	1	1
2014-03-25 11:10:40.136039	3839	52	2	1
2014-03-25 11:10:56.776501	3840	466	3	2
2014-03-25 11:11:08.778718	3845	450	3	2
2014-03-25 11:11:18.896187	3846	20.0	1	1
2014-03-25 11:11:19.124329	3847	52	2	1
2014-03-25 11:11:32.822264	3848	450	3	2
2014-03-26 19:28:42.144348	29243	20.7	1	8
2014-03-25 11:11:57.905979	3853	20.0	1	1
2014-03-25 11:11:58.146594	3854	52	2	1
2014-03-25 11:12:08.782777	3855	482	3	2
2014-03-26 19:28:42.368496	29244	52	2	8
2014-03-26 19:28:44.582667	29245	579	3	2
2014-03-25 11:12:20.775851	3860	482	3	2
2014-03-25 11:12:32.83192	3861	498	3	2
2014-03-25 11:12:36.894031	3862	20.0	1	1
2014-03-25 11:12:37.135106	3863	52	2	1
2014-03-26 19:28:44.829138	29246	1086741.4448329206	4	2
2014-03-26 19:28:56.782846	29247	21.4	1	1
2014-03-25 11:13:15.89473	3868	20.0	1	1
2014-03-25 11:13:16.117351	3869	52	2	1
2014-03-25 11:13:32.837153	3870	482	3	2
2014-03-26 19:28:57.0079	29248	49	2	1
2014-03-26 19:29:08.582341	29249	547	3	2
2014-03-25 11:13:54.896462	3875	20.0	1	1
2014-03-25 11:13:55.118151	3876	52	2	1
2014-03-26 19:29:08.817843	29250	1086746.0409718063	4	2
2014-03-26 19:29:20.055438	29251	21.3	1	9
2014-03-25 11:14:32.841153	3881	482	3	2
2014-03-25 11:14:33.892143	3882	20.0	1	1
2014-03-25 11:14:34.114107	3883	52	2	1
2014-03-26 19:29:20.281473	29252	50	2	9
2014-03-26 19:29:20.589643	29253	579	3	2
2014-03-25 11:15:12.896423	3888	20.0	1	1
2014-03-25 11:15:13.118068	3889	52	2	1
2014-03-25 11:15:32.821212	3890	498	3	2
2014-03-26 19:29:20.823313	29254	1086747.1900065276	4	2
2014-03-26 19:29:21.142856	29255	20.7	1	8
2014-03-26 19:29:21.368784	29256	52	2	8
2014-03-26 19:29:32.583531	29257	579	3	2
2014-03-25 11:15:51.884276	3897	20.0	1	1
2014-03-25 11:15:52.109564	3898	52	2	1
2014-03-26 19:29:32.824636	29258	1086749.4880759704	4	2
2014-03-26 19:29:35.785163	29259	21.4	1	1
2014-03-26 19:29:36.009591	29260	49	2	1
2014-03-26 19:29:56.582457	29261	547	3	2
2014-03-25 11:16:30.891051	3905	20.0	1	1
2014-03-25 11:16:31.115995	3906	52	2	1
2014-03-25 11:16:32.785933	3907	498	3	2
2014-03-26 19:29:56.817698	29262	1086752.9351801346	4	2
2014-03-26 19:29:59.058603	29263	21.3	1	9
2014-03-26 19:29:59.284623	29264	50	2	9
2014-03-26 19:30:00.141529	29265	20.7	1	8
2014-03-25 11:16:56.782906	3914	434	3	2
2014-03-25 11:17:08.781977	3915	434	3	2
2014-03-25 11:17:09.891509	3916	20.0	1	1
2014-03-25 11:17:10.115004	3917	52	2	1
2014-03-26 19:30:00.376728	29266	52	2	8
2014-03-26 19:30:08.58108	29267	579	3	2
2014-03-25 11:17:32.781396	3922	434	3	2
2014-03-26 19:30:08.807747	29268	1086755.2332495775	4	2
2014-03-26 19:30:14.786407	29269	21.4	1	1
2014-03-25 11:17:48.892815	3925	20.0	1	1
2014-03-25 11:17:49.117429	3926	52	2	1
2014-03-26 19:30:15.021178	29270	49	2	1
2014-03-26 19:30:20.583709	29271	579	3	2
2014-03-26 19:30:20.811915	29272	1086757.5313190203	4	2
2014-03-26 19:30:32.581587	29273	579	3	2
2014-03-25 11:18:27.883125	3933	20.0	1	1
2014-03-25 11:18:28.107377	3934	52	2	1
2014-03-25 11:18:32.78012	3935	434	3	2
2014-03-25 11:19:06.884943	3942	20.0	1	1
2014-03-25 11:19:07.118159	3943	52	2	1
2014-03-25 11:19:08.910028	3944	402	3	2
2014-03-25 11:07:46.505696	3809	20.0	1	9
2014-03-25 11:07:46.730376	3810	64	2	9
2014-03-25 11:08:25.502935	3817	20.0	1	9
2014-03-25 11:08:25.727688	3818	63	2	9
2014-03-25 11:09:04.50573	3823	20.0	1	9
2014-03-25 11:09:04.740905	3824	63	2	9
2014-03-25 11:09:43.502638	3829	20.0	1	9
2014-03-25 11:09:43.725883	3830	63	2	9
2014-03-25 11:10:22.507805	3835	20.0	1	9
2014-03-25 11:10:22.751228	3836	63	2	9
2014-03-25 11:11:01.517013	3843	20.0	1	9
2014-03-25 11:11:01.75653	3844	63	2	9
2014-03-25 11:11:40.503333	3851	20.0	1	9
2014-03-25 11:08:24.782754	3815	20.6	1	10
2014-03-25 11:08:25.015501	3816	61	2	10
2014-03-25 11:09:03.782895	3821	20.6	1	10
2014-03-25 11:09:04.008855	3822	61	2	10
2014-03-25 11:09:42.783877	3827	20.6	1	10
2014-03-25 11:09:43.018661	3828	61	2	10
2014-03-25 11:10:21.791359	3833	20.7	1	10
2014-03-25 11:10:22.029854	3834	61	2	10
2014-03-25 11:11:00.789733	3841	20.7	1	10
2014-03-25 11:11:01.021332	3842	60	2	10
2014-03-25 11:11:39.784163	3849	20.7	1	10
2014-03-25 11:11:40.00713	3850	60	2	10
2014-03-25 11:12:18.78495	3856	20.7	1	10
2014-03-25 11:12:19.008264	3857	60	2	10
2014-03-25 11:12:57.78274	3864	20.7	1	10
2014-03-25 11:12:58.005757	3865	60	2	10
2014-03-25 11:13:36.783914	3871	20.8	1	10
2014-03-25 11:13:37.006967	3872	60	2	10
2014-03-25 11:14:15.78472	3877	20.8	1	10
2014-03-25 11:14:16.03931	3878	60	2	10
2014-03-25 11:14:54.78617	3884	20.8	1	10
2014-03-25 11:14:55.009363	3885	60	2	10
2014-03-25 11:15:33.7844	3891	20.8	1	10
2014-03-25 11:15:34.007949	3892	60	2	10
2014-03-25 11:16:12.784363	3899	20.8	1	10
2014-03-25 11:16:13.019822	3900	60	2	10
2014-03-25 11:16:51.786755	3908	20.8	1	10
2014-03-25 11:16:52.010166	3909	60	2	10
2014-03-25 11:17:30.785262	3918	20.9	1	10
2014-03-25 11:17:31.006251	3919	59	2	10
2014-03-25 11:18:09.785027	3927	20.9	1	10
2014-03-25 11:18:10.019543	3928	59	2	10
2014-03-25 11:18:48.809665	3936	20.9	1	10
2014-03-25 11:19:20.910059	3945	402	3	2
2014-03-26 19:30:32.820914	29274	1086758.6803537419	4	2
2014-03-26 19:30:38.060826	29275	21.3	1	9
2014-03-25 11:19:32.780637	3952	402	3	2
2014-03-25 11:19:44.776969	3953	370	3	2
2014-03-25 11:19:45.892172	3954	20.0	1	1
2014-03-25 11:19:46.126067	3955	52	2	1
2014-03-25 11:19:56.780361	3956	402	3	2
2014-03-26 19:30:38.285272	29276	50	2	9
2014-03-25 11:20:08.779758	3961	402	3	2
2014-03-25 11:20:24.893938	3962	20.0	1	1
2014-03-25 11:20:25.126632	3963	52	2	1
2014-03-25 11:20:32.915788	3964	418	3	2
2014-03-26 19:30:39.141605	29277	20.7	1	8
2014-03-26 19:30:39.374914	29278	52	2	8
2014-03-25 11:21:03.891178	3969	20.0	1	1
2014-03-25 11:21:04.132387	3970	53	2	1
2014-03-26 19:30:53.784571	29279	21.4	1	1
2014-03-26 19:30:54.009405	29280	49	2	1
2014-03-25 11:21:32.777501	3975	402	3	2
2014-03-25 11:21:42.887273	3976	20.0	1	1
2014-03-25 11:21:43.111622	3977	53	2	1
2014-03-26 19:31:17.055433	29281	21.3	1	9
2014-03-26 19:31:17.294584	29282	50	2	9
2014-03-25 11:22:21.892789	3982	20.0	1	1
2014-03-25 11:22:22.123356	3983	53	2	1
2014-03-25 11:22:32.773344	3984	402	3	2
2014-03-26 19:31:18.140143	29283	20.7	1	8
2014-03-26 19:31:18.365328	29284	52	2	8
2014-03-25 11:22:44.775169	3989	370	3	2
2014-03-25 11:22:56.781567	3990	338	3	2
2014-03-25 11:23:00.886225	3991	20.0	1	1
2014-03-25 11:23:01.10677	3992	53	2	1
2014-03-25 11:23:08.781984	3993	338	3	2
2014-03-26 19:31:32.581119	29285	579	3	2
2014-03-26 19:31:32.824451	29286	1086767.8771024654	4	2
2014-03-26 19:31:33.132918	29287	21.4	1	1
2014-03-26 19:31:33.358637	29288	49	2	1
2014-03-25 11:23:39.887493	4000	20.0	1	1
2014-03-25 11:23:40.109489	4001	53	2	1
2014-03-25 11:23:44.775703	4002	370	3	2
2014-03-25 11:23:56.775286	4003	402	3	2
2014-03-26 19:31:56.054884	29289	21.3	1	9
2014-03-26 19:31:56.28943	29290	50	2	9
2014-03-25 11:24:08.778611	4008	370	3	2
2014-03-25 11:24:18.889629	4009	20.0	1	1
2014-03-25 11:24:19.123646	4010	53	2	1
2014-03-25 11:24:20.77998	4011	354	3	2
2014-03-25 11:24:32.777971	4012	354	3	2
2014-03-26 19:31:57.142486	29291	20.7	1	8
2014-03-26 19:31:57.366124	29292	52	2	8
2014-03-25 11:24:57.881958	4017	20.0	1	1
2014-03-25 11:24:58.104091	4018	53	2	1
2014-03-26 19:32:11.787862	29293	21.4	1	1
2014-03-26 19:32:12.033311	29294	49	2	1
2014-03-25 11:25:32.780398	4023	402	3	2
2014-03-25 11:25:36.880606	4024	20.0	1	1
2014-03-25 11:25:37.104739	4025	53	2	1
2014-03-25 11:25:44.78081	4026	354	3	2
2014-03-25 11:25:56.778113	4027	418	3	2
2014-03-26 19:32:32.582881	29295	579	3	2
2014-03-26 19:32:32.816456	29296	1086777.0693802366	4	2
2014-03-25 11:26:08.779045	4032	418	3	2
2014-03-25 11:26:15.887967	4033	20.0	1	1
2014-03-25 11:26:16.112399	4034	53	2	1
2014-03-25 11:26:32.775636	4035	418	3	2
2014-03-26 19:32:35.05697	29297	21.3	1	9
2014-03-26 19:32:35.289639	29298	50	2	9
2014-03-25 11:26:54.886956	4040	20.0	1	1
2014-03-25 11:26:55.111973	4041	53	2	1
2014-03-26 19:32:36.141074	29299	20.7	1	8
2014-03-26 19:32:36.363599	29300	52	2	8
2014-03-25 11:27:32.777689	4046	418	3	2
2014-03-25 11:27:33.887505	4047	20.0	1	1
2014-03-25 11:27:34.110576	4048	53	2	1
2014-03-26 19:32:50.783724	29301	21.4	1	1
2014-03-26 19:32:51.021847	29302	49	2	1
2014-03-25 11:28:12.882436	4053	20.0	1	1
2014-03-25 11:28:13.104395	4054	53	2	1
2014-03-25 11:28:32.779162	4055	418	3	2
2014-03-26 19:33:14.056298	29303	21.3	1	9
2014-03-26 19:33:14.280223	29304	50	2	9
2014-03-25 11:28:51.882416	4060	20.0	1	1
2014-03-25 11:28:52.104011	4061	53	2	1
2014-03-26 19:33:15.141351	29305	20.7	1	8
2014-03-26 19:33:15.374249	29306	52	2	8
2014-03-25 11:29:30.883111	4066	20.0	1	1
2014-03-25 11:29:31.104695	4067	53	2	1
2014-03-25 11:29:32.776275	4068	418	3	2
2014-03-25 11:29:44.778154	4069	450	3	2
2014-03-26 19:33:29.782861	29307	21.4	1	1
2014-03-26 19:33:30.008795	29308	49	2	1
2014-03-26 19:33:32.578648	29309	579	3	2
2014-03-25 11:29:56.777731	4074	418	3	2
2014-03-25 11:30:08.779556	4075	402	3	2
2014-03-25 11:30:09.881802	4076	20.1	1	1
2014-03-25 11:30:10.103336	4077	53	2	1
2014-03-25 11:19:28.939948	3948	20.1	1	9
2014-03-25 11:19:29.359942	3949	62	2	9
2014-03-25 11:20:07.503391	3959	20.1	1	9
2014-03-25 11:19:27.91454	3946	20.9	1	10
2014-03-25 11:19:28.360174	3947	59	2	10
2014-03-25 11:20:06.790106	3957	20.9	1	10
2014-03-25 11:20:07.012199	3958	59	2	10
2014-03-25 11:20:45.920057	3965	20.9	1	10
2014-03-25 11:20:46.340069	3966	59	2	10
2014-03-25 11:21:24.787256	3971	20.9	1	10
2014-03-25 11:21:25.012779	3972	59	2	10
2014-03-25 11:22:03.785254	3978	20.9	1	10
2014-03-25 11:22:04.015933	3979	59	2	10
2014-03-25 11:22:42.785307	3985	21.0	1	10
2014-03-25 11:22:43.019434	3986	59	2	10
2014-03-25 11:23:21.785873	3994	21.0	1	10
2014-03-25 11:23:22.007996	3995	58	2	10
2014-03-25 11:24:00.787349	4004	21.0	1	10
2014-03-25 11:24:01.009942	4005	58	2	10
2014-03-25 11:24:39.786337	4013	21.0	1	10
2014-03-25 11:24:40.009333	4014	58	2	10
2014-03-25 11:25:18.991545	4019	21.0	1	10
2014-03-25 11:25:19.224153	4020	58	2	10
2014-03-25 11:25:57.787865	4028	21.0	1	10
2014-03-25 11:25:58.011746	4029	58	2	10
2014-03-25 11:26:36.788096	4036	21.0	1	10
2014-03-25 11:26:37.012076	4037	58	2	10
2014-03-25 11:27:15.788954	4042	21.0	1	10
2014-03-25 11:27:16.009604	4043	58	2	10
2014-03-25 11:27:54.78814	4049	21.0	1	10
2014-03-25 11:27:55.011734	4050	58	2	10
2014-03-25 11:28:33.787887	4056	21.1	1	10
2014-03-25 11:28:34.010601	4057	58	2	10
2014-03-25 11:29:12.789028	4062	21.1	1	10
2014-03-25 11:29:13.011297	4063	58	2	10
2014-03-25 11:29:51.788193	4070	21.1	1	10
2014-03-26 19:33:32.821317	29310	1086787.4106927293	4	2
2014-03-25 11:30:32.780903	4082	418	3	2
2014-03-25 11:30:48.881219	4083	20.1	1	1
2014-03-25 11:30:49.103045	4084	53	2	1
2014-03-26 19:33:53.056314	29311	21.3	1	9
2014-03-26 19:33:53.281976	29312	50	2	9
2014-03-25 11:31:27.883343	4089	20.1	1	1
2014-03-25 11:31:28.106243	4090	53	2	1
2014-03-25 11:31:32.7796	4091	370	3	2
2014-03-25 11:31:44.778409	4092	370	3	2
2014-03-26 19:33:54.143107	29313	20.7	1	8
2014-03-26 19:33:54.37648	29314	52	2	8
2014-03-25 11:32:06.883224	4097	20.1	1	1
2014-03-25 11:32:07.10653	4098	53	2	1
2014-03-26 19:34:08.78295	29315	21.4	1	1
2014-03-26 19:34:09.008646	29316	49	2	1
2014-03-25 11:32:32.777565	4103	370	3	2
2014-03-25 11:32:45.881631	4104	20.1	1	1
2014-03-25 11:32:46.105897	4105	53	2	1
2014-03-26 19:34:32.057358	29317	21.3	1	9
2014-03-26 19:34:32.292438	29318	50	2	9
2014-03-25 11:33:24.877171	4110	20.1	1	1
2014-03-25 11:33:25.099321	4111	53	2	1
2014-03-25 11:33:32.776276	4112	354	3	2
2014-03-26 19:34:32.602592	29319	579	3	2
2014-03-26 19:34:32.832326	29320	1086796.6029705007	4	2
2014-03-25 11:34:03.880701	4117	20.1	1	1
2014-03-25 11:34:04.114268	4118	53	2	1
2014-03-26 19:34:33.144298	29321	20.7	1	8
2014-03-26 19:34:33.378732	29322	52	2	8
2014-03-25 11:34:32.77813	4123	354	3	2
2014-03-25 11:34:42.882482	4124	20.1	1	1
2014-03-25 11:34:43.105013	4125	53	2	1
2014-03-26 19:34:47.780648	29323	21.4	1	1
2014-03-26 19:34:48.004846	29324	49	2	1
2014-03-25 11:35:20.775241	4130	402	3	2
2014-03-25 11:35:22.117902	4131	20.1	1	1
2014-03-25 11:35:22.341039	4132	53	2	1
2014-03-25 11:35:32.779043	4133	402	3	2
2014-03-26 19:35:11.057668	29325	21.3	1	9
2014-03-26 19:35:11.298667	29326	50	2	9
2014-03-25 11:35:44.779496	4138	370	3	2
2014-03-25 11:35:56.778441	4139	370	3	2
2014-03-25 11:36:00.878516	4140	20.1	1	1
2014-03-25 11:36:01.111343	4141	53	2	1
2014-03-25 11:36:08.778696	4142	402	3	2
2014-03-25 11:36:21.58989	4143	402	3	2
2014-03-26 19:35:12.141881	29327	20.7	1	8
2014-03-26 19:35:12.379443	29328	52	2	8
2014-03-25 11:36:32.77781	4148	418	3	2
2014-03-25 11:36:39.880293	4149	20.1	1	1
2014-03-25 11:36:40.101334	4150	53	2	1
2014-03-25 11:36:44.778305	4151	370	3	2
2014-03-25 11:36:56.778669	4152	402	3	2
2014-03-26 19:35:20.582512	29329	515	3	2
2014-03-26 19:35:20.818903	29330	1086804.6462135506	4	2
2014-03-25 11:37:08.775231	4157	370	3	2
2014-03-25 11:37:18.881756	4158	20.1	1	1
2014-03-25 11:37:19.105272	4159	53	2	1
2014-03-25 11:37:20.778674	4160	370	3	2
2014-03-25 11:37:32.776794	4161	370	3	2
2014-03-26 19:35:26.777246	29331	21.5	1	1
2014-03-26 19:35:27.002121	29332	49	2	1
2014-03-25 11:37:44.77903	4166	402	3	2
2014-03-25 11:37:56.775047	4167	418	3	2
2014-03-25 11:37:57.881047	4168	20.1	1	1
2014-03-25 11:37:58.103654	4169	53	2	1
2014-03-26 19:35:32.580199	29333	515	3	2
2014-03-26 19:35:32.821098	29334	1086805.795248272	4	2
2014-03-25 11:38:32.774972	4174	434	3	2
2014-03-25 11:38:36.880448	4175	20.1	1	1
2014-03-25 11:38:37.103172	4176	53	2	1
2014-03-26 19:35:50.055942	29335	21.3	1	9
2014-03-26 19:35:50.283018	29336	50	2	9
2014-03-25 11:39:15.878003	4181	20.1	1	1
2014-03-25 11:39:16.100747	4182	53	2	1
2014-03-25 11:39:32.777796	4183	434	3	2
2014-03-26 19:35:51.143224	29337	20.7	1	8
2014-03-26 19:35:51.490023	29338	52	2	8
2014-03-25 11:39:54.879772	4188	20.1	1	1
2014-03-25 11:39:55.124356	4189	53	2	1
2014-03-26 19:36:05.781659	29339	21.5	1	1
2014-03-26 19:36:06.0058	29340	49	2	1
2014-03-25 11:40:32.776922	4194	418	3	2
2014-03-25 11:40:33.878582	4195	20.1	1	1
2014-03-25 11:40:34.100385	4196	53	2	1
2014-03-26 19:36:29.055013	29341	21.3	1	9
2014-03-26 19:36:29.299974	29342	50	2	9
2014-03-25 11:41:12.878679	4201	20.1	1	1
2014-03-25 11:41:13.100795	4202	53	2	1
2014-03-25 11:41:32.774836	4203	418	3	2
2014-03-26 19:36:30.141714	29343	20.7	1	8
2014-03-26 19:36:30.449725	29344	52	2	8
2014-03-25 11:41:51.875764	4208	20.1	1	1
2014-03-25 11:41:52.107752	4209	53	2	1
2014-03-26 19:36:32.582678	29345	498	3	2
2014-03-25 11:42:30.871735	4214	20.1	1	1
2014-03-25 11:42:31.097002	4215	53	2	1
2014-03-25 11:42:32.777549	4216	450	3	2
2014-03-25 11:31:09.793066	4085	21.1	1	10
2014-03-25 11:31:10.01776	4086	58	2	10
2014-03-25 11:31:48.790154	4093	21.1	1	10
2014-03-25 11:31:49.014367	4094	58	2	10
2014-03-25 11:32:27.790026	4099	21.1	1	10
2014-03-25 11:32:28.035371	4100	58	2	10
2014-03-25 11:33:06.790412	4106	21.1	1	10
2014-03-25 11:33:07.011443	4107	58	2	10
2014-03-25 11:33:45.790117	4113	21.1	1	10
2014-03-25 11:33:46.011043	4114	58	2	10
2014-03-25 11:34:24.789904	4119	21.1	1	10
2014-03-25 11:34:25.013632	4120	58	2	10
2014-03-25 11:35:03.807416	4126	21.1	1	10
2014-03-25 11:35:04.03006	4127	57	2	10
2014-03-25 11:35:42.79204	4134	21.1	1	10
2014-03-25 11:35:43.013596	4135	57	2	10
2014-03-25 11:36:21.907836	4144	21.1	1	10
2014-03-25 11:36:22.153854	4145	57	2	10
2014-03-25 11:37:00.79179	4153	21.1	1	10
2014-03-25 11:37:01.015215	4154	57	2	10
2014-03-25 11:37:39.791812	4162	21.1	1	10
2014-03-25 11:37:40.026073	4163	57	2	10
2014-03-25 11:38:18.79275	4170	21.1	1	10
2014-03-25 11:38:19.01499	4171	57	2	10
2014-03-25 11:38:57.793492	4177	21.1	1	10
2014-03-25 11:38:58.016228	4178	57	2	10
2014-03-25 11:39:36.792218	4184	21.1	1	10
2014-03-25 11:39:37.027611	4185	57	2	10
2014-03-25 11:40:15.792719	4190	21.1	1	10
2014-03-25 11:40:16.015591	4191	57	2	10
2014-03-25 11:40:54.791705	4197	21.1	1	10
2014-03-25 11:40:55.014216	4198	57	2	10
2014-03-25 11:41:33.794566	4204	21.1	1	10
2014-03-25 11:41:34.027189	4205	57	2	10
2014-03-25 11:42:44.777776	4217	450	3	2
2014-03-26 19:36:32.822569	29346	1086814.9875260433	4	2
2014-03-26 19:36:44.780476	29347	21.5	1	1
2014-03-25 11:43:09.874985	4222	20.1	1	1
2014-03-25 11:43:10.099586	4223	53	2	1
2014-03-26 19:36:45.005805	29348	49	2	1
2014-03-26 19:36:56.583001	29349	611	3	2
2014-03-25 11:43:32.789827	4228	450	3	2
2014-03-25 11:43:48.874988	4229	20.1	1	1
2014-03-25 11:43:49.100517	4230	53	2	1
2014-03-26 19:36:56.817725	29350	1086818.4346302075	4	2
2014-03-26 19:37:08.055409	29351	21.3	1	9
2014-03-25 11:44:27.874206	4235	20.1	1	1
2014-03-25 11:44:28.096325	4236	53	2	1
2014-03-25 11:44:32.775203	4237	466	3	2
2014-03-25 11:44:44.775145	4238	434	3	2
2014-03-26 19:37:08.280604	29352	50	2	9
2014-03-26 19:37:08.58744	29353	676	3	2
2014-03-25 11:44:56.775593	4243	434	3	2
2014-03-25 11:45:06.875025	4244	20.1	1	1
2014-03-25 11:45:07.106957	4245	53	2	1
2014-03-26 19:37:08.82474	29354	1086820.7326996503	4	2
2014-03-26 19:37:09.142243	29355	20.7	1	8
2014-03-25 11:45:32.775589	4250	434	3	2
2014-03-25 11:45:46.113186	4251	20.1	1	1
2014-03-25 11:45:46.335876	4252	53	2	1
2014-03-26 19:37:09.36772	29356	52	2	8
2014-03-26 19:37:20.579892	29357	595	3	2
2014-03-25 11:46:24.875096	4257	20.1	1	1
2014-03-25 11:46:25.097445	4258	53	2	1
2014-03-25 11:46:32.779474	4259	418	3	2
2014-03-26 19:37:20.820371	29358	1086823.0307690932	4	2
2014-03-26 19:37:23.780988	29359	21.5	1	1
2014-03-25 11:47:03.875603	4264	20.1	1	1
2014-03-25 11:47:04.152397	4265	53	2	1
2014-03-26 19:37:24.006675	29360	49	2	1
2014-03-26 19:37:32.579384	29361	724	3	2
2014-03-25 11:47:32.77661	4270	418	3	2
2014-03-25 11:47:42.873305	4271	20.1	1	1
2014-03-25 11:47:43.096789	4272	53	2	1
2014-03-26 19:37:32.824645	29362	1086825.328838536	4	2
2014-03-26 19:37:36.664706	29363	22.0	1	10
2014-03-25 11:48:21.870413	4277	20.1	1	1
2014-03-25 11:48:22.116198	4278	53	2	1
2014-03-25 11:48:32.775308	4279	418	3	2
2014-03-26 19:37:36.893427	29364	40	2	10
2014-03-26 19:37:44.579754	29365	724	3	2
2014-03-25 11:48:44.775577	4284	370	3	2
2014-03-25 11:48:56.773588	4285	370	3	2
2014-03-25 11:49:00.869414	4286	20.1	1	1
2014-03-25 11:49:01.090587	4287	53	2	1
2014-03-25 11:49:20.776425	4288	402	3	2
2014-03-26 19:37:44.817242	29366	1086827.626907979	4	2
2014-03-26 19:37:47.056229	29367	21.3	1	9
2014-03-25 11:49:32.77809	4293	370	3	2
2014-03-25 11:49:39.872452	4294	20.1	1	1
2014-03-25 11:49:40.407346	4295	53	2	1
2014-03-25 11:49:44.775499	4296	370	3	2
2014-03-25 11:49:56.774151	4297	402	3	2
2014-03-26 19:37:47.278544	29368	50	2	9
2014-03-26 19:37:48.141332	29369	20.7	1	8
2014-03-25 11:50:08.778636	4302	402	3	2
2014-03-25 11:50:18.87028	4303	20.1	1	1
2014-03-25 11:50:19.128116	4304	53	2	1
2014-03-25 11:50:32.774081	4305	370	3	2
2014-03-26 19:37:48.375449	29370	52	2	8
2014-03-26 19:38:02.78188	29371	21.5	1	1
2014-03-25 11:50:44.774778	4310	402	3	2
2014-03-25 11:50:56.779159	4311	402	3	2
2014-03-25 11:50:57.870495	4312	20.1	1	1
2014-03-25 11:50:58.093236	4313	53	2	1
2014-03-25 11:51:08.776511	4314	354	3	2
2014-03-26 19:38:03.007881	29372	49	2	1
2014-03-26 19:38:15.664995	29373	22.2	1	10
2014-03-25 11:51:20.777036	4319	402	3	2
2014-03-25 11:51:32.774017	4320	434	3	2
2014-03-25 11:51:36.871354	4321	20.1	1	1
2014-03-25 11:51:37.113991	4322	53	2	1
2014-03-25 11:51:44.777983	4323	418	3	2
2014-03-26 19:38:15.901121	29374	40	2	10
2014-03-26 19:38:26.055493	29375	21.3	1	9
2014-03-25 11:52:15.869473	4328	20.1	1	1
2014-03-25 11:52:16.092997	4329	53	2	1
2014-03-25 11:52:32.779369	4330	434	3	2
2014-03-26 19:38:26.279089	29376	50	2	9
2014-03-26 19:38:27.142741	29377	20.8	1	8
2014-03-25 11:52:54.872923	4335	20.1	1	1
2014-03-25 11:52:55.095105	4336	53	2	1
2014-03-26 19:38:27.377664	29378	52	2	8
2014-03-26 19:38:32.581117	29379	659	3	2
2014-03-26 19:38:32.807935	29380	1086836.81918575	4	2
2014-03-25 11:53:32.77401	4341	418	3	2
2014-03-25 11:53:33.871365	4342	20.1	1	1
2014-03-25 11:53:34.150104	4343	53	2	1
2014-03-26 19:38:41.77645	29381	21.5	1	1
2014-03-26 19:38:42.013457	29382	49	2	1
2014-03-25 11:54:12.8668	4348	20.1	1	1
2014-03-25 11:54:13.091364	4349	53	2	1
2014-03-25 11:54:32.775257	4350	418	3	2
2014-03-25 11:42:51.793825	4218	21.1	1	10
2014-03-25 11:42:52.019139	4219	57	2	10
2014-03-25 11:43:30.792498	4224	21.1	1	10
2014-03-25 11:43:31.016236	4225	57	2	10
2014-03-25 11:44:09.793868	4231	21.1	1	10
2014-03-25 11:44:10.017686	4232	57	2	10
2014-03-25 11:44:48.793393	4239	21.1	1	10
2014-03-25 11:44:49.015805	4240	57	2	10
2014-03-25 11:45:27.794375	4246	21.1	1	10
2014-03-25 11:45:28.01729	4247	57	2	10
2014-03-25 11:46:06.794417	4253	21.1	1	10
2014-03-25 11:46:07.0158	4254	57	2	10
2014-03-25 11:46:45.795499	4260	21.1	1	10
2014-03-25 11:46:46.017713	4261	57	2	10
2014-03-25 11:47:24.79531	4266	21.1	1	10
2014-03-25 11:47:25.029915	4267	57	2	10
2014-03-25 11:48:03.79523	4273	21.1	1	10
2014-03-25 11:48:04.049995	4274	57	2	10
2014-03-25 11:48:42.794722	4280	21.1	1	10
2014-03-25 11:48:43.017929	4281	57	2	10
2014-03-25 11:49:21.79465	4289	21.1	1	10
2014-03-25 11:49:22.026624	4290	57	2	10
2014-03-25 11:50:00.796192	4298	21.1	1	10
2014-03-25 11:50:01.067165	4299	57	2	10
2014-03-25 11:50:39.79579	4306	21.1	1	10
2014-03-25 11:50:40.019338	4307	57	2	10
2014-03-25 11:51:18.796495	4315	21.1	1	10
2014-03-25 11:51:19.019273	4316	57	2	10
2014-03-25 11:51:57.796457	4324	21.1	1	10
2014-03-25 11:51:58.019227	4325	57	2	10
2014-03-25 11:52:36.796434	4331	21.1	1	10
2014-03-25 11:52:37.018467	4332	56	2	10
2014-03-25 11:53:15.797058	4337	21.1	1	10
2014-03-26 19:38:44.579745	29383	724	3	2
2014-03-26 19:38:44.804299	29384	1086839.117255193	4	2
2014-03-25 11:54:51.86934	4355	20.1	1	1
2014-03-25 11:54:52.091648	4356	53	2	1
2014-03-26 19:38:54.663804	29385	22.4	1	10
2014-03-26 19:38:54.898894	29386	41	2	10
2014-03-25 11:55:30.867558	4361	20.1	1	1
2014-03-25 11:55:31.101695	4362	53	2	1
2014-03-25 11:55:32.775567	4363	434	3	2
2014-03-26 19:39:05.056594	29387	21.3	1	9
2014-03-26 19:39:05.281462	29388	50	2	9
2014-03-25 11:55:56.775193	4368	402	3	2
2014-03-25 11:56:08.776487	4369	402	3	2
2014-03-25 11:56:09.869617	4370	20.1	1	1
2014-03-25 11:56:10.095396	4371	53	2	1
2014-03-25 11:56:30.597835	4372	434	3	2
2014-03-26 19:39:06.143117	29389	20.8	1	8
2014-03-26 19:39:06.386352	29390	52	2	8
2014-03-25 11:56:32.775889	4377	434	3	2
2014-03-25 11:56:48.868586	4378	20.1	1	1
2014-03-25 11:56:49.091797	4379	53	2	1
2014-03-25 11:56:56.775586	4380	402	3	2
2014-03-25 11:57:08.778079	4381	418	3	2
2014-03-26 19:39:20.775955	29391	21.5	1	1
2014-03-26 19:39:21.000633	29392	49	2	1
2014-03-25 11:57:20.777463	4386	466	3	2
2014-03-25 11:57:27.869773	4387	20.1	1	1
2014-03-25 11:57:28.092365	4388	53	2	1
2014-03-25 11:57:32.778912	4389	450	3	2
2014-03-26 19:39:32.579936	29393	724	3	2
2014-03-26 19:39:32.814799	29394	1086849.4585676857	4	2
2014-03-25 11:58:06.865814	4394	20.1	1	1
2014-03-25 11:58:07.098941	4395	53	2	1
2014-03-26 19:39:33.663263	29395	22.6	1	10
2014-03-26 19:39:33.887616	29396	40	2	10
2014-03-25 11:58:32.775179	4400	466	3	2
2014-03-25 11:58:45.862654	4401	20.1	1	1
2014-03-25 11:58:46.086546	4402	53	2	1
2014-03-26 19:39:44.055315	29397	21.4	1	9
2014-03-26 19:39:44.293982	29398	50	2	9
2014-03-25 11:59:24.865243	4407	20.1	1	1
2014-03-25 11:59:25.093851	4408	53	2	1
2014-03-25 11:59:32.774961	4409	450	3	2
2014-03-26 19:39:45.144162	29399	20.8	1	8
2014-03-26 19:39:45.367363	29400	52	2	8
2014-03-25 12:00:03.867765	4414	20.1	1	1
2014-03-25 12:00:04.093129	4415	53	2	1
2014-03-26 19:39:59.775745	29401	21.5	1	1
2014-03-26 19:40:00.011165	29402	49	2	1
2014-03-25 12:00:32.775898	4420	450	3	2
2014-03-25 12:00:42.865919	4421	20.1	1	1
2014-03-25 12:00:43.091972	4422	53	2	1
2014-03-26 19:40:12.719074	29403	22.6	1	10
2014-03-26 19:40:12.94446	29404	40	2	10
2014-03-25 12:01:21.862781	4427	20.1	1	1
2014-03-25 12:01:22.097162	4428	53	2	1
2014-03-25 12:01:32.776829	4429	450	3	2
2014-03-26 19:40:20.579489	29405	837	3	2
2014-03-26 19:40:20.814798	29406	1086858.650845457	4	2
2014-03-25 12:02:00.863906	4434	20.1	1	1
2014-03-25 12:02:01.100575	4435	53	2	1
2014-03-26 19:40:23.056702	29407	21.4	1	9
2014-03-26 19:40:23.281498	29408	50	2	9
2014-03-25 12:02:32.7748	4440	450	3	2
2014-03-25 12:02:39.860566	4441	20.1	1	1
2014-03-25 12:02:40.084223	4442	53	2	1
2014-03-26 19:40:24.142621	29409	20.8	1	8
2014-03-26 19:40:24.378292	29410	52	2	8
2014-03-25 12:03:18.874031	4447	20.1	1	1
2014-03-25 12:03:19.096181	4448	53	2	1
2014-03-25 12:03:20.777031	4449	498	3	2
2014-03-25 12:03:32.773549	4450	482	3	2
2014-03-26 19:40:32.579851	29411	869	3	2
2014-03-26 19:40:32.804629	29412	1086862.0979496213	4	2
2014-03-25 12:03:57.866007	4455	20.1	1	1
2014-03-25 12:03:58.091018	4456	53	2	1
2014-03-26 19:40:38.776325	29413	21.4	1	1
2014-03-26 19:40:39.015626	29414	49	2	1
2014-03-25 12:04:32.77236	4461	498	3	2
2014-03-25 12:04:36.865123	4462	20.1	1	1
2014-03-25 12:04:37.089246	4463	53	2	1
2014-03-25 12:04:44.774796	4464	466	3	2
2014-03-25 12:04:56.772288	4465	466	3	2
2014-03-26 19:40:44.58155	29415	869	3	2
2014-03-26 19:40:44.810108	29416	1086864.3960190641	4	2
2014-03-25 12:05:15.863598	4470	20.1	1	1
2014-03-25 12:05:16.08762	4471	53	2	1
2014-03-25 12:05:32.775815	4472	466	3	2
2014-03-26 19:40:51.659398	29417	22.6	1	10
2014-03-26 19:40:51.895771	29418	39	2	10
2014-03-25 12:05:54.865825	4477	20.1	1	1
2014-03-25 12:05:55.089109	4478	53	2	1
2014-03-26 19:41:02.056225	29419	21.4	1	9
2014-03-25 12:06:32.777101	4483	466	3	2
2014-03-25 12:06:33.859206	4484	20.1	1	1
2014-03-25 12:06:34.082999	4485	53	2	1
2014-03-25 11:55:12.796728	4357	21.1	1	10
2014-03-25 11:55:13.030121	4358	56	2	10
2014-03-25 11:55:51.797658	4364	21.1	1	10
2014-03-25 11:55:52.021026	4365	56	2	10
2014-03-25 11:56:30.914241	4373	21.1	1	10
2014-03-25 11:56:31.137103	4374	56	2	10
2014-03-25 11:57:09.797781	4382	21.1	1	10
2014-03-25 11:57:10.024538	4383	56	2	10
2014-03-25 11:57:48.799051	4390	21.1	1	10
2014-03-25 11:57:49.033846	4391	56	2	10
2014-03-25 11:58:27.798087	4396	21.1	1	10
2014-03-25 11:58:28.022925	4397	56	2	10
2014-03-25 11:59:06.800308	4403	21.1	1	10
2014-03-25 11:59:07.024896	4404	56	2	10
2014-03-25 11:59:46.00513	4410	21.1	1	10
2014-03-25 11:59:46.230161	4411	56	2	10
2014-03-25 12:00:24.807195	4416	21.1	1	10
2014-03-25 12:00:25.038961	4417	56	2	10
2014-03-25 12:01:03.792553	4423	21.1	1	10
2014-03-25 12:01:04.024817	4424	56	2	10
2014-03-25 12:01:42.799061	4430	21.1	1	10
2014-03-25 12:01:43.021322	4431	56	2	10
2014-03-25 12:02:21.799586	4436	21.1	1	10
2014-03-25 12:02:22.021354	4437	56	2	10
2014-03-25 12:03:00.802499	4443	21.1	1	10
2014-03-25 12:03:01.025067	4444	56	2	10
2014-03-25 12:03:39.80175	4451	21.1	1	10
2014-03-25 12:03:40.026072	4452	56	2	10
2014-03-25 12:04:18.800146	4457	21.1	1	10
2014-03-25 12:04:19.047904	4458	56	2	10
2014-03-25 12:04:57.80179	4466	21.1	1	10
2014-03-25 12:04:58.02403	4467	56	2	10
2014-03-25 12:05:36.799831	4473	21.1	1	10
2014-03-25 12:05:37.025154	4474	56	2	10
2014-03-25 12:06:15.800692	4479	21.1	1	10
2014-03-25 12:06:16.033146	4480	56	2	10
2014-03-25 12:07:12.860377	4490	20.1	1	1
2014-03-25 12:07:13.093427	4491	53	2	1
2014-03-25 12:07:32.774971	4492	466	3	2
2014-03-25 12:07:51.864034	4497	20.1	1	1
2014-03-25 12:07:52.098707	4498	53	2	1
2014-03-26 19:41:02.279104	29420	50	2	9
2014-03-26 19:41:03.142545	29421	20.8	1	8
2014-03-25 12:08:30.857749	4503	20.1	1	1
2014-03-25 12:08:31.080335	4504	53	2	1
2014-03-25 12:08:32.775602	4505	450	3	2
2014-03-26 19:41:03.376783	29422	52	2	8
2014-03-26 19:41:17.776712	29423	21.4	1	1
2014-03-25 12:08:56.773388	4510	418	3	2
2014-03-25 12:09:08.773333	4511	418	3	2
2014-03-25 12:09:09.864205	4512	20.1	1	1
2014-03-25 12:09:10.101217	4513	53	2	1
2014-03-26 19:41:18.00572	29424	49	2	1
2014-03-26 19:41:30.662769	29425	22.6	1	10
2014-03-25 12:09:32.775142	4518	418	3	2
2014-03-25 12:09:48.859745	4519	20.1	1	1
2014-03-25 12:09:49.084535	4520	53	2	1
2014-03-26 19:41:30.898	29426	39	2	10
2014-03-26 19:41:41.054646	29427	21.4	1	9
2014-03-25 12:10:27.863068	4525	20.1	1	1
2014-03-25 12:10:28.086776	4526	53	2	1
2014-03-25 12:10:32.780623	4527	418	3	2
2014-03-26 19:41:41.279192	29428	50	2	9
2014-03-26 19:41:42.142592	29429	20.8	1	8
2014-03-25 12:11:06.864615	4532	20.1	1	1
2014-03-25 12:11:07.087146	4533	53	2	1
2014-03-26 19:41:42.375313	29430	52	2	8
2014-03-26 19:41:44.582151	29431	965	3	2
2014-03-26 19:41:44.808863	29432	1086879.3334704426	4	2
2014-03-26 19:41:56.575781	29433	949	3	2
2014-03-25 12:11:32.772755	4540	418	3	2
2014-03-25 12:11:44.776159	4541	354	3	2
2014-03-25 12:11:45.861843	4542	20.1	1	1
2014-03-25 12:11:46.094424	4543	53	2	1
2014-03-25 12:11:56.778913	4544	338	3	2
2014-03-26 19:41:56.809743	29434	1086882.7805746067	4	2
2014-03-26 19:41:57.118799	29435	21.4	1	1
2014-03-25 12:12:24.86131	4549	20.1	1	1
2014-03-25 12:12:25.103808	4550	53	2	1
2014-03-25 12:12:32.774567	4551	338	3	2
2014-03-26 19:41:57.343365	29436	49	2	1
2014-03-26 19:42:09.667188	29437	22.5	1	10
2014-03-25 12:13:03.860397	4556	20.1	1	1
2014-03-25 12:13:04.088803	4557	53	2	1
2014-03-26 19:42:09.911972	29438	39	2	10
2014-03-26 19:42:20.055285	29439	21.4	1	9
2014-03-25 12:13:32.778183	4562	338	3	2
2014-03-25 12:13:42.857116	4563	20.1	1	1
2014-03-25 12:13:43.081401	4564	53	2	1
2014-03-26 19:42:20.278225	29440	49	2	9
2014-03-26 19:42:20.585808	29441	901	3	2
2014-03-25 12:14:21.864643	4569	20.1	1	1
2014-03-25 12:14:22.087225	4570	53	2	1
2014-03-25 12:14:32.775841	4571	354	3	2
2014-03-26 19:42:20.819434	29442	1086889.6747829353	4	2
2014-03-26 19:42:21.14256	29443	20.8	1	8
2014-03-25 12:15:00.851329	4576	20.1	1	1
2014-03-25 12:15:01.076962	4577	53	2	1
2014-03-25 12:15:20.784715	4578	402	3	2
2014-03-26 19:42:21.365245	29444	52	2	8
2014-03-26 19:42:32.579775	29445	965	3	2
2014-03-25 12:15:32.771383	4583	402	3	2
2014-03-25 12:15:39.859243	4584	20.1	1	1
2014-03-25 12:15:40.08441	4585	53	2	1
2014-03-26 19:42:32.815658	29446	1086891.9728523782	4	2
2014-03-26 19:42:35.776845	29447	21.4	1	1
2014-03-25 12:16:18.859358	4590	20.1	1	1
2014-03-25 12:16:19.082841	4591	53	2	1
2014-03-26 19:42:36.000024	29448	49	2	1
2014-03-26 19:42:44.579855	29449	981	3	2
2014-03-25 12:16:32.771642	4594	402	3	2
2014-03-26 19:42:44.819082	29450	1086895.4199565423	4	2
2014-03-26 19:42:48.666766	29451	22.5	1	10
2014-03-25 12:16:42.42283	4599	20.5	1	8
2014-03-25 12:16:42.64532	4600	63	2	8
2014-03-25 12:16:44.77407	4601	370	3	2
2014-03-25 12:16:56.772468	4602	402	3	2
2014-03-25 12:16:57.85952	4603	20.1	1	1
2014-03-25 12:16:58.092594	4604	53	2	1
2014-03-25 12:17:08.822498	4605	370	3	2
2014-03-26 19:42:48.889589	29452	39	2	10
2014-03-25 12:17:20.775195	4610	402	3	2
2014-03-25 12:17:21.187768	4611	20.7	1	8
2014-03-25 12:17:21.416199	4612	64	2	8
2014-03-25 12:17:32.770583	4613	370	3	2
2014-03-25 12:17:36.857981	4614	20.1	1	1
2014-03-25 12:17:37.103565	4615	53	2	1
2014-03-25 12:17:44.772744	4616	370	3	2
2014-03-25 12:17:56.772099	4617	418	3	2
2014-03-25 12:18:00.186504	4622	20.8	1	8
2014-03-25 12:18:00.418845	4623	63	2	8
2014-03-25 12:18:08.773576	4624	370	3	2
2014-03-25 12:06:55.737972	4489	61	2	9
2014-03-25 12:07:34.558161	4495	20.2	1	9
2014-03-25 12:07:34.784136	4496	61	2	9
2014-03-25 12:07:33.802718	4493	21.1	1	10
2014-03-25 12:07:34.025398	4494	56	2	10
2014-03-25 12:08:12.803911	4499	21.1	1	10
2014-03-25 12:08:13.02805	4500	56	2	10
2014-03-25 12:08:51.803968	4506	21.1	1	10
2014-03-25 12:08:52.046077	4507	56	2	10
2014-03-25 12:09:30.810114	4514	21.1	1	10
2014-03-25 12:09:31.035801	4515	56	2	10
2014-03-25 12:10:09.803984	4521	21.1	1	10
2014-03-25 12:10:10.033553	4522	56	2	10
2014-03-25 12:10:48.802995	4528	21.1	1	10
2014-03-25 12:10:49.027048	4529	56	2	10
2014-03-25 12:11:27.803385	4536	21.1	1	10
2014-03-25 12:11:28.027982	4537	56	2	10
2014-03-25 12:12:06.802501	4545	21.1	1	10
2014-03-25 12:12:07.025337	4546	56	2	10
2014-03-25 12:12:45.803184	4552	21.1	1	10
2014-03-25 12:12:46.026807	4553	56	2	10
2014-03-25 12:13:24.804953	4558	21.1	1	10
2014-03-25 12:13:25.029553	4559	56	2	10
2014-03-25 12:14:03.806637	4565	21.1	1	10
2014-03-25 12:14:04.028862	4566	56	2	10
2014-03-25 12:14:42.839907	4572	21.1	1	10
2014-03-25 12:14:43.078021	4573	56	2	10
2014-03-25 12:15:21.806781	4579	21.1	1	10
2014-03-25 12:15:22.051439	4580	56	2	10
2014-03-25 12:16:00.803674	4586	21.1	1	10
2014-03-25 12:16:01.026993	4587	56	2	10
2014-03-25 12:16:39.804295	4595	21.0	1	10
2014-03-25 12:16:40.026263	4596	56	2	10
2014-03-25 12:17:18.805481	4606	21.0	1	10
2014-03-25 12:17:19.033684	4607	56	2	10
2014-03-25 12:17:57.808022	4618	21.0	1	10
2014-03-25 12:18:15.855311	4625	20.1	1	1
2014-03-25 12:18:16.078799	4626	53	2	1
2014-03-25 12:18:20.772984	4627	402	3	2
2014-03-25 12:18:32.773053	4628	402	3	2
2014-03-26 19:42:56.577665	29453	1062	3	2
2014-03-26 19:42:56.815231	29454	1086898.8670607067	4	2
2014-03-25 12:18:39.18764	4633	20.9	1	8
2014-03-25 12:18:39.431744	4634	63	2	8
2014-03-25 12:18:54.851998	4635	20.1	1	1
2014-03-25 12:18:55.074091	4636	53	2	1
2014-03-26 19:42:59.055384	29455	21.4	1	9
2014-03-26 19:42:59.278026	29456	49	2	9
2014-03-25 12:19:18.188798	4641	20.9	1	8
2014-03-25 12:19:18.422224	4642	62	2	8
2014-03-25 12:19:32.776638	4643	402	3	2
2014-03-25 12:19:33.852171	4644	20.1	1	1
2014-03-25 12:19:34.074154	4645	53	2	1
2014-03-26 19:43:00.142188	29457	20.8	1	8
2014-03-26 19:43:00.375283	29458	52	2	8
2014-03-25 12:19:57.191463	4650	20.9	1	8
2014-03-25 12:19:57.4139	4651	62	2	8
2014-03-25 12:20:12.857144	4652	20.1	1	1
2014-03-25 12:20:13.082066	4653	53	2	1
2014-03-25 12:20:32.784975	4654	418	3	2
2014-03-26 19:43:08.577988	29459	1062	3	2
2014-03-26 19:43:08.804157	29460	1086902.314164871	4	2
2014-03-25 12:20:36.192838	4659	20.9	1	8
2014-03-25 12:20:36.425498	4660	61	2	8
2014-03-25 12:20:51.853977	4661	20.1	1	1
2014-03-25 12:20:52.089641	4662	53	2	1
2014-03-25 12:20:56.769777	4663	370	3	2
2014-03-25 12:21:08.77566	4664	370	3	2
2014-03-26 19:43:15.013151	29461	21.3	1	1
2014-03-26 19:43:15.247703	29462	49	2	1
2014-03-25 12:21:15.17662	4669	21.0	1	8
2014-03-25 12:21:15.409844	4670	61	2	8
2014-03-25 12:21:20.77429	4671	402	3	2
2014-03-25 12:21:30.866931	4672	20.1	1	1
2014-03-25 12:21:31.107358	4673	53	2	1
2014-03-25 12:21:32.783031	4674	370	3	2
2014-03-25 12:21:44.773542	4675	370	3	2
2014-03-26 19:43:27.667181	29463	22.5	1	10
2014-03-26 19:43:27.946795	29464	39	2	10
2014-03-25 12:22:09.856745	4680	20.1	1	1
2014-03-25 12:22:10.09987	4681	53	2	1
2014-03-25 12:22:20.776225	4682	402	3	2
2014-03-26 19:43:32.582715	29465	1046	3	2
2014-03-26 19:43:32.817931	29466	1086909.2083731994	4	2
2014-03-25 12:22:32.77856	4687	370	3	2
2014-03-25 12:22:44.772819	4688	370	3	2
2014-03-25 12:22:48.855602	4689	20.1	1	1
2014-03-25 12:22:49.076986	4690	53	2	1
2014-03-26 19:43:38.056014	29467	21.5	1	9
2014-03-26 19:43:38.284353	29468	49	2	9
2014-03-25 12:23:12.18833	4695	21.1	1	8
2014-03-25 12:23:12.419411	4696	60	2	8
2014-03-25 12:23:27.856883	4697	20.1	1	1
2014-03-25 12:23:28.078958	4698	53	2	1
2014-03-25 12:23:32.772129	4699	370	3	2
2014-03-26 19:43:39.140981	29469	20.8	1	8
2014-03-26 19:43:39.374991	29470	53	2	8
2014-03-25 12:23:51.1862	4704	21.2	1	8
2014-03-25 12:23:51.408433	4705	61	2	8
2014-03-25 12:24:06.854369	4706	20.1	1	1
2014-03-25 12:24:07.088718	4707	53	2	1
2014-03-25 12:24:08.77434	4708	402	3	2
2014-03-25 12:24:20.778113	4709	354	3	2
2014-03-26 19:43:53.779036	29471	21.3	1	1
2014-03-26 19:43:54.006056	29472	49	2	1
2014-03-25 12:24:30.188272	4714	21.3	1	8
2014-03-25 12:24:30.428119	4715	60	2	8
2014-03-25 12:24:32.775424	4716	370	3	2
2014-03-25 12:24:45.886132	4717	20.1	1	1
2014-03-25 12:24:46.108915	4718	53	2	1
2014-03-26 19:44:06.666241	29473	22.4	1	10
2014-03-26 19:44:06.902452	29474	39	2	10
2014-03-25 12:25:09.188322	4723	21.3	1	8
2014-03-25 12:25:09.410229	4724	59	2	8
2014-03-25 12:25:24.852017	4725	20.1	1	1
2014-03-25 12:25:25.103536	4726	53	2	1
2014-03-25 12:25:32.771905	4727	370	3	2
2014-03-26 19:44:17.057305	29475	21.5	1	9
2014-03-26 19:44:17.281179	29476	49	2	9
2014-03-25 12:25:48.320163	4732	21.3	1	8
2014-03-25 12:25:48.755233	4733	59	2	8
2014-03-25 12:25:56.90102	4734	402	3	2
2014-03-25 12:26:03.991134	4735	20.1	1	1
2014-03-25 12:26:04.410042	4736	53	2	1
2014-03-25 12:26:08.930018	4737	370	3	2
2014-03-25 12:26:20.771096	4738	370	3	2
2014-03-26 19:44:18.141532	29477	20.8	1	8
2014-03-26 19:44:18.375929	29478	53	2	8
2014-03-25 12:26:27.189361	4743	21.2	1	8
2014-03-25 12:26:27.421092	4744	58	2	8
2014-03-25 12:26:32.775041	4745	370	3	2
2014-03-25 12:26:42.979987	4746	20.1	1	1
2014-03-25 12:26:43.410023	4747	53	2	1
2014-03-26 19:44:32.571868	29479	1046	3	2
2014-03-26 19:44:32.797671	29480	1086927.592928742	4	2
2014-03-26 19:44:33.114774	29481	21.3	1	1
2014-03-25 12:27:06.190103	4752	21.2	1	8
2014-03-25 12:27:06.414243	4753	58	2	8
2014-03-25 12:27:20.773215	4754	418	3	2
2014-03-25 12:27:21.850845	4755	20.1	1	1
2014-03-25 12:27:22.084578	4756	53	2	1
2014-03-25 12:27:32.773064	4757	434	3	2
2014-03-25 12:18:36.804724	4629	21.0	1	10
2014-03-25 12:18:37.039204	4630	56	2	10
2014-03-25 12:19:15.806426	4637	21.0	1	10
2014-03-25 12:19:16.039191	4638	55	2	10
2014-03-25 12:19:54.805295	4646	21.0	1	10
2014-03-25 12:19:55.029627	4647	55	2	10
2014-03-25 12:20:33.817943	4655	21.0	1	10
2014-03-25 12:20:34.059389	4656	55	2	10
2014-03-25 12:21:12.805326	4665	21.0	1	10
2014-03-25 12:21:13.039202	4666	55	2	10
2014-03-25 12:21:51.807923	4676	21.0	1	10
2014-03-25 12:21:52.041618	4677	55	2	10
2014-03-25 12:22:30.806722	4683	21.0	1	10
2014-03-25 12:22:31.030317	4684	55	2	10
2014-03-25 12:23:09.806646	4691	21.0	1	10
2014-03-25 12:23:10.03979	4692	55	2	10
2014-03-25 12:23:48.805678	4700	21.0	1	10
2014-03-25 12:23:49.0285	4701	55	2	10
2014-03-25 12:24:27.808595	4710	21.0	1	10
2014-03-25 12:24:28.070718	4711	55	2	10
2014-03-25 12:25:06.82009	4719	21.0	1	10
2014-03-25 12:25:07.044713	4720	55	2	10
2014-03-25 12:25:45.806763	4728	21.0	1	10
2014-03-25 12:25:46.030899	4729	55	2	10
2014-03-25 12:26:24.934883	4739	21.0	1	10
2014-03-25 12:26:25.388074	4740	55	2	10
2014-03-25 12:27:03.80785	4748	21.0	1	10
2014-03-26 19:44:33.347913	29482	49	2	1
2014-03-25 12:27:45.186524	4762	21.1	1	8
2014-03-25 12:27:45.412168	4763	58	2	8
2014-03-25 12:28:00.849417	4764	20.1	1	1
2014-03-25 12:28:01.072872	4765	53	2	1
2014-03-26 19:44:45.666365	29483	22.4	1	10
2014-03-26 19:44:45.890829	29484	39	2	10
2014-03-25 12:28:24.188288	4770	21.1	1	8
2014-03-25 12:28:24.43325	4771	58	2	8
2014-03-25 12:28:32.770002	4772	531	3	2
2014-03-25 12:28:39.851861	4773	20.1	1	1
2014-03-25 12:28:40.075418	4774	53	2	1
2014-03-25 12:28:44.773872	4775	531	3	2
2014-03-26 19:44:56.056986	29485	21.5	1	9
2014-03-26 19:44:56.303319	29486	49	2	9
2014-03-25 12:29:03.188325	4780	21.0	1	8
2014-03-25 12:29:03.420675	4781	57	2	8
2014-03-25 12:29:18.850873	4782	20.1	1	1
2014-03-25 12:29:19.072825	4783	53	2	1
2014-03-25 12:29:32.772513	4784	531	3	2
2014-03-26 19:44:57.143252	29487	20.8	1	8
2014-03-26 19:44:57.366484	29488	53	2	8
2014-03-25 12:29:42.186235	4789	21.0	1	8
2014-03-25 12:29:42.408116	4790	57	2	8
2014-03-25 12:29:57.847092	4791	20.1	1	1
2014-03-25 12:29:58.080789	4792	53	2	1
2014-03-26 19:45:11.775504	29489	21.3	1	1
2014-03-26 19:45:12.009535	29490	49	2	1
2014-03-25 12:30:21.186076	4797	20.9	1	8
2014-03-25 12:30:21.409457	4798	57	2	8
2014-03-25 12:30:32.772277	4799	547	3	2
2014-03-25 12:30:36.844569	4800	20.1	1	1
2014-03-25 12:30:37.068697	4801	53	2	1
2014-03-25 12:31:00.18794	4802	20.9	1	8
2014-03-25 12:31:00.420133	4803	57	2	8
2014-03-25 12:31:15.84983	4804	20.1	1	1
2014-03-25 12:31:16.074949	4805	53	2	1
2014-03-25 12:31:32.77027	4806	547	3	2
2014-03-26 19:45:24.664289	29491	22.4	1	10
2014-03-26 19:45:24.890269	29492	39	2	10
2014-03-25 12:31:39.185654	4811	20.8	1	8
2014-03-25 12:31:39.410625	4812	57	2	8
2014-03-25 12:31:54.848543	4813	20.1	1	1
2014-03-25 12:31:55.082041	4814	53	2	1
2014-03-25 12:32:08.774218	4815	515	3	2
2014-03-26 19:45:32.58335	29493	1046	3	2
2014-03-26 19:45:32.819033	29494	1086944.8284495631	4	2
2014-03-25 12:32:18.188989	4820	20.8	1	8
2014-03-25 12:32:18.421514	4821	57	2	8
2014-03-25 12:32:20.773031	4822	498	3	2
2014-03-25 12:32:32.77377	4823	498	3	2
2014-03-25 12:32:33.84719	4824	20.1	1	1
2014-03-25 12:32:34.078244	4825	53	2	1
2014-03-26 19:45:35.054827	29495	21.5	1	9
2014-03-26 19:45:35.27995	29496	49	2	9
2014-03-25 12:32:56.764277	4830	418	3	2
2014-03-25 12:32:57.186822	4831	20.8	1	8
2014-03-25 12:32:57.409556	4832	57	2	8
2014-03-25 12:33:08.774015	4833	418	3	2
2014-03-25 12:33:12.852519	4834	20.0	1	1
2014-03-25 12:33:13.074935	4835	53	2	1
2014-03-25 12:33:32.771907	4836	418	3	2
2014-03-26 19:45:36.141961	29497	20.9	1	8
2014-03-26 19:45:36.378313	29498	53	2	8
2014-03-25 12:33:36.186194	4841	20.7	1	8
2014-03-25 12:33:36.409244	4842	57	2	8
2014-03-25 12:33:51.851486	4843	20.0	1	1
2014-03-25 12:33:52.081698	4844	53	2	1
2014-03-26 19:45:50.773082	29499	21.2	1	1
2014-03-26 19:45:50.999446	29500	49	2	1
2014-03-25 12:34:15.194233	4849	20.7	1	8
2014-03-25 12:34:15.419889	4850	57	2	8
2014-03-25 12:34:30.849455	4851	20.0	1	1
2014-03-25 12:34:31.083034	4852	53	2	1
2014-03-25 12:34:32.773415	4853	418	3	2
2014-03-26 19:46:03.66857	29501	22.4	1	10
2014-03-26 19:46:03.903564	29502	39	2	10
2014-03-25 12:34:54.190538	4858	20.7	1	8
2014-03-25 12:34:54.423993	4859	57	2	8
2014-03-25 12:35:09.843665	4860	20.0	1	1
2014-03-25 12:35:10.066516	4861	53	2	1
2014-03-26 19:46:14.056087	29503	21.5	1	9
2014-03-26 19:46:14.279289	29504	49	2	9
2014-03-25 12:35:32.775769	4866	402	3	2
2014-03-25 12:35:33.187934	4867	20.7	1	8
2014-03-25 12:35:33.413007	4868	57	2	8
2014-03-25 12:35:44.770837	4869	450	3	2
2014-03-25 12:35:48.848645	4870	20.0	1	1
2014-03-25 12:35:49.069293	4871	53	2	1
2014-03-25 12:35:56.773567	4872	402	3	2
2014-03-25 12:36:08.775714	4873	370	3	2
2014-03-26 19:46:15.141042	29505	20.9	1	8
2014-03-26 19:46:15.376275	29506	53	2	8
2014-03-25 12:36:12.187763	4878	20.6	1	8
2014-03-25 12:36:12.409643	4879	57	2	8
2014-03-25 12:36:20.771835	4880	370	3	2
2014-03-25 12:36:27.84449	4881	20.1	1	1
2014-03-25 12:36:28.068555	4882	53	2	1
2014-03-25 12:36:32.770766	4883	402	3	2
2014-03-25 12:36:44.770437	4884	402	3	2
2014-03-26 19:46:29.773161	29507	21.2	1	1
2014-03-26 19:46:29.999238	29508	49	2	1
2014-03-26 19:46:32.578699	29509	1030	3	2
2014-03-25 12:36:51.186423	4889	20.6	1	8
2014-03-25 12:36:51.409038	4890	57	2	8
2014-03-25 12:37:06.842071	4891	20.1	1	1
2014-03-25 12:37:07.075907	4892	53	2	1
2014-03-25 12:37:20.630909	4893	370	3	2
2014-03-25 12:37:20.937833	4894	354	3	2
2014-03-25 12:28:21.807938	4766	21.0	1	10
2014-03-25 12:28:22.040554	4767	55	2	10
2014-03-25 12:29:00.809732	4776	21.0	1	10
2014-03-25 12:29:01.041269	4777	55	2	10
2014-03-25 12:29:39.807949	4785	21.0	1	10
2014-03-25 12:29:40.032956	4786	55	2	10
2014-03-25 12:30:18.810156	4793	21.0	1	10
2014-03-25 12:30:19.033868	4794	55	2	10
2014-03-25 12:31:36.808671	4807	21.0	1	10
2014-03-25 12:31:37.035565	4808	55	2	10
2014-03-25 12:32:15.808997	4816	21.0	1	10
2014-03-25 12:32:16.051479	4817	55	2	10
2014-03-25 12:32:54.808668	4826	21.0	1	10
2014-03-25 12:32:55.032312	4827	55	2	10
2014-03-25 12:33:33.807755	4837	21.0	1	10
2014-03-25 12:33:34.030647	4838	55	2	10
2014-03-25 12:34:12.80932	4845	21.0	1	10
2014-03-25 12:34:13.031042	4846	55	2	10
2014-03-25 12:34:51.812021	4854	21.0	1	10
2014-03-25 12:34:52.036519	4855	55	2	10
2014-03-25 12:35:30.811415	4862	21.0	1	10
2014-03-25 12:35:31.054445	4863	55	2	10
2014-03-25 12:36:09.8097	4874	21.0	1	10
2014-03-25 12:36:10.033271	4875	55	2	10
2014-03-25 12:36:48.81166	4885	21.0	1	10
2014-03-26 19:46:32.812518	29510	1086962.0639703844	4	2
2014-03-26 19:46:42.666941	29511	22.4	1	10
2014-03-25 12:37:30.189272	4899	20.6	1	8
2014-03-25 12:37:30.422413	4900	57	2	8
2014-03-25 12:37:44.770018	4901	402	3	2
2014-03-25 12:37:45.844888	4902	20.1	1	1
2014-03-25 12:37:46.067669	4903	53	2	1
2014-03-26 19:46:42.893317	29512	39	2	10
2014-03-26 19:46:53.056763	29513	21.6	1	9
2014-03-25 12:38:08.772795	4908	370	3	2
2014-03-25 12:38:09.187116	4909	20.6	1	8
2014-03-25 12:38:09.412625	4910	57	2	8
2014-03-25 12:38:20.774211	4911	450	3	2
2014-03-25 12:38:24.846423	4912	20.1	1	1
2014-03-25 12:38:25.067222	4913	53	2	1
2014-03-25 12:38:32.77002	4914	450	3	2
2014-03-26 19:46:53.290766	29514	49	2	9
2014-03-26 19:46:54.142965	29515	20.9	1	8
2014-03-25 12:38:48.187024	4919	20.6	1	8
2014-03-25 12:38:48.413578	4920	57	2	8
2014-03-25 12:39:03.842205	4921	20.1	1	1
2014-03-25 12:39:04.074728	4922	53	2	1
2014-03-26 19:46:54.365905	29516	53	2	8
2014-03-26 19:47:08.773191	29517	21.2	1	1
2014-03-25 12:39:27.186496	4927	20.5	1	8
2014-03-25 12:39:27.408678	4928	57	2	8
2014-03-25 12:39:32.770431	4929	450	3	2
2014-03-25 12:39:42.845852	4930	20.1	1	1
2014-03-25 12:39:43.068665	4931	53	2	1
2014-03-26 19:47:09.00796	29518	49	2	1
2014-03-26 19:47:21.667767	29519	22.4	1	10
2014-03-25 12:40:06.188157	4936	20.5	1	8
2014-03-25 12:40:06.440386	4937	57	2	8
2014-03-25 12:40:20.770782	4938	418	3	2
2014-03-25 12:40:21.843649	4939	20.1	1	1
2014-03-25 12:40:22.066764	4940	53	2	1
2014-03-25 12:40:32.772127	4941	418	3	2
2014-03-26 19:47:21.891818	29520	39	2	10
2014-03-26 19:47:32.054825	29521	21.6	1	9
2014-03-25 12:40:45.187905	4946	20.5	1	8
2014-03-25 12:40:45.411573	4947	57	2	8
2014-03-25 12:41:00.843851	4948	20.0	1	1
2014-03-25 12:41:01.067516	4949	53	2	1
2014-03-26 19:47:32.2885	29522	49	2	9
2014-03-26 19:47:32.597001	29523	1046	3	2
2014-03-25 12:41:24.188445	4954	20.5	1	8
2014-03-25 12:41:24.420748	4955	57	2	8
2014-03-25 12:41:32.77182	4956	418	3	2
2014-03-25 12:41:39.839001	4957	20.0	1	1
2014-03-25 12:41:40.062729	4958	53	2	1
2014-03-26 19:47:32.822175	29524	1086979.2994912057	4	2
2014-03-26 19:47:33.143035	29525	20.9	1	8
2014-03-25 12:42:03.187263	4963	20.5	1	8
2014-03-25 12:42:03.407884	4964	57	2	8
2014-03-25 12:42:18.843534	4965	20.0	1	1
2014-03-25 12:42:19.076185	4966	53	2	1
2014-03-25 12:42:32.770559	4967	418	3	2
2014-03-26 19:47:33.37669	29526	53	2	8
2014-03-26 19:47:47.777444	29527	21.2	1	1
2014-03-25 12:42:42.188916	4972	20.5	1	8
2014-03-25 12:42:42.410303	4973	57	2	8
2014-03-25 12:42:57.839096	4974	20.0	1	1
2014-03-25 12:42:58.062211	4975	53	2	1
2014-03-26 19:47:48.004551	29528	49	2	1
2014-03-26 19:48:00.671233	29529	22.4	1	10
2014-03-25 12:43:21.187189	4980	20.5	1	8
2014-03-25 12:43:21.420162	4981	57	2	8
2014-03-25 12:43:32.76974	4982	418	3	2
2014-03-25 12:43:36.842159	4983	20.0	1	1
2014-03-25 12:43:37.064894	4984	53	2	1
2014-03-26 19:48:00.905266	29530	39	2	10
2014-03-26 19:48:08.580194	29531	949	3	2
2014-03-25 12:44:00.186715	4989	20.5	1	8
2014-03-25 12:44:00.413435	4990	57	2	8
2014-03-25 12:44:15.84105	4991	20.0	1	1
2014-03-25 12:44:16.074214	4992	53	2	1
2014-03-25 12:44:32.769366	4993	370	3	2
2014-03-26 19:48:08.807437	29532	1086989.6408036985	4	2
2014-03-26 19:48:11.056523	29533	21.6	1	9
2014-03-25 12:44:39.186519	4998	20.5	1	8
2014-03-25 12:44:39.417613	4999	57	2	8
2014-03-25 12:44:44.769374	5000	370	3	2
2014-03-25 12:44:54.838663	5001	20.0	1	1
2014-03-25 12:44:55.061415	5002	53	2	1
2014-03-26 19:48:11.30016	29534	49	2	9
2014-03-26 19:48:12.140629	29535	20.9	1	8
2014-03-25 12:45:18.186646	5007	20.5	1	8
2014-03-25 12:45:18.407811	5008	57	2	8
2014-03-25 12:45:20.768944	5009	305	3	2
2014-03-25 12:45:32.768846	5010	338	3	2
2014-03-25 12:45:33.840827	5011	20.0	1	1
2014-03-25 12:45:34.063878	5012	53	2	1
2014-03-25 12:45:44.772187	5013	338	3	2
2014-03-26 19:48:12.3634	29536	53	2	8
2014-03-25 12:45:57.186206	5018	20.4	1	8
2014-03-25 12:45:57.408417	5019	57	2	8
2014-03-25 12:46:08.772586	5020	289	3	2
2014-03-25 12:46:12.848716	5021	20.0	1	1
2014-03-25 12:46:13.08253	5022	53	2	1
2014-03-25 12:46:20.771185	5023	289	3	2
2014-03-25 12:46:32.76915	5024	289	3	2
2014-03-25 12:46:36.185772	5029	20.4	1	8
2014-03-25 12:46:36.419086	5030	57	2	8
2014-03-25 12:46:51.839897	5031	20.0	1	1
2014-03-25 12:46:52.064246	5032	53	2	1
2014-03-25 12:38:06.809563	4904	21.0	1	10
2014-03-25 12:38:07.032907	4905	55	2	10
2014-03-25 12:38:45.809834	4915	21.0	1	10
2014-03-25 12:38:46.033676	4916	55	2	10
2014-03-25 12:39:24.810695	4923	21.0	1	10
2014-03-25 12:39:25.034813	4924	55	2	10
2014-03-25 12:40:03.811967	4932	21.0	1	10
2014-03-25 12:40:04.04315	4933	55	2	10
2014-03-25 12:40:42.813399	4942	21.0	1	10
2014-03-25 12:40:43.037005	4943	55	2	10
2014-03-25 12:41:21.811373	4950	21.0	1	10
2014-03-25 12:41:22.055457	4951	55	2	10
2014-03-25 12:42:00.810118	4959	21.0	1	10
2014-03-25 12:42:01.033546	4960	55	2	10
2014-03-25 12:42:39.822599	4968	21.0	1	10
2014-03-25 12:42:40.045961	4969	55	2	10
2014-03-25 12:43:18.811927	4976	21.0	1	10
2014-03-25 12:43:19.054606	4977	55	2	10
2014-03-25 12:43:57.811791	4985	21.0	1	10
2014-03-25 12:43:58.035538	4986	55	2	10
2014-03-25 12:44:36.812584	4994	21.0	1	10
2014-03-25 12:44:37.055968	4995	55	2	10
2014-03-25 12:45:15.811312	5003	21.0	1	10
2014-03-25 12:45:16.033947	5004	55	2	10
2014-03-25 12:45:54.81378	5014	20.9	1	10
2014-03-25 12:45:55.036545	5015	55	2	10
2014-03-25 12:46:33.814824	5025	20.9	1	10
2014-03-25 12:46:34.049077	5026	55	2	10
2014-03-26 19:48:20.580573	29537	949	3	2
2014-03-26 19:48:20.819021	29538	1086993.0879078626	4	2
2014-03-25 12:47:15.188963	5037	20.4	1	8
2014-03-25 12:47:15.422939	5038	57	2	8
2014-03-25 12:47:30.840017	5039	20.0	1	1
2014-03-25 12:47:31.064545	5040	53	2	1
2014-03-25 12:47:32.771227	5041	289	3	2
2014-03-26 19:48:26.77275	29539	21.2	1	1
2014-03-26 19:48:26.996869	29540	49	2	1
2014-03-25 12:47:54.188857	5046	20.4	1	8
2014-03-25 12:47:54.410547	5047	57	2	8
2014-03-25 12:48:09.84044	5048	20.0	1	1
2014-03-25 12:48:10.073795	5049	53	2	1
2014-03-26 19:48:32.579352	29541	965	3	2
2014-03-26 19:48:32.819089	29542	1086996.5350120268	4	2
2014-03-25 12:48:32.769437	5054	289	3	2
2014-03-25 12:48:33.1873	5055	20.4	1	8
2014-03-25 12:48:33.409268	5056	57	2	8
2014-03-25 12:48:48.841248	5057	20.0	1	1
2014-03-25 12:48:49.065663	5058	53	2	1
2014-03-26 19:48:39.66802	29543	22.3	1	10
2014-03-26 19:48:39.89448	29544	39	2	10
2014-03-25 12:49:12.186759	5063	20.4	1	8
2014-03-25 12:49:12.420604	5064	57	2	8
2014-03-25 12:49:27.840769	5065	20.0	1	1
2014-03-25 12:49:28.064584	5066	53	2	1
2014-03-25 12:49:32.768096	5067	289	3	2
2014-03-26 19:48:50.055346	29545	21.6	1	9
2014-03-26 19:48:50.29154	29546	49	2	9
2014-03-25 12:49:51.18861	5072	20.4	1	8
2014-03-25 12:49:51.41152	5073	57	2	8
2014-03-25 12:50:06.83855	5074	20.0	1	1
2014-03-25 12:50:07.062087	5075	53	2	1
2014-03-26 19:48:51.141123	29547	20.9	1	8
2014-03-26 19:48:51.365843	29548	53	2	8
2014-03-25 12:50:30.18703	5080	20.4	1	8
2014-03-25 12:50:30.410237	5081	57	2	8
2014-03-25 12:50:32.772549	5082	370	3	2
2014-03-25 12:50:44.767916	5083	354	3	2
2014-03-25 12:50:45.841385	5084	20.0	1	1
2014-03-25 12:50:46.063568	5085	53	2	1
2014-03-25 12:50:56.7687	5086	418	3	2
2014-03-26 19:49:05.774094	29549	21.1	1	1
2014-03-26 19:49:06.012429	29550	49	2	1
2014-03-25 12:51:08.769308	5091	418	3	2
2014-03-25 12:51:09.185703	5092	20.4	1	8
2014-03-25 12:51:09.406823	5093	57	2	8
2014-03-25 12:51:24.840463	5094	20.0	1	1
2014-03-25 12:51:25.06312	5095	53	2	1
2014-03-25 12:51:32.773225	5096	466	3	2
2014-03-25 12:51:44.773423	5097	450	3	2
2014-03-26 19:49:18.668584	29551	22.3	1	10
2014-03-26 19:49:18.900298	29552	39	2	10
2014-03-25 12:51:48.186654	5102	20.4	1	8
2014-03-25 12:51:48.409898	5103	57	2	8
2014-03-25 12:52:03.840451	5104	20.0	1	1
2014-03-25 12:52:04.07305	5105	53	2	1
2014-03-26 19:49:29.054004	29553	21.6	1	9
2014-03-26 19:49:29.289593	29554	49	2	9
2014-03-25 12:52:27.185925	5110	20.4	1	8
2014-03-25 12:52:27.408853	5111	57	2	8
2014-03-25 12:52:32.770483	5112	450	3	2
2014-03-25 12:52:42.843342	5113	20.0	1	1
2014-03-25 12:52:43.071858	5114	53	2	1
2014-03-25 12:52:56.772873	5115	482	3	2
2014-03-26 19:49:30.140056	29555	21.0	1	8
2014-03-26 19:49:30.364729	29556	53	2	8
2014-03-25 12:53:06.241886	5120	20.4	1	8
2014-03-25 12:53:06.476675	5121	57	2	8
2014-03-25 12:53:21.638051	5122	466	3	2
2014-03-25 12:53:21.945285	5123	20.0	1	1
2014-03-25 12:53:22.169901	5124	53	2	1
2014-03-25 12:53:32.770931	5125	482	3	2
2014-03-26 19:49:32.583162	29557	965	3	2
2014-03-26 19:49:32.817778	29558	1087012.6214981268	4	2
2014-03-25 12:53:45.187913	5130	20.4	1	8
2014-03-25 12:53:45.4104	5131	57	2	8
2014-03-25 12:54:00.839619	5132	20.0	1	1
2014-03-25 12:54:01.082249	5133	53	2	1
2014-03-26 19:49:44.568788	29559	933	3	2
2014-03-26 19:49:44.794733	29560	1087016.068602291	4	2
2014-03-25 12:54:24.185741	5138	20.4	1	8
2014-03-25 12:54:24.410396	5139	57	2	8
2014-03-25 12:54:32.771965	5140	482	3	2
2014-03-25 12:54:39.838929	5141	20.0	1	1
2014-03-25 12:54:40.061851	5142	53	2	1
2014-03-26 19:49:45.104439	29561	21.1	1	1
2014-03-26 19:49:45.337401	29562	49	2	1
2014-03-25 12:55:03.185306	5147	20.4	1	8
2014-03-25 12:55:03.410214	5148	57	2	8
2014-03-25 12:55:18.838135	5149	20.0	1	1
2014-03-25 12:55:19.06156	5150	53	2	1
2014-03-25 12:55:32.771845	5151	482	3	2
2014-03-26 19:49:56.580254	29563	853	3	2
2014-03-26 19:49:56.806224	29564	1087018.3666717338	4	2
2014-03-25 12:55:42.187836	5156	20.4	1	8
2014-03-25 12:55:42.420239	5157	57	2	8
2014-03-25 12:55:57.836958	5158	20.0	1	1
2014-03-25 12:55:58.059939	5159	53	2	1
2014-03-25 12:56:08.770579	5160	515	3	2
2014-03-26 19:49:57.669441	29565	22.3	1	10
2014-03-25 12:56:20.77274	5165	482	3	2
2014-03-25 12:56:21.185585	5166	20.4	1	8
2014-03-25 12:56:21.409677	5167	57	2	8
2014-03-25 12:56:32.774203	5168	434	3	2
2014-03-25 12:47:12.812707	5033	20.9	1	10
2014-03-25 12:47:13.048187	5034	55	2	10
2014-03-25 12:47:51.813617	5042	20.9	1	10
2014-03-25 12:47:52.038935	5043	55	2	10
2014-03-25 12:48:30.813017	5050	20.9	1	10
2014-03-25 12:48:31.037018	5051	55	2	10
2014-03-25 12:49:09.814142	5059	20.9	1	10
2014-03-25 12:49:10.037292	5060	55	2	10
2014-03-25 12:49:48.813849	5068	20.9	1	10
2014-03-25 12:49:49.03684	5069	55	2	10
2014-03-25 12:50:27.813585	5076	20.9	1	10
2014-03-25 12:50:28.036041	5077	55	2	10
2014-03-25 12:51:06.813631	5087	20.9	1	10
2014-03-25 12:51:07.03869	5088	55	2	10
2014-03-25 12:51:45.817489	5098	20.9	1	10
2014-03-25 12:51:46.049397	5099	55	2	10
2014-03-25 12:52:24.815159	5106	20.9	1	10
2014-03-25 12:52:25.040917	5107	55	2	10
2014-03-25 12:53:03.813827	5116	20.9	1	10
2014-03-25 12:53:04.050193	5117	55	2	10
2014-03-25 12:53:42.81408	5126	20.9	1	10
2014-03-25 12:53:43.037894	5127	55	2	10
2014-03-25 12:54:21.814972	5134	20.9	1	10
2014-03-25 12:54:22.037995	5135	55	2	10
2014-03-25 12:55:00.815323	5143	20.9	1	10
2014-03-25 12:55:01.039402	5144	55	2	10
2014-03-25 12:55:39.815325	5152	20.9	1	10
2014-03-25 12:55:40.04872	5153	55	2	10
2014-03-25 12:56:36.841098	5169	20.0	1	1
2014-03-25 12:56:37.066071	5170	53	2	1
2014-03-25 12:56:44.773187	5171	434	3	2
2014-03-26 19:49:57.905063	29566	39	2	10
2014-03-26 19:50:08.056089	29567	21.6	1	9
2014-03-25 12:57:00.18604	5176	20.4	1	8
2014-03-25 12:57:00.427809	5177	57	2	8
2014-03-25 12:57:15.841268	5178	20.0	1	1
2014-03-25 12:57:16.063139	5179	53	2	1
2014-03-25 12:57:36.614813	5180	434	3	2
2014-03-26 19:50:08.280881	29568	49	2	9
2014-03-26 19:50:08.589402	29569	869	3	2
2014-03-25 12:57:39.185698	5185	20.4	1	8
2014-03-25 12:57:39.409876	5186	57	2	8
2014-03-25 12:57:54.837426	5187	20.0	1	1
2014-03-25 12:57:55.062318	5188	53	2	1
2014-03-26 19:50:08.824602	29570	1087021.813775898	4	2
2014-03-26 19:50:09.145001	29571	21.0	1	8
2014-03-25 12:58:18.185174	5193	20.4	1	8
2014-03-25 12:58:18.409653	5194	57	2	8
2014-03-25 12:58:32.774198	5195	418	3	2
2014-03-25 12:58:33.84057	5196	20.0	1	1
2014-03-25 12:58:34.076361	5197	53	2	1
2014-03-25 12:58:44.773403	5198	515	3	2
2014-03-26 19:50:09.371975	29572	53	2	8
2014-03-26 19:50:23.771131	29573	21.1	1	1
2014-03-25 12:58:56.770905	5203	515	3	2
2014-03-25 12:58:57.18792	5204	20.4	1	8
2014-03-25 12:58:57.423417	5205	57	2	8
2014-03-25 12:59:12.838286	5206	20.0	1	1
2014-03-25 12:59:13.060252	5207	53	2	1
2014-03-25 12:59:32.774675	5208	515	3	2
2014-03-26 19:50:24.005223	29574	49	2	1
2014-03-26 19:50:36.468267	29575	853	3	2
2014-03-25 12:59:36.242142	5213	20.4	1	8
2014-03-25 12:59:36.466057	5214	57	2	8
2014-03-25 12:59:51.835499	5215	20.0	1	1
2014-03-25 12:59:52.067821	5216	53	2	1
2014-03-26 19:50:36.694642	29576	1087027.558949505	4	2
2014-03-26 19:50:37.002777	29577	22.3	1	10
2014-03-25 13:00:15.18483	5221	20.3	1	8
2014-03-25 13:00:15.411776	5222	57	2	8
2014-03-25 13:00:30.827029	5223	20.0	1	1
2014-03-25 13:00:31.069775	5224	53	2	1
2014-03-25 13:00:32.76939	5225	515	3	2
2014-03-26 19:50:37.238037	29578	39	2	10
2014-03-26 19:50:47.055473	29579	21.7	1	9
2014-03-25 13:00:54.185812	5230	20.3	1	8
2014-03-25 13:00:54.416547	5231	57	2	8
2014-03-25 13:01:09.829271	5232	20.0	1	1
2014-03-25 13:01:10.053226	5233	53	2	1
2014-03-26 19:50:47.281894	29580	49	2	9
2014-03-26 19:50:48.141635	29581	21.0	1	8
2014-03-25 13:01:32.772282	5238	531	3	2
2014-03-25 13:01:33.18536	5239	20.3	1	8
2014-03-25 13:01:33.407495	5240	57	2	8
2014-03-25 13:01:48.832898	5241	20.0	1	1
2014-03-25 13:01:49.054914	5242	53	2	1
2014-03-26 19:50:48.389224	29582	53	2	8
2014-03-26 19:51:02.773927	29583	21.1	1	1
2014-03-25 13:02:12.18608	5247	20.3	1	8
2014-03-25 13:02:12.407589	5248	57	2	8
2014-03-25 13:02:27.829851	5249	20.0	1	1
2014-03-25 13:02:28.060993	5250	53	2	1
2014-03-25 13:02:32.768861	5251	531	3	2
2014-03-26 19:51:03.000942	29584	49	2	1
2014-03-26 19:51:15.670416	29585	22.3	1	10
2014-03-25 13:02:51.188597	5256	20.3	1	8
2014-03-25 13:02:51.418796	5257	57	2	8
2014-03-25 13:02:56.771415	5258	579	3	2
2014-03-25 13:03:06.824626	5259	20.0	1	1
2014-03-25 13:03:07.049385	5260	53	2	1
2014-03-25 13:03:08.768059	5261	579	3	2
2014-03-26 19:51:15.904899	29586	39	2	10
2014-03-26 19:51:26.055275	29587	21.7	1	9
2014-03-25 13:03:30.185978	5266	20.3	1	8
2014-03-25 13:03:30.407464	5267	57	2	8
2014-03-25 13:03:32.773109	5268	579	3	2
2014-03-25 13:03:45.83433	5269	20.0	1	1
2014-03-25 13:03:46.059759	5270	53	2	1
2014-03-26 19:51:26.280667	29588	49	2	9
2014-03-26 19:51:27.141902	29589	21.0	1	8
2014-03-25 13:04:09.187399	5275	20.3	1	8
2014-03-25 13:04:09.421837	5276	57	2	8
2014-03-25 13:04:24.831271	5277	20.0	1	1
2014-03-25 13:04:25.055068	5278	53	2	1
2014-03-25 13:04:32.774307	5279	579	3	2
2014-03-26 19:51:27.376445	29590	53	2	8
2014-03-26 19:51:32.574851	29591	869	3	2
2014-03-25 13:04:48.186714	5284	20.3	1	8
2014-03-25 13:04:48.411463	5285	57	2	8
2014-03-25 13:05:03.826239	5286	20.0	1	1
2014-03-25 13:05:04.059302	5287	53	2	1
2014-03-25 13:05:08.768053	5288	676	3	2
2014-03-25 13:05:20.774494	5289	579	3	2
2014-03-26 19:51:32.799982	29592	1087041.347366162	4	2
2014-03-26 19:51:41.76833	29593	21.1	1	1
2014-03-25 13:05:27.184929	5294	20.3	1	8
2014-03-25 13:05:27.421075	5295	57	2	8
2014-03-25 13:05:32.765628	5296	515	3	2
2014-03-25 13:05:42.831223	5297	20.0	1	1
2014-03-25 13:05:43.053843	5298	53	2	1
2014-03-25 13:05:44.766168	5299	515	3	2
2014-03-26 19:51:42.004292	29594	49	2	1
2014-03-25 13:06:06.186153	5304	20.3	1	8
2014-03-25 12:56:57.817273	5172	20.9	1	10
2014-03-25 12:56:58.040505	5173	55	2	10
2014-03-25 12:57:36.933291	5181	20.9	1	10
2014-03-25 12:57:37.165385	5182	55	2	10
2014-03-25 12:58:15.816969	5189	20.9	1	10
2014-03-25 12:58:16.043568	5190	55	2	10
2014-03-25 12:58:54.817166	5199	20.9	1	10
2014-03-25 12:58:55.039431	5200	55	2	10
2014-03-25 12:59:33.816083	5209	20.9	1	10
2014-03-25 12:59:34.037963	5210	55	2	10
2014-03-25 13:00:12.815626	5217	20.9	1	10
2014-03-25 13:00:13.039874	5218	55	2	10
2014-03-25 13:00:51.817041	5226	20.9	1	10
2014-03-25 13:00:52.038941	5227	55	2	10
2014-03-25 13:01:30.817287	5234	20.9	1	10
2014-03-25 13:01:31.051345	5235	55	2	10
2014-03-25 13:02:09.819104	5243	20.9	1	10
2014-03-25 13:02:10.040828	5244	55	2	10
2014-03-25 13:02:48.818678	5252	20.9	1	10
2014-03-25 13:02:49.043965	5253	55	2	10
2014-03-25 13:03:27.818795	5262	20.9	1	10
2014-03-25 13:03:28.043145	5263	55	2	10
2014-03-25 13:04:06.819179	5271	20.9	1	10
2014-03-25 13:04:07.054353	5272	55	2	10
2014-03-25 13:04:45.818601	5280	20.9	1	10
2014-03-25 13:04:46.041926	5281	55	2	10
2014-03-25 13:05:24.820065	5290	20.9	1	10
2014-03-25 13:05:25.053201	5291	55	2	10
2014-03-25 13:06:06.408508	5305	57	2	8
2014-03-25 13:06:21.831145	5306	20.0	1	1
2014-03-25 13:06:22.063703	5307	53	2	1
2014-03-25 13:06:32.769915	5308	498	3	2
2014-03-26 19:51:54.66898	29595	22.3	1	10
2014-03-26 19:51:54.894725	29596	39	2	10
2014-03-25 13:06:45.185843	5313	20.3	1	8
2014-03-25 13:06:45.427507	5314	57	2	8
2014-03-25 13:07:00.830439	5315	20.0	1	1
2014-03-25 13:07:01.053718	5316	53	2	1
2014-03-26 19:52:05.056021	29597	21.7	1	9
2014-03-26 19:52:05.290441	29598	49	2	9
2014-03-25 13:07:24.185568	5321	20.3	1	8
2014-03-25 13:07:24.416792	5322	57	2	8
2014-03-25 13:07:32.77093	5323	498	3	2
2014-03-25 13:07:39.831174	5324	20.0	1	1
2014-03-25 13:07:40.054656	5325	53	2	1
2014-03-26 19:52:06.141964	29599	21.0	1	8
2014-03-26 19:52:06.367513	29600	53	2	8
2014-03-25 13:08:03.185775	5330	20.3	1	8
2014-03-25 13:08:03.408773	5331	57	2	8
2014-03-25 13:08:08.765164	5332	450	3	2
2014-03-25 13:08:18.830512	5333	20.0	1	1
2014-03-25 13:08:19.05901	5334	53	2	1
2014-03-25 13:08:20.769837	5335	466	3	2
2014-03-25 13:08:32.77	5336	450	3	2
2014-03-26 19:52:20.770488	29601	21.0	1	1
2014-03-26 19:52:21.005755	29602	49	2	1
2014-03-25 13:08:42.185675	5341	20.3	1	8
2014-03-25 13:08:42.407528	5342	57	2	8
2014-03-25 13:08:57.829184	5343	20.0	1	1
2014-03-25 13:08:58.065398	5344	53	2	1
2014-03-26 19:52:32.578776	29603	885	3	2
2014-03-26 19:52:32.805233	29604	1087056.2848175406	4	2
2014-03-25 13:09:21.186766	5349	20.3	1	8
2014-03-25 13:09:21.409024	5350	57	2	8
2014-03-25 13:09:32.768484	5351	450	3	2
2014-03-25 13:09:36.829147	5352	20.0	1	1
2014-03-25 13:09:37.053743	5353	53	2	1
2014-03-26 19:52:33.667411	29605	22.3	1	10
2014-03-26 19:52:33.902765	29606	40	2	10
2014-03-25 13:10:00.188088	5358	20.3	1	8
2014-03-25 13:10:00.430088	5359	57	2	8
2014-03-25 13:10:15.83423	5360	19.9	1	1
2014-03-25 13:10:16.056884	5361	53	2	1
2014-03-25 13:10:32.769569	5362	466	3	2
2014-03-26 19:52:44.055776	29607	21.7	1	9
2014-03-26 19:52:44.283067	29608	49	2	9
2014-03-25 13:10:39.189145	5367	20.3	1	8
2014-03-25 13:10:39.413699	5368	57	2	8
2014-03-25 13:10:54.832166	5369	19.9	1	1
2014-03-25 13:10:55.064712	5370	53	2	1
2014-03-26 19:52:45.141231	29609	21.1	1	8
2014-03-26 19:52:45.374046	29610	53	2	8
2014-03-25 13:11:18.187857	5375	20.3	1	8
2014-03-25 13:11:18.411132	5376	57	2	8
2014-03-25 13:11:32.769331	5377	466	3	2
2014-03-25 13:11:33.832209	5378	19.9	1	1
2014-03-25 13:11:34.055902	5379	53	2	1
2014-03-26 19:52:59.768905	29611	21.0	1	1
2014-03-26 19:52:59.994713	29612	49	2	1
2014-03-25 13:11:57.185939	5384	20.3	1	8
2014-03-25 13:11:57.416131	5385	57	2	8
2014-03-25 13:12:12.834762	5386	19.9	1	1
2014-03-25 13:12:13.059467	5387	53	2	1
2014-03-25 13:12:32.774972	5388	466	3	2
2014-03-26 19:53:12.670577	29613	22.3	1	10
2014-03-26 19:53:12.90427	29614	40	2	10
2014-03-25 13:12:36.186346	5393	20.3	1	8
2014-03-25 13:12:36.40983	5394	57	2	8
2014-03-25 13:12:51.83218	5395	19.9	1	1
2014-03-25 13:12:52.064226	5396	53	2	1
2014-03-25 13:13:08.769569	5397	434	3	2
2014-03-26 19:53:23.05604	29615	21.7	1	9
2014-03-26 19:53:23.282035	29616	49	2	9
2014-03-25 13:13:15.186094	5402	20.3	1	8
2014-03-25 13:13:15.408279	5403	57	2	8
2014-03-25 13:13:20.766308	5404	434	3	2
2014-03-25 13:13:31.065002	5405	19.9	1	1
2014-03-25 13:13:31.287911	5406	53	2	1
2014-03-25 13:13:32.770373	5407	418	3	2
2014-03-26 19:53:24.139845	29617	21.1	1	8
2014-03-26 19:53:24.375968	29618	53	2	8
2014-03-25 13:13:54.185734	5412	20.3	1	8
2014-03-25 13:13:54.609537	5413	57	2	8
2014-03-25 13:14:09.825354	5414	19.9	1	1
2014-03-25 13:14:10.559529	5415	53	2	1
2014-03-25 13:14:20.768598	5416	466	3	2
2014-03-26 19:53:32.576619	29619	885	3	2
2014-03-26 19:53:32.803476	29620	1087070.0777051498	4	2
2014-03-25 13:14:32.768156	5421	466	3	2
2014-03-25 13:14:33.185603	5422	20.3	1	8
2014-03-25 13:14:33.418952	5423	57	2	8
2014-03-25 13:14:48.829094	5424	19.9	1	1
2014-03-25 13:14:49.053297	5425	53	2	1
2014-03-26 19:53:38.773372	29621	21.0	1	1
2014-03-26 19:53:39.007383	29622	49	2	1
2014-03-25 13:15:12.187949	5430	20.3	1	8
2014-03-25 13:15:12.420396	5431	57	2	8
2014-03-25 13:15:20.773071	5432	354	3	2
2014-03-25 13:15:27.827647	5433	19.9	1	1
2014-03-25 13:15:28.051305	5434	53	2	1
2014-03-25 13:15:32.768453	5435	354	3	2
2014-03-26 19:53:51.669983	29623	22.3	1	10
2014-03-25 13:15:51.186347	5440	20.3	1	8
2014-03-25 13:06:42.820587	5309	20.9	1	10
2014-03-25 13:06:43.043144	5310	55	2	10
2014-03-25 13:07:21.819454	5317	20.9	1	10
2014-03-25 13:07:22.051923	5318	55	2	10
2014-03-25 13:08:00.821111	5326	20.9	1	10
2014-03-25 13:08:01.043661	5327	55	2	10
2014-03-25 13:08:39.81997	5337	20.9	1	10
2014-03-25 13:08:40.044543	5338	55	2	10
2014-03-25 13:09:18.820944	5345	20.9	1	10
2014-03-25 13:09:19.043276	5346	55	2	10
2014-03-25 13:09:57.819816	5354	20.9	1	10
2014-03-25 13:09:58.051158	5355	55	2	10
2014-03-25 13:10:36.82015	5363	20.8	1	10
2014-03-25 13:10:37.062276	5364	55	2	10
2014-03-25 13:11:15.820413	5371	20.8	1	10
2014-03-25 13:11:16.044134	5372	54	2	10
2014-03-25 13:11:54.82087	5380	20.8	1	10
2014-03-25 13:11:55.043504	5381	54	2	10
2014-03-25 13:12:33.821439	5389	20.8	1	10
2014-03-25 13:12:34.047246	5390	54	2	10
2014-03-25 13:13:12.822826	5398	20.8	1	10
2014-03-25 13:13:13.044285	5399	54	2	10
2014-03-25 13:13:51.822118	5408	20.8	1	10
2014-03-25 13:13:52.098781	5409	54	2	10
2014-03-25 13:14:30.822857	5417	20.8	1	10
2014-03-25 13:14:31.049026	5418	54	2	10
2014-03-25 13:15:09.82202	5426	20.8	1	10
2014-03-25 13:15:10.054746	5427	54	2	10
2014-03-25 13:15:51.411156	5441	57	2	8
2014-03-25 13:16:06.822857	5442	19.9	1	1
2014-03-25 13:16:07.110404	5443	53	2	1
2014-03-25 13:16:20.768861	5444	402	3	2
2014-03-26 19:53:51.896064	29624	40	2	10
2014-03-26 19:54:02.054337	29625	21.7	1	9
2014-03-25 13:16:30.186623	5449	20.3	1	8
2014-03-25 13:16:30.410661	5450	57	2	8
2014-03-25 13:16:32.769571	5451	370	3	2
2014-03-25 13:16:44.770378	5452	370	3	2
2014-03-25 13:16:45.822487	5453	19.9	1	1
2014-03-25 13:16:46.053858	5454	53	2	1
2014-03-26 19:54:02.288862	29626	49	2	9
2014-03-26 19:54:03.142324	29627	21.1	1	8
2014-03-25 13:17:08.768896	5459	402	3	2
2014-03-25 13:17:09.185052	5460	20.3	1	8
2014-03-25 13:17:09.407284	5461	57	2	8
2014-03-25 13:17:20.765664	5462	370	3	2
2014-03-25 13:17:24.82631	5463	19.9	1	1
2014-03-25 13:17:25.047922	5464	53	2	1
2014-03-25 13:17:32.767191	5465	370	3	2
2014-03-26 19:54:03.365624	29628	54	2	8
2014-03-26 19:54:17.774371	29629	21.0	1	1
2014-03-25 13:17:48.18549	5470	20.3	1	8
2014-03-25 13:17:48.408242	5471	57	2	8
2014-03-25 13:18:03.822416	5472	19.9	1	1
2014-03-25 13:18:04.054332	5473	53	2	1
2014-03-26 19:54:18.02205	29630	49	2	1
2014-03-26 19:54:30.662092	29631	22.3	1	10
2014-03-25 13:18:27.183895	5478	20.3	1	8
2014-03-25 13:18:27.406231	5479	57	2	8
2014-03-25 13:18:42.824364	5480	19.9	1	1
2014-03-25 13:18:43.0572	5481	53	2	1
2014-03-26 19:54:30.888918	29632	40	2	10
2014-03-26 19:54:32.580814	29633	804	3	2
2014-03-25 13:19:06.18617	5486	20.3	1	8
2014-03-25 13:19:06.411267	5487	57	2	8
2014-03-25 13:19:21.823508	5488	19.9	1	1
2014-03-25 13:19:22.05876	5489	53	2	1
2014-03-25 13:19:32.770488	5490	370	3	2
2014-03-26 19:54:32.814527	29634	1087082.7170870851	4	2
2014-03-26 19:54:41.05484	29635	21.7	1	9
2014-03-25 13:19:45.186929	5495	20.3	1	8
2014-03-25 13:19:45.409694	5496	57	2	8
2014-03-25 13:20:00.824017	5497	19.9	1	1
2014-03-25 13:20:01.04809	5498	53	2	1
2014-03-25 13:20:08.770001	5499	338	3	2
2014-03-25 13:20:20.770152	5500	338	3	2
2014-03-26 19:54:41.28074	29636	49	2	9
2014-03-26 19:54:42.141269	29637	21.1	1	8
2014-03-25 13:20:24.187109	5505	20.3	1	8
2014-03-25 13:20:24.408996	5506	57	2	8
2014-03-25 13:20:32.769296	5507	338	3	2
2014-03-25 13:20:39.824065	5508	19.9	1	1
2014-03-25 13:20:40.045268	5509	53	2	1
2014-03-26 19:54:42.374103	29638	53	2	8
2014-03-26 19:54:56.771219	29639	21.0	1	1
2014-03-25 13:21:03.319937	5514	20.3	1	8
2014-03-25 13:21:03.760007	5515	57	2	8
2014-03-25 13:21:18.826231	5516	19.9	1	1
2014-03-25 13:21:19.048703	5517	53	2	1
2014-03-25 13:21:20.7686	5518	370	3	2
2014-03-25 13:21:32.770133	5519	354	3	2
2014-03-26 19:54:56.997137	29640	49	2	1
2014-03-26 19:55:08.578625	29641	853	3	2
2014-03-25 13:21:42.18528	5524	20.3	1	8
2014-03-25 13:21:42.408496	5525	57	2	8
2014-03-25 13:21:57.822719	5526	19.9	1	1
2014-03-25 13:21:58.057467	5527	53	2	1
2014-03-26 19:55:08.81197	29642	1087090.7603301352	4	2
2014-03-26 19:55:09.669304	29643	22.4	1	10
2014-03-25 13:22:21.185587	5532	20.3	1	8
2014-03-25 13:22:21.410499	5533	57	2	8
2014-03-25 13:22:32.770034	5534	338	3	2
2014-03-25 13:22:36.864665	5535	19.9	1	1
2014-03-25 13:22:37.104965	5536	53	2	1
2014-03-25 13:22:56.768453	5537	370	3	2
2014-03-26 19:55:09.894762	29644	40	2	10
2014-03-26 19:55:20.057704	29645	21.7	1	9
2014-03-25 13:23:00.18484	5542	20.3	1	8
2014-03-25 13:23:00.407575	5543	57	2	8
2014-03-25 13:23:15.619867	5544	354	3	2
2014-03-25 13:23:16.124963	5545	19.9	1	1
2014-03-25 13:23:16.346382	5546	53	2	1
2014-03-25 13:23:32.897635	5547	338	3	2
2014-03-26 19:55:20.291381	29646	49	2	9
2014-03-26 19:55:20.60009	29647	837	3	2
2014-03-25 13:23:39.309986	5552	20.3	1	8
2014-03-25 13:23:39.750258	5553	57	2	8
2014-03-25 13:23:54.822669	5554	19.9	1	1
2014-03-25 13:23:55.045149	5555	53	2	1
2014-03-25 13:23:56.769419	5556	370	3	2
2014-03-25 13:24:08.769412	5557	370	3	2
2014-03-26 19:55:20.824419	29648	1087093.0583995779	4	2
2014-03-26 19:55:21.139951	29649	21.1	1	8
2014-03-25 13:24:18.18465	5562	20.3	1	8
2014-03-25 13:24:18.406657	5563	57	2	8
2014-03-25 13:24:32.901141	5564	370	3	2
2014-03-25 13:24:33.959978	5565	19.9	1	1
2014-03-25 13:24:34.419962	5566	53	2	1
2014-03-26 19:55:21.374485	29650	53	2	8
2014-03-26 19:55:32.576745	29651	853	3	2
2014-03-25 13:24:57.184692	5571	20.3	1	8
2014-03-25 13:24:57.406044	5572	56	2	8
2014-03-25 13:25:12.822772	5573	19.9	1	1
2014-03-25 13:25:13.059502	5574	53	2	1
2014-03-25 13:25:32.770809	5575	370	3	2
2014-03-25 13:16:27.822394	5445	20.8	1	10
2014-03-25 13:16:28.046336	5446	54	2	10
2014-03-25 13:17:06.822862	5455	20.8	1	10
2014-03-25 13:17:07.104771	5456	54	2	10
2014-03-25 13:17:45.822512	5466	20.8	1	10
2014-03-25 13:17:46.046952	5467	54	2	10
2014-03-25 13:18:24.823482	5474	20.8	1	10
2014-03-25 13:18:25.046556	5475	54	2	10
2014-03-25 13:19:03.822478	5482	20.8	1	10
2014-03-25 13:19:04.047623	5483	54	2	10
2014-03-25 13:19:42.823374	5491	20.8	1	10
2014-03-25 13:19:43.049388	5492	54	2	10
2014-03-25 13:20:21.823557	5501	20.8	1	10
2014-03-25 13:20:22.045242	5502	54	2	10
2014-03-25 13:21:00.951054	5510	20.8	1	10
2014-03-25 13:21:01.40002	5511	54	2	10
2014-03-25 13:21:39.823629	5520	20.8	1	10
2014-03-25 13:21:40.066512	5521	54	2	10
2014-03-25 13:22:18.823795	5528	20.8	1	10
2014-03-25 13:22:19.047271	5529	54	2	10
2014-03-25 13:22:57.82443	5538	20.8	1	10
2014-03-25 13:22:58.046407	5539	54	2	10
2014-03-25 13:23:37.006059	5548	20.8	1	10
2014-03-25 13:23:37.425321	5549	54	2	10
2014-03-25 13:24:15.823163	5558	20.8	1	10
2014-03-25 13:24:16.048963	5559	54	2	10
2014-03-26 19:55:32.803301	29652	1087096.5055037423	4	2
2014-03-26 19:55:35.767692	29653	21.0	1	1
2014-03-25 13:25:36.189007	5580	20.3	1	8
2014-03-25 13:25:36.420557	5581	57	2	8
2014-03-25 13:25:51.819076	5582	19.9	1	1
2014-03-25 13:25:52.042281	5583	53	2	1
2014-03-26 19:55:36.003809	29654	49	2	1
2014-03-26 19:55:44.580847	29655	708	3	2
2014-03-25 13:26:15.184787	5588	20.3	1	8
2014-03-25 13:26:15.417188	5589	57	2	8
2014-03-25 13:26:30.821392	5590	19.9	1	1
2014-03-25 13:26:31.04541	5591	53	2	1
2014-03-25 13:26:32.768425	5592	402	3	2
2014-03-25 13:26:44.768131	5593	418	3	2
2014-03-26 19:55:44.807257	29656	1087098.803573185	4	2
2014-03-26 19:55:48.669526	29657	22.4	1	10
2014-03-25 13:26:54.184401	5598	20.3	1	8
2014-03-25 13:26:54.406625	5599	56	2	8
2014-03-25 13:27:09.818508	5600	19.9	1	1
2014-03-25 13:27:10.050891	5601	53	2	1
2014-03-26 19:55:48.902829	29658	40	2	10
2014-03-26 19:55:56.583837	29659	853	3	2
2014-03-25 13:27:32.769266	5606	418	3	2
2014-03-25 13:27:33.184754	5607	20.3	1	8
2014-03-25 13:27:33.406356	5608	56	2	8
2014-03-25 13:27:48.822328	5609	20.0	1	1
2014-03-25 13:27:49.045275	5610	53	2	1
2014-03-26 19:55:56.810392	29660	1087102.2506773493	4	2
2014-03-26 19:55:59.055631	29661	21.8	1	9
2014-03-25 13:28:12.185481	5615	20.3	1	8
2014-03-25 13:28:12.424281	5616	56	2	8
2014-03-25 13:28:27.817593	5617	20.0	1	1
2014-03-25 13:28:28.039239	5618	53	2	1
2014-03-25 13:28:32.769692	5619	418	3	2
2014-03-26 19:55:59.2911	29662	49	2	9
2014-03-26 19:56:00.143421	29663	21.2	1	8
2014-03-25 13:28:51.185581	5624	20.3	1	8
2014-03-25 13:28:51.411097	5625	56	2	8
2014-03-25 13:29:06.821642	5626	20.0	1	1
2014-03-25 13:29:07.043121	5627	53	2	1
2014-03-26 19:56:00.367532	29664	52	2	8
2014-03-26 19:56:08.582537	29665	853	3	2
2014-03-25 13:29:30.186296	5632	20.3	1	8
2014-03-25 13:29:30.409578	5633	56	2	8
2014-03-25 13:29:32.766436	5634	418	3	2
2014-03-25 13:29:45.819004	5635	20.0	1	1
2014-03-25 13:29:46.041847	5636	53	2	1
2014-03-26 19:56:08.818213	29666	1087104.5487467921	4	2
2014-03-26 19:56:14.766688	29667	21.0	1	1
2014-03-25 13:30:09.185232	5641	20.3	1	8
2014-03-25 13:30:09.41616	5642	56	2	8
2014-03-25 13:30:24.818187	5643	20.0	1	1
2014-03-25 13:30:25.042874	5644	53	2	1
2014-03-25 13:30:32.76784	5645	402	3	2
2014-03-26 19:56:14.991457	29668	49	2	1
2014-03-26 19:56:27.667429	29669	22.4	1	10
2014-03-25 13:30:48.187985	5650	20.3	1	8
2014-03-25 13:30:48.430724	5651	56	2	8
2014-03-25 13:31:03.816067	5652	20.0	1	1
2014-03-25 13:31:04.047484	5653	53	2	1
2014-03-26 19:56:27.901028	29670	40	2	10
2014-03-26 19:56:32.580013	29671	837	3	2
2014-03-25 13:31:27.187078	5658	20.3	1	8
2014-03-25 13:31:27.41144	5659	56	2	8
2014-03-25 13:31:32.769141	5660	418	3	2
2014-03-25 13:31:42.818995	5661	20.0	1	1
2014-03-25 13:31:43.040998	5662	53	2	1
2014-03-25 13:31:56.767301	5663	354	3	2
2014-03-26 19:56:32.805424	29672	1087110.2939203992	4	2
2014-03-26 19:56:38.054154	29673	21.8	1	9
2014-03-25 13:32:06.186185	5668	20.3	1	8
2014-03-25 13:32:06.421212	5669	56	2	8
2014-03-25 13:32:08.769783	5670	354	3	2
2014-03-25 13:32:21.816525	5671	20.0	1	1
2014-03-25 13:32:22.03793	5672	53	2	1
2014-03-25 13:32:32.765576	5673	354	3	2
2014-03-26 19:56:38.294366	29674	49	2	9
2014-03-26 19:56:39.143164	29675	21.2	1	8
2014-03-25 13:32:45.185328	5678	20.3	1	8
2014-03-25 13:32:45.416055	5679	56	2	8
2014-03-25 13:33:00.820165	5680	20.0	1	1
2014-03-25 13:33:01.044402	5681	53	2	1
2014-03-26 19:56:39.368683	29676	52	2	8
2014-03-26 19:56:53.771139	29677	21.0	1	1
2014-03-25 13:33:24.18589	5686	20.3	1	8
2014-03-25 13:33:24.418101	5687	56	2	8
2014-03-25 13:33:32.767619	5688	370	3	2
2014-03-25 13:33:39.814882	5689	20.0	1	1
2014-03-25 13:33:40.038629	5690	53	2	1
2014-03-26 19:56:54.017969	29678	49	2	1
2014-03-26 19:56:56.58155	29679	804	3	2
2014-03-25 13:34:03.186152	5695	20.3	1	8
2014-03-25 13:34:03.407604	5696	56	2	8
2014-03-25 13:34:18.82076	5697	20.0	1	1
2014-03-25 13:34:19.052428	5698	53	2	1
2014-03-25 13:34:32.768277	5699	370	3	2
2014-03-26 19:56:56.805255	29680	1087116.0390940062	4	2
2014-03-26 19:57:06.670185	29681	22.4	1	10
2014-03-25 13:34:42.185199	5704	20.3	1	8
2014-03-25 13:34:42.408826	5705	56	2	8
2014-03-25 13:34:57.813299	5706	20.0	1	1
2014-03-25 13:34:58.037626	5707	53	2	1
2014-03-25 13:35:21.185203	5712	20.3	1	8
2014-03-25 13:25:34.058304	5577	54	2	10
2014-03-25 13:26:12.824551	5584	20.8	1	10
2014-03-25 13:26:13.066231	5585	54	2	10
2014-03-25 13:26:51.824566	5594	20.8	1	10
2014-03-25 13:26:52.045614	5595	54	2	10
2014-03-25 13:27:30.824165	5602	20.8	1	10
2014-03-25 13:27:31.047516	5603	54	2	10
2014-03-25 13:28:09.825342	5611	20.8	1	10
2014-03-25 13:28:10.047159	5612	54	2	10
2014-03-25 13:28:48.825051	5620	20.8	1	10
2014-03-25 13:28:49.047229	5621	54	2	10
2014-03-25 13:29:27.827206	5628	20.8	1	10
2014-03-25 13:29:28.047451	5629	54	2	10
2014-03-25 13:30:06.827755	5637	20.8	1	10
2014-03-25 13:30:07.06154	5638	54	2	10
2014-03-25 13:30:45.825974	5646	20.8	1	10
2014-03-25 13:30:46.049904	5647	54	2	10
2014-03-25 13:31:24.827325	5654	20.8	1	10
2014-03-25 13:31:25.050732	5655	54	2	10
2014-03-25 13:32:03.826577	5664	20.8	1	10
2014-03-25 13:32:04.058798	5665	54	2	10
2014-03-25 13:32:42.825851	5674	20.8	1	10
2014-03-25 13:32:43.05095	5675	54	2	10
2014-03-25 13:33:21.827616	5682	20.8	1	10
2014-03-25 13:33:22.058778	5683	54	2	10
2014-03-25 13:34:00.827903	5691	20.8	1	10
2014-03-25 13:34:01.063118	5692	54	2	10
2014-03-25 13:34:39.829919	5700	20.8	1	10
2014-03-25 13:34:40.051554	5701	54	2	10
2014-03-25 13:35:18.828181	5708	20.8	1	10
2014-03-25 13:35:21.415546	5713	56	2	8
2014-03-25 13:35:32.778464	5714	370	3	2
2014-03-25 13:35:36.813715	5715	20.0	1	1
2014-03-25 13:35:37.039068	5716	53	2	1
2014-03-25 13:35:44.768604	5717	402	3	2
2014-03-25 13:35:56.766434	5718	402	3	2
2014-03-26 19:57:06.904858	29682	40	2	10
2014-03-26 19:57:16.85385	29683	853	3	2
2014-03-25 13:36:00.184706	5723	20.3	1	8
2014-03-25 13:36:00.416776	5724	56	2	8
2014-03-25 13:36:08.76513	5725	370	3	2
2014-03-25 13:36:15.814532	5726	20.0	1	1
2014-03-25 13:36:16.036549	5727	53	2	1
2014-03-25 13:36:20.767486	5728	370	3	2
2014-03-25 13:36:32.76241	5729	402	3	2
2014-03-26 19:57:17.079134	29684	1087118.337163449	4	2
2014-03-26 19:57:17.388151	29685	21.8	1	9
2014-03-25 13:36:39.186448	5734	20.2	1	8
2014-03-25 13:36:39.438774	5735	56	2	8
2014-03-25 13:36:44.763646	5736	402	3	2
2014-03-25 13:36:54.814766	5737	20.0	1	1
2014-03-25 13:36:55.037767	5738	53	2	1
2014-03-26 19:57:17.620878	29686	49	2	9
2014-03-26 19:57:18.141985	29687	21.2	1	8
2014-03-25 13:37:18.185055	5743	20.2	1	8
2014-03-25 13:37:18.407055	5744	56	2	8
2014-03-25 13:37:32.768788	5745	402	3	2
2014-03-25 13:37:33.812254	5746	20.0	1	1
2014-03-25 13:37:34.033493	5747	53	2	1
2014-03-26 19:57:18.36878	29688	52	2	8
2014-03-26 19:57:20.581836	29689	820	3	2
2014-03-25 13:37:57.183803	5752	20.2	1	8
2014-03-25 13:37:57.417	5753	56	2	8
2014-03-25 13:38:12.812277	5754	20.0	1	1
2014-03-25 13:38:13.03753	5755	53	2	1
2014-03-25 13:38:20.769842	5756	434	3	2
2014-03-25 13:38:32.767743	5757	434	3	2
2014-03-26 19:57:20.814696	29690	1087121.7842676134	4	2
2014-03-26 19:57:32.565341	29691	837	3	2
2014-03-25 13:38:36.187224	5762	20.2	1	8
2014-03-25 13:38:36.427339	5763	56	2	8
2014-03-25 13:38:51.811944	5764	20.0	1	1
2014-03-25 13:38:52.035196	5765	53	2	1
2014-03-26 19:57:32.790453	29692	1087124.082337056	4	2
2014-03-26 19:57:33.100168	29693	20.9	1	1
2014-03-25 13:39:15.18464	5770	20.2	1	8
2014-03-25 13:39:15.417351	5771	56	2	8
2014-03-25 13:39:30.816747	5772	20.0	1	1
2014-03-25 13:39:31.040005	5773	53	2	1
2014-03-25 13:39:32.770307	5774	434	3	2
2014-03-26 19:57:33.341145	29694	50	2	1
2014-03-26 19:57:45.670062	29695	22.4	1	10
2014-03-25 13:39:54.184008	5779	20.2	1	8
2014-03-25 13:39:54.406362	5780	56	2	8
2014-03-25 13:40:09.814188	5781	20.0	1	1
2014-03-25 13:40:10.047716	5782	53	2	1
2014-03-26 19:57:45.895242	29696	40	2	10
2014-03-26 19:57:56.053742	29697	21.8	1	9
2014-03-25 13:40:32.768805	5787	434	3	2
2014-03-25 13:40:33.184152	5788	20.2	1	8
2014-03-25 13:40:33.406931	5789	56	2	8
2014-03-25 13:40:48.811953	5790	20.0	1	1
2014-03-25 13:40:49.037206	5791	53	2	1
2014-03-26 19:57:56.288092	29698	49	2	9
2014-03-26 19:57:57.140449	29699	21.3	1	8
2014-03-25 13:41:12.185057	5796	20.2	1	8
2014-03-25 13:41:12.407295	5797	56	2	8
2014-03-25 13:41:27.814264	5798	20.0	1	1
2014-03-25 13:41:28.036686	5799	53	2	1
2014-03-25 13:41:32.765665	5800	434	3	2
2014-03-26 19:57:57.364294	29700	51	2	8
2014-03-26 19:58:11.768194	29701	20.9	1	1
2014-03-25 13:41:51.188116	5805	20.2	1	8
2014-03-25 13:41:51.411	5806	56	2	8
2014-03-25 13:42:06.810737	5807	20.0	1	1
2014-03-25 13:42:07.054463	5808	53	2	1
2014-03-25 13:42:08.767846	5809	482	3	2
2014-03-25 13:42:27.628449	5810	482	3	2
2014-03-26 19:58:12.000998	29702	50	2	1
2014-03-26 19:58:24.672963	29703	22.4	1	10
2014-03-25 13:42:30.185734	5815	20.2	1	8
2014-03-25 13:42:30.423185	5816	56	2	8
2014-03-25 13:42:32.765165	5817	482	3	2
2014-03-25 13:42:45.812568	5818	20.0	1	1
2014-03-25 13:42:46.05713	5819	53	2	1
2014-03-26 19:58:24.897621	29704	40	2	10
2014-03-26 19:58:32.58228	29705	853	3	2
2014-03-25 13:43:09.184492	5824	20.2	1	8
2014-03-25 13:43:09.410169	5825	56	2	8
2014-03-25 13:43:24.814283	5826	20.0	1	1
2014-03-25 13:43:25.039555	5827	53	2	1
2014-03-25 13:43:32.768603	5828	482	3	2
2014-03-26 19:58:32.819275	29706	1087139.0197884345	4	2
2014-03-26 19:58:35.054325	29707	21.8	1	9
2014-03-25 13:43:48.185181	5833	20.2	1	8
2014-03-25 13:43:48.40858	5834	56	2	8
2014-03-25 13:44:03.812831	5835	20.0	1	1
2014-03-25 13:44:04.035384	5836	53	2	1
2014-03-25 13:44:08.765808	5837	450	3	2
2014-03-25 13:44:20.765492	5838	434	3	2
2014-03-26 19:58:35.278017	29708	49	2	9
2014-03-26 19:58:36.142809	29709	21.4	1	8
2014-03-25 13:44:27.185075	5843	20.2	1	8
2014-03-25 13:44:27.407655	5844	56	2	8
2014-03-25 13:44:32.769102	5845	450	3	2
2014-03-25 13:44:42.811626	5846	20.0	1	1
2014-03-25 13:44:43.045785	5847	53	2	1
2014-03-25 13:35:57.829431	5719	20.7	1	10
2014-03-25 13:35:58.07486	5720	54	2	10
2014-03-25 13:36:36.830685	5730	20.7	1	10
2014-03-25 13:36:37.064782	5731	54	2	10
2014-03-25 13:37:16.03282	5739	20.7	1	10
2014-03-25 13:37:16.257018	5740	54	2	10
2014-03-25 13:37:54.829041	5748	20.7	1	10
2014-03-25 13:37:55.063831	5749	54	2	10
2014-03-25 13:38:33.829524	5758	20.7	1	10
2014-03-25 13:38:34.053831	5759	54	2	10
2014-03-25 13:39:13.067497	5766	20.7	1	10
2014-03-25 13:39:13.453124	5767	54	2	10
2014-03-25 13:39:51.832858	5775	20.7	1	10
2014-03-25 13:39:52.05882	5776	54	2	10
2014-03-25 13:40:30.829826	5783	20.7	1	10
2014-03-25 13:40:31.054136	5784	54	2	10
2014-03-25 13:41:09.828935	5792	20.7	1	10
2014-03-25 13:41:10.054765	5793	54	2	10
2014-03-25 13:41:48.829991	5801	20.7	1	10
2014-03-25 13:41:49.054059	5802	54	2	10
2014-03-25 13:42:27.935468	5811	20.7	1	10
2014-03-25 13:42:28.168565	5812	54	2	10
2014-03-25 13:43:06.831877	5820	20.7	1	10
2014-03-25 13:43:07.065593	5821	54	2	10
2014-03-25 13:43:45.830692	5829	20.7	1	10
2014-03-25 13:43:46.05396	5830	54	2	10
2014-03-26 19:58:36.376662	29710	51	2	8
2014-03-26 19:58:50.769601	29711	20.9	1	1
2014-03-25 13:45:06.185039	5852	20.2	1	8
2014-03-25 13:45:06.40784	5853	56	2	8
2014-03-25 13:45:21.810233	5854	20.0	1	1
2014-03-25 13:45:22.056804	5855	53	2	1
2014-03-25 13:45:32.78174	5856	450	3	2
2014-03-26 19:58:50.994735	29712	50	2	1
2014-03-26 19:58:56.578472	29713	708	3	2
2014-03-25 13:45:45.184857	5861	20.2	1	8
2014-03-25 13:45:45.40831	5862	56	2	8
2014-03-25 13:46:00.810977	5863	20.0	1	1
2014-03-25 13:46:01.035675	5864	53	2	1
2014-03-26 19:58:56.819228	29714	1087143.6159273202	4	2
2014-03-26 19:59:03.670172	29715	22.4	1	10
2014-03-25 13:46:24.183735	5869	20.2	1	8
2014-03-25 13:46:24.415403	5870	56	2	8
2014-03-25 13:46:32.767867	5871	450	3	2
2014-03-25 13:46:39.80842	5872	20.0	1	1
2014-03-25 13:46:40.031379	5873	53	2	1
2014-03-26 19:59:03.896903	29716	40	2	10
2014-03-26 19:59:08.576276	29717	724	3	2
2014-03-25 13:47:03.188593	5878	20.2	1	8
2014-03-25 13:47:03.413246	5879	56	2	8
2014-03-25 13:47:18.811434	5880	20.0	1	1
2014-03-25 13:47:19.034236	5881	53	2	1
2014-03-25 13:47:32.764031	5882	434	3	2
2014-03-26 19:59:08.811398	29718	1087147.0630314844	4	2
2014-03-26 19:59:14.053297	29719	21.8	1	9
2014-03-25 13:47:42.184087	5887	20.2	1	8
2014-03-25 13:47:42.40759	5888	56	2	8
2014-03-25 13:47:57.807061	5889	20.0	1	1
2014-03-25 13:47:58.031189	5890	53	2	1
2014-03-26 19:59:14.28471	29720	49	2	9
2014-03-26 19:59:15.143134	29721	21.4	1	8
2014-03-25 13:48:20.770262	5895	466	3	2
2014-03-25 13:48:21.184744	5896	20.2	1	8
2014-03-25 13:48:21.410457	5897	56	2	8
2014-03-25 13:48:32.769165	5898	450	3	2
2014-03-25 13:48:36.806115	5899	20.0	1	1
2014-03-25 13:48:37.028559	5900	53	2	1
2014-03-26 19:59:15.377272	29722	51	2	8
2014-03-26 19:59:20.580082	29723	837	3	2
2014-03-25 13:49:00.184954	5905	20.2	1	8
2014-03-25 13:49:00.405751	5906	56	2	8
2014-03-25 13:49:15.806892	5907	20.0	1	1
2014-03-25 13:49:16.030158	5908	53	2	1
2014-03-25 13:49:32.766713	5909	466	3	2
2014-03-26 19:59:20.807914	29724	1087149.3611009272	4	2
2014-03-26 19:59:29.769468	29725	20.9	1	1
2014-03-25 13:49:39.185179	5914	20.2	1	8
2014-03-25 13:49:39.408725	5915	56	2	8
2014-03-25 13:49:44.767546	5916	434	3	2
2014-03-25 13:49:54.804323	5917	20.0	1	1
2014-03-25 13:49:55.02688	5918	53	2	1
2014-03-25 13:49:56.766573	5919	434	3	2
2014-03-26 19:59:30.01452	29726	50	2	1
2014-03-26 19:59:32.579252	29727	724	3	2
2014-03-25 13:50:18.185173	5924	20.2	1	8
2014-03-25 13:50:18.418746	5925	56	2	8
2014-03-25 13:50:32.765391	5926	466	3	2
2014-03-25 13:50:33.805844	5927	20.0	1	1
2014-03-25 13:50:34.031037	5928	53	2	1
2014-03-25 13:50:44.765416	5929	466	3	2
2014-03-26 19:59:32.804607	29728	1087152.8082050916	4	2
2014-03-26 19:59:42.670277	29729	22.4	1	10
2014-03-25 13:50:57.184306	5934	20.2	1	8
2014-03-25 13:50:57.405103	5935	56	2	8
2014-03-25 13:51:12.803032	5936	20.0	1	1
2014-03-25 13:51:13.027964	5937	53	2	1
2014-03-25 13:51:32.764624	5938	482	3	2
2014-03-26 19:59:42.906099	29730	40	2	10
2014-03-26 19:59:44.580268	29731	837	3	2
2014-03-25 13:51:36.184695	5943	20.2	1	8
2014-03-25 13:51:36.406678	5944	56	2	8
2014-03-25 13:51:51.80627	5945	20.0	1	1
2014-03-25 13:51:52.040039	5946	53	2	1
2014-03-26 19:59:44.804538	29732	1087155.1062745342	4	2
2014-03-26 19:59:53.054444	29733	21.8	1	9
2014-03-25 13:52:15.186528	5951	20.2	1	8
2014-03-25 13:52:15.40687	5952	56	2	8
2014-03-25 13:52:30.804762	5953	20.0	1	1
2014-03-25 13:52:31.038551	5954	53	2	1
2014-03-25 13:52:32.763643	5955	466	3	2
2014-03-26 19:59:53.290264	29734	49	2	9
2014-03-26 19:59:54.140039	29735	21.5	1	8
2014-03-25 13:52:54.186108	5960	20.2	1	8
2014-03-25 13:52:54.413227	5961	56	2	8
2014-03-25 13:53:09.8037	5962	20.0	1	1
2014-03-25 13:53:10.026275	5963	53	2	1
2014-03-25 13:53:20.764088	5964	498	3	2
2014-03-26 19:59:54.364827	29736	51	2	8
2014-03-26 19:59:56.577923	29737	837	3	2
2014-03-25 13:53:32.765321	5969	482	3	2
2014-03-25 13:53:33.183259	5970	20.2	1	8
2014-03-25 13:53:33.407091	5971	56	2	8
2014-03-25 13:53:48.804603	5972	20.0	1	1
2014-03-25 13:53:49.029063	5973	53	2	1
2014-03-26 19:59:56.812415	29738	1087157.404343977	4	2
2014-03-26 20:00:08.766734	29739	20.9	1	1
2014-03-25 13:54:12.185515	5978	20.2	1	8
2014-03-25 13:54:12.416853	5979	56	2	8
2014-03-25 13:54:27.804105	5980	20.0	1	1
2014-03-25 13:54:28.028791	5981	53	2	1
2014-03-25 13:54:32.767656	5982	482	3	2
2014-03-25 13:45:04.057074	5849	54	2	10
2014-03-25 13:45:42.831252	5857	20.7	1	10
2014-03-25 13:45:43.054798	5858	54	2	10
2014-03-25 13:46:21.830384	5865	20.7	1	10
2014-03-25 13:46:22.055647	5866	54	2	10
2014-03-25 13:47:00.830872	5874	20.7	1	10
2014-03-25 13:47:01.055381	5875	54	2	10
2014-03-25 13:47:39.831955	5883	20.7	1	10
2014-03-25 13:47:40.055841	5884	54	2	10
2014-03-25 13:48:18.832575	5891	20.7	1	10
2014-03-25 13:48:19.067005	5892	54	2	10
2014-03-25 13:48:57.832411	5901	20.7	1	10
2014-03-25 13:48:58.054383	5902	54	2	10
2014-03-25 13:49:36.832264	5910	20.7	1	10
2014-03-25 13:49:37.054214	5911	54	2	10
2014-03-25 13:50:15.834717	5920	20.7	1	10
2014-03-25 13:50:16.067012	5921	54	2	10
2014-03-25 13:50:54.834987	5930	20.7	1	10
2014-03-25 13:50:55.057721	5931	54	2	10
2014-03-25 13:51:33.833329	5939	20.7	1	10
2014-03-25 13:51:34.057412	5940	54	2	10
2014-03-25 13:52:12.83038	5947	20.7	1	10
2014-03-25 13:52:13.052024	5948	54	2	10
2014-03-25 13:52:51.835492	5956	20.7	1	10
2014-03-25 13:52:52.058414	5957	54	2	10
2014-03-25 13:53:30.834146	5965	20.7	1	10
2014-03-25 13:53:31.055552	5966	54	2	10
2014-03-25 13:54:09.833617	5974	20.7	1	10
2014-03-26 20:00:08.992966	29740	50	2	1
2014-03-26 20:00:20.577892	29741	724	3	2
2014-03-25 13:54:51.185101	5987	20.2	1	8
2014-03-25 13:54:51.406981	5988	56	2	8
2014-03-25 13:55:06.803006	5989	20.0	1	1
2014-03-25 13:55:07.034145	5990	53	2	1
2014-03-26 20:00:20.813695	29742	1087163.1495175844	4	2
2014-03-26 20:00:21.669265	29743	22.4	1	10
2014-03-25 13:55:30.184638	5995	20.2	1	8
2014-03-25 13:55:30.408095	5996	56	2	8
2014-03-25 13:55:32.764986	5997	482	3	2
2014-03-25 13:55:45.807009	5998	20.0	1	1
2014-03-25 13:55:46.029754	5999	53	2	1
2014-03-25 13:55:56.766482	6000	450	3	2
2014-03-26 20:00:21.893367	29744	40	2	10
2014-03-26 20:00:32.054727	29745	21.8	1	9
2014-03-25 13:56:08.765195	6005	402	3	2
2014-03-25 13:56:09.184372	6006	20.2	1	8
2014-03-25 13:56:09.407033	6007	56	2	8
2014-03-25 13:56:20.76673	6008	402	3	2
2014-03-25 13:56:24.802839	6009	20.0	1	1
2014-03-25 13:56:25.025611	6010	53	2	1
2014-03-25 13:56:32.765311	6011	402	3	2
2014-03-25 13:56:44.762587	6012	370	3	2
2014-03-26 20:00:32.290287	29746	49	2	9
2014-03-26 20:00:32.59801	29747	708	3	2
2014-03-25 13:56:48.185359	6017	20.2	1	8
2014-03-25 13:56:48.406262	6018	56	2	8
2014-03-25 13:56:56.762943	6019	402	3	2
2014-03-25 13:57:03.80344	6020	20.0	1	1
2014-03-25 13:57:04.02863	6021	53	2	1
2014-03-25 13:57:08.76533	6022	370	3	2
2014-03-25 13:57:20.766213	6023	402	3	2
2014-03-26 20:00:32.823017	29748	1087165.4475870272	4	2
2014-03-26 20:00:33.142021	29749	21.5	1	8
2014-03-25 13:57:27.185004	6028	20.2	1	8
2014-03-25 13:57:27.407736	6029	56	2	8
2014-03-25 13:57:32.763869	6030	370	3	2
2014-03-25 13:57:42.804061	6031	20.0	1	1
2014-03-25 13:57:43.04894	6032	53	2	1
2014-03-25 13:57:44.764953	6033	370	3	2
2014-03-26 20:00:33.382856	29750	51	2	8
2014-03-26 20:00:47.768429	29751	20.9	1	1
2014-03-25 13:58:06.185701	6038	20.2	1	8
2014-03-25 13:58:06.407912	6039	56	2	8
2014-03-25 13:58:21.799629	6040	20.0	1	1
2014-03-25 13:58:22.02356	6041	53	2	1
2014-03-25 13:58:32.763116	6042	370	3	2
2014-03-26 20:00:47.992526	29752	50	2	1
2014-03-26 20:00:56.57658	29753	804	3	2
2014-03-25 13:58:45.184427	6047	20.2	1	8
2014-03-25 13:58:45.408097	6048	56	2	8
2014-03-25 13:58:56.765832	6049	402	3	2
2014-03-25 13:59:00.802303	6050	20.0	1	1
2014-03-25 13:59:01.024582	6051	53	2	1
2014-03-25 13:59:08.765912	6052	370	3	2
2014-03-25 13:59:20.763348	6053	370	3	2
2014-03-26 20:00:56.811803	29754	1087170.0437259127	4	2
2014-03-26 20:01:00.673449	29755	22.5	1	10
2014-03-25 13:59:24.185131	6058	20.2	1	8
2014-03-25 13:59:24.412885	6059	56	2	8
2014-03-25 13:59:32.770418	6060	370	3	2
2014-03-25 13:59:39.800245	6061	20.0	1	1
2014-03-25 13:59:40.023915	6062	53	2	1
2014-03-26 20:01:00.900548	29756	40	2	10
2014-03-26 20:01:08.576638	29757	804	3	2
2014-03-25 14:00:03.184556	6067	20.2	1	8
2014-03-25 14:00:03.415348	6068	56	2	8
2014-03-25 14:00:18.803836	6069	20.0	1	1
2014-03-25 14:00:19.028656	6070	53	2	1
2014-03-25 14:00:20.767133	6071	418	3	2
2014-03-25 14:00:32.766371	6072	402	3	2
2014-03-26 20:01:08.811355	29758	1087173.490830077	4	2
2014-03-26 20:01:11.053821	29759	21.9	1	9
2014-03-25 14:00:42.18431	6077	20.2	1	8
2014-03-25 14:00:42.407821	6078	56	2	8
2014-03-25 14:00:44.769529	6079	370	3	2
2014-03-25 14:00:56.768026	6080	370	3	2
2014-03-25 14:00:57.802834	6081	20.0	1	1
2014-03-25 14:00:58.026747	6082	53	2	1
2014-03-26 20:01:11.280081	29760	49	2	9
2014-03-26 20:01:12.143105	29761	21.5	1	8
2014-03-25 14:01:21.184288	6087	20.2	1	8
2014-03-25 14:01:21.417528	6088	56	2	8
2014-03-25 14:01:32.767339	6089	370	3	2
2014-03-25 14:01:36.800431	6090	20.0	1	1
2014-03-25 14:01:37.026684	6091	53	2	1
2014-03-26 20:01:12.377045	29762	51	2	8
2014-03-26 20:01:20.579188	29763	708	3	2
2014-03-25 14:02:00.201366	6096	20.2	1	8
2014-03-25 14:02:00.450482	6097	56	2	8
2014-03-25 14:02:08.763304	6098	418	3	2
2014-03-25 14:02:15.799403	6099	20.0	1	1
2014-03-25 14:02:16.030011	6100	53	2	1
2014-03-25 14:02:20.769714	6101	418	3	2
2014-03-25 14:02:32.767109	6102	402	3	2
2014-03-26 20:01:20.807439	29764	1087175.78889952	4	2
2014-03-25 14:02:39.202141	6107	20.2	1	8
2014-03-25 14:02:39.458805	6108	56	2	8
2014-03-25 14:02:54.831012	6109	20.0	1	1
2014-03-25 14:02:55.05483	6110	53	2	1
2014-03-25 14:03:18.186579	6115	20.2	1	8
2014-03-25 14:03:18.418002	6116	56	2	8
2014-03-25 14:03:32.765597	6117	434	3	2
2014-03-25 14:03:33.802586	6118	20.0	1	1
2014-03-25 14:03:34.026655	6119	53	2	1
2014-03-25 14:03:44.764228	6120	418	3	2
2014-03-25 13:55:27.833818	5991	20.7	1	10
2014-03-25 13:55:28.056264	5992	54	2	10
2014-03-25 13:56:06.837795	6001	20.7	1	10
2014-03-25 13:56:07.061069	6002	54	2	10
2014-03-25 13:56:45.834708	6013	20.7	1	10
2014-03-25 13:56:46.057749	6014	54	2	10
2014-03-25 13:57:24.835617	6024	20.7	1	10
2014-03-25 13:57:25.058228	6025	54	2	10
2014-03-25 13:58:03.835425	6034	20.7	1	10
2014-03-25 13:58:04.058107	6035	54	2	10
2014-03-25 13:58:42.835967	6043	20.7	1	10
2014-03-25 13:58:43.064442	6044	54	2	10
2014-03-25 13:59:21.835199	6054	20.7	1	10
2014-03-25 13:59:22.057428	6055	54	2	10
2014-03-25 14:00:00.981232	6063	20.7	1	10
2014-03-25 14:00:01.449995	6064	54	2	10
2014-03-25 14:00:39.836327	6073	20.7	1	10
2014-03-25 14:00:40.059418	6074	54	2	10
2014-03-25 14:01:18.838268	6083	20.7	1	10
2014-03-25 14:01:19.072394	6084	54	2	10
2014-03-25 14:01:57.836024	6092	20.7	1	10
2014-03-25 14:01:58.061402	6093	54	2	10
2014-03-25 14:02:36.837309	6103	20.7	1	10
2014-03-25 14:02:37.13924	6104	53	2	10
2014-03-25 14:03:15.836878	6111	20.6	1	10
2014-03-25 14:03:16.070551	6112	53	2	10
2014-03-26 20:01:26.767466	29765	20.9	1	1
2014-03-26 20:01:27.002407	29766	50	2	1
2014-03-25 14:03:57.185022	6125	20.2	1	8
2014-03-25 14:03:57.415919	6126	56	2	8
2014-03-25 14:04:12.799688	6127	20.0	1	1
2014-03-25 14:04:13.023325	6128	53	2	1
2014-03-25 14:04:32.767723	6129	402	3	2
2014-03-26 20:01:32.578326	29767	724	3	2
2014-03-26 20:01:32.81186	29768	1087178.0869689626	4	2
2014-03-25 14:04:36.184648	6134	20.2	1	8
2014-03-25 14:04:36.408636	6135	56	2	8
2014-03-25 14:04:44.764848	6136	434	3	2
2014-03-25 14:04:51.797966	6137	20.0	1	1
2014-03-25 14:04:52.019961	6138	53	2	1
2014-03-25 14:04:56.764444	6139	418	3	2
2014-03-26 20:01:39.672112	29769	22.5	1	10
2014-03-26 20:01:39.907156	29770	40	2	10
2014-03-25 14:05:15.186239	6144	20.2	1	8
2014-03-25 14:05:15.409623	6145	56	2	8
2014-03-25 14:05:30.796772	6146	20.0	1	1
2014-03-25 14:05:31.019112	6147	53	2	1
2014-03-25 14:05:32.766788	6148	418	3	2
2014-03-26 20:01:50.055575	29771	21.9	1	9
2014-03-26 20:01:50.283576	29772	49	2	9
2014-03-25 14:05:54.184921	6153	20.2	1	8
2014-03-25 14:05:54.40668	6154	56	2	8
2014-03-25 14:06:09.80099	6155	20.0	1	1
2014-03-25 14:06:10.034031	6156	53	2	1
2014-03-26 20:01:51.140635	29773	21.6	1	8
2014-03-26 20:01:51.387925	29774	51	2	8
2014-03-25 14:06:32.768329	6161	418	3	2
2014-03-25 14:06:33.18438	6162	20.2	1	8
2014-03-25 14:06:33.40649	6163	56	2	8
2014-03-25 14:06:48.8005	6164	20.0	1	1
2014-03-25 14:06:49.026271	6165	53	2	1
2014-03-26 20:02:05.765925	29775	20.9	1	1
2014-03-26 20:02:05.990621	29776	50	2	1
2014-03-25 14:07:12.184	6170	20.2	1	8
2014-03-25 14:07:12.405705	6171	56	2	8
2014-03-25 14:07:27.79815	6172	20.0	1	1
2014-03-25 14:07:28.02349	6173	53	2	1
2014-03-25 14:07:32.764883	6174	402	3	2
2014-03-26 20:02:18.669947	29777	22.5	1	10
2014-03-26 20:02:18.909529	29778	40	2	10
2014-03-25 14:07:51.183741	6179	20.2	1	8
2014-03-25 14:07:51.407366	6180	56	2	8
2014-03-25 14:07:56.764822	6181	354	3	2
2014-03-25 14:08:06.79593	6182	20.0	1	1
2014-03-25 14:08:07.019362	6183	53	2	1
2014-03-25 14:08:08.78142	6184	354	3	2
2014-03-26 20:02:29.053765	29779	21.9	1	9
2014-03-26 20:02:29.277763	29780	49	2	9
2014-03-25 14:08:30.185177	6189	20.2	1	8
2014-03-25 14:08:30.41103	6190	56	2	8
2014-03-25 14:08:32.764494	6191	354	3	2
2014-03-25 14:08:45.792462	6192	20.0	1	1
2014-03-25 14:08:46.01643	6193	53	2	1
2014-03-26 20:02:30.139883	29781	21.6	1	8
2014-03-26 20:02:30.374463	29782	51	2	8
2014-03-25 14:09:09.184922	6198	20.2	1	8
2014-03-25 14:09:09.438224	6199	56	2	8
2014-03-25 14:09:24.796144	6200	20.0	1	1
2014-03-25 14:09:25.019536	6201	53	2	1
2014-03-25 14:09:32.763338	6202	370	3	2
2014-03-26 20:02:32.574917	29783	724	3	2
2014-03-26 20:02:32.799494	29784	1087190.7263508982	4	2
2014-03-25 14:09:48.183926	6207	20.2	1	8
2014-03-25 14:09:48.408707	6208	56	2	8
2014-03-25 14:10:03.794663	6209	20.0	1	1
2014-03-25 14:10:04.02628	6210	53	2	1
2014-03-26 20:02:44.763673	29785	20.8	1	1
2014-03-26 20:02:44.999133	29786	50	2	1
2014-03-25 14:10:27.183687	6215	20.2	1	8
2014-03-25 14:10:27.404768	6216	56	2	8
2014-03-25 14:10:32.761333	6217	370	3	2
2014-03-25 14:10:42.79602	6218	20.0	1	1
2014-03-25 14:10:43.017593	6219	53	2	1
2014-03-26 20:02:56.576541	29787	804	3	2
2014-03-26 20:02:56.80314	29788	1087195.3224897839	4	2
2014-03-25 14:11:06.18596	6224	20.2	1	8
2014-03-25 14:11:06.409168	6225	56	2	8
2014-03-25 14:11:21.794726	6226	20.0	1	1
2014-03-25 14:11:22.016463	6227	53	2	1
2014-03-25 14:11:32.765674	6228	354	3	2
2014-03-26 20:02:57.672355	29789	22.5	1	10
2014-03-26 20:02:57.907268	29790	40	2	10
2014-03-25 14:11:45.183851	6233	20.2	1	8
2014-03-25 14:11:45.40914	6234	56	2	8
2014-03-25 14:12:00.794005	6235	20.0	1	1
2014-03-25 14:12:01.027343	6236	53	2	1
2014-03-26 20:03:08.054615	29791	21.9	1	9
2014-03-26 20:03:08.279565	29792	49	2	9
2014-03-25 14:12:24.186854	6241	20.2	1	8
2014-03-25 14:12:24.413257	6242	56	2	8
2014-03-25 14:12:32.764337	6243	370	3	2
2014-03-25 14:12:39.792352	6244	20.0	1	1
2014-03-25 14:12:40.020217	6245	53	2	1
2014-03-26 20:03:08.588731	29793	724	3	2
2014-03-26 20:03:08.821678	29794	1087197.6205592267	4	2
2014-03-26 20:03:09.142957	29795	21.6	1	8
2014-03-25 14:13:03.184805	6250	20.2	1	8
2014-03-25 14:13:03.43022	6251	56	2	8
2014-03-25 14:13:18.795247	6252	20.0	1	1
2014-03-25 14:13:19.020757	6253	53	2	1
2014-03-25 14:13:32.768587	6254	354	3	2
2014-03-25 14:03:54.838188	6121	20.6	1	10
2014-03-25 14:03:55.061441	6122	53	2	10
2014-03-25 14:04:33.839513	6130	20.6	1	10
2014-03-25 14:04:34.063971	6131	53	2	10
2014-03-25 14:05:12.840181	6140	20.6	1	10
2014-03-25 14:05:13.062115	6141	53	2	10
2014-03-25 14:05:51.837957	6149	20.6	1	10
2014-03-25 14:05:52.061125	6150	53	2	10
2014-03-25 14:06:30.843714	6157	20.6	1	10
2014-03-25 14:06:31.066914	6158	53	2	10
2014-03-25 14:07:09.840104	6166	20.6	1	10
2014-03-25 14:07:10.063467	6167	53	2	10
2014-03-25 14:07:48.838672	6175	20.6	1	10
2014-03-25 14:07:49.065737	6176	53	2	10
2014-03-25 14:08:27.83823	6185	20.6	1	10
2014-03-25 14:08:28.062853	6186	53	2	10
2014-03-25 14:09:06.840364	6194	20.6	1	10
2014-03-25 14:09:07.063358	6195	53	2	10
2014-03-25 14:09:45.839957	6203	20.6	1	10
2014-03-25 14:09:46.064313	6204	53	2	10
2014-03-25 14:10:24.840032	6211	20.6	1	10
2014-03-25 14:10:25.061919	6212	53	2	10
2014-03-25 14:11:03.839503	6220	20.6	1	10
2014-03-25 14:11:04.061451	6221	53	2	10
2014-03-25 14:11:42.842213	6229	20.6	1	10
2014-03-25 14:11:43.064914	6230	53	2	10
2014-03-25 14:12:21.842224	6237	20.6	1	10
2014-03-25 14:12:22.066714	6238	53	2	10
2014-03-26 20:03:09.369158	29796	50	2	8
2014-03-26 20:03:20.577647	29797	708	3	2
2014-03-25 14:13:42.18612	6259	20.2	1	8
2014-03-25 14:13:42.409062	6260	55	2	8
2014-03-25 14:13:57.79506	6261	20.0	1	1
2014-03-25 14:13:58.017359	6262	53	2	1
2014-03-25 14:14:08.76886	6263	418	3	2
2014-03-26 20:03:20.812028	29798	1087199.9186286696	4	2
2014-03-26 20:03:23.761925	29799	20.8	1	1
2014-03-25 14:14:20.763729	6268	418	3	2
2014-03-25 14:14:21.18415	6269	20.2	1	8
2014-03-25 14:14:21.408534	6270	55	2	8
2014-03-25 14:14:32.76486	6271	418	3	2
2014-03-25 14:14:37.03181	6272	20.0	1	1
2014-03-25 14:14:37.256301	6273	53	2	1
2014-03-26 20:03:23.98633	29800	50	2	1
2014-03-26 20:03:32.583075	29801	724	3	2
2014-03-25 14:15:00.184593	6278	20.2	1	8
2014-03-25 14:15:00.409387	6279	55	2	8
2014-03-25 14:15:15.789888	6280	20.0	1	1
2014-03-25 14:15:16.023193	6281	53	2	1
2014-03-25 14:15:32.760183	6282	418	3	2
2014-03-26 20:03:32.818978	29802	1087202.2166981124	4	2
2014-03-26 20:03:36.672667	29803	22.5	1	10
2014-03-25 14:15:39.184462	6287	20.2	1	8
2014-03-25 14:15:39.416597	6288	55	2	8
2014-03-25 14:15:54.790424	6289	20.0	1	1
2014-03-25 14:15:55.013783	6290	53	2	1
2014-03-26 20:03:36.899471	29804	40	2	10
2014-03-26 20:03:44.580398	29805	804	3	2
2014-03-25 14:16:18.186239	6295	20.2	1	8
2014-03-25 14:16:18.427505	6296	55	2	8
2014-03-25 14:16:32.764848	6297	418	3	2
2014-03-25 14:16:33.788461	6298	20.0	1	1
2014-03-25 14:16:34.011925	6299	53	2	1
2014-03-26 20:03:44.814011	29806	1087205.6638022766	4	2
2014-03-26 20:03:47.05296	29807	22.0	1	9
2014-03-25 14:16:57.184082	6304	20.2	1	8
2014-03-25 14:16:57.407997	6305	55	2	8
2014-03-25 14:17:12.790258	6306	20.0	1	1
2014-03-25 14:17:13.013475	6307	53	2	1
2014-03-25 14:17:32.761841	6308	418	3	2
2014-03-26 20:03:47.275823	29808	48	2	9
2014-03-26 20:03:48.140607	29809	21.6	1	8
2014-03-25 14:17:36.185713	6313	20.2	1	8
2014-03-25 14:17:36.417062	6314	55	2	8
2014-03-25 14:17:51.784155	6315	20.0	1	1
2014-03-25 14:17:52.044966	6316	53	2	1
2014-03-26 20:03:48.374086	29810	50	2	8
2014-03-26 20:03:56.577649	29811	676	3	2
2014-03-25 14:18:15.184557	6321	20.2	1	8
2014-03-25 14:18:15.603643	6322	55	2	8
2014-03-25 14:18:30.784032	6323	20.0	1	1
2014-03-25 14:18:31.054869	6324	53	2	1
2014-03-25 14:18:32.763535	6325	418	3	2
2014-03-26 20:03:56.803236	29812	1087207.9618717195	4	2
2014-03-26 20:04:02.76339	29813	20.8	1	1
2014-03-25 14:18:54.185905	6330	20.2	1	8
2014-03-25 14:18:54.409464	6331	55	2	8
2014-03-25 14:19:09.784388	6332	20.0	1	1
2014-03-25 14:19:10.017157	6333	53	2	1
2014-03-26 20:04:02.998568	29814	50	2	1
2014-03-26 20:04:08.580542	29815	708	3	2
2014-03-25 14:19:32.762282	6338	418	3	2
2014-03-25 14:19:33.183997	6339	20.2	1	8
2014-03-25 14:19:33.408729	6340	55	2	8
2014-03-25 14:19:44.762661	6341	354	3	2
2014-03-25 14:19:48.783983	6342	20.0	1	1
2014-03-25 14:19:49.005099	6343	53	2	1
2014-03-25 14:19:56.763324	6344	370	3	2
2014-03-26 20:04:08.814466	29816	1087210.2599411623	4	2
2014-03-26 20:04:15.670876	29817	22.5	1	10
2014-03-25 14:20:12.184126	6349	20.2	1	8
2014-03-25 14:20:12.415261	6350	56	2	8
2014-03-25 14:20:27.786253	6351	20.0	1	1
2014-03-25 14:20:28.008534	6352	53	2	1
2014-03-25 14:20:32.762402	6353	370	3	2
2014-03-26 20:04:15.905842	29818	40	2	10
2014-03-26 20:04:20.577447	29819	804	3	2
2014-03-25 14:20:51.184446	6358	20.2	1	8
2014-03-25 14:20:51.405593	6359	55	2	8
2014-03-25 14:21:06.78446	6360	20.0	1	1
2014-03-25 14:21:07.0149	6361	53	2	1
2014-03-26 20:04:20.804128	29820	1087212.5580106052	4	2
2014-03-26 20:04:26.057725	29821	22.0	1	9
2014-03-25 14:21:30.1835	6366	20.2	1	8
2014-03-25 14:21:30.406085	6367	56	2	8
2014-03-25 14:21:32.761918	6368	354	3	2
2014-03-25 14:21:45.784922	6369	20.0	1	1
2014-03-25 14:21:46.008216	6370	53	2	1
2014-03-26 20:04:26.303744	29822	48	2	9
2014-03-26 20:04:27.140071	29823	21.6	1	8
2014-03-25 14:22:09.224596	6375	20.2	1	8
2014-03-25 14:22:09.455788	6376	55	2	8
2014-03-25 14:22:24.785982	6377	20.0	1	1
2014-03-25 14:22:25.008892	6378	53	2	1
2014-03-25 14:22:32.761539	6379	370	3	2
2014-03-26 20:04:27.365176	29824	50	2	8
2014-03-25 14:22:48.183735	6384	20.2	1	8
2014-03-25 14:22:48.405844	6385	55	2	8
2014-03-25 14:23:03.780854	6386	20.0	1	1
2014-03-25 14:23:04.023341	6387	53	2	1
2014-03-25 14:23:27.183808	6392	20.2	1	8
2014-03-25 14:14:18.841414	6264	20.6	1	10
2014-03-25 14:14:19.065981	6265	53	2	10
2014-03-25 14:14:57.84031	6274	20.6	1	10
2014-03-25 14:14:58.063403	6275	53	2	10
2014-03-25 14:15:36.841832	6283	20.6	1	10
2014-03-25 14:15:37.06481	6284	53	2	10
2014-03-25 14:16:15.841849	6291	20.6	1	10
2014-03-25 14:16:16.075502	6292	53	2	10
2014-03-25 14:16:54.842472	6300	20.6	1	10
2014-03-25 14:16:55.065698	6301	53	2	10
2014-03-25 14:17:33.844058	6309	20.6	1	10
2014-03-25 14:17:34.066541	6310	53	2	10
2014-03-25 14:18:13.048511	6317	20.6	1	10
2014-03-25 14:18:13.336489	6318	53	2	10
2014-03-25 14:18:51.842483	6326	20.6	1	10
2014-03-25 14:18:52.069073	6327	53	2	10
2014-03-25 14:19:30.842747	6334	20.6	1	10
2014-03-25 14:19:31.066039	6335	53	2	10
2014-03-25 14:20:09.841096	6345	20.6	1	10
2014-03-25 14:20:10.063181	6346	53	2	10
2014-03-25 14:20:48.842999	6354	20.6	1	10
2014-03-25 14:20:49.085385	6355	53	2	10
2014-03-25 14:21:27.84454	6362	20.6	1	10
2014-03-25 14:21:28.067234	6363	53	2	10
2014-03-25 14:22:06.842281	6371	20.6	1	10
2014-03-25 14:22:07.07317	6372	53	2	10
2014-03-25 14:22:45.844639	6380	20.6	1	10
2014-03-25 14:22:46.069893	6381	53	2	10
2014-03-25 14:23:24.842893	6388	20.6	1	10
2014-03-25 14:23:25.0696	6389	53	2	10
2014-03-25 14:23:27.405748	6393	55	2	8
2014-03-25 14:23:32.760021	6394	370	3	2
2014-03-25 14:23:42.781959	6395	20.0	1	1
2014-03-25 14:23:43.007679	6396	53	2	1
2014-03-26 20:04:32.576317	29825	804	3	2
2014-03-26 20:04:32.814263	29826	1087214.856080048	4	2
2014-03-25 14:24:06.183548	6401	20.2	1	8
2014-03-25 14:24:06.414351	6402	55	2	8
2014-03-25 14:24:20.758255	6403	402	3	2
2014-03-25 14:24:21.783191	6404	20.0	1	1
2014-03-25 14:24:22.004878	6405	53	2	1
2014-03-25 14:24:32.761298	6406	370	3	2
2014-03-26 20:04:41.763447	29827	20.8	1	1
2014-03-26 20:04:41.988619	29828	50	2	1
2014-03-25 14:24:44.761004	6411	370	3	2
2014-03-25 14:24:45.186274	6412	20.2	1	8
2014-03-25 14:24:45.408054	6413	55	2	8
2014-03-25 14:25:00.780844	6414	20.0	1	1
2014-03-25 14:25:01.011871	6415	53	2	1
2014-03-25 14:25:08.759929	6416	402	3	2
2014-03-25 14:25:20.763155	6417	402	3	2
2014-03-26 20:04:54.672393	29829	22.5	1	10
2014-03-26 20:04:54.908842	29830	40	2	10
2014-03-25 14:25:24.183241	6422	20.2	1	8
2014-03-25 14:25:24.417814	6423	55	2	8
2014-03-25 14:25:32.759688	6424	402	3	2
2014-03-25 14:25:39.778024	6425	20.0	1	1
2014-03-25 14:25:40.000429	6426	53	2	1
2014-03-25 14:25:56.759586	6427	434	3	2
2014-03-26 20:04:56.577401	29831	724	3	2
2014-03-26 20:04:56.803328	29832	1087220.601253655	4	2
2014-03-25 14:26:03.184137	6432	20.2	1	8
2014-03-25 14:26:03.406549	6433	55	2	8
2014-03-25 14:26:08.759937	6434	434	3	2
2014-03-25 14:26:18.780384	6435	20.0	1	1
2014-03-25 14:26:19.000964	6436	53	2	1
2014-03-25 14:26:20.761691	6437	402	3	2
2014-03-25 14:26:32.761008	6438	418	3	2
2014-03-26 20:05:05.053834	29833	22.0	1	9
2014-03-26 20:05:05.288811	29834	48	2	9
2014-03-25 14:26:42.183683	6443	20.2	1	8
2014-03-25 14:26:42.405719	6444	55	2	8
2014-03-25 14:26:57.782725	6445	20.0	1	1
2014-03-25 14:26:58.014057	6446	53	2	1
2014-03-26 20:05:06.142254	29835	21.6	1	8
2014-03-26 20:05:06.365557	29836	50	2	8
2014-03-25 14:27:21.184593	6451	20.2	1	8
2014-03-25 14:27:21.405601	6452	55	2	8
2014-03-25 14:27:32.762634	6453	466	3	2
2014-03-25 14:27:36.786077	6454	20.0	1	1
2014-03-25 14:27:37.007866	6455	53	2	1
2014-03-25 14:27:44.763809	6456	434	3	2
2014-03-25 14:27:56.762626	6457	434	3	2
2014-03-26 20:05:08.57701	29837	804	3	2
2014-03-26 20:05:08.811177	29838	1087222.899323098	4	2
2014-03-25 14:28:00.18646	6462	20.2	1	8
2014-03-25 14:28:00.407126	6463	55	2	8
2014-03-25 14:28:15.78203	6464	20.0	1	1
2014-03-25 14:28:16.014957	6465	53	2	1
2014-03-25 14:28:32.762628	6466	434	3	2
2014-03-26 20:05:20.763475	29839	20.8	1	1
2014-03-26 20:05:20.9896	29840	50	2	1
2014-03-25 14:28:39.183901	6471	20.2	1	8
2014-03-25 14:28:39.41471	6472	55	2	8
2014-03-25 14:28:54.779864	6473	20.0	1	1
2014-03-25 14:28:55.003283	6474	53	2	1
2014-03-26 20:05:32.578267	29841	804	3	2
2014-03-26 20:05:32.813683	29842	1087228.644496705	4	2
2014-03-25 14:29:18.182868	6479	20.2	1	8
2014-03-25 14:29:18.415954	6480	55	2	8
2014-03-25 14:29:33.583423	6481	418	3	2
2014-03-25 14:29:33.893498	6482	20.0	1	1
2014-03-25 14:29:34.116634	6483	53	2	1
2014-03-26 20:05:33.67323	29843	22.5	1	10
2014-03-26 20:05:33.90546	29844	40	2	10
2014-03-25 14:29:57.186212	6488	20.2	1	8
2014-03-25 14:29:57.406376	6489	56	2	8
2014-03-25 14:30:12.780953	6490	20.0	1	1
2014-03-25 14:30:13.014706	6491	53	2	1
2014-03-25 14:30:32.77175	6492	418	3	2
2014-03-26 20:05:44.054655	29845	22.0	1	9
2014-03-26 20:05:44.288613	29846	48	2	9
2014-03-25 14:30:36.182635	6497	20.2	1	8
2014-03-25 14:30:36.416553	6498	55	2	8
2014-03-25 14:30:51.780532	6499	20.0	1	1
2014-03-25 14:30:52.002825	6500	53	2	1
2014-03-26 20:05:45.141145	29847	21.6	1	8
2014-03-26 20:05:45.365054	29848	50	2	8
2014-03-25 14:31:15.183871	6505	20.2	1	8
2014-03-25 14:31:15.416465	6506	55	2	8
2014-03-25 14:31:30.780201	6507	20.0	1	1
2014-03-25 14:31:31.003484	6508	53	2	1
2014-03-25 14:31:32.760625	6509	402	3	2
2014-03-25 14:31:44.761112	6510	370	3	2
2014-03-26 20:05:56.580079	29849	724	3	2
2014-03-26 20:05:56.814708	29850	1087233.2406355906	4	2
2014-03-25 14:31:54.184529	6515	20.2	1	8
2014-03-25 14:31:54.415758	6516	55	2	8
2014-03-25 14:31:56.761217	6517	402	3	2
2014-03-25 14:32:08.758508	6518	418	3	2
2014-03-25 14:32:09.775665	6519	20.0	1	1
2014-03-25 14:32:10.020957	6520	53	2	1
2014-03-25 14:32:20.759784	6521	370	3	2
2014-03-26 20:05:59.76276	29851	20.8	1	1
2014-03-25 14:32:32.763214	6526	402	3	2
2014-03-25 14:32:33.181399	6527	20.2	1	8
2014-03-25 14:32:33.402716	6528	55	2	8
2014-03-25 14:24:03.84383	6397	20.6	1	10
2014-03-25 14:24:04.078624	6398	53	2	10
2014-03-25 14:24:42.843425	6407	20.6	1	10
2014-03-25 14:24:43.067511	6408	53	2	10
2014-03-25 14:25:21.843577	6418	20.6	1	10
2014-03-25 14:25:22.076307	6419	53	2	10
2014-03-25 14:26:00.844755	6428	20.6	1	10
2014-03-25 14:26:01.070532	6429	53	2	10
2014-03-25 14:26:39.843714	6439	20.6	1	10
2014-03-25 14:26:40.066125	6440	53	2	10
2014-03-25 14:27:18.844747	6447	20.6	1	10
2014-03-25 14:27:19.065741	6448	53	2	10
2014-03-25 14:27:57.846178	6458	20.6	1	10
2014-03-25 14:27:58.066951	6459	53	2	10
2014-03-25 14:28:36.844002	6467	20.6	1	10
2014-03-25 14:28:37.066969	6468	53	2	10
2014-03-25 14:29:15.844958	6475	20.6	1	10
2014-03-25 14:29:16.089155	6476	53	2	10
2014-03-25 14:29:54.845122	6484	20.6	1	10
2014-03-25 14:29:55.066418	6485	53	2	10
2014-03-25 14:30:33.84506	6493	20.6	1	10
2014-03-25 14:30:34.066889	6494	53	2	10
2014-03-25 14:31:12.847274	6501	20.6	1	10
2014-03-25 14:31:13.076834	6502	53	2	10
2014-03-25 14:31:51.845097	6511	20.6	1	10
2014-03-25 14:31:52.067587	6512	53	2	10
2014-03-25 14:32:44.765008	6529	402	3	2
2014-03-25 14:32:48.779646	6530	20.0	1	1
2014-03-25 14:32:49.010161	6531	53	2	1
2014-03-26 20:05:59.988436	29852	50	2	1
2014-03-26 20:06:08.576347	29853	724	3	2
2014-03-25 14:33:12.183967	6536	20.1	1	8
2014-03-25 14:33:12.404454	6537	55	2	8
2014-03-25 14:33:27.778889	6538	20.0	1	1
2014-03-25 14:33:28.00935	6539	53	2	1
2014-03-25 14:33:32.763136	6540	402	3	2
2014-03-26 20:06:08.811431	29854	1087235.5387050335	4	2
2014-03-26 20:06:12.672725	29855	22.5	1	10
2014-03-25 14:33:51.183658	6545	20.1	1	8
2014-03-25 14:33:51.404409	6546	55	2	8
2014-03-25 14:34:06.773625	6547	20.0	1	1
2014-03-25 14:34:06.996939	6548	53	2	1
2014-03-26 20:06:12.896471	29856	40	2	10
2014-03-26 20:06:23.055336	29857	22.0	1	9
2014-03-25 14:34:30.185515	6553	20.1	1	8
2014-03-25 14:34:30.416085	6554	55	2	8
2014-03-25 14:34:32.7631	6555	402	3	2
2014-03-25 14:34:45.775642	6556	20.0	1	1
2014-03-25 14:34:45.996599	6557	53	2	1
2014-03-26 20:06:23.41473	29858	48	2	9
2014-03-26 20:06:24.234557	29859	21.6	1	8
2014-03-25 14:35:08.764258	6562	370	3	2
2014-03-25 14:35:09.18829	6563	20.1	1	8
2014-03-25 14:35:09.409429	6564	55	2	8
2014-03-25 14:35:20.761533	6565	402	3	2
2014-03-25 14:35:24.775105	6566	20.0	1	1
2014-03-25 14:35:24.994937	6567	53	2	1
2014-03-25 14:35:44.618735	6568	402	3	2
2014-03-25 14:35:44.941503	6569	370	3	2
2014-03-26 20:06:24.511953	29860	50	2	8
2014-03-26 20:06:32.577261	29861	676	3	2
2014-03-25 14:35:48.184137	6574	20.1	1	8
2014-03-25 14:35:48.407921	6575	55	2	8
2014-03-25 14:35:56.762888	6576	402	3	2
2014-03-25 14:36:03.773492	6577	20.0	1	1
2014-03-25 14:36:03.994614	6578	53	2	1
2014-03-25 14:36:08.761318	6579	402	3	2
2014-03-25 14:36:20.758636	6580	370	3	2
2014-03-26 20:06:33.115464	29862	1087241.2838786405	4	2
2014-03-26 20:06:38.762016	29863	20.8	1	1
2014-03-25 14:36:27.186647	6585	20.1	1	8
2014-03-25 14:36:27.409434	6586	55	2	8
2014-03-25 14:36:32.761623	6587	370	3	2
2014-03-25 14:36:42.774289	6588	20.0	1	1
2014-03-25 14:36:42.997268	6589	53	2	1
2014-03-25 14:36:44.763946	6590	434	3	2
2014-03-25 14:36:56.763732	6591	434	3	2
2014-03-26 20:06:39.068912	29864	50	2	1
2014-03-26 20:06:44.57747	29865	676	3	2
2014-03-25 14:37:06.184097	6596	20.1	1	8
2014-03-25 14:37:06.416439	6597	55	2	8
2014-03-25 14:37:21.775482	6598	20.0	1	1
2014-03-25 14:37:21.997843	6599	53	2	1
2014-03-25 14:37:32.760999	6600	482	3	2
2014-03-26 20:06:44.815641	29866	1087243.5819480834	4	2
2014-03-26 20:06:51.672247	29867	22.6	1	10
2014-03-25 14:37:44.76226	6605	482	3	2
2014-03-25 14:37:45.400975	6606	20.1	1	8
2014-03-25 14:37:45.624552	6607	55	2	8
2014-03-25 14:38:00.774823	6608	20.0	1	1
2014-03-25 14:38:01.00099	6609	54	2	1
2014-03-26 20:06:51.896294	29868	40	2	10
2014-03-26 20:06:56.580469	29869	724	3	2
2014-03-25 14:38:24.183942	6614	20.1	1	8
2014-03-25 14:38:24.418582	6615	55	2	8
2014-03-25 14:38:32.765475	6616	498	3	2
2014-03-25 14:38:39.775849	6617	20.0	1	1
2014-03-25 14:38:40.000173	6618	54	2	1
2014-03-26 20:06:56.830122	29870	1087245.8800175262	4	2
2014-03-26 20:07:02.053556	29871	21.9	1	9
2014-03-25 14:39:03.183632	6623	20.1	1	8
2014-03-25 14:39:03.405595	6624	55	2	8
2014-03-25 14:39:18.770914	6625	20.0	1	1
2014-03-25 14:39:19.006241	6626	54	2	1
2014-03-25 14:39:32.763961	6627	498	3	2
2014-03-26 20:07:02.283953	29872	48	2	9
2014-03-26 20:07:03.140048	29873	21.6	1	8
2014-03-25 14:39:42.183549	6632	20.1	1	8
2014-03-25 14:39:42.417795	6633	55	2	8
2014-03-25 14:39:57.772389	6634	20.0	1	1
2014-03-25 14:39:57.998195	6635	54	2	1
2014-03-26 20:07:03.376611	29874	50	2	8
2014-03-26 20:07:08.578738	29875	820	3	2
2014-03-25 14:40:21.185954	6640	20.1	1	8
2014-03-25 14:40:21.42033	6641	55	2	8
2014-03-25 14:40:32.760191	6642	498	3	2
2014-03-25 14:40:36.77216	6643	20.0	1	1
2014-03-25 14:40:36.995929	6644	54	2	1
2014-03-26 20:07:08.804348	29876	1087248.178086969	4	2
2014-03-26 20:07:17.763016	29877	20.8	1	1
2014-03-25 14:41:00.187018	6649	20.1	1	8
2014-03-25 14:41:00.40866	6650	55	2	8
2014-03-25 14:41:15.776493	6651	20.0	1	1
2014-03-25 14:41:16.023897	6652	54	2	1
2014-03-25 14:41:32.76029	6653	482	3	2
2014-03-26 20:07:17.996683	29878	50	2	1
2014-03-26 20:07:20.579756	29879	837	3	2
2014-03-26 20:07:20.805175	29880	1087251.6251911332	4	2
2014-03-25 14:41:39.18424	6658	20.1	1	8
2014-03-25 14:41:39.480748	6659	55	2	8
2014-03-25 14:41:54.769606	6660	20.0	1	1
2014-03-25 14:41:54.991011	6661	54	2	1
2014-03-25 14:33:09.848316	6532	20.6	1	10
2014-03-25 14:33:10.067805	6533	53	2	10
2014-03-25 14:33:48.849406	6541	20.6	1	10
2014-03-25 14:33:49.071891	6542	53	2	10
2014-03-25 14:34:27.848967	6549	20.6	1	10
2014-03-25 14:34:28.074744	6550	53	2	10
2014-03-25 14:35:06.848052	6558	20.6	1	10
2014-03-25 14:35:07.071739	6559	53	2	10
2014-03-25 14:35:45.848668	6570	20.6	1	10
2014-03-25 14:35:46.072662	6571	53	2	10
2014-03-25 14:36:24.84921	6581	20.6	1	10
2014-03-25 14:36:25.071431	6582	53	2	10
2014-03-25 14:37:03.849175	6592	20.6	1	10
2014-03-25 14:37:04.079513	6593	53	2	10
2014-03-25 14:37:42.848729	6601	20.6	1	10
2014-03-25 14:37:43.077183	6602	53	2	10
2014-03-25 14:38:21.847605	6610	20.6	1	10
2014-03-25 14:38:22.073843	6611	53	2	10
2014-03-25 14:39:00.851045	6619	20.6	1	10
2014-03-25 14:39:01.072978	6620	53	2	10
2014-03-25 14:39:39.848514	6628	20.6	1	10
2014-03-25 14:39:40.077291	6629	53	2	10
2014-03-25 14:40:18.849804	6636	20.6	1	10
2014-03-25 14:40:19.08468	6637	53	2	10
2014-03-25 14:40:57.848675	6645	20.6	1	10
2014-03-25 14:40:58.07041	6646	53	2	10
2014-03-25 14:41:36.8496	6654	20.6	1	10
2014-03-26 20:07:30.672813	29881	22.6	1	10
2014-03-25 14:42:18.185383	6666	20.1	1	8
2014-03-25 14:42:18.421628	6667	55	2	8
2014-03-25 14:42:32.75899	6668	498	3	2
2014-03-25 14:42:33.771474	6669	20.0	1	1
2014-03-25 14:42:33.995374	6670	54	2	1
2014-03-26 20:07:30.908202	29882	40	2	10
2014-03-26 20:07:32.580015	29883	837	3	2
2014-03-25 14:42:57.183131	6675	20.1	1	8
2014-03-25 14:42:57.410158	6676	55	2	8
2014-03-25 14:43:12.773027	6677	20.0	1	1
2014-03-25 14:43:13.007813	6678	54	2	1
2014-03-25 14:43:20.762067	6679	434	3	2
2014-03-25 14:43:32.764766	6680	434	3	2
2014-03-26 20:07:32.804649	29884	1087253.923260576	4	2
2014-03-26 20:07:41.053773	29885	21.9	1	9
2014-03-25 14:43:36.183208	6685	20.1	1	8
2014-03-25 14:43:36.417442	6686	55	2	8
2014-03-25 14:43:51.773795	6687	20.0	1	1
2014-03-25 14:43:51.99644	6688	54	2	1
2014-03-26 20:07:41.291236	29886	48	2	9
2014-03-26 20:07:42.140984	29887	21.6	1	8
2014-03-25 14:44:15.183192	6693	20.1	1	8
2014-03-25 14:44:15.417369	6694	55	2	8
2014-03-25 14:44:30.768529	6695	20.0	1	1
2014-03-25 14:44:30.993052	6696	54	2	1
2014-03-25 14:44:32.762903	6697	434	3	2
2014-03-26 20:07:42.365013	29888	50	2	8
2014-03-26 20:07:56.760754	29889	20.8	1	1
2014-03-25 14:44:54.183655	6702	20.1	1	8
2014-03-25 14:44:54.404454	6703	55	2	8
2014-03-25 14:44:56.755197	6704	515	3	2
2014-03-25 14:45:09.778996	6705	20.0	1	1
2014-03-25 14:45:10.050115	6706	54	2	1
2014-03-26 20:07:56.994967	29890	50	2	1
2014-03-26 20:08:09.672334	29891	22.6	1	10
2014-03-25 14:45:33.183855	6711	20.1	1	8
2014-03-25 14:45:33.41551	6712	55	2	8
2014-03-25 14:45:44.753808	6713	515	3	2
2014-03-25 14:45:48.775173	6714	20.0	1	1
2014-03-25 14:45:48.997634	6715	54	2	1
2014-03-25 14:45:56.759519	6716	418	3	2
2014-03-25 14:46:08.760334	6717	482	3	2
2014-03-26 20:08:09.920033	29892	40	2	10
2014-03-26 20:08:20.053394	29893	21.9	1	9
2014-03-25 14:46:12.185731	6722	20.1	1	8
2014-03-25 14:46:12.416953	6723	55	2	8
2014-03-25 14:46:20.762281	6724	482	3	2
2014-03-25 14:46:28.005464	6725	20.0	1	1
2014-03-25 14:46:28.229998	6726	54	2	1
2014-03-25 14:46:32.762159	6727	498	3	2
2014-03-26 20:08:20.286927	29894	48	2	9
2014-03-26 20:08:21.140681	29895	21.6	1	8
2014-03-25 14:46:51.18379	6732	20.1	1	8
2014-03-25 14:46:51.407047	6733	55	2	8
2014-03-25 14:47:06.7732	6734	20.0	1	1
2014-03-25 14:47:06.994922	6735	54	2	1
2014-03-26 20:08:21.362953	29896	50	2	8
2014-03-26 20:08:32.576981	29897	820	3	2
2014-03-25 14:47:30.184477	6740	20.1	1	8
2014-03-25 14:47:30.428317	6741	55	2	8
2014-03-25 14:47:32.758794	6742	482	3	2
2014-03-25 14:47:45.767674	6743	20.0	1	1
2014-03-25 14:47:45.9905	6744	54	2	1
2014-03-26 20:08:32.812886	29898	1087267.711677233	4	2
2014-03-26 20:08:35.761742	29899	20.8	1	1
2014-03-25 14:48:09.183784	6749	20.1	1	8
2014-03-25 14:48:09.432807	6750	55	2	8
2014-03-25 14:48:24.769336	6751	20.1	1	1
2014-03-25 14:48:25.002188	6752	54	2	1
2014-03-25 14:48:32.761497	6753	466	3	2
2014-03-26 20:08:35.988509	29900	50	2	1
2014-03-26 20:08:48.672596	29901	22.7	1	10
2014-03-25 14:48:48.183861	6758	20.1	1	8
2014-03-25 14:48:48.405526	6759	55	2	8
2014-03-25 14:49:03.771255	6760	20.1	1	1
2014-03-25 14:49:03.994556	6761	54	2	1
2014-03-25 14:49:20.761506	6762	515	3	2
2014-03-26 20:08:48.908603	29902	40	2	10
2014-03-26 20:08:59.053253	29903	21.9	1	9
2014-03-25 14:49:27.183905	6767	20.1	1	8
2014-03-25 14:49:27.406169	6768	55	2	8
2014-03-25 14:49:32.75939	6769	515	3	2
2014-03-25 14:49:42.770099	6770	20.1	1	1
2014-03-25 14:49:42.995183	6771	54	2	1
2014-03-26 20:08:59.277514	29904	48	2	9
2014-03-26 20:09:00.140448	29905	21.6	1	8
2014-03-25 14:50:06.184365	6776	20.1	1	8
2014-03-25 14:50:06.406232	6777	55	2	8
2014-03-25 14:50:21.768222	6778	20.1	1	1
2014-03-25 14:50:21.994813	6779	54	2	1
2014-03-25 14:50:32.76155	6780	515	3	2
2014-03-26 20:09:00.374347	29906	50	2	8
2014-03-26 20:09:14.762202	29907	20.8	1	1
2014-03-25 14:50:45.184917	6785	20.1	1	8
2014-03-25 14:50:45.408136	6786	55	2	8
2014-03-25 14:51:00.769044	6787	20.1	1	1
2014-03-25 14:51:01.000588	6788	54	2	1
2014-03-25 14:51:20.758283	6789	466	3	2
2014-03-26 20:09:14.987664	29908	50	2	1
2014-03-26 20:09:27.675032	29909	22.7	1	10
2014-03-25 14:51:24.185376	6794	20.1	1	8
2014-03-25 14:51:24.406824	6795	55	2	8
2014-03-25 14:51:32.759638	6796	450	3	2
2014-03-25 14:51:40.009274	6797	20.1	1	1
2014-03-25 14:51:40.235258	6798	54	2	1
2014-03-25 14:42:54.850851	6671	20.6	1	10
2014-03-25 14:42:55.077945	6672	53	2	10
2014-03-25 14:43:33.849893	6681	20.6	1	10
2014-03-25 14:43:34.081757	6682	53	2	10
2014-03-25 14:44:12.85213	6689	20.6	1	10
2014-03-25 14:44:13.083915	6690	53	2	10
2014-03-25 14:44:51.851056	6698	20.6	1	10
2014-03-25 14:44:52.074078	6699	53	2	10
2014-03-25 14:45:30.85017	6707	20.6	1	10
2014-03-25 14:45:31.083839	6708	53	2	10
2014-03-25 14:46:09.9046	6718	20.6	1	10
2014-03-25 14:46:10.136811	6719	53	2	10
2014-03-25 14:46:48.850876	6728	20.6	1	10
2014-03-25 14:46:49.07358	6729	53	2	10
2014-03-25 14:47:27.852727	6736	20.6	1	10
2014-03-25 14:47:28.084577	6737	53	2	10
2014-03-25 14:48:06.853289	6745	20.6	1	10
2014-03-25 14:48:07.075036	6746	53	2	10
2014-03-25 14:48:45.852396	6754	20.6	1	10
2014-03-25 14:48:46.074818	6755	53	2	10
2014-03-25 14:49:24.854287	6763	20.6	1	10
2014-03-25 14:49:25.078288	6764	53	2	10
2014-03-25 14:50:03.853217	6772	20.6	1	10
2014-03-25 14:50:04.077454	6773	53	2	10
2014-03-25 14:50:42.854371	6781	20.6	1	10
2014-03-25 14:50:43.07901	6782	53	2	10
2014-03-25 14:51:21.853888	6790	20.6	1	10
2014-03-26 20:09:27.909015	29910	40	2	10
2014-03-26 20:09:32.575957	29911	724	3	2
2014-03-25 14:52:03.183372	6803	20.1	1	8
2014-03-25 14:52:03.406916	6804	55	2	8
2014-03-25 14:52:18.774993	6805	20.1	1	1
2014-03-25 14:52:18.999385	6806	54	2	1
2014-03-25 14:52:32.759703	6807	466	3	2
2014-03-26 20:09:32.803251	29912	1087281.5000938901	4	2
2014-03-26 20:09:38.053382	29913	21.9	1	9
2014-03-25 14:52:42.185368	6812	20.1	1	8
2014-03-25 14:52:42.408625	6813	55	2	8
2014-03-25 14:52:57.76968	6814	20.1	1	1
2014-03-25 14:52:57.993029	6815	54	2	1
2014-03-26 20:09:38.291601	29914	48	2	9
2014-03-26 20:09:39.139892	29915	21.6	1	8
2014-03-25 14:53:21.184727	6820	20.1	1	8
2014-03-25 14:53:21.415405	6821	55	2	8
2014-03-25 14:53:32.758917	6822	466	3	2
2014-03-25 14:53:37.009011	6823	20.1	1	1
2014-03-25 14:53:37.231366	6824	54	2	1
2014-03-26 20:09:39.363645	29916	49	2	8
2014-03-26 20:09:44.576695	29917	837	3	2
2014-03-25 14:54:00.18308	6829	20.1	1	8
2014-03-25 14:54:00.405098	6830	55	2	8
2014-03-25 14:54:15.771912	6831	20.1	1	1
2014-03-25 14:54:16.005511	6832	54	2	1
2014-03-25 14:54:32.760948	6833	466	3	2
2014-03-26 20:09:44.827489	29918	1087283.7981633327	4	2
2014-03-26 20:09:53.759085	29919	20.8	1	1
2014-03-25 14:54:39.183377	6838	20.1	1	8
2014-03-25 14:54:39.414363	6839	55	2	8
2014-03-25 14:54:54.767899	6840	20.1	1	1
2014-03-25 14:54:54.993153	6841	54	2	1
2014-03-25 14:54:56.761235	6842	418	3	2
2014-03-25 14:55:08.758813	6843	418	3	2
2014-03-26 20:09:53.983634	29920	50	2	1
2014-03-26 20:09:56.575716	29921	595	3	2
2014-03-25 14:55:18.184424	6848	20.1	1	8
2014-03-25 14:55:18.405679	6849	55	2	8
2014-03-25 14:55:32.759264	6850	434	3	2
2014-03-25 14:55:33.766446	6851	20.1	1	1
2014-03-25 14:55:33.989819	6852	54	2	1
2014-03-26 20:09:56.811619	29922	1087286.0962327756	4	2
2014-03-26 20:10:06.669469	29923	22.7	1	10
2014-03-25 14:55:57.18338	6857	20.1	1	8
2014-03-25 14:55:57.417394	6858	55	2	8
2014-03-25 14:56:12.76956	6859	20.1	1	1
2014-03-25 14:56:12.993531	6860	54	2	1
2014-03-25 14:56:32.759809	6861	434	3	2
2014-03-26 20:10:06.897001	29924	40	2	10
2014-03-26 20:10:08.579038	29925	611	3	2
2014-03-25 14:56:36.185391	6866	20.1	1	8
2014-03-25 14:56:36.408554	6867	55	2	8
2014-03-25 14:56:51.764058	6868	20.1	1	1
2014-03-25 14:56:51.997319	6869	54	2	1
2014-03-26 20:10:08.813864	29926	1087288.3943022185	4	2
2014-03-26 20:10:17.054122	29927	21.9	1	9
2014-03-25 14:57:15.183711	6874	20.1	1	8
2014-03-25 14:57:15.414461	6875	55	2	8
2014-03-25 14:57:30.764293	6876	20.1	1	1
2014-03-25 14:57:30.998239	6877	54	2	1
2014-03-25 14:57:32.759792	6878	434	3	2
2014-03-26 20:10:17.277012	29928	48	2	9
2014-03-26 20:10:18.140064	29929	21.6	1	8
2014-03-25 14:57:54.183956	6883	20.1	1	8
2014-03-25 14:57:54.407933	6884	55	2	8
2014-03-25 14:58:09.764579	6885	20.1	1	1
2014-03-25 14:58:09.987745	6886	54	2	1
2014-03-26 20:10:18.371531	29930	49	2	8
2014-03-26 20:10:32.760927	29931	20.8	1	1
2014-03-25 14:58:32.758183	6891	434	3	2
2014-03-25 14:58:33.182437	6892	20.1	1	8
2014-03-25 14:58:33.405283	6893	55	2	8
2014-03-25 14:58:48.766221	6894	20.1	1	1
2014-03-25 14:58:48.989599	6895	54	2	1
2014-03-26 20:10:32.987143	29932	50	2	1
2014-03-26 20:10:44.577023	29933	595	3	2
2014-03-25 14:59:12.183296	6900	20.1	1	8
2014-03-25 14:59:12.405928	6901	55	2	8
2014-03-25 14:59:27.766446	6902	20.1	1	1
2014-03-25 14:59:28.000293	6903	54	2	1
2014-03-25 14:59:32.761022	6904	418	3	2
2014-03-26 20:10:44.810182	29934	1087294.1394758255	4	2
2014-03-26 20:10:45.671143	29935	22.7	1	10
2014-03-25 14:59:51.183839	6909	20.1	1	8
2014-03-25 14:59:51.406264	6910	55	2	8
2014-03-25 15:00:06.767766	6911	20.2	1	1
2014-03-25 15:00:06.995056	6912	54	2	1
2014-03-26 20:10:45.897321	29936	40	2	10
2014-03-26 20:10:56.054437	29937	21.9	1	9
2014-03-25 15:00:30.183391	6917	20.1	1	8
2014-03-25 15:00:30.427164	6918	55	2	8
2014-03-25 15:00:32.759428	6919	418	3	2
2014-03-25 15:00:45.762415	6920	20.2	1	1
2014-03-25 15:00:45.990081	6921	54	2	1
2014-03-26 20:10:56.288724	29938	48	2	9
2014-03-25 15:01:08.890006	6926	450	3	2
2014-03-25 15:01:09.530003	6927	20.1	1	8
2014-03-25 15:01:09.950069	6928	55	2	8
2014-03-25 15:01:20.893023	6929	466	3	2
2014-03-25 15:01:24.764408	6930	20.2	1	1
2014-03-25 15:01:24.989912	6931	54	2	1
2014-03-25 15:01:45.658606	6932	450	3	2
2014-03-25 14:52:40.058553	6808	20.6	1	10
2014-03-25 14:52:40.282879	6809	53	2	10
2014-03-25 14:53:18.856388	6816	20.6	1	10
2014-03-25 14:53:19.080525	6817	53	2	10
2014-03-25 14:53:57.855089	6825	20.6	1	10
2014-03-25 14:53:58.079594	6826	53	2	10
2014-03-25 14:54:36.854318	6834	20.6	1	10
2014-03-25 14:54:37.077389	6835	53	2	10
2014-03-25 14:55:15.856444	6844	20.6	1	10
2014-03-25 14:55:16.078808	6845	53	2	10
2014-03-25 14:55:54.854209	6853	20.6	1	10
2014-03-25 14:55:55.078931	6854	53	2	10
2014-03-25 14:56:33.854773	6862	20.6	1	10
2014-03-25 14:56:34.076277	6863	53	2	10
2014-03-25 14:57:12.854418	6870	20.6	1	10
2014-03-25 14:57:13.078747	6871	53	2	10
2014-03-25 14:57:51.856265	6879	20.6	1	10
2014-03-25 14:57:52.080517	6880	53	2	10
2014-03-25 14:58:30.855828	6887	20.6	1	10
2014-03-25 14:58:31.096944	6888	53	2	10
2014-03-25 14:59:09.855614	6896	20.6	1	10
2014-03-25 14:59:10.080146	6897	53	2	10
2014-03-25 14:59:48.855301	6905	20.6	1	10
2014-03-25 14:59:49.077904	6906	53	2	10
2014-03-25 15:00:27.857922	6913	20.6	1	10
2014-03-25 15:00:28.083256	6914	53	2	10
2014-03-25 15:01:06.857842	6922	20.6	1	10
2014-03-25 15:01:07.082981	6923	53	2	10
2014-03-25 15:01:45.982851	6933	20.6	1	10
2014-03-25 15:01:46.20866	6934	53	2	10
2014-03-25 15:01:48.186303	6937	20.1	1	8
2014-03-25 15:01:48.41088	6938	55	2	8
2014-03-25 15:02:03.759435	6939	20.2	1	1
2014-03-25 15:02:03.993136	6940	54	2	1
2014-03-26 20:10:56.596435	29939	611	3	2
2014-03-26 20:10:56.823239	29940	1087296.4375452683	4	2
2014-03-25 15:02:27.186018	6945	20.1	1	8
2014-03-25 15:02:27.409517	6946	55	2	8
2014-03-25 15:02:32.759923	6947	466	3	2
2014-03-25 15:02:42.763393	6948	20.2	1	1
2014-03-25 15:02:42.989449	6949	54	2	1
2014-03-26 20:10:57.140271	29941	21.6	1	8
2014-03-26 20:10:57.375749	29942	49	2	8
2014-03-25 15:03:06.183028	6954	20.1	1	8
2014-03-25 15:03:06.407166	6955	55	2	8
2014-03-25 15:03:21.758984	6956	20.2	1	1
2014-03-25 15:03:21.983778	6957	54	2	1
2014-03-25 15:03:32.759782	6958	482	3	2
2014-03-26 20:11:11.760136	29943	20.8	1	1
2014-03-26 20:11:11.986513	29944	50	2	1
2014-03-25 15:03:45.184223	6963	20.1	1	8
2014-03-25 15:03:45.433707	6964	55	2	8
2014-03-25 15:04:00.760352	6965	20.2	1	1
2014-03-25 15:04:00.983325	6966	54	2	1
2014-03-26 20:11:24.671127	29945	22.8	1	10
2014-03-26 20:11:24.905007	29946	40	2	10
2014-03-25 15:04:24.184193	6971	20.1	1	8
2014-03-25 15:04:24.416159	6972	55	2	8
2014-03-25 15:04:39.562534	6973	466	3	2
2014-03-25 15:04:39.872694	6974	20.2	1	1
2014-03-25 15:04:40.149085	6975	54	2	1
2014-03-26 20:11:32.577399	29947	579	3	2
2014-03-26 20:11:32.803699	29948	1087302.1827188756	4	2
2014-03-25 15:05:03.184619	6980	20.1	1	8
2014-03-25 15:05:03.405414	6981	55	2	8
2014-03-25 15:05:18.765672	6982	20.2	1	1
2014-03-25 15:05:18.988686	6983	54	2	1
2014-03-25 15:05:32.761529	6984	482	3	2
2014-03-26 20:11:35.05528	29949	21.9	1	9
2014-03-26 20:11:35.288855	29950	48	2	9
2014-03-25 15:05:42.183497	6989	20.1	1	8
2014-03-25 15:05:42.405509	6990	55	2	8
2014-03-25 15:05:57.760762	6991	20.2	1	1
2014-03-25 15:05:58.015043	6992	54	2	1
2014-03-26 20:11:36.142782	29951	21.6	1	8
2014-03-26 20:11:36.367384	29952	49	2	8
2014-03-25 15:06:21.183043	6997	20.1	1	8
2014-03-25 15:06:21.405399	6998	55	2	8
2014-03-25 15:06:32.758635	6999	482	3	2
2014-03-25 15:06:36.759754	7000	20.2	1	1
2014-03-25 15:06:36.984496	7001	54	2	1
2014-03-25 15:06:56.758964	7002	450	3	2
2014-03-26 20:11:44.574631	29953	595	3	2
2014-03-26 20:11:44.809654	29954	1087304.4807883182	4	2
2014-03-25 15:07:00.18392	7007	20.1	1	8
2014-03-25 15:07:00.416091	7008	55	2	8
2014-03-25 15:07:08.758912	7009	450	3	2
2014-03-25 15:07:15.759471	7010	20.2	1	1
2014-03-25 15:07:15.982926	7011	54	2	1
2014-03-25 15:07:32.7542	7012	434	3	2
2014-03-26 20:11:50.762601	29955	20.8	1	1
2014-03-26 20:11:50.987918	29956	50	2	1
2014-03-25 15:07:39.185268	7017	20.1	1	8
2014-03-25 15:07:39.416371	7018	55	2	8
2014-03-25 15:07:54.759701	7019	20.2	1	1
2014-03-25 15:07:54.98473	7020	54	2	1
2014-03-26 20:11:56.573312	29957	547	3	2
2014-03-26 20:11:56.812105	29958	1087305.6298230398	4	2
2014-03-25 15:08:18.182794	7025	20.1	1	8
2014-03-25 15:08:18.416101	7026	55	2	8
2014-03-25 15:08:32.758884	7027	450	3	2
2014-03-25 15:08:33.753195	7028	20.2	1	1
2014-03-25 15:08:33.975578	7029	54	2	1
2014-03-26 20:12:03.670841	29959	22.8	1	10
2014-03-26 20:12:03.89471	29960	40	2	10
2014-03-25 15:08:57.183154	7034	20.1	1	8
2014-03-25 15:08:57.409002	7035	55	2	8
2014-03-25 15:09:12.758104	7036	20.2	1	1
2014-03-25 15:09:12.991592	7037	54	2	1
2014-03-25 15:09:32.759576	7038	434	3	2
2014-03-26 20:12:08.581797	29961	595	3	2
2014-03-26 20:12:08.816849	29962	1087307.9278924826	4	2
2014-03-25 15:09:36.182292	7043	20.1	1	8
2014-03-25 15:09:36.404098	7044	55	2	8
2014-03-25 15:09:51.755556	7045	20.2	1	1
2014-03-25 15:09:51.978718	7046	54	2	1
2014-03-26 20:12:14.054214	29963	21.9	1	9
2014-03-26 20:12:14.337087	29964	48	2	9
2014-03-25 15:10:15.184076	7051	20.1	1	8
2014-03-25 15:10:15.406291	7052	55	2	8
2014-03-25 15:10:30.759269	7053	20.2	1	1
2014-03-25 15:10:30.982662	7054	54	2	1
2014-03-25 15:10:32.760623	7055	450	3	2
2014-03-26 20:12:15.141333	29965	21.6	1	8
2014-03-26 20:12:15.386433	29966	49	2	8
2014-03-25 15:10:54.18493	7060	20.1	1	8
2014-03-25 15:10:54.407292	7061	55	2	8
2014-03-25 15:11:09.758771	7062	20.2	1	1
2014-03-25 15:11:09.992294	7063	54	2	1
2014-03-26 20:12:20.575575	29967	579	3	2
2014-03-25 15:11:32.757643	7068	450	3	2
2014-03-25 15:11:33.40119	7069	20.1	1	8
2014-03-25 15:11:33.622931	7070	55	2	8
2014-03-25 15:11:48.75409	7071	20.2	1	1
2014-03-25 15:11:48.978753	7072	54	2	1
2014-03-25 15:02:24.856276	6941	20.6	1	10
2014-03-25 15:02:25.079701	6942	53	2	10
2014-03-25 15:03:03.855905	6950	20.6	1	10
2014-03-25 15:03:04.07967	6951	53	2	10
2014-03-25 15:03:42.858559	6959	20.6	1	10
2014-03-25 15:03:43.090668	6960	53	2	10
2014-03-25 15:04:21.858777	6967	20.6	1	10
2014-03-25 15:04:22.092694	6968	53	2	10
2014-03-25 15:05:00.859605	6976	20.6	1	10
2014-03-25 15:05:01.083197	6977	53	2	10
2014-03-25 15:05:39.861913	6985	20.6	1	10
2014-03-25 15:05:40.123943	6986	53	2	10
2014-03-25 15:06:18.859619	6993	20.6	1	10
2014-03-25 15:06:19.084614	6994	53	2	10
2014-03-25 15:06:57.859655	7003	20.6	1	10
2014-03-25 15:06:58.100845	7004	53	2	10
2014-03-25 15:07:36.859514	7013	20.6	1	10
2014-03-25 15:07:37.081483	7014	53	2	10
2014-03-25 15:08:15.859768	7021	20.6	1	10
2014-03-25 15:08:16.097136	7022	53	2	10
2014-03-25 15:08:54.859731	7030	20.6	1	10
2014-03-25 15:08:55.084115	7031	53	2	10
2014-03-25 15:09:33.859756	7039	20.6	1	10
2014-03-25 15:09:34.082369	7040	53	2	10
2014-03-25 15:10:12.859982	7047	20.6	1	10
2014-03-25 15:10:13.08505	7048	53	2	10
2014-03-25 15:10:51.861739	7056	20.6	1	10
2014-03-25 15:10:52.085295	7057	53	2	10
2014-03-26 20:12:20.800505	29968	1087310.2259619255	4	2
2014-03-26 20:12:29.760901	29969	20.8	1	1
2014-03-25 15:12:12.183988	7077	20.1	1	8
2014-03-25 15:12:12.417008	7078	55	2	8
2014-03-25 15:12:27.753414	7079	20.2	1	1
2014-03-25 15:12:27.996368	7080	54	2	1
2014-03-25 15:12:48.659513	7081	434	3	2
2014-03-26 20:12:30.180157	29970	50	2	1
2014-03-26 20:12:32.579591	29971	531	3	2
2014-03-25 15:12:51.187134	7086	20.1	1	8
2014-03-25 15:12:51.411142	7087	55	2	8
2014-03-25 15:13:06.750616	7088	20.2	1	1
2014-03-25 15:13:06.983119	7089	54	2	1
2014-03-25 15:13:08.758657	7090	482	3	2
2014-03-25 15:13:27.65962	7091	466	3	2
2014-03-26 20:12:32.809897	29972	1087311.3749966468	4	2
2014-03-26 20:12:42.669959	29973	22.8	1	10
2014-03-25 15:13:30.185264	7096	20.1	1	8
2014-03-25 15:13:30.418745	7097	55	2	8
2014-03-25 15:13:32.757014	7098	482	3	2
2014-03-25 15:13:45.758464	7099	20.2	1	1
2014-03-25 15:13:45.99022	7100	54	2	1
2014-03-26 20:12:42.897027	29974	41	2	10
2014-03-26 20:12:44.577084	29975	515	3	2
2014-03-25 15:14:09.184964	7105	20.1	1	8
2014-03-25 15:14:09.410251	7106	55	2	8
2014-03-25 15:14:24.75325	7107	20.2	1	1
2014-03-25 15:14:24.986269	7108	54	2	1
2014-03-25 15:14:32.759345	7109	466	3	2
2014-03-26 20:12:44.810213	29976	1087313.6730660896	4	2
2014-03-26 20:12:53.053824	29977	21.9	1	9
2014-03-25 15:14:48.184384	7114	20.1	1	8
2014-03-25 15:14:48.411105	7115	55	2	8
2014-03-25 15:15:03.752798	7116	20.2	1	1
2014-03-25 15:15:03.976092	7117	54	2	1
2014-03-26 20:12:53.278324	29978	48	2	9
2014-03-26 20:12:54.137983	29979	21.6	1	8
2014-03-25 15:15:27.1842	7122	20.1	1	8
2014-03-25 15:15:27.415203	7123	55	2	8
2014-03-25 15:15:32.75801	7124	466	3	2
2014-03-25 15:15:42.755642	7125	20.2	1	1
2014-03-25 15:15:42.979404	7126	54	2	1
2014-03-26 20:12:54.373608	29980	49	2	8
2014-03-26 20:13:08.758624	29981	20.8	1	1
2014-03-25 15:16:06.1848	7131	20.1	1	8
2014-03-25 15:16:06.406904	7132	55	2	8
2014-03-25 15:16:21.749966	7133	20.2	1	1
2014-03-25 15:16:21.983999	7134	54	2	1
2014-03-25 15:16:32.760254	7135	466	3	2
2014-03-26 20:13:09.00261	29982	50	2	1
2014-03-26 20:13:21.673954	29983	22.9	1	10
2014-03-25 15:16:45.184713	7140	20.1	1	8
2014-03-25 15:16:45.405443	7141	55	2	8
2014-03-25 15:17:00.75214	7142	20.2	1	1
2014-03-25 15:17:00.975991	7143	54	2	1
2014-03-26 20:13:21.908178	29984	41	2	10
2014-03-26 20:13:32.05501	29985	21.9	1	9
2014-03-25 15:17:24.185603	7148	20.1	1	8
2014-03-25 15:17:24.602025	7149	55	2	8
2014-03-25 15:17:32.75785	7150	466	3	2
2014-03-25 15:17:39.747748	7151	20.3	1	1
2014-03-25 15:17:39.971523	7152	54	2	1
2014-03-26 20:13:32.280527	29986	48	2	9
2014-03-26 20:13:32.590026	29987	531	3	2
2014-03-25 15:18:03.185986	7157	20.1	1	8
2014-03-25 15:18:03.416512	7158	55	2	8
2014-03-25 15:18:18.753698	7159	20.3	1	1
2014-03-25 15:18:18.979126	7160	54	2	1
2014-03-25 15:18:32.758425	7161	466	3	2
2014-03-26 20:13:32.822909	29988	1087320.5672744182	4	2
2014-03-26 20:13:33.139481	29989	21.6	1	8
2014-03-25 15:18:42.1836	7166	20.1	1	8
2014-03-25 15:18:42.407635	7167	55	2	8
2014-03-25 15:18:57.747253	7168	20.3	1	1
2014-03-25 15:18:57.983462	7169	54	2	1
2014-03-25 15:19:08.758746	7170	418	3	2
2014-03-26 20:13:33.367983	29990	49	2	8
2014-03-26 20:13:47.760756	29991	20.8	1	1
2014-03-25 15:19:20.759629	7175	418	3	2
2014-03-25 15:19:21.182554	7176	20.1	1	8
2014-03-25 15:19:21.407332	7177	55	2	8
2014-03-25 15:19:32.759855	7178	434	3	2
2014-03-25 15:19:36.749037	7179	20.3	1	1
2014-03-25 15:19:36.972403	7180	54	2	1
2014-03-26 20:13:47.994427	29992	50	2	1
2014-03-26 20:14:00.670369	29993	22.9	1	10
2014-03-25 15:20:00.184519	7185	20.1	1	8
2014-03-25 15:20:00.416297	7186	54	2	8
2014-03-25 15:20:15.754374	7187	20.3	1	1
2014-03-25 15:20:15.98494	7188	54	2	1
2014-03-25 15:20:32.755644	7189	434	3	2
2014-03-26 20:14:00.895388	29994	41	2	10
2014-03-26 20:14:11.055193	29995	21.9	1	9
2014-03-25 15:20:39.183731	7194	20.1	1	8
2014-03-25 15:20:39.404491	7195	54	2	8
2014-03-25 15:20:54.754852	7196	20.3	1	1
2014-03-25 15:20:54.986578	7197	54	2	1
2014-03-26 20:14:11.288778	29996	48	2	9
2014-03-26 20:14:12.138746	29997	21.6	1	8
2014-03-26 20:14:12.36157	29998	49	2	8
2014-03-25 15:21:18.187494	7202	20.1	1	8
2014-03-25 15:21:18.408293	7203	54	2	8
2014-03-25 15:21:32.761207	7204	418	3	2
2014-03-25 15:21:33.753371	7205	20.3	1	1
2014-03-25 15:21:33.975311	7206	54	2	1
2014-03-25 15:12:09.860088	7073	20.6	1	10
2014-03-25 15:12:10.09599	7074	53	2	10
2014-03-25 15:12:48.981546	7082	20.6	1	10
2014-03-25 15:12:49.204646	7083	53	2	10
2014-03-25 15:13:27.975553	7092	20.6	1	10
2014-03-25 15:13:28.208013	7093	53	2	10
2014-03-25 15:14:06.861753	7101	20.6	1	10
2014-03-25 15:14:07.084159	7102	53	2	10
2014-03-25 15:14:45.862559	7110	20.6	1	10
2014-03-25 15:14:46.089459	7111	53	2	10
2014-03-25 15:15:24.86181	7118	20.6	1	10
2014-03-25 15:15:25.094133	7119	53	2	10
2014-03-25 15:16:03.862584	7127	20.6	1	10
2014-03-25 15:16:04.085731	7128	53	2	10
2014-03-25 15:16:42.864289	7136	20.6	1	10
2014-03-25 15:16:43.086519	7137	53	2	10
2014-03-25 15:17:21.863026	7144	20.6	1	10
2014-03-25 15:17:22.110323	7145	53	2	10
2014-03-25 15:18:00.861093	7153	20.6	1	10
2014-03-25 15:18:01.094594	7154	53	2	10
2014-03-25 15:18:39.862508	7162	20.6	1	10
2014-03-25 15:18:40.086088	7163	53	2	10
2014-03-25 15:19:18.863721	7171	20.6	1	10
2014-03-25 15:19:19.096228	7172	53	2	10
2014-03-25 15:19:57.863724	7181	20.6	1	10
2014-03-25 15:19:58.085888	7182	53	2	10
2014-03-25 15:20:36.862379	7190	20.6	1	10
2014-03-25 15:20:37.083198	7191	53	2	10
2014-03-26 20:14:26.761147	29999	20.8	1	1
2014-03-26 20:14:26.995225	30000	50	2	1
2014-03-25 15:21:57.185358	7211	20.1	1	8
2014-03-25 15:21:57.416579	7212	54	2	8
2014-03-25 15:22:12.750524	7213	20.3	1	1
2014-03-25 15:22:12.978088	7214	54	2	1
2014-03-25 15:22:20.758252	7215	450	3	2
2014-03-25 15:22:32.757073	7216	434	3	2
2014-03-26 20:14:32.574399	30001	547	3	2
2014-03-26 20:14:32.804898	30002	1087329.7595521894	4	2
2014-03-25 15:22:36.183709	7221	20.1	1	8
2014-03-25 15:22:36.406569	7222	54	2	8
2014-03-25 15:22:51.752064	7223	20.3	1	1
2014-03-25 15:22:51.990937	7224	54	2	1
2014-03-26 20:14:39.679026	30003	22.9	1	10
2014-03-26 20:14:39.913591	30004	41	2	10
2014-03-25 15:23:15.185363	7229	20.1	1	8
2014-03-25 15:23:15.408193	7230	54	2	8
2014-03-25 15:23:30.752501	7231	20.3	1	1
2014-03-25 15:23:30.985888	7232	54	2	1
2014-03-25 15:23:32.755032	7233	418	3	2
2014-03-26 20:14:50.054381	30005	21.9	1	9
2014-03-26 20:14:50.279609	30006	48	2	9
2014-03-25 15:23:54.185704	7238	20.1	1	8
2014-03-25 15:23:54.417706	7239	54	2	8
2014-03-25 15:24:09.744911	7240	20.3	1	1
2014-03-25 15:24:09.968152	7241	54	2	1
2014-03-26 20:14:51.140159	30007	21.6	1	8
2014-03-26 20:14:51.375539	30008	49	2	8
2014-03-25 15:24:32.761351	7246	434	3	2
2014-03-25 15:24:33.186497	7247	20.1	1	8
2014-03-25 15:24:33.410376	7248	54	2	8
2014-03-25 15:24:48.746937	7249	20.3	1	1
2014-03-25 15:24:48.97957	7250	54	2	1
2014-03-26 20:15:05.760438	30009	20.7	1	1
2014-03-26 20:15:05.985254	30010	50	2	1
2014-03-25 15:25:12.184394	7255	20.1	1	8
2014-03-25 15:25:12.407369	7256	54	2	8
2014-03-25 15:25:20.759587	7257	466	3	2
2014-03-25 15:25:27.98339	7258	20.3	1	1
2014-03-25 15:25:28.206222	7259	54	2	1
2014-03-25 15:25:32.756571	7260	466	3	2
2014-03-26 20:15:18.674627	30011	22.9	1	10
2014-03-26 20:15:18.909987	30012	41	2	10
2014-03-25 15:25:51.184555	7265	20.1	1	8
2014-03-25 15:25:51.406606	7266	54	2	8
2014-03-25 15:26:06.751205	7267	20.3	1	1
2014-03-25 15:26:06.974069	7268	54	2	1
2014-03-26 20:15:20.574661	30013	498	3	2
2014-03-26 20:15:20.799882	30014	1087336.653760518	4	2
2014-03-25 15:26:30.184361	7273	20.1	1	8
2014-03-25 15:26:30.407849	7274	54	2	8
2014-03-25 15:26:32.760721	7275	466	3	2
2014-03-25 15:26:45.750323	7276	20.3	1	1
2014-03-25 15:26:45.980455	7277	54	2	1
2014-03-26 20:15:29.053231	30015	21.8	1	9
2014-03-26 20:15:29.296314	30016	48	2	9
2014-03-25 15:27:09.183354	7282	20.1	1	8
2014-03-25 15:27:09.415216	7283	54	2	8
2014-03-25 15:27:24.746234	7284	20.3	1	1
2014-03-25 15:27:24.97048	7285	54	2	1
2014-03-25 15:27:32.756439	7286	482	3	2
2014-03-26 20:15:30.138631	30017	21.7	1	8
2014-03-26 20:15:30.364921	30018	49	2	8
2014-03-25 15:27:48.18483	7291	20.1	1	8
2014-03-25 15:27:48.406995	7292	54	2	8
2014-03-25 15:28:03.749316	7293	20.3	1	1
2014-03-25 15:28:03.984888	7294	54	2	1
2014-03-26 20:15:32.579346	30019	498	3	2
2014-03-26 20:15:32.814148	30020	1087337.8027952393	4	2
2014-03-25 15:28:27.183154	7299	20.1	1	8
2014-03-25 15:28:27.406775	7300	54	2	8
2014-03-25 15:28:32.758041	7301	466	3	2
2014-03-25 15:28:42.747312	7302	20.3	1	1
2014-03-25 15:28:42.969356	7303	54	2	1
2014-03-26 20:15:44.760117	30021	20.7	1	1
2014-03-26 20:15:44.987411	30022	50	2	1
2014-03-25 15:29:06.185273	7308	20.1	1	8
2014-03-25 15:29:06.41763	7309	54	2	8
2014-03-25 15:29:21.74388	7310	20.3	1	1
2014-03-25 15:29:21.967867	7311	54	2	1
2014-03-25 15:29:32.756222	7312	466	3	2
2014-03-26 20:15:56.577513	30023	547	3	2
2014-03-26 20:15:56.812482	30024	1087342.398934125	4	2
2014-03-25 15:29:45.184502	7317	20.1	1	8
2014-03-25 15:29:45.408767	7318	54	2	8
2014-03-25 15:30:00.746334	7319	20.3	1	1
2014-03-25 15:30:00.98034	7320	54	2	1
2014-03-26 20:15:57.675003	30025	23.0	1	10
2014-03-26 20:15:57.901235	30026	40	2	10
2014-03-25 15:30:24.184053	7325	20.1	1	8
2014-03-25 15:30:24.407954	7326	54	2	8
2014-03-25 15:30:32.754602	7327	466	3	2
2014-03-25 15:30:39.746071	7328	20.3	1	1
2014-03-25 15:30:39.9701	7329	54	2	1
2014-03-26 20:16:08.052754	30027	21.8	1	9
2014-03-25 15:31:03.184058	7334	20.1	1	8
2014-03-25 15:31:03.416076	7335	54	2	8
2014-03-25 15:31:18.552984	7336	434	3	2
2014-03-25 15:31:18.863949	7337	20.3	1	1
2014-03-25 15:31:19.087086	7338	54	2	1
2014-03-25 15:31:20.758103	7339	434	3	2
2014-03-25 15:31:32.75871	7340	434	3	2
2014-03-25 15:22:33.863207	7217	20.6	1	10
2014-03-25 15:22:34.100217	7218	53	2	10
2014-03-25 15:23:12.864178	7225	20.6	1	10
2014-03-25 15:23:13.091736	7226	53	2	10
2014-03-25 15:23:51.863323	7234	20.6	1	10
2014-03-25 15:23:52.086641	7235	53	2	10
2014-03-25 15:24:30.865637	7242	20.5	1	10
2014-03-25 15:24:31.098911	7243	53	2	10
2014-03-25 15:25:09.865243	7251	20.5	1	10
2014-03-25 15:25:10.089912	7252	53	2	10
2014-03-25 15:25:48.865512	7261	20.5	1	10
2014-03-25 15:25:49.089	7262	53	2	10
2014-03-25 15:26:27.864267	7269	20.5	1	10
2014-03-25 15:26:28.090562	7270	53	2	10
2014-03-25 15:27:06.868045	7278	20.5	1	10
2014-03-25 15:27:07.113147	7279	53	2	10
2014-03-25 15:27:45.865347	7287	20.5	1	10
2014-03-25 15:27:46.097938	7288	53	2	10
2014-03-25 15:28:24.866561	7295	20.5	1	10
2014-03-25 15:28:25.092333	7296	53	2	10
2014-03-25 15:29:03.866244	7304	20.5	1	10
2014-03-25 15:29:04.091768	7305	53	2	10
2014-03-25 15:29:42.867469	7313	20.5	1	10
2014-03-25 15:29:43.091118	7314	53	2	10
2014-03-25 15:30:21.867953	7321	20.5	1	10
2014-03-25 15:30:22.090965	7322	53	2	10
2014-03-25 15:31:00.867485	7330	20.5	1	10
2014-03-25 15:31:01.098661	7331	53	2	10
2014-03-25 15:31:39.867388	7341	20.5	1	10
2014-03-25 15:31:40.107719	7342	53	2	10
2014-03-25 15:31:42.183556	7345	20.1	1	8
2014-03-25 15:31:42.416312	7346	54	2	8
2014-03-25 15:31:57.74551	7347	20.3	1	1
2014-03-25 15:31:57.969453	7348	53	2	1
2014-03-26 20:16:08.286784	30028	48	2	9
2014-03-26 20:16:09.142287	30029	21.7	1	8
2014-03-25 15:32:20.760267	7353	482	3	2
2014-03-25 15:32:21.183358	7354	20.1	1	8
2014-03-25 15:32:21.406892	7355	54	2	8
2014-03-25 15:32:32.756732	7356	482	3	2
2014-03-25 15:32:36.749105	7357	20.3	1	1
2014-03-25 15:32:36.976734	7358	53	2	1
2014-03-26 20:16:09.367664	30030	49	2	8
2014-03-26 20:16:20.57713	30031	515	3	2
2014-03-25 15:33:00.183239	7363	20.1	1	8
2014-03-25 15:33:00.415537	7364	54	2	8
2014-03-25 15:33:15.746939	7365	20.3	1	1
2014-03-25 15:33:15.980951	7366	53	2	1
2014-03-25 15:33:32.756825	7367	498	3	2
2014-03-26 20:16:20.811523	30032	1087345.8460382891	4	2
2014-03-26 20:16:23.754775	30033	20.7	1	1
2014-03-25 15:33:39.182657	7372	20.1	1	8
2014-03-25 15:33:39.404573	7373	54	2	8
2014-03-25 15:33:54.744466	7374	20.3	1	1
2014-03-25 15:33:54.96887	7375	53	2	1
2014-03-26 20:16:23.980653	30034	50	2	1
2014-03-26 20:16:32.576158	30035	531	3	2
2014-03-25 15:34:18.184414	7380	20.1	1	8
2014-03-25 15:34:18.40623	7381	54	2	8
2014-03-25 15:34:32.753521	7382	482	3	2
2014-03-25 15:34:33.741636	7383	20.3	1	1
2014-03-25 15:34:33.964326	7384	53	2	1
2014-03-26 20:16:32.810351	30036	1087346.9950730107	4	2
2014-03-26 20:16:36.676534	30037	23.0	1	10
2014-03-25 15:34:57.18327	7389	20.1	1	8
2014-03-25 15:34:57.416582	7390	54	2	8
2014-03-25 15:35:12.742419	7391	20.3	1	1
2014-03-25 15:35:12.965571	7392	53	2	1
2014-03-25 15:35:32.754166	7393	498	3	2
2014-03-26 20:16:36.901651	30038	40	2	10
2014-03-26 20:16:47.054579	30039	21.8	1	9
2014-03-25 15:35:36.185013	7398	20.1	1	8
2014-03-25 15:35:36.410395	7399	54	2	8
2014-03-25 15:35:51.739651	7400	20.3	1	1
2014-03-25 15:35:51.973704	7401	53	2	1
2014-03-26 20:16:47.288164	30040	48	2	9
2014-03-26 20:16:48.139438	30041	21.7	1	8
2014-03-25 15:36:15.183205	7406	20.1	1	8
2014-03-25 15:36:15.40578	7407	54	2	8
2014-03-25 15:36:30.73937	7408	20.3	1	1
2014-03-25 15:36:30.973412	7409	53	2	1
2014-03-25 15:36:32.756593	7410	498	3	2
2014-03-26 20:16:48.363602	30042	49	2	8
2014-03-26 20:17:02.758779	30043	20.7	1	1
2014-03-25 15:36:54.18407	7415	20.1	1	8
2014-03-25 15:36:54.404917	7416	54	2	8
2014-03-25 15:37:09.74428	7417	20.3	1	1
2014-03-25 15:37:09.968575	7418	53	2	1
2014-03-25 15:37:20.758088	7419	547	3	2
2014-03-26 20:17:02.993295	30044	50	2	1
2014-03-26 20:17:15.675688	30045	23.0	1	10
2014-03-25 15:37:32.757315	7424	531	3	2
2014-03-25 15:37:33.183649	7425	20.1	1	8
2014-03-25 15:37:33.404734	7426	54	2	8
2014-03-25 15:37:48.742763	7427	20.3	1	1
2014-03-25 15:37:48.970452	7428	53	2	1
2014-03-26 20:17:15.901573	30046	40	2	10
2014-03-26 20:17:26.052036	30047	21.8	1	9
2014-03-25 15:38:12.18417	7433	20.1	1	8
2014-03-25 15:38:12.415443	7434	54	2	8
2014-03-25 15:38:27.741799	7435	20.3	1	1
2014-03-25 15:38:27.966893	7436	53	2	1
2014-03-25 15:38:32.75829	7437	547	3	2
2014-03-26 20:17:26.288692	30048	48	2	9
2014-03-26 20:17:27.142174	30049	21.7	1	8
2014-03-25 15:38:51.183253	7442	20.1	1	8
2014-03-25 15:38:51.406986	7443	54	2	8
2014-03-25 15:39:06.740731	7444	20.3	1	1
2014-03-25 15:39:06.971896	7445	53	2	1
2014-03-26 20:17:27.365631	30050	49	2	8
2014-03-26 20:17:32.574979	30051	531	3	2
2014-03-25 15:39:30.185067	7450	20.1	1	8
2014-03-25 15:39:30.408062	7451	54	2	8
2014-03-25 15:39:32.75894	7452	547	3	2
2014-03-25 15:39:45.741151	7453	20.3	1	1
2014-03-25 15:39:45.966789	7454	53	2	1
2014-03-25 15:39:56.75456	7455	579	3	2
2014-03-26 20:17:32.810727	30052	1087355.0427870129	4	2
2014-03-26 20:17:41.75707	30053	20.7	1	1
2014-03-25 15:40:08.758577	7460	547	3	2
2014-03-25 15:40:09.181744	7461	20.1	1	8
2014-03-25 15:40:09.444173	7462	54	2	8
2014-03-25 15:40:20.756224	7463	579	3	2
2014-03-25 15:40:24.741198	7464	20.3	1	1
2014-03-25 15:40:24.964314	7465	53	2	1
2014-03-25 15:40:32.760561	7466	547	3	2
2014-03-25 15:40:44.756748	7467	531	3	2
2014-03-26 20:17:41.983394	30054	50	2	1
2014-03-26 20:17:54.679396	30055	23.1	1	10
2014-03-25 15:40:48.184136	7472	20.1	1	8
2014-03-25 15:40:48.417729	7473	54	2	8
2014-03-25 15:41:03.739118	7474	20.3	1	1
2014-03-25 15:41:03.963353	7475	53	2	1
2014-03-26 20:17:54.913696	30056	40	2	10
2014-03-25 15:41:27.183837	7480	20.1	1	8
2014-03-25 15:32:18.869661	7349	20.5	1	10
2014-03-25 15:32:19.101737	7350	53	2	10
2014-03-25 15:32:57.870149	7359	20.5	1	10
2014-03-25 15:32:58.104159	7360	53	2	10
2014-03-25 15:33:36.867394	7368	20.5	1	10
2014-03-25 15:33:37.092609	7369	53	2	10
2014-03-25 15:34:15.86717	7376	20.5	1	10
2014-03-25 15:34:16.090749	7377	53	2	10
2014-03-25 15:34:54.867783	7385	20.5	1	10
2014-03-25 15:34:55.10011	7386	53	2	10
2014-03-25 15:35:33.868698	7394	20.5	1	10
2014-03-25 15:35:34.090836	7395	53	2	10
2014-03-25 15:36:12.869137	7402	20.5	1	10
2014-03-25 15:36:13.091261	7403	53	2	10
2014-03-25 15:36:51.870733	7411	20.5	1	10
2014-03-25 15:36:52.093667	7412	53	2	10
2014-03-25 15:37:30.871534	7420	20.5	1	10
2014-03-25 15:37:31.095737	7421	53	2	10
2014-03-25 15:38:09.873938	7429	20.5	1	10
2014-03-25 15:38:10.096814	7430	53	2	10
2014-03-25 15:38:48.871427	7438	20.5	1	10
2014-03-25 15:38:49.099144	7439	53	2	10
2014-03-25 15:39:27.871428	7446	20.5	1	10
2014-03-25 15:39:28.097421	7447	53	2	10
2014-03-25 15:40:06.89125	7456	20.5	1	10
2014-03-25 15:40:07.147804	7457	53	2	10
2014-03-25 15:40:45.870912	7468	20.5	1	10
2014-03-25 15:40:46.103037	7469	53	2	10
2014-03-25 15:41:27.415095	7481	54	2	8
2014-03-25 15:41:32.756689	7482	547	3	2
2014-03-25 15:41:42.734659	7483	20.3	1	1
2014-03-25 15:41:42.958553	7484	53	2	1
2014-03-26 20:17:56.577575	30057	498	3	2
2014-03-26 20:17:56.803841	30058	1087358.489891177	4	2
2014-03-25 15:42:06.184029	7489	20.1	1	8
2014-03-25 15:42:06.412861	7490	54	2	8
2014-03-25 15:42:21.74282	7491	20.3	1	1
2014-03-25 15:42:21.965418	7492	53	2	1
2014-03-25 15:42:32.757877	7493	547	3	2
2014-03-26 20:18:05.053133	30059	21.8	1	9
2014-03-26 20:18:05.288797	30060	48	2	9
2014-03-25 15:42:44.762094	7498	498	3	2
2014-03-25 15:42:45.182276	7499	20.1	1	8
2014-03-25 15:42:45.404698	7500	54	2	8
2014-03-25 15:42:56.757966	7501	498	3	2
2014-03-25 15:43:00.74048	7502	20.3	1	1
2014-03-25 15:43:00.963194	7503	53	2	1
2014-03-26 20:18:06.140206	30061	21.7	1	8
2014-03-26 20:18:06.366606	30062	49	2	8
2014-03-25 15:43:24.182992	7508	20.1	1	8
2014-03-25 15:43:24.406253	7509	54	2	8
2014-03-25 15:43:32.756758	7510	498	3	2
2014-03-25 15:43:39.739954	7511	20.3	1	1
2014-03-25 15:43:39.966163	7512	53	2	1
2014-03-26 20:18:08.575129	30063	531	3	2
2014-03-26 20:18:08.823373	30064	1087359.6389258984	4	2
2014-03-25 15:44:03.183955	7517	20.0	1	8
2014-03-25 15:44:03.418727	7518	54	2	8
2014-03-25 15:44:18.73697	7519	20.3	1	1
2014-03-25 15:44:18.960877	7520	53	2	1
2014-03-25 15:44:32.759113	7521	498	3	2
2014-03-26 20:18:20.758164	30065	20.7	1	1
2014-03-26 20:18:20.981892	30066	50	2	1
2014-03-25 15:44:42.18607	7526	20.0	1	8
2014-03-25 15:44:42.410421	7527	54	2	8
2014-03-25 15:44:57.738503	7528	20.3	1	1
2014-03-25 15:44:57.971462	7529	53	2	1
2014-03-26 20:18:32.576247	30067	531	3	2
2014-03-26 20:18:32.810405	30068	1087364.235064784	4	2
2014-03-25 15:45:21.186087	7534	20.0	1	8
2014-03-25 15:45:21.408919	7535	54	2	8
2014-03-25 15:45:32.757846	7536	515	3	2
2014-03-25 15:45:36.737524	7537	20.3	1	1
2014-03-25 15:45:36.960256	7538	53	2	1
2014-03-26 20:18:33.675592	30069	23.1	1	10
2014-03-26 20:18:33.906782	30070	40	2	10
2014-03-25 15:46:00.18282	7543	20.0	1	8
2014-03-25 15:46:00.426762	7544	54	2	8
2014-03-25 15:46:15.737337	7545	20.3	1	1
2014-03-25 15:46:15.960178	7546	53	2	1
2014-03-25 15:46:32.754022	7547	515	3	2
2014-03-26 20:18:44.052622	30071	21.8	1	9
2014-03-26 20:18:44.285098	30072	48	2	9
2014-03-25 15:46:39.182677	7552	20.0	1	8
2014-03-25 15:46:39.405425	7553	54	2	8
2014-03-25 15:46:54.540156	7554	450	3	2
2014-03-25 15:46:54.855755	7555	20.3	1	1
2014-03-25 15:46:55.077648	7556	53	2	1
2014-03-25 15:46:56.755645	7557	450	3	2
2014-03-26 20:18:44.59532	30073	482	3	2
2014-03-26 20:18:44.818582	30074	1087365.3840995056	4	2
2014-03-25 15:47:18.182604	7562	20.0	1	8
2014-03-25 15:47:18.404992	7563	54	2	8
2014-03-25 15:47:32.756831	7564	450	3	2
2014-03-25 15:47:33.737982	7565	20.3	1	1
2014-03-25 15:47:33.960583	7566	53	2	1
2014-03-26 20:18:45.139667	30075	21.7	1	8
2014-03-26 20:18:45.374803	30076	49	2	8
2014-03-25 15:47:57.183532	7571	20.0	1	8
2014-03-25 15:47:57.406035	7572	54	2	8
2014-03-25 15:48:12.736236	7573	20.3	1	1
2014-03-25 15:48:12.959096	7574	53	2	1
2014-03-25 15:48:32.75633	7575	450	3	2
2014-03-26 20:18:56.575663	30077	531	3	2
2014-03-26 20:18:56.799187	30078	1087367.6821689485	4	2
2014-03-25 15:48:36.183769	7580	20.0	1	8
2014-03-25 15:48:36.406556	7581	54	2	8
2014-03-25 15:48:44.752109	7582	482	3	2
2014-03-25 15:48:51.735582	7583	20.3	1	1
2014-03-25 15:48:51.96121	7584	53	2	1
2014-03-25 15:48:56.752159	7585	482	3	2
2014-03-26 20:18:59.759311	30079	20.7	1	1
2014-03-26 20:18:59.990996	30080	50	2	1
2014-03-25 15:49:15.182602	7590	20.0	1	8
2014-03-25 15:49:15.439228	7591	54	2	8
2014-03-25 15:49:30.735871	7592	20.3	1	1
2014-03-25 15:49:31.005268	7593	53	2	1
2014-03-25 15:49:32.753232	7594	482	3	2
2014-03-26 20:19:08.578204	30081	531	3	2
2014-03-26 20:19:08.804696	30082	1087368.8312036698	4	2
2014-03-25 15:49:54.183462	7599	20.0	1	8
2014-03-25 15:49:54.414285	7600	54	2	8
2014-03-25 15:50:09.735043	7601	20.3	1	1
2014-03-25 15:50:09.959015	7602	53	2	1
2014-03-26 20:19:12.675433	30083	23.1	1	10
2014-03-26 20:19:12.909682	30084	40	2	10
2014-03-25 15:50:32.758154	7607	515	3	2
2014-03-25 15:50:33.184491	7608	20.0	1	8
2014-03-25 15:50:33.407274	7609	54	2	8
2014-03-25 15:50:44.755825	7610	498	3	2
2014-03-25 15:50:48.736457	7611	20.3	1	1
2014-03-25 15:50:48.969321	7612	53	2	1
2014-03-26 20:19:23.05157	30085	21.8	1	9
2014-03-25 15:42:03.87073	7485	20.5	1	10
2014-03-25 15:42:04.092578	7486	53	2	10
2014-03-25 15:42:42.87089	7494	20.5	1	10
2014-03-25 15:42:43.095361	7495	53	2	10
2014-03-25 15:43:21.873018	7504	20.5	1	10
2014-03-25 15:43:22.098896	7505	53	2	10
2014-03-25 15:44:00.870759	7513	20.5	1	10
2014-03-25 15:44:01.103259	7514	53	2	10
2014-03-25 15:44:39.8717	7522	20.5	1	10
2014-03-25 15:44:40.095784	7523	53	2	10
2014-03-25 15:45:18.872907	7530	20.5	1	10
2014-03-25 15:45:19.095888	7531	53	2	10
2014-03-25 15:45:57.872333	7539	20.5	1	10
2014-03-25 15:45:58.09418	7540	53	2	10
2014-03-25 15:46:36.880206	7548	20.5	1	10
2014-03-25 15:46:37.102141	7549	53	2	10
2014-03-25 15:47:15.872703	7558	20.5	1	10
2014-03-25 15:47:16.094622	7559	53	2	10
2014-03-25 15:47:54.872806	7567	20.5	1	10
2014-03-25 15:47:55.097271	7568	53	2	10
2014-03-25 15:48:33.875791	7576	20.5	1	10
2014-03-25 15:48:34.098506	7577	53	2	10
2014-03-25 15:49:12.874107	7586	20.5	1	10
2014-03-25 15:49:13.09982	7587	52	2	10
2014-03-25 15:49:51.874044	7595	20.5	1	10
2014-03-25 15:49:52.131429	7596	52	2	10
2014-03-25 15:50:30.873619	7603	20.5	1	10
2014-03-25 15:50:31.10536	7604	52	2	10
2014-03-25 15:51:12.184445	7617	20.0	1	8
2014-03-25 15:51:12.410386	7618	54	2	8
2014-03-25 15:51:27.732071	7619	20.3	1	1
2014-03-25 15:51:27.965414	7620	53	2	1
2014-03-25 15:51:32.753519	7621	498	3	2
2014-03-26 20:19:23.276191	30086	48	2	9
2014-03-26 20:19:24.138838	30087	21.7	1	8
2014-03-25 15:51:51.182433	7626	20.0	1	8
2014-03-25 15:51:51.406124	7627	54	2	8
2014-03-25 15:52:06.732475	7628	20.3	1	1
2014-03-25 15:52:06.956821	7629	53	2	1
2014-03-26 20:19:24.371598	30088	49	2	8
2014-03-26 20:19:32.577039	30089	595	3	2
2014-03-25 15:52:30.183148	7634	20.0	1	8
2014-03-25 15:52:30.414421	7635	54	2	8
2014-03-25 15:52:32.752465	7636	482	3	2
2014-03-25 15:52:45.7345	7637	20.3	1	1
2014-03-25 15:52:45.960804	7638	53	2	1
2014-03-26 20:19:32.802452	30090	1087372.278307834	4	2
2014-03-26 20:19:38.755174	30091	20.7	1	1
2014-03-25 15:53:09.183368	7643	20.0	1	8
2014-03-25 15:53:09.407155	7644	54	2	8
2014-03-25 15:53:24.734674	7645	20.3	1	1
2014-03-25 15:53:24.968115	7646	53	2	1
2014-03-25 15:53:32.753644	7647	498	3	2
2014-03-26 20:19:38.989242	30092	50	2	1
2014-03-26 20:19:44.577573	30093	515	3	2
2014-03-25 15:53:48.182077	7652	20.0	1	8
2014-03-25 15:53:48.41335	7653	54	2	8
2014-03-25 15:54:03.72984	7654	20.3	1	1
2014-03-25 15:54:03.953975	7655	53	2	1
2014-03-26 20:19:44.812927	30094	1087374.5763772768	4	2
2014-03-26 20:19:51.676935	30095	23.1	1	10
2014-03-25 15:54:27.182888	7660	20.0	1	8
2014-03-25 15:54:27.41365	7661	54	2	8
2014-03-25 15:54:32.751128	7662	498	3	2
2014-03-25 15:54:42.732689	7663	20.3	1	1
2014-03-25 15:54:42.958455	7664	53	2	1
2014-03-25 15:54:44.752975	7665	450	3	2
2014-03-25 15:54:56.753638	7666	450	3	2
2014-03-26 20:19:51.911482	30096	40	2	10
2014-03-26 20:19:56.576606	30097	595	3	2
2014-03-25 15:55:06.183043	7671	20.0	1	8
2014-03-25 15:55:06.415098	7672	54	2	8
2014-03-25 15:55:21.734658	7673	20.3	1	1
2014-03-25 15:55:21.958919	7674	53	2	1
2014-03-25 15:55:32.75398	7675	450	3	2
2014-03-26 20:19:56.803705	30098	1087376.8744467197	4	2
2014-03-26 20:20:02.052456	30099	21.8	1	9
2014-03-25 15:55:45.185012	7680	20.0	1	8
2014-03-25 15:55:45.407033	7681	54	2	8
2014-03-26 20:20:02.289379	30100	48	2	9
2014-03-26 20:20:03.14061	30101	21.8	1	8
2014-03-25 15:56:24.182274	7686	20.0	1	8
2014-03-25 15:56:24.41639	7687	54	2	8
2014-03-25 15:56:39.729174	7688	20.3	1	1
2014-03-25 15:56:39.952617	7689	53	2	1
2014-03-26 20:20:03.365723	30102	49	2	8
2014-03-26 20:20:08.575874	30103	595	3	2
2014-03-25 15:57:03.182938	7694	20.0	1	8
2014-03-25 15:57:03.415786	7695	54	2	8
2014-03-25 15:57:18.728826	7696	20.3	1	1
2014-03-25 15:57:18.953396	7697	53	2	1
2014-03-25 15:57:32.755812	7698	466	3	2
2014-03-26 20:20:08.815163	30104	1087378.0234814412	4	2
2014-03-26 20:20:17.75879	30105	20.7	1	1
2014-03-25 15:57:42.182348	7703	20.0	1	8
2014-03-25 15:57:42.406516	7704	54	2	8
2014-03-25 15:57:57.730148	7705	20.3	1	1
2014-03-25 15:57:57.964359	7706	53	2	1
2014-03-26 20:20:17.983489	30106	50	2	1
2014-03-26 20:20:30.677681	30107	23.1	1	10
2014-03-25 15:58:21.18246	7711	20.0	1	8
2014-03-25 15:58:21.405602	7712	54	2	8
2014-03-25 15:58:32.75481	7713	450	3	2
2014-03-25 15:58:36.730026	7714	20.3	1	1
2014-03-25 15:58:36.9529	7715	53	2	1
2014-03-26 20:20:30.911984	30108	41	2	10
2014-03-26 20:20:32.57412	30109	595	3	2
2014-03-25 15:59:00.183458	7720	20.0	1	8
2014-03-25 15:59:00.425701	7721	54	2	8
2014-03-25 15:59:15.725839	7722	20.3	1	1
2014-03-25 15:59:15.953691	7723	53	2	1
2014-03-25 15:59:32.753742	7724	450	3	2
2014-03-26 20:20:32.799998	30110	1087382.6196203267	4	2
2014-03-26 20:20:41.051931	30111	21.9	1	9
2014-03-25 15:59:39.183259	7729	20.0	1	8
2014-03-25 15:59:39.407556	7730	54	2	8
2014-03-25 15:59:54.72783	7731	20.3	1	1
2014-03-25 15:59:54.96404	7732	53	2	1
2014-03-26 20:20:41.297573	30112	48	2	9
2014-03-26 20:20:42.139821	30113	21.8	1	8
2014-03-25 16:00:18.183151	7737	20.0	1	8
2014-03-25 16:00:18.406049	7738	54	2	8
2014-03-25 16:00:32.753938	7739	466	3	2
2014-03-25 16:00:33.728947	7740	20.3	1	1
2014-03-25 16:00:33.957153	7741	53	2	1
2014-03-26 20:20:42.363627	30114	49	2	8
2014-03-26 20:20:56.755985	30115	20.7	1	1
2014-03-25 16:00:57.320067	7746	20.0	1	8
2014-03-25 16:00:57.750813	7747	54	2	8
2014-03-25 16:01:12.729119	7748	20.3	1	1
2014-03-25 16:01:12.954819	7749	53	2	1
2014-03-25 16:01:20.75472	7750	498	3	2
2014-03-25 16:01:32.755104	7751	579	3	2
2014-03-25 15:51:48.873526	7622	20.5	1	10
2014-03-25 15:51:49.096961	7623	52	2	10
2014-03-25 15:52:27.874896	7630	20.5	1	10
2014-03-25 15:52:28.136623	7631	52	2	10
2014-03-25 15:53:06.876693	7639	20.5	1	10
2014-03-25 15:53:07.099583	7640	52	2	10
2014-03-25 15:53:45.876231	7648	20.5	1	10
2014-03-25 15:53:46.099842	7649	52	2	10
2014-03-25 15:54:24.877104	7656	20.5	1	10
2014-03-25 15:54:25.109481	7657	52	2	10
2014-03-25 15:55:03.875043	7667	20.5	1	10
2014-03-25 15:55:04.10848	7668	52	2	10
2014-03-25 15:55:42.875581	7676	20.5	1	10
2014-03-25 15:55:43.102275	7677	52	2	10
2014-03-25 15:56:21.875306	7682	20.5	1	10
2014-03-25 15:56:22.107343	7683	52	2	10
2014-03-25 15:57:00.875336	7690	20.5	1	10
2014-03-25 15:57:01.108492	7691	52	2	10
2014-03-25 15:57:39.875395	7699	20.5	1	10
2014-03-25 15:57:40.100654	7700	52	2	10
2014-03-25 15:58:18.878817	7707	20.5	1	10
2014-03-25 15:58:19.100319	7708	52	2	10
2014-03-25 15:58:57.87668	7716	20.5	1	10
2014-03-25 15:58:58.108067	7717	52	2	10
2014-03-25 15:59:36.877356	7725	20.5	1	10
2014-03-25 15:59:37.101004	7726	52	2	10
2014-03-25 16:00:15.877076	7733	20.5	1	10
2014-03-25 16:00:16.10286	7734	52	2	10
2014-03-26 20:20:56.990226	30116	50	2	1
2014-03-26 20:21:08.574318	30117	676	3	2
2014-03-25 16:01:36.184611	7756	20.0	1	8
2014-03-25 16:01:36.416802	7757	54	2	8
2014-03-25 16:01:44.755008	7758	579	3	2
2014-03-25 16:01:51.727945	7759	20.3	1	1
2014-03-25 16:01:51.949906	7760	53	2	1
2014-03-26 20:21:08.800511	30118	1087388.364793934	4	2
2014-03-26 20:21:09.67743	30119	23.1	1	10
2014-03-25 16:02:15.183306	7765	20.0	1	8
2014-03-25 16:02:15.405477	7766	54	2	8
2014-03-25 16:02:30.727893	7767	20.3	1	1
2014-03-25 16:02:30.959425	7768	53	2	1
2014-03-25 16:02:32.758899	7769	595	3	2
2014-03-26 20:21:09.912452	30120	41	2	10
2014-03-26 20:21:20.057993	30121	21.9	1	9
2014-03-25 16:02:54.18544	7774	20.0	1	8
2014-03-25 16:02:54.406286	7775	54	2	8
2014-03-25 16:03:09.730565	7776	20.3	1	1
2014-03-25 16:03:09.953478	7777	53	2	1
2014-03-26 20:21:20.280161	30122	48	2	9
2014-03-26 20:21:20.589146	30123	676	3	2
2014-03-25 16:03:32.753383	7782	595	3	2
2014-03-25 16:03:33.182973	7783	20.0	1	8
2014-03-25 16:03:33.405372	7784	54	2	8
2014-03-25 16:03:48.731543	7785	20.3	1	1
2014-03-25 16:03:48.95461	7786	53	2	1
2014-03-26 20:21:20.824088	30124	1087390.6628633766	4	2
2014-03-26 20:21:21.139598	30125	21.8	1	8
2014-03-25 16:04:12.182981	7791	20.1	1	8
2014-03-25 16:04:12.461959	7792	54	2	8
2014-03-25 16:04:27.726005	7793	20.3	1	1
2014-03-25 16:04:27.958202	7794	53	2	1
2014-03-25 16:04:32.755848	7795	611	3	2
2014-03-26 20:21:21.362881	30126	49	2	8
2014-03-26 20:21:32.57351	30127	643	3	2
2014-03-25 16:04:51.183723	7800	20.1	1	8
2014-03-25 16:04:51.414448	7801	54	2	8
2014-03-25 16:05:06.725772	7802	20.3	1	1
2014-03-25 16:05:06.951758	7803	53	2	1
2014-03-26 20:21:32.806646	30128	1087392.9609328194	4	2
2014-03-26 20:21:35.753128	30129	20.7	1	1
2014-03-25 16:05:30.185691	7808	20.1	1	8
2014-03-25 16:05:30.42931	7809	54	2	8
2014-03-25 16:05:32.759518	7810	595	3	2
2014-03-25 16:05:45.727311	7811	20.3	1	1
2014-03-25 16:05:45.950993	7812	53	2	1
2014-03-26 20:21:35.979324	30130	50	2	1
2014-03-26 20:21:44.577944	30131	676	3	2
2014-03-25 16:06:09.1836	7817	20.1	1	8
2014-03-25 16:06:09.406051	7818	54	2	8
2014-03-25 16:06:24.72669	7819	20.3	1	1
2014-03-25 16:06:24.958857	7820	53	2	1
2014-03-26 20:21:44.81585	30132	1087395.2590022623	4	2
2014-03-26 20:21:48.676364	30133	23.1	1	10
2014-03-25 16:06:48.18623	7825	20.1	1	8
2014-03-25 16:06:48.409367	7826	54	2	8
2014-03-25 16:07:03.527539	7827	498	3	2
2014-03-25 16:07:03.845976	7828	20.3	1	1
2014-03-25 16:07:04.069007	7829	53	2	1
2014-03-25 16:07:20.756545	7830	450	3	2
2014-03-26 20:21:48.899253	30134	41	2	10
2014-03-26 20:21:56.576947	30135	676	3	2
2014-03-25 16:07:27.184103	7835	20.1	1	8
2014-03-25 16:07:27.410044	7836	54	2	8
2014-03-25 16:07:32.754418	7837	450	3	2
2014-03-25 16:07:42.727762	7838	20.3	1	1
2014-03-25 16:07:42.954753	7839	53	2	1
2014-03-26 20:21:56.813626	30136	1087397.557071705	4	2
2014-03-26 20:21:59.054298	30137	21.9	1	9
2014-03-25 16:08:06.18306	7844	20.1	1	8
2014-03-25 16:08:06.416949	7845	54	2	8
2014-03-25 16:08:21.723851	7846	20.3	1	1
2014-03-25 16:08:21.948625	7847	53	2	1
2014-03-25 16:08:32.757991	7848	450	3	2
2014-03-26 20:21:59.279675	30138	48	2	9
2014-03-26 20:22:00.139513	30139	21.9	1	8
2014-03-25 16:08:45.183167	7853	20.1	1	8
2014-03-25 16:08:45.404582	7854	54	2	8
2014-03-25 16:09:00.725074	7855	20.3	1	1
2014-03-25 16:09:00.957405	7856	53	2	1
2014-03-25 16:09:08.75318	7857	402	3	2
2014-03-25 16:09:20.755935	7858	402	3	2
2014-03-26 20:22:00.373775	30140	49	2	8
2014-03-26 20:22:14.808274	30141	20.7	1	1
2014-03-25 16:09:24.183801	7863	20.1	1	8
2014-03-25 16:09:24.416757	7864	54	2	8
2014-03-25 16:09:32.758512	7865	402	3	2
2014-03-25 16:09:39.728631	7866	20.3	1	1
2014-03-25 16:09:39.951362	7867	53	2	1
2014-03-26 20:22:15.03498	30142	50	2	1
2014-03-26 20:22:27.67706	30143	23.1	1	10
2014-03-25 16:10:03.184187	7872	20.1	1	8
2014-03-25 16:10:03.407234	7873	54	2	8
2014-03-25 16:10:18.72211	7874	20.3	1	1
2014-03-25 16:10:18.956625	7875	53	2	1
2014-03-25 16:10:32.754055	7876	402	3	2
2014-03-26 20:22:27.912058	30144	41	2	10
2014-03-26 20:22:32.577086	30145	676	3	2
2014-03-25 16:10:42.239689	7881	20.1	1	8
2014-03-25 16:10:42.474638	7882	54	2	8
2014-03-25 16:10:57.724641	7883	20.3	1	1
2014-03-25 16:10:57.950289	7884	53	2	1
2014-03-25 16:01:34.101644	7753	52	2	10
2014-03-25 16:02:12.878053	7761	20.5	1	10
2014-03-25 16:02:13.100781	7762	52	2	10
2014-03-25 16:02:51.877466	7770	20.5	1	10
2014-03-25 16:02:52.100351	7771	52	2	10
2014-03-25 16:03:30.876708	7778	20.5	1	10
2014-03-25 16:03:31.099882	7779	52	2	10
2014-03-25 16:04:09.878182	7787	20.5	1	10
2014-03-25 16:04:10.103792	7788	52	2	10
2014-03-25 16:04:48.882038	7796	20.5	1	10
2014-03-25 16:04:49.113105	7797	52	2	10
2014-03-25 16:05:27.879093	7804	20.5	1	10
2014-03-25 16:05:28.115571	7805	52	2	10
2014-03-25 16:06:06.879366	7813	20.5	1	10
2014-03-25 16:06:07.103962	7814	52	2	10
2014-03-25 16:06:45.879285	7821	20.5	1	10
2014-03-25 16:06:46.103081	7822	52	2	10
2014-03-25 16:07:24.879708	7831	20.5	1	10
2014-03-25 16:07:25.102635	7832	52	2	10
2014-03-25 16:08:03.881088	7840	20.5	1	10
2014-03-25 16:08:04.104392	7841	52	2	10
2014-03-25 16:08:42.879163	7849	20.5	1	10
2014-03-25 16:08:43.102988	7850	52	2	10
2014-03-25 16:09:21.880559	7859	20.5	1	10
2014-03-25 16:09:22.113944	7860	52	2	10
2014-03-25 16:10:00.88188	7868	20.5	1	10
2014-03-25 16:10:01.108695	7869	52	2	10
2014-03-25 16:10:39.880964	7877	20.5	1	10
2014-03-25 16:10:40.104676	7878	52	2	10
2014-03-25 16:11:18.880706	7885	20.5	1	10
2014-03-25 16:11:21.184916	7889	20.1	1	8
2014-03-25 16:11:21.419474	7890	54	2	8
2014-03-25 16:11:32.75533	7891	418	3	2
2014-03-25 16:11:36.723094	7892	20.2	1	1
2014-03-25 16:11:36.946159	7893	53	2	1
2014-03-26 20:22:32.80338	30146	1087404.4512800337	4	2
2014-03-26 20:22:38.053272	30147	21.9	1	9
2014-03-25 16:12:00.185057	7898	20.1	1	8
2014-03-25 16:12:00.407803	7899	54	2	8
2014-03-25 16:12:15.723807	7900	20.2	1	1
2014-03-25 16:12:16.142545	7901	53	2	1
2014-03-25 16:12:32.753445	7902	418	3	2
2014-03-26 20:22:38.293275	30148	48	2	9
2014-03-26 20:22:39.141871	30149	21.9	1	8
2014-03-25 16:12:39.182928	7907	20.1	1	8
2014-03-25 16:12:39.416184	7908	54	2	8
2014-03-25 16:12:54.723288	7909	20.2	1	1
2014-03-25 16:12:54.944207	7910	53	2	1
2014-03-25 16:12:56.753292	7911	370	3	2
2014-03-25 16:13:08.753792	7912	370	3	2
2014-03-26 20:22:39.365509	30150	49	2	8
2014-03-26 20:22:53.754645	30151	20.8	1	1
2014-03-25 16:13:18.182827	7917	20.1	1	8
2014-03-25 16:13:18.405673	7918	54	2	8
2014-03-25 16:13:32.752851	7919	418	3	2
2014-03-25 16:13:33.723603	7920	20.2	1	1
2014-03-25 16:13:33.94419	7921	53	2	1
2014-03-25 16:13:44.752377	7922	418	3	2
2014-03-26 20:22:53.988752	30152	50	2	1
2014-03-26 20:23:06.678223	30153	23.2	1	10
2014-03-25 16:13:57.182735	7927	20.1	1	8
2014-03-25 16:13:57.413648	7928	54	2	8
2014-03-25 16:14:12.777281	7929	20.2	1	1
2014-03-25 16:14:12.99971	7930	53	2	1
2014-03-25 16:14:32.75348	7931	418	3	2
2014-03-26 20:23:06.904188	30154	41	2	10
2014-03-26 20:23:17.05259	30155	21.9	1	9
2014-03-25 16:14:36.181643	7936	20.1	1	8
2014-03-25 16:14:36.40256	7937	54	2	8
2014-03-25 16:14:51.72138	7938	20.2	1	1
2014-03-25 16:14:51.955054	7939	53	2	1
2014-03-26 20:23:17.649947	30156	48	2	9
2014-03-26 20:23:18.139275	30157	21.9	1	8
2014-03-25 16:15:15.182315	7944	20.1	1	8
2014-03-25 16:15:15.40328	7945	54	2	8
2014-03-25 16:15:30.720086	7946	20.2	1	1
2014-03-25 16:15:30.962725	7947	53	2	1
2014-03-25 16:15:32.754549	7948	418	3	2
2014-03-26 20:23:18.400662	30158	49	2	8
2014-03-26 20:23:32.752353	30159	20.8	1	1
2014-03-25 16:15:54.182781	7953	20.1	1	8
2014-03-25 16:15:54.413182	7954	54	2	8
2014-03-25 16:16:09.719055	7955	20.2	1	1
2014-03-25 16:16:09.943861	7956	53	2	1
2014-03-26 20:23:33.033974	30160	50	2	1
2014-03-26 20:23:45.677353	30161	23.2	1	10
2014-03-25 16:16:32.75337	7961	418	3	2
2014-03-25 16:16:33.181758	7962	20.1	1	8
2014-03-25 16:16:33.403296	7963	54	2	8
2014-03-25 16:16:48.722001	7964	20.2	1	1
2014-03-25 16:16:48.953232	7965	53	2	1
2014-03-25 16:17:08.750358	7966	370	3	2
2014-03-26 20:23:45.936092	30162	41	2	10
2014-03-26 20:23:56.052689	30163	21.9	1	9
2014-03-25 16:17:12.184227	7971	20.1	1	8
2014-03-25 16:17:12.414477	7972	54	2	8
2014-03-25 16:17:27.521765	7973	354	3	2
2014-03-25 16:17:27.827461	7974	20.2	1	1
2014-03-25 16:17:28.051598	7975	53	2	1
2014-03-25 16:17:32.754987	7976	370	3	2
2014-03-26 20:23:56.32348	30164	48	2	9
2014-03-26 20:23:57.139316	30165	21.9	1	8
2014-03-25 16:17:51.183003	7981	20.1	1	8
2014-03-25 16:17:51.413757	7982	54	2	8
2014-03-25 16:18:06.719184	7983	20.2	1	1
2014-03-25 16:18:06.94145	7984	53	2	1
2014-03-26 20:23:57.859069	30166	49	2	8
2014-03-26 20:24:11.753296	30167	20.8	1	1
2014-03-25 16:18:30.182199	7989	20.1	1	8
2014-03-25 16:18:30.424872	7990	53	2	8
2014-03-25 16:18:32.753911	7991	402	3	2
2014-03-25 16:18:44.753819	7992	354	3	2
2014-03-25 16:18:45.716003	7993	20.2	1	1
2014-03-25 16:18:45.947759	7994	53	2	1
2014-03-25 16:18:56.752929	7995	305	3	2
2014-03-26 20:24:11.987318	30168	50	2	1
2014-03-26 20:24:20.573336	30169	643	3	2
2014-03-25 16:19:08.751247	8000	305	3	2
2014-03-25 16:19:09.18202	8001	20.0	1	8
2014-03-25 16:19:09.403387	8002	54	2	8
2014-03-25 16:19:20.756559	8003	338	3	2
2014-03-25 16:19:24.717708	8004	20.2	1	1
2014-03-25 16:19:24.948163	8005	53	2	1
2014-03-25 16:19:32.752059	8006	338	3	2
2014-03-26 20:24:20.798625	30170	1087423.9848702976	4	2
2014-03-26 20:24:24.680545	30171	23.2	1	10
2014-03-25 16:19:48.182469	8011	20.0	1	8
2014-03-25 16:19:48.413113	8012	53	2	8
2014-03-25 16:20:03.7216	8013	20.1	1	1
2014-03-25 16:20:03.944129	8014	53	2	1
2014-03-26 20:24:24.914491	30172	41	2	10
2014-03-26 20:24:32.5741	30173	676	3	2
2014-03-25 16:20:27.182535	8019	20.0	1	8
2014-03-25 16:20:27.413154	8020	53	2	8
2014-03-25 16:20:32.756258	8021	354	3	2
2014-03-25 16:20:42.713932	8022	20.1	1	1
2014-03-25 16:20:42.937178	8023	53	2	1
2014-03-25 16:11:57.87948	7894	20.5	1	10
2014-03-25 16:11:58.102869	7895	52	2	10
2014-03-25 16:12:36.881113	7903	20.5	1	10
2014-03-25 16:12:37.118651	7904	52	2	10
2014-03-25 16:13:15.880345	7913	20.5	1	10
2014-03-25 16:13:16.101146	7914	52	2	10
2014-03-25 16:13:54.880729	7923	20.5	1	10
2014-03-25 16:13:55.112345	7924	52	2	10
2014-03-25 16:14:33.881034	7932	20.5	1	10
2014-03-25 16:14:34.102474	7933	52	2	10
2014-03-25 16:15:12.899846	7940	20.5	1	10
2014-03-25 16:15:13.120833	7941	52	2	10
2014-03-25 16:15:51.882149	7949	20.5	1	10
2014-03-25 16:15:52.104563	7950	52	2	10
2014-03-25 16:16:30.882462	7957	20.5	1	10
2014-03-25 16:16:31.116378	7958	52	2	10
2014-03-25 16:17:09.881994	7967	20.5	1	10
2014-03-25 16:17:10.124042	7968	52	2	10
2014-03-25 16:17:48.883051	7977	20.5	1	10
2014-03-25 16:17:49.108186	7978	52	2	10
2014-03-25 16:18:27.881738	7985	20.5	1	10
2014-03-25 16:18:28.112771	7986	52	2	10
2014-03-25 16:19:06.882039	7996	20.5	1	10
2014-03-25 16:19:07.103708	7997	52	2	10
2014-03-25 16:19:45.884641	8007	20.5	1	10
2014-03-25 16:19:46.105672	8008	52	2	10
2014-03-26 20:24:32.799	30174	1087426.2829397405	4	2
2014-03-26 20:24:35.052428	30175	21.9	1	9
2014-03-25 16:21:06.182398	8028	20.0	1	8
2014-03-25 16:21:06.403527	8029	53	2	8
2014-03-25 16:21:21.716997	8030	20.1	1	1
2014-03-25 16:21:21.951335	8031	53	2	1
2014-03-25 16:21:32.751013	8032	338	3	2
2014-03-26 20:24:35.287033	30176	48	2	9
2014-03-26 20:24:36.140035	30177	22.0	1	8
2014-03-25 16:21:45.182381	8037	20.0	1	8
2014-03-25 16:21:45.403157	8038	53	2	8
2014-03-25 16:22:00.717382	8039	20.1	1	1
2014-03-25 16:22:00.939273	8040	53	2	1
2014-03-26 20:24:36.363272	30178	48	2	8
2014-03-26 20:24:44.576981	30179	627	3	2
2014-03-25 16:22:24.183547	8045	20.0	1	8
2014-03-25 16:22:24.413391	8046	53	2	8
2014-03-25 16:22:32.755647	8047	338	3	2
2014-03-25 16:22:39.715503	8048	20.1	1	1
2014-03-25 16:22:39.939385	8049	53	2	1
2014-03-26 20:24:44.811405	30180	1087428.5810091833	4	2
2014-03-26 20:24:50.753386	30181	20.8	1	1
2014-03-25 16:23:03.183216	8054	20.0	1	8
2014-03-25 16:23:03.404223	8055	53	2	8
2014-03-25 16:23:18.716974	8056	20.1	1	1
2014-03-25 16:23:18.955384	8057	53	2	1
2014-03-25 16:23:32.754213	8058	338	3	2
2014-03-26 20:24:50.976684	30182	50	2	1
2014-03-26 20:24:56.57659	30183	627	3	2
2014-03-25 16:23:42.181083	8063	20.0	1	8
2014-03-25 16:23:42.404641	8064	53	2	8
2014-03-25 16:23:57.714115	8065	20.1	1	1
2014-03-25 16:23:57.936099	8066	53	2	1
2014-03-26 20:24:56.812159	30184	1087430.8790786262	4	2
2014-03-26 20:25:03.677405	30185	23.2	1	10
2014-03-25 16:24:21.182418	8071	20.0	1	8
2014-03-25 16:24:21.413455	8072	53	2	8
2014-03-25 16:24:32.755369	8073	338	3	2
2014-03-25 16:24:36.713897	8074	20.1	1	1
2014-03-25 16:24:36.936852	8075	53	2	1
2014-03-25 16:24:56.753455	8076	370	3	2
2014-03-26 20:25:03.903128	30186	41	2	10
2014-03-26 20:25:14.052095	30187	21.9	1	9
2014-03-25 16:25:00.182501	8081	20.0	1	8
2014-03-25 16:25:00.404361	8082	53	2	8
2014-03-25 16:25:08.75275	8083	370	3	2
2014-03-25 16:25:15.716073	8084	20.1	1	1
2014-03-25 16:25:15.939097	8085	53	2	1
2014-03-25 16:25:20.751996	8086	402	3	2
2014-03-25 16:25:32.754626	8087	370	3	2
2014-03-26 20:25:14.287864	30188	48	2	9
2014-03-26 20:25:15.142108	30189	22.0	1	8
2014-03-25 16:25:39.182847	8092	20.0	1	8
2014-03-25 16:25:39.403789	8093	53	2	8
2014-03-25 16:25:44.75648	8094	370	3	2
2014-03-25 16:25:54.715439	8095	20.1	1	1
2014-03-25 16:25:54.939124	8096	53	2	1
2014-03-26 20:25:15.369188	30190	48	2	8
2014-03-26 20:25:20.577646	30191	547	3	2
2014-03-25 16:26:18.18326	8101	20.0	1	8
2014-03-25 16:26:18.412232	8102	53	2	8
2014-03-25 16:26:32.755314	8103	370	3	2
2014-03-25 16:26:33.714878	8104	20.1	1	1
2014-03-25 16:26:33.937448	8105	53	2	1
2014-03-26 20:25:20.812273	30192	1087434.3261827903	4	2
2014-03-26 20:25:29.748894	30193	20.8	1	1
2014-03-25 16:26:57.184703	8110	20.0	1	8
2014-03-25 16:26:57.415851	8111	53	2	8
2014-03-25 16:27:12.712631	8112	20.1	1	1
2014-03-25 16:27:12.934127	8113	53	2	1
2014-03-25 16:27:32.751339	8114	370	3	2
2014-03-26 20:25:29.973506	30194	50	2	1
2014-03-26 20:25:32.575508	30195	547	3	2
2014-03-25 16:27:36.182828	8119	20.0	1	8
2014-03-25 16:27:36.403227	8120	53	2	8
2014-03-25 16:27:51.712824	8121	20.1	1	1
2014-03-25 16:27:51.947421	8122	53	2	1
2014-03-25 16:27:56.752631	8123	434	3	2
2014-03-25 16:28:08.752581	8124	450	3	2
2014-03-26 20:25:32.812026	30196	1087436.6242522332	4	2
2014-03-26 20:25:42.680934	30197	23.2	1	10
2014-03-25 16:28:15.183728	8129	20.0	1	8
2014-03-25 16:28:15.414978	8130	53	2	8
2014-03-25 16:28:30.712385	8131	20.1	1	1
2014-03-25 16:28:30.934456	8132	53	2	1
2014-03-25 16:28:32.754177	8133	450	3	2
2014-03-26 20:25:42.907551	30198	41	2	10
2014-03-26 20:25:44.573245	30199	611	3	2
2014-03-25 16:28:54.18207	8138	20.0	1	8
2014-03-25 16:28:54.459465	8139	53	2	8
2014-03-25 16:29:09.711732	8140	20.0	1	1
2014-03-25 16:29:10.438932	8141	53	2	1
2014-03-26 20:25:44.810717	30200	1087438.922321676	4	2
2014-03-26 20:25:53.052408	30201	21.9	1	9
2014-03-25 16:29:32.752406	8146	450	3	2
2014-03-25 16:29:33.181962	8147	20.0	1	8
2014-03-25 16:29:33.405902	8148	53	2	8
2014-03-25 16:29:48.714564	8149	20.0	1	1
2014-03-25 16:29:48.936952	8150	53	2	1
2014-03-26 20:25:53.639376	30202	48	2	9
2014-03-25 16:30:12.182434	8155	20.0	1	8
2014-03-25 16:30:12.404207	8156	53	2	8
2014-03-25 16:30:27.71323	8157	20.0	1	1
2014-03-25 16:30:27.935318	8158	53	2	1
2014-03-25 16:30:32.752877	8159	450	3	2
2014-03-25 16:21:04.106188	8025	52	2	10
2014-03-25 16:21:42.883727	8033	20.5	1	10
2014-03-25 16:21:43.106753	8034	52	2	10
2014-03-25 16:22:21.88299	8041	20.5	1	10
2014-03-25 16:22:22.107713	8042	52	2	10
2014-03-25 16:23:00.882342	8050	20.5	1	10
2014-03-25 16:23:01.103809	8051	52	2	10
2014-03-25 16:23:39.883616	8059	20.5	1	10
2014-03-25 16:23:40.106731	8060	52	2	10
2014-03-25 16:24:18.884209	8067	20.5	1	10
2014-03-25 16:24:19.119508	8068	52	2	10
2014-03-25 16:24:57.886804	8077	20.5	1	10
2014-03-25 16:24:58.109204	8078	52	2	10
2014-03-25 16:25:36.884021	8088	20.5	1	10
2014-03-25 16:25:37.106338	8089	52	2	10
2014-03-25 16:26:15.887392	8097	20.5	1	10
2014-03-25 16:26:16.109083	8098	52	2	10
2014-03-25 16:26:54.887056	8106	20.5	1	10
2014-03-25 16:26:55.120232	8107	52	2	10
2014-03-25 16:27:33.88489	8115	20.5	1	10
2014-03-25 16:27:34.10651	8116	52	2	10
2014-03-25 16:28:12.885968	8125	20.5	1	10
2014-03-25 16:28:13.160279	8126	52	2	10
2014-03-25 16:28:51.888152	8134	20.5	1	10
2014-03-25 16:28:52.144225	8135	52	2	10
2014-03-25 16:29:30.888984	8142	20.5	1	10
2014-03-25 16:29:31.112528	8143	52	2	10
2014-03-25 16:30:09.885948	8151	20.5	1	10
2014-03-26 20:25:54.140042	30203	22.0	1	8
2014-03-26 20:25:54.373778	30204	48	2	8
2014-03-25 16:30:51.182444	8164	20.0	1	8
2014-03-25 16:30:51.403265	8165	53	2	8
2014-03-25 16:30:56.753201	8166	418	3	2
2014-03-25 16:31:06.714965	8167	20.0	1	1
2014-03-25 16:31:06.949582	8168	53	2	1
2014-03-25 16:31:08.756379	8169	418	3	2
2014-03-26 20:26:08.430094	30205	611	3	2
2014-03-26 20:26:08.655258	30206	1087441.220391119	4	2
2014-03-25 16:31:30.182405	8174	20.0	1	8
2014-03-25 16:31:30.413158	8175	53	2	8
2014-03-25 16:31:32.753167	8176	418	3	2
2014-03-25 16:31:45.71339	8177	20.0	1	1
2014-03-25 16:31:45.938713	8178	53	2	1
2014-03-26 20:26:08.965233	30207	20.8	1	1
2014-03-26 20:26:09.210721	30208	50	2	1
2014-03-25 16:32:09.182258	8183	20.0	1	8
2014-03-25 16:32:09.404477	8184	53	2	8
2014-03-25 16:32:24.711151	8185	20.0	1	1
2014-03-25 16:32:24.944466	8186	53	2	1
2014-03-25 16:32:32.753453	8187	402	3	2
2014-03-26 20:26:20.574346	30209	611	3	2
2014-03-26 20:26:20.801331	30210	1087444.667495283	4	2
2014-03-25 16:32:48.18192	8192	20.0	1	8
2014-03-25 16:32:48.404026	8193	53	2	8
2014-03-25 16:33:03.70952	8194	20.0	1	1
2014-03-25 16:33:03.931569	8195	53	2	1
2014-03-26 20:26:21.676968	30211	23.2	1	10
2014-03-26 20:26:21.912932	30212	41	2	10
2014-03-25 16:33:27.184771	8200	20.0	1	8
2014-03-25 16:33:27.405595	8201	53	2	8
2014-03-25 16:33:32.753538	8202	434	3	2
2014-03-25 16:33:42.709502	8203	20.0	1	1
2014-03-25 16:33:42.985072	8204	53	2	1
2014-03-25 16:33:44.749996	8205	418	3	2
2014-03-26 20:26:32.053427	30213	21.9	1	9
2014-03-26 20:26:32.276934	30214	48	2	9
2014-03-25 16:34:06.183103	8210	20.0	1	8
2014-03-25 16:34:06.409803	8211	53	2	8
2014-03-25 16:34:21.708558	8212	20.0	1	1
2014-03-25 16:34:21.94255	8213	53	2	1
2014-03-25 16:34:32.755684	8214	434	3	2
2014-03-26 20:26:32.584563	30215	595	3	2
2014-03-26 20:26:32.820212	30216	1087446.965564726	4	2
2014-03-25 16:34:45.181786	8219	20.0	1	8
2014-03-25 16:34:45.414476	8220	53	2	8
2014-03-25 16:34:56.75422	8221	402	3	2
2014-03-25 16:35:00.707485	8222	20.0	1	1
2014-03-25 16:35:00.929211	8223	53	2	1
2014-03-25 16:35:08.752066	8224	402	3	2
2014-03-26 20:26:33.139956	30217	22.0	1	8
2014-03-26 20:26:33.364093	30218	48	2	8
2014-03-25 16:35:24.180888	8229	20.0	1	8
2014-03-25 16:35:24.402353	8230	53	2	8
2014-03-25 16:35:32.751711	8231	434	3	2
2014-03-25 16:35:39.710452	8232	20.0	1	1
2014-03-25 16:35:39.933346	8233	53	2	1
2014-03-25 16:35:44.756593	8234	418	3	2
2014-03-26 20:26:47.750494	30219	20.8	1	1
2014-03-26 20:26:47.986871	30220	50	2	1
2014-03-25 16:36:03.181586	8239	20.0	1	8
2014-03-25 16:36:03.414838	8240	53	2	8
2014-03-25 16:36:18.709167	8241	20.0	1	1
2014-03-25 16:36:18.936683	8242	53	2	1
2014-03-25 16:36:32.755038	8243	418	3	2
2014-03-26 20:27:00.67872	30221	23.2	1	10
2014-03-26 20:27:00.90607	30222	41	2	10
2014-03-25 16:36:42.180946	8248	20.0	1	8
2014-03-25 16:36:42.402866	8249	53	2	8
2014-03-25 16:36:57.708097	8250	20.0	1	1
2014-03-25 16:36:57.943269	8251	53	2	1
2014-03-25 16:37:08.750117	8252	450	3	2
2014-03-26 20:27:11.052823	30223	22.0	1	9
2014-03-26 20:27:11.287813	30224	48	2	9
2014-03-25 16:37:20.752892	8257	434	3	2
2014-03-25 16:37:21.181418	8258	20.0	1	8
2014-03-25 16:37:21.40343	8259	53	2	8
2014-03-25 16:37:32.751956	8260	450	3	2
2014-03-25 16:37:36.709828	8261	20.0	1	1
2014-03-25 16:37:36.934385	8262	53	2	1
2014-03-26 20:27:12.140641	30225	22.0	1	8
2014-03-26 20:27:12.36475	30226	48	2	8
2014-03-25 16:38:00.182858	8267	20.0	1	8
2014-03-25 16:38:00.415461	8268	53	2	8
2014-03-25 16:38:15.709767	8269	20.0	1	1
2014-03-25 16:38:15.933454	8270	53	2	1
2014-03-25 16:38:32.752892	8271	450	3	2
2014-03-26 20:27:20.573831	30227	627	3	2
2014-03-26 20:27:20.808073	30228	1087455.0088077758	4	2
2014-03-25 16:38:39.183437	8276	20.0	1	8
2014-03-25 16:38:39.407241	8277	53	2	8
2014-03-25 16:38:54.710423	8278	20.0	1	1
2014-03-25 16:38:54.944301	8279	53	2	1
2014-03-26 20:27:26.750706	30229	20.8	1	1
2014-03-26 20:27:26.97782	30230	50	2	1
2014-03-25 16:39:18.180853	8284	20.0	1	8
2014-03-25 16:39:18.405162	8285	53	2	8
2014-03-25 16:39:32.750169	8286	466	3	2
2014-03-25 16:39:33.705115	8287	20.0	1	1
2014-03-25 16:39:33.927411	8288	53	2	1
2014-03-25 16:39:57.182638	8293	20.0	1	8
2014-03-25 16:39:57.415584	8294	53	2	8
2014-03-25 16:40:12.707013	8295	20.1	1	1
2014-03-25 16:40:12.932963	8296	53	2	1
2014-03-25 16:30:49.108586	8161	52	2	10
2014-03-25 16:31:27.887104	8170	20.5	1	10
2014-03-25 16:31:28.114994	8171	52	2	10
2014-03-25 16:32:06.890479	8179	20.5	1	10
2014-03-25 16:32:07.112338	8180	52	2	10
2014-03-25 16:32:45.88844	8188	20.5	1	10
2014-03-25 16:32:46.114061	8189	52	2	10
2014-03-25 16:33:24.887564	8196	20.5	1	10
2014-03-25 16:33:25.109889	8197	52	2	10
2014-03-25 16:34:03.888493	8206	20.5	1	10
2014-03-25 16:34:04.111028	8207	52	2	10
2014-03-25 16:34:42.919329	8215	20.5	1	10
2014-03-25 16:34:43.167559	8216	52	2	10
2014-03-25 16:35:21.887302	8225	20.5	1	10
2014-03-25 16:35:22.107648	8226	52	2	10
2014-03-25 16:36:00.888065	8235	20.5	1	10
2014-03-25 16:36:01.121049	8236	52	2	10
2014-03-25 16:36:39.89008	8244	20.5	1	10
2014-03-25 16:36:40.112271	8245	52	2	10
2014-03-25 16:37:18.890181	8253	20.5	1	10
2014-03-25 16:37:19.11341	8254	52	2	10
2014-03-25 16:37:57.889106	8263	20.5	1	10
2014-03-25 16:37:58.122669	8264	52	2	10
2014-03-25 16:38:36.889495	8272	20.6	1	10
2014-03-25 16:38:37.113769	8273	52	2	10
2014-03-25 16:39:15.889577	8280	20.6	1	10
2014-03-25 16:39:16.114081	8281	52	2	10
2014-03-25 16:39:54.889391	8289	20.6	1	10
2014-03-25 16:40:32.750753	8297	466	3	2
2014-03-26 20:27:32.576073	30231	627	3	2
2014-03-26 20:27:32.812841	30232	1087457.3068772187	4	2
2014-03-25 16:40:36.182238	8302	20.0	1	8
2014-03-25 16:40:36.40501	8303	53	2	8
2014-03-25 16:40:44.754953	8304	434	3	2
2014-03-25 16:40:51.701401	8305	20.1	1	1
2014-03-25 16:40:51.923091	8306	53	2	1
2014-03-25 16:40:56.751268	8307	450	3	2
2014-03-26 20:27:39.679416	30233	23.2	1	10
2014-03-26 20:27:39.906117	30234	41	2	10
2014-03-25 16:41:15.181438	8312	20.0	1	8
2014-03-25 16:41:15.413298	8313	53	2	8
2014-03-25 16:41:30.705484	8314	20.1	1	1
2014-03-25 16:41:30.927309	8315	53	2	1
2014-03-25 16:41:32.75618	8316	434	3	2
2014-03-26 20:27:50.057302	30235	22.0	1	9
2014-03-26 20:27:50.292284	30236	48	2	9
2014-03-25 16:41:54.183003	8321	20.0	1	8
2014-03-25 16:41:54.404443	8322	53	2	8
2014-03-25 16:42:09.705244	8323	20.1	1	1
2014-03-25 16:42:09.927952	8324	53	2	1
2014-03-26 20:27:51.142021	30237	22.0	1	8
2014-03-26 20:27:51.366237	30238	48	2	8
2014-03-25 16:42:32.750614	8329	434	3	2
2014-03-25 16:42:33.181933	8330	20.0	1	8
2014-03-25 16:42:33.404692	8331	53	2	8
2014-03-25 16:42:44.752653	8332	370	3	2
2014-03-25 16:42:48.706528	8333	20.1	1	1
2014-03-25 16:42:48.934855	8334	53	2	1
2014-03-25 16:42:56.751554	8335	402	3	2
2014-03-25 16:43:08.75173	8336	370	3	2
2014-03-26 20:27:56.575649	30239	547	3	2
2014-03-26 20:27:56.81051	30240	1087460.753981383	4	2
2014-03-25 16:43:12.182372	8341	20.0	1	8
2014-03-25 16:43:12.41584	8342	53	2	8
2014-03-25 16:43:20.755567	8343	338	3	2
2014-03-25 16:43:27.704079	8344	20.1	1	1
2014-03-25 16:43:27.930972	8345	53	2	1
2014-03-25 16:43:32.753103	8346	338	3	2
2014-03-26 20:28:05.749222	30241	20.8	1	1
2014-03-26 20:28:05.975521	30242	50	2	1
2014-03-25 16:43:51.185499	8351	20.0	1	8
2014-03-25 16:43:51.406641	8352	53	2	8
2014-03-25 16:44:06.942706	8353	20.1	1	1
2014-03-25 16:44:07.169502	8354	53	2	1
2014-03-26 20:28:08.576427	30243	627	3	2
2014-03-26 20:28:08.810441	30244	1087463.052050826	4	2
2014-03-25 16:44:30.184187	8359	20.0	1	8
2014-03-25 16:44:30.406211	8360	53	2	8
2014-03-25 16:44:32.751591	8361	354	3	2
2014-03-25 16:44:45.703698	8362	20.1	1	1
2014-03-25 16:44:45.928675	8363	53	2	1
2014-03-26 20:28:18.678277	30245	23.3	1	10
2014-03-26 20:28:18.903756	30246	41	2	10
2014-03-25 16:45:09.181973	8368	20.0	1	8
2014-03-25 16:45:09.416434	8369	53	2	8
2014-03-25 16:45:24.706497	8370	20.1	1	1
2014-03-25 16:45:24.929066	8371	53	2	1
2014-03-25 16:45:32.753845	8372	338	3	2
2014-03-26 20:28:20.572323	30247	627	3	2
2014-03-26 20:28:20.81446	30248	1087465.3501202685	4	2
2014-03-25 16:45:48.181831	8377	20.0	1	8
2014-03-25 16:45:48.411561	8378	53	2	8
2014-03-25 16:46:03.702311	8379	20.1	1	1
2014-03-25 16:46:03.936343	8380	53	2	1
2014-03-26 20:28:29.053156	30249	22.0	1	9
2014-03-26 20:28:29.280033	30250	48	2	9
2014-03-25 16:46:27.181967	8385	20.0	1	8
2014-03-25 16:46:27.405207	8386	53	2	8
2014-03-25 16:46:32.752001	8387	338	3	2
2014-03-25 16:46:42.704001	8388	20.1	1	1
2014-03-25 16:46:42.92829	8389	53	2	1
2014-03-25 16:46:56.611008	8390	305	3	2
2014-03-25 16:46:56.918143	8391	305	3	2
2014-03-26 20:28:30.140127	30251	22.1	1	8
2014-03-26 20:28:30.375133	30252	48	2	8
2014-03-25 16:47:06.180961	8396	20.0	1	8
2014-03-25 16:47:06.401953	8397	53	2	8
2014-03-25 16:47:08.74942	8398	338	3	2
2014-03-25 16:47:20.752904	8399	338	3	2
2014-03-25 16:47:21.700602	8400	20.1	1	1
2014-03-25 16:47:21.923248	8401	53	2	1
2014-03-25 16:47:32.750301	8402	338	3	2
2014-03-26 20:28:32.572632	30253	627	3	2
2014-03-26 20:28:32.797048	30254	1087467.6481897114	4	2
2014-03-25 16:47:45.181634	8407	20.0	1	8
2014-03-25 16:47:45.413145	8408	53	2	8
2014-03-25 16:48:00.703577	8409	20.1	1	1
2014-03-25 16:48:00.927314	8410	53	2	1
2014-03-26 20:28:44.752672	30255	20.8	1	1
2014-03-26 20:28:44.997696	30256	50	2	1
2014-03-25 16:48:24.182346	8415	20.0	1	8
2014-03-25 16:48:24.412664	8416	53	2	8
2014-03-25 16:48:32.749384	8417	305	3	2
2014-03-25 16:48:39.940185	8418	20.1	1	1
2014-03-25 16:48:40.163696	8419	53	2	1
2014-03-25 16:48:44.750218	8420	305	3	2
2014-03-25 16:48:56.751897	8421	338	3	2
2014-03-26 20:28:57.677451	30257	23.3	1	10
2014-03-25 16:49:03.180937	8426	20.0	1	8
2014-03-25 16:49:03.415417	8427	53	2	8
2014-03-25 16:49:08.752376	8428	305	3	2
2014-03-25 16:49:18.703748	8429	20.1	1	1
2014-03-25 16:49:18.926193	8430	53	2	1
2014-03-25 16:49:20.750339	8431	305	3	2
2014-03-25 16:49:32.749233	8432	370	3	2
2014-03-25 16:40:33.890238	8298	20.6	1	10
2014-03-25 16:40:34.113902	8299	52	2	10
2014-03-25 16:41:12.890577	8308	20.6	1	10
2014-03-25 16:41:13.122834	8309	52	2	10
2014-03-25 16:41:51.890898	8317	20.6	1	10
2014-03-25 16:41:52.112521	8318	52	2	10
2014-03-25 16:42:30.892535	8325	20.6	1	10
2014-03-25 16:42:31.115479	8326	52	2	10
2014-03-25 16:43:09.891926	8337	20.6	1	10
2014-03-25 16:43:10.126262	8338	52	2	10
2014-03-25 16:43:48.890915	8347	20.6	1	10
2014-03-25 16:43:49.121393	8348	52	2	10
2014-03-25 16:44:27.890543	8355	20.6	1	10
2014-03-25 16:44:28.113866	8356	52	2	10
2014-03-25 16:45:06.892531	8364	20.6	1	10
2014-03-25 16:45:07.127373	8365	52	2	10
2014-03-25 16:45:45.891404	8373	20.6	1	10
2014-03-25 16:45:46.114467	8374	52	2	10
2014-03-25 16:46:24.893296	8381	20.6	1	10
2014-03-25 16:46:25.117149	8382	52	2	10
2014-03-25 16:47:03.893006	8392	20.6	1	10
2014-03-25 16:47:04.117169	8393	52	2	10
2014-03-25 16:47:42.894676	8403	20.6	1	10
2014-03-25 16:47:43.119642	8404	52	2	10
2014-03-25 16:48:21.892619	8411	20.6	1	10
2014-03-25 16:48:22.128549	8412	52	2	10
2014-03-26 20:28:57.903042	30258	41	2	10
2014-03-26 20:29:08.052206	30259	22.0	1	9
2014-03-25 16:49:42.183759	8437	20.0	1	8
2014-03-25 16:49:42.426817	8438	53	2	8
2014-03-25 16:49:44.750539	8439	370	3	2
2014-03-25 16:49:57.699534	8440	20.1	1	1
2014-03-25 16:49:57.922664	8441	53	2	1
2014-03-26 20:29:08.289719	30260	48	2	9
2014-03-26 20:29:09.140696	30261	22.1	1	8
2014-03-25 16:50:21.182554	8446	20.0	1	8
2014-03-25 16:50:21.405185	8447	53	2	8
2014-03-25 16:50:32.751608	8448	354	3	2
2014-03-25 16:50:36.699521	8449	20.1	1	1
2014-03-25 16:50:36.93274	8450	53	2	1
2014-03-26 20:29:09.3664	30262	48	2	8
2014-03-26 20:29:23.750077	30263	20.8	1	1
2014-03-25 16:51:00.183401	8455	20.0	1	8
2014-03-25 16:51:00.406135	8456	53	2	8
2014-03-25 16:51:15.698922	8457	20.1	1	1
2014-03-25 16:51:15.933202	8458	53	2	1
2014-03-25 16:51:32.753598	8459	354	3	2
2014-03-26 20:29:23.991117	30264	50	2	1
2014-03-26 20:29:32.574674	30265	611	3	2
2014-03-25 16:51:39.184258	8464	20.0	1	8
2014-03-25 16:51:39.408639	8465	52	2	8
2014-03-25 16:51:54.699443	8466	20.1	1	1
2014-03-25 16:51:54.92287	8467	53	2	1
2014-03-26 20:29:32.800238	30266	1087477.9895022041	4	2
2014-03-26 20:29:36.680506	30267	23.3	1	10
2014-03-25 16:52:18.182644	8472	20.0	1	8
2014-03-25 16:52:18.413708	8473	52	2	8
2014-03-25 16:52:32.750948	8474	354	3	2
2014-03-25 16:52:33.699186	8475	20.1	1	1
2014-03-25 16:52:33.921147	8476	53	2	1
2014-03-26 20:29:36.91558	30268	41	2	10
2014-03-26 20:29:47.054181	30269	22.0	1	9
2014-03-25 16:52:57.181512	8481	20.0	1	8
2014-03-25 16:52:57.40316	8482	52	2	8
2014-03-25 16:53:12.698505	8483	20.1	1	1
2014-03-25 16:53:12.944629	8484	53	2	1
2014-03-25 16:53:32.750025	8485	354	3	2
2014-03-26 20:29:47.279102	30270	48	2	9
2014-03-26 20:29:48.140255	30271	22.1	1	8
2014-03-25 16:53:36.181963	8490	20.0	1	8
2014-03-25 16:53:36.413951	8491	52	2	8
2014-03-25 16:53:51.698994	8492	20.1	1	1
2014-03-25 16:53:51.921591	8493	53	2	1
2014-03-26 20:29:48.374823	30272	48	2	8
2014-03-26 20:30:02.745125	30273	20.8	1	1
2014-03-25 16:54:15.18114	8498	20.0	1	8
2014-03-25 16:54:15.414522	8499	52	2	8
2014-03-25 16:54:30.69595	8500	20.1	1	1
2014-03-25 16:54:30.917954	8501	53	2	1
2014-03-25 16:54:32.74831	8502	370	3	2
2014-03-26 20:30:02.972781	30274	50	2	1
2014-03-26 20:30:15.679266	30275	23.3	1	10
2014-03-25 16:54:54.184487	8507	20.0	1	8
2014-03-25 16:54:54.407345	8508	52	2	8
2014-03-25 16:54:56.751612	8509	305	3	2
2014-03-25 16:55:08.754426	8510	305	3	2
2014-03-25 16:55:09.698147	8511	20.1	1	1
2014-03-25 16:55:09.923684	8512	53	2	1
2014-03-25 16:55:20.751124	8513	338	3	2
2014-03-26 20:30:15.9153	30276	41	2	10
2014-03-26 20:30:26.052882	30277	22.0	1	9
2014-03-25 16:55:32.751326	8518	305	3	2
2014-03-25 16:55:33.18253	8519	20.0	1	8
2014-03-25 16:55:33.406798	8520	52	2	8
2014-03-25 16:55:44.753131	8521	338	3	2
2014-03-25 16:55:48.697236	8522	20.1	1	1
2014-03-25 16:55:48.925379	8523	53	2	1
2014-03-25 16:55:56.748411	8524	305	3	2
2014-03-25 16:56:08.752502	8525	305	3	2
2014-03-26 20:30:26.278145	30278	48	2	9
2014-03-26 20:30:27.13959	30279	22.1	1	8
2014-03-25 16:56:12.182751	8530	20.0	1	8
2014-03-25 16:56:12.416535	8531	52	2	8
2014-03-25 16:56:27.694333	8532	20.2	1	1
2014-03-25 16:56:27.91825	8533	53	2	1
2014-03-25 16:56:32.752402	8534	305	3	2
2014-03-26 20:30:27.372856	30280	48	2	8
2014-03-26 20:30:32.575611	30281	611	3	2
2014-03-25 16:56:51.183505	8539	20.0	1	8
2014-03-25 16:56:51.406062	8540	52	2	8
2014-03-25 16:57:06.695477	8541	20.2	1	1
2014-03-25 16:57:06.927877	8542	53	2	1
2014-03-26 20:30:32.801052	30282	1087488.3308146968	4	2
2014-03-26 20:30:41.749069	30283	20.8	1	1
2014-03-25 16:57:30.181875	8547	20.0	1	8
2014-03-25 16:57:30.405224	8548	52	2	8
2014-03-25 16:57:32.754674	8549	305	3	2
2014-03-25 16:57:45.697578	8550	20.2	1	1
2014-03-25 16:57:45.923566	8551	53	2	1
2014-03-26 20:30:41.986609	30284	50	2	1
2014-03-26 20:30:54.681727	30285	23.3	1	10
2014-03-25 16:58:09.182706	8556	20.0	1	8
2014-03-25 16:58:09.404442	8557	52	2	8
2014-03-25 16:58:24.697408	8558	20.2	1	1
2014-03-25 16:58:24.922518	8559	53	2	1
2014-03-25 16:58:32.750263	8560	305	3	2
2014-03-26 20:30:54.906468	30286	41	2	10
2014-03-25 16:58:48.181638	8565	20.0	1	8
2014-03-25 16:58:48.404621	8566	52	2	8
2014-03-25 16:59:03.696394	8567	20.2	1	1
2014-03-25 16:59:03.931305	8568	53	2	1
2014-03-25 16:49:39.892899	8433	20.6	1	10
2014-03-25 16:49:40.127064	8434	52	2	10
2014-03-25 16:50:18.892769	8442	20.6	1	10
2014-03-25 16:50:19.12077	8443	52	2	10
2014-03-25 16:50:57.892989	8451	20.6	1	10
2014-03-25 16:50:58.1153	8452	52	2	10
2014-03-25 16:51:36.894003	8460	20.7	1	10
2014-03-25 16:51:37.120464	8461	52	2	10
2014-03-25 16:52:15.895435	8468	20.7	1	10
2014-03-25 16:52:16.133646	8469	52	2	10
2014-03-25 16:52:54.895213	8477	20.7	1	10
2014-03-25 16:52:55.119251	8478	52	2	10
2014-03-25 16:53:33.894164	8486	20.7	1	10
2014-03-25 16:53:34.116207	8487	52	2	10
2014-03-25 16:54:12.893562	8494	20.7	1	10
2014-03-25 16:54:13.126909	8495	52	2	10
2014-03-25 16:54:51.895064	8503	20.7	1	10
2014-03-25 16:54:52.119659	8504	52	2	10
2014-03-25 16:55:30.895024	8514	20.7	1	10
2014-03-25 16:55:31.117108	8515	52	2	10
2014-03-25 16:56:10.102146	8526	20.7	1	10
2014-03-25 16:56:10.366975	8527	52	2	10
2014-03-25 16:56:48.896399	8535	20.7	1	10
2014-03-25 16:56:49.12256	8536	52	2	10
2014-03-25 16:57:27.893555	8543	20.7	1	10
2014-03-25 16:57:28.117262	8544	52	2	10
2014-03-25 16:58:06.895945	8552	20.7	1	10
2014-03-25 16:58:07.118651	8553	52	2	10
2014-03-26 20:31:05.051549	30287	22.0	1	9
2014-03-26 20:31:05.28633	30288	48	2	9
2014-03-25 16:59:27.182548	8573	20.0	1	8
2014-03-25 16:59:27.406467	8574	52	2	8
2014-03-25 16:59:32.750193	8575	305	3	2
2014-03-25 16:59:42.696095	8576	20.2	1	1
2014-03-25 16:59:42.918668	8577	53	2	1
2014-03-25 16:59:44.7517	8578	434	3	2
2014-03-25 16:59:56.752385	8579	434	3	2
2014-03-26 20:31:06.140242	30289	22.1	1	8
2014-03-26 20:31:06.363632	30290	48	2	8
2014-03-25 17:00:06.183695	8584	20.0	1	8
2014-03-25 17:00:06.406625	8585	52	2	8
2014-03-25 17:00:21.697292	8586	20.2	1	1
2014-03-25 17:00:21.930311	8587	53	2	1
2014-03-25 17:00:32.753582	8588	434	3	2
2014-03-26 20:31:20.749829	30291	20.8	1	1
2014-03-26 20:31:20.989663	30292	50	2	1
2014-03-25 17:00:44.752706	8593	2993	3	2
2014-03-25 17:00:45.181082	8594	20.0	1	8
2014-03-25 17:00:45.416303	8595	52	2	8
2014-03-25 17:00:56.7504	8596	2961	3	2
2014-03-25 17:01:00.695926	8597	20.2	1	1
2014-03-25 17:01:00.91802	8598	53	2	1
2014-03-25 17:01:08.750365	8599	3010	3	2
2014-03-25 17:01:20.753171	8600	3026	3	2
2014-03-26 20:31:32.576045	30293	627	3	2
2014-03-26 20:31:32.803604	30294	1087498.6721271896	4	2
2014-03-25 17:01:24.182098	8605	20.0	1	8
2014-03-25 17:01:24.415047	8606	52	2	8
2014-03-25 17:01:32.750042	8607	3010	3	2
2014-03-25 17:01:39.693902	8608	20.2	1	1
2014-03-25 17:01:39.918226	8609	53	2	1
2014-03-26 20:31:33.680717	30295	23.3	1	10
2014-03-26 20:31:33.921822	30296	41	2	10
2014-03-25 17:02:03.181508	8614	20.0	1	8
2014-03-25 17:02:03.405497	8615	52	2	8
2014-03-25 17:02:18.829992	8616	20.2	1	1
2014-03-25 17:02:19.245646	8617	53	2	1
2014-03-25 17:02:20.872583	8618	3042	3	2
2014-03-25 17:02:32.748564	8619	3122	3	2
2014-03-26 20:31:44.052233	30297	22.0	1	9
2014-03-26 20:31:44.277427	30298	48	2	9
2014-03-25 17:02:42.181672	8624	20.0	1	8
2014-03-25 17:02:42.414429	8625	52	2	8
2014-03-25 17:02:44.748501	8626	3042	3	2
2014-03-25 17:02:56.749795	8627	3122	3	2
2014-03-25 17:02:57.694845	8628	20.2	1	1
2014-03-25 17:02:57.927061	8629	53	2	1
2014-03-25 17:03:08.754155	8630	3042	3	2
2014-03-26 20:31:44.583752	30299	659	3	2
2014-03-26 20:31:44.82002	30300	1087499.8211619111	4	2
2014-03-25 17:03:20.751535	8635	3026	3	2
2014-03-25 17:03:21.181568	8636	20.0	1	8
2014-03-25 17:03:21.413023	8637	52	2	8
2014-03-25 17:03:32.752842	8638	515	3	2
2014-03-25 17:03:36.693328	8639	20.2	1	1
2014-03-25 17:03:36.91727	8640	53	2	1
2014-03-25 17:03:44.750273	8641	515	3	2
2014-03-26 20:31:45.140484	30301	22.2	1	8
2014-03-26 20:31:45.364025	30302	48	2	8
2014-03-25 17:04:00.181272	8646	20.0	1	8
2014-03-25 17:04:00.412249	8647	52	2	8
2014-03-25 17:04:15.693835	8648	20.2	1	1
2014-03-25 17:04:15.917801	8649	53	2	1
2014-03-25 17:04:32.750375	8650	515	3	2
2014-03-26 20:31:56.572626	30303	659	3	2
2014-03-26 20:31:56.822546	30304	1087502.119231354	4	2
2014-03-25 17:04:39.18129	8655	20.0	1	8
2014-03-25 17:04:39.404278	8656	52	2	8
2014-03-25 17:04:54.690835	8657	20.2	1	1
2014-03-25 17:04:54.959247	8658	53	2	1
2014-03-26 20:31:59.746603	30305	20.8	1	1
2014-03-26 20:31:59.975334	30306	50	2	1
2014-03-25 17:05:18.184001	8663	20.0	1	8
2014-03-25 17:05:18.439245	8664	52	2	8
2014-03-25 17:05:32.753128	8665	515	3	2
2014-03-25 17:05:33.692847	8666	20.2	1	1
2014-03-25 17:05:34.104699	8667	53	2	1
2014-03-26 20:32:12.679203	30307	23.3	1	10
2014-03-26 20:32:12.915677	30308	41	2	10
2014-03-25 17:05:57.183116	8672	20.0	1	8
2014-03-25 17:05:57.437222	8673	52	2	8
2014-03-25 17:06:12.69089	8674	20.1	1	1
2014-03-25 17:06:12.956771	8675	53	2	1
2014-03-25 17:06:20.75171	8676	466	3	2
2014-03-25 17:06:32.750977	8677	3042	3	2
2014-03-26 20:32:23.052933	30309	22.0	1	9
2014-03-26 20:32:23.277651	30310	48	2	9
2014-03-25 17:06:36.180772	8682	20.0	1	8
2014-03-25 17:06:36.403487	8683	52	2	8
2014-03-25 17:06:44.749381	8684	2993	3	2
2014-03-25 17:06:51.690371	8685	20.1	1	1
2014-03-25 17:06:51.91404	8686	53	2	1
2014-03-25 17:06:56.748609	8687	466	3	2
2014-03-25 17:07:08.748416	8688	515	3	2
2014-03-26 20:32:24.13987	30311	22.2	1	8
2014-03-26 20:32:24.37252	30312	48	2	8
2014-03-25 17:07:15.180554	8693	20.0	1	8
2014-03-25 17:07:15.410484	8694	52	2	8
2014-03-25 17:07:20.750962	8695	515	3	2
2014-03-25 17:07:30.689568	8696	20.1	1	1
2014-03-25 17:07:30.921995	8697	53	2	1
2014-03-25 17:07:32.746708	8698	515	3	2
2014-03-26 20:32:32.571757	30313	676	3	2
2014-03-25 17:07:54.177266	8703	20.0	1	8
2014-03-25 17:07:54.417239	8704	52	2	8
2014-03-25 16:59:24.895932	8569	20.7	1	10
2014-03-25 16:59:25.123505	8570	52	2	10
2014-03-25 17:00:03.896074	8580	20.7	1	10
2014-03-25 17:00:04.121571	8581	52	2	10
2014-03-25 17:00:42.897424	8589	20.7	1	10
2014-03-25 17:00:43.119989	8590	52	2	10
2014-03-25 17:01:21.897536	8601	20.7	1	10
2014-03-25 17:01:22.129751	8602	52	2	10
2014-03-25 17:02:00.89818	8610	20.7	1	10
2014-03-25 17:02:01.123498	8611	52	2	10
2014-03-25 17:02:39.898147	8620	20.7	1	10
2014-03-25 17:02:40.131949	8621	52	2	10
2014-03-25 17:03:18.897951	8631	20.7	1	10
2014-03-25 17:03:19.122288	8632	52	2	10
2014-03-25 17:03:57.899191	8642	20.7	1	10
2014-03-25 17:03:58.122008	8643	52	2	10
2014-03-25 17:04:36.896449	8651	20.7	1	10
2014-03-25 17:04:37.120139	8652	52	2	10
2014-03-25 17:05:15.899015	8659	20.7	1	10
2014-03-25 17:05:16.154457	8660	52	2	10
2014-03-25 17:05:54.898531	8668	20.7	1	10
2014-03-25 17:05:55.156848	8669	52	2	10
2014-03-25 17:06:33.901109	8678	20.7	1	10
2014-03-25 17:06:34.121512	8679	52	2	10
2014-03-25 17:07:12.898845	8689	20.7	1	10
2014-03-25 17:07:13.121168	8690	52	2	10
2014-03-25 17:08:09.68981	8705	20.1	1	1
2014-03-25 17:08:09.914126	8706	53	2	1
2014-03-26 20:32:32.797905	30314	1087509.0134396823	4	2
2014-03-26 20:32:38.771245	30315	20.8	1	1
2014-03-25 17:08:32.752344	8711	515	3	2
2014-03-25 17:08:33.18109	8712	20.0	1	8
2014-03-25 17:08:33.401564	8713	52	2	8
2014-03-25 17:08:48.689818	8714	20.1	1	1
2014-03-25 17:08:48.915634	8715	53	2	1
2014-03-26 20:32:39.00716	30316	50	2	1
2014-03-26 20:32:51.679216	30317	23.3	1	10
2014-03-25 17:09:12.180477	8720	20.0	1	8
2014-03-25 17:09:12.402982	8721	52	2	8
2014-03-25 17:09:20.749356	8722	418	3	2
2014-03-25 17:09:27.690883	8723	20.1	1	1
2014-03-25 17:09:27.91437	8724	53	2	1
2014-03-25 17:09:32.747814	8725	418	3	2
2014-03-25 17:09:44.753726	8726	466	3	2
2014-03-26 20:32:51.904264	30318	41	2	10
2014-03-26 20:33:02.053896	30319	22.0	1	9
2014-03-25 17:09:51.180936	8731	20.0	1	8
2014-03-25 17:09:51.411037	8732	52	2	8
2014-03-25 17:09:56.750797	8733	466	3	2
2014-03-25 17:10:06.689709	8734	20.1	1	1
2014-03-25 17:10:06.913243	8735	53	2	1
2014-03-26 20:33:02.288137	30320	48	2	9
2014-03-26 20:33:03.141099	30321	22.2	1	8
2014-03-25 17:10:30.181943	8740	20.0	1	8
2014-03-25 17:10:30.403673	8741	52	2	8
2014-03-25 17:10:32.748139	8742	482	3	2
2014-03-25 17:10:45.687643	8743	20.1	1	1
2014-03-25 17:10:45.911347	8744	53	2	1
2014-03-26 20:33:03.364773	30322	48	2	8
2014-03-26 20:33:08.576796	30323	595	3	2
2014-03-25 17:11:09.183721	8749	20.0	1	8
2014-03-25 17:11:09.414438	8750	52	2	8
2014-03-25 17:11:24.686743	8751	20.1	1	1
2014-03-25 17:11:24.907618	8752	53	2	1
2014-03-25 17:11:32.748566	8753	482	3	2
2014-03-26 20:33:08.811192	30324	1087515.9076480109	4	2
2014-03-26 20:33:17.751991	30325	20.8	1	1
2014-03-25 17:11:48.181832	8758	20.0	1	8
2014-03-25 17:11:48.404121	8759	52	2	8
2014-03-25 17:12:03.686922	8760	20.1	1	1
2014-03-25 17:12:03.918228	8761	53	2	1
2014-03-25 17:12:20.750065	8762	531	3	2
2014-03-26 20:33:17.976252	30326	50	2	1
2014-03-26 20:33:20.576814	30327	595	3	2
2014-03-25 17:12:27.181239	8767	20.0	1	8
2014-03-25 17:12:27.414006	8768	52	2	8
2014-03-25 17:12:32.747139	8769	515	3	2
2014-03-25 17:12:42.687624	8770	20.1	1	1
2014-03-25 17:12:42.913096	8771	53	2	1
2014-03-26 20:33:20.817292	30328	1087518.2057174537	4	2
2014-03-26 20:33:30.682278	30329	23.4	1	10
2014-03-25 17:13:06.182031	8776	20.0	1	8
2014-03-25 17:13:06.404177	8777	52	2	8
2014-03-25 17:13:21.683637	8778	20.1	1	1
2014-03-25 17:13:21.908729	8779	53	2	1
2014-03-25 17:13:32.747891	8780	515	3	2
2014-03-26 20:33:31.244024	30330	41	2	10
2014-03-26 20:33:32.5733	30331	595	3	2
2014-03-25 17:13:45.182129	8785	20.0	1	8
2014-03-25 17:13:45.414006	8786	52	2	8
2014-03-25 17:14:00.689517	8787	20.1	1	1
2014-03-25 17:14:00.912595	8788	53	2	1
2014-03-25 17:14:20.753392	8789	611	3	2
2014-03-26 20:33:32.846586	30332	1087519.354752175	4	2
2014-03-26 20:33:41.053056	30333	22.1	1	9
2014-03-25 17:14:24.182598	8794	20.0	1	8
2014-03-25 17:14:24.403918	8795	52	2	8
2014-03-25 17:14:39.48966	8796	611	3	2
2014-03-25 17:14:39.805	8797	20.1	1	1
2014-03-25 17:14:40.027866	8798	53	2	1
2014-03-26 20:33:41.464781	30334	48	2	9
2014-03-26 20:33:42.141924	30335	22.2	1	8
2014-03-25 17:15:03.182162	8803	20.0	1	8
2014-03-25 17:15:03.415225	8804	52	2	8
2014-03-25 17:15:18.680454	8805	20.2	1	1
2014-03-25 17:15:18.902752	8806	53	2	1
2014-03-25 17:15:32.750757	8807	611	3	2
2014-03-26 20:33:42.747745	30336	48	2	8
2014-03-26 20:33:56.780072	30337	20.8	1	1
2014-03-25 17:15:42.182856	8812	20.0	1	8
2014-03-25 17:15:42.405114	8813	52	2	8
2014-03-25 17:15:57.685436	8814	20.2	1	1
2014-03-25 17:15:57.916309	8815	53	2	1
2014-03-26 20:33:57.008102	30338	50	2	1
2014-03-26 20:34:09.682718	30339	23.4	1	10
2014-03-25 17:16:21.183764	8820	20.0	1	8
2014-03-25 17:16:21.406887	8821	52	2	8
2014-03-25 17:16:32.748192	8822	611	3	2
2014-03-25 17:16:36.684274	8823	20.2	1	1
2014-03-25 17:16:36.90598	8824	53	2	1
2014-03-26 20:34:09.918942	30340	41	2	10
2014-03-26 20:34:20.052016	30341	22.1	1	9
2014-03-25 17:17:00.184062	8829	20.0	1	8
2014-03-25 17:17:00.41625	8830	52	2	8
2014-03-25 17:17:15.682193	8831	20.2	1	1
2014-03-25 17:17:15.906446	8832	53	2	1
2014-03-25 17:17:32.747047	8833	611	3	2
2014-03-26 20:34:20.279412	30342	48	2	9
2014-03-25 17:17:39.180358	8838	20.0	1	8
2014-03-25 17:17:39.403835	8839	52	2	8
2014-03-25 17:17:54.68047	8840	20.2	1	1
2014-03-25 17:08:30.900633	8707	20.7	1	10
2014-03-25 17:08:31.132691	8708	52	2	10
2014-03-25 17:09:09.900691	8716	20.7	1	10
2014-03-25 17:09:10.124919	8717	52	2	10
2014-03-25 17:09:48.899657	8727	20.7	1	10
2014-03-25 17:09:49.129957	8728	52	2	10
2014-03-25 17:10:28.104613	8736	20.7	1	10
2014-03-25 17:10:28.329622	8737	52	2	10
2014-03-25 17:11:06.900007	8745	20.7	1	10
2014-03-25 17:11:07.143412	8746	52	2	10
2014-03-25 17:11:45.899985	8754	20.7	1	10
2014-03-25 17:11:46.121528	8755	52	2	10
2014-03-25 17:12:24.901803	8763	20.7	1	10
2014-03-25 17:12:25.123847	8764	52	2	10
2014-03-25 17:13:03.901664	8772	20.7	1	10
2014-03-25 17:13:04.124002	8773	52	2	10
2014-03-25 17:13:42.901805	8781	20.7	1	10
2014-03-25 17:13:43.124057	8782	52	2	10
2014-03-25 17:14:21.899864	8790	20.7	1	10
2014-03-25 17:14:22.120869	8791	52	2	10
2014-03-25 17:15:00.902644	8799	20.7	1	10
2014-03-25 17:15:01.133734	8800	52	2	10
2014-03-25 17:15:39.901963	8808	20.7	1	10
2014-03-25 17:15:40.126424	8809	52	2	10
2014-03-25 17:16:18.902634	8816	20.7	1	10
2014-03-25 17:16:19.125589	8817	52	2	10
2014-03-25 17:16:57.902615	8825	20.7	1	10
2014-03-25 17:16:58.133823	8826	52	2	10
2014-03-25 17:17:54.902436	8841	54	2	1
2014-03-25 17:18:08.750908	8842	579	3	2
2014-03-26 20:34:21.13954	30343	22.2	1	8
2014-03-26 20:34:21.376621	30344	48	2	8
2014-03-25 17:18:18.181732	8847	20.0	1	8
2014-03-25 17:18:18.403011	8848	52	2	8
2014-03-25 17:18:20.748251	8849	579	3	2
2014-03-25 17:18:32.749352	8850	547	3	2
2014-03-25 17:18:33.681622	8851	20.2	1	1
2014-03-25 17:18:33.903917	8852	54	2	1
2014-03-25 17:18:44.748018	8853	547	3	2
2014-03-26 20:34:32.573286	30345	595	3	2
2014-03-26 20:34:32.798109	30346	1087529.6960646678	4	2
2014-03-25 17:18:57.180762	8858	20.0	1	8
2014-03-25 17:18:57.409321	8859	52	2	8
2014-03-25 17:19:08.7537	8860	579	3	2
2014-03-25 17:19:12.683366	8861	20.2	1	1
2014-03-25 17:19:12.908279	8862	54	2	1
2014-03-25 17:19:20.753358	8863	579	3	2
2014-03-25 17:19:32.752541	8864	547	3	2
2014-03-26 20:34:35.744482	30347	20.8	1	1
2014-03-26 20:34:35.982178	30348	50	2	1
2014-03-25 17:19:36.182036	8869	20.0	1	8
2014-03-25 17:19:36.412548	8870	52	2	8
2014-03-25 17:19:44.748424	8871	595	3	2
2014-03-25 17:19:51.682595	8872	20.2	1	1
2014-03-25 17:19:51.907356	8873	54	2	1
2014-03-25 17:19:56.748885	8874	547	3	2
2014-03-25 17:20:08.752311	8875	547	3	2
2014-03-26 20:34:48.680749	30349	23.4	1	10
2014-03-26 20:34:48.905556	30350	41	2	10
2014-03-25 17:20:15.181542	8880	20.0	1	8
2014-03-25 17:20:15.41352	8881	52	2	8
2014-03-25 17:20:30.680619	8882	20.2	1	1
2014-03-25 17:20:30.906635	8883	54	2	1
2014-03-25 17:20:32.750013	8884	579	3	2
2014-03-25 17:20:44.749876	8885	547	3	2
2014-03-26 20:34:59.052517	30351	22.1	1	9
2014-03-26 20:34:59.297692	30352	48	2	9
2014-03-25 17:20:54.181978	8890	20.0	1	8
2014-03-25 17:20:54.413357	8891	52	2	8
2014-03-25 17:20:56.752705	8892	547	3	2
2014-03-25 17:21:09.67764	8893	20.2	1	1
2014-03-25 17:21:09.903497	8894	54	2	1
2014-03-26 20:35:00.140212	30353	22.2	1	8
2014-03-26 20:35:00.363047	30354	48	2	8
2014-03-25 17:21:32.747837	8899	579	3	2
2014-03-25 17:21:33.183428	8900	20.0	1	8
2014-03-25 17:21:33.405247	8901	52	2	8
2014-03-25 17:21:44.744785	8902	547	3	2
2014-03-25 17:21:48.681666	8903	20.2	1	1
2014-03-25 17:21:48.903508	8904	54	2	1
2014-03-25 17:21:56.752518	8905	579	3	2
2014-03-25 17:22:08.754294	8906	547	3	2
2014-03-26 20:35:14.744615	30355	20.8	1	1
2014-03-26 20:35:14.978536	30356	50	2	1
2014-03-25 17:22:12.181385	8911	20.0	1	8
2014-03-25 17:22:12.406568	8912	52	2	8
2014-03-25 17:22:20.748572	8913	547	3	2
2014-03-25 17:22:27.682336	8914	20.2	1	1
2014-03-25 17:22:27.905436	8915	54	2	1
2014-03-25 17:22:32.748152	8916	547	3	2
2014-03-25 17:22:44.74773	8917	579	3	2
2014-03-26 20:35:27.678973	30357	23.4	1	10
2014-03-26 20:35:27.904681	30358	41	2	10
2014-03-25 17:22:51.18155	8922	20.0	1	8
2014-03-25 17:22:51.403383	8923	52	2	8
2014-03-25 17:22:56.74787	8924	547	3	2
2014-03-25 17:23:06.682369	8925	20.3	1	1
2014-03-25 17:23:06.90477	8926	54	2	1
2014-03-25 17:23:08.74853	8927	547	3	2
2014-03-25 17:23:20.746382	8928	627	3	2
2014-03-26 20:35:32.574739	30359	579	3	2
2014-03-26 20:35:32.810487	30360	1087540.0373771605	4	2
2014-03-25 17:23:30.180904	8933	20.0	1	8
2014-03-25 17:23:30.402354	8934	52	2	8
2014-03-25 17:23:32.751011	8935	643	3	2
2014-03-25 17:23:45.681282	8936	20.3	1	1
2014-03-25 17:23:45.914625	8937	54	2	1
2014-03-26 20:35:38.051809	30361	22.1	1	9
2014-03-26 20:35:38.281582	30362	48	2	9
2014-03-25 17:24:08.744664	8942	692	3	2
2014-03-25 17:24:09.180586	8943	20.0	1	8
2014-03-25 17:24:09.403424	8944	52	2	8
2014-03-25 17:24:20.881062	8945	692	3	2
2014-03-25 17:24:24.810031	8946	20.3	1	1
2014-03-25 17:24:25.22996	8947	54	2	1
2014-03-25 17:24:32.751236	8948	692	3	2
2014-03-26 20:35:39.140427	30363	22.2	1	8
2014-03-26 20:35:39.375227	30364	48	2	8
2014-03-25 17:24:48.182208	8953	20.0	1	8
2014-03-25 17:24:48.403841	8954	52	2	8
2014-03-25 17:25:03.92141	8955	20.3	1	1
2014-03-25 17:25:04.144021	8956	54	2	1
2014-03-26 20:35:53.749858	30365	20.8	1	1
2014-03-26 20:35:53.974719	30366	50	2	1
2014-03-25 17:25:27.180778	8961	20.0	1	8
2014-03-25 17:25:27.413015	8962	53	2	8
2014-03-25 17:25:32.747834	8963	692	3	2
2014-03-25 17:25:42.678831	8964	20.3	1	1
2014-03-25 17:25:42.905591	8965	54	2	1
2014-03-26 20:36:06.683186	30367	23.4	1	10
2014-03-26 20:36:06.917731	30368	41	2	10
2014-03-26 20:36:17.052041	30369	22.1	1	9
2014-03-26 20:36:17.277002	30370	48	2	9
2014-03-25 17:26:06.181194	8970	20.0	1	8
2014-03-25 17:26:06.402661	8971	53	2	8
2014-03-25 17:26:21.680834	8972	20.4	1	1
2014-03-25 17:26:21.912311	8973	54	2	1
2014-03-25 17:26:32.746324	8974	692	3	2
2014-03-25 17:18:15.902995	8843	20.7	1	10
2014-03-25 17:18:16.124021	8844	52	2	10
2014-03-25 17:18:54.902654	8854	20.7	1	10
2014-03-25 17:18:55.12444	8855	52	2	10
2014-03-25 17:19:33.902375	8865	20.7	1	10
2014-03-25 17:19:34.133054	8866	52	2	10
2014-03-25 17:20:12.905367	8876	20.7	1	10
2014-03-25 17:20:13.146957	8877	52	2	10
2014-03-25 17:20:51.902407	8886	20.7	1	10
2014-03-25 17:20:52.126678	8887	52	2	10
2014-03-25 17:21:30.90411	8895	20.7	1	10
2014-03-25 17:21:31.129264	8896	52	2	10
2014-03-25 17:22:09.902431	8907	20.7	1	10
2014-03-25 17:22:10.124531	8908	52	2	10
2014-03-25 17:22:48.90282	8918	20.7	1	10
2014-03-25 17:22:49.127183	8919	52	2	10
2014-03-25 17:23:27.904411	8929	20.7	1	10
2014-03-25 17:23:28.127158	8930	52	2	10
2014-03-25 17:24:06.903465	8938	20.7	1	10
2014-03-25 17:24:07.126396	8939	52	2	10
2014-03-25 17:24:45.904305	8949	20.7	1	10
2014-03-25 17:24:46.126821	8950	52	2	10
2014-03-25 17:25:24.906078	8957	20.7	1	10
2014-03-25 17:25:25.139504	8958	52	2	10
2014-03-26 20:36:18.140715	30371	22.2	1	8
2014-03-26 20:36:18.373759	30372	48	2	8
2014-03-25 17:26:45.182659	8979	20.0	1	8
2014-03-25 17:26:45.413676	8980	53	2	8
2014-03-25 17:27:00.682782	8981	20.4	1	1
2014-03-25 17:27:00.905834	8982	54	2	1
2014-03-25 17:27:08.748249	8983	659	3	2
2014-03-25 17:27:20.746919	8984	659	3	2
2014-03-26 20:36:32.986132	30373	20.8	1	1
2014-03-26 20:36:33.210032	30374	50	2	1
2014-03-25 17:27:24.18404	8989	20.0	1	8
2014-03-25 17:27:24.405618	8990	53	2	8
2014-03-25 17:27:32.751625	8991	676	3	2
2014-03-25 17:27:39.679527	8992	20.4	1	1
2014-03-25 17:27:39.903589	8993	54	2	1
2014-03-26 20:36:45.679309	30375	23.4	1	10
2014-03-26 20:36:45.917044	30376	41	2	10
2014-03-25 17:28:03.182074	8998	20.0	1	8
2014-03-25 17:28:03.404612	8999	53	2	8
2014-03-25 17:28:18.681717	9000	20.4	1	1
2014-03-25 17:28:18.905176	9001	54	2	1
2014-03-25 17:28:32.747881	9002	659	3	2
2014-03-26 20:36:56.052628	30377	22.1	1	9
2014-03-26 20:36:56.277596	30378	48	2	9
2014-03-25 17:28:42.181535	9007	20.0	1	8
2014-03-25 17:28:42.414171	9008	53	2	8
2014-03-25 17:28:57.681488	9009	20.4	1	1
2014-03-25 17:28:57.903402	9010	54	2	1
2014-03-26 20:36:57.13995	30379	22.3	1	8
2014-03-26 20:36:57.374537	30380	48	2	8
2014-03-25 17:29:21.182067	9015	20.0	1	8
2014-03-25 17:29:21.413321	9016	53	2	8
2014-03-25 17:29:32.751465	9017	676	3	2
2014-03-25 17:29:36.678684	9018	20.4	1	1
2014-03-25 17:29:36.901134	9019	54	2	1
2014-03-26 20:37:11.74663	30381	20.8	1	1
2014-03-26 20:37:11.974478	30382	50	2	1
2014-03-25 17:30:00.181538	9024	20.0	1	8
2014-03-25 17:30:00.403887	9025	53	2	8
2014-03-25 17:30:15.674958	9026	20.5	1	1
2014-03-25 17:30:15.908807	9027	54	2	1
2014-03-25 17:30:36.705683	9028	676	3	2
2014-03-26 20:37:20.575331	30383	515	3	2
2014-03-26 20:37:20.811755	30384	1087557.2728979818	4	2
2014-03-25 17:30:39.181498	9033	20.1	1	8
2014-03-25 17:30:39.412759	9034	53	2	8
2014-03-25 17:30:54.674515	9035	20.5	1	1
2014-03-25 17:30:54.899814	9036	54	2	1
2014-03-26 20:37:24.680557	30385	23.4	1	10
2014-03-26 20:37:24.906801	30386	41	2	10
2014-03-25 17:31:18.181123	9041	20.1	1	8
2014-03-25 17:31:18.413366	9042	53	2	8
2014-03-25 17:31:32.748463	9043	627	3	2
2014-03-25 17:31:33.676889	9044	20.5	1	1
2014-03-25 17:31:33.898279	9045	54	2	1
2014-03-25 17:31:44.801614	9046	611	3	2
2014-03-26 20:37:32.57331	30387	531	3	2
2014-03-26 20:37:32.809992	30388	1087559.5709674247	4	2
2014-03-25 17:31:57.182144	9051	20.1	1	8
2014-03-25 17:31:57.404109	9052	53	2	8
2014-03-25 17:32:12.678641	9053	20.5	1	1
2014-03-25 17:32:12.902209	9054	54	2	1
2014-03-25 17:32:32.747665	9055	611	3	2
2014-03-26 20:37:35.061995	30389	22.1	1	9
2014-03-26 20:37:35.285747	30390	48	2	9
2014-03-25 17:32:36.182016	9060	20.1	1	8
2014-03-25 17:32:36.404614	9061	53	2	8
2014-03-25 17:32:51.672767	9062	20.6	1	1
2014-03-25 17:32:51.906101	9063	54	2	1
2014-03-26 20:37:36.139767	30391	22.3	1	8
2014-03-26 20:37:36.373811	30392	48	2	8
2014-03-25 17:33:15.180167	9068	20.1	1	8
2014-03-25 17:33:15.458323	9069	53	2	8
2014-03-25 17:33:30.673317	9070	20.6	1	1
2014-03-25 17:33:30.905373	9071	54	2	1
2014-03-25 17:33:32.749808	9072	627	3	2
2014-03-26 20:37:50.74437	30393	20.8	1	1
2014-03-26 20:37:50.970957	30394	50	2	1
2014-03-25 17:33:54.180999	9077	20.1	1	8
2014-03-25 17:33:54.4157	9078	53	2	8
2014-03-25 17:34:09.675822	9079	20.6	1	1
2014-03-25 17:34:09.897425	9080	54	2	1
2014-03-26 20:38:03.681058	30395	23.5	1	10
2014-03-26 20:38:03.916433	30396	41	2	10
2014-03-25 17:34:32.748598	9085	611	3	2
2014-03-25 17:34:33.180778	9086	20.1	1	8
2014-03-25 17:34:33.404859	9087	53	2	8
2014-03-25 17:34:48.676295	9088	20.6	1	1
2014-03-25 17:34:48.898686	9089	54	2	1
2014-03-26 20:38:14.052687	30397	22.1	1	9
2014-03-26 20:38:14.277702	30398	48	2	9
2014-03-25 17:35:12.181903	9094	20.1	1	8
2014-03-25 17:35:12.404414	9095	53	2	8
2014-03-25 17:35:27.675325	9096	20.7	1	1
2014-03-25 17:35:27.908981	9097	54	2	1
2014-03-25 17:35:32.750183	9098	611	3	2
2014-03-26 20:38:15.141082	30399	22.3	1	8
2014-03-25 17:35:51.180721	9103	20.2	1	8
2014-03-25 17:35:51.411802	9104	53	2	8
2014-03-25 17:36:06.675158	9105	20.7	1	1
2014-03-25 17:36:06.900642	9106	55	2	1
2014-03-25 17:36:30.18121	9111	20.2	1	8
2014-03-25 17:36:30.413338	9112	53	2	8
2014-03-25 17:27:21.905256	8985	20.7	1	10
2014-03-25 17:27:22.127072	8986	52	2	10
2014-03-25 17:28:00.904376	8994	20.7	1	10
2014-03-25 17:28:01.127456	8995	52	2	10
2014-03-25 17:28:39.905956	9003	20.7	1	10
2014-03-25 17:28:40.138711	9004	52	2	10
2014-03-25 17:29:18.906002	9011	20.8	1	10
2014-03-25 17:29:19.149903	9012	52	2	10
2014-03-25 17:29:57.906923	9020	20.8	1	10
2014-03-25 17:29:58.130392	9021	52	2	10
2014-03-25 17:30:37.016317	9029	20.8	1	10
2014-03-25 17:30:37.239117	9030	52	2	10
2014-03-25 17:31:15.906462	9037	20.8	1	10
2014-03-25 17:31:16.142038	9038	52	2	10
2014-03-25 17:31:54.908086	9047	20.8	1	10
2014-03-25 17:31:55.132425	9048	52	2	10
2014-03-25 17:32:33.906294	9056	20.8	1	10
2014-03-25 17:32:34.128059	9057	52	2	10
2014-03-25 17:33:12.907746	9064	20.8	1	10
2014-03-25 17:33:13.130091	9065	52	2	10
2014-03-25 17:33:51.907491	9073	20.8	1	10
2014-03-25 17:33:52.130916	9074	52	2	10
2014-03-25 17:34:30.907697	9081	20.8	1	10
2014-03-25 17:34:31.140014	9082	52	2	10
2014-03-25 17:35:09.90883	9090	20.8	1	10
2014-03-25 17:35:10.130659	9091	52	2	10
2014-03-25 17:35:48.908849	9099	20.8	1	10
2014-03-25 17:35:49.152363	9100	52	2	10
2014-03-25 17:36:27.909974	9107	20.8	1	10
2014-03-25 17:36:28.142268	9108	52	2	10
2014-03-25 17:36:45.478065	9113	627	3	2
2014-03-25 17:36:45.785796	9114	20.7	1	1
2014-03-25 17:36:46.010952	9115	55	2	1
2014-03-26 20:38:15.38517	30400	48	2	8
2014-03-26 20:38:29.778725	30401	20.8	1	1
2014-03-25 17:37:09.180886	9120	20.2	1	8
2014-03-25 17:37:09.403005	9121	54	2	8
2014-03-25 17:37:24.671832	9122	20.8	1	1
2014-03-25 17:37:24.903637	9123	55	2	1
2014-03-25 17:37:32.747576	9124	627	3	2
2014-03-25 17:37:44.749791	9125	547	3	2
2014-03-26 20:38:30.003748	30402	50	2	1
2014-03-26 20:38:32.5731	30403	547	3	2
2014-03-25 17:37:48.183773	9130	20.2	1	8
2014-03-25 17:37:48.415715	9131	54	2	8
2014-03-25 17:37:56.747459	9132	595	3	2
2014-03-25 17:38:03.673041	9133	20.8	1	1
2014-03-25 17:38:03.895808	9134	55	2	1
2014-03-25 17:38:08.75222	9135	595	3	2
2014-03-26 20:38:32.807979	30404	1087567.6142104745	4	2
2014-03-26 20:38:42.681567	30405	23.5	1	10
2014-03-25 17:38:27.180058	9140	20.2	1	8
2014-03-25 17:38:27.403478	9141	54	2	8
2014-03-25 17:38:32.750521	9142	595	3	2
2014-03-25 17:38:42.674477	9143	20.8	1	1
2014-03-25 17:38:42.896591	9144	55	2	1
2014-03-26 20:38:42.906649	30406	41	2	10
2014-03-26 20:38:53.050539	30407	22.1	1	9
2014-03-25 17:39:06.181661	9149	20.2	1	8
2014-03-25 17:39:06.416636	9150	54	2	8
2014-03-25 17:39:21.67249	9151	20.8	1	1
2014-03-25 17:39:21.894733	9152	55	2	1
2014-03-25 17:39:32.750651	9153	595	3	2
2014-03-26 20:38:53.285402	30408	48	2	9
2014-03-26 20:38:54.141295	30409	22.3	1	8
2014-03-25 17:39:45.181568	9158	20.3	1	8
2014-03-25 17:39:45.403673	9159	54	2	8
2014-03-25 17:40:00.673784	9160	20.8	1	1
2014-03-25 17:40:00.90538	9161	55	2	1
2014-03-26 20:38:54.365509	30410	48	2	8
2014-03-26 20:39:08.427975	30411	515	3	2
2014-03-25 17:40:24.182226	9166	20.3	1	8
2014-03-25 17:40:24.405479	9167	54	2	8
2014-03-25 17:40:32.752712	9168	595	3	2
2014-03-25 17:40:39.712455	9169	20.9	1	1
2014-03-25 17:40:39.95468	9170	55	2	1
2014-03-26 20:39:08.665447	30412	1087571.0613146387	4	2
2014-03-26 20:39:08.99551	30413	20.7	1	1
2014-03-25 17:41:03.180722	9175	20.3	1	8
2014-03-25 17:41:03.402713	9176	54	2	8
2014-03-25 17:41:18.672533	9177	20.9	1	1
2014-03-25 17:41:18.897995	9178	55	2	1
2014-03-25 17:41:32.747672	9179	595	3	2
2014-03-26 20:39:09.221321	30414	50	2	1
2014-03-26 20:39:21.681392	30415	23.5	1	10
2014-03-25 17:41:42.181788	9184	20.3	1	8
2014-03-25 17:41:42.415789	9185	54	2	8
2014-03-25 17:41:57.670499	9186	20.9	1	1
2014-03-25 17:41:57.893876	9187	55	2	1
2014-03-26 20:39:21.915519	30416	41	2	10
2014-03-26 20:39:32.051939	30417	22.1	1	9
2014-03-25 17:42:21.182324	9192	20.3	1	8
2014-03-25 17:42:21.428021	9193	54	2	8
2014-03-25 17:42:32.749204	9194	611	3	2
2014-03-25 17:42:36.67018	9195	20.9	1	1
2014-03-25 17:42:36.892076	9196	55	2	1
2014-03-26 20:39:32.27722	30418	48	2	9
2014-03-26 20:39:32.583354	30419	515	3	2
2014-03-25 17:43:00.183378	9201	20.3	1	8
2014-03-25 17:43:00.4054	9202	54	2	8
2014-03-25 17:43:15.727823	9203	21.0	1	1
2014-03-25 17:43:15.96132	9204	54	2	1
2014-03-25 17:43:32.748958	9205	595	3	2
2014-03-26 20:39:32.817054	30420	1087576.806488246	4	2
2014-03-26 20:39:33.139937	30421	22.3	1	8
2014-03-25 17:43:39.180758	9210	20.4	1	8
2014-03-25 17:43:39.406876	9211	54	2	8
2014-03-25 17:43:54.709684	9212	21.0	1	1
2014-03-25 17:43:54.934062	9213	54	2	1
2014-03-25 17:43:56.753163	9214	531	3	2
2014-03-25 17:44:08.749242	9215	531	3	2
2014-03-26 20:39:33.364336	30422	48	2	8
2014-03-26 20:39:47.744047	30423	20.7	1	1
2014-03-25 17:44:18.180234	9220	20.4	1	8
2014-03-25 17:44:18.403526	9221	54	2	8
2014-03-25 17:44:32.748091	9222	531	3	2
2014-03-25 17:44:33.667723	9223	21.0	1	1
2014-03-25 17:44:33.891412	9224	54	2	1
2014-03-26 20:39:47.978057	30424	50	2	1
2014-03-26 20:40:00.680191	30425	23.5	1	10
2014-03-25 17:44:57.18051	9229	20.4	1	8
2014-03-25 17:44:57.403148	9230	54	2	8
2014-03-25 17:45:12.668632	9231	21.0	1	1
2014-03-25 17:45:12.891737	9232	54	2	1
2014-03-25 17:45:32.746495	9233	531	3	2
2014-03-26 20:40:00.904355	30426	41	2	10
2014-03-26 20:40:11.051106	30427	22.1	1	9
2014-03-25 17:45:36.180217	9238	20.4	1	8
2014-03-25 17:45:36.402489	9239	54	2	8
2014-03-25 17:45:51.669957	9240	21.0	1	1
2014-03-25 17:45:51.902279	9241	54	2	1
2014-03-26 20:40:11.284915	30428	48	2	9
2014-03-25 17:46:15.179609	9246	20.4	1	8
2014-03-25 17:46:15.40173	9247	55	2	8
2014-03-25 17:46:30.667568	9248	21.1	1	1
2014-03-25 17:37:06.909954	9116	20.9	1	10
2014-03-25 17:37:07.134006	9117	52	2	10
2014-03-25 17:37:45.909285	9126	20.9	1	10
2014-03-25 17:37:46.149432	9127	52	2	10
2014-03-25 17:38:24.909652	9136	20.9	1	10
2014-03-25 17:38:25.132218	9137	52	2	10
2014-03-25 17:39:04.115532	9145	20.9	1	10
2014-03-25 17:39:04.360981	9146	52	2	10
2014-03-25 17:39:43.112632	9154	20.9	1	10
2014-03-25 17:39:43.334864	9155	52	2	10
2014-03-25 17:40:21.909857	9162	20.9	1	10
2014-03-25 17:40:22.133242	9163	52	2	10
2014-03-25 17:41:00.909581	9171	20.9	1	10
2014-03-25 17:41:01.133357	9172	52	2	10
2014-03-25 17:41:39.913961	9180	20.9	1	10
2014-03-25 17:41:40.146476	9181	52	2	10
2014-03-25 17:42:18.909986	9188	20.9	1	10
2014-03-25 17:42:19.145037	9189	52	2	10
2014-03-25 17:42:57.911824	9197	20.9	1	10
2014-03-25 17:42:58.137404	9198	52	2	10
2014-03-25 17:43:36.909443	9206	20.9	1	10
2014-03-25 17:43:37.132753	9207	52	2	10
2014-03-25 17:44:15.912307	9216	20.9	1	10
2014-03-25 17:44:16.135071	9217	52	2	10
2014-03-25 17:44:54.910882	9225	20.9	1	10
2014-03-25 17:44:55.133374	9226	52	2	10
2014-03-25 17:45:33.912429	9234	20.9	1	10
2014-03-25 17:45:34.134569	9235	52	2	10
2014-03-25 17:46:30.90279	9249	54	2	1
2014-03-25 17:46:32.754213	9250	531	3	2
2014-03-26 20:40:12.140116	30429	22.3	1	8
2014-03-26 20:40:12.366565	30430	48	2	8
2014-03-25 17:46:54.180764	9255	20.4	1	8
2014-03-25 17:46:54.412454	9256	55	2	8
2014-03-25 17:47:09.707967	9257	21.1	1	1
2014-03-25 17:47:09.933557	9258	54	2	1
2014-03-26 20:40:26.743808	30431	20.7	1	1
2014-03-26 20:40:26.978598	30432	50	2	1
2014-03-25 17:47:32.749298	9263	547	3	2
2014-03-25 17:47:33.179751	9264	20.5	1	8
2014-03-25 17:47:33.402696	9265	55	2	8
2014-03-25 17:47:48.668646	9266	21.1	1	1
2014-03-25 17:47:48.893208	9267	54	2	1
2014-03-26 20:40:32.572253	30433	547	3	2
2014-03-26 20:40:32.79651	30434	1087585.9987660171	4	2
2014-03-25 17:48:12.181568	9272	20.5	1	8
2014-03-25 17:48:12.403301	9273	55	2	8
2014-03-25 17:48:27.705938	9274	21.1	1	1
2014-03-25 17:48:27.928703	9275	54	2	1
2014-03-25 17:48:32.74591	9276	547	3	2
2014-03-26 20:40:39.681003	30435	23.5	1	10
2014-03-26 20:40:39.916163	30436	41	2	10
2014-03-25 17:48:51.18426	9281	20.5	1	8
2014-03-25 17:48:51.406787	9282	55	2	8
2014-03-25 17:49:06.666592	9283	21.1	1	1
2014-03-25 17:49:06.891415	9284	54	2	1
2014-03-26 20:40:44.574249	30437	531	3	2
2014-03-26 20:40:44.79893	30438	1087587.1478007387	4	2
2014-03-25 17:49:30.182693	9289	20.5	1	8
2014-03-25 17:49:30.406281	9290	55	2	8
2014-03-25 17:49:32.746174	9291	531	3	2
2014-03-25 17:49:45.665173	9292	21.2	1	1
2014-03-25 17:49:45.888208	9293	54	2	1
2014-03-25 17:49:56.748552	9294	611	3	2
2014-03-26 20:40:50.051317	30439	22.1	1	9
2014-03-26 20:40:50.292925	30440	48	2	9
2014-03-25 17:50:09.073913	9299	595	3	2
2014-03-25 17:50:09.660966	9300	20.5	1	8
2014-03-25 17:50:10.079961	9301	55	2	8
2014-03-25 17:50:24.667534	9302	21.2	1	1
2014-03-25 17:50:24.891197	9303	55	2	1
2014-03-25 17:50:32.750372	9304	595	3	2
2014-03-26 20:40:51.14237	30441	22.3	1	8
2014-03-26 20:40:51.365375	30442	48	2	8
2014-03-25 17:50:48.180113	9309	20.5	1	8
2014-03-25 17:50:48.401353	9310	55	2	8
2014-03-25 17:51:03.666458	9311	21.2	1	1
2014-03-25 17:51:03.898468	9312	55	2	1
2014-03-26 20:41:05.743238	30443	20.7	1	1
2014-03-26 20:41:05.978868	30444	50	2	1
2014-03-25 17:51:27.179838	9317	20.5	1	8
2014-03-25 17:51:27.402506	9318	55	2	8
2014-03-25 17:51:42.466712	9319	595	3	2
2014-03-25 17:51:42.787225	9320	21.2	1	1
2014-03-25 17:51:43.009123	9321	55	2	1
2014-03-26 20:41:18.683061	30445	23.5	1	10
2014-03-26 20:41:18.90757	30446	41	2	10
2014-03-25 17:52:06.179853	9326	20.5	1	8
2014-03-25 17:52:06.423379	9327	55	2	8
2014-03-25 17:52:21.665088	9328	21.2	1	1
2014-03-25 17:52:21.888305	9329	55	2	1
2014-03-25 17:52:32.748747	9330	595	3	2
2014-03-26 20:41:29.052044	30447	22.1	1	9
2014-03-26 20:41:29.297087	30448	48	2	9
2014-03-25 17:52:45.180641	9335	20.6	1	8
2014-03-25 17:52:45.455571	9336	55	2	8
2014-03-25 17:53:00.701398	9337	21.2	1	1
2014-03-25 17:53:00.923994	9338	55	2	1
2014-03-26 20:41:30.140234	30449	22.4	1	8
2014-03-26 20:41:30.363231	30450	48	2	8
2014-03-25 17:53:24.18115	9343	20.6	1	8
2014-03-25 17:53:24.403618	9344	55	2	8
2014-03-25 17:53:32.744771	9345	611	3	2
2014-03-25 17:53:39.66536	9346	21.2	1	1
2014-03-25 17:53:39.889271	9347	55	2	1
2014-03-26 20:41:32.571577	30451	515	3	2
2014-03-26 20:41:32.807061	30452	1087594.042009067	4	2
2014-03-25 17:54:03.182508	9352	20.6	1	8
2014-03-25 17:54:03.414213	9353	55	2	8
2014-03-25 17:54:18.664128	9354	21.2	1	1
2014-03-25 17:54:18.887739	9355	55	2	1
2014-03-25 17:54:32.745826	9356	595	3	2
2014-03-26 20:41:44.744285	30453	20.7	1	1
2014-03-26 20:41:44.969232	30454	50	2	1
2014-03-25 17:54:42.181548	9361	20.6	1	8
2014-03-25 17:54:42.404433	9362	55	2	8
2014-03-25 17:54:57.66508	9363	21.2	1	1
2014-03-25 17:54:57.898306	9364	55	2	1
2014-03-26 20:41:56.570811	30455	547	3	2
2014-03-26 20:41:56.808129	30456	1087598.6381479527	4	2
2014-03-25 17:55:21.179891	9369	20.6	1	8
2014-03-25 17:55:21.411269	9370	55	2	8
2014-03-25 17:55:32.7493	9371	547	3	2
2014-03-25 17:55:36.663172	9372	21.2	1	1
2014-03-25 17:55:36.886534	9373	55	2	1
2014-03-25 17:55:44.747542	9374	531	3	2
2014-03-26 20:41:57.684505	30457	23.5	1	10
2014-03-26 20:41:57.930728	30458	41	2	10
2014-03-25 17:56:00.180578	9379	20.6	1	8
2014-03-25 17:56:00.403176	9380	55	2	8
2014-03-25 17:56:15.665448	9381	21.2	1	1
2014-03-25 17:56:15.89722	9382	55	2	1
2014-03-25 17:56:32.749775	9383	531	3	2
2014-03-25 17:46:51.914112	9251	21.0	1	10
2014-03-25 17:46:52.145441	9252	51	2	10
2014-03-25 17:47:30.911614	9259	21.0	1	10
2014-03-25 17:47:31.145621	9260	51	2	10
2014-03-25 17:48:09.911063	9268	21.0	1	10
2014-03-25 17:48:10.135573	9269	51	2	10
2014-03-25 17:48:48.912855	9277	21.0	1	10
2014-03-25 17:48:49.136076	9278	51	2	10
2014-03-25 17:49:27.913521	9285	21.0	1	10
2014-03-25 17:49:28.13527	9286	51	2	10
2014-03-25 17:50:07.039974	9295	21.0	1	10
2014-03-25 17:50:07.469951	9296	51	2	10
2014-03-25 17:50:45.912901	9305	21.0	1	10
2014-03-25 17:50:46.136413	9306	51	2	10
2014-03-25 17:51:24.913644	9313	21.0	1	10
2014-03-25 17:51:25.137418	9314	51	2	10
2014-03-25 17:52:03.914489	9322	21.0	1	10
2014-03-25 17:52:04.147871	9323	51	2	10
2014-03-25 17:52:42.91605	9331	21.0	1	10
2014-03-25 17:52:43.139303	9332	51	2	10
2014-03-25 17:53:21.913732	9339	21.0	1	10
2014-03-25 17:53:22.137498	9340	51	2	10
2014-03-25 17:54:00.914638	9348	21.0	1	10
2014-03-25 17:54:01.140553	9349	51	2	10
2014-03-25 17:54:39.914464	9357	21.0	1	10
2014-03-25 17:54:40.136963	9358	51	2	10
2014-03-25 17:55:18.914374	9365	21.0	1	10
2014-03-25 17:55:19.137672	9366	51	2	10
2014-03-26 20:42:08.052033	30459	22.1	1	9
2014-03-26 20:42:08.289027	30460	48	2	9
2014-03-25 17:56:39.181342	9388	20.6	1	8
2014-03-25 17:56:39.413276	9389	55	2	8
2014-03-25 17:56:54.662841	9390	21.2	1	1
2014-03-25 17:56:54.886907	9391	55	2	1
2014-03-26 20:42:08.596252	30461	531	3	2
2014-03-26 20:42:08.822045	30462	1087599.7871826743	4	2
2014-03-25 17:57:18.182338	9396	20.6	1	8
2014-03-25 17:57:18.420025	9397	55	2	8
2014-03-25 17:57:32.746032	9398	531	3	2
2014-03-25 17:57:33.662907	9399	21.2	1	1
2014-03-25 17:57:33.885778	9400	55	2	1
2014-03-26 20:42:09.139523	30463	22.4	1	8
2014-03-26 20:42:09.374642	30464	48	2	8
2014-03-25 17:57:57.181005	9405	20.7	1	8
2014-03-25 17:57:57.404138	9406	55	2	8
2014-03-25 17:58:12.658718	9407	21.2	1	1
2014-03-25 17:58:12.892032	9408	55	2	1
2014-03-25 17:58:32.744056	9409	531	3	2
2014-03-26 20:42:23.739545	30465	20.7	1	1
2014-03-26 20:42:23.968681	30466	50	2	1
2014-03-25 17:58:36.181455	9414	20.7	1	8
2014-03-25 17:58:36.423984	9415	55	2	8
2014-03-25 17:58:51.663681	9416	21.2	1	1
2014-03-25 17:58:51.888244	9417	55	2	1
2014-03-26 20:42:32.571203	30467	531	3	2
2014-03-26 20:42:32.806564	30468	1087603.2342868384	4	2
2014-03-25 17:59:15.182392	9422	20.7	1	8
2014-03-25 17:59:15.416526	9423	55	2	8
2014-03-25 17:59:30.661197	9424	21.2	1	1
2014-03-25 17:59:30.886944	9425	55	2	1
2014-03-25 17:59:32.740935	9426	531	3	2
2014-03-26 20:42:36.682328	30469	23.5	1	10
2014-03-26 20:42:36.908465	30470	41	2	10
2014-03-25 17:59:54.178888	9431	20.7	1	8
2014-03-25 17:59:54.403524	9432	55	2	8
2014-03-25 18:00:09.659201	9433	21.2	1	1
2014-03-25 18:00:09.894243	9434	55	2	1
2014-03-26 20:42:47.050132	30471	22.1	1	9
2014-03-26 20:42:47.285662	30472	48	2	9
2014-03-25 18:00:32.74756	9439	531	3	2
2014-03-25 18:00:33.180046	9440	20.7	1	8
2014-03-25 18:00:33.405	9441	55	2	8
2014-03-25 18:00:48.661748	9442	21.2	1	1
2014-03-25 18:00:48.885464	9443	55	2	1
2014-03-26 20:42:48.140329	30473	22.4	1	8
2014-03-26 20:42:48.365815	30474	48	2	8
2014-03-25 18:01:12.180845	9448	20.7	1	8
2014-03-25 18:01:12.41289	9449	55	2	8
2014-03-25 18:01:27.665607	9450	21.2	1	1
2014-03-25 18:01:27.889466	9451	55	2	1
2014-03-25 18:01:32.744674	9452	595	3	2
2014-03-25 18:01:44.748208	9453	595	3	2
2014-03-26 20:43:02.743268	30475	20.7	1	1
2014-03-26 20:43:02.980366	30476	50	2	1
2014-03-25 18:01:51.17969	9458	20.7	1	8
2014-03-25 18:01:51.422844	9459	55	2	8
2014-03-25 18:02:06.661886	9460	21.2	1	1
2014-03-25 18:02:06.883902	9461	55	2	1
2014-03-26 20:43:15.682487	30477	23.5	1	10
2014-03-26 20:43:15.96492	30478	41	2	10
2014-03-25 18:02:30.180384	9466	20.7	1	8
2014-03-25 18:02:30.401725	9467	55	2	8
2014-03-25 18:02:32.750782	9468	595	3	2
2014-03-25 18:02:45.697828	9469	21.2	1	1
2014-03-25 18:02:45.943376	9470	55	2	1
2014-03-26 20:43:26.052842	30479	22.1	1	9
2014-03-26 20:43:26.287951	30480	48	2	9
2014-03-25 18:03:09.180722	9475	20.7	1	8
2014-03-25 18:03:09.411208	9476	55	2	8
2014-03-25 18:03:24.658012	9477	21.2	1	1
2014-03-25 18:03:24.880345	9478	55	2	1
2014-03-25 18:03:32.745812	9479	611	3	2
2014-03-26 20:43:27.139441	30481	22.4	1	8
2014-03-26 20:43:27.364707	30482	48	2	8
2014-03-25 18:03:48.182458	9484	20.7	1	8
2014-03-25 18:03:48.403591	9485	56	2	8
2014-03-25 18:04:03.69516	9486	21.2	1	1
2014-03-25 18:04:03.927197	9487	55	2	1
2014-03-26 20:43:32.572037	30483	531	3	2
2014-03-26 20:43:32.806663	30484	1087612.4265646096	4	2
2014-03-25 18:04:27.182639	9492	20.7	1	8
2014-03-25 18:04:27.404367	9493	56	2	8
2014-03-25 18:04:42.459231	9494	595	3	2
2014-03-25 18:04:42.776476	9495	21.2	1	1
2014-03-25 18:04:43.000317	9496	55	2	1
2014-03-26 20:43:41.740825	30485	20.7	1	1
2014-03-26 20:43:41.965886	30486	50	2	1
2014-03-25 18:05:06.179502	9501	20.7	1	8
2014-03-25 18:05:06.413411	9502	56	2	8
2014-03-25 18:05:21.654424	9503	21.2	1	1
2014-03-25 18:05:21.882209	9504	55	2	1
2014-03-25 18:05:32.748019	9505	595	3	2
2014-03-26 20:43:54.682833	30487	23.6	1	10
2014-03-26 20:43:54.917574	30488	41	2	10
2014-03-25 18:05:45.180584	9510	20.7	1	8
2014-03-25 18:05:45.403768	9511	56	2	8
2014-03-25 18:06:00.659286	9512	21.2	1	1
2014-03-25 18:06:00.891235	9513	55	2	1
2014-03-25 18:06:24.183272	9518	20.8	1	8
2014-03-25 18:06:24.403727	9519	56	2	8
2014-03-25 18:06:32.744723	9520	611	3	2
2014-03-25 17:56:37.138897	9385	51	2	10
2014-03-25 17:57:16.175958	9392	21.1	1	10
2014-03-25 17:57:16.411196	9393	51	2	10
2014-03-25 17:57:54.918041	9401	21.1	1	10
2014-03-25 17:57:55.141545	9402	51	2	10
2014-03-25 17:58:33.915867	9410	21.1	1	10
2014-03-25 17:58:34.139526	9411	52	2	10
2014-03-25 17:59:12.91543	9418	21.1	1	10
2014-03-25 17:59:13.148946	9419	52	2	10
2014-03-25 17:59:51.915884	9427	21.1	1	10
2014-03-25 17:59:52.137097	9428	52	2	10
2014-03-25 18:00:30.915998	9435	21.1	1	10
2014-03-25 18:00:31.138738	9436	52	2	10
2014-03-25 18:01:09.915934	9444	21.1	1	10
2014-03-25 18:01:10.14718	9445	52	2	10
2014-03-25 18:01:48.917539	9454	21.1	1	10
2014-03-25 18:01:49.139824	9455	52	2	10
2014-03-25 18:02:27.917885	9462	21.1	1	10
2014-03-25 18:02:28.335923	9463	52	2	10
2014-03-25 18:03:06.920128	9471	21.2	1	10
2014-03-25 18:03:07.154243	9472	52	2	10
2014-03-25 18:03:45.917567	9480	21.2	1	10
2014-03-25 18:03:46.144379	9481	52	2	10
2014-03-25 18:04:24.918118	9488	21.2	1	10
2014-03-25 18:04:25.14259	9489	52	2	10
2014-03-25 18:05:03.917422	9497	21.2	1	10
2014-03-25 18:05:04.149771	9498	52	2	10
2014-03-25 18:05:42.919492	9506	21.2	1	10
2014-03-25 18:05:43.139873	9507	52	2	10
2014-03-25 18:06:21.918097	9514	21.2	1	10
2014-03-25 18:06:39.654752	9521	21.2	1	1
2014-03-25 18:06:39.878572	9522	55	2	1
2014-03-26 20:44:05.052258	30489	22.2	1	9
2014-03-26 20:44:05.281628	30490	48	2	9
2014-03-25 18:07:03.180986	9527	20.8	1	8
2014-03-25 18:07:03.410651	9528	56	2	8
2014-03-25 18:07:18.661727	9529	21.2	1	1
2014-03-25 18:07:18.883585	9530	55	2	1
2014-03-25 18:07:32.747474	9531	531	3	2
2014-03-26 20:44:06.141697	30491	22.4	1	8
2014-03-26 20:44:06.375121	30492	48	2	8
2014-03-25 18:07:42.181865	9536	20.8	1	8
2014-03-25 18:07:42.404471	9537	56	2	8
2014-03-25 18:07:44.750211	9538	531	3	2
2014-03-25 18:07:57.655746	9539	21.2	1	1
2014-03-25 18:07:57.880956	9540	55	2	1
2014-03-26 20:44:20.740425	30493	20.7	1	1
2014-03-26 20:44:20.973208	30494	50	2	1
2014-03-25 18:08:21.182078	9545	20.8	1	8
2014-03-25 18:08:21.415464	9546	56	2	8
2014-03-25 18:08:32.74619	9547	531	3	2
2014-03-25 18:08:36.658138	9548	21.2	1	1
2014-03-25 18:08:36.882728	9549	55	2	1
2014-03-26 20:44:32.57366	30495	579	3	2
2014-03-26 20:44:32.820495	30496	1087621.618842381	4	2
2014-03-25 18:09:00.18138	9554	20.8	1	8
2014-03-25 18:09:00.402931	9555	56	2	8
2014-03-25 18:09:15.655638	9556	21.2	1	1
2014-03-25 18:09:15.887827	9557	55	2	1
2014-03-25 18:09:32.747748	9558	531	3	2
2014-03-26 20:44:33.682783	30497	23.6	1	10
2014-03-26 20:44:33.914621	30498	41	2	10
2014-03-25 18:09:39.182774	9563	20.8	1	8
2014-03-25 18:09:39.404603	9564	56	2	8
2014-03-25 18:09:54.653668	9565	21.2	1	1
2014-03-25 18:09:54.876767	9566	55	2	1
2014-03-26 20:44:44.05106	30499	22.2	1	9
2014-03-26 20:44:44.286197	30500	48	2	9
2014-03-25 18:10:18.384411	9571	20.8	1	8
2014-03-25 18:10:18.616413	9572	56	2	8
2014-03-25 18:10:32.747523	9573	531	3	2
2014-03-25 18:10:33.692936	9574	21.2	1	1
2014-03-25 18:10:33.915452	9575	56	2	1
2014-03-26 20:44:44.593694	30501	579	3	2
2014-03-26 20:44:44.81705	30502	1087622.7678771026	4	2
2014-03-25 18:10:57.311027	9580	20.8	1	8
2014-03-25 18:10:57.729987	9581	56	2	8
2014-03-25 18:11:12.648183	9582	21.2	1	1
2014-03-25 18:11:12.881445	9583	55	2	1
2014-03-25 18:11:32.746914	9584	659	3	2
2014-03-26 20:44:45.139031	30503	22.4	1	8
2014-03-26 20:44:45.373674	30504	48	2	8
2014-03-25 18:11:36.183114	9589	20.8	1	8
2014-03-25 18:11:36.405332	9590	56	2	8
2014-03-25 18:11:44.743659	9591	659	3	2
2014-03-25 18:11:51.646696	9592	21.2	1	1
2014-03-25 18:11:51.870008	9593	55	2	1
2014-03-25 18:12:08.605076	9594	837	3	2
2014-03-25 18:12:08.912099	9595	837	3	2
2014-03-26 20:44:56.569624	30505	547	3	2
2014-03-26 20:44:56.797128	30506	1087625.0659465452	4	2
2014-03-25 18:12:15.180232	9600	20.8	1	8
2014-03-25 18:12:15.41323	9601	56	2	8
2014-03-25 18:12:30.651823	9602	21.2	1	1
2014-03-25 18:12:30.873817	9603	55	2	1
2014-03-25 18:12:32.746579	9604	837	3	2
2014-03-26 20:44:59.736735	30507	20.7	1	1
2014-03-26 20:44:59.973277	30508	50	2	1
2014-03-25 18:12:54.180792	9609	20.8	1	8
2014-03-25 18:12:54.403436	9610	56	2	8
2014-03-25 18:13:09.649731	9611	21.2	1	1
2014-03-25 18:13:09.883237	9612	55	2	1
2014-03-26 20:45:08.572161	30509	579	3	2
2014-03-26 20:45:08.799559	30510	1087627.364015988	4	2
2014-03-25 18:13:32.745192	9617	837	3	2
2014-03-25 18:13:33.180734	9618	20.8	1	8
2014-03-25 18:13:33.406213	9619	56	2	8
2014-03-25 18:13:48.692251	9620	21.2	1	1
2014-03-25 18:13:48.916076	9621	55	2	1
2014-03-26 20:45:12.682431	30511	23.6	1	10
2014-03-26 20:45:12.915666	30512	41	2	10
2014-03-25 18:14:12.181825	9626	20.8	1	8
2014-03-25 18:14:12.412632	9627	56	2	8
2014-03-25 18:14:27.690224	9628	21.2	1	1
2014-03-25 18:14:27.913475	9629	55	2	1
2014-03-25 18:14:32.74652	9630	853	3	2
2014-03-26 20:45:20.571135	30513	579	3	2
2014-03-26 20:45:20.795674	30514	1087628.5130507096	4	2
2014-03-25 18:14:51.180952	9635	20.8	1	8
2014-03-25 18:14:51.41032	9636	56	2	8
2014-03-25 18:15:06.649373	9637	21.2	1	1
2014-03-25 18:15:06.891522	9638	55	2	1
2014-03-26 20:45:23.050116	30515	22.2	1	9
2014-03-26 20:45:23.28381	30516	48	2	9
2014-03-25 18:15:30.182748	9643	20.8	1	8
2014-03-25 18:15:30.404385	9644	56	2	8
2014-03-25 18:15:32.740611	9645	853	3	2
2014-03-25 18:15:45.648922	9646	21.2	1	1
2014-03-25 18:15:45.873762	9647	55	2	1
2014-03-26 20:45:24.1391	30517	22.4	1	8
2014-03-25 18:16:09.179881	9652	20.8	1	8
2014-03-25 18:16:09.414899	9653	56	2	8
2014-03-25 18:16:24.647449	9654	21.2	1	1
2014-03-25 18:16:24.873396	9655	55	2	1
2014-03-25 18:16:32.742109	9656	708	3	2
2014-03-25 18:07:00.917511	9523	21.2	1	10
2014-03-25 18:07:01.140583	9524	52	2	10
2014-03-25 18:07:39.918879	9532	21.2	1	10
2014-03-25 18:07:40.142265	9533	52	2	10
2014-03-25 18:08:18.921656	9541	21.2	1	10
2014-03-25 18:08:19.145275	9542	52	2	10
2014-03-25 18:08:57.919443	9550	21.2	1	10
2014-03-25 18:08:58.144324	9551	52	2	10
2014-03-25 18:09:36.918823	9559	21.3	1	10
2014-03-25 18:09:37.14288	9560	52	2	10
2014-03-25 18:10:15.915888	9567	21.3	1	10
2014-03-25 18:10:16.147857	9568	52	2	10
2014-03-25 18:10:55.049922	9576	21.3	1	10
2014-03-25 18:10:55.469935	9577	52	2	10
2014-03-25 18:11:33.923467	9585	21.3	1	10
2014-03-25 18:11:34.146448	9586	52	2	10
2014-03-25 18:12:12.918684	9596	21.3	1	10
2014-03-25 18:12:13.150424	9597	52	2	10
2014-03-25 18:12:51.920446	9605	21.3	1	10
2014-03-25 18:12:52.148632	9606	52	2	10
2014-03-25 18:13:30.920626	9613	21.3	1	10
2014-03-25 18:13:31.143815	9614	52	2	10
2014-03-25 18:14:09.922766	9622	21.3	1	10
2014-03-25 18:14:10.154454	9623	52	2	10
2014-03-25 18:14:48.921139	9631	21.3	1	10
2014-03-25 18:14:49.147242	9632	52	2	10
2014-03-25 18:15:27.921149	9639	21.3	1	10
2014-03-25 18:15:28.144565	9640	52	2	10
2014-03-26 20:45:24.364356	30518	48	2	8
2014-03-26 20:45:32.572244	30519	579	3	2
2014-03-25 18:16:48.179843	9661	20.8	1	8
2014-03-25 18:16:48.405143	9662	56	2	8
2014-03-25 18:16:56.745114	9663	804	3	2
2014-03-25 18:17:03.648102	9664	21.2	1	1
2014-03-25 18:17:03.870338	9665	55	2	1
2014-03-26 20:45:32.807376	30520	1087630.8111201525	4	2
2014-03-26 20:45:38.740907	30521	20.7	1	1
2014-03-25 18:17:27.180386	9670	20.8	1	8
2014-03-25 18:17:27.412088	9671	56	2	8
2014-03-25 18:17:32.742098	9672	804	3	2
2014-03-25 18:17:42.64941	9673	21.2	1	1
2014-03-25 18:17:42.875683	9674	55	2	1
2014-03-26 20:45:38.965876	30522	50	2	1
2014-03-26 20:45:51.682547	30523	23.6	1	10
2014-03-25 18:18:06.180432	9679	20.8	1	8
2014-03-25 18:18:06.403422	9680	56	2	8
2014-03-25 18:18:21.648593	9681	21.2	1	1
2014-03-25 18:18:21.894852	9682	55	2	1
2014-03-25 18:18:32.743963	9683	853	3	2
2014-03-26 20:45:51.918088	30524	41	2	10
2014-03-26 20:46:02.050715	30525	22.2	1	9
2014-03-25 18:18:44.747544	9688	869	3	2
2014-03-25 18:18:45.180158	9689	20.8	1	8
2014-03-25 18:18:45.401915	9690	56	2	8
2014-03-25 18:19:00.643708	9691	21.2	1	1
2014-03-25 18:19:00.869476	9692	55	2	1
2014-03-25 18:19:08.742621	9693	837	3	2
2014-03-25 18:19:20.742853	9694	837	3	2
2014-03-26 20:46:02.274571	30526	48	2	9
2014-03-26 20:46:03.138859	30527	22.4	1	8
2014-03-25 18:19:24.180656	9699	20.8	1	8
2014-03-25 18:19:24.413144	9700	56	2	8
2014-03-25 18:19:39.450859	9701	837	3	2
2014-03-25 18:19:39.760762	9702	21.2	1	1
2014-03-25 18:19:39.984541	9703	55	2	1
2014-03-26 20:46:03.373249	30528	48	2	8
2014-03-26 20:46:17.739939	30529	20.7	1	1
2014-03-25 18:20:03.182169	9708	20.8	1	8
2014-03-25 18:20:03.404475	9709	56	2	8
2014-03-25 18:20:18.644276	9710	21.2	1	1
2014-03-25 18:20:18.877268	9711	55	2	1
2014-03-25 18:20:32.739996	9712	837	3	2
2014-03-26 20:46:17.965386	30530	50	2	1
2014-03-26 20:46:30.682027	30531	23.6	1	10
2014-03-25 18:20:42.182493	9717	20.8	1	8
2014-03-25 18:20:42.404935	9718	56	2	8
2014-03-25 18:20:57.644213	9719	21.2	1	1
2014-03-25 18:20:57.871843	9720	55	2	1
2014-03-26 20:46:30.916034	30532	41	2	10
2014-03-26 20:46:32.572551	30533	547	3	2
2014-03-25 18:21:21.181056	9725	20.8	1	8
2014-03-25 18:21:21.424768	9726	56	2	8
2014-03-25 18:21:32.741778	9727	853	3	2
2014-03-25 18:21:36.685275	9728	21.2	1	1
2014-03-25 18:21:36.907856	9729	55	2	1
2014-03-25 18:21:56.741511	9730	804	3	2
2014-03-26 20:46:32.796559	30534	1087641.1524326452	4	2
2014-03-26 20:46:41.050258	30535	22.2	1	9
2014-03-25 18:22:00.180073	9735	20.8	1	8
2014-03-25 18:22:00.404989	9736	56	2	8
2014-03-25 18:22:08.743226	9737	659	3	2
2014-03-25 18:22:15.64388	9738	21.2	1	1
2014-03-25 18:22:15.866441	9739	55	2	1
2014-03-25 18:22:32.745266	9740	724	3	2
2014-03-26 20:46:41.284895	30536	48	2	9
2014-03-26 20:46:42.139656	30537	22.4	1	8
2014-03-25 18:22:39.180225	9745	20.9	1	8
2014-03-25 18:22:39.402014	9746	56	2	8
2014-03-25 18:22:54.648816	9747	21.1	1	1
2014-03-25 18:22:54.883072	9748	55	2	1
2014-03-26 20:46:42.363695	30538	48	2	8
2014-03-26 20:46:44.572224	30539	547	3	2
2014-03-25 18:23:18.182472	9753	20.9	1	8
2014-03-25 18:23:18.40735	9754	56	2	8
2014-03-25 18:23:33.447229	9755	724	3	2
2014-03-25 18:23:33.766056	9756	21.1	1	1
2014-03-25 18:23:33.988883	9757	55	2	1
2014-03-26 20:46:44.80465	30540	1087642.3014673665	4	2
2014-03-26 20:46:56.979496	30541	20.7	1	1
2014-03-25 18:23:57.180039	9762	20.9	1	8
2014-03-25 18:23:57.412548	9763	56	2	8
2014-03-25 18:24:12.642738	9764	21.1	1	1
2014-03-25 18:24:12.866647	9765	55	2	1
2014-03-25 18:24:32.744656	9766	611	3	2
2014-03-26 20:46:57.202879	30542	50	2	1
2014-03-26 20:47:08.574168	30543	595	3	2
2014-03-25 18:24:36.180828	9771	20.9	1	8
2014-03-25 18:24:36.403846	9772	56	2	8
2014-03-25 18:24:44.744013	9773	676	3	2
2014-03-25 18:24:51.643482	9774	21.1	1	1
2014-03-25 18:24:51.866998	9775	55	2	1
2014-03-25 18:24:56.744256	9776	676	3	2
2014-03-25 18:25:08.747944	9777	804	3	2
2014-03-26 20:47:08.823073	30544	1087646.8976062522	4	2
2014-03-26 20:47:09.684249	30545	23.6	1	10
2014-03-25 18:25:15.180746	9782	20.9	1	8
2014-03-25 18:25:15.40195	9783	56	2	8
2014-03-25 18:25:20.744674	9784	724	3	2
2014-03-25 18:25:30.638577	9785	21.0	1	1
2014-03-25 18:25:30.863271	9786	55	2	1
2014-03-25 18:25:32.742138	9787	804	3	2
2014-03-25 18:25:44.743011	9788	724	3	2
2014-03-26 20:47:09.908624	30546	41	2	10
2014-03-25 18:16:46.170022	9657	21.4	1	10
2014-03-25 18:16:46.405916	9658	52	2	10
2014-03-25 18:17:24.92211	9666	21.4	1	10
2014-03-25 18:17:25.173186	9667	52	2	10
2014-03-25 18:18:03.920528	9675	21.4	1	10
2014-03-25 18:18:04.143427	9676	52	2	10
2014-03-25 18:18:43.126253	9684	21.4	1	10
2014-03-25 18:18:43.348007	9685	52	2	10
2014-03-25 18:19:21.923974	9695	21.4	1	10
2014-03-25 18:19:22.160755	9696	52	2	10
2014-03-25 18:20:00.923082	9704	21.4	1	10
2014-03-25 18:20:01.147719	9705	52	2	10
2014-03-25 18:20:39.923812	9713	21.4	1	10
2014-03-25 18:20:40.150301	9714	52	2	10
2014-03-25 18:21:18.924033	9721	21.4	1	10
2014-03-25 18:21:19.155913	9722	52	2	10
2014-03-25 18:21:57.923281	9731	21.5	1	10
2014-03-25 18:21:58.145392	9732	52	2	10
2014-03-25 18:22:36.923161	9741	21.5	1	10
2014-03-25 18:22:37.145154	9742	52	2	10
2014-03-25 18:23:15.924051	9749	21.5	1	10
2014-03-25 18:23:16.147285	9750	52	2	10
2014-03-25 18:23:54.924903	9758	21.5	1	10
2014-03-25 18:23:55.159472	9759	52	2	10
2014-03-25 18:24:33.926072	9767	21.5	1	10
2014-03-25 18:24:34.1515	9768	52	2	10
2014-03-25 18:25:12.924662	9778	21.5	1	10
2014-03-25 18:25:13.147707	9779	52	2	10
2014-03-25 18:25:54.183081	9793	20.9	1	8
2014-03-25 18:25:54.405042	9794	56	2	8
2014-03-25 18:25:56.742173	9795	804	3	2
2014-03-25 18:26:08.748556	9796	659	3	2
2014-03-25 18:26:20.742569	9797	676	3	2
2014-03-26 20:47:20.05087	30547	22.2	1	9
2014-03-26 20:47:20.287874	30548	48	2	9
2014-03-25 18:26:32.742039	9802	659	3	2
2014-03-25 18:26:33.180973	9803	20.8	1	8
2014-03-25 18:26:33.405887	9804	56	2	8
2014-03-25 18:26:48.64955	9805	21.0	1	1
2014-03-25 18:26:48.881396	9806	56	2	1
2014-03-26 20:47:21.139575	30549	22.4	1	8
2014-03-26 20:47:21.390995	30550	48	2	8
2014-03-25 18:27:12.181405	9811	20.8	1	8
2014-03-25 18:27:12.404051	9812	56	2	8
2014-03-25 18:27:27.643091	9813	21.0	1	1
2014-03-25 18:27:27.887167	9814	56	2	1
2014-03-25 18:27:32.744289	9815	659	3	2
2014-03-25 18:27:44.748627	9816	627	3	2
2014-03-26 20:47:32.572346	30551	579	3	2
2014-03-26 20:47:32.810176	30552	1087649.2001466472	4	2
2014-03-25 18:27:51.181505	9821	20.8	1	8
2014-03-25 18:27:51.414283	9822	56	2	8
2014-03-25 18:27:56.742028	9823	627	3	2
2014-03-25 18:28:06.641362	9824	21.0	1	1
2014-03-25 18:28:06.8651	9825	56	2	1
2014-03-26 20:47:35.738598	30553	20.7	1	1
2014-03-26 20:47:35.96446	30554	50	2	1
2014-03-25 18:28:30.17911	9830	20.8	1	8
2014-03-25 18:28:30.403551	9831	56	2	8
2014-03-25 18:28:32.745219	9832	627	3	2
2014-03-25 18:28:45.65006	9833	20.9	1	1
2014-03-25 18:28:45.873665	9834	56	2	1
2014-03-25 18:28:56.745118	9835	498	3	2
2014-03-26 20:47:48.683376	30555	23.6	1	10
2014-03-26 20:47:48.921448	30556	41	2	10
2014-03-25 18:29:08.746137	9840	498	3	2
2014-03-25 18:29:09.180383	9841	20.8	1	8
2014-03-25 18:29:09.404625	9842	56	2	8
2014-03-25 18:29:24.640806	9843	20.9	1	1
2014-03-25 18:29:24.867322	9844	56	2	1
2014-03-25 18:29:32.744765	9845	498	3	2
2014-03-26 20:47:59.050348	30557	22.2	1	9
2014-03-26 20:47:59.273989	30558	48	2	9
2014-03-25 18:29:48.179747	9850	20.8	1	8
2014-03-25 18:29:48.413133	9851	56	2	8
2014-03-25 18:30:03.641771	9852	20.9	1	1
2014-03-25 18:30:03.868495	9853	56	2	1
2014-03-25 18:30:20.742145	9854	466	3	2
2014-03-26 20:48:00.137168	30559	22.5	1	8
2014-03-26 20:48:00.370392	30560	48	2	8
2014-03-25 18:30:27.17988	9859	20.8	1	8
2014-03-25 18:30:27.40101	9860	56	2	8
2014-03-25 18:30:32.743546	9861	466	3	2
2014-03-25 18:30:42.64397	9862	20.9	1	1
2014-03-25 18:30:42.866645	9863	56	2	1
2014-03-26 20:48:08.572368	30561	531	3	2
2014-03-26 20:48:08.798234	30562	1087654.9453202544	4	2
2014-03-25 18:31:06.180693	9868	20.7	1	8
2014-03-25 18:31:06.41141	9869	56	2	8
2014-03-25 18:31:21.766474	9870	20.8	1	1
2014-03-25 18:31:22.192649	9871	56	2	1
2014-03-25 18:31:32.741756	9872	450	3	2
2014-03-26 20:48:14.740873	30563	20.7	1	1
2014-03-26 20:48:14.978097	30564	50	2	1
2014-03-25 18:31:45.181613	9877	20.7	1	8
2014-03-25 18:31:45.402302	9878	56	2	8
2014-03-25 18:32:00.879653	9879	20.8	1	1
2014-03-25 18:32:01.131356	9880	56	2	1
2014-03-25 18:32:08.741818	9881	418	3	2
2014-03-25 18:32:20.739048	9882	338	3	2
2014-03-26 20:48:20.572169	30565	547	3	2
2014-03-26 20:48:20.797633	30566	1087657.243389697	4	2
2014-03-25 18:32:24.179293	9887	20.7	1	8
2014-03-25 18:32:24.414647	9888	56	2	8
2014-03-25 18:32:32.744816	9889	338	3	2
2014-03-25 18:32:39.639495	9890	20.8	1	1
2014-03-25 18:32:39.863908	9891	56	2	1
2014-03-26 20:48:27.683051	30567	23.6	1	10
2014-03-26 20:48:27.919587	30568	41	2	10
2014-03-25 18:33:03.180735	9896	20.7	1	8
2014-03-25 18:33:03.403555	9897	56	2	8
2014-03-25 18:33:18.646356	9898	20.8	1	1
2014-03-25 18:33:18.879178	9899	56	2	1
2014-03-25 18:33:32.741946	9900	338	3	2
2014-03-26 20:48:32.573922	30569	595	3	2
2014-03-26 20:48:32.799351	30570	1087658.3924244186	4	2
2014-03-25 18:33:42.179002	9905	20.7	1	8
2014-03-25 18:33:42.401377	9906	56	2	8
2014-03-25 18:33:57.642268	9907	20.8	1	1
2014-03-25 18:33:57.863582	9908	56	2	1
2014-03-26 20:48:38.052741	30571	22.2	1	9
2014-03-26 20:48:38.292881	30572	48	2	9
2014-03-25 18:34:21.178858	9913	20.7	1	8
2014-03-25 18:34:21.410112	9914	56	2	8
2014-03-25 18:34:32.745813	9915	338	3	2
2014-03-25 18:34:36.637784	9916	20.7	1	1
2014-03-25 18:34:36.862711	9917	56	2	1
2014-03-26 20:48:39.139137	30573	22.5	1	8
2014-03-26 20:48:39.363473	30574	48	2	8
2014-03-26 20:48:44.572109	30575	579	3	2
2014-03-25 18:35:00.179174	9922	20.7	1	8
2014-03-25 18:35:00.399294	9923	56	2	8
2014-03-25 18:35:15.640258	9924	20.7	1	1
2014-03-25 18:35:15.87671	9925	56	2	1
2014-03-25 18:35:32.742665	9926	338	3	2
2014-03-25 18:26:30.923341	9798	21.5	1	10
2014-03-25 18:26:31.157412	9799	52	2	10
2014-03-25 18:27:09.925772	9807	21.5	1	10
2014-03-25 18:27:10.148854	9808	52	2	10
2014-03-25 18:27:48.924184	9817	21.6	1	10
2014-03-25 18:27:49.157627	9818	52	2	10
2014-03-25 18:28:27.925573	9826	21.6	1	10
2014-03-25 18:28:28.148611	9827	52	2	10
2014-03-25 18:29:06.924587	9836	21.6	1	10
2014-03-25 18:29:07.147602	9837	52	2	10
2014-03-25 18:29:46.133227	9846	21.6	1	10
2014-03-25 18:29:46.365678	9847	52	2	10
2014-03-25 18:30:24.926745	9855	21.6	1	10
2014-03-25 18:30:25.150832	9856	52	2	10
2014-03-25 18:31:03.925748	9864	21.6	1	10
2014-03-25 18:31:04.158825	9865	52	2	10
2014-03-25 18:31:42.927069	9873	21.6	1	10
2014-03-25 18:31:43.149754	9874	52	2	10
2014-03-25 18:32:21.927054	9883	21.6	1	10
2014-03-25 18:32:22.158536	9884	52	2	10
2014-03-25 18:33:00.926939	9892	21.6	1	10
2014-03-25 18:33:01.149264	9893	52	2	10
2014-03-25 18:33:39.926147	9901	21.7	1	10
2014-03-25 18:33:40.148026	9902	52	2	10
2014-03-25 18:34:18.925961	9909	21.7	1	10
2014-03-25 18:34:19.14748	9910	52	2	10
2014-03-26 20:48:44.807841	30576	1087660.6904938614	4	2
2014-03-26 20:48:53.737797	30577	20.7	1	1
2014-03-25 18:35:39.179653	9931	20.7	1	8
2014-03-25 18:35:39.410844	9932	56	2	8
2014-03-25 18:35:54.639836	9933	20.7	1	1
2014-03-25 18:35:54.863887	9934	56	2	1
2014-03-26 20:48:53.966525	30578	50	2	1
2014-03-26 20:48:56.571035	30579	611	3	2
2014-03-25 18:36:18.178487	9939	20.7	1	8
2014-03-25 18:36:18.411512	9940	56	2	8
2014-03-25 18:36:32.741115	9941	402	3	2
2014-03-25 18:36:33.63564	9942	20.7	1	1
2014-03-25 18:36:33.858221	9943	56	2	1
2014-03-25 18:36:44.743707	9944	402	3	2
2014-03-26 20:48:56.805341	30580	1087662.9885633043	4	2
2014-03-26 20:49:06.683103	30581	23.7	1	10
2014-03-25 18:36:57.181308	9949	20.7	1	8
2014-03-25 18:36:57.411319	9950	56	2	8
2014-03-25 18:37:12.637849	9951	20.7	1	1
2014-03-25 18:37:12.861433	9952	56	2	1
2014-03-25 18:37:32.74365	9953	402	3	2
2014-03-26 20:49:06.907608	30582	41	2	10
2014-03-26 20:49:08.57302	30583	595	3	2
2014-03-25 18:37:36.179074	9958	20.7	1	8
2014-03-25 18:37:36.403438	9959	56	2	8
2014-03-25 18:37:51.635808	9960	20.6	1	1
2014-03-25 18:37:51.873816	9961	56	2	1
2014-03-26 20:49:08.807685	30584	1087664.1375980256	4	2
2014-03-26 20:49:17.052219	30585	22.2	1	9
2014-03-25 18:38:15.179232	9966	20.6	1	8
2014-03-25 18:38:15.403787	9967	56	2	8
2014-03-25 18:38:30.634758	9968	20.6	1	1
2014-03-25 18:38:30.866999	9969	56	2	1
2014-03-25 18:38:32.739825	9970	402	3	2
2014-03-26 20:49:17.277009	30586	48	2	9
2014-03-26 20:49:18.139985	30587	22.5	1	8
2014-03-25 18:38:54.179943	9975	20.6	1	8
2014-03-25 18:38:54.402562	9976	56	2	8
2014-03-25 18:39:09.634473	9977	20.6	1	1
2014-03-25 18:39:09.856008	9978	55	2	1
2014-03-26 20:49:18.374282	30588	48	2	8
2014-03-26 20:49:32.978718	30589	20.7	1	1
2014-03-25 18:39:32.745623	9983	402	3	2
2014-03-25 18:39:33.181904	9984	20.6	1	8
2014-03-25 18:39:33.403929	9985	56	2	8
2014-03-25 18:39:48.638879	9986	20.6	1	1
2014-03-25 18:39:48.863796	9987	55	2	1
2014-03-26 20:49:33.205817	30590	50	2	1
2014-03-26 20:49:45.685655	30591	23.7	1	10
2014-03-25 18:40:12.179244	9992	20.6	1	8
2014-03-25 18:40:12.400547	9993	56	2	8
2014-03-25 18:40:27.633466	9994	20.6	1	1
2014-03-25 18:40:27.867687	9995	55	2	1
2014-03-25 18:40:32.74179	9996	402	3	2
2014-03-26 20:49:45.932976	30592	41	2	10
2014-03-26 20:49:56.049563	30593	22.2	1	9
2014-03-25 18:40:51.1799	10001	20.6	1	8
2014-03-25 18:40:51.400174	10002	56	2	8
2014-03-25 18:41:06.632331	10003	20.6	1	1
2014-03-25 18:41:06.855456	10004	55	2	1
2014-03-25 18:41:20.744487	10005	338	3	2
2014-03-26 20:49:56.274032	30594	48	2	9
2014-03-26 20:49:57.137447	30595	22.5	1	8
2014-03-25 18:41:30.180147	10010	20.6	1	8
2014-03-25 18:41:30.403084	10011	56	2	8
2014-03-25 18:41:32.870015	10012	338	3	2
2014-03-25 18:41:45.63463	10013	20.5	1	1
2014-03-25 18:41:45.857107	10014	55	2	1
2014-03-26 20:49:57.375121	30596	48	2	8
2014-03-26 20:50:08.569232	30597	531	3	2
2014-03-25 18:42:09.180132	10019	20.6	1	8
2014-03-25 18:42:09.412767	10020	56	2	8
2014-03-25 18:42:24.634958	10021	20.5	1	1
2014-03-25 18:42:24.8579	10022	55	2	1
2014-03-25 18:42:32.74264	10023	338	3	2
2014-03-26 20:50:08.793955	30598	1087674.4789105183	4	2
2014-03-26 20:50:11.739999	30599	20.7	1	1
2014-03-25 18:42:48.179509	10028	20.6	1	8
2014-03-25 18:42:48.404069	10029	56	2	8
2014-03-25 18:43:03.631367	10030	20.5	1	1
2014-03-25 18:43:03.862887	10031	55	2	1
2014-03-26 20:50:11.973377	30600	50	2	1
2014-03-26 20:50:20.571028	30601	515	3	2
2014-03-25 18:43:27.179012	10036	20.6	1	8
2014-03-25 18:43:27.404211	10037	56	2	8
2014-03-25 18:43:32.744989	10038	338	3	2
2014-03-25 18:43:42.628247	10039	20.5	1	1
2014-03-25 18:43:42.851541	10040	55	2	1
2014-03-26 20:50:20.794802	30602	1087676.7769799612	4	2
2014-03-26 20:50:24.68277	30603	23.7	1	10
2014-03-25 18:44:06.178709	10045	20.6	1	8
2014-03-25 18:44:06.409354	10046	56	2	8
2014-03-25 18:44:21.63192	10047	20.5	1	1
2014-03-25 18:44:21.854296	10048	55	2	1
2014-03-25 18:44:32.741978	10049	338	3	2
2014-03-26 20:50:24.918904	30604	41	2	10
2014-03-25 18:44:45.178652	10054	20.6	1	8
2014-03-25 18:44:45.404052	10055	56	2	8
2014-03-25 18:45:00.631504	10056	20.5	1	1
2014-03-25 18:45:00.855878	10057	55	2	1
2014-03-25 18:45:24.178621	10062	20.6	1	8
2014-03-25 18:45:24.402312	10063	56	2	8
2014-03-25 18:45:32.748109	10064	338	3	2
2014-03-25 18:36:15.929371	9935	21.7	1	10
2014-03-25 18:36:16.163669	9936	52	2	10
2014-03-25 18:36:54.929495	9945	21.7	1	10
2014-03-25 18:36:55.153148	9946	52	2	10
2014-03-25 18:37:33.929137	9954	21.7	1	10
2014-03-25 18:37:34.150349	9955	52	2	10
2014-03-25 18:38:12.929899	9962	21.7	1	10
2014-03-25 18:38:13.152555	9963	52	2	10
2014-03-25 18:38:51.930684	9971	21.8	1	10
2014-03-25 18:38:52.157114	9972	52	2	10
2014-03-25 18:39:30.928604	9979	21.8	1	10
2014-03-25 18:39:31.151407	9980	52	2	10
2014-03-25 18:40:09.928442	9988	21.8	1	10
2014-03-25 18:40:10.151731	9989	52	2	10
2014-03-25 18:40:48.930603	9997	21.8	1	10
2014-03-25 18:40:49.153135	9998	52	2	10
2014-03-25 18:41:27.928944	10006	21.8	1	10
2014-03-25 18:41:28.153891	10007	52	2	10
2014-03-25 18:42:06.930606	10015	21.8	1	10
2014-03-25 18:42:07.164172	10016	52	2	10
2014-03-25 18:42:45.929634	10024	21.8	1	10
2014-03-25 18:42:46.152902	10025	52	2	10
2014-03-25 18:43:24.931185	10032	21.8	1	10
2014-03-25 18:43:25.156486	10033	52	2	10
2014-03-25 18:44:03.937799	10041	21.9	1	10
2014-03-25 18:44:04.170363	10042	52	2	10
2014-03-25 18:44:42.932076	10050	21.9	1	10
2014-03-25 18:44:43.155842	10051	52	2	10
2014-03-25 18:45:21.930804	10058	21.9	1	10
2014-03-25 18:45:22.154003	10059	52	2	10
2014-03-25 18:45:39.632657	10065	20.5	1	1
2014-03-25 18:45:39.858618	10066	55	2	1
2014-03-26 20:50:32.571688	30605	531	3	2
2014-03-26 20:50:32.796499	30606	1087677.9260146825	4	2
2014-03-25 18:46:03.179544	10071	20.6	1	8
2014-03-25 18:46:03.400897	10072	55	2	8
2014-03-25 18:46:18.628755	10073	20.4	1	1
2014-03-25 18:46:18.853217	10074	55	2	1
2014-03-25 18:46:32.742835	10075	338	3	2
2014-03-26 20:50:35.049847	30607	22.2	1	9
2014-03-26 20:50:35.287801	30608	48	2	9
2014-03-25 18:46:42.179158	10080	20.6	1	8
2014-03-25 18:46:42.421729	10081	56	2	8
2014-03-25 18:46:57.633388	10082	20.4	1	1
2014-03-25 18:46:57.856426	10083	55	2	1
2014-03-26 20:50:36.137972	30609	22.5	1	8
2014-03-26 20:50:36.362919	30610	48	2	8
2014-03-25 18:47:21.181978	10088	20.6	1	8
2014-03-25 18:47:21.414253	10089	55	2	8
2014-03-25 18:47:32.743061	10090	402	3	2
2014-03-25 18:47:36.629299	10091	20.4	1	1
2014-03-25 18:47:36.852479	10092	55	2	1
2014-03-25 18:47:57.730243	10093	402	3	2
2014-03-26 20:50:50.735491	30611	20.7	1	1
2014-03-26 20:50:50.970792	30612	50	2	1
2014-03-25 18:48:00.18055	10098	20.6	1	8
2014-03-25 18:48:00.41565	10099	55	2	8
2014-03-25 18:48:15.63152	10100	20.4	1	1
2014-03-25 18:48:15.85562	10101	55	2	1
2014-03-25 18:48:32.739553	10102	402	3	2
2014-03-26 20:51:03.684244	30613	23.7	1	10
2014-03-26 20:51:03.909954	30614	41	2	10
2014-03-25 18:48:39.179102	10107	20.6	1	8
2014-03-25 18:48:39.404965	10108	55	2	8
2014-03-25 18:48:54.632385	10109	20.4	1	1
2014-03-25 18:48:54.864021	10110	55	2	1
2014-03-26 20:51:14.05061	30615	22.2	1	9
2014-03-26 20:51:14.284156	30616	48	2	9
2014-03-25 18:49:18.179717	10115	20.6	1	8
2014-03-25 18:49:18.403088	10116	55	2	8
2014-03-25 18:49:32.740494	10117	402	3	2
2014-03-25 18:49:33.63	10118	20.4	1	1
2014-03-25 18:49:33.851517	10119	55	2	1
2014-03-26 20:51:15.138776	30617	22.5	1	8
2014-03-26 20:51:15.364051	30618	48	2	8
2014-03-25 18:49:57.17872	10124	20.6	1	8
2014-03-25 18:49:57.42344	10125	55	2	8
2014-03-25 18:50:12.630605	10126	20.4	1	1
2014-03-25 18:50:12.85335	10127	55	2	1
2014-03-25 18:50:32.744256	10128	402	3	2
2014-03-26 20:51:29.736413	30619	20.7	1	1
2014-03-26 20:51:29.971231	30620	50	2	1
2014-03-25 18:50:36.179169	10133	20.6	1	8
2014-03-25 18:50:36.400141	10134	55	2	8
2014-03-25 18:50:51.628886	10135	20.3	1	1
2014-03-25 18:50:51.861882	10136	55	2	1
2014-03-26 20:51:32.570348	30621	515	3	2
2014-03-26 20:51:32.795267	30622	1087687.118292454	4	2
2014-03-25 18:51:15.178833	10141	20.5	1	8
2014-03-25 18:51:15.399367	10142	55	2	8
2014-03-25 18:51:20.741522	10143	338	3	2
2014-03-25 18:51:30.628789	10144	20.3	1	1
2014-03-25 18:51:30.855085	10145	55	2	1
2014-03-25 18:51:32.742386	10146	338	3	2
2014-03-26 20:51:42.684153	30623	23.7	1	10
2014-03-26 20:51:42.918048	30624	41	2	10
2014-03-25 18:51:54.309986	10151	20.5	1	8
2014-03-25 18:51:54.749738	10152	55	2	8
2014-03-25 18:52:09.625985	10153	20.3	1	1
2014-03-25 18:52:09.848653	10154	55	2	1
2014-03-26 20:51:53.050327	30625	22.2	1	9
2014-03-26 20:51:53.274648	30626	48	2	9
2014-03-25 18:52:32.742123	10159	338	3	2
2014-03-25 18:52:33.180347	10160	20.5	1	8
2014-03-25 18:52:33.401871	10161	55	2	8
2014-03-25 18:52:48.628575	10162	20.3	1	1
2014-03-25 18:52:48.863556	10163	55	2	1
2014-03-26 20:51:54.138175	30627	22.5	1	8
2014-03-26 20:51:54.371376	30628	48	2	8
2014-03-25 18:53:12.180434	10168	20.5	1	8
2014-03-25 18:53:12.403201	10169	55	2	8
2014-03-25 18:53:27.627938	10170	20.3	1	1
2014-03-25 18:53:27.907306	10171	55	2	1
2014-03-25 18:53:32.742689	10172	338	3	2
2014-03-26 20:51:56.573879	30629	547	3	2
2014-03-26 20:51:56.798002	30630	1087690.565396618	4	2
2014-03-25 18:53:51.179408	10177	20.5	1	8
2014-03-25 18:53:51.445871	10178	55	2	8
2014-03-25 18:54:06.630477	10179	20.3	1	1
2014-03-25 18:54:06.88749	10180	55	2	1
2014-03-26 20:52:08.976126	30631	20.7	1	1
2014-03-26 20:52:09.209966	30632	50	2	1
2014-03-25 18:54:30.179753	10185	20.5	1	8
2014-03-25 18:54:30.442884	10186	55	2	8
2014-03-25 18:54:32.739387	10187	338	3	2
2014-03-25 18:54:45.630162	10188	20.3	1	1
2014-03-25 18:54:45.85164	10189	55	2	1
2014-03-26 20:52:21.685649	30633	23.7	1	10
2014-03-26 20:52:21.918593	30634	41	2	10
2014-03-26 20:52:32.049895	30635	22.2	1	9
2014-03-25 18:55:09.178989	10194	20.5	1	8
2014-03-25 18:55:09.400338	10195	55	2	8
2014-03-25 18:55:24.626462	10196	20.3	1	1
2014-03-25 18:55:24.849852	10197	55	2	1
2014-03-25 18:55:32.740953	10198	338	3	2
2014-03-25 18:46:00.933692	10067	21.9	1	10
2014-03-25 18:46:01.157105	10068	52	2	10
2014-03-25 18:46:39.930696	10076	21.9	1	10
2014-03-25 18:46:40.165389	10077	52	2	10
2014-03-25 18:47:18.92996	10084	21.9	1	10
2014-03-25 18:47:19.164733	10085	52	2	10
2014-03-25 18:47:58.040303	10094	21.9	1	10
2014-03-25 18:47:58.263909	10095	52	2	10
2014-03-25 18:48:36.932517	10103	21.9	1	10
2014-03-25 18:48:37.155396	10104	52	2	10
2014-03-25 18:49:15.931149	10111	22.0	1	10
2014-03-25 18:49:16.154368	10112	51	2	10
2014-03-25 18:49:54.9314	10120	22.0	1	10
2014-03-25 18:49:55.15369	10121	51	2	10
2014-03-25 18:50:33.93191	10129	22.0	1	10
2014-03-25 18:50:34.15289	10130	51	2	10
2014-03-25 18:51:12.932849	10137	22.0	1	10
2014-03-25 18:51:13.154826	10138	51	2	10
2014-03-25 18:51:52.061585	10147	22.0	1	10
2014-03-25 18:51:52.510002	10148	51	2	10
2014-03-25 18:52:30.93344	10155	22.0	1	10
2014-03-25 18:52:31.167072	10156	51	2	10
2014-03-25 18:53:09.932465	10164	22.0	1	10
2014-03-25 18:53:10.155036	10165	51	2	10
2014-03-25 18:53:48.933706	10173	22.0	1	10
2014-03-25 18:53:49.359908	10174	51	2	10
2014-03-25 18:54:27.932427	10181	22.0	1	10
2014-03-25 18:54:28.200922	10182	51	2	10
2014-03-26 20:52:32.284711	30636	48	2	9
2014-03-26 20:52:32.595776	30637	531	3	2
2014-03-25 18:55:48.179695	10203	20.5	1	8
2014-03-25 18:55:48.40158	10204	55	2	8
2014-03-25 18:56:03.628647	10205	20.2	1	1
2014-03-25 18:56:03.86413	10206	55	2	1
2014-03-26 20:52:32.821432	30638	1087696.3105702254	4	2
2014-03-26 20:52:33.138843	30639	22.5	1	8
2014-03-25 18:56:27.179928	10211	20.5	1	8
2014-03-25 18:56:27.420549	10212	55	2	8
2014-03-25 18:56:32.74205	10213	338	3	2
2014-03-25 18:56:42.625587	10214	20.2	1	1
2014-03-25 18:56:42.850308	10215	55	2	1
2014-03-26 20:52:33.383095	30640	48	2	8
2014-03-26 20:52:47.737598	30641	20.7	1	1
2014-03-25 18:57:06.179436	10220	20.5	1	8
2014-03-25 18:57:06.595698	10221	55	2	8
2014-03-25 18:57:20.741511	10222	402	3	2
2014-03-25 18:57:21.626586	10223	20.2	1	1
2014-03-25 18:57:21.856059	10224	55	2	1
2014-03-25 18:57:32.741403	10225	402	3	2
2014-03-26 20:52:47.968551	30642	50	2	1
2014-03-26 20:53:00.684296	30643	23.7	1	10
2014-03-25 18:57:45.178485	10230	20.5	1	8
2014-03-25 18:57:45.409093	10231	55	2	8
2014-03-25 18:58:00.62279	10232	20.2	1	1
2014-03-25 18:58:00.843918	10233	55	2	1
2014-03-26 20:53:00.920517	30644	41	2	10
2014-03-26 20:53:11.050771	30645	22.2	1	9
2014-03-25 18:58:24.180681	10238	20.5	1	8
2014-03-25 18:58:24.4128	10239	55	2	8
2014-03-25 18:58:32.738681	10240	402	3	2
2014-03-25 18:58:39.625881	10241	20.2	1	1
2014-03-25 18:58:39.857739	10242	55	2	1
2014-03-26 20:53:11.274427	30646	48	2	9
2014-03-26 20:53:12.139085	30647	22.6	1	8
2014-03-25 18:59:03.178617	10247	20.5	1	8
2014-03-25 18:59:03.400638	10248	55	2	8
2014-03-25 18:59:18.623771	10249	20.2	1	1
2014-03-25 18:59:18.857806	10250	55	2	1
2014-03-25 18:59:32.742517	10251	402	3	2
2014-03-26 20:53:12.371239	30648	48	2	8
2014-03-26 20:53:26.724149	30649	20.7	1	1
2014-03-25 18:59:42.1778	10256	20.5	1	8
2014-03-25 18:59:42.409665	10257	55	2	8
2014-03-25 18:59:57.62286	10258	20.2	1	1
2014-03-25 18:59:57.846073	10259	55	2	1
2014-03-26 20:53:26.949564	30650	50	2	1
2014-03-26 20:53:32.574245	30651	531	3	2
2014-03-25 19:00:21.178592	10264	20.5	1	8
2014-03-25 19:00:21.419873	10265	55	2	8
2014-03-25 19:00:32.738163	10266	402	3	2
2014-03-25 19:00:36.625584	10267	20.2	1	1
2014-03-25 19:00:36.84679	10268	55	2	1
2014-03-26 20:53:32.809297	30652	1087704.3538132752	4	2
2014-03-26 20:53:39.685377	30653	23.7	1	10
2014-03-25 19:01:00.177926	10273	20.5	1	8
2014-03-25 19:01:00.398743	10274	55	2	8
2014-03-25 19:01:15.621686	10275	20.2	1	1
2014-03-25 19:01:15.854288	10276	54	2	1
2014-03-25 19:01:32.742337	10277	338	3	2
2014-03-26 20:53:39.913331	30654	41	2	10
2014-03-26 20:53:50.049916	30655	22.2	1	9
2014-03-25 19:01:39.177929	10282	20.5	1	8
2014-03-25 19:01:39.402156	10283	55	2	8
2014-03-25 19:01:44.740882	10284	338	3	2
2014-03-25 19:01:54.624866	10285	20.2	1	1
2014-03-25 19:01:54.848328	10286	54	2	1
2014-03-26 20:53:50.284885	30656	48	2	9
2014-03-26 20:53:51.138021	30657	22.6	1	8
2014-03-25 19:02:18.2164	10291	20.5	1	8
2014-03-25 19:02:18.467321	10292	55	2	8
2014-03-25 19:02:33.422631	10293	338	3	2
2014-03-25 19:02:33.728507	10294	20.2	1	1
2014-03-25 19:02:33.952032	10295	54	2	1
2014-03-26 20:53:51.360904	30658	48	2	8
2014-03-26 20:54:05.734624	30659	20.7	1	1
2014-03-25 19:02:57.178129	10300	20.5	1	8
2014-03-25 19:02:57.399668	10301	55	2	8
2014-03-25 19:03:12.619739	10302	20.2	1	1
2014-03-25 19:03:12.851275	10303	54	2	1
2014-03-25 19:03:32.740507	10304	338	3	2
2014-03-26 20:54:05.971824	30660	50	2	1
2014-03-26 20:54:18.684315	30661	23.7	1	10
2014-03-25 19:03:36.179117	10309	20.5	1	8
2014-03-25 19:03:36.420666	10310	55	2	8
2014-03-25 19:03:51.621415	10311	20.2	1	1
2014-03-25 19:03:51.844132	10312	54	2	1
2014-03-26 20:54:18.910026	30662	41	2	10
2014-03-26 20:54:29.070495	30663	22.2	1	9
2014-03-25 19:04:15.177018	10317	20.5	1	8
2014-03-25 19:04:15.409119	10318	55	2	8
2014-03-25 19:04:30.62527	10319	20.2	1	1
2014-03-25 19:04:30.846432	10320	54	2	1
2014-03-25 19:04:32.74164	10321	338	3	2
2014-03-26 20:54:29.305291	30664	48	2	9
2014-03-25 19:04:54.178007	10326	20.5	1	8
2014-03-25 19:04:54.400575	10327	55	2	8
2014-03-25 19:05:09.619568	10328	20.2	1	1
2014-03-25 19:05:09.853804	10329	54	2	1
2014-03-25 19:05:32.738948	10334	338	3	2
2014-03-25 19:05:33.179132	10335	20.5	1	8
2014-03-25 19:05:33.403483	10336	55	2	8
2014-03-25 18:56:24.933568	10207	22.1	1	10
2014-03-25 18:56:25.156826	10208	51	2	10
2014-03-25 18:57:03.938308	10216	22.1	1	10
2014-03-25 18:57:04.181288	10217	51	2	10
2014-03-25 18:57:42.933762	10226	22.1	1	10
2014-03-25 18:57:43.168884	10227	51	2	10
2014-03-25 18:58:21.934159	10234	22.1	1	10
2014-03-25 18:58:22.166676	10235	51	2	10
2014-03-25 18:59:00.933315	10243	22.1	1	10
2014-03-25 18:59:01.153883	10244	51	2	10
2014-03-25 18:59:39.935069	10252	22.2	1	10
2014-03-25 18:59:40.16563	10253	51	2	10
2014-03-25 19:00:18.935033	10260	22.2	1	10
2014-03-25 19:00:19.166118	10261	51	2	10
2014-03-25 19:00:57.934126	10269	22.2	1	10
2014-03-25 19:00:58.155271	10270	51	2	10
2014-03-25 19:01:36.93384	10278	22.2	1	10
2014-03-25 19:01:37.157793	10279	51	2	10
2014-03-25 19:02:15.935598	10287	22.2	1	10
2014-03-25 19:02:16.169491	10288	51	2	10
2014-03-25 19:02:54.934862	10296	22.2	1	10
2014-03-25 19:02:55.160152	10297	51	2	10
2014-03-25 19:03:33.933621	10305	22.2	1	10
2014-03-25 19:03:34.15886	10306	51	2	10
2014-03-25 19:04:12.935224	10313	22.2	1	10
2014-03-25 19:04:13.166487	10314	51	2	10
2014-03-25 19:04:51.936565	10322	22.2	1	10
2014-03-25 19:04:52.157735	10323	51	2	10
2014-03-25 19:05:30.935758	10330	22.3	1	10
2014-03-25 19:05:31.158001	10331	51	2	10
2014-03-25 19:05:48.625053	10337	20.2	1	1
2014-03-25 19:05:48.848737	10338	54	2	1
2014-03-26 20:54:30.140322	30665	22.6	1	8
2014-03-26 20:54:30.363175	30666	48	2	8
2014-03-25 19:06:12.178145	10343	20.5	1	8
2014-03-25 19:06:12.410923	10344	55	2	8
2014-03-25 19:06:27.621791	10345	20.3	1	1
2014-03-25 19:06:27.847664	10346	54	2	1
2014-03-25 19:06:32.742273	10347	338	3	2
2014-03-26 20:54:32.570351	30667	515	3	2
2014-03-26 20:54:32.804061	30668	1087713.5460910464	4	2
2014-03-25 19:06:51.178062	10352	20.5	1	8
2014-03-25 19:06:51.398541	10353	55	2	8
2014-03-25 19:07:06.617936	10354	20.3	1	1
2014-03-25 19:07:06.863805	10355	54	2	1
2014-03-26 20:54:44.971653	30669	20.7	1	1
2014-03-26 20:54:45.199007	30670	50	2	1
2014-03-25 19:07:30.178591	10360	20.5	1	8
2014-03-25 19:07:30.39848	10361	55	2	8
2014-03-25 19:07:32.737683	10362	338	3	2
2014-03-25 19:07:44.7422	10363	402	3	2
2014-03-25 19:07:45.616204	10364	20.3	1	1
2014-03-25 19:07:45.837957	10365	54	2	1
2014-03-25 19:07:56.738986	10366	402	3	2
2014-03-26 20:54:57.684536	30671	23.7	1	10
2014-03-26 20:54:57.93902	30672	41	2	10
2014-03-25 19:08:09.178871	10371	20.5	1	8
2014-03-25 19:08:09.409456	10372	55	2	8
2014-03-25 19:08:24.617016	10373	20.3	1	1
2014-03-25 19:08:24.838496	10374	54	2	1
2014-03-25 19:08:32.739965	10375	402	3	2
2014-03-26 20:55:08.049937	30673	22.2	1	9
2014-03-26 20:55:08.276109	30674	48	2	9
2014-03-25 19:08:48.179492	10380	20.5	1	8
2014-03-25 19:08:48.40292	10381	55	2	8
2014-03-25 19:09:03.618912	10382	20.3	1	1
2014-03-25 19:09:03.840206	10383	54	2	1
2014-03-26 20:55:09.140522	30675	22.6	1	8
2014-03-26 20:55:09.375191	30676	48	2	8
2014-03-25 19:09:27.177665	10388	20.5	1	8
2014-03-25 19:09:27.400872	10389	55	2	8
2014-03-25 19:09:32.740683	10390	402	3	2
2014-03-25 19:09:42.620599	10391	20.3	1	1
2014-03-25 19:09:42.854208	10392	54	2	1
2014-03-26 20:55:20.57333	30677	482	3	2
2014-03-26 20:55:20.79783	30678	1087720.440299375	4	2
2014-03-25 19:10:06.177547	10397	20.5	1	8
2014-03-25 19:10:06.400132	10398	55	2	8
2014-03-25 19:10:21.617764	10399	20.4	1	1
2014-03-25 19:10:21.861556	10400	54	2	1
2014-03-25 19:10:32.739192	10401	402	3	2
2014-03-26 20:55:23.733361	30679	20.7	1	1
2014-03-26 20:55:23.968633	30680	50	2	1
2014-03-25 19:10:45.177689	10406	20.5	1	8
2014-03-25 19:10:45.400161	10407	55	2	8
2014-03-25 19:11:00.618169	10408	20.4	1	1
2014-03-25 19:11:00.838273	10409	54	2	1
2014-03-26 20:55:32.573146	30681	531	3	2
2014-03-26 20:55:32.797251	30682	1087722.7383688178	4	2
2014-03-25 19:11:24.177276	10414	20.5	1	8
2014-03-25 19:11:24.410053	10415	55	2	8
2014-03-25 19:11:32.74245	10416	338	3	2
2014-03-25 19:11:39.621025	10417	20.4	1	1
2014-03-25 19:11:39.843109	10418	54	2	1
2014-03-25 19:11:44.738329	10419	338	3	2
2014-03-26 20:55:36.685435	30683	23.8	1	10
2014-03-26 20:55:36.920492	30684	41	2	10
2014-03-25 19:12:03.179203	10424	20.5	1	8
2014-03-25 19:12:03.401598	10425	55	2	8
2014-03-25 19:12:18.81272	10426	20.4	1	1
2014-03-25 19:12:19.259986	10427	54	2	1
2014-03-25 19:12:32.739324	10428	434	3	2
2014-03-26 20:55:44.569735	30685	531	3	2
2014-03-26 20:55:44.794776	30686	1087723.8874035391	4	2
2014-03-25 19:12:42.177467	10433	20.5	1	8
2014-03-25 19:12:42.409148	10434	55	2	8
2014-03-25 19:12:44.740285	10435	434	3	2
2014-03-25 19:12:57.614672	10436	20.4	1	1
2014-03-25 19:12:57.837578	10437	54	2	1
2014-03-26 20:55:47.049612	30687	22.2	1	9
2014-03-26 20:55:47.295639	30688	48	2	9
2014-03-25 19:13:21.177696	10442	20.5	1	8
2014-03-25 19:13:21.398754	10443	55	2	8
2014-03-25 19:13:32.74172	10444	434	3	2
2014-03-25 19:13:36.617834	10445	20.4	1	1
2014-03-25 19:13:36.838713	10446	53	2	1
2014-03-26 20:55:48.138771	30689	22.6	1	8
2014-03-26 20:55:48.364833	30690	48	2	8
2014-03-25 19:14:00.177977	10451	20.5	1	8
2014-03-25 19:14:00.408859	10452	55	2	8
2014-03-25 19:14:15.615847	10453	20.5	1	1
2014-03-25 19:14:15.837879	10454	53	2	1
2014-03-25 19:14:32.738574	10455	434	3	2
2014-03-26 20:56:02.73039	30691	20.7	1	1
2014-03-26 20:56:02.96568	30692	50	2	1
2014-03-25 19:14:39.182457	10460	20.5	1	8
2014-03-25 19:14:39.404448	10461	55	2	8
2014-03-25 19:14:54.613991	10462	20.5	1	1
2014-03-25 19:14:54.845547	10463	53	2	1
2014-03-26 20:56:15.685007	30693	23.8	1	10
2014-03-25 19:15:18.17843	10468	20.5	1	8
2014-03-25 19:15:18.401969	10469	55	2	8
2014-03-25 19:15:32.740384	10470	434	3	2
2014-03-25 19:15:33.615966	10471	20.5	1	1
2014-03-25 19:15:33.840926	10472	53	2	1
2014-03-25 19:06:09.93633	10339	22.3	1	10
2014-03-25 19:06:10.167782	10340	51	2	10
2014-03-25 19:06:48.937112	10348	22.3	1	10
2014-03-25 19:06:49.161855	10349	51	2	10
2014-03-25 19:07:27.938494	10356	22.3	1	10
2014-03-25 19:07:28.159962	10357	51	2	10
2014-03-25 19:08:06.937079	10367	22.3	1	10
2014-03-25 19:08:07.161514	10368	51	2	10
2014-03-25 19:08:45.936182	10376	22.3	1	10
2014-03-25 19:08:46.159631	10377	51	2	10
2014-03-25 19:09:24.936506	10384	22.3	1	10
2014-03-25 19:09:25.160391	10385	51	2	10
2014-03-25 19:10:03.938582	10393	22.3	1	10
2014-03-25 19:10:04.161159	10394	51	2	10
2014-03-25 19:10:42.935602	10402	22.4	1	10
2014-03-25 19:10:43.157451	10403	51	2	10
2014-03-25 19:11:21.938107	10410	22.4	1	10
2014-03-25 19:11:22.161938	10411	51	2	10
2014-03-25 19:12:00.937349	10420	22.4	1	10
2014-03-25 19:12:01.16143	10421	51	2	10
2014-03-25 19:12:39.938305	10429	22.4	1	10
2014-03-25 19:12:40.163713	10430	51	2	10
2014-03-25 19:13:18.940055	10438	22.4	1	10
2014-03-25 19:13:19.163942	10439	51	2	10
2014-03-25 19:13:57.940096	10447	22.4	1	10
2014-03-25 19:13:58.17457	10448	51	2	10
2014-03-25 19:14:36.93918	10456	22.4	1	10
2014-03-25 19:14:37.161292	10457	51	2	10
2014-03-26 20:56:15.909884	30694	41	2	10
2014-03-26 20:56:26.050582	30695	22.2	1	9
2014-03-25 19:15:57.177359	10477	20.5	1	8
2014-03-25 19:15:57.41011	10478	55	2	8
2014-03-25 19:16:12.615732	10479	20.5	1	1
2014-03-25 19:16:12.840503	10480	53	2	1
2014-03-25 19:16:32.742874	10481	434	3	2
2014-03-26 20:56:26.283606	30696	48	2	9
2014-03-26 20:56:27.137273	30697	22.6	1	8
2014-03-25 19:16:36.177872	10486	20.5	1	8
2014-03-25 19:16:36.39878	10487	55	2	8
2014-03-25 19:16:51.617039	10488	20.5	1	1
2014-03-25 19:16:51.861068	10489	53	2	1
2014-03-26 20:56:27.360809	30698	48	2	8
2014-03-26 20:56:32.569014	30699	531	3	2
2014-03-25 19:17:15.180292	10494	20.5	1	8
2014-03-25 19:17:15.400843	10495	55	2	8
2014-03-25 19:17:30.614631	10496	20.5	1	1
2014-03-25 19:17:30.849603	10497	53	2	1
2014-03-25 19:17:32.739692	10498	418	3	2
2014-03-25 19:17:44.741522	10499	482	3	2
2014-03-26 20:56:32.804738	30700	1087730.7816118677	4	2
2014-03-26 20:56:41.730964	30701	20.7	1	1
2014-03-25 19:17:54.178288	10504	20.5	1	8
2014-03-25 19:17:54.410825	10505	55	2	8
2014-03-25 19:17:56.737153	10506	466	3	2
2014-03-25 19:18:09.615593	10507	20.6	1	1
2014-03-25 19:18:09.840654	10508	53	2	1
2014-03-26 20:56:41.954973	30702	50	2	1
2014-03-26 20:56:54.68335	30703	23.8	1	10
2014-03-25 19:18:32.736467	10513	466	3	2
2014-03-25 19:18:33.17964	10514	20.5	1	8
2014-03-25 19:18:33.401251	10515	55	2	8
2014-03-25 19:18:48.616033	10516	20.6	1	1
2014-03-25 19:18:48.838632	10517	53	2	1
2014-03-26 20:56:54.918403	30704	41	2	10
2014-03-26 20:57:05.050927	30705	22.2	1	9
2014-03-25 19:19:12.17772	10522	20.5	1	8
2014-03-25 19:19:12.406952	10523	55	2	8
2014-03-25 19:19:27.611901	10524	20.6	1	1
2014-03-25 19:19:27.835437	10525	53	2	1
2014-03-25 19:19:32.740121	10526	482	3	2
2014-03-26 20:57:05.275985	30706	48	2	9
2014-03-26 20:57:06.13777	30707	22.6	1	8
2014-03-25 19:19:51.179863	10531	20.5	1	8
2014-03-25 19:19:51.401015	10532	55	2	8
2014-03-25 19:20:06.611467	10533	20.6	1	1
2014-03-25 19:20:06.852607	10534	53	2	1
2014-03-26 20:57:06.369499	30708	48	2	8
2014-03-26 20:57:20.973491	30709	20.7	1	1
2014-03-25 19:20:30.177852	10539	20.5	1	8
2014-03-25 19:20:30.400376	10540	55	2	8
2014-03-25 19:20:32.736502	10541	466	3	2
2014-03-25 19:20:45.612179	10542	20.6	1	1
2014-03-25 19:20:45.834568	10543	53	2	1
2014-03-26 20:57:21.197685	30710	50	2	1
2014-03-26 20:57:32.569939	30711	595	3	2
2014-03-25 19:21:09.178043	10548	20.5	1	8
2014-03-25 19:21:09.411151	10549	55	2	8
2014-03-25 19:21:24.609514	10550	20.6	1	1
2014-03-25 19:21:24.832833	10551	53	2	1
2014-03-25 19:21:32.740513	10552	466	3	2
2014-03-26 20:57:32.80689	30712	1087739.9738896391	4	2
2014-03-26 20:57:33.686292	30713	23.8	1	10
2014-03-25 19:21:48.234497	10557	20.5	1	8
2014-03-25 19:21:48.457088	10558	55	2	8
2014-03-25 19:22:03.613795	10559	20.6	1	1
2014-03-25 19:22:03.845505	10560	53	2	1
2014-03-25 19:22:20.738869	10561	418	3	2
2014-03-26 20:57:33.910774	30714	41	2	10
2014-03-26 20:57:44.050994	30715	22.2	1	9
2014-03-25 19:22:27.310039	10566	20.5	1	8
2014-03-25 19:22:27.730036	10567	55	2	8
2014-03-25 19:22:32.870229	10568	418	3	2
2014-03-25 19:22:42.612757	10569	20.7	1	1
2014-03-25 19:22:42.840649	10570	53	2	1
2014-03-26 20:57:44.286707	30716	48	2	9
2014-03-26 20:57:45.138312	30717	22.6	1	8
2014-03-25 19:23:06.178684	10575	20.5	1	8
2014-03-25 19:23:06.403033	10576	55	2	8
2014-03-25 19:23:21.608035	10577	20.7	1	1
2014-03-25 19:23:21.85309	10578	53	2	1
2014-03-25 19:23:32.738179	10579	418	3	2
2014-03-26 20:57:45.362505	30718	48	2	8
2014-03-26 20:57:59.733486	30719	20.7	1	1
2014-03-25 19:23:45.176606	10584	20.5	1	8
2014-03-25 19:23:45.399269	10585	55	2	8
2014-03-25 19:24:00.610348	10586	20.7	1	1
2014-03-25 19:24:00.832537	10587	53	2	1
2014-03-26 20:57:59.969494	30720	50	2	1
2014-03-26 20:58:12.685158	30721	23.8	1	10
2014-03-25 19:24:24.178048	10592	20.5	1	8
2014-03-25 19:24:24.410909	10593	55	2	8
2014-03-25 19:24:32.7374	10594	418	3	2
2014-03-25 19:24:39.611918	10595	20.7	1	1
2014-03-25 19:24:39.833893	10596	53	2	1
2014-03-26 20:58:12.912713	30722	41	2	10
2014-03-26 20:58:23.050187	30723	22.2	1	9
2014-03-26 20:58:23.283113	30724	48	2	9
2014-03-25 19:25:03.179988	10601	20.5	1	8
2014-03-25 19:25:03.401928	10602	55	2	8
2014-03-25 19:25:18.607655	10603	20.7	1	1
2014-03-25 19:25:18.839455	10604	53	2	1
2014-03-25 19:25:32.739337	10605	418	3	2
2014-03-25 19:15:54.939753	10473	22.5	1	10
2014-03-25 19:15:55.171293	10474	51	2	10
2014-03-25 19:16:33.939076	10482	22.5	1	10
2014-03-25 19:16:34.162099	10483	51	2	10
2014-03-25 19:17:12.941191	10490	22.5	1	10
2014-03-25 19:17:13.16398	10491	51	2	10
2014-03-25 19:17:51.939957	10500	22.5	1	10
2014-03-25 19:17:52.173039	10501	51	2	10
2014-03-25 19:18:30.94235	10509	22.5	1	10
2014-03-25 19:18:31.165686	10510	51	2	10
2014-03-25 19:19:09.942012	10518	22.5	1	10
2014-03-25 19:19:10.175444	10519	51	2	10
2014-03-25 19:19:48.943774	10527	22.5	1	10
2014-03-25 19:19:49.168069	10528	51	2	10
2014-03-25 19:20:27.940399	10535	22.5	1	10
2014-03-25 19:20:28.162885	10536	51	2	10
2014-03-25 19:21:06.940874	10544	22.5	1	10
2014-03-25 19:21:07.173184	10545	51	2	10
2014-03-25 19:21:45.941808	10553	22.6	1	10
2014-03-25 19:21:46.164216	10554	51	2	10
2014-03-25 19:22:25.06726	10562	22.6	1	10
2014-03-25 19:22:25.490007	10563	51	2	10
2014-03-25 19:23:03.942511	10571	22.6	1	10
2014-03-25 19:23:04.164746	10572	51	2	10
2014-03-25 19:23:42.947342	10580	22.6	1	10
2014-03-25 19:23:43.168569	10581	51	2	10
2014-03-25 19:24:21.941687	10588	22.6	1	10
2014-03-25 19:24:22.177962	10589	51	2	10
2014-03-25 19:25:00.941608	10597	22.6	1	10
2014-03-26 20:58:24.137526	30725	22.6	1	8
2014-03-25 19:25:42.17811	10610	20.5	1	8
2014-03-25 19:25:42.4109	10611	55	2	8
2014-03-25 19:25:57.609514	10612	20.7	1	1
2014-03-25 19:25:57.831897	10613	53	2	1
2014-03-26 20:58:24.362998	30726	48	2	8
2014-03-26 20:58:32.569016	30727	595	3	2
2014-03-25 19:26:21.178683	10618	20.5	1	8
2014-03-25 19:26:21.411714	10619	55	2	8
2014-03-25 19:26:32.738689	10620	418	3	2
2014-03-25 19:26:36.606364	10621	20.7	1	1
2014-03-25 19:26:36.847361	10622	53	2	1
2014-03-25 19:26:56.739331	10623	338	3	2
2014-03-26 20:58:32.806151	30728	1087750.3152021319	4	2
2014-03-26 20:58:38.732216	30729	20.7	1	1
2014-03-25 19:27:00.177906	10628	20.5	1	8
2014-03-25 19:27:00.409424	10629	55	2	8
2014-03-25 19:27:08.735134	10630	338	3	2
2014-03-25 19:27:15.610241	10631	20.7	1	1
2014-03-25 19:27:15.833638	10632	53	2	1
2014-03-25 19:27:32.733939	10633	354	3	2
2014-03-26 20:58:38.959382	30730	50	2	1
2014-03-26 20:58:51.696871	30731	23.8	1	10
2014-03-25 19:27:39.178513	10638	20.5	1	8
2014-03-25 19:27:39.401949	10639	55	2	8
2014-03-25 19:27:54.608791	10640	20.7	1	1
2014-03-25 19:27:54.8438	10641	52	2	1
2014-03-26 20:58:51.932798	30732	41	2	10
2014-03-26 20:59:02.050059	30733	22.2	1	9
2014-03-25 19:28:18.17865	10646	20.5	1	8
2014-03-25 19:28:18.404018	10647	55	2	8
2014-03-25 19:28:32.740281	10648	338	3	2
2014-03-25 19:28:33.607292	10649	20.7	1	1
2014-03-25 19:28:33.831798	10650	52	2	1
2014-03-25 19:28:44.735147	10651	402	3	2
2014-03-26 20:59:02.274414	30734	48	2	9
2014-03-26 20:59:03.137828	30735	22.6	1	8
2014-03-25 19:28:56.735567	10656	402	3	2
2014-03-25 19:28:57.177432	10657	20.5	1	8
2014-03-25 19:28:57.399807	10658	55	2	8
2014-03-25 19:29:12.605966	10659	20.7	1	1
2014-03-25 19:29:12.840071	10660	52	2	1
2014-03-25 19:29:32.734017	10661	402	3	2
2014-03-26 20:59:03.383242	30736	48	2	8
2014-03-26 20:59:17.732611	30737	20.7	1	1
2014-03-25 19:29:36.178004	10666	20.5	1	8
2014-03-25 19:29:36.418476	10667	55	2	8
2014-03-25 19:29:51.60844	10668	20.7	1	1
2014-03-25 19:29:51.831241	10669	52	2	1
2014-03-26 20:59:17.957736	30738	50	2	1
2014-03-26 20:59:30.686338	30739	23.8	1	10
2014-03-25 19:30:15.180366	10674	20.5	1	8
2014-03-25 19:30:15.412752	10675	55	2	8
2014-03-25 19:30:30.603436	10676	20.7	1	1
2014-03-25 19:30:30.825369	10677	52	2	1
2014-03-25 19:30:32.738588	10678	418	3	2
2014-03-26 20:59:30.921448	30740	41	2	10
2014-03-26 20:59:32.571054	30741	595	3	2
2014-03-25 19:30:54.179824	10683	20.5	1	8
2014-03-25 19:30:54.40046	10684	55	2	8
2014-03-25 19:31:09.604234	10685	20.7	1	1
2014-03-25 19:31:09.837055	10686	52	2	1
2014-03-26 20:59:32.795686	30742	1087760.6565146246	4	2
2014-03-26 20:59:41.052938	30743	22.3	1	9
2014-03-25 19:31:32.73391	10691	418	3	2
2014-03-25 19:31:33.176983	10692	20.5	1	8
2014-03-25 19:31:33.399834	10693	55	2	8
2014-03-25 19:31:48.628238	10694	20.7	1	1
2014-03-25 19:31:48.852266	10695	52	2	1
2014-03-26 20:59:41.286123	30744	48	2	9
2014-03-26 20:59:42.137607	30745	22.6	1	8
2014-03-25 19:32:12.177944	10700	20.5	1	8
2014-03-25 19:32:12.408691	10701	55	2	8
2014-03-25 19:32:27.64404	10702	20.7	1	1
2014-03-25 19:32:27.867247	10703	52	2	1
2014-03-25 19:32:32.738683	10704	402	3	2
2014-03-26 20:59:42.361225	30746	48	2	8
2014-03-26 20:59:56.731476	30747	20.6	1	1
2014-03-25 19:32:51.310002	10709	20.5	1	8
2014-03-25 19:32:51.779992	10710	55	2	8
2014-03-25 19:33:06.608298	10711	20.7	1	1
2014-03-25 19:33:06.850757	10712	52	2	1
2014-03-26 20:59:56.967737	30748	50	2	1
2014-03-26 21:00:09.686031	30749	23.9	1	10
2014-03-25 19:33:30.177346	10717	20.5	1	8
2014-03-25 19:33:30.400291	10718	55	2	8
2014-03-25 19:33:32.737099	10719	402	3	2
2014-03-25 19:33:45.609191	10720	20.7	1	1
2014-03-25 19:33:45.835645	10721	52	2	1
2014-03-26 21:00:09.914557	30750	41	2	10
2014-03-26 21:00:20.049463	30751	22.3	1	9
2014-03-25 19:34:09.178881	10726	20.5	1	8
2014-03-25 19:34:09.410806	10727	55	2	8
2014-03-25 19:34:20.741225	10728	370	3	2
2014-03-25 19:34:24.60468	10729	20.7	1	1
2014-03-25 19:34:24.836215	10730	52	2	1
2014-03-25 19:34:32.738661	10731	370	3	2
2014-03-26 21:00:20.284977	30752	48	2	9
2014-03-26 21:00:21.13901	30753	22.6	1	8
2014-03-25 19:34:48.178244	10736	20.5	1	8
2014-03-25 19:34:48.399563	10737	55	2	8
2014-03-25 19:35:03.601935	10738	20.7	1	1
2014-03-25 19:35:03.836122	10739	52	2	1
2014-03-25 19:35:27.177837	10744	20.5	1	8
2014-03-25 19:26:18.970073	10614	22.6	1	10
2014-03-25 19:26:19.235895	10615	51	2	10
2014-03-25 19:26:57.94199	10624	22.7	1	10
2014-03-25 19:26:58.16347	10625	51	2	10
2014-03-25 19:27:36.943667	10634	22.7	1	10
2014-03-25 19:27:37.176737	10635	51	2	10
2014-03-25 19:28:15.942566	10642	22.7	1	10
2014-03-25 19:28:16.164145	10643	51	2	10
2014-03-25 19:28:54.945346	10652	22.7	1	10
2014-03-25 19:28:55.167892	10653	51	2	10
2014-03-25 19:29:33.947591	10662	22.7	1	10
2014-03-25 19:29:34.168704	10663	51	2	10
2014-03-25 19:30:12.944183	10670	22.7	1	10
2014-03-25 19:30:13.17724	10671	51	2	10
2014-03-25 19:30:51.940582	10679	22.7	1	10
2014-03-25 19:30:52.165615	10680	51	2	10
2014-03-25 19:31:30.942459	10687	22.7	1	10
2014-03-25 19:31:31.166957	10688	51	2	10
2014-03-25 19:32:09.945655	10696	22.7	1	10
2014-03-25 19:32:10.177355	10697	51	2	10
2014-03-25 19:32:49.071264	10705	22.8	1	10
2014-03-25 19:32:49.491982	10706	51	2	10
2014-03-25 19:33:27.945681	10713	22.8	1	10
2014-03-25 19:33:28.168711	10714	51	2	10
2014-03-25 19:34:06.946328	10722	22.8	1	10
2014-03-25 19:34:07.178007	10723	51	2	10
2014-03-25 19:34:45.947234	10732	22.8	1	10
2014-03-25 19:34:46.169772	10733	51	2	10
2014-03-25 19:35:24.948603	10740	22.8	1	10
2014-03-25 19:35:27.399341	10745	55	2	8
2014-03-25 19:35:32.737696	10746	354	3	2
2014-03-25 19:35:42.60739	10747	20.7	1	1
2014-03-25 19:35:42.83004	10748	52	2	1
2014-03-26 21:00:21.363825	30754	48	2	8
2014-03-26 21:00:32.570307	30755	595	3	2
2014-03-25 19:36:06.179517	10753	20.5	1	8
2014-03-25 19:36:06.411461	10754	55	2	8
2014-03-25 19:36:21.604861	10755	20.7	1	1
2014-03-25 19:36:21.828672	10756	52	2	1
2014-03-25 19:36:32.739614	10757	370	3	2
2014-03-26 21:00:32.824499	30756	1087769.8487923958	4	2
2014-03-26 21:00:35.725829	30757	20.6	1	1
2014-03-25 19:36:45.17784	10762	20.5	1	8
2014-03-25 19:36:45.402545	10763	55	2	8
2014-03-25 19:37:00.602886	10764	20.7	1	1
2014-03-25 19:37:00.835225	10765	52	2	1
2014-03-26 21:00:35.951955	30758	50	2	1
2014-03-26 21:00:48.686237	30759	23.9	1	10
2014-03-25 19:37:24.177226	10770	20.5	1	8
2014-03-25 19:37:24.408327	10771	55	2	8
2014-03-25 19:37:32.736197	10772	354	3	2
2014-03-25 19:37:39.601938	10773	20.7	1	1
2014-03-25 19:37:39.827331	10774	52	2	1
2014-03-26 21:00:48.920237	30760	41	2	10
2014-03-26 21:00:59.050103	30761	22.3	1	9
2014-03-25 19:38:03.179229	10779	20.5	1	8
2014-03-25 19:38:03.410312	10780	55	2	8
2014-03-25 19:38:18.604568	10781	20.7	1	1
2014-03-25 19:38:18.827731	10782	52	2	1
2014-03-25 19:38:32.740909	10783	354	3	2
2014-03-26 21:00:59.275445	30762	48	2	9
2014-03-26 21:01:00.13743	30763	22.7	1	8
2014-03-25 19:38:42.177644	10788	20.5	1	8
2014-03-25 19:38:42.399843	10789	55	2	8
2014-03-25 19:38:57.843474	10790	20.7	1	1
2014-03-25 19:38:58.075901	10791	52	2	1
2014-03-26 21:01:00.372799	30764	48	2	8
2014-03-26 21:01:14.731035	30765	20.6	1	1
2014-03-25 19:39:21.176573	10796	20.5	1	8
2014-03-25 19:39:21.398146	10797	55	2	8
2014-03-25 19:39:32.734215	10798	338	3	2
2014-03-25 19:39:36.600676	10799	20.7	1	1
2014-03-25 19:39:36.823616	10800	52	2	1
2014-03-26 21:01:14.955201	30766	50	2	1
2014-03-26 21:01:27.686288	30767	23.9	1	10
2014-03-25 19:40:00.177004	10805	20.5	1	8
2014-03-25 19:40:00.406822	10806	55	2	8
2014-03-25 19:40:15.601143	10807	20.7	1	1
2014-03-25 19:40:15.8244	10808	52	2	1
2014-03-25 19:40:32.735194	10809	354	3	2
2014-03-26 21:01:27.92106	30768	41	2	10
2014-03-26 21:01:32.570424	30769	611	3	2
2014-03-25 19:40:39.178652	10814	20.5	1	8
2014-03-25 19:40:39.401326	10815	55	2	8
2014-03-25 19:40:54.838816	10816	20.6	1	1
2014-03-25 19:40:55.072599	10817	52	2	1
2014-03-25 19:40:56.734668	10818	418	3	2
2014-03-25 19:41:08.736748	10819	402	3	2
2014-03-26 21:01:32.794886	30770	1087780.1901048885	4	2
2014-03-26 21:01:38.050364	30771	22.3	1	9
2014-03-25 19:41:18.179953	10824	20.5	1	8
2014-03-25 19:41:18.413697	10825	55	2	8
2014-03-25 19:41:32.738266	10826	402	3	2
2014-03-25 19:41:33.599084	10827	20.6	1	1
2014-03-25 19:41:33.822107	10828	52	2	1
2014-03-26 21:01:38.287589	30772	48	2	9
2014-03-26 21:01:39.138744	30773	22.7	1	8
2014-03-25 19:41:57.177926	10833	20.5	1	8
2014-03-25 19:41:57.403832	10834	55	2	8
2014-03-25 19:42:12.602114	10835	20.6	1	1
2014-03-25 19:42:12.835227	10836	52	2	1
2014-03-25 19:42:32.736081	10837	402	3	2
2014-03-26 21:01:39.364491	30774	48	2	8
2014-03-26 21:01:53.727965	30775	20.6	1	1
2014-03-25 19:42:36.178037	10842	20.5	1	8
2014-03-25 19:42:36.411349	10843	55	2	8
2014-03-25 19:42:51.601418	10844	20.6	1	1
2014-03-25 19:42:51.828935	10845	52	2	1
2014-03-26 21:01:53.962518	30776	50	2	1
2014-03-26 21:02:06.688008	30777	23.9	1	10
2014-03-25 19:43:15.176862	10850	20.5	1	8
2014-03-25 19:43:15.409059	10851	55	2	8
2014-03-25 19:43:30.602908	10852	20.6	1	1
2014-03-25 19:43:30.825014	10853	52	2	1
2014-03-25 19:43:32.73265	10854	402	3	2
2014-03-26 21:02:06.911907	30778	41	2	10
2014-03-26 21:02:17.048013	30779	22.3	1	9
2014-03-25 19:43:54.177582	10859	20.5	1	8
2014-03-25 19:43:54.39994	10860	55	2	8
2014-03-25 19:44:09.594378	10861	20.6	1	1
2014-03-25 19:44:09.829313	10862	52	2	1
2014-03-26 21:02:17.283234	30780	48	2	9
2014-03-26 21:02:18.137845	30781	22.7	1	8
2014-03-25 19:44:32.734771	10867	402	3	2
2014-03-25 19:44:33.177332	10868	20.5	1	8
2014-03-25 19:44:33.398264	10869	55	2	8
2014-03-25 19:44:48.599149	10870	20.6	1	1
2014-03-25 19:44:48.82498	10871	52	2	1
2014-03-25 19:45:08.734184	10872	354	3	2
2014-03-26 21:02:18.361582	30782	48	2	8
2014-03-25 19:45:12.176907	10877	20.5	1	8
2014-03-25 19:45:12.410217	10878	55	2	8
2014-03-25 19:45:20.738876	10879	354	3	2
2014-03-25 19:45:27.597466	10880	20.6	1	1
2014-03-25 19:36:03.946159	10749	22.8	1	10
2014-03-25 19:36:04.170869	10750	51	2	10
2014-03-25 19:36:42.947639	10758	22.8	1	10
2014-03-25 19:36:43.169325	10759	51	2	10
2014-03-25 19:37:21.947933	10766	22.8	1	10
2014-03-25 19:37:22.172955	10767	51	2	10
2014-03-25 19:38:00.946664	10775	22.8	1	10
2014-03-25 19:38:01.176864	10776	51	2	10
2014-03-25 19:38:39.946018	10784	22.9	1	10
2014-03-25 19:38:40.168949	10785	51	2	10
2014-03-25 19:39:18.946073	10792	22.9	1	10
2014-03-25 19:39:19.170279	10793	51	2	10
2014-03-25 19:39:57.949299	10801	22.9	1	10
2014-03-25 19:39:58.19351	10802	51	2	10
2014-03-25 19:40:36.947774	10810	22.9	1	10
2014-03-25 19:40:37.17278	10811	51	2	10
2014-03-25 19:41:15.947247	10820	22.9	1	10
2014-03-25 19:41:16.181787	10821	51	2	10
2014-03-25 19:41:54.947404	10829	22.9	1	10
2014-03-25 19:41:55.171841	10830	51	2	10
2014-03-25 19:42:33.947923	10838	22.9	1	10
2014-03-25 19:42:34.189316	10839	51	2	10
2014-03-25 19:43:12.947651	10846	22.9	1	10
2014-03-25 19:43:13.19177	10847	51	2	10
2014-03-25 19:43:51.948711	10855	22.9	1	10
2014-03-25 19:43:52.172132	10856	51	2	10
2014-03-25 19:44:30.948827	10863	23.0	1	10
2014-03-25 19:44:31.171113	10864	51	2	10
2014-03-25 19:45:27.819888	10881	52	2	1
2014-03-25 19:45:32.737827	10882	354	3	2
2014-03-26 21:02:32.969435	30783	20.6	1	1
2014-03-26 21:02:33.218676	30784	50	2	1
2014-03-25 19:45:51.177685	10887	20.5	1	8
2014-03-25 19:45:51.407139	10888	55	2	8
2014-03-25 19:46:06.597757	10889	20.6	1	1
2014-03-25 19:46:06.82592	10890	52	2	1
2014-03-26 21:02:44.570599	30785	515	3	2
2014-03-26 21:02:44.796092	30786	1087791.6804521028	4	2
2014-03-25 19:46:30.178477	10895	20.5	1	8
2014-03-25 19:46:30.409812	10896	55	2	8
2014-03-25 19:46:32.742797	10897	354	3	2
2014-03-25 19:46:45.60165	10898	20.6	1	1
2014-03-25 19:46:45.823511	10899	52	2	1
2014-03-26 21:02:45.688604	30787	23.9	1	10
2014-03-26 21:02:46.109274	30788	41	2	10
2014-03-25 19:47:09.177405	10904	20.5	1	8
2014-03-25 19:47:09.401469	10905	55	2	8
2014-03-25 19:47:24.597869	10906	20.5	1	1
2014-03-25 19:47:24.835237	10907	52	2	1
2014-03-25 19:47:32.738084	10908	354	3	2
2014-03-26 21:02:56.049608	30789	22.3	1	9
2014-03-26 21:02:56.272056	30790	48	2	9
2014-03-25 19:47:48.177096	10913	20.5	1	8
2014-03-25 19:47:48.399476	10914	55	2	8
2014-03-25 19:48:03.596913	10915	20.5	1	1
2014-03-25 19:48:03.819938	10916	52	2	1
2014-03-26 21:02:56.584604	30791	531	3	2
2014-03-26 21:02:56.807297	30792	1087793.9785215457	4	2
2014-03-25 19:48:27.177424	10921	20.5	1	8
2014-03-25 19:48:27.409619	10922	55	2	8
2014-03-25 19:48:32.739015	10923	354	3	2
2014-03-25 19:48:42.59665	10924	20.5	1	1
2014-03-25 19:48:42.821151	10925	52	2	1
2014-03-26 21:02:57.136226	30793	22.7	1	8
2014-03-26 21:02:57.365793	30794	48	2	8
2014-03-25 19:49:06.176096	10930	20.5	1	8
2014-03-25 19:49:06.399059	10931	55	2	8
2014-03-25 19:49:21.596275	10932	20.5	1	1
2014-03-25 19:49:21.83166	10933	52	2	1
2014-03-25 19:49:32.735213	10934	354	3	2
2014-03-26 21:03:11.729569	30795	20.6	1	1
2014-03-26 21:03:11.953085	30796	50	2	1
2014-03-25 19:49:45.177346	10939	20.5	1	8
2014-03-25 19:49:45.409194	10940	55	2	8
2014-03-25 19:50:00.599823	10941	20.5	1	1
2014-03-25 19:50:00.825053	10942	52	2	1
2014-03-26 21:03:24.68646	30797	23.9	1	10
2014-03-26 21:03:24.919771	30798	41	2	10
2014-03-25 19:50:24.177613	10947	20.5	1	8
2014-03-25 19:50:24.409115	10948	55	2	8
2014-03-25 19:50:32.738116	10949	354	3	2
2014-03-25 19:50:39.593318	10950	20.5	1	1
2014-03-25 19:50:39.819055	10951	52	2	1
2014-03-26 21:03:32.56994	30799	531	3	2
2014-03-26 21:03:32.794387	30800	1087798.5746604311	4	2
2014-03-25 19:51:03.175814	10956	20.5	1	8
2014-03-25 19:51:03.39796	10957	55	2	8
2014-03-25 19:51:18.595425	10958	20.5	1	1
2014-03-25 19:51:18.828235	10959	52	2	1
2014-03-25 19:51:20.734196	10960	418	3	2
2014-03-25 19:51:32.736997	10961	418	3	2
2014-03-26 21:03:35.050091	30801	22.3	1	9
2014-03-26 21:03:35.28195	30802	48	2	9
2014-03-25 19:51:42.180629	10966	20.5	1	8
2014-03-25 19:51:42.413912	10967	55	2	8
2014-03-25 19:51:57.593094	10968	20.5	1	1
2014-03-25 19:51:57.818044	10969	52	2	1
2014-03-26 21:03:36.137221	30803	22.7	1	8
2014-03-26 21:03:36.35871	30804	48	2	8
2014-03-25 19:52:21.177521	10974	20.5	1	8
2014-03-25 19:52:21.410394	10975	55	2	8
2014-03-25 19:52:32.736305	10976	418	3	2
2014-03-25 19:52:36.595713	10977	20.5	1	1
2014-03-25 19:52:36.82223	10978	51	2	1
2014-03-26 21:03:50.728268	30805	20.6	1	1
2014-03-26 21:03:50.963776	30806	50	2	1
2014-03-25 19:53:00.176576	10983	20.5	1	8
2014-03-25 19:53:00.399448	10984	55	2	8
2014-03-25 19:53:15.719011	10985	20.5	1	1
2014-03-25 19:53:16.550018	10986	51	2	1
2014-03-25 19:53:32.732559	10987	418	3	2
2014-03-26 21:04:03.687707	30807	23.9	1	10
2014-03-26 21:04:03.911936	30808	41	2	10
2014-03-25 19:53:39.174566	10992	20.5	1	8
2014-03-25 19:53:39.405486	10993	55	2	8
2014-03-25 19:53:54.593074	10994	20.4	1	1
2014-03-25 19:53:54.819369	10995	51	2	1
2014-03-26 21:04:14.047646	30809	22.3	1	9
2014-03-26 21:04:14.282961	30810	48	2	9
2014-03-25 19:54:18.178143	11000	20.5	1	8
2014-03-25 19:54:18.408085	11001	55	2	8
2014-03-25 19:54:33.392348	11002	418	3	2
2014-03-25 19:54:33.698872	11003	20.4	1	1
2014-03-25 19:54:33.928602	11004	51	2	1
2014-03-26 21:04:15.137152	30811	22.7	1	8
2014-03-26 21:04:15.358187	30812	48	2	8
2014-03-26 21:04:20.568676	30813	482	3	2
2014-03-25 19:54:57.175113	11009	20.5	1	8
2014-03-25 19:54:57.395901	11010	55	2	8
2014-03-25 19:55:12.593588	11011	20.4	1	1
2014-03-25 19:55:12.825335	11012	51	2	1
2014-03-25 19:55:32.732486	11013	418	3	2
2014-03-25 19:45:49.005017	10883	23.0	1	10
2014-03-25 19:45:49.227403	10884	51	2	10
2014-03-25 19:46:27.94916	10891	23.0	1	10
2014-03-25 19:46:28.193975	10892	51	2	10
2014-03-25 19:47:06.949305	10900	23.0	1	10
2014-03-25 19:47:07.172485	10901	51	2	10
2014-03-25 19:47:45.950501	10909	23.0	1	10
2014-03-25 19:47:46.175146	10910	51	2	10
2014-03-25 19:48:24.953238	10917	23.0	1	10
2014-03-25 19:48:25.18641	10918	51	2	10
2014-03-25 19:49:03.950298	10926	23.0	1	10
2014-03-25 19:49:04.173462	10927	51	2	10
2014-03-25 19:49:42.950591	10935	23.0	1	10
2014-03-25 19:49:43.194114	10936	51	2	10
2014-03-25 19:50:21.952674	10943	23.1	1	10
2014-03-25 19:50:22.185315	10944	51	2	10
2014-03-25 19:51:00.95366	10952	23.1	1	10
2014-03-25 19:51:01.177335	10953	51	2	10
2014-03-25 19:51:39.952076	10962	23.1	1	10
2014-03-25 19:51:40.187811	10963	51	2	10
2014-03-25 19:52:18.950431	10970	23.1	1	10
2014-03-25 19:52:19.184047	10971	51	2	10
2014-03-25 19:52:57.952028	10979	23.1	1	10
2014-03-25 19:52:58.178164	10980	51	2	10
2014-03-25 19:53:36.950949	10988	23.1	1	10
2014-03-25 19:53:37.178262	10989	51	2	10
2014-03-25 19:54:15.950828	10996	23.1	1	10
2014-03-25 19:54:16.181817	10997	51	2	10
2014-03-25 19:54:54.951781	11005	23.1	1	10
2014-03-26 21:04:20.802852	30814	1087806.617903481	4	2
2014-03-25 19:55:36.174757	11018	20.5	1	8
2014-03-25 19:55:36.405146	11019	55	2	8
2014-03-25 19:55:44.734045	11020	354	3	2
2014-03-25 19:55:51.591688	11021	20.4	1	1
2014-03-25 19:55:51.813557	11022	51	2	1
2014-03-25 19:55:56.732597	11023	354	3	2
2014-03-26 21:04:29.728993	30815	20.6	1	1
2014-03-26 21:04:29.954508	30816	50	2	1
2014-03-25 19:56:15.176645	11028	20.5	1	8
2014-03-25 19:56:15.415113	11029	55	2	8
2014-03-25 19:56:30.590491	11030	20.4	1	1
2014-03-25 19:56:30.810847	11031	51	2	1
2014-03-25 19:56:32.733694	11032	354	3	2
2014-03-26 21:04:32.568064	30817	450	3	2
2014-03-26 21:04:32.803626	30818	1087807.7669382025	4	2
2014-03-25 19:56:54.178031	11037	20.5	1	8
2014-03-25 19:56:54.403657	11038	55	2	8
2014-03-25 19:57:09.589296	11039	20.4	1	1
2014-03-25 19:57:09.818076	11040	51	2	1
2014-03-26 21:04:42.68613	30819	23.9	1	10
2014-03-26 21:04:42.90934	30820	41	2	10
2014-03-25 19:57:32.730805	11045	354	3	2
2014-03-25 19:57:33.17637	11046	20.5	1	8
2014-03-25 19:57:33.396618	11047	55	2	8
2014-03-25 19:57:48.59367	11048	20.4	1	1
2014-03-25 19:57:49.160724	11049	51	2	1
2014-03-26 21:04:44.566311	30821	466	3	2
2014-03-26 21:04:44.797541	30822	1087808.9159729239	4	2
2014-03-25 19:58:12.174373	11054	20.5	1	8
2014-03-25 19:58:12.440214	11055	55	2	8
2014-03-25 19:58:27.592299	11056	20.4	1	1
2014-03-25 19:58:27.81419	11057	51	2	1
2014-03-25 19:58:32.729148	11058	354	3	2
2014-03-26 21:04:53.05036	30823	22.3	1	9
2014-03-26 21:04:53.27354	30824	48	2	9
2014-03-25 19:58:51.175185	11063	20.5	1	8
2014-03-25 19:58:51.395541	11064	55	2	8
2014-03-25 19:59:06.593332	11065	20.4	1	1
2014-03-25 19:59:06.826117	11066	51	2	1
2014-03-26 21:04:54.137142	30825	22.7	1	8
2014-03-26 21:04:54.369417	30826	47	2	8
2014-03-25 19:59:30.177698	11071	20.5	1	8
2014-03-25 19:59:30.400137	11072	55	2	8
2014-03-25 19:59:32.733003	11073	354	3	2
2014-03-25 19:59:45.595288	11074	20.4	1	1
2014-03-25 19:59:45.817744	11075	51	2	1
2014-03-26 21:04:56.568775	30827	547	3	2
2014-03-26 21:04:56.790302	30828	1087811.2140423667	4	2
2014-03-25 20:00:09.175081	11080	20.5	1	8
2014-03-25 20:00:09.408687	11081	56	2	8
2014-03-25 20:00:24.591474	11082	20.4	1	1
2014-03-25 20:00:24.815793	11083	51	2	1
2014-03-25 20:00:32.736472	11084	354	3	2
2014-03-26 21:05:08.96722	30829	20.6	1	1
2014-03-26 21:05:09.201795	30830	50	2	1
2014-03-25 20:00:48.175773	11089	20.5	1	8
2014-03-25 20:00:48.397039	11090	56	2	8
2014-03-25 20:01:03.588534	11091	20.3	1	1
2014-03-25 20:01:03.82074	11092	51	2	1
2014-03-26 21:05:20.56681	30831	579	3	2
2014-03-26 21:05:20.790608	30832	1087814.661146531	4	2
2014-03-25 20:01:27.175413	11097	20.5	1	8
2014-03-25 20:01:27.396394	11098	56	2	8
2014-03-25 20:01:32.734306	11099	338	3	2
2014-03-25 20:01:42.58789	11100	20.3	1	1
2014-03-25 20:01:42.812955	11101	51	2	1
2014-03-26 21:05:21.687503	30833	23.9	1	10
2014-03-26 21:05:21.936657	30834	41	2	10
2014-03-25 20:02:06.175609	11106	20.5	1	8
2014-03-25 20:02:06.395877	11107	56	2	8
2014-03-25 20:02:20.72907	11108	402	3	2
2014-03-25 20:02:21.586917	11109	20.3	1	1
2014-03-25 20:02:21.808612	11110	51	2	1
2014-03-25 20:02:32.728841	11111	418	3	2
2014-03-26 21:05:32.049681	30835	22.3	1	9
2014-03-26 21:05:32.275405	30836	48	2	9
2014-03-25 20:02:45.177596	11116	20.5	1	8
2014-03-25 20:02:45.419567	11117	56	2	8
2014-03-25 20:03:00.585675	11118	20.3	1	1
2014-03-25 20:03:00.807323	11119	51	2	1
2014-03-26 21:05:32.580676	30837	579	3	2
2014-03-26 21:05:32.815465	30838	1087816.9592159737	4	2
2014-03-25 20:03:24.307832	11124	20.5	1	8
2014-03-25 20:03:24.740001	11125	56	2	8
2014-03-25 20:03:32.869668	11126	418	3	2
2014-03-25 20:03:39.587558	11127	20.3	1	1
2014-03-25 20:03:39.810916	11128	51	2	1
2014-03-26 21:05:33.138933	30839	22.7	1	8
2014-03-26 21:05:33.363198	30840	47	2	8
2014-03-25 20:04:03.174793	11133	20.5	1	8
2014-03-25 20:04:03.396724	11134	56	2	8
2014-03-25 20:04:18.586632	11135	20.3	1	1
2014-03-25 20:04:18.809628	11136	51	2	1
2014-03-25 20:04:32.732355	11137	418	3	2
2014-03-26 21:05:47.726415	30841	20.6	1	1
2014-03-26 21:05:47.959862	30842	50	2	1
2014-03-25 20:04:42.176025	11142	20.6	1	8
2014-03-25 20:04:42.397989	11143	56	2	8
2014-03-25 20:04:57.58721	11144	20.3	1	1
2014-03-25 20:04:57.820289	11145	51	2	1
2014-03-25 20:05:21.174765	11150	20.6	1	8
2014-03-25 20:05:21.396711	11151	56	2	8
2014-03-25 20:05:32.732559	11152	418	3	2
2014-03-25 19:56:12.956865	11024	23.2	1	10
2014-03-25 19:56:13.178993	11025	51	2	10
2014-03-25 19:56:51.952771	11033	23.2	1	10
2014-03-25 19:56:52.175157	11034	51	2	10
2014-03-25 19:57:30.949817	11041	23.2	1	10
2014-03-25 19:57:31.172035	11042	51	2	10
2014-03-25 19:58:09.951126	11050	23.2	1	10
2014-03-25 19:58:10.235816	11051	51	2	10
2014-03-25 19:58:48.952607	11059	23.2	1	10
2014-03-25 19:58:49.174079	11060	51	2	10
2014-03-25 19:59:27.954316	11067	23.2	1	10
2014-03-25 19:59:28.183563	11068	51	2	10
2014-03-25 20:00:06.952723	11076	23.2	1	10
2014-03-25 20:00:07.18673	11077	51	2	10
2014-03-25 20:00:45.952698	11085	23.2	1	10
2014-03-25 20:00:46.175769	11086	51	2	10
2014-03-25 20:01:24.953546	11093	23.2	1	10
2014-03-25 20:01:25.182286	11094	51	2	10
2014-03-25 20:02:03.952776	11102	23.3	1	10
2014-03-25 20:02:04.175875	11103	51	2	10
2014-03-25 20:02:42.953563	11112	23.3	1	10
2014-03-25 20:02:43.178146	11113	51	2	10
2014-03-25 20:03:22.069295	11120	23.3	1	10
2014-03-25 20:03:22.515282	11121	51	2	10
2014-03-25 20:04:00.952558	11129	23.3	1	10
2014-03-25 20:04:01.174373	11130	51	2	10
2014-03-25 20:04:39.952796	11138	23.3	1	10
2014-03-25 20:04:40.174698	11139	51	2	10
2014-03-25 20:05:18.954551	11146	23.3	1	10
2014-03-25 20:05:36.589358	11153	20.3	1	1
2014-03-25 20:05:36.813376	11154	51	2	1
2014-03-26 21:06:00.688474	30843	24.0	1	10
2014-03-26 21:06:00.914745	30844	41	2	10
2014-03-25 20:06:00.17588	11159	20.6	1	8
2014-03-25 20:06:00.406623	11160	56	2	8
2014-03-25 20:06:15.587859	11161	20.3	1	1
2014-03-25 20:06:15.812988	11162	51	2	1
2014-03-25 20:06:32.731815	11163	418	3	2
2014-03-26 21:06:11.0487	30845	22.3	1	9
2014-03-26 21:06:11.283476	30846	48	2	9
2014-03-25 20:06:39.175812	11168	20.6	1	8
2014-03-25 20:06:39.39959	11169	56	2	8
2014-03-25 20:06:44.730846	11170	482	3	2
2014-03-25 20:06:54.585578	11171	20.3	1	1
2014-03-25 20:06:54.807694	11172	51	2	1
2014-03-25 20:06:56.732065	11173	482	3	2
2014-03-26 21:06:12.134659	30847	22.7	1	8
2014-03-26 21:06:12.359029	30848	47	2	8
2014-03-25 20:07:18.175002	11178	20.6	1	8
2014-03-25 20:07:18.405799	11179	56	2	8
2014-03-25 20:07:20.731318	11180	450	3	2
2014-03-25 20:07:32.730463	11181	450	3	2
2014-03-25 20:07:33.586871	11182	20.3	1	1
2014-03-25 20:07:33.817395	11183	51	2	1
2014-03-26 21:06:26.724632	30849	20.6	1	1
2014-03-26 21:06:26.958583	30850	50	2	1
2014-03-25 20:07:57.177832	11188	20.6	1	8
2014-03-25 20:07:57.398425	11189	56	2	8
2014-03-25 20:08:12.583867	11190	20.3	1	1
2014-03-25 20:08:12.815306	11191	51	2	1
2014-03-25 20:08:32.73186	11192	450	3	2
2014-03-26 21:06:32.569924	30851	547	3	2
2014-03-26 21:06:32.79447	30852	1087826.1514937452	4	2
2014-03-25 20:08:36.174484	11197	20.6	1	8
2014-03-25 20:08:36.398035	11198	56	2	8
2014-03-25 20:08:51.583205	11199	20.3	1	1
2014-03-25 20:08:51.805594	11200	51	2	1
2014-03-26 21:06:39.687202	30853	24.0	1	10
2014-03-26 21:06:39.91998	30854	41	2	10
2014-03-25 20:09:15.176578	11205	20.6	1	8
2014-03-25 20:09:15.40906	11206	56	2	8
2014-03-25 20:09:30.584967	11207	20.3	1	1
2014-03-25 20:09:30.80621	11208	51	2	1
2014-03-25 20:09:32.730511	11209	434	3	2
2014-03-26 21:06:44.565961	30855	547	3	2
2014-03-26 21:06:44.78944	30856	1087828.449563188	4	2
2014-03-25 20:09:54.175193	11214	20.6	1	8
2014-03-25 20:09:54.396187	11215	56	2	8
2014-03-25 20:10:09.586628	11216	20.3	1	1
2014-03-25 20:10:09.816791	11217	51	2	1
2014-03-26 21:06:50.048781	30857	22.3	1	9
2014-03-26 21:06:50.285649	30858	48	2	9
2014-03-25 20:10:32.734108	11222	434	3	2
2014-03-25 20:10:33.175557	11223	20.6	1	8
2014-03-25 20:10:33.39765	11224	56	2	8
2014-03-25 20:10:48.583616	11225	20.3	1	1
2014-03-25 20:10:48.808503	11226	51	2	1
2014-03-26 21:06:51.137967	30859	22.8	1	8
2014-03-26 21:06:51.362639	30860	47	2	8
2014-03-25 20:11:12.176114	11231	20.6	1	8
2014-03-25 20:11:12.405872	11232	56	2	8
2014-03-25 20:11:27.58106	11233	20.3	1	1
2014-03-25 20:11:27.806076	11234	51	2	1
2014-03-25 20:11:32.732336	11235	434	3	2
2014-03-26 21:07:05.724036	30861	20.6	1	1
2014-03-26 21:07:05.957198	30862	50	2	1
2014-03-25 20:11:51.175582	11240	20.6	1	8
2014-03-25 20:11:51.396999	11241	56	2	8
2014-03-25 20:12:06.581429	11242	20.3	1	1
2014-03-25 20:12:06.813962	11243	51	2	1
2014-03-26 21:07:18.687553	30863	24.0	1	10
2014-03-26 21:07:18.911105	30864	41	2	10
2014-03-25 20:12:30.175026	11248	20.6	1	8
2014-03-25 20:12:30.398539	11249	56	2	8
2014-03-25 20:12:32.733513	11250	434	3	2
2014-03-25 20:12:45.584086	11251	20.3	1	1
2014-03-25 20:12:45.807292	11252	51	2	1
2014-03-26 21:07:20.566763	30865	579	3	2
2014-03-26 21:07:20.799085	30866	1087834.194736795	4	2
2014-03-25 20:13:09.178155	11257	20.6	1	8
2014-03-25 20:13:09.409656	11258	56	2	8
2014-03-25 20:13:24.819841	11259	20.3	1	1
2014-03-25 20:13:25.040857	11260	51	2	1
2014-03-25 20:13:32.733162	11261	434	3	2
2014-03-26 21:07:29.087423	30867	22.3	1	9
2014-03-26 21:07:29.327583	30868	48	2	9
2014-03-25 20:13:48.310007	11266	20.6	1	8
2014-03-25 20:13:48.740181	11267	56	2	8
2014-03-25 20:14:03.582403	11268	20.3	1	1
2014-03-25 20:14:03.814797	11269	51	2	1
2014-03-25 20:14:20.73298	11270	482	3	2
2014-03-26 21:07:30.135353	30869	22.8	1	8
2014-03-26 21:07:30.367666	30870	47	2	8
2014-03-25 20:14:27.175063	11275	20.6	1	8
2014-03-25 20:14:27.409648	11276	56	2	8
2014-03-25 20:14:32.73156	11277	482	3	2
2014-03-25 20:14:42.583557	11278	20.3	1	1
2014-03-25 20:14:42.80565	11279	51	2	1
2014-03-26 21:07:32.566165	30871	531	3	2
2014-03-25 20:15:06.175884	11284	20.6	1	8
2014-03-25 20:15:06.39768	11285	56	2	8
2014-03-25 20:15:21.581839	11286	20.3	1	1
2014-03-25 20:15:21.803985	11287	51	2	1
2014-03-25 20:15:42.756355	11288	466	3	2
2014-03-25 20:05:57.954581	11155	23.3	1	10
2014-03-25 20:05:58.185759	11156	51	2	10
2014-03-25 20:06:36.955435	11164	23.3	1	10
2014-03-25 20:06:37.175632	11165	51	2	10
2014-03-25 20:07:15.953909	11174	23.3	1	10
2014-03-25 20:07:16.187416	11175	51	2	10
2014-03-25 20:07:54.958477	11184	23.4	1	10
2014-03-25 20:07:55.183852	11185	51	2	10
2014-03-25 20:08:33.955482	11193	23.4	1	10
2014-03-25 20:08:34.175577	11194	51	2	10
2014-03-25 20:09:12.95477	11201	23.4	1	10
2014-03-25 20:09:13.188583	11202	51	2	10
2014-03-25 20:09:51.956318	11210	23.4	1	10
2014-03-25 20:09:52.176734	11211	51	2	10
2014-03-25 20:10:30.955848	11218	23.4	1	10
2014-03-25 20:10:31.178078	11219	51	2	10
2014-03-25 20:11:09.955047	11227	23.4	1	10
2014-03-25 20:11:10.186172	11228	51	2	10
2014-03-25 20:11:48.957753	11236	23.4	1	10
2014-03-25 20:11:49.17868	11237	51	2	10
2014-03-25 20:12:27.958292	11244	23.4	1	10
2014-03-25 20:12:28.179844	11245	51	2	10
2014-03-25 20:13:06.956473	11253	23.4	1	10
2014-03-25 20:13:07.200803	11254	51	2	10
2014-03-25 20:13:46.130197	11262	23.4	1	10
2014-03-25 20:13:46.56473	11263	51	2	10
2014-03-25 20:14:24.958874	11271	23.4	1	10
2014-03-25 20:14:25.181249	11272	51	2	10
2014-03-26 21:07:32.789749	30872	1087835.3437715166	4	2
2014-03-26 21:07:44.964542	30873	20.6	1	1
2014-03-25 20:15:45.175872	11293	20.6	1	8
2014-03-25 20:15:45.405006	11294	56	2	8
2014-03-25 20:16:00.580779	11295	20.3	1	1
2014-03-25 20:16:00.804641	11296	51	2	1
2014-03-26 21:07:45.200576	30874	50	2	1
2014-03-26 21:07:56.565977	30875	547	3	2
2014-03-25 20:16:24.174606	11301	20.6	1	8
2014-03-25 20:16:24.406901	11302	56	2	8
2014-03-25 20:16:32.730851	11303	466	3	2
2014-03-25 20:16:39.580496	11304	20.3	1	1
2014-03-25 20:16:39.804596	11305	51	2	1
2014-03-26 21:07:56.790412	30876	1087839.939910402	4	2
2014-03-26 21:07:57.69337	30877	24.0	1	10
2014-03-25 20:17:03.17592	11310	20.6	1	8
2014-03-25 20:17:03.396367	11311	56	2	8
2014-03-25 20:17:18.582088	11312	20.3	1	1
2014-03-25 20:17:18.813554	11313	51	2	1
2014-03-25 20:17:32.731994	11314	482	3	2
2014-03-26 21:07:57.929401	30878	41	2	10
2014-03-26 21:08:08.049888	30879	22.3	1	9
2014-03-25 20:17:42.174901	11319	20.6	1	8
2014-03-25 20:17:42.404856	11320	56	2	8
2014-03-25 20:17:57.576085	11321	20.3	1	1
2014-03-25 20:17:57.798169	11322	51	2	1
2014-03-26 21:08:08.272729	30880	48	2	9
2014-03-26 21:08:08.580929	30881	547	3	2
2014-03-25 20:18:21.179256	11327	20.6	1	8
2014-03-25 20:18:21.413125	11328	56	2	8
2014-03-25 20:18:32.72916	11329	482	3	2
2014-03-25 20:18:36.576472	11330	20.3	1	1
2014-03-25 20:18:36.79949	11331	51	2	1
2014-03-25 20:18:44.732613	11332	434	3	2
2014-03-25 20:18:56.728578	11333	418	3	2
2014-03-26 21:08:08.825143	30882	1087841.0889451236	4	2
2014-03-26 21:08:09.136975	30883	22.8	1	8
2014-03-25 20:19:00.17763	11338	20.6	1	8
2014-03-25 20:19:00.412687	11339	56	2	8
2014-03-25 20:19:15.580487	11340	20.3	1	1
2014-03-25 20:19:15.823272	11341	51	2	1
2014-03-25 20:19:32.732762	11342	418	3	2
2014-03-26 21:08:09.359063	30884	47	2	8
2014-03-26 21:08:23.728299	30885	20.6	1	1
2014-03-25 20:19:39.176067	11347	20.6	1	8
2014-03-25 20:19:39.400322	11348	56	2	8
2014-03-25 20:19:54.578975	11349	20.4	1	1
2014-03-25 20:19:54.810517	11350	51	2	1
2014-03-26 21:08:23.96347	30886	50	2	1
2014-03-26 21:08:32.566678	30887	579	3	2
2014-03-25 20:20:18.175896	11355	20.6	1	8
2014-03-25 20:20:18.39718	11356	56	2	8
2014-03-25 20:20:32.729604	11357	418	3	2
2014-03-25 20:20:33.577647	11358	20.4	1	1
2014-03-25 20:20:33.799719	11359	51	2	1
2014-03-26 21:08:32.794216	30888	1087844.5360492878	4	2
2014-03-26 21:08:36.689397	30889	24.0	1	10
2014-03-25 20:20:57.176571	11364	20.6	1	8
2014-03-25 20:20:57.4089	11365	56	2	8
2014-03-25 20:21:08.729306	11366	354	3	2
2014-03-25 20:21:12.577965	11367	20.4	1	1
2014-03-25 20:21:12.798455	11368	51	2	1
2014-03-25 20:21:20.750111	11369	354	3	2
2014-03-25 20:21:32.730447	11370	354	3	2
2014-03-26 21:08:36.923302	30890	41	2	10
2014-03-26 21:08:44.565513	30891	579	3	2
2014-03-25 20:21:36.176784	11375	20.6	1	8
2014-03-25 20:21:36.409402	11376	56	2	8
2014-03-25 20:21:51.581006	11377	20.4	1	1
2014-03-25 20:21:51.805695	11378	51	2	1
2014-03-26 21:08:44.790477	30892	1087846.8341187306	4	2
2014-03-26 21:08:47.047533	30893	22.3	1	9
2014-03-25 20:22:15.175965	11383	20.6	1	8
2014-03-25 20:22:15.407655	11384	56	2	8
2014-03-25 20:22:30.574069	11385	20.4	1	1
2014-03-25 20:22:30.817974	11386	51	2	1
2014-03-25 20:22:32.732459	11387	354	3	2
2014-03-26 21:08:47.281284	30894	48	2	9
2014-03-26 21:08:48.137007	30895	22.8	1	8
2014-03-25 20:22:54.175472	11392	20.6	1	8
2014-03-25 20:22:54.396983	11393	56	2	8
2014-03-25 20:23:09.573184	11394	20.4	1	1
2014-03-25 20:23:09.795533	11395	51	2	1
2014-03-26 21:08:48.360048	30896	47	2	8
2014-03-26 21:08:56.568669	30897	547	3	2
2014-03-25 20:23:32.731553	11400	354	3	2
2014-03-25 20:23:33.175002	11401	20.6	1	8
2014-03-25 20:23:33.396478	11402	56	2	8
2014-03-25 20:23:48.576323	11403	20.4	1	1
2014-03-25 20:23:48.808748	11404	51	2	1
2014-03-26 21:08:56.804475	30898	1087849.1321881735	4	2
2014-03-26 21:09:02.724162	30899	20.6	1	1
2014-03-25 20:24:12.177221	11409	20.6	1	8
2014-03-25 20:24:12.399441	11410	56	2	8
2014-03-25 20:24:27.572224	11411	20.5	1	1
2014-03-25 20:24:27.803493	11412	51	2	1
2014-03-25 20:24:32.731808	11413	354	3	2
2014-03-26 21:09:02.948027	30900	50	2	1
2014-03-26 21:09:08.565772	30901	547	3	2
2014-03-26 21:09:08.801013	30902	1087850.2812228948	4	2
2014-03-25 20:24:51.176283	11418	20.6	1	8
2014-03-25 20:24:51.401515	11419	56	2	8
2014-03-25 20:25:06.577828	11420	20.5	1	1
2014-03-25 20:25:06.799782	11421	51	2	1
2014-03-25 20:25:20.730202	11422	418	3	2
2014-03-25 20:15:43.062899	11289	23.5	1	10
2014-03-25 20:15:43.283682	11290	51	2	10
2014-03-25 20:16:21.957386	11297	23.5	1	10
2014-03-25 20:16:22.201256	11298	51	2	10
2014-03-25 20:17:00.957253	11306	23.5	1	10
2014-03-25 20:17:01.17901	11307	51	2	10
2014-03-25 20:17:39.959159	11315	23.5	1	10
2014-03-25 20:17:40.182742	11316	51	2	10
2014-03-25 20:18:18.957619	11323	23.5	1	10
2014-03-25 20:18:19.19004	11324	51	2	10
2014-03-25 20:18:57.959357	11334	23.5	1	10
2014-03-25 20:18:58.192369	11335	51	2	10
2014-03-25 20:19:36.959535	11343	23.5	1	10
2014-03-25 20:19:37.183157	11344	51	2	10
2014-03-25 20:20:15.959323	11351	23.6	1	10
2014-03-25 20:20:16.182804	11352	51	2	10
2014-03-25 20:20:54.959623	11360	23.6	1	10
2014-03-25 20:20:55.196373	11361	51	2	10
2014-03-25 20:21:33.960631	11371	23.6	1	10
2014-03-25 20:21:34.191435	11372	51	2	10
2014-03-25 20:22:12.96003	11379	23.6	1	10
2014-03-25 20:22:13.19336	11380	51	2	10
2014-03-25 20:22:51.962618	11388	23.6	1	10
2014-03-25 20:22:52.188811	11389	51	2	10
2014-03-25 20:23:30.959012	11396	23.6	1	10
2014-03-25 20:23:31.183286	11397	51	2	10
2014-03-25 20:24:10.166429	11405	23.6	1	10
2014-03-25 20:24:10.389278	11406	50	2	10
2014-03-26 21:09:15.686984	30903	24.0	1	10
2014-03-26 21:09:15.915053	30904	41	2	10
2014-03-25 20:25:30.176115	11427	20.6	1	8
2014-03-25 20:25:30.399674	11428	56	2	8
2014-03-25 20:25:32.731624	11429	418	3	2
2014-03-25 20:25:45.574378	11430	20.5	1	1
2014-03-25 20:25:45.797752	11431	51	2	1
2014-03-26 21:09:20.566917	30905	579	3	2
2014-03-26 21:09:20.800909	30906	1087852.5792923376	4	2
2014-03-25 20:26:09.175379	11436	20.6	1	8
2014-03-25 20:26:09.40704	11437	56	2	8
2014-03-25 20:26:24.574934	11438	20.5	1	1
2014-03-25 20:26:24.797158	11439	51	2	1
2014-03-25 20:26:32.728291	11440	402	3	2
2014-03-26 21:09:26.049561	30907	22.3	1	9
2014-03-26 21:09:26.275883	30908	48	2	9
2014-03-25 20:26:48.176011	11445	20.6	1	8
2014-03-25 20:26:48.396433	11446	56	2	8
2014-03-25 20:27:03.573415	11447	20.5	1	1
2014-03-25 20:27:03.807304	11448	51	2	1
2014-03-26 21:09:27.136713	30909	22.8	1	8
2014-03-26 21:09:27.368692	30910	47	2	8
2014-03-25 20:27:27.175731	11453	20.6	1	8
2014-03-25 20:27:27.399005	11454	56	2	8
2014-03-25 20:27:32.731816	11455	402	3	2
2014-03-25 20:27:42.572708	11456	20.5	1	1
2014-03-25 20:27:42.798259	11457	51	2	1
2014-03-26 21:09:32.568428	30911	547	3	2
2014-03-26 21:09:32.792727	30912	1087854.8773617805	4	2
2014-03-25 20:28:06.175433	11462	20.6	1	8
2014-03-25 20:28:06.406012	11463	56	2	8
2014-03-25 20:28:21.574051	11464	20.5	1	1
2014-03-25 20:28:21.797518	11465	51	2	1
2014-03-25 20:28:32.726686	11466	418	3	2
2014-03-26 21:09:41.72427	30913	20.6	1	1
2014-03-26 21:09:41.95991	30914	50	2	1
2014-03-25 20:28:45.175964	11471	20.6	1	8
2014-03-25 20:28:45.4007	11472	56	2	8
2014-03-25 20:29:00.573295	11473	20.5	1	1
2014-03-25 20:29:00.805755	11474	51	2	1
2014-03-26 21:09:44.569555	30915	531	3	2
2014-03-26 21:09:44.794903	30916	1087856.026396502	4	2
2014-03-25 20:29:24.177381	11479	20.6	1	8
2014-03-25 20:29:24.398616	11480	56	2	8
2014-03-25 20:29:32.72985	11481	402	3	2
2014-03-25 20:29:39.571381	11482	20.5	1	1
2014-03-25 20:29:39.795736	11483	51	2	1
2014-03-25 20:29:56.730451	11484	338	3	2
2014-03-26 21:09:54.689306	30917	24.0	1	10
2014-03-26 21:09:54.925728	30918	41	2	10
2014-03-25 20:30:03.175362	11489	20.6	1	8
2014-03-25 20:30:03.399539	11490	56	2	8
2014-03-25 20:30:08.728249	11491	354	3	2
2014-03-25 20:30:18.573983	11492	20.5	1	1
2014-03-25 20:30:18.798575	11493	51	2	1
2014-03-25 20:30:32.728241	11494	354	3	2
2014-03-26 21:10:05.050967	30919	22.3	1	9
2014-03-26 21:10:05.273669	30920	48	2	9
2014-03-25 20:30:42.175355	11499	20.6	1	8
2014-03-25 20:30:42.397282	11500	56	2	8
2014-03-25 20:30:57.574893	11501	20.6	1	1
2014-03-25 20:30:57.807338	11502	51	2	1
2014-03-26 21:10:06.139058	30921	22.8	1	8
2014-03-26 21:10:06.371061	30922	47	2	8
2014-03-25 20:31:21.233798	11507	20.6	1	8
2014-03-25 20:31:21.458734	11508	56	2	8
2014-03-25 20:31:32.725207	11509	354	3	2
2014-03-25 20:31:36.576671	11510	20.6	1	1
2014-03-25 20:31:36.797189	11511	51	2	1
2014-03-26 21:10:08.565995	30923	595	3	2
2014-03-26 21:10:08.789759	30924	1087859.4735006662	4	2
2014-03-25 20:32:00.176248	11516	20.6	1	8
2014-03-25 20:32:00.407822	11517	56	2	8
2014-03-25 20:32:15.573651	11518	20.6	1	1
2014-03-25 20:32:15.79743	11519	51	2	1
2014-03-25 20:32:32.731551	11520	338	3	2
2014-03-26 21:10:20.962731	30925	20.6	1	1
2014-03-26 21:10:21.197998	30926	50	2	1
2014-03-25 20:32:39.175516	11525	20.7	1	8
2014-03-25 20:32:39.397375	11526	56	2	8
2014-03-25 20:32:54.57278	11527	20.6	1	1
2014-03-25 20:32:54.795998	11528	51	2	1
2014-03-26 21:10:32.564595	30927	595	3	2
2014-03-26 21:10:32.788857	30928	1087864.069639552	4	2
2014-03-25 20:33:18.174722	11533	20.7	1	8
2014-03-25 20:33:18.39674	11534	56	2	8
2014-03-25 20:33:32.730241	11535	354	3	2
2014-03-25 20:33:33.569909	11536	20.6	1	1
2014-03-25 20:33:33.791469	11537	51	2	1
2014-03-26 21:10:33.689671	30929	24.0	1	10
2014-03-26 21:10:33.933143	30930	41	2	10
2014-03-25 20:33:57.175042	11542	20.7	1	8
2014-03-25 20:33:57.405397	11543	56	2	8
2014-03-25 20:34:12.701724	11544	20.6	1	1
2014-03-25 20:34:13.139909	11545	51	2	1
2014-03-25 20:34:32.729435	11546	354	3	2
2014-03-26 21:10:44.051255	30931	22.3	1	9
2014-03-25 20:34:36.177396	11551	20.7	1	8
2014-03-25 20:34:36.432226	11552	56	2	8
2014-03-25 20:34:51.570745	11553	20.6	1	1
2014-03-25 20:34:52.32051	11554	51	2	1
2014-03-25 20:35:15.174351	11559	20.7	1	8
2014-03-25 20:35:15.92416	11560	56	2	8
2014-03-25 20:26:06.964107	11432	23.6	1	10
2014-03-25 20:26:07.20753	11433	50	2	10
2014-03-25 20:26:45.962552	11441	23.6	1	10
2014-03-25 20:26:46.18526	11442	50	2	10
2014-03-25 20:27:24.962268	11449	23.7	1	10
2014-03-25 20:27:25.184521	11450	50	2	10
2014-03-25 20:28:03.962533	11458	23.7	1	10
2014-03-25 20:28:04.19376	11459	50	2	10
2014-03-25 20:28:42.963186	11467	23.7	1	10
2014-03-25 20:28:43.185987	11468	50	2	10
2014-03-25 20:29:21.962154	11475	23.7	1	10
2014-03-25 20:29:22.185982	11476	50	2	10
2014-03-25 20:30:00.961403	11485	23.7	1	10
2014-03-25 20:30:01.183921	11486	50	2	10
2014-03-25 20:30:39.962133	11495	23.7	1	10
2014-03-25 20:30:40.184367	11496	50	2	10
2014-03-25 20:31:18.962764	11503	23.7	1	10
2014-03-25 20:31:19.184092	11504	50	2	10
2014-03-25 20:31:57.961165	11512	23.7	1	10
2014-03-25 20:31:58.184044	11513	50	2	10
2014-03-25 20:32:36.962331	11521	23.7	1	10
2014-03-25 20:32:37.192058	11522	50	2	10
2014-03-25 20:33:15.963704	11529	23.7	1	10
2014-03-25 20:33:16.187463	11530	50	2	10
2014-03-25 20:33:54.965633	11538	23.8	1	10
2014-03-25 20:33:55.199847	11539	50	2	10
2014-03-25 20:34:33.962969	11547	23.8	1	10
2014-03-25 20:34:34.242824	11548	50	2	10
2014-03-25 20:35:13.001392	11555	23.8	1	10
2014-03-25 20:35:13.27259	11556	50	2	10
2014-03-25 20:35:30.570761	11561	20.6	1	1
2014-03-25 20:35:30.805628	11562	51	2	1
2014-03-25 20:35:32.729527	11563	354	3	2
2014-03-26 21:10:44.274015	30932	48	2	9
2014-03-26 21:10:44.581559	30933	531	3	2
2014-03-25 20:35:54.173955	11568	20.7	1	8
2014-03-25 20:35:54.398322	11569	56	2	8
2014-03-25 20:36:09.570258	11570	20.6	1	1
2014-03-25 20:36:09.791498	11571	51	2	1
2014-03-26 21:10:44.81418	30934	1087865.2186742732	4	2
2014-03-26 21:10:45.139769	30935	22.8	1	8
2014-03-25 20:36:32.728093	11576	354	3	2
2014-03-25 20:36:33.174021	11577	20.7	1	8
2014-03-25 20:36:33.405231	11578	56	2	8
2014-03-25 20:36:44.727267	11579	418	3	2
2014-03-25 20:36:48.568926	11580	20.6	1	1
2014-03-25 20:36:48.791363	11581	51	2	1
2014-03-25 20:36:56.730187	11582	418	3	2
2014-03-26 21:10:45.380535	30936	47	2	8
2014-03-26 21:10:56.568257	30937	579	3	2
2014-03-25 20:37:12.175987	11587	20.7	1	8
2014-03-25 20:37:12.404817	11588	56	2	8
2014-03-25 20:37:27.569595	11589	20.6	1	1
2014-03-25 20:37:27.79365	11590	51	2	1
2014-03-25 20:37:32.729996	11591	418	3	2
2014-03-26 21:10:56.800963	30938	1087867.516743716	4	2
2014-03-26 21:10:59.720707	30939	20.6	1	1
2014-03-25 20:37:51.17503	11596	20.7	1	8
2014-03-25 20:37:51.400406	11597	56	2	8
2014-03-25 20:38:06.569558	11598	20.6	1	1
2014-03-25 20:38:06.793823	11599	50	2	1
2014-03-26 21:10:59.944404	30940	50	2	1
2014-03-26 21:11:08.565837	30941	611	3	2
2014-03-25 20:38:30.175836	11604	20.7	1	8
2014-03-25 20:38:30.397705	11605	56	2	8
2014-03-25 20:38:32.727491	11606	418	3	2
2014-03-25 20:38:45.565484	11607	20.6	1	1
2014-03-25 20:38:45.788678	11608	50	2	1
2014-03-26 21:11:08.798173	30942	1087869.814813159	4	2
2014-03-26 21:11:12.688068	30943	24.0	1	10
2014-03-25 20:39:09.174696	11613	20.7	1	8
2014-03-25 20:39:09.406215	11614	56	2	8
2014-03-25 20:39:24.567347	11615	20.6	1	1
2014-03-25 20:39:24.788587	11616	50	2	1
2014-03-25 20:39:32.725987	11617	418	3	2
2014-03-26 21:11:12.91142	30944	41	2	10
2014-03-26 21:11:20.565781	30945	595	3	2
2014-03-25 20:39:48.174905	11622	20.7	1	8
2014-03-25 20:39:48.395547	11623	56	2	8
2014-03-25 20:40:03.566453	11624	20.6	1	1
2014-03-25 20:40:03.797487	11625	50	2	1
2014-03-26 21:11:20.799999	30946	1087872.1128826018	4	2
2014-03-26 21:11:23.053265	30947	22.3	1	9
2014-03-25 20:40:27.177772	11630	20.7	1	8
2014-03-25 20:40:27.400519	11631	56	2	8
2014-03-25 20:40:32.726072	11632	418	3	2
2014-03-25 20:40:42.56569	11633	20.6	1	1
2014-03-25 20:40:42.786742	11634	50	2	1
2014-03-26 21:11:23.279535	30948	48	2	9
2014-03-26 21:11:24.137698	30949	22.8	1	8
2014-03-25 20:41:06.175675	11639	20.7	1	8
2014-03-25 20:41:06.409958	11640	56	2	8
2014-03-25 20:41:08.729741	11641	354	3	2
2014-03-25 20:41:20.725422	11642	354	3	2
2014-03-25 20:41:21.584351	11643	20.6	1	1
2014-03-25 20:41:21.816593	11644	50	2	1
2014-03-25 20:41:32.7281	11645	354	3	2
2014-03-26 21:11:24.371493	30950	47	2	8
2014-03-26 21:11:32.567987	30951	611	3	2
2014-03-25 20:41:45.174767	11650	20.7	1	8
2014-03-25 20:41:45.405748	11651	56	2	8
2014-03-25 20:42:00.569429	11652	20.6	1	1
2014-03-25 20:42:00.792151	11653	50	2	1
2014-03-26 21:11:32.791132	30952	1087873.261917323	4	2
2014-03-26 21:11:38.72116	30953	20.6	1	1
2014-03-25 20:42:24.174785	11658	20.7	1	8
2014-03-25 20:42:24.406075	11659	56	2	8
2014-03-25 20:42:32.726911	11660	354	3	2
2014-03-25 20:42:39.568062	11661	20.6	1	1
2014-03-25 20:42:39.7935	11662	50	2	1
2014-03-26 21:11:38.954392	30954	50	2	1
2014-03-26 21:11:51.690191	30955	24.0	1	10
2014-03-25 20:43:03.17525	11667	20.7	1	8
2014-03-25 20:43:03.397644	11668	56	2	8
2014-03-25 20:43:18.569229	11669	20.6	1	1
2014-03-25 20:43:18.803306	11670	50	2	1
2014-03-25 20:43:32.730897	11671	354	3	2
2014-03-26 21:11:51.914446	30956	41	2	10
2014-03-26 21:12:02.049152	30957	22.3	1	9
2014-03-25 20:43:42.174664	11676	20.7	1	8
2014-03-25 20:43:42.404911	11677	56	2	8
2014-03-25 20:43:57.564762	11678	20.6	1	1
2014-03-25 20:43:57.787398	11679	50	2	1
2014-03-26 21:12:02.28455	30958	48	2	9
2014-03-26 21:12:03.137703	30959	22.8	1	8
2014-03-25 20:44:21.30116	11684	20.7	1	8
2014-03-25 20:44:21.799913	11685	56	2	8
2014-03-25 20:44:36.364315	11686	354	3	2
2014-03-25 20:44:36.670083	11687	20.6	1	1
2014-03-25 20:44:36.893159	11688	50	2	1
2014-03-26 21:12:03.362178	30960	47	2	8
2014-03-25 20:45:00.174593	11693	20.7	1	8
2014-03-25 20:45:00.396604	11694	57	2	8
2014-03-25 20:45:15.565373	11695	20.6	1	1
2014-03-25 20:45:15.796933	11696	50	2	1
2014-03-25 20:35:51.964251	11564	23.8	1	10
2014-03-25 20:35:52.186369	11565	50	2	10
2014-03-25 20:36:30.96378	11572	23.8	1	10
2014-03-25 20:36:31.186593	11573	50	2	10
2014-03-25 20:37:09.96452	11583	23.8	1	10
2014-03-25 20:37:10.185808	11584	50	2	10
2014-03-25 20:37:48.964805	11592	23.8	1	10
2014-03-25 20:37:49.187971	11593	50	2	10
2014-03-25 20:38:27.96358	11600	23.8	1	10
2014-03-25 20:38:28.184919	11601	50	2	10
2014-03-25 20:39:06.966275	11609	23.8	1	10
2014-03-25 20:39:07.208662	11610	50	2	10
2014-03-25 20:39:45.964494	11618	23.8	1	10
2014-03-25 20:39:46.187434	11619	50	2	10
2014-03-25 20:40:24.963839	11626	23.8	1	10
2014-03-25 20:40:25.188137	11627	50	2	10
2014-03-25 20:41:03.965122	11635	23.9	1	10
2014-03-25 20:41:04.186512	11636	50	2	10
2014-03-25 20:41:42.965843	11646	23.9	1	10
2014-03-25 20:41:43.187361	11647	50	2	10
2014-03-25 20:42:21.964148	11654	23.9	1	10
2014-03-25 20:42:22.207435	11655	50	2	10
2014-03-25 20:43:00.965685	11663	23.9	1	10
2014-03-25 20:43:01.187214	11664	50	2	10
2014-03-25 20:43:39.963366	11672	23.9	1	10
2014-03-25 20:43:40.188008	11673	50	2	10
2014-03-25 20:44:19.101305	11680	23.9	1	10
2014-03-25 20:44:19.539985	11681	50	2	10
2014-03-25 20:45:32.7251	11697	354	3	2
2014-03-26 21:12:17.720154	30961	20.5	1	1
2014-03-26 21:12:17.953989	30962	50	2	1
2014-03-25 20:45:39.177434	11702	20.7	1	8
2014-03-25 20:45:39.400815	11703	57	2	8
2014-03-25 20:45:54.565004	11704	20.6	1	1
2014-03-25 20:45:54.78756	11705	50	2	1
2014-03-26 21:12:30.690447	30963	24.1	1	10
2014-03-26 21:12:30.91495	30964	41	2	10
2014-03-25 20:46:18.176139	11710	20.7	1	8
2014-03-25 20:46:18.407879	11711	57	2	8
2014-03-25 20:46:32.725822	11712	354	3	2
2014-03-25 20:46:33.563817	11713	20.6	1	1
2014-03-25 20:46:33.786669	11714	50	2	1
2014-03-26 21:12:32.569151	30965	611	3	2
2014-03-26 21:12:32.803313	30966	1087883.6032298158	4	2
2014-03-25 20:46:57.175424	11719	20.7	1	8
2014-03-25 20:46:57.399077	11720	57	2	8
2014-03-25 20:47:12.559998	11721	20.6	1	1
2014-03-25 20:47:12.79298	11722	50	2	1
2014-03-25 20:47:32.72997	11723	354	3	2
2014-03-26 21:12:41.049503	30967	22.3	1	9
2014-03-26 21:12:41.273605	30968	48	2	9
2014-03-25 20:47:36.175436	11728	20.7	1	8
2014-03-25 20:47:36.405598	11729	57	2	8
2014-03-25 20:47:51.566053	11730	20.6	1	1
2014-03-25 20:47:51.789572	11731	50	2	1
2014-03-25 20:48:08.728079	11732	418	3	2
2014-03-26 21:12:42.136491	30969	22.8	1	8
2014-03-26 21:12:42.368738	30970	47	2	8
2014-03-25 20:48:15.175641	11737	20.7	1	8
2014-03-25 20:48:15.398496	11738	57	2	8
2014-03-25 20:48:20.729298	11739	402	3	2
2014-03-25 20:48:30.561715	11740	20.6	1	1
2014-03-25 20:48:30.786793	11741	50	2	1
2014-03-25 20:48:32.729221	11742	402	3	2
2014-03-26 21:12:56.71931	30971	20.5	1	1
2014-03-26 21:12:56.943327	30972	50	2	1
2014-03-25 20:48:54.174531	11747	20.7	1	8
2014-03-25 20:48:54.395431	11748	57	2	8
2014-03-25 20:49:09.563178	11749	20.6	1	1
2014-03-25 20:49:09.788916	11750	50	2	1
2014-03-26 21:13:09.689839	30973	24.1	1	10
2014-03-26 21:13:09.92326	30974	41	2	10
2014-03-25 20:49:32.727281	11755	402	3	2
2014-03-25 20:49:33.174257	11756	20.7	1	8
2014-03-25 20:49:33.394353	11757	57	2	8
2014-03-25 20:49:48.56492	11758	20.6	1	1
2014-03-25 20:49:48.797443	11759	50	2	1
2014-03-26 21:13:20.048873	30975	22.3	1	9
2014-03-26 21:13:20.272907	30976	48	2	9
2014-03-25 20:50:12.175241	11764	20.7	1	8
2014-03-25 20:50:12.396107	11765	57	2	8
2014-03-25 20:50:27.560697	11766	20.6	1	1
2014-03-25 20:50:27.793416	11767	50	2	1
2014-03-25 20:50:32.726653	11768	418	3	2
2014-03-26 21:13:20.581905	30977	531	3	2
2014-03-26 21:13:20.826491	30978	1087891.6464728657	4	2
2014-03-25 20:50:51.175846	11773	20.7	1	8
2014-03-25 20:50:51.406625	11774	57	2	8
2014-03-25 20:51:06.560008	11775	20.5	1	1
2014-03-25 20:51:06.7849	11776	50	2	1
2014-03-26 21:13:21.135797	30979	22.8	1	8
2014-03-26 21:13:21.359136	30980	47	2	8
2014-03-25 20:51:30.17468	11781	20.7	1	8
2014-03-25 20:51:30.409343	11782	57	2	8
2014-03-25 20:51:32.726538	11783	418	3	2
2014-03-25 20:51:45.558462	11784	20.5	1	1
2014-03-25 20:51:45.790632	11785	50	2	1
2014-03-26 21:13:32.566268	30981	611	3	2
2014-03-26 21:13:32.799198	30982	1087893.9445423086	4	2
2014-03-25 20:52:09.174149	11790	20.7	1	8
2014-03-25 20:52:09.395446	11791	57	2	8
2014-03-25 20:52:24.557296	11792	20.5	1	1
2014-03-25 20:52:24.789442	11793	50	2	1
2014-03-25 20:52:32.727914	11794	418	3	2
2014-03-25 20:52:44.725063	11795	354	3	2
2014-03-26 21:13:35.721849	30983	20.5	1	1
2014-03-26 21:13:35.947051	30984	50	2	1
2014-03-25 20:52:48.174122	11800	20.7	1	8
2014-03-25 20:52:48.404334	11801	57	2	8
2014-03-25 20:52:56.72529	11802	354	3	2
2014-03-25 20:53:03.562488	11803	20.5	1	1
2014-03-25 20:53:03.783055	11804	50	2	1
2014-03-26 21:13:44.562882	30985	611	3	2
2014-03-26 21:13:44.799188	30986	1087896.2426117514	4	2
2014-03-25 20:53:27.17698	11809	20.7	1	8
2014-03-25 20:53:27.399917	11810	57	2	8
2014-03-25 20:53:32.72394	11811	354	3	2
2014-03-25 20:53:42.559375	11812	20.5	1	1
2014-03-25 20:53:42.783894	11813	50	2	1
2014-03-26 21:13:48.692058	30987	24.1	1	10
2014-03-26 21:13:48.91464	30988	41	2	10
2014-03-25 20:54:06.173385	11818	20.7	1	8
2014-03-25 20:54:06.404344	11819	57	2	8
2014-03-25 20:54:21.556523	11820	20.5	1	1
2014-03-25 20:54:21.780454	11821	50	2	1
2014-03-25 20:54:32.851123	11822	354	3	2
2014-03-26 21:13:59.047611	30989	22.3	1	9
2014-03-26 21:13:59.283856	30990	48	2	9
2014-03-26 21:14:00.13744	30991	22.8	1	8
2014-03-25 20:54:45.174842	11827	20.7	1	8
2014-03-25 20:54:45.39588	11828	57	2	8
2014-03-25 20:55:00.556036	11829	20.5	1	1
2014-03-25 20:55:00.788535	11830	50	2	1
2014-03-25 20:45:36.96662	11698	23.9	1	10
2014-03-25 20:45:37.190543	11699	50	2	10
2014-03-25 20:46:15.970055	11706	23.9	1	10
2014-03-25 20:46:16.201228	11707	50	2	10
2014-03-25 20:46:54.968039	11715	23.9	1	10
2014-03-25 20:46:55.209296	11716	50	2	10
2014-03-25 20:47:33.967446	11724	23.9	1	10
2014-03-25 20:47:34.188276	11725	50	2	10
2014-03-25 20:48:12.968205	11733	24.0	1	10
2014-03-25 20:48:13.189842	11734	50	2	10
2014-03-25 20:48:51.967668	11743	24.0	1	10
2014-03-25 20:48:52.188843	11744	50	2	10
2014-03-25 20:49:30.969313	11751	24.0	1	10
2014-03-25 20:49:31.19846	11752	50	2	10
2014-03-25 20:50:09.975344	11760	24.0	1	10
2014-03-25 20:50:10.196176	11761	50	2	10
2014-03-25 20:50:48.968999	11769	24.0	1	10
2014-03-25 20:50:49.192341	11770	50	2	10
2014-03-25 20:51:27.967716	11777	24.0	1	10
2014-03-25 20:51:28.19853	11778	50	2	10
2014-03-25 20:52:06.969467	11786	24.0	1	10
2014-03-25 20:52:07.193433	11787	50	2	10
2014-03-25 20:52:45.968132	11796	24.0	1	10
2014-03-25 20:52:46.20148	11797	50	2	10
2014-03-25 20:53:24.973922	11805	24.0	1	10
2014-03-25 20:53:25.197398	11806	50	2	10
2014-03-25 20:54:03.970213	11814	24.0	1	10
2014-03-25 20:54:04.201205	11815	50	2	10
2014-03-26 21:14:00.359341	30992	47	2	8
2014-03-26 21:14:14.723497	30993	20.5	1	1
2014-03-25 20:55:24.173606	11835	20.7	1	8
2014-03-25 20:55:24.395863	11836	57	2	8
2014-03-25 20:55:32.725783	11837	354	3	2
2014-03-25 20:55:39.560602	11838	20.5	1	1
2014-03-25 20:55:39.781491	11839	50	2	1
2014-03-26 21:14:14.957831	30994	50	2	1
2014-03-26 21:14:27.689898	30995	24.1	1	10
2014-03-25 20:56:03.17679	11844	20.7	1	8
2014-03-25 20:56:03.405982	11845	57	2	8
2014-03-25 20:56:18.557574	11846	20.5	1	1
2014-03-25 20:56:18.780025	11847	50	2	1
2014-03-25 20:56:32.725239	11848	338	3	2
2014-03-26 21:14:27.914474	30996	41	2	10
2014-03-26 21:14:32.56498	30997	595	3	2
2014-03-25 20:56:42.17727	11853	20.7	1	8
2014-03-25 20:56:42.398064	11854	57	2	8
2014-03-25 20:56:57.555072	11855	20.5	1	1
2014-03-25 20:56:57.786611	11856	50	2	1
2014-03-26 21:14:32.800621	30998	1087904.2858548013	4	2
2014-03-26 21:14:38.048889	30999	22.3	1	9
2014-03-25 20:57:21.176162	11861	20.7	1	8
2014-03-25 20:57:21.400907	11862	57	2	8
2014-03-25 20:57:32.722251	11863	354	3	2
2014-03-25 20:57:36.558045	11864	20.5	1	1
2014-03-25 20:57:36.780165	11865	50	2	1
2014-03-26 21:14:38.276861	31000	48	2	9
2014-03-26 21:14:39.136187	31001	22.8	1	8
2014-03-25 20:58:00.175134	11870	20.8	1	8
2014-03-25 20:58:00.40757	11871	57	2	8
2014-03-25 20:58:15.557693	11872	20.4	1	1
2014-03-25 20:58:15.781431	11873	50	2	1
2014-03-25 20:58:32.723231	11874	354	3	2
2014-03-26 21:14:39.368614	31002	47	2	8
2014-03-26 21:14:53.717698	31003	20.5	1	1
2014-03-25 20:58:39.172773	11879	20.8	1	8
2014-03-25 20:58:39.394203	11880	57	2	8
2014-03-25 20:58:54.555953	11881	20.4	1	1
2014-03-25 20:58:54.789397	11882	50	2	1
2014-03-26 21:14:53.944809	31004	50	2	1
2014-03-26 21:15:06.68917	31005	24.1	1	10
2014-03-25 20:59:18.174667	11887	20.8	1	8
2014-03-25 20:59:18.394844	11888	57	2	8
2014-03-25 20:59:32.727249	11889	354	3	2
2014-03-25 20:59:33.555223	11890	20.4	1	1
2014-03-25 20:59:33.775492	11891	50	2	1
2014-03-26 21:15:06.924463	31006	41	2	10
2014-03-26 21:15:17.049173	31007	22.3	1	9
2014-03-25 20:59:56.723805	11896	402	3	2
2014-03-25 20:59:57.175374	11897	20.8	1	8
2014-03-25 20:59:57.397963	11898	57	2	8
2014-03-25 21:00:08.723641	11899	402	3	2
2014-03-25 21:00:12.55413	11900	20.4	1	1
2014-03-25 21:00:12.784948	11901	50	2	1
2014-03-25 21:00:32.724951	11902	418	3	2
2014-03-26 21:15:17.273861	31008	48	2	9
2014-03-26 21:15:18.137176	31009	22.8	1	8
2014-03-25 21:00:36.173773	11907	20.8	1	8
2014-03-25 21:00:36.394789	11908	57	2	8
2014-03-25 21:00:51.550662	11909	20.4	1	1
2014-03-25 21:00:51.775361	11910	50	2	1
2014-03-26 21:15:18.369984	31010	47	2	8
2014-03-26 21:15:20.567172	31011	547	3	2
2014-03-25 21:01:15.173746	11915	20.8	1	8
2014-03-25 21:01:15.40506	11916	57	2	8
2014-03-25 21:01:20.724997	11917	482	3	2
2014-03-25 21:01:30.554325	11918	20.4	1	1
2014-03-25 21:01:30.776859	11919	50	2	1
2014-03-25 21:01:32.724317	11920	482	3	2
2014-03-26 21:15:20.791732	31012	1087912.3290978512	4	2
2014-03-26 21:15:32.960366	31013	20.5	1	1
2014-03-25 21:01:54.176609	11925	20.8	1	8
2014-03-25 21:01:54.40655	11926	57	2	8
2014-03-25 21:02:09.552328	11927	20.4	1	1
2014-03-25 21:02:09.774798	11928	50	2	1
2014-03-26 21:15:33.194054	31014	50	2	1
2014-03-26 21:15:45.691077	31015	24.1	1	10
2014-03-25 21:02:32.723551	11933	498	3	2
2014-03-25 21:02:33.173882	11934	20.8	1	8
2014-03-25 21:02:33.396282	11935	57	2	8
2014-03-25 21:02:48.553103	11936	20.4	1	1
2014-03-25 21:02:48.775828	11937	50	2	1
2014-03-26 21:15:45.914138	31016	41	2	10
2014-03-26 21:15:56.050645	31017	22.3	1	9
2014-03-25 21:03:12.175199	11942	20.8	1	8
2014-03-25 21:03:12.397995	11943	57	2	8
2014-03-25 21:03:27.557312	11944	20.4	1	1
2014-03-25 21:03:27.784724	11945	50	2	1
2014-03-25 21:03:32.722801	11946	498	3	2
2014-03-26 21:15:56.284424	31018	48	2	9
2014-03-26 21:15:57.138672	31019	22.8	1	8
2014-03-25 21:03:51.175263	11951	20.8	1	8
2014-03-25 21:03:51.449541	11952	57	2	8
2014-03-25 21:04:06.552236	11953	20.4	1	1
2014-03-25 21:04:06.786254	11954	50	2	1
2014-03-25 21:04:20.72561	11955	434	3	2
2014-03-26 21:15:57.363152	31020	47	2	8
2014-03-25 21:04:30.175312	11960	20.8	1	8
2014-03-25 21:04:30.40557	11961	57	2	8
2014-03-25 21:04:32.726992	11962	434	3	2
2014-03-25 21:04:45.678692	11963	20.4	1	1
2014-03-25 21:04:46.099994	11964	50	2	1
2014-03-25 20:56:00.970075	11840	24.1	1	10
2014-03-25 20:56:01.20282	11841	50	2	10
2014-03-25 20:56:39.969388	11849	24.1	1	10
2014-03-25 20:56:40.193341	11850	50	2	10
2014-03-25 20:57:18.970402	11857	24.1	1	10
2014-03-25 20:57:19.192793	11858	50	2	10
2014-03-25 20:57:57.97047	11866	24.1	1	10
2014-03-25 20:57:58.215919	11867	50	2	10
2014-03-25 20:58:36.970595	11875	24.1	1	10
2014-03-25 20:58:37.19195	11876	50	2	10
2014-03-25 20:59:15.970764	11883	24.1	1	10
2014-03-25 20:59:16.19093	11884	50	2	10
2014-03-25 20:59:54.970213	11892	24.1	1	10
2014-03-25 20:59:55.192555	11893	50	2	10
2014-03-25 21:00:33.972782	11903	24.1	1	10
2014-03-25 21:00:34.194129	11904	50	2	10
2014-03-25 21:01:12.970802	11911	24.1	1	10
2014-03-25 21:01:13.203608	11912	50	2	10
2014-03-25 21:01:51.971626	11921	24.2	1	10
2014-03-25 21:01:52.195815	11922	50	2	10
2014-03-25 21:02:30.971741	11929	24.2	1	10
2014-03-25 21:02:31.211411	11930	50	2	10
2014-03-25 21:03:09.971485	11938	24.2	1	10
2014-03-25 21:03:10.19275	11939	50	2	10
2014-03-25 21:03:48.971918	11947	24.2	1	10
2014-03-25 21:03:49.193099	11948	50	2	10
2014-03-25 21:04:27.971401	11956	24.2	1	10
2014-03-25 21:04:28.193372	11957	50	2	10
2014-03-25 21:05:06.971553	11965	24.2	1	10
2014-03-25 21:05:07.193496	11966	50	2	10
2014-03-25 21:05:09.17574	11969	20.8	1	8
2014-03-25 21:05:09.396626	11970	57	2	8
2014-03-25 21:05:24.550727	11971	20.4	1	1
2014-03-25 21:05:24.782939	11972	50	2	1
2014-03-25 21:05:32.725448	11973	434	3	2
2014-03-25 21:05:44.724576	11974	370	3	2
2014-03-26 21:16:11.717821	31021	20.5	1	1
2014-03-26 21:16:11.953026	31022	50	2	1
2014-03-25 21:05:48.174435	11979	20.8	1	8
2014-03-25 21:05:48.405531	11980	57	2	8
2014-03-25 21:05:56.723372	11981	370	3	2
2014-03-25 21:06:03.55207	11982	20.4	1	1
2014-03-25 21:06:03.775611	11983	50	2	1
2014-03-26 21:16:24.690202	31023	24.1	1	10
2014-03-26 21:16:24.916433	31024	41	2	10
2014-03-25 21:06:27.173142	11988	20.8	1	8
2014-03-25 21:06:27.403054	11989	57	2	8
2014-03-25 21:06:32.722897	11990	370	3	2
2014-03-25 21:06:42.552588	11991	20.4	1	1
2014-03-25 21:06:42.774939	11992	50	2	1
2014-03-26 21:16:32.568767	31025	515	3	2
2014-03-26 21:16:32.814417	31026	1087922.670410344	4	2
2014-03-25 21:07:06.175752	11997	20.8	1	8
2014-03-25 21:07:06.406618	11998	57	2	8
2014-03-25 21:07:21.552161	11999	20.4	1	1
2014-03-25 21:07:21.774076	12000	50	2	1
2014-03-25 21:07:32.723685	12001	370	3	2
2014-03-26 21:16:35.048003	31027	22.3	1	9
2014-03-26 21:16:35.273063	31028	48	2	9
2014-03-25 21:07:45.174571	12006	20.8	1	8
2014-03-25 21:07:45.397866	12007	57	2	8
2014-03-25 21:08:00.549522	12008	20.4	1	1
2014-03-25 21:08:00.782784	12009	50	2	1
2014-03-26 21:16:36.137617	31029	22.7	1	8
2014-03-26 21:16:36.370568	31030	47	2	8
2014-03-25 21:08:24.175188	12014	20.8	1	8
2014-03-25 21:08:24.398284	12015	57	2	8
2014-03-25 21:08:32.723545	12016	370	3	2
2014-03-25 21:08:39.549843	12017	20.3	1	1
2014-03-25 21:08:39.774104	12018	50	2	1
2014-03-26 21:16:44.566173	31031	531	3	2
2014-03-26 21:16:44.79036	31032	1087924.9684797868	4	2
2014-03-25 21:09:03.17501	12023	20.8	1	8
2014-03-25 21:09:03.396275	12024	57	2	8
2014-03-25 21:09:18.551913	12025	20.3	1	1
2014-03-25 21:09:18.775449	12026	50	2	1
2014-03-25 21:09:32.723127	12027	370	3	2
2014-03-26 21:16:50.718713	31033	20.5	1	1
2014-03-26 21:16:50.953813	31034	50	2	1
2014-03-25 21:09:42.175989	12032	20.8	1	8
2014-03-25 21:09:42.396991	12033	57	2	8
2014-03-25 21:09:57.550762	12034	20.3	1	1
2014-03-25 21:09:57.784635	12035	50	2	1
2014-03-26 21:17:03.691017	31035	24.1	1	10
2014-03-26 21:17:03.915373	31036	41	2	10
2014-03-25 21:10:21.173331	12040	20.8	1	8
2014-03-25 21:10:21.394957	12041	57	2	8
2014-03-25 21:10:32.722767	12042	370	3	2
2014-03-25 21:10:36.550486	12043	20.3	1	1
2014-03-25 21:10:36.774352	12044	50	2	1
2014-03-26 21:17:14.049308	31037	22.3	1	9
2014-03-26 21:17:14.283704	31038	48	2	9
2014-03-25 21:11:00.175553	12049	20.8	1	8
2014-03-25 21:11:00.405927	12050	57	2	8
2014-03-25 21:11:15.551809	12051	20.3	1	1
2014-03-25 21:11:15.776162	12052	50	2	1
2014-03-25 21:11:32.723987	12053	402	3	2
2014-03-26 21:17:15.135455	31039	22.7	1	8
2014-03-26 21:17:15.35875	31040	47	2	8
2014-03-25 21:11:39.174329	12058	20.8	1	8
2014-03-25 21:11:39.396549	12059	57	2	8
2014-03-25 21:11:44.723939	12060	370	3	2
2014-03-25 21:11:54.549788	12061	20.3	1	1
2014-03-25 21:11:54.77248	12062	50	2	1
2014-03-25 21:11:56.72323	12063	402	3	2
2014-03-25 21:12:08.724004	12064	370	3	2
2014-03-26 21:17:20.565964	31041	482	3	2
2014-03-26 21:17:20.799883	31042	1087929.5646186725	4	2
2014-03-25 21:12:18.17705	12069	20.8	1	8
2014-03-25 21:12:18.399843	12070	57	2	8
2014-03-25 21:12:20.723321	12071	370	3	2
2014-03-25 21:12:32.722463	12072	370	3	2
2014-03-25 21:12:33.549231	12073	20.3	1	1
2014-03-25 21:12:33.772011	12074	50	2	1
2014-03-26 21:17:29.718993	31043	20.5	1	1
2014-03-26 21:17:29.943817	31044	50	2	1
2014-03-25 21:12:57.174309	12079	20.8	1	8
2014-03-25 21:12:57.398317	12080	57	2	8
2014-03-25 21:13:12.549673	12081	20.3	1	1
2014-03-25 21:13:12.781743	12082	50	2	1
2014-03-25 21:13:20.723775	12083	434	3	2
2014-03-25 21:13:33.773918	12084	434	3	2
2014-03-26 21:17:32.564067	31045	450	3	2
2014-03-26 21:17:32.799082	31046	1087931.8626881153	4	2
2014-03-25 21:13:36.175686	12089	20.8	1	8
2014-03-25 21:13:36.408325	12090	57	2	8
2014-03-25 21:13:51.545603	12091	20.3	1	1
2014-03-25 21:13:51.824841	12092	50	2	1
2014-03-26 21:17:42.691012	31047	24.1	1	10
2014-03-26 21:17:42.917934	31048	41	2	10
2014-03-26 21:17:44.566446	31049	482	3	2
2014-03-25 21:14:15.174189	12097	20.8	1	8
2014-03-25 21:14:15.407225	12098	57	2	8
2014-03-25 21:14:30.550316	12099	20.3	1	1
2014-03-25 21:14:30.772971	12100	50	2	1
2014-03-25 21:14:32.723424	12101	434	3	2
2014-03-25 21:05:45.974067	11975	24.2	1	10
2014-03-25 21:05:46.206826	11976	50	2	10
2014-03-25 21:06:24.972253	11984	24.2	1	10
2014-03-25 21:06:25.195935	11985	50	2	10
2014-03-25 21:07:03.972993	11993	24.2	1	10
2014-03-25 21:07:04.205217	11994	50	2	10
2014-03-25 21:07:42.972722	12002	24.2	1	10
2014-03-25 21:07:43.196709	12003	50	2	10
2014-03-25 21:08:21.973967	12010	24.2	1	10
2014-03-25 21:08:22.198482	12011	50	2	10
2014-03-25 21:09:00.973097	12019	24.2	1	10
2014-03-25 21:09:01.196131	12020	50	2	10
2014-03-25 21:09:39.972603	12028	24.3	1	10
2014-03-25 21:09:40.19641	12029	50	2	10
2014-03-25 21:10:18.972621	12036	24.3	1	10
2014-03-25 21:10:19.196873	12037	50	2	10
2014-03-25 21:10:57.977007	12045	24.3	1	10
2014-03-25 21:10:58.206563	12046	50	2	10
2014-03-25 21:11:36.976827	12054	24.3	1	10
2014-03-25 21:11:37.197638	12055	50	2	10
2014-03-25 21:12:15.973509	12065	24.3	1	10
2014-03-25 21:12:16.199028	12066	50	2	10
2014-03-25 21:12:54.975676	12075	24.3	1	10
2014-03-25 21:12:55.203475	12076	50	2	10
2014-03-25 21:13:34.081352	12085	24.3	1	10
2014-03-25 21:13:34.315901	12086	50	2	10
2014-03-25 21:14:12.975031	12093	24.3	1	10
2014-03-26 21:17:44.799506	31050	1087933.0117228366	4	2
2014-03-25 21:14:54.174669	12106	20.8	1	8
2014-03-25 21:14:54.396968	12107	57	2	8
2014-03-25 21:15:09.67983	12108	20.3	1	1
2014-03-25 21:15:10.119832	12109	50	2	1
2014-03-26 21:17:53.048271	31051	22.3	1	9
2014-03-26 21:17:53.272484	31052	48	2	9
2014-03-25 21:15:32.723989	12114	434	3	2
2014-03-25 21:15:33.175224	12115	20.8	1	8
2014-03-25 21:15:33.397512	12116	57	2	8
2014-03-25 21:15:44.722239	12117	370	3	2
2014-03-25 21:15:48.54608	12118	20.3	1	1
2014-03-25 21:15:48.77052	12119	50	2	1
2014-03-25 21:15:56.72305	12120	370	3	2
2014-03-26 21:17:54.135827	31053	22.7	1	8
2014-03-26 21:17:54.368561	31054	47	2	8
2014-03-25 21:16:12.176037	12125	20.8	1	8
2014-03-25 21:16:12.408067	12126	57	2	8
2014-03-25 21:16:27.548597	12127	20.3	1	1
2014-03-25 21:16:27.795528	12128	50	2	1
2014-03-25 21:16:32.723084	12129	370	3	2
2014-03-26 21:17:56.567681	31055	466	3	2
2014-03-26 21:17:56.790539	31056	1087934.1607575582	4	2
2014-03-25 21:16:51.175383	12134	20.8	1	8
2014-03-25 21:16:51.398855	12135	57	2	8
2014-03-25 21:17:06.54537	12136	20.3	1	1
2014-03-25 21:17:06.784053	12137	50	2	1
2014-03-26 21:18:08.707068	31057	20.5	1	1
2014-03-26 21:18:08.943643	31058	50	2	1
2014-03-25 21:17:30.175799	12142	20.8	1	8
2014-03-25 21:17:30.398992	12143	57	2	8
2014-03-25 21:17:32.721066	12144	354	3	2
2014-03-25 21:17:45.546449	12145	20.3	1	1
2014-03-25 21:17:45.767025	12146	50	2	1
2014-03-26 21:18:20.566	31059	434	3	2
2014-03-26 21:18:20.793776	31060	1087937.6078617224	4	2
2014-03-25 21:18:09.176119	12151	20.8	1	8
2014-03-25 21:18:09.405179	12152	57	2	8
2014-03-25 21:18:20.719046	12153	305	3	2
2014-03-25 21:18:24.546075	12154	20.3	1	1
2014-03-25 21:18:24.768226	12155	50	2	1
2014-03-25 21:18:32.720274	12156	305	3	2
2014-03-26 21:18:21.692825	31061	24.1	1	10
2014-03-26 21:18:21.927169	31062	41	2	10
2014-03-25 21:18:48.174762	12161	20.8	1	8
2014-03-25 21:18:48.405584	12162	57	2	8
2014-03-25 21:19:03.544944	12163	20.3	1	1
2014-03-25 21:19:03.766975	12164	50	2	1
2014-03-26 21:18:32.049134	31063	22.3	1	9
2014-03-26 21:18:32.294284	31064	48	2	9
2014-03-25 21:19:27.175779	12169	20.8	1	8
2014-03-25 21:19:27.408007	12170	57	2	8
2014-03-25 21:19:32.718599	12171	305	3	2
2014-03-25 21:19:42.54404	12172	20.2	1	1
2014-03-25 21:19:42.767373	12173	50	2	1
2014-03-26 21:18:32.602985	31065	466	3	2
2014-03-26 21:18:32.83541	31066	1087938.756896444	4	2
2014-03-25 21:20:06.175239	12178	20.8	1	8
2014-03-25 21:20:06.398025	12179	57	2	8
2014-03-25 21:20:21.545621	12180	20.2	1	1
2014-03-25 21:20:21.780161	12181	50	2	1
2014-03-25 21:20:32.724329	12182	305	3	2
2014-03-26 21:18:33.143304	31067	22.7	1	8
2014-03-26 21:18:33.365997	31068	47	2	8
2014-03-25 21:20:45.175017	12187	20.8	1	8
2014-03-25 21:20:45.417278	12188	57	2	8
2014-03-25 21:21:00.543301	12189	20.2	1	1
2014-03-25 21:21:00.766208	12190	50	2	1
2014-03-26 21:18:44.567315	31069	450	3	2
2014-03-26 21:18:44.800865	31070	1087939.9104021175	4	2
2014-03-25 21:21:24.174601	12195	20.8	1	8
2014-03-25 21:21:24.406856	12196	57	2	8
2014-03-25 21:21:32.72236	12197	305	3	2
2014-03-25 21:21:39.54171	12198	20.2	1	1
2014-03-25 21:21:39.764228	12199	50	2	1
2014-03-26 21:18:47.718272	31071	20.5	1	1
2014-03-26 21:18:47.941654	31072	50	2	1
2014-03-25 21:22:03.173931	12204	20.8	1	8
2014-03-25 21:22:03.396137	12205	57	2	8
2014-03-25 21:22:18.543052	12206	20.2	1	1
2014-03-25 21:22:18.793691	12207	50	2	1
2014-03-25 21:22:32.719329	12208	305	3	2
2014-03-26 21:19:00.692559	31073	24.1	1	10
2014-03-26 21:19:00.9379	31074	41	2	10
2014-03-25 21:22:42.177317	12213	20.8	1	8
2014-03-25 21:22:42.408543	12214	57	2	8
2014-03-25 21:22:57.541838	12215	20.2	1	1
2014-03-25 21:22:57.765227	12216	50	2	1
2014-03-26 21:19:08.569137	31075	482	3	2
2014-03-26 21:19:08.794473	31076	1087943.3575062817	4	2
2014-03-25 21:23:21.176933	12221	20.8	1	8
2014-03-25 21:23:21.407531	12222	57	2	8
2014-03-25 21:23:32.723015	12223	305	3	2
2014-03-25 21:23:36.542489	12224	20.2	1	1
2014-03-25 21:23:36.764998	12225	50	2	1
2014-03-26 21:19:11.04861	31077	22.3	1	9
2014-03-26 21:19:11.281818	31078	48	2	9
2014-03-25 21:24:00.174439	12230	20.8	1	8
2014-03-25 21:24:00.397806	12231	56	2	8
2014-03-25 21:24:15.540695	12232	20.2	1	1
2014-03-25 21:24:15.784105	12233	50	2	1
2014-03-25 21:24:32.722186	12234	305	3	2
2014-03-25 21:24:39.174469	12239	20.8	1	8
2014-03-25 21:24:39.39871	12240	56	2	8
2014-03-25 21:15:30.975076	12110	24.3	1	10
2014-03-25 21:15:31.196825	12111	50	2	10
2014-03-25 21:16:09.976498	12121	24.3	1	10
2014-03-25 21:16:10.198747	12122	50	2	10
2014-03-25 21:16:48.978239	12130	24.3	1	10
2014-03-25 21:16:49.20037	12131	50	2	10
2014-03-25 21:17:27.979787	12138	24.3	1	10
2014-03-25 21:17:28.203653	12139	50	2	10
2014-03-25 21:18:06.974644	12147	24.3	1	10
2014-03-25 21:18:07.198875	12148	50	2	10
2014-03-25 21:18:45.975904	12157	24.3	1	10
2014-03-25 21:18:46.196825	12158	50	2	10
2014-03-25 21:19:24.976367	12165	24.3	1	10
2014-03-25 21:19:25.207832	12166	50	2	10
2014-03-25 21:20:03.977355	12174	24.3	1	10
2014-03-25 21:20:04.199217	12175	50	2	10
2014-03-25 21:20:42.977771	12183	24.3	1	10
2014-03-25 21:20:43.201288	12184	50	2	10
2014-03-25 21:21:21.977975	12191	24.3	1	10
2014-03-25 21:21:22.210232	12192	50	2	10
2014-03-25 21:22:00.97819	12200	24.3	1	10
2014-03-25 21:22:01.201756	12201	50	2	10
2014-03-25 21:22:39.979456	12209	24.3	1	10
2014-03-25 21:22:40.204444	12210	50	2	10
2014-03-25 21:23:18.978682	12217	24.4	1	10
2014-03-25 21:23:19.211408	12218	50	2	10
2014-03-25 21:23:57.982857	12226	24.4	1	10
2014-03-25 21:23:58.206865	12227	50	2	10
2014-03-25 21:24:36.979046	12235	24.4	1	10
2014-03-25 21:24:54.545349	12241	20.2	1	1
2014-03-25 21:24:54.768132	12242	50	2	1
2014-03-26 21:19:12.137992	31079	22.7	1	8
2014-03-26 21:19:12.363511	31080	47	2	8
2014-03-25 21:25:18.310016	12247	20.8	1	8
2014-03-25 21:25:18.760048	12248	56	2	8
2014-03-25 21:25:32.722106	12249	305	3	2
2014-03-25 21:25:33.541945	12250	20.2	1	1
2014-03-25 21:25:33.76691	12251	50	2	1
2014-03-26 21:19:20.565646	31081	482	3	2
2014-03-26 21:19:20.802111	31082	1087944.506541003	4	2
2014-03-25 21:25:56.719939	12256	354	3	2
2014-03-25 21:25:57.175132	12257	20.8	1	8
2014-03-25 21:25:57.404704	12258	56	2	8
2014-03-25 21:26:08.723165	12259	354	3	2
2014-03-25 21:26:12.539166	12260	20.2	1	1
2014-03-25 21:26:12.762266	12261	50	2	1
2014-03-25 21:26:32.718198	12262	354	3	2
2014-03-26 21:19:26.718697	31083	20.5	1	1
2014-03-26 21:19:26.942481	31084	50	2	1
2014-03-25 21:26:36.17466	12267	20.8	1	8
2014-03-25 21:26:36.397955	12268	56	2	8
2014-03-25 21:26:51.541215	12269	20.2	1	1
2014-03-25 21:26:51.77357	12270	50	2	1
2014-03-26 21:19:39.489113	31085	482	3	2
2014-03-26 21:19:39.724716	31086	1087945.6555757246	4	2
2014-03-25 21:27:15.174948	12275	20.8	1	8
2014-03-25 21:27:15.396913	12276	56	2	8
2014-03-25 21:27:30.544208	12277	20.2	1	1
2014-03-25 21:27:30.790388	12278	50	2	1
2014-03-25 21:27:32.717988	12279	354	3	2
2014-03-26 21:19:40.031694	31087	24.1	1	10
2014-03-26 21:19:40.254876	31088	41	2	10
2014-03-25 21:27:54.173305	12284	20.8	1	8
2014-03-25 21:27:54.404585	12285	56	2	8
2014-03-25 21:28:09.541404	12286	20.2	1	1
2014-03-25 21:28:09.76548	12287	50	2	1
2014-03-26 21:19:50.048263	31089	22.3	1	9
2014-03-26 21:19:50.282326	31090	48	2	9
2014-03-25 21:28:32.719728	12292	354	3	2
2014-03-25 21:28:33.175716	12293	20.8	1	8
2014-03-25 21:28:33.39648	12294	56	2	8
2014-03-25 21:28:48.540941	12295	20.1	1	1
2014-03-25 21:28:48.773588	12296	50	2	1
2014-03-26 21:19:51.136082	31091	22.7	1	8
2014-03-26 21:19:51.359856	31092	47	2	8
2014-03-25 21:29:12.176074	12301	20.8	1	8
2014-03-25 21:29:12.400875	12302	56	2	8
2014-03-25 21:29:27.535832	12303	20.1	1	1
2014-03-25 21:29:27.768867	12304	50	2	1
2014-03-25 21:29:32.721853	12305	354	3	2
2014-03-26 21:20:05.719255	31093	20.5	1	1
2014-03-26 21:20:05.955296	31094	50	2	1
2014-03-25 21:29:51.174295	12310	20.8	1	8
2014-03-25 21:29:51.407797	12311	56	2	8
2014-03-25 21:30:06.538732	12312	20.1	1	1
2014-03-25 21:30:06.760586	12313	50	2	1
2014-03-26 21:20:18.682168	31095	24.1	1	10
2014-03-26 21:20:18.90705	31096	41	2	10
2014-03-25 21:30:30.175552	12318	20.8	1	8
2014-03-25 21:30:30.407325	12319	56	2	8
2014-03-25 21:30:32.720749	12320	305	3	2
2014-03-25 21:30:44.719386	12321	305	3	2
2014-03-25 21:30:45.540924	12322	20.1	1	1
2014-03-25 21:30:45.784337	12323	50	2	1
2014-03-26 21:20:29.048068	31097	22.3	1	9
2014-03-26 21:20:29.336218	31098	48	2	9
2014-03-25 21:31:09.174219	12328	20.8	1	8
2014-03-25 21:31:09.395432	12329	56	2	8
2014-03-25 21:31:24.53547	12330	20.1	1	1
2014-03-25 21:31:24.768853	12331	50	2	1
2014-03-25 21:31:32.723819	12332	305	3	2
2014-03-26 21:20:30.136173	31099	22.7	1	8
2014-03-26 21:20:30.360322	31100	47	2	8
2014-03-25 21:31:48.173986	12337	20.8	1	8
2014-03-25 21:31:48.405691	12338	56	2	8
2014-03-25 21:32:03.536964	12339	20.1	1	1
2014-03-25 21:32:03.760422	12340	50	2	1
2014-03-26 21:20:32.569287	31101	482	3	2
2014-03-26 21:20:32.802608	31102	1087954.8478534957	4	2
2014-03-25 21:32:27.174306	12345	20.8	1	8
2014-03-25 21:32:27.407029	12346	56	2	8
2014-03-25 21:32:32.717364	12347	305	3	2
2014-03-25 21:32:42.53777	12348	20.1	1	1
2014-03-25 21:32:42.762739	12349	50	2	1
2014-03-26 21:20:44.719419	31103	20.5	1	1
2014-03-26 21:20:44.945123	31104	50	2	1
2014-03-25 21:33:06.174176	12354	20.8	1	8
2014-03-25 21:33:06.39478	12355	56	2	8
2014-03-25 21:33:21.534482	12356	20.1	1	1
2014-03-25 21:33:21.76799	12357	50	2	1
2014-03-25 21:33:32.719492	12358	305	3	2
2014-03-26 21:20:57.692624	31105	24.2	1	10
2014-03-26 21:20:57.929712	31106	41	2	10
2014-03-25 21:33:45.175192	12363	20.8	1	8
2014-03-25 21:33:45.397134	12364	56	2	8
2014-03-25 21:34:00.537967	12365	20.1	1	1
2014-03-25 21:34:00.76248	12366	50	2	1
2014-03-26 21:21:08.049578	31107	22.3	1	9
2014-03-26 21:21:08.273711	31108	48	2	9
2014-03-25 21:34:24.175089	12371	20.8	1	8
2014-03-25 21:34:24.407918	12372	56	2	8
2014-03-25 21:34:32.719987	12373	305	3	2
2014-03-25 21:34:39.534884	12374	20.1	1	1
2014-03-25 21:34:39.777519	12375	50	2	1
2014-03-25 21:25:16.110015	12243	24.4	1	10
2014-03-25 21:25:16.570025	12244	50	2	10
2014-03-25 21:25:54.978809	12252	24.4	1	10
2014-03-25 21:25:55.201912	12253	50	2	10
2014-03-25 21:26:33.97872	12263	24.4	1	10
2014-03-25 21:26:34.201768	12264	50	2	10
2014-03-25 21:27:12.980623	12271	24.4	1	10
2014-03-25 21:27:13.204636	12272	50	2	10
2014-03-25 21:27:51.983366	12280	24.4	1	10
2014-03-25 21:27:52.263685	12281	50	2	10
2014-03-25 21:28:30.980005	12288	24.4	1	10
2014-03-25 21:28:31.214304	12289	50	2	10
2014-03-25 21:29:09.988579	12297	24.4	1	10
2014-03-25 21:29:10.212132	12298	50	2	10
2014-03-25 21:29:48.978598	12306	24.4	1	10
2014-03-25 21:29:49.202302	12307	50	2	10
2014-03-25 21:30:27.981885	12314	24.4	1	10
2014-03-25 21:30:28.218254	12315	50	2	10
2014-03-25 21:31:06.980854	12324	24.4	1	10
2014-03-25 21:31:07.203798	12325	50	2	10
2014-03-25 21:31:45.979078	12333	24.4	1	10
2014-03-25 21:31:46.205963	12334	49	2	10
2014-03-25 21:32:24.979353	12341	24.4	1	10
2014-03-25 21:32:25.214551	12342	49	2	10
2014-03-25 21:33:03.98276	12350	24.4	1	10
2014-03-25 21:33:04.20447	12351	49	2	10
2014-03-25 21:33:42.980066	12359	24.4	1	10
2014-03-25 21:33:43.205628	12360	49	2	10
2014-03-26 21:21:09.135644	31109	22.7	1	8
2014-03-26 21:21:09.369042	31110	47	2	8
2014-03-25 21:35:03.173992	12380	20.8	1	8
2014-03-25 21:35:03.395969	12381	56	2	8
2014-03-25 21:35:18.536523	12382	20.1	1	1
2014-03-25 21:35:18.76936	12383	50	2	1
2014-03-25 21:35:32.850148	12384	305	3	2
2014-03-26 21:21:23.71648	31111	20.5	1	1
2014-03-26 21:21:23.941391	31112	50	2	1
2014-03-25 21:35:42.175788	12389	20.8	1	8
2014-03-25 21:35:42.406195	12390	56	2	8
2014-03-25 21:35:57.53662	12391	20.1	1	1
2014-03-25 21:35:57.765117	12392	50	2	1
2014-03-26 21:21:32.565067	31113	498	3	2
2014-03-26 21:21:32.799646	31114	1087962.8910965458	4	2
2014-03-25 21:36:21.176024	12397	20.8	1	8
2014-03-25 21:36:21.409476	12398	56	2	8
2014-03-25 21:36:32.723919	12399	305	3	2
2014-03-25 21:36:36.533939	12400	20.0	1	1
2014-03-25 21:36:36.760034	12401	50	2	1
2014-03-26 21:21:36.69475	31115	24.2	1	10
2014-03-26 21:21:36.921218	31116	41	2	10
2014-03-25 21:37:00.173764	12406	20.8	1	8
2014-03-25 21:37:00.397633	12407	56	2	8
2014-03-25 21:37:15.533441	12408	20.0	1	1
2014-03-25 21:37:15.767089	12409	50	2	1
2014-03-25 21:37:32.724181	12410	305	3	2
2014-03-26 21:21:47.050646	31117	22.3	1	9
2014-03-26 21:21:47.285791	31118	48	2	9
2014-03-25 21:37:39.174094	12415	20.8	1	8
2014-03-25 21:37:39.398433	12416	56	2	8
2014-03-25 21:37:54.536273	12417	20.0	1	1
2014-03-25 21:37:54.759709	12418	50	2	1
2014-03-25 21:38:08.720788	12419	354	3	2
2014-03-26 21:21:48.137015	31119	22.7	1	8
2014-03-26 21:21:48.359133	31120	47	2	8
2014-03-25 21:38:18.174407	12424	20.8	1	8
2014-03-25 21:38:18.396674	12425	56	2	8
2014-03-25 21:38:20.719883	12426	354	3	2
2014-03-25 21:38:32.72024	12427	354	3	2
2014-03-25 21:38:33.532278	12428	20.0	1	1
2014-03-25 21:38:33.754682	12429	50	2	1
2014-03-26 21:22:02.719063	31121	20.5	1	1
2014-03-26 21:22:02.96288	31122	50	2	1
2014-03-25 21:38:57.175613	12434	20.8	1	8
2014-03-25 21:38:57.395902	12435	56	2	8
2014-03-25 21:39:12.534311	12436	20.0	1	1
2014-03-25 21:39:12.766689	12437	50	2	1
2014-03-25 21:39:32.721986	12438	370	3	2
2014-03-26 21:22:15.691944	31123	24.2	1	10
2014-03-26 21:22:15.916721	31124	41	2	10
2014-03-25 21:39:36.175018	12443	20.8	1	8
2014-03-25 21:39:36.398747	12444	56	2	8
2014-03-25 21:39:51.533868	12445	20.0	1	1
2014-03-25 21:39:51.757405	12446	50	2	1
2014-03-25 21:40:12.782777	12447	402	3	2
2014-03-26 21:22:26.050006	31125	22.3	1	9
2014-03-26 21:22:26.285747	31126	48	2	9
2014-03-25 21:40:15.174533	12452	20.8	1	8
2014-03-25 21:40:15.408783	12453	56	2	8
2014-03-25 21:40:20.71925	12454	370	3	2
2014-03-25 21:40:30.533925	12455	20.0	1	1
2014-03-25 21:40:30.756102	12456	50	2	1
2014-03-25 21:40:32.716803	12457	370	3	2
2014-03-26 21:22:27.13485	31127	22.7	1	8
2014-03-26 21:22:27.360392	31128	47	2	8
2014-03-25 21:40:54.174634	12462	20.8	1	8
2014-03-25 21:40:54.407496	12463	56	2	8
2014-03-25 21:41:09.53489	12464	20.0	1	1
2014-03-25 21:41:09.757335	12465	50	2	1
2014-03-26 21:22:41.511953	31129	531	3	2
2014-03-26 21:22:41.747547	31130	1087970.9343395957	4	2
2014-03-25 21:41:32.717735	12470	370	3	2
2014-03-25 21:41:33.174939	12471	20.8	1	8
2014-03-25 21:41:33.397282	12472	56	2	8
2014-03-25 21:41:44.716136	12473	338	3	2
2014-03-25 21:41:48.532098	12474	20.0	1	1
2014-03-25 21:41:48.765779	12475	50	2	1
2014-03-25 21:41:56.720797	12476	338	3	2
2014-03-26 21:22:42.055387	31131	20.5	1	1
2014-03-26 21:22:42.280278	31132	50	2	1
2014-03-25 21:42:12.173461	12481	20.8	1	8
2014-03-25 21:42:12.405913	12482	56	2	8
2014-03-25 21:42:27.529361	12483	20.0	1	1
2014-03-25 21:42:27.752931	12484	50	2	1
2014-03-25 21:42:32.72032	12485	338	3	2
2014-03-26 21:22:44.564815	31133	531	3	2
2014-03-26 21:22:44.797655	31134	1087972.083374317	4	2
2014-03-25 21:42:51.17388	12490	20.8	1	8
2014-03-25 21:42:51.397009	12491	56	2	8
2014-03-25 21:43:06.529272	12492	20.0	1	1
2014-03-25 21:43:06.763275	12493	50	2	1
2014-03-26 21:22:54.692151	31135	24.2	1	10
2014-03-26 21:22:54.916089	31136	41	2	10
2014-03-25 21:43:30.173566	12498	20.8	1	8
2014-03-25 21:43:30.395515	12499	56	2	8
2014-03-25 21:43:32.719356	12500	338	3	2
2014-03-25 21:43:45.529499	12501	20.0	1	1
2014-03-25 21:43:45.753335	12502	50	2	1
2014-03-26 21:23:05.048916	31137	22.3	1	9
2014-03-25 21:44:09.172852	12507	20.8	1	8
2014-03-25 21:44:09.394802	12508	56	2	8
2014-03-25 21:44:24.528152	12509	20.0	1	1
2014-03-25 21:44:24.757852	12510	50	2	1
2014-03-25 21:44:32.720213	12511	338	3	2
2014-03-25 21:35:01.204299	12377	49	2	10
2014-03-25 21:35:39.981057	12385	24.4	1	10
2014-03-25 21:35:40.2027	12386	49	2	10
2014-03-25 21:36:18.981972	12393	24.4	1	10
2014-03-25 21:36:19.214584	12394	49	2	10
2014-03-25 21:36:57.986508	12402	24.4	1	10
2014-03-25 21:36:58.209893	12403	49	2	10
2014-03-25 21:37:36.98323	12411	24.4	1	10
2014-03-25 21:37:37.213336	12412	49	2	10
2014-03-25 21:38:15.984829	12420	24.4	1	10
2014-03-25 21:38:16.208688	12421	49	2	10
2014-03-25 21:38:54.98256	12430	24.4	1	10
2014-03-25 21:38:55.207139	12431	49	2	10
2014-03-25 21:39:33.983214	12439	24.4	1	10
2014-03-25 21:39:34.208577	12440	49	2	10
2014-03-25 21:40:13.090671	12448	24.4	1	10
2014-03-25 21:40:13.327899	12449	49	2	10
2014-03-25 21:40:51.982508	12458	24.4	1	10
2014-03-25 21:40:52.205275	12459	49	2	10
2014-03-25 21:41:30.983059	12466	24.4	1	10
2014-03-25 21:41:31.217757	12467	49	2	10
2014-03-25 21:42:09.982675	12477	24.4	1	10
2014-03-25 21:42:10.205964	12478	49	2	10
2014-03-25 21:42:48.984432	12486	24.4	1	10
2014-03-25 21:42:49.211598	12487	49	2	10
2014-03-25 21:43:27.985457	12494	24.4	1	10
2014-03-25 21:43:28.207993	12495	49	2	10
2014-03-25 21:44:06.984122	12503	24.4	1	10
2014-03-26 21:23:05.284235	31138	48	2	9
2014-03-26 21:23:06.13517	31139	22.6	1	8
2014-03-25 21:44:48.179239	12516	20.8	1	8
2014-03-25 21:44:48.409349	12517	56	2	8
2014-03-25 21:45:03.528177	12518	20.0	1	1
2014-03-25 21:45:03.753281	12519	50	2	1
2014-03-26 21:23:06.358698	31140	47	2	8
2014-03-26 21:23:20.715424	31141	20.5	1	1
2014-03-25 21:45:27.173204	12524	20.8	1	8
2014-03-25 21:45:27.406084	12525	56	2	8
2014-03-25 21:45:32.718044	12526	338	3	2
2014-03-25 21:45:42.660002	12527	20.0	1	1
2014-03-25 21:45:43.092305	12528	50	2	1
2014-03-26 21:23:20.950223	31142	50	2	1
2014-03-26 21:23:32.565702	31143	515	3	2
2014-03-25 21:46:06.173571	12533	20.8	1	8
2014-03-25 21:46:06.396159	12534	56	2	8
2014-03-25 21:46:21.528826	12535	20.0	1	1
2014-03-25 21:46:21.762714	12536	50	2	1
2014-03-25 21:46:32.716477	12537	338	3	2
2014-03-26 21:23:32.79067	31144	1087980.126617367	4	2
2014-03-26 21:23:33.69253	31145	24.2	1	10
2014-03-25 21:46:45.173459	12542	20.8	1	8
2014-03-25 21:46:45.403727	12543	56	2	8
2014-03-25 21:46:56.717534	12544	305	3	2
2014-03-25 21:47:00.526309	12545	19.9	1	1
2014-03-25 21:47:00.751935	12546	50	2	1
2014-03-25 21:47:08.715604	12547	305	3	2
2014-03-26 21:23:33.92652	31146	41	2	10
2014-03-26 21:23:44.048535	31147	22.3	1	9
2014-03-25 21:47:24.172211	12552	20.8	1	8
2014-03-25 21:47:24.39402	12553	56	2	8
2014-03-25 21:47:32.718787	12554	338	3	2
2014-03-25 21:47:39.563511	12555	19.9	1	1
2014-03-25 21:47:39.788089	12556	50	2	1
2014-03-25 21:47:44.715957	12557	338	3	2
2014-03-25 21:47:56.720543	12558	305	3	2
2014-03-26 21:23:44.275479	31148	48	2	9
2014-03-26 21:23:45.13516	31149	22.6	1	8
2014-03-25 21:48:03.172313	12563	20.8	1	8
2014-03-25 21:48:03.40309	12564	56	2	8
2014-03-25 21:48:08.719225	12565	305	3	2
2014-03-25 21:48:18.532454	12566	19.9	1	1
2014-03-25 21:48:18.755468	12567	50	2	1
2014-03-25 21:48:32.719396	12568	338	3	2
2014-03-26 21:23:45.366007	31150	47	2	8
2014-03-26 21:23:59.712907	31151	20.5	1	1
2014-03-25 21:48:42.173638	12573	20.8	1	8
2014-03-25 21:48:42.394713	12574	56	2	8
2014-03-25 21:48:44.718951	12575	305	3	2
2014-03-25 21:48:56.714617	12576	370	3	2
2014-03-25 21:48:57.5291	12577	19.9	1	1
2014-03-25 21:48:57.753501	12578	50	2	1
2014-03-25 21:49:08.718251	12579	370	3	2
2014-03-26 21:23:59.935065	31152	50	2	1
2014-03-26 21:24:12.694012	31153	24.2	1	10
2014-03-25 21:49:21.173086	12584	20.8	1	8
2014-03-25 21:49:21.395105	12585	56	2	8
2014-03-25 21:49:32.719037	12586	370	3	2
2014-03-25 21:49:36.524919	12587	19.9	1	1
2014-03-25 21:49:36.758486	12588	50	2	1
2014-03-26 21:24:12.928897	31154	41	2	10
2014-03-26 21:24:23.072013	31155	22.3	1	9
2014-03-25 21:50:00.175129	12593	20.8	1	8
2014-03-25 21:50:00.395756	12594	55	2	8
2014-03-25 21:50:15.524708	12595	19.9	1	1
2014-03-25 21:50:15.756848	12596	50	2	1
2014-03-25 21:50:32.718694	12597	370	3	2
2014-03-26 21:24:23.333214	31156	48	2	9
2014-03-26 21:24:24.136951	31157	22.6	1	8
2014-03-25 21:50:39.173733	12602	20.8	1	8
2014-03-25 21:50:39.407083	12603	55	2	8
2014-03-25 21:50:54.523609	12604	19.9	1	1
2014-03-25 21:50:54.746494	12605	50	2	1
2014-03-26 21:24:24.404261	31158	47	2	8
2014-03-26 21:24:32.566972	31159	531	3	2
2014-03-25 21:51:18.172125	12610	20.8	1	8
2014-03-25 21:51:18.405526	12611	55	2	8
2014-03-25 21:51:32.716232	12612	370	3	2
2014-03-25 21:51:33.528639	12613	19.9	1	1
2014-03-25 21:51:33.750317	12614	50	2	1
2014-03-26 21:24:32.811841	31160	1087988.1698604168	4	2
2014-03-26 21:24:38.717499	31161	20.5	1	1
2014-03-25 21:51:57.173787	12619	20.8	1	8
2014-03-25 21:51:57.394765	12620	55	2	8
2014-03-25 21:52:12.530235	12621	19.9	1	1
2014-03-25 21:52:12.753298	12622	50	2	1
2014-03-25 21:52:32.714077	12623	354	3	2
2014-03-26 21:24:38.985118	31162	50	2	1
2014-03-26 21:24:51.695214	31163	24.2	1	10
2014-03-25 21:52:36.174014	12628	20.8	1	8
2014-03-25 21:52:36.396431	12629	55	2	8
2014-03-25 21:52:51.521762	12630	19.9	1	1
2014-03-25 21:52:51.781047	12631	50	2	1
2014-03-25 21:52:56.71748	12632	305	3	2
2014-03-25 21:53:08.714091	12633	305	3	2
2014-03-26 21:24:51.953785	31164	41	2	10
2014-03-26 21:25:02.049148	31165	22.3	1	9
2014-03-25 21:53:15.172694	12638	20.8	1	8
2014-03-25 21:53:15.416626	12639	55	2	8
2014-03-25 21:53:30.561252	12640	19.9	1	1
2014-03-25 21:53:30.785282	12641	50	2	1
2014-03-25 21:53:32.717134	12642	305	3	2
2014-03-25 21:53:54.172825	12647	20.8	1	8
2014-03-25 21:53:54.39416	12648	55	2	8
2014-03-25 21:44:46.215093	12513	49	2	10
2014-03-25 21:45:24.983304	12520	24.4	1	10
2014-03-25 21:45:25.2151	12521	49	2	10
2014-03-25 21:46:03.984272	12529	24.4	1	10
2014-03-25 21:46:04.20554	12530	49	2	10
2014-03-25 21:46:42.984006	12538	24.4	1	10
2014-03-25 21:46:43.206018	12539	49	2	10
2014-03-25 21:47:21.983038	12548	24.4	1	10
2014-03-25 21:47:22.211563	12549	49	2	10
2014-03-25 21:48:00.98495	12559	24.4	1	10
2014-03-25 21:48:01.206897	12560	49	2	10
2014-03-25 21:48:39.9857	12569	24.4	1	10
2014-03-25 21:48:40.209399	12570	49	2	10
2014-03-25 21:49:18.987111	12580	24.4	1	10
2014-03-25 21:49:19.208157	12581	49	2	10
2014-03-25 21:49:57.99008	12589	24.3	1	10
2014-03-25 21:49:58.214281	12590	49	2	10
2014-03-25 21:50:36.985619	12598	24.3	1	10
2014-03-25 21:50:37.205655	12599	49	2	10
2014-03-25 21:51:15.985962	12606	24.3	1	10
2014-03-25 21:51:16.216366	12607	49	2	10
2014-03-25 21:51:54.985805	12615	24.3	1	10
2014-03-25 21:51:55.205965	12616	49	2	10
2014-03-25 21:52:33.987903	12624	24.3	1	10
2014-03-25 21:52:34.209316	12625	49	2	10
2014-03-25 21:53:12.985805	12634	24.3	1	10
2014-03-25 21:53:13.2205	12635	49	2	10
2014-03-25 21:53:51.986156	12643	24.3	1	10
2014-03-25 21:54:09.525118	12649	19.9	1	1
2014-03-25 21:54:09.761887	12650	50	2	1
2014-03-26 21:25:02.322688	31166	48	2	9
2014-03-26 21:25:03.136273	31167	22.6	1	8
2014-03-25 21:54:32.719169	12655	305	3	2
2014-03-25 21:54:33.172898	12656	20.8	1	8
2014-03-25 21:54:33.394785	12657	55	2	8
2014-03-25 21:54:48.761131	12658	19.9	1	1
2014-03-25 21:54:48.990712	12659	50	2	1
2014-03-26 21:25:03.393978	31168	47	2	8
2014-03-26 21:25:17.717338	31169	20.5	1	1
2014-03-25 21:55:12.175068	12664	20.8	1	8
2014-03-25 21:55:12.405987	12665	55	2	8
2014-03-25 21:55:27.521199	12666	19.9	1	1
2014-03-25 21:55:27.743382	12667	50	2	1
2014-03-25 21:55:32.713959	12668	305	3	2
2014-03-26 21:25:18.019439	31170	50	2	1
2014-03-26 21:25:30.692987	31171	24.2	1	10
2014-03-25 21:55:51.244205	12673	20.8	1	8
2014-03-25 21:55:51.67002	12674	55	2	8
2014-03-25 21:55:56.841052	12675	1802	3	2
2014-03-25 21:56:06.525165	12676	19.9	1	1
2014-03-25 21:56:06.747387	12677	50	2	1
2014-03-25 21:56:08.713085	12678	370	3	2
2014-03-25 21:56:20.71589	12679	370	3	2
2014-03-26 21:25:30.918101	31172	41	2	10
2014-03-26 21:25:32.566366	31173	531	3	2
2014-03-25 21:56:30.173795	12684	20.8	1	8
2014-03-25 21:56:30.405265	12685	55	2	8
2014-03-25 21:56:32.715495	12686	402	3	2
2014-03-25 21:56:45.320728	12687	370	3	2
2014-03-25 21:56:45.628578	12688	19.9	1	1
2014-03-25 21:56:45.863427	12689	50	2	1
2014-03-25 21:56:56.714289	12690	402	3	2
2014-03-26 21:25:32.799719	31174	1087997.3621381882	4	2
2014-03-26 21:25:41.047841	31175	22.3	1	9
2014-03-25 21:57:08.716871	12695	402	3	2
2014-03-25 21:57:09.174855	12696	20.8	1	8
2014-03-25 21:57:09.408156	12697	55	2	8
2014-03-25 21:57:24.526538	12698	19.9	1	1
2014-03-25 21:57:24.747728	12699	50	2	1
2014-03-25 21:57:32.714311	12700	370	3	2
2014-03-25 21:57:44.712856	12701	370	3	2
2014-03-26 21:25:41.270145	31176	48	2	9
2014-03-26 21:25:42.136036	31177	22.6	1	8
2014-03-25 21:57:48.174205	12706	20.8	1	8
2014-03-25 21:57:48.399302	12707	55	2	8
2014-03-25 21:58:03.523353	12708	19.9	1	1
2014-03-25 21:58:03.748172	12709	50	2	1
2014-03-26 21:25:42.369484	31178	47	2	8
2014-03-26 21:25:56.713173	31179	20.5	1	1
2014-03-25 21:58:27.172858	12714	20.8	1	8
2014-03-25 21:58:27.405852	12715	55	2	8
2014-03-25 21:58:32.714684	12716	370	3	2
2014-03-25 21:58:42.520125	12717	19.9	1	1
2014-03-25 21:58:42.745052	12718	50	2	1
2014-03-26 21:25:56.941885	31180	50	2	1
2014-03-26 21:26:09.692722	31181	24.2	1	10
2014-03-25 21:59:06.172952	12723	20.8	1	8
2014-03-25 21:59:06.394458	12724	55	2	8
2014-03-25 21:59:21.520432	12725	19.8	1	1
2014-03-25 21:59:21.762531	12726	50	2	1
2014-03-25 21:59:32.71579	12727	370	3	2
2014-03-26 21:26:09.928629	31182	41	2	10
2014-03-26 21:26:20.050664	31183	22.3	1	9
2014-03-25 21:59:45.172921	12732	20.8	1	8
2014-03-25 21:59:45.404632	12733	55	2	8
2014-03-25 22:00:00.521489	12734	19.8	1	1
2014-03-25 22:00:00.74367	12735	50	2	1
2014-03-25 22:00:20.712318	12736	434	3	2
2014-03-26 21:26:20.273573	31184	48	2	9
2014-03-26 21:26:20.580571	31185	498	3	2
2014-03-25 22:00:24.18535	12741	20.8	1	8
2014-03-25 22:00:24.407993	12742	55	2	8
2014-03-25 22:00:32.713948	12743	434	3	2
2014-03-25 22:00:39.518193	12744	19.8	1	1
2014-03-25 22:00:39.742598	12745	50	2	1
2014-03-26 21:26:20.813723	31186	1088004.2563465168	4	2
2014-03-26 21:26:21.136027	31187	22.6	1	8
2014-03-25 22:01:03.176848	12750	20.8	1	8
2014-03-25 22:01:03.406666	12751	55	2	8
2014-03-25 22:01:18.51926	12752	19.8	1	1
2014-03-25 22:01:18.743197	12753	50	2	1
2014-03-25 22:01:32.715931	12754	434	3	2
2014-03-26 21:26:21.35808	31188	47	2	8
2014-03-26 21:26:32.56522	31189	515	3	2
2014-03-25 22:01:42.172062	12759	20.8	1	8
2014-03-25 22:01:42.396578	12760	55	2	8
2014-03-25 22:01:57.519992	12761	19.8	1	1
2014-03-25 22:01:57.753449	12762	50	2	1
2014-03-26 21:26:32.799092	31190	1088005.405381238	4	2
2014-03-26 21:26:35.712985	31191	20.5	1	1
2014-03-25 22:02:21.173544	12767	20.8	1	8
2014-03-25 22:02:21.396316	12768	55	2	8
2014-03-25 22:02:32.712658	12769	434	3	2
2014-03-25 22:02:36.516876	12770	19.8	1	1
2014-03-25 22:02:36.738449	12771	50	2	1
2014-03-26 21:26:35.936571	31192	50	2	1
2014-03-26 21:26:48.694244	31193	24.2	1	10
2014-03-25 22:03:00.172818	12776	20.8	1	8
2014-03-25 22:03:00.40518	12777	55	2	8
2014-03-25 22:03:15.517011	12778	19.8	1	1
2014-03-25 22:03:15.740104	12779	50	2	1
2014-03-25 22:03:32.715543	12780	434	3	2
2014-03-26 21:26:48.928773	31194	41	2	10
2014-03-25 21:54:30.989717	12651	24.3	1	10
2014-03-25 21:54:31.211386	12652	49	2	10
2014-03-25 21:55:09.988506	12660	24.3	1	10
2014-03-25 21:55:10.221068	12661	49	2	10
2014-03-25 21:55:48.986856	12669	24.3	1	10
2014-03-25 21:55:49.211973	12670	49	2	10
2014-03-25 21:56:27.98809	12680	24.3	1	10
2014-03-25 21:56:28.217716	12681	49	2	10
2014-03-25 21:57:06.986304	12691	24.3	1	10
2014-03-25 21:57:07.209575	12692	49	2	10
2014-03-25 21:57:45.988645	12702	24.3	1	10
2014-03-25 21:57:46.210376	12703	49	2	10
2014-03-25 21:58:24.990012	12710	24.3	1	10
2014-03-25 21:58:25.212159	12711	49	2	10
2014-03-25 21:59:03.987875	12719	24.3	1	10
2014-03-25 21:59:04.211739	12720	49	2	10
2014-03-25 21:59:42.989514	12728	24.3	1	10
2014-03-25 21:59:43.21292	12729	49	2	10
2014-03-25 22:00:21.989507	12737	24.3	1	10
2014-03-25 22:00:22.212923	12738	49	2	10
2014-03-25 22:01:00.989761	12746	24.3	1	10
2014-03-25 22:01:01.221091	12747	49	2	10
2014-03-25 22:01:39.988687	12755	24.3	1	10
2014-03-25 22:01:40.211839	12756	49	2	10
2014-03-25 22:02:18.988426	12763	24.3	1	10
2014-03-25 22:02:19.210714	12764	49	2	10
2014-03-25 22:02:57.989911	12772	24.3	1	10
2014-03-25 22:02:58.228775	12773	49	2	10
2014-03-25 22:03:39.173185	12785	20.8	1	8
2014-03-25 22:03:39.395587	12786	55	2	8
2014-03-25 22:03:54.553775	12787	19.8	1	1
2014-03-25 22:03:54.786313	12788	50	2	1
2014-03-26 21:26:59.052972	31195	22.3	1	9
2014-03-26 21:26:59.279451	31196	48	2	9
2014-03-25 22:04:18.17293	12793	20.8	1	8
2014-03-25 22:04:18.393901	12794	55	2	8
2014-03-25 22:04:32.714437	12795	434	3	2
2014-03-25 22:04:33.515197	12796	19.8	1	1
2014-03-25 22:04:33.737425	12797	50	2	1
2014-03-26 21:27:00.137882	31197	22.5	1	8
2014-03-26 21:27:00.369515	31198	47	2	8
2014-03-25 22:04:56.71363	12802	370	3	2
2014-03-25 22:04:57.172749	12803	20.8	1	8
2014-03-25 22:04:57.394318	12804	55	2	8
2014-03-25 22:05:08.717568	12805	370	3	2
2014-03-25 22:05:12.51966	12806	19.8	1	1
2014-03-25 22:05:12.740674	12807	50	2	1
2014-03-25 22:05:32.713977	12808	370	3	2
2014-03-26 21:27:08.562188	31199	482	3	2
2014-03-26 21:27:08.785878	31200	1088011.150554845	4	2
2014-03-25 22:05:36.171708	12813	20.8	1	8
2014-03-25 22:05:36.415411	12814	55	2	8
2014-03-25 22:05:51.515285	12815	19.8	1	1
2014-03-25 22:05:51.737345	12816	50	2	1
2014-03-26 21:27:14.711899	31201	20.4	1	1
2014-03-26 21:27:14.944825	31202	50	2	1
2014-03-25 22:06:15.298997	12821	20.8	1	8
2014-03-25 22:06:15.739754	12822	55	2	8
2014-03-25 22:06:30.517536	12823	19.8	1	1
2014-03-25 22:06:30.7404	12824	50	2	1
2014-03-25 22:06:32.712363	12825	370	3	2
2014-03-26 21:27:20.56377	31203	498	3	2
2014-03-26 21:27:20.790004	31204	1088012.2995895667	4	2
2014-03-25 22:06:54.172336	12830	20.8	1	8
2014-03-25 22:06:54.396781	12831	55	2	8
2014-03-25 22:07:09.518918	12832	19.8	1	1
2014-03-25 22:07:09.749423	12833	50	2	1
2014-03-26 21:27:27.692907	31205	24.2	1	10
2014-03-26 21:27:27.927433	31206	41	2	10
2014-03-25 22:07:32.715242	12838	370	3	2
2014-03-25 22:07:33.173174	12839	20.8	1	8
2014-03-25 22:07:33.39631	12840	55	2	8
2014-03-25 22:07:48.518959	12841	19.8	1	1
2014-03-25 22:07:48.743332	12842	50	2	1
2014-03-26 21:27:32.564127	31207	482	3	2
2014-03-26 21:27:32.789075	31208	1088014.5976590095	4	2
2014-03-25 22:08:12.690089	12847	20.8	1	8
2014-03-25 22:08:12.957085	12848	55	2	8
2014-03-25 22:08:27.517612	12849	19.8	1	1
2014-03-25 22:08:27.943636	12850	50	2	1
2014-03-25 22:08:32.713257	12851	370	3	2
2014-03-26 21:27:38.049588	31209	22.3	1	9
2014-03-26 21:27:38.287261	31210	48	2	9
2014-03-25 22:08:51.173039	12856	20.8	1	8
2014-03-25 22:08:51.408552	12857	55	2	8
2014-03-25 22:09:06.518038	12858	19.8	1	1
2014-03-25 22:09:06.762774	12859	50	2	1
2014-03-26 21:27:39.136749	31211	22.5	1	8
2014-03-26 21:27:39.388081	31212	47	2	8
2014-03-25 22:09:30.172526	12864	20.8	1	8
2014-03-25 22:09:30.393781	12865	55	2	8
2014-03-25 22:09:32.715748	12866	354	3	2
2014-03-25 22:09:45.513451	12867	19.8	1	1
2014-03-25 22:09:45.733777	12868	50	2	1
2014-03-26 21:27:53.713311	31213	20.4	1	1
2014-03-26 21:27:53.950048	31214	50	2	1
2014-03-25 22:10:09.173422	12873	20.8	1	8
2014-03-25 22:10:09.404361	12874	55	2	8
2014-03-25 22:10:24.515521	12875	19.8	1	1
2014-03-25 22:10:24.737105	12876	50	2	1
2014-03-25 22:10:32.711117	12877	354	3	2
2014-03-25 22:10:44.711555	12878	289	3	2
2014-03-26 21:28:06.693425	31215	24.2	1	10
2014-03-26 21:28:06.917824	31216	41	2	10
2014-03-25 22:10:48.172704	12883	20.8	1	8
2014-03-25 22:10:48.404928	12884	55	2	8
2014-03-25 22:10:56.71352	12885	305	3	2
2014-03-25 22:11:03.517934	12886	19.8	1	1
2014-03-25 22:11:03.740044	12887	50	2	1
2014-03-26 21:28:17.048925	31217	22.3	1	9
2014-03-26 21:28:17.294853	31218	48	2	9
2014-03-25 22:11:27.176175	12892	20.8	1	8
2014-03-25 22:11:27.397705	12893	55	2	8
2014-03-25 22:11:32.71414	12894	305	3	2
2014-03-25 22:11:42.551782	12895	19.8	1	1
2014-03-25 22:11:42.774942	12896	50	2	1
2014-03-26 21:28:18.190595	31219	22.5	1	8
2014-03-26 21:28:18.416853	31220	47	2	8
2014-03-25 22:12:06.173392	12901	20.8	1	8
2014-03-25 22:12:06.416192	12902	55	2	8
2014-03-25 22:12:21.512141	12903	19.8	1	1
2014-03-25 22:12:21.737095	12904	50	2	1
2014-03-25 22:12:32.714237	12905	354	3	2
2014-03-26 21:28:32.953815	31221	20.4	1	1
2014-03-26 21:28:33.187122	31222	50	2	1
2014-03-25 22:12:44.714257	12910	354	3	2
2014-03-25 22:12:45.173673	12911	20.8	1	8
2014-03-25 22:12:45.396958	12912	55	2	8
2014-03-25 22:13:00.513086	12913	19.8	1	1
2014-03-25 22:13:00.738567	12914	50	2	1
2014-03-26 21:28:45.6934	31223	24.2	1	10
2014-03-25 22:13:24.172631	12919	20.8	1	8
2014-03-25 22:13:24.393885	12920	55	2	8
2014-03-25 22:04:15.988782	12789	24.3	1	10
2014-03-25 22:04:16.210565	12790	49	2	10
2014-03-25 22:04:54.990298	12798	24.2	1	10
2014-03-25 22:04:55.223427	12799	49	2	10
2014-03-25 22:05:33.989798	12809	24.2	1	10
2014-03-25 22:05:34.223056	12810	49	2	10
2014-03-25 22:06:13.120687	12817	24.2	1	10
2014-03-25 22:06:13.564953	12818	49	2	10
2014-03-25 22:06:51.990486	12826	24.2	1	10
2014-03-25 22:06:52.21319	12827	49	2	10
2014-03-25 22:07:30.991328	12834	24.2	1	10
2014-03-25 22:07:31.212859	12835	49	2	10
2014-03-25 22:08:09.990058	12843	24.2	1	10
2014-03-25 22:08:11.228106	12844	49	2	10
2014-03-25 22:08:48.990068	12852	24.2	1	10
2014-03-25 22:08:49.249923	12853	49	2	10
2014-03-25 22:09:27.991313	12860	24.2	1	10
2014-03-25 22:09:28.211916	12861	49	2	10
2014-03-25 22:10:07.198564	12869	24.2	1	10
2014-03-25 22:10:07.430236	12870	49	2	10
2014-03-25 22:10:45.991997	12879	24.2	1	10
2014-03-25 22:10:46.213877	12880	49	2	10
2014-03-25 22:11:24.991075	12888	24.2	1	10
2014-03-25 22:11:25.215018	12889	49	2	10
2014-03-25 22:12:03.991979	12897	24.2	1	10
2014-03-25 22:12:04.225341	12898	49	2	10
2014-03-25 22:12:42.992175	12906	24.2	1	10
2014-03-25 22:12:43.216467	12907	49	2	10
2014-03-25 22:13:32.711498	12921	354	3	2
2014-03-25 22:13:39.516804	12922	19.8	1	1
2014-03-25 22:13:39.739592	12923	50	2	1
2014-03-26 21:28:45.918048	31224	41	2	10
2014-03-26 21:28:56.048677	31225	22.3	1	9
2014-03-25 22:14:03.173304	12928	20.8	1	8
2014-03-25 22:14:03.394117	12929	55	2	8
2014-03-25 22:14:18.510795	12930	19.8	1	1
2014-03-25 22:14:18.744241	12931	50	2	1
2014-03-25 22:14:32.714105	12932	354	3	2
2014-03-26 21:28:56.281726	31226	48	2	9
2014-03-26 21:28:56.591699	31227	450	3	2
2014-03-25 22:14:42.173281	12937	20.8	1	8
2014-03-25 22:14:42.394579	12938	55	2	8
2014-03-25 22:14:57.509491	12939	19.8	1	1
2014-03-25 22:14:57.732097	12940	50	2	1
2014-03-26 21:28:56.815391	31228	1088024.9389715022	4	2
2014-03-26 21:28:57.134926	31229	22.5	1	8
2014-03-25 22:15:21.173307	12945	20.8	1	8
2014-03-25 22:15:21.415365	12946	55	2	8
2014-03-25 22:15:32.713211	12947	354	3	2
2014-03-25 22:15:36.509761	12948	19.7	1	1
2014-03-25 22:15:36.731514	12949	50	2	1
2014-03-26 21:28:57.371079	31230	47	2	8
2014-03-26 21:29:08.5659	31231	466	3	2
2014-03-25 22:16:00.172443	12954	20.9	1	8
2014-03-25 22:16:00.393166	12955	55	2	8
2014-03-25 22:16:15.508846	12956	19.7	1	1
2014-03-25 22:16:15.740572	12957	50	2	1
2014-03-25 22:16:32.710111	12958	354	3	2
2014-03-26 21:29:08.791674	31232	1088027.237040945	4	2
2014-03-26 21:29:11.711243	31233	20.4	1	1
2014-03-25 22:16:39.174033	12963	20.9	1	8
2014-03-25 22:16:39.395333	12964	55	2	8
2014-03-25 22:16:54.509334	12965	19.7	1	1
2014-03-25 22:16:54.732749	12966	50	2	1
2014-03-25 22:17:08.715016	12967	305	3	2
2014-03-26 21:29:11.945282	31234	50	2	1
2014-03-26 21:29:24.695327	31235	24.2	1	10
2014-03-25 22:17:18.173166	12972	20.9	1	8
2014-03-25 22:17:18.405548	12973	55	2	8
2014-03-25 22:17:20.71374	12974	289	3	2
2014-03-25 22:17:32.713574	12975	305	3	2
2014-03-25 22:17:33.501113	12976	19.7	1	1
2014-03-25 22:17:33.733582	12977	50	2	1
2014-03-26 21:29:24.939308	31236	41	2	10
2014-03-26 21:29:32.565777	31237	482	3	2
2014-03-25 22:17:57.17296	12982	20.9	1	8
2014-03-25 22:17:57.396118	12983	55	2	8
2014-03-25 22:18:12.509432	12984	19.7	1	1
2014-03-25 22:18:12.74144	12985	50	2	1
2014-03-25 22:18:32.716613	12986	305	3	2
2014-03-26 21:29:32.800614	31238	1088029.5351103877	4	2
2014-03-26 21:29:35.049084	31239	22.3	1	9
2014-03-25 22:18:36.173227	12991	20.9	1	8
2014-03-25 22:18:36.413716	12992	55	2	8
2014-03-25 22:18:51.50873	12993	19.7	1	1
2014-03-25 22:18:51.731198	12994	50	2	1
2014-03-26 21:29:35.272568	31240	48	2	9
2014-03-26 21:29:36.136355	31241	22.5	1	8
2014-03-25 22:19:15.1728	12999	20.9	1	8
2014-03-25 22:19:15.404338	13000	55	2	8
2014-03-25 22:19:30.507776	13001	19.7	1	1
2014-03-25 22:19:30.731301	13002	50	2	1
2014-03-25 22:19:32.713194	13003	305	3	2
2014-03-26 21:29:36.369745	31242	47	2	8
2014-03-26 21:29:50.715622	31243	20.4	1	1
2014-03-25 22:19:54.173279	13008	20.9	1	8
2014-03-25 22:19:54.394958	13009	55	2	8
2014-03-25 22:20:09.511522	13010	19.7	1	1
2014-03-25 22:20:09.744455	13011	50	2	1
2014-03-26 21:29:50.940171	31244	50	2	1
2014-03-26 21:30:03.695952	31245	24.2	1	10
2014-03-25 22:20:32.715631	13016	305	3	2
2014-03-25 22:20:33.173097	13017	20.9	1	8
2014-03-25 22:20:33.393113	13018	55	2	8
2014-03-25 22:20:48.507457	13019	19.7	1	1
2014-03-25 22:20:48.733366	13020	50	2	1
2014-03-26 21:30:03.930433	31246	41	2	10
2014-03-26 21:30:08.567011	31247	434	3	2
2014-03-25 22:21:12.173072	13025	20.9	1	8
2014-03-25 22:21:12.3947	13026	55	2	8
2014-03-25 22:21:27.509319	13027	19.7	1	1
2014-03-25 22:21:27.730233	13028	50	2	1
2014-03-25 22:21:32.714295	13029	305	3	2
2014-03-26 21:30:08.793478	31248	1088035.280283995	4	2
2014-03-26 21:30:14.047897	31249	22.3	1	9
2014-03-25 22:21:51.17385	13034	20.9	1	8
2014-03-25 22:21:51.395155	13035	55	2	8
2014-03-25 22:22:06.506664	13036	19.7	1	1
2014-03-25 22:22:06.747898	13037	50	2	1
2014-03-26 21:30:14.285624	31250	48	2	9
2014-03-26 21:30:15.136147	31251	22.5	1	8
2014-03-25 22:22:30.174486	13042	20.9	1	8
2014-03-25 22:22:30.397764	13043	55	2	8
2014-03-25 22:22:32.712476	13044	305	3	2
2014-03-25 22:22:45.504883	13045	19.7	1	1
2014-03-25 22:22:45.728574	13046	50	2	1
2014-03-26 21:30:15.359456	31252	47	2	8
2014-03-26 21:30:20.564495	31253	466	3	2
2014-03-25 22:23:09.172971	13051	20.9	1	8
2014-03-25 22:23:09.405531	13052	55	2	8
2014-03-25 22:23:24.507592	13053	19.7	1	1
2014-03-25 22:23:24.737583	13054	50	2	1
2014-03-25 22:23:32.71325	13055	305	3	2
2014-03-25 22:14:00.992658	12924	24.2	1	10
2014-03-25 22:14:01.214123	12925	49	2	10
2014-03-25 22:14:39.992414	12933	24.2	1	10
2014-03-25 22:14:40.213836	12934	49	2	10
2014-03-25 22:15:18.992223	12941	24.2	1	10
2014-03-25 22:15:19.224814	12942	49	2	10
2014-03-25 22:15:57.994037	12950	24.2	1	10
2014-03-25 22:15:58.216571	12951	49	2	10
2014-03-25 22:16:36.992565	12959	24.2	1	10
2014-03-25 22:16:37.217549	12960	49	2	10
2014-03-25 22:17:15.992825	12968	24.2	1	10
2014-03-25 22:17:16.226526	12969	49	2	10
2014-03-25 22:17:54.992636	12978	24.2	1	10
2014-03-25 22:17:55.218172	12979	49	2	10
2014-03-25 22:18:33.993979	12987	24.2	1	10
2014-03-25 22:18:34.216958	12988	49	2	10
2014-03-25 22:19:12.994456	12995	24.2	1	10
2014-03-25 22:19:13.225434	12996	49	2	10
2014-03-25 22:19:51.994185	13004	24.2	1	10
2014-03-25 22:19:52.219591	13005	49	2	10
2014-03-25 22:20:30.994158	13012	24.1	1	10
2014-03-25 22:20:31.215708	13013	49	2	10
2014-03-25 22:21:09.997512	13021	24.1	1	10
2014-03-25 22:21:10.223033	13022	49	2	10
2014-03-25 22:21:48.994873	13030	24.1	1	10
2014-03-25 22:21:49.218135	13031	49	2	10
2014-03-25 22:22:27.996262	13038	24.1	1	10
2014-03-25 22:22:28.220718	13039	49	2	10
2014-03-26 21:30:20.799985	31254	1088036.4293187163	4	2
2014-03-26 21:30:29.71099	31255	20.4	1	1
2014-03-25 22:23:48.175037	13060	20.9	1	8
2014-03-25 22:23:48.397347	13061	55	2	8
2014-03-25 22:24:03.508426	13062	19.7	1	1
2014-03-25 22:24:03.740032	13063	50	2	1
2014-03-26 21:30:29.935914	31256	50	2	1
2014-03-26 21:30:32.565963	31257	450	3	2
2014-03-25 22:24:27.174931	13068	20.9	1	8
2014-03-25 22:24:27.395781	13069	55	2	8
2014-03-25 22:24:32.713315	13070	305	3	2
2014-03-25 22:24:42.507269	13071	19.7	1	1
2014-03-25 22:24:42.730569	13072	50	2	1
2014-03-25 22:24:56.568157	13073	354	3	2
2014-03-25 22:24:56.886923	13074	354	3	2
2014-03-26 21:30:32.800978	31258	1088037.5783534378	4	2
2014-03-26 21:30:42.693472	31259	24.2	1	10
2014-03-25 22:25:06.174848	13079	20.9	1	8
2014-03-25 22:25:06.39614	13080	55	2	8
2014-03-25 22:25:21.503689	13081	19.7	1	1
2014-03-25 22:25:21.727808	13082	50	2	1
2014-03-25 22:25:32.712464	13083	354	3	2
2014-03-26 21:30:42.920529	31260	41	2	10
2014-03-26 21:30:53.04871	31261	22.3	1	9
2014-03-25 22:25:45.173799	13088	20.9	1	8
2014-03-25 22:25:45.397021	13089	55	2	8
2014-03-25 22:26:00.505576	13090	19.7	1	1
2014-03-25 22:26:00.736027	13091	50	2	1
2014-03-26 21:30:53.28351	31262	48	2	9
2014-03-26 21:30:54.134869	31263	22.5	1	8
2014-03-25 22:26:24.174071	13096	20.9	1	8
2014-03-25 22:26:24.396698	13097	55	2	8
2014-03-25 22:26:39.438903	13098	370	3	2
2014-03-25 22:26:40.03321	13099	19.7	1	1
2014-03-25 22:26:40.452525	13100	50	2	1
2014-03-26 21:30:54.36043	31264	47	2	8
2014-03-26 21:31:08.712453	31265	20.4	1	1
2014-03-25 22:27:03.173869	13105	20.9	1	8
2014-03-25 22:27:03.406221	13106	55	2	8
2014-03-25 22:27:18.504883	13107	19.7	1	1
2014-03-25 22:27:18.72678	13108	50	2	1
2014-03-25 22:27:39.796615	13109	354	3	2
2014-03-26 21:31:08.959598	31266	50	2	1
2014-03-26 21:31:21.69524	31267	24.2	1	10
2014-03-25 22:27:42.175022	13114	20.9	1	8
2014-03-25 22:27:42.397422	13115	55	2	8
2014-03-25 22:27:57.50321	13116	19.7	1	1
2014-03-25 22:27:57.735132	13117	50	2	1
2014-03-26 21:31:21.920239	31268	41	2	10
2014-03-26 21:31:32.050257	31269	22.3	1	9
2014-03-25 22:28:21.173432	13122	20.9	1	8
2014-03-25 22:28:21.396306	13123	55	2	8
2014-03-25 22:28:32.71129	13124	354	3	2
2014-03-25 22:28:36.501716	13125	19.7	1	1
2014-03-25 22:28:36.72619	13126	50	2	1
2014-03-26 21:31:32.282568	31270	48	2	9
2014-03-26 21:31:32.58881	31271	482	3	2
2014-03-25 22:29:00.173071	13131	20.9	1	8
2014-03-25 22:29:00.407407	13132	55	2	8
2014-03-25 22:29:15.501455	13133	19.7	1	1
2014-03-25 22:29:15.723726	13134	50	2	1
2014-03-25 22:29:20.712069	13135	482	3	2
2014-03-25 22:29:32.71638	13136	482	3	2
2014-03-26 21:31:32.812115	31272	1088045.6215964877	4	2
2014-03-26 21:31:33.135427	31273	22.5	1	8
2014-03-25 22:29:39.17194	13141	20.9	1	8
2014-03-25 22:29:39.395131	13142	55	2	8
2014-03-25 22:29:54.502305	13143	19.7	1	1
2014-03-25 22:29:54.736043	13144	50	2	1
2014-03-25 22:29:56.710076	13145	434	3	2
2014-03-25 22:30:08.709703	13146	434	3	2
2014-03-26 21:31:33.367517	31274	47	2	8
2014-03-26 21:31:44.56295	31275	482	3	2
2014-03-25 22:30:18.1727	13151	20.9	1	8
2014-03-25 22:30:18.404554	13152	55	2	8
2014-03-25 22:30:32.713832	13153	434	3	2
2014-03-25 22:30:33.500484	13154	19.7	1	1
2014-03-25 22:30:33.725195	13155	50	2	1
2014-03-26 21:31:44.78608	31276	1088046.770631209	4	2
2014-03-26 21:31:47.710855	31277	20.4	1	1
2014-03-25 22:30:57.173345	13160	20.9	1	8
2014-03-25 22:30:57.394322	13161	55	2	8
2014-03-25 22:31:12.502572	13162	19.7	1	1
2014-03-25 22:31:12.734603	13163	50	2	1
2014-03-25 22:31:32.708823	13164	434	3	2
2014-03-26 21:31:47.943932	31278	50	2	1
2014-03-26 21:32:00.694959	31279	24.2	1	10
2014-03-25 22:31:36.173188	13169	20.9	1	8
2014-03-25 22:31:36.413797	13170	55	2	8
2014-03-25 22:31:51.503211	13171	19.7	1	1
2014-03-25 22:31:51.726402	13172	50	2	1
2014-03-26 21:32:00.918597	31280	41	2	10
2014-03-26 21:32:11.05138	31281	22.3	1	9
2014-03-25 22:32:15.172915	13177	20.9	1	8
2014-03-25 22:32:15.404886	13178	55	2	8
2014-03-25 22:32:30.50162	13179	19.7	1	1
2014-03-25 22:32:30.729178	13180	50	2	1
2014-03-25 22:32:32.712838	13181	434	3	2
2014-03-26 21:32:11.285816	31282	48	2	9
2014-03-26 21:32:12.137898	31283	22.5	1	8
2014-03-25 22:32:54.22989	13186	20.9	1	8
2014-03-25 22:32:54.453357	13187	55	2	8
2014-03-25 22:33:09.502055	13188	19.7	1	1
2014-03-25 22:33:09.735024	13189	50	2	1
2014-03-25 22:23:46.425626	13057	49	2	10
2014-03-25 22:24:24.996085	13064	24.1	1	10
2014-03-25 22:24:25.219012	13065	49	2	10
2014-03-25 22:25:03.996768	13075	24.1	1	10
2014-03-25 22:25:04.220036	13076	49	2	10
2014-03-25 22:25:42.997273	13084	24.1	1	10
2014-03-25 22:25:43.21868	13085	49	2	10
2014-03-25 22:26:21.998673	13092	24.1	1	10
2014-03-25 22:26:22.223157	13093	49	2	10
2014-03-25 22:27:00.999564	13101	24.1	1	10
2014-03-25 22:27:01.23161	13102	49	2	10
2014-03-25 22:27:40.117337	13110	24.1	1	10
2014-03-25 22:27:40.340836	13111	49	2	10
2014-03-25 22:28:18.998579	13118	24.0	1	10
2014-03-25 22:28:19.223382	13119	49	2	10
2014-03-25 22:28:57.997129	13127	24.0	1	10
2014-03-25 22:28:58.228145	13128	49	2	10
2014-03-25 22:29:36.998454	13137	24.0	1	10
2014-03-25 22:29:37.219237	13138	49	2	10
2014-03-25 22:30:15.998611	13147	24.0	1	10
2014-03-25 22:30:16.23253	13148	48	2	10
2014-03-25 22:30:54.999359	13156	24.0	1	10
2014-03-25 22:30:55.221228	13157	48	2	10
2014-03-25 22:31:34.205528	13165	24.0	1	10
2014-03-25 22:31:34.429013	13166	48	2	10
2014-03-25 22:32:13.00113	13173	24.0	1	10
2014-03-25 22:32:13.233011	13174	48	2	10
2014-03-25 22:32:51.999227	13182	24.0	1	10
2014-03-25 22:32:52.226943	13183	48	2	10
2014-03-26 21:32:12.361405	31284	47	2	8
2014-03-25 22:33:32.710353	13194	434	3	2
2014-03-25 22:33:33.17313	13195	20.9	1	8
2014-03-25 22:33:33.396233	13196	55	2	8
2014-03-25 22:33:48.499367	13197	19.6	1	1
2014-03-25 22:33:48.721394	13198	50	2	1
2014-03-25 22:34:08.710597	13199	482	3	2
2014-03-26 21:32:26.710375	31285	20.4	1	1
2014-03-26 21:32:26.943323	31286	50	2	1
2014-03-25 22:34:12.17268	13204	20.9	1	8
2014-03-25 22:34:12.404968	13205	55	2	8
2014-03-25 22:34:27.49934	13206	19.6	1	1
2014-03-25 22:34:27.723419	13207	50	2	1
2014-03-25 22:34:32.70508	13208	482	3	2
2014-03-25 22:34:44.716624	13209	595	3	2
2014-03-26 21:32:32.563945	31287	482	3	2
2014-03-26 21:32:32.788456	31288	1088053.6648395376	4	2
2014-03-25 22:34:51.173422	13214	20.9	1	8
2014-03-25 22:34:51.415405	13215	55	2	8
2014-03-25 22:34:56.713002	13216	627	3	2
2014-03-25 22:35:06.496502	13217	19.6	1	1
2014-03-25 22:35:06.722241	13218	50	2	1
2014-03-25 22:35:08.714281	13219	627	3	2
2014-03-26 21:32:39.696461	31289	24.2	1	10
2014-03-26 21:32:39.931204	31290	41	2	10
2014-03-25 22:35:30.172655	13224	20.9	1	8
2014-03-25 22:35:30.415415	13225	55	2	8
2014-03-25 22:35:32.839936	13226	659	3	2
2014-03-25 22:35:44.713475	13227	659	3	2
2014-03-25 22:35:45.500704	13228	19.6	1	1
2014-03-25 22:35:45.734625	13229	50	2	1
2014-03-26 21:32:50.048571	31291	22.3	1	9
2014-03-26 21:32:50.273621	31292	48	2	9
2014-03-25 22:36:09.299908	13234	20.9	1	8
2014-03-25 22:36:09.723424	13235	55	2	8
2014-03-25 22:36:24.495813	13236	19.7	1	1
2014-03-25 22:36:24.72782	13237	50	2	1
2014-03-25 22:36:32.712683	13238	659	3	2
2014-03-26 21:32:51.134687	31293	22.5	1	8
2014-03-26 21:32:51.367596	31294	47	2	8
2014-03-25 22:36:48.17276	13243	20.9	1	8
2014-03-25 22:36:48.403898	13244	55	2	8
2014-03-25 22:37:03.496792	13245	19.7	1	1
2014-03-25 22:37:03.719071	13246	50	2	1
2014-03-25 22:37:08.709899	13247	627	3	2
2014-03-25 22:37:20.711091	13248	547	3	2
2014-03-26 21:33:05.95005	31295	20.4	1	1
2014-03-26 21:33:06.173977	31296	50	2	1
2014-03-25 22:37:27.172862	13253	20.9	1	8
2014-03-25 22:37:27.403362	13254	55	2	8
2014-03-25 22:37:32.712386	13255	531	3	2
2014-03-25 22:37:42.495831	13256	19.7	1	1
2014-03-25 22:37:42.7196	13257	50	2	1
2014-03-25 22:37:44.706868	13258	595	3	2
2014-03-25 22:37:56.71301	13259	611	3	2
2014-03-26 21:33:18.695692	31297	24.2	1	10
2014-03-26 21:33:18.931572	31298	41	2	10
2014-03-25 22:38:06.17463	13264	20.9	1	8
2014-03-25 22:38:06.59304	13265	55	2	8
2014-03-25 22:38:21.493384	13266	19.7	1	1
2014-03-25 22:38:21.71613	13267	50	2	1
2014-03-25 22:38:32.711538	13268	595	3	2
2014-03-26 21:33:29.048317	31299	22.3	1	9
2014-03-26 21:33:29.272365	31300	48	2	9
2014-03-25 22:38:45.17222	13273	20.9	1	8
2014-03-25 22:38:45.404665	13274	55	2	8
2014-03-25 22:38:56.706841	13275	627	3	2
2014-03-25 22:39:00.492704	13276	19.7	1	1
2014-03-25 22:39:00.723979	13277	50	2	1
2014-03-25 22:39:08.707648	13278	595	3	2
2014-03-25 22:39:20.71115	13279	595	3	2
2014-03-26 21:33:30.134655	31301	22.4	1	8
2014-03-26 21:33:30.36961	31302	47	2	8
2014-03-25 22:39:24.173245	13284	20.9	1	8
2014-03-25 22:39:24.407608	13285	55	2	8
2014-03-25 22:39:32.707892	13286	595	3	2
2014-03-25 22:39:39.494859	13287	19.7	1	1
2014-03-25 22:39:39.718865	13288	50	2	1
2014-03-26 21:33:32.566686	31303	482	3	2
2014-03-26 21:33:32.790046	31304	1088061.7080825875	4	2
2014-03-25 22:40:03.173018	13293	20.9	1	8
2014-03-25 22:40:03.395145	13294	55	2	8
2014-03-25 22:40:18.496869	13295	19.7	1	1
2014-03-25 22:40:18.728515	13296	50	2	1
2014-03-25 22:40:32.709588	13297	595	3	2
2014-03-26 21:33:44.70798	31305	20.4	1	1
2014-03-26 21:33:44.942827	31306	50	2	1
2014-03-25 22:40:42.173212	13302	20.9	1	8
2014-03-25 22:40:42.403396	13303	54	2	8
2014-03-25 22:40:57.493698	13304	19.7	1	1
2014-03-25 22:40:57.717706	13305	50	2	1
2014-03-26 21:33:57.695847	31307	24.2	1	10
2014-03-26 21:33:57.920669	31308	41	2	10
2014-03-25 22:41:21.172653	13310	20.9	1	8
2014-03-25 22:41:21.404318	13311	54	2	8
2014-03-25 22:41:32.711638	13312	595	3	2
2014-03-25 22:41:36.4958	13313	19.7	1	1
2014-03-25 22:41:36.717498	13314	50	2	1
2014-03-25 22:41:44.708596	13315	547	3	2
2014-03-25 22:41:56.709414	13316	531	3	2
2014-03-26 21:34:08.047892	31309	22.3	1	9
2014-03-26 21:34:08.281945	31310	48	2	9
2014-03-25 22:42:00.1744	13321	20.9	1	8
2014-03-25 22:42:00.407855	13322	54	2	8
2014-03-25 22:42:15.495709	13323	19.7	1	1
2014-03-25 22:42:15.719427	13324	50	2	1
2014-03-25 22:42:32.711784	13325	547	3	2
2014-03-25 22:34:09.999405	13200	24.0	1	10
2014-03-25 22:34:10.233995	13201	48	2	10
2014-03-25 22:34:48.998886	13210	23.9	1	10
2014-03-25 22:34:49.221867	13211	49	2	10
2014-03-25 22:35:27.999423	13220	23.9	1	10
2014-03-25 22:35:28.23335	13221	49	2	10
2014-03-25 22:36:07.130051	13230	23.9	1	10
2014-03-25 22:36:07.54999	13231	49	2	10
2014-03-25 22:36:45.998618	13239	23.9	1	10
2014-03-25 22:36:46.223211	13240	49	2	10
2014-03-25 22:37:25.00074	13249	23.9	1	10
2014-03-25 22:37:25.26007	13250	49	2	10
2014-03-25 22:38:04.000195	13260	23.9	1	10
2014-03-25 22:38:04.244589	13261	49	2	10
2014-03-25 22:38:43.000438	13269	23.9	1	10
2014-03-25 22:38:43.22582	13270	49	2	10
2014-03-25 22:39:22.000686	13280	23.9	1	10
2014-03-25 22:39:22.231745	13281	49	2	10
2014-03-25 22:40:01.000499	13289	23.9	1	10
2014-03-25 22:40:01.223725	13290	49	2	10
2014-03-25 22:40:40.001106	13298	23.9	1	10
2014-03-25 22:40:40.231803	13299	49	2	10
2014-03-25 22:41:19.002231	13306	23.8	1	10
2014-03-25 22:41:19.24549	13307	49	2	10
2014-03-25 22:41:58.001921	13317	23.8	1	10
2014-03-25 22:41:58.232821	13318	49	2	10
2014-03-26 21:34:09.136676	31311	22.4	1	8
2014-03-25 22:42:39.17246	13330	20.9	1	8
2014-03-25 22:42:39.394672	13331	54	2	8
2014-03-25 22:42:54.548138	13332	19.7	1	1
2014-03-25 22:42:54.78148	13333	50	2	1
2014-03-26 21:34:09.36162	31312	47	2	8
2014-03-26 21:34:23.706978	31313	20.4	1	1
2014-03-25 22:43:18.172405	13338	20.9	1	8
2014-03-25 22:43:18.394408	13339	54	2	8
2014-03-25 22:43:32.707735	13340	531	3	2
2014-03-25 22:43:33.733516	13341	19.7	1	1
2014-03-25 22:43:33.958254	13342	50	2	1
2014-03-26 21:34:23.958995	31314	50	2	1
2014-03-26 21:34:32.565087	31315	531	3	2
2014-03-25 22:43:57.17467	13347	20.9	1	8
2014-03-25 22:43:57.407585	13348	54	2	8
2014-03-25 22:44:12.49083	13349	19.7	1	1
2014-03-25 22:44:12.714947	13350	50	2	1
2014-03-25 22:44:32.709921	13351	547	3	2
2014-03-26 21:34:32.789641	31316	1088069.7513256373	4	2
2014-03-26 21:34:36.904441	31317	24.2	1	10
2014-03-25 22:44:36.174113	13356	20.9	1	8
2014-03-25 22:44:36.396827	13357	54	2	8
2014-03-25 22:44:51.491654	13358	19.7	1	1
2014-03-25 22:44:51.724905	13359	50	2	1
2014-03-26 21:34:37.138866	31318	41	2	10
2014-03-26 21:34:44.564907	31319	531	3	2
2014-03-25 22:45:15.172629	13364	20.9	1	8
2014-03-25 22:45:15.396872	13365	54	2	8
2014-03-25 22:45:30.495425	13366	19.7	1	1
2014-03-25 22:45:30.732391	13367	50	2	1
2014-03-25 22:45:32.709347	13368	547	3	2
2014-03-26 21:34:44.79099	31320	1088072.0493950802	4	2
2014-03-26 21:34:47.047905	31321	22.3	1	9
2014-03-25 22:45:54.172409	13373	20.9	1	8
2014-03-25 22:45:54.403389	13374	54	2	8
2014-03-25 22:46:09.488907	13375	19.7	1	1
2014-03-25 22:46:09.714741	13376	50	2	1
2014-03-26 21:34:47.281055	31322	48	2	9
2014-03-26 21:34:48.134962	31323	22.4	1	8
2014-03-25 22:46:32.710569	13381	547	3	2
2014-03-25 22:46:33.172917	13382	20.9	1	8
2014-03-25 22:46:33.394513	13383	54	2	8
2014-03-25 22:46:48.492174	13384	19.7	1	1
2014-03-25 22:46:48.724805	13385	50	2	1
2014-03-25 22:47:08.567103	13386	515	3	2
2014-03-25 22:47:08.875978	13387	515	3	2
2014-03-26 21:34:48.356262	31324	47	2	8
2014-03-26 21:35:02.714251	31325	20.4	1	1
2014-03-25 22:47:12.172378	13392	20.9	1	8
2014-03-25 22:47:12.406099	13393	54	2	8
2014-03-25 22:47:27.489878	13394	19.7	1	1
2014-03-25 22:47:27.71284	13395	50	2	1
2014-03-25 22:47:32.70758	13396	515	3	2
2014-03-26 21:35:02.948806	31326	50	2	1
2014-03-26 21:35:15.697827	31327	24.2	1	10
2014-03-25 22:47:51.17204	13401	20.9	1	8
2014-03-25 22:47:51.394344	13402	54	2	8
2014-03-25 22:48:06.48915	13403	19.7	1	1
2014-03-25 22:48:06.72296	13404	50	2	1
2014-03-26 21:35:15.922969	31328	41	2	10
2014-03-26 21:35:20.563804	31329	482	3	2
2014-03-25 22:48:30.172527	13409	20.9	1	8
2014-03-25 22:48:30.394194	13410	54	2	8
2014-03-25 22:48:32.710524	13411	515	3	2
2014-03-25 22:48:45.730929	13412	19.7	1	1
2014-03-25 22:48:45.952741	13413	50	2	1
2014-03-26 21:35:20.800999	31330	1088076.645533966	4	2
2014-03-26 21:35:26.048548	31331	22.3	1	9
2014-03-25 22:49:08.710088	13418	547	3	2
2014-03-25 22:49:09.175078	13419	20.9	1	8
2014-03-25 22:49:09.406496	13420	54	2	8
2014-03-25 22:49:20.708576	13421	595	3	2
2014-03-25 22:49:24.493715	13422	19.7	1	1
2014-03-25 22:49:24.71582	13423	50	2	1
2014-03-25 22:49:32.710142	13424	611	3	2
2014-03-26 21:35:26.276514	31332	48	2	9
2014-03-26 21:35:27.134295	31333	22.4	1	8
2014-03-25 22:49:48.173991	13429	20.9	1	8
2014-03-25 22:49:48.398207	13430	54	2	8
2014-03-25 22:50:03.488647	13431	19.7	1	1
2014-03-25 22:50:03.722763	13432	50	2	1
2014-03-26 21:35:27.367255	31334	47	2	8
2014-03-26 21:35:32.569785	31335	531	3	2
2014-03-25 22:50:27.172756	13437	20.9	1	8
2014-03-25 22:50:27.396141	13438	54	2	8
2014-03-25 22:50:32.708696	13439	547	3	2
2014-03-25 22:50:42.49163	13440	19.7	1	1
2014-03-25 22:50:42.713669	13441	50	2	1
2014-03-25 22:50:44.711793	13442	547	3	2
2014-03-25 22:50:56.711756	13443	434	3	2
2014-03-26 21:35:32.796674	31336	1088078.9436034088	4	2
2014-03-26 21:35:41.710776	31337	20.4	1	1
2014-03-25 22:51:06.172046	13448	20.9	1	8
2014-03-25 22:51:06.393976	13449	54	2	8
2014-03-25 22:51:08.70546	13450	531	3	2
2014-03-25 22:51:20.709519	13451	531	3	2
2014-03-25 22:51:21.488915	13452	19.7	1	1
2014-03-25 22:51:21.713066	13453	50	2	1
2014-03-25 22:51:32.71194	13454	611	3	2
2014-03-25 22:51:44.71457	13459	611	3	2
2014-03-25 22:51:45.17228	13460	20.9	1	8
2014-03-25 22:51:45.394597	13461	54	2	8
2014-03-25 22:52:00.488903	13462	19.7	1	1
2014-03-25 22:52:00.713287	13463	50	2	1
2014-03-25 22:52:08.706059	13464	676	3	2
2014-03-25 22:43:16.002286	13334	23.8	1	10
2014-03-25 22:43:16.226896	13335	49	2	10
2014-03-25 22:43:55.001551	13343	23.8	1	10
2014-03-25 22:43:55.235348	13344	49	2	10
2014-03-25 22:44:34.001036	13352	23.8	1	10
2014-03-25 22:44:34.223037	13353	49	2	10
2014-03-25 22:45:13.00117	13360	23.8	1	10
2014-03-25 22:45:13.224128	13361	49	2	10
2014-03-25 22:45:52.002076	13369	23.8	1	10
2014-03-25 22:45:52.223974	13370	49	2	10
2014-03-25 22:46:31.007307	13377	23.8	1	10
2014-03-25 22:46:31.238594	13378	49	2	10
2014-03-25 22:47:10.003038	13388	23.8	1	10
2014-03-25 22:47:10.239733	13389	49	2	10
2014-03-25 22:47:49.004843	13397	23.8	1	10
2014-03-25 22:47:49.228658	13398	49	2	10
2014-03-25 22:48:28.003935	13405	23.7	1	10
2014-03-25 22:48:28.226551	13406	49	2	10
2014-03-25 22:49:07.208555	13414	23.7	1	10
2014-03-25 22:49:07.431696	13415	49	2	10
2014-03-25 22:49:46.004196	13425	23.7	1	10
2014-03-25 22:49:46.226939	13426	49	2	10
2014-03-25 22:50:25.003787	13433	23.7	1	10
2014-03-25 22:50:25.236914	13434	49	2	10
2014-03-25 22:51:04.004857	13444	23.7	1	10
2014-03-25 22:51:04.230289	13445	49	2	10
2014-03-25 22:51:43.007671	13455	23.7	1	10
2014-03-25 22:52:20.705572	13465	676	3	2
2014-03-26 21:35:41.947115	31338	50	2	1
2014-03-26 21:35:44.565302	31339	515	3	2
2014-03-25 22:52:24.173823	13470	21.0	1	8
2014-03-25 22:52:24.395316	13471	54	2	8
2014-03-25 22:52:32.706624	13472	595	3	2
2014-03-25 22:52:39.489708	13473	19.7	1	1
2014-03-25 22:52:39.714875	13474	50	2	1
2014-03-25 22:52:44.707741	13475	595	3	2
2014-03-26 21:35:44.790762	31340	1088080.09263813	4	2
2014-03-26 21:35:54.696504	31341	24.2	1	10
2014-03-25 22:53:03.173393	13480	21.0	1	8
2014-03-25 22:53:03.395624	13481	54	2	8
2014-03-25 22:53:08.711465	13482	498	3	2
2014-03-25 22:53:18.487725	13483	19.7	1	1
2014-03-25 22:53:18.711457	13484	50	2	1
2014-03-25 22:53:20.710037	13485	482	3	2
2014-03-25 22:53:32.7089	13486	498	3	2
2014-03-26 21:35:54.935315	31342	41	2	10
2014-03-26 21:36:05.048282	31343	22.3	1	9
2014-03-25 22:53:42.173678	13491	21.0	1	8
2014-03-25 22:53:42.403855	13492	54	2	8
2014-03-25 22:53:56.70632	13493	434	3	2
2014-03-25 22:53:57.486667	13494	19.7	1	1
2014-03-25 22:53:57.708661	13495	50	2	1
2014-03-25 22:54:08.708954	13496	434	3	2
2014-03-26 21:36:05.272096	31344	48	2	9
2014-03-26 21:36:06.134173	31345	22.4	1	8
2014-03-25 22:54:21.175292	13501	21.0	1	8
2014-03-25 22:54:21.396918	13502	54	2	8
2014-03-25 22:54:32.705228	13503	434	3	2
2014-03-25 22:54:36.48537	13504	19.7	1	1
2014-03-25 22:54:36.707454	13505	50	2	1
2014-03-26 21:36:06.367591	31346	47	2	8
2014-03-26 21:36:20.707818	31347	20.4	1	1
2014-03-25 22:55:00.172613	13510	21.0	1	8
2014-03-25 22:55:00.406823	13511	54	2	8
2014-03-25 22:55:15.482851	13512	19.7	1	1
2014-03-25 22:55:15.705317	13513	50	2	1
2014-03-25 22:55:32.705382	13514	434	3	2
2014-03-26 21:36:20.93442	31348	50	2	1
2014-03-26 21:36:32.565983	31349	531	3	2
2014-03-25 22:55:39.173018	13519	21.0	1	8
2014-03-25 22:55:39.399214	13520	54	2	8
2014-03-25 22:55:54.489188	13521	19.7	1	1
2014-03-25 22:55:54.723932	13522	50	2	1
2014-03-26 21:36:32.800285	31350	1088088.13588118	4	2
2014-03-26 21:36:33.696739	31351	24.2	1	10
2014-03-25 22:56:18.172076	13527	21.0	1	8
2014-03-25 22:56:18.393961	13528	54	2	8
2014-03-25 22:56:32.840026	13529	418	3	2
2014-03-25 22:56:33.609181	13530	19.7	1	1
2014-03-25 22:56:34.03067	13531	50	2	1
2014-03-26 21:36:33.922548	31352	41	2	10
2014-03-26 21:36:44.0483	31353	22.3	1	9
2014-03-25 22:56:57.173003	13536	21.0	1	8
2014-03-25 22:56:57.403641	13537	53	2	8
2014-03-25 22:57:12.483545	13538	19.7	1	1
2014-03-25 22:57:12.707363	13539	50	2	1
2014-03-25 22:57:32.712929	13540	434	3	2
2014-03-26 21:36:44.28183	31354	48	2	9
2014-03-26 21:36:45.134905	31355	22.4	1	8
2014-03-25 22:57:36.171936	13545	21.0	1	8
2014-03-25 22:57:36.394241	13546	53	2	8
2014-03-25 22:57:51.48614	13547	19.7	1	1
2014-03-25 22:57:51.720111	13548	50	2	1
2014-03-26 21:36:45.357524	31356	47	2	8
2014-03-26 21:36:59.710479	31357	20.4	1	1
2014-03-25 22:58:15.176289	13553	21.0	1	8
2014-03-25 22:58:15.399606	13554	53	2	8
2014-03-25 22:58:30.483982	13555	19.7	1	1
2014-03-25 22:58:30.738298	13556	50	2	1
2014-03-25 22:58:32.705001	13557	434	3	2
2014-03-26 21:36:59.945684	31358	50	2	1
2014-03-26 21:37:12.69716	31359	24.2	1	10
2014-03-25 22:58:54.1734	13562	21.0	1	8
2014-03-25 22:58:54.396469	13563	53	2	8
2014-03-25 22:59:09.484027	13564	19.6	1	1
2014-03-25 22:59:09.70605	13565	50	2	1
2014-03-26 21:37:12.923102	31360	41	2	10
2014-03-26 21:37:23.050266	31361	22.3	1	9
2014-03-25 22:59:32.705661	13570	434	3	2
2014-03-25 22:59:33.175461	13571	21.0	1	8
2014-03-25 22:59:33.400276	13572	53	2	8
2014-03-25 22:59:48.48601	13573	19.6	1	1
2014-03-25 22:59:48.729739	13574	50	2	1
2014-03-25 22:59:56.70523	13575	370	3	2
2014-03-25 23:00:08.702303	13576	370	3	2
2014-03-26 21:37:23.295246	31362	48	2	9
2014-03-26 21:37:24.136849	31363	22.4	1	8
2014-03-25 23:00:12.17213	13581	21.0	1	8
2014-03-25 23:00:12.406426	13582	53	2	8
2014-03-25 23:00:20.704086	13583	402	3	2
2014-03-25 23:00:27.48354	13584	19.6	1	1
2014-03-25 23:00:27.705642	13585	50	2	1
2014-03-25 23:00:32.706634	13586	402	3	2
2014-03-25 23:00:44.708601	13587	370	3	2
2014-03-26 21:37:24.361255	31364	47	2	8
2014-03-26 21:37:32.563959	31365	531	3	2
2014-03-26 21:37:32.799806	31366	1088096.1791242298	4	2
2014-03-26 21:37:38.708047	31367	20.4	1	1
2014-03-25 23:00:51.17314	13592	21.0	1	8
2014-03-25 23:00:51.405724	13593	53	2	8
2014-03-25 23:00:56.706448	13594	402	3	2
2014-03-25 23:01:06.487012	13595	19.6	1	1
2014-03-25 23:01:06.714167	13596	50	2	1
2014-03-25 23:01:20.565661	13597	370	3	2
2014-03-25 23:01:20.870976	13598	370	3	2
2014-03-25 22:52:22.004697	13466	23.7	1	10
2014-03-25 22:52:22.226629	13467	49	2	10
2014-03-25 22:53:01.00355	13476	23.7	1	10
2014-03-25 22:53:01.227403	13477	49	2	10
2014-03-25 22:53:40.006288	13487	23.7	1	10
2014-03-25 22:53:40.230354	13488	49	2	10
2014-03-25 22:54:19.004774	13497	23.7	1	10
2014-03-25 22:54:19.229733	13498	49	2	10
2014-03-25 22:54:58.004591	13506	23.7	1	10
2014-03-25 22:54:58.229059	13507	49	2	10
2014-03-25 22:55:37.004947	13515	23.7	1	10
2014-03-25 22:55:37.227976	13516	49	2	10
2014-03-25 22:56:16.006607	13523	23.7	1	10
2014-03-25 22:56:16.228881	13524	49	2	10
2014-03-25 22:56:55.024585	13532	23.7	1	10
2014-03-25 22:56:55.256078	13533	49	2	10
2014-03-25 22:57:34.006009	13541	23.7	1	10
2014-03-25 22:57:34.227114	13542	49	2	10
2014-03-25 22:58:13.00617	13549	23.6	1	10
2014-03-25 22:58:13.227749	13550	49	2	10
2014-03-25 22:58:52.006912	13558	23.6	1	10
2014-03-25 22:58:52.229085	13559	49	2	10
2014-03-25 22:59:31.008523	13566	23.6	1	10
2014-03-25 22:59:31.246503	13567	49	2	10
2014-03-25 23:00:10.007334	13577	23.6	1	10
2014-03-25 23:00:10.240035	13578	49	2	10
2014-03-26 21:37:38.935378	31368	50	2	1
2014-03-26 21:37:51.697281	31369	24.2	1	10
2014-03-25 23:01:30.172723	13603	21.0	1	8
2014-03-25 23:01:30.404282	13604	53	2	8
2014-03-25 23:01:32.706177	13605	402	3	2
2014-03-25 23:01:44.7059	13606	434	3	2
2014-03-25 23:01:45.485585	13607	19.6	1	1
2014-03-25 23:01:45.717394	13608	50	2	1
2014-03-25 23:01:56.707873	13609	434	3	2
2014-03-26 21:37:51.930206	31370	41	2	10
2014-03-26 21:38:02.04773	31371	22.3	1	9
2014-03-25 23:02:09.171123	13614	21.0	1	8
2014-03-25 23:02:09.393505	13615	53	2	8
2014-03-25 23:02:24.477736	13616	19.6	1	1
2014-03-25 23:02:24.703413	13617	50	2	1
2014-03-25 23:02:32.712023	13618	434	3	2
2014-03-26 21:38:02.272933	31372	48	2	9
2014-03-26 21:38:03.135957	31373	22.4	1	8
2014-03-25 23:02:48.172345	13623	21.0	1	8
2014-03-25 23:02:48.393438	13624	53	2	8
2014-03-25 23:03:03.482181	13625	19.6	1	1
2014-03-25 23:03:03.714366	13626	50	2	1
2014-03-26 21:38:03.369043	31374	47	2	8
2014-03-26 21:38:17.707252	31375	20.4	1	1
2014-03-25 23:03:27.172484	13631	21.0	1	8
2014-03-25 23:03:27.39515	13632	53	2	8
2014-03-25 23:03:42.283171	13633	434	3	2
2014-03-25 23:03:42.600194	13634	19.6	1	1
2014-03-25 23:03:42.823394	13635	50	2	1
2014-03-26 21:38:17.93229	31376	50	2	1
2014-03-26 21:38:30.698204	31377	24.2	1	10
2014-03-25 23:04:06.172588	13640	21.0	1	8
2014-03-25 23:04:06.40402	13641	53	2	8
2014-03-25 23:04:21.481274	13642	19.6	1	1
2014-03-25 23:04:21.704368	13643	50	2	1
2014-03-25 23:04:32.707718	13644	450	3	2
2014-03-26 21:38:30.932881	31378	41	2	10
2014-03-26 21:38:32.564811	31379	531	3	2
2014-03-25 23:04:45.174287	13649	21.0	1	8
2014-03-25 23:04:45.396302	13650	53	2	8
2014-03-25 23:05:00.484273	13651	19.6	1	1
2014-03-25 23:05:00.72224	13652	50	2	1
2014-03-26 21:38:32.788192	31380	1088105.3714020012	4	2
2014-03-26 21:38:41.047947	31381	22.3	1	9
2014-03-25 23:05:24.17428	13657	21.0	1	8
2014-03-25 23:05:24.394763	13658	53	2	8
2014-03-25 23:05:32.708695	13659	434	3	2
2014-03-25 23:05:39.478085	13660	19.6	1	1
2014-03-25 23:05:39.701103	13661	50	2	1
2014-03-26 21:38:41.284324	31382	48	2	9
2014-03-26 21:38:42.134503	31383	22.4	1	8
2014-03-25 23:06:03.173232	13666	21.0	1	8
2014-03-25 23:06:03.406677	13667	53	2	8
2014-03-25 23:06:18.478169	13668	19.6	1	1
2014-03-25 23:06:18.700047	13669	50	2	1
2014-03-25 23:06:20.707689	13670	370	3	2
2014-03-25 23:06:39.807721	13671	370	3	2
2014-03-26 21:38:42.358322	31384	47	2	8
2014-03-26 21:38:56.7045	31385	20.4	1	1
2014-03-25 23:06:42.172484	13676	21.0	1	8
2014-03-25 23:06:42.394314	13677	53	2	8
2014-03-25 23:06:44.827111	13678	305	3	2
2014-03-25 23:06:56.707696	13679	338	3	2
2014-03-25 23:06:57.476127	13680	19.6	1	1
2014-03-25 23:06:57.698542	13681	50	2	1
2014-03-25 23:07:08.707148	13682	338	3	2
2014-03-26 21:38:56.939015	31386	50	2	1
2014-03-26 21:39:08.568251	31387	466	3	2
2014-03-25 23:07:20.705818	13687	305	3	2
2014-03-25 23:07:21.172511	13688	21.0	1	8
2014-03-25 23:07:21.396653	13689	53	2	8
2014-03-25 23:07:32.706661	13690	338	3	2
2014-03-25 23:07:36.477824	13691	19.6	1	1
2014-03-25 23:07:36.702804	13692	49	2	1
2014-03-25 23:07:44.705616	13693	338	3	2
2014-03-26 21:39:08.794086	31388	1088109.967540887	4	2
2014-03-26 21:39:09.697281	31389	24.2	1	10
2014-03-25 23:08:00.173406	13698	21.0	1	8
2014-03-25 23:08:00.40236	13699	53	2	8
2014-03-25 23:08:15.474485	13700	19.6	1	1
2014-03-25 23:08:15.70795	13701	49	2	1
2014-03-25 23:08:32.705917	13702	338	3	2
2014-03-26 21:39:09.931114	31390	41	2	10
2014-03-26 21:39:20.04805	31391	22.3	1	9
2014-03-25 23:08:39.172092	13707	21.0	1	8
2014-03-25 23:08:39.394227	13708	53	2	8
2014-03-25 23:08:54.479246	13709	19.6	1	1
2014-03-25 23:08:54.701984	13710	49	2	1
2014-03-26 21:39:20.273649	31392	48	2	9
2014-03-26 21:39:20.582945	31393	466	3	2
2014-03-25 23:09:18.17124	13715	21.0	1	8
2014-03-25 23:09:18.403581	13716	53	2	8
2014-03-25 23:09:32.704942	13717	338	3	2
2014-03-25 23:09:33.477032	13718	19.6	1	1
2014-03-25 23:09:33.697714	13719	49	2	1
2014-03-26 21:39:20.81642	31394	1088112.2656103298	4	2
2014-03-25 23:09:57.171662	13724	21.0	1	8
2014-03-25 23:09:57.394366	13725	53	2	8
2014-03-25 23:10:12.479398	13726	19.6	1	1
2014-03-25 23:10:12.711963	13727	49	2	1
2014-03-25 23:10:32.714339	13728	338	3	2
2014-03-25 23:10:36.174142	13733	21.0	1	8
2014-03-25 23:10:36.405919	13734	53	2	8
2014-03-25 23:10:51.480147	13735	19.6	1	1
2014-03-25 23:10:51.703614	13736	49	2	1
2014-03-25 23:02:07.011503	13610	23.6	1	10
2014-03-25 23:02:07.233814	13611	48	2	10
2014-03-25 23:02:46.00813	13619	23.6	1	10
2014-03-25 23:02:46.233158	13620	48	2	10
2014-03-25 23:03:25.007315	13627	23.6	1	10
2014-03-25 23:03:25.22968	13628	48	2	10
2014-03-25 23:04:04.010387	13636	23.6	1	10
2014-03-25 23:04:04.242335	13637	48	2	10
2014-03-25 23:04:43.008089	13645	23.6	1	10
2014-03-25 23:04:43.232486	13646	48	2	10
2014-03-25 23:05:22.015792	13653	23.6	1	10
2014-03-25 23:05:22.240436	13654	48	2	10
2014-03-25 23:06:01.013454	13662	23.6	1	10
2014-03-25 23:06:01.255798	13663	48	2	10
2014-03-25 23:06:40.113653	13672	23.6	1	10
2014-03-25 23:06:40.336047	13673	48	2	10
2014-03-25 23:07:19.00999	13683	23.6	1	10
2014-03-25 23:07:19.23499	13684	48	2	10
2014-03-25 23:07:58.009634	13694	23.5	1	10
2014-03-25 23:07:58.235202	13695	48	2	10
2014-03-25 23:08:37.010893	13703	23.5	1	10
2014-03-25 23:08:37.233223	13704	48	2	10
2014-03-25 23:09:16.01242	13711	23.5	1	10
2014-03-25 23:09:16.234866	13712	48	2	10
2014-03-25 23:09:55.009571	13720	23.5	1	10
2014-03-25 23:09:55.251937	13721	48	2	10
2014-03-25 23:10:34.009255	13729	23.5	1	10
2014-03-25 23:10:34.233362	13730	48	2	10
2014-03-26 21:39:21.136443	31395	22.3	1	8
2014-03-26 21:39:21.359921	31396	47	2	8
2014-03-25 23:11:15.172041	13741	21.0	1	8
2014-03-25 23:11:15.406653	13742	53	2	8
2014-03-25 23:11:30.475713	13743	19.6	1	1
2014-03-25 23:11:30.697911	13744	49	2	1
2014-03-25 23:11:32.703396	13745	338	3	2
2014-03-26 21:39:32.563055	31397	466	3	2
2014-03-26 21:39:32.798515	31398	1088113.4146450511	4	2
2014-03-25 23:11:54.172443	13750	21.0	1	8
2014-03-25 23:11:54.395738	13751	53	2	8
2014-03-25 23:12:09.47925	13752	19.6	1	1
2014-03-25 23:12:09.723379	13753	49	2	1
2014-03-26 21:39:35.710007	31399	20.4	1	1
2014-03-26 21:39:35.934283	31400	50	2	1
2014-03-25 23:12:32.971712	13758	338	3	2
2014-03-25 23:12:33.279418	13759	21.0	1	8
2014-03-25 23:12:33.501629	13760	53	2	8
2014-03-25 23:12:48.475937	13761	19.6	1	1
2014-03-25 23:12:48.701554	13762	49	2	1
2014-03-26 21:39:44.568675	31401	434	3	2
2014-03-26 21:39:44.802879	31402	1088114.5636797724	4	2
2014-03-25 23:13:12.173172	13767	21.0	1	8
2014-03-25 23:13:12.405022	13768	53	2	8
2014-03-25 23:13:27.474933	13769	19.6	1	1
2014-03-25 23:13:27.69933	13770	49	2	1
2014-03-25 23:13:32.708428	13771	338	3	2
2014-03-26 21:39:48.697966	31403	24.2	1	10
2014-03-26 21:39:48.92861	31404	41	2	10
2014-03-25 23:13:51.170867	13776	20.9	1	8
2014-03-25 23:13:51.392822	13777	53	2	8
2014-03-25 23:14:06.47582	13778	19.6	1	1
2014-03-25 23:14:06.707827	13779	49	2	1
2014-03-26 21:39:56.566044	31405	482	3	2
2014-03-26 21:39:56.801718	31406	1088116.8617492153	4	2
2014-03-25 23:14:30.172494	13784	20.9	1	8
2014-03-25 23:14:30.394541	13785	53	2	8
2014-03-25 23:14:32.707258	13786	338	3	2
2014-03-25 23:14:44.703324	13787	370	3	2
2014-03-25 23:14:45.472844	13788	19.5	1	1
2014-03-25 23:14:45.694991	13789	49	2	1
2014-03-25 23:14:56.705458	13790	370	3	2
2014-03-26 21:39:59.048223	31407	22.3	1	9
2014-03-26 21:39:59.272605	31408	48	2	9
2014-03-25 23:15:09.172749	13795	20.9	1	8
2014-03-25 23:15:09.395461	13796	53	2	8
2014-03-25 23:15:24.47501	13797	19.5	1	1
2014-03-25 23:15:24.716605	13798	49	2	1
2014-03-25 23:15:32.704358	13799	370	3	2
2014-03-26 21:40:00.136219	31409	22.3	1	8
2014-03-26 21:40:00.382434	31410	47	2	8
2014-03-25 23:15:48.172692	13804	20.9	1	8
2014-03-25 23:15:48.404518	13805	53	2	8
2014-03-25 23:16:03.471932	13806	19.5	1	1
2014-03-25 23:16:03.694917	13807	49	2	1
2014-03-26 21:40:08.56585	31411	450	3	2
2014-03-26 21:40:08.790453	31412	1088118.0107839368	4	2
2014-03-25 23:16:27.172131	13812	20.9	1	8
2014-03-25 23:16:27.406371	13813	53	2	8
2014-03-25 23:16:32.706603	13814	354	3	2
2014-03-25 23:16:42.475817	13815	19.5	1	1
2014-03-25 23:16:42.757736	13816	49	2	1
2014-03-26 21:40:14.702454	31413	20.4	1	1
2014-03-26 21:40:14.936203	31414	50	2	1
2014-03-25 23:17:06.299984	13821	20.9	1	8
2014-03-25 23:17:06.839991	13822	53	2	8
2014-03-25 23:17:21.473078	13823	19.5	1	1
2014-03-25 23:17:21.749716	13824	49	2	1
2014-03-25 23:17:32.708853	13825	354	3	2
2014-03-26 21:40:20.56358	31415	466	3	2
2014-03-26 21:40:20.790948	31416	1088119.1598186581	4	2
2014-03-25 23:17:45.172008	13830	20.9	1	8
2014-03-25 23:17:45.396955	13831	53	2	8
2014-03-25 23:18:00.477244	13832	19.5	1	1
2014-03-25 23:18:00.71347	13833	49	2	1
2014-03-26 21:40:27.700437	31417	24.1	1	10
2014-03-26 21:40:27.934172	31418	41	2	10
2014-03-25 23:18:24.173019	13838	20.9	1	8
2014-03-25 23:18:24.411028	13839	53	2	8
2014-03-25 23:18:32.706164	13840	354	3	2
2014-03-25 23:18:39.511815	13841	19.5	1	1
2014-03-25 23:18:39.759704	13842	49	2	1
2014-03-26 21:40:32.563811	31419	466	3	2
2014-03-26 21:40:32.79098	31420	1088121.457888101	4	2
2014-03-25 23:19:03.171616	13847	20.9	1	8
2014-03-25 23:19:03.393875	13848	53	2	8
2014-03-25 23:19:18.475307	13849	19.5	1	1
2014-03-25 23:19:18.709058	13850	49	2	1
2014-03-25 23:19:32.707522	13851	354	3	2
2014-03-26 21:40:38.048719	31421	22.3	1	9
2014-03-26 21:40:38.286297	31422	48	2	9
2014-03-25 23:19:42.171493	13856	20.9	1	8
2014-03-25 23:19:42.404083	13857	53	2	8
2014-03-25 23:19:57.511857	13858	19.5	1	1
2014-03-25 23:19:57.735334	13859	49	2	1
2014-03-26 21:40:39.135305	31423	22.3	1	8
2014-03-26 21:40:39.35804	31424	47	2	8
2014-03-25 23:20:21.171112	13864	20.9	1	8
2014-03-25 23:20:21.403163	13865	53	2	8
2014-03-25 23:20:32.706372	13866	354	3	2
2014-03-25 23:20:36.471868	13867	19.5	1	1
2014-03-25 23:20:36.740068	13868	49	2	1
2014-03-26 21:40:53.705199	31425	20.4	1	1
2014-03-25 23:11:13.01097	13737	23.5	1	10
2014-03-25 23:11:13.243162	13738	48	2	10
2014-03-25 23:11:52.010052	13746	23.5	1	10
2014-03-25 23:11:52.234077	13747	48	2	10
2014-03-25 23:12:31.011044	13754	23.5	1	10
2014-03-25 23:12:31.23361	13755	48	2	10
2014-03-25 23:13:10.010951	13763	23.5	1	10
2014-03-25 23:13:10.24221	13764	48	2	10
2014-03-25 23:13:49.012014	13772	23.5	1	10
2014-03-25 23:13:49.233933	13773	48	2	10
2014-03-25 23:14:28.220682	13780	23.5	1	10
2014-03-25 23:14:28.446028	13781	48	2	10
2014-03-25 23:15:07.014251	13791	23.5	1	10
2014-03-25 23:15:07.236895	13792	48	2	10
2014-03-25 23:15:46.012086	13800	23.5	1	10
2014-03-25 23:15:46.235456	13801	48	2	10
2014-03-25 23:16:25.011943	13808	23.4	1	10
2014-03-25 23:16:25.245194	13809	48	2	10
2014-03-25 23:17:04.141079	13817	23.4	1	10
2014-03-25 23:17:04.589975	13818	48	2	10
2014-03-25 23:17:43.012396	13826	23.4	1	10
2014-03-25 23:17:43.239443	13827	48	2	10
2014-03-25 23:18:22.012636	13834	23.4	1	10
2014-03-25 23:18:22.245584	13835	48	2	10
2014-03-25 23:19:01.020031	13843	23.4	1	10
2014-03-25 23:19:01.245575	13844	48	2	10
2014-03-25 23:19:40.013775	13852	23.4	1	10
2014-03-25 23:19:40.237647	13853	48	2	10
2014-03-25 23:20:19.015274	13860	23.4	1	10
2014-03-25 23:20:19.246565	13861	48	2	10
2014-03-25 23:21:00.173938	13873	20.9	1	8
2014-03-25 23:21:00.397447	13874	53	2	8
2014-03-25 23:21:15.47213	13875	19.5	1	1
2014-03-25 23:21:15.695067	13876	49	2	1
2014-03-25 23:21:32.705354	13877	354	3	2
2014-03-26 21:40:53.938772	31426	50	2	1
2014-03-26 21:41:06.702097	31427	24.1	1	10
2014-03-25 23:21:39.174025	13882	20.9	1	8
2014-03-25 23:21:39.398995	13883	53	2	8
2014-03-25 23:21:54.469737	13884	19.5	1	1
2014-03-25 23:21:54.703533	13885	49	2	1
2014-03-26 21:41:06.926997	31428	41	2	10
2014-03-26 21:41:08.565959	31429	434	3	2
2014-03-25 23:22:18.172128	13890	20.9	1	8
2014-03-25 23:22:18.397287	13891	53	2	8
2014-03-25 23:22:32.706031	13892	354	3	2
2014-03-25 23:22:33.470807	13893	19.5	1	1
2014-03-25 23:22:33.712676	13894	49	2	1
2014-03-26 21:41:08.8016	31430	1088126.0540269867	4	2
2014-03-26 21:41:17.047156	31431	22.3	1	9
2014-03-25 23:22:57.172509	13899	20.9	1	8
2014-03-25 23:22:57.403734	13900	53	2	8
2014-03-25 23:23:08.706021	13901	305	3	2
2014-03-25 23:23:12.470801	13902	19.5	1	1
2014-03-25 23:23:12.694588	13903	49	2	1
2014-03-25 23:23:20.705157	13904	305	3	2
2014-03-25 23:23:32.705743	13905	305	3	2
2014-03-26 21:41:17.271835	31432	48	2	9
2014-03-26 21:41:18.136055	31433	22.3	1	8
2014-03-25 23:23:36.172819	13910	20.9	1	8
2014-03-25 23:23:36.40403	13911	53	2	8
2014-03-25 23:23:51.469263	13912	19.5	1	1
2014-03-25 23:23:51.693727	13913	49	2	1
2014-03-26 21:41:18.36807	31434	47	2	8
2014-03-26 21:41:20.564029	31435	434	3	2
2014-03-25 23:24:15.17351	13918	20.9	1	8
2014-03-25 23:24:15.406456	13919	53	2	8
2014-03-25 23:24:30.469981	13920	19.5	1	1
2014-03-25 23:24:30.692289	13921	49	2	1
2014-03-25 23:24:32.704268	13922	305	3	2
2014-03-26 21:41:20.789848	31436	1088127.203061708	4	2
2014-03-26 21:41:32.946405	31437	20.4	1	1
2014-03-25 23:24:54.173165	13927	20.9	1	8
2014-03-25 23:24:54.395486	13928	53	2	8
2014-03-25 23:25:09.470628	13929	19.5	1	1
2014-03-25 23:25:09.703551	13930	49	2	1
2014-03-26 21:41:33.180307	31438	50	2	1
2014-03-26 21:41:44.562773	31439	498	3	2
2014-03-25 23:25:32.706784	13935	305	3	2
2014-03-25 23:25:33.17278	13936	20.9	1	8
2014-03-25 23:25:33.394391	13937	53	2	8
2014-03-25 23:25:48.469923	13938	19.5	1	1
2014-03-25 23:25:48.693395	13939	49	2	1
2014-03-26 21:41:44.786822	31440	1088130.6501658724	4	2
2014-03-26 21:41:45.698986	31441	24.1	1	10
2014-03-25 23:26:12.174182	13944	20.9	1	8
2014-03-25 23:26:12.40509	13945	53	2	8
2014-03-25 23:26:27.467329	13946	19.5	1	1
2014-03-25 23:26:27.691729	13947	49	2	1
2014-03-25 23:26:32.703025	13948	289	3	2
2014-03-26 21:41:45.936844	31442	41	2	10
2014-03-26 21:41:56.048207	31443	22.3	1	9
2014-03-25 23:26:51.173997	13953	20.9	1	8
2014-03-25 23:26:51.394901	13954	53	2	8
2014-03-25 23:27:06.469697	13955	19.5	1	1
2014-03-25 23:27:06.702072	13956	49	2	1
2014-03-26 21:41:56.274	31444	48	2	9
2014-03-26 21:41:56.582262	31445	434	3	2
2014-03-25 23:27:30.172735	13961	20.9	1	8
2014-03-25 23:27:30.397272	13962	53	2	8
2014-03-25 23:27:32.707519	13963	305	3	2
2014-03-25 23:27:45.464506	13964	19.5	1	1
2014-03-25 23:27:45.689207	13965	49	2	1
2014-03-26 21:41:56.816331	31446	1088131.7992005937	4	2
2014-03-26 21:41:57.136248	31447	22.3	1	8
2014-03-25 23:28:09.17311	13970	20.9	1	8
2014-03-25 23:28:09.39635	13971	53	2	8
2014-03-25 23:28:24.469516	13972	19.5	1	1
2014-03-25 23:28:24.693441	13973	49	2	1
2014-03-25 23:28:32.702462	13974	305	3	2
2014-03-26 21:41:57.358671	31448	47	2	8
2014-03-26 21:42:08.565274	31449	434	3	2
2014-03-25 23:28:48.172373	13979	20.9	1	8
2014-03-25 23:28:48.395037	13980	53	2	8
2014-03-25 23:29:03.46512	13981	19.5	1	1
2014-03-25 23:29:03.691948	13982	49	2	1
2014-03-26 21:42:08.799518	31450	1088134.0972700366	4	2
2014-03-26 21:42:11.704374	31451	20.4	1	1
2014-03-25 23:29:27.172684	13987	20.9	1	8
2014-03-25 23:29:27.394844	13988	53	2	8
2014-03-25 23:29:32.703911	13989	305	3	2
2014-03-25 23:29:42.465719	13990	19.5	1	1
2014-03-25 23:29:42.691124	13991	49	2	1
2014-03-26 21:42:11.929304	31452	50	2	1
2014-03-26 21:42:20.563946	31453	482	3	2
2014-03-25 23:30:06.17207	13996	20.9	1	8
2014-03-25 23:30:06.403327	13997	53	2	8
2014-03-25 23:30:21.464469	13998	19.5	1	1
2014-03-25 23:30:21.68778	13999	49	2	1
2014-03-25 23:30:32.705271	14000	305	3	2
2014-03-26 21:42:20.799726	31454	1088135.246304758	4	2
2014-03-25 23:30:45.173023	14005	20.9	1	8
2014-03-25 23:30:45.395913	14006	53	2	8
2014-03-25 23:31:00.462821	14007	19.4	1	1
2014-03-25 23:31:00.685124	14008	49	2	1
2014-03-25 23:21:37.013309	13878	23.4	1	10
2014-03-25 23:21:37.238274	13879	48	2	10
2014-03-25 23:22:16.013966	13886	23.4	1	10
2014-03-25 23:22:16.237262	13887	48	2	10
2014-03-25 23:22:55.015684	13895	23.4	1	10
2014-03-25 23:22:55.240252	13896	48	2	10
2014-03-25 23:23:34.014781	13906	23.4	1	10
2014-03-25 23:23:34.254146	13907	48	2	10
2014-03-25 23:24:13.015505	13914	23.3	1	10
2014-03-25 23:24:13.248805	13915	48	2	10
2014-03-25 23:24:52.016876	13923	23.3	1	10
2014-03-25 23:24:52.241172	13924	48	2	10
2014-03-25 23:25:31.016222	13931	23.3	1	10
2014-03-25 23:25:31.242708	13932	48	2	10
2014-03-25 23:26:10.014658	13940	23.3	1	10
2014-03-25 23:26:10.239649	13941	48	2	10
2014-03-25 23:26:49.016042	13949	23.3	1	10
2014-03-25 23:26:49.241469	13950	48	2	10
2014-03-25 23:27:28.015711	13957	23.3	1	10
2014-03-25 23:27:28.239373	13958	48	2	10
2014-03-25 23:28:07.015174	13966	23.3	1	10
2014-03-25 23:28:07.237742	13967	48	2	10
2014-03-25 23:28:46.016675	13975	23.3	1	10
2014-03-25 23:28:46.239016	13976	48	2	10
2014-03-25 23:29:25.016668	13983	23.3	1	10
2014-03-25 23:29:25.238115	13984	48	2	10
2014-03-25 23:30:04.016978	13992	23.3	1	10
2014-03-25 23:30:04.251003	13993	48	2	10
2014-03-26 21:42:24.699048	31455	24.1	1	10
2014-03-26 21:42:24.924134	31456	41	2	10
2014-03-25 23:31:24.171691	14013	20.9	1	8
2014-03-25 23:31:24.397741	14014	53	2	8
2014-03-25 23:31:32.70663	14015	354	3	2
2014-03-25 23:31:39.466563	14016	19.4	1	1
2014-03-25 23:31:39.690218	14017	49	2	1
2014-03-25 23:31:44.706697	14018	354	3	2
2014-03-26 21:42:32.562681	31457	450	3	2
2014-03-26 21:42:32.809708	31458	1088136.3953394794	4	2
2014-03-25 23:32:03.174849	14023	20.9	1	8
2014-03-25 23:32:03.396741	14024	53	2	8
2014-03-25 23:32:18.46466	14025	19.4	1	1
2014-03-25 23:32:18.884294	14026	49	2	1
2014-03-25 23:32:32.704908	14027	354	3	2
2014-03-26 21:42:35.051808	31459	22.3	1	9
2014-03-26 21:42:35.275133	31460	48	2	9
2014-03-25 23:32:42.172869	14032	20.9	1	8
2014-03-25 23:32:42.396973	14033	53	2	8
2014-03-25 23:32:57.4638	14034	19.4	1	1
2014-03-25 23:32:57.693643	14035	49	2	1
2014-03-26 21:42:36.13386	31461	22.3	1	8
2014-03-26 21:42:36.367298	31462	47	2	8
2014-03-25 23:33:21.171548	14040	20.9	1	8
2014-03-25 23:33:21.395706	14041	53	2	8
2014-03-25 23:33:32.703625	14042	354	3	2
2014-03-25 23:33:36.465968	14043	19.4	1	1
2014-03-25 23:33:36.688228	14044	49	2	1
2014-03-26 21:42:44.562648	31463	482	3	2
2014-03-26 21:42:44.78973	31464	1088138.6934089223	4	2
2014-03-25 23:34:00.171807	14049	21.0	1	8
2014-03-25 23:34:00.403461	14050	53	2	8
2014-03-25 23:34:15.464446	14051	19.4	1	1
2014-03-25 23:34:15.687063	14052	49	2	1
2014-03-25 23:34:32.705779	14053	354	3	2
2014-03-26 21:42:50.704327	31465	20.4	1	1
2014-03-26 21:42:50.939051	31466	50	2	1
2014-03-25 23:34:39.17209	14058	21.0	1	8
2014-03-25 23:34:39.412101	14059	53	2	8
2014-03-25 23:34:54.46237	14060	19.4	1	1
2014-03-25 23:34:54.695454	14061	49	2	1
2014-03-26 21:42:56.564984	31467	466	3	2
2014-03-26 21:42:56.787883	31468	1088139.8424436436	4	2
2014-03-25 23:35:18.171743	14066	21.0	1	8
2014-03-25 23:35:18.392114	14067	53	2	8
2014-03-25 23:35:32.700444	14068	354	3	2
2014-03-25 23:35:33.463533	14069	19.4	1	1
2014-03-25 23:35:33.68465	14070	49	2	1
2014-03-26 21:43:03.699071	31469	24.1	1	10
2014-03-26 21:43:03.936347	31470	41	2	10
2014-03-25 23:35:56.702299	14075	289	3	2
2014-03-25 23:35:57.172155	14076	21.0	1	8
2014-03-25 23:35:57.393308	14077	53	2	8
2014-03-25 23:36:08.704214	14078	305	3	2
2014-03-25 23:36:12.460031	14079	19.4	1	1
2014-03-25 23:36:12.679743	14080	49	2	1
2014-03-25 23:36:32.701282	14081	305	3	2
2014-03-26 21:43:14.259689	31471	22.3	1	9
2014-03-26 21:43:14.484413	31472	48	2	9
2014-03-25 23:36:36.171967	14086	21.0	1	8
2014-03-25 23:36:36.404682	14087	53	2	8
2014-03-25 23:36:51.460437	14088	19.4	1	1
2014-03-25 23:36:51.681536	14089	49	2	1
2014-03-26 21:43:15.137139	31473	22.3	1	8
2014-03-26 21:43:15.368673	31474	47	2	8
2014-03-25 23:37:15.172795	14094	21.0	1	8
2014-03-25 23:37:15.404371	14095	53	2	8
2014-03-25 23:37:30.591133	14096	19.4	1	1
2014-03-25 23:37:31.010049	14097	49	2	1
2014-03-25 23:37:32.828736	14098	289	3	2
2014-03-26 21:43:29.703763	31475	20.4	1	1
2014-03-26 21:43:29.926995	31476	50	2	1
2014-03-25 23:37:54.171814	14103	21.0	1	8
2014-03-25 23:37:54.395592	14104	53	2	8
2014-03-25 23:38:09.460322	14105	19.4	1	1
2014-03-25 23:38:09.68248	14106	49	2	1
2014-03-26 21:43:32.562347	31477	450	3	2
2014-03-26 21:43:32.794866	31478	1088144.4385825293	4	2
2014-03-25 23:38:32.700678	14111	305	3	2
2014-03-25 23:38:33.172179	14112	21.0	1	8
2014-03-25 23:38:33.396009	14113	53	2	8
2014-03-25 23:38:48.467577	14114	19.4	1	1
2014-03-25 23:38:48.688888	14115	49	2	1
2014-03-26 21:43:42.700249	31479	24.1	1	10
2014-03-26 21:43:42.925355	31480	41	2	10
2014-03-25 23:39:12.171449	14120	21.0	1	8
2014-03-25 23:39:12.400936	14121	53	2	8
2014-03-25 23:39:27.472831	14122	19.4	1	1
2014-03-25 23:39:27.6961	14123	49	2	1
2014-03-25 23:39:32.701698	14124	305	3	2
2014-03-26 21:43:44.564702	31481	482	3	2
2014-03-26 21:43:44.797434	31482	1088145.5876172506	4	2
2014-03-25 23:39:51.171895	14129	21.0	1	8
2014-03-25 23:39:51.39338	14130	53	2	8
2014-03-25 23:40:06.454248	14131	19.4	1	1
2014-03-25 23:40:06.684594	14132	49	2	1
2014-03-26 21:43:53.047098	31483	22.3	1	9
2014-03-26 21:43:53.273179	31484	48	2	9
2014-03-26 21:43:54.136748	31485	22.3	1	8
2014-03-25 23:40:30.172483	14137	21.0	1	8
2014-03-25 23:40:30.39454	14138	53	2	8
2014-03-25 23:40:45.262019	14139	305	3	2
2014-03-25 23:40:45.578809	14140	19.4	1	1
2014-03-25 23:40:45.803216	14141	49	2	1
2014-03-25 23:31:22.018297	14009	23.3	1	10
2014-03-25 23:31:22.243267	14010	48	2	10
2014-03-25 23:32:01.022173	14019	23.2	1	10
2014-03-25 23:32:01.24657	14020	48	2	10
2014-03-25 23:32:40.02394	14028	23.2	1	10
2014-03-25 23:32:40.251927	14029	48	2	10
2014-03-25 23:33:19.017754	14036	23.2	1	10
2014-03-25 23:33:19.240443	14037	48	2	10
2014-03-25 23:33:58.017443	14045	23.2	1	10
2014-03-25 23:33:58.248963	14046	48	2	10
2014-03-25 23:34:37.017366	14054	23.2	1	10
2014-03-25 23:34:37.238195	14055	48	2	10
2014-03-25 23:35:16.0177	14062	23.2	1	10
2014-03-25 23:35:16.239248	14063	48	2	10
2014-03-25 23:35:55.017384	14071	23.2	1	10
2014-03-25 23:35:55.247675	14072	48	2	10
2014-03-25 23:36:34.019836	14082	23.2	1	10
2014-03-25 23:36:34.251502	14083	48	2	10
2014-03-25 23:37:13.019185	14090	23.2	1	10
2014-03-25 23:37:13.25411	14091	48	2	10
2014-03-25 23:37:52.019599	14099	23.2	1	10
2014-03-25 23:37:52.245003	14100	48	2	10
2014-03-25 23:38:31.02022	14107	23.2	1	10
2014-03-25 23:38:31.242273	14108	48	2	10
2014-03-25 23:39:10.019227	14116	23.1	1	10
2014-03-25 23:39:10.249015	14117	48	2	10
2014-03-25 23:39:49.018673	14125	23.1	1	10
2014-03-25 23:39:49.241309	14126	48	2	10
2014-03-25 23:40:28.019591	14133	23.1	1	10
2014-03-26 21:43:54.372168	31486	47	2	8
2014-03-25 23:41:09.171977	14146	21.0	1	8
2014-03-25 23:41:09.402561	14147	53	2	8
2014-03-25 23:41:24.460535	14148	19.4	1	1
2014-03-25 23:41:24.683019	14149	49	2	1
2014-03-25 23:41:32.699106	14150	289	3	2
2014-03-26 21:43:56.565073	31487	434	3	2
2014-03-26 21:43:56.788668	31488	1088147.8856866935	4	2
2014-03-25 23:41:48.171513	14155	21.0	1	8
2014-03-25 23:41:48.392553	14156	53	2	8
2014-03-25 23:42:03.457759	14157	19.4	1	1
2014-03-25 23:42:03.70214	14158	49	2	1
2014-03-26 21:44:08.942294	31489	20.4	1	1
2014-03-26 21:44:09.176432	31490	50	2	1
2014-03-25 23:42:27.173046	14163	21.0	1	8
2014-03-25 23:42:27.431415	14164	53	2	8
2014-03-25 23:42:32.701623	14165	289	3	2
2014-03-25 23:42:42.499441	14166	19.4	1	1
2014-03-25 23:42:42.724221	14167	49	2	1
2014-03-26 21:44:20.562105	31491	466	3	2
2014-03-26 21:44:20.787216	31492	1088151.3327908579	4	2
2014-03-25 23:43:06.173651	14172	21.0	1	8
2014-03-25 23:43:06.403943	14173	52	2	8
2014-03-25 23:43:21.460023	14174	19.4	1	1
2014-03-25 23:43:21.68268	14175	49	2	1
2014-03-25 23:43:42.820908	14176	289	3	2
2014-03-26 21:44:21.699093	31493	24.1	1	10
2014-03-26 21:44:21.934687	31494	41	2	10
2014-03-25 23:43:44.700316	14181	354	3	2
2014-03-25 23:43:45.172519	14182	21.0	1	8
2014-03-25 23:43:45.394718	14183	52	2	8
2014-03-25 23:43:56.699408	14184	354	3	2
2014-03-25 23:44:00.457444	14185	19.4	1	1
2014-03-25 23:44:00.678731	14186	49	2	1
2014-03-26 21:44:32.047875	31495	22.2	1	9
2014-03-26 21:44:32.273019	31496	48	2	9
2014-03-25 23:44:24.171376	14191	21.0	1	8
2014-03-25 23:44:24.403141	14192	52	2	8
2014-03-25 23:44:32.703552	14193	354	3	2
2014-03-25 23:44:39.457872	14194	19.4	1	1
2014-03-25 23:44:39.68357	14195	49	2	1
2014-03-26 21:44:32.582033	31497	466	3	2
2014-03-26 21:44:32.815728	31498	1088152.4818255792	4	2
2014-03-25 23:45:03.172321	14200	21.0	1	8
2014-03-25 23:45:03.392713	14201	52	2	8
2014-03-25 23:45:18.45524	14202	19.4	1	1
2014-03-25 23:45:18.698966	14203	49	2	1
2014-03-25 23:45:32.702928	14204	354	3	2
2014-03-26 21:44:33.138667	31499	22.3	1	8
2014-03-26 21:44:33.36599	31500	47	2	8
2014-03-25 23:45:42.171788	14209	21.0	1	8
2014-03-25 23:45:42.393135	14210	52	2	8
2014-03-25 23:45:57.454617	14211	19.4	1	1
2014-03-25 23:45:57.67798	14212	49	2	1
2014-03-26 21:44:47.701745	31501	20.4	1	1
2014-03-26 21:44:47.936195	31502	50	2	1
2014-03-25 23:46:21.171726	14217	21.0	1	8
2014-03-25 23:46:21.393462	14218	52	2	8
2014-03-25 23:46:32.703788	14219	354	3	2
2014-03-25 23:46:36.45736	14220	19.4	1	1
2014-03-25 23:46:36.679265	14221	49	2	1
2014-03-26 21:45:00.700042	31503	24.1	1	10
2014-03-26 21:45:00.927033	31504	41	2	10
2014-03-25 23:47:00.170376	14226	21.0	1	8
2014-03-25 23:47:00.403015	14227	52	2	8
2014-03-25 23:47:08.701365	14228	418	3	2
2014-03-25 23:47:15.458708	14229	19.4	1	1
2014-03-25 23:47:15.680489	14230	49	2	1
2014-03-25 23:47:32.558703	14231	418	3	2
2014-03-25 23:47:32.871077	14232	418	3	2
2014-03-26 21:45:11.04769	31505	22.2	1	9
2014-03-26 21:45:11.294878	31506	48	2	9
2014-03-25 23:47:39.300005	14237	21.0	1	8
2014-03-25 23:47:39.740048	14238	52	2	8
2014-03-25 23:47:54.456042	14239	19.4	1	1
2014-03-25 23:47:54.677338	14240	49	2	1
2014-03-25 23:47:56.700891	14241	354	3	2
2014-03-25 23:48:08.698968	14242	370	3	2
2014-03-26 21:45:12.134806	31507	22.3	1	8
2014-03-26 21:45:12.360939	31508	47	2	8
2014-03-25 23:48:18.172312	14247	21.0	1	8
2014-03-25 23:48:18.393639	14248	52	2	8
2014-03-25 23:48:32.70279	14249	370	3	2
2014-03-25 23:48:33.453145	14250	19.4	1	1
2014-03-25 23:48:33.674339	14251	49	2	1
2014-03-26 21:45:26.702067	31509	20.4	1	1
2014-03-26 21:45:26.936752	31510	50	2	1
2014-03-25 23:48:57.171297	14256	21.0	1	8
2014-03-25 23:48:57.394247	14257	52	2	8
2014-03-25 23:49:12.693027	14258	19.4	1	1
2014-03-25 23:49:12.922808	14259	49	2	1
2014-03-25 23:49:32.70054	14260	370	3	2
2014-03-26 21:45:32.564675	31511	466	3	2
2014-03-26 21:45:32.788648	31512	1088160.525068629	4	2
2014-03-25 23:49:36.171101	14265	21.0	1	8
2014-03-25 23:49:36.403409	14266	52	2	8
2014-03-25 23:49:51.455818	14267	19.4	1	1
2014-03-25 23:49:51.677153	14268	49	2	1
2014-03-26 21:45:39.699843	31513	24.1	1	10
2014-03-26 21:45:39.934466	31514	41	2	10
2014-03-25 23:50:15.171684	14273	21.0	1	8
2014-03-25 23:50:15.403614	14274	52	2	8
2014-03-25 23:50:30.454379	14275	19.3	1	1
2014-03-25 23:50:30.678022	14276	49	2	1
2014-03-25 23:50:32.702801	14277	370	3	2
2014-03-25 23:41:46.020845	14151	23.1	1	10
2014-03-25 23:41:46.24317	14152	48	2	10
2014-03-25 23:42:25.020308	14159	23.1	1	10
2014-03-25 23:42:25.244369	14160	48	2	10
2014-03-25 23:43:04.018295	14168	23.1	1	10
2014-03-25 23:43:04.25104	14169	48	2	10
2014-03-25 23:43:43.135542	14177	23.1	1	10
2014-03-25 23:43:43.360342	14178	48	2	10
2014-03-25 23:44:22.019383	14187	23.1	1	10
2014-03-25 23:44:22.251658	14188	48	2	10
2014-03-25 23:45:01.019713	14196	23.1	1	10
2014-03-25 23:45:01.241571	14197	48	2	10
2014-03-25 23:45:40.019848	14205	23.1	1	10
2014-03-25 23:45:40.241854	14206	48	2	10
2014-03-25 23:46:19.021576	14213	23.1	1	10
2014-03-25 23:46:19.244248	14214	48	2	10
2014-03-25 23:46:58.022765	14222	23.0	1	10
2014-03-25 23:46:58.254732	14223	48	2	10
2014-03-25 23:47:37.023179	14233	23.0	1	10
2014-03-25 23:47:37.430088	14234	48	2	10
2014-03-25 23:48:16.022435	14243	23.0	1	10
2014-03-25 23:48:16.246433	14244	48	2	10
2014-03-25 23:48:55.021234	14252	23.0	1	10
2014-03-25 23:48:55.243113	14253	48	2	10
2014-03-25 23:49:34.021804	14261	23.0	1	10
2014-03-25 23:49:34.245625	14262	48	2	10
2014-03-25 23:50:13.0221	14269	23.0	1	10
2014-03-25 23:50:13.253008	14270	48	2	10
2014-03-26 21:45:50.047079	31515	22.2	1	9
2014-03-25 23:50:54.172482	14282	21.0	1	8
2014-03-25 23:50:54.393122	14283	52	2	8
2014-03-25 23:51:09.451841	14284	19.3	1	1
2014-03-25 23:51:09.686368	14285	49	2	1
2014-03-26 21:45:50.272368	31516	48	2	9
2014-03-26 21:45:51.135388	31517	22.2	1	8
2014-03-25 23:51:32.700846	14290	370	3	2
2014-03-25 23:51:33.172005	14291	21.0	1	8
2014-03-25 23:51:33.394352	14292	52	2	8
2014-03-25 23:51:48.458303	14293	19.3	1	1
2014-03-25 23:51:48.680782	14294	49	2	1
2014-03-26 21:45:51.368641	31518	47	2	8
2014-03-26 21:46:05.705146	31519	20.4	1	1
2014-03-25 23:52:12.171958	14299	21.0	1	8
2014-03-25 23:52:12.401819	14300	52	2	8
2014-03-25 23:52:27.452184	14301	19.3	1	1
2014-03-25 23:52:27.674058	14302	49	2	1
2014-03-25 23:52:32.700952	14303	370	3	2
2014-03-26 21:46:05.929386	31520	50	2	1
2014-03-26 21:46:08.563376	31521	434	3	2
2014-03-25 23:52:51.172129	14308	21.0	1	8
2014-03-25 23:52:51.393563	14309	52	2	8
2014-03-25 23:53:06.450986	14310	19.3	1	1
2014-03-25 23:53:06.673302	14311	49	2	1
2014-03-26 21:46:08.799785	31522	1088165.1212075148	4	2
2014-03-26 21:46:18.702314	31523	24.1	1	10
2014-03-25 23:53:30.172738	14316	21.0	1	8
2014-03-25 23:53:30.396671	14317	52	2	8
2014-03-25 23:53:32.699838	14318	370	3	2
2014-03-25 23:53:45.452797	14319	19.3	1	1
2014-03-25 23:53:45.68686	14320	49	2	1
2014-03-26 21:46:18.926028	31524	41	2	10
2014-03-26 21:46:20.562909	31525	466	3	2
2014-03-25 23:54:09.17055	14325	21.0	1	8
2014-03-25 23:54:09.393737	14326	52	2	8
2014-03-25 23:54:24.45028	14327	19.3	1	1
2014-03-25 23:54:24.684065	14328	49	2	1
2014-03-25 23:54:32.700129	14329	354	3	2
2014-03-26 21:46:20.797689	31526	1088166.2702422363	4	2
2014-03-26 21:46:29.046683	31527	22.2	1	9
2014-03-25 23:54:48.172533	14334	21.0	1	8
2014-03-25 23:54:48.405256	14335	52	2	8
2014-03-25 23:55:03.452769	14336	19.3	1	1
2014-03-25 23:55:03.674267	14337	49	2	1
2014-03-26 21:46:29.270322	31528	48	2	9
2014-03-26 21:46:30.134406	31529	22.2	1	8
2014-03-25 23:55:27.17156	14342	21.0	1	8
2014-03-25 23:55:27.403392	14343	52	2	8
2014-03-25 23:55:32.69806	14344	354	3	2
2014-03-25 23:55:42.453498	14345	19.3	1	1
2014-03-25 23:55:42.678582	14346	49	2	1
2014-03-25 23:55:56.555063	14347	418	3	2
2014-03-25 23:56:03.8245	14348	418	3	2
2014-03-26 21:46:30.369112	31530	47	2	8
2014-03-26 21:46:32.56601	31531	531	3	2
2014-03-25 23:56:06.171308	14353	20.9	1	8
2014-03-25 23:56:06.403081	14354	53	2	8
2014-03-25 23:56:21.447205	14355	19.3	1	1
2014-03-25 23:56:21.671886	14356	49	2	1
2014-03-25 23:56:32.702895	14357	418	3	2
2014-03-26 21:46:32.792446	31532	1088168.568311679	4	2
2014-03-26 21:46:44.942419	31533	20.4	1	1
2014-03-25 23:56:45.172014	14362	21.0	1	8
2014-03-25 23:56:45.393374	14363	52	2	8
2014-03-25 23:57:00.451682	14364	19.3	1	1
2014-03-25 23:57:00.675362	14365	49	2	1
2014-03-26 21:46:45.176701	31534	50	2	1
2014-03-26 21:46:57.699533	31535	24.1	1	10
2014-03-25 23:57:24.171849	14370	20.9	1	8
2014-03-25 23:57:24.394381	14371	53	2	8
2014-03-25 23:57:32.70011	14372	418	3	2
2014-03-25 23:57:39.452736	14373	19.3	1	1
2014-03-25 23:57:39.677357	14374	49	2	1
2014-03-26 21:46:57.927259	31536	41	2	10
2014-03-26 21:47:08.259774	31537	22.2	1	9
2014-03-25 23:58:03.300015	14379	20.9	1	8
2014-03-25 23:58:03.759775	14380	53	2	8
2014-03-25 23:58:18.45231	14381	19.3	1	1
2014-03-25 23:58:18.674148	14382	49	2	1
2014-03-25 23:58:32.696919	14383	418	3	2
2014-03-26 21:47:08.49692	31538	48	2	9
2014-03-26 21:47:09.135843	31539	22.2	1	8
2014-03-25 23:58:42.172579	14388	20.9	1	8
2014-03-25 23:58:42.394993	14389	53	2	8
2014-03-25 23:58:57.691392	14390	19.3	1	1
2014-03-25 23:58:57.91364	14391	49	2	1
2014-03-26 21:47:09.359349	31540	47	2	8
2014-03-26 21:47:23.703521	31541	20.4	1	1
2014-03-25 23:59:21.17054	14396	20.9	1	8
2014-03-25 23:59:21.395031	14397	53	2	8
2014-03-25 23:59:32.700384	14398	418	3	2
2014-03-25 23:59:36.452342	14399	19.3	1	1
2014-03-25 23:59:36.686478	14400	49	2	1
2014-03-25 23:59:56.696372	14401	354	3	2
2014-03-26 21:47:23.937582	31542	50	2	1
2014-03-26 21:47:32.56323	31543	531	3	2
2014-03-26 00:00:00.171135	14406	20.9	1	8
2014-03-26 00:00:00.404671	14407	53	2	8
2014-03-26 00:00:08.701159	14408	354	3	2
2014-03-26 00:00:15.453482	14409	19.3	1	1
2014-03-26 00:00:15.675886	14410	49	2	1
2014-03-26 00:00:32.698579	14411	354	3	2
2014-03-26 00:00:39.172419	14416	20.9	1	8
2014-03-25 23:51:31.022889	14286	23.0	1	10
2014-03-25 23:51:31.244654	14287	48	2	10
2014-03-25 23:52:10.022247	14295	23.0	1	10
2014-03-25 23:52:10.246924	14296	48	2	10
2014-03-25 23:52:49.024307	14304	23.0	1	10
2014-03-25 23:52:49.248732	14305	48	2	10
2014-03-25 23:53:28.023043	14312	23.0	1	10
2014-03-25 23:53:28.24793	14313	48	2	10
2014-03-25 23:54:07.023243	14321	23.0	1	10
2014-03-25 23:54:07.247558	14322	48	2	10
2014-03-25 23:54:46.024872	14330	23.0	1	10
2014-03-25 23:54:46.246228	14331	48	2	10
2014-03-25 23:55:25.024523	14338	22.9	1	10
2014-03-25 23:55:25.268304	14339	48	2	10
2014-03-25 23:56:04.132059	14349	22.9	1	10
2014-03-25 23:56:04.366212	14350	48	2	10
2014-03-25 23:56:43.024401	14358	22.9	1	10
2014-03-25 23:56:43.255706	14359	48	2	10
2014-03-25 23:57:22.232098	14366	22.9	1	10
2014-03-25 23:57:22.455171	14367	48	2	10
2014-03-25 23:58:01.156179	14375	22.9	1	10
2014-03-25 23:58:01.579998	14376	48	2	10
2014-03-25 23:58:40.025829	14384	22.9	1	10
2014-03-25 23:58:40.249187	14385	48	2	10
2014-03-25 23:59:19.024965	14392	22.9	1	10
2014-03-25 23:59:19.250343	14393	48	2	10
2014-03-25 23:59:58.025988	14402	22.9	1	10
2014-03-25 23:59:58.246371	14403	48	2	10
2014-03-26 00:00:37.025743	14412	22.9	1	10
2014-03-26 00:00:39.393189	14417	53	2	8
2014-03-26 00:00:54.447725	14418	19.3	1	1
2014-03-26 00:00:54.684053	14419	49	2	1
2014-03-26 21:47:32.787741	31544	1088176.611554729	4	2
2014-03-26 21:47:36.701066	31545	24.1	1	10
2014-03-26 00:01:18.172498	14424	20.9	1	8
2014-03-26 00:01:18.394991	14425	53	2	8
2014-03-26 00:01:32.701468	14426	354	3	2
2014-03-26 00:01:33.447757	14427	19.3	1	1
2014-03-26 00:01:33.678592	14428	49	2	1
2014-03-26 21:47:36.937221	31546	41	2	10
2014-03-26 21:47:47.26148	31547	22.2	1	9
2014-03-26 00:01:56.701392	14433	289	3	2
2014-03-26 00:01:57.171471	14434	20.9	1	8
2014-03-26 00:01:57.395853	14435	53	2	8
2014-03-26 00:02:08.699118	14436	305	3	2
2014-03-26 00:02:12.447471	14437	19.3	1	1
2014-03-26 00:02:12.680213	14438	49	2	1
2014-03-26 00:02:32.699816	14439	289	3	2
2014-03-26 21:47:47.488897	31548	48	2	9
2014-03-26 21:47:48.135553	31549	22.2	1	8
2014-03-26 00:02:36.172229	14444	20.9	1	8
2014-03-26 00:02:36.405664	14445	53	2	8
2014-03-26 00:02:51.445906	14446	19.3	1	1
2014-03-26 00:02:51.67015	14447	49	2	1
2014-03-26 21:47:48.3717	31550	47	2	8
2014-03-26 21:47:56.562086	31551	466	3	2
2014-03-26 00:03:15.170562	14452	20.9	1	8
2014-03-26 00:03:15.401946	14453	53	2	8
2014-03-26 00:03:30.446601	14454	19.3	1	1
2014-03-26 00:03:30.66919	14455	49	2	1
2014-03-26 00:03:32.701975	14456	305	3	2
2014-03-26 21:47:56.787191	31552	1088180.0586588932	4	2
2014-03-26 21:48:02.70221	31553	20.4	1	1
2014-03-26 00:03:54.172303	14461	20.9	1	8
2014-03-26 00:03:54.394434	14462	53	2	8
2014-03-26 00:04:09.446395	14463	19.3	1	1
2014-03-26 00:04:09.679384	14464	49	2	1
2014-03-26 21:48:02.948255	31554	50	2	1
2014-03-26 21:48:08.559197	31555	515	3	2
2014-03-26 00:04:32.702867	14469	305	3	2
2014-03-26 00:04:33.174045	14470	20.9	1	8
2014-03-26 00:04:33.402501	14471	53	2	8
2014-03-26 00:04:48.446953	14472	19.3	1	1
2014-03-26 00:04:48.669165	14473	49	2	1
2014-03-26 21:48:08.784217	31556	1088182.356728336	4	2
2014-03-26 21:48:15.70066	31557	24.1	1	10
2014-03-26 00:05:12.174507	14478	20.9	1	8
2014-03-26 00:05:12.406885	14479	53	2	8
2014-03-26 00:05:27.445376	14480	19.3	1	1
2014-03-26 00:05:27.667943	14481	49	2	1
2014-03-26 00:05:32.698931	14482	305	3	2
2014-03-26 21:48:15.934641	31558	41	2	10
2014-03-26 21:48:20.564598	31559	515	3	2
2014-03-26 00:05:51.170913	14487	20.9	1	8
2014-03-26 00:05:51.393821	14488	53	2	8
2014-03-26 00:06:06.446513	14489	19.3	1	1
2014-03-26 00:06:06.679312	14490	49	2	1
2014-03-26 21:48:20.789755	31560	1088183.5057630574	4	2
2014-03-26 21:48:26.047465	31561	22.2	1	9
2014-03-26 00:06:30.171205	14495	20.9	1	8
2014-03-26 00:06:30.392665	14496	53	2	8
2014-03-26 00:06:32.696974	14497	289	3	2
2014-03-26 00:06:45.445742	14498	19.3	1	1
2014-03-26 00:06:45.669207	14499	49	2	1
2014-03-26 21:48:26.287016	31562	48	2	9
2014-03-26 21:48:27.136474	31563	22.2	1	8
2014-03-26 00:07:09.17105	14504	20.9	1	8
2014-03-26 00:07:09.403088	14505	53	2	8
2014-03-26 00:07:24.445925	14506	19.3	1	1
2014-03-26 00:07:24.66769	14507	49	2	1
2014-03-26 00:07:32.694182	14508	354	3	2
2014-03-26 00:07:44.698423	14509	354	3	2
2014-03-26 21:48:27.359783	31564	47	2	8
2014-03-26 21:48:32.564513	31565	515	3	2
2014-03-26 00:07:48.170712	14514	20.9	1	8
2014-03-26 00:07:48.394064	14515	53	2	8
2014-03-26 00:08:03.445345	14516	19.3	1	1
2014-03-26 00:08:03.67898	14517	49	2	1
2014-03-26 21:48:32.799785	31566	1088185.8038325002	4	2
2014-03-26 21:48:41.697521	31567	20.4	1	1
2014-03-26 00:08:27.171497	14522	20.9	1	8
2014-03-26 00:08:27.393254	14523	53	2	8
2014-03-26 00:08:32.694384	14524	354	3	2
2014-03-26 00:08:42.445953	14525	19.3	1	1
2014-03-26 00:08:42.668255	14526	49	2	1
2014-03-26 21:48:41.922855	31568	50	2	1
2014-03-26 21:48:44.563976	31569	2382	3	2
2014-03-26 00:09:06.502124	14531	20.9	1	8
2014-03-26 00:09:06.737156	14532	53	2	8
2014-03-26 00:09:21.44739	14533	19.3	1	1
2014-03-26 00:09:21.669987	14534	49	2	1
2014-03-26 00:09:32.701906	14535	354	3	2
2014-03-26 21:48:44.798816	31570	1088188.101901943	4	2
2014-03-26 21:48:54.700036	31571	24.1	1	10
2014-03-26 00:09:45.172402	14540	20.9	1	8
2014-03-26 00:09:45.397482	14541	53	2	8
2014-03-26 00:10:00.442984	14542	19.3	1	1
2014-03-26 00:10:00.67521	14543	49	2	1
2014-03-26 21:48:54.925388	31572	41	2	10
2014-03-26 00:10:24.172836	14548	20.9	1	8
2014-03-26 00:10:24.396146	14549	53	2	8
2014-03-26 00:10:32.7006	14550	354	3	2
2014-03-26 00:10:39.440332	14551	19.3	1	1
2014-03-26 00:10:39.663757	14552	49	2	1
2014-03-26 00:01:16.025248	14420	22.9	1	10
2014-03-26 00:01:16.246973	14421	48	2	10
2014-03-26 00:01:55.026168	14429	22.9	1	10
2014-03-26 00:01:55.249059	14430	48	2	10
2014-03-26 00:02:34.030967	14440	22.9	1	10
2014-03-26 00:02:34.253701	14441	48	2	10
2014-03-26 00:03:13.029816	14448	22.9	1	10
2014-03-26 00:03:13.260727	14449	48	2	10
2014-03-26 00:03:52.02688	14457	22.8	1	10
2014-03-26 00:03:52.250713	14458	48	2	10
2014-03-26 00:04:31.025899	14465	22.8	1	10
2014-03-26 00:04:31.251716	14466	48	2	10
2014-03-26 00:05:10.028318	14474	22.8	1	10
2014-03-26 00:05:10.250769	14475	48	2	10
2014-03-26 00:05:49.026883	14483	22.8	1	10
2014-03-26 00:05:49.256739	14484	48	2	10
2014-03-26 00:06:28.027437	14491	22.8	1	10
2014-03-26 00:06:28.303448	14492	48	2	10
2014-03-26 00:07:07.028067	14500	22.8	1	10
2014-03-26 00:07:07.259161	14501	48	2	10
2014-03-26 00:07:46.028285	14510	22.8	1	10
2014-03-26 00:07:46.250947	14511	48	2	10
2014-03-26 00:08:25.030633	14518	22.8	1	10
2014-03-26 00:08:25.253241	14519	48	2	10
2014-03-26 00:09:04.030612	14527	22.8	1	10
2014-03-26 00:09:04.263264	14528	48	2	10
2014-03-26 00:09:43.030278	14536	22.8	1	10
2014-03-26 00:09:43.253849	14537	48	2	10
2014-03-26 21:48:56.564111	31573	611	3	2
2014-03-26 21:48:56.799314	31574	1088190.399971386	4	2
2014-03-26 00:11:03.171887	14557	20.9	1	8
2014-03-26 00:11:03.396434	14558	53	2	8
2014-03-26 00:11:18.442058	14559	19.3	1	1
2014-03-26 00:11:18.664315	14560	49	2	1
2014-03-26 00:11:32.698823	14561	354	3	2
2014-03-26 21:49:05.048815	31575	22.2	1	9
2014-03-26 21:49:05.2752	31576	48	2	9
2014-03-26 00:11:42.170885	14566	20.9	1	8
2014-03-26 00:11:42.392372	14567	53	2	8
2014-03-26 00:11:57.442274	14568	19.3	1	1
2014-03-26 00:11:57.666688	14569	49	2	1
2014-03-26 00:12:08.70169	14570	289	3	2
2014-03-26 21:49:06.135635	31577	22.2	1	8
2014-03-26 21:49:06.371587	31578	47	2	8
2014-03-26 00:12:20.699597	14575	289	3	2
2014-03-26 00:12:21.170546	14576	20.9	1	8
2014-03-26 00:12:21.405206	14577	53	2	8
2014-03-26 00:12:32.698098	14578	289	3	2
2014-03-26 00:12:36.441537	14579	19.2	1	1
2014-03-26 00:12:36.664626	14580	49	2	1
2014-03-26 21:49:08.564018	31579	579	3	2
2014-03-26 21:49:08.788659	31580	1088192.6980408288	4	2
2014-03-26 00:13:00.169828	14585	20.9	1	8
2014-03-26 00:13:00.392294	14586	53	2	8
2014-03-26 00:13:15.439809	14587	19.2	1	1
2014-03-26 00:13:15.661633	14588	49	2	1
2014-03-26 00:13:32.695677	14589	289	3	2
2014-03-26 21:49:20.938017	31581	20.4	1	1
2014-03-26 21:49:21.172203	31582	50	2	1
2014-03-26 00:13:39.171481	14594	20.9	1	8
2014-03-26 00:13:39.401735	14595	53	2	8
2014-03-26 00:13:54.439102	14596	19.2	1	1
2014-03-26 00:13:54.662121	14597	49	2	1
2014-03-26 21:49:32.563493	31583	611	3	2
2014-03-26 21:49:32.790668	31584	1088197.2941797145	4	2
2014-03-26 00:14:18.17227	14602	20.9	1	8
2014-03-26 00:14:18.40501	14603	53	2	8
2014-03-26 00:14:32.695461	14604	289	3	2
2014-03-26 00:14:33.436841	14605	19.2	1	1
2014-03-26 00:14:33.664334	14606	49	2	1
2014-03-26 21:49:33.700381	31585	24.1	1	10
2014-03-26 21:49:33.934438	31586	41	2	10
2014-03-26 00:14:57.17266	14611	20.9	1	8
2014-03-26 00:14:57.451096	14612	53	2	8
2014-03-26 00:15:12.442313	14613	19.2	1	1
2014-03-26 00:15:12.673997	14614	49	2	1
2014-03-26 00:15:32.696589	14615	305	3	2
2014-03-26 21:49:44.260969	31587	22.2	1	9
2014-03-26 21:49:44.48668	31588	48	2	9
2014-03-26 00:15:36.172197	14620	20.9	1	8
2014-03-26 00:15:36.40529	14621	53	2	8
2014-03-26 00:15:51.440526	14622	19.2	1	1
2014-03-26 00:15:51.66448	14623	49	2	1
2014-03-26 21:49:45.135	31589	22.2	1	8
2014-03-26 21:49:45.369435	31590	47	2	8
2014-03-26 00:16:15.170405	14628	20.9	1	8
2014-03-26 00:16:15.403269	14629	53	2	8
2014-03-26 00:16:30.442729	14630	19.2	1	1
2014-03-26 00:16:30.667665	14631	49	2	1
2014-03-26 00:16:32.696901	14632	289	3	2
2014-03-26 21:49:59.699857	31591	20.4	1	1
2014-03-26 21:49:59.925477	31592	50	2	1
2014-03-26 00:16:54.171348	14637	20.9	1	8
2014-03-26 00:16:54.393336	14638	53	2	8
2014-03-26 00:17:09.439575	14639	19.2	1	1
2014-03-26 00:17:09.675114	14640	49	2	1
2014-03-26 21:50:12.701842	31593	24.1	1	10
2014-03-26 21:50:12.936312	31594	41	2	10
2014-03-26 00:17:32.969836	14645	305	3	2
2014-03-26 00:17:33.276589	14646	20.9	1	8
2014-03-26 00:17:33.497883	14647	53	2	8
2014-03-26 00:17:48.440629	14648	19.2	1	1
2014-03-26 00:17:48.667481	14649	49	2	1
2014-03-26 21:50:23.046378	31595	22.2	1	9
2014-03-26 21:50:23.271404	31596	48	2	9
2014-03-26 00:18:12.171455	14654	20.9	1	8
2014-03-26 00:18:12.414615	14655	53	2	8
2014-03-26 00:18:27.562091	14656	19.2	1	1
2014-03-26 00:18:27.998958	14657	49	2	1
2014-03-26 00:18:32.823478	14658	289	3	2
2014-03-26 21:50:24.136712	31597	22.2	1	8
2014-03-26 21:50:24.377187	31598	47	2	8
2014-03-26 00:18:51.170783	14663	20.9	1	8
2014-03-26 00:18:51.392512	14664	53	2	8
2014-03-26 00:19:06.433563	14665	19.2	1	1
2014-03-26 00:19:06.666643	14666	49	2	1
2014-03-26 21:50:32.563601	31599	611	3	2
2014-03-26 21:50:32.790112	31600	1088206.4864574857	4	2
2014-03-26 00:19:30.170491	14671	20.9	1	8
2014-03-26 00:19:30.392314	14672	52	2	8
2014-03-26 00:19:32.694506	14673	289	3	2
2014-03-26 00:19:45.438761	14674	19.2	1	1
2014-03-26 00:19:45.663291	14675	49	2	1
2014-03-26 00:19:56.699195	14676	338	3	2
2014-03-26 21:50:38.699937	31601	20.4	1	1
2014-03-26 21:50:38.945191	31602	50	2	1
2014-03-26 21:50:51.70053	31603	24.1	1	10
2014-03-26 00:20:08.697335	14681	338	3	2
2014-03-26 00:20:09.172798	14682	20.9	1	8
2014-03-26 00:20:09.397386	14683	52	2	8
2014-03-26 00:20:24.437473	14684	19.2	1	1
2014-03-26 00:20:24.660287	14685	49	2	1
2014-03-26 00:20:32.694675	14686	338	3	2
2014-03-26 00:11:01.029834	14553	22.8	1	10
2014-03-26 00:11:01.253915	14554	48	2	10
2014-03-26 00:11:40.032667	14562	22.8	1	10
2014-03-26 00:11:40.256253	14563	48	2	10
2014-03-26 00:12:19.030015	14571	22.8	1	10
2014-03-26 00:12:19.252875	14572	48	2	10
2014-03-26 00:12:58.029552	14581	22.8	1	10
2014-03-26 00:12:58.270893	14582	48	2	10
2014-03-26 00:13:37.029161	14590	22.7	1	10
2014-03-26 00:13:37.253081	14591	48	2	10
2014-03-26 00:14:16.033111	14598	22.7	1	10
2014-03-26 00:14:16.264816	14599	48	2	10
2014-03-26 00:14:55.030668	14607	22.7	1	10
2014-03-26 00:14:55.255089	14608	48	2	10
2014-03-26 00:15:34.033869	14616	22.7	1	10
2014-03-26 00:15:34.259241	14617	48	2	10
2014-03-26 00:16:13.03072	14624	22.7	1	10
2014-03-26 00:16:13.263943	14625	48	2	10
2014-03-26 00:16:52.0346	14633	22.7	1	10
2014-03-26 00:16:52.258065	14634	48	2	10
2014-03-26 00:17:31.032651	14641	22.7	1	10
2014-03-26 00:17:31.255651	14642	48	2	10
2014-03-26 00:18:10.032026	14650	22.7	1	10
2014-03-26 00:18:10.254936	14651	48	2	10
2014-03-26 00:18:49.030936	14659	22.7	1	10
2014-03-26 00:18:49.253322	14660	48	2	10
2014-03-26 00:19:28.036081	14667	22.7	1	10
2014-03-26 00:19:28.258135	14668	48	2	10
2014-03-26 21:50:51.927033	31604	41	2	10
2014-03-26 21:51:02.048993	31605	22.2	1	9
2014-03-26 00:20:48.170489	14691	20.9	1	8
2014-03-26 00:20:48.427214	14692	52	2	8
2014-03-26 00:21:03.440319	14693	19.2	1	1
2014-03-26 00:21:03.864609	14694	49	2	1
2014-03-26 21:51:02.468555	31606	48	2	9
2014-03-26 21:51:03.13501	31607	22.2	1	8
2014-03-26 00:21:27.171443	14699	20.9	1	8
2014-03-26 00:21:27.418197	14700	52	2	8
2014-03-26 00:21:32.697728	14701	338	3	2
2014-03-26 00:21:42.440652	14702	19.2	1	1
2014-03-26 00:21:42.661527	14703	49	2	1
2014-03-26 21:51:03.364961	31608	47	2	8
2014-03-26 21:51:17.701475	31609	20.3	1	1
2014-03-26 00:22:06.170683	14708	20.9	1	8
2014-03-26 00:22:06.393724	14709	52	2	8
2014-03-26 00:22:21.438047	14710	19.2	1	1
2014-03-26 00:22:21.672552	14711	49	2	1
2014-03-26 00:22:32.693899	14712	338	3	2
2014-03-26 21:51:17.926053	31610	50	2	1
2014-03-26 21:51:30.703592	31611	24.1	1	10
2014-03-26 00:22:45.170833	14717	20.9	1	8
2014-03-26 00:22:45.393299	14718	52	2	8
2014-03-26 00:23:00.437153	14719	19.2	1	1
2014-03-26 00:23:00.661284	14720	49	2	1
2014-03-26 21:51:30.937999	31612	41	2	10
2014-03-26 21:51:32.563121	31613	611	3	2
2014-03-26 00:23:24.170555	14725	20.9	1	8
2014-03-26 00:23:24.393042	14726	52	2	8
2014-03-26 00:23:32.696408	14727	338	3	2
2014-03-26 00:23:39.434817	14728	19.2	1	1
2014-03-26 00:23:39.658271	14729	49	2	1
2014-03-26 21:51:32.789942	31614	1088216.8277699784	4	2
2014-03-26 21:51:41.047656	31615	22.2	1	9
2014-03-26 00:24:03.172967	14734	20.9	1	8
2014-03-26 00:24:03.396636	14735	52	2	8
2014-03-26 00:24:18.434645	14736	19.2	1	1
2014-03-26 00:24:18.66757	14737	49	2	1
2014-03-26 00:24:32.699883	14738	289	3	2
2014-03-26 21:51:41.28126	31616	48	2	9
2014-03-26 21:51:42.1374	31617	22.2	1	8
2014-03-26 00:24:42.173783	14743	20.9	1	8
2014-03-26 00:24:42.416303	14744	52	2	8
2014-03-26 00:24:44.698764	14745	289	3	2
2014-03-26 00:24:57.436477	14746	19.2	1	1
2014-03-26 00:24:57.71332	14747	49	2	1
2014-03-26 21:51:42.36171	31618	47	2	8
2014-03-26 21:51:56.69762	31619	20.3	1	1
2014-03-26 00:25:21.171953	14752	20.9	1	8
2014-03-26 00:25:21.394053	14753	52	2	8
2014-03-26 00:25:32.698187	14754	289	3	2
2014-03-26 00:25:36.43488	14755	19.2	1	1
2014-03-26 00:25:36.657761	14756	49	2	1
2014-03-26 21:51:56.934439	31620	50	2	1
2014-03-26 21:52:09.702243	31621	24.1	1	10
2014-03-26 00:26:00.174038	14761	20.9	1	8
2014-03-26 00:26:00.405325	14762	52	2	8
2014-03-26 00:26:15.432625	14763	19.2	1	1
2014-03-26 00:26:15.654911	14764	49	2	1
2014-03-26 00:26:32.69512	14765	289	3	2
2014-03-26 21:52:09.928287	31622	41	2	10
2014-03-26 21:52:20.046747	31623	22.2	1	9
2014-03-26 00:26:39.172969	14770	20.9	1	8
2014-03-26 00:26:39.395872	14771	52	2	8
2014-03-26 00:26:54.435555	14772	19.2	1	1
2014-03-26 00:26:54.668856	14773	49	2	1
2014-03-26 21:52:20.280174	31624	48	2	9
2014-03-26 21:52:21.135527	31625	22.2	1	8
2014-03-26 00:27:18.172876	14778	20.9	1	8
2014-03-26 00:27:18.396036	14779	52	2	8
2014-03-26 00:27:32.694435	14780	289	3	2
2014-03-26 00:27:33.434434	14781	19.2	1	1
2014-03-26 00:27:33.659211	14782	49	2	1
2014-03-26 21:52:21.35712	31626	47	2	8
2014-03-26 21:52:32.564241	31627	531	3	2
2014-03-26 00:27:57.172467	14787	20.9	1	8
2014-03-26 00:27:57.419389	14788	52	2	8
2014-03-26 00:28:12.43701	14789	19.2	1	1
2014-03-26 00:28:12.663094	14790	49	2	1
2014-03-26 00:28:32.695492	14791	289	3	2
2014-03-26 21:52:32.798091	31628	1088227.1690824712	4	2
2014-03-26 21:52:35.699985	31629	20.3	1	1
2014-03-26 00:28:36.300628	14796	20.9	1	8
2014-03-26 00:28:36.733435	14797	52	2	8
2014-03-26 00:28:51.432488	14798	19.2	1	1
2014-03-26 00:28:51.656043	14799	49	2	1
2014-03-26 21:52:35.927239	31630	50	2	1
2014-03-26 21:52:44.560286	31631	547	3	2
2014-03-26 00:29:15.170949	14804	20.9	1	8
2014-03-26 00:29:15.402892	14805	52	2	8
2014-03-26 00:29:30.43044	14806	19.2	1	1
2014-03-26 00:29:30.653279	14807	49	2	1
2014-03-26 00:29:32.695411	14808	289	3	2
2014-03-26 21:52:44.795203	31632	1088228.3181171927	4	2
2014-03-26 00:29:54.170508	14813	20.9	1	8
2014-03-26 00:29:54.391578	14814	52	2	8
2014-03-26 00:30:09.432629	14815	19.2	1	1
2014-03-26 00:30:09.664008	14816	49	2	1
2014-03-26 00:30:32.695223	14821	289	3	2
2014-03-26 00:30:33.169853	14822	20.9	1	8
2014-03-26 00:30:33.39242	14823	52	2	8
2014-03-26 00:30:48.432927	14824	19.2	1	1
2014-03-26 00:21:25.033586	14695	22.7	1	10
2014-03-26 00:21:25.266738	14696	48	2	10
2014-03-26 00:22:04.240833	14704	22.7	1	10
2014-03-26 00:22:04.466128	14705	48	2	10
2014-03-26 00:22:43.034231	14713	22.7	1	10
2014-03-26 00:22:43.260881	14714	48	2	10
2014-03-26 00:23:22.033449	14721	22.6	1	10
2014-03-26 00:23:22.257048	14722	48	2	10
2014-03-26 00:24:01.034349	14730	22.6	1	10
2014-03-26 00:24:01.257173	14731	48	2	10
2014-03-26 00:24:40.035277	14739	22.6	1	10
2014-03-26 00:24:40.259113	14740	48	2	10
2014-03-26 00:25:19.034996	14748	22.6	1	10
2014-03-26 00:25:19.25953	14749	48	2	10
2014-03-26 00:25:58.033369	14757	22.6	1	10
2014-03-26 00:25:58.267046	14758	48	2	10
2014-03-26 00:26:37.033591	14766	22.6	1	10
2014-03-26 00:26:37.257258	14767	48	2	10
2014-03-26 00:27:16.033394	14774	22.6	1	10
2014-03-26 00:27:16.257286	14775	48	2	10
2014-03-26 00:27:55.035706	14783	22.6	1	10
2014-03-26 00:27:55.260739	14784	48	2	10
2014-03-26 00:28:34.170564	14792	22.6	1	10
2014-03-26 00:28:34.59	14793	48	2	10
2014-03-26 00:29:13.035235	14800	22.6	1	10
2014-03-26 00:29:13.26751	14801	48	2	10
2014-03-26 00:29:52.037338	14809	22.6	1	10
2014-03-26 00:29:52.268991	14810	48	2	10
2014-03-26 00:30:31.036695	14817	22.6	1	10
2014-03-26 00:30:31.25916	14818	48	2	10
2014-03-26 00:30:48.654762	14825	49	2	1
2014-03-26 21:52:48.702873	31633	24.1	1	10
2014-03-26 21:52:48.930941	31634	41	2	10
2014-03-26 00:31:12.171767	14830	20.9	1	8
2014-03-26 00:31:12.404072	14831	52	2	8
2014-03-26 00:31:27.432196	14832	19.2	1	1
2014-03-26 00:31:27.658733	14833	49	2	1
2014-03-26 00:31:32.696687	14834	289	3	2
2014-03-26 21:52:59.049492	31635	22.2	1	9
2014-03-26 21:52:59.283459	31636	48	2	9
2014-03-26 00:31:51.170464	14839	20.9	1	8
2014-03-26 00:31:51.393727	14840	52	2	8
2014-03-26 00:32:06.431357	14841	19.2	1	1
2014-03-26 00:32:06.663835	14842	49	2	1
2014-03-26 00:32:27.835487	14843	338	3	2
2014-03-26 21:53:00.135464	31637	22.2	1	8
2014-03-26 21:53:00.357179	31638	47	2	8
2014-03-26 00:32:30.170188	14848	20.9	1	8
2014-03-26 00:32:30.403125	14849	52	2	8
2014-03-26 00:32:32.693034	14850	338	3	2
2014-03-26 00:32:45.433476	14851	19.2	1	1
2014-03-26 00:32:45.657093	14852	49	2	1
2014-03-26 21:53:14.697127	31639	20.3	1	1
2014-03-26 21:53:14.931906	31640	50	2	1
2014-03-26 00:33:09.17155	14857	20.9	1	8
2014-03-26 00:33:09.392675	14858	52	2	8
2014-03-26 00:33:24.424901	14859	19.1	1	1
2014-03-26 00:33:24.658255	14860	48	2	1
2014-03-26 00:33:32.694818	14861	354	3	2
2014-03-26 21:53:20.565655	31641	579	3	2
2014-03-26 21:53:20.790596	31642	1088232.9187270305	4	2
2014-03-26 00:33:48.172309	14866	20.9	1	8
2014-03-26 00:33:48.403594	14867	52	2	8
2014-03-26 00:34:03.431875	14868	19.1	1	1
2014-03-26 00:34:03.654211	14869	48	2	1
2014-03-26 21:53:27.702538	31643	24.1	1	10
2014-03-26 21:53:27.938215	31644	41	2	10
2014-03-26 00:34:27.170839	14874	20.9	1	8
2014-03-26 00:34:27.403221	14875	52	2	8
2014-03-26 00:34:32.693797	14876	338	3	2
2014-03-26 00:34:42.43017	14877	19.1	1	1
2014-03-26 00:34:42.674271	14878	48	2	1
2014-03-26 21:53:32.562195	31645	498	3	2
2014-03-26 21:53:32.788916	31646	1088235.2167964734	4	2
2014-03-26 00:35:06.171463	14883	20.9	1	8
2014-03-26 00:35:06.39282	14884	52	2	8
2014-03-26 00:35:21.428894	14885	19.1	1	1
2014-03-26 00:35:21.661919	14886	48	2	1
2014-03-26 00:35:32.693078	14887	338	3	2
2014-03-26 21:53:38.049436	31647	22.2	1	9
2014-03-26 21:53:38.286394	31648	48	2	9
2014-03-26 00:35:45.171735	14892	20.9	1	8
2014-03-26 00:35:45.393751	14893	52	2	8
2014-03-26 00:36:00.430004	14894	19.1	1	1
2014-03-26 00:36:00.653252	14895	48	2	1
2014-03-26 21:53:39.137786	31649	22.1	1	8
2014-03-26 21:53:39.361907	31650	47	2	8
2014-03-26 00:36:24.172828	14900	20.9	1	8
2014-03-26 00:36:24.404311	14901	52	2	8
2014-03-26 00:36:39.233415	14902	289	3	2
2014-03-26 00:36:39.54289	14903	19.1	1	1
2014-03-26 00:36:39.765237	14904	48	2	1
2014-03-26 00:36:44.69653	14905	289	3	2
2014-03-26 21:53:44.563124	31651	547	3	2
2014-03-26 21:53:44.806214	31652	1088236.3658311947	4	2
2014-03-26 00:37:03.171435	14910	20.9	1	8
2014-03-26 00:37:03.404518	14911	52	2	8
2014-03-26 00:37:18.427173	14912	19.1	1	1
2014-03-26 00:37:18.649875	14913	48	2	1
2014-03-26 00:37:39.835655	14914	289	3	2
2014-03-26 21:53:53.69857	31653	20.3	1	1
2014-03-26 21:53:53.922233	31654	50	2	1
2014-03-26 00:37:42.171836	14919	20.9	1	8
2014-03-26 00:37:42.395921	14920	52	2	8
2014-03-26 00:37:57.431017	14921	19.1	1	1
2014-03-26 00:37:57.674859	14922	48	2	1
2014-03-26 21:53:56.561329	31655	547	3	2
2014-03-26 21:53:56.795515	31656	1088238.6639006375	4	2
2014-03-26 00:38:21.171358	14927	20.9	1	8
2014-03-26 00:38:21.394593	14928	52	2	8
2014-03-26 00:38:32.696266	14929	289	3	2
2014-03-26 00:38:36.469045	14930	19.1	1	1
2014-03-26 00:38:36.694309	14931	48	2	1
2014-03-26 21:54:06.702118	31657	24.1	1	10
2014-03-26 21:54:06.925562	31658	41	2	10
2014-03-26 00:39:00.334071	14936	20.9	1	8
2014-03-26 00:39:00.800103	14937	52	2	8
2014-03-26 00:39:15.426973	14938	19.1	1	1
2014-03-26 00:39:15.651201	14939	48	2	1
2014-03-26 00:39:32.697892	14940	289	3	2
2014-03-26 21:54:08.561788	31659	579	3	2
2014-03-26 21:54:08.795477	31660	1088239.812935359	4	2
2014-03-26 00:39:39.170269	14945	20.9	1	8
2014-03-26 00:39:39.393379	14946	52	2	8
2014-03-26 00:39:54.423303	14947	19.1	1	1
2014-03-26 00:39:54.655262	14948	48	2	1
2014-03-26 21:54:17.046608	31661	22.2	1	9
2014-03-26 21:54:17.273019	31662	48	2	9
2014-03-26 21:54:18.135703	31663	22.1	1	8
2014-03-26 00:40:18.170005	14953	20.9	1	8
2014-03-26 00:40:18.393655	14954	52	2	8
2014-03-26 00:40:32.693313	14955	289	3	2
2014-03-26 00:40:33.424123	14956	19.1	1	1
2014-03-26 00:40:33.645809	14957	48	2	1
2014-03-26 00:31:10.03604	14826	22.6	1	10
2014-03-26 00:31:10.268176	14827	48	2	10
2014-03-26 00:31:49.035739	14835	22.5	1	10
2014-03-26 00:31:49.261518	14836	48	2	10
2014-03-26 00:32:28.14259	14844	22.5	1	10
2014-03-26 00:32:28.363896	14845	48	2	10
2014-03-26 00:33:07.034998	14853	22.5	1	10
2014-03-26 00:33:07.256794	14854	48	2	10
2014-03-26 00:33:46.036299	14862	22.5	1	10
2014-03-26 00:33:46.261094	14863	48	2	10
2014-03-26 00:34:25.037378	14870	22.5	1	10
2014-03-26 00:34:25.269024	14871	48	2	10
2014-03-26 00:35:04.03749	14879	22.5	1	10
2014-03-26 00:35:04.259046	14880	48	2	10
2014-03-26 00:35:43.039334	14888	22.5	1	10
2014-03-26 00:35:43.263343	14889	48	2	10
2014-03-26 00:36:22.038734	14896	22.5	1	10
2014-03-26 00:36:22.271971	14897	48	2	10
2014-03-26 00:37:01.038137	14906	22.5	1	10
2014-03-26 00:37:01.261596	14907	48	2	10
2014-03-26 00:37:40.155383	14915	22.5	1	10
2014-03-26 00:37:40.379093	14916	48	2	10
2014-03-26 00:38:19.039946	14923	22.5	1	10
2014-03-26 00:38:19.263956	14924	48	2	10
2014-03-26 00:38:58.231116	14932	22.5	1	10
2014-03-26 00:38:58.699971	14933	48	2	10
2014-03-26 00:39:37.038528	14941	22.5	1	10
2014-03-26 00:39:37.263018	14942	48	2	10
2014-03-26 00:40:16.03933	14949	22.5	1	10
2014-03-26 21:54:18.372053	31664	47	2	8
2014-03-26 00:40:57.171924	14962	20.9	1	8
2014-03-26 00:40:57.403788	14963	52	2	8
2014-03-26 00:41:12.422186	14964	19.1	1	1
2014-03-26 00:41:12.643829	14965	48	2	1
2014-03-26 00:41:32.693098	14966	289	3	2
2014-03-26 21:54:20.560685	31665	579	3	2
2014-03-26 21:54:20.784332	31666	1088242.111004802	4	2
2014-03-26 00:41:36.174215	14971	20.9	1	8
2014-03-26 00:41:36.39604	14972	52	2	8
2014-03-26 00:41:51.427285	14973	19.1	1	1
2014-03-26 00:41:51.656796	14974	48	2	1
2014-03-26 21:54:32.935939	31667	20.3	1	1
2014-03-26 21:54:33.169947	31668	50	2	1
2014-03-26 00:42:15.171764	14979	20.9	1	8
2014-03-26 00:42:15.393981	14980	52	2	8
2014-03-26 00:42:30.425645	14981	19.1	1	1
2014-03-26 00:42:30.657008	14982	48	2	1
2014-03-26 00:42:32.694707	14983	289	3	2
2014-03-26 21:54:44.561122	31669	547	3	2
2014-03-26 21:54:44.785281	31670	1088245.558108966	4	2
2014-03-26 00:42:54.171633	14988	20.9	1	8
2014-03-26 00:42:54.394235	14989	52	2	8
2014-03-26 00:43:09.427545	14990	19.1	1	1
2014-03-26 00:43:09.652025	14991	48	2	1
2014-03-26 21:54:45.702843	31671	24.1	1	10
2014-03-26 21:54:45.935387	31672	41	2	10
2014-03-26 00:43:32.693078	14996	354	3	2
2014-03-26 00:43:33.171059	14997	20.9	1	8
2014-03-26 00:43:33.403888	14998	52	2	8
2014-03-26 00:43:44.695502	14999	354	3	2
2014-03-26 00:43:48.427486	15000	19.1	1	1
2014-03-26 00:43:48.65366	15001	48	2	1
2014-03-26 21:54:56.047564	31673	22.2	1	9
2014-03-26 21:54:56.271743	31674	48	2	9
2014-03-26 00:44:12.169874	15006	20.9	1	8
2014-03-26 00:44:12.393598	15007	52	2	8
2014-03-26 00:44:20.695241	15008	418	3	2
2014-03-26 00:44:27.423169	15009	19.1	1	1
2014-03-26 00:44:27.649165	15010	48	2	1
2014-03-26 00:44:32.695097	15011	418	3	2
2014-03-26 21:54:56.58297	31675	547	3	2
2014-03-26 21:54:56.815927	31676	1088247.856178409	4	2
2014-03-26 00:44:51.17012	15016	20.9	1	8
2014-03-26 00:44:51.402263	15017	52	2	8
2014-03-26 00:45:06.426672	15018	19.1	1	1
2014-03-26 00:45:06.649068	15019	48	2	1
2014-03-26 21:54:57.135833	31677	22.1	1	8
2014-03-26 21:54:57.359489	31678	47	2	8
2014-03-26 00:45:30.170614	15024	20.9	1	8
2014-03-26 00:45:30.403915	15025	52	2	8
2014-03-26 00:45:32.692912	15026	418	3	2
2014-03-26 00:45:45.425324	15027	19.1	1	1
2014-03-26 00:45:45.647125	15028	48	2	1
2014-03-26 21:55:11.495231	31679	579	3	2
2014-03-26 21:55:11.730699	31680	1088249.0052131303	4	2
2014-03-26 00:46:09.169968	15033	20.9	1	8
2014-03-26 00:46:09.391633	15034	52	2	8
2014-03-26 00:46:24.425607	15035	19.1	1	1
2014-03-26 00:46:24.657695	15036	48	2	1
2014-03-26 00:46:32.693668	15037	418	3	2
2014-03-26 21:55:12.038526	31681	20.3	1	1
2014-03-26 21:55:12.260824	31682	50	2	1
2014-03-26 00:46:48.172492	15042	20.9	1	8
2014-03-26 00:46:48.393754	15043	52	2	8
2014-03-26 00:47:03.424811	15044	19.1	1	1
2014-03-26 00:47:03.652493	15045	48	2	1
2014-03-26 21:55:20.561156	31683	547	3	2
2014-03-26 21:55:20.797825	31684	1088251.3032825731	4	2
2014-03-26 00:47:27.171575	15050	20.9	1	8
2014-03-26 00:47:27.402809	15051	52	2	8
2014-03-26 00:47:32.694692	15052	418	3	2
2014-03-26 00:47:42.422805	15053	19.1	1	1
2014-03-26 00:47:42.648459	15054	48	2	1
2014-03-26 21:55:24.703143	31685	24.1	1	10
2014-03-26 21:55:24.953502	31686	41	2	10
2014-03-26 00:48:06.170747	15059	20.9	1	8
2014-03-26 00:48:06.393457	15060	52	2	8
2014-03-26 00:48:21.421664	15061	19.1	1	1
2014-03-26 00:48:21.653785	15062	48	2	1
2014-03-26 00:48:32.692692	15063	370	3	2
2014-03-26 21:55:32.560127	31687	531	3	2
2014-03-26 21:55:32.794698	31688	1088253.601352016	4	2
2014-03-26 00:48:44.693799	15068	370	3	2
2014-03-26 00:48:45.170181	15069	20.9	1	8
2014-03-26 00:48:45.403259	15070	52	2	8
2014-03-26 00:48:56.691848	15071	338	3	2
2014-03-26 00:49:00.422949	15072	19.1	1	1
2014-03-26 00:49:00.645939	15073	48	2	1
2014-03-26 00:49:08.819766	15074	338	3	2
2014-03-26 21:55:35.046703	31689	22.2	1	9
2014-03-26 21:55:35.269911	31690	48	2	9
2014-03-26 00:49:24.170347	15079	20.9	1	8
2014-03-26 00:49:24.39183	15080	52	2	8
2014-03-26 00:49:39.223591	15081	338	3	2
2014-03-26 00:49:39.542403	15082	19.1	1	1
2014-03-26 00:49:39.76668	15083	48	2	1
2014-03-26 21:55:36.137039	31691	22.1	1	8
2014-03-26 21:55:36.373197	31692	47	2	8
2014-03-26 00:50:03.17017	15088	20.9	1	8
2014-03-26 00:50:03.409485	15089	52	2	8
2014-03-26 00:50:18.422298	15090	19.1	1	1
2014-03-26 00:50:18.645619	15091	48	2	1
2014-03-26 00:50:32.692381	15092	338	3	2
2014-03-26 00:41:34.044063	14967	22.4	1	10
2014-03-26 00:41:34.268239	14968	48	2	10
2014-03-26 00:42:13.04098	14975	22.4	1	10
2014-03-26 00:42:13.264913	14976	48	2	10
2014-03-26 00:42:52.038471	14984	22.4	1	10
2014-03-26 00:42:52.264082	14985	48	2	10
2014-03-26 00:43:31.039934	14992	22.4	1	10
2014-03-26 00:43:31.262215	14993	48	2	10
2014-03-26 00:44:10.040152	15002	22.4	1	10
2014-03-26 00:44:10.262483	15003	48	2	10
2014-03-26 00:44:49.039187	15012	22.4	1	10
2014-03-26 00:44:49.283128	15013	48	2	10
2014-03-26 00:45:28.039952	15020	22.4	1	10
2014-03-26 00:45:28.272684	15021	48	2	10
2014-03-26 00:46:07.041223	15029	22.4	1	10
2014-03-26 00:46:07.266116	15030	48	2	10
2014-03-26 00:46:46.044073	15038	22.4	1	10
2014-03-26 00:46:46.267021	15039	48	2	10
2014-03-26 00:47:25.03959	15046	22.4	1	10
2014-03-26 00:47:25.272578	15047	48	2	10
2014-03-26 00:48:04.044846	15055	22.4	1	10
2014-03-26 00:48:04.267297	15056	48	2	10
2014-03-26 00:48:43.040154	15064	22.4	1	10
2014-03-26 00:48:43.262225	15065	48	2	10
2014-03-26 00:49:22.042187	15075	22.4	1	10
2014-03-26 00:49:22.265973	15076	48	2	10
2014-03-26 00:50:01.042258	15084	22.4	1	10
2014-03-26 00:50:01.267166	15085	48	2	10
2014-03-26 00:50:40.042831	15093	22.3	1	10
2014-03-26 00:50:42.170212	15097	20.9	1	8
2014-03-26 00:50:42.393614	15098	52	2	8
2014-03-26 00:50:56.691916	15099	305	3	2
2014-03-26 00:50:57.421889	15100	19.1	1	1
2014-03-26 00:50:57.644698	15101	48	2	1
2014-03-26 00:51:08.691837	15102	305	3	2
2014-03-26 21:55:44.563129	31693	482	3	2
2014-03-26 21:55:44.790001	31694	1088254.7503867373	4	2
2014-03-26 00:51:21.172867	15107	20.9	1	8
2014-03-26 00:51:21.404462	15108	52	2	8
2014-03-26 00:51:32.691177	15109	338	3	2
2014-03-26 00:51:36.420576	15110	19.1	1	1
2014-03-26 00:51:36.64371	15111	48	2	1
2014-03-26 00:51:44.695562	15112	338	3	2
2014-03-26 00:51:56.689766	15113	370	3	2
2014-03-26 21:55:50.695791	31695	20.3	1	1
2014-03-26 21:55:50.931211	31696	50	2	1
2014-03-26 00:52:00.170583	15118	20.9	1	8
2014-03-26 00:52:00.401388	15119	52	2	8
2014-03-26 00:52:08.692003	15120	354	3	2
2014-03-26 00:52:15.419572	15121	19.1	1	1
2014-03-26 00:52:15.641174	15122	48	2	1
2014-03-26 00:52:32.694404	15123	354	3	2
2014-03-26 21:55:59.142405	31697	547	3	2
2014-03-26 21:55:59.366504	31698	1088257.0484561801	4	2
2014-03-26 00:52:39.172806	15128	20.9	1	8
2014-03-26 00:52:39.394885	15129	52	2	8
2014-03-26 00:52:54.419537	15130	19.1	1	1
2014-03-26 00:52:54.651493	15131	48	2	1
2014-03-26 21:56:03.702371	31699	24.2	1	10
2014-03-26 21:56:03.948941	31700	41	2	10
2014-03-26 00:53:18.170799	15136	20.9	1	8
2014-03-26 00:53:18.394379	15137	52	2	8
2014-03-26 00:53:32.692429	15138	354	3	2
2014-03-26 00:53:33.420549	15139	19.1	1	1
2014-03-26 00:53:33.644562	15140	48	2	1
2014-03-26 21:56:08.563125	31701	498	3	2
2014-03-26 21:56:08.788066	31702	1088258.1974909017	4	2
2014-03-26 00:53:57.170036	15145	20.9	1	8
2014-03-26 00:53:57.392971	15146	52	2	8
2014-03-26 00:54:12.423685	15147	19.1	1	1
2014-03-26 00:54:12.646774	15148	48	2	1
2014-03-26 00:54:32.693931	15149	354	3	2
2014-03-26 21:56:14.052346	31703	22.2	1	9
2014-03-26 21:56:14.28738	31704	48	2	9
2014-03-26 00:54:36.170681	15154	20.9	1	8
2014-03-26 00:54:36.392276	15155	52	2	8
2014-03-26 00:54:51.421725	15156	19.1	1	1
2014-03-26 00:54:51.645202	15157	48	2	1
2014-03-26 21:56:15.136187	31705	22.1	1	8
2014-03-26 21:56:15.358999	31706	47	2	8
2014-03-26 00:55:15.171541	15162	20.9	1	8
2014-03-26 00:55:15.393003	15163	52	2	8
2014-03-26 00:55:30.417841	15164	19.0	1	1
2014-03-26 00:55:30.639711	15165	48	2	1
2014-03-26 00:55:32.693745	15166	338	3	2
2014-03-26 21:56:20.563563	31707	547	3	2
2014-03-26 21:56:20.797546	31708	1088260.4955603445	4	2
2014-03-26 00:55:54.171901	15171	20.9	1	8
2014-03-26 00:55:54.395012	15172	52	2	8
2014-03-26 00:56:09.417497	15173	19.0	1	1
2014-03-26 00:56:09.649466	15174	48	2	1
2014-03-26 21:56:29.752877	31709	20.3	1	1
2014-03-26 21:56:29.980985	31710	50	2	1
2014-03-26 00:56:32.691649	15179	338	3	2
2014-03-26 00:56:33.17195	15180	20.9	1	8
2014-03-26 00:56:33.39445	15181	52	2	8
2014-03-26 00:56:44.692646	15182	402	3	2
2014-03-26 00:56:48.415647	15183	19.0	1	1
2014-03-26 00:56:48.637049	15184	48	2	1
2014-03-26 00:56:56.689084	15185	402	3	2
2014-03-26 21:56:32.559123	31711	515	3	2
2014-03-26 21:56:32.795277	31712	1088261.6445950659	4	2
2014-03-26 00:57:12.172118	15190	20.9	1	8
2014-03-26 00:57:12.394479	15191	52	2	8
2014-03-26 00:57:27.414607	15192	19.0	1	1
2014-03-26 00:57:27.639137	15193	48	2	1
2014-03-26 00:57:48.843094	15194	402	3	2
2014-03-26 21:56:42.705301	31713	24.2	1	10
2014-03-26 21:56:42.928876	31714	41	2	10
2014-03-26 00:57:51.17173	15199	20.9	1	8
2014-03-26 00:57:51.402566	15200	52	2	8
2014-03-26 00:58:06.419308	15201	19.0	1	1
2014-03-26 00:58:06.641349	15202	48	2	1
2014-03-26 21:56:44.563974	31715	531	3	2
2014-03-26 21:56:44.797531	31716	1088263.9426645087	4	2
2014-03-26 00:58:30.16993	15207	20.9	1	8
2014-03-26 00:58:30.40462	15208	52	2	8
2014-03-26 00:58:32.689899	15209	338	3	2
2014-03-26 00:58:44.692674	15210	338	3	2
2014-03-26 00:58:45.413272	15211	19.0	1	1
2014-03-26 00:58:45.645865	15212	48	2	1
2014-03-26 21:56:53.046863	31717	22.2	1	9
2014-03-26 21:56:53.273678	31718	48	2	9
2014-03-26 00:59:09.170334	15217	20.9	1	8
2014-03-26 00:59:09.393135	15218	52	2	8
2014-03-26 00:59:24.549958	15219	19.0	1	1
2014-03-26 00:59:24.985489	15220	48	2	1
2014-03-26 00:59:32.692957	15221	338	3	2
2014-03-26 21:56:54.136314	31719	22.1	1	8
2014-03-26 00:59:48.17037	15226	20.9	1	8
2014-03-26 00:59:48.391411	15227	52	2	8
2014-03-26 00:59:56.694725	15228	305	3	2
2014-03-26 01:00:03.415151	15229	19.0	1	1
2014-03-26 01:00:03.640184	15230	48	2	1
2014-03-26 01:00:08.691812	15231	338	3	2
2014-03-26 01:00:20.690175	15232	338	3	2
2014-03-26 00:51:19.041925	15103	22.3	1	10
2014-03-26 00:51:19.284911	15104	48	2	10
2014-03-26 00:51:58.043378	15114	22.3	1	10
2014-03-26 00:51:58.274628	15115	48	2	10
2014-03-26 00:52:37.049117	15124	22.3	1	10
2014-03-26 00:52:37.274874	15125	48	2	10
2014-03-26 00:53:16.043294	15132	22.3	1	10
2014-03-26 00:53:16.266616	15133	48	2	10
2014-03-26 00:53:55.042702	15141	22.3	1	10
2014-03-26 00:53:55.28405	15142	48	2	10
2014-03-26 00:54:34.043075	15150	22.3	1	10
2014-03-26 00:54:34.264582	15151	48	2	10
2014-03-26 00:55:13.042607	15158	22.3	1	10
2014-03-26 00:55:13.265944	15159	48	2	10
2014-03-26 00:55:52.043718	15167	22.3	1	10
2014-03-26 00:55:52.266907	15168	48	2	10
2014-03-26 00:56:31.045731	15175	22.3	1	10
2014-03-26 00:56:31.26797	15176	48	2	10
2014-03-26 00:57:10.045222	15186	22.3	1	10
2014-03-26 00:57:10.268155	15187	48	2	10
2014-03-26 00:57:49.15365	15195	22.3	1	10
2014-03-26 00:57:49.375863	15196	48	2	10
2014-03-26 00:58:28.044369	15203	22.3	1	10
2014-03-26 00:58:28.278196	15204	48	2	10
2014-03-26 00:59:07.0446	15213	22.3	1	10
2014-03-26 00:59:07.265645	15214	48	2	10
2014-03-26 21:56:54.370781	31720	47	2	8
2014-03-26 21:57:08.696493	31721	20.3	1	1
2014-03-26 01:00:27.170043	15237	20.9	1	8
2014-03-26 01:00:27.402702	15238	52	2	8
2014-03-26 01:00:32.693598	15239	354	3	2
2014-03-26 01:00:42.410881	15240	19.0	1	1
2014-03-26 01:00:42.635058	15241	48	2	1
2014-03-26 21:57:08.923184	31722	50	2	1
2014-03-26 21:57:20.5629	31723	498	3	2
2014-03-26 01:01:06.170322	15246	20.9	1	8
2014-03-26 01:01:06.39136	15247	52	2	8
2014-03-26 01:01:08.690533	15248	289	3	2
2014-03-26 01:01:20.692797	15249	289	3	2
2014-03-26 01:01:21.414577	15250	19.0	1	1
2014-03-26 01:01:21.635274	15251	48	2	1
2014-03-26 01:01:32.688891	15252	289	3	2
2014-03-26 21:57:20.798957	31724	1088268.5388033944	4	2
2014-03-26 21:57:21.703126	31725	24.2	1	10
2014-03-26 01:01:45.170578	15257	20.9	1	8
2014-03-26 01:01:45.392016	15258	52	2	8
2014-03-26 01:02:00.415269	15259	19.0	1	1
2014-03-26 01:02:00.646893	15260	48	2	1
2014-03-26 21:57:21.927907	31726	41	2	10
2014-03-26 21:57:32.047605	31727	22.2	1	9
2014-03-26 01:02:24.169828	15265	20.9	1	8
2014-03-26 01:02:24.391316	15266	52	2	8
2014-03-26 01:02:32.68971	15267	289	3	2
2014-03-26 01:02:39.414937	15268	19.0	1	1
2014-03-26 01:02:39.638294	15269	48	2	1
2014-03-26 21:57:32.284377	31728	48	2	9
2014-03-26 21:57:32.592808	31729	547	3	2
2014-03-26 01:03:03.172729	15274	20.9	1	8
2014-03-26 01:03:03.404245	15275	52	2	8
2014-03-26 01:03:18.417817	15276	19.0	1	1
2014-03-26 01:03:18.640486	15277	48	2	1
2014-03-26 01:03:32.692968	15278	289	3	2
2014-03-26 21:57:32.818195	31730	1088270.8368728373	4	2
2014-03-26 21:57:33.13717	31731	22.1	1	8
2014-03-26 01:03:42.170536	15283	20.9	1	8
2014-03-26 01:03:42.393346	15284	52	2	8
2014-03-26 01:03:57.413544	15285	19.0	1	1
2014-03-26 01:03:57.656753	15286	48	2	1
2014-03-26 21:57:33.369106	31732	47	2	8
2014-03-26 21:57:44.559834	31733	547	3	2
2014-03-26 01:04:21.170709	15291	20.9	1	8
2014-03-26 01:04:21.393209	15292	52	2	8
2014-03-26 01:04:32.692713	15293	305	3	2
2014-03-26 01:04:36.413073	15294	19.0	1	1
2014-03-26 01:04:36.636402	15295	48	2	1
2014-03-26 21:57:44.785491	31734	1088273.1349422801	4	2
2014-03-26 21:57:47.697914	31735	20.3	1	1
2014-03-26 01:05:00.169617	15300	20.9	1	8
2014-03-26 01:05:00.39059	15301	52	2	8
2014-03-26 01:05:15.411714	15302	19.0	1	1
2014-03-26 01:05:15.636096	15303	48	2	1
2014-03-26 01:05:32.69452	15304	289	3	2
2014-03-26 21:57:47.934484	31736	50	2	1
2014-03-26 21:57:56.563089	31737	579	3	2
2014-03-26 01:05:39.170029	15309	20.9	1	8
2014-03-26 01:05:39.392397	15310	52	2	8
2014-03-26 01:05:54.413604	15311	19.0	1	1
2014-03-26 01:05:54.648043	15312	48	2	1
2014-03-26 21:57:56.78737	31738	1088274.2839770014	4	2
2014-03-26 21:58:00.703259	31739	24.2	1	10
2014-03-26 01:06:18.169259	15317	20.9	1	8
2014-03-26 01:06:18.392759	15318	52	2	8
2014-03-26 01:06:32.689851	15319	289	3	2
2014-03-26 01:06:33.409858	15320	19.0	1	1
2014-03-26 01:06:33.632604	15321	48	2	1
2014-03-26 21:58:00.937129	31740	41	2	10
2014-03-26 21:58:08.562	31741	547	3	2
2014-03-26 01:06:57.170368	15326	20.9	1	8
2014-03-26 01:06:57.403813	15327	52	2	8
2014-03-26 01:07:12.412573	15328	19.0	1	1
2014-03-26 01:07:12.636763	15329	48	2	1
2014-03-26 01:07:32.690388	15330	305	3	2
2014-03-26 21:58:08.785694	31742	1088276.5820464443	4	2
2014-03-26 21:58:11.047464	31743	22.2	1	9
2014-03-26 01:07:36.169015	15335	20.9	1	8
2014-03-26 01:07:36.391444	15336	52	2	8
2014-03-26 01:07:51.412337	15337	19.0	1	1
2014-03-26 01:07:51.648993	15338	48	2	1
2014-03-26 21:58:11.282453	31744	48	2	9
2014-03-26 21:58:12.136593	31745	22.1	1	8
2014-03-26 01:08:15.171826	15343	20.9	1	8
2014-03-26 01:08:15.394402	15344	52	2	8
2014-03-26 01:08:30.452831	15345	19.0	1	1
2014-03-26 01:08:30.684865	15346	48	2	1
2014-03-26 01:08:32.692494	15347	305	3	2
2014-03-26 21:58:12.359702	31746	47	2	8
2014-03-26 21:58:26.69589	31747	20.3	1	1
2014-03-26 01:08:54.172366	15352	20.9	1	8
2014-03-26 01:08:54.403044	15353	52	2	8
2014-03-26 01:08:56.691638	15354	338	3	2
2014-03-26 01:09:08.690008	15355	338	3	2
2014-03-26 01:09:09.40828	15356	19.0	1	1
2014-03-26 01:09:09.63922	15357	48	2	1
2014-03-26 21:58:26.942701	31748	50	2	1
2014-03-26 21:58:32.559996	31749	627	3	2
2014-03-26 21:58:32.784726	31750	1088280.0291506085	4	2
2014-03-26 01:09:33.204689	15362	338	3	2
2014-03-26 01:09:33.787002	15363	20.9	1	8
2014-03-26 01:09:34.210013	15364	52	2	8
2014-03-26 01:09:48.407778	15365	19.0	1	1
2014-03-26 01:09:48.631698	15366	48	2	1
2014-03-26 01:00:25.0448	15233	22.3	1	10
2014-03-26 01:00:25.277111	15234	48	2	10
2014-03-26 01:01:04.045467	15242	22.3	1	10
2014-03-26 01:01:04.267865	15243	48	2	10
2014-03-26 01:01:43.045698	15253	22.2	1	10
2014-03-26 01:01:43.268941	15254	48	2	10
2014-03-26 01:02:22.047011	15261	22.2	1	10
2014-03-26 01:02:22.269396	15262	48	2	10
2014-03-26 01:03:01.045591	15270	22.2	1	10
2014-03-26 01:03:01.278158	15271	48	2	10
2014-03-26 01:03:40.044868	15279	22.2	1	10
2014-03-26 01:03:40.270147	15280	48	2	10
2014-03-26 01:04:19.045988	15287	22.2	1	10
2014-03-26 01:04:19.269114	15288	48	2	10
2014-03-26 01:04:58.047643	15296	22.2	1	10
2014-03-26 01:04:58.271539	15297	48	2	10
2014-03-26 01:05:37.047144	15305	22.2	1	10
2014-03-26 01:05:37.279521	15306	48	2	10
2014-03-26 01:06:16.047368	15313	22.2	1	10
2014-03-26 01:06:16.270045	15314	48	2	10
2014-03-26 01:06:55.047349	15322	22.2	1	10
2014-03-26 01:06:55.279524	15323	48	2	10
2014-03-26 01:07:34.048594	15331	22.2	1	10
2014-03-26 01:07:34.269106	15332	48	2	10
2014-03-26 01:08:13.049807	15339	22.2	1	10
2014-03-26 01:08:13.272612	15340	48	2	10
2014-03-26 01:08:52.047446	15348	22.2	1	10
2014-03-26 01:08:52.272495	15349	48	2	10
2014-03-26 21:58:39.704063	31751	24.2	1	10
2014-03-26 21:58:39.942471	31752	41	2	10
2014-03-26 01:10:12.169338	15371	20.9	1	8
2014-03-26 01:10:12.401613	15372	52	2	8
2014-03-26 01:10:27.40774	15373	19.0	1	1
2014-03-26 01:10:27.633948	15374	48	2	1
2014-03-26 01:10:32.692991	15375	338	3	2
2014-03-26 21:58:44.559416	31753	627	3	2
2014-03-26 21:58:44.783239	31754	1088282.3272200513	4	2
2014-03-26 01:10:51.170581	15380	20.9	1	8
2014-03-26 01:10:51.391717	15381	52	2	8
2014-03-26 01:11:06.410248	15382	19.0	1	1
2014-03-26 01:11:06.644518	15383	48	2	1
2014-03-26 21:58:50.049415	31755	22.2	1	9
2014-03-26 21:58:50.285945	31756	48	2	9
2014-03-26 01:11:30.170897	15388	20.9	1	8
2014-03-26 01:11:30.43719	15389	52	2	8
2014-03-26 01:11:32.692799	15390	338	3	2
2014-03-26 01:11:45.411833	15391	19.0	1	1
2014-03-26 01:11:45.634988	15392	48	2	1
2014-03-26 21:58:51.138169	31757	22.1	1	8
2014-03-26 21:58:51.36193	31758	47	2	8
2014-03-26 01:12:09.170232	15397	20.9	1	8
2014-03-26 01:12:09.399275	15398	52	2	8
2014-03-26 01:12:24.408695	15399	19.0	1	1
2014-03-26 01:12:24.630621	15400	48	2	1
2014-03-26 01:12:32.690766	15401	338	3	2
2014-03-26 21:58:56.562177	31759	659	3	2
2014-03-26 21:58:56.797907	31760	1088284.6252894942	4	2
2014-03-26 01:12:48.170249	15406	20.9	1	8
2014-03-26 01:12:48.392532	15407	52	2	8
2014-03-26 01:12:56.690533	15408	289	3	2
2014-03-26 01:13:03.447939	15409	19.0	1	1
2014-03-26 01:13:03.67119	15410	48	2	1
2014-03-26 01:13:08.692469	15411	289	3	2
2014-03-26 21:59:05.696876	31761	20.3	1	1
2014-03-26 21:59:05.921357	31762	50	2	1
2014-03-26 01:13:27.169357	15416	20.9	1	8
2014-03-26 01:13:27.401922	15417	52	2	8
2014-03-26 01:13:32.686774	15418	289	3	2
2014-03-26 01:13:42.407426	15419	19.0	1	1
2014-03-26 01:13:42.629326	15420	48	2	1
2014-03-26 21:59:08.561804	31763	659	3	2
2014-03-26 21:59:08.795326	31764	1088286.923358937	4	2
2014-03-26 01:14:06.172098	15425	20.9	1	8
2014-03-26 01:14:06.395006	15426	52	2	8
2014-03-26 01:14:21.44667	15427	19.0	1	1
2014-03-26 01:14:21.668532	15428	48	2	1
2014-03-26 01:14:32.689198	15429	289	3	2
2014-03-26 21:59:18.705111	31765	24.2	1	10
2014-03-26 21:59:18.930568	31766	41	2	10
2014-03-26 01:14:45.170066	15434	20.9	1	8
2014-03-26 01:14:45.393119	15435	52	2	8
2014-03-26 01:15:00.405825	15436	19.0	1	1
2014-03-26 01:15:00.660846	15437	48	2	1
2014-03-26 21:59:29.047257	31767	22.2	1	9
2014-03-26 21:59:29.282515	31768	48	2	9
2014-03-26 01:15:24.172279	15442	20.9	1	8
2014-03-26 01:15:24.397402	15443	52	2	8
2014-03-26 01:15:32.69167	15444	289	3	2
2014-03-26 01:15:39.40449	15445	19.0	1	1
2014-03-26 01:15:39.628046	15446	48	2	1
2014-03-26 21:59:30.137072	31769	22.1	1	8
2014-03-26 21:59:30.360621	31770	47	2	8
2014-03-26 01:16:03.169912	15451	20.9	1	8
2014-03-26 01:16:03.401989	15452	52	2	8
2014-03-26 01:16:18.401569	15453	19.0	1	1
2014-03-26 01:16:18.626944	15454	48	2	1
2014-03-26 01:16:32.694543	15455	289	3	2
2014-03-26 21:59:32.562148	31771	676	3	2
2014-03-26 21:59:32.79541	31772	1088291.5194978227	4	2
2014-03-26 01:16:42.170867	15460	20.9	1	8
2014-03-26 01:16:42.392757	15461	52	2	8
2014-03-26 01:16:57.403978	15462	19.0	1	1
2014-03-26 01:16:57.636659	15463	48	2	1
2014-03-26 21:59:44.694054	31773	20.3	1	1
2014-03-26 21:59:44.917967	31774	50	2	1
2014-03-26 01:17:21.169228	15468	20.9	1	8
2014-03-26 01:17:21.390846	15469	52	2	8
2014-03-26 01:17:32.694458	15470	289	3	2
2014-03-26 01:17:36.403976	15471	19.0	1	1
2014-03-26 01:17:36.628643	15472	48	2	1
2014-03-26 21:59:57.704881	31775	24.2	1	10
2014-03-26 21:59:57.939101	31776	41	2	10
2014-03-26 01:18:00.169259	15477	20.9	1	8
2014-03-26 01:18:00.434849	15478	52	2	8
2014-03-26 01:18:15.406004	15479	19.0	1	1
2014-03-26 01:18:15.666933	15480	48	2	1
2014-03-26 01:18:32.691123	15481	289	3	2
2014-03-26 22:00:08.047421	31777	22.2	1	9
2014-03-26 22:00:08.275381	31778	48	2	9
2014-03-26 01:18:39.170276	15486	20.9	1	8
2014-03-26 01:18:39.393428	15487	52	2	8
2014-03-26 01:18:54.40586	15488	19.0	1	1
2014-03-26 01:18:54.638684	15489	48	2	1
2014-03-26 22:00:08.585024	31779	724	3	2
2014-03-26 01:19:18.171894	15494	20.9	1	8
2014-03-26 01:19:18.393801	15495	52	2	8
2014-03-26 01:19:32.690507	15496	289	3	2
2014-03-26 01:19:33.400331	15497	19.0	1	1
2014-03-26 01:19:33.623197	15498	48	2	1
2014-03-26 01:19:57.299862	15503	20.9	1	8
2014-03-26 01:19:57.739868	15504	52	2	8
2014-03-26 01:10:49.048071	15376	22.2	1	10
2014-03-26 01:10:49.271998	15377	48	2	10
2014-03-26 01:11:28.04845	15384	22.1	1	10
2014-03-26 01:11:28.272066	15385	48	2	10
2014-03-26 01:12:07.050916	15393	22.1	1	10
2014-03-26 01:12:07.283855	15394	48	2	10
2014-03-26 01:12:46.04919	15402	22.1	1	10
2014-03-26 01:12:46.273994	15403	48	2	10
2014-03-26 01:13:25.052144	15412	22.1	1	10
2014-03-26 01:13:25.285812	15413	48	2	10
2014-03-26 01:14:04.054304	15421	22.1	1	10
2014-03-26 01:14:04.278918	15422	48	2	10
2014-03-26 01:14:43.048935	15430	22.1	1	10
2014-03-26 01:14:43.274296	15431	48	2	10
2014-03-26 01:15:22.049893	15438	22.1	1	10
2014-03-26 01:15:22.27199	15439	48	2	10
2014-03-26 01:16:01.048679	15447	22.1	1	10
2014-03-26 01:16:01.281367	15448	48	2	10
2014-03-26 01:16:40.052021	15456	22.1	1	10
2014-03-26 01:16:40.274745	15457	48	2	10
2014-03-26 01:17:19.051698	15464	22.1	1	10
2014-03-26 01:17:19.275498	15465	48	2	10
2014-03-26 01:17:58.052198	15473	22.1	1	10
2014-03-26 01:17:58.325984	15474	48	2	10
2014-03-26 01:18:37.052957	15482	22.1	1	10
2014-03-26 01:18:37.277584	15483	48	2	10
2014-03-26 01:19:16.05078	15490	22.1	1	10
2014-03-26 01:19:16.275112	15491	48	2	10
2014-03-26 01:19:55.179948	15499	22.1	1	10
2014-03-26 01:19:55.640041	15500	48	2	10
2014-03-26 01:20:12.401399	15505	19.0	1	1
2014-03-26 01:20:12.625435	15506	48	2	1
2014-03-26 01:20:32.689041	15507	338	3	2
2014-03-26 22:00:08.818112	31780	1088297.2646714298	4	2
2014-03-26 22:00:09.135865	31781	22.1	1	8
2014-03-26 01:20:36.169781	15512	20.9	1	8
2014-03-26 01:20:36.394891	15513	52	2	8
2014-03-26 01:20:44.686816	15514	354	3	2
2014-03-26 01:20:51.407769	15515	19.0	1	1
2014-03-26 01:20:51.629458	15516	48	2	1
2014-03-26 22:00:09.362494	31782	47	2	8
2014-03-26 22:00:20.561493	31783	708	3	2
2014-03-26 01:21:15.168651	15521	20.9	1	8
2014-03-26 01:21:15.399726	15522	52	2	8
2014-03-26 01:21:30.40157	15523	19.0	1	1
2014-03-26 01:21:30.627397	15524	48	2	1
2014-03-26 01:21:32.689545	15525	338	3	2
2014-03-26 22:00:20.796361	31784	1088299.5627408726	4	2
2014-03-26 22:00:23.694967	31785	20.3	1	1
2014-03-26 01:21:54.170179	15530	20.9	1	8
2014-03-26 01:21:54.391368	15531	52	2	8
2014-03-26 01:22:09.400006	15532	19.0	1	1
2014-03-26 01:22:09.63314	15533	48	2	1
2014-03-26 22:00:23.91986	31786	50	2	1
2014-03-26 22:00:32.561958	31787	692	3	2
2014-03-26 01:22:32.693706	15538	354	3	2
2014-03-26 01:22:33.171971	15539	20.9	1	8
2014-03-26 01:22:33.393489	15540	52	2	8
2014-03-26 01:22:48.403108	15541	19.0	1	1
2014-03-26 01:22:48.627832	15542	48	2	1
2014-03-26 22:00:32.797187	31788	1088301.8608103155	4	2
2014-03-26 22:00:36.70367	31789	24.2	1	10
2014-03-26 01:23:12.17125	15547	20.9	1	8
2014-03-26 01:23:12.403055	15548	52	2	8
2014-03-26 01:23:27.399574	15549	19.0	1	1
2014-03-26 01:23:27.622468	15550	48	2	1
2014-03-26 01:23:32.687697	15551	338	3	2
2014-03-26 22:00:36.928817	31790	41	2	10
2014-03-26 22:00:47.047579	31791	22.2	1	9
2014-03-26 01:23:51.170791	15556	20.9	1	8
2014-03-26 01:23:51.393836	15557	52	2	8
2014-03-26 01:24:06.402303	15558	19.0	1	1
2014-03-26 01:24:06.625194	15559	48	2	1
2014-03-26 22:00:47.283258	31792	48	2	9
2014-03-26 22:00:48.136304	31793	22.1	1	8
2014-03-26 01:24:30.17279	15564	20.9	1	8
2014-03-26 01:24:30.395828	15565	52	2	8
2014-03-26 01:24:32.687481	15566	305	3	2
2014-03-26 01:24:44.692031	15567	289	3	2
2014-03-26 01:24:45.402293	15568	19.0	1	1
2014-03-26 01:24:45.624712	15569	48	2	1
2014-03-26 22:00:48.359509	31794	47	2	8
2014-03-26 22:01:02.693746	31795	20.3	1	1
2014-03-26 01:25:09.169843	15574	20.9	1	8
2014-03-26 01:25:09.393913	15575	52	2	8
2014-03-26 01:25:24.402088	15576	19.0	1	1
2014-03-26 01:25:24.627015	15577	48	2	1
2014-03-26 01:25:32.688848	15578	305	3	2
2014-03-26 22:01:02.939583	31796	50	2	1
2014-03-26 22:01:08.56139	31797	692	3	2
2014-03-26 01:25:48.170754	15583	20.9	1	8
2014-03-26 01:25:48.404182	15584	52	2	8
2014-03-26 01:26:03.402041	15585	19.0	1	1
2014-03-26 01:26:03.624712	15586	48	2	1
2014-03-26 22:01:08.786612	31798	1088309.9040533653	4	2
2014-03-26 22:01:15.705141	31799	24.2	1	10
2014-03-26 01:26:27.170478	15591	20.9	1	8
2014-03-26 01:26:27.40168	15592	52	2	8
2014-03-26 01:26:32.688696	15593	305	3	2
2014-03-26 01:26:42.399923	15594	19.0	1	1
2014-03-26 01:26:42.62527	15595	48	2	1
2014-03-26 22:01:15.938789	31800	41	2	10
2014-03-26 22:01:20.560841	31801	676	3	2
2014-03-26 01:27:06.171046	15600	20.9	1	8
2014-03-26 01:27:06.392127	15601	52	2	8
2014-03-26 01:27:21.399244	15602	19.0	1	1
2014-03-26 01:27:21.646839	15603	48	2	1
2014-03-26 01:27:42.854106	15604	289	3	2
2014-03-26 22:01:20.786231	31802	1088312.2021228082	4	2
2014-03-26 22:01:26.047013	31803	22.2	1	9
2014-03-26 01:27:45.169722	15609	20.9	1	8
2014-03-26 01:27:45.39013	15610	52	2	8
2014-03-26 01:28:00.397356	15611	19.0	1	1
2014-03-26 01:28:00.62654	15612	48	2	1
2014-03-26 22:01:26.284612	31804	48	2	9
2014-03-26 22:01:27.134921	31805	22.1	1	8
2014-03-26 01:28:24.169087	15617	20.9	1	8
2014-03-26 01:28:24.389604	15618	52	2	8
2014-03-26 01:28:39.201555	15619	305	3	2
2014-03-26 01:28:39.518957	15620	19.0	1	1
2014-03-26 01:28:39.739808	15621	48	2	1
2014-03-26 22:01:27.358943	31806	47	2	8
2014-03-26 22:01:32.562689	31807	611	3	2
2014-03-26 01:29:03.169569	15626	20.9	1	8
2014-03-26 01:29:03.399309	15627	52	2	8
2014-03-26 01:29:18.39906	15628	18.9	1	1
2014-03-26 01:29:18.622308	15629	49	2	1
2014-03-26 01:29:32.687018	15630	289	3	2
2014-03-26 22:01:32.798848	31808	1088314.500192251	4	2
2014-03-26 22:01:41.69435	31809	20.3	1	1
2014-03-26 22:01:41.920063	31810	50	2	1
2014-03-26 01:29:42.170001	15635	20.9	1	8
2014-03-26 01:29:42.393632	15636	52	2	8
2014-03-26 01:29:57.399187	15637	18.9	1	1
2014-03-26 01:29:57.63095	15638	49	2	1
2014-03-26 01:20:34.051898	15508	22.1	1	10
2014-03-26 01:20:34.276303	15509	48	2	10
2014-03-26 01:21:13.052637	15517	22.1	1	10
2014-03-26 01:21:13.274009	15518	48	2	10
2014-03-26 01:21:52.052273	15526	22.1	1	10
2014-03-26 01:21:52.274367	15527	48	2	10
2014-03-26 01:22:31.051591	15534	22.1	1	10
2014-03-26 01:22:31.274102	15535	48	2	10
2014-03-26 01:23:10.051934	15543	22.0	1	10
2014-03-26 01:23:10.273313	15544	48	2	10
2014-03-26 01:23:49.055237	15552	22.0	1	10
2014-03-26 01:23:49.286529	15553	48	2	10
2014-03-26 01:24:28.054872	15560	22.0	1	10
2014-03-26 01:24:28.277833	15561	48	2	10
2014-03-26 01:25:07.053241	15570	22.0	1	10
2014-03-26 01:25:07.276258	15571	48	2	10
2014-03-26 01:25:46.052989	15579	22.0	1	10
2014-03-26 01:25:46.287611	15580	48	2	10
2014-03-26 01:26:25.053313	15587	22.0	1	10
2014-03-26 01:26:25.286457	15588	48	2	10
2014-03-26 01:27:04.261697	15596	22.0	1	10
2014-03-26 01:27:04.48532	15597	48	2	10
2014-03-26 01:27:43.163637	15605	22.0	1	10
2014-03-26 01:27:43.387173	15606	48	2	10
2014-03-26 01:28:22.053858	15613	22.0	1	10
2014-03-26 01:28:22.276842	15614	48	2	10
2014-03-26 01:29:01.054048	15622	22.0	1	10
2014-03-26 01:29:01.284063	15623	48	2	10
2014-03-26 22:01:44.560932	31811	611	3	2
2014-03-26 22:01:44.797014	31812	1088315.6492269724	4	2
2014-03-26 01:30:21.172374	15643	20.9	1	8
2014-03-26 01:30:21.39575	15644	52	2	8
2014-03-26 01:30:32.684174	15645	305	3	2
2014-03-26 01:30:36.399176	15646	18.9	1	1
2014-03-26 01:30:36.628077	15647	49	2	1
2014-03-26 22:01:54.705866	31813	24.3	1	10
2014-03-26 22:01:54.931326	31814	41	2	10
2014-03-26 01:31:00.169245	15652	20.9	1	8
2014-03-26 01:31:00.402944	15653	52	2	8
2014-03-26 01:31:15.396737	15654	18.9	1	1
2014-03-26 01:31:15.619751	15655	49	2	1
2014-03-26 01:31:32.691733	15656	305	3	2
2014-03-26 22:02:05.04661	31815	22.2	1	9
2014-03-26 22:02:05.283384	31816	48	2	9
2014-03-26 01:31:39.170392	15661	20.9	1	8
2014-03-26 01:31:39.393183	15662	52	2	8
2014-03-26 01:31:54.439124	15663	18.9	1	1
2014-03-26 01:31:54.660695	15664	49	2	1
2014-03-26 01:31:56.68755	15665	354	3	2
2014-03-26 01:32:08.688681	15666	354	3	2
2014-03-26 22:02:06.136456	31817	22.1	1	8
2014-03-26 22:02:06.359023	31818	47	2	8
2014-03-26 01:32:18.169624	15671	20.9	1	8
2014-03-26 01:32:18.401347	15672	52	2	8
2014-03-26 01:32:32.68587	15673	354	3	2
2014-03-26 01:32:33.394944	15674	18.9	1	1
2014-03-26 01:32:33.618838	15675	49	2	1
2014-03-26 22:02:08.564023	31819	547	3	2
2014-03-26 22:02:08.79992	31820	1088320.245365858	4	2
2014-03-26 01:32:57.169397	15680	20.9	1	8
2014-03-26 01:32:57.39038	15681	52	2	8
2014-03-26 01:33:12.396088	15682	18.9	1	1
2014-03-26 01:33:12.629418	15683	49	2	1
2014-03-26 01:33:32.687754	15684	354	3	2
2014-03-26 22:02:20.932735	31821	20.3	1	1
2014-03-26 22:02:21.157484	31822	50	2	1
2014-03-26 01:33:36.170596	15689	20.9	1	8
2014-03-26 01:33:36.3973	15690	52	2	8
2014-03-26 01:33:51.395999	15691	18.9	1	1
2014-03-26 01:33:51.618965	15692	49	2	1
2014-03-26 22:02:32.556579	31823	515	3	2
2014-03-26 22:02:32.795809	31824	1088323.6924700222	4	2
2014-03-26 01:34:15.169696	15697	20.9	1	8
2014-03-26 01:34:15.398908	15698	52	2	8
2014-03-26 01:34:30.394612	15699	18.9	1	1
2014-03-26 01:34:30.616519	15700	49	2	1
2014-03-26 01:34:32.690559	15701	354	3	2
2014-03-26 22:02:33.705024	31825	24.3	1	10
2014-03-26 22:02:33.930164	31826	41	2	10
2014-03-26 01:34:54.169533	15706	20.9	1	8
2014-03-26 01:34:54.392805	15707	52	2	8
2014-03-26 01:35:09.395218	15708	18.9	1	1
2014-03-26 01:35:09.627737	15709	49	2	1
2014-03-26 22:02:44.04735	31827	22.2	1	9
2014-03-26 22:02:44.283301	31828	48	2	9
2014-03-26 01:35:32.685776	15714	338	3	2
2014-03-26 01:35:33.171193	15715	20.9	1	8
2014-03-26 01:35:33.393108	15716	52	2	8
2014-03-26 01:35:48.395063	15717	18.9	1	1
2014-03-26 01:35:48.61723	15718	49	2	1
2014-03-26 22:02:44.612452	31829	595	3	2
2014-03-26 22:02:44.838877	31830	1088325.990539465	4	2
2014-03-26 01:36:12.170123	15723	20.9	1	8
2014-03-26 01:36:12.403711	15724	52	2	8
2014-03-26 01:36:27.398218	15725	18.9	1	1
2014-03-26 01:36:27.620336	15726	49	2	1
2014-03-26 01:36:32.684151	15727	354	3	2
2014-03-26 22:02:45.147164	31831	22.1	1	8
2014-03-26 22:02:45.381254	31832	47	2	8
2014-03-26 01:36:51.169938	15732	20.9	1	8
2014-03-26 01:36:51.393162	15733	52	2	8
2014-03-26 01:36:56.688623	15734	305	3	2
2014-03-26 01:37:06.397572	15735	18.9	1	1
2014-03-26 01:37:06.619766	15736	49	2	1
2014-03-26 01:37:08.686422	15737	289	3	2
2014-03-26 22:02:56.559599	31833	579	3	2
2014-03-26 22:02:56.784884	31834	1088327.1395741864	4	2
2014-03-26 01:37:30.168203	15742	20.9	1	8
2014-03-26 01:37:30.390133	15743	51	2	8
2014-03-26 01:37:32.685991	15744	305	3	2
2014-03-26 01:37:45.39821	15745	18.9	1	1
2014-03-26 01:37:45.626991	15746	49	2	1
2014-03-26 22:02:59.693566	31835	20.3	1	1
2014-03-26 22:02:59.927919	31836	50	2	1
2014-03-26 01:38:09.170082	15751	20.9	1	8
2014-03-26 01:38:09.392109	15752	51	2	8
2014-03-26 01:38:24.393467	15753	18.9	1	1
2014-03-26 01:38:24.617084	15754	49	2	1
2014-03-26 01:38:32.692228	15755	305	3	2
2014-03-26 22:03:08.557522	31837	611	3	2
2014-03-26 22:03:08.781572	31838	1088329.4376436293	4	2
2014-03-26 01:38:48.169459	15760	20.9	1	8
2014-03-26 01:38:48.390064	15761	52	2	8
2014-03-26 01:39:03.392921	15762	18.9	1	1
2014-03-26 01:39:03.615594	15763	49	2	1
2014-03-26 22:03:12.706293	31839	24.3	1	10
2014-03-26 01:39:27.172882	15768	20.9	1	8
2014-03-26 01:39:27.394586	15769	51	2	8
2014-03-26 01:39:32.68976	15770	305	3	2
2014-03-26 01:39:42.394185	15771	18.9	1	1
2014-03-26 01:39:42.616923	15772	49	2	1
2014-03-26 01:30:58.055021	15648	22.0	1	10
2014-03-26 01:30:58.299062	15649	48	2	10
2014-03-26 01:31:37.05865	15657	22.0	1	10
2014-03-26 01:31:37.281352	15658	48	2	10
2014-03-26 01:32:16.055424	15667	22.0	1	10
2014-03-26 01:32:16.287059	15668	48	2	10
2014-03-26 01:32:55.055378	15676	22.0	1	10
2014-03-26 01:32:55.280051	15677	48	2	10
2014-03-26 01:33:34.05462	15685	22.0	1	10
2014-03-26 01:33:34.276154	15686	48	2	10
2014-03-26 01:34:13.056128	15693	22.0	1	10
2014-03-26 01:34:13.298186	15694	48	2	10
2014-03-26 01:34:52.060056	15702	22.0	1	10
2014-03-26 01:34:52.283141	15703	48	2	10
2014-03-26 01:35:31.055478	15710	22.0	1	10
2014-03-26 01:35:31.335383	15711	48	2	10
2014-03-26 01:36:10.055898	15719	21.9	1	10
2014-03-26 01:36:10.280528	15720	48	2	10
2014-03-26 01:36:49.056687	15728	21.9	1	10
2014-03-26 01:36:49.279453	15729	48	2	10
2014-03-26 01:37:28.058001	15738	21.9	1	10
2014-03-26 01:37:28.279861	15739	48	2	10
2014-03-26 01:38:07.057922	15747	21.9	1	10
2014-03-26 01:38:07.278846	15748	48	2	10
2014-03-26 01:38:46.05667	15756	21.9	1	10
2014-03-26 01:38:46.279369	15757	48	2	10
2014-03-26 01:39:25.058116	15764	21.9	1	10
2014-03-26 01:39:25.279054	15765	48	2	10
2014-03-26 01:40:04.060696	15773	21.9	1	10
2014-03-26 01:40:04.291897	15774	48	2	10
2014-03-26 01:40:06.169754	15777	20.9	1	8
2014-03-26 01:40:06.400645	15778	51	2	8
2014-03-26 01:40:21.543357	15779	18.9	1	1
2014-03-26 01:40:21.965391	15780	49	2	1
2014-03-26 01:40:32.686148	15781	370	3	2
2014-03-26 22:03:12.943227	31840	41	2	10
2014-03-26 22:03:20.563929	31841	595	3	2
2014-03-26 01:40:44.689205	15786	354	3	2
2014-03-26 01:40:45.17019	15787	20.9	1	8
2014-03-26 01:40:45.392127	15788	51	2	8
2014-03-26 01:41:00.391532	15789	18.9	1	1
2014-03-26 01:41:00.61284	15790	49	2	1
2014-03-26 22:03:20.788811	31842	1088331.7357130721	4	2
2014-03-26 22:03:23.046914	31843	22.1	1	9
2014-03-26 01:41:24.168913	15795	20.9	1	8
2014-03-26 01:41:24.401393	15796	51	2	8
2014-03-26 01:41:32.684999	15797	354	3	2
2014-03-26 01:41:39.392301	15798	18.9	1	1
2014-03-26 01:41:39.615033	15799	49	2	1
2014-03-26 22:03:23.288867	31844	48	2	9
2014-03-26 22:03:24.135261	31845	22.1	1	8
2014-03-26 01:42:03.169439	15804	20.9	1	8
2014-03-26 01:42:03.391619	15805	51	2	8
2014-03-26 01:42:18.391252	15806	18.9	1	1
2014-03-26 01:42:18.623051	15807	49	2	1
2014-03-26 01:42:32.684979	15808	370	3	2
2014-03-26 22:03:24.357764	31846	47	2	8
2014-03-26 22:03:32.561188	31847	579	3	2
2014-03-26 01:42:42.170068	15813	20.9	1	8
2014-03-26 01:42:42.390794	15814	51	2	8
2014-03-26 01:42:57.430584	15815	18.9	1	1
2014-03-26 01:42:57.655587	15816	49	2	1
2014-03-26 22:03:32.797761	31848	1088334.033782515	4	2
2014-03-26 22:03:38.695586	31849	20.3	1	1
2014-03-26 01:43:21.170228	15821	20.9	1	8
2014-03-26 01:43:21.403015	15822	51	2	8
2014-03-26 01:43:32.688512	15823	370	3	2
2014-03-26 01:43:36.38898	15824	18.9	1	1
2014-03-26 01:43:36.638746	15825	49	2	1
2014-03-26 22:03:38.92218	31850	50	2	1
2014-03-26 22:03:44.559931	31851	643	3	2
2014-03-26 01:44:00.183518	15830	20.9	1	8
2014-03-26 01:44:00.407121	15831	51	2	8
2014-03-26 01:44:15.39205	15832	18.9	1	1
2014-03-26 01:44:15.623917	15833	49	2	1
2014-03-26 01:44:32.686282	15834	354	3	2
2014-03-26 22:03:44.795091	31852	1088336.3318519578	4	2
2014-03-26 22:03:51.704944	31853	24.3	1	10
2014-03-26 01:44:39.169331	15839	20.9	1	8
2014-03-26 01:44:39.399378	15840	51	2	8
2014-03-26 01:44:44.687661	15841	418	3	2
2014-03-26 01:44:54.388628	15842	18.9	1	1
2014-03-26 01:44:54.612184	15843	49	2	1
2014-03-26 01:44:56.685591	15844	418	3	2
2014-03-26 22:03:51.930746	31854	41	2	10
2014-03-26 22:03:56.560834	31855	643	3	2
2014-03-26 01:45:18.169032	15849	20.9	1	8
2014-03-26 01:45:18.391787	15850	51	2	8
2014-03-26 01:45:32.687983	15851	418	3	2
2014-03-26 01:45:33.392706	15852	18.9	1	1
2014-03-26 01:45:33.615356	15853	49	2	1
2014-03-26 22:03:56.795	31856	1088337.4808866794	4	2
2014-03-26 22:04:02.050057	31857	22.1	1	9
2014-03-26 01:45:57.170654	15858	20.9	1	8
2014-03-26 01:45:57.402819	15859	51	2	8
2014-03-26 01:46:12.632307	15860	18.9	1	1
2014-03-26 01:46:12.856827	15861	49	2	1
2014-03-26 01:46:32.68935	15862	418	3	2
2014-03-26 22:04:02.279669	31858	48	2	9
2014-03-26 22:04:03.136035	31859	22.1	1	8
2014-03-26 01:46:36.174212	15867	20.9	1	8
2014-03-26 01:46:36.397465	15868	51	2	8
2014-03-26 01:46:51.387059	15869	18.9	1	1
2014-03-26 01:46:51.610265	15870	49	2	1
2014-03-26 22:04:03.368597	31860	47	2	8
2014-03-26 22:04:08.562049	31861	820	3	2
2014-03-26 01:47:15.169422	15875	20.9	1	8
2014-03-26 01:47:15.393205	15876	51	2	8
2014-03-26 01:47:30.389011	15877	18.9	1	1
2014-03-26 01:47:30.621218	15878	49	2	1
2014-03-26 01:47:32.684917	15879	402	3	2
2014-03-26 22:04:08.786918	31862	1088340.9279908435	4	2
2014-03-26 22:04:17.695695	31863	20.3	1	1
2014-03-26 01:47:54.168432	15884	20.9	1	8
2014-03-26 01:47:54.391048	15885	51	2	8
2014-03-26 01:48:09.386912	15886	18.9	1	1
2014-03-26 01:48:09.61145	15887	49	2	1
2014-03-26 22:04:17.929555	31864	50	2	1
2014-03-26 22:04:20.559842	31865	643	3	2
2014-03-26 01:48:32.684517	15892	402	3	2
2014-03-26 01:48:33.168876	15893	20.9	1	8
2014-03-26 01:48:33.400546	15894	51	2	8
2014-03-26 01:48:48.388184	15895	18.9	1	1
2014-03-26 01:48:48.612841	15896	49	2	1
2014-03-26 22:04:20.784655	31866	1088343.2260602864	4	2
2014-03-26 22:04:30.705296	31867	24.3	1	10
2014-03-26 01:49:12.168689	15901	20.9	1	8
2014-03-26 01:49:12.400145	15902	51	2	8
2014-03-26 01:49:27.384983	15903	18.9	1	1
2014-03-26 01:49:27.607323	15904	49	2	1
2014-03-26 01:49:32.684112	15905	402	3	2
2014-03-26 22:04:30.93937	31868	41	2	10
2014-03-26 01:49:51.169789	15910	20.9	1	8
2014-03-26 01:49:51.390535	15911	51	2	8
2014-03-26 01:50:06.389134	15912	18.9	1	1
2014-03-26 01:40:43.06128	15782	21.9	1	10
2014-03-26 01:40:43.28453	15783	48	2	10
2014-03-26 01:41:22.059164	15791	21.9	1	10
2014-03-26 01:41:22.291593	15792	48	2	10
2014-03-26 01:42:01.059438	15800	21.9	1	10
2014-03-26 01:42:01.284497	15801	48	2	10
2014-03-26 01:42:40.059472	15809	21.9	1	10
2014-03-26 01:42:40.28489	15810	48	2	10
2014-03-26 01:43:19.05975	15817	21.9	1	10
2014-03-26 01:43:19.292039	15818	48	2	10
2014-03-26 01:43:58.059757	15826	21.9	1	10
2014-03-26 01:43:58.28213	15827	48	2	10
2014-03-26 01:44:37.063648	15835	21.9	1	10
2014-03-26 01:44:37.286497	15836	48	2	10
2014-03-26 01:45:16.059253	15845	21.9	1	10
2014-03-26 01:45:16.281727	15846	48	2	10
2014-03-26 01:45:55.062045	15854	21.9	1	10
2014-03-26 01:45:55.293321	15855	48	2	10
2014-03-26 01:46:34.060279	15863	21.9	1	10
2014-03-26 01:46:34.284615	15864	48	2	10
2014-03-26 01:47:13.059272	15871	21.9	1	10
2014-03-26 01:47:13.28479	15872	48	2	10
2014-03-26 01:47:52.062458	15880	21.9	1	10
2014-03-26 01:47:52.286936	15881	48	2	10
2014-03-26 01:48:31.061761	15888	21.9	1	10
2014-03-26 01:48:31.283395	15889	48	2	10
2014-03-26 01:49:10.060891	15897	21.9	1	10
2014-03-26 01:49:10.293668	15898	48	2	10
2014-03-26 01:50:06.620817	15913	49	2	1
2014-03-26 01:50:20.686274	15914	354	3	2
2014-03-26 22:04:32.55821	31869	595	3	2
2014-03-26 22:04:32.7826	31870	1088345.5241297293	4	2
2014-03-26 01:50:30.295484	15919	20.9	1	8
2014-03-26 01:50:30.734957	15920	51	2	8
2014-03-26 01:50:32.810938	15921	354	3	2
2014-03-26 01:50:45.383801	15922	18.9	1	1
2014-03-26 01:50:45.60606	15923	49	2	1
2014-03-26 22:04:41.04664	31871	22.1	1	9
2014-03-26 22:04:41.283413	31872	48	2	9
2014-03-26 01:51:09.168236	15928	20.9	1	8
2014-03-26 01:51:09.391616	15929	51	2	8
2014-03-26 01:51:24.388147	15930	18.9	1	1
2014-03-26 01:51:24.610721	15931	49	2	1
2014-03-26 01:51:32.683668	15932	354	3	2
2014-03-26 22:04:42.138276	31873	22.0	1	8
2014-03-26 22:04:42.361194	31874	47	2	8
2014-03-26 01:51:48.171694	15937	20.9	1	8
2014-03-26 01:51:48.394232	15938	51	2	8
2014-03-26 01:52:03.385656	15939	18.9	1	1
2014-03-26 01:52:03.618571	15940	49	2	1
2014-03-26 22:04:44.561167	31875	595	3	2
2014-03-26 22:04:44.795715	31876	1088347.822199172	4	2
2014-03-26 01:52:27.168328	15945	20.9	1	8
2014-03-26 01:52:27.393115	15946	51	2	8
2014-03-26 01:52:32.688711	15947	354	3	2
2014-03-26 01:52:42.387989	15948	18.9	1	1
2014-03-26 01:52:42.613247	15949	49	2	1
2014-03-26 22:04:56.932744	31877	20.3	1	1
2014-03-26 22:04:57.157841	31878	50	2	1
2014-03-26 01:53:06.169785	15954	20.9	1	8
2014-03-26 01:53:06.40363	15955	51	2	8
2014-03-26 01:53:21.385313	15956	18.9	1	1
2014-03-26 01:53:21.61063	15957	49	2	1
2014-03-26 01:53:32.685805	15958	354	3	2
2014-03-26 22:05:08.556705	31879	643	3	2
2014-03-26 22:05:08.792523	31880	1088351.2693033363	4	2
2014-03-26 01:53:45.167499	15963	20.9	1	8
2014-03-26 01:53:45.389159	15964	51	2	8
2014-03-26 01:54:00.437384	15965	18.9	1	1
2014-03-26 01:54:00.670215	15966	49	2	1
2014-03-26 22:05:09.705867	31881	24.3	1	10
2014-03-26 22:05:09.929988	31882	41	2	10
2014-03-26 01:54:24.169429	15971	20.9	1	8
2014-03-26 01:54:24.389795	15972	51	2	8
2014-03-26 01:54:32.688209	15973	354	3	2
2014-03-26 01:54:39.385846	15974	18.9	1	1
2014-03-26 01:54:39.608663	15975	49	2	1
2014-03-26 22:05:20.04729	31883	22.1	1	9
2014-03-26 22:05:20.340049	31884	48	2	9
2014-03-26 01:55:03.169529	15980	20.9	1	8
2014-03-26 01:55:03.39905	15981	51	2	8
2014-03-26 01:55:18.382883	15982	18.9	1	1
2014-03-26 01:55:18.604849	15983	49	2	1
2014-03-26 01:55:32.688029	15984	289	3	2
2014-03-26 22:05:20.670157	31885	643	3	2
2014-03-26 22:05:20.897654	31886	1088353.5673727791	4	2
2014-03-26 01:55:42.169502	15989	20.9	1	8
2014-03-26 01:55:42.391121	15990	51	2	8
2014-03-26 01:55:44.685674	15991	289	3	2
2014-03-26 01:55:57.382102	15992	18.9	1	1
2014-03-26 01:55:57.605024	15993	49	2	1
2014-03-26 22:05:21.207874	31887	22.0	1	8
2014-03-26 22:05:21.44412	31888	47	2	8
2014-03-26 01:56:21.169577	15998	20.9	1	8
2014-03-26 01:56:21.39995	15999	51	2	8
2014-03-26 01:56:32.688848	16000	289	3	2
2014-03-26 01:56:36.383714	16001	18.9	1	1
2014-03-26 01:56:36.605789	16002	49	2	1
2014-03-26 22:05:32.560305	31889	643	3	2
2014-03-26 22:05:32.785949	31890	1088355.865442222	4	2
2014-03-26 01:57:00.170477	16007	20.9	1	8
2014-03-26 01:57:00.423435	16008	51	2	8
2014-03-26 01:57:15.384862	16009	18.9	1	1
2014-03-26 01:57:15.620467	16010	49	2	1
2014-03-26 01:57:32.687934	16011	305	3	2
2014-03-26 22:05:35.69001	31891	20.3	1	1
2014-03-26 22:05:35.936473	31892	50	2	1
2014-03-26 01:57:39.168893	16016	20.9	1	8
2014-03-26 01:57:39.393644	16017	51	2	8
2014-03-26 01:57:54.384458	16018	18.9	1	1
2014-03-26 01:57:54.607892	16019	49	2	1
2014-03-26 01:58:08.684416	16020	354	3	2
2014-03-26 22:05:48.705036	31893	24.3	1	10
2014-03-26 22:05:48.929741	31894	41	2	10
2014-03-26 01:58:18.169241	16025	20.9	1	8
2014-03-26 01:58:18.405231	16026	51	2	8
2014-03-26 01:58:20.684283	16027	354	3	2
2014-03-26 01:58:32.684809	16028	354	3	2
2014-03-26 01:58:33.379672	16029	18.9	1	1
2014-03-26 01:58:33.613498	16030	49	2	1
2014-03-26 22:05:59.0468	31895	22.2	1	9
2014-03-26 22:05:59.286098	31896	48	2	9
2014-03-26 01:58:57.168523	16035	20.9	1	8
2014-03-26 01:58:57.390521	16036	51	2	8
2014-03-26 01:59:12.381739	16037	18.9	1	1
2014-03-26 01:59:12.616057	16038	49	2	1
2014-03-26 01:59:32.688862	16039	354	3	2
2014-03-26 22:06:00.136719	31897	22.0	1	8
2014-03-26 22:06:00.362233	31898	47	2	8
2014-03-26 01:59:36.169787	16044	20.9	1	8
2014-03-26 01:59:36.391071	16045	51	2	8
2014-03-26 01:59:51.38369	16046	18.9	1	1
2014-03-26 01:59:51.605179	16047	49	2	1
2014-03-26 01:50:28.185548	15915	21.9	1	10
2014-03-26 01:50:28.659748	15916	48	2	10
2014-03-26 01:51:07.063496	15924	21.8	1	10
2014-03-26 01:51:07.286773	15925	48	2	10
2014-03-26 01:51:46.061613	15933	21.8	1	10
2014-03-26 01:51:46.287485	15934	48	2	10
2014-03-26 01:52:25.061505	15941	21.8	1	10
2014-03-26 01:52:25.284383	15942	48	2	10
2014-03-26 01:53:04.061701	15950	21.8	1	10
2014-03-26 01:53:04.293724	15951	48	2	10
2014-03-26 01:53:43.062639	15959	21.8	1	10
2014-03-26 01:53:43.2846	15960	48	2	10
2014-03-26 01:54:22.063975	15967	21.8	1	10
2014-03-26 01:54:22.285852	15968	48	2	10
2014-03-26 01:55:01.062268	15976	21.8	1	10
2014-03-26 01:55:01.294147	15977	48	2	10
2014-03-26 01:55:40.062938	15985	21.8	1	10
2014-03-26 01:55:40.284105	15986	48	2	10
2014-03-26 01:56:19.07257	15994	21.8	1	10
2014-03-26 01:56:19.295137	15995	48	2	10
2014-03-26 01:56:58.063938	16003	21.8	1	10
2014-03-26 01:56:58.288875	16004	48	2	10
2014-03-26 01:57:37.067735	16012	21.8	1	10
2014-03-26 01:57:37.303344	16013	48	2	10
2014-03-26 01:58:16.063167	16021	21.8	1	10
2014-03-26 01:58:16.296066	16022	48	2	10
2014-03-26 01:58:55.063839	16031	21.8	1	10
2014-03-26 01:58:55.285631	16032	48	2	10
2014-03-26 22:06:14.692864	31899	20.3	1	1
2014-03-26 22:06:14.927973	31900	50	2	1
2014-03-26 02:00:15.169152	16052	20.9	1	8
2014-03-26 02:00:15.390844	16053	51	2	8
2014-03-26 02:00:30.379692	16054	18.9	1	1
2014-03-26 02:00:30.603058	16055	49	2	1
2014-03-26 02:00:32.682777	16056	354	3	2
2014-03-26 22:06:27.70496	31901	24.3	1	10
2014-03-26 22:06:27.929585	31902	41	2	10
2014-03-26 02:00:54.169034	16061	20.9	1	8
2014-03-26 02:00:54.390478	16062	51	2	8
2014-03-26 02:01:09.380453	16063	18.9	1	1
2014-03-26 02:01:09.613415	16064	49	2	1
2014-03-26 22:06:32.559117	31903	643	3	2
2014-03-26 22:06:32.796018	31904	1088366.2067547147	4	2
2014-03-26 02:01:32.68565	16069	354	3	2
2014-03-26 02:01:33.169175	16070	20.9	1	8
2014-03-26 02:01:33.391418	16071	51	2	8
2014-03-26 02:01:48.382549	16072	18.9	1	1
2014-03-26 02:01:48.60455	16073	49	2	1
2014-03-26 22:06:38.045726	31905	22.2	1	9
2014-03-26 22:06:38.275419	31906	48	2	9
2014-03-26 02:02:12.171219	16078	20.9	1	8
2014-03-26 02:02:12.402122	16079	51	2	8
2014-03-26 02:02:27.379518	16080	18.9	1	1
2014-03-26 02:02:27.603204	16081	49	2	1
2014-03-26 02:02:32.685041	16082	354	3	2
2014-03-26 02:02:44.685912	16083	305	3	2
2014-03-26 22:06:39.136086	31907	22.0	1	8
2014-03-26 22:06:39.368425	31908	47	2	8
2014-03-26 02:02:51.168153	16088	20.9	1	8
2014-03-26 02:02:51.392478	16089	51	2	8
2014-03-26 02:02:56.68394	16090	305	3	2
2014-03-26 02:03:06.380194	16091	18.9	1	1
2014-03-26 02:03:06.603575	16092	49	2	1
2014-03-26 22:06:53.69006	31909	20.3	1	1
2014-03-26 22:06:53.916344	31910	50	2	1
2014-03-26 02:03:30.167978	16097	20.8	1	8
2014-03-26 02:03:30.413028	16098	51	2	8
2014-03-26 02:03:32.689294	16099	305	3	2
2014-03-26 02:03:45.383081	16100	18.9	1	1
2014-03-26 02:03:45.605205	16101	49	2	1
2014-03-26 22:07:06.707767	31911	24.3	1	10
2014-03-26 22:07:06.942402	31912	41	2	10
2014-03-26 02:04:09.16955	16106	20.8	1	8
2014-03-26 02:04:09.392589	16107	51	2	8
2014-03-26 02:04:24.377478	16108	18.9	1	1
2014-03-26 02:04:24.601251	16109	49	2	1
2014-03-26 02:04:32.682639	16110	305	3	2
2014-03-26 22:07:17.048203	31913	22.2	1	9
2014-03-26 22:07:17.273436	31914	48	2	9
2014-03-26 02:04:48.169923	16115	20.8	1	8
2014-03-26 02:04:48.403085	16116	51	2	8
2014-03-26 02:05:03.379823	16117	18.9	1	1
2014-03-26 02:05:03.603059	16118	49	2	1
2014-03-26 22:07:18.138322	31915	22.0	1	8
2014-03-26 22:07:18.371549	31916	47	2	8
2014-03-26 02:05:27.1698	16123	20.8	1	8
2014-03-26 02:05:27.399635	16124	51	2	8
2014-03-26 02:05:32.686422	16125	305	3	2
2014-03-26 02:05:42.37812	16126	18.9	1	1
2014-03-26 02:05:42.602345	16127	49	2	1
2014-03-26 22:07:32.930137	31917	20.3	1	1
2014-03-26 22:07:33.153191	31918	50	2	1
2014-03-26 02:06:06.170127	16132	20.8	1	8
2014-03-26 02:06:06.396885	16133	51	2	8
2014-03-26 02:06:21.380257	16134	18.9	1	1
2014-03-26 02:06:21.612526	16135	49	2	1
2014-03-26 02:06:32.684982	16136	305	3	2
2014-03-26 22:07:45.707256	31919	24.3	1	10
2014-03-26 22:07:45.946831	31920	41	2	10
2014-03-26 02:06:45.17046	16141	20.8	1	8
2014-03-26 02:06:45.413818	16142	51	2	8
2014-03-26 02:07:00.374793	16143	18.9	1	1
2014-03-26 02:07:00.596021	16144	49	2	1
2014-03-26 22:07:56.046036	31921	22.2	1	9
2014-03-26 22:07:56.270391	31922	48	2	9
2014-03-26 02:07:24.169553	16149	20.8	1	8
2014-03-26 02:07:24.432415	16150	51	2	8
2014-03-26 02:07:39.18109	16151	305	3	2
2014-03-26 02:07:39.489014	16152	18.8	1	1
2014-03-26 02:07:39.711086	16153	49	2	1
2014-03-26 22:07:57.135592	31923	22.0	1	8
2014-03-26 22:07:57.368188	31924	47	2	8
2014-03-26 02:08:03.170403	16158	20.8	1	8
2014-03-26 02:08:03.39163	16159	51	2	8
2014-03-26 02:08:18.377635	16160	18.8	1	1
2014-03-26 02:08:18.60985	16161	49	2	1
2014-03-26 02:08:32.682747	16162	305	3	2
2014-03-26 22:08:11.691052	31925	20.3	1	1
2014-03-26 22:08:11.918298	31926	50	2	1
2014-03-26 02:08:42.168948	16167	20.8	1	8
2014-03-26 02:08:42.401168	16168	51	2	8
2014-03-26 02:08:57.37436	16169	18.8	1	1
2014-03-26 02:08:57.598471	16170	49	2	1
2014-03-26 22:08:24.706667	31927	24.4	1	10
2014-03-26 22:08:24.94335	31928	41	2	10
2014-03-26 02:09:21.168857	16175	20.8	1	8
2014-03-26 02:09:21.403739	16176	51	2	8
2014-03-26 02:09:32.687963	16177	305	3	2
2014-03-26 02:09:36.374229	16178	18.8	1	1
2014-03-26 02:09:36.598538	16179	49	2	1
2014-03-26 02:10:00.171464	16184	20.8	1	8
2014-03-26 02:00:13.288629	16049	48	2	10
2014-03-26 02:00:52.192214	16057	21.8	1	10
2014-03-26 02:00:52.533589	16058	48	2	10
2014-03-26 02:01:31.06463	16065	21.8	1	10
2014-03-26 02:01:31.288597	16066	48	2	10
2014-03-26 02:02:10.065941	16074	21.8	1	10
2014-03-26 02:02:10.299692	16075	48	2	10
2014-03-26 02:02:49.065751	16084	21.8	1	10
2014-03-26 02:02:49.2894	16085	48	2	10
2014-03-26 02:03:28.065756	16093	21.8	1	10
2014-03-26 02:03:28.297587	16094	48	2	10
2014-03-26 02:04:07.065913	16102	21.8	1	10
2014-03-26 02:04:07.287642	16103	48	2	10
2014-03-26 02:04:46.065882	16111	21.8	1	10
2014-03-26 02:04:46.28699	16112	48	2	10
2014-03-26 02:05:25.067297	16119	21.8	1	10
2014-03-26 02:05:25.307102	16120	48	2	10
2014-03-26 02:06:04.065296	16128	21.8	1	10
2014-03-26 02:06:04.289061	16129	48	2	10
2014-03-26 02:06:43.065698	16137	21.7	1	10
2014-03-26 02:06:43.28899	16138	48	2	10
2014-03-26 02:07:22.067532	16145	21.7	1	10
2014-03-26 02:07:22.334237	16146	48	2	10
2014-03-26 02:08:01.067866	16154	21.7	1	10
2014-03-26 02:08:01.293196	16155	48	2	10
2014-03-26 02:08:40.067357	16163	21.7	1	10
2014-03-26 02:08:40.292586	16164	48	2	10
2014-03-26 02:09:19.067618	16171	21.7	1	10
2014-03-26 02:09:19.30047	16172	48	2	10
2014-03-26 02:09:58.067798	16180	21.7	1	10
2014-03-26 02:10:00.392784	16185	51	2	8
2014-03-26 02:10:15.415499	16186	18.8	1	1
2014-03-26 02:10:15.660001	16187	49	2	1
2014-03-26 02:10:20.689851	16188	354	3	2
2014-03-26 02:10:32.687556	16189	354	3	2
2014-03-26 22:08:32.558097	31929	627	3	2
2014-03-26 22:08:32.784499	31930	1088388.0384144215	4	2
2014-03-26 02:10:39.169351	16194	20.8	1	8
2014-03-26 02:10:39.402455	16195	51	2	8
2014-03-26 02:10:54.500195	16196	18.8	1	1
2014-03-26 02:10:54.920082	16197	49	2	1
2014-03-26 22:08:35.050698	31931	22.2	1	9
2014-03-26 22:08:35.285054	31932	48	2	9
2014-03-26 02:11:18.16972	16202	20.8	1	8
2014-03-26 02:11:18.401575	16203	51	2	8
2014-03-26 02:11:33.1768	16204	354	3	2
2014-03-26 02:11:33.485011	16205	18.8	1	1
2014-03-26 02:11:33.706994	16206	49	2	1
2014-03-26 22:08:36.13557	31933	22.0	1	8
2014-03-26 22:08:36.358671	31934	47	2	8
2014-03-26 02:11:57.169505	16211	20.8	1	8
2014-03-26 02:11:57.391429	16212	51	2	8
2014-03-26 02:12:12.370719	16213	18.8	1	1
2014-03-26 02:12:12.603013	16214	49	2	1
2014-03-26 02:12:32.685923	16215	354	3	2
2014-03-26 22:08:50.689396	31935	20.3	1	1
2014-03-26 22:08:50.926409	31936	50	2	1
2014-03-26 02:12:36.169155	16220	20.8	1	8
2014-03-26 02:12:36.391606	16221	51	2	8
2014-03-26 02:12:51.375742	16222	18.8	1	1
2014-03-26 02:12:51.59797	16223	49	2	1
2014-03-26 22:09:03.706573	31937	24.4	1	10
2014-03-26 22:09:03.933639	31938	41	2	10
2014-03-26 02:13:15.171907	16228	20.8	1	8
2014-03-26 02:13:15.403649	16229	51	2	8
2014-03-26 02:13:30.372444	16230	18.8	1	1
2014-03-26 02:13:30.596035	16231	49	2	1
2014-03-26 02:13:32.68415	16232	354	3	2
2014-03-26 22:09:14.048752	31939	22.2	1	9
2014-03-26 22:09:14.294759	31940	48	2	9
2014-03-26 02:13:54.169263	16237	20.8	1	8
2014-03-26 02:13:54.392832	16238	51	2	8
2014-03-26 02:14:09.377179	16239	18.8	1	1
2014-03-26 02:14:09.609963	16240	49	2	1
2014-03-26 22:09:15.1343	31941	22.0	1	8
2014-03-26 22:09:15.358691	31942	47	2	8
2014-03-26 02:14:32.683004	16245	354	3	2
2014-03-26 02:14:33.169027	16246	20.8	1	8
2014-03-26 02:14:33.392373	16247	51	2	8
2014-03-26 02:14:48.372611	16248	18.8	1	1
2014-03-26 02:14:48.596992	16249	49	2	1
2014-03-26 02:14:56.68039	16250	305	3	2
2014-03-26 02:15:08.683475	16251	289	3	2
2014-03-26 22:09:29.687161	31943	20.3	1	1
2014-03-26 22:09:29.978883	31944	50	2	1
2014-03-26 02:15:12.169133	16256	20.8	1	8
2014-03-26 02:15:12.39015	16257	51	2	8
2014-03-26 02:15:27.375225	16258	18.8	1	1
2014-03-26 02:15:27.607292	16259	49	2	1
2014-03-26 02:15:32.703793	16260	289	3	2
2014-03-26 22:09:32.562171	31945	643	3	2
2014-03-26 22:09:32.785666	31946	1088398.3797269142	4	2
2014-03-26 02:15:51.168689	16265	20.8	1	8
2014-03-26 02:15:51.391204	16266	51	2	8
2014-03-26 02:16:06.373387	16267	18.8	1	1
2014-03-26 02:16:06.60376	16268	49	2	1
2014-03-26 22:09:42.70632	31947	24.4	1	10
2014-03-26 22:09:42.94177	31948	41	2	10
2014-03-26 02:16:30.169492	16273	20.8	1	8
2014-03-26 02:16:30.400524	16274	51	2	8
2014-03-26 02:16:32.728776	16275	289	3	2
2014-03-26 02:16:45.369782	16276	18.8	1	1
2014-03-26 02:16:45.5934	16277	49	2	1
2014-03-26 22:09:53.048974	31949	22.2	1	9
2014-03-26 22:09:53.27465	31950	48	2	9
2014-03-26 02:17:09.169395	16282	20.8	1	8
2014-03-26 02:17:09.391003	16283	51	2	8
2014-03-26 02:17:24.366793	16284	18.8	1	1
2014-03-26 02:17:24.600946	16285	49	2	1
2014-03-26 02:17:32.736371	16286	305	3	2
2014-03-26 22:09:54.137441	31951	22.0	1	8
2014-03-26 22:09:54.370033	31952	47	2	8
2014-03-26 02:17:48.169305	16291	20.8	1	8
2014-03-26 02:17:48.399569	16292	51	2	8
2014-03-26 02:18:03.370593	16293	18.8	1	1
2014-03-26 02:18:03.593157	16294	49	2	1
2014-03-26 22:10:08.692146	31953	20.3	1	1
2014-03-26 22:10:08.917628	31954	50	2	1
2014-03-26 02:18:27.170956	16299	20.8	1	8
2014-03-26 02:18:27.402048	16300	51	2	8
2014-03-26 02:18:32.738221	16301	305	3	2
2014-03-26 02:18:42.370221	16302	18.8	1	1
2014-03-26 02:18:42.593995	16303	49	2	1
2014-03-26 22:10:21.706584	31955	24.4	1	10
2014-03-26 22:10:21.942999	31956	41	2	10
2014-03-26 02:19:06.169785	16308	20.8	1	8
2014-03-26 02:19:06.418484	16309	51	2	8
2014-03-26 02:19:21.374541	16310	18.8	1	1
2014-03-26 02:19:21.597014	16311	49	2	1
2014-03-26 02:19:32.735841	16312	305	3	2
2014-03-26 22:10:32.046147	31957	22.2	1	9
2014-03-26 02:19:45.167631	16317	20.8	1	8
2014-03-26 02:19:45.391386	16318	51	2	8
2014-03-26 02:20:00.370118	16319	18.8	1	1
2014-03-26 02:20:00.606194	16320	49	2	1
2014-03-26 02:10:37.068649	16190	21.7	1	10
2014-03-26 02:10:37.301572	16191	48	2	10
2014-03-26 02:11:16.067615	16198	21.7	1	10
2014-03-26 02:11:16.303203	16199	48	2	10
2014-03-26 02:11:55.067243	16207	21.7	1	10
2014-03-26 02:11:55.289466	16208	48	2	10
2014-03-26 02:12:34.070004	16216	21.7	1	10
2014-03-26 02:12:34.293435	16217	48	2	10
2014-03-26 02:13:13.069465	16224	21.7	1	10
2014-03-26 02:13:13.302932	16225	48	2	10
2014-03-26 02:13:52.06954	16233	21.7	1	10
2014-03-26 02:13:52.29523	16234	48	2	10
2014-03-26 02:14:31.069474	16241	21.7	1	10
2014-03-26 02:14:31.292328	16242	48	2	10
2014-03-26 02:15:10.069097	16252	21.7	1	10
2014-03-26 02:15:10.291716	16253	48	2	10
2014-03-26 02:15:49.069757	16261	21.7	1	10
2014-03-26 02:15:49.293196	16262	48	2	10
2014-03-26 02:16:28.069346	16269	21.7	1	10
2014-03-26 02:16:28.303388	16270	48	2	10
2014-03-26 02:17:07.07288	16278	21.7	1	10
2014-03-26 02:17:07.295724	16279	48	2	10
2014-03-26 02:17:46.071794	16287	21.7	1	10
2014-03-26 02:17:46.297229	16288	48	2	10
2014-03-26 02:18:25.068666	16295	21.7	1	10
2014-03-26 02:18:25.303584	16296	48	2	10
2014-03-26 02:19:04.071681	16304	21.7	1	10
2014-03-26 02:19:04.295342	16305	48	2	10
2014-03-26 22:10:32.271902	31958	48	2	9
2014-03-26 22:10:32.579743	31959	627	3	2
2014-03-26 02:20:24.169731	16325	20.8	1	8
2014-03-26 02:20:24.391772	16326	51	2	8
2014-03-26 02:20:32.720044	16327	289	3	2
2014-03-26 02:20:39.371716	16328	18.8	1	1
2014-03-26 02:20:39.594425	16329	49	2	1
2014-03-26 22:10:32.815022	31960	1088408.721039407	4	2
2014-03-26 22:10:33.136382	31961	22.0	1	8
2014-03-26 02:21:03.166388	16334	20.8	1	8
2014-03-26 02:21:03.387377	16335	51	2	8
2014-03-26 02:21:18.51005	16336	18.8	1	1
2014-03-26 02:21:18.949843	16337	49	2	1
2014-03-26 02:21:32.681696	16338	289	3	2
2014-03-26 22:10:33.361521	31962	47	2	8
2014-03-26 22:10:47.691037	31963	20.3	1	1
2014-03-26 02:21:42.167266	16343	20.8	1	8
2014-03-26 02:21:42.398564	16344	51	2	8
2014-03-26 02:21:57.365869	16345	18.8	1	1
2014-03-26 02:21:57.589093	16346	49	2	1
2014-03-26 22:10:47.924636	31964	50	2	1
2014-03-26 22:11:00.706239	31965	24.4	1	10
2014-03-26 02:22:21.16828	16351	20.8	1	8
2014-03-26 02:22:21.399588	16352	51	2	8
2014-03-26 02:22:32.68229	16353	338	3	2
2014-03-26 02:22:36.364567	16354	18.8	1	1
2014-03-26 02:22:36.586221	16355	49	2	1
2014-03-26 02:22:44.680527	16356	354	3	2
2014-03-26 22:11:00.931534	31966	41	2	10
2014-03-26 22:11:11.046143	31967	22.2	1	9
2014-03-26 02:23:00.170392	16361	20.8	1	8
2014-03-26 02:23:00.40188	16362	51	2	8
2014-03-26 02:23:15.605758	16363	18.8	1	1
2014-03-26 02:23:15.828985	16364	49	2	1
2014-03-26 02:23:32.679992	16365	338	3	2
2014-03-26 22:11:11.279797	31968	48	2	9
2014-03-26 22:11:12.13604	31969	22.0	1	8
2014-03-26 02:23:39.169145	16370	20.8	1	8
2014-03-26 02:23:39.393405	16371	51	2	8
2014-03-26 02:23:54.365329	16372	18.8	1	1
2014-03-26 02:23:54.597211	16373	49	2	1
2014-03-26 22:11:12.361375	31970	47	2	8
2014-03-26 22:11:26.689189	31971	20.3	1	1
2014-03-26 02:24:18.167848	16378	20.8	1	8
2014-03-26 02:24:18.391214	16379	51	2	8
2014-03-26 02:24:32.681828	16380	354	3	2
2014-03-26 02:24:33.371618	16381	18.8	1	1
2014-03-26 02:24:33.593734	16382	49	2	1
2014-03-26 22:11:26.925589	31972	50	2	1
2014-03-26 22:11:32.555572	31973	692	3	2
2014-03-26 02:24:57.169358	16387	20.8	1	8
2014-03-26 02:24:57.402463	16388	51	2	8
2014-03-26 02:25:12.365488	16389	18.8	1	1
2014-03-26 02:25:12.589911	16390	49	2	1
2014-03-26 02:25:32.679446	16391	338	3	2
2014-03-26 22:11:32.780319	31974	1088420.2113866212	4	2
2014-03-26 22:11:39.707086	31975	24.4	1	10
2014-03-26 02:25:36.16853	16396	20.8	1	8
2014-03-26 02:25:36.389118	16397	51	2	8
2014-03-26 02:25:51.363571	16398	18.8	1	1
2014-03-26 02:25:51.596962	16399	49	2	1
2014-03-26 22:11:39.941945	31976	41	2	10
2014-03-26 22:11:44.554565	31977	643	3	2
2014-03-26 02:26:15.168869	16404	20.8	1	8
2014-03-26 02:26:15.389531	16405	51	2	8
2014-03-26 02:26:30.363505	16406	18.8	1	1
2014-03-26 02:26:30.595731	16407	49	2	1
2014-03-26 02:26:32.683074	16408	338	3	2
2014-03-26 02:26:44.682308	16409	289	3	2
2014-03-26 22:11:44.778662	31978	1088422.5094560639	4	2
2014-03-26 22:11:50.046534	31979	22.2	1	9
2014-03-26 02:26:54.169249	16414	20.8	1	8
2014-03-26 02:26:54.390995	16415	51	2	8
2014-03-26 02:26:56.683283	16416	289	3	2
2014-03-26 02:27:09.369227	16417	18.8	1	1
2014-03-26 02:27:09.592744	16418	49	2	1
2014-03-26 22:11:50.284901	31980	48	2	9
2014-03-26 22:11:51.135335	31981	22.1	1	8
2014-03-26 02:27:32.683753	16423	305	3	2
2014-03-26 02:27:33.168721	16424	20.8	1	8
2014-03-26 02:27:33.392262	16425	51	2	8
2014-03-26 02:27:48.36424	16426	18.8	1	1
2014-03-26 02:27:48.58875	16427	49	2	1
2014-03-26 22:11:51.360579	31982	47	2	8
2014-03-26 22:11:56.561493	31983	466	3	2
2014-03-26 02:28:12.168503	16432	20.8	1	8
2014-03-26 02:28:12.389344	16433	51	2	8
2014-03-26 02:28:27.364816	16434	18.8	1	1
2014-03-26 02:28:27.596951	16435	49	2	1
2014-03-26 02:28:32.678718	16436	289	3	2
2014-03-26 22:11:56.799154	31984	1088423.6584907854	4	2
2014-03-26 22:12:05.689412	31985	20.3	1	1
2014-03-26 02:28:51.169472	16441	20.8	1	8
2014-03-26 02:28:51.400107	16442	51	2	8
2014-03-26 02:29:06.364152	16443	18.8	1	1
2014-03-26 02:29:06.593028	16444	49	2	1
2014-03-26 22:12:05.914783	31986	50	2	1
2014-03-26 22:12:08.562686	31987	354	3	2
2014-03-26 22:12:08.808776	31988	1088424.8075255067	4	2
2014-03-26 02:29:30.168123	16449	20.8	1	8
2014-03-26 02:29:30.401848	16450	51	2	8
2014-03-26 02:29:32.681285	16451	305	3	2
2014-03-26 02:29:45.365872	16452	18.8	1	1
2014-03-26 02:29:45.587608	16453	49	2	1
2014-03-26 02:20:22.07082	16321	21.7	1	10
2014-03-26 02:20:22.295132	16322	48	2	10
2014-03-26 02:21:01.070181	16330	21.7	1	10
2014-03-26 02:21:01.347063	16331	48	2	10
2014-03-26 02:21:40.070962	16339	21.7	1	10
2014-03-26 02:21:40.301702	16340	48	2	10
2014-03-26 02:22:19.07111	16347	21.7	1	10
2014-03-26 02:22:19.303418	16348	48	2	10
2014-03-26 02:22:58.07302	16357	21.6	1	10
2014-03-26 02:22:58.296519	16358	48	2	10
2014-03-26 02:23:37.070919	16366	21.6	1	10
2014-03-26 02:23:37.295028	16367	48	2	10
2014-03-26 02:24:16.071448	16374	21.6	1	10
2014-03-26 02:24:16.296944	16375	48	2	10
2014-03-26 02:24:55.07337	16383	21.6	1	10
2014-03-26 02:24:55.303443	16384	48	2	10
2014-03-26 02:25:34.071857	16392	21.6	1	10
2014-03-26 02:25:34.294014	16393	48	2	10
2014-03-26 02:26:13.071078	16400	21.6	1	10
2014-03-26 02:26:13.294591	16401	48	2	10
2014-03-26 02:26:52.072632	16410	21.6	1	10
2014-03-26 02:26:52.295702	16411	48	2	10
2014-03-26 02:27:31.072871	16419	21.6	1	10
2014-03-26 02:27:31.30636	16420	48	2	10
2014-03-26 02:28:10.072932	16428	21.6	1	10
2014-03-26 02:28:10.295331	16429	48	2	10
2014-03-26 02:28:49.074518	16437	21.6	1	10
2014-03-26 02:28:49.296554	16438	48	2	10
2014-03-26 02:29:28.07376	16445	21.6	1	10
2014-03-26 22:12:18.708644	31989	24.4	1	10
2014-03-26 02:30:09.167183	16458	20.8	1	8
2014-03-26 02:30:09.39048	16459	51	2	8
2014-03-26 02:30:24.364288	16460	18.8	1	1
2014-03-26 02:30:24.597391	16461	49	2	1
2014-03-26 02:30:32.680064	16462	289	3	2
2014-03-26 22:12:18.934769	31990	41	2	10
2014-03-26 22:12:20.617026	31991	418	3	2
2014-03-26 02:30:48.167474	16467	20.8	1	8
2014-03-26 02:30:48.399128	16468	51	2	8
2014-03-26 02:31:03.362898	16469	18.8	1	1
2014-03-26 02:31:03.587836	16470	49	2	1
2014-03-26 22:12:20.851473	31992	1088425.9565602283	4	2
2014-03-26 22:12:29.046365	31993	22.2	1	9
2014-03-26 02:31:27.294471	16475	20.8	1	8
2014-03-26 02:31:27.742173	16476	51	2	8
2014-03-26 02:31:32.80917	16477	289	3	2
2014-03-26 02:31:42.363314	16478	18.8	1	1
2014-03-26 02:31:42.64281	16479	49	2	1
2014-03-26 22:12:29.271432	31994	48	2	9
2014-03-26 22:12:30.135483	31995	22.0	1	8
2014-03-26 02:32:06.169222	16484	20.8	1	8
2014-03-26 02:32:06.594765	16485	51	2	8
2014-03-26 02:32:21.361824	16486	18.8	1	1
2014-03-26 02:32:21.618848	16487	49	2	1
2014-03-26 02:32:32.680176	16488	289	3	2
2014-03-26 22:12:30.368659	31996	47	2	8
2014-03-26 22:12:32.561119	31997	418	3	2
2014-03-26 02:32:45.168443	16493	20.8	1	8
2014-03-26 02:32:45.389575	16494	51	2	8
2014-03-26 02:33:00.367851	16495	18.8	1	1
2014-03-26 02:33:00.60343	16496	49	2	1
2014-03-26 22:12:32.786051	31998	1088428.254629671	4	2
2014-03-26 22:12:44.686423	31999	20.3	1	1
2014-03-26 02:33:24.16773	16501	20.8	1	8
2014-03-26 02:33:24.389261	16502	51	2	8
2014-03-26 02:33:32.681964	16503	289	3	2
2014-03-26 02:33:39.362562	16504	18.8	1	1
2014-03-26 02:33:39.584335	16505	49	2	1
2014-03-26 22:12:44.92341	32000	50	2	1
2014-03-26 22:12:57.710171	32001	24.4	1	10
2014-03-26 02:34:03.167245	16510	20.8	1	8
2014-03-26 02:34:03.397465	16511	51	2	8
2014-03-26 02:34:18.363756	16512	18.8	1	1
2014-03-26 02:34:18.586176	16513	49	2	1
2014-03-26 02:34:20.681776	16514	354	3	2
2014-03-26 02:34:32.681859	16515	338	3	2
2014-03-26 22:12:57.934692	32002	41	2	10
2014-03-26 22:13:08.046936	32003	22.2	1	9
2014-03-26 02:34:42.168541	16520	20.8	1	8
2014-03-26 02:34:42.390154	16521	51	2	8
2014-03-26 02:34:57.362566	16522	18.8	1	1
2014-03-26 02:34:57.584567	16523	49	2	1
2014-03-26 22:13:08.282716	32004	48	2	9
2014-03-26 22:13:09.135613	32005	22.0	1	8
2014-03-26 02:35:21.167454	16528	20.8	1	8
2014-03-26 02:35:21.400514	16529	51	2	8
2014-03-26 02:35:32.681084	16530	338	3	2
2014-03-26 02:35:36.361951	16531	18.8	1	1
2014-03-26 02:35:36.583773	16532	49	2	1
2014-03-26 22:13:09.378987	32006	47	2	8
2014-03-26 22:13:20.61484	32007	515	3	2
2014-03-26 02:36:00.167747	16537	20.8	1	8
2014-03-26 02:36:00.391327	16538	51	2	8
2014-03-26 02:36:15.361738	16539	18.8	1	1
2014-03-26 02:36:15.596277	16540	48	2	1
2014-03-26 02:36:32.681193	16541	338	3	2
2014-03-26 22:13:20.851483	32008	1088433.9998032781	4	2
2014-03-26 22:13:23.687007	32009	20.3	1	1
2014-03-26 02:36:39.167906	16546	20.8	1	8
2014-03-26 02:36:39.410066	16547	51	2	8
2014-03-26 02:36:54.360433	16548	18.8	1	1
2014-03-26 02:36:54.584385	16549	48	2	1
2014-03-26 22:13:23.91353	32010	50	2	1
2014-03-26 22:13:32.556999	32011	531	3	2
2014-03-26 02:37:18.167668	16554	20.8	1	8
2014-03-26 02:37:18.397385	16555	51	2	8
2014-03-26 02:37:32.681895	16556	338	3	2
2014-03-26 02:37:33.414117	16557	18.8	1	1
2014-03-26 02:37:33.635927	16558	48	2	1
2014-03-26 22:13:32.79518	32012	1088435.1488379994	4	2
2014-03-26 22:13:36.708901	32013	24.4	1	10
2014-03-26 02:37:56.683992	16563	418	3	2
2014-03-26 02:37:57.167406	16564	20.8	1	8
2014-03-26 02:37:57.389113	16565	51	2	8
2014-03-26 02:38:08.678517	16566	418	3	2
2014-03-26 02:38:12.35915	16567	18.8	1	1
2014-03-26 02:38:12.580002	16568	48	2	1
2014-03-26 02:38:32.678996	16569	418	3	2
2014-03-26 22:13:36.936578	32014	41	2	10
2014-03-26 22:13:47.045352	32015	22.2	1	9
2014-03-26 02:38:36.167623	16574	20.8	1	8
2014-03-26 02:38:36.397213	16575	51	2	8
2014-03-26 02:38:44.682843	16576	354	3	2
2014-03-26 02:38:51.361022	16577	18.8	1	1
2014-03-26 02:38:51.581894	16578	48	2	1
2014-03-26 02:38:56.679028	16579	354	3	2
2014-03-26 22:13:47.280309	32016	48	2	9
2014-03-26 22:13:48.135503	32017	22.0	1	8
2014-03-26 02:39:15.168053	16584	20.8	1	8
2014-03-26 02:39:15.398716	16585	51	2	8
2014-03-26 02:39:30.359844	16586	18.8	1	1
2014-03-26 02:39:30.580887	16587	48	2	1
2014-03-26 02:39:32.680714	16588	354	3	2
2014-03-26 02:30:46.073209	16463	21.6	1	10
2014-03-26 02:30:46.297173	16464	48	2	10
2014-03-26 02:31:25.196709	16471	21.6	1	10
2014-03-26 02:31:25.64075	16472	48	2	10
2014-03-26 02:32:04.074231	16480	21.6	1	10
2014-03-26 02:32:04.418532	16481	48	2	10
2014-03-26 02:32:43.074271	16489	21.6	1	10
2014-03-26 02:32:43.299252	16490	48	2	10
2014-03-26 02:33:22.076061	16497	21.6	1	10
2014-03-26 02:33:22.297699	16498	48	2	10
2014-03-26 02:34:01.075625	16506	21.6	1	10
2014-03-26 02:34:01.30709	16507	48	2	10
2014-03-26 02:34:40.077992	16516	21.6	1	10
2014-03-26 02:34:40.307231	16517	48	2	10
2014-03-26 02:35:19.074663	16524	21.6	1	10
2014-03-26 02:35:19.308254	16525	48	2	10
2014-03-26 02:35:58.074889	16533	21.6	1	10
2014-03-26 02:35:58.297678	16534	48	2	10
2014-03-26 02:36:37.076177	16542	21.6	1	10
2014-03-26 02:36:37.310293	16543	48	2	10
2014-03-26 02:37:16.074102	16550	21.6	1	10
2014-03-26 02:37:16.309679	16551	48	2	10
2014-03-26 02:37:55.075385	16559	21.6	1	10
2014-03-26 02:37:55.298825	16560	48	2	10
2014-03-26 02:38:34.075408	16570	21.5	1	10
2014-03-26 02:38:34.297666	16571	48	2	10
2014-03-26 02:39:13.078481	16580	21.5	1	10
2014-03-26 02:39:13.299905	16581	48	2	10
2014-03-26 02:39:52.075633	16589	21.5	1	10
2014-03-26 02:39:54.170233	16593	20.8	1	8
2014-03-26 02:39:54.390807	16594	51	2	8
2014-03-26 02:40:09.355474	16595	18.8	1	1
2014-03-26 02:40:09.588682	16596	48	2	1
2014-03-26 22:13:48.361179	32018	47	2	8
2014-03-26 22:14:02.68787	32019	20.3	1	1
2014-03-26 02:40:32.678544	16601	354	3	2
2014-03-26 02:40:33.1689	16602	20.8	1	8
2014-03-26 02:40:33.44676	16603	51	2	8
2014-03-26 02:40:48.359129	16604	18.8	1	1
2014-03-26 02:40:48.581426	16605	48	2	1
2014-03-26 22:14:02.925758	32020	50	2	1
2014-03-26 22:14:15.709187	32021	24.4	1	10
2014-03-26 02:41:12.167851	16610	20.8	1	8
2014-03-26 02:41:12.401798	16611	51	2	8
2014-03-26 02:41:27.360243	16612	18.8	1	1
2014-03-26 02:41:27.58331	16613	48	2	1
2014-03-26 02:41:32.67783	16614	354	3	2
2014-03-26 22:14:15.935351	32022	41	2	10
2014-03-26 22:14:26.047896	32023	22.2	1	9
2014-03-26 02:41:51.167329	16619	20.8	1	8
2014-03-26 02:41:51.389807	16620	51	2	8
2014-03-26 02:42:06.355297	16621	18.8	1	1
2014-03-26 02:42:06.588314	16622	48	2	1
2014-03-26 22:14:26.281429	32024	48	2	9
2014-03-26 22:14:27.135468	32025	22.0	1	8
2014-03-26 02:42:30.167745	16627	20.8	1	8
2014-03-26 02:42:30.389097	16628	51	2	8
2014-03-26 02:42:32.684901	16629	354	3	2
2014-03-26 02:42:45.35989	16630	18.8	1	1
2014-03-26 02:42:45.583386	16631	48	2	1
2014-03-26 22:14:27.359762	32026	47	2	8
2014-03-26 22:14:32.561226	32027	515	3	2
2014-03-26 02:43:09.165835	16636	20.8	1	8
2014-03-26 02:43:09.397992	16637	51	2	8
2014-03-26 02:43:24.356105	16638	18.7	1	1
2014-03-26 02:43:24.578266	16639	48	2	1
2014-03-26 02:43:32.681779	16640	354	3	2
2014-03-26 22:14:32.795398	32028	1088444.3411157709	4	2
2014-03-26 22:14:41.686851	32029	20.3	1	1
2014-03-26 02:43:48.16764	16645	20.8	1	8
2014-03-26 02:43:48.390426	16646	51	2	8
2014-03-26 02:44:03.356304	16647	18.7	1	1
2014-03-26 02:44:03.576331	16648	48	2	1
2014-03-26 22:14:41.912008	32030	50	2	1
2014-03-26 22:14:44.553778	32031	418	3	2
2014-03-26 02:44:27.167226	16653	20.8	1	8
2014-03-26 02:44:27.389401	16654	51	2	8
2014-03-26 02:44:32.677517	16655	354	3	2
2014-03-26 02:44:42.358077	16656	18.7	1	1
2014-03-26 02:44:42.580242	16657	48	2	1
2014-03-26 22:14:44.787774	32032	1088445.4901504922	4	2
2014-03-26 22:14:54.707748	32033	24.4	1	10
2014-03-26 02:45:06.169368	16662	20.8	1	8
2014-03-26 02:45:06.393283	16663	51	2	8
2014-03-26 02:45:21.355534	16664	18.7	1	1
2014-03-26 02:45:21.580087	16665	48	2	1
2014-03-26 02:45:32.679719	16666	354	3	2
2014-03-26 22:14:54.933516	32034	41	2	10
2014-03-26 22:14:56.561217	32035	418	3	2
2014-03-26 02:45:45.167201	16671	20.8	1	8
2014-03-26 02:45:45.402248	16672	51	2	8
2014-03-26 02:46:00.35799	16673	18.7	1	1
2014-03-26 02:46:00.58043	16674	48	2	1
2014-03-26 02:46:08.678778	16675	402	3	2
2014-03-26 02:46:20.679047	16676	402	3	2
2014-03-26 22:14:56.805723	32036	1088446.6391852137	4	2
2014-03-26 22:15:05.045253	32037	22.2	1	9
2014-03-26 02:46:24.167656	16681	20.8	1	8
2014-03-26 02:46:24.390634	16682	51	2	8
2014-03-26 02:46:32.680086	16683	402	3	2
2014-03-26 02:46:39.353174	16684	18.7	1	1
2014-03-26 02:46:39.576236	16685	48	2	1
2014-03-26 22:15:05.271834	32038	48	2	9
2014-03-26 22:15:06.137662	32039	22.0	1	8
2014-03-26 02:47:03.166477	16690	20.8	1	8
2014-03-26 02:47:03.397089	16691	51	2	8
2014-03-26 02:47:18.353848	16692	18.7	1	1
2014-03-26 02:47:18.595633	16693	48	2	1
2014-03-26 02:47:32.678918	16694	402	3	2
2014-03-26 22:15:06.372033	32040	47	2	8
2014-03-26 22:15:08.549928	32041	515	3	2
2014-03-26 02:47:42.167262	16699	20.8	1	8
2014-03-26 02:47:42.390026	16700	51	2	8
2014-03-26 02:47:57.354095	16701	18.7	1	1
2014-03-26 02:47:57.584677	16702	48	2	1
2014-03-26 22:15:08.773566	32042	1088448.9372546566	4	2
2014-03-26 22:15:20.924785	32043	20.3	1	1
2014-03-26 02:48:21.167317	16707	20.8	1	8
2014-03-26 02:48:21.388546	16708	51	2	8
2014-03-26 02:48:32.678251	16709	370	3	2
2014-03-26 02:48:36.353249	16710	18.7	1	1
2014-03-26 02:48:36.575044	16711	48	2	1
2014-03-26 02:48:44.682922	16712	370	3	2
2014-03-26 22:15:21.159575	32044	50	2	1
2014-03-26 22:15:32.555057	32045	515	3	2
2014-03-26 02:49:00.167227	16717	20.8	1	8
2014-03-26 02:49:00.398008	16718	51	2	8
2014-03-26 02:49:15.352482	16719	18.7	1	1
2014-03-26 02:49:15.575372	16720	48	2	1
2014-03-26 02:49:32.6791	16721	370	3	2
2014-03-26 22:15:32.779554	32046	1088452.3843588207	4	2
2014-03-26 02:49:39.167313	16726	20.8	1	8
2014-03-26 02:49:39.38953	16727	51	2	8
2014-03-26 02:49:54.355711	16728	18.7	1	1
2014-03-26 02:40:31.077442	16597	21.5	1	10
2014-03-26 02:40:31.300496	16598	48	2	10
2014-03-26 02:41:10.077476	16606	21.5	1	10
2014-03-26 02:41:10.309411	16607	48	2	10
2014-03-26 02:41:49.077678	16615	21.5	1	10
2014-03-26 02:41:49.303005	16616	48	2	10
2014-03-26 02:42:28.076491	16623	21.5	1	10
2014-03-26 02:42:28.298483	16624	48	2	10
2014-03-26 02:43:07.078712	16632	21.5	1	10
2014-03-26 02:43:07.321422	16633	48	2	10
2014-03-26 02:43:46.078436	16641	21.5	1	10
2014-03-26 02:43:46.30188	16642	48	2	10
2014-03-26 02:44:25.080084	16649	21.5	1	10
2014-03-26 02:44:25.302098	16650	48	2	10
2014-03-26 02:45:04.078837	16658	21.5	1	10
2014-03-26 02:45:04.300337	16659	48	2	10
2014-03-26 02:45:43.077868	16667	21.5	1	10
2014-03-26 02:45:43.313391	16668	48	2	10
2014-03-26 02:46:22.079557	16677	21.5	1	10
2014-03-26 02:46:22.300345	16678	48	2	10
2014-03-26 02:47:01.077919	16686	21.5	1	10
2014-03-26 02:47:01.309389	16687	48	2	10
2014-03-26 02:47:40.081487	16695	21.5	1	10
2014-03-26 02:47:40.306683	16696	48	2	10
2014-03-26 02:48:19.078205	16703	21.5	1	10
2014-03-26 02:48:19.300633	16704	48	2	10
2014-03-26 02:48:58.080155	16713	21.5	1	10
2014-03-26 02:48:58.311868	16714	48	2	10
2014-03-26 02:49:54.576351	16729	48	2	1
2014-03-26 22:15:33.70904	32047	24.4	1	10
2014-03-26 22:15:33.945208	32048	41	2	10
2014-03-26 02:50:18.16947	16734	20.8	1	8
2014-03-26 02:50:18.391434	16735	51	2	8
2014-03-26 02:50:32.678436	16736	370	3	2
2014-03-26 02:50:33.351625	16737	18.7	1	1
2014-03-26 02:50:33.575132	16738	48	2	1
2014-03-26 22:15:44.047722	32049	22.1	1	9
2014-03-26 22:15:44.273286	32050	48	2	9
2014-03-26 02:50:56.675202	16743	305	3	2
2014-03-26 02:50:57.167534	16744	20.8	1	8
2014-03-26 02:50:57.389234	16745	51	2	8
2014-03-26 02:51:08.677514	16746	305	3	2
2014-03-26 02:51:12.352684	16747	18.7	1	1
2014-03-26 02:51:12.586873	16748	48	2	1
2014-03-26 02:51:32.678777	16749	305	3	2
2014-03-26 22:15:44.58	32051	418	3	2
2014-03-26 22:15:44.817939	32052	1088453.5333935423	4	2
2014-03-26 02:51:36.166054	16754	20.8	1	8
2014-03-26 02:51:36.397891	16755	51	2	8
2014-03-26 02:51:51.477361	16756	18.7	1	1
2014-03-26 02:51:51.90254	16757	48	2	1
2014-03-26 22:15:45.135258	32053	22.0	1	8
2014-03-26 22:15:45.363402	32054	47	2	8
2014-03-26 02:52:15.166114	16762	20.8	1	8
2014-03-26 02:52:15.397037	16763	51	2	8
2014-03-26 02:52:30.351173	16764	18.7	1	1
2014-03-26 02:52:30.57463	16765	48	2	1
2014-03-26 02:52:32.679628	16766	305	3	2
2014-03-26 02:52:44.676131	16767	370	3	2
2014-03-26 22:15:56.55775	32055	370	3	2
2014-03-26 22:15:56.792837	32056	1088454.6824282636	4	2
2014-03-26 02:52:54.165992	16772	20.8	1	8
2014-03-26 02:52:54.395202	16773	51	2	8
2014-03-26 02:52:56.677069	16774	354	3	2
2014-03-26 02:53:08.678213	16775	305	3	2
2014-03-26 02:53:09.592684	16776	18.7	1	1
2014-03-26 02:53:09.824886	16777	48	2	1
2014-03-26 02:53:20.682044	16778	289	3	2
2014-03-26 22:15:59.686426	32057	20.3	1	1
2014-03-26 22:15:59.908839	32058	50	2	1
2014-03-26 02:53:32.682438	16783	289	3	2
2014-03-26 02:53:33.166771	16784	20.8	1	8
2014-03-26 02:53:33.387973	16785	51	2	8
2014-03-26 02:53:48.349838	16786	18.7	1	1
2014-03-26 02:53:48.581611	16787	48	2	1
2014-03-26 22:16:08.560361	32059	418	3	2
2014-03-26 22:16:08.795135	32060	1088455.831462985	4	2
2014-03-26 02:54:12.168214	16792	20.8	1	8
2014-03-26 02:54:12.391517	16793	51	2	8
2014-03-26 02:54:27.351904	16794	18.7	1	1
2014-03-26 02:54:27.583791	16795	48	2	1
2014-03-26 02:54:32.679341	16796	289	3	2
2014-03-26 22:16:12.708822	32061	24.4	1	10
2014-03-26 22:16:12.933695	32062	41	2	10
2014-03-26 02:54:51.167054	16801	20.8	1	8
2014-03-26 02:54:51.397394	16802	51	2	8
2014-03-26 02:55:06.347714	16803	18.7	1	1
2014-03-26 02:55:06.570797	16804	48	2	1
2014-03-26 22:16:20.559426	32063	418	3	2
2014-03-26 22:16:20.849266	32064	1088456.9804977064	4	2
2014-03-26 02:55:30.165921	16809	20.8	1	8
2014-03-26 02:55:30.398131	16810	51	2	8
2014-03-26 02:55:32.677205	16811	289	3	2
2014-03-26 02:55:45.350861	16812	18.7	1	1
2014-03-26 02:55:45.572709	16813	48	2	1
2014-03-26 22:16:23.045835	32065	22.1	1	9
2014-03-26 22:16:23.270111	32066	48	2	9
2014-03-26 02:56:09.168455	16818	20.8	1	8
2014-03-26 02:56:09.391285	16819	51	2	8
2014-03-26 02:56:24.34867	16820	18.7	1	1
2014-03-26 02:56:24.579172	16821	48	2	1
2014-03-26 02:56:32.676452	16822	289	3	2
2014-03-26 22:16:24.134781	32067	22.0	1	8
2014-03-26 22:16:24.37025	32068	47	2	8
2014-03-26 02:56:48.168992	16827	20.8	1	8
2014-03-26 02:56:48.400405	16828	51	2	8
2014-03-26 02:57:03.349873	16829	18.7	1	1
2014-03-26 02:57:03.571906	16830	48	2	1
2014-03-26 22:16:32.558957	32069	402	3	2
2014-03-26 22:16:32.784335	32070	1088459.2785671493	4	2
2014-03-26 02:57:27.167124	16835	20.8	1	8
2014-03-26 02:57:27.400954	16836	51	2	8
2014-03-26 02:57:32.679683	16837	289	3	2
2014-03-26 02:57:42.348466	16838	18.7	1	1
2014-03-26 02:57:42.574298	16839	48	2	1
2014-03-26 22:16:38.682746	32071	20.3	1	1
2014-03-26 22:16:38.918575	32072	50	2	1
2014-03-26 02:58:06.167519	16844	20.8	1	8
2014-03-26 02:58:06.389906	16845	51	2	8
2014-03-26 02:58:21.349714	16846	18.7	1	1
2014-03-26 02:58:21.58309	16847	48	2	1
2014-03-26 02:58:32.679583	16848	354	3	2
2014-03-26 22:16:51.708968	32073	24.4	1	10
2014-03-26 22:16:51.935099	32074	41	2	10
2014-03-26 02:58:44.681854	16853	338	3	2
2014-03-26 02:58:45.168832	16854	20.8	1	8
2014-03-26 02:58:45.390166	16855	51	2	8
2014-03-26 02:59:00.348644	16856	18.7	1	1
2014-03-26 02:59:00.590783	16857	48	2	1
2014-03-26 22:17:02.045884	32075	22.1	1	9
2014-03-26 02:59:24.167198	16862	20.8	1	8
2014-03-26 02:59:24.392962	16863	51	2	8
2014-03-26 02:59:32.67779	16864	338	3	2
2014-03-26 02:50:16.08202	16730	21.5	1	10
2014-03-26 02:50:16.303703	16731	48	2	10
2014-03-26 02:50:55.080507	16739	21.5	1	10
2014-03-26 02:50:55.313347	16740	48	2	10
2014-03-26 02:51:34.081278	16750	21.5	1	10
2014-03-26 02:51:34.305391	16751	48	2	10
2014-03-26 02:52:13.08064	16758	21.5	1	10
2014-03-26 02:52:13.312813	16759	48	2	10
2014-03-26 02:52:52.080619	16768	21.5	1	10
2014-03-26 02:52:52.303319	16769	48	2	10
2014-03-26 02:53:31.081866	16779	21.5	1	10
2014-03-26 02:53:31.304706	16780	48	2	10
2014-03-26 02:54:10.081211	16788	21.5	1	10
2014-03-26 02:54:10.304079	16789	48	2	10
2014-03-26 02:54:49.08313	16797	21.5	1	10
2014-03-26 02:54:49.306559	16798	48	2	10
2014-03-26 02:55:28.084156	16805	21.5	1	10
2014-03-26 02:55:28.32715	16806	48	2	10
2014-03-26 02:56:07.083184	16814	21.5	1	10
2014-03-26 02:56:07.314662	16815	48	2	10
2014-03-26 02:56:46.080179	16823	21.5	1	10
2014-03-26 02:56:46.307127	16824	48	2	10
2014-03-26 02:57:25.08239	16831	21.5	1	10
2014-03-26 02:57:25.314975	16832	48	2	10
2014-03-26 02:58:04.081955	16840	21.5	1	10
2014-03-26 02:58:04.305115	16841	48	2	10
2014-03-26 02:58:43.081998	16849	21.5	1	10
2014-03-26 02:58:43.30458	16850	48	2	10
2014-03-26 02:59:39.348633	16865	18.7	1	1
2014-03-26 02:59:39.572353	16866	48	2	1
2014-03-26 22:17:02.280024	32076	48	2	9
2014-03-26 22:17:03.1338	32077	22.0	1	8
2014-03-26 03:00:03.167803	16871	20.8	1	8
2014-03-26 03:00:03.401255	16872	51	2	8
2014-03-26 03:00:18.34891	16873	18.7	1	1
2014-03-26 03:00:18.570822	16874	48	2	1
2014-03-26 03:00:32.677387	16875	354	3	2
2014-03-26 22:17:03.357661	32078	47	2	8
2014-03-26 22:17:08.559788	32079	354	3	2
2014-03-26 03:00:42.167745	16880	20.8	1	8
2014-03-26 03:00:42.389013	16881	51	2	8
2014-03-26 03:00:57.346426	16882	18.7	1	1
2014-03-26 03:00:57.577973	16883	48	2	1
2014-03-26 22:17:08.796058	32080	1088462.7256713135	4	2
2014-03-26 22:17:17.68672	32081	20.3	1	1
2014-03-26 03:01:21.168513	16888	20.8	1	8
2014-03-26 03:01:21.389889	16889	51	2	8
2014-03-26 03:01:32.678049	16890	354	3	2
2014-03-26 03:01:36.346316	16891	18.7	1	1
2014-03-26 03:01:36.57208	16892	48	2	1
2014-03-26 22:17:17.910666	32082	50	2	1
2014-03-26 22:17:20.559928	32083	354	3	2
2014-03-26 03:02:00.167821	16897	20.8	1	8
2014-03-26 03:02:00.400529	16898	51	2	8
2014-03-26 03:02:15.583842	16899	18.7	1	1
2014-03-26 03:02:15.80819	16900	48	2	1
2014-03-26 03:02:32.674811	16901	354	3	2
2014-03-26 22:17:20.858294	32084	1088463.874706035	4	2
2014-03-26 22:17:30.709273	32085	24.4	1	10
2014-03-26 03:02:39.165452	16906	20.8	1	8
2014-03-26 03:02:39.389108	16907	51	2	8
2014-03-26 03:02:54.345765	16908	18.7	1	1
2014-03-26 03:02:54.579167	16909	48	2	1
2014-03-26 22:17:30.934036	32086	41	2	10
2014-03-26 22:17:40.843365	32087	354	3	2
2014-03-26 03:03:18.16562	16914	20.8	1	8
2014-03-26 03:03:18.388055	16915	51	2	8
2014-03-26 03:03:20.679512	16916	305	3	2
2014-03-26 03:03:32.675278	16917	305	3	2
2014-03-26 03:03:33.344168	16918	18.7	1	1
2014-03-26 03:03:33.568627	16919	48	2	1
2014-03-26 22:17:41.082806	32088	1088465.0237407563	4	2
2014-03-26 22:17:41.389735	32089	22.1	1	9
2014-03-26 03:03:56.678891	16924	338	3	2
2014-03-26 03:03:57.169004	16925	20.8	1	8
2014-03-26 03:03:57.390768	16926	51	2	8
2014-03-26 03:04:08.681035	16927	305	3	2
2014-03-26 03:04:12.345274	16928	18.7	1	1
2014-03-26 03:04:12.56777	16929	48	2	1
2014-03-26 03:04:20.680992	16930	338	3	2
2014-03-26 03:04:32.677792	16931	305	3	2
2014-03-26 22:17:41.61593	32090	48	2	9
2014-03-26 22:17:42.134811	32091	22.0	1	8
2014-03-26 03:04:36.166203	16936	20.8	1	8
2014-03-26 03:04:36.38721	16937	51	2	8
2014-03-26 03:04:44.675591	16938	305	3	2
2014-03-26 03:04:51.342743	16939	18.7	1	1
2014-03-26 03:04:51.565764	16940	48	2	1
2014-03-26 03:04:56.679735	16941	338	3	2
2014-03-26 03:05:08.67798	16942	305	3	2
2014-03-26 22:17:42.370015	32092	47	2	8
2014-03-26 22:17:56.686288	32093	20.3	1	1
2014-03-26 03:05:15.164793	16947	20.8	1	8
2014-03-26 03:05:15.385184	16948	51	2	8
2014-03-26 03:05:20.67631	16949	305	3	2
2014-03-26 03:05:30.341654	16950	18.7	1	1
2014-03-26 03:05:30.574793	16951	48	2	1
2014-03-26 03:05:32.679346	16952	305	3	2
2014-03-26 22:17:56.910222	32094	50	2	1
2014-03-26 22:18:09.710859	32095	24.4	1	10
2014-03-26 03:05:54.166397	16957	20.8	1	8
2014-03-26 03:05:54.390259	16958	51	2	8
2014-03-26 03:05:56.675865	16959	338	3	2
2014-03-26 03:06:08.674604	16960	305	3	2
2014-03-26 03:06:09.34279	16961	18.7	1	1
2014-03-26 03:06:09.573965	16962	48	2	1
2014-03-26 03:06:20.675155	16963	305	3	2
2014-03-26 22:18:09.944032	32096	41	2	10
2014-03-26 22:18:20.046583	32097	22.1	1	9
2014-03-26 03:06:32.677974	16968	305	3	2
2014-03-26 03:06:33.168858	16969	20.8	1	8
2014-03-26 03:06:33.389445	16970	51	2	8
2014-03-26 03:06:48.34255	16971	18.7	1	1
2014-03-26 03:06:48.573331	16972	48	2	1
2014-03-26 22:18:20.289821	32098	47	2	9
2014-03-26 22:18:21.133984	32099	22.0	1	8
2014-03-26 03:07:12.165491	16977	20.8	1	8
2014-03-26 03:07:12.388719	16978	51	2	8
2014-03-26 03:07:27.34498	16979	18.7	1	1
2014-03-26 03:07:27.577163	16980	48	2	1
2014-03-26 03:07:32.67792	16981	305	3	2
2014-03-26 22:18:21.368229	32100	47	2	8
2014-03-26 22:18:32.558477	32101	338	3	2
2014-03-26 03:07:51.167129	16986	20.8	1	8
2014-03-26 03:07:51.391438	16987	51	2	8
2014-03-26 03:08:06.342851	16988	18.7	1	1
2014-03-26 03:08:06.566179	16989	48	2	1
2014-03-26 22:18:32.784919	32102	1088470.7689143633	4	2
2014-03-26 22:18:35.683352	32103	20.2	1	1
2014-03-26 22:18:35.919184	32104	50	2	1
2014-03-26 03:08:30.166001	16994	20.8	1	8
2014-03-26 03:08:30.388155	16995	51	2	8
2014-03-26 03:08:32.676059	16996	305	3	2
2014-03-26 03:08:45.338771	16997	18.7	1	1
2014-03-26 03:08:45.562463	16998	48	2	1
2014-03-26 03:00:01.082859	16867	21.4	1	10
2014-03-26 03:00:01.314281	16868	48	2	10
2014-03-26 03:00:40.084555	16876	21.4	1	10
2014-03-26 03:00:40.306154	16877	48	2	10
2014-03-26 03:01:19.274385	16884	21.4	1	10
2014-03-26 03:01:19.503197	16885	48	2	10
2014-03-26 03:01:58.085774	16893	21.4	1	10
2014-03-26 03:01:58.31893	16894	48	2	10
2014-03-26 03:02:37.083333	16902	21.4	1	10
2014-03-26 03:02:37.314827	16903	48	2	10
2014-03-26 03:03:16.083534	16910	21.4	1	10
2014-03-26 03:03:16.305809	16911	48	2	10
2014-03-26 03:03:55.084646	16920	21.4	1	10
2014-03-26 03:03:55.31641	16921	48	2	10
2014-03-26 03:04:34.084499	16932	21.4	1	10
2014-03-26 03:04:34.362056	16933	48	2	10
2014-03-26 03:05:13.084746	16943	21.4	1	10
2014-03-26 03:05:13.306568	16944	48	2	10
2014-03-26 03:05:52.08595	16953	21.4	1	10
2014-03-26 03:05:52.30987	16954	48	2	10
2014-03-26 03:06:31.086372	16964	21.4	1	10
2014-03-26 03:06:31.309033	16965	48	2	10
2014-03-26 03:07:10.086003	16973	21.4	1	10
2014-03-26 03:07:10.309895	16974	48	2	10
2014-03-26 03:07:49.084828	16982	21.4	1	10
2014-03-26 03:07:49.309746	16983	48	2	10
2014-03-26 22:18:48.708735	32105	24.4	1	10
2014-03-26 22:18:48.935624	32106	41	2	10
2014-03-26 03:09:09.164419	17003	20.8	1	8
2014-03-26 03:09:09.396533	17004	51	2	8
2014-03-26 03:09:24.339212	17005	18.7	1	1
2014-03-26 03:09:24.560245	17006	48	2	1
2014-03-26 03:09:32.677781	17007	305	3	2
2014-03-26 22:18:59.047731	32107	22.1	1	9
2014-03-26 22:18:59.283074	32108	47	2	9
2014-03-26 03:09:48.165477	17012	20.8	1	8
2014-03-26 03:09:48.388106	17013	51	2	8
2014-03-26 03:10:03.340083	17014	18.7	1	1
2014-03-26 03:10:03.571558	17015	48	2	1
2014-03-26 03:10:20.673948	17016	354	3	2
2014-03-26 22:19:00.13388	32109	22.0	1	8
2014-03-26 22:19:00.357451	32110	47	2	8
2014-03-26 03:10:27.167349	17023	20.8	1	8
2014-03-26 03:10:27.388323	17024	51	2	8
2014-03-26 03:10:32.677086	17025	354	3	2
2014-03-26 03:10:42.340794	17026	18.7	1	1
2014-03-26 03:10:42.564254	17027	48	2	1
2014-03-26 22:19:14.479406	32111	305	3	2
2014-03-26 22:19:14.714043	32112	1088474.2160185277	4	2
2014-03-26 03:11:06.167746	17034	20.8	1	8
2014-03-26 03:11:06.390392	17035	51	2	8
2014-03-26 03:11:21.339453	17036	18.7	1	1
2014-03-26 03:11:21.583631	17037	48	2	1
2014-03-26 03:11:32.673366	17038	354	3	2
2014-03-26 22:19:15.023246	32113	20.2	1	1
2014-03-26 22:19:15.24733	32114	50	2	1
2014-03-26 03:11:45.168822	17045	20.8	1	8
2014-03-26 03:11:45.390253	17046	51	2	8
2014-03-26 03:12:00.340696	17047	18.7	1	1
2014-03-26 03:12:00.57134	17048	48	2	1
2014-03-26 22:19:20.555828	32115	305	3	2
2014-03-26 22:19:20.791165	32116	1088475.365053249	4	2
2014-03-26 03:12:24.300003	17053	20.8	1	8
2014-03-26 03:12:24.720011	17054	51	2	8
2014-03-26 03:12:32.676308	17055	354	3	2
2014-03-26 03:12:39.340832	17056	18.7	1	1
2014-03-26 03:12:39.565629	17057	48	2	1
2014-03-26 22:19:27.708889	32117	24.4	1	10
2014-03-26 22:19:27.936211	32118	41	2	10
2014-03-26 03:13:03.167665	17064	20.8	1	8
2014-03-26 03:13:03.392941	17065	51	2	8
2014-03-26 03:13:18.343529	17066	18.7	1	1
2014-03-26 03:13:18.575116	17067	48	2	1
2014-03-26 03:13:32.675933	17068	354	3	2
2014-03-26 22:19:32.559138	32119	305	3	2
2014-03-26 22:19:32.794339	32120	1088476.5140879704	4	2
2014-03-26 03:13:42.166183	17073	20.8	1	8
2014-03-26 03:13:42.398033	17074	51	2	8
2014-03-26 03:13:57.33959	17075	18.7	1	1
2014-03-26 03:13:57.563505	17076	48	2	1
2014-03-26 22:19:38.049203	32121	22.0	1	9
2014-03-26 22:19:38.277671	32122	47	2	9
2014-03-26 03:14:21.166441	17081	20.8	1	8
2014-03-26 03:14:21.409046	17082	51	2	8
2014-03-26 03:14:32.679346	17083	354	3	2
2014-03-26 03:14:36.337366	17084	18.7	1	1
2014-03-26 03:14:36.559977	17085	48	2	1
2014-03-26 22:19:39.134204	32123	21.9	1	8
2014-03-26 22:19:39.367024	32124	48	2	8
2014-03-26 22:19:53.684873	32125	20.2	1	1
2014-03-26 22:19:53.90977	32126	50	2	1
2014-03-26 03:15:00.165978	17092	20.8	1	8
2014-03-26 03:15:00.389989	17093	51	2	8
2014-03-26 03:15:08.675231	17094	305	3	2
2014-03-26 03:15:15.334449	17095	18.7	1	1
2014-03-26 03:15:15.556548	17096	48	2	1
2014-03-26 03:15:20.67388	17097	338	3	2
2014-03-26 03:15:32.674189	17098	305	3	2
2014-03-26 22:19:56.558782	32127	338	3	2
2014-03-26 22:19:56.793678	32128	1088478.8121574132	4	2
2014-03-26 22:20:06.710384	32129	24.4	1	10
2014-03-26 22:20:06.935591	32130	41	2	10
2014-03-26 03:15:39.166432	17103	20.8	1	8
2014-03-26 03:15:39.396779	17104	51	2	8
2014-03-26 03:15:44.673559	17105	305	3	2
2014-03-26 03:15:54.339756	17106	18.7	1	1
2014-03-26 03:15:54.570438	17107	48	2	1
2014-03-26 22:20:08.557914	32131	354	3	2
2014-03-26 22:20:08.80511	32132	1088479.9611921348	4	2
2014-03-26 22:20:17.046842	32133	22.0	1	9
2014-03-26 22:20:17.270108	32134	47	2	9
2014-03-26 03:16:18.165849	17112	20.8	1	8
2014-03-26 03:16:18.388115	17113	51	2	8
2014-03-26 03:16:32.675303	17114	305	3	2
2014-03-26 03:16:33.335587	17115	18.7	1	1
2014-03-26 03:16:33.55711	17116	48	2	1
2014-03-26 22:20:18.136166	32135	21.9	1	8
2014-03-26 22:20:18.369616	32136	48	2	8
2014-03-26 22:20:32.919482	32137	20.2	1	1
2014-03-26 22:20:33.144244	32138	50	2	1
2014-03-26 22:20:45.709461	32139	24.4	1	10
2014-03-26 22:20:45.944808	32140	41	2	10
2014-03-26 03:16:57.166932	17123	20.8	1	8
2014-03-26 03:16:57.39205	17124	51	2	8
2014-03-26 03:17:12.335594	17125	18.7	1	1
2014-03-26 03:17:12.579084	17126	48	2	1
2014-03-26 03:17:32.673523	17127	305	3	2
2014-03-26 22:20:56.045546	32141	22.0	1	9
2014-03-26 22:20:56.270151	32142	47	2	9
2014-03-26 03:17:36.167938	17132	20.8	1	8
2014-03-26 03:17:36.389072	17133	51	2	8
2014-03-26 03:17:51.338605	17134	18.7	1	1
2014-03-26 03:17:51.562258	17135	48	2	1
2014-03-26 03:09:46.276946	17008	21.4	1	10
2014-03-26 03:09:46.499105	17009	48	2	10
2014-03-26 03:10:25.0863	17017	21.4	1	10
2014-03-26 03:10:25.30871	17018	48	2	10
2014-03-26 03:10:25.623841	17019	21.4	1	10
2014-03-26 03:10:25.848438	17020	48	2	10
2014-03-26 03:11:04.086532	17028	21.4	1	10
2014-03-26 03:11:04.309362	17029	48	2	10
2014-03-26 03:11:04.625991	17030	21.4	1	10
2014-03-26 03:11:04.84886	17031	48	2	10
2014-03-26 03:11:43.088711	17039	21.4	1	10
2014-03-26 03:11:43.311584	17040	48	2	10
2014-03-26 03:11:43.628325	17041	21.4	1	10
2014-03-26 03:11:43.84987	17042	48	2	10
2014-03-26 03:12:22.220066	17049	21.4	1	10
2014-03-26 03:12:22.640006	17050	48	2	10
2014-03-26 03:13:01.087513	17058	21.4	1	10
2014-03-26 03:13:01.323958	17059	48	2	10
2014-03-26 03:13:01.630603	17060	21.4	1	10
2014-03-26 03:13:01.852872	17061	48	2	10
2014-03-26 03:13:40.089056	17069	21.4	1	10
2014-03-26 03:13:40.309587	17070	48	2	10
2014-03-26 03:14:19.088977	17077	21.4	1	10
2014-03-26 03:14:19.323132	17078	48	2	10
2014-03-26 03:14:58.087675	17086	21.4	1	10
2014-03-26 03:14:58.313002	17087	48	2	10
2014-03-26 22:20:57.134389	32143	21.9	1	8
2014-03-26 22:20:57.371408	32144	48	2	8
2014-03-26 03:18:15.167016	17142	20.8	1	8
2014-03-26 03:18:15.392558	17143	51	2	8
2014-03-26 03:18:30.337721	17144	18.7	1	1
2014-03-26 03:18:30.569566	17145	48	2	1
2014-03-26 03:18:32.675209	17146	305	3	2
2014-03-26 22:21:11.682225	32145	20.2	1	1
2014-03-26 22:21:11.927911	32146	50	2	1
2014-03-26 03:18:54.164801	17153	20.8	1	8
2014-03-26 03:18:54.388068	17154	51	2	8
2014-03-26 03:19:09.33351	17155	18.6	1	1
2014-03-26 03:19:09.565267	17156	48	2	1
2014-03-26 22:21:24.710263	32147	24.4	1	10
2014-03-26 22:21:24.943789	32148	41	2	10
2014-03-26 03:19:32.674521	17161	305	3	2
2014-03-26 03:19:33.165149	17162	20.7	1	8
2014-03-26 03:19:33.38545	17163	51	2	8
2014-03-26 03:19:48.337958	17164	18.6	1	1
2014-03-26 03:19:48.560269	17165	48	2	1
2014-03-26 22:21:32.55966	32149	354	3	2
2014-03-26 22:21:32.783684	32150	1088488.0044351846	4	2
2014-03-26 03:20:12.164743	17170	20.7	1	8
2014-03-26 03:20:12.40687	17171	51	2	8
2014-03-26 03:20:27.333178	17172	18.6	1	1
2014-03-26 03:20:27.556478	17173	48	2	1
2014-03-26 03:20:32.674127	17174	305	3	2
2014-03-26 22:21:35.04964	32151	22.0	1	9
2014-03-26 22:21:35.285134	32152	47	2	9
2014-03-26 03:20:51.164104	17179	20.7	1	8
2014-03-26 03:20:51.385794	17180	51	2	8
2014-03-26 03:21:06.331686	17181	18.6	1	1
2014-03-26 03:21:06.563591	17182	48	2	1
2014-03-26 03:21:20.674614	17183	338	3	2
2014-03-26 22:21:36.134588	32153	21.9	1	8
2014-03-26 22:21:36.360498	32154	48	2	8
2014-03-26 03:21:30.164863	17188	20.7	1	8
2014-03-26 03:21:30.395289	17189	51	2	8
2014-03-26 03:21:32.675095	17190	305	3	2
2014-03-26 03:21:44.674709	17191	305	3	2
2014-03-26 03:21:45.334882	17192	18.6	1	1
2014-03-26 03:21:45.565038	17193	48	2	1
2014-03-26 22:21:50.68774	32155	20.2	1	1
2014-03-26 22:21:50.922702	32156	50	2	1
2014-03-26 03:22:09.165192	17198	20.7	1	8
2014-03-26 03:22:09.386595	17199	51	2	8
2014-03-26 03:22:24.332373	17200	18.6	1	1
2014-03-26 03:22:24.56356	17201	48	2	1
2014-03-26 03:22:32.79769	17202	305	3	2
2014-03-26 03:22:44.672095	17203	354	3	2
2014-03-26 22:22:03.711058	32157	24.4	1	10
2014-03-26 22:22:03.934785	32158	41	2	10
2014-03-26 03:22:48.166363	17208	20.7	1	8
2014-03-26 03:22:48.397935	17209	51	2	8
2014-03-26 03:22:56.67478	17210	354	3	2
2014-03-26 03:23:03.331136	17211	18.6	1	1
2014-03-26 03:23:03.553943	17212	48	2	1
2014-03-26 22:22:14.045417	32159	22.0	1	9
2014-03-26 22:22:14.280235	32160	47	2	9
2014-03-26 03:23:27.165859	17219	20.7	1	8
2014-03-26 03:23:27.39857	17220	51	2	8
2014-03-26 03:23:32.673153	17221	354	3	2
2014-03-26 03:23:42.335975	17222	18.6	1	1
2014-03-26 03:23:42.558121	17223	48	2	1
2014-03-26 22:22:15.13536	32161	21.9	1	8
2014-03-26 22:22:15.359001	32162	48	2	8
2014-03-26 03:24:06.165393	17228	20.7	1	8
2014-03-26 03:24:06.387976	17229	51	2	8
2014-03-26 03:24:21.330141	17230	18.6	1	1
2014-03-26 03:24:21.563798	17231	48	2	1
2014-03-26 03:24:32.675118	17232	354	3	2
2014-03-26 22:22:29.680203	32163	20.2	1	1
2014-03-26 22:22:29.971494	32164	50	2	1
2014-03-26 03:24:45.165207	17237	20.7	1	8
2014-03-26 03:24:45.384957	17238	51	2	8
2014-03-26 03:25:00.329863	17239	18.6	1	1
2014-03-26 03:25:00.553729	17240	48	2	1
2014-03-27 00:30:44.766622	34244	1089283.1498752604	4	2
2014-03-27 00:30:45.749719	34245	22.9	1	10
2014-03-27 00:30:45.982857	34246	42	2	10
2014-03-26 03:25:24.165538	17245	20.7	1	8
2014-03-26 03:25:24.397849	17246	51	2	8
2014-03-26 03:25:32.676432	17247	354	3	2
2014-03-26 03:25:39.332103	17248	18.6	1	1
2014-03-26 03:25:39.553106	17249	48	2	1
2014-03-27 00:30:56.044975	34247	20.9	1	9
2014-03-27 00:30:56.269918	34248	48	2	9
2014-03-27 00:30:56.579126	34249	402	3	2
2014-03-27 00:30:56.825599	34250	1089284.298909982	4	2
2014-03-26 03:26:03.219672	17254	20.7	1	8
2014-03-26 03:26:03.460522	17255	51	2	8
2014-03-26 03:26:18.332318	17256	18.6	1	1
2014-03-26 03:26:18.564402	17257	48	2	1
2014-03-26 03:26:32.675121	17258	354	3	2
2014-03-27 00:30:57.132765	34251	21.5	1	8
2014-03-27 00:30:57.358901	34252	47	2	8
2014-03-27 00:31:11.404856	34253	370	3	2
2014-03-27 00:31:11.639909	34254	1089285.4479447033	4	2
2014-03-26 03:26:42.166296	17263	20.7	1	8
2014-03-26 03:26:42.386554	17264	51	2	8
2014-03-26 03:26:57.328939	17265	18.6	1	1
2014-03-26 03:26:57.55073	17266	48	2	1
2014-03-27 00:31:11.949361	34255	20.0	1	1
2014-03-26 03:27:21.163932	17271	20.7	1	8
2014-03-26 03:27:21.385784	17272	51	2	8
2014-03-26 03:18:13.319396	17137	48	2	10
2014-03-26 03:18:13.626932	17138	21.4	1	10
2014-03-26 03:18:13.848325	17139	48	2	10
2014-03-26 03:18:52.088977	17147	21.4	1	10
2014-03-26 03:18:52.309517	17148	48	2	10
2014-03-26 03:18:52.625512	17149	21.4	1	10
2014-03-26 03:18:52.846767	17150	48	2	10
2014-03-26 03:19:31.090679	17157	21.4	1	10
2014-03-26 03:19:31.313216	17158	48	2	10
2014-03-26 03:20:10.088846	17166	21.4	1	10
2014-03-26 03:20:10.320653	17167	48	2	10
2014-03-26 03:20:49.090044	17175	21.4	1	10
2014-03-26 03:20:49.311448	17176	48	2	10
2014-03-26 03:21:28.089241	17184	21.4	1	10
2014-03-26 03:21:28.311031	17185	48	2	10
2014-03-26 03:22:07.092854	17194	21.4	1	10
2014-03-26 03:22:07.315025	17195	48	2	10
2014-03-26 03:22:46.088747	17204	21.4	1	10
2014-03-26 03:22:46.323822	17205	48	2	10
2014-03-26 03:23:25.091715	17213	21.4	1	10
2014-03-26 03:23:25.315506	17214	48	2	10
2014-03-26 03:23:25.621802	17215	21.4	1	10
2014-03-26 03:23:25.862731	17216	48	2	10
2014-03-26 03:24:04.090559	17224	21.4	1	10
2014-03-26 03:24:04.311955	17225	48	2	10
2014-03-26 03:24:43.090722	17233	21.4	1	10
2014-03-26 03:24:43.313063	17234	48	2	10
2014-03-26 03:25:22.092353	17241	21.4	1	10
2014-03-26 03:27:32.671553	17273	305	3	2
2014-03-26 03:27:36.329894	17274	18.6	1	1
2014-03-26 03:27:36.551901	17275	48	2	1
2014-03-26 03:27:44.672538	17276	305	3	2
2014-03-26 22:22:32.559337	32165	354	3	2
2014-03-26 22:22:32.787499	32166	1088493.7496087917	4	2
2014-03-26 03:28:00.167606	17281	20.7	1	8
2014-03-26 03:28:00.388631	17282	51	2	8
2014-03-26 03:28:15.330661	17283	18.6	1	1
2014-03-26 03:28:15.561136	17284	48	2	1
2014-03-26 03:28:32.673712	17285	305	3	2
2014-03-26 22:22:42.71148	32167	24.4	1	10
2014-03-26 22:22:42.9495	32168	41	2	10
2014-03-26 03:28:39.164212	17290	20.7	1	8
2014-03-26 03:28:39.396487	17291	51	2	8
2014-03-26 03:28:54.332268	17292	18.6	1	1
2014-03-26 03:28:54.555856	17293	48	2	1
2014-03-26 22:22:53.046706	32169	22.0	1	9
2014-03-26 22:22:53.272069	32170	47	2	9
2014-03-26 03:29:18.165396	17298	20.7	1	8
2014-03-26 03:29:18.399268	17299	51	2	8
2014-03-26 03:29:32.673564	17300	305	3	2
2014-03-26 03:29:33.332353	17301	18.6	1	1
2014-03-26 03:29:33.5574	17302	48	2	1
2014-03-26 22:22:54.135038	32171	21.9	1	8
2014-03-26 22:22:54.368691	32172	48	2	8
2014-03-26 03:29:57.164348	17307	20.7	1	8
2014-03-26 03:29:57.385631	17308	51	2	8
2014-03-26 03:30:12.331592	17309	18.6	1	1
2014-03-26 03:30:12.564586	17310	48	2	1
2014-03-26 03:30:32.672901	17311	305	3	2
2014-03-26 22:23:08.920398	32173	20.2	1	1
2014-03-26 22:23:09.144433	32174	50	2	1
2014-03-26 03:30:36.164848	17316	20.7	1	8
2014-03-26 03:30:36.387369	17317	51	2	8
2014-03-26 03:30:51.330867	17318	18.6	1	1
2014-03-26 03:30:51.553049	17319	48	2	1
2014-03-26 22:23:20.557224	32175	305	3	2
2014-03-26 22:23:20.794628	32176	1088498.3457476774	4	2
2014-03-26 03:31:15.16529	17324	20.7	1	8
2014-03-26 03:31:15.386302	17325	51	2	8
2014-03-26 03:31:30.330052	17326	18.6	1	1
2014-03-26 03:31:30.5531	17327	48	2	1
2014-03-26 03:31:32.677068	17328	305	3	2
2014-03-26 22:23:21.712928	32177	24.4	1	10
2014-03-26 22:23:21.937176	32178	41	2	10
2014-03-26 03:31:54.16549	17333	20.7	1	8
2014-03-26 03:31:54.387064	17334	50	2	8
2014-03-26 03:31:56.671528	17335	338	3	2
2014-03-26 03:32:08.676283	17336	305	3	2
2014-03-26 03:32:09.327537	17337	18.6	1	1
2014-03-26 03:32:09.549496	17338	48	2	1
2014-03-26 03:32:20.675082	17339	305	3	2
2014-03-26 22:23:32.41032	32179	22.0	1	9
2014-03-26 22:23:32.65777	32180	47	2	9
2014-03-26 03:32:32.675155	17344	305	3	2
2014-03-26 03:32:33.165711	17345	20.7	1	8
2014-03-26 03:32:33.385897	17346	50	2	8
2014-03-26 03:32:48.459996	17347	18.6	1	1
2014-03-26 03:32:48.874608	17348	48	2	1
2014-03-26 22:23:32.967297	32181	305	3	2
2014-03-26 22:23:33.195318	32182	1088499.4947823987	4	2
2014-03-26 03:33:12.167253	17353	20.7	1	8
2014-03-26 03:33:12.397937	17354	50	2	8
2014-03-26 03:33:27.330783	17355	18.6	1	1
2014-03-26 03:33:27.552426	17356	48	2	1
2014-03-26 03:33:32.673305	17357	305	3	2
2014-03-26 22:23:33.503904	32183	21.9	1	8
2014-03-26 22:23:33.740634	32184	48	2	8
2014-03-26 03:33:51.168649	17362	20.7	1	8
2014-03-26 03:33:51.391054	17363	50	2	8
2014-03-26 03:34:06.329865	17364	18.6	1	1
2014-03-26 03:34:06.562867	17365	48	2	1
2014-03-26 22:23:47.684587	32185	20.2	1	1
2014-03-26 22:23:47.909622	32186	50	2	1
2014-03-26 03:34:30.164446	17370	20.7	1	8
2014-03-26 03:34:30.387363	17371	50	2	8
2014-03-26 03:34:32.671654	17372	305	3	2
2014-03-26 03:34:45.330883	17373	18.6	1	1
2014-03-26 03:34:45.553668	17374	48	2	1
2014-03-26 03:34:56.67334	17375	354	3	2
2014-03-26 22:23:56.557944	32187	338	3	2
2014-03-26 22:23:56.793572	32188	1088501.7928518415	4	2
2014-03-26 03:35:08.673695	17380	354	3	2
2014-03-26 03:35:09.165098	17381	20.7	1	8
2014-03-26 03:35:09.387671	17382	50	2	8
2014-03-26 03:35:24.32728	17383	18.6	1	1
2014-03-26 03:35:24.603655	17384	48	2	1
2014-03-26 03:35:32.674222	17385	354	3	2
2014-03-26 22:24:00.712746	32189	24.4	1	10
2014-03-26 22:24:00.937641	32190	41	2	10
2014-03-26 03:35:48.164811	17390	20.7	1	8
2014-03-26 03:35:48.387372	17391	50	2	8
2014-03-26 03:35:56.674573	17392	434	3	2
2014-03-26 03:36:03.325296	17393	18.6	1	1
2014-03-26 03:36:03.604616	17394	48	2	1
2014-03-26 03:36:08.67719	17395	434	3	2
2014-03-26 22:24:08.558967	32191	305	3	2
2014-03-26 22:24:08.79529	32192	1088502.941886563	4	2
2014-03-26 03:36:27.164544	17400	20.7	1	8
2014-03-26 03:36:27.395043	17401	50	2	8
2014-03-26 03:36:32.672497	17402	434	3	2
2014-03-26 03:36:42.327473	17403	18.6	1	1
2014-03-26 03:36:42.549448	17404	48	2	1
2014-03-26 22:24:11.045268	32193	22.0	1	9
2014-03-26 03:27:58.093362	17277	21.4	1	10
2014-03-26 03:27:58.315722	17278	48	2	10
2014-03-26 03:28:37.093201	17286	21.4	1	10
2014-03-26 03:28:37.316718	17287	48	2	10
2014-03-26 03:29:16.092666	17294	21.4	1	10
2014-03-26 03:29:16.328891	17295	48	2	10
2014-03-26 03:29:55.092217	17303	21.4	1	10
2014-03-26 03:29:55.313371	17304	48	2	10
2014-03-26 03:30:34.092049	17312	21.4	1	10
2014-03-26 03:30:34.314444	17313	48	2	10
2014-03-26 03:31:13.092084	17320	21.4	1	10
2014-03-26 03:31:13.314154	17321	48	2	10
2014-03-26 03:31:52.093148	17329	21.4	1	10
2014-03-26 03:31:52.317273	17330	48	2	10
2014-03-26 03:32:31.093123	17340	21.4	1	10
2014-03-26 03:32:31.314964	17341	48	2	10
2014-03-26 03:33:10.096018	17349	21.4	1	10
2014-03-26 03:33:10.339674	17350	48	2	10
2014-03-26 03:33:49.094002	17358	21.4	1	10
2014-03-26 03:33:49.319784	17359	48	2	10
2014-03-26 03:34:28.104107	17366	21.4	1	10
2014-03-26 03:34:28.328144	17367	48	2	10
2014-03-26 03:35:07.093446	17376	21.4	1	10
2014-03-26 03:35:07.327421	17377	48	2	10
2014-03-26 03:35:46.093264	17386	21.4	1	10
2014-03-26 03:35:46.335663	17387	48	2	10
2014-03-26 03:36:25.094528	17396	21.5	1	10
2014-03-26 03:36:25.335706	17397	48	2	10
2014-03-26 03:37:06.166091	17409	20.7	1	8
2014-03-26 03:37:06.387943	17410	50	2	8
2014-03-26 03:37:21.325454	17411	18.6	1	1
2014-03-26 03:37:21.557088	17412	48	2	1
2014-03-26 03:37:32.674594	17413	434	3	2
2014-03-26 22:24:11.269491	32194	47	2	9
2014-03-26 22:24:12.13414	32195	21.9	1	8
2014-03-26 03:37:45.165132	17418	20.7	1	8
2014-03-26 03:37:45.397475	17419	50	2	8
2014-03-26 03:38:00.327416	17420	18.6	1	1
2014-03-26 03:38:00.552431	17421	48	2	1
2014-03-26 22:24:12.366758	32196	48	2	8
2014-03-26 22:24:20.557435	32197	338	3	2
2014-03-26 03:38:24.165063	17426	20.7	1	8
2014-03-26 03:38:24.398678	17427	50	2	8
2014-03-26 03:38:32.6724	17428	434	3	2
2014-03-26 03:38:39.325138	17429	18.6	1	1
2014-03-26 03:38:39.54627	17430	48	2	1
2014-03-26 22:24:20.780928	32198	1088504.0909212844	4	2
2014-03-26 22:24:26.682126	32199	20.2	1	1
2014-03-26 03:39:03.166868	17435	20.7	1	8
2014-03-26 03:39:03.387832	17436	50	2	8
2014-03-26 03:39:18.327069	17437	18.6	1	1
2014-03-26 03:39:18.558713	17438	48	2	1
2014-03-26 03:39:20.67459	17439	370	3	2
2014-03-26 03:39:32.674833	17440	370	3	2
2014-03-26 22:24:26.919437	32200	50	2	1
2014-03-26 22:24:32.557792	32201	370	3	2
2014-03-26 03:39:42.164866	17445	20.7	1	8
2014-03-26 03:39:42.3986	17446	50	2	8
2014-03-26 03:39:57.321198	17447	18.6	1	1
2014-03-26 03:39:57.54358	17448	48	2	1
2014-03-26 22:24:32.78323	32202	1088505.239956006	4	2
2014-03-26 22:24:39.710574	32203	24.4	1	10
2014-03-26 03:40:21.165972	17453	20.7	1	8
2014-03-26 03:40:21.400973	17454	50	2	8
2014-03-26 03:40:32.674016	17455	370	3	2
2014-03-26 03:40:36.324383	17456	18.6	1	1
2014-03-26 03:40:36.547908	17457	48	2	1
2014-03-26 22:24:39.948437	32204	41	2	10
2014-03-26 22:24:44.557804	32205	370	3	2
2014-03-26 03:41:00.164731	17462	20.7	1	8
2014-03-26 03:41:00.38898	17463	50	2	8
2014-03-26 03:41:15.321904	17464	18.6	1	1
2014-03-26 03:41:15.555091	17465	48	2	1
2014-03-26 03:41:32.674396	17466	370	3	2
2014-03-26 22:24:44.783864	32206	1088506.3889907273	4	2
2014-03-26 22:24:50.045727	32207	21.9	1	9
2014-03-26 03:41:39.16524	17471	20.7	1	8
2014-03-26 03:41:39.395283	17472	50	2	8
2014-03-26 03:41:54.324115	17473	18.6	1	1
2014-03-26 03:41:54.547139	17474	48	2	1
2014-03-26 22:24:50.284044	32208	48	2	9
2014-03-26 22:24:51.134701	32209	21.9	1	8
2014-03-26 03:42:18.16468	17479	20.7	1	8
2014-03-26 03:42:18.397042	17480	50	2	8
2014-03-26 03:42:32.672491	17481	370	3	2
2014-03-26 03:42:33.321252	17482	18.6	1	1
2014-03-26 03:42:33.543225	17483	48	2	1
2014-03-26 22:24:51.35847	32210	48	2	8
2014-03-26 22:25:05.679956	32211	20.2	1	1
2014-03-26 03:42:57.293248	17488	20.7	1	8
2014-03-26 03:42:57.710035	17489	50	2	8
2014-03-26 03:43:12.321746	17490	18.6	1	1
2014-03-26 03:43:12.551895	17491	48	2	1
2014-03-26 03:43:32.673956	17492	370	3	2
2014-03-26 22:25:05.913859	32212	50	2	1
2014-03-26 22:25:18.711626	32213	24.4	1	10
2014-03-26 03:43:36.164689	17497	20.7	1	8
2014-03-26 03:43:36.386474	17498	50	2	8
2014-03-26 03:43:51.32207	17499	18.6	1	1
2014-03-26 03:43:51.54441	17500	48	2	1
2014-03-26 22:25:18.937071	32214	41	2	10
2014-03-26 22:25:29.047705	32215	21.9	1	9
2014-03-26 03:44:15.166206	17505	20.7	1	8
2014-03-26 03:44:15.3987	17506	50	2	8
2014-03-26 03:44:30.322424	17507	18.6	1	1
2014-03-26 03:44:30.54572	17508	48	2	1
2014-03-26 03:44:32.670225	17509	354	3	2
2014-03-26 22:25:29.28172	32216	48	2	9
2014-03-26 22:25:30.135456	32217	21.9	1	8
2014-03-26 03:44:54.16516	17514	20.7	1	8
2014-03-26 03:44:54.389298	17515	50	2	8
2014-03-26 03:45:09.321445	17516	18.6	1	1
2014-03-26 03:45:09.545066	17517	48	2	1
2014-03-26 22:25:30.361008	32218	48	2	8
2014-03-26 22:25:32.555773	32219	370	3	2
2014-03-26 03:45:32.672684	17522	370	3	2
2014-03-26 03:45:33.165466	17523	20.7	1	8
2014-03-26 03:45:33.389123	17524	50	2	8
2014-03-26 03:45:48.319619	17525	18.6	1	1
2014-03-26 03:45:48.545077	17526	47	2	1
2014-03-26 22:25:32.789798	32220	1088510.985129613	4	2
2014-03-26 22:25:44.681237	32221	20.2	1	1
2014-03-26 03:46:12.164565	17531	20.7	1	8
2014-03-26 03:46:12.407073	17532	50	2	8
2014-03-26 03:46:27.32213	17533	18.6	1	1
2014-03-26 03:46:27.546273	17534	47	2	1
2014-03-26 03:46:32.671304	17535	434	3	2
2014-03-26 03:46:44.673676	17536	434	3	2
2014-03-26 22:25:44.906232	32222	50	2	1
2014-03-26 03:46:51.16454	17541	20.7	1	8
2014-03-26 03:46:51.385739	17542	50	2	8
2014-03-26 03:47:06.323035	17543	18.6	1	1
2014-03-26 03:47:06.546456	17544	47	2	1
2014-03-26 03:37:43.095046	17414	21.5	1	10
2014-03-26 03:37:43.317384	17415	48	2	10
2014-03-26 03:38:22.098686	17422	21.5	1	10
2014-03-26 03:38:22.330664	17423	48	2	10
2014-03-26 03:39:01.095714	17431	21.5	1	10
2014-03-26 03:39:01.319841	17432	48	2	10
2014-03-26 03:39:40.095639	17441	21.5	1	10
2014-03-26 03:39:40.341653	17442	48	2	10
2014-03-26 03:40:19.095443	17449	21.5	1	10
2014-03-26 03:40:19.326951	17450	48	2	10
2014-03-26 03:40:58.096641	17458	21.5	1	10
2014-03-26 03:40:58.318407	17459	48	2	10
2014-03-26 03:41:37.097011	17467	21.5	1	10
2014-03-26 03:41:37.319565	17468	48	2	10
2014-03-26 03:42:16.097568	17475	21.5	1	10
2014-03-26 03:42:16.329782	17476	48	2	10
2014-03-26 03:42:55.098683	17484	21.5	1	10
2014-03-26 03:42:55.323325	17485	48	2	10
2014-03-26 03:43:34.107006	17493	21.5	1	10
2014-03-26 03:43:34.330047	17494	48	2	10
2014-03-26 03:44:13.100908	17501	21.5	1	10
2014-03-26 03:44:13.33443	17502	48	2	10
2014-03-26 03:44:52.098183	17510	21.5	1	10
2014-03-26 03:44:52.323442	17511	48	2	10
2014-03-26 03:45:31.279183	17518	21.5	1	10
2014-03-26 03:45:31.503879	17519	48	2	10
2014-03-26 03:46:10.097522	17527	21.5	1	10
2014-03-26 03:46:10.330426	17528	48	2	10
2014-03-26 22:25:57.711057	32223	24.4	1	10
2014-03-26 22:25:57.950434	32224	41	2	10
2014-03-26 03:47:30.165261	17549	20.7	1	8
2014-03-26 03:47:30.397406	17550	50	2	8
2014-03-26 03:47:45.122877	17551	418	3	2
2014-03-26 03:47:45.432285	17552	18.5	1	1
2014-03-26 03:47:45.654291	17553	47	2	1
2014-03-26 22:26:08.044672	32225	21.9	1	9
2014-03-26 22:26:08.272425	32226	48	2	9
2014-03-26 03:48:09.16515	17558	20.7	1	8
2014-03-26 03:48:09.388752	17559	50	2	8
2014-03-26 03:48:24.316327	17560	18.5	1	1
2014-03-26 03:48:24.546896	17561	47	2	1
2014-03-26 03:48:32.672846	17562	418	3	2
2014-03-26 22:26:09.136528	32227	21.9	1	8
2014-03-26 22:26:09.380887	32228	48	2	8
2014-03-26 03:48:48.165346	17567	20.7	1	8
2014-03-26 03:48:48.387771	17568	50	2	8
2014-03-26 03:49:03.322861	17569	18.5	1	1
2014-03-26 03:49:03.546969	17570	47	2	1
2014-03-26 22:26:20.555576	32229	402	3	2
2014-03-26 22:26:20.781012	32230	1088516.73030322	4	2
2014-03-26 03:49:27.166386	17575	20.7	1	8
2014-03-26 03:49:27.407867	17576	50	2	8
2014-03-26 03:49:32.67199	17577	418	3	2
2014-03-26 03:49:42.317458	17578	18.5	1	1
2014-03-26 03:49:42.540976	17579	47	2	1
2014-03-26 22:26:23.677011	32231	20.2	1	1
2014-03-26 22:26:23.912261	32232	50	2	1
2014-03-26 03:50:06.164309	17584	20.7	1	8
2014-03-26 03:50:06.388132	17585	50	2	8
2014-03-26 03:50:21.320662	17586	18.5	1	1
2014-03-26 03:50:21.555597	17587	47	2	1
2014-03-26 03:50:32.670978	17588	418	3	2
2014-03-26 22:26:32.559551	32233	402	3	2
2014-03-26 22:26:32.786475	32234	1088517.8793379413	4	2
2014-03-26 03:50:45.164918	17593	20.7	1	8
2014-03-26 03:50:45.388239	17594	50	2	8
2014-03-26 03:51:00.317203	17595	18.5	1	1
2014-03-26 03:51:00.540579	17596	47	2	1
2014-03-26 03:51:08.671648	17597	354	3	2
2014-03-26 03:51:20.674759	17598	354	3	2
2014-03-26 22:26:36.711104	32235	24.4	1	10
2014-03-26 22:26:36.944619	32236	41	2	10
2014-03-26 03:51:24.164743	17603	20.7	1	8
2014-03-26 03:51:24.386475	17604	50	2	8
2014-03-26 03:51:32.670814	17605	305	3	2
2014-03-26 03:51:39.316864	17606	18.5	1	1
2014-03-26 03:51:39.541515	17607	47	2	1
2014-03-26 03:51:44.670406	17608	305	3	2
2014-03-26 22:26:47.046266	32237	21.9	1	9
2014-03-26 22:26:47.271203	32238	48	2	9
2014-03-26 03:52:03.164289	17613	20.7	1	8
2014-03-26 03:52:03.386086	17614	50	2	8
2014-03-26 03:52:18.317804	17615	18.5	1	1
2014-03-26 03:52:18.550287	17616	47	2	1
2014-03-26 03:52:32.672182	17617	305	3	2
2014-03-26 22:26:48.133627	32239	21.9	1	8
2014-03-26 22:26:48.370304	32240	48	2	8
2014-03-26 03:52:42.165114	17622	20.7	1	8
2014-03-26 03:52:42.386991	17623	50	2	8
2014-03-26 03:52:57.317897	17624	18.5	1	1
2014-03-26 03:52:57.541552	17625	47	2	1
2014-03-26 22:26:56.557369	32241	370	3	2
2014-03-26 22:26:56.782388	32242	1088520.1774073842	4	2
2014-03-26 03:53:21.290021	17630	20.7	1	8
2014-03-26 03:53:21.729852	17631	50	2	8
2014-03-26 03:53:32.674611	17632	305	3	2
2014-03-26 03:53:36.315626	17633	18.5	1	1
2014-03-26 03:53:36.538035	17634	47	2	1
2014-03-26 22:27:02.680738	32243	20.2	1	1
2014-03-26 22:27:02.914582	32244	50	2	1
2014-03-26 03:54:00.165174	17639	20.7	1	8
2014-03-26 03:54:00.397753	17640	50	2	8
2014-03-26 03:54:15.356289	17641	18.5	1	1
2014-03-26 03:54:15.579448	17642	47	2	1
2014-03-26 03:54:32.672939	17643	305	3	2
2014-03-26 22:27:08.55586	32245	370	3	2
2014-03-26 22:27:08.781383	32246	1088521.3264421057	4	2
2014-03-26 03:54:39.165882	17648	20.7	1	8
2014-03-26 03:54:39.387714	17649	50	2	8
2014-03-26 03:54:54.315701	17650	18.5	1	1
2014-03-26 03:54:54.547199	17651	47	2	1
2014-03-26 22:27:15.711198	32247	24.4	1	10
2014-03-26 22:27:15.946586	32248	41	2	10
2014-03-26 03:55:18.165568	17656	20.7	1	8
2014-03-26 03:55:18.38841	17657	50	2	8
2014-03-26 03:55:33.119335	17658	305	3	2
2014-03-26 03:55:33.438171	17659	18.5	1	1
2014-03-26 03:55:33.661625	17660	47	2	1
2014-03-26 22:27:20.557833	32249	402	3	2
2014-03-26 22:27:20.782359	32250	1088522.475476827	4	2
2014-03-26 03:55:57.166553	17665	20.7	1	8
2014-03-26 03:55:57.410019	17666	50	2	8
2014-03-26 03:56:12.313574	17667	18.5	1	1
2014-03-26 03:56:12.53786	17668	47	2	1
2014-03-26 03:56:32.668651	17669	305	3	2
2014-03-26 22:27:26.045287	32251	21.9	1	9
2014-03-26 22:27:26.306312	32252	48	2	9
2014-03-26 22:27:27.134376	32253	21.9	1	8
2014-03-26 03:56:36.380218	17674	20.7	1	8
2014-03-26 03:56:36.604405	17675	50	2	8
2014-03-26 03:56:51.314649	17676	18.5	1	1
2014-03-26 03:56:51.548612	17677	47	2	1
2014-03-26 03:47:28.098777	17545	21.5	1	10
2014-03-26 03:47:28.333374	17546	48	2	10
2014-03-26 03:48:07.098792	17554	21.5	1	10
2014-03-26 03:48:07.322716	17555	48	2	10
2014-03-26 03:48:46.099292	17563	21.5	1	10
2014-03-26 03:48:46.324282	17564	48	2	10
2014-03-26 03:49:25.100415	17571	21.5	1	10
2014-03-26 03:49:25.323459	17572	48	2	10
2014-03-26 03:50:04.099528	17580	21.5	1	10
2014-03-26 03:50:04.323844	17581	48	2	10
2014-03-26 03:50:43.098861	17589	21.5	1	10
2014-03-26 03:50:43.324578	17590	48	2	10
2014-03-26 03:51:22.100571	17599	21.5	1	10
2014-03-26 03:51:22.323431	17600	48	2	10
2014-03-26 03:52:01.09955	17609	21.5	1	10
2014-03-26 03:52:01.32337	17610	48	2	10
2014-03-26 03:52:40.100749	17618	21.5	1	10
2014-03-26 03:52:40.343177	17619	48	2	10
2014-03-26 03:53:19.230084	17626	21.5	1	10
2014-03-26 03:53:19.649012	17627	48	2	10
2014-03-26 03:53:58.099969	17635	21.5	1	10
2014-03-26 03:53:58.333935	17636	48	2	10
2014-03-26 03:54:37.104013	17644	21.5	1	10
2014-03-26 03:54:37.327473	17645	48	2	10
2014-03-26 03:55:16.100399	17652	21.5	1	10
2014-03-26 03:55:16.329573	17653	48	2	10
2014-03-26 03:55:55.102511	17661	21.5	1	10
2014-03-26 03:55:55.336568	17662	48	2	10
2014-03-26 03:56:34.101897	17670	21.5	1	10
2014-03-26 22:27:27.357796	32254	48	2	8
2014-03-26 03:57:15.164844	17682	20.7	1	8
2014-03-26 03:57:15.386536	17683	50	2	8
2014-03-26 03:57:30.31432	17684	18.5	1	1
2014-03-26 03:57:30.545864	17685	47	2	1
2014-03-26 03:57:32.673563	17686	305	3	2
2014-03-26 22:27:32.556559	32255	402	3	2
2014-03-26 22:27:32.793615	32256	1088523.6245115486	4	2
2014-03-26 03:57:54.164001	17691	20.7	1	8
2014-03-26 03:57:54.394475	17692	50	2	8
2014-03-26 03:58:09.314577	17693	18.5	1	1
2014-03-26 03:58:09.543251	17694	47	2	1
2014-03-26 22:27:41.677455	32257	20.2	1	1
2014-03-26 22:27:41.906232	32258	50	2	1
2014-03-26 03:58:32.673472	17699	305	3	2
2014-03-26 03:58:33.164518	17700	20.7	1	8
2014-03-26 03:58:33.387013	17701	50	2	8
2014-03-26 03:58:48.31528	17702	18.5	1	1
2014-03-26 03:58:48.545938	17703	47	2	1
2014-03-26 03:58:56.671025	17704	354	3	2
2014-03-26 03:59:08.66951	17705	354	3	2
2014-03-26 22:27:54.712939	32259	24.4	1	10
2014-03-26 22:27:54.946305	32260	41	2	10
2014-03-26 03:59:12.16426	17710	20.7	1	8
2014-03-26 03:59:12.410122	17711	50	2	8
2014-03-26 03:59:27.314738	17712	18.5	1	1
2014-03-26 03:59:27.537236	17713	47	2	1
2014-03-26 03:59:32.670159	17714	354	3	2
2014-03-26 22:28:05.045389	32261	21.9	1	9
2014-03-26 22:28:05.269607	32262	48	2	9
2014-03-26 03:59:51.168467	17719	20.7	1	8
2014-03-26 03:59:51.392796	17720	50	2	8
2014-03-26 04:00:06.314493	17721	18.5	1	1
2014-03-26 04:00:06.547362	17722	47	2	1
2014-03-26 22:28:06.135361	32263	21.9	1	8
2014-03-26 22:28:06.368763	32264	48	2	8
2014-03-26 04:00:30.165315	17727	20.7	1	8
2014-03-26 04:00:30.387786	17728	50	2	8
2014-03-26 04:00:32.670777	17729	354	3	2
2014-03-26 04:00:45.315431	17730	18.5	1	1
2014-03-26 04:00:45.539216	17731	47	2	1
2014-03-26 22:28:08.55645	32265	370	3	2
2014-03-26 22:28:08.781654	32266	1088527.076086665	4	2
2014-03-26 04:01:09.164163	17736	20.7	1	8
2014-03-26 04:01:09.394169	17737	50	2	8
2014-03-26 04:01:24.315827	17738	18.5	1	1
2014-03-26 04:01:24.537544	17739	47	2	1
2014-03-26 04:01:32.672506	17740	354	3	2
2014-03-26 22:28:20.915003	32267	20.2	1	1
2014-03-26 22:28:21.150313	32268	50	2	1
2014-03-26 04:01:48.164408	17745	20.7	1	8
2014-03-26 04:01:48.387633	17746	50	2	8
2014-03-26 04:02:03.312921	17747	18.5	1	1
2014-03-26 04:02:03.546837	17748	47	2	1
2014-03-26 22:28:32.55531	32269	370	3	2
2014-03-26 22:28:32.782719	32270	1088529.374156108	4	2
2014-03-26 04:02:27.163808	17753	20.7	1	8
2014-03-26 04:02:27.406667	17754	50	2	8
2014-03-26 04:02:32.669904	17755	354	3	2
2014-03-26 04:02:42.312376	17756	18.5	1	1
2014-03-26 04:02:42.535577	17757	47	2	1
2014-03-26 22:28:33.714027	32271	24.4	1	10
2014-03-26 22:28:33.94751	32272	41	2	10
2014-03-26 04:03:06.163665	17762	20.7	1	8
2014-03-26 04:03:06.385062	17763	50	2	8
2014-03-26 04:03:21.311106	17764	18.5	1	1
2014-03-26 04:03:21.534723	17765	47	2	1
2014-03-26 04:03:32.8017	17766	354	3	2
2014-03-26 22:28:44.045765	32273	21.9	1	9
2014-03-26 22:28:44.270585	32274	48	2	9
2014-03-26 04:03:45.164371	17771	20.7	1	8
2014-03-26 04:03:45.385778	17772	50	2	8
2014-03-26 04:04:00.312256	17773	18.5	1	1
2014-03-26 04:04:00.543845	17774	47	2	1
2014-03-26 04:04:08.673744	17775	305	3	2
2014-03-26 04:04:20.67137	17776	305	3	2
2014-03-26 22:28:44.579862	32275	402	3	2
2014-03-26 22:28:44.825108	32276	1088530.5231908292	4	2
2014-03-26 04:04:24.166032	17781	20.7	1	8
2014-03-26 04:04:24.399359	17782	50	2	8
2014-03-26 04:04:32.672478	17783	305	3	2
2014-03-26 04:04:39.309485	17784	18.5	1	1
2014-03-26 04:04:39.536533	17785	47	2	1
2014-03-26 22:28:45.134113	32277	21.9	1	8
2014-03-26 22:28:45.357383	32278	48	2	8
2014-03-26 04:05:03.164721	17790	20.7	1	8
2014-03-26 04:05:03.388754	17791	50	2	8
2014-03-26 04:05:18.312695	17792	18.5	1	1
2014-03-26 04:05:18.546274	17793	47	2	1
2014-03-26 04:05:32.670944	17794	338	3	2
2014-03-26 22:28:56.556642	32279	370	3	2
2014-03-26 22:28:56.794267	32280	1088531.6722255505	4	2
2014-03-26 04:05:42.167455	17799	20.7	1	8
2014-03-26 04:05:42.416715	17800	50	2	8
2014-03-26 04:05:44.672175	17801	338	3	2
2014-03-26 04:05:57.306633	17802	18.5	1	1
2014-03-26 04:05:57.528096	17803	47	2	1
2014-03-26 22:28:59.680063	32281	20.2	1	1
2014-03-26 22:28:59.904985	32282	50	2	1
2014-03-26 04:06:21.165496	17808	20.7	1	8
2014-03-26 04:06:21.390391	17809	50	2	8
2014-03-26 04:06:32.671011	17810	338	3	2
2014-03-26 04:06:36.368044	17811	18.5	1	1
2014-03-26 04:06:36.590617	17812	47	2	1
2014-03-26 04:06:56.672966	17813	305	3	2
2014-03-26 03:57:52.102072	17687	21.5	1	10
2014-03-26 03:57:52.326726	17688	48	2	10
2014-03-26 03:58:31.102819	17695	21.5	1	10
2014-03-26 03:58:31.334289	17696	48	2	10
2014-03-26 03:59:10.102461	17706	21.5	1	10
2014-03-26 03:59:10.334971	17707	48	2	10
2014-03-26 03:59:49.104868	17715	21.6	1	10
2014-03-26 03:59:49.326802	17716	48	2	10
2014-03-26 04:00:28.102468	17723	21.6	1	10
2014-03-26 04:00:28.327706	17724	48	2	10
2014-03-26 04:01:07.103506	17732	21.6	1	10
2014-03-26 04:01:07.329537	17733	48	2	10
2014-03-26 04:01:46.102774	17741	21.6	1	10
2014-03-26 04:01:46.327159	17742	48	2	10
2014-03-26 04:02:25.104122	17749	21.6	1	10
2014-03-26 04:02:25.328128	17750	48	2	10
2014-03-26 04:03:04.104091	17758	21.6	1	10
2014-03-26 04:03:04.38378	17759	48	2	10
2014-03-26 04:03:43.104964	17767	21.6	1	10
2014-03-26 04:03:43.328115	17768	48	2	10
2014-03-26 04:04:22.103392	17777	21.6	1	10
2014-03-26 04:04:22.338464	17778	48	2	10
2014-03-26 04:05:01.108797	17786	21.6	1	10
2014-03-26 04:05:01.334417	17787	48	2	10
2014-03-26 04:05:40.108001	17795	21.6	1	10
2014-03-26 04:05:40.334145	17796	48	2	10
2014-03-26 04:06:19.105218	17804	21.6	1	10
2014-03-26 04:06:19.333635	17805	48	2	10
2014-03-26 22:29:08.555743	32283	370	3	2
2014-03-26 04:07:00.168807	17818	20.7	1	8
2014-03-26 04:07:00.406812	17819	50	2	8
2014-03-26 04:07:08.667748	17820	338	3	2
2014-03-26 04:07:15.306069	17821	18.5	1	1
2014-03-26 04:07:15.531428	17822	47	2	1
2014-03-26 04:07:20.669038	17823	338	3	2
2014-03-26 04:07:32.66733	17824	338	3	2
2014-03-26 22:29:08.793652	32284	1088532.821260272	4	2
2014-03-26 22:29:12.712473	32285	24.4	1	10
2014-03-26 04:07:39.16542	17829	20.7	1	8
2014-03-26 04:07:39.398104	17830	50	2	8
2014-03-26 04:07:54.307876	17831	18.5	1	1
2014-03-26 04:07:54.533748	17832	47	2	1
2014-03-26 22:29:12.936818	32286	41	2	10
2014-03-26 22:29:20.554871	32287	338	3	2
2014-03-26 04:08:18.164489	17837	20.7	1	8
2014-03-26 04:08:18.397241	17838	50	2	8
2014-03-26 04:08:32.673616	17839	338	3	2
2014-03-26 04:08:33.3101	17840	18.5	1	1
2014-03-26 04:08:33.534732	17841	47	2	1
2014-03-26 22:29:20.790792	32288	1088533.9702949934	4	2
2014-03-26 22:29:23.04481	32289	21.9	1	9
2014-03-26 04:08:57.164606	17846	20.7	1	8
2014-03-26 04:08:57.385234	17847	50	2	8
2014-03-26 04:09:12.309768	17848	18.4	1	1
2014-03-26 04:09:12.535197	17849	47	2	1
2014-03-26 04:09:32.669797	17850	338	3	2
2014-03-26 22:29:23.271888	32290	48	2	9
2014-03-26 22:29:24.134172	32291	21.9	1	8
2014-03-26 04:09:36.163964	17855	20.7	1	8
2014-03-26 04:09:36.422863	17856	50	2	8
2014-03-26 04:09:44.669378	17857	305	3	2
2014-03-26 04:09:51.306772	17858	18.4	1	1
2014-03-26 04:09:51.529468	17859	47	2	1
2014-03-26 04:09:56.670543	17860	338	3	2
2014-03-26 04:10:08.668262	17861	338	3	2
2014-03-26 22:29:24.370605	32292	48	2	8
2014-03-26 22:29:32.555068	32293	338	3	2
2014-03-26 04:10:15.164982	17866	20.7	1	8
2014-03-26 04:10:15.390037	17867	50	2	8
2014-03-26 04:10:30.307755	17868	18.4	1	1
2014-03-26 04:10:30.540863	17869	47	2	1
2014-03-26 04:10:32.670712	17870	338	3	2
2014-03-26 22:29:32.780963	32294	1088535.119329715	4	2
2014-03-26 22:29:38.678535	32295	20.2	1	1
2014-03-26 04:10:54.167264	17875	20.7	1	8
2014-03-26 04:10:54.39822	17876	50	2	8
2014-03-26 04:11:09.304001	17877	18.4	1	1
2014-03-26 04:11:09.535499	17878	47	2	1
2014-03-26 22:29:38.91595	32296	50	2	1
2014-03-26 22:29:51.712896	32297	24.4	1	10
2014-03-26 04:11:32.670028	17883	370	3	2
2014-03-26 04:11:33.164896	17884	20.7	1	8
2014-03-26 04:11:33.388893	17885	50	2	8
2014-03-26 04:11:44.671768	17886	370	3	2
2014-03-26 04:11:48.310565	17887	18.4	1	1
2014-03-26 04:11:48.543189	17888	47	2	1
2014-03-26 22:29:51.938748	32298	41	2	10
2014-03-26 22:30:02.045412	32299	21.8	1	9
2014-03-26 04:12:12.165925	17893	20.7	1	8
2014-03-26 04:12:12.39056	17894	50	2	8
2014-03-26 04:12:27.304546	17895	18.4	1	1
2014-03-26 04:12:27.730218	17896	47	2	1
2014-03-26 04:12:32.6687	17897	354	3	2
2014-03-26 22:30:02.2796	32300	48	2	9
2014-03-26 22:30:03.134647	32301	21.9	1	8
2014-03-26 04:12:51.163063	17902	20.7	1	8
2014-03-26 04:12:51.393835	17903	50	2	8
2014-03-26 04:13:06.303029	17904	18.4	1	1
2014-03-26 04:13:06.526394	17905	47	2	1
2014-03-26 22:30:03.358217	32302	48	2	8
2014-03-26 22:30:17.676872	32303	20.2	1	1
2014-03-26 04:13:30.16432	17910	20.7	1	8
2014-03-26 04:13:30.394955	17911	50	2	8
2014-03-26 04:13:32.67303	17912	354	3	2
2014-03-26 04:13:45.42997	17913	18.4	1	1
2014-03-26 04:13:45.850003	17914	47	2	1
2014-03-26 22:30:17.911392	32304	50	2	1
2014-03-26 22:30:30.712692	32305	24.4	1	10
2014-03-26 04:14:09.162456	17919	20.7	1	8
2014-03-26 04:14:09.382774	17920	50	2	8
2014-03-26 04:14:24.305909	17921	18.4	1	1
2014-03-26 04:14:24.536359	17922	47	2	1
2014-03-26 04:14:32.669831	17923	354	3	2
2014-03-26 22:30:30.935759	32306	41	2	10
2014-03-26 22:30:32.557206	32307	338	3	2
2014-03-26 04:14:48.163195	17928	20.7	1	8
2014-03-26 04:14:48.39401	17929	50	2	8
2014-03-26 04:15:03.305018	17930	18.4	1	1
2014-03-26 04:15:03.528077	17931	47	2	1
2014-03-26 22:30:32.790662	32308	1088540.864503322	4	2
2014-03-26 22:30:41.047702	32309	21.8	1	9
2014-03-26 04:15:27.163658	17936	20.7	1	8
2014-03-26 04:15:27.394919	17937	50	2	8
2014-03-26 04:15:32.67019	17938	354	3	2
2014-03-26 04:15:42.302616	17939	18.4	1	1
2014-03-26 04:15:42.544272	17940	47	2	1
2014-03-26 22:30:41.271613	32310	48	2	9
2014-03-26 04:16:06.165457	17945	20.6	1	8
2014-03-26 04:16:06.387119	17946	50	2	8
2014-03-26 04:16:08.668052	17947	305	3	2
2014-03-26 04:16:20.66972	17948	305	3	2
2014-03-26 04:16:21.302435	17949	18.4	1	1
2014-03-26 04:16:21.526333	17950	47	2	1
2014-03-26 04:16:32.671409	17951	305	3	2
2014-03-26 04:07:37.113099	17825	21.6	1	10
2014-03-26 04:07:37.348667	17826	48	2	10
2014-03-26 04:08:16.107788	17833	21.6	1	10
2014-03-26 04:08:16.341406	17834	47	2	10
2014-03-26 04:08:55.106539	17842	21.6	1	10
2014-03-26 04:08:55.330381	17843	47	2	10
2014-03-26 04:09:34.106003	17851	21.6	1	10
2014-03-26 04:09:34.326304	17852	47	2	10
2014-03-26 04:10:13.10673	17862	21.6	1	10
2014-03-26 04:10:13.329688	17863	47	2	10
2014-03-26 04:10:52.108408	17871	21.6	1	10
2014-03-26 04:10:52.338419	17872	47	2	10
2014-03-26 04:11:31.106533	17879	21.6	1	10
2014-03-26 04:11:31.341435	17880	47	2	10
2014-03-26 04:12:10.1073	17889	21.6	1	10
2014-03-26 04:12:10.335634	17890	47	2	10
2014-03-26 04:12:49.107323	17898	21.6	1	10
2014-03-26 04:12:49.337626	17899	47	2	10
2014-03-26 04:13:28.107717	17906	21.6	1	10
2014-03-26 04:13:28.339533	17907	47	2	10
2014-03-26 04:14:07.106148	17915	21.6	1	10
2014-03-26 04:14:07.326622	17916	47	2	10
2014-03-26 04:14:46.107109	17924	21.6	1	10
2014-03-26 04:14:46.336796	17925	47	2	10
2014-03-26 04:15:25.11003	17932	21.6	1	10
2014-03-26 04:15:25.343016	17933	47	2	10
2014-03-26 04:16:04.109185	17941	21.6	1	10
2014-03-26 22:30:42.133373	32311	21.9	1	8
2014-03-26 22:30:42.369395	32312	48	2	8
2014-03-26 04:16:45.162579	17956	20.6	1	8
2014-03-26 04:16:45.38633	17957	50	2	8
2014-03-26 04:17:00.543929	17958	18.4	1	1
2014-03-26 04:17:00.77669	17959	47	2	1
2014-03-26 22:30:56.687574	32313	20.2	1	1
2014-03-26 22:30:56.912515	32314	50	2	1
2014-03-26 04:17:24.163333	17964	20.6	1	8
2014-03-26 04:17:24.386188	17965	50	2	8
2014-03-26 04:17:32.668631	17966	305	3	2
2014-03-26 04:17:39.299623	17967	18.4	1	1
2014-03-26 04:17:39.526905	17968	47	2	1
2014-03-26 22:31:09.712117	32315	24.4	1	10
2014-03-26 22:31:09.947258	32316	41	2	10
2014-03-26 04:18:03.163867	17973	20.6	1	8
2014-03-26 04:18:03.394152	17974	50	2	8
2014-03-26 04:18:18.305034	17975	18.4	1	1
2014-03-26 04:18:18.527873	17976	47	2	1
2014-03-26 04:18:32.671928	17977	305	3	2
2014-03-26 22:31:20.044991	32317	21.8	1	9
2014-03-26 22:31:20.270563	32318	48	2	9
2014-03-26 04:18:42.164236	17982	20.6	1	8
2014-03-26 04:18:42.389644	17983	50	2	8
2014-03-26 04:18:57.301501	17984	18.4	1	1
2014-03-26 04:18:57.54298	17985	47	2	1
2014-03-26 22:31:21.135337	32319	21.9	1	8
2014-03-26 22:31:21.369342	32320	48	2	8
2014-03-26 04:19:21.163165	17990	20.6	1	8
2014-03-26 04:19:21.385243	17991	50	2	8
2014-03-26 04:19:32.666631	17992	305	3	2
2014-03-26 04:19:36.300178	17993	18.4	1	1
2014-03-26 04:19:36.52244	17994	47	2	1
2014-03-26 22:31:32.555269	32321	338	3	2
2014-03-26 22:31:32.77952	32322	1088546.609676929	4	2
2014-03-26 04:20:00.163929	17999	20.6	1	8
2014-03-26 04:20:00.385995	18000	50	2	8
2014-03-26 04:20:15.299936	18001	18.4	1	1
2014-03-26 04:20:15.523871	18002	47	2	1
2014-03-26 04:20:32.667299	18003	305	3	2
2014-03-26 22:31:35.678965	32323	20.2	1	1
2014-03-26 22:31:35.930604	32324	50	2	1
2014-03-26 04:20:39.162816	18008	20.6	1	8
2014-03-26 04:20:39.395418	18009	50	2	8
2014-03-26 04:20:54.299827	18010	18.4	1	1
2014-03-26 04:20:54.521419	18011	47	2	1
2014-03-26 22:31:48.714189	32325	24.4	1	10
2014-03-26 22:31:48.93962	32326	41	2	10
2014-03-26 04:21:18.166114	18016	20.6	1	8
2014-03-26 04:21:18.396462	18017	50	2	8
2014-03-26 04:21:32.667746	18018	305	3	2
2014-03-26 04:21:33.300532	18019	18.4	1	1
2014-03-26 04:21:33.521011	18020	47	2	1
2014-03-26 22:31:59.046421	32327	21.8	1	9
2014-03-26 22:31:59.281302	32328	48	2	9
2014-03-26 04:21:57.499822	18025	20.6	1	8
2014-03-26 04:21:57.722682	18026	50	2	8
2014-03-26 04:22:12.303298	18027	18.4	1	1
2014-03-26 04:22:12.535051	18028	47	2	1
2014-03-26 04:22:32.66856	18029	305	3	2
2014-03-26 22:32:00.135897	32329	21.8	1	8
2014-03-26 22:32:00.360553	32330	48	2	8
2014-03-26 04:22:36.163724	18034	20.6	1	8
2014-03-26 04:22:36.395714	18035	50	2	8
2014-03-26 04:22:51.29903	18036	18.4	1	1
2014-03-26 04:22:51.523771	18037	47	2	1
2014-03-26 22:32:14.674744	32331	20.2	1	1
2014-03-26 22:32:14.908852	32332	50	2	1
2014-03-26 04:23:15.163717	18042	20.6	1	8
2014-03-26 04:23:15.396697	18043	50	2	8
2014-03-26 04:23:30.297481	18044	18.4	1	1
2014-03-26 04:23:30.520975	18045	47	2	1
2014-03-26 04:23:32.665888	18046	354	3	2
2014-03-26 04:23:44.667535	18047	354	3	2
2014-03-26 22:32:27.712011	32333	24.4	1	10
2014-03-26 22:32:27.937445	32334	41	2	10
2014-03-26 04:23:54.28994	18052	20.6	1	8
2014-03-26 04:23:54.712082	18053	50	2	8
2014-03-26 04:24:09.300276	18054	18.4	1	1
2014-03-26 04:24:09.521588	18055	47	2	1
2014-03-26 22:32:32.557796	32335	338	3	2
2014-03-26 22:32:32.791384	32336	1088552.354850536	4	2
2014-03-26 04:24:32.963344	18060	354	3	2
2014-03-26 04:24:33.279273	18061	20.6	1	8
2014-03-26 04:24:33.50115	18062	50	2	8
2014-03-26 04:24:48.29875	18063	18.4	1	1
2014-03-26 04:24:48.528602	18064	47	2	1
2014-03-26 22:32:38.045177	32337	21.8	1	9
2014-03-26 22:32:38.272761	32338	48	2	9
2014-03-26 04:25:12.167531	18069	20.6	1	8
2014-03-26 04:25:12.389965	18070	50	2	8
2014-03-26 04:25:27.300589	18071	18.4	1	1
2014-03-26 04:25:27.53201	18072	47	2	1
2014-03-26 04:25:32.667377	18073	354	3	2
2014-03-26 22:32:39.134286	32339	21.8	1	8
2014-03-26 22:32:39.370891	32340	48	2	8
2014-03-26 04:25:51.163918	18078	20.6	1	8
2014-03-26 04:25:51.384473	18079	50	2	8
2014-03-26 04:26:06.295291	18080	18.4	1	1
2014-03-26 04:26:06.517302	18081	47	2	1
2014-03-26 04:26:30.163421	18086	20.6	1	8
2014-03-26 04:26:30.393974	18087	50	2	8
2014-03-26 04:26:32.670617	18088	354	3	2
2014-03-26 04:16:43.340083	17953	47	2	10
2014-03-26 04:17:22.109105	17960	21.6	1	10
2014-03-26 04:17:22.331797	17961	47	2	10
2014-03-26 04:18:01.109432	17969	21.6	1	10
2014-03-26 04:18:01.330795	17970	47	2	10
2014-03-26 04:18:40.108635	17978	21.6	1	10
2014-03-26 04:18:40.329681	17979	47	2	10
2014-03-26 04:19:19.109804	17986	21.6	1	10
2014-03-26 04:19:19.332248	17987	47	2	10
2014-03-26 04:19:58.108825	17995	21.6	1	10
2014-03-26 04:19:58.330432	17996	47	2	10
2014-03-26 04:20:37.109928	18004	21.6	1	10
2014-03-26 04:20:37.341309	18005	47	2	10
2014-03-26 04:21:16.111574	18012	21.6	1	10
2014-03-26 04:21:16.343746	18013	47	2	10
2014-03-26 04:21:55.109034	18021	21.6	1	10
2014-03-26 04:21:55.333411	18022	47	2	10
2014-03-26 04:22:34.109245	18030	21.6	1	10
2014-03-26 04:22:34.352789	18031	47	2	10
2014-03-26 04:23:13.109322	18038	21.6	1	10
2014-03-26 04:23:13.342131	18039	47	2	10
2014-03-26 04:23:52.240044	18048	21.6	1	10
2014-03-26 04:23:52.659998	18049	47	2	10
2014-03-26 04:24:31.112172	18056	21.6	1	10
2014-03-26 04:24:31.33399	18057	47	2	10
2014-03-26 04:25:10.111588	18065	21.6	1	10
2014-03-26 04:25:10.333809	18066	47	2	10
2014-03-26 04:25:49.111012	18074	21.6	1	10
2014-03-26 04:25:49.334599	18075	47	2	10
2014-03-26 04:26:28.114975	18082	21.6	1	10
2014-03-26 04:26:45.299722	18089	18.4	1	1
2014-03-26 04:26:45.523123	18090	47	2	1
2014-03-26 22:32:53.674704	32341	20.2	1	1
2014-03-26 22:32:53.900343	32342	50	2	1
2014-03-26 04:27:09.164589	18095	20.6	1	8
2014-03-26 04:27:09.386116	18096	50	2	8
2014-03-26 04:27:24.297379	18097	18.4	1	1
2014-03-26 04:27:24.533617	18098	47	2	1
2014-03-26 04:27:32.666709	18099	354	3	2
2014-03-26 22:33:06.714163	32343	24.4	1	10
2014-03-26 22:33:06.9481	32344	41	2	10
2014-03-26 04:27:48.163416	18104	20.6	1	8
2014-03-26 04:27:48.386144	18105	50	2	8
2014-03-26 04:28:03.295436	18106	18.4	1	1
2014-03-26 04:28:03.51789	18107	47	2	1
2014-03-26 22:33:17.045007	32345	21.8	1	9
2014-03-26 22:33:17.269759	32346	48	2	9
2014-03-26 04:28:27.163437	18112	20.6	1	8
2014-03-26 04:28:27.396544	18113	50	2	8
2014-03-26 04:28:32.665605	18114	305	3	2
2014-03-26 04:28:42.297733	18115	18.3	1	1
2014-03-26 04:28:42.533057	18116	46	2	1
2014-03-26 04:28:44.668759	18117	305	3	2
2014-03-26 22:33:18.134805	32347	21.8	1	8
2014-03-26 22:33:18.368114	32348	48	2	8
2014-03-26 04:29:06.163129	18122	20.6	1	8
2014-03-26 04:29:06.394357	18123	50	2	8
2014-03-26 04:29:21.294822	18124	18.3	1	1
2014-03-26 04:29:21.516713	18125	46	2	1
2014-03-26 04:29:32.670931	18126	305	3	2
2014-03-26 22:33:32.914651	32349	20.2	1	1
2014-03-26 22:33:33.139092	32350	50	2	1
2014-03-26 04:29:45.163221	18131	20.6	1	8
2014-03-26 04:29:45.385399	18132	50	2	8
2014-03-26 04:30:00.29624	18133	18.3	1	1
2014-03-26 04:30:00.518785	18134	46	2	1
2014-03-26 22:33:45.713388	32351	24.4	1	10
2014-03-26 22:33:45.948427	32352	41	2	10
2014-03-26 04:30:24.163192	18139	20.6	1	8
2014-03-26 04:30:24.384481	18140	50	2	8
2014-03-26 04:30:32.671355	18141	305	3	2
2014-03-26 04:30:39.294709	18142	18.3	1	1
2014-03-26 04:30:39.516987	18143	46	2	1
2014-03-26 22:33:56.044462	32353	21.8	1	9
2014-03-26 22:33:56.269357	32354	48	2	9
2014-03-26 04:31:03.491973	18148	20.6	1	8
2014-03-26 04:31:03.715479	18149	50	2	8
2014-03-26 04:31:18.292628	18150	18.3	1	1
2014-03-26 04:31:18.514457	18151	46	2	1
2014-03-26 04:31:32.669651	18152	305	3	2
2014-03-26 22:33:56.580084	32355	402	3	2
2014-03-26 22:33:56.81494	32356	1088561.5471283074	4	2
2014-03-26 04:31:42.162519	18157	20.6	1	8
2014-03-26 04:31:42.384656	18158	50	2	8
2014-03-26 04:31:57.294031	18159	18.3	1	1
2014-03-26 04:31:57.526531	18160	46	2	1
2014-03-26 22:33:57.134294	32357	21.8	1	8
2014-03-26 22:33:57.35767	32358	48	2	8
2014-03-26 04:32:21.165203	18165	20.6	1	8
2014-03-26 04:32:21.385814	18166	50	2	8
2014-03-26 04:32:32.667296	18167	305	3	2
2014-03-26 04:32:36.291884	18168	18.3	1	1
2014-03-26 04:32:36.513948	18169	46	2	1
2014-03-26 22:34:08.555399	32359	402	3	2
2014-03-26 22:34:08.791587	32360	1088562.6961630287	4	2
2014-03-26 04:33:00.162821	18174	20.6	1	8
2014-03-26 04:33:00.449375	18175	50	2	8
2014-03-26 04:33:15.293015	18176	18.3	1	1
2014-03-26 04:33:15.670907	18177	46	2	1
2014-03-26 04:33:32.666157	18178	305	3	2
2014-03-26 22:34:11.677991	32361	20.2	1	1
2014-03-26 22:34:11.902062	32362	50	2	1
2014-03-26 04:33:39.16191	18183	20.6	1	8
2014-03-26 04:33:39.386081	18184	50	2	8
2014-03-26 04:33:54.291369	18185	18.3	1	1
2014-03-26 04:33:54.52503	18186	46	2	1
2014-03-26 04:34:08.800072	18187	370	3	2
2014-03-26 22:34:24.716357	32363	24.4	1	10
2014-03-26 22:34:24.952325	32364	41	2	10
2014-03-26 04:34:18.306408	18192	20.6	1	8
2014-03-26 04:34:18.771168	18193	50	2	8
2014-03-26 04:34:20.791138	18194	370	3	2
2014-03-26 04:34:32.668661	18195	370	3	2
2014-03-26 04:34:33.296055	18196	18.3	1	1
2014-03-26 04:34:33.529303	18197	46	2	1
2014-03-26 22:34:32.555492	32365	418	3	2
2014-03-26 22:34:32.782818	32366	1088564.9942324716	4	2
2014-03-26 04:34:57.163819	18202	20.6	1	8
2014-03-26 04:34:57.387712	18203	50	2	8
2014-03-26 04:35:12.295501	18204	18.3	1	1
2014-03-26 04:35:12.528545	18205	46	2	1
2014-03-26 04:35:32.668479	18206	370	3	2
2014-03-26 22:34:35.045896	32367	21.8	1	9
2014-03-26 22:34:35.286115	32368	48	2	9
2014-03-26 04:35:36.162433	18211	20.6	1	8
2014-03-26 04:35:36.385915	18212	50	2	8
2014-03-26 04:35:44.668301	18213	402	3	2
2014-03-26 04:35:51.289079	18214	18.3	1	1
2014-03-26 04:35:51.514578	18215	46	2	1
2014-03-26 04:35:56.66768	18216	434	3	2
2014-03-26 04:36:08.667	18217	434	3	2
2014-03-26 22:34:36.134433	32369	21.8	1	8
2014-03-26 04:36:15.162571	18222	20.6	1	8
2014-03-26 04:36:15.394171	18223	50	2	8
2014-03-26 04:36:30.33418	18224	18.3	1	1
2014-03-26 04:27:07.113502	18091	21.6	1	10
2014-03-26 04:27:07.334785	18092	47	2	10
2014-03-26 04:27:46.111582	18100	21.6	1	10
2014-03-26 04:27:46.33592	18101	47	2	10
2014-03-26 04:28:25.110595	18108	21.6	1	10
2014-03-26 04:28:25.342439	18109	47	2	10
2014-03-26 04:29:04.112552	18118	21.6	1	10
2014-03-26 04:29:04.334298	18119	47	2	10
2014-03-26 04:29:43.11118	18127	21.6	1	10
2014-03-26 04:29:43.353818	18128	47	2	10
2014-03-26 04:30:22.112473	18135	21.6	1	10
2014-03-26 04:30:22.335643	18136	47	2	10
2014-03-26 04:31:01.112159	18144	21.6	1	10
2014-03-26 04:31:01.335416	18145	47	2	10
2014-03-26 04:31:40.112947	18153	21.6	1	10
2014-03-26 04:31:40.33571	18154	47	2	10
2014-03-26 04:32:19.114559	18161	21.6	1	10
2014-03-26 04:32:19.336537	18162	47	2	10
2014-03-26 04:32:58.112109	18170	21.6	1	10
2014-03-26 04:32:58.38284	18171	47	2	10
2014-03-26 04:33:37.112779	18179	21.6	1	10
2014-03-26 04:33:37.392045	18180	47	2	10
2014-03-26 04:34:16.240003	18188	21.6	1	10
2014-03-26 04:34:16.659981	18189	47	2	10
2014-03-26 04:34:55.1139	18198	21.6	1	10
2014-03-26 04:34:55.33578	18199	47	2	10
2014-03-26 04:35:34.113464	18207	21.6	1	10
2014-03-26 04:35:34.33561	18208	47	2	10
2014-03-26 04:36:30.556013	18225	46	2	1
2014-03-26 04:36:32.665237	18226	418	3	2
2014-03-26 22:34:36.357795	32370	48	2	8
2014-03-26 22:34:50.674691	32371	20.2	1	1
2014-03-26 04:36:54.163511	18231	20.6	1	8
2014-03-26 04:36:54.385369	18232	50	2	8
2014-03-26 04:37:09.29114	18233	18.3	1	1
2014-03-26 04:37:09.522318	18234	46	2	1
2014-03-26 22:34:50.923759	32372	50	2	1
2014-03-26 22:35:03.713654	32373	24.4	1	10
2014-03-26 04:37:32.667756	18239	418	3	2
2014-03-26 04:37:33.164805	18240	20.6	1	8
2014-03-26 04:37:33.386991	18241	50	2	8
2014-03-26 04:37:48.293645	18242	18.3	1	1
2014-03-26 04:37:48.517897	18243	46	2	1
2014-03-26 22:35:03.939774	32374	41	2	10
2014-03-26 22:35:14.046247	32375	21.7	1	9
2014-03-26 04:38:12.164413	18248	20.6	1	8
2014-03-26 04:38:12.396741	18249	50	2	8
2014-03-26 04:38:27.288568	18250	18.3	1	1
2014-03-26 04:38:27.513241	18251	46	2	1
2014-03-26 04:38:32.669426	18252	418	3	2
2014-03-26 22:35:14.282551	32376	48	2	9
2014-03-26 22:35:15.134436	32377	21.8	1	8
2014-03-26 04:38:51.162922	18257	20.6	1	8
2014-03-26 04:38:51.387081	18258	50	2	8
2014-03-26 04:39:06.290162	18259	18.3	1	1
2014-03-26 04:39:06.524071	18260	46	2	1
2014-03-26 22:35:15.359064	32378	48	2	8
2014-03-26 22:35:29.673475	32379	20.2	1	1
2014-03-26 04:39:30.162616	18265	20.6	1	8
2014-03-26 04:39:30.38405	18266	50	2	8
2014-03-26 04:39:32.66824	18267	418	3	2
2014-03-26 04:39:45.287489	18268	18.3	1	1
2014-03-26 04:39:45.511741	18269	46	2	1
2014-03-26 22:35:29.910008	32380	50	2	1
2014-03-26 22:35:32.556471	32381	418	3	2
2014-03-26 04:40:09.163919	18274	20.6	1	8
2014-03-26 04:40:09.395618	18275	50	2	8
2014-03-26 04:40:24.330642	18276	18.3	1	1
2014-03-26 04:40:24.554031	18277	46	2	1
2014-03-26 04:40:32.66601	18278	418	3	2
2014-03-26 22:35:32.784187	32382	1088571.8884408001	4	2
2014-03-26 22:35:42.713327	32383	24.4	1	10
2014-03-26 04:40:48.162401	18283	20.6	1	8
2014-03-26 04:40:48.384893	18284	50	2	8
2014-03-26 04:41:03.287981	18285	18.3	1	1
2014-03-26 04:41:03.518855	18286	46	2	1
2014-03-26 04:41:08.665487	18287	370	3	2
2014-03-26 04:41:20.668785	18288	370	3	2
2014-03-26 22:35:42.950028	32384	41	2	10
2014-03-26 22:35:53.047103	32385	21.7	1	9
2014-03-26 04:41:27.162943	18293	20.6	1	8
2014-03-26 04:41:27.394913	18294	50	2	8
2014-03-26 04:41:32.66401	18295	354	3	2
2014-03-26 04:41:42.290955	18296	18.3	1	1
2014-03-26 04:41:42.514344	18297	46	2	1
2014-03-26 22:35:53.273642	32386	48	2	9
2014-03-26 22:35:54.135692	32387	21.8	1	8
2014-03-26 04:42:06.163589	18302	20.6	1	8
2014-03-26 04:42:06.386119	18303	50	2	8
2014-03-26 04:42:21.289911	18304	18.3	1	1
2014-03-26 04:42:21.515258	18305	46	2	1
2014-03-26 04:42:32.66859	18306	370	3	2
2014-03-26 22:35:54.368924	32388	48	2	8
2014-03-26 22:36:08.67286	32389	20.2	1	1
2014-03-26 04:42:45.16267	18311	20.6	1	8
2014-03-26 04:42:45.385316	18312	50	2	8
2014-03-26 04:43:00.289073	18313	18.3	1	1
2014-03-26 04:43:00.523285	18314	46	2	1
2014-03-26 22:36:08.898422	32390	50	2	1
2014-03-26 22:36:31.843458	32391	24.4	1	10
2014-03-26 04:43:24.164158	18319	20.6	1	8
2014-03-26 04:43:24.385797	18320	50	2	8
2014-03-26 04:43:32.664947	18321	354	3	2
2014-03-26 04:43:39.287351	18322	18.3	1	1
2014-03-26 04:43:39.509303	18323	46	2	1
2014-03-26 22:36:32.079341	32392	41	2	10
2014-03-26 22:36:32.387635	32393	21.7	1	9
2014-03-26 04:44:03.161931	18328	20.6	1	8
2014-03-26 04:44:03.385743	18329	50	2	8
2014-03-26 04:44:18.285254	18330	18.3	1	1
2014-03-26 04:44:18.509944	18331	46	2	1
2014-03-26 04:44:32.809999	18332	354	3	2
2014-03-26 22:36:32.61326	32394	48	2	9
2014-03-26 22:36:32.924017	32395	402	3	2
2014-03-26 04:44:42.162941	18337	20.6	1	8
2014-03-26 04:44:42.386759	18338	50	2	8
2014-03-26 04:44:57.287282	18339	18.3	1	1
2014-03-26 04:44:57.511831	18340	46	2	1
2014-03-26 22:36:33.160419	32396	1088578.7826491287	4	2
2014-03-26 22:36:33.469405	32397	21.8	1	8
2014-03-26 04:45:21.510007	18345	20.6	1	8
2014-03-26 04:45:21.732127	18346	50	2	8
2014-03-26 04:45:32.671582	18347	354	3	2
2014-03-26 04:45:36.284169	18348	18.3	1	1
2014-03-26 04:45:36.519009	18349	46	2	1
2014-03-26 22:36:33.692947	32398	48	2	8
2014-03-26 22:36:44.55446	32399	450	3	2
2014-03-26 22:36:44.789982	32400	1088579.93168385	4	2
2014-03-26 04:46:00.162426	18354	20.6	1	8
2014-03-26 04:46:00.383737	18355	50	2	8
2014-03-26 04:46:15.284764	18356	18.3	1	1
2014-03-26 04:46:15.519096	18357	46	2	1
2014-03-26 04:46:32.666475	18358	354	3	2
2014-03-26 04:36:52.114178	18227	21.6	1	10
2014-03-26 04:36:52.336848	18228	47	2	10
2014-03-26 04:37:31.116606	18235	21.6	1	10
2014-03-26 04:37:31.339513	18236	47	2	10
2014-03-26 04:38:10.114795	18244	21.6	1	10
2014-03-26 04:38:10.353461	18245	47	2	10
2014-03-26 04:38:49.115529	18253	21.6	1	10
2014-03-26 04:38:49.339432	18254	47	2	10
2014-03-26 04:39:28.115374	18261	21.6	1	10
2014-03-26 04:39:28.336849	18262	47	2	10
2014-03-26 04:40:07.115249	18270	21.6	1	10
2014-03-26 04:40:07.337481	18271	47	2	10
2014-03-26 04:40:46.115933	18279	21.6	1	10
2014-03-26 04:40:46.337988	18280	47	2	10
2014-03-26 04:41:25.114931	18289	21.6	1	10
2014-03-26 04:41:25.347426	18290	47	2	10
2014-03-26 04:42:04.115656	18298	21.6	1	10
2014-03-26 04:42:04.338457	18299	47	2	10
2014-03-26 04:42:43.118017	18307	21.6	1	10
2014-03-26 04:42:43.342807	18308	47	2	10
2014-03-26 04:43:22.117216	18315	21.6	1	10
2014-03-26 04:43:22.343095	18316	47	2	10
2014-03-26 04:44:01.116191	18324	21.6	1	10
2014-03-26 04:44:01.34829	18325	47	2	10
2014-03-26 04:44:40.117921	18333	21.6	1	10
2014-03-26 04:44:40.340587	18334	47	2	10
2014-03-26 04:45:19.117877	18341	21.6	1	10
2014-03-26 04:45:19.339726	18342	47	2	10
2014-03-26 22:36:47.682354	32401	20.2	1	1
2014-03-26 22:36:47.909172	32402	50	2	1
2014-03-26 04:46:39.162388	18363	20.6	1	8
2014-03-26 04:46:39.392826	18364	50	2	8
2014-03-26 04:46:54.2812	18365	18.3	1	1
2014-03-26 04:46:54.505449	18366	46	2	1
2014-03-26 22:36:56.555473	32403	450	3	2
2014-03-26 22:36:56.791489	32404	1088582.2297532929	4	2
2014-03-26 04:47:18.162235	18371	20.6	1	8
2014-03-26 04:47:18.393458	18372	50	2	8
2014-03-26 04:47:32.667741	18373	354	3	2
2014-03-26 04:47:33.285877	18374	18.3	1	1
2014-03-26 04:47:33.507711	18375	46	2	1
2014-03-26 22:37:00.71497	32405	24.4	1	10
2014-03-26 22:37:00.941641	32406	41	2	10
2014-03-26 04:47:57.503246	18380	20.6	1	8
2014-03-26 04:47:57.724512	18381	50	2	8
2014-03-26 04:48:12.287135	18382	18.2	1	1
2014-03-26 04:48:12.518143	18383	46	2	1
2014-03-26 04:48:32.666822	18384	418	3	2
2014-03-26 22:37:11.045049	32407	21.7	1	9
2014-03-26 22:37:11.280577	32408	48	2	9
2014-03-26 04:48:36.165286	18389	20.6	1	8
2014-03-26 04:48:36.386831	18390	50	2	8
2014-03-26 04:48:44.665652	18391	418	3	2
2014-03-26 04:48:51.283368	18392	18.2	1	1
2014-03-26 04:48:51.505469	18393	46	2	1
2014-03-26 22:37:12.1341	32409	21.8	1	8
2014-03-26 22:37:12.360413	32410	48	2	8
2014-03-26 04:49:15.16312	18398	20.6	1	8
2014-03-26 04:49:15.386286	18399	50	2	8
2014-03-26 04:49:20.663247	18400	354	3	2
2014-03-26 04:49:30.286628	18401	18.2	1	1
2014-03-26 04:49:30.508542	18402	46	2	1
2014-03-26 04:49:32.665306	18403	354	3	2
2014-03-26 22:37:26.673798	32411	20.2	1	1
2014-03-26 22:37:26.915146	32412	50	2	1
2014-03-26 04:49:54.163421	18408	20.6	1	8
2014-03-26 04:49:54.397165	18409	50	2	8
2014-03-26 04:50:09.285495	18410	18.2	1	1
2014-03-26 04:50:09.509326	18411	46	2	1
2014-03-26 22:37:32.556002	32413	450	3	2
2014-03-26 22:37:32.78402	32414	1088586.8258921786	4	2
2014-03-26 04:50:32.667672	18416	354	3	2
2014-03-26 04:50:33.163274	18417	20.6	1	8
2014-03-26 04:50:33.385721	18418	50	2	8
2014-03-26 04:50:48.284847	18419	18.2	1	1
2014-03-26 04:50:48.509522	18420	46	2	1
2014-03-26 22:37:39.715878	32415	24.3	1	10
2014-03-26 22:37:39.953434	32416	41	2	10
2014-03-26 04:51:12.163206	18423	20.6	1	8
2014-03-26 04:51:12.385706	18424	50	2	8
2014-03-26 04:51:27.279966	18425	18.2	1	1
2014-03-26 04:51:27.502826	18426	46	2	1
2014-03-26 04:51:32.667269	18427	354	3	2
2014-03-26 22:37:50.04714	32417	21.7	1	9
2014-03-26 22:37:50.271691	32418	48	2	9
2014-03-26 04:51:51.16355	18432	20.6	1	8
2014-03-26 04:51:51.396095	18433	50	2	8
2014-03-26 04:52:06.281398	18434	18.2	1	1
2014-03-26 04:52:06.504229	18435	46	2	1
2014-03-26 22:37:51.133308	32419	21.8	1	8
2014-03-26 22:37:51.38017	32420	48	2	8
2014-03-26 04:52:30.165512	18440	20.6	1	8
2014-03-26 04:52:30.396409	18441	50	2	8
2014-03-26 04:52:32.663455	18442	354	3	2
2014-03-26 04:52:45.286083	18443	18.2	1	1
2014-03-26 04:52:45.508872	18444	46	2	1
2014-03-26 22:38:05.671163	32421	20.2	1	1
2014-03-26 22:38:05.896879	32422	50	2	1
2014-03-26 04:53:09.163336	18449	20.6	1	8
2014-03-26 04:53:09.383589	18450	50	2	8
2014-03-26 04:53:20.666272	18451	305	3	2
2014-03-26 04:53:24.282324	18452	18.2	1	1
2014-03-26 04:53:24.515104	18453	46	2	1
2014-03-26 04:53:32.667432	18454	305	3	2
2014-03-26 22:38:18.713985	32423	24.3	1	10
2014-03-26 22:38:19.136997	32424	41	2	10
2014-03-26 04:53:48.492726	18459	20.6	1	8
2014-03-26 04:53:48.713991	18460	50	2	8
2014-03-26 04:54:03.280674	18461	18.2	1	1
2014-03-26 04:54:03.502571	18462	46	2	1
2014-03-26 22:38:29.045768	32425	21.7	1	9
2014-03-26 22:38:29.27504	32426	48	2	9
2014-03-26 04:54:27.162664	18467	20.6	1	8
2014-03-26 04:54:27.398327	18468	50	2	8
2014-03-26 04:54:32.665154	18469	305	3	2
2014-03-26 04:54:42.407642	18470	18.2	1	1
2014-03-26 04:54:42.830003	18471	46	2	1
2014-03-26 22:38:30.190402	32427	21.8	1	8
2014-03-26 22:38:30.413337	32428	48	2	8
2014-03-26 04:55:06.164883	18476	20.6	1	8
2014-03-26 04:55:06.392006	18477	50	2	8
2014-03-26 04:55:21.277447	18478	18.2	1	1
2014-03-26 04:55:21.511609	18479	46	2	1
2014-03-26 04:55:32.66423	18480	305	3	2
2014-03-26 22:38:32.560205	32429	434	3	2
2014-03-26 04:55:45.163678	18485	20.6	1	8
2014-03-26 04:55:45.395587	18486	50	2	8
2014-03-26 04:56:00.27844	18487	18.2	1	1
2014-03-26 04:56:00.502773	18488	46	2	1
2014-03-26 04:56:24.489706	18493	20.6	1	8
2014-03-26 04:56:24.72469	18494	50	2	8
2014-03-26 04:56:32.666646	18495	305	3	2
2014-03-26 04:56:39.281985	18496	18.2	1	1
2014-03-26 04:47:16.11882	18367	21.6	1	10
2014-03-26 04:47:16.351021	18368	47	2	10
2014-03-26 04:47:55.118909	18376	21.6	1	10
2014-03-26 04:47:55.340994	18377	47	2	10
2014-03-26 04:48:34.119125	18385	21.6	1	10
2014-03-26 04:48:34.340867	18386	47	2	10
2014-03-26 04:49:13.118269	18394	21.6	1	10
2014-03-26 04:49:13.341347	18395	47	2	10
2014-03-26 04:49:52.128778	18404	21.6	1	10
2014-03-26 04:49:52.364023	18405	47	2	10
2014-03-26 04:50:31.119455	18412	21.6	1	10
2014-03-26 04:50:31.356863	18413	47	2	10
2014-03-26 04:51:49.119084	18428	21.6	1	10
2014-03-26 04:51:49.352938	18429	47	2	10
2014-03-26 04:52:28.119777	18436	21.6	1	10
2014-03-26 04:52:28.36268	18437	47	2	10
2014-03-26 04:53:07.120463	18445	21.6	1	10
2014-03-26 04:53:07.342775	18446	47	2	10
2014-03-26 04:53:46.122182	18455	21.6	1	10
2014-03-26 04:53:46.344096	18456	47	2	10
2014-03-26 04:54:25.119821	18463	21.6	1	10
2014-03-26 04:54:25.353856	18464	47	2	10
2014-03-26 04:55:04.120793	18472	21.6	1	10
2014-03-26 04:55:04.345636	18473	47	2	10
2014-03-26 04:55:43.120593	18481	21.6	1	10
2014-03-26 04:55:43.349157	18482	47	2	10
2014-03-26 04:56:22.121352	18489	21.6	1	10
2014-03-26 04:56:22.35601	18490	47	2	10
2014-03-26 04:56:39.503668	18497	46	2	1
2014-03-26 22:38:32.79023	32430	1088593.720100507	4	2
2014-03-26 22:38:44.670895	32431	20.2	1	1
2014-03-26 04:57:03.163859	18502	20.6	1	8
2014-03-26 04:57:03.385717	18503	50	2	8
2014-03-26 04:57:18.285047	18504	18.2	1	1
2014-03-26 04:57:18.507049	18505	46	2	1
2014-03-26 04:57:32.664536	18506	305	3	2
2014-03-26 22:38:44.894261	32432	50	2	1
2014-03-26 22:38:57.713684	32433	24.3	1	10
2014-03-26 04:57:42.163061	18511	20.6	1	8
2014-03-26 04:57:42.385451	18512	50	2	8
2014-03-26 04:57:57.276092	18513	18.2	1	1
2014-03-26 04:57:57.509243	18514	46	2	1
2014-03-26 22:38:57.947658	32434	41	2	10
2014-03-26 22:39:08.045853	32435	21.7	1	9
2014-03-26 04:58:20.664519	18519	338	3	2
2014-03-26 04:58:21.162655	18520	20.6	1	8
2014-03-26 04:58:21.384313	18521	50	2	8
2014-03-26 04:58:32.664983	18522	305	3	2
2014-03-26 04:58:36.279142	18523	18.2	1	1
2014-03-26 04:58:36.502135	18524	46	2	1
2014-03-26 04:58:44.663949	18525	305	3	2
2014-03-26 22:39:08.269638	32436	48	2	9
2014-03-26 22:39:09.13396	32437	21.8	1	8
2014-03-26 04:59:00.163813	18530	20.6	1	8
2014-03-26 04:59:00.386303	18531	50	2	8
2014-03-26 04:59:15.282053	18532	18.2	1	1
2014-03-26 04:59:15.51425	18533	46	2	1
2014-03-26 04:59:32.662187	18534	305	3	2
2014-03-26 22:39:09.365638	32438	48	2	8
2014-03-26 22:39:23.674371	32439	20.2	1	1
2014-03-26 04:59:39.16473	18539	20.6	1	8
2014-03-26 04:59:39.396607	18540	50	2	8
2014-03-26 04:59:54.283885	18541	18.2	1	1
2014-03-26 04:59:54.506508	18542	46	2	1
2014-03-26 22:39:23.897195	32440	50	2	1
2014-03-26 22:39:32.553884	32441	450	3	2
2014-03-26 05:00:18.162229	18547	20.6	1	8
2014-03-26 05:00:18.396561	18548	50	2	8
2014-03-26 05:00:32.667938	18549	354	3	2
2014-03-26 05:00:33.276279	18550	18.2	1	1
2014-03-26 05:00:33.499096	18551	46	2	1
2014-03-26 05:00:44.664101	18552	354	3	2
2014-03-26 22:39:32.788727	32442	1088601.763343557	4	2
2014-03-26 22:39:36.714989	32443	24.3	1	10
2014-03-26 05:00:57.163142	18557	20.6	1	8
2014-03-26 05:00:57.383497	18558	50	2	8
2014-03-26 05:01:12.278828	18559	18.2	1	1
2014-03-26 05:01:12.503777	18560	46	2	1
2014-03-26 05:01:33.921656	18561	354	3	2
2014-03-26 22:39:36.938559	32444	41	2	10
2014-03-26 22:39:47.045429	32445	21.7	1	9
2014-03-26 05:01:36.16283	18566	20.6	1	8
2014-03-26 05:01:36.384322	18567	50	2	8
2014-03-26 05:01:51.279514	18568	18.2	1	1
2014-03-26 05:01:51.510971	18569	46	2	1
2014-03-26 22:39:47.281216	32446	48	2	9
2014-03-26 22:39:48.13328	32447	21.8	1	8
2014-03-26 05:02:15.163459	18574	20.6	1	8
2014-03-26 05:02:15.387324	18575	50	2	8
2014-03-26 05:02:30.318877	18576	18.2	1	1
2014-03-26 05:02:30.553161	18577	46	2	1
2014-03-26 05:02:32.665669	18578	338	3	2
2014-03-26 22:39:48.35555	32448	48	2	8
2014-03-26 22:40:02.671861	32449	20.2	1	1
2014-03-26 05:02:54.162482	18583	20.6	1	8
2014-03-26 05:02:54.385092	18584	50	2	8
2014-03-26 05:03:09.278245	18585	18.2	1	1
2014-03-26 05:03:09.502574	18586	46	2	1
2014-03-26 22:40:02.906887	32450	50	2	1
2014-03-26 22:40:15.715536	32451	24.3	1	10
2014-03-26 05:03:32.662466	18591	354	3	2
2014-03-26 05:03:33.163057	18592	20.6	1	8
2014-03-26 05:03:33.38438	18593	50	2	8
2014-03-26 05:03:48.274942	18594	18.2	1	1
2014-03-26 05:03:48.506829	18595	46	2	1
2014-03-26 22:40:15.940095	32452	41	2	10
2014-03-26 22:40:26.045373	32453	21.7	1	9
2014-03-26 05:04:12.162671	18600	20.6	1	8
2014-03-26 05:04:12.385165	18601	50	2	8
2014-03-26 05:04:27.273006	18602	18.2	1	1
2014-03-26 05:04:27.50508	18603	46	2	1
2014-03-26 05:04:32.66208	18604	354	3	2
2014-03-26 22:40:26.279446	32454	48	2	9
2014-03-26 22:40:27.132544	32455	21.8	1	8
2014-03-26 05:04:51.291361	18609	20.6	1	8
2014-03-26 05:04:51.732238	18610	50	2	8
2014-03-26 05:05:06.319246	18611	18.2	1	1
2014-03-26 05:05:06.543757	18612	46	2	1
2014-03-26 05:05:20.663617	18613	289	3	2
2014-03-26 22:40:27.363202	32456	48	2	8
2014-03-26 22:40:32.553107	32457	450	3	2
2014-03-26 05:05:30.163051	18618	20.6	1	8
2014-03-26 05:05:30.385936	18619	50	2	8
2014-03-26 05:05:32.665606	18620	289	3	2
2014-03-26 05:05:45.275092	18621	18.2	1	1
2014-03-26 05:05:45.501952	18622	46	2	1
2014-03-26 22:40:32.7939	32458	1088608.6575518853	4	2
2014-03-26 22:40:41.671771	32459	20.2	1	1
2014-03-26 05:06:09.162674	18627	20.6	1	8
2014-03-26 05:06:09.427398	18628	50	2	8
2014-03-26 05:06:24.315688	18629	18.2	1	1
2014-03-26 05:06:24.574492	18630	46	2	1
2014-03-26 05:06:32.664248	18631	289	3	2
2014-03-26 04:57:01.12136	18498	21.6	1	10
2014-03-26 04:57:01.363323	18499	47	2	10
2014-03-26 04:57:40.121923	18507	21.6	1	10
2014-03-26 04:57:40.348643	18508	47	2	10
2014-03-26 04:58:19.122028	18515	21.6	1	10
2014-03-26 04:58:19.344535	18516	47	2	10
2014-03-26 04:58:58.1328	18526	21.6	1	10
2014-03-26 04:58:58.355355	18527	47	2	10
2014-03-26 04:59:37.122072	18535	21.6	1	10
2014-03-26 04:59:37.344592	18536	47	2	10
2014-03-26 05:00:16.121524	18543	21.6	1	10
2014-03-26 05:00:16.354112	18544	47	2	10
2014-03-26 05:00:55.12243	18553	21.6	1	10
2014-03-26 05:00:55.34578	18554	47	2	10
2014-03-26 05:01:34.237687	18562	21.6	1	10
2014-03-26 05:01:34.4606	18563	47	2	10
2014-03-26 05:02:13.122823	18570	21.6	1	10
2014-03-26 05:02:13.345203	18571	47	2	10
2014-03-26 05:02:52.122613	18579	21.6	1	10
2014-03-26 05:02:52.346661	18580	47	2	10
2014-03-26 05:03:31.123766	18587	21.6	1	10
2014-03-26 05:03:31.35545	18588	47	2	10
2014-03-26 05:04:10.124954	18596	21.6	1	10
2014-03-26 05:04:10.347049	18597	47	2	10
2014-03-26 05:04:49.260096	18605	21.6	1	10
2014-03-26 05:04:49.680091	18606	47	2	10
2014-03-26 05:05:28.123782	18614	21.6	1	10
2014-03-26 05:05:28.347797	18615	47	2	10
2014-03-26 22:40:41.895489	32460	50	2	1
2014-03-26 22:40:54.714431	32461	24.3	1	10
2014-03-26 05:06:48.162103	18636	20.6	1	8
2014-03-26 05:06:48.382347	18637	50	2	8
2014-03-26 05:07:03.275136	18638	18.2	1	1
2014-03-26 05:07:03.505951	18639	46	2	1
2014-03-26 22:40:54.950304	32462	41	2	10
2014-03-26 22:41:05.044911	32463	21.7	1	9
2014-03-26 05:07:27.162853	18644	20.6	1	8
2014-03-26 05:07:27.386053	18645	50	2	8
2014-03-26 05:07:32.663911	18646	289	3	2
2014-03-26 05:07:42.279508	18647	18.1	1	1
2014-03-26 05:07:42.502482	18648	46	2	1
2014-03-26 22:41:05.269431	32464	48	2	9
2014-03-26 22:41:06.133395	32465	21.8	1	8
2014-03-26 05:08:06.19958	18653	20.6	1	8
2014-03-26 05:08:06.448137	18654	50	2	8
2014-03-26 05:08:21.274279	18655	18.1	1	1
2014-03-26 05:08:21.49635	18656	46	2	1
2014-03-26 05:08:32.665699	18657	289	3	2
2014-03-26 22:41:06.365581	32466	48	2	8
2014-03-26 22:41:20.669493	32467	20.2	1	1
2014-03-26 05:08:45.163018	18662	20.6	1	8
2014-03-26 05:08:45.384485	18663	50	2	8
2014-03-26 05:09:00.275397	18664	18.1	1	1
2014-03-26 05:09:00.695282	18665	46	2	1
2014-03-26 22:41:20.892443	32468	50	2	1
2014-03-26 22:41:32.5536	32469	450	3	2
2014-03-26 05:09:24.162199	18670	20.6	1	8
2014-03-26 05:09:24.393493	18671	50	2	8
2014-03-26 05:09:32.661703	18672	289	3	2
2014-03-26 05:09:39.275154	18673	18.1	1	1
2014-03-26 05:09:39.505474	18674	46	2	1
2014-03-26 22:41:32.79856	32470	1088616.7007949352	4	2
2014-03-26 22:41:33.715985	32471	24.3	1	10
2014-03-26 05:10:03.163843	18679	20.6	1	8
2014-03-26 05:10:03.384467	18680	50	2	8
2014-03-26 05:10:18.272652	18681	18.1	1	1
2014-03-26 05:10:18.505214	18682	46	2	1
2014-03-26 05:10:32.660641	18683	305	3	2
2014-03-26 22:41:33.94133	32472	41	2	10
2014-03-26 22:41:44.044312	32473	21.7	1	9
2014-03-26 05:10:42.162357	18688	20.6	1	8
2014-03-26 05:10:42.394598	18689	50	2	8
2014-03-26 05:10:57.274678	18690	18.1	1	1
2014-03-26 05:10:57.49664	18691	46	2	1
2014-03-26 22:41:44.27906	32474	48	2	9
2014-03-26 22:41:44.587266	32475	402	3	2
2014-03-26 05:11:21.163224	18696	20.6	1	8
2014-03-26 05:11:21.396024	18697	50	2	8
2014-03-26 05:11:32.66399	18698	305	3	2
2014-03-26 05:11:36.271576	18699	18.1	1	1
2014-03-26 05:11:36.505629	18700	46	2	1
2014-03-26 22:41:44.813364	32476	1088617.8498296568	4	2
2014-03-26 22:41:45.136495	32477	21.8	1	8
2014-03-26 05:12:00.16363	18705	20.5	1	8
2014-03-26 05:12:00.385528	18706	50	2	8
2014-03-26 05:12:15.275171	18707	18.1	1	1
2014-03-26 05:12:15.520006	18708	46	2	1
2014-03-26 05:12:32.664739	18709	354	3	2
2014-03-26 22:41:45.368704	32478	48	2	8
2014-03-26 22:41:56.553012	32479	402	3	2
2014-03-26 05:12:39.163829	18714	20.5	1	8
2014-03-26 05:12:39.387843	18715	50	2	8
2014-03-26 05:12:44.664803	18716	354	3	2
2014-03-26 05:12:54.27048	18717	18.1	1	1
2014-03-26 05:12:54.493006	18718	46	2	1
2014-03-26 22:41:56.776988	32480	1088618.998864378	4	2
2014-03-26 22:41:59.669534	32481	20.2	1	1
2014-03-26 05:13:18.162365	18723	20.5	1	8
2014-03-26 05:13:18.384175	18724	50	2	8
2014-03-26 05:13:32.665303	18725	354	3	2
2014-03-26 05:13:33.273486	18726	18.1	1	1
2014-03-26 05:13:33.506715	18727	46	2	1
2014-03-26 22:41:59.90467	32482	50	2	1
2014-03-26 22:42:12.715514	32483	24.3	1	10
2014-03-26 05:13:57.161609	18732	20.5	1	8
2014-03-26 05:13:57.383313	18733	50	2	8
2014-03-26 05:14:12.267601	18734	18.1	1	1
2014-03-26 05:14:12.499588	18735	46	2	1
2014-03-26 05:14:32.666363	18736	338	3	2
2014-03-26 22:42:12.939021	32484	41	2	10
2014-03-26 22:42:23.045789	32485	21.7	1	9
2014-03-26 05:14:36.162054	18741	20.5	1	8
2014-03-26 05:14:36.392354	18742	50	2	8
2014-03-26 05:14:51.267445	18743	18.1	1	1
2014-03-26 05:14:51.493401	18744	46	2	1
2014-03-26 22:42:23.282632	32486	48	2	9
2014-03-26 22:42:24.135553	32487	21.8	1	8
2014-03-26 05:15:15.300955	18747	20.5	1	8
2014-03-26 05:15:15.720053	18748	50	2	8
2014-03-26 05:15:30.269562	18749	18.1	1	1
2014-03-26 05:15:30.501786	18750	46	2	1
2014-03-26 05:15:32.663678	18751	338	3	2
2014-03-26 22:42:24.360283	32488	48	2	8
2014-03-26 05:15:54.161592	18756	20.5	1	8
2014-03-26 05:15:54.394544	18757	50	2	8
2014-03-26 05:16:09.272452	18758	18.1	1	1
2014-03-26 05:16:09.495047	18759	46	2	1
2014-03-26 05:16:32.66085	18764	338	3	2
2014-03-26 05:16:33.160662	18765	20.5	1	8
2014-03-26 05:16:33.384019	18766	50	2	8
2014-03-26 05:16:48.270081	18767	18.1	1	1
2014-03-26 05:16:48.494804	18768	46	2	1
2014-03-26 05:06:46.380642	18633	47	2	10
2014-03-26 05:07:25.12422	18640	21.6	1	10
2014-03-26 05:07:25.346831	18641	47	2	10
2014-03-26 05:08:04.12422	18649	21.6	1	10
2014-03-26 05:08:04.345225	18650	47	2	10
2014-03-26 05:08:43.124788	18658	21.6	1	10
2014-03-26 05:08:43.346937	18659	47	2	10
2014-03-26 05:09:22.126024	18666	21.6	1	10
2014-03-26 05:09:22.354428	18667	47	2	10
2014-03-26 05:10:01.12642	18675	21.6	1	10
2014-03-26 05:10:01.351037	18676	47	2	10
2014-03-26 05:10:40.12516	18684	21.6	1	10
2014-03-26 05:10:40.34969	18685	47	2	10
2014-03-26 05:11:19.124725	18692	21.6	1	10
2014-03-26 05:11:19.359038	18693	47	2	10
2014-03-26 05:11:58.125401	18701	21.6	1	10
2014-03-26 05:11:58.348218	18702	47	2	10
2014-03-26 05:12:37.128784	18710	21.6	1	10
2014-03-26 05:12:37.361531	18711	47	2	10
2014-03-26 05:13:16.125896	18719	21.6	1	10
2014-03-26 05:13:16.3486	18720	47	2	10
2014-03-26 05:13:55.125656	18728	21.6	1	10
2014-03-26 05:13:55.347729	18729	47	2	10
2014-03-26 05:14:34.127631	18737	21.6	1	10
2014-03-26 05:14:34.349283	18738	47	2	10
2014-03-26 05:15:52.125184	18752	21.6	1	10
2014-03-26 05:15:52.349484	18753	47	2	10
2014-03-26 05:16:31.128452	18760	21.6	1	10
2014-03-26 05:16:31.360665	18761	47	2	10
2014-03-26 22:42:32.555371	32489	402	3	2
2014-03-26 22:42:32.7921	32490	1088623.5950032638	4	2
2014-03-26 05:17:12.162056	18773	20.5	1	8
2014-03-26 05:17:12.382589	18774	50	2	8
2014-03-26 05:17:27.266164	18775	18.1	1	1
2014-03-26 05:17:27.499924	18776	45	2	1
2014-03-26 05:17:32.663203	18777	354	3	2
2014-03-26 22:42:38.669525	32491	20.2	1	1
2014-03-26 22:42:38.920997	32492	50	2	1
2014-03-26 05:17:51.161868	18782	20.5	1	8
2014-03-26 05:17:51.392545	18783	50	2	8
2014-03-26 05:18:06.269405	18784	18.1	1	1
2014-03-26 05:18:06.546591	18785	45	2	1
2014-03-26 05:18:20.665806	18786	289	3	2
2014-03-26 22:42:51.716452	32493	24.3	1	10
2014-03-26 22:42:51.948888	32494	41	2	10
2014-03-26 05:18:30.161661	18791	20.5	1	8
2014-03-26 05:18:30.38379	18792	50	2	8
2014-03-26 05:18:32.663774	18793	289	3	2
2014-03-26 05:18:45.265881	18794	18.1	1	1
2014-03-26 05:18:45.488618	18795	45	2	1
2014-03-26 22:43:02.045168	32495	21.7	1	9
2014-03-26 22:43:02.27069	32496	48	2	9
2014-03-26 05:19:09.485098	18800	20.5	1	8
2014-03-26 05:19:09.71583	18801	50	2	8
2014-03-26 05:19:24.269532	18802	18.1	1	1
2014-03-26 05:19:24.491056	18803	45	2	1
2014-03-26 05:19:45.927879	18804	289	3	2
2014-03-26 22:43:03.135362	32497	21.8	1	8
2014-03-26 22:43:03.373774	32498	48	2	8
2014-03-26 05:19:48.497805	18809	20.5	1	8
2014-03-26 05:19:48.718437	18810	50	2	8
2014-03-26 05:20:03.271427	18811	18.1	1	1
2014-03-26 05:20:03.502849	18812	45	2	1
2014-03-26 22:43:17.669985	32499	20.2	1	1
2014-03-26 22:43:17.893586	32500	50	2	1
2014-03-26 05:20:27.16286	18817	20.5	1	8
2014-03-26 05:20:27.384982	18818	50	2	8
2014-03-26 05:20:32.66374	18819	289	3	2
2014-03-26 05:20:42.270098	18820	18.1	1	1
2014-03-26 05:20:42.494632	18821	45	2	1
2014-03-26 22:43:30.716306	32501	24.3	1	10
2014-03-26 22:43:30.984661	32502	41	2	10
2014-03-26 05:21:06.163862	18826	20.5	1	8
2014-03-26 05:21:06.39427	18827	50	2	8
2014-03-26 05:21:21.267797	18828	18.1	1	1
2014-03-26 05:21:21.491046	18829	45	2	1
2014-03-26 05:21:32.660362	18830	289	3	2
2014-03-26 22:43:32.557306	32503	402	3	2
2014-03-26 22:43:32.804396	32504	1088629.3401768708	4	2
2014-03-26 05:21:45.160797	18835	20.5	1	8
2014-03-26 05:21:45.383873	18836	50	2	8
2014-03-26 05:22:00.266841	18837	18.1	1	1
2014-03-26 05:22:00.490544	18838	45	2	1
2014-03-26 22:43:41.045128	32505	21.6	1	9
2014-03-26 22:43:41.312873	32506	48	2	9
2014-03-26 05:22:24.161366	18843	20.5	1	8
2014-03-26 05:22:24.383617	18844	50	2	8
2014-03-26 05:22:32.662354	18845	289	3	2
2014-03-26 05:22:39.265873	18846	18.1	1	1
2014-03-26 05:22:39.491416	18847	45	2	1
2014-03-26 22:43:42.135104	32507	21.8	1	8
2014-03-26 22:43:42.381697	32508	48	2	8
2014-03-26 05:23:03.160653	18852	20.5	1	8
2014-03-26 05:23:03.38153	18853	50	2	8
2014-03-26 05:23:18.267782	18854	18.1	1	1
2014-03-26 05:23:18.489091	18855	45	2	1
2014-03-26 05:23:32.663871	18856	289	3	2
2014-03-26 22:43:56.66891	32509	20.2	1	1
2014-03-26 22:43:57.106056	32510	50	2	1
2014-03-26 05:23:42.161483	18861	20.5	1	8
2014-03-26 05:23:42.3834	18862	50	2	8
2014-03-26 05:23:57.26091	18863	18.1	1	1
2014-03-26 05:23:57.483271	18864	45	2	1
2014-03-26 22:44:08.555715	32511	370	3	2
2014-03-26 22:44:08.814694	32512	1088633.9363157565	4	2
2014-03-26 05:24:21.161941	18869	20.5	1	8
2014-03-26 05:24:21.383366	18870	50	2	8
2014-03-26 05:24:32.662109	18871	305	3	2
2014-03-26 05:24:36.267002	18872	18.1	1	1
2014-03-26 05:24:36.489262	18873	45	2	1
2014-03-26 22:44:09.716871	32513	24.3	1	10
2014-03-26 22:44:09.985776	32514	41	2	10
2014-03-26 05:25:00.161199	18878	20.5	1	8
2014-03-26 05:25:00.395494	18879	50	2	8
2014-03-26 05:25:15.261799	18880	18.1	1	1
2014-03-26 05:25:15.484027	18881	45	2	1
2014-03-26 05:25:32.660452	18882	289	3	2
2014-03-26 22:44:20.044002	32515	21.6	1	9
2014-03-26 22:44:20.304183	32516	48	2	9
2014-03-26 05:25:39.179074	18887	20.5	1	8
2014-03-26 05:25:39.40184	18888	50	2	8
2014-03-26 05:25:44.662767	18889	354	3	2
2014-03-26 05:25:54.263836	18890	18.1	1	1
2014-03-26 05:25:54.485553	18891	45	2	1
2014-03-26 05:25:56.662178	18892	338	3	2
2014-03-26 22:44:20.61231	32517	370	3	2
2014-03-26 22:44:20.85677	32518	1088635.085350478	4	2
2014-03-26 22:44:21.164066	32519	21.8	1	8
2014-03-26 05:26:18.163548	18897	20.5	1	8
2014-03-26 05:26:18.396569	18898	50	2	8
2014-03-26 05:26:32.659412	18899	338	3	2
2014-03-26 05:26:33.266236	18900	18.1	1	1
2014-03-26 05:26:33.487856	18901	45	2	1
2014-03-26 05:17:10.127677	18769	21.5	1	10
2014-03-26 05:17:10.374121	18770	47	2	10
2014-03-26 05:17:49.128112	18778	21.5	1	10
2014-03-26 05:17:49.350717	18779	47	2	10
2014-03-26 05:18:28.128179	18787	21.5	1	10
2014-03-26 05:18:28.351017	18788	47	2	10
2014-03-26 05:19:07.128329	18796	21.5	1	10
2014-03-26 05:19:07.369804	18797	47	2	10
2014-03-26 05:19:46.244316	18805	21.5	1	10
2014-03-26 05:19:46.465035	18806	47	2	10
2014-03-26 05:20:25.13033	18813	21.5	1	10
2014-03-26 05:20:25.352799	18814	47	2	10
2014-03-26 05:21:04.129157	18822	21.5	1	10
2014-03-26 05:21:04.361341	18823	47	2	10
2014-03-26 05:21:43.129314	18831	21.5	1	10
2014-03-26 05:21:43.35357	18832	47	2	10
2014-03-26 05:22:22.129235	18839	21.5	1	10
2014-03-26 05:22:22.351152	18840	47	2	10
2014-03-26 05:23:01.13428	18848	21.5	1	10
2014-03-26 05:23:01.356277	18849	47	2	10
2014-03-26 05:23:40.12885	18857	21.5	1	10
2014-03-26 05:23:40.350284	18858	47	2	10
2014-03-26 05:24:19.131264	18865	21.5	1	10
2014-03-26 05:24:19.355286	18866	47	2	10
2014-03-26 05:24:58.132162	18874	21.5	1	10
2014-03-26 05:24:58.355602	18875	47	2	10
2014-03-26 05:25:37.132407	18883	21.5	1	10
2014-03-26 05:25:37.354856	18884	47	2	10
2014-03-26 05:26:16.131384	18893	21.5	1	10
2014-03-26 22:44:21.387945	32520	48	2	8
2014-03-26 05:26:57.160957	18906	20.5	1	8
2014-03-26 05:26:57.38405	18907	50	2	8
2014-03-26 05:27:12.264741	18908	18.1	1	1
2014-03-26 05:27:12.488901	18909	45	2	1
2014-03-26 05:27:32.664886	18910	338	3	2
2014-03-26 22:44:32.554883	32521	402	3	2
2014-03-26 22:44:32.78758	32522	1088636.2343851994	4	2
2014-03-26 05:27:36.503338	18915	20.5	1	8
2014-03-26 05:27:36.724034	18916	50	2	8
2014-03-26 05:27:51.259008	18917	18.1	1	1
2014-03-26 05:27:51.494852	18918	45	2	1
2014-03-26 22:44:35.671595	32523	20.2	1	1
2014-03-26 22:44:35.904131	32524	50	2	1
2014-03-26 05:28:15.161973	18923	20.5	1	8
2014-03-26 05:28:15.385392	18924	50	2	8
2014-03-26 05:28:30.263621	18925	18.1	1	1
2014-03-26 05:28:30.495823	18926	45	2	1
2014-03-26 05:28:32.664557	18927	338	3	2
2014-03-26 22:44:44.557768	32525	402	3	2
2014-03-26 22:44:44.793598	32526	1088637.3834199207	4	2
2014-03-26 05:28:54.162777	18932	20.5	1	8
2014-03-26 05:28:54.385226	18933	50	2	8
2014-03-26 05:29:09.265548	18934	18.1	1	1
2014-03-26 05:29:09.486937	18935	45	2	1
2014-03-26 22:44:48.719221	32527	24.3	1	10
2014-03-26 22:44:48.941043	32528	41	2	10
2014-03-26 05:29:32.661797	18940	338	3	2
2014-03-26 05:29:33.162035	18941	20.5	1	8
2014-03-26 05:29:33.383799	18942	50	2	8
2014-03-26 05:29:48.262062	18943	18.1	1	1
2014-03-26 05:29:48.484593	18944	45	2	1
2014-03-26 22:44:59.044776	32529	21.6	1	9
2014-03-26 22:44:59.277696	32530	48	2	9
2014-03-26 05:30:12.161746	18949	20.5	1	8
2014-03-26 05:30:12.38391	18950	50	2	8
2014-03-26 05:30:27.264128	18951	18.1	1	1
2014-03-26 05:30:27.49569	18952	45	2	1
2014-03-26 05:30:32.66306	18953	338	3	2
2014-03-26 05:30:44.660304	18954	289	3	2
2014-03-26 22:45:00.133812	32531	21.8	1	8
2014-03-26 22:45:00.358832	32532	48	2	8
2014-03-26 05:30:51.162766	18959	20.5	1	8
2014-03-26 05:30:51.394547	18960	50	2	8
2014-03-26 05:30:56.663296	18961	289	3	2
2014-03-26 05:31:06.258513	18962	18.0	1	1
2014-03-26 05:31:06.481481	18963	45	2	1
2014-03-26 22:45:08.555955	32533	370	3	2
2014-03-26 22:45:08.801851	32534	1088639.6814893635	4	2
2014-03-26 05:31:30.163906	18968	20.5	1	8
2014-03-26 05:31:30.386061	18969	50	2	8
2014-03-26 05:31:32.66207	18970	289	3	2
2014-03-26 05:31:45.263083	18971	18.0	1	1
2014-03-26 05:31:45.49656	18972	45	2	1
2014-03-26 22:45:14.669947	32535	20.2	1	1
2014-03-26 22:45:14.89573	32536	50	2	1
2014-03-26 05:32:09.16198	18977	20.5	1	8
2014-03-26 05:32:09.38602	18978	50	2	8
2014-03-26 05:32:24.263157	18979	18.0	1	1
2014-03-26 05:32:24.508813	18980	45	2	1
2014-03-26 05:32:32.662278	18981	354	3	2
2014-03-26 05:32:44.662483	18982	354	3	2
2014-03-26 22:45:20.553241	32537	370	3	2
2014-03-26 22:45:20.788647	32538	1088640.830524085	4	2
2014-03-26 05:32:48.161717	18987	20.5	1	8
2014-03-26 05:32:48.395022	18988	50	2	8
2014-03-26 05:33:03.260635	18989	18.0	1	1
2014-03-26 05:33:03.484362	18990	45	2	1
2014-03-26 22:45:27.719616	32539	24.3	1	10
2014-03-26 22:45:27.944625	32540	41	2	10
2014-03-26 05:33:27.161842	18995	20.5	1	8
2014-03-26 05:33:27.392207	18996	50	2	8
2014-03-26 05:33:32.662402	18997	354	3	2
2014-03-26 05:33:42.30187	18998	18.0	1	1
2014-03-26 05:33:42.525344	18999	45	2	1
2014-03-26 22:45:32.554403	32541	370	3	2
2014-03-26 22:45:32.790038	32542	1088641.9795588064	4	2
2014-03-26 05:34:06.160712	19004	20.5	1	8
2014-03-26 05:34:06.382853	19005	50	2	8
2014-03-26 05:34:21.257996	19006	18.0	1	1
2014-03-26 05:34:21.489047	19007	45	2	1
2014-03-26 05:34:32.665226	19008	354	3	2
2014-03-26 22:45:38.045037	32543	21.6	1	9
2014-03-26 22:45:38.272432	32544	48	2	9
2014-03-26 05:34:45.162642	19013	20.5	1	8
2014-03-26 05:34:45.395656	19014	50	2	8
2014-03-26 05:35:00.500044	19015	18.0	1	1
2014-03-26 05:35:00.723969	19016	45	2	1
2014-03-26 22:45:39.133738	32545	21.8	1	8
2014-03-26 22:45:39.367554	32546	48	2	8
2014-03-26 05:35:24.161478	19021	20.5	1	8
2014-03-26 05:35:24.3935	19022	50	2	8
2014-03-26 05:35:32.785043	19023	354	3	2
2014-03-26 05:35:39.440053	19024	18.0	1	1
2014-03-26 05:35:39.86089	19025	45	2	1
2014-03-26 22:45:53.670874	32547	20.2	1	1
2014-03-26 22:45:53.897558	32548	50	2	1
2014-03-26 05:36:03.161506	19030	20.5	1	8
2014-03-26 05:36:03.383035	19031	50	2	8
2014-03-26 05:36:18.263762	19032	18.0	1	1
2014-03-26 05:36:18.494869	19033	45	2	1
2014-03-26 05:36:32.658238	19034	354	3	2
2014-03-26 05:36:42.163036	19039	20.5	1	8
2014-03-26 05:36:42.393724	19040	50	2	8
2014-03-26 05:27:34.131514	18911	21.5	1	10
2014-03-26 05:27:34.351957	18912	47	2	10
2014-03-26 05:28:13.13132	18919	21.5	1	10
2014-03-26 05:28:13.354068	18920	47	2	10
2014-03-26 05:28:52.131344	18928	21.5	1	10
2014-03-26 05:28:52.353934	18929	47	2	10
2014-03-26 05:29:31.131223	18936	21.5	1	10
2014-03-26 05:29:31.363724	18937	47	2	10
2014-03-26 05:30:10.132402	18945	21.4	1	10
2014-03-26 05:30:10.355173	18946	47	2	10
2014-03-26 05:30:49.132383	18955	21.4	1	10
2014-03-26 05:30:49.365942	18956	47	2	10
2014-03-26 05:31:28.133327	18964	21.4	1	10
2014-03-26 05:31:28.356408	18965	47	2	10
2014-03-26 05:32:07.134723	18973	21.4	1	10
2014-03-26 05:32:07.358702	18974	47	2	10
2014-03-26 05:32:46.131872	18983	21.4	1	10
2014-03-26 05:32:46.367049	18984	47	2	10
2014-03-26 05:33:25.133019	18991	21.4	1	10
2014-03-26 05:33:25.36591	18992	47	2	10
2014-03-26 05:34:04.132951	19000	21.4	1	10
2014-03-26 05:34:04.355544	19001	47	2	10
2014-03-26 05:34:43.136063	19009	21.4	1	10
2014-03-26 05:34:43.358499	19010	47	2	10
2014-03-26 05:35:22.132817	19017	21.4	1	10
2014-03-26 05:35:22.36397	19018	47	2	10
2014-03-26 05:36:01.133585	19026	21.4	1	10
2014-03-26 05:36:01.355822	19027	47	2	10
2014-03-26 05:36:40.134259	19035	21.4	1	10
2014-03-26 05:36:57.256192	19041	18.0	1	1
2014-03-26 05:36:57.478253	19042	45	2	1
2014-03-26 22:45:56.552698	32549	402	3	2
2014-03-26 22:45:56.786242	32550	1088645.4266629708	4	2
2014-03-26 05:37:21.161533	19047	20.5	1	8
2014-03-26 05:37:21.396611	19048	50	2	8
2014-03-26 05:37:32.662695	19049	354	3	2
2014-03-26 05:37:36.263761	19050	18.0	1	1
2014-03-26 05:37:36.48823	19051	45	2	1
2014-03-26 05:37:44.659447	19052	418	3	2
2014-03-26 05:37:56.660571	19053	418	3	2
2014-03-26 22:46:06.718207	32551	24.3	1	10
2014-03-26 22:46:06.944494	32552	41	2	10
2014-03-26 05:38:00.490323	19058	20.5	1	8
2014-03-26 05:38:00.721918	19059	50	2	8
2014-03-26 05:38:15.260724	19060	18.0	1	1
2014-03-26 05:38:15.486152	19061	45	2	1
2014-03-26 05:38:32.658194	19062	418	3	2
2014-03-26 22:46:08.55446	32553	402	3	2
2014-03-26 22:46:08.789902	32554	1088646.575697692	4	2
2014-03-26 05:38:39.161621	19067	20.5	1	8
2014-03-26 05:38:39.383418	19068	50	2	8
2014-03-26 05:38:54.25844	19069	18.0	1	1
2014-03-26 05:38:54.503622	19070	45	2	1
2014-03-26 22:46:17.042534	32555	21.6	1	9
2014-03-26 22:46:17.267574	32556	48	2	9
2014-03-26 05:39:18.161812	19075	20.5	1	8
2014-03-26 05:39:18.385302	19076	50	2	8
2014-03-26 05:39:32.663781	19077	418	3	2
2014-03-26 05:39:33.257386	19078	18.0	1	1
2014-03-26 05:39:33.477973	19079	45	2	1
2014-03-26 22:46:18.133736	32557	21.8	1	8
2014-03-26 22:46:18.366929	32558	48	2	8
2014-03-26 05:39:57.161328	19084	20.5	1	8
2014-03-26 05:39:57.384144	19085	50	2	8
2014-03-26 05:40:12.256999	19086	18.0	1	1
2014-03-26 05:40:12.485487	19087	45	2	1
2014-03-26 05:40:32.6588	19088	418	3	2
2014-03-26 22:46:32.904034	32559	20.2	1	1
2014-03-26 22:46:33.128833	32560	50	2	1
2014-03-26 05:40:36.160959	19093	20.5	1	8
2014-03-26 05:40:36.383473	19094	50	2	8
2014-03-26 05:40:51.254638	19095	18.0	1	1
2014-03-26 05:40:51.485314	19096	45	2	1
2014-03-26 22:46:45.717854	32561	24.3	1	10
2014-03-26 22:46:45.952478	32562	41	2	10
2014-03-26 05:41:15.162235	19101	20.5	1	8
2014-03-26 05:41:15.384255	19102	50	2	8
2014-03-26 05:41:30.257491	19103	18.0	1	1
2014-03-26 05:41:30.488981	19104	45	2	1
2014-03-26 05:41:32.660086	19105	418	3	2
2014-03-26 22:46:56.046216	32563	21.6	1	9
2014-03-26 22:46:56.270708	32564	48	2	9
2014-03-26 05:41:54.162064	19110	20.5	1	8
2014-03-26 05:41:54.383921	19111	50	2	8
2014-03-26 05:42:09.255681	19112	18.0	1	1
2014-03-26 05:42:09.477249	19113	45	2	1
2014-03-26 22:46:57.134648	32565	21.8	1	8
2014-03-26 22:46:57.379815	32566	48	2	8
2014-03-26 05:42:32.661259	19118	402	3	2
2014-03-26 05:42:33.163013	19119	20.5	1	8
2014-03-26 05:42:33.385573	19120	50	2	8
2014-03-26 05:42:44.66046	19121	354	3	2
2014-03-26 05:42:48.258918	19122	18.0	1	1
2014-03-26 05:42:48.480888	19123	45	2	1
2014-03-26 05:42:56.663427	19124	354	3	2
2014-03-26 22:47:11.666152	32567	20.2	1	1
2014-03-26 22:47:11.891062	32568	50	2	1
2014-03-26 05:43:12.161228	19129	20.5	1	8
2014-03-26 05:43:12.390627	19130	50	2	8
2014-03-26 05:43:27.256681	19131	18.0	1	1
2014-03-26 05:43:27.48044	19132	45	2	1
2014-03-26 05:43:32.65858	19133	354	3	2
2014-03-26 22:47:24.717438	32569	24.2	1	10
2014-03-26 22:47:24.952716	32570	41	2	10
2014-03-26 05:43:51.161639	19138	20.5	1	8
2014-03-26 05:43:51.382578	19139	50	2	8
2014-03-26 05:44:06.254523	19140	18.0	1	1
2014-03-26 05:44:06.489847	19141	45	2	1
2014-03-26 22:47:32.556015	32571	338	3	2
2014-03-26 22:47:32.780343	32572	1088655.7679754635	4	2
2014-03-26 05:44:30.50078	19146	20.5	1	8
2014-03-26 05:44:30.72334	19147	50	2	8
2014-03-26 05:44:32.656759	19148	354	3	2
2014-03-26 05:44:45.251034	19149	18.0	1	1
2014-03-26 05:44:45.474069	19150	45	2	1
2014-03-26 22:47:35.04372	32573	21.6	1	9
2014-03-26 22:47:35.285781	32574	48	2	9
2014-03-26 05:45:09.162238	19155	20.5	1	8
2014-03-26 05:45:09.386188	19156	50	2	8
2014-03-26 05:45:24.254159	19157	18.0	1	1
2014-03-26 05:45:24.476469	19158	45	2	1
2014-03-26 05:45:32.661592	19159	354	3	2
2014-03-26 22:47:36.135756	32575	21.8	1	8
2014-03-26 22:47:36.358022	32576	48	2	8
2014-03-26 05:45:48.290011	19164	20.5	1	8
2014-03-26 05:45:48.710132	19165	50	2	8
2014-03-26 05:46:03.249709	19166	18.0	1	1
2014-03-26 05:46:03.482653	19167	45	2	1
2014-03-26 22:47:44.555509	32577	338	3	2
2014-03-26 05:46:27.496406	19172	20.5	1	8
2014-03-26 05:46:27.719449	19173	50	2	8
2014-03-26 05:46:32.658711	19174	354	3	2
2014-03-26 05:46:42.254422	19175	18.0	1	1
2014-03-26 05:46:42.478259	19176	45	2	1
2014-03-26 05:37:19.13573	19043	21.4	1	10
2014-03-26 05:37:19.369524	19044	47	2	10
2014-03-26 05:37:58.134229	19054	21.4	1	10
2014-03-26 05:37:58.366507	19055	47	2	10
2014-03-26 05:38:37.134686	19063	21.3	1	10
2014-03-26 05:38:37.356674	19064	47	2	10
2014-03-26 05:39:16.134016	19071	21.3	1	10
2014-03-26 05:39:16.356315	19072	47	2	10
2014-03-26 05:39:55.134886	19080	21.3	1	10
2014-03-26 05:39:55.358743	19081	47	2	10
2014-03-26 05:40:34.135221	19089	21.3	1	10
2014-03-26 05:40:34.356342	19090	47	2	10
2014-03-26 05:41:13.134883	19097	21.3	1	10
2014-03-26 05:41:13.357061	19098	47	2	10
2014-03-26 05:41:52.138064	19106	21.3	1	10
2014-03-26 05:41:52.359697	19107	47	2	10
2014-03-26 05:42:31.137684	19114	21.3	1	10
2014-03-26 05:42:31.383001	19115	47	2	10
2014-03-26 05:43:10.134843	19125	21.3	1	10
2014-03-26 05:43:10.359319	19126	47	2	10
2014-03-26 05:43:49.13589	19134	21.3	1	10
2014-03-26 05:43:49.357976	19135	47	2	10
2014-03-26 05:44:28.135919	19142	21.3	1	10
2014-03-26 05:44:28.358115	19143	47	2	10
2014-03-26 05:45:07.136316	19151	21.3	1	10
2014-03-26 05:45:07.415041	19152	47	2	10
2014-03-26 05:45:46.269643	19160	21.3	1	10
2014-03-26 05:45:46.679887	19161	47	2	10
2014-03-26 22:47:44.791981	32578	1088656.9170101848	4	2
2014-03-26 22:47:50.665967	32579	20.2	1	1
2014-03-26 05:47:06.161921	19181	20.5	1	8
2014-03-26 05:47:06.393339	19182	50	2	8
2014-03-26 05:47:21.249247	19183	18.0	1	1
2014-03-26 05:47:21.471657	19184	45	2	1
2014-03-26 05:47:32.663563	19185	354	3	2
2014-03-26 22:47:50.890398	32580	50	2	1
2014-03-26 22:48:03.718547	32581	24.2	1	10
2014-03-26 05:47:45.162468	19190	20.5	1	8
2014-03-26 05:47:45.385368	19191	50	2	8
2014-03-26 05:48:00.056202	19192	289	3	2
2014-03-26 05:48:00.373247	19193	18.0	1	1
2014-03-26 05:48:00.595593	19194	45	2	1
2014-03-26 05:48:08.661511	19195	305	3	2
2014-03-26 22:48:03.952725	32582	41	2	10
2014-03-26 22:48:14.25628	32583	21.6	1	9
2014-03-26 05:48:24.160111	19200	20.5	1	8
2014-03-26 05:48:24.383925	19201	50	2	8
2014-03-26 05:48:32.660506	19202	305	3	2
2014-03-26 05:48:39.254256	19203	18.0	1	1
2014-03-26 05:48:39.47788	19204	45	2	1
2014-03-26 22:48:14.481187	32584	48	2	9
2014-03-26 22:48:15.132684	32585	21.8	1	8
2014-03-26 05:49:03.160668	19209	20.5	1	8
2014-03-26 05:49:03.393241	19210	50	2	8
2014-03-26 05:49:18.249345	19211	18.0	1	1
2014-03-26 05:49:18.473598	19212	45	2	1
2014-03-26 05:49:32.663044	19213	289	3	2
2014-03-26 22:48:15.367488	32586	48	2	8
2014-03-26 22:48:29.668825	32587	20.2	1	1
2014-03-26 05:49:42.161213	19218	20.5	1	8
2014-03-26 05:49:42.384224	19219	50	2	8
2014-03-26 05:49:44.662257	19220	354	3	2
2014-03-26 05:49:56.658753	19221	338	3	2
2014-03-26 05:49:57.25024	19222	18.0	1	1
2014-03-26 05:49:57.471766	19223	45	2	1
2014-03-26 22:48:29.893722	32588	50	2	1
2014-03-26 22:48:32.553345	32589	338	3	2
2014-03-26 05:50:21.160111	19228	20.5	1	8
2014-03-26 05:50:21.382741	19229	50	2	8
2014-03-26 05:50:32.658461	19230	354	3	2
2014-03-26 05:50:36.292227	19231	18.0	1	1
2014-03-26 05:50:36.513557	19232	45	2	1
2014-03-26 22:48:32.786524	32590	1088661.5131490706	4	2
2014-03-26 22:48:42.716282	32591	24.2	1	10
2014-03-26 05:51:00.161644	19237	20.5	1	8
2014-03-26 05:51:00.392464	19238	50	2	8
2014-03-26 05:51:15.253284	19239	18.0	1	1
2014-03-26 05:51:15.475933	19240	45	2	1
2014-03-26 05:51:32.660482	19241	354	3	2
2014-03-26 22:48:42.941603	32592	41	2	10
2014-03-26 22:48:53.045163	32593	21.6	1	9
2014-03-26 05:51:39.160453	19246	20.5	1	8
2014-03-26 05:51:39.380833	19247	50	2	8
2014-03-26 05:51:54.25209	19248	18.0	1	1
2014-03-26 05:51:54.482709	19249	45	2	1
2014-03-26 22:48:53.279764	32594	48	2	9
2014-03-26 22:48:54.134956	32595	21.8	1	8
2014-03-26 05:52:18.160805	19254	20.5	1	8
2014-03-26 05:52:18.382622	19255	50	2	8
2014-03-26 05:52:32.655311	19256	338	3	2
2014-03-26 05:52:33.249342	19257	18.0	1	1
2014-03-26 05:52:33.470963	19258	45	2	1
2014-03-26 22:48:54.360677	32596	48	2	8
2014-03-26 22:49:08.905323	32597	20.2	1	1
2014-03-26 05:52:57.161665	19263	20.5	1	8
2014-03-26 05:52:57.38328	19264	50	2	8
2014-03-26 05:53:12.250538	19265	18.0	1	1
2014-03-26 05:53:12.472854	19266	45	2	1
2014-03-26 05:53:32.661525	19267	338	3	2
2014-03-26 22:49:09.139064	32598	50	2	1
2014-03-26 22:49:20.553765	32599	370	3	2
2014-03-26 05:53:36.161615	19272	20.5	1	8
2014-03-26 05:53:36.386409	19273	50	2	8
2014-03-26 05:53:51.248538	19274	18.0	1	1
2014-03-26 05:53:51.470748	19275	45	2	1
2014-03-26 22:49:20.778429	32600	1088666.1092879563	4	2
2014-03-26 22:49:21.719148	32601	24.2	1	10
2014-03-26 05:54:15.160283	19280	20.5	1	8
2014-03-26 05:54:15.3844	19281	50	2	8
2014-03-26 05:54:30.247383	19282	18.0	1	1
2014-03-26 05:54:30.481941	19283	45	2	1
2014-03-26 05:54:32.658853	19284	354	3	2
2014-03-26 22:49:21.951363	32602	41	2	10
2014-03-26 22:49:32.045462	32603	21.6	1	9
2014-03-26 05:54:54.1607	19289	20.5	1	8
2014-03-26 05:54:54.401961	19290	50	2	8
2014-03-26 05:54:56.661066	19291	305	3	2
2014-03-26 05:55:08.65654	19292	289	3	2
2014-03-26 05:55:09.245968	19293	18.0	1	1
2014-03-26 05:55:09.479123	19294	45	2	1
2014-03-26 22:49:32.27058	32604	48	2	9
2014-03-26 22:49:32.580264	32605	370	3	2
2014-03-26 05:55:32.660174	19299	305	3	2
2014-03-26 05:55:33.160656	19300	20.5	1	8
2014-03-26 05:55:33.416004	19301	50	2	8
2014-03-26 05:55:48.248697	19302	18.0	1	1
2014-03-26 05:55:48.504536	19303	45	2	1
2014-03-26 22:49:32.814227	32606	1088667.2583226776	4	2
2014-03-26 05:56:12.509929	19308	20.5	1	8
2014-03-26 05:56:13.050089	19309	50	2	8
2014-03-26 05:56:27.246968	19310	18.0	1	1
2014-03-26 05:56:27.501156	19311	45	2	1
2014-03-26 05:56:32.660636	19312	305	3	2
2014-03-26 05:47:04.135672	19177	21.3	1	10
2014-03-26 05:47:04.359004	19178	47	2	10
2014-03-26 05:47:43.139098	19186	21.3	1	10
2014-03-26 05:47:43.36308	19187	47	2	10
2014-03-26 05:48:22.137836	19196	21.2	1	10
2014-03-26 05:48:22.361611	19197	47	2	10
2014-03-26 05:49:01.137676	19205	21.2	1	10
2014-03-26 05:49:01.361863	19206	47	2	10
2014-03-26 05:49:40.138046	19214	21.2	1	10
2014-03-26 05:49:40.360658	19215	47	2	10
2014-03-26 05:50:19.13797	19224	21.2	1	10
2014-03-26 05:50:19.36005	19225	47	2	10
2014-03-26 05:50:58.138202	19233	21.2	1	10
2014-03-26 05:50:58.360574	19234	47	2	10
2014-03-26 05:51:37.139249	19242	21.2	1	10
2014-03-26 05:51:37.361549	19243	47	2	10
2014-03-26 05:52:16.139218	19250	21.2	1	10
2014-03-26 05:52:16.361387	19251	47	2	10
2014-03-26 05:52:55.140822	19259	21.2	1	10
2014-03-26 05:52:55.3635	19260	47	2	10
2014-03-26 05:53:34.138943	19268	21.2	1	10
2014-03-26 05:53:34.362464	19269	47	2	10
2014-03-26 05:54:13.140007	19276	21.2	1	10
2014-03-26 05:54:13.363313	19277	47	2	10
2014-03-26 05:54:52.140011	19285	21.2	1	10
2014-03-26 05:54:52.362979	19286	47	2	10
2014-03-26 05:55:31.139842	19295	21.2	1	10
2014-03-26 05:55:31.393833	19296	47	2	10
2014-03-26 22:49:33.134611	32607	21.8	1	8
2014-03-26 22:49:33.359059	32608	48	2	8
2014-03-26 05:56:51.161022	19317	20.5	1	8
2014-03-26 05:56:51.386871	19318	50	2	8
2014-03-26 05:57:06.243563	19319	18.0	1	1
2014-03-26 05:57:06.474329	19320	45	2	1
2014-03-26 22:49:47.665401	32609	20.2	1	1
2014-03-26 22:49:47.899853	32610	50	2	1
2014-03-26 05:57:30.160535	19325	20.5	1	8
2014-03-26 05:57:30.385599	19326	50	2	8
2014-03-26 05:57:32.660021	19327	289	3	2
2014-03-26 05:57:45.247964	19328	18.0	1	1
2014-03-26 05:57:45.484477	19329	45	2	1
2014-03-26 22:50:00.719276	32611	24.2	1	10
2014-03-26 22:50:00.943829	32612	41	2	10
2014-03-26 05:58:09.162422	19334	20.5	1	8
2014-03-26 05:58:09.404449	19335	50	2	8
2014-03-26 05:58:24.248061	19336	18.0	1	1
2014-03-26 05:58:24.468447	19337	45	2	1
2014-03-26 05:58:32.657188	19338	289	3	2
2014-03-26 22:50:11.045511	32613	21.6	1	9
2014-03-26 22:50:11.290803	32614	48	2	9
2014-03-26 05:58:48.162979	19343	20.5	1	8
2014-03-26 05:58:48.383496	19344	49	2	8
2014-03-26 05:59:03.243585	19345	18.0	1	1
2014-03-26 05:59:03.479717	19346	45	2	1
2014-03-26 22:50:12.132574	32615	21.7	1	8
2014-03-26 22:50:12.355717	32616	48	2	8
2014-03-26 05:59:27.161447	19351	20.4	1	8
2014-03-26 05:59:27.384687	19352	49	2	8
2014-03-26 05:59:32.661776	19353	289	3	2
2014-03-26 05:59:42.24744	19354	18.0	1	1
2014-03-26 05:59:42.474502	19355	45	2	1
2014-03-26 22:50:26.665244	32617	20.2	1	1
2014-03-26 22:50:26.898917	32618	50	2	1
2014-03-26 06:00:06.160706	19360	20.4	1	8
2014-03-26 06:00:06.394671	19361	50	2	8
2014-03-26 06:00:21.245645	19362	18.0	1	1
2014-03-26 06:00:21.472797	19363	45	2	1
2014-03-26 06:00:32.658035	19364	305	3	2
2014-03-26 22:50:32.550001	32619	370	3	2
2014-03-26 22:50:32.775626	32620	1088673.0034962846	4	2
2014-03-26 06:00:45.161283	19369	20.4	1	8
2014-03-26 06:00:45.390898	19370	49	2	8
2014-03-26 06:01:00.244859	19371	17.9	1	1
2014-03-26 06:01:00.47566	19372	45	2	1
2014-03-26 22:50:39.721459	32621	24.2	1	10
2014-03-26 22:50:39.954237	32622	41	2	10
2014-03-26 06:01:24.160634	19377	20.4	1	8
2014-03-26 06:01:24.382998	19378	49	2	8
2014-03-26 06:01:32.657622	19379	289	3	2
2014-03-26 06:01:39.244555	19380	17.9	1	1
2014-03-26 06:01:39.467092	19381	45	2	1
2014-03-26 22:50:50.044887	32623	21.6	1	9
2014-03-26 22:50:50.272966	32624	48	2	9
2014-03-26 06:02:03.161156	19386	20.4	1	8
2014-03-26 06:02:03.386374	19387	49	2	8
2014-03-26 06:02:08.659094	19388	354	3	2
2014-03-26 06:02:18.245062	19389	17.9	1	1
2014-03-26 06:02:18.653142	19390	45	2	1
2014-03-26 06:02:20.657895	19391	354	3	2
2014-03-26 06:02:32.660055	19392	354	3	2
2014-03-26 22:50:51.133073	32625	21.7	1	8
2014-03-26 22:50:51.368696	32626	48	2	8
2014-03-26 06:02:42.161668	19397	20.4	1	8
2014-03-26 06:02:42.392931	19398	49	2	8
2014-03-26 06:02:57.244294	19399	17.9	1	1
2014-03-26 06:02:57.467165	19400	45	2	1
2014-03-26 22:51:05.663273	32627	20.2	1	1
2014-03-26 22:51:05.888273	32628	50	2	1
2014-03-26 06:03:21.162455	19405	20.4	1	8
2014-03-26 06:03:21.393535	19406	49	2	8
2014-03-26 06:03:32.659296	19407	338	3	2
2014-03-26 06:03:36.245043	19408	17.9	1	1
2014-03-26 06:03:36.466282	19409	45	2	1
2014-03-26 22:51:18.718138	32629	24.2	1	10
2014-03-26 22:51:18.95474	32630	41	2	10
2014-03-26 06:04:00.164152	19414	20.4	1	8
2014-03-26 06:04:00.387511	19415	49	2	8
2014-03-26 06:04:15.247483	19416	17.9	1	1
2014-03-26 06:04:15.683691	19417	45	2	1
2014-03-26 06:04:32.664796	19418	354	3	2
2014-03-26 22:51:29.044855	32631	21.6	1	9
2014-03-26 22:51:29.267399	32632	48	2	9
2014-03-26 06:04:39.163006	19423	20.4	1	8
2014-03-26 06:04:39.409559	19424	49	2	8
2014-03-26 06:04:54.243375	19425	17.9	1	1
2014-03-26 06:04:54.467924	19426	45	2	1
2014-03-26 22:51:30.171309	32633	21.7	1	8
2014-03-26 22:51:30.421739	32634	48	2	8
2014-03-26 06:05:18.160457	19431	20.4	1	8
2014-03-26 06:05:18.382748	19432	49	2	8
2014-03-26 06:05:32.656692	19433	338	3	2
2014-03-26 06:05:33.243886	19434	17.9	1	1
2014-03-26 06:05:33.465659	19435	45	2	1
2014-03-26 22:51:32.556984	32635	370	3	2
2014-03-26 22:51:32.780145	32636	1088679.8977046132	4	2
2014-03-26 06:05:57.16018	19440	20.4	1	8
2014-03-26 06:05:57.391691	19441	49	2	8
2014-03-26 06:06:12.48332	19442	17.9	1	1
2014-03-26 06:06:12.705961	19443	45	2	1
2014-03-26 06:06:32.656923	19444	338	3	2
2014-03-26 22:51:44.906492	32637	20.2	1	1
2014-03-26 05:56:49.140867	19313	21.2	1	10
2014-03-26 05:56:49.363572	19314	47	2	10
2014-03-26 05:57:28.140104	19321	21.1	1	10
2014-03-26 05:57:28.364691	19322	47	2	10
2014-03-26 05:58:07.14192	19330	21.1	1	10
2014-03-26 05:58:07.373221	19331	47	2	10
2014-03-26 05:58:46.140536	19339	21.1	1	10
2014-03-26 05:58:46.36816	19340	47	2	10
2014-03-26 05:59:25.14238	19347	21.1	1	10
2014-03-26 05:59:25.366893	19348	47	2	10
2014-03-26 06:00:04.14139	19356	21.1	1	10
2014-03-26 06:00:04.377723	19357	47	2	10
2014-03-26 06:00:43.14157	19365	21.1	1	10
2014-03-26 06:00:43.363651	19366	47	2	10
2014-03-26 06:01:22.142523	19373	21.1	1	10
2014-03-26 06:01:22.365995	19374	47	2	10
2014-03-26 06:02:01.141408	19382	21.1	1	10
2014-03-26 06:02:01.376369	19383	47	2	10
2014-03-26 06:02:40.142435	19393	21.1	1	10
2014-03-26 06:02:40.433488	19394	47	2	10
2014-03-26 06:03:19.143915	19401	21.1	1	10
2014-03-26 06:03:19.377548	19402	47	2	10
2014-03-26 06:03:58.145226	19410	21.1	1	10
2014-03-26 06:03:58.367793	19411	47	2	10
2014-03-26 06:04:37.14297	19419	21.1	1	10
2014-03-26 06:04:37.368751	19420	47	2	10
2014-03-26 06:05:16.142853	19427	21.1	1	10
2014-03-26 06:05:16.564302	19428	47	2	10
2014-03-26 06:05:55.142465	19436	21.1	1	10
2014-03-26 06:05:55.372263	19437	47	2	10
2014-03-26 06:06:36.160748	19449	20.4	1	8
2014-03-26 06:06:36.381414	19450	49	2	8
2014-03-26 06:06:51.24326	19451	17.9	1	1
2014-03-26 06:06:51.476102	19452	45	2	1
2014-03-26 06:07:08.65619	19453	305	3	2
2014-03-26 22:51:45.140009	32638	50	2	1
2014-03-26 22:51:56.552575	32639	370	3	2
2014-03-26 06:07:15.160316	19458	20.4	1	8
2014-03-26 06:07:15.3905	19459	49	2	8
2014-03-26 06:07:20.655923	19460	289	3	2
2014-03-26 06:07:30.242358	19461	17.9	1	1
2014-03-26 06:07:30.471196	19462	45	2	1
2014-03-26 06:07:32.65794	19463	289	3	2
2014-03-26 22:51:56.776876	32640	1088682.195774056	4	2
2014-03-26 22:51:57.719877	32641	24.2	1	10
2014-03-26 06:07:54.160097	19468	20.4	1	8
2014-03-26 06:07:54.400236	19469	49	2	8
2014-03-26 06:08:09.241874	19470	17.9	1	1
2014-03-26 06:08:09.463488	19471	45	2	1
2014-03-26 22:51:57.955109	32642	41	2	10
2014-03-26 22:52:08.047092	32643	21.6	1	9
2014-03-26 06:08:33.04226	19476	289	3	2
2014-03-26 06:08:33.355539	19477	20.4	1	8
2014-03-26 06:08:33.57669	19478	49	2	8
2014-03-26 06:08:48.240089	19479	17.9	1	1
2014-03-26 06:08:48.470352	19480	45	2	1
2014-03-26 22:52:08.270594	32644	48	2	9
2014-03-26 22:52:08.578526	32645	370	3	2
2014-03-26 06:09:12.16257	19485	20.4	1	8
2014-03-26 06:09:12.385548	19486	49	2	8
2014-03-26 06:09:27.240331	19487	17.9	1	1
2014-03-26 06:09:27.472033	19488	45	2	1
2014-03-26 06:09:32.65641	19489	289	3	2
2014-03-26 22:52:08.811674	32646	1088683.3448087773	4	2
2014-03-26 22:52:09.133847	32647	21.7	1	8
2014-03-26 06:09:51.160364	19494	20.4	1	8
2014-03-26 06:09:51.382757	19495	49	2	8
2014-03-26 06:10:06.239906	19496	17.9	1	1
2014-03-26 06:10:06.463281	19497	45	2	1
2014-03-26 22:52:09.356759	32648	48	2	8
2014-03-26 22:52:23.664332	32649	20.2	1	1
2014-03-26 06:10:30.160858	19502	20.4	1	8
2014-03-26 06:10:30.392743	19503	49	2	8
2014-03-26 06:10:32.660368	19504	289	3	2
2014-03-26 06:10:45.239913	19505	17.9	1	1
2014-03-26 06:10:45.474465	19506	45	2	1
2014-03-26 22:52:23.898503	32650	50	2	1
2014-03-26 22:52:32.552857	32651	370	3	2
2014-03-26 06:11:09.161538	19511	20.4	1	8
2014-03-26 06:11:09.381301	19512	49	2	8
2014-03-26 06:11:24.240449	19513	17.9	1	1
2014-03-26 06:11:24.482366	19514	45	2	1
2014-03-26 06:11:32.659302	19515	289	3	2
2014-03-26 22:52:32.777899	32652	1088685.6428782202	4	2
2014-03-26 22:52:36.719508	32653	24.2	1	10
2014-03-26 06:11:48.160688	19520	20.4	1	8
2014-03-26 06:11:48.381425	19521	49	2	8
2014-03-26 06:12:03.236676	19522	17.9	1	1
2014-03-26 06:12:03.458836	19523	45	2	1
2014-03-26 22:52:36.953275	32654	41	2	10
2014-03-26 22:52:47.045395	32655	21.6	1	9
2014-03-26 06:12:27.160508	19528	20.4	1	8
2014-03-26 06:12:27.382396	19529	49	2	8
2014-03-26 06:12:32.660841	19530	289	3	2
2014-03-26 06:12:42.240544	19531	17.9	1	1
2014-03-26 06:12:42.463322	19532	45	2	1
2014-03-26 22:52:47.269846	32656	48	2	9
2014-03-26 22:52:48.133819	32657	21.7	1	8
2014-03-26 06:13:06.160985	19537	20.4	1	8
2014-03-26 06:13:06.381721	19538	49	2	8
2014-03-26 06:13:21.243033	19539	17.9	1	1
2014-03-26 06:13:21.463619	19540	45	2	1
2014-03-26 06:13:32.65955	19541	289	3	2
2014-03-26 22:52:48.367401	32658	48	2	8
2014-03-26 22:53:02.664271	32659	20.2	1	1
2014-03-26 06:13:45.160569	19546	20.4	1	8
2014-03-26 06:13:45.429539	19547	49	2	8
2014-03-26 06:14:00.238062	19548	17.9	1	1
2014-03-26 06:14:00.66367	19549	45	2	1
2014-03-26 06:14:08.660436	19550	338	3	2
2014-03-26 06:14:20.658327	19551	354	3	2
2014-03-26 22:53:02.890656	32660	50	2	1
2014-03-26 22:53:15.719606	32661	24.2	1	10
2014-03-26 06:14:24.163488	19556	20.4	1	8
2014-03-26 06:14:24.385109	19557	49	2	8
2014-03-26 06:14:32.656368	19558	338	3	2
2014-03-26 06:14:39.239888	19559	17.9	1	1
2014-03-26 06:14:39.461191	19560	45	2	1
2014-03-26 22:53:15.96344	32662	41	2	10
2014-03-26 22:53:26.044683	32663	21.6	1	9
2014-03-26 06:15:03.160029	19565	20.4	1	8
2014-03-26 06:15:03.393253	19566	49	2	8
2014-03-26 06:15:18.240833	19567	17.9	1	1
2014-03-26 06:15:18.461523	19568	45	2	1
2014-03-26 06:15:32.660297	19569	354	3	2
2014-03-26 22:53:26.269438	32664	48	2	9
2014-03-26 22:53:27.133548	32665	21.7	1	8
2014-03-26 06:15:42.160756	19574	20.4	1	8
2014-03-26 06:15:42.382538	19575	49	2	8
2014-03-26 06:15:57.238138	19576	17.9	1	1
2014-03-26 06:15:57.471264	19577	45	2	1
2014-03-26 22:53:27.367503	32666	48	2	8
2014-03-26 06:16:21.160561	19582	20.4	1	8
2014-03-26 06:16:21.382264	19583	49	2	8
2014-03-26 06:16:32.789994	19584	354	3	2
2014-03-26 06:07:13.143372	19454	21.0	1	10
2014-03-26 06:07:13.372803	19455	47	2	10
2014-03-26 06:07:52.143736	19464	21.0	1	10
2014-03-26 06:07:52.365054	19465	47	2	10
2014-03-26 06:08:31.144077	19472	21.0	1	10
2014-03-26 06:08:31.377649	19473	47	2	10
2014-03-26 06:09:10.145968	19481	21.0	1	10
2014-03-26 06:09:10.366692	19482	47	2	10
2014-03-26 06:09:49.144032	19490	21.0	1	10
2014-03-26 06:09:49.366923	19491	47	2	10
2014-03-26 06:10:28.145173	19498	21.0	1	10
2014-03-26 06:10:28.378072	19499	46	2	10
2014-03-26 06:11:07.145325	19507	21.0	1	10
2014-03-26 06:11:07.368142	19508	46	2	10
2014-03-26 06:11:46.144654	19516	21.0	1	10
2014-03-26 06:11:46.366611	19517	46	2	10
2014-03-26 06:12:25.145521	19524	21.0	1	10
2014-03-26 06:12:25.367289	19525	46	2	10
2014-03-26 06:13:04.14391	19533	21.0	1	10
2014-03-26 06:13:04.366228	19534	46	2	10
2014-03-26 06:13:43.147348	19542	21.0	1	10
2014-03-26 06:13:43.555184	19543	46	2	10
2014-03-26 06:14:22.148774	19552	21.0	1	10
2014-03-26 06:14:22.373333	19553	46	2	10
2014-03-26 06:15:01.144511	19561	21.0	1	10
2014-03-26 06:15:01.379358	19562	46	2	10
2014-03-26 06:15:40.146104	19570	21.0	1	10
2014-03-26 06:15:40.369034	19571	46	2	10
2014-03-26 06:16:36.370002	19585	17.9	1	1
2014-03-26 06:16:36.789909	19586	45	2	1
2014-03-26 22:53:32.550909	32667	305	3	2
2014-03-26 22:53:32.77611	32668	1088691.3880518272	4	2
2014-03-26 06:17:00.161839	19591	20.4	1	8
2014-03-26 06:17:00.392397	19592	49	2	8
2014-03-26 06:17:15.240142	19593	17.9	1	1
2014-03-26 06:17:15.462522	19594	45	2	1
2014-03-26 06:17:32.66101	19595	354	3	2
2014-03-26 22:53:41.665344	32669	20.2	1	1
2014-03-26 22:53:41.901061	32670	50	2	1
2014-03-26 06:17:39.161922	19600	20.4	1	8
2014-03-26 06:17:39.383606	19601	49	2	8
2014-03-26 06:17:54.233787	19602	17.9	1	1
2014-03-26 06:17:54.474772	19603	45	2	1
2014-03-26 22:53:44.551697	32671	305	3	2
2014-03-26 22:53:44.774743	32672	1088692.5370865487	4	2
2014-03-26 06:18:18.162204	19608	20.4	1	8
2014-03-26 06:18:18.38168	19609	49	2	8
2014-03-26 06:18:32.65506	19610	354	3	2
2014-03-26 06:18:33.233627	19611	17.9	1	1
2014-03-26 06:18:33.454141	19612	45	2	1
2014-03-26 22:53:54.720502	32673	24.2	1	10
2014-03-26 22:53:54.954383	32674	41	2	10
2014-03-26 06:18:57.16063	19617	20.4	1	8
2014-03-26 06:18:57.392618	19618	49	2	8
2014-03-26 06:19:08.658623	19619	305	3	2
2014-03-26 06:19:12.236105	19620	17.9	1	1
2014-03-26 06:19:12.459091	19621	45	2	1
2014-03-26 06:19:32.513703	19622	305	3	2
2014-03-26 06:19:32.822427	19623	305	3	2
2014-03-26 22:53:56.555328	32675	338	3	2
2014-03-26 22:53:56.799621	32676	1088693.68612127	4	2
2014-03-26 06:19:36.162303	19628	20.4	1	8
2014-03-26 06:19:36.393413	19629	49	2	8
2014-03-26 06:19:51.235597	19630	17.9	1	1
2014-03-26 06:19:51.457645	19631	45	2	1
2014-03-26 22:54:05.044431	32677	21.6	1	9
2014-03-26 22:54:05.279255	32678	48	2	9
2014-03-26 06:20:15.485345	19636	20.4	1	8
2014-03-26 06:20:15.716305	19637	49	2	8
2014-03-26 06:20:30.2368	19638	17.9	1	1
2014-03-26 06:20:30.459073	19639	45	2	1
2014-03-26 06:20:32.659599	19640	289	3	2
2014-03-26 22:54:06.135173	32679	21.7	1	8
2014-03-26 22:54:06.360861	32680	48	2	8
2014-03-26 06:20:54.161711	19643	20.4	1	8
2014-03-26 06:20:54.383425	19644	49	2	8
2014-03-26 06:21:09.232738	19645	17.9	1	1
2014-03-26 06:21:09.456289	19646	45	2	1
2014-03-26 22:54:08.555026	32681	338	3	2
2014-03-26 22:54:08.788958	32682	1088694.8351559916	4	2
2014-03-26 06:21:32.657772	19651	289	3	2
2014-03-26 06:21:33.375631	19652	20.4	1	8
2014-03-26 06:21:33.609988	19653	49	2	8
2014-03-26 06:21:48.233834	19654	17.9	1	1
2014-03-26 06:21:48.458634	19655	45	2	1
2014-03-26 22:54:20.662166	32683	20.2	1	1
2014-03-26 22:54:20.887783	32684	50	2	1
2014-03-26 06:22:12.161633	19660	20.4	1	8
2014-03-26 06:22:12.393501	19661	49	2	8
2014-03-26 06:22:27.233122	19662	17.9	1	1
2014-03-26 06:22:27.456923	19663	45	2	1
2014-03-26 06:22:32.66147	19664	305	3	2
2014-03-26 22:54:32.553267	32685	305	3	2
2014-03-26 22:54:32.787665	32686	1088697.1332254345	4	2
2014-03-26 06:22:51.496913	19669	20.4	1	8
2014-03-26 06:22:51.719496	19670	49	2	8
2014-03-26 06:23:06.236309	19671	17.9	1	1
2014-03-26 06:23:06.468871	19672	45	2	1
2014-03-26 22:54:33.720464	32687	24.2	1	10
2014-03-26 22:54:33.944639	32688	41	2	10
2014-03-26 06:23:30.161882	19677	20.4	1	8
2014-03-26 06:23:30.38264	19678	49	2	8
2014-03-26 06:23:32.656014	19679	305	3	2
2014-03-26 06:23:45.231272	19680	17.9	1	1
2014-03-26 06:23:45.454138	19681	45	2	1
2014-03-26 22:54:44.045393	32689	21.6	1	9
2014-03-26 22:54:44.278286	32690	48	2	9
2014-03-26 06:24:09.160381	19686	20.4	1	8
2014-03-26 06:24:09.392573	19687	49	2	8
2014-03-26 06:24:24.235303	19688	17.9	1	1
2014-03-26 06:24:24.45667	19689	45	2	1
2014-03-26 06:24:32.657479	19690	289	3	2
2014-03-26 22:54:44.587322	32691	338	3	2
2014-03-26 22:54:44.811179	32692	1088698.2822601558	4	2
2014-03-26 06:24:48.50712	19695	20.4	1	8
2014-03-26 06:24:48.727341	19696	49	2	8
2014-03-26 06:25:03.359908	19697	17.9	1	1
2014-03-26 06:25:03.799941	19698	45	2	1
2014-03-26 22:54:45.135745	32693	21.7	1	8
2014-03-26 22:54:45.370713	32694	48	2	8
2014-03-26 06:25:27.163877	19703	20.4	1	8
2014-03-26 06:25:27.384639	19704	49	2	8
2014-03-26 06:25:32.655391	19705	289	3	2
2014-03-26 06:25:42.232417	19706	17.9	1	1
2014-03-26 06:25:42.454745	19707	45	2	1
2014-03-26 22:54:56.552843	32695	338	3	2
2014-03-26 06:26:06.163023	19712	20.4	1	8
2014-03-26 06:26:06.394327	19713	49	2	8
2014-03-26 06:26:08.656375	19714	354	3	2
2014-03-26 06:26:20.657497	19715	338	3	2
2014-03-26 06:26:21.230517	19716	17.9	1	1
2014-03-26 06:26:21.464063	19717	45	2	1
2014-03-26 06:26:32.655252	19718	338	3	2
2014-03-26 06:16:58.147188	19587	20.9	1	10
2014-03-26 06:16:58.377852	19588	47	2	10
2014-03-26 06:17:37.152383	19596	20.9	1	10
2014-03-26 06:17:37.377054	19597	47	2	10
2014-03-26 06:18:16.148016	19604	20.9	1	10
2014-03-26 06:18:16.372042	19605	47	2	10
2014-03-26 06:18:55.147639	19613	20.9	1	10
2014-03-26 06:18:55.379278	19614	47	2	10
2014-03-26 06:19:34.150084	19624	20.9	1	10
2014-03-26 06:19:34.38074	19625	47	2	10
2014-03-26 06:20:13.15033	19632	20.9	1	10
2014-03-26 06:20:13.387321	19633	47	2	10
2014-03-26 06:21:31.150284	19647	20.9	1	10
2014-03-26 06:21:31.372384	19648	47	2	10
2014-03-26 06:22:10.150241	19656	20.9	1	10
2014-03-26 06:22:10.383733	19657	47	2	10
2014-03-26 06:22:49.149724	19665	20.9	1	10
2014-03-26 06:22:49.374859	19666	47	2	10
2014-03-26 06:23:28.148515	19673	20.9	1	10
2014-03-26 06:23:28.371609	19674	47	2	10
2014-03-26 06:24:07.150204	19682	20.9	1	10
2014-03-26 06:24:07.380712	19683	47	2	10
2014-03-26 06:24:46.150631	19691	20.9	1	10
2014-03-26 06:24:46.380041	19692	47	2	10
2014-03-26 06:25:25.152117	19699	20.9	1	10
2014-03-26 06:25:25.373676	19700	47	2	10
2014-03-26 06:26:04.150785	19708	20.9	1	10
2014-03-26 06:26:04.393944	19709	47	2	10
2014-03-26 22:54:56.779098	32696	1088699.431294877	4	2
2014-03-26 22:54:59.66228	32697	20.2	1	1
2014-03-26 06:26:45.302851	19723	20.4	1	8
2014-03-26 06:26:45.724336	19724	49	2	8
2014-03-26 06:27:00.231208	19725	17.9	1	1
2014-03-26 06:27:00.454757	19726	45	2	1
2014-03-26 22:54:59.894921	32698	50	2	1
2014-03-26 22:55:12.720542	32699	24.2	1	10
2014-03-26 06:27:24.160689	19731	20.4	1	8
2014-03-26 06:27:24.400426	19732	49	2	8
2014-03-26 06:27:32.659279	19733	354	3	2
2014-03-26 06:27:39.233208	19734	17.8	1	1
2014-03-26 06:27:39.458011	19735	45	2	1
2014-03-26 22:55:12.944644	32700	41	2	10
2014-03-26 22:55:23.062543	32701	21.5	1	9
2014-03-26 06:28:03.16035	19740	20.4	1	8
2014-03-26 06:28:03.382565	19741	49	2	8
2014-03-26 06:28:18.2326	19742	17.8	1	1
2014-03-26 06:28:18.464512	19743	45	2	1
2014-03-26 06:28:32.656412	19744	354	3	2
2014-03-26 22:55:23.29508	32702	48	2	9
2014-03-26 22:55:24.132777	32703	21.7	1	8
2014-03-26 06:28:42.160713	19749	20.4	1	8
2014-03-26 06:28:42.382898	19750	49	2	8
2014-03-26 06:28:57.230592	19751	17.8	1	1
2014-03-26 06:28:57.452047	19752	45	2	1
2014-03-26 22:55:24.357652	32704	48	2	8
2014-03-26 22:55:32.552069	32705	338	3	2
2014-03-26 06:29:21.16207	19757	20.4	1	8
2014-03-26 06:29:21.385178	19758	49	2	8
2014-03-26 06:29:32.655162	19759	354	3	2
2014-03-26 06:29:36.228607	19760	17.8	1	1
2014-03-26 06:29:36.449704	19761	45	2	1
2014-03-26 22:55:32.788742	32706	1088702.8783990415	4	2
2014-03-26 22:55:38.661994	32707	20.2	1	1
2014-03-26 06:30:00.161345	19766	20.4	1	8
2014-03-26 06:30:00.392707	19767	49	2	8
2014-03-26 06:30:15.229868	19768	17.8	1	1
2014-03-26 06:30:15.451502	19769	45	2	1
2014-03-26 06:30:32.655989	19770	338	3	2
2014-03-26 22:55:38.885751	32708	50	2	1
2014-03-26 22:55:51.721595	32709	24.2	1	10
2014-03-26 06:30:39.162722	19775	20.4	1	8
2014-03-26 06:30:39.382976	19776	49	2	8
2014-03-26 06:30:44.655625	19777	418	3	2
2014-03-26 06:30:54.231495	19778	17.8	1	1
2014-03-26 06:30:54.454353	19779	45	2	1
2014-03-26 06:30:56.655557	19780	354	3	2
2014-03-26 06:31:08.710036	19781	354	3	2
2014-03-26 22:55:51.967192	32710	41	2	10
2014-03-26 22:56:02.044289	32711	21.5	1	9
2014-03-26 06:31:18.161797	19786	20.4	1	8
2014-03-26 06:31:18.385286	19787	49	2	8
2014-03-26 06:31:32.654728	19788	354	3	2
2014-03-26 06:31:33.230158	19789	17.8	1	1
2014-03-26 06:31:33.454804	19790	45	2	1
2014-03-26 22:56:02.268224	32712	48	2	9
2014-03-26 22:56:03.133386	32713	21.7	1	8
2014-03-26 06:31:57.160764	19795	20.4	1	8
2014-03-26 06:31:57.393643	19796	49	2	8
2014-03-26 06:32:12.229023	19797	17.8	1	1
2014-03-26 06:32:12.451444	19798	45	2	1
2014-03-26 06:32:32.658308	19799	354	3	2
2014-03-26 22:56:03.365352	32714	48	2	8
2014-03-26 22:56:17.661131	32715	20.2	1	1
2014-03-26 06:32:36.160928	19804	20.4	1	8
2014-03-26 06:32:36.381045	19805	49	2	8
2014-03-26 06:32:51.226252	19806	17.8	1	1
2014-03-26 06:32:51.453177	19807	45	2	1
2014-03-26 22:56:17.886122	32716	50	2	1
2014-03-26 22:56:30.720499	32717	24.1	1	10
2014-03-26 06:33:15.161086	19812	20.4	1	8
2014-03-26 06:33:15.382611	19813	49	2	8
2014-03-26 06:33:30.22744	19814	17.8	1	1
2014-03-26 06:33:30.458842	19815	45	2	1
2014-03-26 06:33:32.6577	19816	354	3	2
2014-03-26 22:56:30.956653	32718	41	2	10
2014-03-26 22:56:32.550863	32719	338	3	2
2014-03-26 06:33:54.160059	19821	20.4	1	8
2014-03-26 06:33:54.381063	19822	49	2	8
2014-03-26 06:34:09.229751	19823	17.8	1	1
2014-03-26 06:34:09.451926	19824	45	2	1
2014-03-26 22:56:32.774375	32720	1088708.6235726485	4	2
2014-03-26 22:56:41.044113	32721	21.5	1	9
2014-03-26 06:34:32.959603	19829	354	3	2
2014-03-26 06:34:33.285578	19830	20.4	1	8
2014-03-26 06:34:33.507561	19831	49	2	8
2014-03-26 06:34:48.228834	19832	17.8	1	1
2014-03-26 06:34:48.452076	19833	45	2	1
2014-03-26 22:56:41.277579	32722	48	2	9
2014-03-26 22:56:42.133688	32723	21.7	1	8
2014-03-26 06:35:12.161876	19838	20.4	1	8
2014-03-26 06:35:12.383221	19839	49	2	8
2014-03-26 06:35:27.225973	19840	17.8	1	1
2014-03-26 06:35:27.457307	19841	45	2	1
2014-03-26 06:35:32.657513	19842	354	3	2
2014-03-26 22:56:42.35588	32724	48	2	8
2014-03-26 06:35:51.161751	19847	20.4	1	8
2014-03-26 06:35:51.383346	19848	49	2	8
2014-03-26 06:36:06.230258	19849	17.8	1	1
2014-03-26 06:36:06.451615	19850	45	2	1
2014-03-26 06:36:30.160756	19855	20.4	1	8
2014-03-26 06:36:30.391659	19856	49	2	8
2014-03-26 06:27:22.15084	19727	20.8	1	10
2014-03-26 06:27:22.373727	19728	47	2	10
2014-03-26 06:28:01.150546	19736	20.8	1	10
2014-03-26 06:28:01.3727	19737	47	2	10
2014-03-26 06:28:40.149825	19745	20.8	1	10
2014-03-26 06:28:40.373268	19746	47	2	10
2014-03-26 06:29:19.152629	19753	20.8	1	10
2014-03-26 06:29:19.374955	19754	47	2	10
2014-03-26 06:29:58.150601	19762	20.8	1	10
2014-03-26 06:29:58.38376	19763	47	2	10
2014-03-26 06:30:37.15434	19771	20.8	1	10
2014-03-26 06:30:37.376103	19772	47	2	10
2014-03-26 06:31:16.150571	19782	20.8	1	10
2014-03-26 06:31:16.374666	19783	47	2	10
2014-03-26 06:31:55.152298	19791	20.8	1	10
2014-03-26 06:31:55.386074	19792	47	2	10
2014-03-26 06:32:34.153452	19800	20.8	1	10
2014-03-26 06:32:34.375063	19801	47	2	10
2014-03-26 06:33:13.152107	19808	20.8	1	10
2014-03-26 06:33:13.374498	19809	47	2	10
2014-03-26 06:33:52.152704	19817	20.8	1	10
2014-03-26 06:33:52.374543	19818	47	2	10
2014-03-26 06:34:31.153423	19825	20.8	1	10
2014-03-26 06:34:31.374945	19826	47	2	10
2014-03-26 06:35:10.154406	19834	20.8	1	10
2014-03-26 06:35:10.37737	19835	47	2	10
2014-03-26 06:35:49.154704	19843	20.8	1	10
2014-03-26 06:35:49.37707	19844	47	2	10
2014-03-26 06:36:28.153591	19851	20.8	1	10
2014-03-26 06:36:28.377051	19852	47	2	10
2014-03-26 06:36:32.654139	19857	354	3	2
2014-03-26 06:36:45.22655	19858	17.8	1	1
2014-03-26 06:36:45.447238	19859	45	2	1
2014-03-26 22:56:56.672279	32725	20.2	1	1
2014-03-26 22:56:56.908762	32726	50	2	1
2014-03-26 06:37:09.409463	19864	20.4	1	8
2014-03-26 06:37:09.829803	19865	49	2	8
2014-03-26 06:37:24.22403	19866	17.8	1	1
2014-03-26 06:37:24.459143	19867	45	2	1
2014-03-26 06:37:32.653684	19868	402	3	2
2014-03-26 06:37:44.658221	19869	418	3	2
2014-03-26 22:57:09.723198	32727	24.1	1	10
2014-03-26 22:57:09.947952	32728	41	2	10
2014-03-26 06:37:48.159458	19874	20.4	1	8
2014-03-26 06:37:48.382356	19875	49	2	8
2014-03-26 06:38:03.227663	19876	17.8	1	1
2014-03-26 06:38:03.460141	19877	45	2	1
2014-03-26 22:57:20.047416	32729	21.5	1	9
2014-03-26 22:57:20.280882	32730	48	2	9
2014-03-26 06:38:27.160153	19882	20.4	1	8
2014-03-26 06:38:27.381139	19883	49	2	8
2014-03-26 06:38:32.660949	19884	402	3	2
2014-03-26 06:38:42.223047	19885	17.8	1	1
2014-03-26 06:38:42.445734	19886	45	2	1
2014-03-26 22:57:21.132967	32731	21.7	1	8
2014-03-26 22:57:21.357296	32732	48	2	8
2014-03-26 06:39:06.160359	19891	20.4	1	8
2014-03-26 06:39:06.390504	19892	49	2	8
2014-03-26 06:39:21.227914	19893	17.8	1	1
2014-03-26 06:39:21.451345	19894	45	2	1
2014-03-26 06:39:32.654151	19895	402	3	2
2014-03-26 22:57:32.549603	32733	338	3	2
2014-03-26 22:57:32.78372	32734	1088714.3687462555	4	2
2014-03-26 06:39:45.161152	19900	20.4	1	8
2014-03-26 06:39:45.381561	19901	49	2	8
2014-03-26 06:40:00.225779	19902	17.8	1	1
2014-03-26 06:40:00.458668	19903	45	2	1
2014-03-26 22:57:35.662275	32735	20.2	1	1
2014-03-26 22:57:35.891742	32736	50	2	1
2014-03-26 06:40:24.160834	19908	20.4	1	8
2014-03-26 06:40:24.383183	19909	49	2	8
2014-03-26 06:40:32.655892	19910	402	3	2
2014-03-26 06:40:39.221612	19911	17.8	1	1
2014-03-26 06:40:39.444849	19912	45	2	1
2014-03-26 22:57:48.721233	32737	24.1	1	10
2014-03-26 22:57:48.959908	32738	41	2	10
2014-03-26 06:41:03.16252	19917	20.4	1	8
2014-03-26 06:41:03.405014	19918	49	2	8
2014-03-26 06:41:18.225922	19919	17.8	1	1
2014-03-26 06:41:18.44753	19920	45	2	1
2014-03-26 06:41:32.65365	19921	418	3	2
2014-03-26 22:57:56.553706	32739	305	3	2
2014-03-26 22:57:56.779297	32740	1088716.6668156984	4	2
2014-03-26 06:41:42.162838	19926	20.4	1	8
2014-03-26 06:41:42.384195	19927	49	2	8
2014-03-26 06:41:57.226586	19928	17.8	1	1
2014-03-26 06:41:57.458482	19929	45	2	1
2014-03-26 22:57:59.047195	32741	21.5	1	9
2014-03-26 22:57:59.279117	32742	48	2	9
2014-03-26 06:42:21.160842	19934	20.4	1	8
2014-03-26 06:42:21.383908	19935	49	2	8
2014-03-26 06:42:32.658017	19936	402	3	2
2014-03-26 06:42:36.223162	19937	17.8	1	1
2014-03-26 06:42:36.446688	19938	45	2	1
2014-03-26 22:58:00.134696	32743	21.7	1	8
2014-03-26 22:58:00.358812	32744	48	2	8
2014-03-26 06:43:00.48631	19943	20.4	1	8
2014-03-26 06:43:00.718124	19944	49	2	8
2014-03-26 06:43:08.660018	19945	354	3	2
2014-03-26 06:43:15.223671	19946	17.8	1	1
2014-03-26 06:43:15.447617	19947	45	2	1
2014-03-26 06:43:20.655027	19948	338	3	2
2014-03-26 06:43:32.657341	19949	354	3	2
2014-03-26 22:58:08.55335	32745	305	3	2
2014-03-26 22:58:08.788665	32746	1088717.81585042	4	2
2014-03-26 06:43:39.161077	19954	20.4	1	8
2014-03-26 06:43:39.393286	19955	49	2	8
2014-03-26 06:43:54.220639	19956	17.8	1	1
2014-03-26 06:43:54.443317	19957	45	2	1
2014-03-26 22:58:14.661285	32747	20.2	1	1
2014-03-26 22:58:14.885079	32748	50	2	1
2014-03-26 06:44:18.160292	19962	20.4	1	8
2014-03-26 06:44:18.403363	19963	49	2	8
2014-03-26 06:44:32.65966	19964	338	3	2
2014-03-26 06:44:33.220904	19965	17.8	1	1
2014-03-26 06:44:33.441512	19966	45	2	1
2014-03-26 22:58:20.551649	32749	338	3	2
2014-03-26 22:58:20.786313	32750	1088718.9648851412	4	2
2014-03-26 06:44:57.159205	19971	20.4	1	8
2014-03-26 06:44:57.381579	19972	49	2	8
2014-03-26 06:45:12.221984	19973	17.8	1	1
2014-03-26 06:45:12.454373	19974	45	2	1
2014-03-26 06:45:32.655863	19975	354	3	2
2014-03-26 22:58:27.72059	32751	24.1	1	10
2014-03-26 22:58:27.945471	32752	41	2	10
2014-03-26 06:45:36.161591	19980	20.4	1	8
2014-03-26 06:45:36.392259	19981	49	2	8
2014-03-26 06:45:51.222173	19982	17.8	1	1
2014-03-26 06:45:51.444604	19983	45	2	1
2014-03-26 22:58:32.55255	32753	338	3	2
2014-03-26 06:46:15.16115	19988	20.4	1	8
2014-03-26 06:46:15.394527	19989	49	2	8
2014-03-26 06:46:20.657726	19990	289	3	2
2014-03-26 06:46:30.224968	19991	17.8	1	1
2014-03-26 06:46:30.44731	19992	45	2	1
2014-03-26 06:37:07.289533	19860	20.8	1	10
2014-03-26 06:37:07.709753	19861	47	2	10
2014-03-26 06:37:46.154015	19870	20.8	1	10
2014-03-26 06:37:46.37548	19871	47	2	10
2014-03-26 06:38:25.154686	19878	20.7	1	10
2014-03-26 06:38:25.377232	19879	47	2	10
2014-03-26 06:39:04.155039	19887	20.7	1	10
2014-03-26 06:39:04.37639	19888	47	2	10
2014-03-26 06:39:43.155626	19896	20.7	1	10
2014-03-26 06:39:43.376595	19897	47	2	10
2014-03-26 06:40:22.155049	19904	20.7	1	10
2014-03-26 06:40:22.376644	19905	47	2	10
2014-03-26 06:41:01.154472	19913	20.7	1	10
2014-03-26 06:41:01.377362	19914	47	2	10
2014-03-26 06:41:40.158857	19922	20.7	1	10
2014-03-26 06:41:40.379239	19923	47	2	10
2014-03-26 06:42:19.157105	19930	20.7	1	10
2014-03-26 06:42:19.383912	19931	47	2	10
2014-03-26 06:42:58.155174	19939	20.7	1	10
2014-03-26 06:42:58.392428	19940	47	2	10
2014-03-26 06:43:37.164741	19950	20.7	1	10
2014-03-26 06:43:37.396127	19951	47	2	10
2014-03-26 06:44:16.157417	19958	20.7	1	10
2014-03-26 06:44:16.38954	19959	47	2	10
2014-03-26 06:44:55.155791	19967	20.7	1	10
2014-03-26 06:44:55.37889	19968	47	2	10
2014-03-26 06:45:34.157104	19976	20.7	1	10
2014-03-26 06:45:34.377951	19977	47	2	10
2014-03-26 06:46:32.654517	19993	289	3	2
2014-03-26 22:58:32.785738	32754	1088718.9648851412	4	2
2014-03-26 22:58:38.045283	32755	21.5	1	9
2014-03-26 06:46:54.162045	19998	20.4	1	8
2014-03-26 06:46:54.385385	19999	49	2	8
2014-03-26 06:47:09.255349	20000	17.8	1	1
2014-03-26 06:47:09.4889	20001	45	2	1
2014-03-26 22:58:38.274338	32756	47	2	9
2014-03-26 22:58:39.132915	32757	21.7	1	8
2014-03-26 06:47:32.669031	20006	289	3	2
2014-03-26 06:47:33.161882	20007	20.4	1	8
2014-03-26 06:47:33.384454	20008	49	2	8
2014-03-26 06:47:48.218425	20009	17.8	1	1
2014-03-26 06:47:48.443646	20010	45	2	1
2014-03-26 22:58:39.378592	32758	48	2	8
2014-03-26 22:58:53.664886	32759	20.2	1	1
2014-03-26 06:48:12.159886	20015	20.4	1	8
2014-03-26 06:48:12.383559	20016	49	2	8
2014-03-26 06:48:27.463215	20017	17.8	1	1
2014-03-26 06:48:27.68462	20018	45	2	1
2014-03-26 06:48:32.657435	20019	289	3	2
2014-03-26 22:58:53.891017	32760	50	2	1
2014-03-26 22:58:56.554452	32761	305	3	2
2014-03-26 06:48:51.159761	20024	20.3	1	8
2014-03-26 06:48:51.383312	20025	49	2	8
2014-03-26 06:49:06.218898	20026	17.8	1	1
2014-03-26 06:49:06.451872	20027	45	2	1
2014-03-26 22:58:56.789116	32762	1088721.262954584	4	2
2014-03-26 22:59:06.723068	32763	24.1	1	10
2014-03-26 06:49:30.161247	20032	20.3	1	8
2014-03-26 06:49:30.383113	20033	49	2	8
2014-03-26 06:49:32.659592	20034	289	3	2
2014-03-26 06:49:45.219643	20035	17.8	1	1
2014-03-26 06:49:45.44276	20036	45	2	1
2014-03-26 22:59:06.949089	32764	41	2	10
2014-03-26 22:59:08.551959	32765	338	3	2
2014-03-26 06:50:08.65402	20041	338	3	2
2014-03-26 06:50:09.190045	20042	20.3	1	8
2014-03-26 06:50:09.438834	20043	49	2	8
2014-03-26 06:50:20.654162	20044	338	3	2
2014-03-26 06:50:24.219444	20045	17.8	1	1
2014-03-26 06:50:24.450853	20046	45	2	1
2014-03-26 06:50:32.657117	20047	338	3	2
2014-03-26 22:59:08.785517	32766	1088722.4119893054	4	2
2014-03-26 22:59:17.045672	32767	21.5	1	9
2014-03-26 06:50:48.496086	20052	20.3	1	8
2014-03-26 06:50:48.737111	20053	49	2	8
2014-03-26 06:51:03.216031	20054	17.8	1	1
2014-03-26 06:51:03.439216	20055	45	2	1
2014-03-26 22:59:17.2712	32768	47	2	9
2014-03-26 22:59:18.133355	32769	21.7	1	8
2014-03-26 06:51:27.160207	20060	20.3	1	8
2014-03-26 06:51:27.391597	20061	49	2	8
2014-03-26 06:51:32.653043	20062	338	3	2
2014-03-26 06:51:42.217973	20063	17.8	1	1
2014-03-26 06:51:42.439617	20064	45	2	1
2014-03-26 22:59:18.368152	32770	48	2	8
2014-03-26 22:59:20.551635	32771	305	3	2
2014-03-26 06:52:06.162525	20069	20.3	1	8
2014-03-26 06:52:06.383823	20070	49	2	8
2014-03-26 06:52:21.220043	20071	17.8	1	1
2014-03-26 06:52:21.452535	20072	45	2	1
2014-03-26 06:52:32.65685	20073	338	3	2
2014-03-26 22:59:20.775806	32772	1088723.561024027	4	2
2014-03-26 22:59:32.899045	32773	20.2	1	1
2014-03-26 06:52:45.161659	20078	20.3	1	8
2014-03-26 06:52:45.384163	20079	49	2	8
2014-03-26 06:53:00.217632	20080	17.8	1	1
2014-03-26 06:53:00.441963	20081	45	2	1
2014-03-26 06:53:20.654537	20082	305	3	2
2014-03-26 22:59:33.134536	32774	50	2	1
2014-03-26 22:59:44.554043	32775	338	3	2
2014-03-26 06:53:24.161443	20087	20.3	1	8
2014-03-26 06:53:24.384914	20088	49	2	8
2014-03-26 06:53:32.652157	20089	338	3	2
2014-03-26 06:53:39.215942	20090	17.8	1	1
2014-03-26 06:53:39.439199	20091	45	2	1
2014-03-26 06:53:44.655807	20092	338	3	2
2014-03-26 22:59:44.779011	32776	1088725.8590934698	4	2
2014-03-26 22:59:45.721945	32777	24.1	1	10
2014-03-26 06:54:03.159563	20097	20.3	1	8
2014-03-26 06:54:03.380897	20098	49	2	8
2014-03-26 06:54:18.218082	20099	17.8	1	1
2014-03-26 06:54:18.44181	20100	45	2	1
2014-03-26 06:54:32.658611	20101	338	3	2
2014-03-26 22:59:45.955865	32778	41	2	10
2014-03-26 22:59:56.045153	32779	21.5	1	9
2014-03-26 06:54:42.215681	20106	20.3	1	8
2014-03-26 06:54:42.43775	20107	49	2	8
2014-03-26 06:54:57.216284	20108	17.8	1	1
2014-03-26 06:54:57.448007	20109	45	2	1
2014-03-26 22:59:56.270658	32780	48	2	9
2014-03-26 22:59:57.133347	32781	21.7	1	8
2014-03-26 06:55:21.160804	20114	20.3	1	8
2014-03-26 06:55:21.383199	20115	49	2	8
2014-03-26 06:55:32.652495	20116	338	3	2
2014-03-26 06:55:36.218893	20117	17.8	1	1
2014-03-26 06:55:36.440247	20118	45	2	1
2014-03-26 06:55:56.652151	20119	289	3	2
2014-03-26 22:59:57.367027	32782	48	2	8
2014-03-26 06:56:00.16027	20124	20.3	1	8
2014-03-26 06:56:00.394074	20125	49	2	8
2014-03-26 06:56:08.660269	20126	289	3	2
2014-03-26 06:56:15.216043	20127	17.8	1	1
2014-03-26 06:56:15.438259	20128	45	2	1
2014-03-26 06:46:52.159392	19994	20.7	1	10
2014-03-26 06:46:52.381322	19995	47	2	10
2014-03-26 06:47:31.160819	20002	20.7	1	10
2014-03-26 06:47:31.385437	20003	47	2	10
2014-03-26 06:48:10.1574	20011	20.7	1	10
2014-03-26 06:48:10.379882	20012	47	2	10
2014-03-26 06:48:49.157784	20020	20.7	1	10
2014-03-26 06:48:49.378759	20021	47	2	10
2014-03-26 06:49:28.159108	20028	20.7	1	10
2014-03-26 06:49:28.381162	20029	47	2	10
2014-03-26 06:50:07.158861	20037	20.7	1	10
2014-03-26 06:50:07.379791	20038	47	2	10
2014-03-26 06:50:46.159494	20048	20.7	1	10
2014-03-26 06:50:46.380586	20049	47	2	10
2014-03-26 06:51:25.159368	20056	20.7	1	10
2014-03-26 06:51:25.392301	20057	47	2	10
2014-03-26 06:52:04.16211	20065	20.7	1	10
2014-03-26 06:52:04.384744	20066	47	2	10
2014-03-26 06:52:43.159896	20074	20.7	1	10
2014-03-26 06:52:43.395174	20075	47	2	10
2014-03-26 06:53:22.16002	20083	20.7	1	10
2014-03-26 06:53:22.382699	20084	47	2	10
2014-03-26 06:54:01.159858	20093	20.6	1	10
2014-03-26 06:54:01.382583	20094	47	2	10
2014-03-26 06:54:40.160305	20102	20.7	1	10
2014-03-26 06:54:40.383233	20103	47	2	10
2014-03-26 06:55:19.160732	20110	20.7	1	10
2014-03-26 06:55:19.384813	20111	47	2	10
2014-03-26 06:56:32.652933	20129	289	3	2
2014-03-26 23:00:11.663701	32783	20.2	1	1
2014-03-26 23:00:11.890516	32784	50	2	1
2014-03-26 06:56:39.163473	20134	20.3	1	8
2014-03-26 06:56:39.385133	20135	49	2	8
2014-03-26 06:56:54.219041	20136	17.8	1	1
2014-03-26 06:56:54.453222	20137	45	2	1
2014-03-26 23:00:24.722484	32785	24.1	1	10
2014-03-26 23:00:24.956522	32786	41	2	10
2014-03-26 06:57:18.162972	20142	20.3	1	8
2014-03-26 06:57:18.38493	20143	49	2	8
2014-03-26 06:57:32.77997	20144	289	3	2
2014-03-26 06:57:33.410038	20145	17.8	1	1
2014-03-26 06:57:33.832523	20146	45	2	1
2014-03-26 23:00:32.552348	32787	338	3	2
2014-03-26 23:00:32.777382	32788	1088730.4552323555	4	2
2014-03-26 06:57:57.160401	20151	20.3	1	8
2014-03-26 06:57:57.39299	20152	49	2	8
2014-03-26 06:58:12.215059	20153	17.8	1	1
2014-03-26 06:58:12.441862	20154	45	2	1
2014-03-26 06:58:33.961907	20155	289	3	2
2014-03-26 23:00:35.044329	32789	21.5	1	9
2014-03-26 23:00:35.284515	32790	47	2	9
2014-03-26 06:58:36.160877	20160	20.3	1	8
2014-03-26 06:58:36.385286	20161	49	2	8
2014-03-26 06:58:51.215773	20162	17.8	1	1
2014-03-26 06:58:51.449231	20163	45	2	1
2014-03-26 23:00:36.13343	32791	21.7	1	8
2014-03-26 23:00:36.357678	32792	48	2	8
2014-03-26 06:59:15.503248	20168	20.3	1	8
2014-03-26 06:59:15.726357	20169	49	2	8
2014-03-26 06:59:30.215333	20170	17.8	1	1
2014-03-26 06:59:30.447267	20171	45	2	1
2014-03-26 06:59:32.656421	20172	289	3	2
2014-03-26 23:00:50.660784	32793	20.2	1	1
2014-03-26 23:00:50.899171	32794	50	2	1
2014-03-26 06:59:54.160818	20177	20.3	1	8
2014-03-26 06:59:54.383134	20178	49	2	8
2014-03-26 07:00:09.214084	20179	17.8	1	1
2014-03-26 07:00:09.467161	20180	45	2	1
2014-03-26 23:00:56.551515	32795	370	3	2
2014-03-26 23:00:56.778727	32796	1088732.7533017981	4	2
2014-03-26 07:00:32.653419	20185	289	3	2
2014-03-26 07:00:33.1606	20186	20.3	1	8
2014-03-26 07:00:33.383329	20187	49	2	8
2014-03-26 07:00:48.213841	20188	17.8	1	1
2014-03-26 07:00:48.457388	20189	45	2	1
2014-03-26 23:01:03.723552	32797	24.1	1	10
2014-03-26 23:01:03.957397	32798	41	2	10
2014-03-26 07:01:12.160282	20194	20.3	1	8
2014-03-26 07:01:12.380468	20195	49	2	8
2014-03-26 07:01:27.212305	20196	17.8	1	1
2014-03-26 07:01:27.433646	20197	45	2	1
2014-03-26 07:01:32.652291	20198	289	3	2
2014-03-26 23:01:08.5525	32799	370	3	2
2014-03-26 23:01:08.779238	32800	1088733.9023365197	4	2
2014-03-26 07:01:51.160514	20203	20.3	1	8
2014-03-26 07:01:51.381481	20204	49	2	8
2014-03-26 07:02:06.213409	20205	17.8	1	1
2014-03-26 07:02:06.445709	20206	45	2	1
2014-03-26 23:01:14.045311	32801	21.5	1	9
2014-03-26 23:01:14.281648	32802	48	2	9
2014-03-26 07:02:30.161856	20211	20.3	1	8
2014-03-26 07:02:30.383764	20212	49	2	8
2014-03-26 07:02:32.655426	20213	289	3	2
2014-03-26 07:02:45.212286	20214	17.8	1	1
2014-03-26 07:02:45.437154	20215	45	2	1
2014-03-26 23:01:15.133317	32803	21.7	1	8
2014-03-26 23:01:15.357988	32804	48	2	8
2014-03-26 07:03:08.654783	20220	338	3	2
2014-03-26 07:03:09.162628	20221	20.3	1	8
2014-03-26 07:03:09.384141	20222	49	2	8
2014-03-26 07:03:20.654777	20223	338	3	2
2014-03-26 07:03:24.213919	20224	17.8	1	1
2014-03-26 07:03:24.435465	20225	45	2	1
2014-03-26 07:03:32.652849	20226	338	3	2
2014-03-26 23:01:29.661831	32805	20.1	1	1
2014-03-26 23:01:29.910204	32806	50	2	1
2014-03-26 07:03:48.500252	20231	20.3	1	8
2014-03-26 07:03:48.724814	20232	49	2	8
2014-03-26 07:04:03.213402	20233	17.8	1	1
2014-03-26 07:04:03.460115	20234	45	2	1
2014-03-26 23:01:32.552724	32807	370	3	2
2014-03-26 23:01:32.777609	32808	1088736.2004059625	4	2
2014-03-26 07:04:27.160775	20239	20.3	1	8
2014-03-26 07:04:27.382406	20240	49	2	8
2014-03-26 07:04:32.653542	20241	338	3	2
2014-03-26 07:04:42.213119	20242	17.8	1	1
2014-03-26 07:04:42.472333	20243	45	2	1
2014-03-26 07:04:56.648056	20244	450	3	2
2014-03-26 23:01:42.722269	32809	24.1	1	10
2014-03-26 23:01:42.959041	32810	41	2	10
2014-03-26 07:05:06.159206	20249	20.3	1	8
2014-03-26 07:05:06.391844	20250	49	2	8
2014-03-26 07:05:08.657491	20251	515	3	2
2014-03-26 07:05:20.655421	20252	515	3	2
2014-03-26 07:05:21.21192	20253	17.8	1	1
2014-03-26 07:05:21.444292	20254	45	2	1
2014-03-26 07:05:32.655634	20255	515	3	2
2014-03-26 23:01:53.044509	32811	21.5	1	9
2014-03-26 23:01:53.267535	32812	48	2	9
2014-03-26 07:05:45.162943	20260	20.3	1	8
2014-03-26 07:05:45.3855	20261	49	2	8
2014-03-26 07:06:00.211397	20262	17.8	1	1
2014-03-26 07:06:00.434594	20263	45	2	1
2014-03-26 06:56:37.160428	20130	20.6	1	10
2014-03-26 06:56:37.383196	20131	47	2	10
2014-03-26 06:57:16.162535	20138	20.6	1	10
2014-03-26 06:57:16.385361	20139	47	2	10
2014-03-26 06:57:55.161393	20147	20.6	1	10
2014-03-26 06:57:55.386411	20148	47	2	10
2014-03-26 06:58:34.278963	20156	20.6	1	10
2014-03-26 06:58:34.504052	20157	47	2	10
2014-03-26 06:59:13.161251	20164	20.6	1	10
2014-03-26 06:59:13.384141	20165	47	2	10
2014-03-26 06:59:52.162398	20173	20.6	1	10
2014-03-26 06:59:52.386314	20174	47	2	10
2014-03-26 07:00:31.162726	20181	20.6	1	10
2014-03-26 07:00:31.394003	20182	47	2	10
2014-03-26 07:01:10.161572	20190	20.6	1	10
2014-03-26 07:01:10.383382	20191	47	2	10
2014-03-26 07:01:49.161496	20199	20.6	1	10
2014-03-26 07:01:49.393456	20200	47	2	10
2014-03-26 07:02:28.163913	20207	20.6	1	10
2014-03-26 07:02:28.385933	20208	47	2	10
2014-03-26 07:03:07.16647	20216	20.6	1	10
2014-03-26 07:03:07.399148	20217	47	2	10
2014-03-26 07:03:46.166893	20227	20.6	1	10
2014-03-26 07:03:46.394075	20228	47	2	10
2014-03-26 07:04:25.163083	20235	20.6	1	10
2014-03-26 07:04:25.386806	20236	47	2	10
2014-03-26 07:05:04.16389	20245	20.6	1	10
2014-03-26 07:05:04.396181	20246	47	2	10
2014-03-26 23:01:54.132691	32813	21.7	1	8
2014-03-26 23:01:54.365621	32814	48	2	8
2014-03-26 07:06:24.160453	20268	20.4	1	8
2014-03-26 07:06:24.390954	20269	49	2	8
2014-03-26 07:06:32.654422	20270	498	3	2
2014-03-26 07:06:39.210566	20271	17.8	1	1
2014-03-26 07:06:39.433535	20272	45	2	1
2014-03-26 23:02:08.662364	32815	20.1	1	1
2014-03-26 23:02:08.887419	32816	50	2	1
2014-03-26 07:07:03.159194	20275	20.4	1	8
2014-03-26 07:07:03.384043	20276	50	2	8
2014-03-26 07:07:18.211823	20277	17.8	1	1
2014-03-26 07:07:18.434696	20278	45	2	1
2014-03-26 07:07:32.658016	20279	498	3	2
2014-03-26 23:02:21.722861	32817	24.1	1	10
2014-03-26 23:02:21.95801	32818	41	2	10
2014-03-26 07:07:42.311154	20284	20.4	1	8
2014-03-26 07:07:42.787878	20285	50	2	8
2014-03-26 07:07:57.208759	20286	17.8	1	1
2014-03-26 07:07:57.440504	20287	45	2	1
2014-03-26 23:02:32.04376	32819	21.5	1	9
2014-03-26 23:02:32.267571	32820	48	2	9
2014-03-26 07:08:21.161617	20292	20.5	1	8
2014-03-26 07:08:21.383696	20293	51	2	8
2014-03-26 07:08:32.656043	20294	515	3	2
2014-03-26 07:08:36.210894	20295	17.8	1	1
2014-03-26 07:08:36.434603	20296	45	2	1
2014-03-26 07:08:44.650766	20297	466	3	2
2014-03-26 07:08:56.652967	20298	466	3	2
2014-03-26 23:02:32.573833	32821	370	3	2
2014-03-26 23:02:32.80945	32822	1088743.0946142909	4	2
2014-03-26 07:09:00.160733	20303	20.6	1	8
2014-03-26 07:09:00.384345	20304	52	2	8
2014-03-26 07:09:15.210469	20305	17.8	1	1
2014-03-26 07:09:15.445525	20306	45	2	1
2014-03-26 07:09:32.651959	20307	450	3	2
2014-03-26 23:02:33.133364	32823	21.7	1	8
2014-03-26 23:02:33.357073	32824	48	2	8
2014-03-26 07:09:39.159949	20312	20.7	1	8
2014-03-26 07:09:39.383029	20313	54	2	8
2014-03-26 07:09:54.20714	20314	17.8	1	1
2014-03-26 07:09:54.431657	20315	45	2	1
2014-03-26 23:02:47.673976	32825	20.1	1	1
2014-03-26 23:02:47.908613	32826	50	2	1
2014-03-26 07:10:18.160787	20320	20.8	1	8
2014-03-26 07:10:18.39034	20321	54	2	8
2014-03-26 07:10:32.652829	20322	450	3	2
2014-03-26 07:10:33.209483	20323	17.8	1	1
2014-03-26 07:10:33.430585	20324	45	2	1
2014-03-26 23:03:00.72322	32827	24.1	1	10
2014-03-26 23:03:00.948464	32828	41	2	10
2014-03-26 07:10:57.160347	20329	20.9	1	8
2014-03-26 07:10:57.381576	20330	55	2	8
2014-03-26 07:11:12.209377	20331	17.8	1	1
2014-03-26 07:11:12.431895	20332	45	2	1
2014-03-26 07:11:32.652686	20333	450	3	2
2014-03-26 23:03:11.046249	32829	21.5	1	9
2014-03-26 23:03:11.280311	32830	47	2	9
2014-03-26 07:11:36.160035	20338	20.9	1	8
2014-03-26 07:11:36.383421	20339	56	2	8
2014-03-26 07:11:51.209708	20340	17.8	1	1
2014-03-26 07:11:51.443086	20341	45	2	1
2014-03-26 23:03:12.135198	32831	21.7	1	8
2014-03-26 23:03:12.358913	32832	48	2	8
2014-03-26 07:12:15.158454	20346	21.0	1	8
2014-03-26 07:12:15.381451	20347	56	2	8
2014-03-26 07:12:30.205685	20348	17.8	1	1
2014-03-26 07:12:30.437916	20349	45	2	1
2014-03-26 07:12:32.650146	20350	466	3	2
2014-03-26 23:03:20.553919	32833	402	3	2
2014-03-26 23:03:20.787794	32834	1088747.6907531766	4	2
2014-03-26 07:12:54.160014	20355	21.1	1	8
2014-03-26 07:12:54.39183	20356	57	2	8
2014-03-26 07:13:09.205884	20357	17.8	1	1
2014-03-26 07:13:09.429164	20358	45	2	1
2014-03-26 23:03:26.655476	32835	20.1	1	1
2014-03-26 23:03:26.879164	32836	50	2	1
2014-03-26 07:13:32.654627	20363	450	3	2
2014-03-26 07:13:33.161591	20364	21.2	1	8
2014-03-26 07:13:33.383678	20365	58	2	8
2014-03-26 07:13:48.20783	20366	17.8	1	1
2014-03-26 07:13:48.432257	20367	45	2	1
2014-03-26 23:03:32.553284	32837	370	3	2
2014-03-26 23:03:32.787945	32838	1088748.8397878981	4	2
2014-03-26 07:14:12.159174	20372	21.3	1	8
2014-03-26 07:14:12.382207	20373	59	2	8
2014-03-26 07:14:27.208183	20374	17.8	1	1
2014-03-26 07:14:27.46298	20375	45	2	1
2014-03-26 07:14:32.650583	20376	450	3	2
2014-03-26 23:03:39.723632	32839	24.1	1	10
2014-03-26 23:03:39.947628	32840	41	2	10
2014-03-26 07:14:51.160727	20381	21.3	1	8
2014-03-26 07:14:51.384363	20382	59	2	8
2014-03-26 07:15:06.205252	20383	17.8	1	1
2014-03-26 07:15:06.432271	20384	45	2	1
2014-03-26 23:03:44.552946	32841	370	3	2
2014-03-26 07:15:30.160241	20389	21.4	1	8
2014-03-26 07:15:30.382112	20390	60	2	8
2014-03-26 07:15:32.650809	20391	434	3	2
2014-03-26 07:15:44.65206	20392	466	3	2
2014-03-26 07:15:45.203096	20393	17.7	1	1
2014-03-26 07:15:45.435081	20394	45	2	1
2014-03-26 07:15:56.654772	20395	450	3	2
2014-03-26 07:16:09.159679	20400	21.5	1	8
2014-03-26 07:06:22.385566	20265	47	2	10
2014-03-26 07:07:40.288928	20280	20.6	1	10
2014-03-26 07:07:40.712644	20281	47	2	10
2014-03-26 07:08:19.165357	20288	20.6	1	10
2014-03-26 07:08:19.387584	20289	47	2	10
2014-03-26 07:08:58.166803	20299	20.6	1	10
2014-03-26 07:08:58.390708	20300	47	2	10
2014-03-26 07:09:37.165211	20308	20.6	1	10
2014-03-26 07:09:37.39042	20309	47	2	10
2014-03-26 07:10:16.166495	20316	20.6	1	10
2014-03-26 07:10:16.397044	20317	47	2	10
2014-03-26 07:10:55.16645	20325	20.6	1	10
2014-03-26 07:10:55.388716	20326	47	2	10
2014-03-26 07:11:34.165602	20334	20.6	1	10
2014-03-26 07:11:34.388323	20335	47	2	10
2014-03-26 07:12:13.16568	20342	20.6	1	10
2014-03-26 07:12:13.38809	20343	47	2	10
2014-03-26 07:12:52.168059	20351	20.6	1	10
2014-03-26 07:12:52.392557	20352	47	2	10
2014-03-26 07:13:31.168652	20359	20.6	1	10
2014-03-26 07:13:31.400989	20360	47	2	10
2014-03-26 07:14:10.166447	20368	20.5	1	10
2014-03-26 07:14:10.390885	20369	47	2	10
2014-03-26 07:14:49.167951	20377	20.5	1	10
2014-03-26 07:14:49.3926	20378	47	2	10
2014-03-26 07:15:28.168561	20385	20.5	1	10
2014-03-26 07:15:28.391009	20386	47	2	10
2014-03-26 07:16:07.168087	20396	20.5	1	10
2014-03-26 07:16:07.390162	20397	47	2	10
2014-03-26 07:16:09.381598	20401	60	2	8
2014-03-26 07:16:24.205801	20402	17.7	1	1
2014-03-26 07:16:24.428968	20403	45	2	1
2014-03-26 07:16:32.65578	20404	466	3	2
2014-03-26 23:03:44.786603	32842	1088749.9888226194	4	2
2014-03-26 23:03:50.045266	32843	21.5	1	9
2014-03-26 07:16:48.159368	20409	21.6	1	8
2014-03-26 07:16:48.38198	20410	61	2	8
2014-03-26 07:17:03.202326	20411	17.7	1	1
2014-03-26 07:17:03.434072	20412	45	2	1
2014-03-26 23:03:50.27541	32844	47	2	9
2014-03-26 23:03:51.133286	32845	21.7	1	8
2014-03-26 07:17:27.159774	20417	21.6	1	8
2014-03-26 07:17:27.401307	20418	61	2	8
2014-03-26 07:17:32.64861	20419	466	3	2
2014-03-26 07:17:42.206572	20420	17.7	1	1
2014-03-26 07:17:42.429861	20421	45	2	1
2014-03-26 23:03:51.368135	32846	48	2	8
2014-03-26 23:04:05.661267	32847	20.1	1	1
2014-03-26 07:18:06.339862	20426	21.7	1	8
2014-03-26 07:18:06.7599	20427	60	2	8
2014-03-26 07:18:21.205531	20428	17.7	1	1
2014-03-26 07:18:21.429674	20429	45	2	1
2014-03-26 07:18:32.653417	20430	466	3	2
2014-03-26 23:04:05.885991	32848	50	2	1
2014-03-26 23:04:18.723134	32849	24.0	1	10
2014-03-26 07:18:45.160913	20435	21.7	1	8
2014-03-26 07:18:45.383973	20436	60	2	8
2014-03-26 07:19:00.205171	20437	17.7	1	1
2014-03-26 07:19:00.440241	20438	45	2	1
2014-03-26 23:04:18.957651	32850	41	2	10
2014-03-26 23:04:29.045482	32851	21.4	1	9
2014-03-26 07:19:24.160377	20443	21.7	1	8
2014-03-26 07:19:24.383564	20444	59	2	8
2014-03-26 07:19:32.652852	20445	466	3	2
2014-03-26 07:19:39.203899	20446	17.7	1	1
2014-03-26 07:19:39.427663	20447	45	2	1
2014-03-26 23:04:29.27012	32852	47	2	9
2014-03-26 23:04:30.133488	32853	21.7	1	8
2014-03-26 07:20:03.159367	20452	21.6	1	8
2014-03-26 07:20:03.391608	20453	59	2	8
2014-03-26 07:20:18.205446	20454	17.7	1	1
2014-03-26 07:20:18.428309	20455	45	2	1
2014-03-26 07:20:32.652585	20456	466	3	2
2014-03-26 23:04:30.45558	32854	48	2	8
2014-03-26 23:04:32.550132	32855	370	3	2
2014-03-26 07:20:42.159295	20461	21.6	1	8
2014-03-26 07:20:42.381742	20462	59	2	8
2014-03-26 07:20:57.20417	20463	17.7	1	1
2014-03-26 07:20:57.435309	20464	45	2	1
2014-03-26 07:21:08.654064	20465	418	3	2
2014-03-26 23:04:32.775469	32856	1088755.7339962265	4	2
2014-03-26 23:04:44.656002	32857	20.1	1	1
2014-03-26 07:21:20.655979	20470	418	3	2
2014-03-26 07:21:21.159461	20471	21.6	1	8
2014-03-26 07:21:21.379937	20472	59	2	8
2014-03-26 07:21:32.653364	20473	434	3	2
2014-03-26 07:21:36.20022	20474	17.7	1	1
2014-03-26 07:21:36.430847	20475	45	2	1
2014-03-26 23:04:44.889481	32858	50	2	1
2014-03-26 23:04:57.723589	32859	24.0	1	10
2014-03-26 07:22:00.159218	20480	21.5	1	8
2014-03-26 07:22:00.381536	20481	58	2	8
2014-03-26 07:22:08.643177	20482	402	3	2
2014-03-26 07:22:15.202584	20483	17.7	1	1
2014-03-26 07:22:15.425935	20484	45	2	1
2014-03-26 07:22:20.650097	20485	402	3	2
2014-03-26 07:22:32.65503	20486	466	3	2
2014-03-26 23:04:57.947657	32860	41	2	10
2014-03-26 23:05:08.047056	32861	21.4	1	9
2014-03-26 07:22:39.159498	20491	21.5	1	8
2014-03-26 07:22:39.380107	20492	58	2	8
2014-03-26 07:22:44.655745	20493	466	3	2
2014-03-26 07:22:54.198021	20494	17.7	1	1
2014-03-26 07:22:54.421305	20495	45	2	1
2014-03-26 23:05:08.28108	32862	47	2	9
2014-03-26 23:05:09.133731	32863	21.7	1	8
2014-03-26 07:23:18.159188	20500	21.5	1	8
2014-03-26 07:23:18.391344	20501	58	2	8
2014-03-26 07:23:32.653232	20502	466	3	2
2014-03-26 07:23:33.201396	20503	17.7	1	1
2014-03-26 07:23:33.424646	20504	45	2	1
2014-03-26 23:05:09.359318	32864	48	2	8
2014-03-26 23:05:23.66096	32865	20.1	1	1
2014-03-26 07:23:56.649358	20509	418	3	2
2014-03-26 07:23:57.160813	20510	21.5	1	8
2014-03-26 07:23:57.382182	20511	58	2	8
2014-03-26 07:24:08.652564	20512	418	3	2
2014-03-26 07:24:12.201809	20513	17.7	1	1
2014-03-26 07:24:12.42501	20514	45	2	1
2014-03-26 07:24:32.649424	20515	418	3	2
2014-03-26 23:05:23.895269	32866	50	2	1
2014-03-26 23:05:32.555337	32867	370	3	2
2014-03-26 07:24:36.16264	20520	21.4	1	8
2014-03-26 07:24:36.384785	20521	58	2	8
2014-03-26 07:24:51.20338	20522	17.7	1	1
2014-03-26 07:24:51.436454	20523	45	2	1
2014-03-26 23:05:32.780718	32868	1088761.4791698337	4	2
2014-03-26 23:05:36.722983	32869	24.0	1	10
2014-03-26 07:25:15.159833	20528	21.4	1	8
2014-03-26 07:25:15.389556	20529	58	2	8
2014-03-26 07:25:30.203273	20530	17.7	1	1
2014-03-26 07:25:30.437547	20531	45	2	1
2014-03-26 07:25:32.650248	20532	418	3	2
2014-03-26 23:05:36.956905	32870	41	2	10
2014-03-26 07:16:46.167209	20405	20.5	1	10
2014-03-26 07:16:46.390809	20406	47	2	10
2014-03-26 07:17:25.168518	20413	20.5	1	10
2014-03-26 07:17:25.391966	20414	47	2	10
2014-03-26 07:18:04.300051	20422	20.5	1	10
2014-03-26 07:18:04.722743	20423	47	2	10
2014-03-26 07:18:43.17078	20431	20.5	1	10
2014-03-26 07:18:43.395684	20432	47	2	10
2014-03-26 07:19:22.16902	20439	20.5	1	10
2014-03-26 07:19:22.393885	20440	47	2	10
2014-03-26 07:20:01.168862	20448	20.5	1	10
2014-03-26 07:20:01.392719	20449	47	2	10
2014-03-26 07:20:40.170228	20457	20.5	1	10
2014-03-26 07:20:40.392438	20458	47	2	10
2014-03-26 07:21:19.169692	20466	20.5	1	10
2014-03-26 07:21:19.40076	20467	47	2	10
2014-03-26 07:21:58.17009	20476	20.5	1	10
2014-03-26 07:21:58.392235	20477	47	2	10
2014-03-26 07:22:37.17806	20487	20.5	1	10
2014-03-26 07:22:37.402899	20488	47	2	10
2014-03-26 07:23:16.171965	20496	20.5	1	10
2014-03-26 07:23:16.405739	20497	47	2	10
2014-03-26 07:23:55.170191	20505	20.5	1	10
2014-03-26 07:23:55.395594	20506	47	2	10
2014-03-26 07:24:34.172392	20516	20.5	1	10
2014-03-26 07:24:34.395599	20517	47	2	10
2014-03-26 07:25:13.172008	20524	20.5	1	10
2014-03-26 07:25:13.396003	20525	47	2	10
2014-03-26 07:25:54.160462	20537	21.4	1	8
2014-03-26 07:25:54.393354	20538	57	2	8
2014-03-26 07:26:09.199482	20539	17.7	1	1
2014-03-26 07:26:09.422003	20540	45	2	1
2014-03-26 23:05:47.04493	32871	21.4	1	9
2014-03-26 23:05:47.270985	32872	47	2	9
2014-03-26 07:26:33.024983	20545	450	3	2
2014-03-26 07:26:33.397766	20546	21.4	1	8
2014-03-26 07:26:33.654298	20547	57	2	8
2014-03-26 07:26:44.654167	20548	434	3	2
2014-03-26 07:26:48.196337	20549	17.7	1	1
2014-03-26 07:26:48.552841	20550	45	2	1
2014-03-26 23:05:48.133003	32873	21.7	1	8
2014-03-26 23:05:48.366399	32874	48	2	8
2014-03-26 07:27:12.162024	20555	21.4	1	8
2014-03-26 07:27:12.433898	20556	57	2	8
2014-03-26 07:27:27.437727	20557	17.7	1	1
2014-03-26 07:27:27.659653	20558	45	2	1
2014-03-26 23:05:56.556962	32875	305	3	2
2014-03-26 23:05:56.782952	32876	1088763.7772392763	4	2
2014-03-26 07:27:51.162879	20563	21.3	1	8
2014-03-26 07:27:51.397092	20564	56	2	8
2014-03-26 07:27:56.645243	20565	482	3	2
2014-03-26 07:28:06.196003	20566	17.7	1	1
2014-03-26 07:28:06.417951	20567	45	2	1
2014-03-26 23:06:02.657996	32877	20.1	1	1
2014-03-26 23:06:02.893814	32878	50	2	1
2014-03-26 07:28:30.289146	20572	21.3	1	8
2014-03-26 07:28:30.725747	20573	56	2	8
2014-03-26 07:28:32.780016	20574	482	3	2
2014-03-26 07:28:45.339132	20575	17.7	1	1
2014-03-26 07:28:45.770368	20576	45	2	1
2014-03-26 07:28:56.657118	20577	370	3	2
2014-03-26 23:06:08.551188	32879	338	3	2
2014-03-26 23:06:08.778882	32880	1088764.9262739979	4	2
2014-03-26 07:29:08.651281	20582	402	3	2
2014-03-26 07:29:09.160081	20583	21.3	1	8
2014-03-26 07:29:09.382618	20584	56	2	8
2014-03-26 07:29:20.653217	20585	402	3	2
2014-03-26 07:29:24.200013	20586	17.7	1	1
2014-03-26 07:29:24.430421	20587	45	2	1
2014-03-26 07:29:44.653456	20588	370	3	2
2014-03-26 23:06:15.726125	32881	24.0	1	10
2014-03-26 23:06:15.960791	32882	41	2	10
2014-03-26 07:29:48.162557	20593	21.3	1	8
2014-03-26 07:29:48.391461	20594	56	2	8
2014-03-26 07:29:56.649873	20595	466	3	2
2014-03-26 07:30:03.201558	20596	17.7	1	1
2014-03-26 07:30:03.424278	20597	45	2	1
2014-03-26 07:30:08.651915	20598	450	3	2
2014-03-26 23:06:20.550683	32883	338	3	2
2014-03-26 23:06:20.778198	32884	1088766.0753087192	4	2
2014-03-26 07:30:27.160307	20603	21.3	1	8
2014-03-26 07:30:27.383806	20604	55	2	8
2014-03-26 07:30:32.653529	20605	466	3	2
2014-03-26 07:30:42.199212	20606	17.7	1	1
2014-03-26 07:30:42.4255	20607	45	2	1
2014-03-26 23:06:26.045093	32885	21.4	1	9
2014-03-26 23:06:26.283759	32886	47	2	9
2014-03-26 07:31:06.16053	20612	21.3	1	8
2014-03-26 07:31:06.395415	20613	55	2	8
2014-03-26 07:31:21.199133	20614	17.7	1	1
2014-03-26 07:31:21.425225	20615	45	2	1
2014-03-26 07:31:32.653684	20616	1062	3	2
2014-03-26 23:06:27.132881	32887	21.7	1	8
2014-03-26 23:06:27.356986	32888	48	2	8
2014-03-26 07:31:44.653493	20621	853	3	2
2014-03-26 07:31:45.159196	20622	21.2	1	8
2014-03-26 07:31:45.38162	20623	55	2	8
2014-03-26 07:31:56.655075	20624	482	3	2
2014-03-26 07:32:00.198101	20625	17.7	1	1
2014-03-26 07:32:00.41938	20626	45	2	1
2014-03-26 07:32:08.656331	20627	482	3	2
2014-03-26 07:32:20.652904	20628	515	3	2
2014-03-26 23:06:32.553973	32889	338	3	2
2014-03-26 23:06:32.791334	32890	1088767.2243434407	4	2
2014-03-26 07:32:24.160278	20633	21.2	1	8
2014-03-26 07:32:24.404665	20634	55	2	8
2014-03-26 07:32:32.651792	20635	450	3	2
2014-03-26 07:32:39.194884	20636	17.7	1	1
2014-03-26 07:32:39.41911	20637	45	2	1
2014-03-26 07:32:44.651806	20638	466	3	2
2014-03-26 07:32:56.649106	20639	418	3	2
2014-03-26 23:06:41.657273	32891	20.1	1	1
2014-03-26 23:06:41.884673	32892	50	2	1
2014-03-26 07:33:03.160129	20644	21.2	1	8
2014-03-26 07:33:03.3914	20645	55	2	8
2014-03-26 07:33:08.658199	20646	418	3	2
2014-03-26 07:33:18.2434	20647	17.7	1	1
2014-03-26 07:33:18.466456	20648	45	2	1
2014-03-26 07:33:39.973383	20649	418	3	2
2014-03-26 23:06:54.727088	32893	24.0	1	10
2014-03-26 23:06:54.960363	32894	41	2	10
2014-03-26 07:33:42.160324	20654	21.2	1	8
2014-03-26 07:33:42.38131	20655	55	2	8
2014-03-26 07:33:56.653633	20656	466	3	2
2014-03-26 07:33:57.192618	20657	17.7	1	1
2014-03-26 07:33:57.414154	20658	45	2	1
2014-03-26 07:34:08.653778	20659	450	3	2
2014-03-26 23:07:05.047072	32895	21.4	1	9
2014-03-26 23:07:05.271172	32896	47	2	9
2014-03-26 23:07:06.133892	32897	21.7	1	8
2014-03-26 07:34:20.654199	20664	498	3	2
2014-03-26 07:34:21.158998	20665	21.2	1	8
2014-03-26 07:34:21.379562	20666	55	2	8
2014-03-26 07:34:32.652448	20667	498	3	2
2014-03-26 07:34:36.195009	20668	17.7	1	1
2014-03-26 07:34:36.427849	20669	45	2	1
2014-03-26 07:34:56.655978	20670	627	3	2
2014-03-26 07:26:31.172577	20541	20.5	1	10
2014-03-26 07:26:31.443562	20542	47	2	10
2014-03-26 07:27:10.170508	20551	20.5	1	10
2014-03-26 07:27:10.663537	20552	47	2	10
2014-03-26 07:27:49.172045	20559	20.5	1	10
2014-03-26 07:27:49.406513	20560	47	2	10
2014-03-26 07:28:28.171961	20568	20.5	1	10
2014-03-26 07:28:28.394757	20569	47	2	10
2014-03-26 07:29:07.172298	20578	20.5	1	10
2014-03-26 07:29:07.395442	20579	47	2	10
2014-03-26 07:29:46.174053	20589	20.5	1	10
2014-03-26 07:29:46.395408	20590	47	2	10
2014-03-26 07:30:25.172429	20599	20.5	1	10
2014-03-26 07:30:25.397348	20600	47	2	10
2014-03-26 07:31:04.173066	20608	20.5	1	10
2014-03-26 07:31:04.406216	20609	47	2	10
2014-03-26 07:31:43.172914	20617	20.5	1	10
2014-03-26 07:31:43.434387	20618	47	2	10
2014-03-26 07:32:22.174893	20629	20.5	1	10
2014-03-26 07:32:22.405237	20630	47	2	10
2014-03-26 07:33:01.172441	20640	20.5	1	10
2014-03-26 07:33:01.40569	20641	47	2	10
2014-03-26 07:33:40.280739	20650	20.5	1	10
2014-03-26 07:33:40.502889	20651	47	2	10
2014-03-26 23:07:06.368004	32898	48	2	8
2014-03-26 23:07:20.65491	32899	20.1	1	1
2014-03-26 07:35:00.161363	20675	21.2	1	8
2014-03-26 07:35:00.392498	20676	55	2	8
2014-03-26 07:35:08.65306	20677	2398	3	2
2014-03-26 07:35:15.19702	20678	17.8	1	1
2014-03-26 07:35:15.420734	20679	45	2	1
2014-03-26 07:35:20.653303	20680	2398	3	2
2014-03-26 07:35:32.64941	20681	2398	3	2
2014-03-26 23:07:20.883756	32900	50	2	1
2014-03-26 23:07:32.552422	32901	338	3	2
2014-03-26 07:35:39.159418	20686	21.2	1	8
2014-03-26 07:35:39.394893	20687	55	2	8
2014-03-26 07:35:54.200609	20688	17.8	1	1
2014-03-26 07:35:54.425862	20689	45	2	1
2014-03-26 23:07:32.797778	32902	1088772.9695170477	4	2
2014-03-26 23:07:33.722769	32903	24.0	1	10
2014-03-26 07:36:18.160238	20694	21.2	1	8
2014-03-26 07:36:18.394128	20695	54	2	8
2014-03-26 07:36:32.654745	20696	2527	3	2
2014-03-26 07:36:33.193961	20697	17.8	1	1
2014-03-26 07:36:33.418021	20698	46	2	1
2014-03-26 07:36:44.658002	20699	2704	3	2
2014-03-26 23:07:33.947056	32904	41	2	10
2014-03-26 23:07:44.044852	32905	21.4	1	9
2014-03-26 07:36:56.649176	20704	4925	3	2
2014-03-26 07:36:57.159635	20705	21.2	1	8
2014-03-26 07:36:57.382001	20706	54	2	8
2014-03-26 07:37:08.655167	20707	6116	3	2
2014-03-26 07:37:12.194999	20708	17.9	1	1
2014-03-26 07:37:12.417765	20709	46	2	1
2014-03-26 07:37:20.652784	20710	6116	3	2
2014-03-26 07:37:32.652697	20711	6020	3	2
2014-03-26 23:07:44.279916	32906	47	2	9
2014-03-26 23:07:45.13342	32907	21.7	1	8
2014-03-26 07:37:36.160307	20716	21.1	1	8
2014-03-26 07:37:36.382505	20717	54	2	8
2014-03-26 07:37:44.653068	20718	6116	3	2
2014-03-26 07:37:51.195788	20719	17.9	1	1
2014-03-26 07:37:51.417355	20720	46	2	1
2014-03-26 07:37:56.654683	20721	6261	3	2
2014-03-26 07:38:08.780009	20722	4973	3	2
2014-03-26 23:07:45.356684	32908	48	2	8
2014-03-26 23:07:59.654943	32909	20.1	1	1
2014-03-26 07:38:15.349993	20727	21.1	1	8
2014-03-26 07:38:15.77105	20728	54	2	8
2014-03-26 07:38:20.779122	20729	4973	3	2
2014-03-26 07:38:30.191535	20730	18.0	1	1
2014-03-26 07:38:30.41409	20731	46	2	1
2014-03-26 07:38:32.650827	20732	6100	3	2
2014-03-26 07:38:44.655487	20733	6100	3	2
2014-03-26 23:07:59.890864	32910	50	2	1
2014-03-26 23:08:12.724048	32911	23.9	1	10
2014-03-26 07:38:54.159185	20738	21.1	1	8
2014-03-26 07:38:54.381093	20739	54	2	8
2014-03-26 07:38:56.648687	20740	4957	3	2
2014-03-26 07:39:08.654976	20741	4957	3	2
2014-03-26 07:39:09.193465	20742	18.0	1	1
2014-03-26 07:39:09.426738	20743	46	2	1
2014-03-26 23:08:12.947886	32912	42	2	10
2014-03-26 23:08:23.04607	32913	21.4	1	9
2014-03-26 07:39:32.654149	20748	5070	3	2
2014-03-26 07:39:33.380072	20749	21.1	1	8
2014-03-26 07:39:33.601697	20750	54	2	8
2014-03-26 07:39:44.654115	20751	6213	3	2
2014-03-26 07:39:48.192699	20752	18.1	1	1
2014-03-26 07:39:48.414733	20753	47	2	1
2014-03-26 07:39:56.654088	20754	5070	3	2
2014-03-26 07:40:08.650649	20755	804	3	2
2014-03-26 23:08:23.280369	32914	47	2	9
2014-03-26 23:08:24.133663	32915	21.7	1	8
2014-03-26 07:40:12.161975	20760	21.1	1	8
2014-03-26 07:40:12.384334	20761	54	2	8
2014-03-26 07:40:20.651988	20762	820	3	2
2014-03-26 07:40:27.194434	20763	18.1	1	1
2014-03-26 07:40:27.41639	20764	47	2	1
2014-03-26 07:40:32.649093	20765	804	3	2
2014-03-26 23:08:24.358179	32916	48	2	8
2014-03-26 23:08:32.552447	32917	338	3	2
2014-03-26 07:40:51.159015	20770	21.1	1	8
2014-03-26 07:40:51.383616	20771	54	2	8
2014-03-26 07:41:06.190351	20772	18.2	1	1
2014-03-26 07:41:06.424151	20773	47	2	1
2014-03-26 07:41:08.651852	20774	2060	3	2
2014-03-26 23:08:32.787078	32918	1088778.7146906548	4	2
2014-03-26 23:08:38.654913	32919	20.1	1	1
2014-03-26 07:41:30.15901	20779	21.1	1	8
2014-03-26 07:41:30.383367	20780	53	2	8
2014-03-26 07:41:45.231946	20781	18.2	1	1
2014-03-26 07:41:45.456799	20782	47	2	1
2014-03-26 23:08:38.880093	32920	50	2	1
2014-03-26 23:08:51.72544	32921	23.9	1	10
2014-03-26 07:42:09.159051	20787	21.1	1	8
2014-03-26 07:42:09.390594	20788	53	2	8
2014-03-26 07:42:20.651425	20789	1078	3	2
2014-03-26 07:42:24.196637	20790	18.3	1	1
2014-03-26 07:42:24.419435	20791	47	2	1
2014-03-26 07:42:32.651505	20792	1062	3	2
2014-03-26 07:42:44.657607	20793	2012	3	2
2014-03-26 23:08:51.962122	32922	42	2	10
2014-03-26 07:42:48.158699	20798	21.1	1	8
2014-03-26 07:42:48.392971	20799	53	2	8
2014-03-26 07:42:56.652569	20800	4507	3	2
2014-03-26 07:43:03.190609	20801	18.3	1	1
2014-03-26 07:43:03.414071	20802	48	2	1
2014-03-26 07:43:08.654193	20803	3283	3	2
2014-03-26 07:43:20.652499	20804	3541	3	2
2014-03-26 07:35:37.174337	20682	20.4	1	10
2014-03-26 07:35:37.408243	20683	47	2	10
2014-03-26 07:36:16.173983	20690	20.4	1	10
2014-03-26 07:36:16.408001	20691	46	2	10
2014-03-26 07:36:55.17319	20700	20.4	1	10
2014-03-26 07:36:55.39688	20701	46	2	10
2014-03-26 07:37:34.175396	20712	20.3	1	10
2014-03-26 07:37:34.396841	20713	46	2	10
2014-03-26 07:38:13.310068	20723	20.3	1	10
2014-03-26 07:38:13.729979	20724	46	2	10
2014-03-26 07:38:52.175776	20734	20.3	1	10
2014-03-26 07:38:52.397871	20735	46	2	10
2014-03-26 07:39:31.175707	20744	20.3	1	10
2014-03-26 07:39:31.400052	20745	46	2	10
2014-03-26 07:40:10.178595	20756	20.3	1	10
2014-03-26 07:40:10.402821	20757	46	2	10
2014-03-26 07:40:49.177792	20766	20.3	1	10
2014-03-26 07:40:49.399918	20767	46	2	10
2014-03-26 07:41:28.175882	20775	20.3	1	10
2014-03-26 07:41:28.398547	20776	46	2	10
2014-03-26 07:42:07.1778	20783	20.2	1	10
2014-03-26 07:42:07.410112	20784	46	2	10
2014-03-26 07:42:46.177296	20794	20.2	1	10
2014-03-26 07:42:46.40952	20795	46	2	10
2014-03-26 07:43:25.177358	20805	20.2	1	10
2014-03-26 07:43:25.40928	20806	46	2	10
2014-03-26 07:43:27.487058	20809	21.1	1	8
2014-03-26 07:43:27.723673	20810	53	2	8
2014-03-26 07:43:32.651006	20811	3283	3	2
2014-03-26 07:43:42.193738	20812	18.4	1	1
2014-03-26 07:43:42.437476	20813	48	2	1
2014-03-26 07:43:44.654246	20814	2205	3	2
2014-03-26 07:43:56.650811	20815	1352	3	2
2014-03-26 23:09:02.044553	32923	21.4	1	9
2014-03-26 23:09:02.272017	32924	47	2	9
2014-03-26 07:44:06.15999	20820	21.1	1	8
2014-03-26 07:44:06.391965	20821	53	2	8
2014-03-26 07:44:08.655036	20822	837	3	2
2014-03-26 07:44:20.649854	20823	1979	3	2
2014-03-26 07:44:21.188048	20824	18.4	1	1
2014-03-26 07:44:21.420237	20825	48	2	1
2014-03-26 07:44:32.649985	20826	1963	3	2
2014-03-26 23:09:03.133409	32925	21.7	1	8
2014-03-26 23:09:03.367785	32926	48	2	8
2014-03-26 07:44:44.650213	20831	804	3	2
2014-03-26 07:44:45.376772	20832	21.1	1	8
2014-03-26 07:44:45.598988	20833	53	2	8
2014-03-26 07:44:56.655223	20834	804	3	2
2014-03-26 07:45:00.191246	20835	18.4	1	1
2014-03-26 07:45:00.414281	20836	48	2	1
2014-03-26 07:45:20.65206	20837	1883	3	2
2014-03-26 23:09:17.654496	32927	20.1	1	1
2014-03-26 23:09:17.879318	32928	50	2	1
2014-03-26 07:45:24.160654	20842	21.0	1	8
2014-03-26 07:45:24.393443	20843	53	2	8
2014-03-26 07:45:32.652875	20844	692	3	2
2014-03-26 07:45:39.191833	20845	18.5	1	1
2014-03-26 07:45:39.414828	20846	48	2	1
2014-03-26 07:45:44.65154	20847	627	3	2
2014-03-26 07:45:56.652009	20848	627	3	2
2014-03-26 23:09:30.725819	32929	23.9	1	10
2014-03-26 23:09:30.963437	32930	42	2	10
2014-03-26 07:46:03.161509	20853	21.0	1	8
2014-03-26 07:46:03.392493	20854	53	2	8
2014-03-26 07:46:18.190756	20855	18.5	1	1
2014-03-26 07:46:18.413618	20856	48	2	1
2014-03-26 07:46:32.653393	20857	627	3	2
2014-03-26 23:09:32.549254	32931	338	3	2
2014-03-26 23:09:32.774345	32932	1088784.4598642618	4	2
2014-03-26 07:46:42.159318	20862	21.0	1	8
2014-03-26 07:46:42.38239	20863	53	2	8
2014-03-26 07:46:44.653951	20864	1883	3	2
2014-03-26 07:46:56.655969	20865	1867	3	2
2014-03-26 07:46:57.186738	20866	18.6	1	1
2014-03-26 07:46:57.409432	20867	48	2	1
2014-03-26 07:47:08.653173	20868	676	3	2
2014-03-26 23:09:41.045164	32933	21.4	1	9
2014-03-26 23:09:41.28161	32934	47	2	9
2014-03-26 07:47:20.65313	20873	627	3	2
2014-03-26 07:47:21.15953	20874	21.0	1	8
2014-03-26 07:47:21.380322	20875	54	2	8
2014-03-26 07:47:32.649627	20876	627	3	2
2014-03-26 07:47:36.188963	20877	18.6	1	1
2014-03-26 07:47:36.411258	20878	48	2	1
2014-03-26 23:09:42.133082	32935	21.7	1	8
2014-03-26 23:09:42.358439	32936	48	2	8
2014-03-26 07:48:00.1596	20883	21.0	1	8
2014-03-26 07:48:00.391232	20884	54	2	8
2014-03-26 07:48:15.188638	20885	18.6	1	1
2014-03-26 07:48:15.411442	20886	49	2	1
2014-03-26 07:48:36.980904	20887	627	3	2
2014-03-26 23:09:56.65377	32937	20.1	1	1
2014-03-26 23:09:56.888138	32938	50	2	1
2014-03-26 07:48:39.158213	20892	21.0	1	8
2014-03-26 07:48:39.382587	20893	54	2	8
2014-03-26 07:48:54.187496	20894	18.7	1	1
2014-03-26 07:48:54.419802	20895	49	2	1
2014-03-26 23:10:09.724589	32939	23.9	1	10
2014-03-26 23:10:09.95262	32940	42	2	10
2014-03-26 07:49:18.158773	20900	21.0	1	8
2014-03-26 07:49:18.381735	20901	54	2	8
2014-03-26 07:49:20.653814	20902	595	3	2
2014-03-26 07:49:32.654991	20903	611	3	2
2014-03-26 07:49:33.186534	20904	18.7	1	1
2014-03-26 07:49:33.410829	20905	49	2	1
2014-03-26 23:10:20.046244	32941	21.4	1	9
2014-03-26 23:10:20.334034	32942	47	2	9
2014-03-26 07:49:57.159354	20910	21.0	1	8
2014-03-26 07:49:57.391152	20911	54	2	8
2014-03-26 07:50:12.190795	20912	18.8	1	1
2014-03-26 07:50:12.415476	20913	49	2	1
2014-03-26 07:50:32.783893	20914	627	3	2
2014-03-26 23:10:20.676571	32943	305	3	2
2014-03-26 23:10:20.937735	32944	1088789.0560031475	4	2
2014-03-26 07:50:36.360088	20919	21.0	1	8
2014-03-26 07:50:36.780136	20920	54	2	8
2014-03-26 07:50:51.183437	20921	18.8	1	1
2014-03-26 07:50:51.416718	20922	49	2	1
2014-03-26 23:10:21.269841	32945	21.7	1	8
2014-03-26 23:10:21.540239	32946	48	2	8
2014-03-26 07:51:15.161582	20927	21.0	1	8
2014-03-26 07:51:15.382981	20928	55	2	8
2014-03-26 07:51:30.190216	20929	18.8	1	1
2014-03-26 07:51:30.423943	20930	49	2	1
2014-03-26 07:51:32.65039	20931	627	3	2
2014-03-26 23:10:32.551303	32947	305	3	2
2014-03-26 23:10:32.83032	32948	1088790.205037869	4	2
2014-03-26 07:51:54.1601	20936	21.0	1	8
2014-03-26 07:51:54.391379	20937	55	2	8
2014-03-26 07:51:56.650396	20938	676	3	2
2014-03-26 07:52:08.652258	20939	676	3	2
2014-03-26 23:10:35.653554	32949	20.1	1	1
2014-03-26 07:52:32.645178	20944	676	3	2
2014-03-26 07:44:04.176534	20816	20.2	1	10
2014-03-26 07:44:04.409566	20817	46	2	10
2014-03-26 07:44:43.178256	20827	20.2	1	10
2014-03-26 07:44:43.399666	20828	46	2	10
2014-03-26 07:45:22.177917	20838	20.2	1	10
2014-03-26 07:45:22.410525	20839	46	2	10
2014-03-26 07:46:01.179561	20849	20.2	1	10
2014-03-26 07:46:01.411206	20850	46	2	10
2014-03-26 07:46:40.178574	20858	20.2	1	10
2014-03-26 07:46:40.402442	20859	46	2	10
2014-03-26 07:47:19.179123	20869	20.2	1	10
2014-03-26 07:47:19.403006	20870	46	2	10
2014-03-26 07:47:58.177091	20879	20.2	1	10
2014-03-26 07:47:58.402197	20880	46	2	10
2014-03-26 07:48:37.297587	20888	20.1	1	10
2014-03-26 07:48:37.520044	20889	46	2	10
2014-03-26 07:49:16.179491	20896	20.1	1	10
2014-03-26 07:49:16.401672	20897	46	2	10
2014-03-26 07:49:55.179857	20906	20.1	1	10
2014-03-26 07:49:55.412775	20907	46	2	10
2014-03-26 07:50:34.310068	20915	20.1	1	10
2014-03-26 07:50:34.733775	20916	46	2	10
2014-03-26 07:51:13.181636	20923	20.1	1	10
2014-03-26 07:51:13.405433	20924	46	2	10
2014-03-26 07:51:52.181076	20932	20.1	1	10
2014-03-26 07:51:52.404656	20933	46	2	10
2014-03-26 07:52:33.15899	20945	21.0	1	8
2014-03-26 07:52:33.382161	20946	55	2	8
2014-03-26 07:52:48.18499	20947	19.0	1	1
2014-03-26 07:52:48.60436	20948	48	2	1
2014-03-26 23:10:35.971264	32950	50	2	1
2014-03-26 23:10:44.55429	32951	338	3	2
2014-03-26 07:53:12.160722	20953	21.0	1	8
2014-03-26 07:53:12.389114	20954	55	2	8
2014-03-26 07:53:27.184574	20955	19.0	1	1
2014-03-26 07:53:27.405962	20956	48	2	1
2014-03-26 07:53:32.654591	20957	676	3	2
2014-03-26 23:10:44.819959	32952	1088791.3540725904	4	2
2014-03-26 23:10:48.72505	32953	23.9	1	10
2014-03-26 07:53:51.491302	20962	21.0	1	8
2014-03-26 07:53:51.713619	20963	55	2	8
2014-03-26 07:54:06.183379	20964	19.0	1	1
2014-03-26 07:54:06.41408	20965	48	2	1
2014-03-26 23:10:48.992498	32954	42	2	10
2014-03-26 23:10:56.55097	32955	338	3	2
2014-03-26 07:54:30.159516	20968	21.0	1	8
2014-03-26 07:54:30.390659	20969	55	2	8
2014-03-26 07:54:32.650313	20970	676	3	2
2014-03-26 07:54:45.182892	20971	19.1	1	1
2014-03-26 07:54:45.404905	20972	48	2	1
2014-03-26 23:10:56.776258	32956	1088792.503107312	4	2
2014-03-26 23:10:59.046842	32957	21.4	1	9
2014-03-26 07:55:09.158646	20977	21.0	1	8
2014-03-26 07:55:09.379632	20978	55	2	8
2014-03-26 07:55:24.187115	20979	19.1	1	1
2014-03-26 07:55:24.419518	20980	48	2	1
2014-03-26 07:55:32.654835	20981	676	3	2
2014-03-26 23:10:59.283974	32958	47	2	9
2014-03-26 23:11:00.133473	32959	21.7	1	8
2014-03-26 07:55:48.161101	20986	21.0	1	8
2014-03-26 07:55:48.393138	20987	55	2	8
2014-03-26 07:56:03.184526	20988	19.2	1	1
2014-03-26 07:56:03.406971	20989	48	2	1
2014-03-26 23:11:00.357067	32960	48	2	8
2014-03-26 23:11:08.551589	32961	305	3	2
2014-03-26 07:56:27.160528	20994	21.0	1	8
2014-03-26 07:56:27.392635	20995	55	2	8
2014-03-26 07:56:32.652352	20996	676	3	2
2014-03-26 07:56:42.225375	20997	19.2	1	1
2014-03-26 07:56:42.446404	20998	48	2	1
2014-03-26 23:11:08.786155	32962	1088793.6521420332	4	2
2014-03-26 23:11:14.654985	32963	20.1	1	1
2014-03-26 07:57:06.158297	21003	21.0	1	8
2014-03-26 07:57:06.384015	21004	55	2	8
2014-03-26 07:57:21.182526	21005	19.3	1	1
2014-03-26 07:57:21.416087	21006	48	2	1
2014-03-26 07:57:32.649032	21007	611	3	2
2014-03-26 23:11:14.879706	32964	50	2	1
2014-03-26 23:11:20.554166	32965	338	3	2
2014-03-26 07:57:44.652399	21012	611	3	2
2014-03-26 07:57:45.159121	21013	21.0	1	8
2014-03-26 07:57:45.382917	21014	55	2	8
2014-03-26 07:58:00.184824	21015	19.3	1	1
2014-03-26 07:58:00.418597	21016	48	2	1
2014-03-26 23:11:20.78897	32966	1088794.8011767545	4	2
2014-03-26 23:11:27.930917	32967	23.9	1	10
2014-03-26 07:58:24.160086	21021	21.0	1	8
2014-03-26 07:58:24.38409	21022	55	2	8
2014-03-26 07:58:32.649604	21023	611	3	2
2014-03-26 07:58:39.183002	21024	19.3	1	1
2014-03-26 07:58:39.406133	21025	49	2	1
2014-03-26 23:11:28.155021	32968	42	2	10
2014-03-26 23:11:32.549327	32969	338	3	2
2014-03-26 07:59:03.158575	21030	21.0	1	8
2014-03-26 07:59:03.39124	21031	56	2	8
2014-03-26 07:59:08.650785	21032	724	3	2
2014-03-26 07:59:18.181453	21033	19.4	1	1
2014-03-26 07:59:18.424732	21034	49	2	1
2014-03-26 07:59:32.652937	21035	724	3	2
2014-03-26 23:11:32.784909	32970	1088794.8011767545	4	2
2014-03-26 23:11:38.045032	32971	21.4	1	9
2014-03-26 07:59:42.159141	21040	21.0	1	8
2014-03-26 07:59:42.390796	21041	56	2	8
2014-03-26 07:59:57.179621	21042	19.4	1	1
2014-03-26 07:59:57.403401	21043	49	2	1
2014-03-26 23:11:38.271109	32972	47	2	9
2014-03-26 23:11:39.133262	32973	21.7	1	8
2014-03-26 08:00:21.158239	21048	21.1	1	8
2014-03-26 08:00:21.391107	21049	57	2	8
2014-03-26 08:00:32.650364	21050	724	3	2
2014-03-26 08:00:36.183152	21051	19.5	1	1
2014-03-26 08:00:36.404884	21052	49	2	1
2014-03-26 23:11:39.366999	32974	48	2	8
2014-03-26 23:11:53.654289	32975	20.1	1	1
2014-03-26 08:01:00.159312	21057	21.1	1	8
2014-03-26 08:01:00.379848	21058	59	2	8
2014-03-26 08:01:08.646607	21059	692	3	2
2014-03-26 08:01:15.184331	21060	19.5	1	1
2014-03-26 08:01:15.407527	21061	49	2	1
2014-03-26 08:01:20.647788	21062	692	3	2
2014-03-26 08:01:32.648629	21063	708	3	2
2014-03-26 23:11:53.87986	32976	50	2	1
2014-03-26 08:01:39.495769	21068	21.2	1	8
2014-03-26 08:01:39.717722	21069	61	2	8
2014-03-26 08:01:54.188766	21070	19.6	1	1
2014-03-26 08:01:54.419292	21071	49	2	1
2014-03-26 08:02:18.158684	21076	21.3	1	8
2014-03-26 08:02:18.383172	21077	63	2	8
2014-03-26 08:02:32.65101	21078	692	3	2
2014-03-26 08:02:33.184678	21079	19.6	1	1
2014-03-26 08:02:33.408126	21080	49	2	1
2014-03-26 07:53:10.180634	20949	20.1	1	10
2014-03-26 07:53:10.408755	20950	46	2	10
2014-03-26 07:53:49.17919	20958	20.1	1	10
2014-03-26 07:53:49.406242	20959	46	2	10
2014-03-26 07:55:07.182444	20973	20.1	1	10
2014-03-26 07:55:07.406102	20974	46	2	10
2014-03-26 07:55:46.181278	20982	20.1	1	10
2014-03-26 07:55:46.415614	20983	46	2	10
2014-03-26 07:56:25.182608	20990	20.1	1	10
2014-03-26 07:56:25.424371	20991	46	2	10
2014-03-26 07:57:04.181956	20999	20.1	1	10
2014-03-26 07:57:04.406032	21000	46	2	10
2014-03-26 07:57:43.182341	21008	20.1	1	10
2014-03-26 07:57:43.406474	21009	46	2	10
2014-03-26 07:58:22.181723	21017	20.1	1	10
2014-03-26 07:58:22.403621	21018	46	2	10
2014-03-26 07:59:01.182529	21026	20.1	1	10
2014-03-26 07:59:01.417027	21027	46	2	10
2014-03-26 07:59:40.18257	21036	20.1	1	10
2014-03-26 07:59:40.406195	21037	46	2	10
2014-03-26 08:00:19.182621	21044	20.1	1	10
2014-03-26 08:00:19.415427	21045	46	2	10
2014-03-26 08:00:58.183199	21053	20.1	1	10
2014-03-26 08:00:58.405109	21054	46	2	10
2014-03-26 08:01:37.183804	21064	20.1	1	10
2014-03-26 08:01:37.40682	21065	46	2	10
2014-03-26 08:02:16.18545	21072	20.1	1	10
2014-03-26 08:02:16.417053	21073	46	2	10
2014-03-26 23:12:06.726233	32977	23.9	1	10
2014-03-26 23:12:06.964528	32978	42	2	10
2014-03-26 08:02:57.160959	21085	21.4	1	8
2014-03-26 08:02:57.382321	21086	64	2	8
2014-03-26 08:03:12.184398	21087	19.6	1	1
2014-03-26 08:03:12.406924	21088	49	2	1
2014-03-26 08:03:32.64717	21089	692	3	2
2014-03-26 23:12:17.045069	32979	21.4	1	9
2014-03-26 23:12:17.269691	32980	47	2	9
2014-03-26 08:03:36.157872	21094	21.5	1	8
2014-03-26 08:03:36.392752	21095	66	2	8
2014-03-26 08:03:51.18224	21096	19.7	1	1
2014-03-26 08:03:51.403372	21097	49	2	1
2014-03-26 23:12:18.132758	32981	21.7	1	8
2014-03-26 23:12:18.36878	32982	48	2	8
2014-03-26 08:04:15.158958	21102	21.7	1	8
2014-03-26 08:04:15.389717	21103	67	2	8
2014-03-26 08:04:20.650593	21104	804	3	2
2014-03-26 08:04:30.182356	21105	19.7	1	1
2014-03-26 08:04:30.406063	21106	49	2	1
2014-03-26 08:04:32.651299	21107	804	3	2
2014-03-26 23:12:20.549649	32983	305	3	2
2014-03-26 23:12:20.776159	32984	1088799.3973156402	4	2
2014-03-26 08:04:54.159347	21112	21.8	1	8
2014-03-26 08:04:54.38808	21113	68	2	8
2014-03-26 08:05:09.179882	21114	19.7	1	1
2014-03-26 08:05:09.403224	21115	49	2	1
2014-03-26 23:12:32.892671	32985	20.1	1	1
2014-03-26 23:12:33.127093	32986	50	2	1
2014-03-26 08:05:32.645086	21120	804	3	2
2014-03-26 08:05:33.157479	21121	22.0	1	8
2014-03-26 08:05:33.38004	21122	68	2	8
2014-03-26 08:05:48.183785	21123	19.8	1	1
2014-03-26 08:05:48.408292	21124	49	2	1
2014-03-26 08:05:56.655363	21125	627	3	2
2014-03-26 08:06:08.649255	21126	643	3	2
2014-03-26 23:12:44.54866	32987	338	3	2
2014-03-26 23:12:44.775692	32988	1088801.695385083	4	2
2014-03-26 08:06:12.157375	21131	22.0	1	8
2014-03-26 08:06:12.389216	21132	67	2	8
2014-03-26 08:06:20.651008	21133	692	3	2
2014-03-26 08:06:27.181688	21134	19.8	1	1
2014-03-26 08:06:27.405242	21135	49	2	1
2014-03-26 08:06:32.6512	21136	692	3	2
2014-03-26 08:06:44.701386	21137	643	3	2
2014-03-26 23:12:45.725572	32989	23.9	1	10
2014-03-26 23:12:45.961742	32990	42	2	10
2014-03-26 08:06:51.159466	21142	21.9	1	8
2014-03-26 08:06:51.390535	21143	66	2	8
2014-03-26 08:06:56.649205	21144	643	3	2
2014-03-26 08:07:06.182921	21145	19.8	1	1
2014-03-26 08:07:06.405016	21146	49	2	1
2014-03-26 23:12:56.044543	32991	21.4	1	9
2014-03-26 23:12:56.267526	32992	47	2	9
2014-03-26 08:07:30.159823	21151	21.9	1	8
2014-03-26 08:07:30.381865	21152	65	2	8
2014-03-26 08:07:32.64932	21153	643	3	2
2014-03-26 08:07:45.181819	21154	19.8	1	1
2014-03-26 08:07:45.4074	21155	49	2	1
2014-03-26 23:12:56.575907	32993	305	3	2
2014-03-26 23:12:56.810744	32994	1088802.8444198046	4	2
2014-03-26 08:08:08.649226	21160	611	3	2
2014-03-26 08:08:09.159582	21161	21.8	1	8
2014-03-26 08:08:09.383314	21162	64	2	8
2014-03-26 08:08:20.649658	21163	611	3	2
2014-03-26 08:08:24.176611	21164	19.9	1	1
2014-03-26 08:08:24.400323	21165	49	2	1
2014-03-26 08:08:32.652633	21166	466	3	2
2014-03-26 08:08:44.649432	21167	466	3	2
2014-03-26 23:12:57.134763	32995	21.7	1	8
2014-03-26 23:12:57.362232	32996	48	2	8
2014-03-26 08:08:48.157893	21172	21.8	1	8
2014-03-26 08:08:48.386797	21173	64	2	8
2014-03-26 08:08:56.648907	21174	595	3	2
2014-03-26 08:09:03.179388	21175	19.9	1	1
2014-03-26 08:09:03.401916	21176	49	2	1
2014-03-26 08:09:08.64528	21177	611	3	2
2014-03-26 23:13:08.55091	32997	305	3	2
2014-03-26 23:13:08.796392	32998	1088803.993454526	4	2
2014-03-26 08:09:27.160001	21182	21.7	1	8
2014-03-26 08:09:27.384354	21183	64	2	8
2014-03-26 08:09:32.653514	21184	531	3	2
2014-03-26 08:09:42.174461	21185	19.9	1	1
2014-03-26 08:09:42.396706	21186	49	2	1
2014-03-26 08:09:44.653897	21187	418	3	2
2014-03-26 08:09:56.650217	21188	466	3	2
2014-03-26 23:13:11.650604	32999	20.1	1	1
2014-03-26 23:13:11.874327	33000	50	2	1
2014-03-26 08:10:06.158449	21193	21.7	1	8
2014-03-26 08:10:06.383021	21194	64	2	8
2014-03-26 08:10:08.651051	21195	482	3	2
2014-03-26 08:10:21.178723	21196	19.9	1	1
2014-03-26 08:10:21.399342	21197	49	2	1
2014-03-26 08:10:32.642513	21198	627	3	2
2014-03-26 23:13:20.552995	33001	370	3	2
2014-03-26 23:13:20.787355	33002	1088805.1424892475	4	2
2014-03-26 08:10:44.643156	21203	515	3	2
2014-03-26 08:10:45.159574	21204	21.7	1	8
2014-03-26 08:10:45.38025	21205	64	2	8
2014-03-26 08:10:56.6491	21206	482	3	2
2014-03-26 08:11:00.173402	21207	19.9	1	1
2014-03-26 08:11:00.394875	21208	49	2	1
2014-03-26 08:11:08.647796	21209	466	3	2
2014-03-26 23:13:24.723992	33003	23.9	1	10
2014-03-26 08:11:24.158184	21214	21.6	1	8
2014-03-26 08:11:24.380847	21215	63	2	8
2014-03-26 08:11:32.650769	21216	466	3	2
2014-03-26 08:02:55.183285	21081	20.1	1	10
2014-03-26 08:02:55.408729	21082	46	2	10
2014-03-26 08:03:34.183042	21090	20.1	1	10
2014-03-26 08:03:34.415542	21091	46	2	10
2014-03-26 08:04:13.183088	21098	20.1	1	10
2014-03-26 08:04:13.41459	21099	46	2	10
2014-03-26 08:04:52.184312	21108	20.1	1	10
2014-03-26 08:04:52.405685	21109	46	2	10
2014-03-26 08:05:31.183899	21116	20.1	1	10
2014-03-26 08:05:31.415767	21117	46	2	10
2014-03-26 08:06:10.184192	21127	20.1	1	10
2014-03-26 08:06:10.417662	21128	46	2	10
2014-03-26 08:06:49.18531	21138	20.1	1	10
2014-03-26 08:06:49.41569	21139	46	2	10
2014-03-26 08:07:28.187893	21147	20.1	1	10
2014-03-26 08:07:28.412297	21148	46	2	10
2014-03-26 08:08:07.18598	21156	20.1	1	10
2014-03-26 08:08:07.417617	21157	46	2	10
2014-03-26 08:08:46.185547	21168	20.1	1	10
2014-03-26 08:08:46.407356	21169	46	2	10
2014-03-26 08:09:25.187086	21178	20.1	1	10
2014-03-26 08:09:25.410748	21179	46	2	10
2014-03-26 08:10:04.187221	21189	20.1	1	10
2014-03-26 08:10:04.408268	21190	46	2	10
2014-03-26 08:10:43.186884	21199	20.1	1	10
2014-03-26 08:10:43.408824	21200	45	2	10
2014-03-26 08:11:39.176305	21217	19.9	1	1
2014-03-26 08:11:39.399484	21218	49	2	1
2014-03-26 23:13:24.95173	33004	42	2	10
2014-03-26 23:13:32.550417	33005	370	3	2
2014-03-26 08:12:03.158566	21223	21.6	1	8
2014-03-26 08:12:03.388845	21224	63	2	8
2014-03-26 08:12:18.176334	21225	20.0	1	1
2014-03-26 08:12:18.399181	21226	49	2	1
2014-03-26 08:12:32.653288	21227	466	3	2
2014-03-26 23:13:32.785223	33006	1088806.2915239688	4	2
2014-03-26 23:13:35.046648	33007	21.4	1	9
2014-03-26 08:12:42.162422	21232	21.6	1	8
2014-03-26 08:12:42.385526	21233	63	2	8
2014-03-26 08:12:57.180341	21234	20.0	1	1
2014-03-26 08:12:57.412472	21235	49	2	1
2014-03-26 23:13:35.270706	33008	47	2	9
2014-03-26 23:13:36.132593	33009	21.7	1	8
2014-03-26 08:13:21.158977	21240	21.6	1	8
2014-03-26 08:13:21.384408	21241	63	2	8
2014-03-26 08:13:32.647863	21242	466	3	2
2014-03-26 08:13:36.176453	21243	20.0	1	1
2014-03-26 08:13:36.401517	21244	49	2	1
2014-03-26 23:13:36.369216	33010	48	2	8
2014-03-26 23:13:50.650737	33011	20.1	1	1
2014-03-26 08:14:00.158836	21249	21.6	1	8
2014-03-26 08:14:00.392113	21250	62	2	8
2014-03-26 08:14:15.176687	21251	20.1	1	1
2014-03-26 08:14:15.398427	21252	49	2	1
2014-03-26 08:14:36.986403	21253	466	3	2
2014-03-26 23:13:50.875254	33012	50	2	1
2014-03-26 23:14:03.724474	33013	23.9	1	10
2014-03-26 08:14:39.158545	21258	21.5	1	8
2014-03-26 08:14:39.379733	21259	62	2	8
2014-03-26 08:14:54.17364	21260	20.1	1	1
2014-03-26 08:14:54.40902	21261	49	2	1
2014-03-26 23:14:03.95933	33014	42	2	10
2014-03-26 23:14:14.044713	33015	21.4	1	9
2014-03-26 08:15:18.158768	21266	21.5	1	8
2014-03-26 08:15:18.379434	21267	62	2	8
2014-03-26 08:15:32.652029	21268	466	3	2
2014-03-26 08:15:33.213534	21269	20.1	1	1
2014-03-26 08:15:33.43538	21270	49	2	1
2014-03-26 23:14:14.270599	33016	47	2	9
2014-03-26 23:14:15.135123	33017	21.7	1	8
2014-03-26 08:15:57.157846	21275	21.5	1	8
2014-03-26 08:15:57.388726	21276	62	2	8
2014-03-26 08:16:08.651456	21277	515	3	2
2014-03-26 08:16:12.212556	21278	20.1	1	1
2014-03-26 08:16:12.436255	21279	49	2	1
2014-03-26 08:16:20.646346	21280	515	3	2
2014-03-26 08:16:32.648556	21281	531	3	2
2014-03-26 23:14:15.369178	33018	48	2	8
2014-03-26 23:14:29.652967	33019	20.1	1	1
2014-03-26 08:16:36.158481	21286	21.5	1	8
2014-03-26 08:16:36.389933	21287	62	2	8
2014-03-26 08:16:51.173361	21288	20.2	1	1
2014-03-26 08:16:51.395125	21289	49	2	1
2014-03-26 23:14:29.884831	33020	50	2	1
2014-03-26 23:14:32.549855	33021	370	3	2
2014-03-26 08:17:15.158711	21294	21.5	1	8
2014-03-26 08:17:15.391955	21295	62	2	8
2014-03-26 08:17:30.175401	21296	20.2	1	1
2014-03-26 08:17:30.39746	21297	50	2	1
2014-03-26 08:17:32.647448	21298	515	3	2
2014-03-26 23:14:32.78375	33022	1088813.1857322974	4	2
2014-03-26 23:14:42.725522	33023	23.8	1	10
2014-03-26 08:17:54.160332	21303	21.5	1	8
2014-03-26 08:17:54.382256	21304	62	2	8
2014-03-26 08:18:09.174856	21305	20.2	1	1
2014-03-26 08:18:09.407409	21306	50	2	1
2014-03-26 23:14:42.950273	33024	42	2	10
2014-03-26 23:14:53.044182	33025	21.4	1	9
2014-03-26 08:18:32.957412	21311	515	3	2
2014-03-26 08:18:33.265561	21312	21.5	1	8
2014-03-26 08:18:33.488085	21313	62	2	8
2014-03-26 08:18:48.175988	21314	20.3	1	1
2014-03-26 08:18:48.402658	21315	50	2	1
2014-03-26 23:14:53.280008	33026	47	2	9
2014-03-26 23:14:54.132454	33027	21.6	1	8
2014-03-26 08:19:12.157785	21320	21.5	1	8
2014-03-26 08:19:12.382548	21321	62	2	8
2014-03-26 08:19:27.172563	21322	20.3	1	1
2014-03-26 08:19:27.3955	21323	50	2	1
2014-03-26 08:19:32.652167	21324	515	3	2
2014-03-26 23:14:54.357419	33028	48	2	8
2014-03-26 23:15:08.649535	33029	20.1	1	1
2014-03-26 08:19:51.158696	21329	21.5	1	8
2014-03-26 08:19:51.381052	21330	62	2	8
2014-03-26 08:20:06.173243	21331	20.3	1	1
2014-03-26 08:20:06.40477	21332	50	2	1
2014-03-26 23:15:08.886906	33030	50	2	1
2014-03-26 23:15:21.72659	33031	23.8	1	10
2014-03-26 08:20:30.158539	21337	21.5	1	8
2014-03-26 08:20:30.380119	21338	62	2	8
2014-03-26 08:20:32.64756	21339	515	3	2
2014-03-26 08:20:45.226973	21340	20.4	1	1
2014-03-26 08:20:45.449506	21341	50	2	1
2014-03-26 23:15:21.952166	33032	42	2	10
2014-03-26 23:15:32.044555	33033	21.4	1	9
2014-03-26 08:21:09.157255	21346	21.5	1	8
2014-03-26 08:21:09.379259	21347	62	2	8
2014-03-26 08:21:24.171219	21348	20.4	1	1
2014-03-26 08:21:24.395868	21349	50	2	1
2014-03-26 08:21:32.649267	21350	531	3	2
2014-03-26 08:21:44.648319	21351	466	3	2
2014-03-26 08:12:01.187335	21219	20.1	1	10
2014-03-26 08:12:01.418421	21220	45	2	10
2014-03-26 08:12:40.189179	21228	20.1	1	10
2014-03-26 08:12:40.413673	21229	45	2	10
2014-03-26 08:13:19.18758	21236	20.1	1	10
2014-03-26 08:13:19.412931	21237	45	2	10
2014-03-26 08:13:58.18593	21245	20.1	1	10
2014-03-26 08:13:58.411379	21246	45	2	10
2014-03-26 08:14:37.313171	21254	20.1	1	10
2014-03-26 08:14:37.536627	21255	45	2	10
2014-03-26 08:15:16.188625	21262	20.1	1	10
2014-03-26 08:15:16.410133	21263	45	2	10
2014-03-26 08:15:55.188232	21271	20.1	1	10
2014-03-26 08:15:55.41885	21272	45	2	10
2014-03-26 08:16:34.188808	21282	20.1	1	10
2014-03-26 08:16:34.420335	21283	45	2	10
2014-03-26 08:17:13.189961	21290	20.1	1	10
2014-03-26 08:17:13.422719	21291	45	2	10
2014-03-26 08:17:52.190916	21299	20.2	1	10
2014-03-26 08:17:52.41523	21300	45	2	10
2014-03-26 08:18:31.189429	21307	20.2	1	10
2014-03-26 08:18:31.413239	21308	45	2	10
2014-03-26 08:19:10.190302	21316	20.2	1	10
2014-03-26 08:19:10.413844	21317	45	2	10
2014-03-26 08:19:49.19085	21325	20.2	1	10
2014-03-26 08:19:49.414074	21326	45	2	10
2014-03-26 08:20:28.190045	21333	20.2	1	10
2014-03-26 08:20:28.41251	21334	45	2	10
2014-03-26 23:15:32.277338	33034	47	2	9
2014-03-26 23:15:32.589575	33035	370	3	2
2014-03-26 08:21:48.158083	21356	21.5	1	8
2014-03-26 08:21:48.378823	21357	62	2	8
2014-03-26 08:21:56.6454	21358	482	3	2
2014-03-26 08:22:03.171908	21359	20.4	1	1
2014-03-26 08:22:03.393382	21360	50	2	1
2014-03-26 23:15:32.813787	33036	1088818.9309059044	4	2
2014-03-26 23:15:33.132044	33037	21.6	1	8
2014-03-26 08:22:27.1582	21365	21.5	1	8
2014-03-26 08:22:27.379847	21366	62	2	8
2014-03-26 08:22:32.645797	21367	482	3	2
2014-03-26 08:22:42.172512	21368	20.4	1	1
2014-03-26 08:22:42.395055	21369	50	2	1
2014-03-26 23:15:33.367196	33038	48	2	8
2014-03-26 23:15:47.650648	33039	20.1	1	1
2014-03-26 08:23:06.1593	21374	21.4	1	8
2014-03-26 08:23:06.411856	21375	61	2	8
2014-03-26 08:23:21.170437	21376	20.5	1	1
2014-03-26 08:23:21.393655	21377	50	2	1
2014-03-26 08:23:32.647255	21378	482	3	2
2014-03-26 23:15:47.874569	33040	50	2	1
2014-03-26 23:16:00.726231	33041	23.8	1	10
2014-03-26 08:23:45.156844	21383	21.4	1	8
2014-03-26 08:23:45.437038	21384	61	2	8
2014-03-26 08:24:00.167949	21385	20.5	1	1
2014-03-26 08:24:00.392758	21386	50	2	1
2014-03-26 08:24:20.646674	21387	579	3	2
2014-03-26 23:16:00.960839	33042	42	2	10
2014-03-26 23:16:11.044517	33043	21.3	1	9
2014-03-26 08:24:24.158695	21392	21.4	1	8
2014-03-26 08:24:24.390762	21393	61	2	8
2014-03-26 08:24:32.649241	21394	547	3	2
2014-03-26 08:24:39.169736	21395	20.5	1	1
2014-03-26 08:24:39.395293	21396	50	2	1
2014-03-26 08:24:44.648581	21397	579	3	2
2014-03-26 08:24:56.648771	21398	547	3	2
2014-03-26 23:16:11.268524	33044	47	2	9
2014-03-26 23:16:12.132126	33045	21.6	1	8
2014-03-26 08:25:03.158234	21403	21.4	1	8
2014-03-26 08:25:03.390321	21404	61	2	8
2014-03-26 08:25:08.644459	21405	547	3	2
2014-03-26 08:25:18.173122	21406	20.6	1	1
2014-03-26 08:25:18.394783	21407	50	2	1
2014-03-26 08:25:32.647857	21408	579	3	2
2014-03-26 23:16:12.378052	33046	48	2	8
2014-03-26 23:16:26.652526	33047	20.1	1	1
2014-03-26 08:25:42.160015	21413	21.4	1	8
2014-03-26 08:25:42.382233	21414	61	2	8
2014-03-26 08:25:44.652649	21415	547	3	2
2014-03-26 08:25:56.646113	21416	547	3	2
2014-03-26 08:25:57.16952	21417	20.6	1	1
2014-03-26 08:25:57.391556	21418	50	2	1
2014-03-26 08:26:08.647158	21419	579	3	2
2014-03-26 23:16:26.878498	33048	50	2	1
2014-03-26 23:16:32.550928	33049	370	3	2
2014-03-26 08:26:21.0432	21424	547	3	2
2014-03-26 08:26:21.349179	21425	21.4	1	8
2014-03-26 08:26:21.571836	21426	61	2	8
2014-03-26 08:26:32.644333	21427	547	3	2
2014-03-26 08:26:36.171303	21428	20.6	1	1
2014-03-26 08:26:36.393633	21429	50	2	1
2014-03-26 23:16:32.785518	33050	1088823.5315157422	4	2
2014-03-26 23:16:39.726656	33051	23.8	1	10
2014-03-26 08:27:00.159143	21434	21.4	1	8
2014-03-26 08:27:00.399642	21435	61	2	8
2014-03-26 08:27:15.167781	21436	20.6	1	1
2014-03-26 08:27:15.389309	21437	50	2	1
2014-03-26 08:27:32.648173	21438	531	3	2
2014-03-26 23:16:39.951551	33052	42	2	10
2014-03-26 23:16:50.044401	33053	21.3	1	9
2014-03-26 08:27:39.158999	21443	21.4	1	8
2014-03-26 08:27:39.382636	21444	61	2	8
2014-03-26 08:27:54.170297	21445	20.6	1	1
2014-03-26 08:27:54.403033	21446	50	2	1
2014-03-26 23:16:50.277835	33054	47	2	9
2014-03-26 23:16:51.131645	33055	21.6	1	8
2014-03-26 08:28:18.159806	21451	21.4	1	8
2014-03-26 08:28:18.382845	21452	61	2	8
2014-03-26 08:28:32.645497	21453	595	3	2
2014-03-26 08:28:33.172003	21454	20.6	1	1
2014-03-26 08:28:33.393117	21455	50	2	1
2014-03-26 08:28:44.64611	21456	627	3	2
2014-03-26 23:16:51.355802	33056	48	2	8
2014-03-26 23:17:05.65315	33057	20.1	1	1
2014-03-26 08:28:56.648056	21461	595	3	2
2014-03-26 08:28:57.159373	21462	21.4	1	8
2014-03-26 08:28:57.380819	21463	61	2	8
2014-03-26 08:29:08.649511	21464	595	3	2
2014-03-26 08:29:12.187531	21465	20.7	1	1
2014-03-26 08:29:12.42498	21466	50	2	1
2014-03-26 08:29:32.646763	21467	547	3	2
2014-03-26 23:17:05.888535	33058	50	2	1
2014-03-26 23:17:18.728828	33059	23.8	1	10
2014-03-26 08:29:36.158574	21472	21.4	1	8
2014-03-26 08:29:36.384157	21473	61	2	8
2014-03-26 08:29:44.644576	21474	547	3	2
2014-03-26 08:29:51.168249	21475	20.7	1	1
2014-03-26 08:29:51.393103	21476	50	2	1
2014-03-26 08:29:56.648907	21477	579	3	2
2014-03-26 08:30:08.651887	21478	547	3	2
2014-03-26 08:30:15.15869	21483	21.4	1	8
2014-03-26 08:30:15.392967	21484	61	2	8
2014-03-26 08:30:20.646844	21485	547	3	2
2014-03-26 08:30:30.165534	21486	20.7	1	1
2014-03-26 08:30:30.388549	21487	50	2	1
2014-03-26 08:30:32.647871	21488	579	3	2
2014-03-26 08:21:46.412305	21353	45	2	10
2014-03-26 08:22:25.189659	21361	20.2	1	10
2014-03-26 08:22:25.414354	21362	45	2	10
2014-03-26 08:23:04.190874	21370	20.2	1	10
2014-03-26 08:23:04.423393	21371	45	2	10
2014-03-26 08:23:43.192579	21379	20.2	1	10
2014-03-26 08:23:43.414015	21380	45	2	10
2014-03-26 08:24:22.192857	21388	20.2	1	10
2014-03-26 08:24:22.417105	21389	45	2	10
2014-03-26 08:25:01.192654	21399	20.2	1	10
2014-03-26 08:25:01.426071	21400	45	2	10
2014-03-26 08:25:40.19201	21409	20.2	1	10
2014-03-26 08:25:40.415028	21410	45	2	10
2014-03-26 08:26:19.193057	21420	20.2	1	10
2014-03-26 08:26:19.415045	21421	45	2	10
2014-03-26 08:26:58.192439	21430	20.3	1	10
2014-03-26 08:26:58.424668	21431	45	2	10
2014-03-26 08:27:37.199417	21439	20.3	1	10
2014-03-26 08:27:37.424063	21440	45	2	10
2014-03-26 08:28:16.192386	21447	20.3	1	10
2014-03-26 08:28:16.415252	21448	45	2	10
2014-03-26 08:28:55.193183	21457	20.3	1	10
2014-03-26 08:28:55.425983	21458	45	2	10
2014-03-26 08:29:34.193132	21468	20.3	1	10
2014-03-26 08:29:34.417186	21469	45	2	10
2014-03-26 08:30:13.192776	21479	20.3	1	10
2014-03-26 08:30:44.648539	21489	579	3	2
2014-03-26 23:17:18.954155	33060	42	2	10
2014-03-26 23:17:29.045197	33061	21.3	1	9
2014-03-26 08:30:54.158006	21494	21.4	1	8
2014-03-26 08:30:54.391908	21495	61	2	8
2014-03-26 08:31:09.163179	21496	20.7	1	1
2014-03-26 08:31:09.385306	21497	50	2	1
2014-03-26 23:17:29.286899	33062	47	2	9
2014-03-26 23:17:30.135006	33063	21.6	1	8
2014-03-26 08:31:32.647847	21502	579	3	2
2014-03-26 08:31:33.157352	21503	21.4	1	8
2014-03-26 08:31:33.379446	21504	61	2	8
2014-03-26 08:31:48.168195	21505	20.7	1	1
2014-03-26 08:31:48.389932	21506	50	2	1
2014-03-26 08:31:56.647747	21507	547	3	2
2014-03-26 08:32:08.645815	21508	579	3	2
2014-03-26 23:17:30.41409	33064	48	2	8
2014-03-26 23:17:32.550681	33065	370	3	2
2014-03-26 08:32:12.214177	21513	21.4	1	8
2014-03-26 08:32:12.44662	21514	61	2	8
2014-03-26 08:32:20.649499	21515	547	3	2
2014-03-26 08:32:27.167386	21516	20.7	1	1
2014-03-26 08:32:27.390065	21517	50	2	1
2014-03-26 08:32:32.647256	21518	547	3	2
2014-03-26 23:17:32.787465	33066	1088830.4257240708	4	2
2014-03-26 23:17:44.649217	33067	20.1	1	1
2014-03-26 08:32:51.157428	21523	21.4	1	8
2014-03-26 08:32:51.400291	21524	61	2	8
2014-03-26 08:32:56.647044	21525	579	3	2
2014-03-26 08:33:06.164048	21526	20.7	1	1
2014-03-26 08:33:06.385918	21527	50	2	1
2014-03-26 08:33:08.646128	21528	579	3	2
2014-03-26 08:33:20.647547	21529	547	3	2
2014-03-26 23:17:44.876756	33068	50	2	1
2014-03-26 23:17:57.728864	33069	23.8	1	10
2014-03-26 08:33:30.157133	21534	21.4	1	8
2014-03-26 08:33:30.389764	21535	61	2	8
2014-03-26 08:33:32.644979	21536	547	3	2
2014-03-26 08:33:45.166648	21537	20.8	1	1
2014-03-26 08:33:45.389429	21538	50	2	1
2014-03-26 23:17:57.963839	33070	42	2	10
2014-03-26 23:18:08.045494	33071	21.3	1	9
2014-03-26 08:34:08.64628	21543	498	3	2
2014-03-26 08:34:09.158593	21544	21.4	1	8
2014-03-26 08:34:09.380817	21545	61	2	8
2014-03-26 08:34:20.647601	21546	515	3	2
2014-03-26 08:34:24.170807	21547	20.8	1	1
2014-03-26 08:34:24.393048	21548	50	2	1
2014-03-26 08:34:32.647848	21549	498	3	2
2014-03-26 23:18:08.270519	33072	47	2	9
2014-03-26 23:18:09.133095	33073	21.6	1	8
2014-03-26 08:34:48.156616	21554	21.4	1	8
2014-03-26 08:34:48.379607	21555	61	2	8
2014-03-26 08:35:03.202041	21556	20.8	1	1
2014-03-26 08:35:03.435771	21557	50	2	1
2014-03-26 23:18:09.367366	33074	48	2	8
2014-03-26 23:18:23.649203	33075	20.1	1	1
2014-03-26 08:35:27.156497	21562	21.4	1	8
2014-03-26 08:35:27.380619	21563	61	2	8
2014-03-26 08:35:32.64864	21564	515	3	2
2014-03-26 08:35:42.165094	21565	20.8	1	1
2014-03-26 08:35:42.389647	21566	50	2	1
2014-03-26 23:18:23.874998	33076	50	2	1
2014-03-26 23:18:36.526564	33077	338	3	2
2014-03-26 08:36:06.157933	21571	21.4	1	8
2014-03-26 08:36:06.389298	21572	60	2	8
2014-03-26 08:36:21.164048	21573	20.8	1	1
2014-03-26 08:36:21.387385	21574	50	2	1
2014-03-26 08:36:32.649068	21575	498	3	2
2014-03-26 23:18:36.760513	33078	1088836.1708976778	4	2
2014-03-26 23:18:37.070816	33079	23.8	1	10
2014-03-26 08:36:45.156809	21580	21.4	1	8
2014-03-26 08:36:45.378899	21581	61	2	8
2014-03-26 08:37:00.16521	21582	20.8	1	1
2014-03-26 08:37:00.387157	21583	50	2	1
2014-03-26 23:18:37.294014	33080	42	2	10
2014-03-26 23:18:44.554565	33081	338	3	2
2014-03-26 08:37:24.157454	21588	21.3	1	8
2014-03-26 08:37:24.379252	21589	60	2	8
2014-03-26 08:37:32.646499	21590	450	3	2
2014-03-26 08:37:39.162614	21591	20.8	1	1
2014-03-26 08:37:39.387414	21592	51	2	1
2014-03-26 08:37:44.647631	21593	434	3	2
2014-03-26 23:18:44.789672	33082	1088837.3199323993	4	2
2014-03-26 23:18:47.045553	33083	21.3	1	9
2014-03-26 08:38:03.15778	21598	21.3	1	8
2014-03-26 08:38:03.390464	21599	60	2	8
2014-03-26 08:38:18.164572	21600	20.8	1	1
2014-03-26 08:38:18.388079	21601	51	2	1
2014-03-26 08:38:32.64744	21602	466	3	2
2014-03-26 23:18:47.270158	33084	47	2	9
2014-03-26 23:18:48.13261	33085	21.6	1	8
2014-03-26 08:38:42.158233	21607	21.3	1	8
2014-03-26 08:38:42.380442	21608	60	2	8
2014-03-26 08:38:44.645621	21609	466	3	2
2014-03-26 08:38:57.163453	21610	20.8	1	1
2014-03-26 08:38:57.386906	21611	51	2	1
2014-03-26 23:18:48.366719	33086	48	2	8
2014-03-26 23:19:02.650327	33087	20.1	1	1
2014-03-26 08:39:21.485308	21616	21.3	1	8
2014-03-26 08:39:21.716841	21617	60	2	8
2014-03-26 08:39:32.643418	21618	466	3	2
2014-03-26 08:39:36.162044	21619	20.8	1	1
2014-03-26 08:39:36.384893	21620	51	2	1
2014-03-26 23:19:02.875199	33088	50	2	1
2014-03-26 08:30:52.193574	21490	20.3	1	10
2014-03-26 08:30:52.426295	21491	45	2	10
2014-03-26 08:31:31.193179	21498	20.3	1	10
2014-03-26 08:31:31.4255	21499	45	2	10
2014-03-26 08:32:10.193948	21509	20.3	1	10
2014-03-26 08:32:10.426255	21510	45	2	10
2014-03-26 08:32:49.194635	21519	20.3	1	10
2014-03-26 08:32:49.418928	21520	45	2	10
2014-03-26 08:33:28.1938	21530	20.3	1	10
2014-03-26 08:33:28.42496	21531	45	2	10
2014-03-26 08:34:07.196457	21539	20.3	1	10
2014-03-26 08:34:07.41927	21540	45	2	10
2014-03-26 08:34:46.195102	21550	20.4	1	10
2014-03-26 08:34:46.421311	21551	45	2	10
2014-03-26 08:35:25.19499	21558	20.4	1	10
2014-03-26 08:35:25.419863	21559	45	2	10
2014-03-26 08:36:04.195311	21567	20.4	1	10
2014-03-26 08:36:04.418471	21568	45	2	10
2014-03-26 08:36:43.197682	21576	20.4	1	10
2014-03-26 08:36:43.421856	21577	45	2	10
2014-03-26 08:37:22.195679	21584	20.4	1	10
2014-03-26 08:37:22.418429	21585	45	2	10
2014-03-26 08:38:01.197621	21594	20.4	1	10
2014-03-26 08:38:01.4314	21595	45	2	10
2014-03-26 08:38:40.196835	21603	20.4	1	10
2014-03-26 08:38:40.421104	21604	45	2	10
2014-03-26 08:39:19.197661	21612	20.4	1	10
2014-03-26 08:39:19.421022	21613	45	2	10
2014-03-26 08:40:00.158597	21625	21.3	1	8
2014-03-26 08:40:00.383214	21626	60	2	8
2014-03-26 08:40:15.16273	21627	20.8	1	1
2014-03-26 08:40:15.399282	21628	51	2	1
2014-03-26 08:40:32.64562	21629	466	3	2
2014-03-26 23:19:15.726667	33089	23.8	1	10
2014-03-26 23:19:15.963931	33090	41	2	10
2014-03-26 08:40:39.15829	21634	21.3	1	8
2014-03-26 08:40:39.391411	21635	60	2	8
2014-03-26 08:40:54.162578	21636	20.8	1	1
2014-03-26 08:40:54.388462	21637	51	2	1
2014-03-26 08:40:56.646111	21638	515	3	2
2014-03-26 08:41:08.643637	21639	531	3	2
2014-03-26 23:19:26.046976	33091	21.3	1	9
2014-03-26 23:19:26.269578	33092	47	2	9
2014-03-26 08:41:18.157886	21644	21.3	1	8
2014-03-26 08:41:18.380342	21645	60	2	8
2014-03-26 08:41:32.643292	21646	515	3	2
2014-03-26 08:41:33.160872	21647	20.9	1	1
2014-03-26 08:41:33.383853	21648	51	2	1
2014-03-26 23:19:27.134181	33093	21.6	1	8
2014-03-26 23:19:27.37731	33094	48	2	8
2014-03-26 08:41:57.158679	21653	21.3	1	8
2014-03-26 08:41:57.391108	21654	60	2	8
2014-03-26 08:42:12.161721	21655	20.9	1	1
2014-03-26 08:42:12.422377	21656	51	2	1
2014-03-26 08:42:32.64809	21657	515	3	2
2014-03-26 23:19:32.550415	33095	305	3	2
2014-03-26 23:19:32.775465	33096	1088841.9160712848	4	2
2014-03-26 08:42:36.156663	21662	21.3	1	8
2014-03-26 08:42:36.378627	21663	60	2	8
2014-03-26 08:42:51.162457	21664	20.9	1	1
2014-03-26 08:42:51.397415	21665	51	2	1
2014-03-26 23:19:41.647739	33097	20.1	1	1
2014-03-26 23:19:41.882388	33098	50	2	1
2014-03-26 08:43:15.159547	21670	21.3	1	8
2014-03-26 08:43:15.383168	21671	60	2	8
2014-03-26 08:43:30.16052	21672	20.9	1	1
2014-03-26 08:43:30.393597	21673	51	2	1
2014-03-26 08:43:32.647289	21674	531	3	2
2014-03-26 23:19:44.548212	33099	305	3	2
2014-03-26 23:19:44.772472	33100	1088843.0651060063	4	2
2014-03-26 08:43:54.158955	21679	21.3	1	8
2014-03-26 08:43:54.393212	21680	60	2	8
2014-03-26 08:44:09.162351	21681	20.9	1	1
2014-03-26 08:44:09.38592	21682	51	2	1
2014-03-26 23:19:54.72578	33101	23.8	1	10
2014-03-26 23:19:54.961213	33102	41	2	10
2014-03-26 08:44:32.645671	21687	515	3	2
2014-03-26 08:44:33.159582	21688	21.3	1	8
2014-03-26 08:44:33.382662	21689	60	2	8
2014-03-26 08:44:48.199499	21690	20.9	1	1
2014-03-26 08:44:48.432316	21691	51	2	1
2014-03-26 23:19:56.54575	33103	338	3	2
2014-03-26 23:19:56.771599	33104	1088844.2141407277	4	2
2014-03-26 08:45:12.158564	21696	21.3	1	8
2014-03-26 08:45:12.383675	21697	60	2	8
2014-03-26 08:45:27.159052	21698	20.9	1	1
2014-03-26 08:45:27.394273	21699	51	2	1
2014-03-26 08:45:32.646874	21700	531	3	2
2014-03-26 23:20:05.044418	33105	21.3	1	9
2014-03-26 23:20:05.279511	33106	47	2	9
2014-03-26 08:45:51.159016	21705	21.3	1	8
2014-03-26 08:45:51.388796	21706	60	2	8
2014-03-26 08:46:06.156646	21707	20.9	1	1
2014-03-26 08:46:06.378815	21708	51	2	1
2014-03-26 08:46:08.648521	21709	466	3	2
2014-03-26 08:46:20.647309	21710	466	3	2
2014-03-26 23:20:06.132787	33107	21.6	1	8
2014-03-26 23:20:06.357694	33108	48	2	8
2014-03-26 08:46:30.156571	21715	21.3	1	8
2014-03-26 08:46:30.387745	21716	60	2	8
2014-03-26 08:46:32.644261	21717	466	3	2
2014-03-26 08:46:45.158162	21718	20.9	1	1
2014-03-26 08:46:45.378977	21719	51	2	1
2014-03-26 23:20:08.552424	33109	338	3	2
2014-03-26 23:20:08.786664	33110	1088845.3631754492	4	2
2014-03-26 08:47:09.510781	21724	21.3	1	8
2014-03-26 08:47:09.733046	21725	60	2	8
2014-03-26 08:47:24.157579	21726	20.9	1	1
2014-03-26 08:47:24.388115	21727	51	2	1
2014-03-26 08:47:32.647465	21728	466	3	2
2014-03-26 23:20:20.649867	33111	20.1	1	1
2014-03-26 23:20:20.874788	33112	50	2	1
2014-03-26 08:47:48.155653	21733	21.3	1	8
2014-03-26 08:47:48.386722	21734	60	2	8
2014-03-26 08:48:03.157345	21735	20.9	1	1
2014-03-26 08:48:03.379447	21736	51	2	1
2014-03-26 23:20:32.550285	33113	338	3	2
2014-03-26 23:20:32.785463	33114	1088847.661244892	4	2
2014-03-26 08:48:27.157905	21741	21.3	1	8
2014-03-26 08:48:27.393018	21742	60	2	8
2014-03-26 08:48:32.6428	21743	466	3	2
2014-03-26 08:48:42.156187	21744	20.9	1	1
2014-03-26 08:48:42.379245	21745	51	2	1
2014-03-26 23:20:33.731067	33115	23.8	1	10
2014-03-26 23:20:33.95598	33116	41	2	10
2014-03-26 08:49:06.157116	21750	21.3	1	8
2014-03-26 08:49:06.37781	21751	60	2	8
2014-03-26 08:49:21.159582	21752	20.9	1	1
2014-03-26 08:49:21.391168	21753	51	2	1
2014-03-26 08:49:32.645652	21754	466	3	2
2014-03-26 23:20:44.044262	33117	21.3	1	9
2014-03-26 08:49:45.159095	21759	21.3	1	8
2014-03-26 08:49:45.378815	21760	60	2	8
2014-03-26 08:40:37.199381	21630	20.4	1	10
2014-03-26 08:40:37.430452	21631	45	2	10
2014-03-26 08:41:16.197477	21640	20.4	1	10
2014-03-26 08:41:16.420062	21641	45	2	10
2014-03-26 08:41:55.19699	21649	20.4	1	10
2014-03-26 08:41:55.431855	21650	45	2	10
2014-03-26 08:42:34.197823	21658	20.4	1	10
2014-03-26 08:42:34.419951	21659	45	2	10
2014-03-26 08:43:13.1966	21666	20.4	1	10
2014-03-26 08:43:13.421473	21667	45	2	10
2014-03-26 08:43:52.202051	21675	20.5	1	10
2014-03-26 08:43:52.435952	21676	45	2	10
2014-03-26 08:44:31.19884	21683	20.5	1	10
2014-03-26 08:44:31.43196	21684	45	2	10
2014-03-26 08:45:10.200661	21692	20.5	1	10
2014-03-26 08:45:10.424907	21693	45	2	10
2014-03-26 08:45:49.200774	21701	20.5	1	10
2014-03-26 08:45:49.427889	21702	45	2	10
2014-03-26 08:46:28.198822	21711	20.5	1	10
2014-03-26 08:46:28.431853	21712	45	2	10
2014-03-26 08:47:07.199255	21720	20.5	1	10
2014-03-26 08:47:07.421122	21721	45	2	10
2014-03-26 08:47:46.255253	21729	20.5	1	10
2014-03-26 08:47:46.489183	21730	45	2	10
2014-03-26 08:48:25.199623	21737	20.5	1	10
2014-03-26 08:48:25.433406	21738	45	2	10
2014-03-26 08:49:04.201382	21746	20.5	1	10
2014-03-26 08:49:04.424309	21747	45	2	10
2014-03-26 08:50:00.155031	21761	20.9	1	1
2014-03-26 08:50:00.378032	21762	51	2	1
2014-03-26 23:20:44.277819	33118	47	2	9
2014-03-26 23:20:45.131446	33119	21.6	1	8
2014-03-26 08:50:24.157882	21767	21.3	1	8
2014-03-26 08:50:24.391583	21768	60	2	8
2014-03-26 08:50:32.643218	21769	466	3	2
2014-03-26 08:50:39.152563	21770	20.9	1	1
2014-03-26 08:50:39.377313	21771	51	2	1
2014-03-26 23:20:45.356922	33120	48	2	8
2014-03-26 23:20:59.648847	33121	20.1	1	1
2014-03-26 08:51:03.156205	21776	21.3	1	8
2014-03-26 08:51:03.378692	21777	60	2	8
2014-03-26 08:51:18.16176	21778	20.9	1	1
2014-03-26 08:51:18.395621	21779	51	2	1
2014-03-26 08:51:32.645398	21780	466	3	2
2014-03-26 23:20:59.885216	33122	50	2	1
2014-03-26 23:21:08.551103	33123	402	3	2
2014-03-26 08:51:42.157489	21785	21.3	1	8
2014-03-26 08:51:42.377665	21786	60	2	8
2014-03-26 08:51:57.154078	21787	20.9	1	1
2014-03-26 08:51:57.375923	21788	51	2	1
2014-03-26 23:21:08.777796	33124	1088851.1083490562	4	2
2014-03-26 23:21:12.729437	33125	23.8	1	10
2014-03-26 08:52:21.156203	21793	21.3	1	8
2014-03-26 08:52:21.397331	21794	60	2	8
2014-03-26 08:52:32.645849	21795	482	3	2
2014-03-26 08:52:36.155005	21796	20.9	1	1
2014-03-26 08:52:36.380053	21797	51	2	1
2014-03-26 08:52:56.648826	21798	515	3	2
2014-03-26 23:21:12.963144	33126	41	2	10
2014-03-26 23:21:20.552104	33127	402	3	2
2014-03-26 08:53:00.576479	21803	21.3	1	8
2014-03-26 08:53:00.832743	21804	60	2	8
2014-03-26 08:53:08.640776	21805	515	3	2
2014-03-26 08:53:15.155411	21806	20.9	1	1
2014-03-26 08:53:15.58255	21807	51	2	1
2014-03-26 08:53:32.646965	21808	515	3	2
2014-03-26 23:21:20.778083	33128	1088852.2573837775	4	2
2014-03-26 23:21:23.044512	33129	21.3	1	9
2014-03-26 08:53:39.157017	21813	21.3	1	8
2014-03-26 08:53:39.377902	21814	60	2	8
2014-03-26 08:53:54.152635	21815	20.9	1	1
2014-03-26 08:53:54.375552	21816	51	2	1
2014-03-26 23:21:23.27823	33130	47	2	9
2014-03-26 23:21:24.132098	33131	21.6	1	8
2014-03-26 08:54:18.15649	21821	21.3	1	8
2014-03-26 08:54:18.379176	21822	60	2	8
2014-03-26 08:54:32.643788	21823	515	3	2
2014-03-26 08:54:33.155542	21824	20.9	1	1
2014-03-26 08:54:33.377142	21825	51	2	1
2014-03-26 23:21:24.363079	33132	48	2	8
2014-03-26 23:21:32.550845	33133	402	3	2
2014-03-26 08:54:57.159524	21830	21.3	1	8
2014-03-26 08:54:57.391525	21831	59	2	8
2014-03-26 08:55:12.155063	21832	20.9	1	1
2014-03-26 08:55:12.378423	21833	51	2	1
2014-03-26 08:55:32.645114	21834	498	3	2
2014-03-26 23:21:32.785113	33134	1088853.406418499	4	2
2014-03-26 23:21:38.648687	33135	20.1	1	1
2014-03-26 08:55:36.158208	21839	21.3	1	8
2014-03-26 08:55:36.380863	21840	60	2	8
2014-03-26 08:55:51.153517	21841	20.9	1	1
2014-03-26 08:55:51.836634	21842	51	2	1
2014-03-26 23:21:38.874188	33136	50	2	1
2014-03-26 23:21:51.728653	33137	23.8	1	10
2014-03-26 08:56:15.156337	21847	21.3	1	8
2014-03-26 08:56:15.37954	21848	60	2	8
2014-03-26 08:56:30.150264	21849	20.9	1	1
2014-03-26 08:56:30.384496	21850	51	2	1
2014-03-26 08:56:32.644542	21851	515	3	2
2014-03-26 23:21:51.963425	33138	41	2	10
2014-03-26 23:22:02.04539	33139	21.3	1	9
2014-03-26 08:56:54.156466	21856	21.3	1	8
2014-03-26 08:56:54.388976	21857	60	2	8
2014-03-26 08:57:09.150819	21858	20.9	1	1
2014-03-26 08:57:09.373268	21859	51	2	1
2014-03-26 23:22:02.269594	33140	47	2	9
2014-03-26 23:22:03.132738	33141	21.6	1	8
2014-03-26 08:57:32.644852	21864	515	3	2
2014-03-26 08:57:33.156993	21865	21.3	1	8
2014-03-26 08:57:33.378175	21866	60	2	8
2014-03-26 08:57:48.154452	21867	20.9	1	1
2014-03-26 08:57:48.389929	21868	51	2	1
2014-03-26 08:58:08.770001	21869	466	3	2
2014-03-26 23:22:03.377463	33142	48	2	8
2014-03-26 23:22:17.649529	33143	20.1	1	1
2014-03-26 08:58:12.159021	21874	21.3	1	8
2014-03-26 08:58:12.560055	21875	60	2	8
2014-03-26 08:58:20.64775	21876	466	3	2
2014-03-26 08:58:27.151624	21877	20.8	1	1
2014-03-26 08:58:27.374101	21878	51	2	1
2014-03-26 08:58:32.646519	21879	466	3	2
2014-03-26 23:22:17.874551	33144	50	2	1
2014-03-26 23:22:30.729392	33145	23.8	1	10
2014-03-26 08:58:51.156084	21884	21.3	1	8
2014-03-26 08:58:51.378726	21885	60	2	8
2014-03-26 08:59:06.148929	21886	20.8	1	1
2014-03-26 08:59:06.382381	21887	51	2	1
2014-03-26 23:22:30.964297	33146	41	2	10
2014-03-26 08:59:30.157264	21892	21.3	1	8
2014-03-26 08:59:30.379463	21893	59	2	8
2014-03-26 08:59:32.643012	21894	466	3	2
2014-03-26 08:59:45.153713	21895	20.8	1	1
2014-03-26 08:59:45.375879	21896	51	2	1
2014-03-26 08:50:22.204113	21763	20.5	1	10
2014-03-26 08:50:22.43621	21764	45	2	10
2014-03-26 08:51:01.200599	21772	20.5	1	10
2014-03-26 08:51:01.424497	21773	45	2	10
2014-03-26 08:51:40.200725	21781	20.5	1	10
2014-03-26 08:51:40.425356	21782	45	2	10
2014-03-26 08:52:19.200904	21789	20.5	1	10
2014-03-26 08:52:19.431135	21790	45	2	10
2014-03-26 08:52:58.201315	21799	20.5	1	10
2014-03-26 08:52:58.455779	21800	45	2	10
2014-03-26 08:53:37.201944	21809	20.5	1	10
2014-03-26 08:53:37.424092	21810	45	2	10
2014-03-26 08:54:16.201931	21817	20.6	1	10
2014-03-26 08:54:16.424149	21818	45	2	10
2014-03-26 08:54:55.200531	21826	20.6	1	10
2014-03-26 08:54:55.433331	21827	45	2	10
2014-03-26 08:55:34.203815	21835	20.6	1	10
2014-03-26 08:55:34.426351	21836	45	2	10
2014-03-26 08:56:13.202543	21843	20.6	1	10
2014-03-26 08:56:13.425841	21844	45	2	10
2014-03-26 08:56:52.20347	21852	20.6	1	10
2014-03-26 08:56:52.428149	21853	45	2	10
2014-03-26 08:57:31.202958	21860	20.6	1	10
2014-03-26 08:57:31.436082	21861	45	2	10
2014-03-26 08:58:10.205723	21870	20.6	1	10
2014-03-26 08:58:10.434671	21871	45	2	10
2014-03-26 08:58:49.203114	21880	20.6	1	10
2014-03-26 08:58:49.426591	21881	45	2	10
2014-03-26 23:22:32.547549	33147	402	3	2
2014-03-26 23:22:32.774639	33148	1088860.3006268274	4	2
2014-03-26 09:00:09.156974	21901	21.3	1	8
2014-03-26 09:00:09.387774	21902	60	2	8
2014-03-26 09:00:24.15074	21903	20.8	1	1
2014-03-26 09:00:24.37351	21904	51	2	1
2014-03-26 09:00:32.64451	21905	482	3	2
2014-03-26 09:00:44.643114	21906	450	3	2
2014-03-26 23:22:41.043305	33149	21.3	1	9
2014-03-26 23:22:41.281859	33150	47	2	9
2014-03-26 09:00:48.159183	21911	21.3	1	8
2014-03-26 09:00:48.384468	21912	60	2	8
2014-03-26 09:00:56.642713	21913	466	3	2
2014-03-26 09:01:03.151466	21914	20.8	1	1
2014-03-26 09:01:03.375445	21915	51	2	1
2014-03-26 23:22:42.133364	33151	21.6	1	8
2014-03-26 23:22:42.356429	33152	48	2	8
2014-03-26 09:01:27.156698	21920	21.3	1	8
2014-03-26 09:01:27.392092	21921	59	2	8
2014-03-26 09:01:32.64013	21922	466	3	2
2014-03-26 09:01:42.151627	21923	20.8	1	1
2014-03-26 09:01:42.376098	21924	51	2	1
2014-03-26 23:22:56.645425	33153	20.1	1	1
2014-03-26 23:22:56.883251	33154	50	2	1
2014-03-26 09:02:06.503598	21929	21.2	1	8
2014-03-26 09:02:06.726844	21930	60	2	8
2014-03-26 09:02:21.144678	21931	20.8	1	1
2014-03-26 09:02:21.379125	21932	51	2	1
2014-03-26 09:02:32.645881	21933	482	3	2
2014-03-26 23:23:09.731036	33155	23.8	1	10
2014-03-26 23:23:09.95607	33156	41	2	10
2014-03-26 09:02:44.638706	21938	579	3	2
2014-03-26 09:02:45.15571	21939	21.3	1	8
2014-03-26 09:02:45.389843	21940	60	2	8
2014-03-26 09:02:56.644665	21941	595	3	2
2014-03-26 09:03:00.148006	21942	20.8	1	1
2014-03-26 09:03:00.369595	21943	51	2	1
2014-03-26 23:23:20.044082	33157	21.3	1	9
2014-03-26 23:23:20.278239	33158	47	2	9
2014-03-26 09:03:24.155238	21948	21.3	1	8
2014-03-26 09:03:24.376941	21949	60	2	8
2014-03-26 09:03:32.645173	21950	595	3	2
2014-03-26 09:03:39.145652	21951	20.8	1	1
2014-03-26 09:03:39.368109	21952	51	2	1
2014-03-26 23:23:21.131702	33159	21.6	1	8
2014-03-26 23:23:21.356346	33160	48	2	8
2014-03-26 09:04:03.155421	21957	21.3	1	8
2014-03-26 09:04:03.378098	21958	59	2	8
2014-03-26 09:04:18.147317	21959	20.8	1	1
2014-03-26 09:04:18.396882	21960	51	2	1
2014-03-26 09:04:20.644292	21961	531	3	2
2014-03-26 09:04:32.644743	21962	531	3	2
2014-03-26 23:23:32.549608	33161	402	3	2
2014-03-26 23:23:32.783624	33162	1088867.194835156	4	2
2014-03-26 09:04:42.156502	21967	21.3	1	8
2014-03-26 09:04:42.378669	21968	59	2	8
2014-03-26 09:04:56.640353	21969	579	3	2
2014-03-26 09:04:57.184271	21970	20.8	1	1
2014-03-26 09:04:57.406805	21971	51	2	1
2014-03-26 09:05:08.647392	21972	579	3	2
2014-03-26 23:23:35.64608	33163	20.1	1	1
2014-03-26 23:23:35.881857	33164	50	2	1
2014-03-26 09:05:21.157557	21977	21.3	1	8
2014-03-26 09:05:21.379487	21978	59	2	8
2014-03-26 09:05:32.644015	21979	579	3	2
2014-03-26 09:05:36.145273	21980	20.8	1	1
2014-03-26 09:05:36.366766	21981	51	2	1
2014-03-26 23:23:48.728522	33165	23.7	1	10
2014-03-26 23:23:48.965728	33166	41	2	10
2014-03-26 09:06:00.15757	21986	21.3	1	8
2014-03-26 09:06:00.3892	21987	59	2	8
2014-03-26 09:06:15.147234	21988	20.8	1	1
2014-03-26 09:06:15.370876	21989	51	2	1
2014-03-26 09:06:32.640285	21990	579	3	2
2014-03-26 23:23:59.04484	33167	21.3	1	9
2014-03-26 23:23:59.268993	33168	47	2	9
2014-03-26 09:06:39.155821	21995	21.3	1	8
2014-03-26 09:06:39.380326	21996	59	2	8
2014-03-26 09:06:54.143932	21997	20.8	1	1
2014-03-26 09:06:54.381056	21998	51	2	1
2014-03-26 23:24:00.13356	33169	21.6	1	8
2014-03-26 23:24:00.366778	33170	48	2	8
2014-03-26 09:07:18.157331	22003	21.3	1	8
2014-03-26 09:07:18.38757	22004	59	2	8
2014-03-26 09:07:32.6438	22005	579	3	2
2014-03-26 09:07:33.149161	22006	20.8	1	1
2014-03-26 09:07:33.391909	22007	51	2	1
2014-03-26 23:24:14.646587	33171	20.1	1	1
2014-03-26 23:24:14.871833	33172	50	2	1
2014-03-26 09:07:57.15569	22012	21.3	1	8
2014-03-26 09:07:57.388811	22013	59	2	8
2014-03-26 09:08:12.145595	22014	20.7	1	1
2014-03-26 09:08:12.369655	22015	51	2	1
2014-03-26 09:08:34.00439	22016	579	3	2
2014-03-26 23:24:27.730652	33173	23.7	1	10
2014-03-26 23:24:27.965198	33174	41	2	10
2014-03-26 09:08:36.156015	22021	21.3	1	8
2014-03-26 09:08:36.376759	22022	59	2	8
2014-03-26 09:08:51.145974	22023	20.7	1	1
2014-03-26 09:08:51.376605	22024	51	2	1
2014-03-26 23:24:32.54734	33175	402	3	2
2014-03-26 09:09:15.155678	22029	21.3	1	8
2014-03-26 09:09:15.376631	22030	59	2	8
2014-03-26 09:09:30.144891	22031	20.7	1	1
2014-03-26 09:09:30.379283	22032	51	2	1
2014-03-26 09:00:07.204217	21897	20.6	1	10
2014-03-26 09:00:07.43982	21898	45	2	10
2014-03-26 09:00:46.205866	21907	20.6	1	10
2014-03-26 09:00:46.427565	21908	45	2	10
2014-03-26 09:01:25.205603	21916	20.6	1	10
2014-03-26 09:01:25.437964	21917	45	2	10
2014-03-26 09:02:04.203474	21925	20.6	1	10
2014-03-26 09:02:04.428818	21926	45	2	10
2014-03-26 09:02:43.204562	21934	20.6	1	10
2014-03-26 09:02:43.428604	21935	45	2	10
2014-03-26 09:03:22.203978	21944	20.6	1	10
2014-03-26 09:03:22.426659	21945	45	2	10
2014-03-26 09:04:01.204702	21953	20.6	1	10
2014-03-26 09:04:01.427009	21954	45	2	10
2014-03-26 09:04:40.20554	21963	20.6	1	10
2014-03-26 09:04:40.429424	21964	45	2	10
2014-03-26 09:05:19.205425	21973	20.7	1	10
2014-03-26 09:05:19.428008	21974	45	2	10
2014-03-26 09:05:58.206072	21982	20.7	1	10
2014-03-26 09:05:58.438044	21983	45	2	10
2014-03-26 09:06:37.206722	21991	20.7	1	10
2014-03-26 09:06:37.429553	21992	45	2	10
2014-03-26 09:07:16.205574	21999	20.7	1	10
2014-03-26 09:07:16.430449	22000	45	2	10
2014-03-26 09:07:55.207095	22008	20.7	1	10
2014-03-26 09:07:55.442169	22009	45	2	10
2014-03-26 09:08:34.333068	22017	20.7	1	10
2014-03-26 09:08:34.556532	22018	45	2	10
2014-03-26 09:09:32.644745	22033	579	3	2
2014-03-26 23:24:32.771769	33176	1088874.0890434845	4	2
2014-03-26 23:24:38.045919	33177	21.3	1	9
2014-03-26 09:09:54.155305	22038	21.3	1	8
2014-03-26 09:09:54.379021	22039	59	2	8
2014-03-26 09:10:08.641212	22040	531	3	2
2014-03-26 09:10:09.147836	22041	20.7	1	1
2014-03-26 09:10:09.369136	22042	51	2	1
2014-03-26 09:10:20.642156	22043	531	3	2
2014-03-26 23:24:38.281088	33178	47	2	9
2014-03-26 23:24:39.135326	33179	21.6	1	8
2014-03-26 09:10:33.049344	22048	531	3	2
2014-03-26 09:10:33.356887	22049	21.3	1	8
2014-03-26 09:10:33.577976	22050	59	2	8
2014-03-26 09:10:44.63882	22051	595	3	2
2014-03-26 09:10:48.142812	22052	20.7	1	1
2014-03-26 09:10:48.367237	22053	52	2	1
2014-03-26 09:10:56.641778	22054	595	3	2
2014-03-26 09:11:08.645324	22055	434	3	2
2014-03-26 23:24:39.358475	33180	48	2	8
2014-03-26 23:24:53.646981	33181	20.1	1	1
2014-03-26 09:11:12.158496	22060	21.3	1	8
2014-03-26 09:11:12.400057	22061	59	2	8
2014-03-26 09:11:20.641868	22062	434	3	2
2014-03-26 09:11:27.142746	22063	20.7	1	1
2014-03-26 09:11:27.366106	22064	52	2	1
2014-03-26 09:11:32.64459	22065	434	3	2
2014-03-26 23:24:53.881426	33182	50	2	1
2014-03-26 23:25:06.730518	33183	23.7	1	10
2014-03-26 09:11:51.158295	22070	21.3	1	8
2014-03-26 09:11:51.382603	22071	59	2	8
2014-03-26 09:12:06.140269	22072	20.7	1	1
2014-03-26 09:12:06.376152	22073	52	2	1
2014-03-26 23:25:06.957067	33184	41	2	10
2014-03-26 23:25:17.04422	33185	21.3	1	9
2014-03-26 09:12:30.157069	22078	21.3	1	8
2014-03-26 09:12:30.380853	22079	59	2	8
2014-03-26 09:12:32.642584	22080	434	3	2
2014-03-26 09:12:45.141284	22081	20.7	1	1
2014-03-26 09:12:45.366573	22082	52	2	1
2014-03-26 23:25:17.279543	33186	47	2	9
2014-03-26 23:25:18.135173	33187	21.6	1	8
2014-03-26 09:13:09.156676	22087	21.3	1	8
2014-03-26 09:13:09.388662	22088	58	2	8
2014-03-26 09:13:24.139331	22089	20.7	1	1
2014-03-26 09:13:24.362809	22090	52	2	1
2014-03-26 09:13:32.640847	22091	450	3	2
2014-03-26 23:25:18.359073	33188	48	2	8
2014-03-26 23:25:32.886636	33189	20.1	1	1
2014-03-26 09:13:48.156335	22096	21.3	1	8
2014-03-26 09:13:48.378034	22097	58	2	8
2014-03-26 09:14:03.380851	22098	20.7	1	1
2014-03-26 09:14:03.61474	22099	52	2	1
2014-03-26 23:25:33.133382	33190	50	2	1
2014-03-26 23:25:45.937439	33191	23.7	1	10
2014-03-26 09:14:27.157265	22104	21.3	1	8
2014-03-26 09:14:27.380981	22105	58	2	8
2014-03-26 09:14:32.641292	22106	434	3	2
2014-03-26 09:14:42.142498	22107	20.7	1	1
2014-03-26 09:14:42.366523	22108	52	2	1
2014-03-26 23:25:46.162156	33192	41	2	10
2014-03-26 23:25:56.043477	33193	21.3	1	9
2014-03-26 09:15:06.156004	22113	21.3	1	8
2014-03-26 09:15:06.387894	22114	58	2	8
2014-03-26 09:15:21.379717	22115	20.7	1	1
2014-03-26 09:15:21.604163	22116	52	2	1
2014-03-26 09:15:32.64283	22117	434	3	2
2014-03-26 23:25:56.279756	33194	47	2	9
2014-03-26 23:25:57.132493	33195	21.6	1	8
2014-03-26 09:15:45.155845	22122	21.3	1	8
2014-03-26 09:15:45.378754	22123	58	2	8
2014-03-26 09:16:00.137738	22124	20.7	1	1
2014-03-26 09:16:00.371646	22125	52	2	1
2014-03-26 23:25:57.359	33196	48	2	8
2014-03-26 23:26:08.548704	33197	450	3	2
2014-03-26 09:16:24.156333	22130	21.3	1	8
2014-03-26 09:16:24.379564	22131	58	2	8
2014-03-26 09:16:32.642199	22132	434	3	2
2014-03-26 09:16:39.139436	22133	20.7	1	1
2014-03-26 09:16:39.362139	22134	52	2	1
2014-03-26 09:16:56.642354	22135	466	3	2
2014-03-26 23:26:08.785535	33198	1088884.4303559773	4	2
2014-03-26 23:26:11.64536	33199	20.1	1	1
2014-03-26 09:17:03.485265	22140	21.3	1	8
2014-03-26 09:17:03.718058	22141	58	2	8
2014-03-26 09:17:08.640781	22142	482	3	2
2014-03-26 09:17:18.139074	22143	20.7	1	1
2014-03-26 09:17:18.363024	22144	52	2	1
2014-03-26 09:17:32.645757	22145	482	3	2
2014-03-26 23:26:11.871063	33200	50	2	1
2014-03-26 23:26:20.550044	33201	450	3	2
2014-03-26 09:17:42.157869	22150	21.3	1	8
2014-03-26 09:17:42.382215	22151	58	2	8
2014-03-26 09:17:57.139151	22152	20.7	1	1
2014-03-26 09:17:57.38451	22153	52	2	1
2014-03-26 23:26:20.783988	33202	1088886.7284254201	4	2
2014-03-26 23:26:24.7847	33203	23.7	1	10
2014-03-26 09:18:20.638763	22158	531	3	2
2014-03-26 09:18:21.158703	22159	21.2	1	8
2014-03-26 09:18:21.384277	22160	58	2	8
2014-03-26 09:18:32.642868	22161	515	3	2
2014-03-26 09:18:36.138256	22162	20.7	1	1
2014-03-26 09:18:36.361034	22163	52	2	1
2014-03-26 23:26:25.0089	33204	41	2	10
2014-03-26 09:19:00.156766	22168	21.2	1	8
2014-03-26 09:09:52.206485	22034	20.7	1	10
2014-03-26 09:09:52.429033	22035	45	2	10
2014-03-26 09:10:31.207639	22044	20.7	1	10
2014-03-26 09:10:31.430536	22045	45	2	10
2014-03-26 09:11:10.208189	22056	20.7	1	10
2014-03-26 09:11:10.438741	22057	45	2	10
2014-03-26 09:11:49.211354	22066	20.7	1	10
2014-03-26 09:11:49.435416	22067	45	2	10
2014-03-26 09:12:28.209302	22074	20.7	1	10
2014-03-26 09:12:28.434258	22075	45	2	10
2014-03-26 09:13:07.208785	22083	20.7	1	10
2014-03-26 09:13:07.433588	22084	45	2	10
2014-03-26 09:13:46.208538	22092	20.7	1	10
2014-03-26 09:13:46.431875	22093	45	2	10
2014-03-26 09:14:25.209474	22100	20.7	1	10
2014-03-26 09:14:25.434969	22101	45	2	10
2014-03-26 09:15:04.209996	22109	20.7	1	10
2014-03-26 09:15:04.434991	22110	45	2	10
2014-03-26 09:15:43.209754	22118	20.7	1	10
2014-03-26 09:15:43.432853	22119	45	2	10
2014-03-26 09:16:22.209359	22126	20.7	1	10
2014-03-26 09:16:22.432392	22127	45	2	10
2014-03-26 09:17:01.212109	22136	20.7	1	10
2014-03-26 09:17:01.447892	22137	45	2	10
2014-03-26 09:17:40.210297	22146	20.7	1	10
2014-03-26 09:17:40.436798	22147	45	2	10
2014-03-26 09:18:19.211496	22154	20.7	1	10
2014-03-26 09:18:19.436056	22155	45	2	10
2014-03-26 09:19:00.379541	22169	58	2	8
2014-03-26 09:19:15.142637	22170	20.7	1	1
2014-03-26 09:19:15.37527	22171	52	2	1
2014-03-26 09:19:32.642955	22172	531	3	2
2014-03-26 23:26:32.55043	33205	450	3	2
2014-03-26 23:26:32.788254	33206	1088887.8774601414	4	2
2014-03-26 09:19:39.155666	22177	21.2	1	8
2014-03-26 09:19:39.376612	22178	58	2	8
2014-03-26 09:19:54.13777	22179	20.7	1	1
2014-03-26 09:19:54.360277	22180	52	2	1
2014-03-26 23:26:35.044307	33207	21.3	1	9
2014-03-26 23:26:35.268688	33208	47	2	9
2014-03-26 09:20:18.156857	22185	21.2	1	8
2014-03-26 09:20:18.388843	22186	58	2	8
2014-03-26 09:20:32.642335	22187	531	3	2
2014-03-26 09:20:33.132889	22188	20.7	1	1
2014-03-26 09:20:33.355337	22189	52	2	1
2014-03-26 23:26:36.132755	33209	21.6	1	8
2014-03-26 23:26:36.368897	33210	48	2	8
2014-03-26 09:20:57.155755	22194	21.2	1	8
2014-03-26 09:20:57.378234	22195	58	2	8
2014-03-26 09:21:12.135161	22196	20.7	1	1
2014-03-26 09:21:12.380022	22197	52	2	1
2014-03-26 09:21:32.642925	22198	531	3	2
2014-03-26 23:26:50.644528	33211	20.1	1	1
2014-03-26 23:26:50.867666	33212	50	2	1
2014-03-26 09:21:36.157928	22203	21.2	1	8
2014-03-26 09:21:36.379033	22204	58	2	8
2014-03-26 09:21:44.641615	22205	482	3	2
2014-03-26 09:21:51.378764	22206	20.7	1	1
2014-03-26 09:21:51.600549	22207	52	2	1
2014-03-26 09:21:56.643063	22208	466	3	2
2014-03-26 23:27:03.730561	33213	23.7	1	10
2014-03-26 23:27:03.965121	33214	41	2	10
2014-03-26 09:22:15.157586	22213	21.2	1	8
2014-03-26 09:22:15.400024	22214	58	2	8
2014-03-26 09:22:30.135448	22215	20.7	1	1
2014-03-26 09:22:30.367199	22216	52	2	1
2014-03-26 09:22:32.64226	22217	498	3	2
2014-03-26 09:22:44.642482	22218	515	3	2
2014-03-26 23:27:14.045034	33215	21.3	1	9
2014-03-26 23:27:14.269658	33216	47	2	9
2014-03-26 09:22:54.155449	22223	21.2	1	8
2014-03-26 09:22:54.391004	22224	58	2	8
2014-03-26 09:23:09.137333	22225	20.6	1	1
2014-03-26 09:23:09.362771	22226	52	2	1
2014-03-26 23:27:15.132696	33217	21.6	1	8
2014-03-26 23:27:15.367905	33218	48	2	8
2014-03-26 09:23:32.642375	22231	515	3	2
2014-03-26 09:23:33.155938	22232	21.2	1	8
2014-03-26 09:23:33.383448	22233	58	2	8
2014-03-26 09:23:48.135886	22234	20.6	1	1
2014-03-26 09:23:48.367473	22235	52	2	1
2014-03-26 23:27:29.645275	33219	20.1	1	1
2014-03-26 23:27:29.877921	33220	50	2	1
2014-03-26 09:24:12.156024	22240	21.2	1	8
2014-03-26 09:24:12.37736	22241	58	2	8
2014-03-26 09:24:27.134642	22242	20.6	1	1
2014-03-26 09:24:27.37745	22243	52	2	1
2014-03-26 09:24:49.011234	22244	515	3	2
2014-03-26 23:27:32.551886	33221	450	3	2
2014-03-26 23:27:32.786569	33222	1088894.77166847	4	2
2014-03-26 09:24:51.155786	22249	21.2	1	8
2014-03-26 09:24:51.385818	22250	58	2	8
2014-03-26 09:25:06.134145	22251	20.6	1	1
2014-03-26 09:25:06.355819	22252	52	2	1
2014-03-26 23:27:42.732377	33223	23.7	1	10
2014-03-26 23:27:42.959779	33224	41	2	10
2014-03-26 09:25:30.155998	22257	21.2	1	8
2014-03-26 09:25:30.388329	22258	58	2	8
2014-03-26 09:25:32.64142	22259	515	3	2
2014-03-26 09:25:45.135829	22260	20.6	1	1
2014-03-26 09:25:45.358298	22261	52	2	1
2014-03-26 23:27:53.044224	33225	21.3	1	9
2014-03-26 23:27:53.278306	33226	47	2	9
2014-03-26 09:26:09.157693	22266	21.2	1	8
2014-03-26 09:26:09.382417	22267	59	2	8
2014-03-26 09:26:24.135776	22268	20.6	1	1
2014-03-26 09:26:24.368046	22269	52	2	1
2014-03-26 09:26:32.63965	22270	515	3	2
2014-03-26 23:27:54.133267	33227	21.6	1	8
2014-03-26 23:27:54.356676	33228	48	2	8
2014-03-26 09:26:48.155388	22275	21.2	1	8
2014-03-26 09:26:48.378654	22276	58	2	8
2014-03-26 09:27:03.135214	22277	20.6	1	1
2014-03-26 09:27:03.360734	22278	52	2	1
2014-03-26 23:28:08.640812	33229	20.1	1	1
2014-03-26 23:28:08.879004	33230	50	2	1
2014-03-26 09:27:27.483832	22283	21.2	1	8
2014-03-26 09:27:27.715002	22284	58	2	8
2014-03-26 09:27:32.642695	22285	515	3	2
2014-03-26 09:27:42.136086	22286	20.6	1	1
2014-03-26 09:27:42.362245	22287	52	2	1
2014-03-26 23:28:21.73535	33231	23.7	1	10
2014-03-26 23:28:21.96018	33232	41	2	10
2014-03-26 09:28:06.155806	22292	21.2	1	8
2014-03-26 09:28:06.380086	22293	58	2	8
2014-03-26 09:28:08.639662	22294	450	3	2
2014-03-26 09:28:20.641067	22295	515	3	2
2014-03-26 09:28:21.135092	22296	20.6	1	1
2014-03-26 09:28:21.359912	22297	52	2	1
2014-03-26 09:28:32.638807	22298	515	3	2
2014-03-26 23:28:32.043306	33233	21.3	1	9
2014-03-26 09:28:45.156348	22303	21.2	1	8
2014-03-26 09:28:45.390272	22304	58	2	8
2014-03-26 09:19:37.210951	22173	20.7	1	10
2014-03-26 09:19:37.433447	22174	45	2	10
2014-03-26 09:20:16.210142	22181	20.7	1	10
2014-03-26 09:20:16.433714	22182	45	2	10
2014-03-26 09:20:55.211445	22190	20.7	1	10
2014-03-26 09:20:55.434135	22191	45	2	10
2014-03-26 09:21:34.212364	22199	20.7	1	10
2014-03-26 09:21:34.436438	22200	45	2	10
2014-03-26 09:22:13.211647	22209	20.7	1	10
2014-03-26 09:22:13.434536	22210	45	2	10
2014-03-26 09:22:52.21354	22219	20.7	1	10
2014-03-26 09:22:52.448148	22220	45	2	10
2014-03-26 09:23:31.211804	22227	20.7	1	10
2014-03-26 09:23:31.446249	22228	45	2	10
2014-03-26 09:24:10.21421	22236	20.7	1	10
2014-03-26 09:24:10.437452	22237	45	2	10
2014-03-26 09:24:49.319033	22245	20.7	1	10
2014-03-26 09:24:49.541499	22246	44	2	10
2014-03-26 09:25:28.211632	22253	20.7	1	10
2014-03-26 09:25:28.444038	22254	44	2	10
2014-03-26 09:26:07.214141	22262	20.7	1	10
2014-03-26 09:26:07.436973	22263	44	2	10
2014-03-26 09:26:46.212366	22271	20.7	1	10
2014-03-26 09:26:46.435011	22272	44	2	10
2014-03-26 09:27:25.212735	22279	20.7	1	10
2014-03-26 09:27:25.445498	22280	44	2	10
2014-03-26 09:28:04.216344	22288	20.7	1	10
2014-03-26 09:28:04.439502	22289	44	2	10
2014-03-26 09:29:00.133502	22305	20.6	1	1
2014-03-26 09:29:00.359775	22306	52	2	1
2014-03-26 23:28:32.277551	33234	47	2	9
2014-03-26 23:28:32.587561	33235	450	3	2
2014-03-26 09:29:24.154191	22311	21.2	1	8
2014-03-26 09:29:24.385825	22312	58	2	8
2014-03-26 09:29:32.640959	22313	515	3	2
2014-03-26 09:29:39.132566	22314	20.6	1	1
2014-03-26 09:29:39.355855	22315	52	2	1
2014-03-26 23:28:32.814151	33236	1088902.8149115199	4	2
2014-03-26 23:28:33.133685	33237	21.6	1	8
2014-03-26 09:30:03.155564	22320	21.2	1	8
2014-03-26 09:30:03.37878	22321	58	2	8
2014-03-26 09:30:18.131808	22322	20.6	1	1
2014-03-26 09:30:18.363329	22323	52	2	1
2014-03-26 09:30:32.644369	22324	515	3	2
2014-03-26 23:28:33.378122	33238	48	2	8
2014-03-26 23:28:47.641447	33239	20.1	1	1
2014-03-26 09:30:42.155999	22329	21.2	1	8
2014-03-26 09:30:42.388255	22330	58	2	8
2014-03-26 09:30:57.132034	22331	20.6	1	1
2014-03-26 09:30:57.355481	22332	52	2	1
2014-03-26 23:28:47.866687	33240	50	2	1
2014-03-26 23:29:00.730249	33241	23.7	1	10
2014-03-26 09:31:21.15517	22337	21.2	1	8
2014-03-26 09:31:21.386993	22338	58	2	8
2014-03-26 09:31:32.639455	22339	515	3	2
2014-03-26 09:31:36.131936	22340	20.6	1	1
2014-03-26 09:31:36.353957	22341	52	2	1
2014-03-26 23:29:01.171765	33242	41	2	10
2014-03-26 23:29:11.043029	33243	21.3	1	9
2014-03-26 09:32:00.492207	22346	21.2	1	8
2014-03-26 09:32:00.714715	22347	58	2	8
2014-03-26 09:32:15.129765	22348	20.6	1	1
2014-03-26 09:32:15.360669	22349	52	2	1
2014-03-26 09:32:32.642543	22350	482	3	2
2014-03-26 23:29:11.266975	33244	47	2	9
2014-03-26 23:29:12.131589	33245	21.6	1	8
2014-03-26 09:32:39.15637	22355	21.2	1	8
2014-03-26 09:32:39.378194	22356	58	2	8
2014-03-26 09:32:44.642702	22357	434	3	2
2014-03-26 09:32:54.129683	22358	20.6	1	1
2014-03-26 09:32:54.353574	22359	52	2	1
2014-03-26 09:32:56.642363	22360	450	3	2
2014-03-26 09:33:08.639162	22361	370	3	2
2014-03-26 23:29:12.354315	33246	48	2	8
2014-03-26 23:29:26.643507	33247	20.1	1	1
2014-03-26 09:33:18.157603	22366	21.2	1	8
2014-03-26 09:33:18.379615	22367	58	2	8
2014-03-26 09:33:20.64374	22368	402	3	2
2014-03-26 09:33:32.640596	22369	402	3	2
2014-03-26 09:33:33.128835	22370	20.6	1	1
2014-03-26 09:33:33.353601	22371	52	2	1
2014-03-26 23:29:26.876805	33248	50	2	1
2014-03-26 23:29:32.547958	33249	450	3	2
2014-03-26 09:33:57.155479	22376	21.2	1	8
2014-03-26 09:33:57.38968	22377	58	2	8
2014-03-26 09:34:08.642087	22378	434	3	2
2014-03-26 09:34:12.126022	22379	20.6	1	1
2014-03-26 09:34:12.350342	22380	52	2	1
2014-03-26 09:34:20.640898	22381	434	3	2
2014-03-26 09:34:32.637966	22382	418	3	2
2014-03-26 23:29:32.771507	33250	1088910.8581545698	4	2
2014-03-26 23:29:39.730254	33251	23.7	1	10
2014-03-26 09:34:36.155738	22387	21.2	1	8
2014-03-26 09:34:36.39031	22388	58	2	8
2014-03-26 09:34:51.130775	22389	20.6	1	1
2014-03-26 09:34:51.353278	22390	52	2	1
2014-03-26 23:29:39.966308	33252	41	2	10
2014-03-26 23:29:50.04481	33253	21.3	1	9
2014-03-26 09:35:15.156006	22395	21.2	1	8
2014-03-26 09:35:15.388829	22396	58	2	8
2014-03-26 09:35:30.131386	22397	20.6	1	1
2014-03-26 09:35:30.353215	22398	52	2	1
2014-03-26 09:35:32.63926	22399	418	3	2
2014-03-26 23:29:50.267571	33254	47	2	9
2014-03-26 23:29:51.132869	33255	21.6	1	8
2014-03-26 09:35:54.155067	22404	21.2	1	8
2014-03-26 09:35:54.378008	22405	58	2	8
2014-03-26 09:36:09.129435	22406	20.5	1	1
2014-03-26 09:36:09.361305	22407	52	2	1
2014-03-26 23:29:51.364725	33256	48	2	8
2014-03-26 23:30:05.64214	33257	20.1	1	1
2014-03-26 09:36:32.956014	22412	418	3	2
2014-03-26 09:36:33.262318	22413	21.2	1	8
2014-03-26 09:36:33.484446	22414	58	2	8
2014-03-26 09:36:48.126142	22415	20.5	1	1
2014-03-26 09:36:48.348726	22416	52	2	1
2014-03-26 23:30:05.865425	33258	50	2	1
2014-03-26 23:30:18.732003	33259	23.6	1	10
2014-03-26 09:37:12.480874	22421	21.1	1	8
2014-03-26 09:37:12.703068	22422	58	2	8
2014-03-26 09:37:27.125906	22423	20.5	1	1
2014-03-26 09:37:27.349509	22424	52	2	1
2014-03-26 09:37:32.63939	22425	418	3	2
2014-03-26 23:30:18.967944	33260	41	2	10
2014-03-26 23:30:29.04431	33261	21.3	1	9
2014-03-26 09:37:51.155097	22430	21.1	1	8
2014-03-26 09:37:51.376845	22431	58	2	8
2014-03-26 09:38:06.12658	22432	20.5	1	1
2014-03-26 09:38:06.358272	22433	52	2	1
2014-03-26 09:38:08.640137	22434	450	3	2
2014-03-26 09:38:20.638864	22435	418	3	2
2014-03-26 23:30:29.268528	33262	47	2	9
2014-03-26 09:38:30.156766	22440	21.1	1	8
2014-03-26 09:29:22.213815	22307	20.7	1	10
2014-03-26 09:29:22.448608	22308	44	2	10
2014-03-26 09:30:01.213338	22316	20.7	1	10
2014-03-26 09:30:01.436617	22317	44	2	10
2014-03-26 09:30:40.215236	22325	20.7	1	10
2014-03-26 09:30:40.437311	22326	44	2	10
2014-03-26 09:31:19.216838	22333	20.7	1	10
2014-03-26 09:31:19.461065	22334	44	2	10
2014-03-26 09:31:58.216159	22342	20.7	1	10
2014-03-26 09:31:58.441195	22343	44	2	10
2014-03-26 09:32:37.222677	22351	20.7	1	10
2014-03-26 09:32:37.450898	22352	44	2	10
2014-03-26 09:33:16.217081	22362	20.7	1	10
2014-03-26 09:33:16.440221	22363	44	2	10
2014-03-26 09:33:55.215294	22372	20.7	1	10
2014-03-26 09:33:55.449703	22373	44	2	10
2014-03-26 09:34:34.214091	22383	20.7	1	10
2014-03-26 09:34:34.448456	22384	44	2	10
2014-03-26 09:35:13.215802	22391	20.7	1	10
2014-03-26 09:35:13.446522	22392	44	2	10
2014-03-26 09:35:52.215446	22400	20.6	1	10
2014-03-26 09:35:52.442892	22401	44	2	10
2014-03-26 09:36:31.217714	22408	20.6	1	10
2014-03-26 09:36:31.441612	22409	44	2	10
2014-03-26 09:37:10.215914	22417	20.6	1	10
2014-03-26 09:37:10.439143	22418	44	2	10
2014-03-26 09:37:49.217646	22426	20.6	1	10
2014-03-26 09:37:49.441258	22427	44	2	10
2014-03-26 09:38:30.389199	22441	58	2	8
2014-03-26 09:38:32.639658	22442	434	3	2
2014-03-26 09:38:45.129082	22443	20.5	1	1
2014-03-26 09:38:45.353837	22444	52	2	1
2014-03-26 23:30:30.133267	33263	21.6	1	8
2014-03-26 23:30:30.374404	33264	48	2	8
2014-03-26 09:39:09.154575	22449	21.1	1	8
2014-03-26 09:39:09.378166	22450	58	2	8
2014-03-26 09:39:24.124096	22451	20.5	1	1
2014-03-26 09:39:24.348926	22452	52	2	1
2014-03-26 09:39:32.640586	22453	434	3	2
2014-03-26 09:39:44.639481	22454	466	3	2
2014-03-26 23:30:32.549202	33265	434	3	2
2014-03-26 23:30:32.772046	33266	1088917.7523628983	4	2
2014-03-26 09:39:48.154918	22459	21.1	1	8
2014-03-26 09:39:48.390365	22460	58	2	8
2014-03-26 09:39:56.638882	22461	466	3	2
2014-03-26 09:40:03.124346	22462	20.5	1	1
2014-03-26 09:40:03.34649	22463	52	2	1
2014-03-26 23:30:44.641466	33267	20.1	1	1
2014-03-26 23:30:44.875528	33268	50	2	1
2014-03-26 09:40:27.159776	22468	21.1	1	8
2014-03-26 09:40:27.381886	22469	58	2	8
2014-03-26 09:40:32.640728	22470	466	3	2
2014-03-26 09:40:42.1231	22471	20.5	1	1
2014-03-26 09:40:42.345979	22472	52	2	1
2014-03-26 23:30:56.549861	33269	402	3	2
2014-03-26 23:30:56.774064	33270	1088921.1994670625	4	2
2014-03-26 09:41:06.154375	22477	21.1	1	8
2014-03-26 09:41:06.375053	22478	58	2	8
2014-03-26 09:41:21.128996	22479	20.5	1	1
2014-03-26 09:41:21.359122	22480	52	2	1
2014-03-26 09:41:32.637848	22481	466	3	2
2014-03-26 23:30:57.73097	33271	23.6	1	10
2014-03-26 23:30:57.966076	33272	41	2	10
2014-03-26 09:41:45.154505	22486	21.1	1	8
2014-03-26 09:41:45.385152	22487	58	2	8
2014-03-26 09:42:00.126365	22488	20.5	1	1
2014-03-26 09:42:00.348868	22489	52	2	1
2014-03-26 23:31:08.043891	33273	21.3	1	9
2014-03-26 23:31:08.271517	33274	47	2	9
2014-03-26 09:42:24.155279	22494	21.1	1	8
2014-03-26 09:42:24.387105	22495	58	2	8
2014-03-26 09:42:32.636438	22496	466	3	2
2014-03-26 09:42:39.122255	22497	20.5	1	1
2014-03-26 09:42:39.345021	22498	52	2	1
2014-03-26 23:31:08.578536	33275	402	3	2
2014-03-26 23:31:08.811715	33276	1088922.348501784	4	2
2014-03-26 09:43:03.15453	22503	21.1	1	8
2014-03-26 09:43:03.376097	22504	58	2	8
2014-03-26 09:43:18.125777	22505	20.5	1	1
2014-03-26 09:43:18.356521	22506	52	2	1
2014-03-26 09:43:32.637768	22507	466	3	2
2014-03-26 23:31:09.133191	33277	21.6	1	8
2014-03-26 23:31:09.358033	33278	48	2	8
2014-03-26 09:43:42.155734	22512	21.1	1	8
2014-03-26 09:43:42.387487	22513	58	2	8
2014-03-26 09:43:57.123868	22514	20.5	1	1
2014-03-26 09:43:57.348043	22515	52	2	1
2014-03-26 23:31:23.640439	33279	20.1	1	1
2014-03-26 23:31:23.873842	33280	50	2	1
2014-03-26 09:44:21.154475	22520	21.1	1	8
2014-03-26 09:44:21.388219	22521	58	2	8
2014-03-26 09:44:32.63625	22522	450	3	2
2014-03-26 09:44:36.121184	22523	20.5	1	1
2014-03-26 09:44:36.34625	22524	52	2	1
2014-03-26 09:44:44.63985	22525	402	3	2
2014-03-26 09:44:56.639046	22526	370	3	2
2014-03-26 23:31:32.55001	33281	402	3	2
2014-03-26 23:31:32.774418	33282	1088924.6465712267	4	2
2014-03-26 09:45:00.154451	22531	21.1	1	8
2014-03-26 09:45:00.389315	22532	58	2	8
2014-03-26 09:45:08.638884	22533	402	3	2
2014-03-26 09:45:15.11946	22534	20.5	1	1
2014-03-26 09:45:15.342467	22535	52	2	1
2014-03-26 09:45:20.639932	22536	402	3	2
2014-03-26 09:45:32.637257	22537	402	3	2
2014-03-26 23:31:36.731892	33283	23.6	1	10
2014-03-26 23:31:36.965826	33284	41	2	10
2014-03-26 09:45:39.154328	22542	21.1	1	8
2014-03-26 09:45:39.385633	22543	58	2	8
2014-03-26 09:45:54.123886	22544	20.5	1	1
2014-03-26 09:45:54.345605	22545	52	2	1
2014-03-26 23:31:47.044913	33285	21.3	1	9
2014-03-26 23:31:47.269645	33286	47	2	9
2014-03-26 09:46:18.153444	22550	21.1	1	8
2014-03-26 09:46:18.386632	22551	58	2	8
2014-03-26 09:46:32.6418	22552	402	3	2
2014-03-26 09:46:33.120412	22553	20.5	1	1
2014-03-26 09:46:33.34328	22554	52	2	1
2014-03-26 23:31:48.133044	33287	21.6	1	8
2014-03-26 23:31:48.38011	33288	48	2	8
2014-03-26 09:46:57.154471	22559	21.1	1	8
2014-03-26 09:46:57.37576	22560	58	2	8
2014-03-26 09:47:08.639926	22561	450	3	2
2014-03-26 09:47:12.11989	22562	20.5	1	1
2014-03-26 09:47:12.340043	22563	52	2	1
2014-03-26 09:47:20.63734	22564	434	3	2
2014-03-26 09:47:32.638557	22565	434	3	2
2014-03-26 23:32:02.641442	33289	20.1	1	1
2014-03-26 23:32:02.884679	33290	50	2	1
2014-03-26 23:32:15.730055	33291	23.6	1	10
2014-03-26 09:47:36.153887	22570	21.1	1	8
2014-03-26 09:47:36.385066	22571	58	2	8
2014-03-26 09:47:51.121946	22572	20.5	1	1
2014-03-26 09:47:51.346251	22573	52	2	1
2014-03-26 09:39:07.215804	22445	20.6	1	10
2014-03-26 09:39:07.44057	22446	44	2	10
2014-03-26 09:39:46.217598	22455	20.6	1	10
2014-03-26 09:39:46.451566	22456	44	2	10
2014-03-26 09:40:25.217974	22464	20.6	1	10
2014-03-26 09:40:25.440766	22465	44	2	10
2014-03-26 09:41:04.218675	22473	20.6	1	10
2014-03-26 09:41:04.442451	22474	44	2	10
2014-03-26 09:41:43.227383	22482	20.6	1	10
2014-03-26 09:41:43.459025	22483	44	2	10
2014-03-26 09:42:22.218967	22490	20.6	1	10
2014-03-26 09:42:22.450561	22491	44	2	10
2014-03-26 09:43:01.218837	22499	20.6	1	10
2014-03-26 09:43:01.443954	22500	44	2	10
2014-03-26 09:43:40.218807	22508	20.6	1	10
2014-03-26 09:43:40.449952	22509	44	2	10
2014-03-26 09:44:19.220735	22516	20.6	1	10
2014-03-26 09:44:19.469374	22517	44	2	10
2014-03-26 09:44:58.218706	22527	20.6	1	10
2014-03-26 09:44:58.453145	22528	44	2	10
2014-03-26 09:45:37.219763	22538	20.6	1	10
2014-03-26 09:45:37.453588	22539	44	2	10
2014-03-26 09:46:16.219658	22546	20.6	1	10
2014-03-26 09:46:16.452148	22547	44	2	10
2014-03-26 09:46:55.220786	22555	20.6	1	10
2014-03-26 09:46:55.443199	22556	44	2	10
2014-03-26 09:47:34.220209	22566	20.6	1	10
2014-03-26 23:32:15.963955	33292	41	2	10
2014-03-26 09:48:15.153239	22578	21.1	1	8
2014-03-26 09:48:15.386417	22579	58	2	8
2014-03-26 09:48:30.119088	22580	20.5	1	1
2014-03-26 09:48:30.341452	22581	52	2	1
2014-03-26 09:48:32.638896	22582	418	3	2
2014-03-26 23:32:26.043339	33293	21.3	1	9
2014-03-26 23:32:26.26887	33294	47	2	9
2014-03-26 09:48:54.155851	22587	21.1	1	8
2014-03-26 09:48:54.377998	22588	58	2	8
2014-03-26 09:49:09.123591	22589	20.5	1	1
2014-03-26 09:49:09.347398	22590	52	2	1
2014-03-26 23:32:27.131916	33295	21.6	1	8
2014-03-26 23:32:27.364196	33296	48	2	8
2014-03-26 09:49:32.637471	22595	418	3	2
2014-03-26 09:49:33.155099	22596	21.1	1	8
2014-03-26 09:49:33.410804	22597	58	2	8
2014-03-26 09:49:48.118734	22598	20.5	1	1
2014-03-26 09:49:48.449394	22599	52	2	1
2014-03-26 23:32:32.551356	33297	402	3	2
2014-03-26 23:32:32.77604	33298	1088931.5407795552	4	2
2014-03-26 09:50:12.154793	22604	21.1	1	8
2014-03-26 09:50:12.411004	22605	58	2	8
2014-03-26 09:50:27.120595	22606	20.5	1	1
2014-03-26 09:50:27.365772	22607	52	2	1
2014-03-26 09:50:32.639021	22608	434	3	2
2014-03-26 23:32:41.64093	33299	20.1	1	1
2014-03-26 23:32:41.876598	33300	50	2	1
2014-03-26 09:50:51.478523	22613	21.1	1	8
2014-03-26 09:50:51.708913	22614	58	2	8
2014-03-26 09:51:06.119017	22615	20.5	1	1
2014-03-26 09:51:06.340078	22616	52	2	1
2014-03-26 09:51:20.63686	22617	466	3	2
2014-03-26 23:32:54.730357	33301	23.6	1	10
2014-03-26 23:32:54.954878	33302	41	2	10
2014-03-26 09:51:30.15539	22622	21.1	1	8
2014-03-26 09:51:30.376117	22623	58	2	8
2014-03-26 09:51:32.638707	22624	466	3	2
2014-03-26 09:51:44.638054	22625	434	3	2
2014-03-26 09:51:45.117628	22626	20.5	1	1
2014-03-26 09:51:45.3396	22627	52	2	1
2014-03-26 09:51:56.640737	22628	434	3	2
2014-03-26 23:33:05.043425	33303	21.3	1	9
2014-03-26 23:33:05.276016	33304	47	2	9
2014-03-26 09:52:09.152661	22633	21.1	1	8
2014-03-26 09:52:09.373754	22634	58	2	8
2014-03-26 09:52:24.11849	22635	20.5	1	1
2014-03-26 09:52:24.353372	22636	52	2	1
2014-03-26 09:52:46.020768	22637	434	3	2
2014-03-26 23:33:06.131996	33305	21.6	1	8
2014-03-26 23:33:06.354129	33306	48	2	8
2014-03-26 09:52:48.154117	22642	21.1	1	8
2014-03-26 09:52:48.375588	22643	57	2	8
2014-03-26 09:53:03.121139	22644	20.5	1	1
2014-03-26 09:53:03.342751	22645	52	2	1
2014-03-26 23:33:20.643366	33307	20.1	1	1
2014-03-26 23:33:20.877442	33308	50	2	1
2014-03-26 09:53:27.154409	22650	21.1	1	8
2014-03-26 09:53:27.395717	22651	58	2	8
2014-03-26 09:53:32.634968	22652	434	3	2
2014-03-26 09:53:42.116216	22653	20.5	1	1
2014-03-26 09:53:42.337343	22654	52	2	1
2014-03-26 23:33:32.547748	33309	402	3	2
2014-03-26 23:33:32.77537	33310	1088938.4349878838	4	2
2014-03-26 09:54:06.155133	22659	21.1	1	8
2014-03-26 09:54:06.376117	22660	58	2	8
2014-03-26 09:54:21.118083	22661	20.5	1	1
2014-03-26 09:54:21.348932	22662	52	2	1
2014-03-26 09:54:32.637942	22663	434	3	2
2014-03-26 23:33:33.73285	33311	23.6	1	10
2014-03-26 23:33:33.965961	33312	41	2	10
2014-03-26 09:54:45.156784	22668	21.1	1	8
2014-03-26 09:54:45.389625	22669	57	2	8
2014-03-26 09:55:00.119339	22670	20.5	1	1
2014-03-26 09:55:00.343369	22671	52	2	1
2014-03-26 23:33:44.044103	33313	21.3	1	9
2014-03-26 23:33:44.268801	33314	47	2	9
2014-03-26 09:55:24.480072	22676	21.1	1	8
2014-03-26 09:55:24.711268	22677	58	2	8
2014-03-26 09:55:32.63764	22678	450	3	2
2014-03-26 09:55:39.120106	22679	20.5	1	1
2014-03-26 09:55:39.34428	22680	52	2	1
2014-03-26 23:33:45.133976	33315	21.6	1	8
2014-03-26 23:33:45.366676	33316	47	2	8
2014-03-26 09:56:03.154305	22685	21.1	1	8
2014-03-26 09:56:03.376297	22686	58	2	8
2014-03-26 09:56:18.11718	22687	20.5	1	1
2014-03-26 09:56:18.350758	22688	52	2	1
2014-03-26 09:56:32.637933	22689	402	3	2
2014-03-26 23:33:59.63947	33317	20.1	1	1
2014-03-26 23:33:59.865409	33318	50	2	1
2014-03-26 09:56:42.154698	22694	21.1	1	8
2014-03-26 09:56:42.396555	22695	58	2	8
2014-03-26 09:56:44.63755	22696	370	3	2
2014-03-26 09:56:56.641081	22697	402	3	2
2014-03-26 09:56:57.11907	22698	20.5	1	1
2014-03-26 09:56:57.351211	22699	53	2	1
2014-03-26 09:57:08.638784	22700	402	3	2
2014-03-26 09:57:20.634505	22705	370	3	2
2014-03-26 09:57:21.153474	22706	21.1	1	8
2014-03-26 09:57:21.386351	22707	58	2	8
2014-03-26 09:57:32.638104	22708	370	3	2
2014-03-26 09:57:36.112371	22709	20.5	1	1
2014-03-26 09:57:36.334161	22710	53	2	1
2014-03-26 09:57:44.638167	22711	402	3	2
2014-03-26 09:57:56.632798	22712	370	3	2
2014-03-26 09:48:52.219996	22583	20.6	1	10
2014-03-26 09:48:52.443646	22584	44	2	10
2014-03-26 09:49:31.222562	22591	20.6	1	10
2014-03-26 09:49:31.497718	22592	44	2	10
2014-03-26 09:50:10.220058	22600	20.6	1	10
2014-03-26 09:50:10.475761	22601	44	2	10
2014-03-26 09:50:49.220217	22609	20.6	1	10
2014-03-26 09:50:49.44689	22610	44	2	10
2014-03-26 09:51:28.219695	22618	20.6	1	10
2014-03-26 09:51:28.441341	22619	44	2	10
2014-03-26 09:52:07.220672	22629	20.6	1	10
2014-03-26 09:52:07.443331	22630	44	2	10
2014-03-26 09:52:46.328176	22638	20.6	1	10
2014-03-26 09:52:46.550736	22639	44	2	10
2014-03-26 09:53:25.222031	22646	20.6	1	10
2014-03-26 09:53:25.453784	22647	44	2	10
2014-03-26 09:54:04.220816	22655	20.6	1	10
2014-03-26 09:54:04.44256	22656	44	2	10
2014-03-26 09:54:43.223569	22664	20.6	1	10
2014-03-26 09:54:43.448255	22665	44	2	10
2014-03-26 09:55:22.221255	22672	20.6	1	10
2014-03-26 09:55:22.492139	22673	44	2	10
2014-03-26 09:56:01.222956	22681	20.6	1	10
2014-03-26 09:56:01.444822	22682	44	2	10
2014-03-26 09:56:40.223201	22690	20.6	1	10
2014-03-26 09:56:40.445768	22691	44	2	10
2014-03-26 09:57:19.223294	22701	20.6	1	10
2014-03-26 23:34:08.544252	33319	370	3	2
2014-03-26 23:34:08.78208	33320	1088941.882092048	4	2
2014-03-26 09:58:00.154165	22717	21.1	1	8
2014-03-26 09:58:00.385036	22718	58	2	8
2014-03-26 09:58:08.635606	22719	370	3	2
2014-03-26 09:58:15.11242	22720	20.4	1	1
2014-03-26 09:58:15.335625	22721	53	2	1
2014-03-26 09:58:32.635713	22722	418	3	2
2014-03-26 23:34:12.733296	33321	23.6	1	10
2014-03-26 23:34:12.958666	33322	41	2	10
2014-03-26 09:58:39.155497	22727	21.1	1	8
2014-03-26 09:58:39.377783	22728	57	2	8
2014-03-26 09:58:44.636537	22729	402	3	2
2014-03-26 09:58:54.112771	22730	20.4	1	1
2014-03-26 09:58:54.335262	22731	53	2	1
2014-03-26 09:58:56.637728	22732	370	3	2
2014-03-26 09:59:08.637583	22733	370	3	2
2014-03-26 23:34:20.546796	33323	402	3	2
2014-03-26 23:34:20.781125	33324	1088943.0311267695	4	2
2014-03-26 09:59:18.154376	22738	21.1	1	8
2014-03-26 09:59:18.39589	22739	57	2	8
2014-03-26 09:59:20.635043	22740	402	3	2
2014-03-26 09:59:32.63639	22741	370	3	2
2014-03-26 09:59:33.114679	22742	20.4	1	1
2014-03-26 09:59:33.346604	22743	53	2	1
2014-03-26 09:59:44.634265	22744	402	3	2
2014-03-26 23:34:23.043397	33325	21.3	1	9
2014-03-26 23:34:23.267023	33326	47	2	9
2014-03-26 09:59:56.633405	22749	370	3	2
2014-03-26 09:59:57.154714	22750	21.1	1	8
2014-03-26 09:59:57.376338	22751	58	2	8
2014-03-26 10:00:08.634571	22752	402	3	2
2014-03-26 10:00:12.114313	22753	20.4	1	1
2014-03-26 10:00:12.347213	22754	53	2	1
2014-03-26 10:00:20.634519	22755	370	3	2
2014-03-26 10:00:32.636357	22756	402	3	2
2014-03-26 23:34:24.135423	33327	21.6	1	8
2014-03-26 23:34:24.369641	33328	47	2	8
2014-03-26 10:00:36.153017	22761	21.1	1	8
2014-03-26 10:00:36.388115	22762	58	2	8
2014-03-26 10:00:44.635192	22763	402	3	2
2014-03-26 10:00:51.1111	22764	20.4	1	1
2014-03-26 10:00:51.33448	22765	53	2	1
2014-03-26 23:34:32.547792	33329	402	3	2
2014-03-26 23:34:32.79365	33330	1088944.1801614908	4	2
2014-03-26 10:01:15.155564	22770	21.1	1	8
2014-03-26 10:01:15.380166	22771	57	2	8
2014-03-26 10:01:30.111516	22772	20.4	1	1
2014-03-26 10:01:30.344033	22773	53	2	1
2014-03-26 10:01:32.637295	22774	402	3	2
2014-03-26 23:34:38.642476	33331	20.1	1	1
2014-03-26 23:34:38.878432	33332	50	2	1
2014-03-26 10:01:54.153442	22779	21.1	1	8
2014-03-26 10:01:54.387021	22780	58	2	8
2014-03-26 10:01:56.63338	22781	370	3	2
2014-03-26 10:02:08.637892	22782	402	3	2
2014-03-26 10:02:09.11222	22783	20.4	1	1
2014-03-26 10:02:09.353196	22784	53	2	1
2014-03-26 10:02:20.638768	22785	402	3	2
2014-03-26 23:34:51.732614	33333	23.6	1	10
2014-03-26 23:34:51.960047	33334	41	2	10
2014-03-26 10:02:32.638501	22790	402	3	2
2014-03-26 10:02:33.154495	22791	21.1	1	8
2014-03-26 10:02:33.38515	22792	58	2	8
2014-03-26 10:02:48.112247	22793	20.4	1	1
2014-03-26 10:02:48.335884	22794	53	2	1
2014-03-26 10:02:56.636795	22795	370	3	2
2014-03-26 10:03:08.634385	22796	402	3	2
2014-03-26 23:34:56.546464	33335	338	3	2
2014-03-26 23:34:56.793298	33336	1088947.627265655	4	2
2014-03-26 10:03:12.154211	22801	21.1	1	8
2014-03-26 10:03:12.376601	22802	58	2	8
2014-03-26 10:03:20.638713	22803	434	3	2
2014-03-26 10:03:27.10825	22804	20.4	1	1
2014-03-26 10:03:27.332141	22805	53	2	1
2014-03-26 10:03:32.633323	22806	434	3	2
2014-03-26 23:35:02.045625	33337	21.2	1	9
2014-03-26 23:35:02.273276	33338	47	2	9
2014-03-26 10:03:51.153606	22811	21.1	1	8
2014-03-26 10:03:51.38506	22812	58	2	8
2014-03-26 10:04:06.110254	22813	20.4	1	1
2014-03-26 10:04:06.332522	22814	53	2	1
2014-03-26 23:35:03.132253	33339	21.6	1	8
2014-03-26 23:35:03.367746	33340	47	2	8
2014-03-26 10:04:30.494518	22817	21.1	1	8
2014-03-26 10:04:30.717309	22818	58	2	8
2014-03-26 10:04:44.492186	22819	434	3	2
2014-03-26 10:04:44.809369	22820	3026	3	2
2014-03-26 10:04:45.117632	22821	20.4	1	1
2014-03-26 10:04:45.34009	22822	53	2	1
2014-03-26 10:04:56.637259	22823	2945	3	2
2014-03-26 23:35:08.546736	33341	338	3	2
2014-03-26 23:35:08.7716	33342	1088948.7763003765	4	2
2014-03-26 10:05:08.632844	22828	2945	3	2
2014-03-26 10:05:09.155602	22829	21.1	1	8
2014-03-26 10:05:09.376931	22830	58	2	8
2014-03-26 10:05:24.109288	22831	20.4	1	1
2014-03-26 10:05:24.334058	22832	53	2	1
2014-03-26 10:05:46.024114	22833	2945	3	2
2014-03-26 23:35:17.641141	33343	20.1	1	1
2014-03-26 10:05:48.153028	22838	21.1	1	8
2014-03-26 10:05:48.386616	22839	58	2	8
2014-03-26 10:06:03.111815	22840	20.4	1	1
2014-03-26 10:06:03.33486	22841	53	2	1
2014-03-26 10:06:27.482543	22846	21.1	1	8
2014-03-26 10:06:27.714448	22847	58	2	8
2014-03-26 10:06:32.635954	22848	2961	3	2
2014-03-26 09:57:58.222883	22713	20.6	1	10
2014-03-26 09:57:58.474387	22714	44	2	10
2014-03-26 09:58:37.221931	22723	20.6	1	10
2014-03-26 09:58:37.444215	22724	44	2	10
2014-03-26 09:59:16.223606	22734	20.6	1	10
2014-03-26 09:59:16.451718	22735	44	2	10
2014-03-26 09:59:55.22501	22745	20.6	1	10
2014-03-26 09:59:55.452442	22746	44	2	10
2014-03-26 10:00:34.222543	22757	20.6	1	10
2014-03-26 10:00:34.457723	22758	44	2	10
2014-03-26 10:01:13.224057	22766	20.6	1	10
2014-03-26 10:01:13.447956	22767	44	2	10
2014-03-26 10:01:52.224235	22775	20.6	1	10
2014-03-26 10:01:52.446395	22776	44	2	10
2014-03-26 10:02:31.225568	22786	20.6	1	10
2014-03-26 10:02:31.447745	22787	44	2	10
2014-03-26 10:03:10.224008	22797	20.6	1	10
2014-03-26 10:03:10.445698	22798	44	2	10
2014-03-26 10:03:49.225358	22807	20.6	1	10
2014-03-26 10:03:49.456379	22808	44	2	10
2014-03-26 10:05:07.224484	22824	20.5	1	10
2014-03-26 10:05:07.44683	22825	44	2	10
2014-03-26 10:05:46.331652	22834	20.5	1	10
2014-03-26 10:05:46.566137	22835	44	2	10
2014-03-26 10:06:25.223792	22842	20.5	1	10
2014-03-26 10:06:25.457557	22843	44	2	10
2014-03-26 10:06:42.10929	22849	20.4	1	1
2014-03-26 10:06:42.352147	22850	53	2	1
2014-03-26 23:35:17.876091	33344	50	2	1
2014-03-26 23:35:30.731891	33345	23.6	1	10
2014-03-26 10:07:06.152765	22855	21.1	1	8
2014-03-26 10:07:06.37479	22856	58	2	8
2014-03-26 10:07:08.632578	22857	434	3	2
2014-03-26 10:07:20.633789	22858	450	3	2
2014-03-26 10:07:21.107096	22859	20.4	1	1
2014-03-26 10:07:21.331771	22860	53	2	1
2014-03-26 10:07:32.633663	22861	434	3	2
2014-03-26 23:35:30.957308	33346	41	2	10
2014-03-26 23:35:32.548668	33347	338	3	2
2014-03-26 10:07:45.15394	22866	21.1	1	8
2014-03-26 10:07:45.375696	22867	58	2	8
2014-03-26 10:08:00.110039	22868	20.4	1	1
2014-03-26 10:08:00.33382	22869	53	2	1
2014-03-26 23:35:32.785669	33348	1088951.0743698194	4	2
2014-03-26 23:35:41.043108	33349	21.2	1	9
2014-03-26 10:08:24.15286	22874	21.1	1	8
2014-03-26 10:08:24.395836	22875	58	2	8
2014-03-26 10:08:32.632091	22876	434	3	2
2014-03-26 10:08:39.107574	22877	20.4	1	1
2014-03-26 10:08:39.331154	22878	53	2	1
2014-03-26 10:08:56.633758	22879	402	3	2
2014-03-26 23:35:41.266817	33350	47	2	9
2014-03-26 23:35:42.134892	33351	21.6	1	8
2014-03-26 10:09:03.152524	22884	21.1	1	8
2014-03-26 10:09:03.375048	22885	58	2	8
2014-03-26 10:09:08.63267	22886	402	3	2
2014-03-26 10:09:18.105275	22887	20.4	1	1
2014-03-26 10:09:18.329411	22888	53	2	1
2014-03-26 10:09:32.635036	22889	370	3	2
2014-03-26 23:35:42.367099	33352	47	2	8
2014-03-26 23:35:56.63854	33353	20.1	1	1
2014-03-26 10:09:42.152652	22894	21.1	1	8
2014-03-26 10:09:42.385265	22895	58	2	8
2014-03-26 10:09:44.633982	22896	450	3	2
2014-03-26 10:09:56.906439	22897	450	3	2
2014-03-26 10:09:57.216367	22898	20.4	1	1
2014-03-26 10:09:57.450327	22899	53	2	1
2014-03-26 23:35:56.861603	33354	50	2	1
2014-03-26 23:36:09.734598	33355	23.6	1	10
2014-03-26 10:10:21.155583	22904	21.1	1	8
2014-03-26 10:10:21.376692	22905	58	2	8
2014-03-26 10:10:32.63294	22906	450	3	2
2014-03-26 10:10:36.111451	22907	20.4	1	1
2014-03-26 10:10:36.333568	22908	53	2	1
2014-03-26 23:36:09.969454	33356	41	2	10
2014-03-26 23:36:20.043928	33357	21.2	1	9
2014-03-26 10:11:00.152575	22913	21.1	1	8
2014-03-26 10:11:00.386586	22914	58	2	8
2014-03-26 10:11:08.632859	22915	498	3	2
2014-03-26 10:11:15.104562	22916	20.4	1	1
2014-03-26 10:11:15.328528	22917	53	2	1
2014-03-26 10:11:20.633888	22918	498	3	2
2014-03-26 10:11:32.634329	22919	498	3	2
2014-03-26 23:36:20.272933	33358	47	2	9
2014-03-26 23:36:21.133746	33359	21.6	1	8
2014-03-26 10:11:39.153817	22924	21.1	1	8
2014-03-26 10:11:39.389309	22925	58	2	8
2014-03-26 10:11:54.107178	22926	20.4	1	1
2014-03-26 10:11:54.336694	22927	53	2	1
2014-03-26 23:36:21.368813	33360	47	2	8
2014-03-26 23:36:32.548544	33361	338	3	2
2014-03-26 10:12:18.153188	22932	21.1	1	8
2014-03-26 10:12:18.388008	22933	58	2	8
2014-03-26 10:12:32.633908	22934	482	3	2
2014-03-26 10:12:33.108027	22935	20.4	1	1
2014-03-26 10:12:33.330785	22936	53	2	1
2014-03-26 23:36:32.772479	33362	1088956.8195434264	4	2
2014-03-26 23:36:35.635927	33363	20.1	1	1
2014-03-26 10:12:57.153147	22941	21.1	1	8
2014-03-26 10:12:57.374876	22942	58	2	8
2014-03-26 10:13:12.102394	22943	20.4	1	1
2014-03-26 10:13:12.334354	22944	53	2	1
2014-03-26 10:13:32.636225	22945	482	3	2
2014-03-26 23:36:35.877374	33364	50	2	1
2014-03-26 23:36:48.731996	33365	23.6	1	10
2014-03-26 10:13:36.153669	22950	21.1	1	8
2014-03-26 10:13:36.386018	22951	58	2	8
2014-03-26 10:13:51.103531	22952	20.4	1	1
2014-03-26 10:13:51.327536	22953	53	2	1
2014-03-26 23:36:48.95953	33366	41	2	10
2014-03-26 23:36:59.042649	33367	21.2	1	9
2014-03-26 10:14:15.155795	22958	21.1	1	8
2014-03-26 10:14:15.387338	22959	58	2	8
2014-03-26 10:14:30.105147	22960	20.4	1	1
2014-03-26 10:14:30.327808	22961	53	2	1
2014-03-26 10:14:32.634302	22962	482	3	2
2014-03-26 23:36:59.276876	33368	47	2	9
2014-03-26 23:37:00.132954	33369	21.6	1	8
2014-03-26 10:14:54.153632	22967	21.1	1	8
2014-03-26 10:14:54.382775	22968	57	2	8
2014-03-26 10:15:09.105027	22969	20.4	1	1
2014-03-26 10:15:09.3379	22970	53	2	1
2014-03-26 23:37:00.359547	33370	47	2	8
2014-03-26 23:37:14.63734	33371	20.1	1	1
2014-03-26 23:37:14.872775	33372	50	2	1
2014-03-26 10:15:32.632351	22975	498	3	2
2014-03-26 10:15:33.15354	22976	21.1	1	8
2014-03-26 10:15:33.376342	22977	57	2	8
2014-03-26 10:15:44.632309	22978	531	3	2
2014-03-26 10:15:48.103926	22979	20.4	1	1
2014-03-26 10:15:48.345284	22980	53	2	1
2014-03-26 10:15:56.630737	22981	531	3	2
2014-03-26 10:07:04.231719	22851	20.5	1	10
2014-03-26 10:07:04.459255	22852	44	2	10
2014-03-26 10:07:43.226419	22862	20.5	1	10
2014-03-26 10:07:43.450327	22863	44	2	10
2014-03-26 10:08:22.225754	22870	20.5	1	10
2014-03-26 10:08:22.457811	22871	44	2	10
2014-03-26 10:09:01.226048	22880	20.5	1	10
2014-03-26 10:09:01.447489	22881	44	2	10
2014-03-26 10:09:40.225898	22890	20.5	1	10
2014-03-26 10:09:40.458601	22891	44	2	10
2014-03-26 10:10:19.22713	22900	20.5	1	10
2014-03-26 10:10:19.450225	22901	44	2	10
2014-03-26 10:10:58.22863	22909	20.5	1	10
2014-03-26 10:10:58.46037	22910	44	2	10
2014-03-26 10:11:37.227986	22920	20.5	1	10
2014-03-26 10:11:37.469107	22921	44	2	10
2014-03-26 10:12:16.227425	22928	20.5	1	10
2014-03-26 10:12:16.461435	22929	44	2	10
2014-03-26 10:12:55.228988	22937	20.5	1	10
2014-03-26 10:12:55.45278	22938	44	2	10
2014-03-26 10:13:34.226448	22946	20.5	1	10
2014-03-26 10:13:34.448497	22947	44	2	10
2014-03-26 10:14:13.227866	22954	20.5	1	10
2014-03-26 10:14:13.461651	22955	44	2	10
2014-03-26 10:14:52.228659	22963	20.5	1	10
2014-03-26 10:14:52.45083	22964	44	2	10
2014-03-26 10:15:31.228583	22971	20.5	1	10
2014-03-26 23:37:27.732444	33373	23.6	1	10
2014-03-26 10:16:12.155689	22986	21.1	1	8
2014-03-26 10:16:12.377601	22987	57	2	8
2014-03-26 10:16:27.10194	22988	20.4	1	1
2014-03-26 10:16:27.334588	22989	53	2	1
2014-03-26 10:16:49.027608	22990	531	3	2
2014-03-26 23:37:27.95745	33374	41	2	10
2014-03-26 23:37:32.546408	33375	338	3	2
2014-03-26 10:16:51.152659	22995	21.1	1	8
2014-03-26 10:16:51.378111	22996	57	2	8
2014-03-26 10:17:06.103012	22997	20.4	1	1
2014-03-26 10:17:06.328944	22998	53	2	1
2014-03-26 23:37:32.781081	33376	1088961.415682312	4	2
2014-03-26 23:37:38.044017	33377	21.2	1	9
2014-03-26 10:17:30.483476	23003	21.1	1	8
2014-03-26 10:17:30.716034	23004	57	2	8
2014-03-26 10:17:32.63323	23005	547	3	2
2014-03-26 10:17:45.104723	23006	20.4	1	1
2014-03-26 10:17:45.329649	23007	53	2	1
2014-03-26 23:37:38.270046	33378	47	2	9
2014-03-26 23:37:39.132477	33379	21.6	1	8
2014-03-26 10:18:09.153528	23012	21.1	1	8
2014-03-26 10:18:09.37467	23013	57	2	8
2014-03-26 10:18:24.102422	23014	20.4	1	1
2014-03-26 10:18:24.333514	23015	53	2	1
2014-03-26 10:18:32.634605	23016	531	3	2
2014-03-26 23:37:39.39132	33380	47	2	8
2014-03-26 23:37:53.635728	33381	20.1	1	1
2014-03-26 10:18:48.154198	23021	21.1	1	8
2014-03-26 10:18:48.384347	23022	57	2	8
2014-03-26 10:19:03.101271	23023	20.4	1	1
2014-03-26 10:19:03.323998	23024	53	2	1
2014-03-26 23:37:53.859598	33382	50	2	1
2014-03-26 23:38:06.732681	33383	23.6	1	10
2014-03-26 10:19:27.153139	23029	21.1	1	8
2014-03-26 10:19:27.385482	23030	57	2	8
2014-03-26 10:19:32.633116	23031	531	3	2
2014-03-26 10:19:42.100102	23032	20.4	1	1
2014-03-26 10:19:42.322099	23033	53	2	1
2014-03-26 23:38:06.979907	33384	41	2	10
2014-03-26 23:38:17.043126	33385	21.2	1	9
2014-03-26 10:20:06.152262	23038	21.1	1	8
2014-03-26 10:20:06.374754	23039	57	2	8
2014-03-26 10:20:21.099619	23040	20.4	1	1
2014-03-26 10:20:21.332815	23041	53	2	1
2014-03-26 10:20:32.629922	23042	547	3	2
2014-03-26 23:38:17.266327	33386	47	2	9
2014-03-26 23:38:18.132773	33387	21.6	1	8
2014-03-26 10:20:45.153838	23047	21.1	1	8
2014-03-26 10:20:45.375958	23048	57	2	8
2014-03-26 10:20:56.635814	23049	482	3	2
2014-03-26 10:21:00.101662	23050	20.4	1	1
2014-03-26 10:21:00.324004	23051	53	2	1
2014-03-26 10:21:08.631323	23052	482	3	2
2014-03-26 23:38:18.36571	33388	47	2	8
2014-03-26 23:38:20.546171	33389	370	3	2
2014-03-26 10:21:24.15697	23057	21.1	1	8
2014-03-26 10:21:24.379887	23058	57	2	8
2014-03-26 10:21:32.633697	23059	482	3	2
2014-03-26 10:21:39.100043	23060	20.4	1	1
2014-03-26 10:21:39.324136	23061	53	2	1
2014-03-26 23:38:20.774066	33390	1088966.0118211976	4	2
2014-03-26 23:38:32.875527	33391	20.1	1	1
2014-03-26 10:22:03.153323	23066	21.0	1	8
2014-03-26 10:22:03.377005	23067	56	2	8
2014-03-26 10:22:18.100862	23068	20.4	1	1
2014-03-26 10:22:18.334297	23069	53	2	1
2014-03-26 10:22:32.629471	23070	482	3	2
2014-03-26 23:38:33.109198	33392	50	2	1
2014-03-26 23:38:45.734636	33393	23.5	1	10
2014-03-26 10:22:42.154045	23075	21.0	1	8
2014-03-26 10:22:42.389305	23076	56	2	8
2014-03-26 10:22:57.099979	23077	20.4	1	1
2014-03-26 10:22:57.32314	23078	53	2	1
2014-03-26 23:38:45.958489	33394	41	2	10
2014-03-26 23:38:56.042991	33395	21.2	1	9
2014-03-26 10:23:21.152613	23083	21.0	1	8
2014-03-26 10:23:21.388091	23084	56	2	8
2014-03-26 10:23:32.634619	23085	498	3	2
2014-03-26 10:23:36.101211	23086	20.4	1	1
2014-03-26 10:23:36.323251	23087	53	2	1
2014-03-26 10:23:56.633024	23088	434	3	2
2014-03-26 23:38:56.275914	33396	47	2	9
2014-03-26 23:38:57.131783	33397	21.6	1	8
2014-03-26 10:24:00.153651	23093	21.0	1	8
2014-03-26 10:24:00.384205	23094	56	2	8
2014-03-26 10:24:08.633491	23095	434	3	2
2014-03-26 10:24:15.099631	23096	20.4	1	1
2014-03-26 10:24:15.379022	23097	53	2	1
2014-03-26 10:24:32.628147	23098	434	3	2
2014-03-26 23:38:57.3563	33398	47	2	8
2014-03-26 23:39:11.637248	33399	20.1	1	1
2014-03-26 10:24:39.154353	23103	21.0	1	8
2014-03-26 10:24:39.376893	23104	56	2	8
2014-03-26 10:24:54.099251	23105	20.4	1	1
2014-03-26 10:24:54.321581	23106	53	2	1
2014-03-26 23:39:11.87507	33400	50	2	1
2014-03-26 23:39:24.733214	33401	23.5	1	10
2014-03-26 10:25:18.153256	23111	21.0	1	8
2014-03-26 10:25:18.385935	23112	56	2	8
2014-03-26 10:25:32.629351	23113	434	3	2
2014-03-26 10:25:33.0958	23114	20.4	1	1
2014-03-26 10:25:33.317311	23115	53	2	1
2014-03-26 10:25:57.153463	23120	21.0	1	8
2014-03-26 10:16:49.376768	22991	20.5	1	10
2014-03-26 10:16:49.61765	22992	44	2	10
2014-03-26 10:17:28.227544	22999	20.5	1	10
2014-03-26 10:17:28.462608	23000	44	2	10
2014-03-26 10:18:07.22912	23008	20.5	1	10
2014-03-26 10:18:07.452536	23009	44	2	10
2014-03-26 10:18:46.229004	23017	20.5	1	10
2014-03-26 10:18:46.451584	23018	44	2	10
2014-03-26 10:19:25.229956	23025	20.5	1	10
2014-03-26 10:19:25.461389	23026	44	2	10
2014-03-26 10:20:04.229069	23034	20.5	1	10
2014-03-26 10:20:04.451605	23035	44	2	10
2014-03-26 10:20:43.230628	23043	20.5	1	10
2014-03-26 10:20:43.454552	23044	44	2	10
2014-03-26 10:21:22.231669	23053	20.5	1	10
2014-03-26 10:21:22.454794	23054	44	2	10
2014-03-26 10:22:01.232271	23062	20.5	1	10
2014-03-26 10:22:01.454602	23063	44	2	10
2014-03-26 10:22:40.230212	23071	20.5	1	10
2014-03-26 10:22:40.457305	23072	44	2	10
2014-03-26 10:23:19.230414	23079	20.5	1	10
2014-03-26 10:23:19.463574	23080	44	2	10
2014-03-26 10:23:58.23024	23089	20.5	1	10
2014-03-26 10:23:58.452025	23090	44	2	10
2014-03-26 10:24:37.230473	23099	20.5	1	10
2014-03-26 10:24:37.452887	23100	44	2	10
2014-03-26 10:25:16.230745	23107	20.5	1	10
2014-03-26 10:25:16.463346	23108	44	2	10
2014-03-26 10:25:55.230671	23116	20.4	1	10
2014-03-26 10:25:57.3749	23121	56	2	8
2014-03-26 10:26:12.097745	23122	20.4	1	1
2014-03-26 10:26:12.321321	23123	53	2	1
2014-03-26 10:26:32.631929	23124	434	3	2
2014-03-26 23:39:24.959089	33402	41	2	10
2014-03-26 23:39:32.545148	33403	370	3	2
2014-03-26 10:26:36.15478	23129	21.0	1	8
2014-03-26 10:26:36.386532	23130	56	2	8
2014-03-26 10:26:51.098659	23131	20.4	1	1
2014-03-26 10:26:51.323146	23132	53	2	1
2014-03-26 23:39:32.781397	33404	1088974.0550642477	4	2
2014-03-26 23:39:35.043409	33405	21.2	1	9
2014-03-26 10:27:15.152377	23135	21.0	1	8
2014-03-26 10:27:15.433098	23136	56	2	8
2014-03-26 10:27:30.093655	23137	20.4	1	1
2014-03-26 10:27:30.328655	23138	53	2	1
2014-03-26 10:27:32.63307	23139	434	3	2
2014-03-26 10:27:44.630579	23140	466	3	2
2014-03-26 23:39:35.265564	33406	47	2	9
2014-03-26 23:39:36.133535	33407	21.6	1	8
2014-03-26 10:27:54.152265	23145	21.0	1	8
2014-03-26 10:27:54.375678	23146	56	2	8
2014-03-26 10:27:56.632326	23147	466	3	2
2014-03-26 10:28:09.095048	23148	20.4	1	1
2014-03-26 10:28:09.318857	23149	53	2	1
2014-03-26 23:39:36.367551	33408	47	2	8
2014-03-26 23:39:50.638027	33409	20.1	1	1
2014-03-26 10:28:32.638721	23154	482	3	2
2014-03-26 10:28:33.152103	23155	21.0	1	8
2014-03-26 10:28:33.374198	23156	56	2	8
2014-03-26 10:28:48.09544	23157	20.4	1	1
2014-03-26 10:28:48.321619	23158	53	2	1
2014-03-26 23:39:50.865306	33410	50	2	1
2014-03-26 23:40:03.733115	33411	23.5	1	10
2014-03-26 10:29:12.152324	23163	21.0	1	8
2014-03-26 10:29:12.374959	23164	56	2	8
2014-03-26 10:29:27.098585	23165	20.4	1	1
2014-03-26 10:29:27.331778	23166	53	2	1
2014-03-26 10:29:32.633406	23167	482	3	2
2014-03-26 23:40:03.968688	33412	41	2	10
2014-03-26 23:40:14.045641	33413	21.2	1	9
2014-03-26 10:29:51.152249	23172	21.0	1	8
2014-03-26 10:29:51.374237	23173	56	2	8
2014-03-26 10:30:06.095242	23174	20.4	1	1
2014-03-26 10:30:06.3175	23175	53	2	1
2014-03-26 23:40:14.268936	33414	47	2	9
2014-03-26 23:40:15.13287	33415	21.6	1	8
2014-03-26 10:30:30.153064	23180	21.0	1	8
2014-03-26 10:30:30.384848	23181	56	2	8
2014-03-26 10:30:32.630639	23182	482	3	2
2014-03-26 10:30:45.092029	23183	20.4	1	1
2014-03-26 10:30:45.336619	23184	53	2	1
2014-03-26 23:40:15.366626	33416	47	2	8
2014-03-26 23:40:29.635523	33417	20.1	1	1
2014-03-26 10:31:09.488473	23189	21.0	1	8
2014-03-26 10:31:09.713807	23190	56	2	8
2014-03-26 10:31:24.097489	23191	20.4	1	1
2014-03-26 10:31:24.331044	23192	53	2	1
2014-03-26 10:31:32.630465	23193	482	3	2
2014-03-26 23:40:29.85963	33418	50	2	1
2014-03-26 23:40:32.548996	33419	370	3	2
2014-03-26 10:31:48.152939	23198	21.0	1	8
2014-03-26 10:31:48.37539	23199	56	2	8
2014-03-26 10:32:03.093545	23200	20.4	1	1
2014-03-26 10:32:03.316454	23201	53	2	1
2014-03-26 23:40:32.784051	33420	1088979.8002378547	4	2
2014-03-26 23:40:42.733322	33421	23.5	1	10
2014-03-26 10:32:27.152849	23206	21.0	1	8
2014-03-26 10:32:27.375677	23207	56	2	8
2014-03-26 10:32:32.631441	23208	482	3	2
2014-03-26 10:32:42.090497	23209	20.4	1	1
2014-03-26 10:32:42.316121	23210	53	2	1
2014-03-26 23:40:42.957204	33422	41	2	10
2014-03-26 23:40:53.046718	33423	21.2	1	9
2014-03-26 10:33:06.151895	23215	21.0	1	8
2014-03-26 10:33:06.375284	23216	56	2	8
2014-03-26 10:33:21.091371	23217	20.4	1	1
2014-03-26 10:33:21.32403	23218	53	2	1
2014-03-26 10:33:32.63096	23219	482	3	2
2014-03-26 23:40:53.283059	33424	47	2	9
2014-03-26 23:40:54.13556	33425	21.6	1	8
2014-03-26 10:33:45.151547	23224	21.0	1	8
2014-03-26 10:33:45.384198	23225	56	2	8
2014-03-26 10:33:56.631903	23226	434	3	2
2014-03-26 10:34:00.090061	23227	20.4	1	1
2014-03-26 10:34:00.31214	23228	53	2	1
2014-03-26 10:34:08.629234	23229	434	3	2
2014-03-26 23:40:54.359954	33426	47	2	8
2014-03-26 23:41:08.635321	33427	20.1	1	1
2014-03-26 10:34:24.153168	23234	21.0	1	8
2014-03-26 10:34:24.375012	23235	56	2	8
2014-03-26 10:34:32.632321	23236	434	3	2
2014-03-26 10:34:39.091632	23237	20.4	1	1
2014-03-26 10:34:39.316701	23238	53	2	1
2014-03-26 23:41:08.869877	33428	50	2	1
2014-03-26 23:41:21.733627	33429	23.5	1	10
2014-03-26 10:35:03.152504	23243	21.0	1	8
2014-03-26 10:35:03.382529	23244	56	2	8
2014-03-26 10:35:18.094011	23245	20.4	1	1
2014-03-26 10:35:18.315839	23246	53	2	1
2014-03-26 10:35:32.629158	23247	434	3	2
2014-03-26 10:35:42.151837	23252	21.1	1	8
2014-03-26 10:35:42.373586	23253	56	2	8
2014-03-26 10:35:57.089831	23254	20.4	1	1
2014-03-26 10:35:57.321124	23255	53	2	1
2014-03-26 10:26:34.232597	23125	20.4	1	10
2014-03-26 10:26:34.454447	23126	44	2	10
2014-03-26 10:27:52.231055	23141	20.4	1	10
2014-03-26 10:27:52.45506	23142	44	2	10
2014-03-26 10:28:31.231416	23150	20.4	1	10
2014-03-26 10:28:31.455511	23151	44	2	10
2014-03-26 10:29:10.232059	23159	20.4	1	10
2014-03-26 10:29:10.455329	23160	44	2	10
2014-03-26 10:29:49.232087	23168	20.4	1	10
2014-03-26 10:29:49.455147	23169	44	2	10
2014-03-26 10:30:28.232741	23176	20.4	1	10
2014-03-26 10:30:28.465394	23177	44	2	10
2014-03-26 10:31:07.23314	23185	20.4	1	10
2014-03-26 10:31:07.455553	23186	44	2	10
2014-03-26 10:31:46.232247	23194	20.4	1	10
2014-03-26 10:31:46.456977	23195	44	2	10
2014-03-26 10:32:25.235037	23202	20.4	1	10
2014-03-26 10:32:25.457693	23203	44	2	10
2014-03-26 10:33:04.232327	23211	20.4	1	10
2014-03-26 10:33:04.456673	23212	43	2	10
2014-03-26 10:33:43.232282	23220	20.4	1	10
2014-03-26 10:33:43.456383	23221	43	2	10
2014-03-26 10:34:22.233326	23230	20.4	1	10
2014-03-26 10:34:22.455957	23231	43	2	10
2014-03-26 10:35:01.234188	23239	20.4	1	10
2014-03-26 10:35:01.464461	23240	43	2	10
2014-03-26 10:35:40.233645	23248	20.4	1	10
2014-03-26 10:35:40.455493	23249	43	2	10
2014-03-26 23:41:21.957092	33430	41	2	10
2014-03-26 23:41:32.044474	33431	21.2	1	9
2014-03-26 10:36:21.152455	23260	21.1	1	8
2014-03-26 10:36:21.374367	23261	56	2	8
2014-03-26 10:36:32.630153	23262	418	3	2
2014-03-26 10:36:36.091811	23263	20.4	1	1
2014-03-26 10:36:36.314323	23264	53	2	1
2014-03-26 23:41:32.291375	33432	47	2	9
2014-03-26 23:41:32.601661	33433	370	3	2
2014-03-26 10:37:00.15201	23269	21.1	1	8
2014-03-26 10:37:00.384595	23270	56	2	8
2014-03-26 10:37:15.091559	23271	20.4	1	1
2014-03-26 10:37:15.316827	23272	53	2	1
2014-03-26 10:37:32.626431	23273	434	3	2
2014-03-26 23:41:32.825895	33434	1088986.6944461833	4	2
2014-03-26 23:41:33.132974	33435	21.6	1	8
2014-03-26 10:37:39.154397	23278	21.1	1	8
2014-03-26 10:37:39.376169	23279	56	2	8
2014-03-26 10:37:54.08334	23280	20.4	1	1
2014-03-26 10:37:54.31725	23281	53	2	1
2014-03-26 23:41:33.368491	33436	47	2	8
2014-03-26 23:41:47.638633	33437	20.1	1	1
2014-03-26 10:38:18.151529	23286	21.1	1	8
2014-03-26 10:38:18.374454	23287	56	2	8
2014-03-26 10:38:32.631269	23288	466	3	2
2014-03-26 10:38:33.08765	23289	20.4	1	1
2014-03-26 10:38:33.310533	23290	53	2	1
2014-03-26 10:38:44.628661	23291	466	3	2
2014-03-26 23:41:47.861903	33438	50	2	1
2014-03-26 23:42:00.733895	33439	23.5	1	10
2014-03-26 10:38:57.150893	23296	21.1	1	8
2014-03-26 10:38:57.375151	23297	57	2	8
2014-03-26 10:39:12.085407	23298	20.4	1	1
2014-03-26 10:39:12.307091	23299	53	2	1
2014-03-26 10:39:32.627121	23300	498	3	2
2014-03-26 23:42:00.967484	33440	41	2	10
2014-03-26 23:42:11.043535	33441	21.2	1	9
2014-03-26 10:39:36.155283	23305	21.1	1	8
2014-03-26 10:39:36.377224	23306	57	2	8
2014-03-26 10:39:44.625689	23307	498	3	2
2014-03-26 10:39:51.08367	23308	20.4	1	1
2014-03-26 10:39:51.30638	23309	53	2	1
2014-03-26 23:42:11.267098	33442	47	2	9
2014-03-26 23:42:12.13353	33443	21.6	1	8
2014-03-26 10:40:15.152577	23314	21.1	1	8
2014-03-26 10:40:15.384265	23315	57	2	8
2014-03-26 10:40:30.084645	23316	20.4	1	1
2014-03-26 10:40:30.307256	23317	53	2	1
2014-03-26 10:40:32.627166	23318	498	3	2
2014-03-26 23:42:12.367292	33444	47	2	8
2014-03-26 23:42:26.631951	33445	20.1	1	1
2014-03-26 10:40:54.152628	23323	21.1	1	8
2014-03-26 10:40:54.375087	23324	57	2	8
2014-03-26 10:40:56.630972	23325	531	3	2
2014-03-26 10:41:08.629213	23326	531	3	2
2014-03-26 10:41:09.086043	23327	20.4	1	1
2014-03-26 10:41:09.308025	23328	53	2	1
2014-03-26 23:42:26.856658	33446	50	2	1
2014-03-26 23:42:32.545824	33447	370	3	2
2014-03-26 10:41:32.626366	23333	547	3	2
2014-03-26 10:41:33.152301	23334	21.1	1	8
2014-03-26 10:41:33.373133	23335	57	2	8
2014-03-26 10:41:48.087324	23336	20.4	1	1
2014-03-26 10:41:48.318717	23337	53	2	1
2014-03-26 23:42:32.778712	33448	1088992.4396197903	4	2
2014-03-26 23:42:39.733962	33449	23.5	1	10
2014-03-26 10:42:12.152526	23342	21.1	1	8
2014-03-26 10:42:12.374064	23343	57	2	8
2014-03-26 10:42:27.086219	23344	20.4	1	1
2014-03-26 10:42:27.318764	23345	53	2	1
2014-03-26 10:42:32.629674	23346	531	3	2
2014-03-26 23:42:39.958999	33450	41	2	10
2014-03-26 23:42:50.043727	33451	21.2	1	9
2014-03-26 10:42:51.153322	23351	21.1	1	8
2014-03-26 10:42:51.377094	23352	57	2	8
2014-03-26 10:43:06.085023	23353	20.4	1	1
2014-03-26 10:43:06.309214	23354	53	2	1
2014-03-26 23:42:50.278855	33452	47	2	9
2014-03-26 23:42:51.133607	33453	21.6	1	8
2014-03-26 10:43:30.151009	23359	21.1	1	8
2014-03-26 10:43:30.384961	23360	57	2	8
2014-03-26 10:43:44.887982	23361	547	3	2
2014-03-26 10:43:45.195494	23362	20.4	1	1
2014-03-26 10:43:45.420069	23363	53	2	1
2014-03-26 23:42:51.356522	33454	47	2	8
2014-03-26 23:43:05.638001	33455	20.1	1	1
2014-03-26 10:44:09.152567	23368	21.1	1	8
2014-03-26 10:44:09.376972	23369	57	2	8
2014-03-26 10:44:24.087563	23370	20.4	1	1
2014-03-26 10:44:24.308851	23371	53	2	1
2014-03-26 10:44:32.629481	23372	531	3	2
2014-03-26 23:43:05.873049	33456	50	2	1
2014-03-26 23:43:18.734097	33457	23.5	1	10
2014-03-26 10:44:48.151505	23377	21.1	1	8
2014-03-26 10:44:48.372535	23378	57	2	8
2014-03-26 10:45:03.083806	23379	20.4	1	1
2014-03-26 10:45:03.307776	23380	53	2	1
2014-03-26 23:43:18.959215	33458	41	2	10
2014-03-26 23:43:20.546853	33459	338	3	2
2014-03-26 10:45:27.152203	23385	21.1	1	8
2014-03-26 10:45:27.38347	23386	57	2	8
2014-03-26 10:45:32.631014	23387	547	3	2
2014-03-26 10:45:42.079225	23388	20.4	1	1
2014-03-26 10:45:42.304274	23389	53	2	1
2014-03-26 10:36:19.456565	23257	43	2	10
2014-03-26 10:36:58.234284	23265	20.4	1	10
2014-03-26 10:36:58.46541	23266	43	2	10
2014-03-26 10:37:37.23467	23274	20.4	1	10
2014-03-26 10:37:37.460786	23275	43	2	10
2014-03-26 10:38:16.235211	23282	20.4	1	10
2014-03-26 10:38:16.457666	23283	43	2	10
2014-03-26 10:38:55.234755	23292	20.4	1	10
2014-03-26 10:38:55.464009	23293	43	2	10
2014-03-26 10:39:34.234155	23301	20.4	1	10
2014-03-26 10:39:34.455241	23302	43	2	10
2014-03-26 10:40:13.235407	23310	20.4	1	10
2014-03-26 10:40:13.467206	23311	43	2	10
2014-03-26 10:40:52.236144	23319	20.4	1	10
2014-03-26 10:40:52.459032	23320	43	2	10
2014-03-26 10:41:31.235815	23329	20.4	1	10
2014-03-26 10:41:31.465671	23330	43	2	10
2014-03-26 10:42:10.236104	23338	20.4	1	10
2014-03-26 10:42:10.459414	23339	43	2	10
2014-03-26 10:42:49.237469	23347	20.4	1	10
2014-03-26 10:42:49.463337	23348	43	2	10
2014-03-26 10:43:28.238287	23355	20.4	1	10
2014-03-26 10:43:28.46017	23356	43	2	10
2014-03-26 10:44:07.237149	23364	20.4	1	10
2014-03-26 10:44:07.463496	23365	43	2	10
2014-03-26 10:44:46.244779	23373	20.4	1	10
2014-03-26 10:44:46.466439	23374	43	2	10
2014-03-26 10:45:25.237856	23381	20.4	1	10
2014-03-26 10:45:25.469034	23382	43	2	10
2014-03-26 23:43:20.781614	33460	1088997.035758676	4	2
2014-03-26 10:46:06.152248	23394	21.1	1	8
2014-03-26 10:46:06.373526	23395	57	2	8
2014-03-26 10:46:08.626965	23396	515	3	2
2014-03-26 10:46:20.625678	23397	515	3	2
2014-03-26 10:46:21.083136	23398	20.4	1	1
2014-03-26 10:46:21.306689	23399	53	2	1
2014-03-26 10:46:32.628957	23400	515	3	2
2014-03-26 23:43:29.044412	33461	21.2	1	9
2014-03-26 23:43:29.268768	33462	47	2	9
2014-03-26 10:46:45.150832	23405	21.1	1	8
2014-03-26 10:46:45.39485	23406	58	2	8
2014-03-26 10:47:00.084667	23407	20.4	1	1
2014-03-26 10:47:00.307033	23408	53	2	1
2014-03-26 10:47:20.630724	23409	611	3	2
2014-03-26 23:43:30.13203	33463	21.6	1	8
2014-03-26 23:43:30.365668	33464	47	2	8
2014-03-26 10:47:24.150976	23414	21.1	1	8
2014-03-26 10:47:24.37225	23415	58	2	8
2014-03-26 10:47:32.62726	23416	611	3	2
2014-03-26 10:47:39.08316	23417	20.4	1	1
2014-03-26 10:47:39.318195	23418	53	2	1
2014-03-26 23:43:32.550451	33465	338	3	2
2014-03-26 23:43:32.775052	33466	1088998.1847933973	4	2
2014-03-26 10:48:03.152224	23423	21.1	1	8
2014-03-26 10:48:03.374878	23424	58	2	8
2014-03-26 10:48:18.085778	23425	20.4	1	1
2014-03-26 10:48:18.320367	23426	53	2	1
2014-03-26 10:48:32.632626	23427	611	3	2
2014-03-26 23:43:44.636593	33467	20.1	1	1
2014-03-26 23:43:44.872252	33468	50	2	1
2014-03-26 10:48:42.150924	23432	21.1	1	8
2014-03-26 10:48:42.376859	23433	57	2	8
2014-03-26 10:48:57.081955	23434	20.4	1	1
2014-03-26 10:48:57.306171	23435	53	2	1
2014-03-26 23:43:57.737323	33469	23.5	1	10
2014-03-26 23:43:57.96131	33470	41	2	10
2014-03-26 10:49:21.153602	23440	21.1	1	8
2014-03-26 10:49:21.38697	23441	57	2	8
2014-03-26 10:49:32.628503	23442	627	3	2
2014-03-26 10:49:36.075701	23443	20.4	1	1
2014-03-26 10:49:36.297715	23444	53	2	1
2014-03-26 23:44:08.044505	33471	21.2	1	9
2014-03-26 23:44:08.278252	33472	47	2	9
2014-03-26 10:50:00.152558	23449	21.1	1	8
2014-03-26 10:50:00.373781	23450	57	2	8
2014-03-26 10:50:15.081702	23451	20.4	1	1
2014-03-26 10:50:15.324859	23452	53	2	1
2014-03-26 10:50:32.631232	23453	627	3	2
2014-03-26 23:44:09.133351	33473	21.6	1	8
2014-03-26 23:44:09.355718	33474	47	2	8
2014-03-26 10:50:39.151271	23458	21.1	1	8
2014-03-26 10:50:39.381721	23459	57	2	8
2014-03-26 10:50:54.07753	23460	20.4	1	1
2014-03-26 10:50:54.2983	23461	53	2	1
2014-03-26 23:44:23.633085	33475	20.1	1	1
2014-03-26 23:44:23.869483	33476	50	2	1
2014-03-26 10:51:18.151449	23466	21.2	1	8
2014-03-26 10:51:18.384392	23467	57	2	8
2014-03-26 10:51:32.627649	23468	627	3	2
2014-03-26 10:51:33.081145	23469	20.4	1	1
2014-03-26 10:51:33.301622	23470	53	2	1
2014-03-26 10:51:44.628316	23471	579	3	2
2014-03-26 23:44:32.549428	33477	338	3	2
2014-03-26 23:44:32.775458	33478	1089003.9299670043	4	2
2014-03-26 10:51:56.627775	23476	579	3	2
2014-03-26 10:51:57.151738	23477	21.2	1	8
2014-03-26 10:51:57.37372	23478	56	2	8
2014-03-26 10:52:12.07943	23479	20.4	1	1
2014-03-26 10:52:12.301398	23480	53	2	1
2014-03-26 10:52:32.628849	23481	579	3	2
2014-03-26 23:44:36.736588	33479	23.4	1	10
2014-03-26 23:44:36.982239	33480	41	2	10
2014-03-26 10:52:36.152808	23486	21.2	1	8
2014-03-26 10:52:36.386661	23487	56	2	8
2014-03-26 10:52:44.627858	23488	627	3	2
2014-03-26 10:52:51.079984	23489	20.4	1	1
2014-03-26 10:52:51.302437	23490	53	2	1
2014-03-26 10:52:56.626028	23491	627	3	2
2014-03-26 23:44:47.043858	33481	21.2	1	9
2014-03-26 23:44:47.267165	33482	47	2	9
2014-03-26 10:53:15.152997	23496	21.2	1	8
2014-03-26 10:53:15.375438	23497	56	2	8
2014-03-26 10:53:30.07851	23498	20.4	1	1
2014-03-26 10:53:30.30288	23499	54	2	1
2014-03-26 10:53:32.62858	23500	627	3	2
2014-03-26 23:44:48.132561	33483	21.6	1	8
2014-03-26 23:44:48.366554	33484	47	2	8
2014-03-26 10:53:54.151876	23505	21.2	1	8
2014-03-26 10:53:54.375641	23506	56	2	8
2014-03-26 10:54:09.081659	23507	20.4	1	1
2014-03-26 10:54:09.314926	23508	54	2	1
2014-03-26 10:54:31.040145	23509	676	3	2
2014-03-26 23:45:02.635798	33485	20.1	1	1
2014-03-26 23:45:02.860741	33486	50	2	1
2014-03-26 10:54:32.622576	23514	676	3	2
2014-03-26 10:54:33.152807	23515	21.2	1	8
2014-03-26 10:54:33.377569	23516	56	2	8
2014-03-26 10:54:44.625209	23517	595	3	2
2014-03-26 10:54:48.079083	23518	20.4	1	1
2014-03-26 10:54:48.310524	23519	54	2	1
2014-03-26 10:54:56.627645	23520	515	3	2
2014-03-26 10:55:08.627906	23521	515	3	2
2014-03-26 10:55:12.151581	23526	21.2	1	8
2014-03-26 10:55:12.384703	23527	56	2	8
2014-03-26 10:55:27.079607	23528	20.4	1	1
2014-03-26 10:46:43.238312	23401	20.3	1	10
2014-03-26 10:46:43.45986	23402	43	2	10
2014-03-26 10:47:22.237327	23410	20.3	1	10
2014-03-26 10:47:22.459384	23411	43	2	10
2014-03-26 10:48:01.238975	23419	20.3	1	10
2014-03-26 10:48:01.460754	23420	43	2	10
2014-03-26 10:48:40.241341	23428	20.3	1	10
2014-03-26 10:48:40.483876	23429	43	2	10
2014-03-26 10:49:19.239126	23436	20.3	1	10
2014-03-26 10:49:19.473227	23437	43	2	10
2014-03-26 10:49:58.23811	23445	20.3	1	10
2014-03-26 10:49:58.461955	23446	43	2	10
2014-03-26 10:50:37.240568	23454	20.3	1	10
2014-03-26 10:50:37.461279	23455	43	2	10
2014-03-26 10:51:16.239122	23462	20.3	1	10
2014-03-26 10:51:16.468879	23463	43	2	10
2014-03-26 10:51:55.239523	23472	20.3	1	10
2014-03-26 10:51:55.461335	23473	43	2	10
2014-03-26 10:52:34.242398	23482	20.3	1	10
2014-03-26 10:52:34.475768	23483	43	2	10
2014-03-26 10:53:13.240713	23492	20.3	1	10
2014-03-26 10:53:13.463927	23493	43	2	10
2014-03-26 10:53:52.241568	23501	20.3	1	10
2014-03-26 10:53:52.46425	23502	43	2	10
2014-03-26 10:54:31.34793	23510	20.3	1	10
2014-03-26 10:54:31.572341	23511	43	2	10
2014-03-26 10:55:10.241351	23522	20.3	1	10
2014-03-26 10:55:27.303161	23529	54	2	1
2014-03-26 10:55:32.626066	23530	547	3	2
2014-03-26 10:55:44.628667	23531	547	3	2
2014-03-26 23:45:15.734599	33487	23.4	1	10
2014-03-26 23:45:15.971464	33488	41	2	10
2014-03-26 10:55:51.152899	23536	21.2	1	8
2014-03-26 10:55:51.375351	23537	56	2	8
2014-03-26 10:56:06.083611	23538	20.4	1	1
2014-03-26 10:56:06.315779	23539	54	2	1
2014-03-26 23:45:26.043292	33489	21.2	1	9
2014-03-26 23:45:26.266215	33490	47	2	9
2014-03-26 10:56:30.153311	23544	21.2	1	8
2014-03-26 10:56:30.373447	23545	56	2	8
2014-03-26 10:56:32.626069	23546	547	3	2
2014-03-26 10:56:44.628698	23547	579	3	2
2014-03-26 10:56:45.082271	23548	20.4	1	1
2014-03-26 10:56:45.30382	23549	54	2	1
2014-03-26 10:56:56.630733	23550	547	3	2
2014-03-26 23:45:27.133026	33491	21.6	1	8
2014-03-26 23:45:27.366657	33492	47	2	8
2014-03-26 10:57:08.626672	23555	547	3	2
2014-03-26 10:57:09.153102	23556	21.2	1	8
2014-03-26 10:57:09.37591	23557	56	2	8
2014-03-26 10:57:24.083293	23558	20.4	1	1
2014-03-26 10:57:24.305774	23559	54	2	1
2014-03-26 10:57:32.629648	23560	531	3	2
2014-03-26 23:45:32.550777	33493	338	3	2
2014-03-26 23:45:32.775014	33494	1089009.6751406114	4	2
2014-03-26 10:57:48.152561	23565	21.1	1	8
2014-03-26 10:57:48.375014	23566	55	2	8
2014-03-26 10:58:03.084406	23567	20.4	1	1
2014-03-26 10:58:03.306509	23568	54	2	1
2014-03-26 10:58:08.624494	23569	498	3	2
2014-03-26 10:58:20.629546	23570	498	3	2
2014-03-26 23:45:41.633723	33495	20.1	1	1
2014-03-26 23:45:41.870241	33496	50	2	1
2014-03-26 10:58:27.482603	23575	21.1	1	8
2014-03-26 10:58:27.716832	23576	55	2	8
2014-03-26 10:58:32.624739	23577	498	3	2
2014-03-26 10:58:42.083959	23578	20.4	1	1
2014-03-26 10:58:42.307193	23579	54	2	1
2014-03-26 23:45:44.543416	33497	305	3	2
2014-03-26 23:45:44.766484	33498	1089010.824175333	4	2
2014-03-26 10:59:06.150444	23584	21.1	1	8
2014-03-26 10:59:06.377475	23585	55	2	8
2014-03-26 10:59:21.079462	23586	20.4	1	1
2014-03-26 10:59:21.330249	23587	54	2	1
2014-03-26 10:59:32.627904	23588	498	3	2
2014-03-26 23:45:54.734988	33499	23.4	1	10
2014-03-26 23:45:54.970752	33500	41	2	10
2014-03-26 10:59:45.150969	23593	21.1	1	8
2014-03-26 10:59:45.374624	23594	55	2	8
2014-03-26 11:00:00.077575	23595	20.4	1	1
2014-03-26 11:00:00.300046	23596	54	2	1
2014-03-26 23:45:56.546672	33501	338	3	2
2014-03-26 23:45:56.770197	33502	1089011.9732100542	4	2
2014-03-26 11:00:24.150044	23601	21.1	1	8
2014-03-26 11:00:24.383577	23602	55	2	8
2014-03-26 11:00:32.630938	23603	498	3	2
2014-03-26 11:00:39.081023	23604	20.4	1	1
2014-03-26 11:00:39.30311	23605	54	2	1
2014-03-26 23:46:05.045404	33503	21.2	1	9
2014-03-26 23:46:05.278323	33504	47	2	9
2014-03-26 11:01:03.151502	23610	21.1	1	8
2014-03-26 11:01:03.373373	23611	55	2	8
2014-03-26 11:01:18.082089	23612	20.4	1	1
2014-03-26 11:01:18.314128	23613	54	2	1
2014-03-26 11:01:32.630531	23614	498	3	2
2014-03-26 23:46:06.133389	33505	21.6	1	8
2014-03-26 23:46:06.35654	33506	47	2	8
2014-03-26 11:01:42.150255	23619	21.1	1	8
2014-03-26 11:01:42.372357	23620	55	2	8
2014-03-26 11:01:57.078019	23621	20.4	1	1
2014-03-26 11:01:57.299749	23622	54	2	1
2014-03-26 23:46:08.545931	33507	338	3	2
2014-03-26 23:46:08.779705	33508	1089013.1222447758	4	2
2014-03-26 11:02:21.151685	23627	21.1	1	8
2014-03-26 11:02:21.389924	23628	55	2	8
2014-03-26 11:02:32.628127	23629	498	3	2
2014-03-26 11:02:36.077836	23630	20.4	1	1
2014-03-26 11:02:36.32216	23631	54	2	1
2014-03-26 23:46:20.631443	33509	20.1	1	1
2014-03-26 23:46:20.859532	33510	50	2	1
2014-03-26 11:03:00.489611	23636	21.1	1	8
2014-03-26 11:03:00.710409	23637	55	2	8
2014-03-26 11:03:15.077435	23638	20.4	1	1
2014-03-26 11:03:15.329797	23639	54	2	1
2014-03-26 11:03:32.624932	23640	498	3	2
2014-03-26 23:46:32.548148	33511	338	3	2
2014-03-26 23:46:32.784095	33512	1089015.4203142186	4	2
2014-03-26 11:03:39.150999	23645	21.1	1	8
2014-03-26 11:03:39.373256	23646	55	2	8
2014-03-26 11:03:44.629222	23647	579	3	2
2014-03-26 11:03:54.079686	23648	20.4	1	1
2014-03-26 11:03:54.302753	23649	54	2	1
2014-03-26 11:03:56.62713	23650	579	3	2
2014-03-26 23:46:33.735043	33513	23.4	1	10
2014-03-26 23:46:33.95758	33514	41	2	10
2014-03-26 11:04:18.152862	23655	21.1	1	8
2014-03-26 11:04:18.374175	23656	55	2	8
2014-03-26 11:04:32.629406	23657	579	3	2
2014-03-26 11:04:33.080077	23658	20.4	1	1
2014-03-26 11:04:33.304767	23659	54	2	1
2014-03-26 23:46:44.043175	33515	21.2	1	9
2014-03-26 11:04:56.629101	23664	627	3	2
2014-03-26 10:55:49.242339	23532	20.2	1	10
2014-03-26 10:55:49.46628	23533	43	2	10
2014-03-26 10:56:28.243933	23540	20.2	1	10
2014-03-26 10:56:28.466114	23541	43	2	10
2014-03-26 10:57:07.240924	23551	20.2	1	10
2014-03-26 10:57:07.466527	23552	43	2	10
2014-03-26 10:57:46.242811	23561	20.2	1	10
2014-03-26 10:57:46.465949	23562	43	2	10
2014-03-26 10:58:25.242516	23571	20.2	1	10
2014-03-26 10:58:25.476691	23572	43	2	10
2014-03-26 10:59:04.244672	23580	20.2	1	10
2014-03-26 10:59:04.467348	23581	43	2	10
2014-03-26 10:59:43.252179	23589	20.2	1	10
2014-03-26 10:59:43.476627	23590	43	2	10
2014-03-26 11:00:22.243152	23597	20.2	1	10
2014-03-26 11:00:22.47516	23598	43	2	10
2014-03-26 11:01:01.242475	23606	20.2	1	10
2014-03-26 11:01:01.466391	23607	43	2	10
2014-03-26 11:01:40.242877	23615	20.2	1	10
2014-03-26 11:01:40.464354	23616	43	2	10
2014-03-26 11:02:19.243093	23623	20.2	1	10
2014-03-26 11:02:19.474561	23624	43	2	10
2014-03-26 11:02:58.243423	23632	20.2	1	10
2014-03-26 11:02:58.467131	23633	43	2	10
2014-03-26 11:03:37.243429	23641	20.2	1	10
2014-03-26 11:03:37.465041	23642	43	2	10
2014-03-26 11:04:16.245958	23651	20.2	1	10
2014-03-26 11:04:16.52347	23652	43	2	10
2014-03-26 11:04:57.150946	23665	21.1	1	8
2014-03-26 11:04:57.387988	23666	55	2	8
2014-03-26 11:05:08.628601	23667	627	3	2
2014-03-26 11:05:12.073311	23668	20.4	1	1
2014-03-26 11:05:12.297095	23669	54	2	1
2014-03-26 11:05:32.626261	23670	627	3	2
2014-03-26 23:46:44.279095	33516	47	2	9
2014-03-26 23:46:45.133957	33517	21.5	1	8
2014-03-26 11:05:36.151732	23675	21.1	1	8
2014-03-26 11:05:36.37516	23676	55	2	8
2014-03-26 11:05:51.076059	23677	20.4	1	1
2014-03-26 11:05:51.373375	23678	54	2	1
2014-03-26 23:46:45.356503	33518	47	2	8
2014-03-26 23:46:59.633044	33519	20.1	1	1
2014-03-26 11:06:15.151344	23683	21.1	1	8
2014-03-26 11:06:15.376598	23684	55	2	8
2014-03-26 11:06:30.075164	23685	20.4	1	1
2014-03-26 11:06:30.308249	23686	54	2	1
2014-03-26 11:06:32.629041	23687	611	3	2
2014-03-26 23:46:59.870845	33520	50	2	1
2014-03-26 23:47:08.548719	33521	305	3	2
2014-03-26 11:06:54.47803	23692	21.1	1	8
2014-03-26 11:06:54.701303	23693	55	2	8
2014-03-26 11:07:09.075879	23694	20.4	1	1
2014-03-26 11:07:09.298218	23695	54	2	1
2014-03-26 23:47:08.772875	33522	1089018.8674183828	4	2
2014-03-26 23:47:12.73569	33523	23.4	1	10
2014-03-26 11:07:32.629976	23700	611	3	2
2014-03-26 11:07:33.151675	23701	21.1	1	8
2014-03-26 11:07:33.373837	23702	55	2	8
2014-03-26 11:07:48.07626	23703	20.4	1	1
2014-03-26 11:07:48.309848	23704	54	2	1
2014-03-26 23:47:12.970601	33524	41	2	10
2014-03-26 23:47:20.546021	33525	338	3	2
2014-03-26 11:08:12.151734	23709	21.1	1	8
2014-03-26 11:08:12.375144	23710	55	2	8
2014-03-26 11:08:27.074535	23711	20.4	1	1
2014-03-26 11:08:27.306263	23712	54	2	1
2014-03-26 11:08:32.627244	23713	611	3	2
2014-03-26 23:47:20.770272	33526	1089020.016453104	4	2
2014-03-26 23:47:23.046336	33527	21.2	1	9
2014-03-26 11:08:51.150943	23718	21.1	1	8
2014-03-26 11:08:51.42887	23719	55	2	8
2014-03-26 11:09:06.074955	23720	20.4	1	1
2014-03-26 11:09:06.298003	23721	54	2	1
2014-03-26 23:47:23.293255	33528	47	2	9
2014-03-26 23:47:24.132233	33529	21.5	1	8
2014-03-26 11:09:30.152705	23726	21.1	1	8
2014-03-26 11:09:30.385266	23727	55	2	8
2014-03-26 11:09:32.630466	23728	611	3	2
2014-03-26 11:09:45.075595	23729	20.4	1	1
2014-03-26 11:09:45.299822	23730	54	2	1
2014-03-26 23:47:24.356372	33530	47	2	8
2014-03-26 23:47:32.546502	33531	338	3	2
2014-03-26 11:10:09.152692	23735	21.1	1	8
2014-03-26 11:10:09.376914	23736	55	2	8
2014-03-26 11:10:24.075676	23737	20.4	1	1
2014-03-26 11:10:24.310937	23738	54	2	1
2014-03-26 11:10:32.625831	23739	611	3	2
2014-03-26 11:10:44.627183	23740	547	3	2
2014-03-26 23:47:32.783061	33532	1089021.1654878256	4	2
2014-03-26 23:47:38.634515	33533	20.1	1	1
2014-03-26 11:10:48.152352	23745	21.1	1	8
2014-03-26 11:10:48.38592	23746	55	2	8
2014-03-26 11:10:56.625766	23747	547	3	2
2014-03-26 11:11:03.073961	23748	20.4	1	1
2014-03-26 11:11:03.296602	23749	54	2	1
2014-03-26 23:47:38.886955	33534	50	2	1
2014-03-26 23:47:51.734982	33535	23.4	1	10
2014-03-26 11:11:27.152331	23754	21.1	1	8
2014-03-26 11:11:27.374511	23755	55	2	8
2014-03-26 11:11:32.626109	23756	547	3	2
2014-03-26 11:11:42.072659	23757	20.4	1	1
2014-03-26 11:11:42.29701	23758	54	2	1
2014-03-26 11:11:44.628817	23759	515	3	2
2014-03-26 11:11:56.629616	23760	515	3	2
2014-03-26 23:47:51.968451	33536	41	2	10
2014-03-26 23:48:02.04324	33537	21.1	1	9
2014-03-26 11:12:06.486085	23765	21.1	1	8
2014-03-26 11:12:06.710691	23766	54	2	8
2014-03-26 11:12:21.071998	23767	20.4	1	1
2014-03-26 11:12:21.314486	23768	54	2	1
2014-03-26 11:12:32.627887	23769	515	3	2
2014-03-26 23:48:02.267808	33538	47	2	9
2014-03-26 23:48:03.132368	33539	21.5	1	8
2014-03-26 11:12:45.151274	23774	21.1	1	8
2014-03-26 11:12:45.375472	23775	54	2	8
2014-03-26 11:13:00.073578	23776	20.4	1	1
2014-03-26 11:13:00.29724	23777	54	2	1
2014-03-26 11:13:08.628823	23778	547	3	2
2014-03-26 11:13:20.626618	23779	547	3	2
2014-03-26 23:48:03.367669	33540	47	2	8
2014-03-26 23:48:17.639005	33541	20.1	1	1
2014-03-26 11:13:24.49021	23784	21.1	1	8
2014-03-26 11:13:24.712626	23785	54	2	8
2014-03-26 11:13:32.626663	23786	547	3	2
2014-03-26 11:13:39.069665	23787	20.4	1	1
2014-03-26 11:13:39.292584	23788	54	2	1
2014-03-26 23:48:17.863772	33542	50	2	1
2014-03-26 23:48:30.734449	33543	23.4	1	10
2014-03-26 23:48:30.969259	33544	41	2	10
2014-03-26 11:14:03.150779	23793	21.1	1	8
2014-03-26 11:14:03.38299	23794	54	2	8
2014-03-26 11:14:18.075044	23795	20.4	1	1
2014-03-26 11:14:18.296854	23796	54	2	1
2014-03-26 11:14:32.62895	23797	515	3	2
2014-03-26 11:05:34.244714	23671	20.2	1	10
2014-03-26 11:05:34.468687	23672	43	2	10
2014-03-26 11:06:13.245125	23679	20.1	1	10
2014-03-26 11:06:13.467837	23680	43	2	10
2014-03-26 11:06:52.244119	23688	20.1	1	10
2014-03-26 11:06:52.467349	23689	43	2	10
2014-03-26 11:07:31.252078	23696	20.1	1	10
2014-03-26 11:07:31.474043	23697	43	2	10
2014-03-26 11:08:10.245438	23705	20.1	1	10
2014-03-26 11:08:10.468992	23706	43	2	10
2014-03-26 11:08:49.245026	23714	20.1	1	10
2014-03-26 11:08:49.468047	23715	43	2	10
2014-03-26 11:09:28.244773	23722	20.1	1	10
2014-03-26 11:09:28.487113	23723	43	2	10
2014-03-26 11:10:07.248493	23731	20.1	1	10
2014-03-26 11:10:07.47178	23732	43	2	10
2014-03-26 11:10:46.248905	23741	20.1	1	10
2014-03-26 11:10:46.482822	23742	43	2	10
2014-03-26 11:11:25.247273	23750	20.1	1	10
2014-03-26 11:11:25.471964	23751	43	2	10
2014-03-26 11:12:04.247624	23761	20.1	1	10
2014-03-26 11:12:04.470477	23762	43	2	10
2014-03-26 11:12:43.247866	23770	20.1	1	10
2014-03-26 11:12:43.472359	23771	43	2	10
2014-03-26 11:13:22.247807	23780	20.1	1	10
2014-03-26 11:13:22.472008	23781	43	2	10
2014-03-26 11:14:01.247447	23789	20.1	1	10
2014-03-26 23:48:32.545697	33545	338	3	2
2014-03-26 11:14:42.153781	23802	21.1	1	8
2014-03-26 11:14:42.375442	23803	54	2	8
2014-03-26 11:14:44.625446	23804	515	3	2
2014-03-26 11:14:57.072817	23805	20.4	1	1
2014-03-26 11:14:57.308244	23806	54	2	1
2014-03-26 23:48:32.771613	33546	1089026.9106614327	4	2
2014-03-26 23:48:41.042897	33547	21.1	1	9
2014-03-26 11:15:21.152223	23811	21.0	1	8
2014-03-26 11:15:21.376032	23812	54	2	8
2014-03-26 11:15:32.628752	23813	515	3	2
2014-03-26 11:15:36.070635	23814	20.4	1	1
2014-03-26 11:15:36.293852	23815	54	2	1
2014-03-26 23:48:41.277025	33548	47	2	9
2014-03-26 23:48:42.132664	33549	21.5	1	8
2014-03-26 11:16:00.151795	23820	21.0	1	8
2014-03-26 11:16:00.373983	23821	54	2	8
2014-03-26 11:16:15.06975	23822	20.4	1	1
2014-03-26 11:16:15.293291	23823	54	2	1
2014-03-26 11:16:32.627786	23824	515	3	2
2014-03-26 23:48:42.355938	33550	47	2	8
2014-03-26 23:48:56.633943	33551	20.1	1	1
2014-03-26 11:16:39.151441	23829	21.0	1	8
2014-03-26 11:16:39.383816	23830	54	2	8
2014-03-26 11:16:54.062297	23831	20.5	1	1
2014-03-26 11:16:54.285008	23832	54	2	1
2014-03-26 23:48:56.868285	33552	50	2	1
2014-03-26 23:49:09.737319	33553	23.4	1	10
2014-03-26 11:17:18.151996	23837	21.0	1	8
2014-03-26 11:17:18.383375	23838	54	2	8
2014-03-26 11:17:20.62622	23839	579	3	2
2014-03-26 11:17:32.63085	23840	579	3	2
2014-03-26 11:17:33.069638	23841	20.5	1	1
2014-03-26 11:17:33.304413	23842	54	2	1
2014-03-26 23:49:09.960518	33554	41	2	10
2014-03-26 23:49:20.043441	33555	21.1	1	9
2014-03-26 11:17:56.626402	23847	547	3	2
2014-03-26 11:17:57.154115	23848	21.1	1	8
2014-03-26 11:17:57.376756	23849	55	2	8
2014-03-26 11:18:08.625525	23850	498	3	2
2014-03-26 11:18:12.06974	23851	20.4	1	1
2014-03-26 11:18:12.293175	23852	54	2	1
2014-03-26 11:18:20.625586	23853	498	3	2
2014-03-26 11:18:32.623625	23854	482	3	2
2014-03-26 23:49:20.277473	33556	47	2	9
2014-03-26 23:49:20.58578	33557	305	3	2
2014-03-26 11:18:36.152645	23859	21.1	1	8
2014-03-26 11:18:36.395651	23860	55	2	8
2014-03-26 11:18:51.067939	23861	20.4	1	1
2014-03-26 11:18:51.290487	23862	54	2	1
2014-03-26 23:49:20.812565	33558	1089031.5068003184	4	2
2014-03-26 23:49:21.132886	33559	21.5	1	8
2014-03-26 11:19:15.151836	23867	21.1	1	8
2014-03-26 11:19:15.383409	23868	55	2	8
2014-03-26 11:19:30.064872	23869	20.4	1	1
2014-03-26 11:19:30.286866	23870	54	2	1
2014-03-26 11:19:32.622996	23871	482	3	2
2014-03-26 23:49:21.366115	33560	47	2	8
2014-03-26 23:49:32.547008	33561	338	3	2
2014-03-26 11:19:54.152681	23876	21.1	1	8
2014-03-26 11:19:54.37446	23877	55	2	8
2014-03-26 11:20:09.062461	23878	20.4	1	1
2014-03-26 11:20:09.297504	23879	54	2	1
2014-03-26 23:49:32.773221	33562	1089032.6558350397	4	2
2014-03-26 23:49:35.630237	33563	20.1	1	1
2014-03-26 11:20:32.624912	23884	482	3	2
2014-03-26 11:20:33.152731	23885	21.0	1	8
2014-03-26 11:20:33.379048	23886	55	2	8
2014-03-26 11:20:48.063692	23887	20.4	1	1
2014-03-26 11:20:48.29281	23888	54	2	1
2014-03-26 23:49:35.865276	33564	50	2	1
2014-03-26 23:49:44.544033	33565	338	3	2
2014-03-26 11:21:12.509973	23893	21.0	1	8
2014-03-26 11:21:12.952002	23894	54	2	8
2014-03-26 11:21:27.061468	23895	20.4	1	1
2014-03-26 11:21:27.287562	23896	54	2	1
2014-03-26 11:21:32.622916	23897	482	3	2
2014-03-26 23:49:44.769605	33566	1089033.8048697612	4	2
2014-03-26 23:49:58.842934	33567	23.4	1	10
2014-03-26 11:21:51.151343	23902	21.0	1	8
2014-03-26 11:21:51.374004	23903	54	2	8
2014-03-26 11:22:06.059155	23904	20.4	1	1
2014-03-26 11:22:06.303403	23905	54	2	1
2014-03-26 23:49:59.079659	33568	41	2	10
2014-03-26 23:49:59.38624	33569	21.1	1	9
2014-03-26 11:22:30.151988	23910	21.0	1	8
2014-03-26 11:22:30.374639	23911	54	2	8
2014-03-26 11:22:32.624377	23912	450	3	2
2014-03-26 11:22:44.625813	23913	466	3	2
2014-03-26 11:22:45.064216	23914	20.4	1	1
2014-03-26 11:22:45.287784	23915	54	2	1
2014-03-26 23:49:59.610016	33570	47	2	9
2014-03-26 23:50:00.133521	33571	21.5	1	8
2014-03-26 11:23:09.150863	23920	21.0	1	8
2014-03-26 11:23:09.373328	23921	54	2	8
2014-03-26 11:23:24.064011	23922	20.4	1	1
2014-03-26 11:23:24.331832	23923	54	2	1
2014-03-26 11:23:32.623484	23924	466	3	2
2014-03-26 23:50:00.366814	33572	47	2	8
2014-03-26 23:50:14.63393	33573	20.1	1	1
2014-03-26 11:23:48.150958	23929	21.0	1	8
2014-03-26 11:23:48.416313	23930	54	2	8
2014-03-26 11:24:03.058652	23931	20.4	1	1
2014-03-26 11:24:03.319571	23932	54	2	1
2014-03-26 11:15:19.251196	23807	20.1	1	10
2014-03-26 11:15:19.475938	23808	43	2	10
2014-03-26 11:15:58.249301	23816	20.1	1	10
2014-03-26 11:15:58.473831	23817	43	2	10
2014-03-26 11:16:37.248322	23825	20.1	1	10
2014-03-26 11:16:37.483199	23826	43	2	10
2014-03-26 11:17:16.247279	23833	20.1	1	10
2014-03-26 11:17:16.479632	23834	43	2	10
2014-03-26 11:17:55.249887	23843	20.1	1	10
2014-03-26 11:17:55.47167	23844	43	2	10
2014-03-26 11:18:34.249656	23855	20.1	1	10
2014-03-26 11:18:34.481593	23856	43	2	10
2014-03-26 11:19:13.251172	23863	20.1	1	10
2014-03-26 11:19:13.483455	23864	43	2	10
2014-03-26 11:19:52.250899	23872	20.1	1	10
2014-03-26 11:19:52.474512	23873	43	2	10
2014-03-26 11:20:31.252822	23880	20.1	1	10
2014-03-26 11:20:31.480851	23881	43	2	10
2014-03-26 11:21:10.379983	23889	20.1	1	10
2014-03-26 11:21:10.842409	23890	43	2	10
2014-03-26 11:21:49.252784	23898	20.1	1	10
2014-03-26 11:21:49.479232	23899	43	2	10
2014-03-26 11:22:28.252215	23906	20.1	1	10
2014-03-26 11:22:28.476356	23907	43	2	10
2014-03-26 11:23:07.251796	23916	20.0	1	10
2014-03-26 11:23:07.474847	23917	43	2	10
2014-03-26 11:23:46.251229	23925	20.0	1	10
2014-03-26 11:23:46.508993	23926	43	2	10
2014-03-26 11:24:25.2919	23933	20.0	1	10
2014-03-26 11:24:27.259975	23937	21.0	1	8
2014-03-26 11:24:27.581986	23938	54	2	8
2014-03-26 11:24:41.864099	23939	466	3	2
2014-03-26 11:24:42.173495	23940	20.4	1	1
2014-03-26 11:24:42.395752	23941	54	2	1
2014-03-26 23:50:14.859043	33574	50	2	1
2014-03-26 23:50:20.545384	33575	305	3	2
2014-03-26 11:25:06.15311	23946	21.0	1	8
2014-03-26 11:25:06.375601	23947	54	2	8
2014-03-26 11:25:21.062227	23948	20.4	1	1
2014-03-26 11:25:21.305354	23949	54	2	1
2014-03-26 11:25:32.623495	23950	450	3	2
2014-03-26 23:50:20.794662	33576	1089037.2519739254	4	2
2014-03-26 23:50:27.737137	33577	23.4	1	10
2014-03-26 11:25:45.15431	23955	21.0	1	8
2014-03-26 11:25:45.385594	23956	54	2	8
2014-03-26 11:26:00.060012	23957	20.4	1	1
2014-03-26 11:26:00.284115	23958	54	2	1
2014-03-26 11:26:20.62653	23959	498	3	2
2014-03-26 23:50:27.964378	33578	41	2	10
2014-03-26 23:50:32.546293	33579	305	3	2
2014-03-26 11:26:24.152025	23964	21.0	1	8
2014-03-26 11:26:24.375047	23965	54	2	8
2014-03-26 11:26:32.623689	23966	498	3	2
2014-03-26 11:26:39.058113	23967	20.4	1	1
2014-03-26 11:26:39.279227	23968	54	2	1
2014-03-26 23:50:32.780728	33580	1089037.2519739254	4	2
2014-03-26 23:50:38.045393	33581	21.1	1	9
2014-03-26 11:27:03.152557	23973	21.0	1	8
2014-03-26 11:27:03.38525	23974	54	2	8
2014-03-26 11:27:18.061849	23975	20.4	1	1
2014-03-26 11:27:18.283439	23976	54	2	1
2014-03-26 11:27:32.622325	23977	498	3	2
2014-03-26 23:50:38.270044	33582	47	2	9
2014-03-26 23:50:39.13212	33583	21.5	1	8
2014-03-26 11:27:42.152288	23982	21.0	1	8
2014-03-26 11:27:42.375045	23983	54	2	8
2014-03-26 11:27:57.063833	23984	20.4	1	1
2014-03-26 11:27:57.293701	23985	54	2	1
2014-03-26 23:50:39.366812	33584	47	2	8
2014-03-26 23:50:53.632041	33585	20.0	1	1
2014-03-26 11:28:21.153267	23990	21.0	1	8
2014-03-26 11:28:21.375297	23991	54	2	8
2014-03-26 11:28:32.625866	23992	482	3	2
2014-03-26 11:28:36.0637	23993	20.4	1	1
2014-03-26 11:28:36.286081	23994	54	2	1
2014-03-26 23:50:53.856903	33586	50	2	1
2014-03-26 23:50:56.545718	33587	370	3	2
2014-03-26 11:29:00.152964	23999	21.0	1	8
2014-03-26 11:29:00.375422	24000	54	2	8
2014-03-26 11:29:15.060397	24001	20.4	1	1
2014-03-26 11:29:15.289996	24002	54	2	1
2014-03-26 11:29:20.624995	24003	531	3	2
2014-03-26 11:29:32.624295	24004	515	3	2
2014-03-26 23:50:56.7894	33588	1089039.5500433682	4	2
2014-03-26 23:51:06.739001	33589	23.4	1	10
2014-03-26 11:29:39.153036	24009	21.0	1	8
2014-03-26 11:29:39.378226	24010	54	2	8
2014-03-26 11:29:54.060238	24011	20.4	1	1
2014-03-26 11:29:54.291144	24012	54	2	1
2014-03-26 23:51:06.966227	33590	41	2	10
2014-03-26 23:51:08.544473	33591	370	3	2
2014-03-26 11:30:18.152731	24017	21.0	1	8
2014-03-26 11:30:18.375697	24018	54	2	8
2014-03-26 11:30:32.626505	24019	531	3	2
2014-03-26 11:30:33.061398	24020	20.4	1	1
2014-03-26 11:30:33.283944	24021	54	2	1
2014-03-26 23:51:08.779764	33592	1089040.6990780896	4	2
2014-03-26 23:51:17.04429	33593	21.1	1	9
2014-03-26 11:30:57.154226	24026	21.0	1	8
2014-03-26 11:30:57.393991	24027	54	2	8
2014-03-26 11:31:12.059498	24028	20.4	1	1
2014-03-26 11:31:12.282789	24029	54	2	1
2014-03-26 11:31:32.625037	24030	531	3	2
2014-03-26 23:51:17.269206	33594	47	2	9
2014-03-26 23:51:18.135183	33595	21.5	1	8
2014-03-26 11:31:36.153363	24035	21.0	1	8
2014-03-26 11:31:36.37682	24036	54	2	8
2014-03-26 11:31:51.059575	24037	20.4	1	1
2014-03-26 11:31:51.304307	24038	54	2	1
2014-03-26 23:51:18.368749	33596	47	2	8
2014-03-26 23:51:32.872673	33597	20.0	1	1
2014-03-26 11:32:15.151319	24043	21.0	1	8
2014-03-26 11:32:15.377953	24044	54	2	8
2014-03-26 11:32:30.059091	24045	20.4	1	1
2014-03-26 11:32:30.289982	24046	54	2	1
2014-03-26 11:32:32.626485	24047	531	3	2
2014-03-26 23:51:33.09826	33598	50	2	1
2014-03-26 23:51:45.738559	33599	23.4	1	10
2014-03-26 11:32:54.152191	24052	21.0	1	8
2014-03-26 11:32:54.374152	24053	54	2	8
2014-03-26 11:33:09.057013	24054	20.4	1	1
2014-03-26 11:33:09.279215	24055	54	2	1
2014-03-26 23:51:45.973245	33600	41	2	10
2014-03-26 11:33:32.626673	24058	531	3	2
2014-03-26 11:33:33.152331	24059	21.0	1	8
2014-03-26 11:33:33.375208	24060	54	2	8
2014-03-26 11:33:48.059612	24061	20.4	1	1
2014-03-26 11:33:48.291717	24062	54	2	1
2014-03-26 11:34:12.152085	24067	21.0	1	8
2014-03-26 11:34:12.37404	24068	54	2	8
2014-03-26 11:34:27.060348	24069	20.4	1	1
2014-03-26 11:34:27.291419	24070	54	2	1
2014-03-26 11:34:32.629541	24071	482	3	2
2014-03-26 11:34:44.622787	24072	482	3	2
2014-03-26 11:25:04.252522	23942	20.0	1	10
2014-03-26 11:25:04.476575	23943	43	2	10
2014-03-26 11:25:43.253615	23951	20.0	1	10
2014-03-26 11:25:43.475873	23952	43	2	10
2014-03-26 11:26:22.252886	23960	20.0	1	10
2014-03-26 11:26:22.475423	23961	43	2	10
2014-03-26 11:27:01.252752	23969	20.0	1	10
2014-03-26 11:27:01.487014	23970	43	2	10
2014-03-26 11:27:40.254098	23978	20.0	1	10
2014-03-26 11:27:40.478902	23979	43	2	10
2014-03-26 11:28:19.252438	23986	20.0	1	10
2014-03-26 11:28:19.47683	23987	43	2	10
2014-03-26 11:28:58.252837	23995	20.0	1	10
2014-03-26 11:28:58.474475	23996	43	2	10
2014-03-26 11:29:37.25303	24005	20.0	1	10
2014-03-26 11:29:37.475363	24006	43	2	10
2014-03-26 11:30:16.254084	24013	20.0	1	10
2014-03-26 11:30:16.478112	24014	43	2	10
2014-03-26 11:30:55.253192	24022	20.0	1	10
2014-03-26 11:30:55.485508	24023	43	2	10
2014-03-26 11:31:34.255287	24031	20.0	1	10
2014-03-26 11:31:34.475586	24032	43	2	10
2014-03-26 11:32:13.252717	24039	20.0	1	10
2014-03-26 11:32:13.476282	24040	43	2	10
2014-03-26 11:32:52.308751	24048	19.9	1	10
2014-03-26 11:32:52.532539	24049	43	2	10
2014-03-26 11:34:10.254684	24063	19.9	1	10
2014-03-26 11:34:10.476283	24064	43	2	10
2014-03-26 23:51:56.252432	33601	21.1	1	9
2014-03-26 23:51:56.480253	33602	47	2	9
2014-03-26 11:34:51.151942	24077	21.0	1	8
2014-03-26 11:34:51.386058	24078	54	2	8
2014-03-26 11:35:06.059148	24079	20.4	1	1
2014-03-26 11:35:06.284012	24080	54	2	1
2014-03-26 23:51:57.134037	33603	21.5	1	8
2014-03-26 23:51:57.365978	33604	47	2	8
2014-03-26 11:35:30.151847	24085	21.0	1	8
2014-03-26 11:35:30.392895	24086	54	2	8
2014-03-26 11:35:32.623284	24087	482	3	2
2014-03-26 11:35:45.062338	24088	20.4	1	1
2014-03-26 11:35:45.284875	24089	54	2	1
2014-03-26 23:52:11.628881	33605	20.0	1	1
2014-03-26 23:52:11.85445	33606	50	2	1
2014-03-26 11:36:09.486867	24094	21.0	1	8
2014-03-26 11:36:09.708986	24095	53	2	8
2014-03-26 11:36:24.059917	24096	20.4	1	1
2014-03-26 11:36:24.282857	24097	54	2	1
2014-03-26 11:36:32.624575	24098	482	3	2
2014-03-26 23:52:24.737586	33607	23.4	1	10
2014-03-26 23:52:24.971378	33608	41	2	10
2014-03-26 11:36:48.151921	24103	21.0	1	8
2014-03-26 11:36:48.375112	24104	53	2	8
2014-03-26 11:37:03.058912	24105	20.4	1	1
2014-03-26 11:37:03.29341	24106	54	2	1
2014-03-26 23:52:32.54946	33609	370	3	2
2014-03-26 23:52:32.775288	33610	1089049.891355861	4	2
2014-03-26 11:37:27.151728	24111	21.0	1	8
2014-03-26 11:37:27.376601	24112	53	2	8
2014-03-26 11:37:32.626059	24113	482	3	2
2014-03-26 11:37:42.059571	24114	20.4	1	1
2014-03-26 11:37:42.283155	24115	54	2	1
2014-03-26 23:52:35.042939	33611	21.1	1	9
2014-03-26 23:52:35.279537	33612	47	2	9
2014-03-26 11:38:06.151374	24120	21.0	1	8
2014-03-26 11:38:06.381969	24121	53	2	8
2014-03-26 11:38:21.058201	24122	20.4	1	1
2014-03-26 11:38:21.282591	24123	54	2	1
2014-03-26 11:38:32.62783	24124	466	3	2
2014-03-26 23:52:36.131747	33613	21.5	1	8
2014-03-26 23:52:36.357993	33614	47	2	8
2014-03-26 11:38:45.150821	24129	21.0	1	8
2014-03-26 11:38:45.372375	24130	53	2	8
2014-03-26 11:39:00.058452	24131	20.4	1	1
2014-03-26 11:39:00.299614	24132	54	2	1
2014-03-26 23:52:50.629533	33615	20.0	1	1
2014-03-26 23:52:50.86534	33616	50	2	1
2014-03-26 11:39:24.151599	24137	21.0	1	8
2014-03-26 11:39:24.372888	24138	53	2	8
2014-03-26 11:39:32.625236	24139	482	3	2
2014-03-26 11:39:39.057852	24140	20.4	1	1
2014-03-26 11:39:39.279537	24141	54	2	1
2014-03-26 23:52:56.549377	33617	402	3	2
2014-03-26 23:52:56.774737	33618	1089052.1894253038	4	2
2014-03-26 11:40:03.151929	24146	21.0	1	8
2014-03-26 11:40:03.37473	24147	53	2	8
2014-03-26 11:40:18.055643	24148	20.4	1	1
2014-03-26 11:40:18.277553	24149	54	2	1
2014-03-26 11:40:32.626081	24150	482	3	2
2014-03-26 23:53:03.738783	33619	23.4	1	10
2014-03-26 23:53:03.972877	33620	41	2	10
2014-03-26 11:40:42.150479	24155	21.0	1	8
2014-03-26 11:40:42.372875	24156	53	2	8
2014-03-26 11:40:57.056761	24157	20.4	1	1
2014-03-26 11:40:57.289234	24158	54	2	1
2014-03-26 11:41:08.624194	24159	531	3	2
2014-03-26 23:53:08.543369	33621	370	3	2
2014-03-26 23:53:08.767958	33622	1089053.3384600251	4	2
2014-03-26 11:41:21.002928	24164	531	3	2
2014-03-26 11:41:21.312719	24165	21.0	1	8
2014-03-26 11:41:21.544575	24166	53	2	8
2014-03-26 11:41:32.624189	24167	531	3	2
2014-03-26 11:41:36.059469	24168	20.4	1	1
2014-03-26 11:41:36.283383	24169	54	2	1
2014-03-26 23:53:14.043962	33623	21.1	1	9
2014-03-26 23:53:14.293569	33624	47	2	9
2014-03-26 11:42:00.151918	24174	21.0	1	8
2014-03-26 11:42:00.395275	24175	53	2	8
2014-03-26 11:42:15.054173	24176	20.4	1	1
2014-03-26 11:42:15.297827	24177	54	2	1
2014-03-26 11:42:32.635846	24178	531	3	2
2014-03-26 23:53:15.131614	33625	21.5	1	8
2014-03-26 23:53:15.356846	33626	47	2	8
2014-03-26 11:42:39.150496	24183	21.0	1	8
2014-03-26 11:42:39.373076	24184	53	2	8
2014-03-26 11:42:54.053966	24185	20.4	1	1
2014-03-26 11:42:54.276028	24186	54	2	1
2014-03-26 23:53:20.544621	33627	370	3	2
2014-03-26 23:53:20.779064	33628	1089054.4874947467	4	2
2014-03-26 11:43:18.151036	24191	21.0	1	8
2014-03-26 11:43:18.381073	24192	53	2	8
2014-03-26 11:43:32.62273	24193	531	3	2
2014-03-26 11:43:33.054497	24194	20.4	1	1
2014-03-26 11:43:33.275286	24195	54	2	1
2014-03-26 23:53:29.629886	33629	20.0	1	1
2014-03-26 23:53:29.856627	33630	50	2	1
2014-03-26 11:43:57.151463	24200	21.0	1	8
2014-03-26 11:43:57.37296	24201	53	2	8
2014-03-26 11:44:12.050383	24202	20.4	1	1
2014-03-26 11:44:12.282828	24203	54	2	1
2014-03-26 11:44:32.628326	24204	531	3	2
2014-03-26 23:53:32.5466	33631	370	3	2
2014-03-26 11:34:49.255384	24073	19.9	1	10
2014-03-26 11:34:49.489371	24074	43	2	10
2014-03-26 11:35:28.255567	24081	19.9	1	10
2014-03-26 11:35:28.488136	24082	43	2	10
2014-03-26 11:36:07.253849	24090	19.9	1	10
2014-03-26 11:36:07.477243	24091	43	2	10
2014-03-26 11:36:46.257994	24099	19.9	1	10
2014-03-26 11:36:46.479562	24100	43	2	10
2014-03-26 11:37:25.255868	24107	19.9	1	10
2014-03-26 11:37:25.478291	24108	43	2	10
2014-03-26 11:38:04.256698	24116	19.9	1	10
2014-03-26 11:38:04.49041	24117	43	2	10
2014-03-26 11:38:43.257567	24125	19.9	1	10
2014-03-26 11:38:43.479562	24126	43	2	10
2014-03-26 11:39:22.25655	24133	19.9	1	10
2014-03-26 11:39:22.485314	24134	43	2	10
2014-03-26 11:40:01.258123	24142	19.9	1	10
2014-03-26 11:40:01.479624	24143	43	2	10
2014-03-26 11:40:40.256595	24151	19.9	1	10
2014-03-26 11:40:40.479269	24152	43	2	10
2014-03-26 11:41:19.259828	24160	19.9	1	10
2014-03-26 11:41:19.482476	24161	43	2	10
2014-03-26 11:41:58.259078	24170	19.9	1	10
2014-03-26 11:41:58.483869	24171	43	2	10
2014-03-26 11:42:37.270429	24179	19.9	1	10
2014-03-26 11:42:37.496344	24180	43	2	10
2014-03-26 11:43:16.259281	24187	19.9	1	10
2014-03-26 11:43:16.481848	24188	43	2	10
2014-03-26 11:43:55.259162	24196	19.9	1	10
2014-03-26 11:43:55.480613	24197	43	2	10
2014-03-26 11:44:36.150963	24209	21.0	1	8
2014-03-26 11:44:36.374924	24210	53	2	8
2014-03-26 11:44:51.053717	24211	20.4	1	1
2014-03-26 11:44:51.276691	24212	54	2	1
2014-03-26 23:53:32.782469	33632	1089055.636529468	4	2
2014-03-26 23:53:42.739153	33633	23.4	1	10
2014-03-26 11:45:15.15154	24217	21.0	1	8
2014-03-26 11:45:15.383749	24218	53	2	8
2014-03-26 11:45:30.051875	24219	20.4	1	1
2014-03-26 11:45:30.27526	24220	54	2	1
2014-03-26 11:45:32.625941	24221	531	3	2
2014-03-26 23:53:42.964826	33634	41	2	10
2014-03-26 23:53:53.045803	33635	21.1	1	9
2014-03-26 11:45:54.150139	24226	21.0	1	8
2014-03-26 11:45:54.371644	24227	53	2	8
2014-03-26 11:46:09.053768	24228	20.4	1	1
2014-03-26 11:46:09.285546	24229	54	2	1
2014-03-26 23:53:53.279376	33636	47	2	9
2014-03-26 23:53:54.132276	33637	21.5	1	8
2014-03-26 11:46:33.025572	24234	482	3	2
2014-03-26 11:46:33.330677	24235	21.0	1	8
2014-03-26 11:46:33.553322	24236	53	2	8
2014-03-26 11:46:44.623758	24237	482	3	2
2014-03-26 11:46:48.055062	24238	20.4	1	1
2014-03-26 11:46:48.279432	24239	54	2	1
2014-03-26 23:53:54.356452	33638	47	2	8
2014-03-26 23:54:08.630107	33639	20.0	1	1
2014-03-26 11:47:12.152471	24244	21.0	1	8
2014-03-26 11:47:12.38406	24245	53	2	8
2014-03-26 11:47:27.055482	24246	20.4	1	1
2014-03-26 11:47:27.280865	24247	54	2	1
2014-03-26 11:47:32.625957	24248	482	3	2
2014-03-26 23:54:08.865045	33640	50	2	1
2014-03-26 23:54:21.739851	33641	23.4	1	10
2014-03-26 11:47:51.150583	24253	21.0	1	8
2014-03-26 11:47:51.3744	24254	53	2	8
2014-03-26 11:48:06.054056	24255	20.4	1	1
2014-03-26 11:48:06.285436	24256	54	2	1
2014-03-26 23:54:21.965879	33642	41	2	10
2014-03-26 23:54:32.044681	33643	21.1	1	9
2014-03-26 11:48:30.151441	24261	21.0	1	8
2014-03-26 11:48:30.37263	24262	53	2	8
2014-03-26 11:48:32.624855	24263	482	3	2
2014-03-26 11:48:45.056509	24264	20.4	1	1
2014-03-26 11:48:45.279881	24265	54	2	1
2014-03-26 23:54:32.277063	33644	47	2	9
2014-03-26 23:54:32.587527	33645	370	3	2
2014-03-26 11:49:09.151395	24270	21.0	1	8
2014-03-26 11:49:09.382568	24271	53	2	8
2014-03-26 11:49:24.050709	24272	20.4	1	1
2014-03-26 11:49:24.272558	24273	54	2	1
2014-03-26 11:49:32.625842	24274	466	3	2
2014-03-26 23:54:32.811002	33646	1089062.5307377966	4	2
2014-03-26 23:54:33.131408	33647	21.5	1	8
2014-03-26 11:49:48.153206	24279	21.0	1	8
2014-03-26 11:49:48.376283	24280	53	2	8
2014-03-26 11:50:03.05411	24281	20.4	1	1
2014-03-26 11:50:03.287636	24282	54	2	1
2014-03-26 23:54:33.365011	33648	47	2	8
2014-03-26 23:54:47.631462	33649	20.0	1	1
2014-03-26 11:50:27.488567	24287	21.0	1	8
2014-03-26 11:50:27.710734	24288	53	2	8
2014-03-26 11:50:32.626404	24289	482	3	2
2014-03-26 11:50:42.052792	24290	20.4	1	1
2014-03-26 11:50:42.276687	24291	54	2	1
2014-03-26 23:54:47.855822	33650	50	2	1
2014-03-26 23:55:00.94595	33651	23.4	1	10
2014-03-26 11:51:06.151985	24296	21.0	1	8
2014-03-26 11:51:06.384064	24297	53	2	8
2014-03-26 11:51:21.052399	24298	20.4	1	1
2014-03-26 11:51:21.276152	24299	54	2	1
2014-03-26 11:51:32.623365	24300	466	3	2
2014-03-26 23:55:01.182949	33652	41	2	10
2014-03-26 23:55:11.044533	33653	21.1	1	9
2014-03-26 11:51:45.152517	24305	21.0	1	8
2014-03-26 11:51:45.374562	24306	53	2	8
2014-03-26 11:52:00.052031	24307	20.4	1	1
2014-03-26 11:52:00.283645	24308	54	2	1
2014-03-26 23:55:11.270672	33654	47	2	9
2014-03-26 23:55:12.131994	33655	21.5	1	8
2014-03-26 11:52:24.152988	24313	21.0	1	8
2014-03-26 11:52:24.374322	24314	53	2	8
2014-03-26 11:52:32.622752	24315	466	3	2
2014-03-26 11:52:39.050282	24316	20.4	1	1
2014-03-26 11:52:39.275274	24317	54	2	1
2014-03-26 23:55:12.364229	33656	47	2	8
2014-03-26 23:55:20.549657	33657	305	3	2
2014-03-26 11:53:03.150657	24322	21.0	1	8
2014-03-26 11:53:03.374099	24323	53	2	8
2014-03-26 11:53:18.05057	24324	20.4	1	1
2014-03-26 11:53:18.27339	24325	54	2	1
2014-03-26 11:53:32.478407	24326	515	3	2
2014-03-26 11:53:32.794504	24327	515	3	2
2014-03-26 23:55:20.775889	33658	1089067.1268766823	4	2
2014-03-26 23:55:26.628823	33659	20.0	1	1
2014-03-26 11:53:42.151047	24332	21.0	1	8
2014-03-26 11:53:42.374713	24333	53	2	8
2014-03-26 11:53:57.049701	24334	20.4	1	1
2014-03-26 11:53:57.271387	24335	54	2	1
2014-03-26 23:55:26.86562	33660	50	2	1
2014-03-26 11:54:21.151922	24340	21.0	1	8
2014-03-26 11:54:21.382268	24341	53	2	8
2014-03-26 11:54:32.623775	24342	515	3	2
2014-03-26 11:54:36.048715	24343	20.4	1	1
2014-03-26 11:54:36.269236	24344	54	2	1
2014-03-26 11:45:13.257942	24213	19.9	1	10
2014-03-26 11:45:13.490271	24214	43	2	10
2014-03-26 11:45:52.259103	24222	19.9	1	10
2014-03-26 11:45:52.482013	24223	43	2	10
2014-03-26 11:46:31.259947	24230	19.9	1	10
2014-03-26 11:46:31.481349	24231	43	2	10
2014-03-26 11:47:10.262263	24240	19.9	1	10
2014-03-26 11:47:10.493543	24241	43	2	10
2014-03-26 11:47:49.261472	24249	19.9	1	10
2014-03-26 11:47:49.485336	24250	43	2	10
2014-03-26 11:48:28.261008	24257	19.9	1	10
2014-03-26 11:48:28.484882	24258	43	2	10
2014-03-26 11:49:07.260393	24266	19.9	1	10
2014-03-26 11:49:07.5063	24267	43	2	10
2014-03-26 11:49:46.260479	24275	19.9	1	10
2014-03-26 11:49:46.483576	24276	43	2	10
2014-03-26 11:50:25.261513	24283	19.9	1	10
2014-03-26 11:50:25.483359	24284	43	2	10
2014-03-26 11:51:04.262281	24292	19.8	1	10
2014-03-26 11:51:04.484623	24293	43	2	10
2014-03-26 11:51:43.263608	24301	19.8	1	10
2014-03-26 11:51:43.48664	24302	43	2	10
2014-03-26 11:52:22.261622	24309	19.8	1	10
2014-03-26 11:52:22.484798	24310	43	2	10
2014-03-26 11:53:01.262766	24318	19.8	1	10
2014-03-26 11:53:01.484829	24319	43	2	10
2014-03-26 11:53:40.264508	24328	19.8	1	10
2014-03-26 11:53:40.489466	24329	43	2	10
2014-03-26 23:55:32.541941	33661	305	3	2
2014-03-26 23:55:32.770183	33662	1089068.2759114036	4	2
2014-03-26 11:55:00.15191	24349	21.0	1	8
2014-03-26 11:55:00.373093	24350	53	2	8
2014-03-26 11:55:15.049971	24351	20.4	1	1
2014-03-26 11:55:15.282653	24352	54	2	1
2014-03-26 11:55:32.624848	24353	515	3	2
2014-03-26 23:55:39.739381	33663	23.4	1	10
2014-03-26 23:55:39.977183	33664	41	2	10
2014-03-26 11:55:39.152486	24358	21.0	1	8
2014-03-26 11:55:39.385159	24359	53	2	8
2014-03-26 11:55:54.049056	24360	20.4	1	1
2014-03-26 11:55:54.273141	24361	54	2	1
2014-03-26 23:55:50.044929	33665	21.1	1	9
2014-03-26 23:55:50.270429	33666	47	2	9
2014-03-26 11:56:18.151907	24366	21.0	1	8
2014-03-26 11:56:18.384926	24367	53	2	8
2014-03-26 11:56:32.623287	24368	515	3	2
2014-03-26 11:56:33.049351	24369	20.4	1	1
2014-03-26 11:56:33.272689	24370	54	2	1
2014-03-26 23:55:51.132625	33667	21.5	1	8
2014-03-26 23:55:51.366825	33668	47	2	8
2014-03-26 11:56:56.950747	24375	466	3	2
2014-03-26 11:56:57.258971	24376	21.0	1	8
2014-03-26 11:56:57.482391	24377	53	2	8
2014-03-26 11:57:08.625894	24378	466	3	2
2014-03-26 11:57:12.047377	24379	20.4	1	1
2014-03-26 11:57:12.268873	24380	54	2	1
2014-03-26 11:57:32.624362	24381	482	3	2
2014-03-26 23:56:05.625689	33669	20.0	1	1
2014-03-26 23:56:05.853735	33670	50	2	1
2014-03-26 11:57:36.152598	24386	21.0	1	8
2014-03-26 11:57:36.37539	24387	53	2	8
2014-03-26 11:57:51.046161	24388	20.4	1	1
2014-03-26 11:57:51.283187	24389	54	2	1
2014-03-26 23:56:18.739993	33671	23.3	1	10
2014-03-26 23:56:18.987436	33672	41	2	10
2014-03-26 11:58:15.150488	24394	21.0	1	8
2014-03-26 11:58:15.374209	24395	53	2	8
2014-03-26 11:58:30.045388	24396	20.4	1	1
2014-03-26 11:58:30.28029	24397	54	2	1
2014-03-26 11:58:32.62183	24398	466	3	2
2014-03-26 23:56:29.04576	33673	21.1	1	9
2014-03-26 23:56:29.270706	33674	47	2	9
2014-03-26 11:58:54.150748	24403	21.0	1	8
2014-03-26 11:58:54.37475	24404	53	2	8
2014-03-26 11:59:08.62135	24405	547	3	2
2014-03-26 11:59:09.047504	24406	20.4	1	1
2014-03-26 11:59:09.26908	24407	54	2	1
2014-03-26 11:59:20.622432	24408	531	3	2
2014-03-26 23:56:30.132528	33675	21.5	1	8
2014-03-26 23:56:30.36572	33676	47	2	8
2014-03-26 11:59:32.630454	24413	482	3	2
2014-03-26 11:59:33.150888	24414	21.0	1	8
2014-03-26 11:59:33.374952	24415	53	2	8
2014-03-26 11:59:44.624467	24416	515	3	2
2014-03-26 11:59:48.048119	24417	20.4	1	1
2014-03-26 11:59:48.269972	24418	54	2	1
2014-03-26 11:59:56.623512	24419	498	3	2
2014-03-26 23:56:32.545406	33677	305	3	2
2014-03-26 23:56:32.770086	33678	1089074.0210850106	4	2
2014-03-26 12:00:12.151742	24424	21.0	1	8
2014-03-26 12:00:12.374849	24425	53	2	8
2014-03-26 12:00:27.047239	24426	20.4	1	1
2014-03-26 12:00:27.280625	24427	54	2	1
2014-03-26 12:00:32.623843	24428	498	3	2
2014-03-26 23:56:44.865829	33679	20.0	1	1
2014-03-26 23:56:45.102682	33680	50	2	1
2014-03-26 12:00:51.150333	24433	21.0	1	8
2014-03-26 12:00:51.373079	24434	53	2	8
2014-03-26 12:01:06.043212	24435	20.4	1	1
2014-03-26 12:01:06.267576	24436	54	2	1
2014-03-26 23:56:56.545932	33681	338	3	2
2014-03-26 23:56:56.771639	33682	1089075.1701197322	4	2
2014-03-26 12:01:30.150497	24441	21.0	1	8
2014-03-26 12:01:30.380346	24442	53	2	8
2014-03-26 12:01:32.621967	24443	498	3	2
2014-03-26 12:01:45.049053	24444	20.4	1	1
2014-03-26 12:01:45.271024	24445	54	2	1
2014-03-26 23:56:57.739862	33683	23.3	1	10
2014-03-26 23:56:57.973646	33684	41	2	10
2014-03-26 12:02:09.488916	24450	21.0	1	8
2014-03-26 12:02:09.711252	24451	53	2	8
2014-03-26 12:02:24.046071	24452	20.4	1	1
2014-03-26 12:02:24.269853	24453	54	2	1
2014-03-26 12:02:32.622866	24454	498	3	2
2014-03-26 23:57:08.044031	33685	21.1	1	9
2014-03-26 23:57:08.270117	33686	47	2	9
2014-03-26 12:02:48.152365	24459	21.0	1	8
2014-03-26 12:02:48.374706	24460	53	2	8
2014-03-26 12:03:03.042827	24461	20.4	1	1
2014-03-26 12:03:03.27624	24462	54	2	1
2014-03-26 23:57:08.579843	33687	305	3	2
2014-03-26 23:57:08.814877	33688	1089076.3191544535	4	2
2014-03-26 12:03:27.150617	24467	21.0	1	8
2014-03-26 12:03:27.37589	24468	53	2	8
2014-03-26 12:03:32.621622	24469	482	3	2
2014-03-26 12:03:42.046133	24470	20.4	1	1
2014-03-26 12:03:42.270083	24471	54	2	1
2014-03-26 23:57:09.134796	33689	21.5	1	8
2014-03-26 12:04:06.150747	24476	21.0	1	8
2014-03-26 12:04:06.385151	24477	53	2	8
2014-03-26 12:04:21.040752	24478	20.4	1	1
2014-03-26 12:04:21.263603	24479	54	2	1
2014-03-26 12:04:32.622118	24480	482	3	2
2014-03-26 11:54:58.263816	24345	19.8	1	10
2014-03-26 11:54:58.495062	24346	43	2	10
2014-03-26 11:55:37.262944	24354	19.8	1	10
2014-03-26 11:55:37.485305	24355	43	2	10
2014-03-26 11:56:16.262784	24362	19.8	1	10
2014-03-26 11:56:16.493276	24363	43	2	10
2014-03-26 11:56:55.26432	24371	19.8	1	10
2014-03-26 11:56:55.486224	24372	43	2	10
2014-03-26 11:57:34.263745	24382	19.8	1	10
2014-03-26 11:57:34.486861	24383	43	2	10
2014-03-26 11:58:13.265273	24390	19.8	1	10
2014-03-26 11:58:13.487889	24391	43	2	10
2014-03-26 11:58:52.264605	24399	19.8	1	10
2014-03-26 11:58:52.48903	24400	43	2	10
2014-03-26 11:59:31.263435	24409	19.8	1	10
2014-03-26 11:59:31.488125	24410	43	2	10
2014-03-26 12:00:10.264433	24420	19.7	1	10
2014-03-26 12:00:10.488878	24421	43	2	10
2014-03-26 12:00:49.263001	24429	19.7	1	10
2014-03-26 12:00:49.487135	24430	43	2	10
2014-03-26 12:01:28.264105	24437	19.7	1	10
2014-03-26 12:01:28.495609	24438	43	2	10
2014-03-26 12:02:07.264289	24446	19.7	1	10
2014-03-26 12:02:07.4868	24447	43	2	10
2014-03-26 12:02:46.263152	24455	19.7	1	10
2014-03-26 12:02:46.487934	24456	43	2	10
2014-03-26 12:03:25.265675	24463	19.7	1	10
2014-03-26 12:03:25.4871	24464	43	2	10
2014-03-26 23:57:09.357867	33690	47	2	8
2014-03-26 23:57:20.545014	33691	305	3	2
2014-03-26 12:04:45.151025	24485	21.0	1	8
2014-03-26 12:04:45.372836	24486	53	2	8
2014-03-26 12:05:00.039829	24487	20.4	1	1
2014-03-26 12:05:00.273269	24488	54	2	1
2014-03-26 23:57:20.779493	33692	1089077.468189175	4	2
2014-03-26 23:57:23.623789	33693	20.0	1	1
2014-03-26 12:05:24.151214	24493	21.0	1	8
2014-03-26 12:05:24.375107	24494	53	2	8
2014-03-26 12:05:32.625535	24495	482	3	2
2014-03-26 12:05:39.044473	24496	20.4	1	1
2014-03-26 12:05:39.267182	24497	54	2	1
2014-03-26 23:57:23.848102	33694	50	2	1
2014-03-26 23:57:32.544006	33695	338	3	2
2014-03-26 12:06:03.150098	24502	21.0	1	8
2014-03-26 12:06:03.388832	24503	53	2	8
2014-03-26 12:06:18.099936	24504	20.4	1	1
2014-03-26 12:06:18.323502	24505	54	2	1
2014-03-26 12:06:20.622284	24506	547	3	2
2014-03-26 12:06:32.621248	24507	547	3	2
2014-03-26 23:57:32.78032	33696	1089078.6172238963	4	2
2014-03-26 23:57:36.73879	33697	23.3	1	10
2014-03-26 12:06:42.150275	24512	21.0	1	8
2014-03-26 12:06:42.372624	24513	53	2	8
2014-03-26 12:06:57.04034	24514	20.4	1	1
2014-03-26 12:06:57.27401	24515	54	2	1
2014-03-26 23:57:36.964419	33698	41	2	10
2014-03-26 23:57:44.545752	33699	305	3	2
2014-03-26 12:07:21.151653	24520	21.0	1	8
2014-03-26 12:07:21.374244	24521	52	2	8
2014-03-26 12:07:32.621462	24522	595	3	2
2014-03-26 12:07:36.042828	24523	20.4	1	1
2014-03-26 12:07:36.265749	24524	54	2	1
2014-03-26 12:07:44.620233	24525	595	3	2
2014-03-26 23:57:44.780431	33700	1089079.7662586179	4	2
2014-03-26 23:57:47.044359	33701	21.1	1	9
2014-03-26 12:08:00.152457	24530	21.0	1	8
2014-03-26 12:08:00.374187	24531	52	2	8
2014-03-26 12:08:15.281345	24532	20.4	1	1
2014-03-26 12:08:15.514239	24533	54	2	1
2014-03-26 12:08:32.621305	24534	595	3	2
2014-03-26 23:57:47.270099	33702	47	2	9
2014-03-26 23:57:48.133744	33703	21.5	1	8
2014-03-26 12:08:39.153096	24539	21.0	1	8
2014-03-26 12:08:39.384064	24540	52	2	8
2014-03-26 12:08:54.039563	24541	20.4	1	1
2014-03-26 12:08:54.264294	24542	54	2	1
2014-03-26 12:08:56.623169	24543	547	3	2
2014-03-26 12:09:08.624645	24544	579	3	2
2014-03-26 23:57:48.369839	33704	47	2	8
2014-03-26 23:57:56.545947	33705	338	3	2
2014-03-26 12:09:18.185998	24549	20.9	1	8
2014-03-26 12:09:18.437477	24550	53	2	8
2014-03-26 12:09:20.62239	24551	579	3	2
2014-03-26 12:09:32.620045	24552	579	3	2
2014-03-26 12:09:33.039552	24553	20.4	1	1
2014-03-26 12:09:33.273443	24554	54	2	1
2014-03-26 23:57:56.771075	33706	1089080.9152933392	4	2
2014-03-26 23:58:02.627499	33707	20.0	1	1
2014-03-26 12:09:57.150865	24559	20.9	1	8
2014-03-26 12:09:57.373315	24560	53	2	8
2014-03-26 12:10:12.039752	24561	20.4	1	1
2014-03-26 12:10:12.272551	24562	54	2	1
2014-03-26 12:10:32.624463	24563	579	3	2
2014-03-26 23:58:02.862741	33708	50	2	1
2014-03-26 23:58:08.543644	33709	338	3	2
2014-03-26 12:10:36.152299	24566	20.9	1	8
2014-03-26 12:10:36.374339	24567	53	2	8
2014-03-26 12:10:51.040295	24568	20.4	1	1
2014-03-26 12:10:51.27365	24569	54	2	1
2014-03-26 23:58:08.768117	33710	1089082.0643280607	4	2
2014-03-26 23:58:15.740014	33711	23.3	1	10
2014-03-26 12:11:15.15074	24574	20.9	1	8
2014-03-26 12:11:15.372595	24575	53	2	8
2014-03-26 12:11:30.039516	24576	20.4	1	1
2014-03-26 12:11:30.273279	24577	54	2	1
2014-03-26 12:11:32.621395	24578	579	3	2
2014-03-26 12:11:44.624334	24579	515	3	2
2014-03-26 23:58:15.974947	33712	41	2	10
2014-03-26 23:58:20.542421	33713	305	3	2
2014-03-26 12:11:54.150099	24584	20.9	1	8
2014-03-26 12:11:54.383394	24585	53	2	8
2014-03-26 12:11:56.622067	24586	531	3	2
2014-03-26 12:12:09.035531	24587	20.4	1	1
2014-03-26 12:12:09.257882	24588	54	2	1
2014-03-26 12:12:20.619763	24589	498	3	2
2014-03-26 23:58:20.76545	33714	1089083.213362782	4	2
2014-03-26 23:58:26.046997	33715	21.1	1	9
2014-03-26 12:12:32.622552	24594	531	3	2
2014-03-26 12:12:33.150501	24595	20.9	1	8
2014-03-26 12:12:33.372471	24596	53	2	8
2014-03-26 12:12:44.620504	24597	515	3	2
2014-03-26 12:12:48.039645	24598	20.4	1	1
2014-03-26 12:12:48.262119	24599	54	2	1
2014-03-26 23:58:26.281591	33716	47	2	9
2014-03-26 12:13:12.150031	24604	20.9	1	8
2014-03-26 12:13:12.382599	24605	53	2	8
2014-03-26 12:13:27.035627	24606	20.4	1	1
2014-03-26 12:13:27.2604	24607	54	2	1
2014-03-26 12:13:32.621283	24608	515	3	2
2014-03-26 12:13:51.152547	24613	20.9	1	8
2014-03-26 12:13:51.375182	24614	53	2	8
2014-03-26 12:13:56.622566	24615	466	3	2
2014-03-26 12:14:06.040469	24616	20.4	1	1
2014-03-26 12:04:43.27381	24481	19.7	1	10
2014-03-26 12:04:43.502619	24482	43	2	10
2014-03-26 12:05:22.26667	24489	19.7	1	10
2014-03-26 12:05:22.489346	24490	43	2	10
2014-03-26 12:06:01.263705	24498	19.7	1	10
2014-03-26 12:06:01.497258	24499	43	2	10
2014-03-26 12:06:40.26553	24508	19.7	1	10
2014-03-26 12:06:40.486673	24509	43	2	10
2014-03-26 12:07:19.267975	24516	19.7	1	10
2014-03-26 12:07:19.49228	24517	43	2	10
2014-03-26 12:07:58.264847	24526	19.7	1	10
2014-03-26 12:07:58.489562	24527	43	2	10
2014-03-26 12:08:37.267063	24535	19.7	1	10
2014-03-26 12:08:37.511488	24536	43	2	10
2014-03-26 12:09:16.266402	24545	19.7	1	10
2014-03-26 12:09:16.489369	24546	43	2	10
2014-03-26 12:09:55.264578	24555	19.7	1	10
2014-03-26 12:09:55.48995	24556	43	2	10
2014-03-26 12:11:13.263769	24570	19.7	1	10
2014-03-26 12:11:13.486168	24571	43	2	10
2014-03-26 12:11:52.264641	24580	19.7	1	10
2014-03-26 12:11:52.509386	24581	43	2	10
2014-03-26 12:12:31.26474	24590	19.7	1	10
2014-03-26 12:12:31.48641	24591	43	2	10
2014-03-26 12:13:10.26418	24600	19.7	1	10
2014-03-26 12:13:10.497101	24601	43	2	10
2014-03-26 12:13:49.26371	24609	19.7	1	10
2014-03-26 12:13:49.486876	24610	43	2	10
2014-03-26 12:14:06.264519	24617	54	2	1
2014-03-26 12:14:08.62036	24618	466	3	2
2014-03-26 23:58:27.13356	33717	21.5	1	8
2014-03-26 23:58:27.361004	33718	47	2	8
2014-03-26 12:14:30.150048	24623	20.9	1	8
2014-03-26 12:14:30.383618	24624	53	2	8
2014-03-26 12:14:32.624326	24625	466	3	2
2014-03-26 12:14:45.041671	24626	20.4	1	1
2014-03-26 12:14:45.265089	24627	54	2	1
2014-03-26 23:58:32.545262	33719	305	3	2
2014-03-26 23:58:32.791986	33720	1089084.3623975033	4	2
2014-03-26 12:15:09.150784	24632	20.9	1	8
2014-03-26 12:15:09.374903	24633	53	2	8
2014-03-26 12:15:24.040632	24634	20.4	1	1
2014-03-26 12:15:24.293091	24635	54	2	1
2014-03-26 12:15:32.62183	24636	466	3	2
2014-03-26 23:58:41.626432	33721	20.0	1	1
2014-03-26 23:58:41.852932	33722	50	2	1
2014-03-26 12:15:48.151866	24641	20.9	1	8
2014-03-26 12:15:48.384905	24642	53	2	8
2014-03-26 12:16:03.037275	24643	20.4	1	1
2014-03-26 12:16:03.25957	24644	54	2	1
2014-03-26 23:58:44.544037	33723	338	3	2
2014-03-26 23:58:44.77848	33724	1089085.511432225	4	2
2014-03-26 12:16:27.152207	24649	20.9	1	8
2014-03-26 12:16:27.387031	24650	53	2	8
2014-03-26 12:16:32.622637	24651	466	3	2
2014-03-26 12:16:42.037144	24652	20.4	1	1
2014-03-26 12:16:42.259332	24653	54	2	1
2014-03-26 23:58:54.740018	33725	23.3	1	10
2014-03-26 23:58:54.963928	33726	41	2	10
2014-03-26 12:17:06.149995	24658	20.9	1	8
2014-03-26 12:17:06.380715	24659	53	2	8
2014-03-26 12:17:21.036912	24660	20.4	1	1
2014-03-26 12:17:21.268978	24661	54	2	1
2014-03-26 12:17:32.618981	24662	450	3	2
2014-03-26 23:58:56.547933	33727	305	3	2
2014-03-26 23:58:56.788885	33728	1089086.6604669462	4	2
2014-03-26 12:17:45.152505	24667	20.9	1	8
2014-03-26 12:17:45.375895	24668	53	2	8
2014-03-26 12:17:56.620266	24669	482	3	2
2014-03-26 12:18:00.039534	24670	20.4	1	1
2014-03-26 12:18:00.261218	24671	54	2	1
2014-03-26 12:18:08.619146	24672	450	3	2
2014-03-26 12:18:20.619865	24673	450	3	2
2014-03-26 23:59:05.042778	33729	21.1	1	9
2014-03-26 23:59:05.266057	33730	47	2	9
2014-03-26 12:18:24.151854	24678	20.9	1	8
2014-03-26 12:18:24.385971	24679	53	2	8
2014-03-26 12:18:32.617977	24680	515	3	2
2014-03-26 12:18:39.035627	24681	20.5	1	1
2014-03-26 12:18:39.260121	24682	54	2	1
2014-03-26 12:18:44.620789	24683	515	3	2
2014-03-26 23:59:06.132581	33731	21.5	1	8
2014-03-26 23:59:06.366162	33732	47	2	8
2014-03-26 12:19:03.151434	24688	20.9	1	8
2014-03-26 12:19:03.375253	24689	53	2	8
2014-03-26 12:19:18.03412	24690	20.5	1	1
2014-03-26 12:19:18.306447	24691	54	2	1
2014-03-26 12:19:32.619662	24692	498	3	2
2014-03-26 23:59:08.545637	33733	338	3	2
2014-03-26 23:59:08.771058	33734	1089087.8095016677	4	2
2014-03-26 12:19:42.150089	24697	20.9	1	8
2014-03-26 12:19:42.374354	24698	53	2	8
2014-03-26 12:19:57.035483	24699	20.5	1	1
2014-03-26 12:19:57.26078	24700	54	2	1
2014-03-26 23:59:20.865556	33735	20.0	1	1
2014-03-26 23:59:21.103174	33736	50	2	1
2014-03-26 12:20:21.150514	24705	20.9	1	8
2014-03-26 12:20:21.384244	24706	53	2	8
2014-03-26 12:20:32.624081	24707	498	3	2
2014-03-26 12:20:36.03367	24708	20.5	1	1
2014-03-26 12:20:36.256571	24709	54	2	1
2014-03-26 23:59:32.545579	33737	338	3	2
2014-03-26 23:59:32.822386	33738	1089090.1075711106	4	2
2014-03-26 12:21:00.495572	24714	20.9	1	8
2014-03-26 12:21:00.719063	24715	53	2	8
2014-03-26 12:21:15.034857	24716	20.5	1	1
2014-03-26 12:21:15.261043	24717	54	2	1
2014-03-26 12:21:37.071952	24718	515	3	2
2014-03-26 23:59:33.73971	33739	23.3	1	10
2014-03-26 23:59:34.006938	33740	41	2	10
2014-03-26 12:21:39.150012	24723	20.9	1	8
2014-03-26 12:21:39.373006	24724	53	2	8
2014-03-26 12:21:54.070196	24725	20.5	1	1
2014-03-26 12:21:54.310726	24726	54	2	1
2014-03-26 23:59:44.044042	33741	21.1	1	9
2014-03-26 23:59:44.29896	33742	47	2	9
2014-03-26 12:22:18.15107	24731	20.9	1	8
2014-03-26 12:22:18.436133	24732	53	2	8
2014-03-26 12:22:32.62137	24733	531	3	2
2014-03-26 12:22:33.030635	24734	20.5	1	1
2014-03-26 12:22:33.25318	24735	54	2	1
2014-03-26 12:22:44.620587	24736	498	3	2
2014-03-26 23:59:45.132313	33743	21.5	1	8
2014-03-26 23:59:45.402812	33744	47	2	8
2014-03-26 12:22:56.619802	24741	498	3	2
2014-03-26 12:22:57.150511	24742	20.9	1	8
2014-03-26 12:22:57.382502	24743	53	2	8
2014-03-26 12:23:08.62278	24744	531	3	2
2014-03-26 12:23:12.030469	24745	20.5	1	1
2014-03-26 12:23:12.253372	24746	54	2	1
2014-03-26 12:23:20.621529	24747	515	3	2
2014-03-26 12:23:32.617922	24748	515	3	2
2014-03-26 23:59:59.626369	33745	20.0	1	1
2014-03-26 12:14:28.266056	24619	19.7	1	10
2014-03-26 12:14:28.498789	24620	43	2	10
2014-03-26 12:15:07.264348	24628	19.6	1	10
2014-03-26 12:15:07.489056	24629	43	2	10
2014-03-26 12:15:46.265221	24637	19.6	1	10
2014-03-26 12:15:46.490061	24638	43	2	10
2014-03-26 12:16:25.26434	24645	19.6	1	10
2014-03-26 12:16:25.496051	24646	43	2	10
2014-03-26 12:17:04.263923	24654	19.6	1	10
2014-03-26 12:17:04.495329	24655	43	2	10
2014-03-26 12:17:43.264319	24663	19.6	1	10
2014-03-26 12:17:43.488575	24664	42	2	10
2014-03-26 12:18:22.266367	24674	19.6	1	10
2014-03-26 12:18:22.49832	24675	42	2	10
2014-03-26 12:19:01.26448	24684	19.6	1	10
2014-03-26 12:19:01.486956	24685	42	2	10
2014-03-26 12:19:40.265216	24693	19.6	1	10
2014-03-26 12:19:40.487759	24694	42	2	1