import subprocess

class TransferManager(object):
    def __init__(self,
                 connection=None,
                 default_file_name="default",
                 default_file_type=".tar.gz",
                 public_private_key=None,
                 debug=False):

        # Set up some fields for use later
        self.connection = connection
        self.default_file_name = default_file_name
        self.default_file_type = default_file_type
        self.public_private_key = public_private_key
        self.debug = debug
        self.package_directory = "."

    def push(self, name="default", files=["."]):
        if not name: name=self.default_file_name
        name = self._file_type_filter(name)
        file_list = " ".join(files)

        # Had some problems passing this as a list, went with shell=True
        if self.debug:
            subprocess.Popen("tar -avcf %s %s" % (name, file_list), shell=True).wait()
        else:
            subprocess.Popen("tar --warning=none -acf %s %s" % (name, file_list), shell=True).wait()

        try:
            self.connection.put(name, "%s/%s" % (self.package_directory, name))
        except IOError as e:
            print("%s, exiting..." % str(e))

        subprocess.Popen(["rm", "-f", name]).wait()

    def pull(self, name=None):
        if not name: name=self.default_file_name
        name = self._file_type_filter(name)

        try: 
            self.connection.get("%s/%s" % (self.package_directory, name))
        except IOError as e:
            print("%s, exiting..." % str(e))
            return

        #s.execute("rm -f %s" % name)

        if self.debug:
            subprocess.Popen(["tar","-z", "-v", "-x", "-f", "%s" % name]).wait()
        else:
            subprocess.Popen(["tar", "--warning=none", "-z", "-x", "-f", "%s" % name]).wait()

        subprocess.Popen(["rm", "-f", "%s" % name]).wait()

    def _file_type_filter(self, f):
        if not f.endswith(self.default_file_type):
            return "%s%s" % (f, self.default_file_type)
        else:
            return f
