import re

class ConnectionStringParser(object):
    def _parse_connection_string(self, cs):
        username, address = cs[:cs.find(":")].split("@")
        port = cs[cs.find(":")+1:]
        return (username, address, int(port))

    def _is_malformed_connection_string(self, conn):
        return not bool(re.match(r'[A-Za-z][-A-Za-z0-9_]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z0-9]+:\d{2,5}', conn))

    def parse(self, conn):
        defaultRet = (False, "", "", -1)

        if self._is_malformed_connection_string(conn):
            return defaultRet

        try:
            user, addr, port = self._parse_connection_string(conn)
            return True, user, addr, port
        except Exception as e:
            return defaultRet
