import subprocess
import ssh
import os.path

class Package(object):
    
    def __init__(self, name="default", loc=".", files=[]):
        self.name = name
        self.loc = loc
        self.files = files
        self.connection = None

    def _tar(self, arguments, name, files):
        """ Return a tar command basically"""
        return "tar %s %s %s" % (arguments, name, files)

    def _files(self):
        return " ".join(self.files)

    def set_remote(self, connection):
        self.connection = connection

    def set_local(self):
        self.connection = None

    def compress(self):
        if self.connection:
            self.connection.execute(self._tar("-avcf", self.full_name(), self._files()))
        else:
            subprocess.Popen(self._tar("-avcf", self.full_name(), self._files()), shell=True).wait()

    def uncompress(self):
        if self.connection:
            self.connection.execute(self._tar("-zvxf", self.full_name(), self._files()))
        else:
            subprocess.Popen(self._tar("-zvxf", self.full_name(), self._files()), shell=True).wait()

    def remove(self):
        if self.connection:
            self.connection.execute("rm -f %s" % self.full_path())
        else:
            if os.path.exists(self.full_path()):
                subprocess.Popen("rm -f %s" % self.full_path(), shell=True)
            else:
                subprocess.Popen("rm -f %s" % self.full_name(), shell=True)

    def full_path(self, change=None):
        return "%s/%s.tar.gz" % (self.loc, self.name)

    def full_name(self):
        return "%s.tar.gz" % (self.name)
