from package import Package
import os.path
from configobj import ConfigObj

class PackageFactory(object):
    def __init__(self):
        pass
    
    def make(self, name="default", loc=".", files=[], nocheck=False):
        if not nocheck:
            for f in files:
                f = os.path.expanduser(f)
                if not os.path.exists(f):
                    return (False, Package())

        return (True, Package(name, loc, files))
    
    def make_from_config(self, conf_file=None, name="default", nocheck=False):
        """ This will allow us to produce a package from the .habitat.conf file """
        
        # Take care of this right now before it causes problems later
        conf_file = os.path.expanduser(conf_file)
        if not os.path.exists(conf_file):
            return (False, Package())

        conf = ConfigObj(conf_file)
        
        try:
            package = conf["packages"][name]
            files = package["files"].split(",")
            files = [f.strip() for f in files if f.strip() != ""]

            if "location" in package.keys():
                return self.make(name, package["location"], files, nocheck)
            else:
                return self.make(name, ".", files, nocheck)
        except KeyError:
            return (False, Package())

