from remote import Remote
from configobj import ConfigObj
import os.path

class RemoteFactory(object):
    def __init__(self):
        pass

    def make_from_config(self, conf_file=None, name="default"):
        conf_file = os.path.expanduser(conf_file)
        if not os.path.exists(conf_file):
            return (False, None)

        conf = ConfigObj(conf_file)

        try:
            servers = conf["servers"][name]
            if "passwordless" in servers:
                return (True, Remote(servers["connection_string"], True))
            else:
                return (True, Remote(servers["connection_string"]))
        except KeyError:
            return (False, None)

