#!/usr/bin/python
# coding: utf-8
"""
 :copyright: (c) 2011 Philipp Benjamin Köppchen
 :license: GPLv3, see LICENSE for more details.
"""
import httplib
import os
import os.path
import optparse
from zipfile import ZipFile


try:
    import json
except ImportError:
    import simplejson as json


class PackageError(Exception):
    pass


def check_dir(path):
    configfilename = os.path.join(path, 'config.json')

    if not os.path.exists(configfilename):
        raise PackageError("no config.json found.")

    try:
        with open(configfilename, 'r') as fp:
            json.load(fp)
    except Exception, exc:
        raise PackageError("problems when reading 'config.json': %s" % exc)


def create_package(path):
    skippatterns = [
        './.hg/',
        './.homunculus/',
    ]

    check_dir(path)

    with ZipFile(os.path.join(path, 'homunculus.zip'), 'w') as zipfile:
        for dirpath, dirnames, filenames in os.walk(path):
            for filename in filenames:
                fullname = os.path.join(dirpath, filename)

                if fullname == './homunculus.zip' \
                          or any(fullname.startswith(p) for p in skippatterns):
                    continue

                print "adding %r" % fullname
                zipfile.write(fullname)


def upload_package():
    with open("homunculus.zip") as fp:
        post_multipart('homunculus.flyingelephantsoftware.de',
                       '/apps/scrapmetal/revisions/new/',
                       fp.read())


def post_multipart(host, selector, value):

    limit = '----------lImIt_of_THE_fIle_eW_$'



    h = httplib.HTTP(host)
    h.putrequest('POST', selector)
    h.putheader('content-type', 'multipart/form-data; boundary=%s' % limit)
    h.putheader('content-length', str(len(body)))
    h.endheaders()

    h.send(body)

    errcode, errmsg, headers = h.getreply()

    print errcode, errmsg, headers
    print h.file.read()
#    return h.file.read()


def main():
    parser = optparse.OptionParser()

#    parser.add_option('--directory', dest='directory', default=".homunculus",
#                      help="Location, where all data necessary for running "
#                           "the application is stored.")

    options, args = parser.parse_args()

    create_package(os.path.curdir)
#    upload_package()


if __name__ == '__main__':
    main()
