# coding: utf-8
"""
 :copyright: (c) 2011 Philipp Benjamin Köppchen
 :license: GPLv3, see LICENSE for more details.
"""
from __future__ import with_statement

try:
    from json import load
except ImportError:
    from simplejson import load

from glob import glob

import os
import os.path
import logging


config = {}


def init(revision_path):
    """ initializes the homunculus_instancetools-package.

    This function is called automatically by homunculus and should not be
    called manually.

    path:
        path to the revision directory
    """
    global config

    config.clear()

    for filename in glob(os.path.join(revision_path, 'config', '*.json')):
        logging.info('adding %r to homunculus_instancetools.config', filename)
        with open(filename, 'r') as fp:
            keyname = os.path.basename(filename)[:-len('.json')]
            config[keyname] = load(fp)


def _init_from_environment():
    """ Updates config from a file identified by an environment variable.

    Does nothing, if environment variable is not given.
    """
    filename = os.getenv("HOMUNCULUS_CONFIG_FILE")
    if filename:
        with open(filename, 'r') as fp:
            config.update(load(fp))


_init_from_environment()


__all__ = ['config']
