# coding: utf-8
from sqlalchemy import (MetaData, Table, Column, Integer, String, ForeignKey,
                                    LargeBinary, UnicodeText, UniqueConstraint)

meta = MetaData()

app_table = Table(
    'App',
    meta,
    Column('id', Integer, primary_key=True),
    Column('name', String(50), unique=True, nullable=False),
    Column('domain', String(150), nullable=True),
    Column('current_revision_id',
           Integer,
           ForeignKey('Revision.id',
                      use_alter=True,
                      name='revision_fk'),
           nullable=True))


revision_table = Table(
    'Revision',
    meta,
    Column('id', Integer, primary_key=True),
    Column('name', String(50), nullable=False),
    Column('status', String(50), default=u'preparing', nullable=False),
    Column('app_id', Integer, ForeignKey('App.id'), nullable=False),
    Column('data', LargeBinary((2 ** 10) ** 3), nullable=False),
    Column('log', UnicodeText, nullable=False, default=u''),
    UniqueConstraint('app_id', 'name'))


def upgrade(migrate_engine):
    meta.create_all(migrate_engine)


def downgrade(migrate_engine):
    meta.drop_all(migrate_engine)
