# coding: utf-8
"""
 :copyright: (c) 2011 Philipp Benjamin Köppchen
 :license: GPLv3, see LICENSE for more details.
"""
import os.path
from paver.easy import *


@task
@needs('pythonenv')
def test():
    """ runs all texts """
    sh('pythonenv/bin/nosetests tests')


@task
def pythonenv():
    """" creates the virtualenv """
    if os.path.exists('pythonenv'):
        return
    sh('virtualenv --no-site-packages pythonenv')
    sh('pythonenv/bin/pip install nose')


@task
def clean():
    sh("rm -rf pythonenv dist homunculus_instancetools.egg-info")
