# coding: utf-8
"""
 :copyright: (c) 2011 Philipp Benjamin Köppchen
 :license: GPLv3, see LICENSE for more details.
"""
from __future__ import with_statement

import flask
import jinja2
from flask import Blueprint, current_app
import migrate.versioning.api

from helpers import Path

from . import model


flask_sqlalchemy_migrations = Blueprint('flask_sqlalchemy_migrations',
                                        __name__)


@flask_sqlalchemy_migrations.before_app_first_request
def handle_migration():
    #url = current_app.config['SQLALCHEMY_DATABASE_URI']
    url = model.db.engine
    old_dispose = url.dispose
    url.dispose = lambda: None

    try:
        repository = Path(__file__).dirname.join('migrations')
        try:
            migrate.versioning.api.version_control(url, repository)
        except migrate.exceptions.DatabaseAlreadyControlledError, exc:
            pass

        migrate.versioning.api.upgrade(url, repository)
    finally:
        url.dispose = old_dispose


def create_app(config):
    class Application(flask.Flask):
        jinja_options = {'undefined': jinja2.StrictUndefined}

    app = Application('homunculus_server')
    app.config.update({
        'SQLALCHEMY_DATABASE_URI': 'sqlite:homunculus.db',
        'BASEDIR': '/tmp/homunculus',
        'PROPAGATE_EXCEPTIONS': True,

        'HANDLER_CONFIG': {
            'handlers.mysql.handle_mysql': {
                'host': 'localhost',
                'user': 'homunculus',
            }
        },

        'generic_domain': 'homunculus.flyingelephantsoftware.de',
    })
    app.config.update(config)

    import controller
    app.register_blueprint(controller.bp)
    app.register_blueprint(flask_sqlalchemy_migrations)

    app.template_filter('repr')(repr)

    @app.template_filter('ppjson')
    def ppjson_filter(data):
        return flask.json.dumps(data, sort_keys=True, indent=2)

    model.db.init_app(app)

    return app
