# coding: utf-8
from sqlalchemy import (MetaData, Table, Column, Integer, String, ForeignKey,
                          DateTime, LargeBinary, UnicodeText, UniqueConstraint)

meta = MetaData()


app_table = Table(
    'App',
    meta,
    Column('id', Integer, primary_key=True)
    # ...
    )


backup_table = Table(
    'Backup',
    meta,
    Column('id', Integer, primary_key=True),
    Column('app_id', Integer, ForeignKey('App.id'), nullable=False),
    Column('datetime', DateTime, nullable=False),
    Column('data', LargeBinary((2 ** 10) ** 3), nullable=False))


def upgrade(migrate_engine):
    meta.bind = migrate_engine
    backup_table.create()


def downgrade(migrate_engine):
    meta.bind = migrate_engine
    backup_table.drop()
