(function() {
  var hide_errors, show_errors;
  $.fn.serializeObject = function() {
    var item, values, _i, _len, _ref;
    values = {};
    _ref = this.serializeArray();
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      item = _ref[_i];
      values[item.name] = item.value;
    }
    return values;
  };
  $.fn.iframe_json = function() {
    return this[0].contentWindow.json_content;
  };
  show_errors = function(element, errormessage) {
    element.addClass('error');
    element.qtip({
      content: {
        text: $("<p>" + errormessage + "</p>")
      },
      show: {
        event: 'focus'
      },
      hide: {
        event: 'blur'
      },
      position: {
        my: 'top left',
        at: 'bottom left',
        adjust: {
          y: -10
        }
      },
      style: {
        classes: 'error-tooltip'
      }
    });
    return element.focus();
  };
  hide_errors = function(element) {
    var tip;
    tip = element.qtip();
    if (tip && tip.destroy) {
      tip.destroy();
    }
    return element.removeClass('error');
  };
  $(document).ready(function() {
    $('form.onefieldform').submit(function(evt) {
      var form, textfield;
      form = $(evt.target);
      textfield = form.find('input[type=text]');
      $.ajax({
        url: form.attr('action'),
        type: form.attr('method'),
        data: form.serializeObject(),
        success: function(response) {
          var key, message, value;
          if (response.success) {
            hide_errors(textfield);
            return window.location.reload();
          } else {
            message = ((function() {
              var _ref, _results;
              _ref = response.errors;
              _results = [];
              for (key in _ref) {
                value = _ref[key];
                _results.push(value);
              }
              return _results;
            })()).join('<br>');
            return show_errors(textfield, message);
          }
        },
        error: function() {
          return show_errors(textfield, "Server Error");
        }
      });
      return false;
    });
    $('button.safety_button').click(function(evt) {
      var button, content;
      button = $(evt.target);
      content = $("<span>" + (button.data('message')) + "\n<button class='yes'>Yes</button>\n<button class='no'>No</button></span>");
      content.find('.yes').click(function() {
        button.qtip().destroy();
        return $.ajax({
          url: button.data('url'),
          type: button.data('method'),
          data: {
            xsrf_token: xsrf_token
          },
          success: function() {
            return document.location.href = button.data('successurl');
          }
        });
      });
      content.find('.no').click(function() {
        return button.qtip().destroy();
      });
      return button.qtip({
        position: {
          my: "top left",
          at: "top left",
          adjust: {
            y: -16
          }
        },
        show: {
          ready: true
        },
        hide: {
          event: false
        },
        content: content,
        style: {
          classes: "safeclick-tooltip"
        }
      });
    });
    return $('div.file_upload').each(function(index, div) {
      var error, form, iframe, progress;
      form = $(div).find('form');
      progress = $(div).find('.progress');
      error = $(div).find('.error');
      iframe = $(div).find('iframe');
      form.submit(function() {
        console.log('upload started');
        form.hide();
        error.hide();
        return progress.show();
      });
      iframe.load(function() {
        var response;
        console.log('iframe loaded');
        form.hide();
        progress.hide();
        response = iframe.iframe_json();
        if (response.success) {
          return document.location.reload();
        } else {
          error.find('.message').text(response.error);
          return error.show();
        }
      });
      return error.find('button').click(function() {
        form.show();
        error.hide();
        return progress.hide();
      });
    });
  });
}).call(this);
