# coding: utf-8
"""

Memcached
=========

With ::

  "features": {
      "memcached": true,
      # ...
  }

the usage of Memcached can be requested. The application can then use a
memcached daemon, described in the provided configuration: ::

  {
    "host": "hostname",
    "post": 12345
  }

:copyright: (c) 2011 Philipp Benjamin Köppchen
:license: GPLv3, see LICENSE for more details.
"""
from __future__ import absolute_import
from . import feature_added


@feature_added.connect_via(intern('memcached'))
def provide_memcached(name, hom_env, revision_env, **kwargs):
    """ Provides the configuration for memcached

    """
    revision_env.logger('providing memcached...')

    config = hom_env.get_handler_config('handlers.memcached.handle_memcached')
    revision_env.add_config('memcached', config)
