

$.fn.serializeObject = ->
    # Serializes the Values of a form in an object, as {fieldname: "value"}
    values = {}
    for item in this.serializeArray()
        values[item.name] = item.value
    values


$.fn.iframe_json = () ->
    # a hackish solution to get the contents of the iframe as json.
    # usage of .text and friends breaks with browser json formatting plugins.
    this[0].contentWindow.json_content


show_errors = (element, errormessage) ->
    element.addClass('error')
    element.qtip
        content:
            text: $("<p>#{errormessage}</p>")
        show:
            event: 'focus'
        hide:
            event: 'blur'
        position:
            my: 'top left'
            at: 'bottom left'
            adjust:
                y: -10
        style:
            classes: 'error-tooltip'
    element.focus()


hide_errors = (element) ->
    tip = element.qtip()

    # TODO: a little too hackish
    tip.destroy() if tip and tip.destroy
    element.removeClass('error')



$(document).ready ->

  $('form.onefieldform').submit (evt) ->
    form = $(evt.target)
    textfield = form.find('input[type=text]')

    $.ajax
      url: form.attr('action')
      type: form.attr('method')
      data: form.serializeObject()
      success: (response)->
        if response.success
          hide_errors textfield
          window.location.reload()
        else
          message = (value for key, value of response.errors).join('<br>')
          show_errors textfield, message
      error: ->
         show_errors textfield, "Server Error"

    return false

  $('button.safety_button').click (evt) ->
    button = $(evt.target)

    content = $("""<span>#{button.data('message')}
                     <button class='yes'>Yes</button>
                     <button class='no'>No</button></span>""")

    content.find('.yes').click ->
      button.qtip().destroy()
      $.ajax
        url: button.data('url')
        type: button.data('method')
        data:
          xsrf_token: xsrf_token
        success: ->
          document.location.href = button.data('successurl')

    content.find('.no').click ->
      button.qtip().destroy()

    button.qtip
      position:
          my: "top left"
          at: "top left"
          adjust:
              y: -16
      show:
          ready: true
      hide:
          event: false
      content: content
      style:
          classes: "safeclick-tooltip"


  $('div.file_upload').each (index, div) ->
    form = $(div).find('form')
    progress = $(div).find('.progress')
    error = $(div).find('.error')
    iframe = $(div).find('iframe')

    form.submit ->
      console.log 'upload started'
      form.hide()
      error.hide()
      progress.show()

    iframe.load ->
      console.log 'iframe loaded'
      form.hide()
      progress.hide()

      response = iframe.iframe_json()

      if response.success
        document.location.reload()
      else
        error.find('.message').text(response.error)
        error.show()

    error.find('button').click ->
      form.show()
      error.hide()
      progress.hide()

