#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Phil Adams http://philadams.net

hrpg: commandline interface for http://habitrpg.com
http://github.com/philadams/hrpg
"""

import cmd
from pprint import pprint

VERSION = 'hrpg version 0.0.4'
CONFIG_FILE = '~/.hrpgrc'

# check for interactive mode
#if args['--interactive']:
#    hrpg = interactive.InteractiveHRPG(auth=auth)
#    hrgp.cmdloop()


class InteractiveHRPG(cmd.Cmd):
    """interactive cmd.Cmd interface to the HRPG api."""
    intro = 'HRPG interactive commandline interface...'
    prompt = 'hrpg> '

    def __init__(self, auth):
        self.auth = auth
        print('ah')

    def do_status(self, args):
        res = call_api('/user', headers=config)
        pprint(res['stats'])

    def do_server(self, args):
        res = call_api('/status')
        if res['status'] == 'up':
            print('Up and running! All is well.')
        else:
            print('HRPG server is down...')

    def do_quit(self, arg):
        """quits interactive mode"""
        print('hasta luego!')
        exit()
