from binascii import hexlify

from .registry import Registry

class Reader:
    BUTTON_ZONE_MAP = {
        '10': 1,
        '20': 2,
        '40': 3,
        # These do not correspond to any zones
        #'30': None,
        #'50': None,
        #'60': None,
    }

    found_first_packet = False

    def __init__(self, io_dev):
        self.io_dev = io_dev

    def __iter__(self):
        registry = Registry()
        self.unit_registry = registry.all()
        return self

    def __next__(self):
        if not self.found_first_packet:
            data = self.find_start()
            self.found_first_packet = True
        else:
            data = self.read_ascii(5)

        return self.parse(data)

    def find_start(self):
        while not self.found_first_packet:
            button = self.read_ascii(1)
            if button in self.BUTTON_ZONE_MAP:
                esn = self.read_ascii(4)
                if esn in self.unit_registry or not self.unit_registry:
                    self.found_first_packet = True
                    return button + esn

    def read_ascii(self, size):
        data = self.io_dev.read(size)
        return hexlify(data).decode('ascii')

    def parse(self, data):
        zone = None
        if data[0:2] in self.BUTTON_ZONE_MAP:
            zone = self.BUTTON_ZONE_MAP[data[0:2]]

        return {
            'radioId': data[2:],
            'zone': zone
        }

