# -*- coding: utf-8 -*-
import hyperestraier

node = hyperestraier.Node()
node.set_url("http://127.0.0.1:1978/node/test")
node.set_auth("admin", "admin")


doc = hyperestraier.Document()
doc.add_attr("@uri", u"http://localhost/example11.txt")
doc.add_attr("@title", u"Over the rainbowテスト")
doc.add_text(u"ストテSomewhere ほげほげ over the rainbow.  Way up high.:END")
doc.add_text(u"テストThere's a land that I heard of once in a lullaby.")
doc.add_text(u"ストテSomewhere over the rainbow.  Way up high.")
doc.add_text(u"222ストテSomewhere over the rainbow.  Way up high.")
node.put_doc(doc)

doc = hyperestraier.Document()
doc.add_attr("@uri", u"http://localhost/example12.txt")
doc.add_attr("@title", u"Over the rainbowテスト")
doc.add_text(u"ストテSomewhere over the rainbow.  Way up high.")
doc.add_text(u"テストThere's a land that I heard of once in a lullaby.")
doc.add_text(u"ストテSomewhere over the rainbow.  Way up high.")
doc.add_text(u"222ストテSomewhere over the rainbow.  Way up high.")
node.put_doc(doc)

cond = hyperestraier.Condition()
cond.set_phrase(u"ほげほげ")
nres = node.search(cond, 0)
if nres:
    for rdoc in nres.docs:
        print "#" * 20
        v = rdoc.attr("@uri")
        print "URI: " + v

        v = rdoc.attr("@title")
        print "TITLE: " + v
        print rdoc.snippet

