import unittest
import random
import string
import hyperestraier
from  twisted.internet import reactor, defer

def getUid():
    random_string = ''
    for i in range(16):  
        random_string += random.choice(string.letters + string.digits)
    return random_string 


class NodeTestCase:
    
    def setUp(self):
        self.node = hyperestraier.Node(hyperestraier.AsynTransport())
        self.node.set_url("http://192.168.0.52:1978/node/test")
        self.node.set_auth("admin", "admin")
    
    def tearDown(self):
        pass
    
    def run(self):
        for funcName in dir(self):
            if funcName.startswith("test"):
                func = getattr(self, funcName)
                func()
            

    @defer.deferredGenerator
    def testPutDoc(self):
        doc = hyperestraier.Document()
        uid = getUid()
        doc.add_attr("@uri", "http://localhost/" + uid)
        doc.add_attr("@title", "Over the rainbow")
        doc.add_text("There's a land that I heard of once in a lullaby.")
        doc.add_text("Somewhere over the rainbow.  Way up high.")
        wfd = defer.waitForDeferred(self.node.put_doc(doc))
        yield wfd
        p = wfd.getResult()
        print(p)
        assert p==True

    @defer.deferredGenerator
    def testOutDoc(self):
        uid = getUid()
        doc = hyperestraier.Document()
        doc.add_attr("@uri", "http://localhost/"+uid)
        doc.add_attr("@title", "Over the rainbow")
        doc.add_text("There's a land that I heard of once in a lullaby.")
        doc.add_text("Somewhere over the rainbow.  Way up high.")
        
        wfd = defer.waitForDeferred(self.node.put_doc(doc))
        yield wfd
        result = wfd.getResult()
        print(result)
        assert result != None
        
        wfd = defer.waitForDeferred(self.node.uri_to_id("http://localhost/"+uid))
        yield wfd
        result = wfd.getResult()
        print(result)
        assert result != None

        
        wfd = defer.waitForDeferred(self.node.out_doc(result))
        yield wfd
        result = wfd.getResult()
        print(result)
        assert result == True


        doc = hyperestraier.Document()
        uid = getUid()
        doc.add_attr("@uri", "http://localhost/"+uid)
        doc.add_attr("@title", "Over the rainbow")
        doc.add_text("There's a land that I heard of once in a lullaby.")
        doc.add_text("Somewhere over the rainbow.  Way up high.")
        wfd = defer.waitForDeferred(self.node.put_doc(doc))
        yield wfd
        result = wfd.getResult()
        print(result)
        assert result == True

        
        wfd = defer.waitForDeferred(self.node.out_doc_by_uri("http://localhost/"+uid))
        yield wfd
        result = wfd.getResult()
        print(result)
        assert result == True


#     @defer.deferredGenerator
    def testEditDoc(self):
        uid = getUid()
        doc = hyperestraier.Document()
        doc.add_attr("@uri", "http://localhost/"+uid)
        doc.add_attr("@title", "Over the rainbow")
        doc.add_text("There's a land that I heard of once in a lullaby.")
        doc.add_text("Somewhere over the rainbow.  Way up high.")
        wfd = defer.waitForDeferred(self.node.put_doc(doc))
        yield wfd
        result = wfd.getResult()
        assert result == True

        wfd = defer.waitForDeferred(self.node.get_doc_by_uri("http://localhost/"+uid))
        yield wfd
        doc = wfd.getResult()
        wfd = defer.waitForDeferred(self.node.edit_doc(doc))
        yield wfd
        result = wfd.getResult()
        assert result == True

    @defer.deferredGenerator
    def testGetDoc(self):
        uid = getUid()
        doc = hyperestraier.Document()
        doc.add_attr("@uri", "http://localhost/"+uid)
        doc.add_attr("@title", "Over the rainbow")
        doc.add_text("There's a land that I heard of once in a lullaby.")
        doc.add_text("Somewhere over the rainbow.  Way up high.")
        wfd = defer.waitForDeferred(self.node.put_doc(doc))
        yield wfd
        result = wfd.getResult()
        assert result == True

        
        wfd = defer.waitForDeferred(self.node.get_doc_by_uri("http://localhost/"+uid))
        yield wfd
        result = wfd.getResult()
        assert result != None
        assert result.attr("@title") == "Over the rainbow"
        assert result.attr("@uri") == "http://localhost/"+uid

        wfd = defer.waitForDeferred(self.node.uri_to_id("http://localhost/"+uid))
        yield wfd
        hid  = wfd.getResult()
        assert hid != None

        wfd = defer.waitForDeferred(self.node.get_doc(hid))
        yield wfd
        result = wfd.getResult()
        assert result != None
        assert result.attr("@title") == "Over the rainbow"
        assert result.attr("@uri") == "http://localhost/"+uid

    @defer.deferredGenerator
    def testAttr(self):
        uid = getUid()
        doc = hyperestraier.Document()
        doc.add_attr("@uri", "http://localhost/"+uid)
        doc.add_attr("@title", "Over the rainbow")
        doc.add_text("There's a land that I heard of once in a lullaby.")
        doc.add_text("Somewhere over the rainbow.  Way up high.")
        wfd = defer.waitForDeferred(self.node.put_doc(doc))
        yield wfd
        result = wfd.getResult()
        assert result == True
        
        wfd = defer.waitForDeferred(self.node.uri_to_id("http://localhost/"+uid))
        yield wfd
        hid  = wfd.getResult()
        assert hid != None
        
        wfd = defer.waitForDeferred(self.node.get_doc_attr(hid, "@title"))
        yield wfd
        result = wfd.getResult()
        assert result == "Over the rainbow"
        
        wfd = defer.waitForDeferred(self.node.get_doc_attr(hid, "@uri"))
        yield wfd
        result = wfd.getResult()
        assert result == "http://localhost/"+uid

        uri = "http://localhost/"+uid
        wfd = defer.waitForDeferred(self.node.get_doc_attr_by_uri(uri, "@title"))
        yield wfd
        result = wfd.getResult()
        assert result == "Over the rainbow"
        wfd = defer.waitForDeferred(self.node.get_doc_attr_by_uri(uri, "@uri"))
        yield wfd
        result = wfd.getResult()
        assert result == "http://localhost/"+uid

    @defer.deferredGenerator
    def testKword(self):
        uid = getUid()
        doc = hyperestraier.Document()
        doc.add_attr("@uri", "http://localhost/"+uid)
        doc.add_attr("@title", "Over the rainbow")
        doc.add_text("There's a land that I heard of once in a lullaby.")
        doc.add_text("Somewhere over the rainbow.  Way up high.")
        doc.set_keywords({"high": "10.0", "there": "20.0"})
        wfd = defer.waitForDeferred(self.node.put_doc(doc))
        yield wfd
        result = wfd.getResult()
        assert result == True
        
        wfd = defer.waitForDeferred(self.node.uri_to_id("http://localhost/"+uid))
        yield wfd
        hid = wfd.getResult()
        assert hid !=  None
        
        wfd = defer.waitForDeferred(self.node.etch_doc(hid))
        yield wfd
        result = wfd.getResult()
        assert result != None

        wfd = defer.waitForDeferred(self.node.etch_doc_by_uri("http://localhost/"+uid))
        yield wfd
        result = wfd.getResult()
        assert result != None

    @defer.deferredGenerator
    def testSearch(self):
        uid = getUid()
        doc = hyperestraier.Document()
        doc.add_attr("@uri", "http://localhost/"+uid)
        doc.add_attr("@title", "Over the rainbow")
        doc.add_text("There's a land that I heard of once in a lullaby.")
        doc.add_text("Somewhere over the rainbow.  Way up high.")
        doc.set_keywords({"high": "10.0", "there": "20.0"})
        wfd = defer.waitForDeferred(self.node.put_doc(doc))
        yield wfd
        result = wfd.getResult()
        print(result)
        assert result == True

        cond = hyperestraier.Condition()
        cond.set_phrase("rainbow AND lullaby")
        wfd = defer.waitForDeferred(self.node.search(cond, 0))
        yield wfd
        result = wfd.getResult()
        print(result)
        assert len(result.docs) != 0


    @defer.deferredGenerator
    def testNode(self):
        wfd = defer.waitForDeferred(self.node.get_name())
        yield wfd
        print("name: " + wfd.getResult())
        wfd = defer.waitForDeferred(self.node.get_label())
        yield wfd
        print("label: " + wfd.getResult())
        wfd = defer.waitForDeferred(self.node.get_doc_num())
        yield wfd
        print("doc_num: " + str(wfd.getResult()))
        wfd = defer.waitForDeferred(self.node.get_word_num())
        yield wfd
        print("word_num: " + str(wfd.getResult()))
        wfd = defer.waitForDeferred(self.node.get_size())
        yield wfd
        print("size: " + str(wfd.getResult()))
        wfd = defer.waitForDeferred(self.node.get_cache_usage())
        yield wfd
        print("cache_usage: " + str(wfd.getResult()))
        wfd = defer.waitForDeferred(self.node.get_admins())
        yield wfd
        print("admins: " + str(wfd.getResult()))
        wfd = defer.waitForDeferred(self.node.get_users())
        yield wfd
        print("users: " + str(wfd.getResult()))
        wfd = defer.waitForDeferred(self.node.get_links())
        yield wfd
        print("links: " + str(wfd.getResult()))

    @defer.deferredGenerator
    def testSync(self):
        wfd = defer.waitForDeferred(self.node.sync())
        yield wfd
        result = wfd.getResult()
        assert result == True


    @defer.deferredGenerator
    def testOptimize(self):
        wfd = defer.waitForDeferred(self.node.optimize())
        yield wfd
        result = wfd.getResult()
        assert result == True



if __name__ == "__main__":
    testcase = NodeTestCase()
    testcase.setUp()
    testcase.run()
    reactor.run()
