# -*- coding: utf-8 -*-
import hyperestraier

node = hyperestraier.Node()
node.set_url("http://localhost:1978/node/test")
node.set_auth("admin", "admin")


doc = hyperestraier.Document()
doc.add_attr("@uri", u"http://localhost/example2.txt")
doc.add_attr("@title", u"Over the rainbowテスト")
doc.add_text(u"テストThere's a land that I heard of once in a lullaby.")
doc.add_text("Somewhere over the rainbow.  Way up high.")
node.put_doc(doc)

cond = hyperestraier.Condition()
cond.set_phrase(u"テスト")
nres = node.search(cond, 0)
if nres:
    for rdoc in nres.docs:
        print "#" * 20
        v = rdoc.attr("@uri")
        print "URI: " + v
        v = rdoc.attr("@title")
        print "TITLE: " + v
        print rdoc.snippet

