import hyperestraier

node = hyperestraier.Node()
node.set_url("http://localhost:1978/node/test")
node.set_auth("admin", "admin")


doc = hyperestraier.Document()
doc.add_attr("@uri", "http://localhost/example.txt")
doc.add_attr("@title", "Over the rainbow")
doc.add_text("There's a land that I heard of once in a lullaby.")
doc.add_text("Somewhere over the rainbow.  Way up high.")
node.put_doc(doc)

cond = hyperestraier.Condition()
cond.set_phrase("rainbow AND lullaby")
nres = node.search(cond, 0)
if nres:
    for rdoc in nres.docs:
        print "#" * 20
        v = rdoc.attr("@uri")
        print "URI: " + v
        v = rdoc.attr("@title")
        print "TITLE: " + v
        print rdoc.snippet

