# Database
#
# The X-ray lines energies are taken from J.A. Bearden (1967) Rev. Mod.
# Phys, 39 78 as tabulated in Goldstein et al., Plenum publisher
# third edition accompanying CD
#
# The line factor, more precisely the approximate line weight from K,L M
# shells are taken from Goldstein et al., Plenum publisher third edition
# p 286

from hyperspy.misc import utils


elements = {'Ru': {'Physical_properties': {'density (g/cm^3)': 12.37},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 2.683,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 21.658,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 19.279,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 2.835,
                                                                'factor': 0.2},
                                                        'La': {'energy (keV)': 2.559,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 2.382,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 2.252,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 2.763,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 3.18,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 2.9645,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 279.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ru.M5'},
                                                              'M4': {'onset_energy (eV)': 279.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Ru.M5'},
                                                              'M3': {'onset_energy (eV)': 461.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Ru.M3'},
                                                              'M2': {'onset_energy (eV)': 483.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Ru.M3'}}},
                   'General_properties': {'atomic_weight': 101.07,
                                          'Z': 44,
                                          'name': 'ruthenium'}},
            'Re': {'Physical_properties': {'density (g/cm^3)': 21.02},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 10.008,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 69.317,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 61.14,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 10.273,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.843,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 9.8452,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 8.653,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 9.0259,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 7.602,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.9062000000000001,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 10.158,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 2.1067,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 2.4082,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 12.08,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 11.683,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.4367999999999999,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1883.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Re.M5'},
                                                              'M4': {'onset_energy (eV)': 1949.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Re.M5'}}},
                   'General_properties': {'atomic_weight': 186.207,
                                          'Z': 75,
                                          'name': 'rhenium'}},
            'Ra': {'Physical_properties': {'density (g/cm^3)': 5.0},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 15.236,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 100.15,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 88.47,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 14.836,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 14.746,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 12.34,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 13.66,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 10.62,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 2.9629000000000003,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 15.445,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 3.1812,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 3.842,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 18.358,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 17.849,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 2.2256,
                                                               'factor': 0.06}}},
                   'General_properties': {'atomic_weight': 226,
                                          'Z': 88,
                                          'name': 'radium'}},
            'Rb': {'Physical_properties': {'density (g/cm^3)': 1.532},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 1.752,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 14.959,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 13.395,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 1.694,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 1.542,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 1.482,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 1.826,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 2.05,
                                                                'factor': 0.03}},
                                         'Binding_energies': {'M2': {'onset_energy (eV)': 247.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Rb.M3'},
                                                              'M5': {'onset_energy (eV)': 110.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Rb.M5'},
                                                              'M4': {'onset_energy (eV)': 110.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Rb.M5'},
                                                              'L2': {'onset_energy (eV)': 1864.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Rb.L3'},
                                                              'L3': {'onset_energy (eV)': 1804.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Rb.L3'},
                                                              'M3': {'onset_energy (eV)': 238.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Rb.M3'},
                                                              'L1': {'onset_energy (eV)': 2065.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Rb.L1'}}},
                   'General_properties': {'atomic_weight': 85.4678,
                                          'Z': 37,
                                          'name': 'rubidium'}},
            'Rn': {'Physical_properties': {'density (g/cm^3)': 0.00973},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 14.313,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 94.859,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 83.78,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 14.071,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 13.901,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 11.73,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 12.862,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 10.135,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 2.7842,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 14.509,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 2.9977,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 3.5845,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 17.264,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 16.77,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 2.0923000000000003,
                                                               'factor': 0.06}}},
                   'General_properties': {'atomic_weight': 222,
                                          'Z': 86,
                                          'name': 'radon'}},
            'Rh': {'Physical_properties': {'density (g/cm^3)': 12.45},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 2.834,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 22.724,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 20.21,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 3.001,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 2.89,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 2.697,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 2.519,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 2.376,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 2.915,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 3.363,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 3.1438,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 308.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Rh.M5'},
                                                              'M4': {'onset_energy (eV)': 312.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Rh.M5'},
                                                              'M3': {'onset_energy (eV)': 496.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Rh.M3'},
                                                              'M2': {'onset_energy (eV)': 521.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Rh.M3'}}},
                   'General_properties': {'atomic_weight': 102.9055,
                                          'Z': 45,
                                          'name': 'rhodium'}},
            'Be': {'Physical_properties': {'density (g/cm^3)': 1.848},
                   'Atomic_properties': {'Xray_lines': {'Ka': {'energy (keV)': 0.109,
                                                               'factor': 1}},
                                         'Binding_energies': {'K': {'onset_energy (eV)': 111.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'Be.K1'}}},
                   'General_properties': {'atomic_weight': 9.012182,
                                          'Z': 4,
                                          'name': 'beryllium'}},
            'Ba': {'Physical_properties': {'density (g/cm^3)': 3.51},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 4.827,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 36.381,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 32.19,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 5.156,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 4.851,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 4.466,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 4.33,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 3.953,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 4.9258999999999995,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 5.8078,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 5.5299,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 781.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ba.M5'},
                                                              'M4': {'onset_energy (eV)': 796.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Ba.M5'},
                                                              'M3': {'onset_energy (eV)': 1062.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Ba.M3'},
                                                              'M2': {'onset_energy (eV)': 1137.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Ba.M3'},
                                                              'N4': {'onset_energy (eV)': 90.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Ba.N5'},
                                                              'N5': {'onset_energy (eV)': 90.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ba.N5'}}},
                   'General_properties': {'atomic_weight': 137.327,
                                          'Z': 56,
                                          'name': 'barium'}},
            'Bi': {'Physical_properties': {'density (g/cm^3)': 9.78},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 13.024,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 87.319,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 77.11,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 12.976,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 2.423,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 12.689,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 10.84,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 11.709,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 9.418899999999999,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 2.5256,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 13.208,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 2.7357,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 3.2337,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 15.708,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 15.247,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.9013,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 2580.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Bi.M5'},
                                                              'M4': {'onset_energy (eV)': 2688.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Bi.M5'}}},
                   'General_properties': {'atomic_weight': 208.9804,
                                          'Z': 83,
                                          'name': 'bismuth'}},
            'Br': {'Physical_properties': {'density (g/cm^3)': 3.12},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 1.526,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 13.288,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 11.924,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 1.48,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 1.339,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 1.293,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 1.596,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L2': {'onset_energy (eV)': 1596.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Br.L3'},
                                                              'L3': {'onset_energy (eV)': 1550.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Br.L3'},
                                                              'L1': {'onset_energy (eV)': 1782.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Br.L1'}}},
                   'General_properties': {'atomic_weight': 79.904,
                                          'Z': 35,
                                          'name': 'bromine'}},
            'P': {'Physical_properties': {'density (g/cm^3)': 1.823},
                  'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 2.136,
                                                              'factor': 0.1},
                                                       'Ka': {'energy (keV)': 2.014,
                                                              'factor': 1}},
                                        'Binding_energies': {'K': {'onset_energy (eV)': 2146.0,
                                                                   'relevance': 'Major',
                                                                   'factor': 1,
                                                                   'filename': 'P.K1'},
                                                             'L3': {'onset_energy (eV)': 132.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'P.L3'},
                                                             'L1': {'onset_energy (eV)': 189.0,
                                                                    'relevance': 'Minor',
                                                                    'factor': 1,
                                                                    'filename': 'P.L1'}}},
                  'General_properties': {'atomic_weight': 30.973762,
                                         'Z': 15,
                                         'name': 'phosphorus'}},
            'Os': {'Physical_properties': {'density (g/cm^3)': 22.59},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 10.354,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 71.397,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 63.0,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 10.595,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.91,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 10.174,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 8.912,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 9.3351,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 7.8212,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.9783,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 10.509,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 2.182,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 2.5021,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 12.498,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 12.093,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.4919,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1960.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Os.M5'},
                                                              'M4': {'onset_energy (eV)': 2031.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Os.M5'}}},
                   'General_properties': {'atomic_weight': 190.23,
                                          'Z': 76,
                                          'name': 'osmium'}},
            'Ge': {'Physical_properties': {'density (g/cm^3)': 5.323},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 1.218,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 10.98,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 9.886,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 1.188,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 1.068,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 1.036,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 1.294,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L2': {'onset_energy (eV)': 1248.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Ge.L3'},
                                                              'L3': {'onset_energy (eV)': 1217.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ge.L3'},
                                                              'L1': {'onset_energy (eV)': 1414.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Ge.L1'}}},
                   'General_properties': {'atomic_weight': 72.64,
                                          'Z': 32,
                                          'name': 'germanium'}},
            'Gd': {'Physical_properties': {'density (g/cm^3)': 7.901},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 6.7118,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 48.697,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 42.996,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 7.1021,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.185,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 6.686100000000001,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 6.057,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 6.049,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 5.3611,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.2090999999999998,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 6.8302,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.4019000000000001,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.5179,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 8.1038,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 7.7838,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 0.91375,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1185.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Gd.M5'},
                                                              'M4': {'onset_energy (eV)': 1217.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Gd.M5'},
                                                              'M3': {'onset_energy (eV)': 1544.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Gd.M3'},
                                                              'M2': {'onset_energy (eV)': 1688.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Gd.M3'},
                                                              'N4': {'onset_energy (eV)': 141.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Gd.N5'},
                                                              'N5': {'onset_energy (eV)': 141.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Gd.N5'}}},
                   'General_properties': {'atomic_weight': 157.25,
                                          'Z': 64,
                                          'name': 'gadolinium'}},
            'Ga': {'Physical_properties': {'density (g/cm^3)': 5.904},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 1.125,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 10.263,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 9.252,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 1.098,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 0.98399,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 0.957,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 1.197,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L2': {'onset_energy (eV)': 1142.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Ga.L3'},
                                                              'L3': {'onset_energy (eV)': 1115.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ga.L3'},
                                                              'L1': {'onset_energy (eV)': 1298.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Ga.L1'}}},
                   'General_properties': {'atomic_weight': 69.723,
                                          'Z': 31,
                                          'name': 'gallium'}},
            'Pr': {'Physical_properties': {'density (g/cm^3)': 6.64},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 5.4881,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 40.755,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 36.03,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 5.849,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 0.929,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 5.4971000000000005,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 5.034,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 4.9349,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 4.456300000000001,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 0.94932,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 5.591,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.1273,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.191,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 6.6151,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 6.321,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 0.71154,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 931.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Pr.M5'},
                                                              'M4': {'onset_energy (eV)': 951.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Pr.M5'},
                                                              'M3': {'onset_energy (eV)': 1242.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Pr.M3'},
                                                              'M2': {'onset_energy (eV)': 1337.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Pr.M3'},
                                                              'N4': {'onset_energy (eV)': 114.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Pr.N5'},
                                                              'N5': {'onset_energy (eV)': 114.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Pr.N5'}}},
                   'General_properties': {'atomic_weight': 140.90765,
                                          'Z': 59,
                                          'name': 'praseodymium'}},
            'Pt': {'Physical_properties': {'density (g/cm^3)': 21.09},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 11.069,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 75.769,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 66.83,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 11.247,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 2.051,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 10.852,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 9.442,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 9.972700000000001,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 8.267100000000001,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 2.1273,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 11.233,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 2.3309,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 2.6946,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 13.358,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 12.94,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.6022,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 2122.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Pt.M5'},
                                                              'M4': {'onset_energy (eV)': 2202.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Pt.M5'}}},
                   'General_properties': {'atomic_weight': 195.084,
                                          'Z': 78,
                                          'name': 'platinum'}},
            'C': {'Physical_properties': {'density (g/cm^3)': 2.26},
                  'Atomic_properties': {'Xray_lines': {'Ka': {'energy (keV)': 0.277,
                                                              'factor': 1}},
                                        'Binding_energies': {'K': {'onset_energy (eV)': 284.0,
                                                                   'relevance': 'Major',
                                                                   'factor': 1,
                                                                   'filename': 'C.K1'},
                                                             'K1a': {'onset_energy (eV)': 284.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'C.K1a'}}},
                  'General_properties': {'atomic_weight': 12.0107,
                                         'Z': 6,
                                         'name': 'carbon'}},
            'Pb': {'Physical_properties': {'density (g/cm^3)': 11.34},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 12.613,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 84.936,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 74.97,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 12.619,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 2.346,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 12.305,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 10.55,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 11.347,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 9.1831,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 2.4425,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 12.791,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 2.6525,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 3.1245,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 15.215,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 14.761,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.8395,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 2484.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Pb.M5'},
                                                              'M4': {'onset_energy (eV)': 2586.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Pb.M5'}}},
                   'General_properties': {'atomic_weight': 207.2,
                                          'Z': 82,
                                          'name': 'lead'}},
            'Pa': {'Physical_properties': {'density (g/cm^3)': 15.37},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 16.705,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 108.47,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 95.87,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 16.025,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 3.082,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 16.105,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 13.29,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 14.945,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 11.364,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 3.2396,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 16.933,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 3.466,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 4.2605,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 20.099,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 19.562,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 2.4348,
                                                               'factor': 0.06}}},
                   'General_properties': {'atomic_weight': 231.03586,
                                          'Z': 91,
                                          'name': 'protactinium'}},
            'Pd': {'Physical_properties': {'density (g/cm^3)': 12.023},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 2.99,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 23.817,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 21.18,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 3.171,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 3.045,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 2.839,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 2.66,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 2.503,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 3.072,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 3.5529,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 3.328,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 335.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Pd.M5'},
                                                              'M4': {'onset_energy (eV)': 340.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Pd.M5'},
                                                              'M3': {'onset_energy (eV)': 531.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Pd.M3'},
                                                              'M2': {'onset_energy (eV)': 559.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Pd.M3'}}},
                   'General_properties': {'atomic_weight': 106.42,
                                          'Z': 46,
                                          'name': 'palladium'}},
            'Cd': {'Physical_properties': {'density (g/cm^3)': 8.65},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 3.316,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 26.098,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 23.17,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 3.528,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 3.367,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 3.134,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 2.956,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 2.767,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 3.401,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 3.9509000000000003,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 3.716,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 404.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Cd.M5'},
                                                              'M4': {'onset_energy (eV)': 411.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Cd.M5'},
                                                              'M3': {'onset_energy (eV)': 616.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Cd.M3'},
                                                              'M2': {'onset_energy (eV)': 651.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Cd.M3'}}},
                   'General_properties': {'atomic_weight': 112.411,
                                          'Z': 48,
                                          'name': 'cadmium'}},
            'Po': {'Physical_properties': {'density (g/cm^3)': 9.196},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 13.446,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 89.776,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 79.29,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 13.336,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 13.084,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 11.13,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 12.087,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 9.656799999999999,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 2.6105,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 13.645,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 2.8211,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 3.3459,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 16.218,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 15.744,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.9638,
                                                               'factor': 0.06}}},
                   'General_properties': {'atomic_weight': 209,
                                          'Z': 84,
                                          'name': 'polonium'}},
            'Pm': {'Physical_properties': {'density (g/cm^3)': 7.264},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 5.960100000000001,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 43.825,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 38.72,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 6.3378000000000005,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.033,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 5.954899999999999,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 5.433,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 5.3638,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 4.811100000000001,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.0474,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 6.0701,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.2355999999999998,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.3157999999999999,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 7.188899999999999,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 6.890899999999999,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 0.7898099999999999,
                                                               'factor': 0.06}}},
                   'General_properties': {'atomic_weight': 145,
                                          'Z': 61,
                                          'name': 'promethium'}},
            'Ho': {'Physical_properties': {'density (g/cm^3)': 8.795},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 7.524,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 53.877,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 47.55,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 7.91,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.348,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 7.4701,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 6.72,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 6.787100000000001,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 5.9421,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.3829,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 7.6498,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.5764,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.7375,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 9.0861,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 8.7458,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.0451,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1351.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ho.M5'},
                                                              'M4': {'onset_energy (eV)': 1391.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Ho.M5'},
                                                              'M3': {'onset_energy (eV)': 1741.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Ho.M3'},
                                                              'M2': {'onset_energy (eV)': 1923.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Ho.M3'},
                                                              'N4': {'onset_energy (eV)': 161.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Ho.N5'},
                                                              'N5': {'onset_energy (eV)': 161.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ho.N5'}}},
                   'General_properties': {'atomic_weight': 164.93032,
                                          'Z': 67,
                                          'name': 'holmium'}},
            'Hf': {'Physical_properties': {'density (g/cm^3)': 13.31},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 9.020700000000001,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 63.234,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 54.61,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 9.3451,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.645,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 8.9041,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 7.899,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 8.1378,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 6.9582,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.6977,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 9.1621,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.8945999999999998,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 2.1401,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 10.889,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 10.514,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.28,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1662.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Hf.M5'},
                                                              'M4': {'onset_energy (eV)': 1716.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Hf.M5'}}},
                   'General_properties': {'atomic_weight': 178.49,
                                          'Z': 72,
                                          'name': 'hafnium'}},
            'Hg': {'Physical_properties': {'density (g/cm^3)': 13.534},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 11.821,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 80.247,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 70.82,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 11.92,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 2.196,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 11.561,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 9.989,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 10.648,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 8.72,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 2.2825,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 11.993,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 2.4876,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 2.9027,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 14.262,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 13.828,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.7186,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 2295.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Hg.M5'},
                                                              'M4': {'onset_energy (eV)': 2385.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Hg.M5'}}},
                   'General_properties': {'atomic_weight': 200.59,
                                          'Z': 80,
                                          'name': 'mercury'}},
            'Mg': {'Physical_properties': {'density (g/cm^3)': 1.738},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 1.2955,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 1.254,
                                                               'factor': 1}},
                                         'Binding_energies': {'K': {'onset_energy (eV)': 1305.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'Mg.K1'},
                                                              'L2': {'onset_energy (eV)': 51.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Mg.L3'},
                                                              'L3': {'onset_energy (eV)': 51.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Mg.L3'},
                                                              'L1': {'onset_energy (eV)': 89.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Mg.L1'}}},
                   'General_properties': {'atomic_weight': 24.305,
                                          'Z': 12,
                                          'name': 'magnesium'}},
            'K': {'Physical_properties': {'density (g/cm^3)': 0.856},
                  'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 3.589,
                                                              'factor': 0.1},
                                                       'Ka': {'energy (keV)': 3.314,
                                                              'factor': 1}},
                                        'Binding_energies': {'L1': {'onset_energy (eV)': 377.0,
                                                                    'relevance': 'Minor',
                                                                    'factor': 1,
                                                                    'filename': 'K.L1'},
                                                             'L2': {'onset_energy (eV)': 296.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 0.5,
                                                                    'filename': 'K.L3'},
                                                             'L3': {'onset_energy (eV)': 294.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'K.L3'},
                                                             'L1a': {'onset_energy (eV)': 377.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'K.L1a'}}},
                  'General_properties': {'atomic_weight': 39.0983,
                                         'Z': 19,
                                         'name': 'potassium'}},
            'Mn': {'Physical_properties': {'density (g/cm^3)': 7.47},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 6.4891000000000005,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 5.899,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 0.637,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 0.567,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 0.556,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 0.721,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L1': {'onset_energy (eV)': 769.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Mn.L1'},
                                                              'L2': {'onset_energy (eV)': 651.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Mn.L3'},
                                                              'L3': {'onset_energy (eV)': 640.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Mn.L3'},
                                                              'M3': {'onset_energy (eV)': 51.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Mn.M3'},
                                                              'M2': {'onset_energy (eV)': 51.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Mn.M3'}}},
                   'General_properties': {'atomic_weight': 54.938045,
                                          'Z': 25,
                                          'name': 'manganese'}},
            'O': {'Physical_properties': {'density (g/cm^3)': 0.001429},
                  'Atomic_properties': {'Xray_lines': {'Ka': {'energy (keV)': 0.525,
                                                              'factor': 1}},
                                        'Binding_energies': {'K': {'onset_energy (eV)': 532.0,
                                                                   'relevance': 'Major',
                                                                   'factor': 1,
                                                                   'filename': 'O.K1'}}},
                  'General_properties': {'atomic_weight': 15.9994,
                                         'Z': 8,
                                         'name': 'oxygen'}},
            'S': {'Physical_properties': {'density (g/cm^3)': 1.96},
                  'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 2.464,
                                                              'factor': 0.1},
                                                       'Ka': {'energy (keV)': 2.308,
                                                              'factor': 1}},
                                        'Binding_energies': {'L3': {'onset_energy (eV)': 165.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'S.L3'},
                                                             'L1': {'onset_energy (eV)': 229.0,
                                                                    'relevance': 'Minor',
                                                                    'factor': 1,
                                                                    'filename': 'S.L1'}}},
                  'General_properties': {'atomic_weight': 32.065,
                                         'Z': 16,
                                         'name': 'sulfur'}},
            'W': {'Physical_properties': {'density (g/cm^3)': 19.25},
                  'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 9.6709,
                                                               'factor': 0.7},
                                                       'Kb': {'energy (keV)': 67.244,
                                                              'factor': 0.1},
                                                       'Ka': {'energy (keV)': 59.32,
                                                              'factor': 1},
                                                       'Lb2': {'energy (keV)': 9.9583,
                                                               'factor': 0.2},
                                                       'Ma': {'energy (keV)': 1.775,
                                                              'factor': 1},
                                                       'Lb4': {'energy (keV)': 9.5238,
                                                               'factor': 0.05},
                                                       'La': {'energy (keV)': 8.398,
                                                              'factor': 1},
                                                       'Ln': {'energy (keV)': 8.723,
                                                              'factor': 0.01},
                                                       'Ll': {'energy (keV)': 7.386,
                                                              'factor': 0.04},
                                                       'Mb': {'energy (keV)': 1.8349000000000002,
                                                              'factor': 0.6},
                                                       'Lb3': {'energy (keV)': 9.817200000000001,
                                                               'factor': 0.08},
                                                       'Mg': {'energy (keV)': 2.0351,
                                                              'factor': 0.05},
                                                       'M2N4': {'energy (keV)': 2.3144,
                                                                'factor': 0.01},
                                                       'Lg3': {'energy (keV)': 11.672,
                                                               'factor': 0.03},
                                                       'Lg1': {'energy (keV)': 11.284,
                                                               'factor': 0.08},
                                                       'Mz': {'energy (keV)': 1.3834000000000002,
                                                              'factor': 0.06}},
                                        'Binding_energies': {'M5': {'onset_energy (eV)': 1809.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'W.M5'},
                                                             'M4': {'onset_energy (eV)': 1872.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 0.6666666666666666,
                                                                    'filename': 'W.M5'}}},
                  'General_properties': {'atomic_weight': 183.84,
                                         'Z': 74,
                                         'name': 'tungsten'}},
            'Zn': {'Physical_properties': {'density (g/cm^3)': 7.14},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 1.034,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 9.5701,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 8.639,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 1.012,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 0.906,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 0.884,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 1.107,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L1': {'onset_energy (eV)': 1194.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Zn.L1'},
                                                              'L2': {'onset_energy (eV)': 1043.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Zn.L3'},
                                                              'L3': {'onset_energy (eV)': 1020.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Zn.L3'},
                                                              'M3': {'onset_energy (eV)': 87.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Zn.M3'},
                                                              'M2': {'onset_energy (eV)': 87.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Zn.M3'}}},
                   'General_properties': {'atomic_weight': 65.38,
                                          'Z': 30,
                                          'name': 'zinc'}},
            'Eu': {'Physical_properties': {'density (g/cm^3)': 5.244},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 6.455,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 47.028,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 41.54,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 6.8418,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.131,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 6.4379,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 5.846,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 5.816,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 5.176,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.1533,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 6.5699,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.346,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.4485,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 7.795,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 7.479100000000001,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 0.8719,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1131.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Eu.M5'},
                                                              'M4': {'onset_energy (eV)': 1161.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Eu.M5'},
                                                              'M3': {'onset_energy (eV)': 1481.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Eu.M3'},
                                                              'M2': {'onset_energy (eV)': 1614.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Eu.M3'},
                                                              'N4': {'onset_energy (eV)': 134.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Eu.N5'},
                                                              'N5': {'onset_energy (eV)': 134.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Eu.N5'}}},
                   'General_properties': {'atomic_weight': 151.964,
                                          'Z': 63,
                                          'name': 'europium'}},
            'Zr': {'Physical_properties': {'density (g/cm^3)': 6.511},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 2.124,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 17.668,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 15.775,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 2.219,
                                                                'factor': 0.2},
                                                        'La': {'energy (keV)': 2.042,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 1.876,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 1.792,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 2.201,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 2.502,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 2.302,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M2': {'onset_energy (eV)': 344.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Zr.M3'},
                                                              'M5': {'onset_energy (eV)': 181.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Zr.M5'},
                                                              'M4': {'onset_energy (eV)': 181.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Zr.M5'},
                                                              'L2': {'onset_energy (eV)': 2307.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Zr.L3'},
                                                              'L3': {'onset_energy (eV)': 2222.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Zr.L3'},
                                                              'M3': {'onset_energy (eV)': 330.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Zr.M3'},
                                                              'L1': {'onset_energy (eV)': 2532.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Zr.L1'}}},
                   'General_properties': {'atomic_weight': 91.224,
                                          'Z': 40,
                                          'name': 'zirconium'}},
            'Er': {'Physical_properties': {'density (g/cm^3)': 9.066},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 7.8088,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 55.681,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 49.13,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 8.187899999999999,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.406,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 7.744,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 6.949,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 7.0448,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 6.1417,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.443,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 7.9378,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.643,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.8144,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 9.4289,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 9.0869,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.0903,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1409.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Er.M5'},
                                                              'M4': {'onset_energy (eV)': 1453.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Er.M5'},
                                                              'M3': {'onset_energy (eV)': 1812.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Er.M3'},
                                                              'M2': {'onset_energy (eV)': 2006.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Er.M3'},
                                                              'N4': {'onset_energy (eV)': 168.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Er.N5'},
                                                              'N5': {'onset_energy (eV)': 168.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Er.N5'}}},
                   'General_properties': {'atomic_weight': 167.259,
                                          'Z': 68,
                                          'name': 'erbium'}},
            'Ni': {'Physical_properties': {'density (g/cm^3)': 8.908},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 0.869,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 8.263200000000001,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 7.478,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 0.852,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 0.7619900000000001,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 0.743,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 0.941,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L1': {'onset_energy (eV)': 1008.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Ni.L1'},
                                                              'L2': {'onset_energy (eV)': 872.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Ni.L3'},
                                                              'L3': {'onset_energy (eV)': 855.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ni.L3'},
                                                              'M3': {'onset_energy (eV)': 68.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ni.M3'},
                                                              'M2': {'onset_energy (eV)': 68.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Ni.M3'}}},
                   'General_properties': {'atomic_weight': 58.6934,
                                          'Z': 28,
                                          'name': 'nickel'}},
            'Na': {'Physical_properties': {'density (g/cm^3)': 0.968},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 1.0672000000000001,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 1.041,
                                                               'factor': 1}},
                                         'Binding_energies': {'K': {'onset_energy (eV)': 1072.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'Na.K1'},
                                                              'L3': {'onset_energy (eV)': 31.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Na.L3'},
                                                              'L1': {'onset_energy (eV)': 63.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Na.L1'}}},
                   'General_properties': {'atomic_weight': 22.98976928,
                                          'Z': 11,
                                          'name': 'sodium'}},
            'Nb': {'Physical_properties': {'density (g/cm^3)': 8.57},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 2.257,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 18.623,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 16.615,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 2.367,
                                                                'factor': 0.2},
                                                        'La': {'energy (keV)': 2.166,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 1.996,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 1.902,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 2.334,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 2.663,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 2.461,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M2': {'onset_energy (eV)': 378.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Nb.M3'},
                                                              'M5': {'onset_energy (eV)': 202.3,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Nb.M5'},
                                                              'M4': {'onset_energy (eV)': 205.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Nb.M5'},
                                                              'L2': {'onset_energy (eV)': 2465.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Nb.L3'},
                                                              'L3': {'onset_energy (eV)': 2371.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Nb.L3'},
                                                              'M3': {'onset_energy (eV)': 363.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Nb.M3'},
                                                              'L1': {'onset_energy (eV)': 2698.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Nb.L1'}}},
                   'General_properties': {'atomic_weight': 92.90638,
                                          'Z': 41,
                                          'name': 'niobium'}},
            'Nd': {'Physical_properties': {'density (g/cm^3)': 7.01},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 5.721100000000001,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 42.272,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 37.36,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 6.087899999999999,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 0.978,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 5.721100000000001,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 5.23,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 5.145,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 4.632,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 0.99663,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 5.8281,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.1802000000000001,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.2523,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 6.9,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 6.601100000000001,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 0.75007,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 978.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Nd.M5'},
                                                              'M4': {'onset_energy (eV)': 1000.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Nd.M5'},
                                                              'M3': {'onset_energy (eV)': 1297.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Nd.M3'},
                                                              'M2': {'onset_energy (eV)': 1403.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Nd.M3'},
                                                              'N4': {'onset_energy (eV)': 118.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Nd.N5'},
                                                              'N5': {'onset_energy (eV)': 118.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Nd.N5'}}},
                   'General_properties': {'atomic_weight': 144.242,
                                          'Z': 60,
                                          'name': 'neodymium'}},
            'Ne': {'Physical_properties': {'density (g/cm^3)': 0.0009},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 0.85741,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 0.849,
                                                               'factor': 1}},
                                         'Binding_energies': {'K': {'onset_energy (eV)': 867.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'Ne.K1'}}},
                   'General_properties': {'atomic_weight': 20.1791,
                                          'Z': 10,
                                          'name': 'neon'}},
            'Fr': {'Physical_properties': {'density (g/cm^3)': 'NaN'},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 14.768,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 97.469,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 86.1,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 14.445,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 14.32,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 12.03,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 13.258,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 10.376,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 2.873,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 14.974,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 3.0887,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 3.7109,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 17.804,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 17.305,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 2.1583,
                                                               'factor': 0.06}}},
                   'General_properties': {'atomic_weight': 223,
                                          'Z': 87,
                                          'name': 'francium'}},
            'Fe': {'Physical_properties': {'density (g/cm^3)': 7.874},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 7.0568,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 6.404,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 0.705,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 0.62799,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 0.615,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 0.792,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'K': {'onset_energy (eV)': 7113.0,
                                                                    'relevance': 'Minor',
                                                                    'factor': 1,
                                                                    'filename': 'Fe.K1'},
                                                              'L1': {'onset_energy (eV)': 846.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Fe.L1'},
                                                              'L2': {'onset_energy (eV)': 721.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Fe.L3'},
                                                              'L3': {'onset_energy (eV)': 708.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Fe.L3'},
                                                              'M3': {'onset_energy (eV)': 57.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Fe.M3'},
                                                              'M2': {'onset_energy (eV)': 57.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Fe.M3'}}},
                   'General_properties': {'atomic_weight': 55.845,
                                          'Z': 26,
                                          'name': 'iron'}},
            'B': {'Physical_properties': {'density (g/cm^3)': 2.46},
                  'Atomic_properties': {'Xray_lines': {'Ka': {'energy (keV)': 0.183,
                                                              'factor': 1}},
                                        'Binding_energies': {'K': {'onset_energy (eV)': 188.0,
                                                                   'relevance': 'Major',
                                                                   'factor': 1,
                                                                   'filename': 'B.K1'}}},
                  'General_properties': {'atomic_weight': 10.811,
                                         'Z': 5,
                                         'name': 'boron'}},
            'F': {'Physical_properties': {'density (g/cm^3)': 0.001696},
                  'Atomic_properties': {'Xray_lines': {'Ka': {'energy (keV)': 0.677,
                                                              'factor': 1}},
                                        'Binding_energies': {'K': {'onset_energy (eV)': 685.0,
                                                                   'relevance': 'Major',
                                                                   'factor': 1,
                                                                   'filename': 'F.K1'}}},
                  'General_properties': {'atomic_weight': 18.9984032,
                                         'Z': 9,
                                         'name': 'fluorine'}},
            'Sr': {'Physical_properties': {'density (g/cm^3)': 2.63},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 1.871,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 15.837,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 14.165,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 1.807,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 1.649,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 1.582,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 1.947,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 2.196,
                                                                'factor': 0.03}},
                                         'Binding_energies': {'M2': {'onset_energy (eV)': 280.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Sr.M3'},
                                                              'M5': {'onset_energy (eV)': 134.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Sr.M5'},
                                                              'M4': {'onset_energy (eV)': 134.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Sr.M5'},
                                                              'L2': {'onset_energy (eV)': 2007.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Sr.L3'},
                                                              'L3': {'onset_energy (eV)': 1940.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Sr.L3'},
                                                              'M3': {'onset_energy (eV)': 269.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Sr.M3'},
                                                              'L1': {'onset_energy (eV)': 2216.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Sr.L1'}}},
                   'General_properties': {'atomic_weight': 87.62,
                                          'Z': 38,
                                          'name': 'strontium'}},
            'N': {'Physical_properties': {'density (g/cm^3)': 0.001251},
                  'Atomic_properties': {'Xray_lines': {'Ka': {'energy (keV)': 0.392,
                                                              'factor': 1}},
                                        'Binding_energies': {'K': {'onset_energy (eV)': 401.0,
                                                                   'relevance': 'Major',
                                                                   'factor': 1,
                                                                   'filename': 'N.K1'}}},
                  'General_properties': {'atomic_weight': 14.0067,
                                         'Z': 7,
                                         'name': 'nitrogen'}},
            'Kr': {'Physical_properties': {'density (g/cm^3)': 0.00375},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 1.636,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 14.11,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 12.649,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 1.586,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 1.438,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 1.385,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 1.706,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 1.909,
                                                                'factor': 0.03}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 89.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Kr.M5'},
                                                              'M4': {'onset_energy (eV)': 89.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Kr.M5'},
                                                              'L2': {'onset_energy (eV)': 1727.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Kr.L3'},
                                                              'L3': {'onset_energy (eV)': 1675.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Kr.L3'},
                                                              'L1': {'onset_energy (eV)': 1921.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Kr.L1'}}},
                   'General_properties': {'atomic_weight': 83.798,
                                          'Z': 36,
                                          'name': 'krypton'}},
            'Si': {'Physical_properties': {'density (g/cm^3)': 2.33},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 1.829,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 1.74,
                                                               'factor': 1}},
                                         'Binding_energies': {'K': {'onset_energy (eV)': 1839.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'Si.K1'},
                                                              'L2': {'onset_energy (eV)': 99.8,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Si.L3'},
                                                              'L3': {'onset_energy (eV)': 99.2,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Si.L3'},
                                                              'L1': {'onset_energy (eV)': 149.7,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Si.L1'}}},
                   'General_properties': {'atomic_weight': 28.0855,
                                          'Z': 14,
                                          'name': 'silicon'}},
            'Sn': {'Physical_properties': {'density (g/cm^3)': 7.31},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 3.662,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 28.49,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 25.27,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 3.9041,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 3.708,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 3.414,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 3.2719,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 3.044,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 3.75,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 4.376,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 4.129899999999999,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 485.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Sn.M5'},
                                                              'M4': {'onset_energy (eV)': 494.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Sn.M5'},
                                                              'M3': {'onset_energy (eV)': 714.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Sn.M3'},
                                                              'M2': {'onset_energy (eV)': 756.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Sn.M3'}}},
                   'General_properties': {'atomic_weight': 118.71,
                                          'Z': 50,
                                          'name': 'tin'}},
            'Sm': {'Physical_properties': {'density (g/cm^3)': 7.353},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 6.204,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 45.406,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 40.12,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 6.586,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.081,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 6.195,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 5.636,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 5.588,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 4.994,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.1000999999999999,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 6.3168999999999995,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.2915,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.3812,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 7.4849,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 7.1769,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 0.83051,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1080.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Sm.M5'},
                                                              'M4': {'onset_energy (eV)': 1106.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Sm.M5'},
                                                              'M3': {'onset_energy (eV)': 1420.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Sm.M3'},
                                                              'M2': {'onset_energy (eV)': 1541.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Sm.M3'},
                                                              'N4': {'onset_energy (eV)': 130.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Sm.N5'},
                                                              'N5': {'onset_energy (eV)': 130.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Sm.N5'}}},
                   'General_properties': {'atomic_weight': 150.36,
                                          'Z': 62,
                                          'name': 'samarium'}},
            'V': {'Physical_properties': {'density (g/cm^3)': 6.11},
                  'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 5.4261,
                                                              'factor': 0.1},
                                                       'Ka': {'energy (keV)': 4.952,
                                                              'factor': 1},
                                                       'La': {'energy (keV)': 0.511,
                                                              'factor': 1},
                                                       'Ln': {'energy (keV)': 0.453,
                                                              'factor': 0.01},
                                                       'Ll': {'energy (keV)': 0.446,
                                                              'factor': 0.04},
                                                       'Lb3': {'energy (keV)': 0.585,
                                                               'factor': 0.08}},
                                        'Binding_energies': {'L1': {'onset_energy (eV)': 628.0,
                                                                    'relevance': 'Minor',
                                                                    'factor': 1,
                                                                    'filename': 'V.L1'},
                                                             'L2': {'onset_energy (eV)': 521.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 0.5,
                                                                    'filename': 'V.L3'},
                                                             'L3': {'onset_energy (eV)': 513.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'V.L3'},
                                                             'M3': {'onset_energy (eV)': 47.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'V.M3'},
                                                             'M2': {'onset_energy (eV)': 47.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 0.5,
                                                                    'filename': 'V.M3'}}},
                  'General_properties': {'atomic_weight': 50.9415,
                                         'Z': 23,
                                         'name': 'vanadium'}},
            'Sc': {'Physical_properties': {'density (g/cm^3)': 2.985},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 4.460100000000001,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 4.091,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 0.395,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 0.353,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 0.348,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 0.458,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L1': {'onset_energy (eV)': 500.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Sc.L1'},
                                                              'L2': {'onset_energy (eV)': 407.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Sc.L3'},
                                                              'L3': {'onset_energy (eV)': 402.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Sc.L3'},
                                                              'M3': {'onset_energy (eV)': 32.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Sc.M3'},
                                                              'M2': {'onset_energy (eV)': 32.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Sc.M3'}}},
                   'General_properties': {'atomic_weight': 44.955912,
                                          'Z': 21,
                                          'name': 'scandium'}},
            'Sb': {'Physical_properties': {'density (g/cm^3)': 6.697},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 3.8429,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 29.729,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 26.36,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 4.1,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 3.8859,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 3.605,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 3.436,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 3.188,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 3.932,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 4.599,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 4.347,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 528.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Sb.M5'},
                                                              'M4': {'onset_energy (eV)': 537.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Sb.M5'},
                                                              'M3': {'onset_energy (eV)': 766.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Sb.M3'},
                                                              'M2': {'onset_energy (eV)': 812.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Sb.M3'}}},
                   'General_properties': {'atomic_weight': 121.76,
                                          'Z': 51,
                                          'name': 'antimony'}},
            'Se': {'Physical_properties': {'density (g/cm^3)': 4.819},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 1.419,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 12.494,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 11.181,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 1.379,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 1.244,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 1.204,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 1.49,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L2': {'onset_energy (eV)': 1476.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Se.L3'},
                                                              'L3': {'onset_energy (eV)': 1436.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Se.L3'},
                                                              'L1': {'onset_energy (eV)': 1654.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Se.L1'}}},
                   'General_properties': {'atomic_weight': 78.96,
                                          'Z': 34,
                                          'name': 'selenium'}},
            'Co': {'Physical_properties': {'density (g/cm^3)': 8.9},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 7.648,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 6.93,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 0.776,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 0.69399,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 0.678,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 0.866,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L1': {'onset_energy (eV)': 926.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Co.L1'},
                                                              'L2': {'onset_energy (eV)': 794.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Co.L3'},
                                                              'L3': {'onset_energy (eV)': 779.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Co.L3'},
                                                              'M3': {'onset_energy (eV)': 62.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Co.M3'},
                                                              'M2': {'onset_energy (eV)': 62.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Co.M3'}}},
                   'General_properties': {'atomic_weight': 58.933195,
                                          'Z': 27,
                                          'name': 'cobalt'}},
            'Cl': {'Physical_properties': {'density (g/cm^3)': 0.003214},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 2.815,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 2.622,
                                                               'factor': 1}},
                                         'Binding_energies': {'L3': {'onset_energy (eV)': 200.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Cl.L3'},
                                                              'L1': {'onset_energy (eV)': 270.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Cl.L1'}}},
                   'General_properties': {'atomic_weight': 35.453,
                                          'Z': 17,
                                          'name': 'chlorine'}},
            'Ca': {'Physical_properties': {'density (g/cm^3)': 1.55},
                   'Atomic_properties': {'Xray_lines': {'Ln': {'energy (keV)': 0.30581,
                                                               'factor': 0.01},
                                                        'Kb': {'energy (keV)': 4.0119,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 3.692,
                                                               'factor': 1},
                                                        'Ll': {'energy (keV)': 0.30207999999999996,
                                                               'factor': 0.04},
                                                        'La': {'energy (keV)': 0.341,
                                                               'factor': 1}},
                                         'Binding_energies': {'L2': {'onset_energy (eV)': 350.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Ca.L3'},
                                                              'L3': {'onset_energy (eV)': 346.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Ca.L3'},
                                                              'L1': {'onset_energy (eV)': 438.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ca.L1'}}},
                   'General_properties': {'atomic_weight': 40.078,
                                          'Z': 20,
                                          'name': 'calcium'}},
            'Ce': {'Physical_properties': {'density (g/cm^3)': 6.689},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 5.261,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 39.255,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 34.72,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 5.612,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 0.883,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 5.276,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 4.84,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 4.731,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 4.287,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 0.9016799999999999,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 5.363899999999999,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.0753,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.1316,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 6.3401000000000005,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 6.0511,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 0.6745399999999999,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 883.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ce.M5'},
                                                              'M4': {'onset_energy (eV)': 901.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Ce.M5'},
                                                              'M3': {'onset_energy (eV)': 1185.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Ce.M3'},
                                                              'M2': {'onset_energy (eV)': 1273.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Ce.M3'},
                                                              'N4': {'onset_energy (eV)': 110.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Ce.N5'},
                                                              'N5': {'onset_energy (eV)': 110.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ce.N5'}}},
                   'General_properties': {'atomic_weight': 140.116,
                                          'Z': 58,
                                          'name': 'cerium'}},
            'Xe': {'Physical_properties': {'density (g/cm^3)': 0.0059},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 4.417,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 33.624,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 29.78,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 4.718100000000001,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 4.45,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 4.11,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 3.958,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 3.637,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 4.512,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 5.3049,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 5.036,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 672.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Xe.M5'},
                                                              'M4': {'onset_energy (eV)': 685.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Xe.M5'}}},
                   'General_properties': {'atomic_weight': 131.293,
                                          'Z': 54,
                                          'name': 'xenon'}},
            'Tm': {'Physical_properties': {'density (g/cm^3)': 9.321},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 8.1002,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 57.517,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 50.74,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 8.466899999999999,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.462,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 8.0241,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 7.18,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 7.308,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 6.3411,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.503,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 8.2292,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.7045,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.8931,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 9.7776,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 9.4239,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.1359000000000001,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1468.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Tm.M5'},
                                                              'M4': {'onset_energy (eV)': 1515.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Tm.M5'},
                                                              'M3': {'onset_energy (eV)': 1884.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Tm.M3'},
                                                              'M2': {'onset_energy (eV)': 2090.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Tm.M3'},
                                                              'N4': {'onset_energy (eV)': 177.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Tm.N5'},
                                                              'N5': {'onset_energy (eV)': 177.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Tm.N5'}}},
                   'General_properties': {'atomic_weight': 168.93421,
                                          'Z': 69,
                                          'name': 'thulium'}},
            'Cs': {'Physical_properties': {'density (g/cm^3)': 1.879},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 4.6189,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 34.992,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 30.97,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 4.935,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 4.649100000000001,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 4.287,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 4.140899999999999,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 3.794,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 4.7161,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 5.5519,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 5.278899999999999,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 726.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Cs.M5'},
                                                              'M4': {'onset_energy (eV)': 740.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Cs.M5'},
                                                              'M3': {'onset_energy (eV)': 998.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Cs.M3'},
                                                              'M2': {'onset_energy (eV)': 1065.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Cs.M3'},
                                                              'N4': {'onset_energy (eV)': 78.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Cs.N5'},
                                                              'N5': {'onset_energy (eV)': 78.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Cs.N5'}}},
                   'General_properties': {'atomic_weight': 132.9054519,
                                          'Z': 55,
                                          'name': 'cesium'}},
            'Cr': {'Physical_properties': {'density (g/cm^3)': 7.14},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 5.946,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 5.415,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 0.573,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 0.51,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 0.5,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 0.654,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L1': {'onset_energy (eV)': 695.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Cr.L1'},
                                                              'L2': {'onset_energy (eV)': 584.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Cr.L3'},
                                                              'L3': {'onset_energy (eV)': 575.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Cr.L3'},
                                                              'M3': {'onset_energy (eV)': 48.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Cr.M3'},
                                                              'M2': {'onset_energy (eV)': 48.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Cr.M3'}}},
                   'General_properties': {'atomic_weight': 51.9961,
                                          'Z': 24,
                                          'name': 'chromium'}},
            'Cu': {'Physical_properties': {'density (g/cm^3)': 8.92},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 0.95,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 8.9041,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 8.048,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 0.93,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 0.83199,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 0.811,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 1.023,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L1': {'onset_energy (eV)': 1096.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Cu.L1'},
                                                              'L2': {'onset_energy (eV)': 951.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Cu.L3'},
                                                              'L3': {'onset_energy (eV)': 931.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Cu.L3'},
                                                              'M3': {'onset_energy (eV)': 74.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Cu.M3'},
                                                              'M2': {'onset_energy (eV)': 74.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Cu.M3'}}},
                   'General_properties': {'atomic_weight': 63.546,
                                          'Z': 29,
                                          'name': 'copper'}},
            'La': {'Physical_properties': {'density (g/cm^3)': 6.146},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 5.0409,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 37.804,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 33.44,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 5.383,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 0.833,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 5.061100000000001,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 4.651,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 4.524,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 4.118600000000001,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 0.8550399999999999,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 5.1429,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.0263,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.0743,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 6.073,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 5.7881,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 0.63809,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 832.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'La.M5'},
                                                              'M4': {'onset_energy (eV)': 849.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'La.M5'},
                                                              'M3': {'onset_energy (eV)': 1123.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'La.M3'},
                                                              'M2': {'onset_energy (eV)': 1204.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'La.M3'},
                                                              'N4': {'onset_energy (eV)': 99.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'La.N5'},
                                                              'N5': {'onset_energy (eV)': 99.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'La.N5'}}},
                   'General_properties': {'atomic_weight': 138.90547,
                                          'Z': 57,
                                          'name': 'lanthanum'}},
            'Li': {'Physical_properties': {'density (g/cm^3)': 0.534},
                   'Atomic_properties': {'Binding_energies': {'K': {'onset_energy (eV)': 55.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'Li.K1'}}},
                   'General_properties': {'Z': 3,
                                          'atomic_weight': 6.939,
                                          'name': 'lithium'}},
            'Tl': {'Physical_properties': {'density (g/cm^3)': 11.85},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 12.211,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 82.576,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 72.87,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 12.268,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 2.271,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 11.929,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 10.27,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 10.992,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 8.9517,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 2.362,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 12.388,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 2.5705999999999998,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 3.0120999999999998,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 14.733,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 14.288,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.7778,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 2389.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Tl.M5'},
                                                              'M4': {'onset_energy (eV)': 2485.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Tl.M5'}}},
                   'General_properties': {'atomic_weight': 204.3833,
                                          'Z': 81,
                                          'name': 'thallium'}},
            'Lu': {'Physical_properties': {'density (g/cm^3)': 9.841},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 8.707799999999999,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 61.283,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 54.07,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 9.0464,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.581,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 8.605,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 7.656,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 7.8558,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 6.752,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.6311,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 8.845,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.8319,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 2.056,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 10.509,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 10.142,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.2315,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1588.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Lu.M5'},
                                                              'M4': {'onset_energy (eV)': 1639.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Lu.M5'},
                                                              'M3': {'onset_energy (eV)': 2024.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Lu.M3'},
                                                              'M2': {'onset_energy (eV)': 2263.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Lu.M3'},
                                                              'N4': {'onset_energy (eV)': 195.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Lu.N5'},
                                                              'N5': {'onset_energy (eV)': 195.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Lu.N5'}}},
                   'General_properties': {'atomic_weight': 174.9668,
                                          'Z': 71,
                                          'name': 'lutetium'}},
            'Th': {'Physical_properties': {'density (g/cm^3)': 11.724},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 16.204,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 105.57,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 93.35,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 15.625,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 2.996,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 15.642,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 12.97,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 14.507,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 11.115,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 3.1459,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 16.425,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 3.3699,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 4.1176,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 19.507,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 18.983,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 2.3638000000000003,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 3332.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Th.M5'},
                                                              'M4': {'onset_energy (eV)': 3491.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Th.M5'},
                                                              'O5': {'onset_energy (eV)': 83.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Th.O5'},
                                                              'O4': {'onset_energy (eV)': 83.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Th.O5'}}},
                   'General_properties': {'atomic_weight': 232.03806,
                                          'Z': 90,
                                          'name': 'thorium'}},
            'Ti': {'Physical_properties': {'density (g/cm^3)': 4.507},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 4.931,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 4.511,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 0.452,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 0.401,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 0.395,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 0.519,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L1': {'onset_energy (eV)': 564.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Ti.L1'},
                                                              'L2': {'onset_energy (eV)': 462.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Ti.L3'},
                                                              'L3': {'onset_energy (eV)': 456.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ti.L3'},
                                                              'M3': {'onset_energy (eV)': 47.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ti.M3'},
                                                              'M2': {'onset_energy (eV)': 47.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Ti.M3'}}},
                   'General_properties': {'atomic_weight': 47.867,
                                          'Z': 22,
                                          'name': 'titanium'}},
            'Te': {'Physical_properties': {'density (g/cm^3)': 6.24},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 4.029,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 30.995,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 27.47,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 4.301,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 4.069,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 3.769,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 3.605,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 3.335,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 4.120100000000001,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 4.8279,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 4.5701,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 572.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Te.M5'},
                                                              'M4': {'onset_energy (eV)': 582.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Te.M5'},
                                                              'M3': {'onset_energy (eV)': 819.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Te.M3'},
                                                              'M2': {'onset_energy (eV)': 870.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Te.M3'}}},
                   'General_properties': {'atomic_weight': 127.6,
                                          'Z': 52,
                                          'name': 'tellurium'}},
            'Tb': {'Physical_properties': {'density (g/cm^3)': 8.219},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 6.977,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 50.382,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 44.48,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 7.3649,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.24,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 6.939100000000001,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 6.273,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 6.2829,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 5.549300000000001,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.2661,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 7.0952,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.461,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.5892,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 8.422,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 8.1002,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 0.95553,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1241.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Tb.M5'},
                                                              'M4': {'onset_energy (eV)': 1275.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Tb.M5'},
                                                              'M3': {'onset_energy (eV)': 1611.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Tb.M3'},
                                                              'M2': {'onset_energy (eV)': 1768.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Tb.M3'},
                                                              'N4': {'onset_energy (eV)': 148.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Tb.N5'},
                                                              'N5': {'onset_energy (eV)': 148.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Tb.N5'}}},
                   'General_properties': {'atomic_weight': 158.92535,
                                          'Z': 65,
                                          'name': 'terbium'}},
            'Tc': {'Physical_properties': {'density (g/cm^3)': 11.5},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 2.536,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 20.619,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 18.367,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 2.674,
                                                                'factor': 0.2},
                                                        'La': {'energy (keV)': 2.424,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 2.249,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 2.131,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 2.615,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 3.002,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 2.79,
                                                                'factor': 0.08}}},
                   'General_properties': {'atomic_weight': 98,
                                          'Z': 43,
                                          'name': 'technetium'}},
            'Ta': {'Physical_properties': {'density (g/cm^3)': 16.65},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 9.3422,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 65.223,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 57.53,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 9.6491,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.71,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 9.2111,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 8.146,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 8.427100000000001,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 7.1719,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.7654,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 9.485899999999999,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.9642,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 2.2259,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 11.276,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 10.893,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.3308,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1735.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ta.M5'},
                                                              'M4': {'onset_energy (eV)': 1793.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Ta.M5'}}},
                   'General_properties': {'atomic_weight': 180.94788,
                                          'Z': 73,
                                          'name': 'tantalum'}},
            'Yb': {'Physical_properties': {'density (g/cm^3)': 6.57},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 8.399799999999999,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 59.37,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 52.39,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 8.757,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.521,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 8.3119,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 7.416,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 7.5792,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 6.5439,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.5675999999999999,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 8.5351,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.7651,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.9737,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 10.141,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 9.777700000000001,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.1830999999999998,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1528.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Yb.M5'},
                                                              'M4': {'onset_energy (eV)': 1576.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Yb.M5'},
                                                              'M3': {'onset_energy (eV)': 1950.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Yb.M3'},
                                                              'M2': {'onset_energy (eV)': 2173.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Yb.M3'},
                                                              'N4': {'onset_energy (eV)': 184.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Yb.N5'},
                                                              'N5': {'onset_energy (eV)': 184.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Yb.N5'}}},
                   'General_properties': {'atomic_weight': 173.054,
                                          'Z': 70,
                                          'name': 'ytterbium'}},
            'Dy': {'Physical_properties': {'density (g/cm^3)': 8.551},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 7.2461,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 52.119,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 45.998,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 7.6338,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.293,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 7.2032,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 6.495,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 6.5328,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 5.742,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 1.325,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 7.3689,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 1.5223,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 1.6624,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 8.7519,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 8.4169,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 0.99775,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 1295.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Dy.M5'},
                                                              'M4': {'onset_energy (eV)': 1332.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Dy.M5'},
                                                              'M3': {'onset_energy (eV)': 1676.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Dy.M3'},
                                                              'M2': {'onset_energy (eV)': 1842.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Dy.M3'},
                                                              'N4': {'onset_energy (eV)': 154.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Dy.N5'},
                                                              'N5': {'onset_energy (eV)': 154.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Dy.N5'}}},
                   'General_properties': {'atomic_weight': 162.5,
                                          'Z': 66,
                                          'name': 'dysprosium'}},
            'I': {'Physical_properties': {'density (g/cm^3)': 4.94},
                  'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 4.2201,
                                                               'factor': 0.7},
                                                       'Kb': {'energy (keV)': 32.297,
                                                              'factor': 0.1},
                                                       'Ka': {'energy (keV)': 28.61,
                                                              'factor': 1},
                                                       'Lb2': {'energy (keV)': 4.5069,
                                                               'factor': 0.2},
                                                       'Lb4': {'energy (keV)': 4.257,
                                                               'factor': 0.05},
                                                       'La': {'energy (keV)': 3.938,
                                                              'factor': 1},
                                                       'Ln': {'energy (keV)': 3.78,
                                                              'factor': 0.01},
                                                       'Ll': {'energy (keV)': 3.484,
                                                              'factor': 0.04},
                                                       'Lb3': {'energy (keV)': 4.313,
                                                               'factor': 0.08},
                                                       'Lg3': {'energy (keV)': 5.065,
                                                               'factor': 0.03},
                                                       'Lg1': {'energy (keV)': 4.8001000000000005,
                                                               'factor': 0.08}},
                                        'Binding_energies': {'M5': {'onset_energy (eV)': 620.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'I.M5'},
                                                             'M4': {'onset_energy (eV)': 631.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 0.6666666666666666,
                                                                    'filename': 'I.M5'},
                                                             'M3': {'onset_energy (eV)': 875.0,
                                                                    'relevance': 'Minor',
                                                                    'factor': 1,
                                                                    'filename': 'I.M3'},
                                                             'M2': {'onset_energy (eV)': 930.0,
                                                                    'relevance': 'Minor',
                                                                    'factor': 0.5,
                                                                    'filename': 'I.M3'}}},
                  'General_properties': {'atomic_weight': 126.90447,
                                         'Z': 53,
                                         'name': 'iodine'}},
            'U': {'Physical_properties': {'density (g/cm^3)': 19.05},
                  'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 17.221,
                                                               'factor': 0.7},
                                                       'Kb': {'energy (keV)': 111.27,
                                                              'factor': 0.1},
                                                       'Ka': {'energy (keV)': 98.44,
                                                              'factor': 1},
                                                       'Lb2': {'energy (keV)': 16.43,
                                                               'factor': 0.2},
                                                       'Ma': {'energy (keV)': 3.171,
                                                              'factor': 1},
                                                       'Lb4': {'energy (keV)': 16.577,
                                                               'factor': 0.05},
                                                       'La': {'energy (keV)': 13.61,
                                                              'factor': 1},
                                                       'Ln': {'energy (keV)': 15.397,
                                                              'factor': 0.01},
                                                       'Ll': {'energy (keV)': 11.616,
                                                              'factor': 0.04},
                                                       'Mb': {'energy (keV)': 3.3364000000000003,
                                                              'factor': 0.6},
                                                       'Lb3': {'energy (keV)': 17.456,
                                                               'factor': 0.08},
                                                       'Mg': {'energy (keV)': 3.5637,
                                                              'factor': 0.05},
                                                       'M2N4': {'energy (keV)': 4.4011000000000005,
                                                                'factor': 0.01},
                                                       'Lg3': {'energy (keV)': 20.715,
                                                               'factor': 0.03},
                                                       'Lg1': {'energy (keV)': 20.168,
                                                               'factor': 0.08},
                                                       'Mz': {'energy (keV)': 2.5067,
                                                              'factor': 0.06}},
                                        'Binding_energies': {'M5': {'onset_energy (eV)': 3552.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'U.M5'},
                                                             'M4': {'onset_energy (eV)': 3728.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 0.6666666666666666,
                                                                    'filename': 'U.M5'},
                                                             'O5': {'onset_energy (eV)': 96.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'U.O5'},
                                                             'O4': {'onset_energy (eV)': 96.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 0.6666666666666666,
                                                                    'filename': 'U.O5'}}},
                  'General_properties': {'atomic_weight': 238.02891,
                                         'Z': 92,
                                         'name': 'uranium'}},
            'Y': {'Physical_properties': {'density (g/cm^3)': 4.472},
                  'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 1.995,
                                                               'factor': 0.7},
                                                       'Kb': {'energy (keV)': 16.739,
                                                              'factor': 0.1},
                                                       'Ka': {'energy (keV)': 14.958,
                                                              'factor': 1},
                                                       'Lb2': {'energy (keV)': 2.075,
                                                               'factor': 0.2},
                                                       'La': {'energy (keV)': 1.923,
                                                              'factor': 1},
                                                       'Ln': {'energy (keV)': 1.761,
                                                              'factor': 0.01},
                                                       'Ll': {'energy (keV)': 1.685,
                                                              'factor': 0.04},
                                                       'Lb3': {'energy (keV)': 2.072,
                                                               'factor': 0.08},
                                                       'Lg3': {'energy (keV)': 2.346,
                                                               'factor': 0.03},
                                                       'Lg1': {'energy (keV)': 2.144,
                                                               'factor': 0.08}},
                                        'Binding_energies': {'M2': {'onset_energy (eV)': 312.0,
                                                                    'relevance': 'Minor',
                                                                    'factor': 0.5,
                                                                    'filename': 'Y.M3'},
                                                             'M5': {'onset_energy (eV)': 160.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'Y.M5'},
                                                             'M4': {'onset_energy (eV)': 160.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 0.6666666666666666,
                                                                    'filename': 'Y.M5'},
                                                             'L2': {'onset_energy (eV)': 2155.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 0.5,
                                                                    'filename': 'Y.L3'},
                                                             'L3': {'onset_energy (eV)': 2080.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'Y.L3'},
                                                             'M3': {'onset_energy (eV)': 300.0,
                                                                    'relevance': 'Minor',
                                                                    'factor': 1,
                                                                    'filename': 'Y.M3'},
                                                             'L1': {'onset_energy (eV)': 2372.0,
                                                                    'relevance': 'Minor',
                                                                    'factor': 1,
                                                                    'filename': 'Y.L1'}}},
                  'General_properties': {'atomic_weight': 88.90585,
                                         'Z': 39,
                                         'name': 'yttrium'}},
            'Ac': {'Physical_properties': {'density (g/cm^3)': 10.07},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 15.714,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 102.8,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 90.88,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 15.231,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 15.188,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 12.65,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 14.081,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 10.867,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 3.0539,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 15.932,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 3.275,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 3.9777,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 18.925,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 18.408,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 2.294,
                                                               'factor': 0.06}}},
                   'General_properties': {'atomic_weight': 227,
                                          'Z': 89,
                                          'name': 'actinium'}},
            'Ag': {'Physical_properties': {'density (g/cm^3)': 10.49},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 3.15,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 24.946,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 22.16,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 3.347,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 3.203,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 2.984,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 2.806,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 2.633,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 3.234,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 3.749,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 3.519,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 367.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ag.M5'},
                                                              'M4': {'onset_energy (eV)': 373.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Ag.M5'},
                                                              'M3': {'onset_energy (eV)': 571.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Ag.M3'},
                                                              'M2': {'onset_energy (eV)': 602.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Ag.M3'}}},
                   'General_properties': {'atomic_weight': 107.8682,
                                          'Z': 47,
                                          'name': 'silver'}},
            'Ir': {'Physical_properties': {'density (g/cm^3)': 22.56},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 10.706,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 73.562,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 64.9,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 10.918,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 1.98,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 10.509,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 9.175,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 9.649,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 8.0431,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 2.0533,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 10.866,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 2.2542,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 2.5936999999999997,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 12.921,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 12.509,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.5457,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 2040.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ir.M5'},
                                                              'M4': {'onset_energy (eV)': 2116.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Ir.M5'}}},
                   'General_properties': {'atomic_weight': 192.217,
                                          'Z': 77,
                                          'name': 'iridium'}},
            'Al': {'Physical_properties': {'density (g/cm^3)': 2.7},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 1.553,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 1.487,
                                                               'factor': 1}},
                                         'Binding_energies': {'K': {'onset_energy (eV)': 1560.0,
                                                                    'relevance': 'Major',
                                                                    'factor': 1,
                                                                    'filename': 'Al.K1'},
                                                              'L3': {'onset_energy (eV)': 73.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Al.L3'},
                                                              'L1': {'onset_energy (eV)': 118.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Al.L1'}}},
                   'General_properties': {'atomic_weight': 26.9815386,
                                          'Z': 13,
                                          'name': 'aluminum'}},
            'As': {'Physical_properties': {'density (g/cm^3)': 5.727},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 1.317,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 11.724,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 10.544,
                                                               'factor': 1},
                                                        'La': {'energy (keV)': 1.282,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 1.155,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 1.12,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 1.388,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'L2': {'onset_energy (eV)': 1359.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'As.L3'},
                                                              'L3': {'onset_energy (eV)': 1323.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'As.L3'},
                                                              'L1': {'onset_energy (eV)': 1526.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'As.L1'}}},
                   'General_properties': {'atomic_weight': 74.9216,
                                          'Z': 33,
                                          'name': 'arsenic'}},
            'Ar': {'Physical_properties': {'density (g/cm^3)': 0.001784},
                   'Atomic_properties': {'Xray_lines': {'Kb': {'energy (keV)': 3.19,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 2.958,
                                                               'factor': 1}},
                                         'Binding_energies': {'L3': {'onset_energy (eV)': 245.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Ar.L3'},
                                                              'L1': {'onset_energy (eV)': 320.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Ar.L1'}}},
                   'General_properties': {'atomic_weight': 39.948,
                                          'Z': 18,
                                          'name': 'argon'}},
            'Au': {'Physical_properties': {'density (g/cm^3)': 19.3},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 11.441,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 77.965,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 66.99,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 11.582,
                                                                'factor': 0.2},
                                                        'Ma': {'energy (keV)': 2.123,
                                                               'factor': 1},
                                                        'Lb4': {'energy (keV)': 11.203,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 9.713,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 10.307,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 8.493,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 2.2045,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 11.608,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 2.4097,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 2.7974,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 13.806,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 13.379,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 1.6605999999999999,
                                                               'factor': 0.06}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 2206.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Au.M5'},
                                                              'M4': {'onset_energy (eV)': 2291.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Au.M5'}}},
                   'General_properties': {'atomic_weight': 196.966569,
                                          'Z': 79,
                                          'name': 'gold'}},
            'At': {'Physical_properties': {'density (g/cm^3)': 'NaN'},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 13.874,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 92.316,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 81.52,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 13.701,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 13.489,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 11.43,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 12.472,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 9.8955,
                                                               'factor': 0.04},
                                                        'Mb': {'energy (keV)': 2.6967,
                                                               'factor': 0.6},
                                                        'Lb3': {'energy (keV)': 14.065,
                                                                'factor': 0.08},
                                                        'Mg': {'energy (keV)': 2.9085,
                                                               'factor': 0.05},
                                                        'M2N4': {'energy (keV)': 3.4628,
                                                                 'factor': 0.01},
                                                        'Lg3': {'energy (keV)': 16.737,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 16.251,
                                                                'factor': 0.08},
                                                        'Mz': {'energy (keV)': 2.0275,
                                                               'factor': 0.06}}},
                   'General_properties': {'atomic_weight': 210,
                                          'Z': 85,
                                          'name': 'astatine'}},
            'In': {'Physical_properties': {'density (g/cm^3)': 7.31},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 3.487,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 27.278,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 24.21,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 3.713,
                                                                'factor': 0.2},
                                                        'Lb4': {'energy (keV)': 3.535,
                                                                'factor': 0.05},
                                                        'La': {'energy (keV)': 3.287,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 3.1119,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 2.904,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 3.572,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 4.16,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 3.92,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M5': {'onset_energy (eV)': 443.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'In.M5'},
                                                              'M4': {'onset_energy (eV)': 451.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'In.M5'},
                                                              'M3': {'onset_energy (eV)': 664.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'In.M3'},
                                                              'M2': {'onset_energy (eV)': 702.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'In.M3'}}},
                   'General_properties': {'atomic_weight': 114.818,
                                          'Z': 49,
                                          'name': 'indium'}},
            'Mo': {'Physical_properties': {'density (g/cm^3)': 10.28},
                   'Atomic_properties': {'Xray_lines': {'Lb1': {'energy (keV)': 2.394,
                                                                'factor': 0.7},
                                                        'Kb': {'energy (keV)': 19.609,
                                                               'factor': 0.1},
                                                        'Ka': {'energy (keV)': 17.479,
                                                               'factor': 1},
                                                        'Lb2': {'energy (keV)': 2.518,
                                                                'factor': 0.2},
                                                        'La': {'energy (keV)': 2.293,
                                                               'factor': 1},
                                                        'Ln': {'energy (keV)': 2.12,
                                                               'factor': 0.01},
                                                        'Ll': {'energy (keV)': 2.015,
                                                               'factor': 0.04},
                                                        'Lb3': {'energy (keV)': 2.473,
                                                                'factor': 0.08},
                                                        'Lg3': {'energy (keV)': 2.8299000000000003,
                                                                'factor': 0.03},
                                                        'Lg1': {'energy (keV)': 2.623,
                                                                'factor': 0.08}},
                                         'Binding_energies': {'M2': {'onset_energy (eV)': 410.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 0.5,
                                                                     'filename': 'Mo.M3'},
                                                              'M5': {'onset_energy (eV)': 227.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Mo.M5'},
                                                              'M4': {'onset_energy (eV)': 228.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.6666666666666666,
                                                                     'filename': 'Mo.M5'},
                                                              'L2': {'onset_energy (eV)': 2625.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 0.5,
                                                                     'filename': 'Mo.L3'},
                                                              'L3': {'onset_energy (eV)': 2520.0,
                                                                     'relevance': 'Major',
                                                                     'factor': 1,
                                                                     'filename': 'Mo.L3'},
                                                              'M3': {'onset_energy (eV)': 392.0,
                                                                     'relevance': 'Minor',
                                                                     'factor': 1,
                                                                     'filename': 'Mo.M3'},
                                                              'L1': {'onset_energy (eV)': 2866.0,
                                                                     'relevance': '',
                                                                     'factor': 1,
                                                                     'filename': 'Mo.L1'}}},
                   'General_properties': {'atomic_weight': 95.96,
                                          'Z': 42,
                                          'name': 'molybdenum'}}}

elements_db = utils.DictionaryTreeBrowser(elements)
