import SocketServer
import base

################################################################################
################################### Classes ####################################
################################################################################

class BaseRequestHandlerException(base.ISockBaseException): pass

class BaseRequestHandler(SocketServer.BaseRequestHandler,base.Base):
    """
        This class is responsible for Server communication
        A thread that servs a client

        Constants:

        Variables:
    """
    def handle(self):
        """
            This function handles all communication from clients
            Default CommServer behavior is to do communication loop back.
            This function should be overloaded

            Input:
            Nothing

            Returns:
            Nothing
        """
        raise BaseRequestHandlerException("handle function not implement")

    def _recv(self,buffer):
        """
            Low level receive function.

            Input:
            buffer  - Buffer size

            Returns:
            Received data
        """
        import socket

        try: data = self.request.recv(buffer)
        except socket.error as error: raise BaseRequestHandlerException(str(error))

        return data

    def _send(self,data):
        """
            Low level send function.

            Input:
            data    - data to send

            Returns:
            Send data size
        """
        import socket

        try: size = self.request.send(data)
        except socket.error as error: raise BaseRequestHandlerException(str(error))

        return size

    def _close(self):
        """
            Low level close function.

            Input:
            Nothing

            Returns:
            Nothing
        """
        self.request.close()
