"""
ice_pick.filters.usage_types
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

This module contains a set of constants that can be used as usage type
filters. All the constants are based on AWS definitions.

Copyright 2014 Demand Media.

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""


AP_DATA_TRANSFER_OUT_BYTES = 'AP-DataTransfer-Out-Bytes'
AP_REQUEST_TIER_1 = 'AP-Requests-Tier1'
AP_REQUEST_TIER_2_HTTPS = 'AP-Requests-Tier2-HTTPS'
APN1_AWS_IN_BYTES = 'APN1-AWS-In-Bytes'
APN1_AWS_OUT_BYTES = 'APN1-AWS-Out-Bytes'
APS1_AWS_IN_BYTES = 'APS1-AWS-In-Bytes'
APS1_AWS_OUT_BYTES = 'APS1-AWS-Out-Bytes'
APS2_AWS_IN_BYTES = 'APS2-AWS-In-Bytes'
APS2_AWS_OUT_BYTES = 'APS2-AWS-Out-Bytes'
AU_DATA_TRANSFER_OUT_BYTES = 'AU-DataTransfer-Out-Bytes'
AU_REQUESTS_TIER1 = 'AU-Requests-Tier1'
AU_REQUESTS_TIER2_HTTPS = 'AU-Requests-Tier2-HTTPS'
AWS_ACTIVITIES_FREQ = 'AWS-Activities-freq'
AWS_ACTIVITIES_INFREQ = 'AWS-Activities-infreq'
ATTACHMENTS_SIZE_BYTES = 'AttachmentsSize-Bytes'
BOX_USAGE = 'BoxUsage'
C1_MEDIUM = 'c1.medium'
C1_XLARGE = 'c1.xlarge'
C3_4XLARGE_WINDOWS = 'c3.4xlarge.windows'
C3_8XLARGE_WINDOWS = 'c3.8xlarge.windows'
C3_XLARGE = 'c3.xlarge'
C3_XLARGE_WINDOWS = 'c3.xlarge.windows'
CW_ALARM_MONITOR_USAGE = 'CW:AlarmMonitorUsage'
CW_METRIC_MONITOR_USAGE = 'CW:MetricMonitorUsage'
CW_REQUESTS = 'CW:Requests'
CLOSED_RETAINED_WORKFLOW_DAYS = 'ClosedRetainedWorkflowDays'
CLOUD_FRONT_IN_BYTES = 'CloudFront-In-Bytes'
CLOUD_FRONT_OUT_BYTES = 'CloudFront-Out-Bytes'
DNS_QUERIES = 'DNS-Queries'
DATA_PROCESSING_BYTES = 'DataProcessing-Bytes'
DATA_TRANSFER_IN_BYTES = 'DataTransfer-In-Bytes'
DATA_TRANSFER_OUT_BYTES = 'DataTransfer-Out-Bytes'
DATA_TRANSFER_REGIONAL_BYTES = 'DataTransfer-Regional-Bytes'
DELIVERY_ATTEMPS_SMTP = 'DeliveryAttempts-SMTP'
DW_HS1_XLARGE = 'dw.hs1.xlarge'
EBS_SNAPSHOT_USAGE = 'EBS:SnapshotUsage'
EBS_VOLUMEN_IO_USAGE = 'EBS:VolumeIOUsage'
EBS_VOLUMEN_P_IOPS_PIOPS = 'EBS:VolumeP-IOPS.piops'
EBS_VOLUMEN_USAGE = 'EBS:VolumeUsage'
EBS_VOLUMEN_USAGE_PIOPS = 'EBS:VolumeUsage.piops'
EBS_OPTIMIZED_M1_LARGE = 'EBSOptimized:m1.large'
EU_AWS_IN_BYTES = 'EU-AWS-In-Bytes'
EU_AWS_OUT_BYTES = 'EU-AWS-Out-Bytes'
EARLY_DELETE_BYTE_HRS = 'EarlyDelete-ByteHrs'
ELASTIC_IP_IDLE_ADDRESS = 'ElasticIP:IdleAddress'
ELASTIC_IP_REMAP = 'ElasticIP:Remap'
HOSTED_ZONE = 'HostedZone'
IN_DATA_TRANSFER_OUT_BYTES = 'IN-DataTransfer-Out-Bytes'
IN_REQUEST_TIER1 = 'IN-Requests-Tier1'
IN_REQUEST_TIER2_HTTPS = 'IN-Requests-Tier2-HTTPS'
INACTIVE_PIPELINES = 'InactivePipelines'
INITIATED_ACTIONS = 'InitiatedActions'
INITIATED_WORKFLOW = 'InitiatedWorkflows'
INSTANCE_USAGE_DB_M1_LARGE = 'InstanceUsage:db.m1.large'
INSTANCE_USAGE_DB_M1_SMALL = 'InstanceUsage:db.m1.small'
INSTANCE_USAGE_DB_M1_XLARGE = 'InstanceUsage:db.m1.xlarge'
INSTANCE_USAGE_DB_M2_2XLARGE = 'InstanceUsage:db.m2.2xlarge'
INSTANCE_USAGE_DB_T1_MICRO = 'InstanceUsage:db.t1.micro'
INTRA_AWS_DNS_QUERIES = 'Intra-AWS-DNS-Queries'
JP_DATA_TRANSFER_OUT_BYTES = 'JP-DataTransfer-Out-Bytes'
JP_REQUESTS_TIER1 = 'JP-Requests-Tier1'
JP_REQUESTS_TIER2_HTTPS = 'JP-Requests-Tier2-HTTPS'
LOAD_BALANCER_USAGE = 'LoadBalancerUsage'
M1_LARGE = 'm1.large'
M1_LARGE_WINDOWS = 'm1.large.windows'
M1_MEDIUM = 'm1.medium'
M1_SMALL = 'm1.small'
M1_SMALL_WINDOWS = 'm1.small.windows'
M1_XLARGE = 'm1.xlarge'
M2_2XLARGE = 'm2.2xlarge'
M2_4XLARGE = 'm2.4xlarge'
M2_4X_LARGE_WINDOWS = 'm2.4xlarge.windows'
M2_XLARGE = 'm2.xlarge'
M3_2XLARGE = 'm3.2xlarge'
M3_XLARGE = 'm3.xlarge'
MULTI_AZ_USAGE_DB_M1_LARGE = 'Multi-AZUsage:db.m1.large'
MULTI_AZ_USAGE_DB_M1_SMALL = 'Multi-AZUsage:db.m1.small'
MULTI_AZ_USAGE_DB_M1_XLARGE = 'Multi-AZUsage:db.m1.xlarge'
MULTI_AZ_USAGE_DB_M2_2XLARGE = 'Multi-AZUsage:db.m2.2xlarge'
NODE_USAGE_CACHE_M1_SMALL = 'NodeUsage:cache.m1.small'
NODE_USAGE_CACHE_M3_2XLARGE = 'NodeUsage:cache.m3.2xlarge'
OPEN_WORKFLOW_DAYS = 'OpenWorkflowDays'
PUT_REQUEST_VOLUMEN = 'PutRequestVolume'
RDS_MULTI_AZ_PIOPS = 'RDS:Multi-AZ-PIOPS'
RDS_MULTI_AZ_PIOPS_STORAGE = 'RDS:Multi-AZ-PIOPS-Storage'
RDS_MULTI_AZ_STORAGE_USAGE = 'RDS:Multi-AZ-StorageUsage'
RDS_STORAGE_IOUSAGE = 'RDS:StorageIOUsage'
RDS_STORAGE_USAGE = 'RDS:StorageUsage'
READ_CAPACITY_UNIT_HRS = 'ReadCapacityUnit-Hrs'
RECIPIENTS = 'Recipients'
RECIPIENTS_EC2 = 'Recipients-EC2'
REQUEST = 'request'
REQUEST_RBP = 'Requests-RBP'
REQUESTS_TIER1 = 'Requests-Tier1'
REQUESTS_TIER2 = 'Requests-Tier2'
REQUESTS_TIER2_HTTPS = 'Requests-Tier2-HTTPS'
REQUEST_TIER3 = 'Requests-Tier3'
SA_DATA_TRANSFER_OUT_BYTES = 'SA-DataTransfer-Out-Bytes'
SA_REQUEST_TIER1 = 'SA-Requests-Tier1'
SA_REQUESTS_TIER2_HTTPS = 'SA-Requests-Tier2-HTTPS'
SAE1_AWS_IN_BYTES = 'SAE1-AWS-In-Bytes'
SAE1_AWS_OUT_BYTES = 'SAE1-AWS-Out-Bytes'
SSL_CERT_CUSTOM = 'SSL-Cert-Custom'
SPOT_USAGE_M1_MEDIUM = 'SpotUsage:m1.medium'
SPOT_USAGE_T1_MICRO = 'SpotUsage:t1.micro'
STORAGE_SHARD_HOUR = 'Storage-ShardHour'
T1_MICRO = 't1.micro'
T1_MICRO_RHEL = 't1.micro.rhel'
T1_MICRO_WINDOWS = 't1.micro.windows'
TIMED_STORAGE_BYTE_HRS = 'TimedStorage-ByteHrs'
TIMED_STORAGE_GLACIER_BYTE_HRS = 'TimedStorage-GlacierByteHrs'
TIME_STORAGE_RRS_BYTE_HRS = 'TimedStorage-RRS-ByteHrs'
UGW1_AWS_IN_BYTES = 'UGW1-AWS-In-Bytes'
UGW1_AWS_OUT_BYTES = 'UGW1-AWS-Out-Bytes'
US_DATA_TRANSFER_OUT_BYTES = 'US-DataTransfer-Out-Bytes'
US_REQUESTS_TIER1 = 'US-Requests-Tier1'
US_REQUESTS_TIER2_HTTPS = 'US-Requests-Tier2-HTTPS'
USE1_AWS_IN_BYTES = 'USE1-AWS-In-Bytes'
USE1_AWS_OUT_BYTES = 'USE1-AWS-Out-Bytes'
USW1_AWS_IN_BYTES = 'USW1-AWS-In-Bytes'
USW1_AWS_OUT_BYTES = 'USW1-AWS-Out-Bytes'
USW2_AWS_IN_BYTES = 'USW2-AWS-In-Bytes'
USW2_AWS_OUT_BYTES = 'USW2-AWS-Out-Bytes'
VPN_USAGE_HOURS_IPSEC_1 = 'VPN-Usage-Hours:ipsec.1'
WRITE_CAPACITY_UNIT_HRS = 'WriteCapacityUnit-Hrs'
