/* heatmap.js 0.2 Leaflet overlay
 *
 * Copyright (c) 2012, Dominik Moritz
 * Dual-licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
 * and the Beerware (http://en.wikipedia.org/wiki/Beerware) license.
 *
 * Attribution
 *  - Some snippets for canvas layer: https://gist.github.com/2566567
 *  - QuadTree: https://github.com/jsmarkus/ExamplesByMesh/tree/master/JavaScript/QuadTree
 */
L.TileLayer.HeatMap=L.TileLayer.Canvas.extend({options:{debug:false,opacity:0.9,radius:{value:20,absolute:false}},initialize:function(b,c){var a=this;L.Util.setOptions(this,b);this.drawTile=function(g,e,f){var d={canvas:g,tilePoint:e,zoom:f};if(a.options.debug){a._drawDebugInfo(d)}this._draw(d)}},_drawDebugInfo:function(b){var c=L.DomUtil.create("canvas","leaflet-tile-debug");var e=this.options.tileSize;c.width=e;c.height=e;b.canvas.appendChild(c);b.dbgcanvas=c;var a=e;var d=c.getContext("2d");d.strokeStyle="#000000";d.fillStyle="#FFFF00";d.strokeRect(0,0,a,a);d.font="12px Arial";d.fillRect(0,0,5,5);d.fillRect(0,a-5,5,5);d.fillRect(a-5,0,5,5);d.fillRect(a-5,a-5,5,5);d.fillRect(a/2-5,a/2-5,10,10);d.strokeText(b.tilePoint.x+" "+b.tilePoint.y+" "+b.zoom,a/2-30,a/2-10);this._drawPoint(b,[0,0])},_drawPoint:function(a,b){var e=this._tilePoint(a,b);var f=a.dbgcanvas;var d=f.getContext("2d");d.beginPath();d.fillStyle="#FF0000";d.arc(e.x,e.y,4,0,Math.PI*2);d.closePath();d.fill();d.restore()},_createTileProto:function(){var a=this._canvasProto=L.DomUtil.create("div","leaflet-tile");var b=this.options.tileSize;a.style.width=b+"px";a.style.height=b+"px";a.width=b;a.height=b},setData:function(c){var a=this;var b=[];this._maxValue=0;c.forEach(function(e){b.push(new L.LatLng(e.lat,e.lon));a._maxValue=Math.max(a._maxValue,e.value)});this._bounds=new L.LatLngBounds(b);this._quad=new QuadTree(this._boundsToQuery(this._bounds),false,6,6);c.forEach(function(e){a._quad.insert({x:e.lon,y:e.lat,value:e.value})});this.redraw()},_tilePoint:function(b,d){var c=b.tilePoint.multiplyBy(this.options.tileSize);var e=this._map.project(new L.LatLng(d[1],d[0]));var a=Math.round(e.x-c.x);var f=Math.round(e.y-c.y);return[a,f]},_boundsToQuery:function(a){return{x:a.getSouthWest().lng,y:a.getSouthWest().lat,width:a.getNorthEast().lng-a.getSouthWest().lng,height:a.getNorthEast().lat-a.getSouthWest().lat}},_getLatRadius:function(){return(this.options.radius.value/40075017)*360},_getLngRadius:function(a){return this._getLatRadius()/Math.cos(L.LatLng.DEG_TO_RAD*a.lat)},projectLatlngs:function(a){var e=this._getLngRadius(a),d=new L.LatLng(a.lat,a.lng-e,true),c=this._map.latLngToLayerPoint(d),b=this._map.latLngToLayerPoint(a);return Math.max(Math.round(b.x-c.x),1)},_draw:function(o){if(!this._quad||!this._map){return}var n=this,q=this.options,e=o.canvas,m=q.tileSize,g=this.options.radius.value;var j,i,c=[];var l=o.tilePoint.multiplyBy(m),k=l.add(new L.Point(m,m));if(q.radius.absolute){var f=l.add(new L.Point(m/2,m/2));var b=this._map.unproject(f);g=this.projectLatlngs(b)}var h=h337.create({radius:g,element:e,visible:true,opacity:100,gradient:q.gradient,debug:q.debug});var d=new L.Point(g,g);l=l.subtract(d);k=k.add(d);var a=new L.LatLngBounds(this._map.unproject(k),this._map.unproject(l));this._quad.retrieveInBounds(this._boundsToQuery(a)).forEach(function(p){j=n._tilePoint(o,[p.x,p.y]);i=p.value;c.push({x:j[0],y:j[1],count:i})});h.store.setDataSet({max:this._maxValue,data:c});return this}});L.TileLayer.heatMap=function(a){return new L.TileLayer.HeatMap(a)};
