/* heatmap.js 1.0 - JavaScript Heatmap Library

 Copyright (c) 2011, Patrick Wied (http://www.patrick-wied.at)
 Dual-licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
 and the Beerware (http://en.wikipedia.org/wiki/Beerware) license. */
(function(b){var a=(function(){var c=function c(g){var f={data:[],heatmap:g};this.max=1;this.get=function(h){return f[h]};this.set=function(h,i){f[h]=i}};c.prototype={addDataPoint:function(f,j){if(f<0||j<0){return}var g=this,i=g.get("heatmap"),h=g.get("data");if(!h[f]){h[f]=[]}if(!h[f][j]){h[f][j]=0}h[f][j]+=(arguments.length<3)?1:arguments[2];g.set("data",h);if(g.max<h[f][j]){i.get("actx").clearRect(0,0,i.get("width"),i.get("height"));g.setDataSet({max:h[f][j],data:h},true);return}i.drawAlpha(f,j,h[f][j],true)},setDataSet:function(f,h){var l=this,n=l.get("heatmap"),g=[],k=f.data,i=k.length;n.clear();this.max=f.max;n.get("legend")&&n.get("legend").update(f.max);if(h!=null&&h){for(var j in k){if(j===undefined){continue}for(var o in k[j]){if(o===undefined){continue}n.drawAlpha(j,o,k[j][o],false)}}}else{while(i--){var m=k[i];n.drawAlpha(m.x,m.y,m.count,false);if(!g[m.x]){g[m.x]=[]}if(!g[m.x][m.y]){g[m.x][m.y]=0}g[m.x][m.y]=m.count}}n.colorize();this.set("data",k)},exportDataSet:function(){var i=this,j=i.get("data"),g=[];for(var h in j){if(h===undefined){continue}for(var f in j[h]){if(f===undefined){continue}g.push({x:parseInt(h,10),y:parseInt(f,10),count:j[h][f]})}}return{max:i.max,data:g}},generateRandomDataSet:function(j){var m=this.get("heatmap"),g=m.get("width"),i=m.get("height");var l={},f=Math.floor(Math.random()*1000+1);l.max=f;var k=[];while(j--){k.push({x:Math.floor(Math.random()*g+1),y:Math.floor(Math.random()*i+1),count:Math.floor(Math.random()*f+1)})}l.data=k;this.setDataSet(l)}};var d=function d(g){this.config=g;var f={element:null,labelsEl:null,gradientCfg:null,ctx:null};this.get=function(h){return f[h]};this.set=function(h,i){f[h]=i};this.init()};d.prototype={init:function(){var l=this,f=l.config,o=f.title||"Legend",j=f.position,g=f.offset||10,q=f.gradient,m=document.createElement("ul"),k="",p,i,n,h="";l.processGradientObject();if(j.indexOf("t")>-1){h+="top:"+g+"px;"}else{h+="bottom:"+g+"px;"}if(j.indexOf("l")>-1){h+="left:"+g+"px;"}else{h+="right:"+g+"px;"}i=document.createElement("div");i.style.cssText="border-radius:5px;position:absolute;"+h+"font-family:Helvetica; width:256px;z-index:10000000000; background:rgba(255,255,255,1);padding:10px;border:1px solid black;margin:0;";i.innerHTML="<h3 style='padding:0;margin:0;text-align:center;font-size:16px;'>"+o+"</h3>";m.style.cssText="position:relative;font-size:12px;display:block;list-style:none;list-style-type:none;margin:0;height:15px;";n=document.createElement("div");n.style.cssText=["position:relative;display:block;width:256px;height:15px;border-bottom:1px solid black; background-image:url(",l.createGradientImage(),");"].join("");i.appendChild(m);i.appendChild(n);l.set("element",i);l.set("labelsEl",m);l.update(1)},processGradientObject:function(){var i=this,h=this.config.gradient,f=[];for(var g in h){if(h.hasOwnProperty(g)){f.push({stop:g,value:h[g]})}}f.sort(function(k,j){return(k.stop-j.stop)});f.unshift({stop:0,value:"rgba(0,0,0,0)"});i.set("gradientArr",f)},createGradientImage:function(){var k=this,l=k.get("gradientArr"),j=l.length,g=document.createElement("canvas"),f=g.getContext("2d"),m;g.width="256";g.height="15";m=f.createLinearGradient(0,5,256,10);for(var h=0;h<j;h++){m.addColorStop(1/(j-1)*h,l[h].value)}f.fillStyle=m;f.fillRect(0,5,256,10);f.strokeStyle="black";f.beginPath();for(var h=0;h<j;h++){f.moveTo(((1/(j-1)*h*256)>>0)+0.5,0);f.lineTo(((1/(j-1)*h*256)>>0)+0.5,(h==0)?15:5)}f.moveTo(255.5,0);f.lineTo(255.5,15);f.moveTo(255.5,4.5);f.lineTo(0,4.5);f.stroke();k.set("ctx",f);return g.toDataURL()},getElement:function(){return this.get("element")},update:function(m){var l=this,n=l.get("gradientArr"),o=l.get("ctx"),j=l.get("labelsEl"),f,k="",g;for(var h=0;h<n.length;h++){f=m*n[h].stop>>0;g=(o.measureText(f).width/2)>>0;if(h==0){g=0}if(h==n.length-1){g*=2}k+='<li style="position:absolute;left:'+(((((1/(n.length-1)*h*256)||0))>>0)-g+0.5)+'px">'+f+"</li>"}j.innerHTML=k}};var e=function e(g){var f={radius:40,element:{},canvas:{},acanvas:{},ctx:{},actx:{},legend:null,visible:true,width:0,height:0,max:false,gradient:false,opacity:180,premultiplyAlpha:false,bounds:{l:1000,r:0,t:1000,b:0},debug:false};this.store=new c(this);this.get=function(h){return f[h]};this.set=function(h,i){f[h]=i};this.configure(g);this.init()};e.prototype={configure:function(g){var i=this,f,h;i.set("radius",g.radius||40);i.set("element",(g.element instanceof Object)?g.element:document.getElementById(g.element));i.set("visible",(g.visible!=null)?g.visible:true);i.set("max",g.max||false);i.set("gradient",g.gradient||{0.45:"rgb(0,0,255)",0.55:"rgb(0,255,255)",0.65:"rgb(0,255,0)",0.95:"yellow",1:"rgb(255,0,0)"});i.set("opacity",parseInt(255/(100/g.opacity),10)||180);i.set("width",g.width||0);i.set("height",g.height||0);i.set("debug",g.debug);if(g.legend){var j=g.legend;j.gradient=i.get("gradient");i.set("legend",new d(j))}},resize:function(){var i=this,h=i.get("element"),g=i.get("canvas"),f=i.get("acanvas");g.width=f.width=i.get("width")||h.style.width.replace(/px/,"")||i.getWidth(h);this.set("width",g.width);g.height=f.height=i.get("height")||h.style.height.replace(/px/,"")||i.getHeight(h);this.set("height",g.height)},init:function(){var j=this,h=document.createElement("canvas"),g=document.createElement("canvas"),f=h.getContext("2d"),k=g.getContext("2d"),i=j.get("element");j.initColorPalette();j.set("canvas",h);j.set("ctx",f);j.set("acanvas",g);j.set("actx",k);j.resize();h.style.cssText=g.style.cssText="position:absolute;top:0;left:0;z-index:10000000;";if(!j.get("visible")){h.style.display="none"}i.appendChild(h);if(j.get("legend")){i.appendChild(j.get("legend").getElement())}if(j.get("debug")){document.body.appendChild(g)}k.shadowOffsetX=15000;k.shadowOffsetY=15000;k.shadowBlur=15},initColorPalette:function(){var j=this,h=document.createElement("canvas"),k=j.get("gradient"),g,l,i;h.width="1";h.height="256";g=h.getContext("2d");l=g.createLinearGradient(0,0,1,256);i=g.getImageData(0,0,1,1);i.data[0]=i.data[3]=64;i.data[1]=i.data[2]=0;g.putImageData(i,0,0);i=g.getImageData(0,0,1,1);j.set("premultiplyAlpha",(i.data[0]<60||i.data[0]>70));for(var f in k){l.addColorStop(f,k[f])}g.fillStyle=l;g.fillRect(0,0,1,256);j.set("gradient",g.getImageData(0,0,1,256).data)},getWidth:function(f){var g=f.offsetWidth;if(f.style.paddingLeft){g+=f.style.paddingLeft}if(f.style.paddingRight){g+=f.style.paddingRight}return g},getHeight:function(g){var f=g.offsetHeight;if(g.style.paddingTop){f+=g.style.paddingTop}if(g.style.paddingBottom){f+=g.style.paddingBottom}return f},colorize:function(r,q){var F=this,w=F.get("width"),k=F.get("radius"),v=F.get("height"),g=F.get("actx"),z=F.get("ctx"),B=k*3,s=F.get("premultiplyAlpha"),D=F.get("gradient"),h=F.get("opacity"),o=F.get("bounds"),l,t,p,E,u,C,j,m,n,f;if(r!=null&&q!=null){if(r+B>w){r=w-B}if(r<0){r=0}if(q<0){q=0}if(q+B>v){q=v-B}l=r;t=q;E=r+B;p=q+B}else{if(o.l<0){l=0}else{l=o.l}if(o.r>w){E=w}else{E=o.r}if(o.t<0){t=0}else{t=o.t}if(o.b>v){p=v}else{p=o.b}}u=g.getImageData(l,t,E-l,p-t);C=u.data;j=C.length;for(var A=3;A<j;A+=4){m=C[A],n=m*4;if(!n){continue}f=(m<h)?m:h;C[A-3]=D[n];C[A-2]=D[n+1];C[A-1]=D[n+2];if(s){C[A-3]/=255/f;C[A-2]/=255/f;C[A-1]/=255/f}C[A]=f}u.data=C;z.putImageData(u,l,t)},drawAlpha:function(o,m,h,g){var l=this,i=l.get("radius"),q=l.get("actx"),n=l.get("max"),f=l.get("bounds"),r=o-(1.5*i)>>0,k=m-(1.5*i)>>0,p=o+(1.5*i)>>0,j=m+(1.5*i)>>0;q.shadowColor=("rgba(0,0,0,"+((h)?(h/l.store.max):"0.1")+")");q.shadowOffsetX=15000;q.shadowOffsetY=15000;q.shadowBlur=15;q.beginPath();q.arc(o-15000,m-15000,i,0,Math.PI*2,true);q.closePath();q.fill();if(g){l.colorize(r,k)}else{if(r<f.l){f.l=r}if(k<f.t){f.t=k}if(p>f.r){f.r=p}if(j>f.b){f.b=j}}},toggleDisplay:function(){var g=this,h=g.get("visible"),f=g.get("canvas");if(!h){f.style.display="block"}else{f.style.display="none"}g.set("visible",!h)},getImageData:function(){return this.get("canvas").toDataURL()},clear:function(){var i=this,f=i.get("width"),g=i.get("height");i.store.set("data",[]);i.get("ctx").clearRect(0,0,f,g);i.get("actx").clearRect(0,0,f,g)},cleanup:function(){var f=this;f.get("element").removeChild(f.get("canvas"))}};return{create:function(f){return new e(f)},util:{mousePosition:function(g){var f,h;if(g.layerX){f=g.layerX;h=g.layerY}else{if(g.offsetX){f=g.offsetX;h=g.offsetY}}if(typeof(f)=="undefined"){return}return[f,h]}}}})();b.h337=b.heatmapFactory=a})(window);
