function make_graph(url,graph_id){function suffixFormatter(val,axis){return val>1e6?(val/1e6).toFixed(axis.tickDecimals)+" M":val>1e3?(val/1e3).toFixed(axis.tickDecimals)+" k":val.toFixed(axis.tickDecimals)}var graphWidth=940,graphHeight=155,screenWidth=screen.width;screenWidth>=760&&1e3>screenWidth?graphWidth=660:760>screenWidth&&(graphWidth=260);var placeholder=$(graph_id);placeholder.css("width",graphWidth+"px"),placeholder.css("height",graphHeight+"px");var result={};$.ajax({url:url,dataType:"json",async:!1,success:function(json){result=json}});for(var options={grid:{hoverable:!0,borderWidth:{top:0,right:0,bottom:1,left:1}},legend:{show:!1,position:"nw"},series:{lines:{show:!0,fill:!1},points:{show:!0}},xaxis:{mode:"time",timeformat:"%b %Y"},yaxis:{tickDecimals:1,tickFormatter:suffixFormatter}},colors=["rgb(0,150,221)","rgb(184,216,233)","rgb(240,136,30)"],series=[],i=0;i<result.series.length;i++)series.push({label:result.series[i].title,data:result.series[i].data,color:colors[i]});$.plot(document.querySelector(graph_id+" .chart"),series,options);$("<div id='chart_tooltip'></div>").css({position:"absolute",display:"none",border:"1px solid #ddf",padding:"2px","background-color":"#eef",opacity:.8}).appendTo("body"),placeholder.bind("plothover",function(event,pos,item){if(item){var y=(item.datapoint[0],item.datapoint[1]);$("#chart_tooltip").html(item.series.label+": "+y).css({top:item.pageY+5,left:item.pageX+5}).fadeIn(200)}else $("#chart_tooltip").hide()})}!function($){$.color={},$.color.make=function(r,g,b,a){var o={};return o.r=r||0,o.g=g||0,o.b=b||0,o.a=null!=a?a:1,o.add=function(c,d){for(var i=0;i<c.length;++i)o[c.charAt(i)]+=d;return o.normalize()},o.scale=function(c,f){for(var i=0;i<c.length;++i)o[c.charAt(i)]*=f;return o.normalize()},o.toString=function(){return o.a>=1?"rgb("+[o.r,o.g,o.b].join(",")+")":"rgba("+[o.r,o.g,o.b,o.a].join(",")+")"},o.normalize=function(){function clamp(min,value,max){return min>value?min:value>max?max:value}return o.r=clamp(0,parseInt(o.r),255),o.g=clamp(0,parseInt(o.g),255),o.b=clamp(0,parseInt(o.b),255),o.a=clamp(0,o.a,1),o},o.clone=function(){return $.color.make(o.r,o.b,o.g,o.a)},o.normalize()},$.color.extract=function(elem,css){var c;do{if(c=elem.css(css).toLowerCase(),""!=c&&"transparent"!=c)break;elem=elem.parent()}while(elem.length&&!$.nodeName(elem.get(0),"body"));return"rgba(0, 0, 0, 0)"==c&&(c="transparent"),$.color.parse(c)},$.color.parse=function(str){var res,m=$.color.make;if(res=/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(str))return m(parseInt(res[1],10),parseInt(res[2],10),parseInt(res[3],10));if(res=/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]+(?:\.[0-9]+)?)\s*\)/.exec(str))return m(parseInt(res[1],10),parseInt(res[2],10),parseInt(res[3],10),parseFloat(res[4]));if(res=/rgb\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*\)/.exec(str))return m(2.55*parseFloat(res[1]),2.55*parseFloat(res[2]),2.55*parseFloat(res[3]));if(res=/rgba\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\s*\)/.exec(str))return m(2.55*parseFloat(res[1]),2.55*parseFloat(res[2]),2.55*parseFloat(res[3]),parseFloat(res[4]));if(res=/#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(str))return m(parseInt(res[1],16),parseInt(res[2],16),parseInt(res[3],16));if(res=/#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(str))return m(parseInt(res[1]+res[1],16),parseInt(res[2]+res[2],16),parseInt(res[3]+res[3],16));var name=$.trim(str).toLowerCase();return"transparent"==name?m(255,255,255,0):(res=lookupColors[name]||[0,0,0],m(res[0],res[1],res[2]))};var lookupColors={aqua:[0,255,255],azure:[240,255,255],beige:[245,245,220],black:[0,0,0],blue:[0,0,255],brown:[165,42,42],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgrey:[169,169,169],darkgreen:[0,100,0],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkviolet:[148,0,211],fuchsia:[255,0,255],gold:[255,215,0],green:[0,128,0],indigo:[75,0,130],khaki:[240,230,140],lightblue:[173,216,230],lightcyan:[224,255,255],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightyellow:[255,255,224],lime:[0,255,0],magenta:[255,0,255],maroon:[128,0,0],navy:[0,0,128],olive:[128,128,0],orange:[255,165,0],pink:[255,192,203],purple:[128,0,128],violet:[128,0,128],red:[255,0,0],silver:[192,192,192],white:[255,255,255],yellow:[255,255,0]}}(jQuery),function($){function Canvas(cls,container){var element=container.children("."+cls)[0];if(null==element&&(element=document.createElement("canvas"),element.className=cls,$(element).css({direction:"ltr",position:"absolute",left:0,top:0}).appendTo(container),!element.getContext)){if(!window.G_vmlCanvasManager)throw new Error("Canvas is not available. If you're using IE with a fall-back such as Excanvas, then there's either a mistake in your conditional include, or the page has no DOCTYPE and is rendering in Quirks Mode.");element=window.G_vmlCanvasManager.initElement(element)}this.element=element;var context=this.context=element.getContext("2d"),devicePixelRatio=window.devicePixelRatio||1,backingStoreRatio=context.webkitBackingStorePixelRatio||context.mozBackingStorePixelRatio||context.msBackingStorePixelRatio||context.oBackingStorePixelRatio||context.backingStorePixelRatio||1;this.pixelRatio=devicePixelRatio/backingStoreRatio,this.resize(container.width(),container.height()),this.textContainer=null,this.text={},this._textCache={}}function Plot(placeholder,data_,options_,plugins){function executeHooks(hook,args){args=[plot].concat(args);for(var i=0;i<hook.length;++i)hook[i].apply(this,args)}function initPlugins(){for(var classes={Canvas:Canvas},i=0;i<plugins.length;++i){var p=plugins[i];p.init(plot,classes),p.options&&$.extend(!0,options,p.options)}}function parseOptions(opts){$.extend(!0,options,opts),opts&&opts.colors&&(options.colors=opts.colors),null==options.xaxis.color&&(options.xaxis.color=$.color.parse(options.grid.color).scale("a",.22).toString()),null==options.yaxis.color&&(options.yaxis.color=$.color.parse(options.grid.color).scale("a",.22).toString()),null==options.xaxis.tickColor&&(options.xaxis.tickColor=options.grid.tickColor||options.xaxis.color),null==options.yaxis.tickColor&&(options.yaxis.tickColor=options.grid.tickColor||options.yaxis.color),null==options.grid.borderColor&&(options.grid.borderColor=options.grid.color),null==options.grid.tickColor&&(options.grid.tickColor=$.color.parse(options.grid.color).scale("a",.22).toString());var i,axisOptions,axisCount,fontSize=placeholder.css("font-size"),fontSizeDefault=fontSize?+fontSize.replace("px",""):13,fontDefaults={style:placeholder.css("font-style"),size:Math.round(.8*fontSizeDefault),variant:placeholder.css("font-variant"),weight:placeholder.css("font-weight"),family:placeholder.css("font-family")};for(axisCount=options.xaxes.length||1,i=0;axisCount>i;++i)axisOptions=options.xaxes[i],axisOptions&&!axisOptions.tickColor&&(axisOptions.tickColor=axisOptions.color),axisOptions=$.extend(!0,{},options.xaxis,axisOptions),options.xaxes[i]=axisOptions,axisOptions.font&&(axisOptions.font=$.extend({},fontDefaults,axisOptions.font),axisOptions.font.color||(axisOptions.font.color=axisOptions.color),axisOptions.font.lineHeight||(axisOptions.font.lineHeight=Math.round(1.15*axisOptions.font.size)));for(axisCount=options.yaxes.length||1,i=0;axisCount>i;++i)axisOptions=options.yaxes[i],axisOptions&&!axisOptions.tickColor&&(axisOptions.tickColor=axisOptions.color),axisOptions=$.extend(!0,{},options.yaxis,axisOptions),options.yaxes[i]=axisOptions,axisOptions.font&&(axisOptions.font=$.extend({},fontDefaults,axisOptions.font),axisOptions.font.color||(axisOptions.font.color=axisOptions.color),axisOptions.font.lineHeight||(axisOptions.font.lineHeight=Math.round(1.15*axisOptions.font.size)));for(options.xaxis.noTicks&&null==options.xaxis.ticks&&(options.xaxis.ticks=options.xaxis.noTicks),options.yaxis.noTicks&&null==options.yaxis.ticks&&(options.yaxis.ticks=options.yaxis.noTicks),options.x2axis&&(options.xaxes[1]=$.extend(!0,{},options.xaxis,options.x2axis),options.xaxes[1].position="top",null==options.x2axis.min&&(options.xaxes[1].min=null),null==options.x2axis.max&&(options.xaxes[1].max=null)),options.y2axis&&(options.yaxes[1]=$.extend(!0,{},options.yaxis,options.y2axis),options.yaxes[1].position="right",null==options.y2axis.min&&(options.yaxes[1].min=null),null==options.y2axis.max&&(options.yaxes[1].max=null)),options.grid.coloredAreas&&(options.grid.markings=options.grid.coloredAreas),options.grid.coloredAreasColor&&(options.grid.markingsColor=options.grid.coloredAreasColor),options.lines&&$.extend(!0,options.series.lines,options.lines),options.points&&$.extend(!0,options.series.points,options.points),options.bars&&$.extend(!0,options.series.bars,options.bars),null!=options.shadowSize&&(options.series.shadowSize=options.shadowSize),null!=options.highlightColor&&(options.series.highlightColor=options.highlightColor),i=0;i<options.xaxes.length;++i)getOrCreateAxis(xaxes,i+1).options=options.xaxes[i];for(i=0;i<options.yaxes.length;++i)getOrCreateAxis(yaxes,i+1).options=options.yaxes[i];for(var n in hooks)options.hooks[n]&&options.hooks[n].length&&(hooks[n]=hooks[n].concat(options.hooks[n]));executeHooks(hooks.processOptions,[options])}function setData(d){series=parseData(d),fillInSeriesOptions(),processData()}function parseData(d){for(var res=[],i=0;i<d.length;++i){var s=$.extend(!0,{},options.series);null!=d[i].data?(s.data=d[i].data,delete d[i].data,$.extend(!0,s,d[i]),d[i].data=s.data):s.data=d[i],res.push(s)}return res}function axisNumber(obj,coord){var a=obj[coord+"axis"];return"object"==typeof a&&(a=a.n),"number"!=typeof a&&(a=1),a}function allAxes(){return $.grep(xaxes.concat(yaxes),function(a){return a})}function canvasToAxisCoords(pos){var i,axis,res={};for(i=0;i<xaxes.length;++i)axis=xaxes[i],axis&&axis.used&&(res["x"+axis.n]=axis.c2p(pos.left));for(i=0;i<yaxes.length;++i)axis=yaxes[i],axis&&axis.used&&(res["y"+axis.n]=axis.c2p(pos.top));return void 0!==res.x1&&(res.x=res.x1),void 0!==res.y1&&(res.y=res.y1),res}function axisToCanvasCoords(pos){var i,axis,key,res={};for(i=0;i<xaxes.length;++i)if(axis=xaxes[i],axis&&axis.used&&(key="x"+axis.n,null==pos[key]&&1==axis.n&&(key="x"),null!=pos[key])){res.left=axis.p2c(pos[key]);break}for(i=0;i<yaxes.length;++i)if(axis=yaxes[i],axis&&axis.used&&(key="y"+axis.n,null==pos[key]&&1==axis.n&&(key="y"),null!=pos[key])){res.top=axis.p2c(pos[key]);break}return res}function getOrCreateAxis(axes,number){return axes[number-1]||(axes[number-1]={n:number,direction:axes==xaxes?"x":"y",options:$.extend(!0,{},axes==xaxes?options.xaxis:options.yaxis)}),axes[number-1]}function fillInSeriesOptions(){var i,neededColors=series.length,maxIndex=-1;for(i=0;i<series.length;++i){var sc=series[i].color;null!=sc&&(neededColors--,"number"==typeof sc&&sc>maxIndex&&(maxIndex=sc))}maxIndex>=neededColors&&(neededColors=maxIndex+1);var c,colors=[],colorPool=options.colors,colorPoolSize=colorPool.length,variation=0;for(i=0;neededColors>i;i++)c=$.color.parse(colorPool[i%colorPoolSize]||"#666"),i%colorPoolSize==0&&i&&(variation=variation>=0?.5>variation?-variation-.2:0:-variation),colors[i]=c.scale("rgb",1+variation);var s,colori=0;for(i=0;i<series.length;++i){if(s=series[i],null==s.color?(s.color=colors[colori].toString(),++colori):"number"==typeof s.color&&(s.color=colors[s.color].toString()),null==s.lines.show){var v,show=!0;for(v in s)if(s[v]&&s[v].show){show=!1;break}show&&(s.lines.show=!0)}null==s.lines.zero&&(s.lines.zero=!!s.lines.fill),s.xaxis=getOrCreateAxis(xaxes,axisNumber(s,"x")),s.yaxis=getOrCreateAxis(yaxes,axisNumber(s,"y"))}}function processData(){function updateAxis(axis,min,max){min<axis.datamin&&min!=-fakeInfinity&&(axis.datamin=min),max>axis.datamax&&max!=fakeInfinity&&(axis.datamax=max)}var i,j,k,m,s,points,ps,val,f,p,data,format,topSentry=Number.POSITIVE_INFINITY,bottomSentry=Number.NEGATIVE_INFINITY,fakeInfinity=Number.MAX_VALUE;for($.each(allAxes(),function(_,axis){axis.datamin=topSentry,axis.datamax=bottomSentry,axis.used=!1}),i=0;i<series.length;++i)s=series[i],s.datapoints={points:[]},executeHooks(hooks.processRawData,[s,s.data,s.datapoints]);for(i=0;i<series.length;++i){if(s=series[i],data=s.data,format=s.datapoints.format,!format){if(format=[],format.push({x:!0,number:!0,required:!0}),format.push({y:!0,number:!0,required:!0}),s.bars.show||s.lines.show&&s.lines.fill){var autoscale=!!(s.bars.show&&s.bars.zero||s.lines.show&&s.lines.zero);format.push({y:!0,number:!0,required:!1,defaultValue:0,autoscale:autoscale}),s.bars.horizontal&&(delete format[format.length-1].y,format[format.length-1].x=!0)}s.datapoints.format=format}if(null==s.datapoints.pointsize){s.datapoints.pointsize=format.length,ps=s.datapoints.pointsize,points=s.datapoints.points;var insertSteps=s.lines.show&&s.lines.steps;for(s.xaxis.used=s.yaxis.used=!0,j=k=0;j<data.length;++j,k+=ps){p=data[j];var nullify=null==p;if(!nullify)for(m=0;ps>m;++m)val=p[m],f=format[m],f&&(f.number&&null!=val&&(val=+val,isNaN(val)?val=null:1/0==val?val=fakeInfinity:val==-1/0&&(val=-fakeInfinity)),null==val&&(f.required&&(nullify=!0),null!=f.defaultValue&&(val=f.defaultValue))),points[k+m]=val;if(nullify)for(m=0;ps>m;++m)val=points[k+m],null!=val&&(f=format[m],f.autoscale!==!1&&(f.x&&updateAxis(s.xaxis,val,val),f.y&&updateAxis(s.yaxis,val,val))),points[k+m]=null;else if(insertSteps&&k>0&&null!=points[k-ps]&&points[k-ps]!=points[k]&&points[k-ps+1]!=points[k+1]){for(m=0;ps>m;++m)points[k+ps+m]=points[k+m];points[k+1]=points[k-ps+1],k+=ps}}}}for(i=0;i<series.length;++i)s=series[i],executeHooks(hooks.processDatapoints,[s,s.datapoints]);for(i=0;i<series.length;++i){s=series[i],points=s.datapoints.points,ps=s.datapoints.pointsize,format=s.datapoints.format;var xmin=topSentry,ymin=topSentry,xmax=bottomSentry,ymax=bottomSentry;for(j=0;j<points.length;j+=ps)if(null!=points[j])for(m=0;ps>m;++m)val=points[j+m],f=format[m],f&&f.autoscale!==!1&&val!=fakeInfinity&&val!=-fakeInfinity&&(f.x&&(xmin>val&&(xmin=val),val>xmax&&(xmax=val)),f.y&&(ymin>val&&(ymin=val),val>ymax&&(ymax=val)));if(s.bars.show){var delta;switch(s.bars.align){case"left":delta=0;break;case"right":delta=-s.bars.barWidth;break;default:delta=-s.bars.barWidth/2}s.bars.horizontal?(ymin+=delta,ymax+=delta+s.bars.barWidth):(xmin+=delta,xmax+=delta+s.bars.barWidth)}updateAxis(s.xaxis,xmin,xmax),updateAxis(s.yaxis,ymin,ymax)}$.each(allAxes(),function(_,axis){axis.datamin==topSentry&&(axis.datamin=null),axis.datamax==bottomSentry&&(axis.datamax=null)})}function setupCanvases(){placeholder.css("padding",0).children().filter(function(){return!$(this).hasClass("flot-overlay")&&!$(this).hasClass("flot-base")}).remove(),"static"==placeholder.css("position")&&placeholder.css("position","relative"),surface=new Canvas("flot-base",placeholder),overlay=new Canvas("flot-overlay",placeholder),ctx=surface.context,octx=overlay.context,eventHolder=$(overlay.element).unbind();var existing=placeholder.data("plot");existing&&(existing.shutdown(),overlay.clear()),placeholder.data("plot",plot)}function bindEvents(){options.grid.hoverable&&(eventHolder.mousemove(onMouseMove),eventHolder.bind("mouseleave",onMouseLeave)),options.grid.clickable&&eventHolder.click(onClick),executeHooks(hooks.bindEvents,[eventHolder])}function shutdown(){redrawTimeout&&clearTimeout(redrawTimeout),eventHolder.unbind("mousemove",onMouseMove),eventHolder.unbind("mouseleave",onMouseLeave),eventHolder.unbind("click",onClick),executeHooks(hooks.shutdown,[eventHolder])}function setTransformationHelpers(axis){function identity(x){return x}var s,m,t=axis.options.transform||identity,it=axis.options.inverseTransform;"x"==axis.direction?(s=axis.scale=plotWidth/Math.abs(t(axis.max)-t(axis.min)),m=Math.min(t(axis.max),t(axis.min))):(s=axis.scale=plotHeight/Math.abs(t(axis.max)-t(axis.min)),s=-s,m=Math.max(t(axis.max),t(axis.min))),axis.p2c=t==identity?function(p){return(p-m)*s}:function(p){return(t(p)-m)*s},axis.c2p=it?function(c){return it(m+c/s)}:function(c){return m+c/s}}function measureTickLabels(axis){for(var opts=axis.options,ticks=axis.ticks||[],labelWidth=opts.labelWidth||0,labelHeight=opts.labelHeight||0,maxWidth=labelWidth||("x"==axis.direction?Math.floor(surface.width/(ticks.length||1)):null),legacyStyles=axis.direction+"Axis "+axis.direction+axis.n+"Axis",layer="flot-"+axis.direction+"-axis flot-"+axis.direction+axis.n+"-axis "+legacyStyles,font=opts.font||"flot-tick-label tickLabel",i=0;i<ticks.length;++i){var t=ticks[i];if(t.label){var info=surface.getTextInfo(layer,t.label,font,null,maxWidth);labelWidth=Math.max(labelWidth,info.width),labelHeight=Math.max(labelHeight,info.height)}}axis.labelWidth=opts.labelWidth||labelWidth,axis.labelHeight=opts.labelHeight||labelHeight}function allocateAxisBoxFirstPhase(axis){var lw=axis.labelWidth,lh=axis.labelHeight,pos=axis.options.position,isXAxis="x"===axis.direction,tickLength=axis.options.tickLength,axisMargin=options.grid.axisMargin,padding=options.grid.labelMargin,innermost=!0,outermost=!0,first=!0,found=!1;$.each(isXAxis?xaxes:yaxes,function(i,a){a&&(a.show||a.reserveSpace)&&(a===axis?found=!0:a.options.position===pos&&(found?outermost=!1:innermost=!1),found||(first=!1))}),outermost&&(axisMargin=0),null==tickLength&&(tickLength=first?"full":5),isNaN(+tickLength)||(padding+=+tickLength),isXAxis?(lh+=padding,"bottom"==pos?(plotOffset.bottom+=lh+axisMargin,axis.box={top:surface.height-plotOffset.bottom,height:lh}):(axis.box={top:plotOffset.top+axisMargin,height:lh},plotOffset.top+=lh+axisMargin)):(lw+=padding,"left"==pos?(axis.box={left:plotOffset.left+axisMargin,width:lw},plotOffset.left+=lw+axisMargin):(plotOffset.right+=lw+axisMargin,axis.box={left:surface.width-plotOffset.right,width:lw})),axis.position=pos,axis.tickLength=tickLength,axis.box.padding=padding,axis.innermost=innermost}function allocateAxisBoxSecondPhase(axis){"x"==axis.direction?(axis.box.left=plotOffset.left-axis.labelWidth/2,axis.box.width=surface.width-plotOffset.left-plotOffset.right+axis.labelWidth):(axis.box.top=plotOffset.top-axis.labelHeight/2,axis.box.height=surface.height-plotOffset.bottom-plotOffset.top+axis.labelHeight)}function adjustLayoutForThingsStickingOut(){var i,minMargin=options.grid.minBorderMargin;if(null==minMargin)for(minMargin=0,i=0;i<series.length;++i)minMargin=Math.max(minMargin,2*(series[i].points.radius+series[i].points.lineWidth/2));var margins={left:minMargin,right:minMargin,top:minMargin,bottom:minMargin};$.each(allAxes(),function(_,axis){axis.reserveSpace&&axis.ticks&&axis.ticks.length&&("x"===axis.direction?(margins.left=Math.max(margins.left,axis.labelWidth/2),margins.right=Math.max(margins.right,axis.labelWidth/2)):(margins.bottom=Math.max(margins.bottom,axis.labelHeight/2),margins.top=Math.max(margins.top,axis.labelHeight/2)))}),plotOffset.left=Math.ceil(Math.max(margins.left,plotOffset.left)),plotOffset.right=Math.ceil(Math.max(margins.right,plotOffset.right)),plotOffset.top=Math.ceil(Math.max(margins.top,plotOffset.top)),plotOffset.bottom=Math.ceil(Math.max(margins.bottom,plotOffset.bottom))}function setupGrid(){var i,axes=allAxes(),showGrid=options.grid.show;for(var a in plotOffset){var margin=options.grid.margin||0;plotOffset[a]="number"==typeof margin?margin:margin[a]||0}executeHooks(hooks.processOffset,[plotOffset]);for(var a in plotOffset)plotOffset[a]+="object"==typeof options.grid.borderWidth?showGrid?options.grid.borderWidth[a]:0:showGrid?options.grid.borderWidth:0;if($.each(axes,function(_,axis){var axisOpts=axis.options;axis.show=null==axisOpts.show?axis.used:axisOpts.show,axis.reserveSpace=null==axisOpts.reserveSpace?axis.show:axisOpts.reserveSpace,setRange(axis)}),showGrid){var allocatedAxes=$.grep(axes,function(axis){return axis.show||axis.reserveSpace});for($.each(allocatedAxes,function(_,axis){setupTickGeneration(axis),setTicks(axis),snapRangeToTicks(axis,axis.ticks),measureTickLabels(axis)}),i=allocatedAxes.length-1;i>=0;--i)allocateAxisBoxFirstPhase(allocatedAxes[i]);adjustLayoutForThingsStickingOut(),$.each(allocatedAxes,function(_,axis){allocateAxisBoxSecondPhase(axis)})}plotWidth=surface.width-plotOffset.left-plotOffset.right,plotHeight=surface.height-plotOffset.bottom-plotOffset.top,$.each(axes,function(_,axis){setTransformationHelpers(axis)}),showGrid&&drawAxisLabels(),insertLegend()}function setRange(axis){var opts=axis.options,min=+(null!=opts.min?opts.min:axis.datamin),max=+(null!=opts.max?opts.max:axis.datamax),delta=max-min;if(0==delta){var widen=0==max?1:.01;null==opts.min&&(min-=widen),(null==opts.max||null!=opts.min)&&(max+=widen)}else{var margin=opts.autoscaleMargin;null!=margin&&(null==opts.min&&(min-=delta*margin,0>min&&null!=axis.datamin&&axis.datamin>=0&&(min=0)),null==opts.max&&(max+=delta*margin,max>0&&null!=axis.datamax&&axis.datamax<=0&&(max=0)))}axis.min=min,axis.max=max}function setupTickGeneration(axis){var noTicks,opts=axis.options;noTicks="number"==typeof opts.ticks&&opts.ticks>0?opts.ticks:.3*Math.sqrt("x"==axis.direction?surface.width:surface.height);var delta=(axis.max-axis.min)/noTicks,dec=-Math.floor(Math.log(delta)/Math.LN10),maxDec=opts.tickDecimals;null!=maxDec&&dec>maxDec&&(dec=maxDec);var size,magn=Math.pow(10,-dec),norm=delta/magn;if(1.5>norm?size=1:3>norm?(size=2,norm>2.25&&(null==maxDec||maxDec>=dec+1)&&(size=2.5,++dec)):size=7.5>norm?5:10,size*=magn,null!=opts.minTickSize&&size<opts.minTickSize&&(size=opts.minTickSize),axis.delta=delta,axis.tickDecimals=Math.max(0,null!=maxDec?maxDec:dec),axis.tickSize=opts.tickSize||size,"time"==opts.mode&&!axis.tickGenerator)throw new Error("Time mode requires the flot.time plugin.");if(axis.tickGenerator||(axis.tickGenerator=function(axis){var prev,ticks=[],start=floorInBase(axis.min,axis.tickSize),i=0,v=Number.NaN;do prev=v,v=start+i*axis.tickSize,ticks.push(v),++i;while(v<axis.max&&v!=prev);return ticks},axis.tickFormatter=function(value,axis){var factor=axis.tickDecimals?Math.pow(10,axis.tickDecimals):1,formatted=""+Math.round(value*factor)/factor;if(null!=axis.tickDecimals){var decimal=formatted.indexOf("."),precision=-1==decimal?0:formatted.length-decimal-1;if(precision<axis.tickDecimals)return(precision?formatted:formatted+".")+(""+factor).substr(1,axis.tickDecimals-precision)}return formatted}),$.isFunction(opts.tickFormatter)&&(axis.tickFormatter=function(v,axis){return""+opts.tickFormatter(v,axis)}),null!=opts.alignTicksWithAxis){var otherAxis=("x"==axis.direction?xaxes:yaxes)[opts.alignTicksWithAxis-1];if(otherAxis&&otherAxis.used&&otherAxis!=axis){var niceTicks=axis.tickGenerator(axis);if(niceTicks.length>0&&(null==opts.min&&(axis.min=Math.min(axis.min,niceTicks[0])),null==opts.max&&niceTicks.length>1&&(axis.max=Math.max(axis.max,niceTicks[niceTicks.length-1]))),axis.tickGenerator=function(axis){var v,i,ticks=[];for(i=0;i<otherAxis.ticks.length;++i)v=(otherAxis.ticks[i].v-otherAxis.min)/(otherAxis.max-otherAxis.min),v=axis.min+v*(axis.max-axis.min),ticks.push(v);return ticks},!axis.mode&&null==opts.tickDecimals){var extraDec=Math.max(0,-Math.floor(Math.log(axis.delta)/Math.LN10)+1),ts=axis.tickGenerator(axis);ts.length>1&&/\..*0$/.test((ts[1]-ts[0]).toFixed(extraDec))||(axis.tickDecimals=extraDec)}}}}function setTicks(axis){var oticks=axis.options.ticks,ticks=[];null==oticks||"number"==typeof oticks&&oticks>0?ticks=axis.tickGenerator(axis):oticks&&(ticks=$.isFunction(oticks)?oticks(axis):oticks);var i,v;for(axis.ticks=[],i=0;i<ticks.length;++i){var label=null,t=ticks[i];"object"==typeof t?(v=+t[0],t.length>1&&(label=t[1])):v=+t,null==label&&(label=axis.tickFormatter(v,axis)),isNaN(v)||axis.ticks.push({v:v,label:label})}}function snapRangeToTicks(axis,ticks){axis.options.autoscaleMargin&&ticks.length>0&&(null==axis.options.min&&(axis.min=Math.min(axis.min,ticks[0].v)),null==axis.options.max&&ticks.length>1&&(axis.max=Math.max(axis.max,ticks[ticks.length-1].v)))}function draw(){surface.clear(),executeHooks(hooks.drawBackground,[ctx]);var grid=options.grid;grid.show&&grid.backgroundColor&&drawBackground(),grid.show&&!grid.aboveData&&drawGrid();for(var i=0;i<series.length;++i)executeHooks(hooks.drawSeries,[ctx,series[i]]),drawSeries(series[i]);executeHooks(hooks.draw,[ctx]),grid.show&&grid.aboveData&&drawGrid(),surface.render(),triggerRedrawOverlay()}function extractRange(ranges,coord){for(var axis,from,to,key,axes=allAxes(),i=0;i<axes.length;++i)if(axis=axes[i],axis.direction==coord&&(key=coord+axis.n+"axis",ranges[key]||1!=axis.n||(key=coord+"axis"),ranges[key])){from=ranges[key].from,to=ranges[key].to;break}if(ranges[key]||(axis="x"==coord?xaxes[0]:yaxes[0],from=ranges[coord+"1"],to=ranges[coord+"2"]),null!=from&&null!=to&&from>to){var tmp=from;from=to,to=tmp}return{from:from,to:to,axis:axis}}function drawBackground(){ctx.save(),ctx.translate(plotOffset.left,plotOffset.top),ctx.fillStyle=getColorOrGradient(options.grid.backgroundColor,plotHeight,0,"rgba(255, 255, 255, 0)"),ctx.fillRect(0,0,plotWidth,plotHeight),ctx.restore()}function drawGrid(){var i,axes,bw,bc;ctx.save(),ctx.translate(plotOffset.left,plotOffset.top);var markings=options.grid.markings;if(markings)for($.isFunction(markings)&&(axes=plot.getAxes(),axes.xmin=axes.xaxis.min,axes.xmax=axes.xaxis.max,axes.ymin=axes.yaxis.min,axes.ymax=axes.yaxis.max,markings=markings(axes)),i=0;i<markings.length;++i){var m=markings[i],xrange=extractRange(m,"x"),yrange=extractRange(m,"y");if(null==xrange.from&&(xrange.from=xrange.axis.min),null==xrange.to&&(xrange.to=xrange.axis.max),null==yrange.from&&(yrange.from=yrange.axis.min),null==yrange.to&&(yrange.to=yrange.axis.max),!(xrange.to<xrange.axis.min||xrange.from>xrange.axis.max||yrange.to<yrange.axis.min||yrange.from>yrange.axis.max)){xrange.from=Math.max(xrange.from,xrange.axis.min),xrange.to=Math.min(xrange.to,xrange.axis.max),yrange.from=Math.max(yrange.from,yrange.axis.min),yrange.to=Math.min(yrange.to,yrange.axis.max);var xequal=xrange.from===xrange.to,yequal=yrange.from===yrange.to;if(!xequal||!yequal)if(xrange.from=Math.floor(xrange.axis.p2c(xrange.from)),xrange.to=Math.floor(xrange.axis.p2c(xrange.to)),yrange.from=Math.floor(yrange.axis.p2c(yrange.from)),yrange.to=Math.floor(yrange.axis.p2c(yrange.to)),xequal||yequal){var lineWidth=m.lineWidth||options.grid.markingsLineWidth,subPixel=lineWidth%2?.5:0;ctx.beginPath(),ctx.strokeStyle=m.color||options.grid.markingsColor,ctx.lineWidth=lineWidth,xequal?(ctx.moveTo(xrange.to+subPixel,yrange.from),ctx.lineTo(xrange.to+subPixel,yrange.to)):(ctx.moveTo(xrange.from,yrange.to+subPixel),ctx.lineTo(xrange.to,yrange.to+subPixel)),ctx.stroke()}else ctx.fillStyle=m.color||options.grid.markingsColor,ctx.fillRect(xrange.from,yrange.to,xrange.to-xrange.from,yrange.from-yrange.to)}}axes=allAxes(),bw=options.grid.borderWidth;for(var j=0;j<axes.length;++j){var x,y,xoff,yoff,axis=axes[j],box=axis.box,t=axis.tickLength;if(axis.show&&0!=axis.ticks.length){for(ctx.lineWidth=1,"x"==axis.direction?(x=0,y="full"==t?"top"==axis.position?0:plotHeight:box.top-plotOffset.top+("top"==axis.position?box.height:0)):(y=0,x="full"==t?"left"==axis.position?0:plotWidth:box.left-plotOffset.left+("left"==axis.position?box.width:0)),axis.innermost||(ctx.strokeStyle=axis.options.color,ctx.beginPath(),xoff=yoff=0,"x"==axis.direction?xoff=plotWidth+1:yoff=plotHeight+1,1==ctx.lineWidth&&("x"==axis.direction?y=Math.floor(y)+.5:x=Math.floor(x)+.5),ctx.moveTo(x,y),ctx.lineTo(x+xoff,y+yoff),ctx.stroke()),ctx.strokeStyle=axis.options.tickColor,ctx.beginPath(),i=0;i<axis.ticks.length;++i){var v=axis.ticks[i].v;xoff=yoff=0,isNaN(v)||v<axis.min||v>axis.max||"full"==t&&("object"==typeof bw&&bw[axis.position]>0||bw>0)&&(v==axis.min||v==axis.max)||("x"==axis.direction?(x=axis.p2c(v),yoff="full"==t?-plotHeight:t,"top"==axis.position&&(yoff=-yoff)):(y=axis.p2c(v),xoff="full"==t?-plotWidth:t,"left"==axis.position&&(xoff=-xoff)),1==ctx.lineWidth&&("x"==axis.direction?x=Math.floor(x)+.5:y=Math.floor(y)+.5),ctx.moveTo(x,y),ctx.lineTo(x+xoff,y+yoff))}ctx.stroke()}}bw&&(bc=options.grid.borderColor,"object"==typeof bw||"object"==typeof bc?("object"!=typeof bw&&(bw={top:bw,right:bw,bottom:bw,left:bw}),"object"!=typeof bc&&(bc={top:bc,right:bc,bottom:bc,left:bc}),bw.top>0&&(ctx.strokeStyle=bc.top,ctx.lineWidth=bw.top,ctx.beginPath(),ctx.moveTo(0-bw.left,0-bw.top/2),ctx.lineTo(plotWidth,0-bw.top/2),ctx.stroke()),bw.right>0&&(ctx.strokeStyle=bc.right,ctx.lineWidth=bw.right,ctx.beginPath(),ctx.moveTo(plotWidth+bw.right/2,0-bw.top),ctx.lineTo(plotWidth+bw.right/2,plotHeight),ctx.stroke()),bw.bottom>0&&(ctx.strokeStyle=bc.bottom,ctx.lineWidth=bw.bottom,ctx.beginPath(),ctx.moveTo(plotWidth+bw.right,plotHeight+bw.bottom/2),ctx.lineTo(0,plotHeight+bw.bottom/2),ctx.stroke()),bw.left>0&&(ctx.strokeStyle=bc.left,ctx.lineWidth=bw.left,ctx.beginPath(),ctx.moveTo(0-bw.left/2,plotHeight+bw.bottom),ctx.lineTo(0-bw.left/2,0),ctx.stroke())):(ctx.lineWidth=bw,ctx.strokeStyle=options.grid.borderColor,ctx.strokeRect(-bw/2,-bw/2,plotWidth+bw,plotHeight+bw))),ctx.restore()}function drawAxisLabels(){$.each(allAxes(),function(_,axis){var tick,x,y,halign,valign,box=axis.box,legacyStyles=axis.direction+"Axis "+axis.direction+axis.n+"Axis",layer="flot-"+axis.direction+"-axis flot-"+axis.direction+axis.n+"-axis "+legacyStyles,font=axis.options.font||"flot-tick-label tickLabel";if(surface.removeText(layer),axis.show&&0!=axis.ticks.length)for(var i=0;i<axis.ticks.length;++i)tick=axis.ticks[i],!tick.label||tick.v<axis.min||tick.v>axis.max||("x"==axis.direction?(halign="center",x=plotOffset.left+axis.p2c(tick.v),"bottom"==axis.position?y=box.top+box.padding:(y=box.top+box.height-box.padding,valign="bottom")):(valign="middle",y=plotOffset.top+axis.p2c(tick.v),"left"==axis.position?(x=box.left+box.width-box.padding,halign="right"):x=box.left+box.padding),surface.addText(layer,x,y,tick.label,font,null,null,halign,valign))})}function drawSeries(series){series.lines.show&&drawSeriesLines(series),series.bars.show&&drawSeriesBars(series),series.points.show&&drawSeriesPoints(series)}function drawSeriesLines(series){function plotLine(datapoints,xoffset,yoffset,axisx,axisy){var points=datapoints.points,ps=datapoints.pointsize,prevx=null,prevy=null;ctx.beginPath();for(var i=ps;i<points.length;i+=ps){var x1=points[i-ps],y1=points[i-ps+1],x2=points[i],y2=points[i+1];if(null!=x1&&null!=x2){if(y2>=y1&&y1<axisy.min){if(y2<axisy.min)continue;x1=(axisy.min-y1)/(y2-y1)*(x2-x1)+x1,y1=axisy.min}else if(y1>=y2&&y2<axisy.min){if(y1<axisy.min)continue;x2=(axisy.min-y1)/(y2-y1)*(x2-x1)+x1,y2=axisy.min}if(y1>=y2&&y1>axisy.max){if(y2>axisy.max)continue;x1=(axisy.max-y1)/(y2-y1)*(x2-x1)+x1,y1=axisy.max}else if(y2>=y1&&y2>axisy.max){if(y1>axisy.max)continue;x2=(axisy.max-y1)/(y2-y1)*(x2-x1)+x1,y2=axisy.max}if(x2>=x1&&x1<axisx.min){if(x2<axisx.min)continue;y1=(axisx.min-x1)/(x2-x1)*(y2-y1)+y1,x1=axisx.min}else if(x1>=x2&&x2<axisx.min){if(x1<axisx.min)continue;y2=(axisx.min-x1)/(x2-x1)*(y2-y1)+y1,x2=axisx.min}if(x1>=x2&&x1>axisx.max){if(x2>axisx.max)continue;y1=(axisx.max-x1)/(x2-x1)*(y2-y1)+y1,x1=axisx.max}else if(x2>=x1&&x2>axisx.max){if(x1>axisx.max)continue;y2=(axisx.max-x1)/(x2-x1)*(y2-y1)+y1,x2=axisx.max}(x1!=prevx||y1!=prevy)&&ctx.moveTo(axisx.p2c(x1)+xoffset,axisy.p2c(y1)+yoffset),prevx=x2,prevy=y2,ctx.lineTo(axisx.p2c(x2)+xoffset,axisy.p2c(y2)+yoffset)}}ctx.stroke()}function plotLineArea(datapoints,axisx,axisy){for(var points=datapoints.points,ps=datapoints.pointsize,bottom=Math.min(Math.max(0,axisy.min),axisy.max),i=0,areaOpen=!1,ypos=1,segmentStart=0,segmentEnd=0;;){if(ps>0&&i>points.length+ps)break;i+=ps;var x1=points[i-ps],y1=points[i-ps+ypos],x2=points[i],y2=points[i+ypos];if(areaOpen){if(ps>0&&null!=x1&&null==x2){segmentEnd=i,ps=-ps,ypos=2;continue}if(0>ps&&i==segmentStart+ps){ctx.fill(),areaOpen=!1,ps=-ps,ypos=1,i=segmentStart=segmentEnd+ps;continue}}if(null!=x1&&null!=x2){if(x2>=x1&&x1<axisx.min){if(x2<axisx.min)continue;y1=(axisx.min-x1)/(x2-x1)*(y2-y1)+y1,x1=axisx.min
}else if(x1>=x2&&x2<axisx.min){if(x1<axisx.min)continue;y2=(axisx.min-x1)/(x2-x1)*(y2-y1)+y1,x2=axisx.min}if(x1>=x2&&x1>axisx.max){if(x2>axisx.max)continue;y1=(axisx.max-x1)/(x2-x1)*(y2-y1)+y1,x1=axisx.max}else if(x2>=x1&&x2>axisx.max){if(x1>axisx.max)continue;y2=(axisx.max-x1)/(x2-x1)*(y2-y1)+y1,x2=axisx.max}if(areaOpen||(ctx.beginPath(),ctx.moveTo(axisx.p2c(x1),axisy.p2c(bottom)),areaOpen=!0),y1>=axisy.max&&y2>=axisy.max)ctx.lineTo(axisx.p2c(x1),axisy.p2c(axisy.max)),ctx.lineTo(axisx.p2c(x2),axisy.p2c(axisy.max));else if(y1<=axisy.min&&y2<=axisy.min)ctx.lineTo(axisx.p2c(x1),axisy.p2c(axisy.min)),ctx.lineTo(axisx.p2c(x2),axisy.p2c(axisy.min));else{var x1old=x1,x2old=x2;y2>=y1&&y1<axisy.min&&y2>=axisy.min?(x1=(axisy.min-y1)/(y2-y1)*(x2-x1)+x1,y1=axisy.min):y1>=y2&&y2<axisy.min&&y1>=axisy.min&&(x2=(axisy.min-y1)/(y2-y1)*(x2-x1)+x1,y2=axisy.min),y1>=y2&&y1>axisy.max&&y2<=axisy.max?(x1=(axisy.max-y1)/(y2-y1)*(x2-x1)+x1,y1=axisy.max):y2>=y1&&y2>axisy.max&&y1<=axisy.max&&(x2=(axisy.max-y1)/(y2-y1)*(x2-x1)+x1,y2=axisy.max),x1!=x1old&&ctx.lineTo(axisx.p2c(x1old),axisy.p2c(y1)),ctx.lineTo(axisx.p2c(x1),axisy.p2c(y1)),ctx.lineTo(axisx.p2c(x2),axisy.p2c(y2)),x2!=x2old&&(ctx.lineTo(axisx.p2c(x2),axisy.p2c(y2)),ctx.lineTo(axisx.p2c(x2old),axisy.p2c(y2)))}}}}ctx.save(),ctx.translate(plotOffset.left,plotOffset.top),ctx.lineJoin="round";var lw=series.lines.lineWidth,sw=series.shadowSize;if(lw>0&&sw>0){ctx.lineWidth=sw,ctx.strokeStyle="rgba(0,0,0,0.1)";var angle=Math.PI/18;plotLine(series.datapoints,Math.sin(angle)*(lw/2+sw/2),Math.cos(angle)*(lw/2+sw/2),series.xaxis,series.yaxis),ctx.lineWidth=sw/2,plotLine(series.datapoints,Math.sin(angle)*(lw/2+sw/4),Math.cos(angle)*(lw/2+sw/4),series.xaxis,series.yaxis)}ctx.lineWidth=lw,ctx.strokeStyle=series.color;var fillStyle=getFillStyle(series.lines,series.color,0,plotHeight);fillStyle&&(ctx.fillStyle=fillStyle,plotLineArea(series.datapoints,series.xaxis,series.yaxis)),lw>0&&plotLine(series.datapoints,0,0,series.xaxis,series.yaxis),ctx.restore()}function drawSeriesPoints(series){function plotPoints(datapoints,radius,fillStyle,offset,shadow,axisx,axisy,symbol){for(var points=datapoints.points,ps=datapoints.pointsize,i=0;i<points.length;i+=ps){var x=points[i],y=points[i+1];null==x||x<axisx.min||x>axisx.max||y<axisy.min||y>axisy.max||(ctx.beginPath(),x=axisx.p2c(x),y=axisy.p2c(y)+offset,"circle"==symbol?ctx.arc(x,y,radius,0,shadow?Math.PI:2*Math.PI,!1):symbol(ctx,x,y,radius,shadow),ctx.closePath(),fillStyle&&(ctx.fillStyle=fillStyle,ctx.fill()),ctx.stroke())}}ctx.save(),ctx.translate(plotOffset.left,plotOffset.top);var lw=series.points.lineWidth,sw=series.shadowSize,radius=series.points.radius,symbol=series.points.symbol;if(0==lw&&(lw=1e-4),lw>0&&sw>0){var w=sw/2;ctx.lineWidth=w,ctx.strokeStyle="rgba(0,0,0,0.1)",plotPoints(series.datapoints,radius,null,w+w/2,!0,series.xaxis,series.yaxis,symbol),ctx.strokeStyle="rgba(0,0,0,0.2)",plotPoints(series.datapoints,radius,null,w/2,!0,series.xaxis,series.yaxis,symbol)}ctx.lineWidth=lw,ctx.strokeStyle=series.color,plotPoints(series.datapoints,radius,getFillStyle(series.points,series.color),0,!1,series.xaxis,series.yaxis,symbol),ctx.restore()}function drawBar(x,y,b,barLeft,barRight,fillStyleCallback,axisx,axisy,c,horizontal,lineWidth){var left,right,bottom,top,drawLeft,drawRight,drawTop,drawBottom,tmp;horizontal?(drawBottom=drawRight=drawTop=!0,drawLeft=!1,left=b,right=x,top=y+barLeft,bottom=y+barRight,left>right&&(tmp=right,right=left,left=tmp,drawLeft=!0,drawRight=!1)):(drawLeft=drawRight=drawTop=!0,drawBottom=!1,left=x+barLeft,right=x+barRight,bottom=b,top=y,bottom>top&&(tmp=top,top=bottom,bottom=tmp,drawBottom=!0,drawTop=!1)),right<axisx.min||left>axisx.max||top<axisy.min||bottom>axisy.max||(left<axisx.min&&(left=axisx.min,drawLeft=!1),right>axisx.max&&(right=axisx.max,drawRight=!1),bottom<axisy.min&&(bottom=axisy.min,drawBottom=!1),top>axisy.max&&(top=axisy.max,drawTop=!1),left=axisx.p2c(left),bottom=axisy.p2c(bottom),right=axisx.p2c(right),top=axisy.p2c(top),fillStyleCallback&&(c.fillStyle=fillStyleCallback(bottom,top),c.fillRect(left,top,right-left,bottom-top)),lineWidth>0&&(drawLeft||drawRight||drawTop||drawBottom)&&(c.beginPath(),c.moveTo(left,bottom),drawLeft?c.lineTo(left,top):c.moveTo(left,top),drawTop?c.lineTo(right,top):c.moveTo(right,top),drawRight?c.lineTo(right,bottom):c.moveTo(right,bottom),drawBottom?c.lineTo(left,bottom):c.moveTo(left,bottom),c.stroke()))}function drawSeriesBars(series){function plotBars(datapoints,barLeft,barRight,fillStyleCallback,axisx,axisy){for(var points=datapoints.points,ps=datapoints.pointsize,i=0;i<points.length;i+=ps)null!=points[i]&&drawBar(points[i],points[i+1],points[i+2],barLeft,barRight,fillStyleCallback,axisx,axisy,ctx,series.bars.horizontal,series.bars.lineWidth)}ctx.save(),ctx.translate(plotOffset.left,plotOffset.top),ctx.lineWidth=series.bars.lineWidth,ctx.strokeStyle=series.color;var barLeft;switch(series.bars.align){case"left":barLeft=0;break;case"right":barLeft=-series.bars.barWidth;break;default:barLeft=-series.bars.barWidth/2}var fillStyleCallback=series.bars.fill?function(bottom,top){return getFillStyle(series.bars,series.color,bottom,top)}:null;plotBars(series.datapoints,barLeft,barLeft+series.bars.barWidth,fillStyleCallback,series.xaxis,series.yaxis),ctx.restore()}function getFillStyle(filloptions,seriesColor,bottom,top){var fill=filloptions.fill;if(!fill)return null;if(filloptions.fillColor)return getColorOrGradient(filloptions.fillColor,bottom,top,seriesColor);var c=$.color.parse(seriesColor);return c.a="number"==typeof fill?fill:.4,c.normalize(),c.toString()}function insertLegend(){if(null!=options.legend.container?$(options.legend.container).html(""):placeholder.find(".legend").remove(),options.legend.show){for(var s,label,fragments=[],entries=[],rowStarted=!1,lf=options.legend.labelFormatter,i=0;i<series.length;++i)s=series[i],s.label&&(label=lf?lf(s.label,s):s.label,label&&entries.push({label:label,color:s.color}));if(options.legend.sorted)if($.isFunction(options.legend.sorted))entries.sort(options.legend.sorted);else if("reverse"==options.legend.sorted)entries.reverse();else{var ascending="descending"!=options.legend.sorted;entries.sort(function(a,b){return a.label==b.label?0:a.label<b.label!=ascending?1:-1})}for(var i=0;i<entries.length;++i){var entry=entries[i];i%options.legend.noColumns==0&&(rowStarted&&fragments.push("</tr>"),fragments.push("<tr>"),rowStarted=!0),fragments.push('<td class="legendColorBox"><div style="border:1px solid '+options.legend.labelBoxBorderColor+';padding:1px"><div style="width:4px;height:0;border:5px solid '+entry.color+';overflow:hidden"></div></div></td><td class="legendLabel">'+entry.label+"</td>")}if(rowStarted&&fragments.push("</tr>"),0!=fragments.length){var table='<table style="font-size:smaller;color:'+options.grid.color+'">'+fragments.join("")+"</table>";if(null!=options.legend.container)$(options.legend.container).html(table);else{var pos="",p=options.legend.position,m=options.legend.margin;null==m[0]&&(m=[m,m]),"n"==p.charAt(0)?pos+="top:"+(m[1]+plotOffset.top)+"px;":"s"==p.charAt(0)&&(pos+="bottom:"+(m[1]+plotOffset.bottom)+"px;"),"e"==p.charAt(1)?pos+="right:"+(m[0]+plotOffset.right)+"px;":"w"==p.charAt(1)&&(pos+="left:"+(m[0]+plotOffset.left)+"px;");var legend=$('<div class="legend">'+table.replace('style="','style="position:absolute;'+pos+";")+"</div>").appendTo(placeholder);if(0!=options.legend.backgroundOpacity){var c=options.legend.backgroundColor;null==c&&(c=options.grid.backgroundColor,c=c&&"string"==typeof c?$.color.parse(c):$.color.extract(legend,"background-color"),c.a=1,c=c.toString());var div=legend.children();$('<div style="position:absolute;width:'+div.width()+"px;height:"+div.height()+"px;"+pos+"background-color:"+c+';"> </div>').prependTo(legend).css("opacity",options.legend.backgroundOpacity)}}}}}function findNearbyItem(mouseX,mouseY,seriesFilter){var i,j,ps,maxDistance=options.grid.mouseActiveRadius,smallestDistance=maxDistance*maxDistance+1,item=null;for(i=series.length-1;i>=0;--i)if(seriesFilter(series[i])){var s=series[i],axisx=s.xaxis,axisy=s.yaxis,points=s.datapoints.points,mx=axisx.c2p(mouseX),my=axisy.c2p(mouseY),maxx=maxDistance/axisx.scale,maxy=maxDistance/axisy.scale;if(ps=s.datapoints.pointsize,axisx.options.inverseTransform&&(maxx=Number.MAX_VALUE),axisy.options.inverseTransform&&(maxy=Number.MAX_VALUE),s.lines.show||s.points.show)for(j=0;j<points.length;j+=ps){var x=points[j],y=points[j+1];if(null!=x&&!(x-mx>maxx||-maxx>x-mx||y-my>maxy||-maxy>y-my)){var dx=Math.abs(axisx.p2c(x)-mouseX),dy=Math.abs(axisy.p2c(y)-mouseY),dist=dx*dx+dy*dy;smallestDistance>dist&&(smallestDistance=dist,item=[i,j/ps])}}if(s.bars.show&&!item){var barLeft,barRight;switch(s.bars.align){case"left":barLeft=0;break;case"right":barLeft=-s.bars.barWidth;break;default:barLeft=-s.bars.barWidth/2}for(barRight=barLeft+s.bars.barWidth,j=0;j<points.length;j+=ps){var x=points[j],y=points[j+1],b=points[j+2];null!=x&&(series[i].bars.horizontal?mx<=Math.max(b,x)&&mx>=Math.min(b,x)&&my>=y+barLeft&&y+barRight>=my:mx>=x+barLeft&&x+barRight>=mx&&my>=Math.min(b,y)&&my<=Math.max(b,y))&&(item=[i,j/ps])}}}return item?(i=item[0],j=item[1],ps=series[i].datapoints.pointsize,{datapoint:series[i].datapoints.points.slice(j*ps,(j+1)*ps),dataIndex:j,series:series[i],seriesIndex:i}):null}function onMouseMove(e){options.grid.hoverable&&triggerClickHoverEvent("plothover",e,function(s){return 0!=s.hoverable})}function onMouseLeave(e){options.grid.hoverable&&triggerClickHoverEvent("plothover",e,function(){return!1})}function onClick(e){triggerClickHoverEvent("plotclick",e,function(s){return 0!=s.clickable})}function triggerClickHoverEvent(eventname,event,seriesFilter){var offset=eventHolder.offset(),canvasX=event.pageX-offset.left-plotOffset.left,canvasY=event.pageY-offset.top-plotOffset.top,pos=canvasToAxisCoords({left:canvasX,top:canvasY});pos.pageX=event.pageX,pos.pageY=event.pageY;var item=findNearbyItem(canvasX,canvasY,seriesFilter);if(item&&(item.pageX=parseInt(item.series.xaxis.p2c(item.datapoint[0])+offset.left+plotOffset.left,10),item.pageY=parseInt(item.series.yaxis.p2c(item.datapoint[1])+offset.top+plotOffset.top,10)),options.grid.autoHighlight){for(var i=0;i<highlights.length;++i){var h=highlights[i];h.auto!=eventname||item&&h.series==item.series&&h.point[0]==item.datapoint[0]&&h.point[1]==item.datapoint[1]||unhighlight(h.series,h.point)}item&&highlight(item.series,item.datapoint,eventname)}placeholder.trigger(eventname,[pos,item])}function triggerRedrawOverlay(){var t=options.interaction.redrawOverlayInterval;return-1==t?void drawOverlay():void(redrawTimeout||(redrawTimeout=setTimeout(drawOverlay,t)))}function drawOverlay(){redrawTimeout=null,octx.save(),overlay.clear(),octx.translate(plotOffset.left,plotOffset.top);var i,hi;for(i=0;i<highlights.length;++i)hi=highlights[i],hi.series.bars.show?drawBarHighlight(hi.series,hi.point):drawPointHighlight(hi.series,hi.point);octx.restore(),executeHooks(hooks.drawOverlay,[octx])}function highlight(s,point,auto){if("number"==typeof s&&(s=series[s]),"number"==typeof point){var ps=s.datapoints.pointsize;point=s.datapoints.points.slice(ps*point,ps*(point+1))}var i=indexOfHighlight(s,point);-1==i?(highlights.push({series:s,point:point,auto:auto}),triggerRedrawOverlay()):auto||(highlights[i].auto=!1)}function unhighlight(s,point){if(null==s&&null==point)return highlights=[],void triggerRedrawOverlay();if("number"==typeof s&&(s=series[s]),"number"==typeof point){var ps=s.datapoints.pointsize;point=s.datapoints.points.slice(ps*point,ps*(point+1))}var i=indexOfHighlight(s,point);-1!=i&&(highlights.splice(i,1),triggerRedrawOverlay())}function indexOfHighlight(s,p){for(var i=0;i<highlights.length;++i){var h=highlights[i];if(h.series==s&&h.point[0]==p[0]&&h.point[1]==p[1])return i}return-1}function drawPointHighlight(series,point){var x=point[0],y=point[1],axisx=series.xaxis,axisy=series.yaxis,highlightColor="string"==typeof series.highlightColor?series.highlightColor:$.color.parse(series.color).scale("a",.5).toString();if(!(x<axisx.min||x>axisx.max||y<axisy.min||y>axisy.max)){var pointRadius=series.points.radius+series.points.lineWidth/2;octx.lineWidth=pointRadius,octx.strokeStyle=highlightColor;var radius=1.5*pointRadius;x=axisx.p2c(x),y=axisy.p2c(y),octx.beginPath(),"circle"==series.points.symbol?octx.arc(x,y,radius,0,2*Math.PI,!1):series.points.symbol(octx,x,y,radius,!1),octx.closePath(),octx.stroke()}}function drawBarHighlight(series,point){var barLeft,highlightColor="string"==typeof series.highlightColor?series.highlightColor:$.color.parse(series.color).scale("a",.5).toString(),fillStyle=highlightColor;switch(series.bars.align){case"left":barLeft=0;break;case"right":barLeft=-series.bars.barWidth;break;default:barLeft=-series.bars.barWidth/2}octx.lineWidth=series.bars.lineWidth,octx.strokeStyle=highlightColor,drawBar(point[0],point[1],point[2]||0,barLeft,barLeft+series.bars.barWidth,function(){return fillStyle},series.xaxis,series.yaxis,octx,series.bars.horizontal,series.bars.lineWidth)}function getColorOrGradient(spec,bottom,top,defaultColor){if("string"==typeof spec)return spec;for(var gradient=ctx.createLinearGradient(0,top,0,bottom),i=0,l=spec.colors.length;l>i;++i){var c=spec.colors[i];if("string"!=typeof c){var co=$.color.parse(defaultColor);null!=c.brightness&&(co=co.scale("rgb",c.brightness)),null!=c.opacity&&(co.a*=c.opacity),c=co.toString()}gradient.addColorStop(i/(l-1),c)}return gradient}var series=[],options={colors:["#edc240","#afd8f8","#cb4b4b","#4da74d","#9440ed"],legend:{show:!0,noColumns:1,labelFormatter:null,labelBoxBorderColor:"#ccc",container:null,position:"ne",margin:5,backgroundColor:null,backgroundOpacity:.85,sorted:null},xaxis:{show:null,position:"bottom",mode:null,font:null,color:null,tickColor:null,transform:null,inverseTransform:null,min:null,max:null,autoscaleMargin:null,ticks:null,tickFormatter:null,labelWidth:null,labelHeight:null,reserveSpace:null,tickLength:null,alignTicksWithAxis:null,tickDecimals:null,tickSize:null,minTickSize:null},yaxis:{autoscaleMargin:.02,position:"left"},xaxes:[],yaxes:[],series:{points:{show:!1,radius:3,lineWidth:2,fill:!0,fillColor:"#ffffff",symbol:"circle"},lines:{lineWidth:2,fill:!1,fillColor:null,steps:!1},bars:{show:!1,lineWidth:2,barWidth:1,fill:!0,fillColor:null,align:"left",horizontal:!1,zero:!0},shadowSize:3,highlightColor:null},grid:{show:!0,aboveData:!1,color:"#545454",backgroundColor:null,borderColor:null,tickColor:null,margin:0,labelMargin:5,axisMargin:8,borderWidth:2,minBorderMargin:null,markings:null,markingsColor:"#f4f4f4",markingsLineWidth:2,clickable:!1,hoverable:!1,autoHighlight:!0,mouseActiveRadius:10},interaction:{redrawOverlayInterval:1e3/60},hooks:{}},surface=null,overlay=null,eventHolder=null,ctx=null,octx=null,xaxes=[],yaxes=[],plotOffset={left:0,right:0,top:0,bottom:0},plotWidth=0,plotHeight=0,hooks={processOptions:[],processRawData:[],processDatapoints:[],processOffset:[],drawBackground:[],drawSeries:[],draw:[],bindEvents:[],drawOverlay:[],shutdown:[]},plot=this;plot.setData=setData,plot.setupGrid=setupGrid,plot.draw=draw,plot.getPlaceholder=function(){return placeholder},plot.getCanvas=function(){return surface.element},plot.getPlotOffset=function(){return plotOffset},plot.width=function(){return plotWidth},plot.height=function(){return plotHeight},plot.offset=function(){var o=eventHolder.offset();return o.left+=plotOffset.left,o.top+=plotOffset.top,o},plot.getData=function(){return series},plot.getAxes=function(){var res={};return $.each(xaxes.concat(yaxes),function(_,axis){axis&&(res[axis.direction+(1!=axis.n?axis.n:"")+"axis"]=axis)}),res},plot.getXAxes=function(){return xaxes},plot.getYAxes=function(){return yaxes},plot.c2p=canvasToAxisCoords,plot.p2c=axisToCanvasCoords,plot.getOptions=function(){return options},plot.highlight=highlight,plot.unhighlight=unhighlight,plot.triggerRedrawOverlay=triggerRedrawOverlay,plot.pointOffset=function(point){return{left:parseInt(xaxes[axisNumber(point,"x")-1].p2c(+point.x)+plotOffset.left,10),top:parseInt(yaxes[axisNumber(point,"y")-1].p2c(+point.y)+plotOffset.top,10)}},plot.shutdown=shutdown,plot.destroy=function(){shutdown(),placeholder.removeData("plot").empty(),series=[],options=null,surface=null,overlay=null,eventHolder=null,ctx=null,octx=null,xaxes=[],yaxes=[],hooks=null,highlights=[],plot=null},plot.resize=function(){var width=placeholder.width(),height=placeholder.height();surface.resize(width,height),overlay.resize(width,height)},plot.hooks=hooks,initPlugins(plot),parseOptions(options_),setupCanvases(),setData(data_),setupGrid(),draw(),bindEvents();var highlights=[],redrawTimeout=null}function floorInBase(n,base){return base*Math.floor(n/base)}var hasOwnProperty=Object.prototype.hasOwnProperty;$.fn.detach||($.fn.detach=function(){return this.each(function(){this.parentNode&&this.parentNode.removeChild(this)})}),Canvas.prototype.resize=function(width,height){if(0>=width||0>=height)throw new Error("Invalid dimensions for plot, width = "+width+", height = "+height);var element=this.element,context=this.context,pixelRatio=this.pixelRatio;this.width!=width&&(element.width=width*pixelRatio,element.style.width=width+"px",this.width=width),this.height!=height&&(element.height=height*pixelRatio,element.style.height=height+"px",this.height=height),context.restore(),context.save(),context.scale(pixelRatio,pixelRatio)},Canvas.prototype.clear=function(){this.context.clearRect(0,0,this.width,this.height)},Canvas.prototype.render=function(){var cache=this._textCache;for(var layerKey in cache)if(hasOwnProperty.call(cache,layerKey)){var layer=this.getTextLayer(layerKey),layerCache=cache[layerKey];layer.hide();for(var styleKey in layerCache)if(hasOwnProperty.call(layerCache,styleKey)){var styleCache=layerCache[styleKey];for(var key in styleCache)if(hasOwnProperty.call(styleCache,key)){for(var position,positions=styleCache[key].positions,i=0;position=positions[i];i++)position.active?position.rendered||(layer.append(position.element),position.rendered=!0):(positions.splice(i--,1),position.rendered&&position.element.detach());0==positions.length&&delete styleCache[key]}}layer.show()}},Canvas.prototype.getTextLayer=function(classes){var layer=this.text[classes];return null==layer&&(null==this.textContainer&&(this.textContainer=$("<div class='flot-text'></div>").css({position:"absolute",top:0,left:0,bottom:0,right:0,"font-size":"smaller",color:"#545454"}).insertAfter(this.element)),layer=this.text[classes]=$("<div></div>").addClass(classes).css({position:"absolute",top:0,left:0,bottom:0,right:0}).appendTo(this.textContainer)),layer},Canvas.prototype.getTextInfo=function(layer,text,font,angle,width){var textStyle,layerCache,styleCache,info;if(text=""+text,textStyle="object"==typeof font?font.style+" "+font.variant+" "+font.weight+" "+font.size+"px/"+font.lineHeight+"px "+font.family:font,layerCache=this._textCache[layer],null==layerCache&&(layerCache=this._textCache[layer]={}),styleCache=layerCache[textStyle],null==styleCache&&(styleCache=layerCache[textStyle]={}),info=styleCache[text],null==info){var element=$("<div></div>").html(text).css({position:"absolute","max-width":width,top:-9999}).appendTo(this.getTextLayer(layer));"object"==typeof font?element.css({font:textStyle,color:font.color}):"string"==typeof font&&element.addClass(font),info=styleCache[text]={width:element.outerWidth(!0),height:element.outerHeight(!0),element:element,positions:[]},element.detach()}return info},Canvas.prototype.addText=function(layer,x,y,text,font,angle,width,halign,valign){var info=this.getTextInfo(layer,text,font,angle,width),positions=info.positions;"center"==halign?x-=info.width/2:"right"==halign&&(x-=info.width),"middle"==valign?y-=info.height/2:"bottom"==valign&&(y-=info.height);for(var position,i=0;position=positions[i];i++)if(position.x==x&&position.y==y)return void(position.active=!0);position={active:!0,rendered:!1,element:positions.length?info.element.clone():info.element,x:x,y:y},positions.push(position),position.element.css({top:Math.round(y),left:Math.round(x),"text-align":halign})},Canvas.prototype.removeText=function(layer,x,y,text,font,angle){if(null==text){var layerCache=this._textCache[layer];if(null!=layerCache)for(var styleKey in layerCache)if(hasOwnProperty.call(layerCache,styleKey)){var styleCache=layerCache[styleKey];for(var key in styleCache)if(hasOwnProperty.call(styleCache,key))for(var position,positions=styleCache[key].positions,i=0;position=positions[i];i++)position.active=!1}}else for(var position,positions=this.getTextInfo(layer,text,font,angle).positions,i=0;position=positions[i];i++)position.x==x&&position.y==y&&(position.active=!1)},$.plot=function(placeholder,data,options){var plot=new Plot($(placeholder),data,options,$.plot.plugins);return plot},$.plot.version="0.8.3",$.plot.plugins=[],$.fn.plot=function(data,options){return this.each(function(){$.plot(this,data,options)})}}(jQuery),function($){function floorInBase(n,base){return base*Math.floor(n/base)}function formatDate(d,fmt,monthNames,dayNames){if("function"==typeof d.strftime)return d.strftime(fmt);var leftPad=function(n,pad){return n=""+n,pad=""+(null==pad?"0":pad),1==n.length?pad+n:n},r=[],escape=!1,hours=d.getHours(),isAM=12>hours;null==monthNames&&(monthNames=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]),null==dayNames&&(dayNames=["Sun","Mon","Tue","Wed","Thu","Fri","Sat"]);var hours12;hours12=hours>12?hours-12:0==hours?12:hours;for(var i=0;i<fmt.length;++i){var c=fmt.charAt(i);if(escape){switch(c){case"a":c=""+dayNames[d.getDay()];break;case"b":c=""+monthNames[d.getMonth()];break;case"d":c=leftPad(d.getDate());break;case"e":c=leftPad(d.getDate()," ");break;case"h":case"H":c=leftPad(hours);break;case"I":c=leftPad(hours12);break;case"l":c=leftPad(hours12," ");break;case"m":c=leftPad(d.getMonth()+1);break;case"M":c=leftPad(d.getMinutes());break;case"q":c=""+(Math.floor(d.getMonth()/3)+1);break;case"S":c=leftPad(d.getSeconds());break;case"y":c=leftPad(d.getFullYear()%100);break;case"Y":c=""+d.getFullYear();break;case"p":c=isAM?"am":"pm";break;case"P":c=isAM?"AM":"PM";break;case"w":c=""+d.getDay()}r.push(c),escape=!1}else"%"==c?escape=!0:r.push(c)}return r.join("")}function makeUtcWrapper(d){function addProxyMethod(sourceObj,sourceMethod,targetObj,targetMethod){sourceObj[sourceMethod]=function(){return targetObj[targetMethod].apply(targetObj,arguments)}}var utc={date:d};void 0!=d.strftime&&addProxyMethod(utc,"strftime",d,"strftime"),addProxyMethod(utc,"getTime",d,"getTime"),addProxyMethod(utc,"setTime",d,"setTime");for(var props=["Date","Day","FullYear","Hours","Milliseconds","Minutes","Month","Seconds"],p=0;p<props.length;p++)addProxyMethod(utc,"get"+props[p],d,"getUTC"+props[p]),addProxyMethod(utc,"set"+props[p],d,"setUTC"+props[p]);return utc}function dateGenerator(ts,opts){if("browser"==opts.timezone)return new Date(ts);if(opts.timezone&&"utc"!=opts.timezone){if("undefined"!=typeof timezoneJS&&"undefined"!=typeof timezoneJS.Date){var d=new timezoneJS.Date;return d.setTimezone(opts.timezone),d.setTime(ts),d}return makeUtcWrapper(new Date(ts))}return makeUtcWrapper(new Date(ts))}function init(plot){plot.hooks.processOptions.push(function(plot){$.each(plot.getAxes(),function(axisName,axis){var opts=axis.options;"time"==opts.mode&&(axis.tickGenerator=function(axis){var ticks=[],d=dateGenerator(axis.min,opts),minSize=0,spec=opts.tickSize&&"quarter"===opts.tickSize[1]||opts.minTickSize&&"quarter"===opts.minTickSize[1]?specQuarters:specMonths;null!=opts.minTickSize&&(minSize="number"==typeof opts.tickSize?opts.tickSize:opts.minTickSize[0]*timeUnitSize[opts.minTickSize[1]]);for(var i=0;i<spec.length-1&&!(axis.delta<(spec[i][0]*timeUnitSize[spec[i][1]]+spec[i+1][0]*timeUnitSize[spec[i+1][1]])/2&&spec[i][0]*timeUnitSize[spec[i][1]]>=minSize);++i);var size=spec[i][0],unit=spec[i][1];if("year"==unit){if(null!=opts.minTickSize&&"year"==opts.minTickSize[1])size=Math.floor(opts.minTickSize[0]);else{var magn=Math.pow(10,Math.floor(Math.log(axis.delta/timeUnitSize.year)/Math.LN10)),norm=axis.delta/timeUnitSize.year/magn;size=1.5>norm?1:3>norm?2:7.5>norm?5:10,size*=magn}1>size&&(size=1)}axis.tickSize=opts.tickSize||[size,unit];var tickSize=axis.tickSize[0];unit=axis.tickSize[1];var step=tickSize*timeUnitSize[unit];"second"==unit?d.setSeconds(floorInBase(d.getSeconds(),tickSize)):"minute"==unit?d.setMinutes(floorInBase(d.getMinutes(),tickSize)):"hour"==unit?d.setHours(floorInBase(d.getHours(),tickSize)):"month"==unit?d.setMonth(floorInBase(d.getMonth(),tickSize)):"quarter"==unit?d.setMonth(3*floorInBase(d.getMonth()/3,tickSize)):"year"==unit&&d.setFullYear(floorInBase(d.getFullYear(),tickSize)),d.setMilliseconds(0),step>=timeUnitSize.minute&&d.setSeconds(0),step>=timeUnitSize.hour&&d.setMinutes(0),step>=timeUnitSize.day&&d.setHours(0),step>=4*timeUnitSize.day&&d.setDate(1),step>=2*timeUnitSize.month&&d.setMonth(floorInBase(d.getMonth(),3)),step>=2*timeUnitSize.quarter&&d.setMonth(floorInBase(d.getMonth(),6)),step>=timeUnitSize.year&&d.setMonth(0);var prev,carry=0,v=Number.NaN;do if(prev=v,v=d.getTime(),ticks.push(v),"month"==unit||"quarter"==unit)if(1>tickSize){d.setDate(1);var start=d.getTime();d.setMonth(d.getMonth()+("quarter"==unit?3:1));var end=d.getTime();d.setTime(v+carry*timeUnitSize.hour+(end-start)*tickSize),carry=d.getHours(),d.setHours(0)}else d.setMonth(d.getMonth()+tickSize*("quarter"==unit?3:1));else"year"==unit?d.setFullYear(d.getFullYear()+tickSize):d.setTime(v+step);while(v<axis.max&&v!=prev);return ticks},axis.tickFormatter=function(v,axis){var d=dateGenerator(v,axis.options);if(null!=opts.timeformat)return formatDate(d,opts.timeformat,opts.monthNames,opts.dayNames);var fmt,useQuarters=axis.options.tickSize&&"quarter"==axis.options.tickSize[1]||axis.options.minTickSize&&"quarter"==axis.options.minTickSize[1],t=axis.tickSize[0]*timeUnitSize[axis.tickSize[1]],span=axis.max-axis.min,suffix=opts.twelveHourClock?" %p":"",hourCode=opts.twelveHourClock?"%I":"%H";fmt=t<timeUnitSize.minute?hourCode+":%M:%S"+suffix:t<timeUnitSize.day?span<2*timeUnitSize.day?hourCode+":%M"+suffix:"%b %d "+hourCode+":%M"+suffix:t<timeUnitSize.month?"%b %d":useQuarters&&t<timeUnitSize.quarter||!useQuarters&&t<timeUnitSize.year?span<timeUnitSize.year?"%b":"%b %Y":useQuarters&&t<timeUnitSize.year?span<timeUnitSize.year?"Q%q":"Q%q %Y":"%Y";var rt=formatDate(d,fmt,opts.monthNames,opts.dayNames);return rt})})})}var options={xaxis:{timezone:null,timeformat:null,twelveHourClock:!1,monthNames:null}},timeUnitSize={second:1e3,minute:6e4,hour:36e5,day:864e5,month:2592e6,quarter:7776e6,year:525949.2*60*1e3},baseSpec=[[1,"second"],[2,"second"],[5,"second"],[10,"second"],[30,"second"],[1,"minute"],[2,"minute"],[5,"minute"],[10,"minute"],[30,"minute"],[1,"hour"],[2,"hour"],[4,"hour"],[8,"hour"],[12,"hour"],[1,"day"],[2,"day"],[3,"day"],[.25,"month"],[.5,"month"],[1,"month"],[2,"month"]],specMonths=baseSpec.concat([[3,"month"],[6,"month"],[1,"year"]]),specQuarters=baseSpec.concat([[1,"quarter"],[2,"quarter"],[1,"year"]]);$.plot.plugins.push({init:init,options:options,name:"time",version:"1.0"}),$.plot.formatDate=formatDate,$.plot.dateGenerator=dateGenerator}(jQuery),$(document).ready(function(){make_graph("/stats_cell.json","#cell_chart"),make_graph("/stats_wifi.json","#wifi_chart")});