import os
import sys


def isKde():
    """ isKde()
    Return whether this is the KDE window manager.
    """
    if sys.platform.startswith('linux'):
        if os.environ.get('KDE_FULL_SESSION'):
            return True
    return False


def isFrozen():
    """ isFrozen()
    Return whether the current IEP application is frozen.
    """
    return bool( hasattr(sys, 'frozen') )


def usesLinuxSystemQt():
    """ usesLinuxSystemQt()
    Return whether the Linux system PySide/PyQt libraries are used.
    """
    from iep.codeeditor.qt import QtCore, QtGui
    return QtCore.__file__.startswith('/usr/')

