# Copyright

r"""Test the igor module by loading sample files.

>>> dumpibw('mac-double.ibw')  # doctest: +REPORT_UDIFF
{'version': 2,
 'wave': {'bin_header': {'checksum': 25137,
                         'noteSize': 0,
                         'pictSize': 0,
                         'wfmSize': 166},
          'note': '',
          'padding': array([], dtype=float64),
          'wData': array([ 5.,  4.,  3.,  2.,  1.]),
          'wave_header': {'aModified': 0,
                          'bname': 'double',
                          'botFullScale': 0.0,
                          'creationDate': 3001587842,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 0,
                          'fileName': 0,
                          'formula': 0,
                          'fsValid': 0,
                          'hsA': 1.0,
                          'hsB': 0.0,
                          'kindBits': '\x00',
                          'modDate': 3001587842,
                          'next': 0,
                          'npnts': 5,
                          'srcFldr': 0,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 4,
                          'useBits': '\x00',
                          'wModified': 0,
                          'wUnused': array(['', ''],
      dtype='|S1'),
                          'waveNoteH': 0,
                          'whVersion': 0,
                          'xUnits': array(['', '', '', ''],
      dtype='|S1')}}}

>>> dumpibw('mac-textWave.ibw')  # doctest: +REPORT_UDIFF
{'version': 5,
 'wave': {'bin_header': {'checksum': 5554,
                         'dataEUnitsSize': 0,
                         'dimEUnitsSize': array([0, 0, 0, 0]),
                         'dimLabelsSize': array([0, 0, 0, 0]),
                         'formulaSize': 0,
                         'noteSize': 0,
                         'optionsSize1': 0,
                         'optionsSize2': 0,
                         'sIndicesSize': 20,
                         'wfmSize': 338},
          'data_units': '',
          'dimension_units': '',
          'formula': '',
          'labels': [[], [], [], []],
          'note': '',
          'sIndices': array([ 4,  7,  8, 14, 18]),
          'wData': array(['Mary', 'had', 'a', 'little', 'lamb'],
      dtype='|S6'),
          'wave_header': {'aModified': 0,
                          'bname': 'text0',
                          'botFullScale': 0.0,
                          'creationDate': 3001571199,
                          'dFolder': 69554896,
                          'dLock': 0,
                          'dataEUnits': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 22,
                          'dimEUnits': array([0, 0, 0, 0]),
                          'dimLabels': array([0, 0, 0, 0]),
                          'dimUnits': array([['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', '']],
      dtype='|S1'),
                          'fileName': 0,
                          'formula': 0,
                          'fsValid': 0,
                          'kindBits': '\x00',
                          'modDate': 3001571215,
                          'nDim': array([5, 0, 0, 0]),
                          'next': 0,
                          'npnts': 5,
                          'sIndices': 69557296,
                          'sfA': array([ 1.,  1.,  1.,  1.]),
                          'sfB': array([ 0.,  0.,  0.,  0.]),
                          'srcFldr': 0,
                          'swModified': 1,
                          'topFullScale': 0.0,
                          'type': 0,
                          'useBits': '\x00',
                          'wModified': 0,
                          'waveNoteH': 0,
                          'whUnused': array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
                          'whVersion': 1,
                          'whpad1': array(['', '', '', '', '', ''],
      dtype='|S1'),
                          'whpad2': 0,
                          'whpad3': 0,
                          'whpad4': 0}}}

>>> dumpibw('mac-version2.ibw')  # doctest: +REPORT_UDIFF
{'version': 2,
 'wave': {'bin_header': {'checksum': -16803,
                         'noteSize': 15,
                         'pictSize': 0,
                         'wfmSize': 146},
          'note': 'This is a test.',
          'padding': array([], dtype=float64),
          'wData': array([ 5.,  4.,  3.,  2.,  1.], dtype=float32),
          'wave_header': {'aModified': 0,
                          'bname': 'version2',
                          'botFullScale': 0.0,
                          'creationDate': 3001251979,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 0,
                          'fileName': 0,
                          'formula': 0,
                          'fsValid': 0,
                          'hsA': 1.0,
                          'hsB': 0.0,
                          'kindBits': '\x00',
                          'modDate': 3001573594,
                          'next': 0,
                          'npnts': 5,
                          'srcFldr': 0,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 0,
                          'wUnused': array(['', ''],
      dtype='|S1'),
                          'waveNoteH': 0,
                          'whVersion': 0,
                          'xUnits': array(['', '', '', ''],
      dtype='|S1')}}}

>>> dumpibw('mac-version3Dependent.ibw')  # doctest: +REPORT_UDIFF
{'version': 3,
 'wave': {'bin_header': {'checksum': -32334,
                         'formulaSize': 4,
                         'noteSize': 0,
                         'pictSize': 0,
                         'wfmSize': 126},
          'formula': ' K0',
          'note': '',
          'padding': array([], dtype=float64),
          'wData': array([], dtype=float32),
          'wave_header': {'aModified': 3,
                          'bname': 'version3Dependent',
                          'botFullScale': 0.0,
                          'creationDate': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 23,
                          'fileName': 0,
                          'formula': 103408364,
                          'fsValid': 0,
                          'hsA': 1.0,
                          'hsB': 0.0,
                          'kindBits': '\x00',
                          'modDate': 3001672861,
                          'next': 0,
                          'npnts': 10,
                          'srcFldr': 0,
                          'swModified': 1,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 1,
                          'wUnused': array(['', ''],
      dtype='|S1'),
                          'waveNoteH': 0,
                          'whVersion': 0,
                          'xUnits': array(['', '', '', ''],
      dtype='|S1')}}}

>>> dumpibw('mac-version5.ibw')  # doctest: +REPORT_UDIFF
{'version': 5,
 'wave': {'bin_header': {'checksum': -12033,
                         'dataEUnitsSize': 0,
                         'dimEUnitsSize': array([0, 0, 0, 0]),
                         'dimLabelsSize': array([64,  0,  0,  0]),
                         'formulaSize': 0,
                         'noteSize': 15,
                         'optionsSize1': 0,
                         'optionsSize2': 0,
                         'sIndicesSize': 0,
                         'wfmSize': 340},
          'data_units': '',
          'dimension_units': '',
          'formula': '',
          'labels': [['Column0'], [], [], []],
          'note': 'This is a test.',
          'sIndices': array([], dtype=float64),
          'wData': array([ 5.,  4.,  3.,  2.,  1.], dtype=float32),
          'wave_header': {'aModified': 0,
                          'bname': 'version5',
                          'botFullScale': 0.0,
                          'creationDate': 3001252180,
                          'dFolder': 69554896,
                          'dLock': 0,
                          'dataEUnits': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 27,
                          'dimEUnits': array([0, 0, 0, 0]),
                          'dimLabels': array([69554136,        0,        0,        0]),
                          'dimUnits': array([['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', '']],
      dtype='|S1'),
                          'fileName': 69554292,
                          'formula': 0,
                          'fsValid': 0,
                          'kindBits': '\x00',
                          'modDate': 3001573601,
                          'nDim': array([5, 0, 0, 0]),
                          'next': 69555212,
                          'npnts': 5,
                          'sIndices': 0,
                          'sfA': array([ 1.,  1.,  1.,  1.]),
                          'sfB': array([ 0.,  0.,  0.,  0.]),
                          'srcFldr': -32349,
                          'swModified': 1,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 0,
                          'waveNoteH': 69554032,
                          'whUnused': array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
                          'whVersion': 1,
                          'whpad1': array(['', '', '', '', '', ''],
      dtype='|S1'),
                          'whpad2': 0,
                          'whpad3': 0,
                          'whpad4': 0}}}

>>> dumpibw('mac-zeroPointWave.ibw')  # doctest: +REPORT_UDIFF
{'version': 5,
 'wave': {'bin_header': {'checksum': -15649,
                         'dataEUnitsSize': 0,
                         'dimEUnitsSize': array([0, 0, 0, 0]),
                         'dimLabelsSize': array([0, 0, 0, 0]),
                         'formulaSize': 0,
                         'noteSize': 0,
                         'optionsSize1': 0,
                         'optionsSize2': 0,
                         'sIndicesSize': 0,
                         'wfmSize': 320},
          'data_units': '',
          'dimension_units': '',
          'formula': '',
          'labels': [[], [], [], []],
          'note': '',
          'sIndices': array([], dtype=float64),
          'wData': array([], dtype=float32),
          'wave_header': {'aModified': 3,
                          'bname': 'zeroWave',
                          'botFullScale': 0.0,
                          'creationDate': 3001573964,
                          'dFolder': 69554896,
                          'dLock': 0,
                          'dataEUnits': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 29,
                          'dimEUnits': array([0, 0, 0, 0]),
                          'dimLabels': array([0, 0, 0, 0]),
                          'dimUnits': array([['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', '']],
      dtype='|S1'),
                          'fileName': 0,
                          'formula': 0,
                          'fsValid': 0,
                          'kindBits': '\x00',
                          'modDate': 3001573964,
                          'nDim': array([0, 0, 0, 0]),
                          'next': 0,
                          'npnts': 0,
                          'sIndices': 0,
                          'sfA': array([ 1.,  1.,  1.,  1.]),
                          'sfB': array([ 0.,  0.,  0.,  0.]),
                          'srcFldr': 0,
                          'swModified': 1,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 1,
                          'waveNoteH': 0,
                          'whUnused': array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
                          'whVersion': 1,
                          'whpad1': array(['', '', '', '', '', ''],
      dtype='|S1'),
                          'whpad2': 0,
                          'whpad3': 0,
                          'whpad4': 0}}}

>>> dumpibw('win-double.ibw')  # doctest: +REPORT_UDIFF
{'version': 2,
 'wave': {'bin_header': {'checksum': 28962,
                         'noteSize': 0,
                         'pictSize': 0,
                         'wfmSize': 166},
          'note': '',
          'padding': array([], dtype=float64),
          'wData': array([ 5.,  4.,  3.,  2.,  1.]),
          'wave_header': {'aModified': 0,
                          'bname': 'double',
                          'botFullScale': 0.0,
                          'creationDate': 3001587842,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 0,
                          'fileName': 0,
                          'formula': 0,
                          'fsValid': 0,
                          'hsA': 1.0,
                          'hsB': 0.0,
                          'kindBits': '\x00',
                          'modDate': 3001587842,
                          'next': 0,
                          'npnts': 5,
                          'srcFldr': 0,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 4,
                          'useBits': '\x00',
                          'wModified': 0,
                          'wUnused': array(['', ''],
      dtype='|S1'),
                          'waveNoteH': 0,
                          'whVersion': 0,
                          'xUnits': array(['', '', '', ''],
      dtype='|S1')}}}

>>> dumpibw('win-textWave.ibw')  # doctest: +REPORT_UDIFF
{'version': 5,
 'wave': {'bin_header': {'checksum': 184,
                         'dataEUnitsSize': 0,
                         'dimEUnitsSize': array([0, 0, 0, 0]),
                         'dimLabelsSize': array([0, 0, 0, 0]),
                         'formulaSize': 0,
                         'noteSize': 0,
                         'optionsSize1': 0,
                         'optionsSize2': 0,
                         'sIndicesSize': 20,
                         'wfmSize': 338},
          'data_units': '',
          'dimension_units': '',
          'formula': '',
          'labels': [[], [], [], []],
          'note': '',
          'sIndices': array([ 4,  7,  8, 14, 18]),
          'wData': array(['Mary', 'had', 'a', 'little', 'lamb'],
      dtype='|S6'),
          'wave_header': {'aModified': 0,
                          'bname': 'text0',
                          'botFullScale': 0.0,
                          'creationDate': 3001571199,
                          'dFolder': 8108612,
                          'dLock': 0,
                          'dataEUnits': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 32,
                          'dimEUnits': array([0, 0, 0, 0]),
                          'dimLabels': array([0, 0, 0, 0]),
                          'dimUnits': array([['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', '']],
      dtype='|S1'),
                          'fileName': 7814472,
                          'formula': 0,
                          'fsValid': 0,
                          'kindBits': '\x00',
                          'modDate': 3001571215,
                          'nDim': array([5, 0, 0, 0]),
                          'next': 0,
                          'npnts': 5,
                          'sIndices': 8133100,
                          'sfA': array([ 1.,  1.,  1.,  1.]),
                          'sfB': array([ 0.,  0.,  0.,  0.]),
                          'srcFldr': -1007,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 0,
                          'useBits': '\x00',
                          'wModified': 1,
                          'waveNoteH': 0,
                          'whUnused': array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
                          'whVersion': 1,
                          'whpad1': array(['', '', '', '', '', ''],
      dtype='|S1'),
                          'whpad2': 0,
                          'whpad3': 0,
                          'whpad4': 0}}}

>>> dumpibw('win-version2.ibw')  # doctest: +REPORT_UDIFF
{'version': 2,
 'wave': {'bin_header': {'checksum': 1047,
                         'noteSize': 15,
                         'pictSize': 0,
                         'wfmSize': 146},
          'note': 'This is a test.',
          'padding': array([], dtype=float64),
          'wData': array([ 5.,  4.,  3.,  2.,  1.], dtype=float32),
          'wave_header': {'aModified': 0,
                          'bname': 'version2',
                          'botFullScale': 0.0,
                          'creationDate': 3001251979,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 0,
                          'fileName': 0,
                          'formula': 0,
                          'fsValid': 0,
                          'hsA': 1.0,
                          'hsB': 0.0,
                          'kindBits': '\x00',
                          'modDate': 3001573594,
                          'next': 0,
                          'npnts': 5,
                          'srcFldr': 0,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 0,
                          'wUnused': array(['', ''],
      dtype='|S1'),
                          'waveNoteH': 0,
                          'whVersion': 0,
                          'xUnits': array(['', '', '', ''],
      dtype='|S1')}}}

>>> dumpibw('win-version5.ibw')  # doctest: +REPORT_UDIFF
{'version': 5,
 'wave': {'bin_header': {'checksum': 13214,
                         'dataEUnitsSize': 0,
                         'dimEUnitsSize': array([0, 0, 0, 0]),
                         'dimLabelsSize': array([64,  0,  0,  0]),
                         'formulaSize': 0,
                         'noteSize': 15,
                         'optionsSize1': 0,
                         'optionsSize2': 0,
                         'sIndicesSize': 0,
                         'wfmSize': 340},
          'data_units': '',
          'dimension_units': '',
          'formula': '',
          'labels': [['Column0'], [], [], []],
          'note': 'This is a test.',
          'sIndices': array([], dtype=float64),
          'wData': array([ 5.,  4.,  3.,  2.,  1.], dtype=float32),
          'wave_header': {'aModified': 0,
                          'bname': 'version5',
                          'botFullScale': 0.0,
                          'creationDate': 3001252180,
                          'dFolder': 8108612,
                          'dLock': 0,
                          'dataEUnits': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 30,
                          'dimEUnits': array([0, 0, 0, 0]),
                          'dimLabels': array([8138784,       0,       0,       0]),
                          'dimUnits': array([['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', '']],
      dtype='|S1'),
                          'fileName': 8131824,
                          'formula': 0,
                          'fsValid': 0,
                          'kindBits': '\x00',
                          'modDate': 3001573601,
                          'nDim': array([5, 0, 0, 0]),
                          'next': 8125236,
                          'npnts': 5,
                          'sIndices': 0,
                          'sfA': array([ 1.,  1.,  1.,  1.]),
                          'sfB': array([ 0.,  0.,  0.,  0.]),
                          'srcFldr': -1007,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 1,
                          'waveNoteH': 8131596,
                          'whUnused': array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
                          'whVersion': 1,
                          'whpad1': array(['', '', '', '', '', ''],
      dtype='|S1'),
                          'whpad2': 0,
                          'whpad3': 0,
                          'whpad4': 0}}}

>>> dumpibw('win-zeroPointWave.ibw')  # doctest: +REPORT_UDIFF
{'version': 5,
 'wave': {'bin_header': {'checksum': 27541,
                         'dataEUnitsSize': 0,
                         'dimEUnitsSize': array([0, 0, 0, 0]),
                         'dimLabelsSize': array([0, 0, 0, 0]),
                         'formulaSize': 0,
                         'noteSize': 0,
                         'optionsSize1': 0,
                         'optionsSize2': 0,
                         'sIndicesSize': 0,
                         'wfmSize': 320},
          'data_units': '',
          'dimension_units': '',
          'formula': '',
          'labels': [[], [], [], []],
          'note': '',
          'sIndices': array([], dtype=float64),
          'wData': array([], dtype=float32),
          'wave_header': {'aModified': 3,
                          'bname': 'zeroWave',
                          'botFullScale': 0.0,
                          'creationDate': 3001573964,
                          'dFolder': 8108612,
                          'dLock': 0,
                          'dataEUnits': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 31,
                          'dimEUnits': array([0, 0, 0, 0]),
                          'dimLabels': array([0, 0, 0, 0]),
                          'dimUnits': array([['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', '']],
      dtype='|S1'),
                          'fileName': 8125252,
                          'formula': 0,
                          'fsValid': 0,
                          'kindBits': '\x00',
                          'modDate': 3001573964,
                          'nDim': array([0, 0, 0, 0]),
                          'next': 8133140,
                          'npnts': 0,
                          'sIndices': 0,
                          'sfA': array([ 1.,  1.,  1.,  1.]),
                          'sfB': array([ 0.,  0.,  0.,  0.]),
                          'srcFldr': -1007,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 1,
                          'waveNoteH': 0,
                          'whUnused': array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
                          'whVersion': 1,
                          'whpad1': array(['', '', '', '', '', ''],
      dtype='|S1'),
                          'whpad2': 0,
                          'whpad3': 0,
                          'whpad4': 0}}}

>>> dumppxp('polar-graphs-demo.pxp')    # doctest: +REPORT_UDIFF, +ELLIPSIS
record 0:
<UnknownRecord-11 ...>
record 1:
<UnknownRecord-12 ...>
record 2:
<UnknownRecord-13 ...>
record 3:
<UnknownRecord-13 ...>
record 4:
<UnknownRecord-13 ...>
record 5:
<UnknownRecord-13 ...>
record 6:
<UnknownRecord-13 ...>
record 7:
<UnknownRecord-13 ...>
record 8:
<UnknownRecord-13 ...>
record 9:
<UnknownRecord-14 ...>
record 10:
<UnknownRecord-15 ...>
record 11:
<UnknownRecord-16 ...>
record 12:
<UnknownRecord-16 ...>
record 13:
<UnknownRecord-17 ...>
record 14:
<UnknownRecord-17 ...>
record 15:
<UnknownRecord-17 ...>
record 16:
<UnknownRecord-17 ...>
record 17:
<UnknownRecord-17 ...>
record 18:
<UnknownRecord-17 ...>
record 19:
<UnknownRecord-16 ...>
record 20:
<UnknownRecord-17 ...>
record 21:
<UnknownRecord-17 ...>
record 22:
<UnknownRecord-17 ...>
record 23:
<UnknownRecord-17 ...>
record 24:
<UnknownRecord-17 ...>
record 25:
<UnknownRecord-17 ...>
record 26:
<UnknownRecord-18 ...>
record 27:
<UnknownRecord-11 ...>
record 28:
<UnknownRecord-26 ...>
record 29:
<UnknownRecord-26 ...>
record 30:
{'variables': {'sysVars': {'K0': 0.0,
                           'K1': 0.0,
                           'K10': 0.0,
                           'K11': 0.0,
                           'K12': 0.0,
                           'K13': 0.0,
                           'K14': 0.0,
                           'K15': 0.0,
                           'K16': 0.0,
                           'K17': 0.0,
                           'K18': 0.0,
                           'K19': 0.0,
                           'K2': 0.0,
                           'K20': 128.0,
                           'K3': 0.0,
                           'K4': 0.0,
                           'K5': 0.0,
                           'K6': 0.0,
                           'K7': 0.0,
                           'K8': 0.0,
                           'K9': 0.0},
               'userStrs': {},
               'userVars': {},
               'var_header': {'numSysVars': 21,
                              'numUserStrs': 0,
                              'numUserVars': 0}},
 'version': 1}
record 31:
'\x95 Polar Graphs Demo, v3.01\n\n'
record 32:
{'version': 2,
 'wave': {'bin_header': {'checksum': -25004,
                         'noteSize': 0,
                         'pictSize': 0,
                         'wfmSize': 638},
          'note': '',
          'padding': array([], dtype=float64),
          'wData': array([ 0.30000001,  0.5448544 ,  0.77480197,  0.97584349,  1.13573945,
        1.24475539,  1.2962544 ,  1.28710103,  1.21785283,  1.09272552,
        0.91933674,  0.7082426 ,  0.47229454,  0.22585714, -0.01606643,
       -0.23874778, -0.42862982, -0.57415301, -0.6664573 , -0.69992352,
       -0.67251408, -0.58589762, -0.44534767, -0.25942117, -0.03943586,
        0.20121357,  0.44787762,  0.68553883,  0.89972788,  1.0774051 ,
        1.20775461,  1.28283918,  1.29808831,  1.25257373,  1.14906585,
        0.99386656,  0.79642528,  0.56876069,  0.32473388,  0.07920124,
       -0.15288824, -0.35740662, -0.52190179, -0.63635898, -0.69381076,
       -0.69075894, -0.62739003, -0.5075599 , -0.3385666 , -0.13069656,
        0.10339352,  0.34945396,  0.59250361,  0.81774551,  1.01146686,
        1.16187334,  1.25980926,  1.29931164,  1.27797604,  1.1971004 ,
        1.06160903,  0.87975079,  0.66259789,  0.42336911,  0.17663053,
       -0.06259823, -0.2797519 , -0.46160996, -0.59710097, -0.67797607,
       -0.69931161, -0.65980917, -0.56187314, -0.41146588, -0.21774435,
        0.00749773,  0.25054744,  0.49660596,  0.7306987 ,  0.93856692,
        1.10756063,  1.22738981,  1.29075909,  1.29381061,  1.23635852,
        1.1219027 ,  0.95740634,  0.7528879 ,  0.52079749,  0.2752648 ,
        0.03123802, -0.19642642, -0.39386547, -0.54906607, -0.6525743 ,
       -0.69808841, -0.68283898, -0.60775399, -0.47740453, -0.29972947,
       -0.08553842,  0.15212469,  0.39878684,  0.63943672,  0.85942155,
        1.04534864,  1.18589854,  1.2725141 ,  1.29992342,  1.2664578 ,
        1.17415261,  1.0286293 ,  0.83874667,  0.61606491,  0.37414294,
        0.12770344, -0.1082412 , -0.31933719, -0.49272597, -0.61785328,
       -0.6871013 , -0.69625437, -0.64475471, -0.53574032, -0.37584305,
       -0.17479956,  0.05514668,  0.30000135], dtype=float32),
          'wave_header': {'aModified': 0,
                          'bname': 'radiusData',
                          'botFullScale': 0.0,
                          'creationDate': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 0,
                          'fileName': 0,
                          'formula': 0,
                          'fsValid': 0,
                          'hsA': 0.04908738521234052,
                          'hsB': 0.0,
                          'kindBits': '\x00',
                          'modDate': 2845545774,
                          'next': 0,
                          'npnts': 128,
                          'srcFldr': 0,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 0,
                          'wUnused': array(['', ''],
      dtype='|S1'),
                          'waveNoteH': 0,
                          'whVersion': 0,
                          'xUnits': array(['', '', '', ''],
      dtype='|S1')}}}
record 33:
{'version': 2,
 'wave': {'bin_header': {'checksum': 28621,
                         'noteSize': 0,
                         'pictSize': 0,
                         'wfmSize': 638},
          'note': '',
          'padding': array([], dtype=float64),
          'wData': array([ 0.        ,  0.0494739 ,  0.0989478 ,  0.1484217 ,  0.1978956 ,
        0.24736951,  0.29684341,  0.34631732,  0.3957912 ,  0.44526511,
        0.49473903,  0.54421294,  0.59368682,  0.6431607 ,  0.69263464,
        0.74210852,  0.79158241,  0.84105635,  0.89053023,  0.94000411,
        0.98947805,  1.03895199,  1.08842587,  1.13789964,  1.18737364,
        1.23684752,  1.2863214 ,  1.3357954 ,  1.38526928,  1.43474305,
        1.48421705,  1.53369093,  1.58316481,  1.63263881,  1.68211269,
        1.73158658,  1.78106046,  1.83053434,  1.88000822,  1.92948222,
        1.9789561 ,  2.02842999,  2.07790399,  2.12737775,  2.17685175,
        2.22632551,  2.27579927,  2.32527351,  2.37474728,  2.42422128,
        2.47369504,  2.52316904,  2.5726428 ,  2.6221168 ,  2.67159081,
        2.72106457,  2.77053857,  2.82001233,  2.86948609,  2.91896009,
        2.9684341 ,  3.0179081 ,  3.06738186,  3.11685586,  3.16632962,
        3.21580338,  3.26527762,  3.31475139,  3.36422539,  3.41369915,
        3.46317315,  3.51264691,  3.56212091,  3.61159492,  3.66106868,
        3.71054268,  3.76001644,  3.8094902 ,  3.85896444,  3.90843821,
        3.95791221,  4.00738621,  4.05685997,  4.10633373,  4.15580797,
        4.20528126,  4.2547555 ,  4.30422926,  4.3537035 ,  4.40317726,
        4.45265102,  4.50212526,  4.55159855,  4.60107279,  4.65054703,
        4.70002079,  4.74949455,  4.79896832,  4.84844255,  4.89791584,
        4.94739008,  4.99686432,  5.04633808,  5.09581184,  5.14528561,
        5.19475985,  5.24423361,  5.29370737,  5.34318161,  5.3926549 ,
        5.44212914,  5.4916029 ,  5.54107714,  5.5905509 ,  5.64002466,
        5.6894989 ,  5.73897219,  5.78844643,  5.83792019,  5.88739443,
        5.93686819,  5.98634195,  6.03581619,  6.08528948,  6.13476372,
        6.18423796,  6.23371172,  6.28318548], dtype=float32),
          'wave_header': {'aModified': 0,
                          'bname': 'angleData',
                          'botFullScale': 0.0,
                          'creationDate': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 0,
                          'fileName': 0,
                          'formula': 0,
                          'fsValid': 0,
                          'hsA': 0.04908738521234052,
                          'hsB': 0.0,
                          'kindBits': '\x00',
                          'modDate': 2845470039,
                          'next': 0,
                          'npnts': 128,
                          'srcFldr': 0,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 0,
                          'wUnused': array(['', ''],
      dtype='|S1'),
                          'waveNoteH': 0,
                          'whVersion': 0,
                          'xUnits': array(['', '', '', ''],
      dtype='|S1')}}}
record 34:
{'version': 5,
 'wave': {'bin_header': {'checksum': 23021,
                         'dataEUnitsSize': 0,
                         'dimEUnitsSize': array([0, 0, 0, 0]),
                         'dimLabelsSize': array([0, 0, 0, 0]),
                         'formulaSize': 80,
                         'noteSize': 0,
                         'optionsSize1': 0,
                         'optionsSize2': 0,
                         'sIndicesSize': 0,
                         'wfmSize': 832},
          'data_units': '',
          'dimension_units': '',
          'formula': ' PolarRadiusFunction(radiusData,1,0) * cos(PolarAngleFunction(angleData,3,1,2))',
          'labels': [[], [], [], []],
          'note': '',
          'sIndices': array([], dtype=float64),
          'wData': array([  1.83690956e-17,   2.69450769e-02,   7.65399113e-02,
         1.44305170e-01,   2.23293692e-01,   3.04783821e-01,
         3.79158467e-01,   4.36888516e-01,   4.69528973e-01,
         4.70633775e-01,   4.36502904e-01,   3.66688997e-01,
         2.64211357e-01,   1.35452762e-01,  -1.02594923e-02,
        -1.61356136e-01,  -3.04955602e-01,  -4.27943677e-01,
        -5.18107474e-01,  -5.65230608e-01,  -5.62046587e-01,
        -5.04969478e-01,  -3.94532531e-01,  -2.35490710e-01,
        -3.65724117e-02,   1.90097600e-01,   4.29877043e-01,
         6.66696191e-01,   8.84287775e-01,   1.06744885e+00,
         1.20323074e+00,   1.28195620e+00,   1.29798901e+00,
         1.25017929e+00,   1.14195395e+00,   9.81046736e-01,
         7.78884649e-01,   5.49682915e-01,   3.09332967e-01,
         7.41607845e-02,  -1.40328899e-01,  -3.20629656e-01,
        -4.56221938e-01,  -5.40310800e-01,  -5.70244014e-01,
        -5.47582209e-01,  -4.77826297e-01,  -3.69823217e-01,
        -2.34920204e-01,  -8.59207287e-02,   6.40354082e-02,
         2.02596441e-01,   3.19209903e-01,   4.05949473e-01,
         4.58081126e-01,   4.74326164e-01,   4.56804305e-01,
         4.10668582e-01,   3.43470216e-01,   2.64317334e-01,
         1.82909429e-01,   1.08534366e-01,   4.91267964e-02,
         1.04717268e-02,  -4.36885841e-03,   4.64119762e-03,
         3.45129520e-02,   7.95329511e-02,   1.31838784e-01,
         1.82213545e-01,   2.21028924e-01,   2.39245579e-01,
         2.29380637e-01,   1.86348081e-01,   1.08093813e-01,
        -4.03938442e-03,  -1.45255283e-01,  -3.07566285e-01,
        -4.80366081e-01,  -6.51240766e-01,  -8.07001889e-01,
        -9.34792042e-01,  -1.02321768e+00,  -1.06338477e+00,
        -1.04975033e+00,  -9.80714381e-01,  -8.58889818e-01,
        -6.91040277e-01,  -4.87653464e-01,  -2.62210011e-01,
        -3.01902127e-02,   1.92100301e-01,   3.88785005e-01,
         5.45667768e-01,   6.51326835e-01,   6.98035002e-01,
         6.82368934e-01,   6.05477571e-01,   4.72992837e-01,
         2.94585884e-01,   8.31873119e-02,  -1.46010652e-01,
        -3.76755983e-01,  -5.93006968e-01,  -7.80143738e-01,
        -9.26071882e-01,  -1.02209401e+00,  -1.06349015e+00,
        -1.04976654e+00,  -9.84551251e-01,  -8.75151932e-01,
        -7.31834948e-01,  -5.66861272e-01,  -3.93398553e-01,
        -2.24383846e-01,  -7.14399144e-02,   5.60413450e-02,
         1.51621893e-01,   2.12215677e-01,   2.38205954e-01,
         2.33226836e-01,   2.03656554e-01,   1.57870770e-01,
         1.05330117e-01,   5.55786416e-02,   1.72677450e-02,
        -2.72719120e-03,   5.24539061e-08], dtype=float32),
          'wave_header': {'aModified': 0,
                          'bname': 'W_plrX5',
                          'botFullScale': 0.0,
                          'creationDate': 0,
                          'dFolder': 7848580,
                          'dLock': 0,
                          'dataEUnits': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 24,
                          'dimEUnits': array([0, 0, 0, 0]),
                          'dimLabels': array([0, 0, 0, 0]),
                          'dimUnits': array([['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', '']],
      dtype='|S1'),
                          'fileName': 0,
                          'formula': 8054500,
                          'fsValid': 0,
                          'kindBits': '\x00',
                          'modDate': 2985072242,
                          'nDim': array([128,   0,   0,   0]),
                          'next': 8054516,
                          'npnts': 128,
                          'sIndices': 0,
                          'sfA': array([ 0.04908739,  1.        ,  1.        ,  1.        ]),
                          'sfB': array([ 0.,  0.,  0.,  0.]),
                          'srcFldr': 0,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 0,
                          'waveNoteH': 0,
                          'whUnused': array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
                          'whVersion': 1,
                          'whpad1': array(['', '', '', '', '', ''],
      dtype='|S1'),
                          'whpad2': 0,
                          'whpad3': 0,
                          'whpad4': 0}}}
record 35:
{'version': 5,
 'wave': {'bin_header': {'checksum': -9146,
                         'dataEUnitsSize': 0,
                         'dimEUnitsSize': array([0, 0, 0, 0]),
                         'dimLabelsSize': array([0, 0, 0, 0]),
                         'formulaSize': 80,
                         'noteSize': 82,
                         'optionsSize1': 0,
                         'optionsSize2': 0,
                         'sIndicesSize': 0,
                         'wfmSize': 832},
          'data_units': '',
          'dimension_units': '',
          'formula': ' PolarRadiusFunction(radiusData,1,0) * sin(PolarAngleFunction(angleData,3,1,2))',
          'labels': [[], [], [], []],
          'note': 'shadowX=W_plrX5,appendRadius=radiusData,appendAngleData=angleData,angleDataUnits=2',
          'sIndices': array([], dtype=float64),
          'wData': array([ 0.30000001,  0.54418772,  0.77101213,  0.96511477,  1.1135726 ,
        1.20686483,  1.23956215,  1.21068466,  1.12370288,  0.98618096,
        0.80910152,  0.60592639,  0.39147732,  0.18073183, -0.01236418,
       -0.17596789, -0.30120692, -0.38277394, -0.41920158, -0.41280419,
       -0.36929506, -0.29712263, -0.20658807, -0.10882771, -0.01475283,
        0.06595302,  0.12569843,  0.15962352,  0.16596791,  0.14613269,
        0.10443594,  0.04758934, -0.01605497, -0.0774129 , -0.12764584,
       -0.15911636, -0.16622847, -0.14607331, -0.09881912, -0.02780312,
        0.06068454,  0.15791172,  0.25346208,  0.33617997,  0.3952153 ,
        0.42107204,  0.40657136,  0.34763175,  0.24380288,  0.09848462,
       -0.08117689, -0.28473276, -0.49916485, -0.70986813, -0.90179092,
       -1.06064332, -1.17407382, -1.23270524, -1.23095524, -1.16755545,
       -1.04573321, -0.87303019, -0.66077417, -0.42323959, -0.1765765 ,
        0.06242594,  0.2776148 ,  0.45470679,  0.58236426,  0.65303123,
        0.66346282,  0.61490625,  0.51291907,  0.36684951,  0.18901938,
       -0.00631659, -0.20414437, -0.389898  , -0.55060786, -0.67586488,
       -0.75857663, -0.79539269, -0.78681922, -0.73699296, -0.65315133,
       -0.54485315, -0.42300734, -0.29883695, -0.18282266, -0.08376524,
       -0.00802278,  0.0409977 ,  0.06305727,  0.06099379,  0.04033075,
        0.00863387, -0.02533132, -0.05255322, -0.06475239, -0.05528941,
       -0.01991711,  0.04269439,  0.13071296,  0.23921135,  0.36052904,
        0.48491719,  0.60139763,  0.69877088,  0.76667541,  0.79660165,
        0.78277934,  0.72283876,  0.6181944 ,  0.47410288,  0.29939076,
        0.10585135, -0.09260413, -0.28104633, -0.44468346, -0.57008827,
       -0.64630753, -0.66580337, -0.62512833, -0.52528399, -0.37171093,
       -0.17394456,  0.0550792 ,  0.30000135], dtype=float32),
          'wave_header': {'aModified': 0,
                          'bname': 'W_plrY5',
                          'botFullScale': 0.0,
                          'creationDate': 0,
                          'dFolder': 7848580,
                          'dLock': 0,
                          'dataEUnits': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 26,
                          'dimEUnits': array([0, 0, 0, 0]),
                          'dimLabels': array([0, 0, 0, 0]),
                          'dimUnits': array([['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', '']],
      dtype='|S1'),
                          'fileName': 0,
                          'formula': 8054532,
                          'fsValid': 0,
                          'kindBits': '\x00',
                          'modDate': 2985072242,
                          'nDim': array([128,   0,   0,   0]),
                          'next': 8084972,
                          'npnts': 128,
                          'sIndices': 0,
                          'sfA': array([ 0.04908739,  1.        ,  1.        ,  1.        ]),
                          'sfB': array([ 0.,  0.,  0.,  0.]),
                          'srcFldr': 0,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 0,
                          'waveNoteH': 7996608,
                          'whUnused': array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
                          'whVersion': 1,
                          'whpad1': array(['', '', '', '', '', ''],
      dtype='|S1'),
                          'whpad2': 0,
                          'whpad3': 0,
                          'whpad4': 0}}}
record 36:
{'version': 2,
 'wave': {'bin_header': {'checksum': 14307,
                         'noteSize': 0,
                         'pictSize': 0,
                         'wfmSize': 382},
          'note': '',
          'padding': array([], dtype=float64),
          'wData': array([ 0.2617994 ,  0.27842158,  0.29504377,  0.31166595,  0.32828814,
        0.34491032,  0.36153251,  0.3781547 ,  0.39477688,  0.41139907,
        0.42802125,  0.44464344,  0.46126559,  0.47788778,  0.49450997,
        0.51113212,  0.52775431,  0.54437649,  0.56099868,  0.57762086,
        0.59424305,  0.61086524,  0.62748742,  0.64410961,  0.66073179,
        0.67735398,  0.69397616,  0.71059835,  0.72722054,  0.74384272,
        0.76046491,  0.77708709,  0.79370928,  0.81033146,  0.82695365,
        0.84357584,  0.86019802,  0.87682021,  0.89344239,  0.91006458,
        0.92668676,  0.94330889,  0.95993114,  0.97655326,  0.99317551,
        1.00979757,  1.02641988,  1.04304194,  1.05966425,  1.07628632,
        1.09290862,  1.10953069,  1.12615299,  1.14277506,  1.15939736,
        1.17601943,  1.19264174,  1.2092638 ,  1.22588611,  1.24250817,
        1.25913048,  1.27575254,  1.29237485,  1.30899692], dtype=float32),
          'wave_header': {'aModified': 0,
                          'bname': 'angleQ1',
                          'botFullScale': 0.0,
                          'creationDate': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 0,
                          'fileName': 0,
                          'formula': 0,
                          'fsValid': 0,
                          'hsA': 1.0,
                          'hsB': 0.0,
                          'kindBits': '\x00',
                          'modDate': 2845473705,
                          'next': 0,
                          'npnts': 64,
                          'srcFldr': 0,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 0,
                          'wUnused': array(['', ''],
      dtype='|S1'),
                          'waveNoteH': 0,
                          'whVersion': 0,
                          'xUnits': array(['', '', '', ''],
      dtype='|S1')}}}
record 37:
{'version': 2,
 'wave': {'bin_header': {'checksum': -12080,
                         'noteSize': 0,
                         'pictSize': 0,
                         'wfmSize': 382},
          'note': '',
          'padding': array([], dtype=float64),
          'wData': array([ -8.34064484,  -7.66960144,  -6.62294245,  -6.82878971,
        -8.6383152 , -11.20019722, -13.83398628, -15.95139503,
       -16.18096733, -13.58062267,  -9.26843071,  -5.34649038,
        -3.01010084,  -2.30953455,  -2.73682952,  -3.72112942,
        -4.85171413,  -5.63053226,  -5.48626232,  -4.49401283,
        -3.53216696,  -3.34821796,  -4.07400894,  -5.87675714,
        -9.11268425, -12.98700237, -15.06296921, -13.71571922,
       -10.23535728,  -7.01303005,  -5.23288727,  -5.71091986,
        -9.24852943, -14.06335735, -15.846241  , -12.78800964,
        -7.8465519 ,  -4.56293297,  -3.54999399,  -3.67789125,
        -4.10172844,  -4.78980875,  -6.20238352,  -8.17891598,
        -9.2803278 ,  -8.36780167,  -6.3059268 ,  -4.85605574,
        -4.54975414,  -4.52917624,  -3.99160147,  -3.1971693 ,
        -2.93472862,  -3.47230864,  -4.7322526 ,  -6.80173016,
        -9.08601665, -10.00928402,  -8.87677383,  -6.88120317,
        -5.61007977,  -5.6351161 ,  -6.41880989,  -6.8738699 ], dtype=float32),
          'wave_header': {'aModified': 0,
                          'bname': 'radiusQ1',
                          'botFullScale': 0.0,
                          'creationDate': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 0,
                          'fileName': 0,
                          'formula': 0,
                          'fsValid': 0,
                          'hsA': 1.0,
                          'hsB': 0.0,
                          'kindBits': '\x00',
                          'modDate': 2845473634,
                          'next': 0,
                          'npnts': 64,
                          'srcFldr': 0,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 0,
                          'wUnused': array(['', ''],
      dtype='|S1'),
                          'waveNoteH': 0,
                          'whVersion': 0,
                          'xUnits': array(['', '', '', ''],
      dtype='|S1')}}}
record 38:
{'version': 5,
 'wave': {'bin_header': {'checksum': -5745,
                         'dataEUnitsSize': 0,
                         'dimEUnitsSize': array([0, 0, 0, 0]),
                         'dimLabelsSize': array([0, 0, 0, 0]),
                         'formulaSize': 78,
                         'noteSize': 0,
                         'optionsSize1': 0,
                         'optionsSize2': 0,
                         'sIndicesSize': 0,
                         'wfmSize': 576},
          'data_units': '',
          'dimension_units': '',
          'formula': ' PolarRadiusFunction(radiusQ1,1,-40) * cos(PolarAngleFunction(angleQ1,2,2,2))',
          'labels': [[], [], [], []],
          'note': '',
          'sIndices': array([], dtype=float64),
          'wData': array([ 30.58058929,  31.08536911,  31.93481636,  31.57315445,
        29.68683434,  27.10366058,  24.47453499,  22.3495121 ,
        21.98692894,  24.21500397,  27.95923996,  31.28394508,
        33.12408066,  33.46794128,  32.79909515,  31.64211464,
        30.36601639,  29.40137291,  29.22361755,  29.74564171,
        30.21624565,  30.02338219,  29.0822773 ,  27.28613091,
        24.38687515,  21.04944038,  19.16931915,  19.92274094,
        22.23493385,  24.27418709,  25.1893177 ,  24.44671249,
        21.56310272,  17.87704659,  16.35500908,  18.09041786,
        20.97328949,  22.66550255,  22.84443283,  22.29068756,
        21.55643272,  20.67234993,  19.38551521,  17.81604385,
        16.77393341,  16.8293457 ,  17.4496479 ,  17.6982975 ,
        17.34101677,  16.83446693,  16.56042671,  16.38027191,
        15.94310474,  15.16159916,  14.10328865,  12.76812935,
        11.41363049,  10.60795975,  10.52314186,  10.67826462,
        10.5454855 ,   9.99268055,   9.22939587,   8.5736742 ], dtype=float32),
          'wave_header': {'aModified': 0,
                          'bname': 'W_plrX6',
                          'botFullScale': 0.0,
                          'creationDate': 0,
                          'dFolder': 7848580,
                          'dLock': 0,
                          'dataEUnits': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 30,
                          'dimEUnits': array([0, 0, 0, 0]),
                          'dimLabels': array([0, 0, 0, 0]),
                          'dimUnits': array([['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', '']],
      dtype='|S1'),
                          'fileName': 0,
                          'formula': 8052116,
                          'fsValid': 0,
                          'kindBits': '\x00',
                          'modDate': 2985072242,
                          'nDim': array([64,  0,  0,  0]),
                          'next': 8324392,
                          'npnts': 64,
                          'sIndices': 0,
                          'sfA': array([ 1.,  1.,  1.,  1.]),
                          'sfB': array([ 0.,  0.,  0.,  0.]),
                          'srcFldr': 0,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 0,
                          'waveNoteH': 0,
                          'whUnused': array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
                          'whVersion': 1,
                          'whpad1': array(['', '', '', '', '', ''],
      dtype='|S1'),
                          'whpad2': 0,
                          'whpad3': 0,
                          'whpad4': 0}}}
record 39:
{'version': 5,
 'wave': {'bin_header': {'checksum': -16604,
                         'dataEUnitsSize': 0,
                         'dimEUnitsSize': array([0, 0, 0, 0]),
                         'dimLabelsSize': array([0, 0, 0, 0]),
                         'formulaSize': 78,
                         'noteSize': 78,
                         'optionsSize1': 0,
                         'optionsSize2': 0,
                         'sIndicesSize': 0,
                         'wfmSize': 576},
          'data_units': '',
          'dimension_units': '',
          'formula': ' PolarRadiusFunction(radiusQ1,1,-40) * sin(PolarAngleFunction(angleQ1,2,2,2))',
          'labels': [[], [], [], []],
          'note': 'shadowX=W_plrX6,appendRadius=radiusQ1,appendAngleData=angleQ1,angleDataUnits=2',
          'sIndices': array([], dtype=float64),
          'wData': array([  8.19404411,   8.88563347,   9.70543861,  10.17177773,
        10.11173058,   9.73756695,   9.25513077,   8.8788929 ,
         9.16085339,  10.56489944,  12.75579453,  14.90572262,
        16.46352959,  17.33401871,  17.68511391,  17.74635315,
        17.70048141,  17.79942513,  18.36241531,  19.38741684,
        20.41767311,  21.02259827,  21.09260368,  20.4905529 ,
        18.95538521,  16.9299469 ,  15.94969368,  17.14490509,
        19.78741264,  22.33615875,  23.96352196,  24.04369545,
        21.92454147,  18.79150391,  17.77407646,  20.32803917,
        24.37140465,  27.24079132,  28.40307808,  28.67787933,
        28.70550728,  28.50283432,  27.68538666,  26.36607552,
        25.73583984,  26.78374672,  28.8236084 ,  30.36226463,
        30.91939545,  31.22146797,  31.97431755,  32.95656204,
        33.4611969 ,  33.23248672,  32.3250885 ,  30.64473915,
        28.72983551,  28.05199242,  29.29024887,  31.3501091 ,
        32.7331543 ,  32.87995529,  32.28799438,  31.99738503], dtype=float32),
          'wave_header': {'aModified': 0,
                          'bname': 'W_plrY6',
                          'botFullScale': 0.0,
                          'creationDate': 0,
                          'dFolder': 7848580,
                          'dLock': 0,
                          'dataEUnits': 0,
                          'dataUnits': array(['', '', '', ''],
      dtype='|S1'),
                          'depID': 32,
                          'dimEUnits': array([0, 0, 0, 0]),
                          'dimLabels': array([0, 0, 0, 0]),
                          'dimUnits': array([['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', ''],
       ['', '', '', '']],
      dtype='|S1'),
                          'fileName': 0,
                          'formula': 7995612,
                          'fsValid': 0,
                          'kindBits': '\x00',
                          'modDate': 2985072242,
                          'nDim': array([64,  0,  0,  0]),
                          'next': 0,
                          'npnts': 64,
                          'sIndices': 0,
                          'sfA': array([ 1.,  1.,  1.,  1.]),
                          'sfB': array([ 0.,  0.,  0.,  0.]),
                          'srcFldr': 0,
                          'swModified': 0,
                          'topFullScale': 0.0,
                          'type': 2,
                          'useBits': '\x00',
                          'wModified': 0,
                          'waveNoteH': 7998208,
                          'whUnused': array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
                          'whVersion': 1,
                          'whpad1': array(['', '', '', '', '', ''],
      dtype='|S1'),
                          'whpad2': 0,
                          'whpad3': 0,
                          'whpad4': 0}}}
record 40:
'Packages'
record 41:
'WMDataBase'
record 42:
{'variables': {'sysVars': {'K0': 0.0,
                           'K1': 0.0,
                           'K10': 0.0,
                           'K11': 0.0,
                           'K12': 0.0,
                           'K13': 0.0,
                           'K14': 0.0,
                           'K15': 0.0,
                           'K16': 0.0,
                           'K17': 0.0,
                           'K18': 0.0,
                           'K19': 0.0,
                           'K2': 0.0,
                           'K20': 128.0,
                           'K3': 0.0,
                           'K4': 0.0,
                           'K5': 0.0,
                           'K6': 0.0,
                           'K7': 0.0,
                           'K8': 0.0,
                           'K9': 0.0},
               'userStrs': {'u_dataBase': ';PolarGraph0:,...,useCircles=2,maxArcLine=6;',
                            'u_dbBadStringChars': ',;=:',
                            'u_dbCurrBag': 'PolarGraph1',
                            'u_dbCurrContents': ',appendRadius=radiusQ1,...,useCircles=2,maxArcLine=6;',
                            'u_dbReplaceBadChars': '\xa9\xae\x99\x9f',
                            'u_str': '2'},
               'userVars': {},
               'var_header': {'numSysVars': 21,
                              'numUserStrs': 6,
                              'numUserVars': 0}},
 'version': 1}
record 43:
''
record 44:
'PolarGraphs'
record 45:
{'variables': {'sysVars': {'K0': 0.0,
                           'K1': 0.0,
                           'K10': 0.0,
                           'K11': 0.0,
                           'K12': 0.0,
                           'K13': 0.0,
                           'K14': 0.0,
                           'K15': 0.0,
                           'K16': 0.0,
                           'K17': 0.0,
                           'K18': 0.0,
                           'K19': 0.0,
                           'K2': 0.0,
                           'K20': 128.0,
                           'K3': 0.0,
                           'K4': 0.0,
                           'K5': 0.0,
                           'K6': 0.0,
                           'K7': 0.0,
                           'K8': 0.0,
                           'K9': 0.0},
               'userStrs': {'u_colorList': 'black;blue;green;cyan;red;magenta;yellow;white;special',
                            'u_debugStr': 'Turn Debugging On',
                            'u_polAngleAxesWherePop': 'Off;Radius Start;Radius End;Radius Start and End;All Major Radii;At Listed Radii',
                            'u_polAngleUnitsPop': 'deg;rad',
                            'u_polLineStylePop': 'solid;dash 1;dash 2;dash 3;dash 4;dash 5;dash 6;dash 7;dash 8;dash 9;dash 10;dash 11;dash 12;dash 13;dash 14;dash 15;dash 16;dash 17;',
                            'u_polOffOn': 'Off;On',
                            'u_polRadAxesWherePop': '  Off;  Angle Start;  Angle Middle;  Angle End;  Angle Start and End;  0;  90;  180; -90;  0, 90;  90, 180; -180, -90; -90, 0;  0, 180;  90, -90;  0, 90, 180, -90;  All Major Angles;  At Listed Angles',
                            'u_polRotPop': ' -90;  0; +90; +180',
                            'u_popup': '',
                            'u_prompt': ''},
               'userVars': {'V_bottom': 232.0,
                            'V_left': 1.0,
                            'V_max': 2.4158518093414401,
                            'V_min': -2.1848498883412,
                            'V_right': 232.0,
                            'V_top': 1.0,
                            'u_UniqWaveNdx': 8.0,
                            'u_UniqWinNdx': 3.0,
                            'u_angle0': 0.0,
                            'u_angleRange': 6.2831853071795862,
                            'u_debug': 0.0,
                            'u_majorDelta': 0.0,
                            'u_numPlaces': 0.0,
                            'u_polAngle0': 0.26179938779914941,
                            'u_polAngleRange': 1.0471975511965976,
                            'u_polInnerRadius': -20.0,
                            'u_polMajorAngleInc': 0.26179938779914941,
                            'u_polMajorRadiusInc': 10.0,
                            'u_polMinorAngleTicks': 3.0,
                            'u_polMinorRadiusTicks': 1.0,
                            'u_polOuterRadius': 0.0,
                            'u_segsPerMinorArc': 3.0,
                            'u_tickDelta': 0.0,
                            'u_var': 0.0,
                            'u_x1': 11.450159535018935,
                            'u_x2': 12.079591517721363,
                            'u_y1': 42.732577139459856,
                            'u_y2': 45.081649278814126},
               'var_header': {'numSysVars': 21,
                              'numUserStrs': 10,
                              'numUserVars': 28}},
 'version': 1}
record 46:
''
record 47:
''
record 48:
'| Platform=Windows95, IGORVersion=3.130\n\n\n\nMoveWindow/P 5.25,40.25,504.75,335\n...hook=PolarWindowHook\nEndMacro\n'
record 49:
''
record 50:
'#include <Polar Graphs> version >= 3.0\n'
<BLANKLINE>
filesystem:
{'root': {'K0': 0.0,
          'K1': 0.0,
          'K10': 0.0,
          'K11': 0.0,
          'K12': 0.0,
          'K13': 0.0,
          'K14': 0.0,
          'K15': 0.0,
          'K16': 0.0,
          'K17': 0.0,
          'K18': 0.0,
          'K19': 0.0,
          'K2': 0.0,
          'K20': 128.0,
          'K3': 0.0,
          'K4': 0.0,
          'K5': 0.0,
          'K6': 0.0,
          'K7': 0.0,
          'K8': 0.0,
          'K9': 0.0,
          'Packages': {'PolarGraphs': {'V_bottom': 232.0,
                                       'V_left': 1.0,
                                       'V_max': 2.4158518093414401,
                                       'V_min': -2.1848498883412,
                                       'V_right': 232.0,
                                       'V_top': 1.0,
                                       'u_UniqWaveNdx': 8.0,
                                       'u_UniqWinNdx': 3.0,
                                       'u_angle0': 0.0,
                                       'u_angleRange': 6.2831853071795862,
                                       'u_colorList': 'black;blue;green;cyan;red;magenta;yellow;white;special',
                                       'u_debug': 0.0,
                                       'u_debugStr': 'Turn Debugging On',
                                       'u_majorDelta': 0.0,
                                       'u_numPlaces': 0.0,
                                       'u_polAngle0': 0.26179938779914941,
                                       'u_polAngleAxesWherePop': 'Off;Radius Start;Radius End;Radius Start and End;All Major Radii;At Listed Radii',
                                       'u_polAngleRange': 1.0471975511965976,
                                       'u_polAngleUnitsPop': 'deg;rad',
                                       'u_polInnerRadius': -20.0,
                                       'u_polLineStylePop': 'solid;dash 1;dash 2;dash 3;dash 4;dash 5;dash 6;dash 7;dash 8;dash 9;dash 10;dash 11;dash 12;dash 13;dash 14;dash 15;dash 16;dash 17;',
                                       'u_polMajorAngleInc': 0.26179938779914941,
                                       'u_polMajorRadiusInc': 10.0,
                                       'u_polMinorAngleTicks': 3.0,
                                       'u_polMinorRadiusTicks': 1.0,
                                       'u_polOffOn': 'Off;On',
                                       'u_polOuterRadius': 0.0,
                                       'u_polRadAxesWherePop': '  Off;  Angle Start;  Angle Middle;  Angle End;  Angle Start and End;  0;  90;  180; -90;  0, 90;  90, 180; -180, -90; -90, 0;  0, 180;  90, -90;  0, 90, 180, -90;  All Major Angles;  At Listed Angles',
                                       'u_polRotPop': ' -90;  0; +90; +180',
                                       'u_popup': '',
                                       'u_prompt': '',
                                       'u_segsPerMinorArc': 3.0,
                                       'u_tickDelta': 0.0,
                                       'u_var': 0.0,
                                       'u_x1': 11.450159535018935,
                                       'u_x2': 12.079591517721363,
                                       'u_y1': 42.732577139459856,
                                       'u_y2': 45.081649278814126},
                       'WMDataBase': {'u_dataBase': ';PolarGraph0:,appendRadius=radiusData,...,useCircles=2,maxArcLine=6;',
                                      'u_dbBadStringChars': ',;=:',
                                      'u_dbCurrBag': 'PolarGraph1',
                                      'u_dbCurrContents': ',appendRadius=radiusQ1,...,useCircles=2,maxArcLine=6;',
                                      'u_dbReplaceBadChars': '\xa9\xae\x99\x9f',
                                      'u_str': '2'}},
          'W_plrX5': <WaveRecord ...>,
          'W_plrX6': <WaveRecord ...>,
          'W_plrY5': <WaveRecord ...>,
          'W_plrY6': <WaveRecord ...>,
          'angleData': <WaveRecord ...>,
          'angleQ1': <WaveRecord ...>,
          'radiusData': <WaveRecord ...>,
          'radiusQ1': <WaveRecord ...>}}
<BLANKLINE>
walking filesystem:
walk callback on ([], root, {'K0': 0.0,...})
walk callback on (['root'], K0, 0.0)
walk callback on (['root'], K1, 0.0)
walk callback on (['root'], K10, 0.0)
...
walk callback on (['root'], K9, 0.0)
walk callback on (['root'], Packages, {'PolarGraphs': ...})
walk callback on (['root', 'Packages'], PolarGraphs, {...})
walk callback on (['root', 'Packages', 'PolarGraphs'], V_bottom, 232.0)
...
walk callback on (['root', 'Packages'], WMDataBase, {...})
...
walk callback on (['root'], radiusQ1, <WaveRecord ...>)
"""

import os.path
from pprint import pformat

from igor import LOG
from igor.binarywave import load as loadibw
from igor.packed import load as loadpxp
from igor.packed import walk as _walk
from igor.record.base import TextRecord
from igor.record.folder import FolderStartRecord, FolderEndRecord
from igor.record.variables import VariablesRecord
from igor.record.wave import WaveRecord


_this_dir = os.path.dirname(__file__)
_data_dir = os.path.join(_this_dir, 'data')

def dumpibw(filename):
    LOG.info('Testing {}\n'.format(filename))
    path = os.path.join(_data_dir, filename)
    data = loadibw(path)
    pprint(data)

def walk_callback(dirpath, key, value):
    print('walk callback on ({}, {}, {})'.format(
            dirpath, key, pformat(value)))

def dumppxp(filename, walk=True):
    LOG.info('Testing {}\n'.format(filename))
    path = os.path.join(_data_dir, filename)
    records,filesystem = loadpxp(path)
    for i,record in enumerate(records):
        print('record {}:'.format(i))
        if isinstance(record, (FolderStartRecord, FolderEndRecord)):
            pprint(record.null_terminated_text)
        elif isinstance(record, TextRecord):
            pprint(record.text)
        elif isinstance(record, VariablesRecord):
            pprint(record.variables)
        elif isinstance(record, WaveRecord):
            pprint(record.wave)
        else:
            pprint(record)
    print('\nfilesystem:')
    pprint(filesystem)
    if walk:
        print('\nwalking filesystem:')
        _walk(filesystem, walk_callback)

def pprint(data):
    lines = pformat(data).splitlines()
    print('\n'.join([line.rstrip() for line in lines]))
