<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<stl:block xmlns="http://www.w3.org/1999/xhtml" xmlns:stl="http://www.hforge.org/xml-namespaces/stl">
    <!-- Javascript -->
  <script language="javascript">
  var list_products = {<stl:inline stl:repeat="product list_products">
                       "${product/id}":
                          {'module':
                           [<stl:inline stl:repeat="module product/modules">
                             {"id": "${module/id}",
                              "value": "${module/value}"},
                              </stl:inline>],
                           'version':
                           [<stl:inline stl:repeat="version product/versions">
                             {"id": "${version/id}",
                              "value": "${version/value}"},
                              </stl:inline>]}
                       ,</stl:inline>
                      }
  function update_tracker(){
      update_tracker_list('version');
      update_tracker_list('module');
  }
  </script>
<p stl:if="reported_by">
  Rapporté par <em>${reported_by}</em>
</p>

<form action=";edit" method="post" enctype="multipart/form-data">
  <fieldset>
    <legend>Modifier une fiche</legend>
    <table>
      <tr>
        <td colspan="2">
          <label for="title" class="${title/class}">Titre (obligatoire)</label><br></br>
          <input name="title" type="text" id="title" size="48" value="${title/value}"></input>
        </td>
      </tr>
      <tr>
        <td valign="top">
          <label for="product" class="${product/class}">Produit (obligatoire) :</label><br></br>
          <select id="product" name="product" class="tracker_select">
            <option value="-1"></option>
            <option value="${item/name}" selected="${item/selected}" stl:repeat="item product/value">${item/value}</option>
          </select>
        </td>
        <td valign="top">
          <label for="module" class="${module/class}">Module :</label><br></br>
          <select id="module" name="module" class="tracker_select">
            <option value=""></option>
            <option value="${item/name}" selected="${item/selected}" stl:repeat="item module/value">${item/value}</option>
          </select>
        </td>
        <td valign="top">
          <label for="version" class="${version/class}">Version :</label><br></br>
          <select id="version" name="version" class="tracker_select">
            <option value=""></option>
            <option value="${item/name}" selected="${item/selected}" stl:repeat="item version/value">${item/value}</option>
          </select>
        </td>
      </tr>
      <tr>
        <td valign="top">
          <label for="type" class="${type/class}">Type (obligatoire) :</label><br></br>
          <select id="type" name="type" class="tracker_select">
            <option value=""></option>
            <option value="${item/name}" selected="${item/selected}" stl:repeat="item type/value">${item/value}</option>
          </select>
        </td>
        <td valign="top">
          <label for="state" class="${state/class}">État (obligatoire) :</label><br></br>
          <select id="state" name="state" class="tracker_select">
            <option value=""></option>
            <option value="${item/name}" selected="${item/selected}" stl:repeat="item state/value">${item/value}</option>
          </select>
        </td>
        <td valign="top">
          <label for="priority" class="${priority/class}">Priorité :</label><br></br>
          <select id="priority" name="priority" class="tracker_select">
            <option value=""></option>
            <option value="${item/name}" selected="${item/selected}" stl:repeat="item priority/value">${item/value}</option>
          </select>
        </td>
      </tr>
      <tr>
        <td valign="top">
          <label for="assigned_to" class="${assigned_to/class}">Assigné à :</label><br></br>
          <select id="assigned_to" name="assigned_to" class="tracker_select">
            <option value=""></option>
            <option value="${item/name}" selected="${item/selected}" stl:repeat="item assigned_to/value">${item/value}</option>
          </select>
        </td>
        <td valign="top">
          <label for="cc_add" class="${cc_add/class}">Ajouter CC :</label><br></br>
          <select id="cc_add" name="cc_add" class="tracker_select" size="5" multiple="multiple">
            <option value="${item/name}" selected="${item/selected}" stl:repeat="item cc_add/value">${item/value}</option>
          </select>
        </td>
        <td valign="top">
          <label for="cc_list" class="${cc_list/class}">CC :</label><br></br>
          <select id="cc_list" name="cc_list" class="tracker_select" size="4" multiple="multiple">
            <option value="${item/name}" selected="${item/selected}" stl:repeat="item cc_list/value">${item/value}</option>
          </select>
          <input value="1" type="checkbox" name="cc_remove" checked="${cc_remove}"></input>
          <label for="cc_remove">Supprimer les CCs sélectionnés</label>
        </td>
      </tr>
      <tr>
        <td colspan="3" valign="top">
          <a name="new_comment"></a>
          <label for="comment" class="${comment/class}">Nouveau commentaire :</label><br></br>
          <textarea name="comment" rows="10" id="comment" cols="80"></textarea>
        </td>
      </tr>
      <tr>
        <td colspan="2" valign="top">
          <label for="attachement">Nouvelle pièce jointe :</label><br></br>
          <input name="file" id="attachement" size="36" type="file"></input>
        </td>
      </tr>
      <tr>
        <td colspan="2">
          <input value="Modifier" class="button_ok" type="submit"></input>
        </td>
      </tr>
    </table>
  </fieldset>
</form>

<br></br>
<stl:block stl:repeat="comment comments">
  <table width="100%" cellpadding="0" cellspacing="0" border="0">
    <tr class="tracker_issue_comment_title">
      <td><a name="c${comment/number}"></a></td>
      <td>Commentaire <a href="#c${comment/number}">${comment/number}</a></td>
      <td>${comment/user}</td>
      <td align="right">${comment/datetime}</td>
      <td align="right">
       [ <a onclick="javascript:reply('${comment/number}');" href="#new_comment"> Répondre </a>] 
      </td>
    </tr>
    <tr stl:if="comment/file">
      <td colspan="5">
        Pièce jointe : <a href="${comment/file}/;download">${comment/file}</a>
      </td>
    </tr>
    <tr>
      <td colspan="5">
      <pre id="comment${comment/number}" class="com">${comment/comment}</pre>
      </td>
    </tr>
  </table>
  <br></br>
</stl:block>

</stl:block>
