<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:stl="http://www.hforge.org/xml-namespaces/stl">
  <head>
    <title>Insert link</title>
    <link rel="stylesheet" href="${style}" stl:repeat="style styles" type="text/css"></link>
    <script src="${script}" stl:repeat="script scripts" type="text/javascript"></script>
    <script type="text/javascript">
      $(document).ready(function() {
        tabme();
      })
      ${additional_javascript}
    </script>
    <style>
      #body {
        border-top: 20px solid #30569D;
        padding: 20px;
      }
      table.thumbs {
        border-collapse: collapse;
      }
      table.thumbs th,
      table.thumbs td {
        border: 2px solid #ccc;
      }
      dt a {
        white-space: nowrap;
      }
    </style>
  </head>

  <body>
    <div id="body">

      <!-- tabs -->
      <p class="tabme">
        <a onclick="tabme_show(event, this)" href="#browse" stl:if="show_browse">Parcourir</a>  <a onclick="tabme_show(event, this)" href="#external" stl:if="show_external">Lien Externe</a>  <a onclick="tabme_show(event, this)" href="#insert" stl:if="show_insert">Insérer</a>  <a onclick="tabme_show(event, this)" href="#upload" stl:if="show_upload">Importer</a>
      </p>

      <!-- Message -->
      <div id="message" stl:if="message">Message: ${message}</div>

      <!-- Internal Link -->
      <div id="browse" stl:if="show_browse">
        <h3>Parcourir l'application pour sélectionner un fichier :</h3>
        <!-- Breadcrumbs -->
        <div id="maintitle">
          <div id="breadcrumbs">
            <label>Emplacement :</label>
            <span stl:repeat="x bc/path">
              <a href="${x/url}" title="${x/title}">${x/short_title}</a> /
            </span>
          </div>
        </div>
        <table cellspacing="1" width="100%" cellpadding="1" class="thumbs" border="0">
          <tr>
            <th width="150">Parcourir</th>
            <th>Sélectionner la ressource</th>
          </tr>
          <tr>
            <td valign="top">
              <!-- Browse Folders -->
              <stl:block stl:repeat="item bc/items">
                <dl stl:if="item/is_folder">
                  <dt>
                    <a href="${item/url}" title="${item/title}"><img src="${item/icon}" width="16" alt="" height="16"></img> ${item/short_title}</a>
                  </dt>
                </dl>
              </stl:block>
            </td>
            <td valign="top">
              <!-- Files and Folders to select -->
              <stl:block stl:repeat="item bc/items">
                <dl class="thumb">
                  <dt>
                    <img src="${item/icon}" width="48" title="${item/item_type}" alt="" height="48"></img>
                  </dt>
                  <dd>
                    <abbr title="${item/title}">${item/short_title}</abbr><br></br>  <a href="javascript:select_element('${element_to_add}', '${item/path}', '${item/title}')">Selectionner</a>
                  </dd>
                </dl>
              </stl:block>
            </td>
          </tr>
        </table>
      </div>

      <!-- External Link -->
      <div id="external" stl:if="show_external">
        <h3>Saisissez une adresse URL externe</h3>
        <form>
          <input id="uri" type="text" name="uri" size="40" value="http://"></input>
          <input onclick="select_element('${element_to_add}', $('#uri').val(), '');" type="button" class="button_ok" value="Add"></input>
        </form>
      </div>

      <!-- New Web or Wiki Page -->
      <div id="insert" stl:if="show_insert">
        <h3>Créer une nouvelle page et la lier</h3>
        <form action=";add_link#insert" method="post">
          <input value="${bc/target_path}" name="target_path" type="hidden"></input>
          <input value="${target_id}" name="target_id" type="hidden"></input>  <input value="${mode}" name="mode" type="hidden"></input>  <input name="title" size="40" type="text"></input>  <input value="" name="name" type="hidden"></input>
          <input value="OK" name=";add_resource" class="button_ok" type="submit"></input>
        </form>
      </div>

      <!-- Upload and Link -->
      <div id="upload" stl:if="show_upload">
        <h3>Importer un fichier ici et le lier :</h3>
        <form action=";add_link#upload" method="post" enctype="multipart/form-data">
          <input value="${bc/target_path}" name="target_path" type="hidden"></input>
          <input value="${target_id}" name="target_id" type="hidden"></input>  <input value="${mode}" name="mode" type="hidden"></input>  <input id="file" name="file" size="35" type="file"></input>  <br></br>
          <input value="Importer et lier" name=";upload" class="button_upload" type="submit"></input>
        </form>
      </div>
    </div>
  </body>
</html>
