<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<stl:block xmlns="http://www.w3.org/1999/xhtml" xmlns:stl="http://www.hforge.org/xml-namespaces/stl">

  <p>
  État actuel : <strong class="wf_${statename}">${state}</strong>
  </p>

  <form action=";edit_state" method="post">
    <dl>
      <dt>Vous pouvez réaliser les actions suivantes :</dt>
      <dd stl:repeat="transition transitions">
        <input value="${transition/name}" name="transition" id="${transition/name}" type="radio"></input>
        <label for="${transition/name}">${transition/description}</label>
      </dd>
    </dl>
    <dl>
      <dt><label for="comments">Commentaires (facultatif) :</label></dt>
      <dd>
        <textarea cols="52" rows="7" name="comments" id="comments"></textarea>
      </dd>
    </dl>
    <p>
      <input value="Modifier" class="button_ok" type="submit"></input>
    </p>
  </form>

  <h4>Historique de publication</h4>

  <p stl:if="not history">
    Rien dans l'historique.
  </p>

  <table id="browse_list" stl:if="history">
    <thead>
      <tr>
        <th>Date</th>
        <th>Action</th>
        <th>Par</th>
        <th>Commentaires :</th>
      </tr>
    </thead>
    <tbody>
      <tr stl:repeat="transition history" class="${repeat/transition/even}">
        <td>${transition/date}</td>
        <td>${transition/title}</td>
        <td>${transition/user}</td>
        <td>${transition/comments}</td>
      </tr>
    </tbody>
  </table>

</stl:block>
