<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<stl:block xmlns="http://www.w3.org/1999/xhtml" xmlns:stl="http://www.hforge.org/xml-namespaces/stl">

  <!-- Edit Languages -->
  <fieldset>
    <legend>Définir les langues du Site Web.</legend>
    <form id="browse_list" action="" method="post">
      <table summary="Configuration des langues">
        <thead>
          <tr>
            <th></th>
            <th>Nom</th>
            <th>Code</th>
            <th>Par défaut</th>
          </tr>
        </thead>
        <tbody>
          <tr stl:repeat="language active_languages" class="${repeat/language/even}">
            <td>
              <input class="checkbox" type="checkbox" name="codes" value="${language/code}"></input>
            </td>
            <td>${language/name}</td>
            <td>${language/code}</td>
            <td align="center">
              <stl:block stl:if="language/isdefault">Oui</stl:block>
            </td>
          </tr>
        </tbody>
      </table>
      <p>
        <input value="Modifier la langue par défaut" class="button_ok" name=";change_default_language" type="submit"></input>
        <input name=";remove_languages" type="submit" class="button_delete" value="Supprimer"></input>
      </p>
    </form>
  </fieldset>

  <br></br>

  <!-- Add Language -->
  <fieldset>
    <legend>Ajouter une langue</legend>
    <form action="" method="post">
      <select id="new_language" name="code">
        <option value="">Choisissez une langue</option>
        <option value="${language/code}" stl:repeat="language not_active_languages">${language/name}</option>
      </select>
      <input value="Ajouter" class="button_ok" name=";add_language" type="submit"></input>
    </form>
  </fieldset>

</stl:block>
