<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<stl:block xmlns="http://www.w3.org/1999/xhtml" xmlns:stl="http://www.hforge.org/xml-namespaces/stl">

<div id="cal-monthly-view">
  <div id="selector">
    <a href="${today}" class="cal-today" stl:if="today">
      Come back to today</a>
    <ul>
      <li>
        <a href="${previous_week}">«</a> ${current_week} <a href="${next_week}">»</a>
      </li>
      <li>
        <a href="${previous_month}">«</a> ${current_month} <a href="${next_month}">»</a>
      </li>
      <li>
        <a href="${previous_year}">«</a> ${current_year} <a href="${next_year}">»</a>
      </li>
    </ul>
  </div>

  <table>
    <colgroup width="85px" span="1"></colgroup>
    <colgroup width="13%" span="7"></colgroup>

    <tr>
      <th></th>
      <th stl:repeat="day days_of_week">
        <span>${day/name}</span>
      </th>
    </tr>

    <tr stl:repeat="week weeks" valign="top">
      <td class="month">${week/month}</td>
      <td stl:repeat="day week/days" class="day">
        <span class="bold" stl:if="not day/selected">${day/nday}</span>  <span class="cal-day-selected" stl:if="day/selected">${day/nday}</span>  <a href="${day/url}" class="add-event" stl:if="day/url">  <img width="16" src="${add_icon}" height="16"></img></a> ${day/events}
      </td>
    </tr>
  </table>
</div>
</stl:block>
