<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<stl:block xmlns="http://www.w3.org/1999/xhtml" xmlns:stl="http://www.hforge.org/xml-namespaces/stl">

<div id="cal-weekly-view">
  <div id="selector">
    <a href="${today}" class="cal-today" stl:if="today">
      Come back to today</a>
    <ul>
      <li>
        <a href="${previous_week}">«</a> ${current_week} <a href="${next_week}">»</a>
      </li>
      <li>
        <a href="${previous_month}">«</a> ${current_month} <a href="${next_month}">»</a>
      </li>
      <li>
        <a href="${previous_year}">«</a> ${current_year} <a href="${next_year}">»</a>
      </li>
    </ul>
  </div>

  <table width="100%" class="timetable" border="0">
    <tr>
      <th></th>
      <th colspan="${header/width}" stl:repeat="header timetable_data/headers" class="${header/class}">
        ${header/header}
      </th>
    </tr>

    <tr stl:repeat="row timetable_data/body">
      <th width="9%" class="time">
        ${row/start}-${row/end}
      </th>
      <stl:block stl:repeat="item row/items">
        <stl:block stl:repeat="cell item/cells">
          <div stl:if="cell/new">${cell/ns}</div>

          <div stl:if="cell/free">
            <td colspan="${cell/colspan}" class="free" valign="top">
              <a href="${cell/newurl}" class="add-event" stl:if="cell/newurl">
                <img width="16" src="${add_icon}" height="16"></img>
              </a>
              <div> </div>
            </td>
          </div>
        </stl:block>
      </stl:block>
    </tr>

  <!-- FULL DAYS SPECIAL BEHAVIOUR -->
    <tr id="full-day-events" stl:if="timetable_data/full_day_events">
      <th class="time">Full day</th>
      <td colspan="${item/width}" stl:repeat="item timetable_data/full_day_events" valign="top">
        <table width="100%" class="event">
          <tr stl:repeat="event item/events">
            ${event/ns}
          </tr>
        </table>
      </td>
    </tr>

  </table>

</div>
</stl:block>
