<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<stl:block xmlns="http://www.w3.org/1999/xhtml" xmlns:stl="http://www.hforge.org/xml-namespaces/stl">

  <script type="text/javascript">
    $(document).ready(function() {
      var resolutions = new Array(${widths});
      apply_best_resolution(resolutions);
    });
  </script>

  <table class="${css}" id="browse-list">
    <thead stl:if="columns">
      <tr>
        <stl:block stl:repeat="column columns">
          <!-- checkbox -->
          <th class="checkbox" stl:if="column/is_checkbox">
            <label for="browse-list-select-all">Tout sélectionner</label>
            <input onclick="select_checkboxes('form-table', this.checked);" id="browse-list-select-all" title="Cliquez pour sélectionner/désélectionner toutes les lignes" type="checkbox"></input>
          </th>
          <!-- checkbox -->
          <th stl:if="not column/is_checkbox">
            <a href="${column/href}" class="sort-${column/order}" stl:if="column/href">${column/title}</a>
          </th>
        </stl:block>
      </tr>
    </thead>
  </table>

  <form name="browse_list" stl:omit-tag="not actions" action="" method="post" id="form-table">
    <div id="browse-image">
      <a href="../;preview_content?size=${size}&amp;width=${width}&amp;height=${height}" title="Retour" stl:if="not root"><img src="/ui/icons/16x16/up.png"></img></a>
      <div stl:repeat="row rows" class="thumbnail size${size}">
        <div stl:omit-tag="not row/is_folder" class="folder">
          <a href="${row/href}" stl:omit-tag="not row/href">
            <img src="${row/name}/;thumb?width=${size}&amp;height=${size}"></img>
          </a>
        </div>
        <p>
          <!-- checkbox -->
          <stl:block stl:if="row/checkbox">
            <input name="ids" checked="${row/checked}" id="id-${row/id}" class="checkbox" type="checkbox" value="${row/id}"></input>
            <label for="id-${row/id}" class="wf-${row/workflow_statename}">${row/title_or_name}</label>
          </stl:block>
          <stl:block stl:if="not row/checkbox">
            <label>${row/title_or_name}</label>
          </stl:block>
        </p>
      </div>
    </div>
    <p stl:if="actions">
      <stl:block stl:repeat="action actions">
        <button value="${action/value}" type="submit" class="${action/class}" onclick="${action/onclick}" name="action">${action/title}</button>
      </stl:block>
    </p>
  </form>

</stl:block>
