<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:stl="http://www.hforge.org/xml-namespaces/stl">
  <head>
    <title>Insérer une image</title>
    <link rel="stylesheet" href="/ui/bo.css" type="text/css"></link>
    <link rel="stylesheet" href="/ui/aruni/style.css" type="text/css"></link>
    <link rel="stylesheet" href="/ui/html/style.css" type="text/css"></link>
    <script src="/ui/jquery.js" type="text/javascript"></script>
    <script src="/ui/javascript.js" type="text/javascript"></script>
    <script src="${script}" stl:repeat="script scripts" type="text/javascript"></script>
    <script type="text/javascript">
      $(document).ready(function() {
        tabme();
      })
      ${additional_javascript}
    </script>
  </head>

  <body>
    <div id="body">

      <!-- tabs -->
      <p class="tabme">
        <a onclick="tabme_show(event, this)" href="#browse" stl:if="show_browse">Parcourir</a>  <a onclick="tabme_show(event, this)" href="#external" stl:if="show_external">Lien Externe</a>  <a onclick="tabme_show(event, this)" href="#insert" stl:if="show_insert">Insérer</a>  <a onclick="tabme_show(event, this)" href="#upload" stl:if="show_upload">Importer</a>
      </p>

      <!-- Message -->
      <div id="message" stl:if="message">${message}</div>

      <!-- Browse -->
      <div id="browse" stl:if="show_browse">
        <h3>Parcourir l'application pour sélectionner une image :</h3>
        <!-- Breadcrumb -->
        <div id="maintitle">
          <div id="breadcrumbs">
            <label>Emplacement :</label>
            <span stl:repeat="x breadcrumb">
              <a href="${x/url}" title="${x/title}">${x/short_title}</a> /
            </span>
          </div>
        </div>
        <table cellspacing="1" width="100%" cellpadding="1" class="thumbs" border="0">
          <tr>
            <th width="150" stl:if="folders">Parcourir</th>
            <th>Sélectionner l'image</th>
          </tr>
          <tr>
            <!-- Left column -->
            <td valign="top" stl:if="folders">
              <dl stl:repeat="item folders">
                <dt>
                  <a href="${item/url}" title="${item/title}">
                    <img src="${item/icon}" width="16" alt="" height="16"></img> ${item/short_title}
                  </a>
                </dt>
              </dl>
            </td>
            <!-- Right column -->
            <td valign="top">
              <dl stl:repeat="item items" class="thumb">
                <dt>
                  <img src="${item/icon}" width="48" title="${item/item_type}" alt="" height="48"></img>
                </dt>
                <dd>
                  <a href="javascript:select_element('${element_to_add}', '${item/path}${resource_action}', '${item/quoted_title}')" title="${item/title}">${item/short_title}</a>
                </dd>
              </dl>
            </td>
          </tr>
        </table>
      </div>

      <!-- Upload -->
      <div id="upload" stl:if="show_upload">
        <h3>Importer une image ici et l'insérer :</h3>
        <form action=";add_image#upload" method="post" enctype="multipart/form-data">
          <input value="${target_path}" name="target_path" type="hidden"></input>
          <input value="${target_id}" name="target_id" type="hidden"></input>  <input value="${mode}" name="mode" id="mode" type="hidden"></input>  <input id="file" name="file" size="35" type="file"></input>  <br></br>  <button value="upload" type="submit" class="button-upload" name="action">Importer</button>
        </form>
      </div>

    </div>
  </body>
</html>
