<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<stl:block xmlns="http://www.w3.org/1999/xhtml" xmlns:stl="http://www.hforge.org/xml-namespaces/stl">

  <fieldset stl:if="metadata">
    <legend>Modifier les métadonnées</legend>
    <table>
      <tr>
        <td><b>Auteur</b></td>
        <td>: ${metadata/author_name}</td>
      </tr>
      <tr>
        <td><b>Date</b></td>
        <td>: ${metadata/author_date}</td>
      </tr>
      <tr>
        <td><b>Message</b></td>
        <td>: ${metadata/subject}</td>
      </tr>
    </table>
  </fieldset>

  <div id="git-stat" stl:if="stat">
    <h3>Statistiques</h3>
    <p>${stat/summary}</p>
    <table id="browse-list">
      <thead>
        <tr>
          <th>Nom de fichier</th>
          <th>Lignes modifiées</th>
          <th>Avant</th>
          <th>Après</th>
        </tr>
      </thead>
      <tbody>
        <tr stl:repeat="row stat/table" class="${repeat/row/even}">
          <td><a href="#diff_${repeat/row/index}">${row/value}</a></td>
          <td>${row/nlines}</td>
          <td class="rem">${row/before}</td>
          <td class="add">${row/after}</td>
        </tr>
      </tbody>
    </table>
  </div>

  <div id="differ" stl:if="changes">
    <h3>Détails</h3>
    <stl:block stl:repeat="change changes">
      <div stl:if="change/is_header"><a name="diff_${change/index}"></a>${change/value}</div>
      <stl:block stl:if="not change/is_header">
        <span class="${change/css}">${change/value}</span><br></br>
      </stl:block>
    </stl:block>
  </div>

</stl:block>
