<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<stl:block xmlns:stl="http://www.hforge.org/xml-namespaces/stl" xmlns="http://www.w3.org/1999/xhtml">

  <table class="${css}" id="browse-list">
    <thead stl:if="columns">
      <tr>
        <stl:block stl:repeat="column columns">
          <!-- checkbox -->
          <th class="checkbox" stl:if="column/is_checkbox">
            <label for="browse-list-select-all">Tout sélectionner</label>
            <input title="Cliquez pour sélectionner/désélectionner toutes les lignes" type="checkbox" onclick="select_checkboxes('form-table', this.checked);" id="browse-list-select-all"></input>
          </th>
          <!-- checkbox -->
          <th stl:if="not column/is_checkbox">
            <a stl:if="column/href" href="${column/href}" class="sort-${column/order}">${column/title}</a>
          </th>
        </stl:block>
      </tr>
    </thead>
  </table>

  <form action="" id="form-table" name="browse_list" stl:omit-tag="not actions" method="post">
    <div id="browse-image">
      <a title="Retour" href="../;preview_content?size=${size}&amp;width=${width}&amp;height=${height}" stl:if="not root"><img src="/ui/icons/16x16/up.png"></img></a>
      <div stl:repeat="row rows" class="thumbnail size${size}">
        <div stl:omit-tag="not row/is_folder" class="folder">
          <a stl:omit-tag="not row/href" href="${row/href}">
            <img src="${row/name}/;thumb?width=${size}&amp;height=${size}&amp;fit=1&amp;lossy=0"></img>
          </a>
        </div>
        <p>
          <!-- checkbox -->
          <stl:block stl:if="row/checkbox">
            <input type="checkbox" id="id-${row/id}" class="checkbox" checked="${row/checked}" value="${row/id}" name="ids"></input>
          </stl:block>
          <stl:block stl:if="not row/checkbox">
            <label>${row/title_or_name}</label>
          </stl:block>
        </p>
      </div>
    </div>
    <p stl:if="actions">
      <stl:block stl:repeat="action actions">${action}</stl:block>
    </p>
  </form>

</stl:block>
