<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<stl:block xmlns:stl="http://www.hforge.org/xml-namespaces/stl" xmlns="http://www.w3.org/1999/xhtml">

  <fieldset stl:if="metadata">
    <legend>Change metadata</legend>
    <table>
      <tr>
        <td><b>Author</b></td>
        <td>: ${metadata/author_name}</td>
      </tr>
      <tr>
        <td><b>Date</b></td>
        <td>: ${metadata/author_date}</td>
      </tr>
      <tr>
        <td><b>Message</b></td>
        <td>: ${metadata/message_short}</td>
      </tr>
    </table>
  </fieldset>

  <div stl:if="stat" id="git-stat">
    <h3>Stat</h3>
    <p>${stat/summary}</p>
    <table id="browse-list">
      <thead>
        <tr>
          <th>Filename</th>
          <th>Lines Changed</th>
          <th>Before</th>
          <th>After</th>
        </tr>
      </thead>
      <tbody>
        <tr stl:repeat="row stat/table" class="${repeat/row/even}">
          <td><a href="#diff_${repeat/row/index}">${row/value}</a></td>
          <td align="right">${row/nlines}</td>
          <td class="rem">${row/before}</td>
          <td class="add">${row/after}</td>
        </tr>
      </tbody>
    </table>
  </div>

  <div stl:if="changes" id="differ">
    <h3>Details</h3>
    <stl:block stl:repeat="change changes">
      <div><a name="diff_${change/index}"></a>${change/header}</div>
      <pre stl:repeat="block change/blocks" class="${block/css}">${block/value}</pre>
    </stl:block>
  </div>

</stl:block>
