#!/usr/bin/env python
from Sequencer import Sequencer
from Blocks import Block
from os import sys
from optparse import OptionParser
from mingus.core import notes
import Bands

try:
	from mingus.extra import fluidsynth
except:
	print "Couldn't load the music library mingus."
	print "A download is available at http://mingus.googlecode.com/"
	sys.exit(1)

def get_available_bands():
	return [x for x in Bands.__dict__ if \
		type(getattr(Bands, x)) == type([])]

if __name__ == '__main__':

	parser = OptionParser()
	parser.add_option("-b", "--bpm", dest="bpm", type="int",
		help="Set the bpm to start with.")
	parser.add_option("-d", "--duration", dest="duration", type="int",
		help="Set the number of times the progression should be repeated.")
	parser.add_option("-e", "--ensemble", dest="ensemble", 
		metavar="EN", help="Set the ensemble")
	parser.add_option("-f", "--frontend", dest="frontend", 
		metavar="F", help="Choose front-end [blocks, lines, mixed]")
	parser.add_option("-l", "--list", action="store_true", 
		dest="list_bands", default=False, 
		help="List available ensembles. Don't play.")
	parser.add_option("-k", "--key", dest="key",
		help="Set the key to start in.")
	parser.add_option("-q", "--quiet", action="store_false",
		dest="verbose")
	parser.add_option("-s", "--swing", action="store_true",
		dest="swing", default=False, help="Set swing")
	parser.add_option("-v", "--verbose", action="store_true", 
		dest="verbose", default=True)
	parser.add_option("-w", "--wildness", type="float", dest="wild",
		help="Floating point number indicating wildness")

	(options, args) = parser.parse_args()


	visual = None
	block = Block()
	block.swing = options.swing

	if options.frontend == "blocks":
		from Visualizations import PygameBlockVisualization
		visual = PygameBlockVisualization(400,400)
	elif options.frontend == "lines":
		from Visualizations import PygameLineVisualization
		visual = PygameLineVisualization(400,400)
	elif options.frontend == "mixed":
		from Visualizations import PygameMixedVisualizations
		visual = PygameMixedVisualizations(400,400)

	if options.list_bands:
		i = 1
		for x in get_available_bands():
			print "%d. %s" % (i, x)
			i += 1
		sys.exit(0)

	if options.ensemble != None:
		if options.ensemble in get_available_bands():
			block.instruments = getattr(Bands, options.ensemble)
		else:
			if options.verbose:
				print "Unknown ensemble:", options.ensemble



	if options.key != None:
		if notes.is_valid_note(options.key):
			block.key = options.key
		else:
			if options.verbose:
				print "Invalid key:", options.key

	if options.bpm != None:
		block.bpm = options.bpm

	if options.duration != None:
		block.duration = options.duration

	if options.wild != None:
		block.wildness = options.wild

	if not fluidsynth.init_fluidsynth():
		print "No running fluidsynth server found at port 9800."
		sys.exit(1)

	seq = Sequencer(block)
	seq.verbose = options.verbose
	if visual != None:
		seq.paint_function = visual.paint_screen
		seq.refresh_function = visual.refresh_screen
		seq.update_function = visual.update_screen
	seq.play()
