from Blocks import Block
import Progressions
import Bands
import Blocks
import Movements
from Movements import Movement
from Instrument import Instrument
from optparse import OptionParser
from os import sys
from mingus.core import diatonic
from Sequencer import Sequencer

def get_available_bands():
	return [x for x in Bands.__dict__ if \
		type(getattr(Bands, x)) == type([])]

def get_available_progressions():
	return [x for x in Progressions.__dict__ if \
		type(getattr(Progressions, x)) == type([]) and \
		x[0] != "_"]

def get_available_instruments():
	return [x for x in Bands.__dict__ if \
		type(getattr(Bands, x)) == type(Instrument) and \
		issubclass(getattr(Bands,x), Instrument)]


def get_available_blocks():
	return [x for x in Blocks.__dict__ if \
		type(getattr(Blocks, x)) == type(Block) and \
		issubclass(getattr(Blocks,x), Block)]


def get_available_movements():
	return [x for x in Movements.__dict__ if \
		type(getattr(Movements,x)) == type(Movement) and \
		issubclass(getattr(Movements, x), Movement)]


def check_options(test, test_func, test_str, module):
	"""Returns test in module if it can be found in the list or \
iterator generated by test_func. """

	if test != None:
		if test in test_func():
			return getattr(module, test)
		else:
			print "Unknown %s:" % test_str, test
			return False
	return False


def get_options():
	parser = OptionParser()
	parser.add_option("-b", "--bpm", dest="bpm", type="int",
		default=120,help="Set the bpm to start with.")

	parser.add_option("--blocks", dest="blocks", 
		help="Set blocks separated by comma.")

	parser.add_option("-d", "--duration", dest="duration", type="int",
		help="Set the number of times the progression should be \
		repeated.", default=1)

	parser.add_option("-e", "--ensemble", dest="ensemble", 
		metavar="EN", help="Set the ensemble")

	parser.add_option("-f", "--frontend", dest="frontend", 
		metavar="F", help="Choose front-end [blocks, lines, mixed]")
	parser.add_option("--height", dest='height', type='int',
		default=400, help='Height of the visualization screen')

	parser.add_option("-i", "--instruments", 
		help="Specify instruments separated by comma.", 
		dest="instrument")

	parser.add_option("-k", "--key", dest="key", default='C',
		help="Set the default key.")

	parser.add_option("-l", "--list", dest="list", 
		help="List [blocks, ensembles, progressions, \
		instruments, movements]. Don't play.")

	parser.add_option("-m", "--movement", dest="movement",
		help="Set the movement.")

	parser.add_option("-n", "--no-fluidsynth", dest="no_fluidsynth",
		action="store_true", default=False, 
		help="Don't connect to a fluidsynth server, \
		just write the midi file."),

	parser.add_option("-o", "--output-file", dest="midifile", 
		help="The file to write the midi to.", 
		default="improviser.mid"),

	parser.add_option("-p", "--progression", 
		dest="progression", help="Set the progression.")

	parser.add_option("-r", "--resolution", dest="resolution",
		default=8, type="int", help="The resolution \
		[1,2,4,8,16,32,etc]")

	parser.add_option("-q", "--quiet", action="store_false",
		dest="verbose", default=True, 
		help="Don't output to stdout")

	parser.add_option("-s", "--swing", action="store_true",
		dest="swing", default=False, help="Set swing")

	parser.add_option("--sf2", dest="SF2", default="default.sf2", 
		help="The soundfont to load.")

	parser.add_option("-w", "--wildness", type="float", dest="wild",
		help="Floating point number indicating wildness",
		default=0.5)

	parser.add_option("--width", dest="width", default=400,
		type="int", help="Width of the visualization screen")

	return parser.parse_args()


def get_movement(options):
	b = check_options(options.movement, get_available_movements, 
		"movement", Movements)
	if b != False:
		movement = b()
	else:
		movement = Movement()
	movement.swing = options.swing
	movement.default_resolution = options.resolution
	movement.default_bpm = options.bpm
	movement.default_wildness = options.wild
	if options.key in diatonic.basic_keys:
		movement.default_key = options.key
	return movement

def get_blocks(options):
	res = []
	for block in options.blocks.split(","):
		b = check_options(block, get_available_blocks, 
			"block", Blocks)
		if b != False:
			block = b()
			block.swing = options.swing
			block.resolution = options.resolution
			res.append(block)
		else:
			sys.exit(1)
	if res == []:
		b = Block()
		b.swing = options.swing
		b.resolution = options.resolution
		res = [b]
	return res

def get_visualization(options):
	w = options.width
	h = options.height

	if options.frontend == "blocks":
		from Visualizations import PygameBlockVisualization
		visual = PygameBlockVisualization(w,h)
	elif options.frontend == "lines":
		from Visualizations import PygameLineVisualization
		visual = PygameLineVisualization(w,h)
	elif options.frontend == "mixed":
		from Visualizations import PygameMixedVisualizations
		visual = PygameMixedVisualizations(w,h)
	else:
		from Visualizations import DefaultVisualization
		visual = DefaultVisualization()

	return visual

def list_arguments(options):

	if options.list != None:
		if options.list == "ensembles" or \
			options.list[0] == 'e':
			i = 1
			for x in get_available_bands():
				print "%d. %s" % (i, x)
				i += 1
		elif options.list == "progressions" or\
			options.list[0] == 'p':
			i = 1
			for x in get_available_progressions():
				print "%d. %s" % (i, x)
				i += 1
		elif options.list == "instruments" or\
			options.list[0] == 'i':
			i = 1
			for x in get_available_instruments():
				print "%d. %s" % (i, x)
				i += 1
		elif options.list == "blocks" or\
			options.list[0] == 'b':
			i = 1
			for x in get_available_blocks():
				print "%d. %s" % (i, x)
				i += 1
		elif options.list == "movements" or\
			options.list[0] == 'm':
			i = 1
			for x in get_available_movements():
				print "%d. %s" % (i, x)
				i += 1
		else:
			print "Unknown list", options.list
		sys.exit(0)


def set_ensemble(options, block):
	b = check_options(options.ensemble, get_available_bands, 
			"ensemble", Bands)
	if b != False:
		block.instruments = b

def set_progression(options, block):
	b = check_options(options.progression, get_available_progressions,
			"progression", Progressions)
	if b != False:
		block.progressions = b

def set_instrument(options, block):

	if options.instrument != None:
		c = 1
		for inst in options.instrument.split(","):
			if inst in get_available_instruments():
				i = getattr(Musicians, inst)
				i = i({'channel': c, 'start': 0})
				c += 1
				block.instruments += [i]
			else:
				if options.verbose:
					print "Unknown instrument:", inst
					sys.exit(1)

def set_misc_options(options, block):

	if options.key in diatonic.basic_keys:
		block.key = options.key
	else:
		if options.verbose:
			print "Invalid key:", options.key
			sys.exit(1)

	block.bpm = options.bpm
	block.duration = options.duration
	block.wildness = options.wild

def load_fluidsynth(options):
	if not options.no_fluidsynth:
		try:
			from mingus.midi import fluidsynth
		except:
			print "Couldn't load the music library mingus."
			print "A download is available at http://mingus.googlecode.com/"
			sys.exit(1)
		if not fluidsynth.init(options.SF2):
			print "Couldn't load '%s', quiting. Use the --sf2 option to set the soundfont." % options.SF2
			sys.exit(1)

def get_sequencer():

	options, args = get_options()
	movement = get_movement(options)
	blocks = get_blocks(options)
	visual = get_visualization(options)
	list_arguments(options)

	for block in blocks:
		set_ensemble(options, block)
		set_progression(options, block)
		set_instrument(options,block)
		set_misc_options(options,block)
		movement.add_block(block)

	load_fluidsynth(options)


	if block.instruments == []:
		print "No instruments or ensemble selected."
		sys.exit(1)

	for x in block.instruments:
		x.no_fluidsynth = options.no_fluidsynth

	seq = Sequencer(movement)
	seq.verbose = options.verbose
	seq.no_fluidsynth = options.no_fluidsynth
	seq.output_file = options.midifile
	if visual != None:
		seq.paint_function = visual.paint_screen
		seq.refresh_function = visual.refresh_screen
		seq.update_function = visual.update_screen
	return seq
