ctca2_to_ctn = {   'AF': 'Africa',
    'AN': 'Antarctica',
    'AS': 'Asia',
    'EU': 'Europe',
    'NA': 'North America',
    'OC': 'Oceania',
    'SA': 'South America'}

ctn_to_ctca2 = {   'Africa': 'AF',
    'Antarctica': 'AN',
    'Asia': 'AS',
    'Europe': 'EU',
    'North America': 'NA',
    'Oceania': 'OC',
    'South America': 'SA'}

ccn_to_cca2 = {   '004': 'AF',
    '008': 'AL',
    '010': 'AQ',
    '012': 'DZ',
    '016': 'AS',
    '020': 'AD',
    '024': 'AO',
    '028': 'AG',
    '031': 'AZ',
    '032': 'AR',
    '036': 'AU',
    '040': 'AT',
    '044': 'BS',
    '048': 'BH',
    '050': 'BD',
    '051': 'AM',
    '052': 'BB',
    '056': 'BE',
    '060': 'BM',
    '064': 'BT',
    '068': 'BO',
    '070': 'BA',
    '072': 'BW',
    '074': 'BV',
    '076': 'BR',
    '084': 'BZ',
    '086': 'IO',
    '090': 'SB',
    '092': 'VG',
    '096': 'BN',
    '100': 'BG',
    '104': 'MM',
    '108': 'BI',
    '112': 'BY',
    '116': 'KH',
    '120': 'CM',
    '124': 'CA',
    '132': 'CV',
    '136': 'KY',
    '140': 'CF',
    '144': 'LK',
    '148': 'TD',
    '152': 'CL',
    '156': 'CN',
    '158': 'TW',
    '162': 'CX',
    '166': 'CC',
    '170': 'CO',
    '174': 'KM',
    '175': 'YT',
    '178': 'CG',
    '180': 'CD',
    '184': 'CK',
    '188': 'CR',
    '191': 'HR',
    '192': 'CU',
    '196': 'CY',
    '203': 'CZ',
    '204': 'BJ',
    '208': 'DK',
    '212': 'DM',
    '214': 'DO',
    '218': 'EC',
    '222': 'SV',
    '226': 'GQ',
    '231': 'ET',
    '232': 'ER',
    '233': 'EE',
    '234': 'FO',
    '238': 'FK',
    '239': 'GS',
    '242': 'FJ',
    '246': 'FI',
    '248': 'AX',
    '250': 'FR',
    '254': 'GF',
    '258': 'PF',
    '260': 'TF',
    '262': 'DJ',
    '266': 'GA',
    '268': 'GE',
    '270': 'GM',
    '275': 'PS',
    '276': 'DE',
    '288': 'GH',
    '292': 'GI',
    '296': 'KI',
    '300': 'GR',
    '304': 'GL',
    '308': 'GD',
    '312': 'GP',
    '316': 'GU',
    '320': 'GT',
    '324': 'GN',
    '328': 'GY',
    '332': 'HT',
    '334': 'HM',
    '336': 'VA',
    '340': 'HN',
    '344': 'HK',
    '348': 'HU',
    '352': 'IS',
    '356': 'IN',
    '360': 'ID',
    '364': 'IR',
    '368': 'IQ',
    '372': 'IE',
    '376': 'IL',
    '380': 'IT',
    '384': 'CI',
    '388': 'JM',
    '392': 'JP',
    '398': 'KZ',
    '400': 'JO',
    '404': 'KE',
    '408': 'KP',
    '410': 'KR',
    '414': 'KW',
    '417': 'KG',
    '418': 'LA',
    '422': 'LB',
    '426': 'LS',
    '428': 'LV',
    '430': 'LR',
    '434': 'LY',
    '438': 'LI',
    '440': 'LT',
    '442': 'LU',
    '446': 'MO',
    '450': 'MG',
    '454': 'MW',
    '458': 'MY',
    '462': 'MV',
    '466': 'ML',
    '470': 'MT',
    '474': 'MQ',
    '478': 'MR',
    '480': 'MU',
    '484': 'MX',
    '492': 'MC',
    '496': 'MN',
    '498': 'MD',
    '499': 'ME',
    '500': 'MS',
    '504': 'MA',
    '508': 'MZ',
    '512': 'OM',
    '516': 'NA',
    '520': 'NR',
    '524': 'NP',
    '528': 'NL',
    '530': 'AN',
    '533': 'AW',
    '540': 'NC',
    '548': 'VU',
    '554': 'NZ',
    '558': 'NI',
    '562': 'NE',
    '566': 'NG',
    '570': 'NU',
    '574': 'NF',
    '578': 'NO',
    '580': 'MP',
    '581': 'UM',
    '583': 'FM',
    '584': 'MH',
    '585': 'PW',
    '586': 'PK',
    '591': 'PA',
    '598': 'PG',
    '600': 'PY',
    '604': 'PE',
    '608': 'PH',
    '612': 'PN',
    '616': 'PL',
    '620': 'PT',
    '624': 'GW',
    '626': 'TL',
    '630': 'PR',
    '634': 'QA',
    '638': 'RE',
    '642': 'RO',
    '643': 'RU',
    '646': 'RW',
    '652': 'BL',
    '654': 'SH',
    '659': 'KN',
    '660': 'AI',
    '662': 'LC',
    '663': 'MF',
    '666': 'PM',
    '670': 'VC',
    '674': 'SM',
    '678': 'ST',
    '682': 'SA',
    '686': 'SN',
    '688': 'RS',
    '690': 'SC',
    '694': 'SL',
    '702': 'SG',
    '703': 'SK',
    '704': 'VN',
    '705': 'SI',
    '706': 'SO',
    '710': 'ZA',
    '716': 'ZW',
    '724': 'ES',
    '732': 'EH',
    '736': 'SD',
    '740': 'SR',
    '744': 'SJ',
    '748': 'SZ',
    '752': 'SE',
    '756': 'CH',
    '760': 'SY',
    '762': 'TJ',
    '764': 'TH',
    '768': 'TG',
    '772': 'TK',
    '776': 'TO',
    '780': 'TT',
    '784': 'AE',
    '788': 'TN',
    '792': 'TR',
    '795': 'TM',
    '796': 'TC',
    '798': 'TV',
    '800': 'UG',
    '804': 'UA',
    '807': 'MK',
    '818': 'EG',
    '826': 'GB',
    '831': 'GG',
    '832': 'JE',
    '833': 'IM',
    '834': 'TZ',
    '840': 'US',
    '850': 'VI',
    '854': 'BF',
    '858': 'UY',
    '860': 'UZ',
    '862': 'VE',
    '876': 'WF',
    '882': 'WS',
    '887': 'YE',
    '894': 'ZM'}

ccn_to_cca3 = {   '004': 'AFG',
    '008': 'ALB',
    '010': 'ATA',
    '012': 'DZA',
    '016': 'ASM',
    '020': 'AND',
    '024': 'AGO',
    '028': 'ATG',
    '031': 'AZE',
    '032': 'ARG',
    '036': 'AUS',
    '040': 'AUT',
    '044': 'BHS',
    '048': 'BHR',
    '050': 'BGD',
    '051': 'ARM',
    '052': 'BRB',
    '056': 'BEL',
    '060': 'BMU',
    '064': 'BTN',
    '068': 'BOL',
    '070': 'BIH',
    '072': 'BWA',
    '074': 'BVT',
    '076': 'BRA',
    '084': 'BLZ',
    '086': 'IOT',
    '090': 'SLB',
    '092': 'VGB',
    '096': 'BRN',
    '100': 'BGR',
    '104': 'MMR',
    '108': 'BDI',
    '112': 'BLR',
    '116': 'KHM',
    '120': 'CMR',
    '124': 'CAN',
    '132': 'CPV',
    '136': 'CYM',
    '140': 'CAF',
    '144': 'LKA',
    '148': 'TCD',
    '152': 'CHL',
    '156': 'CHN',
    '158': 'TWN',
    '162': 'CXR',
    '166': 'CCK',
    '170': 'COL',
    '174': 'COM',
    '175': 'MYT',
    '178': 'COG',
    '180': 'COD',
    '184': 'COK',
    '188': 'CRI',
    '191': 'HRV',
    '192': 'CUB',
    '196': 'CYP',
    '203': 'CZE',
    '204': 'BEN',
    '208': 'DNK',
    '212': 'DMA',
    '214': 'DOM',
    '218': 'ECU',
    '222': 'SLV',
    '226': 'GNQ',
    '231': 'ETH',
    '232': 'ERI',
    '233': 'EST',
    '234': 'FRO',
    '238': 'FLK',
    '239': 'SGS',
    '242': 'FJI',
    '246': 'FIN',
    '248': 'ALA',
    '250': 'FRA',
    '254': 'GUF',
    '258': 'PYF',
    '260': 'ATF',
    '262': 'DJI',
    '266': 'GAB',
    '268': 'GEO',
    '270': 'GMB',
    '275': 'PSE',
    '276': 'DEU',
    '288': 'GHA',
    '292': 'GIB',
    '296': 'KIR',
    '300': 'GRC',
    '304': 'GRL',
    '308': 'GRD',
    '312': 'GLP',
    '316': 'GUM',
    '320': 'GTM',
    '324': 'GIN',
    '328': 'GUY',
    '332': 'HTI',
    '334': 'HMD',
    '336': 'VAT',
    '340': 'HND',
    '344': 'HKG',
    '348': 'HUN',
    '352': 'ISL',
    '356': 'IND',
    '360': 'IDN',
    '364': 'IRN',
    '368': 'IRQ',
    '372': 'IRL',
    '376': 'ISR',
    '380': 'ITA',
    '384': 'CIV',
    '388': 'JAM',
    '392': 'JPN',
    '398': 'KAZ',
    '400': 'JOR',
    '404': 'KEN',
    '408': 'PRK',
    '410': 'KOR',
    '414': 'KWT',
    '417': 'KGZ',
    '418': 'LAO',
    '422': 'LBN',
    '426': 'LSO',
    '428': 'LVA',
    '430': 'LBR',
    '434': 'LBY',
    '438': 'LIE',
    '440': 'LTU',
    '442': 'LUX',
    '446': 'MAC',
    '450': 'MDG',
    '454': 'MWI',
    '458': 'MYS',
    '462': 'MDV',
    '466': 'MLI',
    '470': 'MLT',
    '474': 'MTQ',
    '478': 'MRT',
    '480': 'MUS',
    '484': 'MEX',
    '492': 'MCO',
    '496': 'MNG',
    '498': 'MDA',
    '499': 'MNE',
    '500': 'MSR',
    '504': 'MAR',
    '508': 'MOZ',
    '512': 'OMN',
    '516': 'NAM',
    '520': 'NRU',
    '524': 'NPL',
    '528': 'NLD',
    '530': 'ANT',
    '533': 'ABW',
    '540': 'NCL',
    '548': 'VUT',
    '554': 'NZL',
    '558': 'NIC',
    '562': 'NER',
    '566': 'NGA',
    '570': 'NIU',
    '574': 'NFK',
    '578': 'NOR',
    '580': 'MNP',
    '581': 'UMI',
    '583': 'FSM',
    '584': 'MHL',
    '585': 'PLW',
    '586': 'PAK',
    '591': 'PAN',
    '598': 'PNG',
    '600': 'PRY',
    '604': 'PER',
    '608': 'PHL',
    '612': 'PCN',
    '616': 'POL',
    '620': 'PRT',
    '624': 'GNB',
    '626': 'TLS',
    '630': 'PRI',
    '634': 'QAT',
    '638': 'REU',
    '642': 'ROU',
    '643': 'RUS',
    '646': 'RWA',
    '652': 'BLM',
    '654': 'SHN',
    '659': 'KNA',
    '660': 'AIA',
    '662': 'LCA',
    '663': 'MAF',
    '666': 'SPM',
    '670': 'VCT',
    '674': 'SMR',
    '678': 'STP',
    '682': 'SAU',
    '686': 'SEN',
    '688': 'SRB',
    '690': 'SYC',
    '694': 'SLE',
    '702': 'SGP',
    '703': 'SVK',
    '704': 'VNM',
    '705': 'SVN',
    '706': 'SOM',
    '710': 'ZAF',
    '716': 'ZWE',
    '724': 'ESP',
    '732': 'ESH',
    '736': 'SDN',
    '740': 'SUR',
    '744': 'SJM',
    '748': 'SWZ',
    '752': 'SWE',
    '756': 'CHE',
    '760': 'SYR',
    '762': 'TJK',
    '764': 'THA',
    '768': 'TGO',
    '772': 'TKL',
    '776': 'TON',
    '780': 'TTO',
    '784': 'ARE',
    '788': 'TUN',
    '792': 'TUR',
    '795': 'TKM',
    '796': 'TCA',
    '798': 'TUV',
    '800': 'UGA',
    '804': 'UKR',
    '807': 'MKD',
    '818': 'EGY',
    '826': 'GBR',
    '831': 'GGY',
    '832': 'JEY',
    '833': 'IMN',
    '834': 'TZA',
    '840': 'USA',
    '850': 'VIR',
    '854': 'BFA',
    '858': 'URY',
    '860': 'UZB',
    '862': 'VEN',
    '876': 'WLF',
    '882': 'WSM',
    '887': 'YEM',
    '894': 'ZMB'}

ccn_to_cn = {   '004': 'Afghanistan',
    '008': 'Albania',
    '010': 'Antarctica (the territory South of 60 deg S)',
    '012': 'Algeria',
    '016': 'American Samoa',
    '020': 'Andorra',
    '024': 'Angola',
    '028': 'Antigua and Barbuda',
    '031': 'Azerbaijan',
    '032': 'Argentina',
    '036': 'Australia',
    '040': 'Austria',
    '044': 'Bahamas',
    '048': 'Bahrain',
    '050': 'Bangladesh',
    '051': 'Armenia',
    '052': 'Barbados',
    '056': 'Belgium',
    '060': 'Bermuda',
    '064': 'Bhutan',
    '068': 'Bolivia',
    '070': 'Bosnia and Herzegovina',
    '072': 'Botswana',
    '074': 'Bouvet Island (Bouvetoya)',
    '076': 'Brazil',
    '084': 'Belize',
    '086': 'British Indian Ocean Territory (Chagos Archipelago)',
    '090': 'Solomon Islands',
    '092': 'British Virgin Islands',
    '096': 'Brunei Darussalam',
    '100': 'Bulgaria',
    '104': 'Myanmar',
    '108': 'Burundi',
    '112': 'Belarus',
    '116': 'Cambodia',
    '120': 'Cameroon',
    '124': 'Canada',
    '132': 'Cape Verde',
    '136': 'Cayman Islands',
    '140': 'Central African Republic',
    '144': 'Sri Lanka',
    '148': 'Chad',
    '152': 'Chile',
    '156': 'China',
    '158': 'Taiwan',
    '162': 'Christmas Island',
    '166': 'Cocos (Keeling) Islands',
    '170': 'Colombia',
    '174': 'Comoros',
    '175': 'Mayotte',
    '178': 'Congo',
    '180': 'Congo',
    '184': 'Cook Islands',
    '188': 'Costa Rica',
    '191': 'Croatia',
    '192': 'Cuba',
    '196': 'Cyprus',
    '203': 'Czech Republic',
    '204': 'Benin',
    '208': 'Denmark',
    '212': 'Dominica',
    '214': 'Dominican Republic',
    '218': 'Ecuador',
    '222': 'El Salvador',
    '226': 'Equatorial Guinea',
    '231': 'Ethiopia',
    '232': 'Eritrea',
    '233': 'Estonia',
    '234': 'Faroe Islands',
    '238': 'Falkland Islands (Malvinas)',
    '239': 'South Georgia and the South Sandwich Islands',
    '242': 'Fiji',
    '246': 'Finland',
    '248': '\xc3\x85land Islands',
    '250': 'France',
    '254': 'French Guiana',
    '258': 'French Polynesia',
    '260': 'French Southern Territories',
    '262': 'Djibouti',
    '266': 'Gabon',
    '268': 'Georgia',
    '270': 'Gambia',
    '275': 'Palestinian Territory',
    '276': 'Germany',
    '288': 'Ghana',
    '292': 'Gibraltar',
    '296': 'Kiribati',
    '300': 'Greece',
    '304': 'Greenland',
    '308': 'Grenada',
    '312': 'Guadeloupe',
    '316': 'Guam',
    '320': 'Guatemala',
    '324': 'Guinea',
    '328': 'Guyana',
    '332': 'Haiti',
    '334': 'Heard Island and McDonald Islands',
    '336': 'Holy See (Vatican City State)',
    '340': 'Honduras',
    '344': 'Hong Kong',
    '348': 'Hungary',
    '352': 'Iceland',
    '356': 'India',
    '360': 'Indonesia',
    '364': 'Iran',
    '368': 'Iraq',
    '372': 'Ireland',
    '376': 'Israel',
    '380': 'Italy',
    '384': "Cote d'Ivoire",
    '388': 'Jamaica',
    '392': 'Japan',
    '398': 'Kazakhstan',
    '400': 'Jordan',
    '404': 'Kenya',
    '408': 'Korea',
    '410': 'Korea',
    '414': 'Kuwait',
    '417': 'Kyrgyz Republic',
    '418': "Lao People's Democratic Republic",
    '422': 'Lebanon',
    '426': 'Lesotho',
    '428': 'Latvia',
    '430': 'Liberia',
    '434': 'Libyan Arab Jamahiriya',
    '438': 'Liechtenstein',
    '440': 'Lithuania',
    '442': 'Luxembourg',
    '446': 'Macao',
    '450': 'Madagascar',
    '454': 'Malawi',
    '458': 'Malaysia',
    '462': 'Maldives',
    '466': 'Mali',
    '470': 'Malta',
    '474': 'Martinique',
    '478': 'Mauritania',
    '480': 'Mauritius',
    '484': 'Mexico',
    '492': 'Monaco',
    '496': 'Mongolia',
    '498': 'Moldova',
    '499': 'Montenegro',
    '500': 'Montserrat',
    '504': 'Morocco',
    '508': 'Mozambique',
    '512': 'Oman',
    '516': 'Namibia',
    '520': 'Nauru',
    '524': 'Nepal',
    '528': 'Netherlands',
    '530': 'Netherlands Antilles',
    '533': 'Aruba',
    '540': 'New Caledonia',
    '548': 'Vanuatu',
    '554': 'New Zealand',
    '558': 'Nicaragua',
    '562': 'Niger',
    '566': 'Nigeria',
    '570': 'Niue',
    '574': 'Norfolk Island',
    '578': 'Norway',
    '580': 'Northern Mariana Islands',
    '581': 'United States Minor Outlying Islands',
    '583': 'Micronesia',
    '584': 'Marshall Islands',
    '585': 'Palau',
    '586': 'Pakistan',
    '591': 'Panama',
    '598': 'Papua New Guinea',
    '600': 'Paraguay',
    '604': 'Peru',
    '608': 'Philippines',
    '612': 'Pitcairn Islands',
    '616': 'Poland',
    '620': 'Portugal',
    '624': 'Guinea-Bissau',
    '626': 'Timor-Leste',
    '630': 'Puerto Rico',
    '634': 'Qatar',
    '638': 'Reunion',
    '642': 'Romania',
    '643': 'Russian Federation',
    '646': 'Rwanda',
    '652': 'Saint Barthelemy',
    '654': 'Saint Helena',
    '659': 'Saint Kitts and Nevis',
    '660': 'Anguilla',
    '662': 'Saint Lucia',
    '663': 'Saint Martin',
    '666': 'Saint Pierre and Miquelon',
    '670': 'Saint Vincent and the Grenadines',
    '674': 'San Marino',
    '678': 'Sao Tome and Principe',
    '682': 'Saudi Arabia',
    '686': 'Senegal',
    '688': 'Serbia',
    '690': 'Seychelles',
    '694': 'Sierra Leone',
    '702': 'Singapore',
    '703': 'Slovakia (Slovak Republic)',
    '704': 'Vietnam',
    '705': 'Slovenia',
    '706': 'Somalia',
    '710': 'South Africa',
    '716': 'Zimbabwe',
    '724': 'Spain',
    '732': 'Western Sahara',
    '736': 'Sudan',
    '740': 'Suriname',
    '744': 'Svalbard & Jan Mayen Islands',
    '748': 'Swaziland',
    '752': 'Sweden',
    '756': 'Switzerland',
    '760': 'Syrian Arab Republic',
    '762': 'Tajikistan',
    '764': 'Thailand',
    '768': 'Togo',
    '772': 'Tokelau',
    '776': 'Tonga',
    '780': 'Trinidad and Tobago',
    '784': 'United Arab Emirates',
    '788': 'Tunisia',
    '792': 'Turkey',
    '795': 'Turkmenistan',
    '796': 'Turks and Caicos Islands',
    '798': 'Tuvalu',
    '800': 'Uganda',
    '804': 'Ukraine',
    '807': 'Macedonia',
    '818': 'Egypt',
    '826': 'United Kingdom of Great Britain & Northern Ireland',
    '831': 'Guernsey',
    '832': 'Jersey',
    '833': 'Isle of Man',
    '834': 'Tanzania',
    '840': 'United States of America',
    '850': 'United States Virgin Islands',
    '854': 'Burkina Faso',
    '858': 'Uruguay',
    '860': 'Uzbekistan',
    '862': 'Venezuela',
    '876': 'Wallis and Futuna',
    '882': 'Samoa',
    '887': 'Yemen',
    '894': 'Zambia'}

ccn_to_con = {   '004': 'Islamic Republic of Afghanistan',
    '008': 'Republic of Albania',
    '010': 'Antarctica (the territory South of 60 deg S)',
    '012': "People's Democratic Republic of Algeria",
    '016': 'American Samoa',
    '020': 'Principality of Andorra',
    '024': 'Republic of Angola',
    '028': 'Antigua and Barbuda',
    '031': 'Republic of Azerbaijan',
    '032': 'Argentine Republic Argentina',
    '036': 'Commonwealth of Australia',
    '040': 'Republic of Austria',
    '044': 'Commonwealth of the Bahamas',
    '048': 'Kingdom of Bahrain',
    '050': "People's Republic of Bangladesh",
    '051': 'Republic of Armenia',
    '052': 'Barbados',
    '056': 'Kingdom of Belgium',
    '060': 'Bermuda',
    '064': 'Kingdom of Bhutan',
    '068': 'Republic of Bolivia',
    '070': 'Bosnia and Herzegovina',
    '072': 'Republic of Botswana',
    '074': 'Bouvet Island (Bouvetoya)',
    '076': 'Federative Republic of Brazil',
    '084': 'Belize',
    '086': 'British Indian Ocean Territory (Chagos Archipelago)',
    '090': 'Solomon Islands',
    '092': 'British Virgin Islands',
    '096': 'Brunei Darussalam',
    '100': 'Republic of Bulgaria',
    '104': 'Union of Myanmar',
    '108': 'Republic of Burundi',
    '112': 'Republic of Belarus',
    '116': 'Kingdom of Cambodia',
    '120': 'Republic of Cameroon',
    '124': 'Canada',
    '132': 'Republic of Cape Verde',
    '136': 'Cayman Islands',
    '140': 'Central African Republic',
    '144': 'Democratic Socialist Republic of Sri Lanka',
    '148': 'Republic of Chad',
    '152': 'Republic of Chile',
    '156': "People's Republic of China",
    '158': 'Taiwan',
    '162': 'Christmas Island',
    '166': 'Cocos (Keeling) Islands',
    '170': 'Republic of Colombia',
    '174': 'Union of the Comoros',
    '175': 'Mayotte',
    '178': 'Republic of the Congo',
    '180': 'Democratic Republic of the Congo',
    '184': 'Cook Islands',
    '188': 'Republic of Costa Rica',
    '191': 'Republic of Croatia',
    '192': 'Republic of Cuba',
    '196': 'Republic of Cyprus',
    '203': 'Czech Republic',
    '204': 'Republic of Benin',
    '208': 'Kingdom of Denmark',
    '212': 'Commonwealth of Dominica',
    '214': 'Dominican Republic',
    '218': 'Republic of Ecuador',
    '222': 'Republic of El Salvador',
    '226': 'Republic of Equatorial Guinea',
    '231': 'Federal Democratic Republic of Ethiopia',
    '232': 'State of Eritrea',
    '233': 'Republic of Estonia',
    '234': 'Faroe Islands',
    '238': 'Falkland Islands (Malvinas)',
    '239': 'South Georgia and the South Sandwich Islands',
    '242': 'Republic of the Fiji Islands Fiji',
    '246': 'Republic of Finland',
    '248': '\xc3\x85land Islands',
    '250': 'French Republic France',
    '254': 'French Guiana',
    '258': 'French Polynesia',
    '260': 'French Southern Territories',
    '262': 'Republic of Djibouti',
    '266': 'Gabonese Republic Gabon',
    '268': 'Georgia',
    '270': 'Republic of the Gambia',
    '275': 'Occupied Palestinian Territory',
    '276': 'Federal Republic of Germany',
    '288': 'Republic of Ghana',
    '292': 'Gibraltar',
    '296': 'Republic of Kiribati',
    '300': 'Hellenic Republic Greece',
    '304': 'Greenland',
    '308': 'Grenada',
    '312': 'Guadeloupe',
    '316': 'Guam',
    '320': 'Republic of Guatemala',
    '324': 'Republic of Guinea',
    '328': 'Co-operative Republic of Guyana',
    '332': 'Republic of Haiti',
    '334': 'Heard Island and McDonald Islands',
    '336': 'Holy See (Vatican City State)',
    '340': 'Republic of Honduras',
    '344': 'Special Administrative Region of China Hong Kong',
    '348': 'Republic of Hungary',
    '352': 'Republic of Iceland',
    '356': 'Republic of India',
    '360': 'Republic of Indonesia',
    '364': 'Islamic Republic of Iran',
    '368': 'Republic of Iraq',
    '372': 'Ireland',
    '376': 'State of Israel',
    '380': 'Italian Republic Italy',
    '384': "Republic of Cote d'Ivoire",
    '388': 'Jamaica',
    '392': 'Japan',
    '398': 'Republic of Kazakhstan',
    '400': 'Hashemite Kingdom of Jordan',
    '404': 'Republic of Kenya',
    '408': "Democratic People's Republic of Korea",
    '410': 'Republic of Korea',
    '414': 'State of Kuwait',
    '417': 'Kyrgyz Republic',
    '418': "Lao People's Democratic Republic",
    '422': 'Lebanese Republic Lebanon',
    '426': 'Kingdom of Lesotho',
    '428': 'Republic of Latvia',
    '430': 'Republic of Liberia',
    '434': 'Libyan Arab Jamahiriya',
    '438': 'Principality of Liechtenstein',
    '440': 'Republic of Lithuania',
    '442': 'Grand Duchy of Luxembourg',
    '446': 'Special Administrative Region of China Macao',
    '450': 'Republic of Madagascar',
    '454': 'Republic of Malawi',
    '458': 'Malaysia',
    '462': 'Republic of Maldives',
    '466': 'Republic of Mali',
    '470': 'Republic of Malta',
    '474': 'Martinique',
    '478': 'Islamic Republic of Mauritania',
    '480': 'Republic of Mauritius',
    '484': 'United Mexican States Mexico',
    '492': 'Principality of Monaco',
    '496': 'Mongolia',
    '498': 'Republic of Moldova',
    '499': 'Republic of Montenegro',
    '500': 'Montserrat',
    '504': 'Kingdom of Morocco',
    '508': 'Republic of Mozambique',
    '512': 'Sultanate of Oman',
    '516': 'Republic of Namibia',
    '520': 'Republic of Nauru',
    '524': 'State of Nepal',
    '528': 'Kingdom of the Netherlands',
    '530': 'Netherlands Antilles',
    '533': 'Aruba',
    '540': 'New Caledonia',
    '548': 'Republic of Vanuatu',
    '554': 'New Zealand',
    '558': 'Republic of Nicaragua',
    '562': 'Republic of Niger',
    '566': 'Federal Republic of Nigeria',
    '570': 'Niue',
    '574': 'Norfolk Island',
    '578': 'Kingdom of Norway',
    '580': 'Commonwealth of the Northern Mariana Islands',
    '581': 'United States Minor Outlying Islands',
    '583': 'Federated States of Micronesia',
    '584': 'Republic of the Marshall Islands',
    '585': 'Republic of Palau',
    '586': 'Islamic Republic of Pakistan',
    '591': 'Republic of Panama',
    '598': 'Independent State of Papua New Guinea',
    '600': 'Republic of Paraguay',
    '604': 'Republic of Peru',
    '608': 'Republic of the Philippines',
    '612': 'Pitcairn Islands',
    '616': 'Republic of Poland',
    '620': 'Portuguese Republic Portugal',
    '624': 'Republic of Guinea-Bissau',
    '626': 'Democratic Republic of Timor-Leste',
    '630': 'Commonwealth of Puerto Rico',
    '634': 'State of Qatar',
    '638': 'Reunion',
    '642': 'Romania',
    '643': 'Russian Federation',
    '646': 'Republic of Rwanda',
    '652': 'Saint Barthelemy',
    '654': 'Saint Helena',
    '659': 'Federation of Saint Kitts and Nevis',
    '660': 'Anguilla',
    '662': 'Saint Lucia',
    '663': 'Saint Martin',
    '666': 'Saint Pierre and Miquelon',
    '670': 'Saint Vincent and the Grenadines',
    '674': 'Republic of San Marino',
    '678': 'Democratic Republic of Sao Tome and Principe',
    '682': 'Kingdom of Saudi Arabia',
    '686': 'Republic of Senegal',
    '688': 'Republic of Serbia',
    '690': 'Republic of Seychelles',
    '694': 'Republic of Sierra Leone',
    '702': 'Republic of Singapore',
    '703': 'Slovakia (Slovak Republic)',
    '704': 'Socialist Republic of Vietnam',
    '705': 'Republic of Slovenia',
    '706': 'Somali Republic Somalia',
    '710': 'Republic of South Africa',
    '716': 'Republic of Zimbabwe',
    '724': 'Kingdom of Spain',
    '732': 'Western Sahara',
    '736': 'Republic of Sudan',
    '740': 'Republic of Suriname',
    '744': 'Svalbard & Jan Mayen Islands',
    '748': 'Kingdom of Swaziland',
    '752': 'Kingdom of Sweden',
    '756': 'Swiss Confederation Switzerland',
    '760': 'Syrian Arab Republic',
    '762': 'Republic of Tajikistan',
    '764': 'Kingdom of Thailand',
    '768': 'Togolese Republic Togo',
    '772': 'Tokelau',
    '776': 'Kingdom of Tonga',
    '780': 'Republic of Trinidad and Tobago',
    '784': 'United Arab Emirates',
    '788': 'Tunisian Republic Tunisia',
    '792': 'Republic of Turkey',
    '795': 'Turkmenistan',
    '796': 'Turks and Caicos Islands',
    '798': 'Tuvalu',
    '800': 'Republic of Uganda',
    '804': 'Ukraine',
    '807': 'the former Yugoslav Republic of Macedonia',
    '818': 'Arab Republic of Egypt',
    '826': 'United Kingdom of Great Britain & Northern Ireland',
    '831': 'Bailiwick of Guernsey',
    '832': 'Bailiwick of Jersey',
    '833': 'Isle of Man',
    '834': 'United Republic of Tanzania',
    '840': 'United States of America',
    '850': 'United States Virgin Islands',
    '854': 'Burkina Faso',
    '858': 'Eastern Republic of Uruguay',
    '860': 'Republic of Uzbekistan',
    '862': 'Bolivarian Republic of Venezuela',
    '876': 'Wallis and Futuna',
    '882': 'Independent State of Samoa',
    '887': 'Yemen',
    '894': 'Republic of Zambia'}

cn_to_ccn = {   'Afghanistan': '004',
    'Albania': '008',
    'Algeria': '012',
    'American Samoa': '016',
    'Andorra': '020',
    'Angola': '024',
    'Anguilla': '660',
    'Antarctica (the territory South of 60 deg S)': '010',
    'Antigua and Barbuda': '028',
    'Argentina': '032',
    'Armenia': '051',
    'Aruba': '533',
    'Australia': '036',
    'Austria': '040',
    'Azerbaijan': '031',
    'Bahamas': '044',
    'Bahrain': '048',
    'Bangladesh': '050',
    'Barbados': '052',
    'Belarus': '112',
    'Belgium': '056',
    'Belize': '084',
    'Benin': '204',
    'Bermuda': '060',
    'Bhutan': '064',
    'Bolivia': '068',
    'Bosnia and Herzegovina': '070',
    'Botswana': '072',
    'Bouvet Island (Bouvetoya)': '074',
    'Brazil': '076',
    'British Indian Ocean Territory (Chagos Archipelago)': '086',
    'British Virgin Islands': '092',
    'Brunei Darussalam': '096',
    'Bulgaria': '100',
    'Burkina Faso': '854',
    'Burundi': '108',
    'Cambodia': '116',
    'Cameroon': '120',
    'Canada': '124',
    'Cape Verde': '132',
    'Cayman Islands': '136',
    'Central African Republic': '140',
    'Chad': '148',
    'Chile': '152',
    'China': '156',
    'Christmas Island': '162',
    'Cocos (Keeling) Islands': '166',
    'Colombia': '170',
    'Comoros': '174',
    'Congo': '178',
    'Cook Islands': '184',
    'Costa Rica': '188',
    "Cote d'Ivoire": '384',
    'Croatia': '191',
    'Cuba': '192',
    'Cyprus': '196',
    'Czech Republic': '203',
    'Denmark': '208',
    'Djibouti': '262',
    'Dominica': '212',
    'Dominican Republic': '214',
    'Ecuador': '218',
    'Egypt': '818',
    'El Salvador': '222',
    'Equatorial Guinea': '226',
    'Eritrea': '232',
    'Estonia': '233',
    'Ethiopia': '231',
    'Falkland Islands (Malvinas)': '238',
    'Faroe Islands': '234',
    'Fiji': '242',
    'Finland': '246',
    'France': '250',
    'French Guiana': '254',
    'French Polynesia': '258',
    'French Southern Territories': '260',
    'Gabon': '266',
    'Gambia': '270',
    'Georgia': '268',
    'Germany': '276',
    'Ghana': '288',
    'Gibraltar': '292',
    'Greece': '300',
    'Greenland': '304',
    'Grenada': '308',
    'Guadeloupe': '312',
    'Guam': '316',
    'Guatemala': '320',
    'Guernsey': '831',
    'Guinea': '324',
    'Guinea-Bissau': '624',
    'Guyana': '328',
    'Haiti': '332',
    'Heard Island and McDonald Islands': '334',
    'Holy See (Vatican City State)': '336',
    'Honduras': '340',
    'Hong Kong': '344',
    'Hungary': '348',
    'Iceland': '352',
    'India': '356',
    'Indonesia': '360',
    'Iran': '364',
    'Iraq': '368',
    'Ireland': '372',
    'Isle of Man': '833',
    'Israel': '376',
    'Italy': '380',
    'Jamaica': '388',
    'Japan': '392',
    'Jersey': '832',
    'Jordan': '400',
    'Kazakhstan': '398',
    'Kenya': '404',
    'Kiribati': '296',
    'Korea': '410',
    'Kuwait': '414',
    'Kyrgyz Republic': '417',
    "Lao People's Democratic Republic": '418',
    'Latvia': '428',
    'Lebanon': '422',
    'Lesotho': '426',
    'Liberia': '430',
    'Libyan Arab Jamahiriya': '434',
    'Liechtenstein': '438',
    'Lithuania': '440',
    'Luxembourg': '442',
    'Macao': '446',
    'Macedonia': '807',
    'Madagascar': '450',
    'Malawi': '454',
    'Malaysia': '458',
    'Maldives': '462',
    'Mali': '466',
    'Malta': '470',
    'Marshall Islands': '584',
    'Martinique': '474',
    'Mauritania': '478',
    'Mauritius': '480',
    'Mayotte': '175',
    'Mexico': '484',
    'Micronesia': '583',
    'Moldova': '498',
    'Monaco': '492',
    'Mongolia': '496',
    'Montenegro': '499',
    'Montserrat': '500',
    'Morocco': '504',
    'Mozambique': '508',
    'Myanmar': '104',
    'Namibia': '516',
    'Nauru': '520',
    'Nepal': '524',
    'Netherlands': '528',
    'Netherlands Antilles': '530',
    'New Caledonia': '540',
    'New Zealand': '554',
    'Nicaragua': '558',
    'Niger': '562',
    'Nigeria': '566',
    'Niue': '570',
    'Norfolk Island': '574',
    'Northern Mariana Islands': '580',
    'Norway': '578',
    'Oman': '512',
    'Pakistan': '586',
    'Palau': '585',
    'Palestinian Territory': '275',
    'Panama': '591',
    'Papua New Guinea': '598',
    'Paraguay': '600',
    'Peru': '604',
    'Philippines': '608',
    'Pitcairn Islands': '612',
    'Poland': '616',
    'Portugal': '620',
    'Puerto Rico': '630',
    'Qatar': '634',
    'Reunion': '638',
    'Romania': '642',
    'Russian Federation': '643',
    'Rwanda': '646',
    'Saint Barthelemy': '652',
    'Saint Helena': '654',
    'Saint Kitts and Nevis': '659',
    'Saint Lucia': '662',
    'Saint Martin': '663',
    'Saint Pierre and Miquelon': '666',
    'Saint Vincent and the Grenadines': '670',
    'Samoa': '882',
    'San Marino': '674',
    'Sao Tome and Principe': '678',
    'Saudi Arabia': '682',
    'Senegal': '686',
    'Serbia': '688',
    'Seychelles': '690',
    'Sierra Leone': '694',
    'Singapore': '702',
    'Slovakia (Slovak Republic)': '703',
    'Slovenia': '705',
    'Solomon Islands': '090',
    'Somalia': '706',
    'South Africa': '710',
    'South Georgia and the South Sandwich Islands': '239',
    'Spain': '724',
    'Sri Lanka': '144',
    'Sudan': '736',
    'Suriname': '740',
    'Svalbard & Jan Mayen Islands': '744',
    'Swaziland': '748',
    'Sweden': '752',
    'Switzerland': '756',
    'Syrian Arab Republic': '760',
    'Taiwan': '158',
    'Tajikistan': '762',
    'Tanzania': '834',
    'Thailand': '764',
    'Timor-Leste': '626',
    'Togo': '768',
    'Tokelau': '772',
    'Tonga': '776',
    'Trinidad and Tobago': '780',
    'Tunisia': '788',
    'Turkey': '792',
    'Turkmenistan': '795',
    'Turks and Caicos Islands': '796',
    'Tuvalu': '798',
    'Uganda': '800',
    'Ukraine': '804',
    'United Arab Emirates': '784',
    'United Kingdom of Great Britain & Northern Ireland': '826',
    'United States Minor Outlying Islands': '581',
    'United States Virgin Islands': '850',
    'United States of America': '840',
    'Uruguay': '858',
    'Uzbekistan': '860',
    'Vanuatu': '548',
    'Venezuela': '862',
    'Vietnam': '704',
    'Wallis and Futuna': '876',
    'Western Sahara': '732',
    'Yemen': '887',
    'Zambia': '894',
    'Zimbabwe': '716',
    '\xc3\x85land Islands': '248'}

cca3_to_ccn = {   'ABW': '533',
    'AFG': '004',
    'AGO': '024',
    'AIA': '660',
    'ALA': '248',
    'ALB': '008',
    'AND': '020',
    'ANT': '530',
    'ARE': '784',
    'ARG': '032',
    'ARM': '051',
    'ASM': '016',
    'ATA': '010',
    'ATF': '260',
    'ATG': '028',
    'AUS': '036',
    'AUT': '040',
    'AZE': '031',
    'BDI': '108',
    'BEL': '056',
    'BEN': '204',
    'BFA': '854',
    'BGD': '050',
    'BGR': '100',
    'BHR': '048',
    'BHS': '044',
    'BIH': '070',
    'BLM': '652',
    'BLR': '112',
    'BLZ': '084',
    'BMU': '060',
    'BOL': '068',
    'BRA': '076',
    'BRB': '052',
    'BRN': '096',
    'BTN': '064',
    'BVT': '074',
    'BWA': '072',
    'CAF': '140',
    'CAN': '124',
    'CCK': '166',
    'CHE': '756',
    'CHL': '152',
    'CHN': '156',
    'CIV': '384',
    'CMR': '120',
    'COD': '180',
    'COG': '178',
    'COK': '184',
    'COL': '170',
    'COM': '174',
    'CPV': '132',
    'CRI': '188',
    'CUB': '192',
    'CXR': '162',
    'CYM': '136',
    'CYP': '196',
    'CZE': '203',
    'DEU': '276',
    'DJI': '262',
    'DMA': '212',
    'DNK': '208',
    'DOM': '214',
    'DZA': '012',
    'ECU': '218',
    'EGY': '818',
    'ERI': '232',
    'ESH': '732',
    'ESP': '724',
    'EST': '233',
    'ETH': '231',
    'FIN': '246',
    'FJI': '242',
    'FLK': '238',
    'FRA': '250',
    'FRO': '234',
    'FSM': '583',
    'GAB': '266',
    'GBR': '826',
    'GEO': '268',
    'GGY': '831',
    'GHA': '288',
    'GIB': '292',
    'GIN': '324',
    'GLP': '312',
    'GMB': '270',
    'GNB': '624',
    'GNQ': '226',
    'GRC': '300',
    'GRD': '308',
    'GRL': '304',
    'GTM': '320',
    'GUF': '254',
    'GUM': '316',
    'GUY': '328',
    'HKG': '344',
    'HMD': '334',
    'HND': '340',
    'HRV': '191',
    'HTI': '332',
    'HUN': '348',
    'IDN': '360',
    'IMN': '833',
    'IND': '356',
    'IOT': '086',
    'IRL': '372',
    'IRN': '364',
    'IRQ': '368',
    'ISL': '352',
    'ISR': '376',
    'ITA': '380',
    'JAM': '388',
    'JEY': '832',
    'JOR': '400',
    'JPN': '392',
    'KAZ': '398',
    'KEN': '404',
    'KGZ': '417',
    'KHM': '116',
    'KIR': '296',
    'KNA': '659',
    'KOR': '410',
    'KWT': '414',
    'LAO': '418',
    'LBN': '422',
    'LBR': '430',
    'LBY': '434',
    'LCA': '662',
    'LIE': '438',
    'LKA': '144',
    'LSO': '426',
    'LTU': '440',
    'LUX': '442',
    'LVA': '428',
    'MAC': '446',
    'MAF': '663',
    'MAR': '504',
    'MCO': '492',
    'MDA': '498',
    'MDG': '450',
    'MDV': '462',
    'MEX': '484',
    'MHL': '584',
    'MKD': '807',
    'MLI': '466',
    'MLT': '470',
    'MMR': '104',
    'MNE': '499',
    'MNG': '496',
    'MNP': '580',
    'MOZ': '508',
    'MRT': '478',
    'MSR': '500',
    'MTQ': '474',
    'MUS': '480',
    'MWI': '454',
    'MYS': '458',
    'MYT': '175',
    'NAM': '516',
    'NCL': '540',
    'NER': '562',
    'NFK': '574',
    'NGA': '566',
    'NIC': '558',
    'NIU': '570',
    'NLD': '528',
    'NOR': '578',
    'NPL': '524',
    'NRU': '520',
    'NZL': '554',
    'OMN': '512',
    'PAK': '586',
    'PAN': '591',
    'PCN': '612',
    'PER': '604',
    'PHL': '608',
    'PLW': '585',
    'PNG': '598',
    'POL': '616',
    'PRI': '630',
    'PRK': '408',
    'PRT': '620',
    'PRY': '600',
    'PSE': '275',
    'PYF': '258',
    'QAT': '634',
    'REU': '638',
    'ROU': '642',
    'RUS': '643',
    'RWA': '646',
    'SAU': '682',
    'SDN': '736',
    'SEN': '686',
    'SGP': '702',
    'SGS': '239',
    'SHN': '654',
    'SJM': '744',
    'SLB': '090',
    'SLE': '694',
    'SLV': '222',
    'SMR': '674',
    'SOM': '706',
    'SPM': '666',
    'SRB': '688',
    'STP': '678',
    'SUR': '740',
    'SVK': '703',
    'SVN': '705',
    'SWE': '752',
    'SWZ': '748',
    'SYC': '690',
    'SYR': '760',
    'TCA': '796',
    'TCD': '148',
    'TGO': '768',
    'THA': '764',
    'TJK': '762',
    'TKL': '772',
    'TKM': '795',
    'TLS': '626',
    'TON': '776',
    'TTO': '780',
    'TUN': '788',
    'TUR': '792',
    'TUV': '798',
    'TWN': '158',
    'TZA': '834',
    'UGA': '800',
    'UKR': '804',
    'UMI': '581',
    'URY': '858',
    'USA': '840',
    'UZB': '860',
    'VAT': '336',
    'VCT': '670',
    'VEN': '862',
    'VGB': '092',
    'VIR': '850',
    'VNM': '704',
    'VUT': '548',
    'WLF': '876',
    'WSM': '882',
    'YEM': '887',
    'ZAF': '710',
    'ZMB': '894',
    'ZWE': '716'}

cca2_to_ccn = {   'AD': '020',
    'AE': '784',
    'AF': '004',
    'AG': '028',
    'AI': '660',
    'AL': '008',
    'AM': '051',
    'AN': '530',
    'AO': '024',
    'AQ': '010',
    'AR': '032',
    'AS': '016',
    'AT': '040',
    'AU': '036',
    'AW': '533',
    'AX': '248',
    'AZ': '031',
    'BA': '070',
    'BB': '052',
    'BD': '050',
    'BE': '056',
    'BF': '854',
    'BG': '100',
    'BH': '048',
    'BI': '108',
    'BJ': '204',
    'BL': '652',
    'BM': '060',
    'BN': '096',
    'BO': '068',
    'BR': '076',
    'BS': '044',
    'BT': '064',
    'BV': '074',
    'BW': '072',
    'BY': '112',
    'BZ': '084',
    'CA': '124',
    'CC': '166',
    'CD': '180',
    'CF': '140',
    'CG': '178',
    'CH': '756',
    'CI': '384',
    'CK': '184',
    'CL': '152',
    'CM': '120',
    'CN': '156',
    'CO': '170',
    'CR': '188',
    'CU': '192',
    'CV': '132',
    'CX': '162',
    'CY': '196',
    'CZ': '203',
    'DE': '276',
    'DJ': '262',
    'DK': '208',
    'DM': '212',
    'DO': '214',
    'DZ': '012',
    'EC': '218',
    'EE': '233',
    'EG': '818',
    'EH': '732',
    'ER': '232',
    'ES': '724',
    'ET': '231',
    'FI': '246',
    'FJ': '242',
    'FK': '238',
    'FM': '583',
    'FO': '234',
    'FR': '250',
    'GA': '266',
    'GB': '826',
    'GD': '308',
    'GE': '268',
    'GF': '254',
    'GG': '831',
    'GH': '288',
    'GI': '292',
    'GL': '304',
    'GM': '270',
    'GN': '324',
    'GP': '312',
    'GQ': '226',
    'GR': '300',
    'GS': '239',
    'GT': '320',
    'GU': '316',
    'GW': '624',
    'GY': '328',
    'HK': '344',
    'HM': '334',
    'HN': '340',
    'HR': '191',
    'HT': '332',
    'HU': '348',
    'ID': '360',
    'IE': '372',
    'IL': '376',
    'IM': '833',
    'IN': '356',
    'IO': '086',
    'IQ': '368',
    'IR': '364',
    'IS': '352',
    'IT': '380',
    'JE': '832',
    'JM': '388',
    'JO': '400',
    'JP': '392',
    'KE': '404',
    'KG': '417',
    'KH': '116',
    'KI': '296',
    'KM': '174',
    'KN': '659',
    'KP': '408',
    'KR': '410',
    'KW': '414',
    'KY': '136',
    'KZ': '398',
    'LA': '418',
    'LB': '422',
    'LC': '662',
    'LI': '438',
    'LK': '144',
    'LR': '430',
    'LS': '426',
    'LT': '440',
    'LU': '442',
    'LV': '428',
    'LY': '434',
    'MA': '504',
    'MC': '492',
    'MD': '498',
    'ME': '499',
    'MF': '663',
    'MG': '450',
    'MH': '584',
    'MK': '807',
    'ML': '466',
    'MM': '104',
    'MN': '496',
    'MO': '446',
    'MP': '580',
    'MQ': '474',
    'MR': '478',
    'MS': '500',
    'MT': '470',
    'MU': '480',
    'MV': '462',
    'MW': '454',
    'MX': '484',
    'MY': '458',
    'MZ': '508',
    'NA': '516',
    'NC': '540',
    'NE': '562',
    'NF': '574',
    'NG': '566',
    'NI': '558',
    'NL': '528',
    'NO': '578',
    'NP': '524',
    'NR': '520',
    'NU': '570',
    'NZ': '554',
    'OM': '512',
    'PA': '591',
    'PE': '604',
    'PF': '258',
    'PG': '598',
    'PH': '608',
    'PK': '586',
    'PL': '616',
    'PM': '666',
    'PN': '612',
    'PR': '630',
    'PS': '275',
    'PT': '620',
    'PW': '585',
    'PY': '600',
    'QA': '634',
    'RE': '638',
    'RO': '642',
    'RS': '688',
    'RU': '643',
    'RW': '646',
    'SA': '682',
    'SB': '090',
    'SC': '690',
    'SD': '736',
    'SE': '752',
    'SG': '702',
    'SH': '654',
    'SI': '705',
    'SJ': '744',
    'SK': '703',
    'SL': '694',
    'SM': '674',
    'SN': '686',
    'SO': '706',
    'SR': '740',
    'ST': '678',
    'SV': '222',
    'SY': '760',
    'SZ': '748',
    'TC': '796',
    'TD': '148',
    'TF': '260',
    'TG': '768',
    'TH': '764',
    'TJ': '762',
    'TK': '772',
    'TL': '626',
    'TM': '795',
    'TN': '788',
    'TO': '776',
    'TR': '792',
    'TT': '780',
    'TV': '798',
    'TW': '158',
    'TZ': '834',
    'UA': '804',
    'UG': '800',
    'UM': '581',
    'US': '840',
    'UY': '858',
    'UZ': '860',
    'VA': '336',
    'VC': '670',
    'VE': '862',
    'VG': '092',
    'VI': '850',
    'VN': '704',
    'VU': '548',
    'WF': '876',
    'WS': '882',
    'YE': '887',
    'YT': '175',
    'ZA': '710',
    'ZM': '894',
    'ZW': '716'}

ccn_to_ctca2 = {   '004': 'AS',
    '008': 'EU',
    '010': 'AN',
    '012': 'AF',
    '016': 'OC',
    '020': 'EU',
    '024': 'AF',
    '028': 'NA',
    '031': 'AS',
    '032': 'SA',
    '036': 'OC',
    '040': 'EU',
    '044': 'NA',
    '048': 'AS',
    '050': 'AS',
    '051': 'AS',
    '052': 'NA',
    '056': 'EU',
    '060': 'NA',
    '064': 'AS',
    '068': 'SA',
    '070': 'EU',
    '072': 'AF',
    '074': 'AN',
    '076': 'SA',
    '084': 'NA',
    '086': 'AS',
    '090': 'OC',
    '092': 'NA',
    '096': 'AS',
    '100': 'EU',
    '104': 'AS',
    '108': 'AF',
    '112': 'EU',
    '116': 'AS',
    '120': 'AF',
    '124': 'NA',
    '132': 'AF',
    '136': 'NA',
    '140': 'AF',
    '144': 'AS',
    '148': 'AF',
    '152': 'SA',
    '156': 'AS',
    '158': 'AS',
    '162': 'AS',
    '166': 'AS',
    '170': 'SA',
    '174': 'AF',
    '175': 'AF',
    '178': 'AF',
    '180': 'AF',
    '184': 'OC',
    '188': 'NA',
    '191': 'EU',
    '192': 'NA',
    '196': 'AS',
    '203': 'EU',
    '204': 'AF',
    '208': 'EU',
    '212': 'NA',
    '214': 'NA',
    '218': 'SA',
    '222': 'NA',
    '226': 'AF',
    '231': 'AF',
    '232': 'AF',
    '233': 'EU',
    '234': 'EU',
    '238': 'SA',
    '239': 'AN',
    '242': 'OC',
    '246': 'EU',
    '248': 'EU',
    '250': 'EU',
    '254': 'SA',
    '258': 'OC',
    '260': 'AN',
    '262': 'AF',
    '266': 'AF',
    '268': 'AS',
    '270': 'AF',
    '275': 'AS',
    '276': 'EU',
    '288': 'AF',
    '292': 'EU',
    '296': 'OC',
    '300': 'EU',
    '304': 'NA',
    '308': 'NA',
    '312': 'NA',
    '316': 'OC',
    '320': 'NA',
    '324': 'AF',
    '328': 'SA',
    '332': 'NA',
    '334': 'AN',
    '336': 'EU',
    '340': 'NA',
    '344': 'AS',
    '348': 'EU',
    '352': 'EU',
    '356': 'AS',
    '360': 'AS',
    '364': 'AS',
    '368': 'AS',
    '372': 'EU',
    '376': 'AS',
    '380': 'EU',
    '384': 'AF',
    '388': 'NA',
    '392': 'AS',
    '398': 'AS',
    '400': 'AS',
    '404': 'AF',
    '408': 'AS',
    '410': 'AS',
    '414': 'AS',
    '417': 'AS',
    '418': 'AS',
    '422': 'AS',
    '426': 'AF',
    '428': 'EU',
    '430': 'AF',
    '434': 'AF',
    '438': 'EU',
    '440': 'EU',
    '442': 'EU',
    '446': 'AS',
    '450': 'AF',
    '454': 'AF',
    '458': 'AS',
    '462': 'AS',
    '466': 'AF',
    '470': 'EU',
    '474': 'NA',
    '478': 'AF',
    '480': 'AF',
    '484': 'NA',
    '492': 'EU',
    '496': 'AS',
    '498': 'EU',
    '499': 'EU',
    '500': 'NA',
    '504': 'AF',
    '508': 'AF',
    '512': 'AS',
    '516': 'AF',
    '520': 'OC',
    '524': 'AS',
    '528': 'EU',
    '530': 'NA',
    '533': 'NA',
    '540': 'OC',
    '548': 'OC',
    '554': 'OC',
    '558': 'NA',
    '562': 'AF',
    '566': 'AF',
    '570': 'OC',
    '574': 'OC',
    '578': 'EU',
    '580': 'OC',
    '581': 'OC',
    '583': 'OC',
    '584': 'OC',
    '585': 'OC',
    '586': 'AS',
    '591': 'NA',
    '598': 'OC',
    '600': 'SA',
    '604': 'SA',
    '608': 'AS',
    '612': 'OC',
    '616': 'EU',
    '620': 'EU',
    '624': 'AF',
    '626': 'AS',
    '630': 'NA',
    '634': 'AS',
    '638': 'AF',
    '642': 'EU',
    '643': 'EU',
    '646': 'AF',
    '652': 'NA',
    '654': 'AF',
    '659': 'NA',
    '660': 'NA',
    '662': 'NA',
    '663': 'NA',
    '666': 'NA',
    '670': 'NA',
    '674': 'EU',
    '678': 'AF',
    '682': 'AS',
    '686': 'AF',
    '688': 'EU',
    '690': 'AF',
    '694': 'AF',
    '702': 'AS',
    '703': 'EU',
    '704': 'AS',
    '705': 'EU',
    '706': 'AF',
    '710': 'AF',
    '716': 'AF',
    '724': 'EU',
    '732': 'AF',
    '736': 'AF',
    '740': 'SA',
    '744': 'EU',
    '748': 'AF',
    '752': 'EU',
    '756': 'EU',
    '760': 'AS',
    '762': 'AS',
    '764': 'AS',
    '768': 'AF',
    '772': 'OC',
    '776': 'OC',
    '780': 'NA',
    '784': 'AS',
    '788': 'AF',
    '792': 'AS',
    '795': 'AS',
    '796': 'NA',
    '798': 'OC',
    '800': 'AF',
    '804': 'EU',
    '807': 'EU',
    '818': 'AF',
    '826': 'EU',
    '831': 'EU',
    '832': 'EU',
    '833': 'EU',
    '834': 'AF',
    '840': 'NA',
    '850': 'NA',
    '854': 'AF',
    '858': 'SA',
    '860': 'AS',
    '862': 'SA',
    '876': 'OC',
    '882': 'OC',
    '887': 'AS',
    '894': 'AF'}

ctca2_to_ccn = {   'AF': [   '012',
              '024',
              '204',
              '072',
              '854',
              '108',
              '120',
              '132',
              '140',
              '148',
              '174',
              '180',
              '178',
              '384',
              '262',
              '818',
              '226',
              '232',
              '231',
              '266',
              '270',
              '288',
              '324',
              '624',
              '404',
              '426',
              '430',
              '434',
              '450',
              '454',
              '466',
              '478',
              '480',
              '175',
              '504',
              '508',
              '516',
              '562',
              '566',
              '638',
              '646',
              '654',
              '678',
              '686',
              '690',
              '694',
              '706',
              '710',
              '736',
              '748',
              '834',
              '768',
              '788',
              '800',
              '732',
              '894',
              '716'],
    'AN': ['010', '074', '260', '334', '239'],
    'AS': [   '004',
              '051',
              '031',
              '048',
              '050',
              '064',
              '086',
              '096',
              '116',
              '156',
              '162',
              '166',
              '196',
              '268',
              '344',
              '356',
              '360',
              '364',
              '368',
              '376',
              '392',
              '400',
              '398',
              '408',
              '410',
              '414',
              '417',
              '418',
              '422',
              '446',
              '458',
              '462',
              '496',
              '104',
              '524',
              '512',
              '586',
              '275',
              '608',
              '634',
              '682',
              '702',
              '144',
              '760',
              '158',
              '762',
              '764',
              '626',
              '792',
              '795',
              '784',
              '860',
              '704',
              '887'],
    'EU': [   '248',
              '008',
              '020',
              '040',
              '112',
              '056',
              '070',
              '100',
              '191',
              '203',
              '208',
              '233',
              '234',
              '246',
              '250',
              '276',
              '292',
              '300',
              '831',
              '336',
              '348',
              '352',
              '372',
              '833',
              '380',
              '832',
              '428',
              '438',
              '440',
              '442',
              '807',
              '470',
              '498',
              '492',
              '499',
              '528',
              '578',
              '616',
              '620',
              '642',
              '643',
              '674',
              '688',
              '703',
              '705',
              '724',
              '744',
              '752',
              '756',
              '804',
              '826'],
    'NA': [   '660',
              '028',
              '533',
              '044',
              '052',
              '084',
              '060',
              '092',
              '124',
              '136',
              '188',
              '192',
              '212',
              '214',
              '222',
              '304',
              '308',
              '312',
              '320',
              '332',
              '340',
              '388',
              '474',
              '484',
              '500',
              '530',
              '558',
              '591',
              '630',
              '652',
              '659',
              '662',
              '663',
              '666',
              '670',
              '780',
              '796',
              '840',
              '850'],
    'OC': [   '016',
              '036',
              '184',
              '242',
              '258',
              '316',
              '296',
              '584',
              '583',
              '520',
              '540',
              '554',
              '570',
              '574',
              '580',
              '585',
              '598',
              '612',
              '882',
              '090',
              '772',
              '776',
              '798',
              '581',
              '548',
              '876'],
    'SA': [   '032',
              '068',
              '076',
              '152',
              '170',
              '218',
              '238',
              '254',
              '328',
              '600',
              '604',
              '740',
              '858',
              '862']}

