#!/usr/bin/env python

import os
from setuptools import setup

# Fetch version from git tags, and write to version.py.
# Also, when git is not available (PyPi package), use stored version.py.
version_py = os.path.join(os.path.dirname(__file__), "ids", '__init__.py')

try:
    version_git = subprocess.check_output(["git", "describe", "--always"]).rstrip()
except:
    with open(version_py, 'r') as fh:
        version_git = open(version_py).read().strip().split('=')[-1].replace('"','')


version_msg = "# Do not edit this file, versioning is governed by git tags"
with open(version_py, 'w') as fh:
    fh.write(version_msg + os.linesep + "__version__=\"" + version_git + '"' + os.linesep)


setup(name = "incf.ids-tools",
      version = "{ver}".format(ver=version_git),
      description = "INCF Dataspace tools",
      long_description = open("README.rst").read(),
      author = "Chris Smith",
      author_email = "chris@distributedbio.com",
      scripts = ["bin/ids-copy-dataset", "bin/ids-event-logger",
                 "bin/ids-init", "bin/ids-manage-resource",
                 "bin/ids-search-meta", "bin/ids-setup-data-server",
                 "bin/ids-setup-namespace", "bin/ids-setup-zone",
                 "bin/ids-sync-ldap-users", "bin/ids-sync-peer-zones",
                 "bin/ids-sync-users", "bin/ids-sync-zone-rules"],
      url = "https://github.com/INCF/ids-tools/",
      packages = ["ids", "ids.rules", "ids.fabfile", "ids.fabfile.templates"],
      package_data = {
          "ids.rules": ["*.r",],
          "ids.fabfile.templates": ["*.tmpl",]},
      include_package_data = True,
      install_requires = [
          "argparse",
          "Fabric"],
      license = "ASL",
      platforms = "Posix; MacOS X",
      classifiers = [
          "Development Status :: 3 - Alpha",
          "Intended Audience :: Science/Research",
          "Intended Audience :: System Administrators",
          "License :: OSI Approved :: Apache Software License",
          "Operating System :: OS Independent",
          "Topic :: Internet",
          "Topic :: System :: Archiving",
          "Topic :: System :: Distributed Computing",
          "Programming Language :: Python :: 2",
          "Programming Language :: Python :: 2.7"]
      )
