from infi.instruct import *

# http://www.t10.org/lists/asc-num.txt

# spc4r30: 4.5.6 (page 61)
ASC_CODES = {
    struct.pack(">BB", 0x00, 0x00): "NO ADDITIONAL SENSE INFORMATION",
    struct.pack(">BB", 0x00, 0x01): "FILEMARK DETECTED",
    struct.pack(">BB", 0x00, 0x02): "END-OF-PARTITION/MEDIUM DETECTED",
    struct.pack(">BB", 0x00, 0x03): "SETMARK DETECTED",
    struct.pack(">BB", 0x00, 0x04): "BEGINNING-OF-PARTITION/MEDIUM DETECTED",
    struct.pack(">BB", 0x00, 0x05): "END-OF-DATA DETECTED",
    struct.pack(">BB", 0x00, 0x06): "I/O PROCESS TERMINATED",
    struct.pack(">BB", 0x00, 0x07): "PROGRAMMABLE EARLY WARNING DETECTED",
    struct.pack(">BB", 0x00, 0x11): "AUDIO PLAY OPERATION IN PROGRESS",
    struct.pack(">BB", 0x00, 0x12): "AUDIO PLAY OPERATION PAUSED",
    struct.pack(">BB", 0x00, 0x13): "AUDIO PLAY OPERATION SUCCESSFULLY COMPLETED",
    struct.pack(">BB", 0x00, 0x14): "AUDIO PLAY OPERATION STOPPED DUE TO ERROR",
    struct.pack(">BB", 0x00, 0x15): "NO CURRENT AUDIO STATUS TO RETURN",
    struct.pack(">BB", 0x00, 0x16): "OPERATION IN PROGRESS",
    struct.pack(">BB", 0x00, 0x17): "CLEANING REQUESTED",
    struct.pack(">BB", 0x00, 0x18): "ERASE OPERATION IN PROGRESS",
    struct.pack(">BB", 0x00, 0x19): "LOCATE OPERATION IN PROGRESS",
    struct.pack(">BB", 0x00, 0x1A): "REWIND OPERATION IN PROGRESS",
    struct.pack(">BB", 0x00, 0x1B): "SET CAPACITY OPERATION IN PROGRESS",
    struct.pack(">BB", 0x00, 0x1C): "VERIFY OPERATION IN PROGRESS",
    struct.pack(">BB", 0x00, 0x1D): "ATA PASS THROUGH INFORMATION AVAILABLE",
    struct.pack(">BB", 0x00, 0x1E): "CONFLICTING SA CREATION REQUEST",
    struct.pack(">BB", 0x00, 0x1F): "LOGICAL UNIT TRANSITIONING TO ANOTHER POWER CONDITION",
    struct.pack(">BB", 0x01, 0x00): "NO INDEX/SECTOR SIGNAL",
    struct.pack(">BB", 0x02, 0x00): "NO SEEK COMPLETE",
    struct.pack(">BB", 0x03, 0x00): "PERIPHERAL DEVICE WRITE FAULT",
    struct.pack(">BB", 0x03, 0x01): "NO WRITE CURRENT",
    struct.pack(">BB", 0x03, 0x02): "EXCESSIVE WRITE ERRORS",
    struct.pack(">BB", 0x04, 0x00): "LOGICAL UNIT NOT READY, CAUSE NOT REPORTABLE",
    struct.pack(">BB", 0x04, 0x01): "LOGICAL UNIT IS IN PROCESS OF BECOMING READY",
    struct.pack(">BB", 0x04, 0x02): "LOGICAL UNIT NOT READY, INITIALIZING COMMAND REQUIRED",
    struct.pack(">BB", 0x04, 0x03): "LOGICAL UNIT NOT READY, MANUAL INTERVENTION REQUIRED",
    struct.pack(">BB", 0x04, 0x04): "LOGICAL UNIT NOT READY, FORMAT IN PROGRESS",
    struct.pack(">BB", 0x04, 0x05): "LOGICAL UNIT NOT READY, REBUILD IN PROGRESS",
    struct.pack(">BB", 0x04, 0x06): "LOGICAL UNIT NOT READY, RECALCULATION IN PROGRESS",
    struct.pack(">BB", 0x04, 0x07): "LOGICAL UNIT NOT READY, OPERATION IN PROGRESS",
    struct.pack(">BB", 0x04, 0x08): "LOGICAL UNIT NOT READY, LONG WRITE IN PROGRESS",
    struct.pack(">BB", 0x04, 0x09): "LOGICAL UNIT NOT READY, SELF-TEST IN PROGRESS",
    struct.pack(">BB", 0x04, 0x0A): "LOGICAL UNIT NOT ACCESSIBLE, ASYMMETRIC ACCESS STATE TRANSITION",
    struct.pack(">BB", 0x04, 0x0B): "LOGICAL UNIT NOT ACCESSIBLE, TARGET PORT IN STANDBY STATE",
    struct.pack(">BB", 0x04, 0x0C): "LOGICAL UNIT NOT ACCESSIBLE, TARGET PORT IN UNAVAILABLE STATE",
    struct.pack(">BB", 0x04, 0x0D): "LOGICAL UNIT NOT READY, STRUCTURE CHECK REQUIRED",
    struct.pack(">BB", 0x04, 0x10): "LOGICAL UNIT NOT READY, AUXILIARY MEMORY NOT ACCESSIBLE",
    struct.pack(">BB", 0x04, 0x11): "LOGICAL UNIT NOT READY, NOTIFY (ENABLE SPINUP) REQUIRED",
    struct.pack(">BB", 0x04, 0x12): "LOGICAL UNIT NOT READY, OFFLINE",
    struct.pack(">BB", 0x04, 0x13): "LOGICAL UNIT NOT READY, SA CREATION IN PROGRESS",
    struct.pack(">BB", 0x04, 0x14): "LOGICAL UNIT NOT READY, SPACE ALLOCATION IN PROGRESS",
    struct.pack(">BB", 0x04, 0x15): "LOGICAL UNIT NOT READY, ROBOTICS DISABLED",
    struct.pack(">BB", 0x04, 0x16): "LOGICAL UNIT NOT READY, CONFIGURATION REQUIRED",
    struct.pack(">BB", 0x04, 0x17): "LOGICAL UNIT NOT READY, CALIBRATION REQUIRED",
    struct.pack(">BB", 0x04, 0x18): "LOGICAL UNIT NOT READY, A DOOR IS OPEN",
    struct.pack(">BB", 0x04, 0x19): "LOGICAL UNIT NOT READY, OPERATING IN SEQUENTIAL MODE",
    struct.pack(">BB", 0x04, 0x1A): "LOGICAL UNIT NOT READY, START STOP UNIT COMMAND IN PROGRESS",
    struct.pack(">BB", 0x04, 0x1B): "LOGICAL UNIT NOT READY, SANITIZE IN PROGRESS",
    struct.pack(">BB", 0x04, 0x1C): "LOGICAL UNIT NOT READY, ADDITIONAL POWER USE NOT YET GRANTED",
    struct.pack(">BB", 0x05, 0x00): "LOGICAL UNIT DOES NOT RESPOND TO SELECTION",
    struct.pack(">BB", 0x06, 0x00): "NO REFERENCE POSITION FOUND",
    struct.pack(">BB", 0x07, 0x00): "MULTIPLE PERIPHERAL DEVICES SELECTED",
    struct.pack(">BB", 0x08, 0x00): "LOGICAL UNIT COMMUNICATION FAILURE",
    struct.pack(">BB", 0x08, 0x01): "LOGICAL UNIT COMMUNICATION TIME-OUT",
    struct.pack(">BB", 0x08, 0x02): "LOGICAL UNIT COMMUNICATION PARITY ERROR",
    struct.pack(">BB", 0x08, 0x03): "LOGICAL UNIT COMMUNICATION CRC ERROR (ULTRA-DMA/32)",
    struct.pack(">BB", 0x08, 0x04): "UNREACHABLE COPY TARGET",
    struct.pack(">BB", 0x09, 0x00): "TRACK FOLLOWING ERROR",
    struct.pack(">BB", 0x09, 0x01): "TRACKING SERVO FAILURE",
    struct.pack(">BB", 0x09, 0x02): "FOCUS SERVO FAILURE",
    struct.pack(">BB", 0x09, 0x03): "SPINDLE SERVO FAILURE",
    struct.pack(">BB", 0x09, 0x04): "HEAD SELECT FAULT",
    struct.pack(">BB", 0x0A, 0x00): "ERROR LOG OVERFLOW",
    struct.pack(">BB", 0x0B, 0x00): "WARNING",
    struct.pack(">BB", 0x0B, 0x01): "WARNING - SPECIFIED TEMPERATURE EXCEEDED",
    struct.pack(">BB", 0x0B, 0x02): "WARNING - ENCLOSURE DEGRADED",
    struct.pack(">BB", 0x0B, 0x03): "WARNING - BACKGROUND SELF-TEST FAILED",
    struct.pack(">BB", 0x0B, 0x04): "WARNING - BACKGROUND PRE-SCAN DETECTED MEDIUM ERROR",
    struct.pack(">BB", 0x0B, 0x05): "WARNING - BACKGROUND MEDIUM SCAN DETECTED MEDIUM ERROR",
    struct.pack(">BB", 0x0B, 0x06): "WARNING - NON-VOLATILE CACHE NOW VOLATILE",
    struct.pack(">BB", 0x0B, 0x07): "WARNING - DEGRADED POWER TO NON-VOLATILE CACHE",
    struct.pack(">BB", 0x0B, 0x08): "WARNING - POWER LOSS EXPECTED",
    struct.pack(">BB", 0x0C, 0x00): "WRITE ERROR",
    struct.pack(">BB", 0x0C, 0x01): "WRITE ERROR - RECOVERED WITH AUTO REALLOCATION",
    struct.pack(">BB", 0x0C, 0x02): "WRITE ERROR - AUTO REALLOCATION FAILED",
    struct.pack(">BB", 0x0C, 0x03): "WRITE ERROR - RECOMMEND REASSIGNMENT",
    struct.pack(">BB", 0x0C, 0x04): "COMPRESSION CHECK MISCOMPARE ERROR",
    struct.pack(">BB", 0x0C, 0x05): "DATA EXPANSION OCCURRED DURING COMPRESSION",
    struct.pack(">BB", 0x0C, 0x06): "BLOCK NOT COMPRESSIBLE",
    struct.pack(">BB", 0x0C, 0x07): "WRITE ERROR - RECOVERY NEEDED",
    struct.pack(">BB", 0x0C, 0x08): "WRITE ERROR - RECOVERY FAILED",
    struct.pack(">BB", 0x0C, 0x09): "WRITE ERROR - LOSS OF STREAMING",
    struct.pack(">BB", 0x0C, 0x0A): "WRITE ERROR - PADDING BLOCKS ADDED",
    struct.pack(">BB", 0x0C, 0x0B): "AUXILIARY MEMORY WRITE ERROR",
    struct.pack(">BB", 0x0C, 0x0C): "WRITE ERROR - UNEXPECTED UNSOLICITED DATA",
    struct.pack(">BB", 0x0C, 0x0D): "WRITE ERROR - NOT ENOUGH UNSOLICITED DATA",
    struct.pack(">BB", 0x0C, 0x0F): "DEFECTS IN ERROR WINDOW",
    struct.pack(">BB", 0x0D, 0x00): "ERROR DETECTED BY THIRD PARTY TEMPORARY INITIATOR",
    struct.pack(">BB", 0x0D, 0x01): "THIRD PARTY DEVICE FAILURE",
    struct.pack(">BB", 0x0D, 0x02): "COPY TARGET DEVICE NOT REACHABLE",
    struct.pack(">BB", 0x0D, 0x03): "INCORRECT COPY TARGET DEVICE TYPE",
    struct.pack(">BB", 0x0D, 0x04): "COPY TARGET DEVICE DATA UNDERRUN",
    struct.pack(">BB", 0x0D, 0x05): "COPY TARGET DEVICE DATA OVERRUN",
    struct.pack(">BB", 0x0E, 0x00): "INVALID INFORMATION UNIT",
    struct.pack(">BB", 0x0E, 0x01): "INFORMATION UNIT TOO SHORT",
    struct.pack(">BB", 0x0E, 0x02): "INFORMATION UNIT TOO LONG",
    struct.pack(">BB", 0x0E, 0x03): "INVALID FIELD IN COMMAND INFORMATION UNIT",
    struct.pack(">BB", 0x0F, 0x00): "0Fh/00h",
    struct.pack(">BB", 0x10, 0x00): "ID CRC OR ECC ERROR",
    struct.pack(">BB", 0x10, 0x01): "LOGICAL BLOCK GUARD CHECK FAILED",
    struct.pack(">BB", 0x10, 0x02): "LOGICAL BLOCK APPLICATION TAG CHECK FAILED",
    struct.pack(">BB", 0x10, 0x03): "LOGICAL BLOCK REFERENCE TAG CHECK FAILED",
    struct.pack(">BB", 0x10, 0x04): "LOGICAL BLOCK PROTECTION ERROR ON RECOVER BUFFERED DATA",
    struct.pack(">BB", 0x10, 0x05): "LOGICAL BLOCK PROTECTION METHOD ERROR",
    struct.pack(">BB", 0x11, 0x00): "UNRECOVERED READ ERROR",
    struct.pack(">BB", 0x11, 0x01): "READ RETRIES EXHAUSTED",
    struct.pack(">BB", 0x11, 0x02): "ERROR TOO LONG TO CORRECT",
    struct.pack(">BB", 0x11, 0x03): "MULTIPLE READ ERRORS",
    struct.pack(">BB", 0x11, 0x04): "UNRECOVERED READ ERROR - AUTO REALLOCATE FAILED",
    struct.pack(">BB", 0x11, 0x05): "L-EC UNCORRECTABLE ERROR",
    struct.pack(">BB", 0x11, 0x06): "CIRC UNRECOVERED ERROR",
    struct.pack(">BB", 0x11, 0x07): "DATA RE-SYNCHRONIZATION ERROR",
    struct.pack(">BB", 0x11, 0x08): "INCOMPLETE BLOCK READ",
    struct.pack(">BB", 0x11, 0x09): "NO GAP FOUND",
    struct.pack(">BB", 0x11, 0x0A): "MISCORRECTED ERROR",
    struct.pack(">BB", 0x11, 0x0B): "UNRECOVERED READ ERROR - RECOMMEND REASSIGNMENT",
    struct.pack(">BB", 0x11, 0x0C): "UNRECOVERED READ ERROR - RECOMMEND REWRITE THE DATA",
    struct.pack(">BB", 0x11, 0x0D): "DE-COMPRESSION CRC ERROR",
    struct.pack(">BB", 0x11, 0x0E): "CANNOT DECOMPRESS USING DECLARED ALGORITHM",
    struct.pack(">BB", 0x11, 0x0F): "ERROR READING UPC/EAN NUMBER",
    struct.pack(">BB", 0x11, 0x10): "ERROR READING ISRC NUMBER",
    struct.pack(">BB", 0x11, 0x11): "READ ERROR - LOSS OF STREAMING",
    struct.pack(">BB", 0x11, 0x12): "AUXILIARY MEMORY READ ERROR",
    struct.pack(">BB", 0x11, 0x13): "READ ERROR - FAILED RETRANSMISSION REQUEST",
    struct.pack(">BB", 0x11, 0x14): "READ ERROR - LBA MARKED BAD BY APPLICATION CLIENT",
    struct.pack(">BB", 0x12, 0x00): "ADDRESS MARK NOT FOUND FOR ID FIELD",
    struct.pack(">BB", 0x13, 0x00): "ADDRESS MARK NOT FOUND FOR DATA FIELD",
    struct.pack(">BB", 0x14, 0x00): "RECORDED ENTITY NOT FOUND",
    struct.pack(">BB", 0x14, 0x01): "RECORD NOT FOUND",
    struct.pack(">BB", 0x14, 0x02): "FILEMARK OR SETMARK NOT FOUND",
    struct.pack(">BB", 0x14, 0x03): "END-OF-DATA NOT FOUND",
    struct.pack(">BB", 0x14, 0x04): "BLOCK SEQUENCE ERROR",
    struct.pack(">BB", 0x14, 0x05): "RECORD NOT FOUND - RECOMMEND REASSIGNMENT",
    struct.pack(">BB", 0x14, 0x06): "RECORD NOT FOUND - DATA AUTO-REALLOCATED",
    struct.pack(">BB", 0x14, 0x07): "LOCATE OPERATION FAILURE",
    struct.pack(">BB", 0x15, 0x00): "RANDOM POSITIONING ERROR",
    struct.pack(">BB", 0x15, 0x01): "MECHANICAL POSITIONING ERROR",
    struct.pack(">BB", 0x15, 0x02): "POSITIONING ERROR DETECTED BY READ OF MEDIUM",
    struct.pack(">BB", 0x16, 0x00): "DATA SYNCHRONIZATION MARK ERROR",
    struct.pack(">BB", 0x16, 0x01): "DATA SYNC ERROR - DATA REWRITTEN",
    struct.pack(">BB", 0x16, 0x02): "DATA SYNC ERROR - RECOMMEND REWRITE",
    struct.pack(">BB", 0x16, 0x03): "DATA SYNC ERROR - DATA AUTO-REALLOCATED",
    struct.pack(">BB", 0x16, 0x04): "DATA SYNC ERROR - RECOMMEND REASSIGNMENT",
    struct.pack(">BB", 0x17, 0x00): "RECOVERED DATA WITH NO ERROR CORRECTION APPLIED",
    struct.pack(">BB", 0x17, 0x01): "RECOVERED DATA WITH RETRIES",
    struct.pack(">BB", 0x17, 0x02): "RECOVERED DATA WITH POSITIVE HEAD OFFSET",
    struct.pack(">BB", 0x17, 0x03): "RECOVERED DATA WITH NEGATIVE HEAD OFFSET",
    struct.pack(">BB", 0x17, 0x04): "RECOVERED DATA WITH RETRIES AND/OR CIRC APPLIED",
    struct.pack(">BB", 0x17, 0x05): "RECOVERED DATA USING PREVIOUS SECTOR ID",
    struct.pack(">BB", 0x17, 0x06): "RECOVERED DATA WITHOUT ECC - DATA AUTO-REALLOCATED",
    struct.pack(">BB", 0x17, 0x07): "RECOVERED DATA WITHOUT ECC - RECOMMEND REASSIGNMENT",
    struct.pack(">BB", 0x17, 0x08): "RECOVERED DATA WITHOUT ECC - RECOMMEND REWRITE",
    struct.pack(">BB", 0x17, 0x09): "RECOVERED DATA WITHOUT ECC - DATA REWRITTEN",
    struct.pack(">BB", 0x18, 0x00): "RECOVERED DATA WITH ERROR CORRECTION APPLIED",
    struct.pack(">BB", 0x18, 0x01): "RECOVERED DATA WITH ERROR CORR. & RETRIES APPLIED",
    struct.pack(">BB", 0x18, 0x02): "RECOVERED DATA - DATA AUTO-REALLOCATED",
    struct.pack(">BB", 0x18, 0x03): "RECOVERED DATA WITH CIRC",
    struct.pack(">BB", 0x18, 0x04): "RECOVERED DATA WITH L-EC",
    struct.pack(">BB", 0x18, 0x05): "RECOVERED DATA - RECOMMEND REASSIGNMENT",
    struct.pack(">BB", 0x18, 0x06): "RECOVERED DATA - RECOMMEND REWRITE",
    struct.pack(">BB", 0x18, 0x07): "RECOVERED DATA WITH ECC - DATA REWRITTEN",
    struct.pack(">BB", 0x18, 0x08): "RECOVERED DATA WITH LINKING",
    struct.pack(">BB", 0x19, 0x00): "DEFECT LIST ERROR",
    struct.pack(">BB", 0x19, 0x01): "DEFECT LIST NOT AVAILABLE",
    struct.pack(">BB", 0x19, 0x02): "DEFECT LIST ERROR IN PRIMARY LIST",
    struct.pack(">BB", 0x19, 0x03): "DEFECT LIST ERROR IN GROWN LIST",
    struct.pack(">BB", 0x1A, 0x00): "PARAMETER LIST LENGTH ERROR",
    struct.pack(">BB", 0x1B, 0x00): "SYNCHRONOUS DATA TRANSFER ERROR",
    struct.pack(">BB", 0x1C, 0x00): "DEFECT LIST NOT FOUND",
    struct.pack(">BB", 0x1C, 0x01): "PRIMARY DEFECT LIST NOT FOUND",
    struct.pack(">BB", 0x1C, 0x02): "GROWN DEFECT LIST NOT FOUND",
    struct.pack(">BB", 0x1D, 0x00): "MISCOMPARE DURING VERIFY OPERATION",
    struct.pack(">BB", 0x1D, 0x01): "MISCOMPARE VERIFY OF UNMAPPED LBA",
    struct.pack(">BB", 0x1E, 0x00): "RECOVERED ID WITH ECC CORRECTION",
    struct.pack(">BB", 0x1F, 0x00): "PARTIAL DEFECT LIST TRANSFER",
    struct.pack(">BB", 0x20, 0x00): "INVALID COMMAND OPERATION CODE",
    struct.pack(">BB", 0x20, 0x01): "ACCESS DENIED - INITIATOR PENDING-ENROLLED",
    struct.pack(">BB", 0x20, 0x02): "ACCESS DENIED - NO ACCESS RIGHTS",
    struct.pack(">BB", 0x20, 0x03): "ACCESS DENIED - INVALID MGMT ID KEY",
    struct.pack(">BB", 0x20, 0x04): "ILLEGAL COMMAND WHILE IN WRITE CAPABLE STATE",
    struct.pack(">BB", 0x20, 0x05): "Obsolete",
    struct.pack(">BB", 0x20, 0x06): "ILLEGAL COMMAND WHILE IN EXPLICIT ADDRESS MODE",
    struct.pack(">BB", 0x20, 0x07): "ILLEGAL COMMAND WHILE IN IMPLICIT ADDRESS MODE",
    struct.pack(">BB", 0x20, 0x08): "ACCESS DENIED - ENROLLMENT CONFLICT",
    struct.pack(">BB", 0x20, 0x09): "ACCESS DENIED - INVALID LU IDENTIFIER",
    struct.pack(">BB", 0x20, 0x0A): "ACCESS DENIED - INVALID PROXY TOKEN",
    struct.pack(">BB", 0x20, 0x0B): "ACCESS DENIED - ACL LUN CONFLICT",
    struct.pack(">BB", 0x20, 0x0C): "ILLEGAL COMMAND WHEN NOT IN APPEND-ONLY MODE",
    struct.pack(">BB", 0x21, 0x00): "LOGICAL BLOCK ADDRESS OUT OF RANGE",
    struct.pack(">BB", 0x21, 0x01): "INVALID ELEMENT ADDRESS",
    struct.pack(">BB", 0x21, 0x02): "INVALID ADDRESS FOR WRITE",
    struct.pack(">BB", 0x21, 0x03): "INVALID WRITE CROSSING LAYER JUMP",
    struct.pack(">BB", 0x22, 0x00): "ILLEGAL FUNCTION (USE 20 00, 24 00, OR 26 00)",
    struct.pack(">BB", 0x23, 0x00): "INVALID TOKEN OPERATION, CAUSE NOT REPORTABLE",
    struct.pack(">BB", 0x24, 0x00): "INVALID FIELD IN CDB",
    struct.pack(">BB", 0x24, 0x01): "CDB DECRYPTION ERROR",
    struct.pack(">BB", 0x24, 0x02): "Obsolete",
    struct.pack(">BB", 0x24, 0x03): "Obsolete",
    struct.pack(">BB", 0x24, 0x04): "SECURITY AUDIT VALUE FROZEN",
    struct.pack(">BB", 0x24, 0x05): "SECURITY WORKING KEY FROZEN",
    struct.pack(">BB", 0x24, 0x06): "NONCE NOT UNIQUE",
    struct.pack(">BB", 0x24, 0x07): "NONCE TIMESTAMP OUT OF RANGE",
    struct.pack(">BB", 0x24, 0x08): "INVALID XCDB",
    struct.pack(">BB", 0x25, 0x00): "LOGICAL UNIT NOT SUPPORTED",
    struct.pack(">BB", 0x26, 0x00): "INVALID FIELD IN PARAMETER LIST",
    struct.pack(">BB", 0x26, 0x01): "PARAMETER NOT SUPPORTED",
    struct.pack(">BB", 0x26, 0x02): "PARAMETER VALUE INVALID",
    struct.pack(">BB", 0x26, 0x03): "THRESHOLD PARAMETERS NOT SUPPORTED",
    struct.pack(">BB", 0x26, 0x04): "INVALID RELEASE OF PERSISTENT RESERVATION",
    struct.pack(">BB", 0x26, 0x05): "DATA DECRYPTION ERROR",
    struct.pack(">BB", 0x26, 0x06): "TOO MANY TARGET DESCRIPTORS",
    struct.pack(">BB", 0x26, 0x07): "UNSUPPORTED TARGET DESCRIPTOR TYPE CODE",
    struct.pack(">BB", 0x26, 0x08): "TOO MANY SEGMENT DESCRIPTORS",
    struct.pack(">BB", 0x26, 0x09): "UNSUPPORTED SEGMENT DESCRIPTOR TYPE CODE",
    struct.pack(">BB", 0x26, 0x0A): "UNEXPECTED INEXACT SEGMENT",
    struct.pack(">BB", 0x26, 0x0B): "INLINE DATA LENGTH EXCEEDED",
    struct.pack(">BB", 0x26, 0x0C): "INVALID OPERATION FOR COPY SOURCE OR DESTINATION",
    struct.pack(">BB", 0x26, 0x0D): "COPY SEGMENT GRANULARITY VIOLATION",
    struct.pack(">BB", 0x26, 0x0E): "INVALID PARAMETER WHILE PORT IS ENABLED",
    struct.pack(">BB", 0x26, 0x0F): "INVALID DATA-OUT BUFFER INTEGRITY CHECK VALUE",
    struct.pack(">BB", 0x26, 0x10): "DATA DECRYPTION KEY FAIL LIMIT REACHED",
    struct.pack(">BB", 0x26, 0x11): "INCOMPLETE KEY-ASSOCIATED DATA SET",
    struct.pack(">BB", 0x26, 0x12): "VENDOR SPECIFIC KEY REFERENCE NOT FOUND",
    struct.pack(">BB", 0x27, 0x00): "WRITE PROTECTED",
    struct.pack(">BB", 0x27, 0x01): "HARDWARE WRITE PROTECTED",
    struct.pack(">BB", 0x27, 0x02): "LOGICAL UNIT SOFTWARE WRITE PROTECTED",
    struct.pack(">BB", 0x27, 0x03): "ASSOCIATED WRITE PROTECT",
    struct.pack(">BB", 0x27, 0x04): "PERSISTENT WRITE PROTECT",
    struct.pack(">BB", 0x27, 0x05): "PERMANENT WRITE PROTECT",
    struct.pack(">BB", 0x27, 0x06): "CONDITIONAL WRITE PROTECT",
    struct.pack(">BB", 0x27, 0x07): "SPACE ALLOCATION FAILED WRITE PROTECT",
    struct.pack(">BB", 0x28, 0x00): "NOT READY TO READY CHANGE, MEDIUM MAY HAVE CHANGED",
    struct.pack(">BB", 0x28, 0x01): "IMPORT OR EXPORT ELEMENT ACCESSED",
    struct.pack(">BB", 0x28, 0x02): "FORMAT-LAYER MAY HAVE CHANGED",
    struct.pack(">BB", 0x28, 0x03): "IMPORT/EXPORT ELEMENT ACCESSED, MEDIUM CHANGED",
    struct.pack(">BB", 0x29, 0x00): "POWER ON, RESET, OR BUS DEVICE RESET OCCURRED",
    struct.pack(">BB", 0x29, 0x01): "POWER ON OCCURRED",
    struct.pack(">BB", 0x29, 0x02): "SCSI BUS RESET OCCURRED",
    struct.pack(">BB", 0x29, 0x03): "BUS DEVICE RESET FUNCTION OCCURRED",
    struct.pack(">BB", 0x29, 0x04): "DEVICE INTERNAL RESET",
    struct.pack(">BB", 0x29, 0x05): "TRANSCEIVER MODE CHANGED TO SINGLE-ENDED",
    struct.pack(">BB", 0x29, 0x06): "TRANSCEIVER MODE CHANGED TO LVD",
    struct.pack(">BB", 0x29, 0x07): "I_T NEXUS LOSS OCCURRED",
    struct.pack(">BB", 0x2A, 0x00): "PARAMETERS CHANGED",
    struct.pack(">BB", 0x2A, 0x01): "MODE PARAMETERS CHANGED",
    struct.pack(">BB", 0x2A, 0x02): "LOG PARAMETERS CHANGED",
    struct.pack(">BB", 0x2A, 0x03): "RESERVATIONS PREEMPTED",
    struct.pack(">BB", 0x2A, 0x04): "RESERVATIONS RELEASED",
    struct.pack(">BB", 0x2A, 0x05): "REGISTRATIONS PREEMPTED",
    struct.pack(">BB", 0x2A, 0x06): "ASYMMETRIC ACCESS STATE CHANGED",
    struct.pack(">BB", 0x2A, 0x07): "IMPLICIT ASYMMETRIC ACCESS STATE TRANSITION FAILED",
    struct.pack(">BB", 0x2A, 0x08): "PRIORITY CHANGED",
    struct.pack(">BB", 0x2A, 0x09): "CAPACITY DATA HAS CHANGED",
    struct.pack(">BB", 0x2A, 0x0A): "ERROR HISTORY I_T NEXUS CLEARED",
    struct.pack(">BB", 0x2A, 0x0B): "ERROR HISTORY SNAPSHOT RELEASED",
    struct.pack(">BB", 0x2A, 0x0C): "ERROR RECOVERY ATTRIBUTES HAVE CHANGED",
    struct.pack(">BB", 0x2A, 0x0D): "DATA ENCRYPTION CAPABILITIES CHANGED",
    struct.pack(">BB", 0x2A, 0x10): "TIMESTAMP CHANGED",
    struct.pack(">BB", 0x2A, 0x11): "DATA ENCRYPTION PARAMETERS CHANGED BY ANOTHER I_T NEXUS",
    struct.pack(">BB", 0x2A, 0x12): "DATA ENCRYPTION PARAMETERS CHANGED BY VENDOR SPECIFIC EVENT",
    struct.pack(">BB", 0x2A, 0x13): "DATA ENCRYPTION KEY INSTANCE COUNTER HAS CHANGED",
    struct.pack(">BB", 0x2A, 0x14): "SA CREATION CAPABILITIES DATA HAS CHANGED",
    struct.pack(">BB", 0x2B, 0x00): "COPY CANNOT EXECUTE SINCE HOST CANNOT DISCONNECT",
    struct.pack(">BB", 0x2C, 0x00): "COMMAND SEQUENCE ERROR",
    struct.pack(">BB", 0x2C, 0x01): "TOO MANY WINDOWS SPECIFIED",
    struct.pack(">BB", 0x2C, 0x02): "INVALID COMBINATION OF WINDOWS SPECIFIED",
    struct.pack(">BB", 0x2C, 0x03): "CURRENT PROGRAM AREA IS NOT EMPTY",
    struct.pack(">BB", 0x2C, 0x04): "CURRENT PROGRAM AREA IS EMPTY",
    struct.pack(">BB", 0x2C, 0x05): "ILLEGAL POWER CONDITION REQUEST",
    struct.pack(">BB", 0x2C, 0x06): "PERSISTENT PREVENT CONFLICT",
    struct.pack(">BB", 0x2C, 0x07): "PREVIOUS BUSY STATUS",
    struct.pack(">BB", 0x2C, 0x08): "PREVIOUS TASK SET FULL STATUS",
    struct.pack(">BB", 0x2C, 0x09): "PREVIOUS RESERVATION CONFLICT STATUS",
    struct.pack(">BB", 0x2C, 0x0A): "PARTITION OR COLLECTION CONTAINS USER OBJECTS",
    struct.pack(">BB", 0x2C, 0x0B): "NOT RESERVED",
    struct.pack(">BB", 0x2C, 0x0C): "ORWRITE GENERATION DOES NOT MATCH",
    struct.pack(">BB", 0x2D, 0x00): "OVERWRITE ERROR ON UPDATE IN PLACE",
    struct.pack(">BB", 0x2E, 0x00): "INSUFFICIENT TIME FOR OPERATION",
    struct.pack(">BB", 0x2F, 0x00): "COMMANDS CLEARED BY ANOTHER INITIATOR",
    struct.pack(">BB", 0x2F, 0x01): "COMMANDS CLEARED BY POWER LOSS NOTIFICATION",
    struct.pack(">BB", 0x2F, 0x02): "COMMANDS CLEARED BY DEVICE SERVER",
    struct.pack(">BB", 0x30, 0x00): "INCOMPATIBLE MEDIUM INSTALLED",
    struct.pack(">BB", 0x30, 0x01): "CANNOT READ MEDIUM - UNKNOWN FORMAT",
    struct.pack(">BB", 0x30, 0x02): "CANNOT READ MEDIUM - INCOMPATIBLE FORMAT",
    struct.pack(">BB", 0x30, 0x03): "CLEANING CARTRIDGE INSTALLED",
    struct.pack(">BB", 0x30, 0x04): "CANNOT WRITE MEDIUM - UNKNOWN FORMAT",
    struct.pack(">BB", 0x30, 0x05): "CANNOT WRITE MEDIUM - INCOMPATIBLE FORMAT",
    struct.pack(">BB", 0x30, 0x06): "CANNOT FORMAT MEDIUM - INCOMPATIBLE MEDIUM",
    struct.pack(">BB", 0x30, 0x07): "CLEANING FAILURE",
    struct.pack(">BB", 0x30, 0x08): "CANNOT WRITE - APPLICATION CODE MISMATCH",
    struct.pack(">BB", 0x30, 0x09): "CURRENT SESSION NOT FIXATED FOR APPEND",
    struct.pack(">BB", 0x30, 0x0A): "CLEANING REQUEST REJECTED",
    struct.pack(">BB", 0x30, 0x0C): "WORM MEDIUM - OVERWRITE ATTEMPTED",
    struct.pack(">BB", 0x30, 0x0D): "WORM MEDIUM - INTEGRITY CHECK",
    struct.pack(">BB", 0x30, 0x10): "MEDIUM NOT FORMATTED",
    struct.pack(">BB", 0x30, 0x11): "INCOMPATIBLE VOLUME TYPE",
    struct.pack(">BB", 0x30, 0x12): "INCOMPATIBLE VOLUME QUALIFIER",
    struct.pack(">BB", 0x30, 0x13): "CLEANING VOLUME EXPIRED",
    struct.pack(">BB", 0x31, 0x00): "MEDIUM FORMAT CORRUPTED",
    struct.pack(">BB", 0x31, 0x01): "FORMAT COMMAND FAILED",
    struct.pack(">BB", 0x31, 0x02): "ZONED FORMATTING FAILED DUE TO SPARE LINKING",
    struct.pack(">BB", 0x31, 0x03): "SANITIZE COMMAND FAILED",
    struct.pack(">BB", 0x32, 0x00): "NO DEFECT SPARE LOCATION AVAILABLE",
    struct.pack(">BB", 0x32, 0x01): "DEFECT LIST UPDATE FAILURE",
    struct.pack(">BB", 0x33, 0x00): "TAPE LENGTH ERROR",
    struct.pack(">BB", 0x34, 0x00): "ENCLOSURE FAILURE",
    struct.pack(">BB", 0x35, 0x00): "ENCLOSURE SERVICES FAILURE",
    struct.pack(">BB", 0x35, 0x01): "UNSUPPORTED ENCLOSURE FUNCTION",
    struct.pack(">BB", 0x35, 0x02): "ENCLOSURE SERVICES UNAVAILABLE",
    struct.pack(">BB", 0x35, 0x03): "ENCLOSURE SERVICES TRANSFER FAILURE",
    struct.pack(">BB", 0x35, 0x04): "ENCLOSURE SERVICES TRANSFER REFUSED",
    struct.pack(">BB", 0x35, 0x05): "ENCLOSURE SERVICES CHECKSUM ERROR",
    struct.pack(">BB", 0x36, 0x00): "RIBBON, INK, OR TONER FAILURE",
    struct.pack(">BB", 0x37, 0x00): "ROUNDED PARAMETER",
    struct.pack(">BB", 0x38, 0x00): "EVENT STATUS NOTIFICATION",
    struct.pack(">BB", 0x38, 0x02): "ESN - POWER MANAGEMENT CLASS EVENT",
    struct.pack(">BB", 0x38, 0x04): "ESN - MEDIA CLASS EVENT",
    struct.pack(">BB", 0x38, 0x06): "ESN - DEVICE BUSY CLASS EVENT",
    struct.pack(">BB", 0x38, 0x07): "THIN PROVISIONING SOFT THRESHOLD REACHED",
    struct.pack(">BB", 0x39, 0x00): "SAVING PARAMETERS NOT SUPPORTED",
    struct.pack(">BB", 0x3A, 0x00): "MEDIUM NOT PRESENT",
    struct.pack(">BB", 0x3A, 0x01): "MEDIUM NOT PRESENT - TRAY CLOSED",
    struct.pack(">BB", 0x3A, 0x02): "MEDIUM NOT PRESENT - TRAY OPEN",
    struct.pack(">BB", 0x3A, 0x03): "MEDIUM NOT PRESENT - LOADABLE",
    struct.pack(">BB", 0x3A, 0x04): "MEDIUM NOT PRESENT - MEDIUM AUXILIARY MEMORY ACCESSIBLE",
    struct.pack(">BB", 0x3B, 0x00): "SEQUENTIAL POSITIONING ERROR",
    struct.pack(">BB", 0x3B, 0x01): "TAPE POSITION ERROR AT BEGINNING-OF-MEDIUM",
    struct.pack(">BB", 0x3B, 0x02): "TAPE POSITION ERROR AT END-OF-MEDIUM",
    struct.pack(">BB", 0x3B, 0x03): "TAPE OR ELECTRONIC VERTICAL FORMS UNIT NOT READY",
    struct.pack(">BB", 0x3B, 0x04): "SLEW FAILURE",
    struct.pack(">BB", 0x3B, 0x05): "PAPER JAM",
    struct.pack(">BB", 0x3B, 0x06): "FAILED TO SENSE TOP-OF-FORM",
    struct.pack(">BB", 0x3B, 0x07): "FAILED TO SENSE BOTTOM-OF-FORM",
    struct.pack(">BB", 0x3B, 0x08): "REPOSITION ERROR",
    struct.pack(">BB", 0x3B, 0x09): "READ PAST END OF MEDIUM",
    struct.pack(">BB", 0x3B, 0x0A): "READ PAST BEGINNING OF MEDIUM",
    struct.pack(">BB", 0x3B, 0x0B): "POSITION PAST END OF MEDIUM",
    struct.pack(">BB", 0x3B, 0x0C): "POSITION PAST BEGINNING OF MEDIUM",
    struct.pack(">BB", 0x3B, 0x0D): "MEDIUM DESTINATION ELEMENT FULL",
    struct.pack(">BB", 0x3B, 0x0E): "MEDIUM SOURCE ELEMENT EMPTY",
    struct.pack(">BB", 0x3B, 0x0F): "END OF MEDIUM REACHED",
    struct.pack(">BB", 0x3B, 0x11): "MEDIUM MAGAZINE NOT ACCESSIBLE",
    struct.pack(">BB", 0x3B, 0x12): "MEDIUM MAGAZINE REMOVED",
    struct.pack(">BB", 0x3B, 0x13): "MEDIUM MAGAZINE INSERTED",
    struct.pack(">BB", 0x3B, 0x14): "MEDIUM MAGAZINE LOCKED",
    struct.pack(">BB", 0x3B, 0x15): "MEDIUM MAGAZINE UNLOCKED",
    struct.pack(">BB", 0x3B, 0x16): "MECHANICAL POSITIONING OR CHANGER ERROR",
    struct.pack(">BB", 0x3B, 0x17): "READ PAST END OF USER OBJECT",
    struct.pack(">BB", 0x3B, 0x18): "ELEMENT DISABLED",
    struct.pack(">BB", 0x3B, 0x19): "ELEMENT ENABLED",
    struct.pack(">BB", 0x3B, 0x1A): "DATA TRANSFER DEVICE REMOVED",
    struct.pack(">BB", 0x3B, 0x1B): "DATA TRANSFER DEVICE INSERTED",
    struct.pack(">BB", 0x3C, 0x00): "3Ch/00h",
    struct.pack(">BB", 0x3D, 0x00): "INVALID BITS IN IDENTIFY MESSAGE",
    struct.pack(">BB", 0x3E, 0x00): "LOGICAL UNIT HAS NOT SELF-CONFIGURED YET",
    struct.pack(">BB", 0x3E, 0x01): "LOGICAL UNIT FAILURE",
    struct.pack(">BB", 0x3E, 0x02): "TIMEOUT ON LOGICAL UNIT",
    struct.pack(">BB", 0x3E, 0x03): "LOGICAL UNIT FAILED SELF-TEST",
    struct.pack(">BB", 0x3E, 0x04): "LOGICAL UNIT UNABLE TO UPDATE SELF-TEST LOG",
    struct.pack(">BB", 0x3F, 0x00): "TARGET OPERATING CONDITIONS HAVE CHANGED",
    struct.pack(">BB", 0x3F, 0x01): "MICROCODE HAS BEEN CHANGED",
    struct.pack(">BB", 0x3F, 0x02): "CHANGED OPERATING DEFINITION",
    struct.pack(">BB", 0x3F, 0x03): "INQUIRY DATA HAS CHANGED",
    struct.pack(">BB", 0x3F, 0x04): "COMPONENT DEVICE ATTACHED",
    struct.pack(">BB", 0x3F, 0x05): "DEVICE IDENTIFIER CHANGED",
    struct.pack(">BB", 0x3F, 0x06): "REDUNDANCY GROUP CREATED OR MODIFIED",
    struct.pack(">BB", 0x3F, 0x07): "REDUNDANCY GROUP DELETED",
    struct.pack(">BB", 0x3F, 0x08): "SPARE CREATED OR MODIFIED",
    struct.pack(">BB", 0x3F, 0x09): "SPARE DELETED",
    struct.pack(">BB", 0x3F, 0x0A): "VOLUME SET CREATED OR MODIFIED",
    struct.pack(">BB", 0x3F, 0x0B): "VOLUME SET DELETED",
    struct.pack(">BB", 0x3F, 0x0C): "VOLUME SET DEASSIGNED",
    struct.pack(">BB", 0x3F, 0x0D): "VOLUME SET REASSIGNED",
    struct.pack(">BB", 0x3F, 0x0E): "REPORTED LUNS DATA HAS CHANGED",
    struct.pack(">BB", 0x3F, 0x0F): "ECHO BUFFER OVERWRITTEN",
    struct.pack(">BB", 0x3F, 0x10): "MEDIUM LOADABLE",
    struct.pack(">BB", 0x3F, 0x11): "MEDIUM AUXILIARY MEMORY ACCESSIBLE",
    struct.pack(">BB", 0x3F, 0x12): "iSCSI IP ADDRESS ADDED",
    struct.pack(">BB", 0x3F, 0x13): "iSCSI IP ADDRESS REMOVED",
    struct.pack(">BB", 0x3F, 0x14): "iSCSI IP ADDRESS CHANGED",
    struct.pack(">BB", 0x40, 0x00): "RAM FAILURE (SHOULD USE 40 NN)",
    struct.pack(">BB", 0x41, 0x00): "DATA PATH FAILURE (SHOULD USE 40 NN)",
    struct.pack(">BB", 0x42, 0x00): "POWER-ON OR SELF-TEST FAILURE (SHOULD USE 40 NN)",
    struct.pack(">BB", 0x43, 0x00): "MESSAGE ERROR",
    struct.pack(">BB", 0x44, 0x00): "INTERNAL TARGET FAILURE",
    struct.pack(">BB", 0x44, 0x71): "ATA DEVICE FAILED SET FEATURES",
    struct.pack(">BB", 0x45, 0x00): "SELECT OR RESELECT FAILURE",
    struct.pack(">BB", 0x46, 0x00): "UNSUCCESSFUL SOFT RESET",
    struct.pack(">BB", 0x47, 0x00): "SCSI PARITY ERROR",
    struct.pack(">BB", 0x47, 0x01): "DATA PHASE CRC ERROR DETECTED",
    struct.pack(">BB", 0x47, 0x02): "SCSI PARITY ERROR DETECTED DURING ST DATA PHASE",
    struct.pack(">BB", 0x47, 0x03): "INFORMATION UNIT iuCRC ERROR DETECTED",
    struct.pack(">BB", 0x47, 0x04): "ASYNCHRONOUS INFORMATION PROTECTION ERROR DETECTED",
    struct.pack(">BB", 0x47, 0x05): "PROTOCOL SERVICE CRC ERROR",
    struct.pack(">BB", 0x47, 0x06): "PHY TEST FUNCTION IN PROGRESS",
    struct.pack(">BB", 0x47, 0x7F): "SOME COMMANDS CLEARED BY ISCSI PROTOCOL EVENT",
    struct.pack(">BB", 0x48, 0x00): "INITIATOR DETECTED ERROR MESSAGE RECEIVED",
    struct.pack(">BB", 0x49, 0x00): "INVALID MESSAGE ERROR",
    struct.pack(">BB", 0x4A, 0x00): "COMMAND PHASE ERROR",
    struct.pack(">BB", 0x4B, 0x00): "DATA PHASE ERROR",
    struct.pack(">BB", 0x4B, 0x01): "INVALID TARGET PORT TRANSFER TAG RECEIVED",
    struct.pack(">BB", 0x4B, 0x02): "TOO MUCH WRITE DATA",
    struct.pack(">BB", 0x4B, 0x03): "ACK/NAK TIMEOUT",
    struct.pack(">BB", 0x4B, 0x04): "NAK RECEIVED",
    struct.pack(">BB", 0x4B, 0x05): "DATA OFFSET ERROR",
    struct.pack(">BB", 0x4B, 0x06): "INITIATOR RESPONSE TIMEOUT",
    struct.pack(">BB", 0x4B, 0x07): "CONNECTION LOST",
    struct.pack(">BB", 0x4C, 0x00): "LOGICAL UNIT FAILED SELF-CONFIGURATION",
    struct.pack(">BB", 0x4E, 0x00): "OVERLAPPED COMMANDS ATTEMPTED",
    struct.pack(">BB", 0x4F, 0x00): "4Fh/00h",
    struct.pack(">BB", 0x50, 0x00): "WRITE APPEND ERROR",
    struct.pack(">BB", 0x50, 0x01): "WRITE APPEND POSITION ERROR",
    struct.pack(">BB", 0x50, 0x02): "POSITION ERROR RELATED TO TIMING",
    struct.pack(">BB", 0x51, 0x00): "ERASE FAILURE",
    struct.pack(">BB", 0x51, 0x01): "ERASE FAILURE - INCOMPLETE ERASE OPERATION DETECTED",
    struct.pack(">BB", 0x52, 0x00): "CARTRIDGE FAULT",
    struct.pack(">BB", 0x53, 0x00): "MEDIA LOAD OR EJECT FAILED",
    struct.pack(">BB", 0x53, 0x01): "UNLOAD TAPE FAILURE",
    struct.pack(">BB", 0x53, 0x02): "MEDIUM REMOVAL PREVENTED",
    struct.pack(">BB", 0x53, 0x03): "MEDIUM REMOVAL PREVENTED BY DATA TRANSFER ELEMENT",
    struct.pack(">BB", 0x53, 0x04): "MEDIUM THREAD OR UNTHREAD FAILURE",
    struct.pack(">BB", 0x53, 0x05): "VOLUME IDENTIFIER INVALID",
    struct.pack(">BB", 0x53, 0x06): "VOLUME IDENTIFIER MISSING",
    struct.pack(">BB", 0x53, 0x07): "DUPLICATE VOLUME IDENTIFIER",
    struct.pack(">BB", 0x53, 0x08): "ELEMENT STATUS UNKNOWN",
    struct.pack(">BB", 0x54, 0x00): "SCSI TO HOST SYSTEM INTERFACE FAILURE",
    struct.pack(">BB", 0x55, 0x00): "SYSTEM RESOURCE FAILURE",
    struct.pack(">BB", 0x55, 0x01): "SYSTEM BUFFER FULL",
    struct.pack(">BB", 0x55, 0x02): "INSUFFICIENT RESERVATION RESOURCES",
    struct.pack(">BB", 0x55, 0x03): "INSUFFICIENT RESOURCES",
    struct.pack(">BB", 0x55, 0x04): "INSUFFICIENT REGISTRATION RESOURCES",
    struct.pack(">BB", 0x55, 0x05): "INSUFFICIENT ACCESS CONTROL RESOURCES",
    struct.pack(">BB", 0x55, 0x06): "AUXILIARY MEMORY OUT OF SPACE",
    struct.pack(">BB", 0x55, 0x07): "QUOTA ERROR",
    struct.pack(">BB", 0x55, 0x08): "MAXIMUM NUMBER OF SUPPLEMENTAL DECRYPTION KEYS EXCEEDED",
    struct.pack(">BB", 0x55, 0x09): "MEDIUM AUXILIARY MEMORY NOT ACCESSIBLE",
    struct.pack(">BB", 0x55, 0x0A): "DATA CURRENTLY UNAVAILABLE",
    struct.pack(">BB", 0x55, 0x0B): "INSUFFICIENT POWER FOR OPERATION",
    struct.pack(">BB", 0x56, 0x00): "56h/00h",
    struct.pack(">BB", 0x57, 0x00): "UNABLE TO RECOVER TABLE-OF-CONTENTS",
    struct.pack(">BB", 0x58, 0x00): "GENERATION DOES NOT EXIST",
    struct.pack(">BB", 0x59, 0x00): "UPDATED BLOCK READ",
    struct.pack(">BB", 0x5A, 0x00): "OPERATOR REQUEST OR STATE CHANGE INPUT",
    struct.pack(">BB", 0x5A, 0x01): "OPERATOR MEDIUM REMOVAL REQUEST",
    struct.pack(">BB", 0x5A, 0x02): "OPERATOR SELECTED WRITE PROTECT",
    struct.pack(">BB", 0x5A, 0x03): "OPERATOR SELECTED WRITE PERMIT",
    struct.pack(">BB", 0x5B, 0x00): "LOG EXCEPTION",
    struct.pack(">BB", 0x5B, 0x01): "THRESHOLD CONDITION MET",
    struct.pack(">BB", 0x5B, 0x02): "LOG COUNTER AT MAXIMUM",
    struct.pack(">BB", 0x5B, 0x03): "LOG LIST CODES EXHAUSTED",
    struct.pack(">BB", 0x5C, 0x00): "RPL STATUS CHANGE",
    struct.pack(">BB", 0x5C, 0x01): "SPINDLES SYNCHRONIZED",
    struct.pack(">BB", 0x5C, 0x02): "SPINDLES NOT SYNCHRONIZED",
    struct.pack(">BB", 0x5D, 0x00): "FAILURE PREDICTION THRESHOLD EXCEEDED",
    struct.pack(">BB", 0x5D, 0x01): "MEDIA FAILURE PREDICTION THRESHOLD EXCEEDED",
    struct.pack(">BB", 0x5D, 0x02): "LOGICAL UNIT FAILURE PREDICTION THRESHOLD EXCEEDED",
    struct.pack(">BB", 0x5D, 0x03): "SPARE AREA EXHAUSTION PREDICTION THRESHOLD EXCEEDED",
    struct.pack(">BB", 0x5D, 0x10): "HARDWARE IMPENDING FAILURE GENERAL HARD DRIVE FAILURE",
    struct.pack(">BB", 0x5D, 0x11): "HARDWARE IMPENDING FAILURE DRIVE ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x12): "HARDWARE IMPENDING FAILURE DATA ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x13): "HARDWARE IMPENDING FAILURE SEEK ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x14): "HARDWARE IMPENDING FAILURE TOO MANY BLOCK REASSIGNS",
    struct.pack(">BB", 0x5D, 0x15): "HARDWARE IMPENDING FAILURE ACCESS TIMES TOO HIGH",
    struct.pack(">BB", 0x5D, 0x16): "HARDWARE IMPENDING FAILURE START UNIT TIMES TOO HIGH",
    struct.pack(">BB", 0x5D, 0x17): "HARDWARE IMPENDING FAILURE CHANNEL PARAMETRICS",
    struct.pack(">BB", 0x5D, 0x18): "HARDWARE IMPENDING FAILURE CONTROLLER DETECTED",
    struct.pack(">BB", 0x5D, 0x19): "HARDWARE IMPENDING FAILURE THROUGHPUT PERFORMANCE",
    struct.pack(">BB", 0x5D, 0x1A): "HARDWARE IMPENDING FAILURE SEEK TIME PERFORMANCE",
    struct.pack(">BB", 0x5D, 0x1B): "HARDWARE IMPENDING FAILURE SPIN-UP RETRY COUNT",
    struct.pack(">BB", 0x5D, 0x1C): "HARDWARE IMPENDING FAILURE DRIVE CALIBRATION RETRY COUNT",
    struct.pack(">BB", 0x5D, 0x20): "CONTROLLER IMPENDING FAILURE GENERAL HARD DRIVE FAILURE",
    struct.pack(">BB", 0x5D, 0x21): "CONTROLLER IMPENDING FAILURE DRIVE ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x22): "CONTROLLER IMPENDING FAILURE DATA ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x23): "CONTROLLER IMPENDING FAILURE SEEK ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x24): "CONTROLLER IMPENDING FAILURE TOO MANY BLOCK REASSIGNS",
    struct.pack(">BB", 0x5D, 0x25): "CONTROLLER IMPENDING FAILURE ACCESS TIMES TOO HIGH",
    struct.pack(">BB", 0x5D, 0x26): "CONTROLLER IMPENDING FAILURE START UNIT TIMES TOO HIGH",
    struct.pack(">BB", 0x5D, 0x27): "CONTROLLER IMPENDING FAILURE CHANNEL PARAMETRICS",
    struct.pack(">BB", 0x5D, 0x28): "CONTROLLER IMPENDING FAILURE CONTROLLER DETECTED",
    struct.pack(">BB", 0x5D, 0x29): "CONTROLLER IMPENDING FAILURE THROUGHPUT PERFORMANCE",
    struct.pack(">BB", 0x5D, 0x2A): "CONTROLLER IMPENDING FAILURE SEEK TIME PERFORMANCE",
    struct.pack(">BB", 0x5D, 0x2B): "CONTROLLER IMPENDING FAILURE SPIN-UP RETRY COUNT",
    struct.pack(">BB", 0x5D, 0x2C): "CONTROLLER IMPENDING FAILURE DRIVE CALIBRATION RETRY COUNT",
    struct.pack(">BB", 0x5D, 0x30): "DATA CHANNEL IMPENDING FAILURE GENERAL HARD DRIVE FAILURE",
    struct.pack(">BB", 0x5D, 0x31): "DATA CHANNEL IMPENDING FAILURE DRIVE ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x32): "DATA CHANNEL IMPENDING FAILURE DATA ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x33): "DATA CHANNEL IMPENDING FAILURE SEEK ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x34): "DATA CHANNEL IMPENDING FAILURE TOO MANY BLOCK REASSIGNS",
    struct.pack(">BB", 0x5D, 0x35): "DATA CHANNEL IMPENDING FAILURE ACCESS TIMES TOO HIGH",
    struct.pack(">BB", 0x5D, 0x36): "DATA CHANNEL IMPENDING FAILURE START UNIT TIMES TOO HIGH",
    struct.pack(">BB", 0x5D, 0x37): "DATA CHANNEL IMPENDING FAILURE CHANNEL PARAMETRICS",
    struct.pack(">BB", 0x5D, 0x38): "DATA CHANNEL IMPENDING FAILURE CONTROLLER DETECTED",
    struct.pack(">BB", 0x5D, 0x39): "DATA CHANNEL IMPENDING FAILURE THROUGHPUT PERFORMANCE",
    struct.pack(">BB", 0x5D, 0x3A): "DATA CHANNEL IMPENDING FAILURE SEEK TIME PERFORMANCE",
    struct.pack(">BB", 0x5D, 0x3B): "DATA CHANNEL IMPENDING FAILURE SPIN-UP RETRY COUNT",
    struct.pack(">BB", 0x5D, 0x3C): "DATA CHANNEL IMPENDING FAILURE DRIVE CALIBRATION RETRY COUNT",
    struct.pack(">BB", 0x5D, 0x40): "SERVO IMPENDING FAILURE GENERAL HARD DRIVE FAILURE",
    struct.pack(">BB", 0x5D, 0x41): "SERVO IMPENDING FAILURE DRIVE ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x42): "SERVO IMPENDING FAILURE DATA ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x43): "SERVO IMPENDING FAILURE SEEK ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x44): "SERVO IMPENDING FAILURE TOO MANY BLOCK REASSIGNS",
    struct.pack(">BB", 0x5D, 0x45): "SERVO IMPENDING FAILURE ACCESS TIMES TOO HIGH",
    struct.pack(">BB", 0x5D, 0x46): "SERVO IMPENDING FAILURE START UNIT TIMES TOO HIGH",
    struct.pack(">BB", 0x5D, 0x47): "SERVO IMPENDING FAILURE CHANNEL PARAMETRICS",
    struct.pack(">BB", 0x5D, 0x48): "SERVO IMPENDING FAILURE CONTROLLER DETECTED",
    struct.pack(">BB", 0x5D, 0x49): "SERVO IMPENDING FAILURE THROUGHPUT PERFORMANCE",
    struct.pack(">BB", 0x5D, 0x4A): "SERVO IMPENDING FAILURE SEEK TIME PERFORMANCE",
    struct.pack(">BB", 0x5D, 0x4B): "SERVO IMPENDING FAILURE SPIN-UP RETRY COUNT",
    struct.pack(">BB", 0x5D, 0x4C): "SERVO IMPENDING FAILURE DRIVE CALIBRATION RETRY COUNT",
    struct.pack(">BB", 0x5D, 0x50): "SPINDLE IMPENDING FAILURE GENERAL HARD DRIVE FAILURE",
    struct.pack(">BB", 0x5D, 0x51): "SPINDLE IMPENDING FAILURE DRIVE ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x52): "SPINDLE IMPENDING FAILURE DATA ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x53): "SPINDLE IMPENDING FAILURE SEEK ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x54): "SPINDLE IMPENDING FAILURE TOO MANY BLOCK REASSIGNS",
    struct.pack(">BB", 0x5D, 0x55): "SPINDLE IMPENDING FAILURE ACCESS TIMES TOO HIGH",
    struct.pack(">BB", 0x5D, 0x56): "SPINDLE IMPENDING FAILURE START UNIT TIMES TOO HIGH",
    struct.pack(">BB", 0x5D, 0x57): "SPINDLE IMPENDING FAILURE CHANNEL PARAMETRICS",
    struct.pack(">BB", 0x5D, 0x58): "SPINDLE IMPENDING FAILURE CONTROLLER DETECTED",
    struct.pack(">BB", 0x5D, 0x59): "SPINDLE IMPENDING FAILURE THROUGHPUT PERFORMANCE",
    struct.pack(">BB", 0x5D, 0x5A): "SPINDLE IMPENDING FAILURE SEEK TIME PERFORMANCE",
    struct.pack(">BB", 0x5D, 0x5B): "SPINDLE IMPENDING FAILURE SPIN-UP RETRY COUNT",
    struct.pack(">BB", 0x5D, 0x5C): "SPINDLE IMPENDING FAILURE DRIVE CALIBRATION RETRY COUNT",
    struct.pack(">BB", 0x5D, 0x60): "FIRMWARE IMPENDING FAILURE GENERAL HARD DRIVE FAILURE",
    struct.pack(">BB", 0x5D, 0x61): "FIRMWARE IMPENDING FAILURE DRIVE ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x62): "FIRMWARE IMPENDING FAILURE DATA ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x63): "FIRMWARE IMPENDING FAILURE SEEK ERROR RATE TOO HIGH",
    struct.pack(">BB", 0x5D, 0x64): "FIRMWARE IMPENDING FAILURE TOO MANY BLOCK REASSIGNS",
    struct.pack(">BB", 0x5D, 0x65): "FIRMWARE IMPENDING FAILURE ACCESS TIMES TOO HIGH",
    struct.pack(">BB", 0x5D, 0x66): "FIRMWARE IMPENDING FAILURE START UNIT TIMES TOO HIGH",
    struct.pack(">BB", 0x5D, 0x67): "FIRMWARE IMPENDING FAILURE CHANNEL PARAMETRICS",
    struct.pack(">BB", 0x5D, 0x68): "FIRMWARE IMPENDING FAILURE CONTROLLER DETECTED",
    struct.pack(">BB", 0x5D, 0x69): "FIRMWARE IMPENDING FAILURE THROUGHPUT PERFORMANCE",
    struct.pack(">BB", 0x5D, 0x6A): "FIRMWARE IMPENDING FAILURE SEEK TIME PERFORMANCE",
    struct.pack(">BB", 0x5D, 0x6B): "FIRMWARE IMPENDING FAILURE SPIN-UP RETRY COUNT",
    struct.pack(">BB", 0x5D, 0x6C): "FIRMWARE IMPENDING FAILURE DRIVE CALIBRATION RETRY COUNT",
    struct.pack(">BB", 0x5D, 0xFF): "FAILURE PREDICTION THRESHOLD EXCEEDED (FALSE)",
    struct.pack(">BB", 0x5E, 0x00): "LOW POWER CONDITION ON",
    struct.pack(">BB", 0x5E, 0x01): "IDLE CONDITION ACTIVATED BY TIMER",
    struct.pack(">BB", 0x5E, 0x02): "STANDBY CONDITION ACTIVATED BY TIMER",
    struct.pack(">BB", 0x5E, 0x03): "IDLE CONDITION ACTIVATED BY COMMAND",
    struct.pack(">BB", 0x5E, 0x04): "STANDBY CONDITION ACTIVATED BY COMMAND",
    struct.pack(">BB", 0x5E, 0x05): "IDLE_B CONDITION ACTIVATED BY TIMER",
    struct.pack(">BB", 0x5E, 0x06): "IDLE_B CONDITION ACTIVATED BY COMMAND",
    struct.pack(">BB", 0x5E, 0x07): "IDLE_C CONDITION ACTIVATED BY TIMER",
    struct.pack(">BB", 0x5E, 0x08): "IDLE_C CONDITION ACTIVATED BY COMMAND",
    struct.pack(">BB", 0x5E, 0x09): "STANDBY_Y CONDITION ACTIVATED BY TIMER",
    struct.pack(">BB", 0x5E, 0x0A): "STANDBY_Y CONDITION ACTIVATED BY COMMAND",
    struct.pack(">BB", 0x5E, 0x41): "POWER STATE CHANGE TO ACTIVE",
    struct.pack(">BB", 0x5E, 0x42): "POWER STATE CHANGE TO IDLE",
    struct.pack(">BB", 0x5E, 0x43): "POWER STATE CHANGE TO STANDBY",
    struct.pack(">BB", 0x5E, 0x45): "POWER STATE CHANGE TO SLEEP",
    struct.pack(">BB", 0x5E, 0x47): "POWER STATE CHANGE TO DEVICE CONTROL",
    struct.pack(">BB", 0x5F, 0x00): "5Fh/00h",
    struct.pack(">BB", 0x60, 0x00): "LAMP FAILURE",
    struct.pack(">BB", 0x61, 0x00): "VIDEO ACQUISITION ERROR",
    struct.pack(">BB", 0x61, 0x01): "UNABLE TO ACQUIRE VIDEO",
    struct.pack(">BB", 0x61, 0x02): "OUT OF FOCUS",
    struct.pack(">BB", 0x62, 0x00): "SCAN HEAD POSITIONING ERROR",
    struct.pack(">BB", 0x63, 0x00): "END OF USER AREA ENCOUNTERED ON THIS TRACK",
    struct.pack(">BB", 0x63, 0x01): "PACKET DOES NOT FIT IN AVAILABLE SPACE",
    struct.pack(">BB", 0x64, 0x00): "ILLEGAL MODE FOR THIS TRACK",
    struct.pack(">BB", 0x64, 0x01): "INVALID PACKET SIZE",
    struct.pack(">BB", 0x65, 0x00): "VOLTAGE FAULT",
    struct.pack(">BB", 0x66, 0x00): "AUTOMATIC DOCUMENT FEEDER COVER UP",
    struct.pack(">BB", 0x66, 0x01): "AUTOMATIC DOCUMENT FEEDER LIFT UP",
    struct.pack(">BB", 0x66, 0x02): "DOCUMENT JAM IN AUTOMATIC DOCUMENT FEEDER",
    struct.pack(">BB", 0x66, 0x03): "DOCUMENT MISS FEED AUTOMATIC IN DOCUMENT FEEDER",
    struct.pack(">BB", 0x67, 0x00): "CONFIGURATION FAILURE",
    struct.pack(">BB", 0x67, 0x01): "CONFIGURATION OF INCAPABLE LOGICAL UNITS FAILED",
    struct.pack(">BB", 0x67, 0x02): "ADD LOGICAL UNIT FAILED",
    struct.pack(">BB", 0x67, 0x03): "MODIFICATION OF LOGICAL UNIT FAILED",
    struct.pack(">BB", 0x67, 0x04): "EXCHANGE OF LOGICAL UNIT FAILED",
    struct.pack(">BB", 0x67, 0x05): "REMOVE OF LOGICAL UNIT FAILED",
    struct.pack(">BB", 0x67, 0x06): "ATTACHMENT OF LOGICAL UNIT FAILED",
    struct.pack(">BB", 0x67, 0x07): "CREATION OF LOGICAL UNIT FAILED",
    struct.pack(">BB", 0x67, 0x08): "ASSIGN FAILURE OCCURRED",
    struct.pack(">BB", 0x67, 0x09): "MULTIPLY ASSIGNED LOGICAL UNIT",
    struct.pack(">BB", 0x67, 0x0A): "SET TARGET PORT GROUPS COMMAND FAILED",
    struct.pack(">BB", 0x67, 0x0B): "ATA DEVICE FEATURE NOT ENABLED",
    struct.pack(">BB", 0x68, 0x00): "LOGICAL UNIT NOT CONFIGURED",
    struct.pack(">BB", 0x69, 0x00): "DATA LOSS ON LOGICAL UNIT",
    struct.pack(">BB", 0x69, 0x01): "MULTIPLE LOGICAL UNIT FAILURES",
    struct.pack(">BB", 0x69, 0x02): "PARITY/DATA MISMATCH",
    struct.pack(">BB", 0x6A, 0x00): "INFORMATIONAL, REFER TO LOG",
    struct.pack(">BB", 0x6B, 0x00): "STATE CHANGE HAS OCCURRED",
    struct.pack(">BB", 0x6B, 0x01): "REDUNDANCY LEVEL GOT BETTER",
    struct.pack(">BB", 0x6B, 0x02): "REDUNDANCY LEVEL GOT WORSE",
    struct.pack(">BB", 0x6C, 0x00): "REBUILD FAILURE OCCURRED",
    struct.pack(">BB", 0x6D, 0x00): "RECALCULATE FAILURE OCCURRED",
    struct.pack(">BB", 0x6E, 0x00): "COMMAND TO LOGICAL UNIT FAILED",
    struct.pack(">BB", 0x6F, 0x00): "COPY PROTECTION KEY EXCHANGE FAILURE - AUTHENTICATION FAILURE",
    struct.pack(">BB", 0x6F, 0x01): "COPY PROTECTION KEY EXCHANGE FAILURE - KEY NOT PRESENT",
    struct.pack(">BB", 0x6F, 0x02): "COPY PROTECTION KEY EXCHANGE FAILURE - KEY NOT ESTABLISHED",
    struct.pack(">BB", 0x6F, 0x03): "READ OF SCRAMBLED SECTOR WITHOUT AUTHENTICATION",
    struct.pack(">BB", 0x6F, 0x04): "MEDIA REGION CODE IS MISMATCHED TO LOGICAL UNIT REGION",
    struct.pack(">BB", 0x6F, 0x05): "DRIVE REGION MUST BE PERMANENT/REGION RESET COUNT ERROR",
    struct.pack(">BB", 0x6F, 0x06): "INSUFFICIENT BLOCK COUNT FOR BINDING NONCE RECORDING",
    struct.pack(">BB", 0x6F, 0x07): "CONFLICT IN BINDING NONCE RECORDING",
    struct.pack(">BB", 0x71, 0x00): "DECOMPRESSION EXCEPTION LONG ALGORITHM ID",
    struct.pack(">BB", 0x72, 0x00): "SESSION FIXATION ERROR",
    struct.pack(">BB", 0x72, 0x01): "SESSION FIXATION ERROR WRITING LEAD-IN",
    struct.pack(">BB", 0x72, 0x02): "SESSION FIXATION ERROR WRITING LEAD-OUT",
    struct.pack(">BB", 0x72, 0x03): "SESSION FIXATION ERROR - INCOMPLETE TRACK IN SESSION",
    struct.pack(">BB", 0x72, 0x04): "EMPTY OR PARTIALLY WRITTEN RESERVED TRACK",
    struct.pack(">BB", 0x72, 0x05): "NO MORE TRACK RESERVATIONS ALLOWED",
    struct.pack(">BB", 0x72, 0x06): "RMZ EXTENSION IS NOT ALLOWED",
    struct.pack(">BB", 0x72, 0x07): "NO MORE TEST ZONE EXTENSIONS ARE ALLOWED",
    struct.pack(">BB", 0x73, 0x00): "CD CONTROL ERROR",
    struct.pack(">BB", 0x73, 0x01): "POWER CALIBRATION AREA ALMOST FULL",
    struct.pack(">BB", 0x73, 0x02): "POWER CALIBRATION AREA IS FULL",
    struct.pack(">BB", 0x73, 0x03): "POWER CALIBRATION AREA ERROR",
    struct.pack(">BB", 0x73, 0x04): "PROGRAM MEMORY AREA UPDATE FAILURE",
    struct.pack(">BB", 0x73, 0x05): "PROGRAM MEMORY AREA IS FULL",
    struct.pack(">BB", 0x73, 0x06): "RMA/PMA IS ALMOST FULL",
    struct.pack(">BB", 0x73, 0x10): "CURRENT POWER CALIBRATION AREA ALMOST FULL",
    struct.pack(">BB", 0x73, 0x11): "CURRENT POWER CALIBRATION AREA IS FULL",
    struct.pack(">BB", 0x73, 0x17): "RDZ IS FULL",
    struct.pack(">BB", 0x74, 0x00): "SECURITY ERROR",
    struct.pack(">BB", 0x74, 0x01): "UNABLE TO DECRYPT DATA",
    struct.pack(">BB", 0x74, 0x02): "UNENCRYPTED DATA ENCOUNTERED WHILE DECRYPTING",
    struct.pack(">BB", 0x74, 0x03): "INCORRECT DATA ENCRYPTION KEY",
    struct.pack(">BB", 0x74, 0x04): "CRYPTOGRAPHIC INTEGRITY VALIDATION FAILED",
    struct.pack(">BB", 0x74, 0x05): "ERROR DECRYPTING DATA",
    struct.pack(">BB", 0x74, 0x06): "UNKNOWN SIGNATURE VERIFICATION KEY",
    struct.pack(">BB", 0x74, 0x07): "ENCRYPTION PARAMETERS NOT USEABLE",
    struct.pack(">BB", 0x74, 0x08): "DIGITAL SIGNATURE VALIDATION FAILURE",
    struct.pack(">BB", 0x74, 0x09): "ENCRYPTION MODE MISMATCH ON READ",
    struct.pack(">BB", 0x74, 0x0A): "ENCRYPTED BLOCK NOT RAW READ ENABLED",
    struct.pack(">BB", 0x74, 0x0B): "INCORRECT ENCRYPTION PARAMETERS",
    struct.pack(">BB", 0x74, 0x0C): "UNABLE TO DECRYPT PARAMETER LIST",
    struct.pack(">BB", 0x74, 0x0D): "ENCRYPTION ALGORITHM DISABLED",
    struct.pack(">BB", 0x74, 0x10): "SA CREATION PARAMETER VALUE INVALID",
    struct.pack(">BB", 0x74, 0x11): "SA CREATION PARAMETER VALUE REJECTED",
    struct.pack(">BB", 0x74, 0x12): "INVALID SA USAGE",
    struct.pack(">BB", 0x74, 0x21): "DATA ENCRYPTION CONFIGURATION PREVENTED",
    struct.pack(">BB", 0x74, 0x30): "SA CREATION PARAMETER NOT SUPPORTED",
    struct.pack(">BB", 0x74, 0x40): "AUTHENTICATION FAILED",
    struct.pack(">BB", 0x74, 0x61): "EXTERNAL DATA ENCRYPTION KEY MANAGER ACCESS ERROR",
    struct.pack(">BB", 0x74, 0x62): "EXTERNAL DATA ENCRYPTION KEY MANAGER ERROR",
    struct.pack(">BB", 0x74, 0x63): "EXTERNAL DATA ENCRYPTION KEY NOT FOUND",
    struct.pack(">BB", 0x74, 0x64): "EXTERNAL DATA ENCRYPTION REQUEST NOT AUTHORIZED",
    struct.pack(">BB", 0x74, 0x6E): "EXTERNAL DATA ENCRYPTION CONTROL TIMEOUT",
    struct.pack(">BB", 0x74, 0x6F): "EXTERNAL DATA ENCRYPTION CONTROL ERROR",
    struct.pack(">BB", 0x74, 0x71): "LOGICAL UNIT ACCESS NOT AUTHORIZED",
    struct.pack(">BB", 0x74, 0x79): "SECURITY CONFLICT IN TRANSLATED DEVICE",
    struct.pack(">BB", 0x75, 0x00): "VENDOR SPECIFIC",
    struct.pack(">BB", 0x76, 0x00): "VENDOR SPECIFIC",
    struct.pack(">BB", 0x77, 0x00): "VENDOR SPECIFIC",
    struct.pack(">BB", 0x78, 0x00): "VENDOR SPECIFIC",
    struct.pack(">BB", 0x79, 0x00): "VENDOR SPECIFIC",
    struct.pack(">BB", 0x7A, 0x00): "VENDOR SPECIFIC",
    struct.pack(">BB", 0x7B, 0x00): "VENDOR SPECIFIC",
    struct.pack(">BB", 0x7C, 0x00): "VENDOR SPECIFIC",
    struct.pack(">BB", 0x7D, 0x00): "VENDOR SPECIFIC",
    struct.pack(">BB", 0x7E, 0x00): "VENDOR SPECIFIC",
    struct.pack(">BB", 0x7F, 0x00): "VENDOR SPECIFIC",
}

for i in xrange(0x80, 0xFF):
    ASC_CODES[struct.pack(">BB", 0x40, i)] = "DIAGNOSTIC FAILURE ON COMPONENT %2X" % (i,)

for i in xrange(0, 0xFF):
    ASC_CODES[struct.pack(">BB", 0x4D, i)] = "TAGGED OVERLAPPED COMMANDS (%2X = TASK TAG)" % (i,)
    ASC_CODES[struct.pack(">BB", 0x70, i)] = "DECOMPRESSION EXCEPTION SHORT ALGORITHM ID OF %2X" % (i,)

class AdditionalSenseCode(Struct):
    _fields_ = [
        UBInt8("code"),
        UBInt8("qualifier")
    ]

    @property
    def code_name(self):
        combined_code = struct.pack(">BB", self.code, self.qualifier)
        return ASC_CODES.get(combined_code, "Unknown code, qualifier: {}, {}".format(self.code, self.qualifier))

    def to_repr(self, context=None):
        return "AdditionalSenseCode(%s: code=0x%02x, qualifier=0x%02x)" % (self.code_name, self.code, self.qualifier)
