
import logging
from pyvisdk.exceptions import InvalidArgumentError

########################################
# Automatically generated, do not edit.
########################################

log = logging.getLogger(__name__)

def ClusterConfigSpecEx(vim, *args, **kwargs):
    '''The ClusterConfigSpecEx data object provides a set of update specifications for
    complete cluster configuration. You can configure a cluster when you create a
    new cluster (the CreateClusterEx method) or when you reconfigure an existing
    cluster (the ReconfigureComputeResource_Task method).All fields are optional.
    If you set the parameter to when you call ReconfigureComputeResource_Task, an
    unset property has no effect on the existing property value in the cluster
    configuration on the Server. If you set the parameter to when you reconfigure a
    cluster, the cluster configuration is reverted to the default values, then the
    new configuration values are applied.Use the properties defined for this object
    to configure the following services:* HA (High Availability) - provides
    failover protection for virtual machines running in a cluster of ESX Server
    hosts. The virtual machines are located in a Datastore, which provides shared
    storage for the cluster. When a failure occurs that affects a protected virtual
    machine, HA will restart the virtual machine on another host. When HA detects a
    host failure, either the host has failed or it may be isolated from the
    network. The HA agent on an isolated host will power off or shutdown the
    virtual machines running on that host so that they can be restarted elsewhere.
    See ClusterDasVmSettingsIsolationResponse for information about how a host
    handles network isolation.When it chooses a failover host, HA selects a host
    that is compatible with the virtual machine and that can support resource
    allocation for that virtual machine so that service level guarantees remain
    intact. HA does not consider hosts that are in maintenance mode, standby mode,
    or which are disconnected from the vCenter Server. When a host powers on or
    becomes available again, HA is reenabled on that host, so it becomes available
    for failover again. VMware recommends that you configure hosts and virtual
    machines so that all virtual machines can run on all hosts in the cluster. This
    will maximize the chances of restarting a VM after a failure.HA also restarts a
    virtual machine after a guest operating system failure. In this case, the
    virtual machine health monitoring service detects the guest failure, and HA
    restarts the virtual machine on the same host. The service monitors heartbeats
    from the VmTools service and optionally heartbeats that are generated by a
    third-party application monitor. See ClusterVmToolsMonitoringSettings and
    ClusterDasConfigInfo.vmMonitoring.To enable HA for a cluster, set the
    ClusterDasConfigInfo.enabled property to and the
    ClusterDasConfigInfo.hostMonitoring property to enabled. (The vSphere API uses
    the substring "das" in object, property, and method names for HA. )* DRS
    (Distributed Resource Scheduling) - provides automatic initial virtual machine
    placement on any of the hosts in the cluster. DRS also makes automatic resource
    relocation and optimization decisions as hosts or virtual machines are added or
    removed from the cluster. You can also configure DRS for manual control, so
    that it only makes recommendations that you can review and carry out.To enable
    DRS for a cluster, set the ClusterDrsConfigInfo.enabled property to .* DPM
    (Distributed Power Management) - supports optimized power consumption on the
    cluster. When virtual machines in a DRS cluster require fewer resources, DPM
    consolidates workloads onto fewer servers while maintaining quality of service
    guarantees and powers off the rest to reduce power consumption. When more
    resources are required, DPM brings the powered-down hosts online.To enable DPM
    for a cluster, set the ClusterDpmConfigInfo.enabled property to .The HA, DRS,
    and DPM services are integrated with the FT (Fault Tolerance) and EVC (Enhanced
    vMotion Compatibility) services. Use the CreateSecondaryVM_Task method to
    establish fault tolerance for a virtual machine. Use the vSphere Client to
    configure EVC. The HA, DRS, DPM, FT, and EVC services interact under the
    following circumstances.* To determine initial placement of a virtual machine,
    DRS checks to see if the HA admission control policy on a potential host
    supports the addition of the powered on virtual machine. With the default
    setting, DRS will not power on more than four FT virtual machines per host. You
    can use the configuration editor in the vSphere Client to set the HA advanced
    option to the desired number or to zero to disable. * When a host fails, HA
    determines placement within the cluster when it restarts the virtual machines.
    If there is insufficient capacity, and DPM has put one or more compatible hosts
    into standby, HA relies on DPM to bring more capacity online. * To use FT in a
    cluster, the cluster must be HA-enabled. * You can disable HA in a cluster
    while there are FT virtual machines registered on hosts in the cluster. While
    HA is disabled, powered on FT virtual machines will continue to run, but HA
    will not restart any virtual machines after a failure. When HA is disabled, you
    cannot use the following FT operations: * Turn on FT (CreateSecondaryVM_Task) *
    Enable FT (EnableSecondaryVM_Task) * Power on an FT virtual machine
    (PowerOnVM_Task) * Test failover and test secondary restart
    (TerminateFaultTolerantVM_Task) * In a cluster using DRS and HA with admission
    control turned on (ClusterDasConfigInfo.admissionControlEnabled), the vCenter
    Server might not migrate virtual machines from hosts entering maintenance mode.
    This is because resources are reserved to maintain the failover level. You must
    use vMotion to manually migrate the virtual machines off the hosts.When
    admission control is disabled, failover resource constraints are not passed on
    to DRS and DPM. The constraints are not enforced.* DRS determines virtual
    machine placement and status (maintenance mode, standby mode) regardless of the
    impact this might have on failover requirements. * DPM powers off hosts (places
    them in standby mode) even if doing so violates failover requirements. If there
    is insufficient capacity when a failover occurs, DPM will attempt to bring more
    capacity online in order to correct the situation. * You must enable EVC in a
    cluster to enable DRS to manage FT primary and secondary virtual machine pairs
    in the cluster. For information about EVC clusters, see EVCMode.If EVC is
    disabled, vCenter automatically creates overrides to disable DRS for FT
    primary/secondary pairs in the cluster. vCenter will still use DRS to place a
    secondary virtual machine when it powers on. Attempts to remove the overrides
    or to enable DRS operations will fail.* EVC clusters support load balancing of
    powered on FT primary and secondary virtual machines. DRS behavior is governed
    by the overrides defined for the primary virtual machine. The secondary
    inherits DRS behavior from its primary. If you do not configure a DRS override
    for an FT virtual machine, DRS uses the cluster default
    (defaultVmBehavior).High Availability was previously called Distributed
    Availability Services.'''
    
    obj = vim.client.factory.create('ns0:ClusterConfigSpecEx')

    # do some validation checking...
    if (len(args) + len(kwargs)) < 0:
        raise IndexError('Expected at least 1 arguments got: %d' % len(args))

    required = [  ]
    optional = [ 'dasConfig', 'dasVmConfigSpec', 'dpmConfig', 'dpmHostConfigSpec', 'drsConfig',
        'drsVmConfigSpec', 'groupSpec', 'rulesSpec', 'spbmEnabled', 'vmSwapPlacement',
        'dynamicProperty', 'dynamicType' ]

    for name, arg in zip(required+optional, args):
        setattr(obj, name, arg)

    for name, value in kwargs.items():
        if name in required + optional:
            setattr(obj, name, value)
        else:
            raise InvalidArgumentError("Invalid argument: %s.  Expected one of %s" % (name, ", ".join(required + optional)))

    return obj
    