from pyVmomi.VmomiSupport import CreateDataType,  CreateManagedType,  CreateEnumType,  AddVersion,  AddVersionParent,  F_LINK,  F_LINKABLE,  F_OPTIONAL


#### Ugly hack to patch to add internal methods to vim.HostSystem

from pyVmomi import vim
from pyVmomi.VmomiSupport import Capitalize, ManagedMethod, GetWsdlNamespace, LazyObject
from pyVmomi.VmomiSupport import _SetWsdlMethod, _dependencyMap
def AddWsdlMethod(_type, mVmodl, mWsdl, mVersion, mParams, mResult, mPrivilege, mFaults):
    vmodlName = _type.__name__

    if mFaults is None:
        mFaults = []
    mName = Capitalize(mVmodl)
    params = tuple([LazyObject(name=p[0], typeName=p[1], version=p[2], flags=p[3],
                    privId=p[4]) for p in mParams])
    info = LazyObject(name=mName, typeName=vmodlName, wsdlName=mWsdl,
                      version=mVersion, params=params, isTask=False,
                      resultFlags=mResult[0], resultName=mResult[1],
                      methodResultName=mResult[2], privId=mPrivilege, faults=mFaults)
    mm = ManagedMethod(info)
    ns = GetWsdlNamespace(info.version)
    method = _SetWsdlMethod(ns, info.wsdlName, mm)
    _type._methodInfo[mName] = info
    setattr(_type, mWsdl, mm)
    _dependencyMap[vmodlName].add(info.wsdlName)

for patch in [
  ("retrieveManagedMethodExecuter", "RetrieveManagedMethodExecuter", "vim.version.version7", (), (F_OPTIONAL, "vmodl.reflect.ManagedMethodExecuter", "vmodl.reflect.ManagedMethodExecuter"), "System.Read", None),
  ('retrieveDynamicTypeManager', 'RetrieveDynamicTypeManager', 'vim.version.version7', (), (F_OPTIONAL, 'vmodl.reflect.DynamicTypeManager', 'vmodl.reflect.DynamicTypeManager'), 'System.Read', None)]:
  AddWsdlMethod(vim.HostSystem, *patch)

####

# new names used by MMESoapStubAdapter. Turns out ReflectTypes.py is a bit outdated
CreateDataType("vmodl.Reflect.ManagedMethodExecutor.SoapArgument", "ReflectManagedMethodExecuterSoapArgument", "vmodl.DynamicData", "vmodl.reflect.version.version1", [("name", "string", "vmodl.reflect.version.version1", 0), ("val", "string", "vmodl.reflect.version.version1", 0)])
CreateDataType("vmodl.Reflect.ManagedMethodExecutor.SoapFault", "ReflectManagedMethodExecuterSoapFault", "vmodl.DynamicData", "vmodl.reflect.version.version1", [("faultMsg", "string", "vmodl.reflect.version.version1", 0), ("faultDetail", "string", "vmodl.reflect.version.version1", F_OPTIONAL)])
CreateDataType("vmodl.Reflect.ManagedMethodExecutor.SoapResult", "ReflectManagedMethodExecuterSoapResult", "vmodl.DynamicData", "vmodl.reflect.version.version1", [("response", "string", "vmodl.reflect.version.version1", F_OPTIONAL), ("fault", "vmodl.reflect.ManagedMethodExecuter.SoapFault", "vmodl.reflect.version.version1", F_OPTIONAL)])


# the following code is autogenerated using tools/generate_cli_types.py
# DO NOT EDIT

CreateDataType("vim.EsxCLI.device.alias.get.Device", "VimEsxCLIdevicealiasgetDevice", "vmodl.DynamicData", "vim.version.version5", [("Alias", "string", "vim.version.version5", F_OPTIONAL), ("BusType", "string", "vim.version.version5", F_OPTIONAL), ("BusspecificAddress", "string", "vim.version.version5", F_OPTIONAL), ("HardwareLocation", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.device.alias.list.Device", "VimEsxCLIdevicealiaslistDevice", "vmodl.DynamicData", "vim.version.version5", [("Alias", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.esxcli.command.list.EsxCliCommand", "VimEsxCLIesxclicommandlistEsxCliCommand", "vmodl.DynamicData", "vim.version.version5", [("Command", "string", "vim.version.version5", F_OPTIONAL), ("Namespace", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.fcoe.adapter.list.FcoeAdapterDevice", "VimEsxCLIfcoeadapterlistFcoeAdapterDevice", "vmodl.DynamicData", "vim.version.version5", [("AdapterName", "string", "vim.version.version5", F_OPTIONAL), ("FCFMAC", "string", "vim.version.version5", F_OPTIONAL), ("PhysicalNIC", "string", "vim.version.version5", F_OPTIONAL), ("SourceMAC", "string", "vim.version.version5", F_OPTIONAL), ("UserPriority", "long", "vim.version.version5", F_OPTIONAL), ("VLANid", "long", "vim.version.version5", F_OPTIONAL), ("VNPortMAC", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.fcoe.nic.list.NicDevice", "VimEsxCLIfcoeniclistNicDevice", "vmodl.DynamicData", "vim.version.version5", [("Active", "boolean", "vim.version.version5", F_OPTIONAL), ("FCOENICName", "string", "vim.version.version5", F_OPTIONAL), ("PrioritySettable", "boolean", "vim.version.version5", F_OPTIONAL), ("SourceMAC", "string", "vim.version.version5", F_OPTIONAL), ("SourceMACSettable", "boolean", "vim.version.version5", F_OPTIONAL), ("UserPriority", "long", "vim.version.version5", F_OPTIONAL), ("VLANRangeSettable", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.graphics.device.list.GraphicsDevice", "VimEsxCLIgraphicsdevicelistGraphicsDevice", "vmodl.DynamicData", "vim.version.version5", [("Address", "string", "vim.version.version5", F_OPTIONAL), ("DeviceName", "string", "vim.version.version5", F_OPTIONAL), ("GraphicsType", "string", "vim.version.version5", F_OPTIONAL), ("MemorySizeinKB", "long", "vim.version.version5", F_OPTIONAL), ("NumberofVMs", "long", "vim.version.version5", F_OPTIONAL), ("VendorName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.graphics.vm.list.VM", "VimEsxCLIgraphicsvmlistVM", "vmodl.DynamicData", "vim.version.version5", [("DeviceAddress", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("WorldID", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.bootdevice.list.BootDeviceList", "VimEsxCLIhardwarebootdevicelistBootDeviceList", "vmodl.DynamicData", "vim.version.version5", [("BootOrder", "long", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("Type", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.cpu.cpuid.get.CpuCpuId", "VimEsxCLIhardwarecpucpuidgetCpuCpuId", "vmodl.DynamicData", "vim.version.version5", [("EAX", "long", "vim.version.version5", F_OPTIONAL), ("EBX", "long", "vim.version.version5", F_OPTIONAL), ("ECX", "long", "vim.version.version5", F_OPTIONAL), ("EDX", "long", "vim.version.version5", F_OPTIONAL), ("Level", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.cpu.global.get.Cpu", "VimEsxCLIhardwarecpuglobalgetCpu", "vmodl.DynamicData", "vim.version.version5", [("CPUCores", "long", "vim.version.version5", F_OPTIONAL), ("CPUPackages", "long", "vim.version.version5", F_OPTIONAL), ("CPUThreads", "long", "vim.version.version5", F_OPTIONAL), ("HVReplayCapable", "boolean", "vim.version.version5", F_OPTIONAL), ("HVReplayDisabledReasons", "string[]", "vim.version.version5", F_OPTIONAL), ("HVSupport", "long", "vim.version.version5", F_OPTIONAL), ("HyperthreadingActive", "boolean", "vim.version.version5", F_OPTIONAL), ("HyperthreadingEnabled", "boolean", "vim.version.version5", F_OPTIONAL), ("HyperthreadingSupported", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.cpu.list.Cpu", "VimEsxCLIhardwarecpulistCpu", "vmodl.DynamicData", "vim.version.version5", [("APICID", "long", "vim.version.version5", F_OPTIONAL), ("Brand", "string", "vim.version.version5", F_OPTIONAL), ("BusSpeed", "long", "vim.version.version5", F_OPTIONAL), ("CoreSpeed", "long", "vim.version.version5", F_OPTIONAL), ("Family", "long", "vim.version.version5", F_OPTIONAL), ("Id", "long", "vim.version.version5", F_OPTIONAL), ("L2CacheAssociativity", "long", "vim.version.version5", F_OPTIONAL), ("L2CacheCPUCount", "long", "vim.version.version5", F_OPTIONAL), ("L2CacheLineSize", "long", "vim.version.version5", F_OPTIONAL), ("L2CacheSize", "long", "vim.version.version5", F_OPTIONAL), ("L3CacheAssociativity", "long", "vim.version.version5", F_OPTIONAL), ("L3CacheCPUCount", "long", "vim.version.version5", F_OPTIONAL), ("L3CacheLineSize", "long", "vim.version.version5", F_OPTIONAL), ("L3CacheSize", "long", "vim.version.version5", F_OPTIONAL), ("Model", "long", "vim.version.version5", F_OPTIONAL), ("Node", "long", "vim.version.version5", F_OPTIONAL), ("PackageId", "long", "vim.version.version5", F_OPTIONAL), ("Stepping", "long", "vim.version.version5", F_OPTIONAL), ("Type", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.ipmi.fru.get.IpmiFRUConfig", "VimEsxCLIhardwareipmifrugetIpmiFRUConfig", "vmodl.DynamicData", "vim.version.version5", [("DeviceIDs", "string[]", "vim.version.version5", F_OPTIONAL), ("Features", "string[]", "vim.version.version5", F_OPTIONAL), ("FormattedRaw", "string[]", "vim.version.version5", F_OPTIONAL), ("Raw", "string[]", "vim.version.version5", F_OPTIONAL), ("Sizebytes", "long[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.ipmi.fru.list.IpmiFRU", "VimEsxCLIhardwareipmifrulistIpmiFRU", "vmodl.DynamicData", "vim.version.version5", [("AssetTag", "string", "vim.version.version5", F_OPTIONAL), ("EntityInstance", "string", "vim.version.version5", F_OPTIONAL), ("FormattedRaw", "string", "vim.version.version5", F_OPTIONAL), ("ManufacturerName", "string", "vim.version.version5", F_OPTIONAL), ("ManufacturerTimeStamp", "string", "vim.version.version5", F_OPTIONAL), ("PartName", "string", "vim.version.version5", F_OPTIONAL), ("PartNumber", "string", "vim.version.version5", F_OPTIONAL), ("Raw", "string", "vim.version.version5", F_OPTIONAL), ("SerialNumber", "string", "vim.version.version5", F_OPTIONAL), ("Type", "string", "vim.version.version5", F_OPTIONAL), ("Version", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.ipmi.sdr.get.IpmiSDRConfig", "VimEsxCLIhardwareipmisdrgetIpmiSDRConfig", "vmodl.DynamicData", "vim.version.version5", [("Feature", "string[]", "vim.version.version5", F_OPTIONAL), ("FormattedRaw", "string[]", "vim.version.version5", F_OPTIONAL), ("FreeSpace", "long[]", "vim.version.version5", F_OPTIONAL), ("LastAdded", "string[]", "vim.version.version5", F_OPTIONAL), ("LastCleared", "string[]", "vim.version.version5", F_OPTIONAL), ("Raw", "string[]", "vim.version.version5", F_OPTIONAL), ("TotalRecords", "long[]", "vim.version.version5", F_OPTIONAL), ("Version", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.ipmi.sdr.list.IpmiSDR", "VimEsxCLIhardwareipmisdrlistIpmiSDR", "vmodl.DynamicData", "vim.version.version5", [("BaseUnit", "string", "vim.version.version5", F_OPTIONAL), ("ComputedReading", "string", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("EntityInstance", "string", "vim.version.version5", F_OPTIONAL), ("FormattedRaw", "string", "vim.version.version5", F_OPTIONAL), ("NodeSensor", "string", "vim.version.version5", F_OPTIONAL), ("Raw", "string", "vim.version.version5", F_OPTIONAL), ("RawReading", "string", "vim.version.version5", F_OPTIONAL), ("TimestampComment", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.ipmi.sel.get.IpmiSELConfig", "VimEsxCLIhardwareipmiselgetIpmiSELConfig", "vmodl.DynamicData", "vim.version.version5", [("Enabled", "boolean[]", "vim.version.version5", F_OPTIONAL), ("FormattedRaw", "string[]", "vim.version.version5", F_OPTIONAL), ("LastAdded", "string[]", "vim.version.version5", F_OPTIONAL), ("LastCleared", "string[]", "vim.version.version5", F_OPTIONAL), ("MaximumRecords", "long[]", "vim.version.version5", F_OPTIONAL), ("Overflow", "boolean[]", "vim.version.version5", F_OPTIONAL), ("Raw", "string[]", "vim.version.version5", F_OPTIONAL), ("SelClock", "string[]", "vim.version.version5", F_OPTIONAL), ("TotalRecords", "long[]", "vim.version.version5", F_OPTIONAL), ("Version", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.ipmi.sel.list.IpmiSEL", "VimEsxCLIhardwareipmisellistIpmiSEL", "vmodl.DynamicData", "vim.version.version5", [("EventType", "string", "vim.version.version5", F_OPTIONAL), ("FormattedRaw", "string", "vim.version.version5", F_OPTIONAL), ("Message", "string", "vim.version.version5", F_OPTIONAL), ("Raw", "string", "vim.version.version5", F_OPTIONAL), ("RecordId", "long", "vim.version.version5", F_OPTIONAL), ("SELType", "string", "vim.version.version5", F_OPTIONAL), ("SensorNumber", "string", "vim.version.version5", F_OPTIONAL), ("When", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.memory.get.Memory", "VimEsxCLIhardwarememorygetMemory", "vmodl.DynamicData", "vim.version.version5", [("NUMANodeCount", "long", "vim.version.version5", F_OPTIONAL), ("PhysicalMemory", "long", "vim.version.version5", F_OPTIONAL), ("ReliableMemory", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.pci.list.PciDevice", "VimEsxCLIhardwarepcilistPciDevice", "vmodl.DynamicData", "vim.version.version5", [("Address", "string", "vim.version.version5", F_OPTIONAL), ("Bus", "long", "vim.version.version5", F_OPTIONAL), ("Chassis", "long", "vim.version.version5", F_OPTIONAL), ("ConfiguredOwner", "string", "vim.version.version5", F_OPTIONAL), ("CurrentOwner", "string", "vim.version.version5", F_OPTIONAL), ("DependentDevice", "string", "vim.version.version5", F_OPTIONAL), ("DeviceClass", "long", "vim.version.version5", F_OPTIONAL), ("DeviceClassName", "string", "vim.version.version5", F_OPTIONAL), ("DeviceID", "long", "vim.version.version5", F_OPTIONAL), ("DeviceName", "string", "vim.version.version5", F_OPTIONAL), ("FPTSharable", "boolean", "vim.version.version5", F_OPTIONAL), ("Flags", "long", "vim.version.version5", F_OPTIONAL), ("Function", "long", "vim.version.version5", F_OPTIONAL), ("IRQ", "long", "vim.version.version5", F_OPTIONAL), ("InterruptLine", "long", "vim.version.version5", F_OPTIONAL), ("InterruptVector", "long", "vim.version.version5", F_OPTIONAL), ("ModuleID", "long", "vim.version.version5", F_OPTIONAL), ("ModuleName", "string", "vim.version.version5", F_OPTIONAL), ("PCIPin", "long", "vim.version.version5", F_OPTIONAL), ("ParentDevice", "string", "vim.version.version5", F_OPTIONAL), ("PassthruCapable", "boolean", "vim.version.version5", F_OPTIONAL), ("PhysicalSlot", "long", "vim.version.version5", F_OPTIONAL), ("ProgrammingInterface", "long", "vim.version.version5", F_OPTIONAL), ("ResetMethod", "string", "vim.version.version5", F_OPTIONAL), ("RevisionID", "long", "vim.version.version5", F_OPTIONAL), ("Segment", "long", "vim.version.version5", F_OPTIONAL), ("Slot", "long", "vim.version.version5", F_OPTIONAL), ("SlotDescription", "string", "vim.version.version5", F_OPTIONAL), ("SpawnedBus", "long", "vim.version.version5", F_OPTIONAL), ("SubDeviceID", "long", "vim.version.version5", F_OPTIONAL), ("SubVendorID", "long", "vim.version.version5", F_OPTIONAL), ("VMkernelName", "string", "vim.version.version5", F_OPTIONAL), ("VendorID", "long", "vim.version.version5", F_OPTIONAL), ("VendorName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.platform.get.PlatformGet", "VimEsxCLIhardwareplatformgetPlatformGet", "vmodl.DynamicData", "vim.version.version5", [("IPMISupported", "boolean", "vim.version.version5", F_OPTIONAL), ("ProductName", "string", "vim.version.version5", F_OPTIONAL), ("SerialNumber", "string", "vim.version.version5", F_OPTIONAL), ("UUID", "string", "vim.version.version5", F_OPTIONAL), ("VendorName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.hardware.trustedboot.get.TrustedbootGet", "VimEsxCLIhardwaretrustedbootgetTrustedbootGet", "vmodl.DynamicData", "vim.version.version5", [("DrtmEnabled", "boolean", "vim.version.version5", F_OPTIONAL), ("TpmPresent", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.auth.chap.get.AdapterChapAuth", "VimEsxCLIiscsiadapterauthchapgetAdapterChapAuth", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("Direction", "string", "vim.version.version5", F_OPTIONAL), ("Level", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.capabilities.get.AdapterCapabilities", "VimEsxCLIiscsiadaptercapabilitiesgetAdapterCapabilities", "vmodl.DynamicData", "vim.version.version5", [("ARPRedirectSettable", "boolean", "vim.version.version5", F_OPTIONAL), ("AdapterDataDigestSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("AdapterHeaderDigestSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("AuthorizationMethodSettable", "boolean", "vim.version.version5", F_OPTIONAL), ("CHAPAuthorizationSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("DNSBasedAddressSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("DefaultGatewaySettable", "boolean", "vim.version.version5", F_OPTIONAL), ("DelayedAckSettable", "boolean", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("IPConfigurationMethodSettable", "boolean", "vim.version.version5", F_OPTIONAL), ("IPv6Supported", "boolean", "vim.version.version5", F_OPTIONAL), ("ISnSSettable", "boolean", "vim.version.version5", F_OPTIONAL), ("InheritanceSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("KRB5AuthorizationSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("MTUSettable", "boolean", "vim.version.version5", F_OPTIONAL), ("MutualAuthenticationSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("NameAndAliasSettable", "boolean", "vim.version.version5", F_OPTIONAL), ("PrimaryDNSSettable", "boolean", "vim.version.version5", F_OPTIONAL), ("SLPSettable", "boolean", "vim.version.version5", F_OPTIONAL), ("SPKM1AuthorizationSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("SPKM2AuthorizationSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("SRPAuthorizationSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("SecondaryDNSSettable", "boolean", "vim.version.version5", F_OPTIONAL), ("SendtargetDiscoverySettable", "boolean", "vim.version.version5", F_OPTIONAL), ("StaticDiscoverySettable", "boolean", "vim.version.version5", F_OPTIONAL), ("SubnetMaskSetttable", "boolean", "vim.version.version5", F_OPTIONAL), ("TargetLevelAuthenticationSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("TargetLevelDataDigestSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("TargetLevelHeaderDigestSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("TargetLevelMutualAuthenticationSupported", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.discovery.sendtarget.auth.chap.get.Sendtarget", "VimEsxCLIiscsiadapterdiscoverysendtargetauthchapgetSendtarget", "vmodl.DynamicData", "vim.version.version5", [("Direction", "string", "vim.version.version5", F_OPTIONAL), ("Inheritance", "boolean", "vim.version.version5", F_OPTIONAL), ("Level", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Parent", "string", "vim.version.version5", F_OPTIONAL), ("Sendtarget", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.discovery.sendtarget.list.Sendtarget", "VimEsxCLIiscsiadapterdiscoverysendtargetlistSendtarget", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("Sendtarget", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.discovery.sendtarget.param.get.iScsiParm", "VimEsxCLIiscsiadapterdiscoverysendtargetparamgetiScsiParm", "vmodl.DynamicData", "vim.version.version5", [("Current", "string", "vim.version.version5", F_OPTIONAL), ("Default", "string", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("Inherit", "boolean", "vim.version.version5", F_OPTIONAL), ("Max", "string", "vim.version.version5", F_OPTIONAL), ("Min", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Settable", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.discovery.statictarget.list.Statictarget", "VimEsxCLIiscsiadapterdiscoverystatictargetlistStatictarget", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("Boot", "string", "vim.version.version5", F_OPTIONAL), ("TPGT", "string", "vim.version.version5", F_OPTIONAL), ("TargetAddress", "string", "vim.version.version5", F_OPTIONAL), ("TargetName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.firmware.get.AdapterFirmware", "VimEsxCLIiscsiadapterfirmwaregetAdapterFirmware", "vmodl.DynamicData", "vim.version.version5", [("Description", "string", "vim.version.version5", F_OPTIONAL), ("File", "string", "vim.version.version5", F_OPTIONAL), ("Type", "string", "vim.version.version5", F_OPTIONAL), ("Upgrade", "string", "vim.version.version5", F_OPTIONAL), ("Version", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.get.AdapterInfo", "VimEsxCLIiscsiadaptergetAdapterInfo", "vmodl.DynamicData", "vim.version.version5", [("Alias", "string", "vim.version.version5", F_OPTIONAL), ("AsicVersion", "string", "vim.version.version5", F_OPTIONAL), ("BidirectionalTransfersSupported", "string", "vim.version.version5", F_OPTIONAL), ("CanBeNIC", "string", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("DriverName", "string", "vim.version.version5", F_OPTIONAL), ("DriverVersion", "string", "vim.version.version5", F_OPTIONAL), ("FirmwareVersion", "string", "vim.version.version5", F_OPTIONAL), ("HardwareVersion", "string", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("IsInitiator", "string", "vim.version.version5", F_OPTIONAL), ("IsNIC", "string", "vim.version.version5", F_OPTIONAL), ("IsTarget", "string", "vim.version.version5", F_OPTIONAL), ("MaximumCdbLength", "long", "vim.version.version5", F_OPTIONAL), ("Model", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("OptionRomVersion", "string", "vim.version.version5", F_OPTIONAL), ("SerialNumber", "string", "vim.version.version5", F_OPTIONAL), ("TCPProtocolSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("UsingISCSIOffloadEngine", "string", "vim.version.version5", F_OPTIONAL), ("UsingTCPOffloadEngine", "string", "vim.version.version5", F_OPTIONAL), ("Vendor", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.list.iScsiAdapter", "VimEsxCLIiscsiadapterlistiScsiAdapter", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("Driver", "string", "vim.version.version5", F_OPTIONAL), ("State", "string", "vim.version.version5", F_OPTIONAL), ("UID", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.param.get.iScsiParm", "VimEsxCLIiscsiadapterparamgetiScsiParm", "vmodl.DynamicData", "vim.version.version5", [("Current", "string", "vim.version.version5", F_OPTIONAL), ("Default", "string", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("Inherit", "boolean", "vim.version.version5", F_OPTIONAL), ("Max", "string", "vim.version.version5", F_OPTIONAL), ("Min", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Settable", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.target.list.Target", "VimEsxCLIiscsiadaptertargetlistTarget", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("Alias", "string", "vim.version.version5", F_OPTIONAL), ("DiscoveryMethod", "string", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("LastError", "string", "vim.version.version5", F_OPTIONAL), ("SendTargetsDiscoveryEnabled", "boolean", "vim.version.version5", F_OPTIONAL), ("SendTargetsDiscoverySettable", "boolean", "vim.version.version5", F_OPTIONAL), ("Target", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.target.portal.auth.chap.get.TargetAuth", "VimEsxCLIiscsiadaptertargetportalauthchapgetTargetAuth", "vmodl.DynamicData", "vim.version.version5", [("Address", "string", "vim.version.version5", F_OPTIONAL), ("Direction", "string", "vim.version.version5", F_OPTIONAL), ("Inheritance", "boolean", "vim.version.version5", F_OPTIONAL), ("Level", "string", "vim.version.version5", F_OPTIONAL), ("Method", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Parent", "string", "vim.version.version5", F_OPTIONAL), ("TargetName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.target.portal.list.TargetPortal", "VimEsxCLIiscsiadaptertargetportallistTargetPortal", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("IP", "string", "vim.version.version5", F_OPTIONAL), ("Port", "string", "vim.version.version5", F_OPTIONAL), ("Target", "string", "vim.version.version5", F_OPTIONAL), ("Tpgt", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.adapter.target.portal.param.get.iScsiParm", "VimEsxCLIiscsiadaptertargetportalparamgetiScsiParm", "vmodl.DynamicData", "vim.version.version5", [("Current", "string", "vim.version.version5", F_OPTIONAL), ("Default", "string", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("Inherit", "boolean", "vim.version.version5", F_OPTIONAL), ("Max", "string", "vim.version.version5", F_OPTIONAL), ("Min", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Settable", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.ibftboot.get.IbftBoot", "VimEsxCLIiscsiibftbootgetIbftBoot", "vmodl.DynamicData", "vim.version.version5", [("ChapName", "string", "vim.version.version5", F_OPTIONAL), ("ChapType", "long", "vim.version.version5", F_OPTIONAL), ("Dhcp", "boolean", "vim.version.version5", F_OPTIONAL), ("Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("Gateway", "string", "vim.version.version5", F_OPTIONAL), ("IPAddress", "string", "vim.version.version5", F_OPTIONAL), ("InitiatorAlias", "string", "vim.version.version5", F_OPTIONAL), ("InitiatorBootFlags", "long", "vim.version.version5", F_OPTIONAL), ("InitiatorName", "string", "vim.version.version5", F_OPTIONAL), ("Lun", "long", "vim.version.version5", F_OPTIONAL), ("MACAddress", "string", "vim.version.version5", F_OPTIONAL), ("MutualChapName", "string", "vim.version.version5", F_OPTIONAL), ("NICFlags", "long", "vim.version.version5", F_OPTIONAL), ("SLPServerIP", "string", "vim.version.version5", F_OPTIONAL), ("SubnetMask", "string", "vim.version.version5", F_OPTIONAL), ("TargetBootFlags", "long", "vim.version.version5", F_OPTIONAL), ("TargetIP", "string", "vim.version.version5", F_OPTIONAL), ("TargetName", "string", "vim.version.version5", F_OPTIONAL), ("TargetPort", "long", "vim.version.version5", F_OPTIONAL), ("Vlan", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.logicalnetworkportal.list.LogicalNetworkPortal", "VimEsxCLIiscsilogicalnetworkportallistLogicalNetworkPortal", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("Compliant", "boolean", "vim.version.version5", F_OPTIONAL), ("MACAddress", "string", "vim.version.version5", F_OPTIONAL), ("MACAddressValid", "boolean", "vim.version.version5", F_OPTIONAL), ("Vmknic", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.networkportal.ipconfig.get.NetworkPortal", "VimEsxCLIiscsinetworkportalipconfiggetNetworkPortal", "vmodl.DynamicData", "vim.version.version5", [("Gateway", "string", "vim.version.version5", F_OPTIONAL), ("IPv4", "string", "vim.version.version5", F_OPTIONAL), ("IPv4SubnetMask", "string", "vim.version.version5", F_OPTIONAL), ("IPv6", "string", "vim.version.version5", F_OPTIONAL), ("IscsiAdapter", "string", "vim.version.version5", F_OPTIONAL), ("PrimaryDNS", "string", "vim.version.version5", F_OPTIONAL), ("SecondaryDNS", "string", "vim.version.version5", F_OPTIONAL), ("Vmknic", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.networkportal.list.NetworkPortal", "VimEsxCLIiscsinetworkportallistNetworkPortal", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("CompliantStatus", "string", "vim.version.version5", F_OPTIONAL), ("CurrentSpeed", "long", "vim.version.version5", F_OPTIONAL), ("Duplex", "string", "vim.version.version5", F_OPTIONAL), ("IPv4", "string", "vim.version.version5", F_OPTIONAL), ("IPv4SubnetMask", "string", "vim.version.version5", F_OPTIONAL), ("IPv6", "string", "vim.version.version5", F_OPTIONAL), ("LinkUp", "boolean", "vim.version.version5", F_OPTIONAL), ("MACAddress", "string", "vim.version.version5", F_OPTIONAL), ("MACAddressValid", "boolean", "vim.version.version5", F_OPTIONAL), ("MTU", "long", "vim.version.version5", F_OPTIONAL), ("NICDriver", "string", "vim.version.version5", F_OPTIONAL), ("NICDriverVersion", "string", "vim.version.version5", F_OPTIONAL), ("NICFirmwareVersion", "string", "vim.version.version5", F_OPTIONAL), ("NonCompliantMessage", "string", "vim.version.version5", F_OPTIONAL), ("NonCompliantRemedy", "string", "vim.version.version5", F_OPTIONAL), ("PathStatus", "string", "vim.version.version5", F_OPTIONAL), ("PortGroup", "string", "vim.version.version5", F_OPTIONAL), ("PortGroupKey", "string", "vim.version.version5", F_OPTIONAL), ("PortKey", "string", "vim.version.version5", F_OPTIONAL), ("ReservedPorts", "string", "vim.version.version5", F_OPTIONAL), ("RxPackets", "long", "vim.version.version5", F_OPTIONAL), ("TCPChecksum", "boolean", "vim.version.version5", F_OPTIONAL), ("TOE", "boolean", "vim.version.version5", F_OPTIONAL), ("TSO", "boolean", "vim.version.version5", F_OPTIONAL), ("TxPackets", "long", "vim.version.version5", F_OPTIONAL), ("VlanID", "long", "vim.version.version5", F_OPTIONAL), ("VlanSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("Vmknic", "string", "vim.version.version5", F_OPTIONAL), ("Vswitch", "string", "vim.version.version5", F_OPTIONAL), ("VswitchUuid", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.physicalnetworkportal.list.PhysicalNetworkPortal", "VimEsxCLIiscsiphysicalnetworkportallistPhysicalNetworkPortal", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("CurrentSpeed", "long", "vim.version.version5", F_OPTIONAL), ("MACAddress", "string", "vim.version.version5", F_OPTIONAL), ("MACAddressValid", "boolean", "vim.version.version5", F_OPTIONAL), ("MaxFrameSize", "long", "vim.version.version5", F_OPTIONAL), ("MaxSpeed", "long", "vim.version.version5", F_OPTIONAL), ("Vmnic", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.physicalnetworkportal.param.get.iScsiNetParm", "VimEsxCLIiscsiphysicalnetworkportalparamgetiScsiNetParm", "vmodl.DynamicData", "vim.version.version5", [("Option", "string", "vim.version.version5", F_OPTIONAL), ("Settable", "boolean", "vim.version.version5", F_OPTIONAL), ("Value", "long", "vim.version.version5", F_OPTIONAL), ("Vmnic", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.plugin.list.iScsiPlugin", "VimEsxCLIiscsipluginlistiScsiPlugin", "vmodl.DynamicData", "vim.version.version5", [("AutoPersistenceSupported", "boolean", "vim.version.version5", F_OPTIONAL), ("BuildTime", "string", "vim.version.version5", F_OPTIONAL), ("FileName", "string", "vim.version.version5", F_OPTIONAL), ("ImplementationVersion", "string", "vim.version.version5", F_OPTIONAL), ("LhbasCanBeCreatedAndDestroyed", "boolean", "vim.version.version5", F_OPTIONAL), ("SupportedImaVersion", "long", "vim.version.version5", F_OPTIONAL), ("Vendor", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.session.connection.list.Connection", "VimEsxCLIiscsisessionconnectionlistConnection", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("CID", "long", "vim.version.version5", F_OPTIONAL), ("ConnectionAddress", "string", "vim.version.version5", F_OPTIONAL), ("ConnectionCreateTime", "string", "vim.version.version5", F_OPTIONAL), ("ConnectionStartTime", "string", "vim.version.version5", F_OPTIONAL), ("DataDigest", "string", "vim.version.version5", F_OPTIONAL), ("HeaderDigest", "string", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("IFMarker", "boolean", "vim.version.version5", F_OPTIONAL), ("IFMarkerInterval", "long", "vim.version.version5", F_OPTIONAL), ("ISID", "string", "vim.version.version5", F_OPTIONAL), ("LocalAddress", "string", "vim.version.version5", F_OPTIONAL), ("MaxRecvDataSegmentLength", "long", "vim.version.version5", F_OPTIONAL), ("MaxTransmitDataSegmentLength", "long", "vim.version.version5", F_OPTIONAL), ("OFMarker", "boolean", "vim.version.version5", F_OPTIONAL), ("OFMarkerInterval", "long", "vim.version.version5", F_OPTIONAL), ("RemoteAddress", "string", "vim.version.version5", F_OPTIONAL), ("SessionCreateTime", "string", "vim.version.version5", F_OPTIONAL), ("State", "string", "vim.version.version5", F_OPTIONAL), ("Target", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.iscsi.session.list.Session", "VimEsxCLIiscsisessionlistSession", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("AuthenticationMethod", "string", "vim.version.version5", F_OPTIONAL), ("DataPduInOrder", "boolean", "vim.version.version5", F_OPTIONAL), ("DataSequenceInOrder", "boolean", "vim.version.version5", F_OPTIONAL), ("DefaultTime2Retain", "long", "vim.version.version5", F_OPTIONAL), ("DefaultTime2Wait", "long", "vim.version.version5", F_OPTIONAL), ("ErrorRecoveryLevel", "long", "vim.version.version5", F_OPTIONAL), ("FirstBurstLength", "string", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("ISID", "string", "vim.version.version5", F_OPTIONAL), ("ImmediateData", "boolean", "vim.version.version5", F_OPTIONAL), ("InitialR2T", "boolean", "vim.version.version5", F_OPTIONAL), ("MaxBurstLength", "long", "vim.version.version5", F_OPTIONAL), ("MaxConnections", "long", "vim.version.version5", F_OPTIONAL), ("MaxOutstandingR2T", "long", "vim.version.version5", F_OPTIONAL), ("TSIH", "long", "vim.version.version5", F_OPTIONAL), ("Target", "string", "vim.version.version5", F_OPTIONAL), ("TargetPortalGroupTag", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.diag.ping.VMKPingSummary", "VimEsxCLInetworkdiagpingVMKPingSummary", "vmodl.DynamicData", "vim.version.version5", [("Duplicated", "long", "vim.version.version5", F_OPTIONAL), ("HostAddr", "string", "vim.version.version5", F_OPTIONAL), ("PacketLost", "long", "vim.version.version5", F_OPTIONAL), ("Recieved", "long", "vim.version.version5", F_OPTIONAL), ("RoundtripAvgMS", "long", "vim.version.version5", F_OPTIONAL), ("RoundtripMaxMS", "long", "vim.version.version5", F_OPTIONAL), ("RoundtripMinMS", "long", "vim.version.version5", F_OPTIONAL), ("Transmitted", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.diag.ping.VMKPingTrace", "VimEsxCLInetworkdiagpingVMKPingTrace", "vmodl.DynamicData", "vim.version.version5", [("Detail", "string", "vim.version.version5", F_OPTIONAL), ("Dup", "boolean", "vim.version.version5", F_OPTIONAL), ("Host", "string", "vim.version.version5", F_OPTIONAL), ("ICMPSeq", "long", "vim.version.version5", F_OPTIONAL), ("ReceivedBytes", "long", "vim.version.version5", F_OPTIONAL), ("RoundtripTimeMS", "long", "vim.version.version5", F_OPTIONAL), ("TTL", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.diag.ping.VMKPing", "VimEsxCLInetworkdiagpingVMKPing", "vmodl.DynamicData", "vim.version.version5", [("Summary", "vim.EsxCLI.network.diag.ping.VMKPingSummary", "vim.version.version5", F_OPTIONAL), ("Trace", "vim.EsxCLI.network.diag.ping.VMKPingTrace[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.fence.list.FenceSwitch", "VimEsxCLInetworkfencelistFenceSwitch", "vmodl.DynamicData", "vim.version.version5", [("MTU", "long", "vim.version.version5", F_OPTIONAL), ("Numberofactivefencednetworks", "long", "vim.version.version5", F_OPTIONAL), ("VDSName", "string", "vim.version.version5", F_OPTIONAL), ("VDSSwitchID", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.fence.network.bte.list.FenceBTE", "VimEsxCLInetworkfencenetworkbtelistFenceBTE", "vmodl.DynamicData", "vim.version.version5", [("InnerMac", "string", "vim.version.version5", F_OPTIONAL), ("OuterMac", "string", "vim.version.version5", F_OPTIONAL), ("Vlan", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.fence.network.bte.list.FenceBteList", "VimEsxCLInetworkfencenetworkbtelistFenceBteList", "vmodl.DynamicData", "vim.version.version5", [("Bridgetableentries", "vim.EsxCLI.network.fence.network.bte.list.FenceBTE[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.fence.network.list.FenceNetwork", "VimEsxCLInetworkfencenetworklistFenceNetwork", "vmodl.DynamicData", "vim.version.version5", [("FenceId", "long", "vim.version.version5", F_OPTIONAL), ("NumBridgeTableEntries", "long", "vim.version.version5", F_OPTIONAL), ("NumFencedPorts", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.fence.network.list.FenceNetworkList", "VimEsxCLInetworkfencenetworklistFenceNetworkList", "vmodl.DynamicData", "vim.version.version5", [("FenceNetworks", "vim.EsxCLI.network.fence.network.list.FenceNetwork[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.fence.network.port.list.FencePort", "VimEsxCLInetworkfencenetworkportlistFencePort", "vmodl.DynamicData", "vim.version.version5", [("BcastContainment", "boolean", "vim.version.version5", F_OPTIONAL), ("DVPortId", "string", "vim.version.version5", F_OPTIONAL), ("IOportId", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.fence.network.port.list.FencePortList", "VimEsxCLInetworkfencenetworkportlistFencePortList", "vmodl.DynamicData", "vim.version.version5", [("FencePorts", "vim.EsxCLI.network.fence.network.port.list.FencePort[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.firewall.get.Firewall", "VimEsxCLInetworkfirewallgetFirewall", "vmodl.DynamicData", "vim.version.version5", [("DefaultAction", "string", "vim.version.version5", F_OPTIONAL), ("Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("Loaded", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.firewall.ruleset.allowedip.list.FirewallRulesetAllowedip", "VimEsxCLInetworkfirewallrulesetallowediplistFirewallRulesetAllowedip", "vmodl.DynamicData", "vim.version.version5", [("AllowedIPAddresses", "string[]", "vim.version.version5", F_OPTIONAL), ("Ruleset", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.firewall.ruleset.list.Ruleset", "VimEsxCLInetworkfirewallrulesetlistRuleset", "vmodl.DynamicData", "vim.version.version5", [("Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.firewall.ruleset.rule.list.FirewallPortRule", "VimEsxCLInetworkfirewallrulesetrulelistFirewallPortRule", "vmodl.DynamicData", "vim.version.version5", [("Direction", "string", "vim.version.version5", F_OPTIONAL), ("PortBegin", "long", "vim.version.version5", F_OPTIONAL), ("PortEnd", "long", "vim.version.version5", F_OPTIONAL), ("PortType", "string", "vim.version.version5", F_OPTIONAL), ("Protocol", "string", "vim.version.version5", F_OPTIONAL), ("Ruleset", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.connection.list.IpConnection", "VimEsxCLInetworkipconnectionlistIpConnection", "vmodl.DynamicData", "vim.version.version5", [("CCAlgo", "string", "vim.version.version5", F_OPTIONAL), ("ForeignAddress", "string", "vim.version.version5", F_OPTIONAL), ("LocalAddress", "string", "vim.version.version5", F_OPTIONAL), ("Proto", "string", "vim.version.version5", F_OPTIONAL), ("RecvQ", "long", "vim.version.version5", F_OPTIONAL), ("SendQ", "long", "vim.version.version5", F_OPTIONAL), ("State", "string", "vim.version.version5", F_OPTIONAL), ("WorldID", "long", "vim.version.version5", F_OPTIONAL), ("WorldName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.dns.search.list.DNSSearchList", "VimEsxCLInetworkipdnssearchlistDNSSearchList", "vmodl.DynamicData", "vim.version.version5", [("DNSSearchDomains", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.dns.server.list.NameServerList", "VimEsxCLInetworkipdnsserverlistNameServerList", "vmodl.DynamicData", "vim.version.version5", [("DNSServers", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.get.IPInfo", "VimEsxCLInetworkipgetIPInfo", "vmodl.DynamicData", "vim.version.version5", [("IPv6Enabled", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.interface.ipv4.get.IPv4Interface", "VimEsxCLInetworkipinterfaceipv4getIPv4Interface", "vmodl.DynamicData", "vim.version.version5", [("AddressType", "string", "vim.version.version5", F_OPTIONAL), ("DHCPDNS", "boolean", "vim.version.version5", F_OPTIONAL), ("IPv4Address", "string", "vim.version.version5", F_OPTIONAL), ("IPv4Broadcast", "string", "vim.version.version5", F_OPTIONAL), ("IPv4Netmask", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.interface.ipv6.address.list.IPv6Interface", "VimEsxCLInetworkipinterfaceipv6addresslistIPv6Interface", "vmodl.DynamicData", "vim.version.version5", [("Address", "string", "vim.version.version5", F_OPTIONAL), ("Interface", "string", "vim.version.version5", F_OPTIONAL), ("Netmask", "long", "vim.version.version5", F_OPTIONAL), ("Status", "string", "vim.version.version5", F_OPTIONAL), ("Type", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.interface.ipv6.get.IPv6Interface", "VimEsxCLInetworkipinterfaceipv6getIPv6Interface", "vmodl.DynamicData", "vim.version.version5", [("DHCPDNS", "boolean", "vim.version.version5", F_OPTIONAL), ("DHCPv6Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("RouterAdvEnabled", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.interface.list.NetworkInterface", "VimEsxCLInetworkipinterfacelistNetworkInterface", "vmodl.DynamicData", "vim.version.version5", [("Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("MACAddress", "string", "vim.version.version5", F_OPTIONAL), ("MTU", "long", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("NetstackInstance", "string", "vim.version.version5", F_OPTIONAL), ("PortID", "long", "vim.version.version5", F_OPTIONAL), ("Portgroup", "string", "vim.version.version5", F_OPTIONAL), ("Portset", "string", "vim.version.version5", F_OPTIONAL), ("TSOMSS", "long", "vim.version.version5", F_OPTIONAL), ("VDSConnection", "long", "vim.version.version5", F_OPTIONAL), ("VDSName", "string", "vim.version.version5", F_OPTIONAL), ("VDSPort", "string", "vim.version.version5", F_OPTIONAL), ("VDSUUID", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.interface.tag.get.InterfaceTag", "VimEsxCLInetworkipinterfacetaggetInterfaceTag", "vmodl.DynamicData", "vim.version.version5", [("Tags", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.ipsec.sa.list.SecurityAssociation", "VimEsxCLInetworkipipsecsalistSecurityAssociation", "vmodl.DynamicData", "vim.version.version5", [("DestinationAddress", "string", "vim.version.version5", F_OPTIONAL), ("EncryptionAlgorithm", "string", "vim.version.version5", F_OPTIONAL), ("IntegrityAlgorithm", "string", "vim.version.version5", F_OPTIONAL), ("Lifetime", "string", "vim.version.version5", F_OPTIONAL), ("Mode", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("SPI", "string", "vim.version.version5", F_OPTIONAL), ("SourceAddress", "string", "vim.version.version5", F_OPTIONAL), ("State", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.ipsec.sp.list.SecurityPolicy", "VimEsxCLInetworkipipsecsplistSecurityPolicy", "vmodl.DynamicData", "vim.version.version5", [("Action", "string", "vim.version.version5", F_OPTIONAL), ("DestinationAddress", "string", "vim.version.version5", F_OPTIONAL), ("DestinationPort", "long", "vim.version.version5", F_OPTIONAL), ("Flow", "string", "vim.version.version5", F_OPTIONAL), ("Mode", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Protocol", "string", "vim.version.version5", F_OPTIONAL), ("SAName", "string", "vim.version.version5", F_OPTIONAL), ("SourceAddress", "string", "vim.version.version5", F_OPTIONAL), ("SourcePort", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.neighbor.list.NetworkNeighbor", "VimEsxCLInetworkipneighborlistNetworkNeighbor", "vmodl.DynamicData", "vim.version.version5", [("Expiry", "long", "vim.version.version5", F_OPTIONAL), ("MacAddress", "string", "vim.version.version5", F_OPTIONAL), ("Neighbor", "string", "vim.version.version5", F_OPTIONAL), ("State", "string", "vim.version.version5", F_OPTIONAL), ("Type", "string", "vim.version.version5", F_OPTIONAL), ("Vmknic", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.netstack.get.NetstackInstance", "VimEsxCLInetworkipnetstackgetNetstackInstance", "vmodl.DynamicData", "vim.version.version5", [("CongestionControlAlgorithm", "string", "vim.version.version5", F_OPTIONAL), ("CurrentIPv6Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("CurrentMaxConnections", "long", "vim.version.version5", F_OPTIONAL), ("Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("IPv6Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("Key", "string", "vim.version.version5", F_OPTIONAL), ("MaxConnections", "long", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("State", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.netstack.list.NetstackInstance", "VimEsxCLInetworkipnetstacklistNetstackInstance", "vmodl.DynamicData", "vim.version.version5", [("Key", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("State", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.route.ipv4.list.Ipv4Route", "VimEsxCLInetworkiprouteipv4listIpv4Route", "vmodl.DynamicData", "vim.version.version5", [("Gateway", "string", "vim.version.version5", F_OPTIONAL), ("Interface", "string", "vim.version.version5", F_OPTIONAL), ("Netmask", "string", "vim.version.version5", F_OPTIONAL), ("Network", "string", "vim.version.version5", F_OPTIONAL), ("Source", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.ip.route.ipv6.list.Ipv6Route", "VimEsxCLInetworkiprouteipv6listIpv6Route", "vmodl.DynamicData", "vim.version.version5", [("Gateway", "string", "vim.version.version5", F_OPTIONAL), ("Interface", "string", "vim.version.version5", F_OPTIONAL), ("Netmask", "string", "vim.version.version5", F_OPTIONAL), ("Network", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.nic.coalesce.get.CoalesceParams", "VimEsxCLInetworkniccoalescegetCoalesceParams", "vmodl.DynamicData", "vim.version.version5", [("NIC", "string", "vim.version.version5", F_OPTIONAL), ("RXmaximumframes", "string", "vim.version.version5", F_OPTIONAL), ("RXmicroseconds", "string", "vim.version.version5", F_OPTIONAL), ("TXMaximumframes", "string", "vim.version.version5", F_OPTIONAL), ("TXmicroseconds", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.nic.cso.get.CSOSettings", "VimEsxCLInetworkniccsogetCSOSettings", "vmodl.DynamicData", "vim.version.version5", [("NIC", "string", "vim.version.version5", F_OPTIONAL), ("RXChecksumOffload", "string", "vim.version.version5", F_OPTIONAL), ("TXChecksumOffload", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.nic.eeprom.dump.EepromDump", "VimEsxCLInetworkniceepromdumpEepromDump", "vmodl.DynamicData", "vim.version.version5", [("Offset", "string", "vim.version.version5", F_OPTIONAL), ("Value", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.nic.get.NICDriverInfo", "VimEsxCLInetworknicgetNICDriverInfo", "vmodl.DynamicData", "vim.version.version5", [("BusInfo", "string", "vim.version.version5", F_OPTIONAL), ("Driver", "string", "vim.version.version5", F_OPTIONAL), ("FirmwareVersion", "string", "vim.version.version5", F_OPTIONAL), ("Version", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.nic.get.NICInfo", "VimEsxCLInetworknicgetNICInfo", "vmodl.DynamicData", "vim.version.version5", [("AdvertisedAutoNegotiation", "boolean", "vim.version.version5", F_OPTIONAL), ("AdvertisedLinkModes", "string[]", "vim.version.version5", F_OPTIONAL), ("AutoNegotiation", "boolean", "vim.version.version5", F_OPTIONAL), ("CableType", "string", "vim.version.version5", F_OPTIONAL), ("CurrentMessageLevel", "long", "vim.version.version5", F_OPTIONAL), ("DriverInfo", "vim.EsxCLI.network.nic.get.NICDriverInfo", "vim.version.version5", F_OPTIONAL), ("LinkDetected", "boolean", "vim.version.version5", F_OPTIONAL), ("LinkStatus", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("PHYAddress", "long", "vim.version.version5", F_OPTIONAL), ("PauseAutonegotiate", "boolean", "vim.version.version5", F_OPTIONAL), ("PauseRX", "boolean", "vim.version.version5", F_OPTIONAL), ("PauseTX", "boolean", "vim.version.version5", F_OPTIONAL), ("SupportedPorts", "string[]", "vim.version.version5", F_OPTIONAL), ("SupportsAutoNegotiation", "boolean", "vim.version.version5", F_OPTIONAL), ("SupportsPause", "boolean", "vim.version.version5", F_OPTIONAL), ("SupportsWakeon", "boolean", "vim.version.version5", F_OPTIONAL), ("Transceiver", "string", "vim.version.version5", F_OPTIONAL), ("Wakeon", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.nic.list.Nic", "VimEsxCLInetworkniclistNic", "vmodl.DynamicData", "vim.version.version5", [("Description", "string", "vim.version.version5", F_OPTIONAL), ("Driver", "string", "vim.version.version5", F_OPTIONAL), ("Duplex", "string", "vim.version.version5", F_OPTIONAL), ("Link", "string", "vim.version.version5", F_OPTIONAL), ("MACAddress", "string", "vim.version.version5", F_OPTIONAL), ("MTU", "long", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("PCIDevice", "string", "vim.version.version5", F_OPTIONAL), ("Speed", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.nic.register.dump.RegisterDump", "VimEsxCLInetworknicregisterdumpRegisterDump", "vmodl.DynamicData", "vim.version.version5", [("Offset", "string", "vim.version.version5", F_OPTIONAL), ("Value", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.nic.selftest.run.EepromDump", "VimEsxCLInetworknicselftestrunEepromDump", "vmodl.DynamicData", "vim.version.version5", [("Item", "string", "vim.version.version5", F_OPTIONAL), ("Value", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.nic.sg.get.ScatterGatherSetting", "VimEsxCLInetworknicsggetScatterGatherSetting", "vmodl.DynamicData", "vim.version.version5", [("NIC", "string", "vim.version.version5", F_OPTIONAL), ("Value", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.nic.stats.get.Nic", "VimEsxCLInetworknicstatsgetNic", "vmodl.DynamicData", "vim.version.version5", [("Bytesreceived", "long", "vim.version.version5", F_OPTIONAL), ("Bytessent", "long", "vim.version.version5", F_OPTIONAL), ("NICName", "string", "vim.version.version5", F_OPTIONAL), ("Packetsreceived", "long", "vim.version.version5", F_OPTIONAL), ("Packetssent", "long", "vim.version.version5", F_OPTIONAL), ("ReceiveCRCerrors", "long", "vim.version.version5", F_OPTIONAL), ("ReceiveFIFOerrors", "long", "vim.version.version5", F_OPTIONAL), ("Receiveframeerrors", "long", "vim.version.version5", F_OPTIONAL), ("Receivelengtherrors", "long", "vim.version.version5", F_OPTIONAL), ("Receivemissederrors", "long", "vim.version.version5", F_OPTIONAL), ("Receiveovererrors", "long", "vim.version.version5", F_OPTIONAL), ("Receivepacketsdropped", "long", "vim.version.version5", F_OPTIONAL), ("Totalreceiveerrors", "long", "vim.version.version5", F_OPTIONAL), ("Totaltransmiterrors", "long", "vim.version.version5", F_OPTIONAL), ("TransmitFIFOerrors", "long", "vim.version.version5", F_OPTIONAL), ("Transmitabortederrors", "long", "vim.version.version5", F_OPTIONAL), ("Transmitcarriererrors", "long", "vim.version.version5", F_OPTIONAL), ("Transmitheartbeaterrors", "long", "vim.version.version5", F_OPTIONAL), ("Transmitpacketsdropped", "long", "vim.version.version5", F_OPTIONAL), ("Transmitwindowerrors", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.nic.tso.get.TSOSettings", "VimEsxCLInetworknictsogetTSOSettings", "vmodl.DynamicData", "vim.version.version5", [("NIC", "string", "vim.version.version5", F_OPTIONAL), ("Value", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.nic.vlan.stats.get.NIC", "VimEsxCLInetworknicvlanstatsgetNIC", "vmodl.DynamicData", "vim.version.version5", [("Packetsreceived", "long", "vim.version.version5", F_OPTIONAL), ("Packetssent", "long", "vim.version.version5", F_OPTIONAL), ("VLANID", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.port.filter.stats.get.Filter", "VimEsxCLInetworkportfilterstatsgetFilter", "vmodl.DynamicData", "vim.version.version5", [("Filterdirection", "string", "vim.version.version5", F_OPTIONAL), ("Filtername", "string", "vim.version.version5", F_OPTIONAL), ("Packeterrors", "long", "vim.version.version5", F_OPTIONAL), ("Packetsdropped", "long", "vim.version.version5", F_OPTIONAL), ("Packetsfaulted", "long", "vim.version.version5", F_OPTIONAL), ("Packetsfiltered", "long", "vim.version.version5", F_OPTIONAL), ("Packetsin", "long", "vim.version.version5", F_OPTIONAL), ("Packetsinjected", "long", "vim.version.version5", F_OPTIONAL), ("Packetsout", "long", "vim.version.version5", F_OPTIONAL), ("Packetsqueued", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.port.stats.get.Port", "VimEsxCLInetworkportstatsgetPort", "vmodl.DynamicData", "vim.version.version5", [("Broadcastpacketsreceived", "long", "vim.version.version5", F_OPTIONAL), ("Broadcastpacketssent", "long", "vim.version.version5", F_OPTIONAL), ("Bytesreceived", "long", "vim.version.version5", F_OPTIONAL), ("Bytessent", "long", "vim.version.version5", F_OPTIONAL), ("Multicastpacketsreceived", "long", "vim.version.version5", F_OPTIONAL), ("Multicastpacketssent", "long", "vim.version.version5", F_OPTIONAL), ("Packetsreceived", "long", "vim.version.version5", F_OPTIONAL), ("Packetssent", "long", "vim.version.version5", F_OPTIONAL), ("PortID", "long", "vim.version.version5", F_OPTIONAL), ("Receivepacketsdropped", "long", "vim.version.version5", F_OPTIONAL), ("Transmitpacketsdropped", "long", "vim.version.version5", F_OPTIONAL), ("Unicastpacketsreceived", "long", "vim.version.version5", F_OPTIONAL), ("Unicastpacketssent", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.sriovnic.list.SriovNic", "VimEsxCLInetworksriovniclistSriovNic", "vmodl.DynamicData", "vim.version.version5", [("Description", "string", "vim.version.version5", F_OPTIONAL), ("Driver", "string", "vim.version.version5", F_OPTIONAL), ("Duplex", "string", "vim.version.version5", F_OPTIONAL), ("Link", "string", "vim.version.version5", F_OPTIONAL), ("MACAddress", "string", "vim.version.version5", F_OPTIONAL), ("MTU", "long", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("PCIDevice", "string", "vim.version.version5", F_OPTIONAL), ("Speed", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.sriovnic.vf.list.VFList", "VimEsxCLInetworksriovnicvflistVFList", "vmodl.DynamicData", "vim.version.version5", [("Active", "boolean", "vim.version.version5", F_OPTIONAL), ("OwnerWorldID", "string", "vim.version.version5", F_OPTIONAL), ("PCIAddress", "string", "vim.version.version5", F_OPTIONAL), ("VFID", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.sriovnic.vf.stats.VfStats", "VimEsxCLInetworksriovnicvfstatsVfStats", "vmodl.DynamicData", "vim.version.version5", [("NICName", "string", "vim.version.version5", F_OPTIONAL), ("RxBroadcastBytes", "long", "vim.version.version5", F_OPTIONAL), ("RxBroadcastPkts", "long", "vim.version.version5", F_OPTIONAL), ("RxErrordrops", "long", "vim.version.version5", F_OPTIONAL), ("RxLROBytes", "long", "vim.version.version5", F_OPTIONAL), ("RxLROPkts", "long", "vim.version.version5", F_OPTIONAL), ("RxMulticastBytes", "long", "vim.version.version5", F_OPTIONAL), ("RxMulticastPkts", "long", "vim.version.version5", F_OPTIONAL), ("RxOutofBufferdrops", "long", "vim.version.version5", F_OPTIONAL), ("RxUnicastBytes", "long", "vim.version.version5", F_OPTIONAL), ("RxUnicastPkt", "long", "vim.version.version5", F_OPTIONAL), ("TxBroadcastBytes", "long", "vim.version.version5", F_OPTIONAL), ("TxBroadcastPkts", "long", "vim.version.version5", F_OPTIONAL), ("TxDiscards", "long", "vim.version.version5", F_OPTIONAL), ("TxErrors", "long", "vim.version.version5", F_OPTIONAL), ("TxMulticastBytes", "long", "vim.version.version5", F_OPTIONAL), ("TxMulticastPkts", "long", "vim.version.version5", F_OPTIONAL), ("TxTSOBytes", "long", "vim.version.version5", F_OPTIONAL), ("TxTSOPkts", "long", "vim.version.version5", F_OPTIONAL), ("TxUnicastBytes", "long", "vim.version.version5", F_OPTIONAL), ("TxUnicastPkt", "long", "vim.version.version5", F_OPTIONAL), ("VFID", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vm.list.VM", "VimEsxCLInetworkvmlistVM", "vmodl.DynamicData", "vim.version.version5", [("Name", "string", "vim.version.version5", F_OPTIONAL), ("Networks", "string[]", "vim.version.version5", F_OPTIONAL), ("NumPorts", "long", "vim.version.version5", F_OPTIONAL), ("WorldID", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vm.port.list.Port", "VimEsxCLInetworkvmportlistPort", "vmodl.DynamicData", "vim.version.version5", [("ActiveFilters", "string[]", "vim.version.version5", F_OPTIONAL), ("DVPortID", "string", "vim.version.version5", F_OPTIONAL), ("IPAddress", "string", "vim.version.version5", F_OPTIONAL), ("MACAddress", "string", "vim.version.version5", F_OPTIONAL), ("PortID", "long", "vim.version.version5", F_OPTIONAL), ("Portgroup", "string", "vim.version.version5", F_OPTIONAL), ("TeamUplink", "string", "vim.version.version5", F_OPTIONAL), ("UplinkPortID", "long", "vim.version.version5", F_OPTIONAL), ("vSwitch", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.lacp.config.get.LACP", "VimEsxCLInetworkvswitchdvsvmwarelacpconfiggetLACP", "vmodl.DynamicData", "vim.version.version5", [("DVSName", "string", "vim.version.version5", F_OPTIONAL), ("Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("LAGID", "long", "vim.version.version5", F_OPTIONAL), ("LAGName", "string", "vim.version.version5", F_OPTIONAL), ("Loadbalance", "string", "vim.version.version5", F_OPTIONAL), ("Mode", "string", "vim.version.version5", F_OPTIONAL), ("NICs", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.lacp.stats.get.LACPStats", "VimEsxCLInetworkvswitchdvsvmwarelacpstatsgetLACPStats", "vmodl.DynamicData", "vim.version.version5", [("DVSwitch", "string", "vim.version.version5", F_OPTIONAL), ("LAGID", "long", "vim.version.version5", F_OPTIONAL), ("NIC", "string", "vim.version.version5", F_OPTIONAL), ("RxErrors", "long", "vim.version.version5", F_OPTIONAL), ("RxLACPDUs", "long", "vim.version.version5", F_OPTIONAL), ("TxErrors", "long", "vim.version.version5", F_OPTIONAL), ("TxLACPDUs", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.lacp.status.get.LocalInfo", "VimEsxCLInetworkvswitchdvsvmwarelacpstatusgetLocalInfo", "vmodl.DynamicData", "vim.version.version5", [("AdminKey", "long", "vim.version.version5", F_OPTIONAL), ("Flags", "string", "vim.version.version5", F_OPTIONAL), ("OperKey", "long", "vim.version.version5", F_OPTIONAL), ("PortNumber", "long", "vim.version.version5", F_OPTIONAL), ("PortPriority", "long", "vim.version.version5", F_OPTIONAL), ("PortState", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.lacp.status.get.PartnerInfo", "VimEsxCLInetworkvswitchdvsvmwarelacpstatusgetPartnerInfo", "vmodl.DynamicData", "vim.version.version5", [("Age", "string", "vim.version.version5", F_OPTIONAL), ("DeviceID", "string", "vim.version.version5", F_OPTIONAL), ("Flags", "string", "vim.version.version5", F_OPTIONAL), ("OperKey", "long", "vim.version.version5", F_OPTIONAL), ("PortNumber", "long", "vim.version.version5", F_OPTIONAL), ("PortPriority", "long", "vim.version.version5", F_OPTIONAL), ("PortState", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.lacp.status.get.NicStatus", "VimEsxCLInetworkvswitchdvsvmwarelacpstatusgetNicStatus", "vmodl.DynamicData", "vim.version.version5", [("LocalInformation", "vim.EsxCLI.network.vswitch.dvs.vmware.lacp.status.get.LocalInfo", "vim.version.version5", F_OPTIONAL), ("Nic", "string", "vim.version.version5", F_OPTIONAL), ("PartnerInformation", "vim.EsxCLI.network.vswitch.dvs.vmware.lacp.status.get.PartnerInfo", "vim.version.version5", F_OPTIONAL), ("State", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.lacp.status.get.LAG", "VimEsxCLInetworkvswitchdvsvmwarelacpstatusgetLAG", "vmodl.DynamicData", "vim.version.version5", [("DVSwitch", "string", "vim.version.version5", F_OPTIONAL), ("Flags", "string[]", "vim.version.version5", F_OPTIONAL), ("LAGID", "long", "vim.version.version5", F_OPTIONAL), ("Mode", "string", "vim.version.version5", F_OPTIONAL), ("NicList", "vim.EsxCLI.network.vswitch.dvs.vmware.lacp.status.get.NicStatus[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.list.DVPort", "VimEsxCLInetworkvswitchdvsvmwarelistDVPort", "vmodl.DynamicData", "vim.version.version5", [("Client", "string[]", "vim.version.version5", F_OPTIONAL), ("DVPortgroupID", "string", "vim.version.version5", F_OPTIONAL), ("InUse", "boolean", "vim.version.version5", F_OPTIONAL), ("PortID", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.list.VDS", "VimEsxCLInetworkvswitchdvsvmwarelistVDS", "vmodl.DynamicData", "vim.version.version5", [("BeaconTimeout", "long", "vim.version.version5", F_OPTIONAL), ("CDPStatus", "string", "vim.version.version5", F_OPTIONAL), ("Class", "string", "vim.version.version5", F_OPTIONAL), ("ConfiguredPorts", "long", "vim.version.version5", F_OPTIONAL), ("DVPort", "vim.EsxCLI.network.vswitch.dvs.vmware.list.DVPort[]", "vim.version.version5", F_OPTIONAL), ("MTU", "long", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("NumPorts", "long", "vim.version.version5", F_OPTIONAL), ("Uplinks", "string[]", "vim.version.version5", F_OPTIONAL), ("UsedPorts", "long", "vim.version.version5", F_OPTIONAL), ("VDSID", "string", "vim.version.version5", F_OPTIONAL), ("VMwareBranded", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.config.stats.get.VxlanConfigStats", "VimEsxCLInetworkvswitchdvsvmwarevxlanconfigstatsgetVxlanConfigStats", "vmodl.DynamicData", "vim.version.version5", [("Level", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.get.VxlanSwitch", "VimEsxCLInetworkvswitchdvsvmwarevxlangetVxlanSwitch", "vmodl.DynamicData", "vim.version.version5", [("ControlplaneOutOfSync", "string", "vim.version.version5", F_OPTIONAL), ("UDPport", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.list.VxlanSwitch", "VimEsxCLInetworkvswitchdvsvmwarevxlanlistVxlanSwitch", "vmodl.DynamicData", "vim.version.version5", [("GatewayIP", "string", "vim.version.version5", F_OPTIONAL), ("GatewayMAC", "string", "vim.version.version5", F_OPTIONAL), ("MTU", "long", "vim.version.version5", F_OPTIONAL), ("NetworkCount", "long", "vim.version.version5", F_OPTIONAL), ("SegmentID", "string", "vim.version.version5", F_OPTIONAL), ("VDSID", "string", "vim.version.version5", F_OPTIONAL), ("VDSName", "string", "vim.version.version5", F_OPTIONAL), ("VmknicCount", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.network.arp.list.VxlanARP", "VimEsxCLInetworkvswitchdvsvmwarevxlannetworkarplistVxlanARP", "vmodl.DynamicData", "vim.version.version5", [("Flags", "string", "vim.version.version5", F_OPTIONAL), ("IP", "string", "vim.version.version5", F_OPTIONAL), ("MAC", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.network.list.VxlanNetwork", "VimEsxCLInetworkvswitchdvsvmwarevxlannetworklistVxlanNetwork", "vmodl.DynamicData", "vim.version.version5", [("ARPEntryCount", "long", "vim.version.version5", F_OPTIONAL), ("ControlPlane", "string", "vim.version.version5", F_OPTIONAL), ("ControllerConnection", "string", "vim.version.version5", F_OPTIONAL), ("MACEntryCount", "long", "vim.version.version5", F_OPTIONAL), ("MTEPCount", "long", "vim.version.version5", F_OPTIONAL), ("MulticastIP", "string", "vim.version.version5", F_OPTIONAL), ("PortCount", "long", "vim.version.version5", F_OPTIONAL), ("VXLANID", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.network.mac.list.VxlanMapping", "VimEsxCLInetworkvswitchdvsvmwarevxlannetworkmaclistVxlanMapping", "vmodl.DynamicData", "vim.version.version5", [("Flags", "string", "vim.version.version5", F_OPTIONAL), ("InnerMAC", "string", "vim.version.version5", F_OPTIONAL), ("OuterIP", "string", "vim.version.version5", F_OPTIONAL), ("OuterMAC", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.network.mtep.list.VxlanMTEP", "VimEsxCLInetworkvswitchdvsvmwarevxlannetworkmteplistVxlanMTEP", "vmodl.DynamicData", "vim.version.version5", [("IP", "string", "vim.version.version5", F_OPTIONAL), ("SegmentID", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.network.port.list.VxlanPort", "VimEsxCLInetworkvswitchdvsvmwarevxlannetworkportlistVxlanPort", "vmodl.DynamicData", "vim.version.version5", [("SwitchPortID", "long", "vim.version.version5", F_OPTIONAL), ("VDSPortID", "string", "vim.version.version5", F_OPTIONAL), ("VMKNICID", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.network.port.stats.list.VxlanPortStats", "VimEsxCLInetworkvswitchdvsvmwarevxlannetworkportstatslistVxlanPortStats", "vmodl.DynamicData", "vim.version.version5", [("Name", "string", "vim.version.version5", F_OPTIONAL), ("Value", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.network.stats.list.VxlanNetStats", "VimEsxCLInetworkvswitchdvsvmwarevxlannetworkstatslistVxlanNetStats", "vmodl.DynamicData", "vim.version.version5", [("Name", "string", "vim.version.version5", F_OPTIONAL), ("Value", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.stats.list.VxlanSwitchStats", "VimEsxCLInetworkvswitchdvsvmwarevxlanstatslistVxlanSwitchStats", "vmodl.DynamicData", "vim.version.version5", [("Name", "string", "vim.version.version5", F_OPTIONAL), ("Value", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.vmknic.list.VxlanVmknic", "VimEsxCLInetworkvswitchdvsvmwarevxlanvmkniclistVxlanVmknic", "vmodl.DynamicData", "vim.version.version5", [("EndpointID", "long", "vim.version.version5", F_OPTIONAL), ("IP", "string", "vim.version.version5", F_OPTIONAL), ("IPAcquireTimeout", "long", "vim.version.version5", F_OPTIONAL), ("MulticastGroupCount", "long", "vim.version.version5", F_OPTIONAL), ("Netmask", "string", "vim.version.version5", F_OPTIONAL), ("SegmentID", "string", "vim.version.version5", F_OPTIONAL), ("SwitchPortID", "long", "vim.version.version5", F_OPTIONAL), ("VDSPortID", "string", "vim.version.version5", F_OPTIONAL), ("VLANID", "long", "vim.version.version5", F_OPTIONAL), ("VmknicName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.vmknic.multicastgroup.list.VxlanVmknic", "VimEsxCLInetworkvswitchdvsvmwarevxlanvmknicmulticastgrouplistVxlanVmknic", "vmodl.DynamicData", "vim.version.version5", [("Joined", "string", "vim.version.version5", F_OPTIONAL), ("MulticastIP", "string", "vim.version.version5", F_OPTIONAL), ("PortCount", "long", "vim.version.version5", F_OPTIONAL), ("VXLANIP", "string", "vim.version.version5", F_OPTIONAL), ("VmknicID", "long", "vim.version.version5", F_OPTIONAL), ("VmknicName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.dvs.vmware.vxlan.vmknic.stats.list.VxlanVmknicStats", "VimEsxCLInetworkvswitchdvsvmwarevxlanvmknicstatslistVxlanVmknicStats", "vmodl.DynamicData", "vim.version.version5", [("Name", "string", "vim.version.version5", F_OPTIONAL), ("Value", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.standard.list.VirtualSwitch", "VimEsxCLInetworkvswitchstandardlistVirtualSwitch", "vmodl.DynamicData", "vim.version.version5", [("BeaconEnabled", "boolean", "vim.version.version5", F_OPTIONAL), ("BeaconInterval", "long", "vim.version.version5", F_OPTIONAL), ("BeaconRequiredBy", "string[]", "vim.version.version5", F_OPTIONAL), ("BeaconThreshold", "long", "vim.version.version5", F_OPTIONAL), ("CDPStatus", "string", "vim.version.version5", F_OPTIONAL), ("Class", "string", "vim.version.version5", F_OPTIONAL), ("ConfiguredPorts", "long", "vim.version.version5", F_OPTIONAL), ("MTU", "long", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("NumPorts", "long", "vim.version.version5", F_OPTIONAL), ("Portgroups", "string[]", "vim.version.version5", F_OPTIONAL), ("Uplinks", "string[]", "vim.version.version5", F_OPTIONAL), ("UsedPorts", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.standard.policy.failover.get.VirtualSwitchFailoverPolicy", "VimEsxCLInetworkvswitchstandardpolicyfailovergetVirtualSwitchFailoverPolicy", "vmodl.DynamicData", "vim.version.version5", [("ActiveAdapters", "string[]", "vim.version.version5", F_OPTIONAL), ("Failback", "boolean", "vim.version.version5", F_OPTIONAL), ("LoadBalancing", "string", "vim.version.version5", F_OPTIONAL), ("NetworkFailureDetection", "string", "vim.version.version5", F_OPTIONAL), ("NotifySwitches", "boolean", "vim.version.version5", F_OPTIONAL), ("StandbyAdapters", "string[]", "vim.version.version5", F_OPTIONAL), ("UnusedAdapters", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.standard.policy.security.get.VirtualSwitchSecurityPolicy", "VimEsxCLInetworkvswitchstandardpolicysecuritygetVirtualSwitchSecurityPolicy", "vmodl.DynamicData", "vim.version.version5", [("AllowForgedTransmits", "boolean", "vim.version.version5", F_OPTIONAL), ("AllowMACAddressChange", "boolean", "vim.version.version5", F_OPTIONAL), ("AllowPromiscuous", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.standard.policy.shaping.get.VirtualSwitchTrafficShapingPolicy", "VimEsxCLInetworkvswitchstandardpolicyshapinggetVirtualSwitchTrafficShapingPolicy", "vmodl.DynamicData", "vim.version.version5", [("AverageBandwidth", "long", "vim.version.version5", F_OPTIONAL), ("BurstSize", "long", "vim.version.version5", F_OPTIONAL), ("Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("PeakBandwidth", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.standard.portgroup.list.PortGroup", "VimEsxCLInetworkvswitchstandardportgrouplistPortGroup", "vmodl.DynamicData", "vim.version.version5", [("ActiveClients", "long", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("VLANID", "long", "vim.version.version5", F_OPTIONAL), ("VirtualSwitch", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.standard.portgroup.policy.failover.get.PortGroupFailoverPolicy", "VimEsxCLInetworkvswitchstandardportgrouppolicyfailovergetPortGroupFailoverPolicy", "vmodl.DynamicData", "vim.version.version5", [("ActiveAdapters", "string[]", "vim.version.version5", F_OPTIONAL), ("Failback", "boolean", "vim.version.version5", F_OPTIONAL), ("LoadBalancing", "string", "vim.version.version5", F_OPTIONAL), ("NetworkFailureDetection", "string", "vim.version.version5", F_OPTIONAL), ("NotifySwitches", "boolean", "vim.version.version5", F_OPTIONAL), ("OverrideVswitchFailback", "boolean", "vim.version.version5", F_OPTIONAL), ("OverrideVswitchLoadBalancing", "boolean", "vim.version.version5", F_OPTIONAL), ("OverrideVswitchNetworkFailureDetection", "boolean", "vim.version.version5", F_OPTIONAL), ("OverrideVswitchNotifySwitches", "boolean", "vim.version.version5", F_OPTIONAL), ("OverrideVswitchUplinks", "boolean", "vim.version.version5", F_OPTIONAL), ("StandbyAdapters", "string[]", "vim.version.version5", F_OPTIONAL), ("UnusedAdapters", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.standard.portgroup.policy.security.get.PortGroupSecurityPolicy", "VimEsxCLInetworkvswitchstandardportgrouppolicysecuritygetPortGroupSecurityPolicy", "vmodl.DynamicData", "vim.version.version5", [("AllowForgedTransmits", "boolean", "vim.version.version5", F_OPTIONAL), ("AllowMACAddressChange", "boolean", "vim.version.version5", F_OPTIONAL), ("AllowPromiscuous", "boolean", "vim.version.version5", F_OPTIONAL), ("OverrideVswitchAllowForgedTransmits", "boolean", "vim.version.version5", F_OPTIONAL), ("OverrideVswitchAllowMACAddressChange", "boolean", "vim.version.version5", F_OPTIONAL), ("OverrideVswitchAllowPromiscuous", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.network.vswitch.standard.portgroup.policy.shaping.get.PortGroupTrafficShapingPolicy", "VimEsxCLInetworkvswitchstandardportgrouppolicyshapinggetPortGroupTrafficShapingPolicy", "vmodl.DynamicData", "vim.version.version5", [("AverageBandwidth", "long", "vim.version.version5", F_OPTIONAL), ("BurstSize", "long", "vim.version.version5", F_OPTIONAL), ("Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("OverrideVswitchAverageBandwidth", "boolean", "vim.version.version5", F_OPTIONAL), ("OverrideVswitchBurstSize", "boolean", "vim.version.version5", F_OPTIONAL), ("OverrideVswitchEnabled", "boolean", "vim.version.version5", F_OPTIONAL), ("OverrideVswitchPeakBandwidth", "boolean", "vim.version.version5", F_OPTIONAL), ("PeakBandwidth", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.sched.swap.system.get.SystemSwapOptions", "VimEsxCLIschedswapsystemgetSystemSwapOptions", "vmodl.DynamicData", "vim.version.version5", [("DatastoreActive", "boolean", "vim.version.version5", F_OPTIONAL), ("DatastoreEnabled", "boolean", "vim.version.version5", F_OPTIONAL), ("DatastoreName", "string", "vim.version.version5", F_OPTIONAL), ("DatastoreOrder", "long", "vim.version.version5", F_OPTIONAL), ("HostcacheActive", "boolean", "vim.version.version5", F_OPTIONAL), ("HostcacheEnabled", "boolean", "vim.version.version5", F_OPTIONAL), ("HostcacheOrder", "long", "vim.version.version5", F_OPTIONAL), ("HostlocalswapActive", "boolean", "vim.version.version5", F_OPTIONAL), ("HostlocalswapEnabled", "boolean", "vim.version.version5", F_OPTIONAL), ("HostlocalswapOrder", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.profile.get.ImageProfile", "VimEsxCLIsoftwareprofilegetImageProfile", "vmodl.DynamicData", "vim.version.version5", [("AcceptanceLevel", "string", "vim.version.version5", F_OPTIONAL), ("CreationTime", "string", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("ModificationTime", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("StatelessReady", "string", "vim.version.version5", F_OPTIONAL), ("VIBs", "string[]", "vim.version.version5", F_OPTIONAL), ("Vendor", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.profile.install.InstallationResult", "VimEsxCLIsoftwareprofileinstallInstallationResult", "vmodl.DynamicData", "vim.version.version5", [("Message", "string", "vim.version.version5", F_OPTIONAL), ("RebootRequired", "boolean", "vim.version.version5", F_OPTIONAL), ("VIBsInstalled", "string[]", "vim.version.version5", F_OPTIONAL), ("VIBsRemoved", "string[]", "vim.version.version5", F_OPTIONAL), ("VIBsSkipped", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.profile.update.InstallationResult", "VimEsxCLIsoftwareprofileupdateInstallationResult", "vmodl.DynamicData", "vim.version.version5", [("Message", "string", "vim.version.version5", F_OPTIONAL), ("RebootRequired", "boolean", "vim.version.version5", F_OPTIONAL), ("VIBsInstalled", "string[]", "vim.version.version5", F_OPTIONAL), ("VIBsRemoved", "string[]", "vim.version.version5", F_OPTIONAL), ("VIBsSkipped", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.profile.validate.ProfileValidationResult", "VimEsxCLIsoftwareprofilevalidateProfileValidationResult", "vmodl.DynamicData", "vim.version.version5", [("Compliant", "boolean", "vim.version.version5", F_OPTIONAL), ("HostImageProfile", "string", "vim.version.version5", F_OPTIONAL), ("VIBsinHostImageProfileOnly", "string[]", "vim.version.version5", F_OPTIONAL), ("VIBsinValidationProfileOnly", "string[]", "vim.version.version5", F_OPTIONAL), ("ValidationProfile", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.sources.profile.get.ImageProfile", "VimEsxCLIsoftwaresourcesprofilegetImageProfile", "vmodl.DynamicData", "vim.version.version5", [("AcceptanceLevel", "string", "vim.version.version5", F_OPTIONAL), ("CreationTime", "string", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("ModificationTime", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("StatelessReady", "string", "vim.version.version5", F_OPTIONAL), ("VIBs", "string[]", "vim.version.version5", F_OPTIONAL), ("Vendor", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.sources.profile.list.ImageProfileSummary", "VimEsxCLIsoftwaresourcesprofilelistImageProfileSummary", "vmodl.DynamicData", "vim.version.version5", [("AcceptanceLevel", "string", "vim.version.version5", F_OPTIONAL), ("CreationTime", "string", "vim.version.version5", F_OPTIONAL), ("ModificationTime", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Vendor", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.sources.vib.get.VIB", "VimEsxCLIsoftwaresourcesvibgetVIB", "vmodl.DynamicData", "vim.version.version5", [("AcceptanceLevel", "string", "vim.version.version5", F_OPTIONAL), ("Conflicts", "string[]", "vim.version.version5", F_OPTIONAL), ("CreationDate", "string", "vim.version.version5", F_OPTIONAL), ("Depends", "string[]", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("HardwarePlatformsRequired", "string[]", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("InstallDate", "string", "vim.version.version5", F_OPTIONAL), ("LiveInstallAllowed", "string", "vim.version.version5", F_OPTIONAL), ("LiveRemoveAllowed", "string", "vim.version.version5", F_OPTIONAL), ("MaintenanceModeRequired", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Overlay", "string", "vim.version.version5", F_OPTIONAL), ("Payloads", "string[]", "vim.version.version5", F_OPTIONAL), ("Provides", "string[]", "vim.version.version5", F_OPTIONAL), ("ReferenceURLs", "string[]", "vim.version.version5", F_OPTIONAL), ("Replaces", "string[]", "vim.version.version5", F_OPTIONAL), ("StatelessReady", "string", "vim.version.version5", F_OPTIONAL), ("Status", "string", "vim.version.version5", F_OPTIONAL), ("Summary", "string", "vim.version.version5", F_OPTIONAL), ("Tags", "string[]", "vim.version.version5", F_OPTIONAL), ("Type", "string", "vim.version.version5", F_OPTIONAL), ("Vendor", "string", "vim.version.version5", F_OPTIONAL), ("Version", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.sources.vib.list.VIBSummary", "VimEsxCLIsoftwaresourcesviblistVIBSummary", "vmodl.DynamicData", "vim.version.version5", [("AcceptanceLevel", "string", "vim.version.version5", F_OPTIONAL), ("CreationDate", "string", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("InstallDate", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Status", "string", "vim.version.version5", F_OPTIONAL), ("Vendor", "string", "vim.version.version5", F_OPTIONAL), ("Version", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.vib.get.VIB", "VimEsxCLIsoftwarevibgetVIB", "vmodl.DynamicData", "vim.version.version5", [("AcceptanceLevel", "string", "vim.version.version5", F_OPTIONAL), ("Conflicts", "string[]", "vim.version.version5", F_OPTIONAL), ("CreationDate", "string", "vim.version.version5", F_OPTIONAL), ("Depends", "string[]", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("HardwarePlatformsRequired", "string[]", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("InstallDate", "string", "vim.version.version5", F_OPTIONAL), ("LiveInstallAllowed", "string", "vim.version.version5", F_OPTIONAL), ("LiveRemoveAllowed", "string", "vim.version.version5", F_OPTIONAL), ("MaintenanceModeRequired", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Overlay", "string", "vim.version.version5", F_OPTIONAL), ("Payloads", "string[]", "vim.version.version5", F_OPTIONAL), ("Provides", "string[]", "vim.version.version5", F_OPTIONAL), ("ReferenceURLs", "string[]", "vim.version.version5", F_OPTIONAL), ("Replaces", "string[]", "vim.version.version5", F_OPTIONAL), ("StatelessReady", "string", "vim.version.version5", F_OPTIONAL), ("Status", "string", "vim.version.version5", F_OPTIONAL), ("Summary", "string", "vim.version.version5", F_OPTIONAL), ("Tags", "string[]", "vim.version.version5", F_OPTIONAL), ("Type", "string", "vim.version.version5", F_OPTIONAL), ("Vendor", "string", "vim.version.version5", F_OPTIONAL), ("Version", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.vib.install.InstallationResult", "VimEsxCLIsoftwarevibinstallInstallationResult", "vmodl.DynamicData", "vim.version.version5", [("Message", "string", "vim.version.version5", F_OPTIONAL), ("RebootRequired", "boolean", "vim.version.version5", F_OPTIONAL), ("VIBsInstalled", "string[]", "vim.version.version5", F_OPTIONAL), ("VIBsRemoved", "string[]", "vim.version.version5", F_OPTIONAL), ("VIBsSkipped", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.vib.list.VIBSummary", "VimEsxCLIsoftwareviblistVIBSummary", "vmodl.DynamicData", "vim.version.version5", [("AcceptanceLevel", "string", "vim.version.version5", F_OPTIONAL), ("CreationDate", "string", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("InstallDate", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Status", "string", "vim.version.version5", F_OPTIONAL), ("Vendor", "string", "vim.version.version5", F_OPTIONAL), ("Version", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.vib.remove.InstallationResult", "VimEsxCLIsoftwarevibremoveInstallationResult", "vmodl.DynamicData", "vim.version.version5", [("Message", "string", "vim.version.version5", F_OPTIONAL), ("RebootRequired", "boolean", "vim.version.version5", F_OPTIONAL), ("VIBsInstalled", "string[]", "vim.version.version5", F_OPTIONAL), ("VIBsRemoved", "string[]", "vim.version.version5", F_OPTIONAL), ("VIBsSkipped", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.software.vib.update.InstallationResult", "VimEsxCLIsoftwarevibupdateInstallationResult", "vmodl.DynamicData", "vim.version.version5", [("Message", "string", "vim.version.version5", F_OPTIONAL), ("RebootRequired", "boolean", "vim.version.version5", F_OPTIONAL), ("VIBsInstalled", "string[]", "vim.version.version5", F_OPTIONAL), ("VIBsRemoved", "string[]", "vim.version.version5", F_OPTIONAL), ("VIBsSkipped", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.adapter.list.ScsiAdapter", "VimEsxCLIstoragecoreadapterlistScsiAdapter", "vmodl.DynamicData", "vim.version.version5", [("Description", "string", "vim.version.version5", F_OPTIONAL), ("Driver", "string", "vim.version.version5", F_OPTIONAL), ("HBAName", "string", "vim.version.version5", F_OPTIONAL), ("LinkState", "string", "vim.version.version5", F_OPTIONAL), ("UID", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.adapter.stats.get.ScsiAdapterStats", "VimEsxCLIstoragecoreadapterstatsgetScsiAdapterStats", "vmodl.DynamicData", "vim.version.version5", [("BlocksRead", "long", "vim.version.version5", F_OPTIONAL), ("BlocksWritten", "long", "vim.version.version5", F_OPTIONAL), ("FailedBlocksRead", "long", "vim.version.version5", F_OPTIONAL), ("FailedBlocksWritten", "long", "vim.version.version5", F_OPTIONAL), ("FailedCommands", "long", "vim.version.version5", F_OPTIONAL), ("FailedReadOperations", "long", "vim.version.version5", F_OPTIONAL), ("FailedReserveOperations", "long", "vim.version.version5", F_OPTIONAL), ("FailedWriteOperations", "long", "vim.version.version5", F_OPTIONAL), ("HBAName", "string", "vim.version.version5", F_OPTIONAL), ("PAECommands", "long", "vim.version.version5", F_OPTIONAL), ("ReadOperations", "long", "vim.version.version5", F_OPTIONAL), ("ReservationConflicts", "long", "vim.version.version5", F_OPTIONAL), ("ReserveOperations", "long", "vim.version.version5", F_OPTIONAL), ("SuccessfulCommands", "long", "vim.version.version5", F_OPTIONAL), ("TotalSplits", "long", "vim.version.version5", F_OPTIONAL), ("WriteOperations", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.claimrule.convert.ConvertedClaimRule", "VimEsxCLIstoragecoreclaimruleconvertConvertedClaimRule", "vmodl.DynamicData", "vim.version.version5", [("Controller", "long", "vim.version.version5", F_OPTIONAL), ("HbaName", "string", "vim.version.version5", F_OPTIONAL), ("LUN", "long", "vim.version.version5", F_OPTIONAL), ("Plugin", "string", "vim.version.version5", F_OPTIONAL), ("Rule", "long", "vim.version.version5", F_OPTIONAL), ("Target", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.claimrule.list.PSAClaimRule", "VimEsxCLIstoragecoreclaimrulelistPSAClaimRule", "vmodl.DynamicData", "vim.version.version5", [("Class", "string", "vim.version.version5", F_OPTIONAL), ("Matches", "string", "vim.version.version5", F_OPTIONAL), ("Plugin", "string", "vim.version.version5", F_OPTIONAL), ("Rule", "long", "vim.version.version5", F_OPTIONAL), ("RuleClass", "string", "vim.version.version5", F_OPTIONAL), ("Type", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.device.detached.list.ScsiDetachedDeviceListMap", "VimEsxCLIstoragecoredevicedetachedlistScsiDetachedDeviceListMap", "vmodl.DynamicData", "vim.version.version5", [("DeviceUID", "string", "vim.version.version5", F_OPTIONAL), ("State", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.device.list.ScsiDevice", "VimEsxCLIstoragecoredevicelistScsiDevice", "vmodl.DynamicData", "vim.version.version5", [("AttachedFilters", "string[]", "vim.version.version5", F_OPTIONAL), ("DevfsPath", "string", "vim.version.version5", F_OPTIONAL), ("Device", "string", "vim.version.version5", F_OPTIONAL), ("DeviceType", "string", "vim.version.version5", F_OPTIONAL), ("DisplayName", "string", "vim.version.version5", F_OPTIONAL), ("HasSettableDisplayName", "boolean", "vim.version.version5", F_OPTIONAL), ("IsBootUSBDevice", "boolean", "vim.version.version5", F_OPTIONAL), ("IsLocal", "boolean", "vim.version.version5", F_OPTIONAL), ("IsLocalSASDevice", "boolean", "vim.version.version5", F_OPTIONAL), ("IsOffline", "boolean", "vim.version.version5", F_OPTIONAL), ("IsPerenniallyReserved", "boolean", "vim.version.version5", F_OPTIONAL), ("IsPseudo", "boolean", "vim.version.version5", F_OPTIONAL), ("IsRDMCapable", "boolean", "vim.version.version5", F_OPTIONAL), ("IsRemovable", "boolean", "vim.version.version5", F_OPTIONAL), ("IsSSD", "boolean", "vim.version.version5", F_OPTIONAL), ("IsUSB", "boolean", "vim.version.version5", F_OPTIONAL), ("Model", "string", "vim.version.version5", F_OPTIONAL), ("MultipathPlugin", "string", "vim.version.version5", F_OPTIONAL), ("NoofoutstandingIOswithcompetingworlds", "long", "vim.version.version5", F_OPTIONAL), ("OtherUIDs", "string[]", "vim.version.version5", F_OPTIONAL), ("QueueFullSampleSize", "long", "vim.version.version5", F_OPTIONAL), ("QueueFullThreshold", "long", "vim.version.version5", F_OPTIONAL), ("Revision", "string", "vim.version.version5", F_OPTIONAL), ("SCSILevel", "long", "vim.version.version5", F_OPTIONAL), ("Size", "long", "vim.version.version5", F_OPTIONAL), ("Status", "string", "vim.version.version5", F_OPTIONAL), ("ThinProvisioningStatus", "string", "vim.version.version5", F_OPTIONAL), ("VAAIStatus", "string", "vim.version.version5", F_OPTIONAL), ("Vendor", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.device.partition.list.ScsiDevicePartition", "VimEsxCLIstoragecoredevicepartitionlistScsiDevicePartition", "vmodl.DynamicData", "vim.version.version5", [("Device", "string", "vim.version.version5", F_OPTIONAL), ("EndSector", "long", "vim.version.version5", F_OPTIONAL), ("Partition", "long", "vim.version.version5", F_OPTIONAL), ("PartitionName", "string", "vim.version.version5", F_OPTIONAL), ("Path", "string", "vim.version.version5", F_OPTIONAL), ("Size", "long", "vim.version.version5", F_OPTIONAL), ("StartSector", "long", "vim.version.version5", F_OPTIONAL), ("Type", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.device.partition.showguid.ScsiDevicePartitionShowGuid", "VimEsxCLIstoragecoredevicepartitionshowguidScsiDevicePartitionShowGuid", "vmodl.DynamicData", "vim.version.version5", [("Device", "string", "vim.version.version5", F_OPTIONAL), ("GUID", "string", "vim.version.version5", F_OPTIONAL), ("Layout", "string", "vim.version.version5", F_OPTIONAL), ("Partition", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.device.smart.get.SmartDevice", "VimEsxCLIstoragecoredevicesmartgetSmartDevice", "vmodl.DynamicData", "vim.version.version5", [("Parameter", "string", "vim.version.version5", F_OPTIONAL), ("Threshold", "string", "vim.version.version5", F_OPTIONAL), ("Value", "string", "vim.version.version5", F_OPTIONAL), ("Worst", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.device.stats.get.ScsiDeviceStats", "VimEsxCLIstoragecoredevicestatsgetScsiDeviceStats", "vmodl.DynamicData", "vim.version.version5", [("BlocksRead", "long", "vim.version.version5", F_OPTIONAL), ("BlocksWritten", "long", "vim.version.version5", F_OPTIONAL), ("Device", "string", "vim.version.version5", F_OPTIONAL), ("FailedBlocksRead", "long", "vim.version.version5", F_OPTIONAL), ("FailedBlocksWritten", "long", "vim.version.version5", F_OPTIONAL), ("FailedCommands", "long", "vim.version.version5", F_OPTIONAL), ("FailedReadOperations", "long", "vim.version.version5", F_OPTIONAL), ("FailedReserveOperations", "long", "vim.version.version5", F_OPTIONAL), ("FailedWriteOperations", "long", "vim.version.version5", F_OPTIONAL), ("ReadOperations", "long", "vim.version.version5", F_OPTIONAL), ("ReservationConflicts", "long", "vim.version.version5", F_OPTIONAL), ("ReserveOperations", "long", "vim.version.version5", F_OPTIONAL), ("SuccessfulCommands", "long", "vim.version.version5", F_OPTIONAL), ("WriteOperations", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.device.vaai.status.get.ScsiDevice", "VimEsxCLIstoragecoredevicevaaistatusgetScsiDevice", "vmodl.DynamicData", "vim.version.version5", [("ATSStatus", "string", "vim.version.version5", F_OPTIONAL), ("CloneStatus", "string", "vim.version.version5", F_OPTIONAL), ("DeleteStatus", "string", "vim.version.version5", F_OPTIONAL), ("Device", "string", "vim.version.version5", F_OPTIONAL), ("VAAIPluginName", "string", "vim.version.version5", F_OPTIONAL), ("ZeroStatus", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.device.world.list.ScsiDeviceWorld", "VimEsxCLIstoragecoredeviceworldlistScsiDeviceWorld", "vmodl.DynamicData", "vim.version.version5", [("Device", "string", "vim.version.version5", F_OPTIONAL), ("OpenCount", "long", "vim.version.version5", F_OPTIONAL), ("WorldID", "long", "vim.version.version5", F_OPTIONAL), ("WorldName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.path.list.ScsiPath", "VimEsxCLIstoragecorepathlistScsiPath", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("AdapterIdentifier", "string", "vim.version.version5", F_OPTIONAL), ("AdapterTransportDetails", "string", "vim.version.version5", F_OPTIONAL), ("Channel", "long", "vim.version.version5", F_OPTIONAL), ("Device", "string", "vim.version.version5", F_OPTIONAL), ("DeviceDisplayName", "string", "vim.version.version5", F_OPTIONAL), ("LUN", "long", "vim.version.version5", F_OPTIONAL), ("MaximumIOSize", "long", "vim.version.version5", F_OPTIONAL), ("Plugin", "string", "vim.version.version5", F_OPTIONAL), ("RuntimeName", "string", "vim.version.version5", F_OPTIONAL), ("State", "string", "vim.version.version5", F_OPTIONAL), ("Target", "long", "vim.version.version5", F_OPTIONAL), ("TargetIdentifier", "string", "vim.version.version5", F_OPTIONAL), ("TargetTransportDetails", "string", "vim.version.version5", F_OPTIONAL), ("Transport", "string", "vim.version.version5", F_OPTIONAL), ("UID", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.path.stats.get.ScsiPathStats", "VimEsxCLIstoragecorepathstatsgetScsiPathStats", "vmodl.DynamicData", "vim.version.version5", [("BlocksRead", "long", "vim.version.version5", F_OPTIONAL), ("BlocksWritten", "long", "vim.version.version5", F_OPTIONAL), ("FailedBlocksRead", "long", "vim.version.version5", F_OPTIONAL), ("FailedBlocksWritten", "long", "vim.version.version5", F_OPTIONAL), ("FailedCommands", "long", "vim.version.version5", F_OPTIONAL), ("FailedReadOperations", "long", "vim.version.version5", F_OPTIONAL), ("FailedReserveOperations", "long", "vim.version.version5", F_OPTIONAL), ("FailedWriteOperations", "long", "vim.version.version5", F_OPTIONAL), ("PAECommands", "long", "vim.version.version5", F_OPTIONAL), ("ReadOperations", "long", "vim.version.version5", F_OPTIONAL), ("ReservationConflicts", "long", "vim.version.version5", F_OPTIONAL), ("ReserveOperations", "long", "vim.version.version5", F_OPTIONAL), ("RuntimeName", "string", "vim.version.version5", F_OPTIONAL), ("SuccessfulCommands", "long", "vim.version.version5", F_OPTIONAL), ("TotalSplits", "long", "vim.version.version5", F_OPTIONAL), ("UID", "string", "vim.version.version5", F_OPTIONAL), ("WriteOperations", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.plugin.list.PsaPlugin", "VimEsxCLIstoragecorepluginlistPsaPlugin", "vmodl.DynamicData", "vim.version.version5", [("Pluginclass", "string", "vim.version.version5", F_OPTIONAL), ("Pluginname", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.core.plugin.registration.list.RegisteredModuleList", "VimEsxCLIstoragecorepluginregistrationlistRegisteredModuleList", "vmodl.DynamicData", "vim.version.version5", [("Dependencies", "string", "vim.version.version5", F_OPTIONAL), ("FullPath", "string", "vim.version.version5", F_OPTIONAL), ("ModuleName", "string", "vim.version.version5", F_OPTIONAL), ("PluginClass", "string", "vim.version.version5", F_OPTIONAL), ("PluginName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.filesystem.list.FilesystemVolume", "VimEsxCLIstoragefilesystemlistFilesystemVolume", "vmodl.DynamicData", "vim.version.version5", [("Free", "long", "vim.version.version5", F_OPTIONAL), ("MountPoint", "string", "vim.version.version5", F_OPTIONAL), ("Mounted", "boolean", "vim.version.version5", F_OPTIONAL), ("Size", "long", "vim.version.version5", F_OPTIONAL), ("Type", "string", "vim.version.version5", F_OPTIONAL), ("UUID", "string", "vim.version.version5", F_OPTIONAL), ("VolumeName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.nfs.list.NasMount", "VimEsxCLIstoragenfslistNasMount", "vmodl.DynamicData", "vim.version.version5", [("Accessible", "boolean", "vim.version.version5", F_OPTIONAL), ("HardwareAcceleration", "string", "vim.version.version5", F_OPTIONAL), ("Host", "string", "vim.version.version5", F_OPTIONAL), ("Mounted", "boolean", "vim.version.version5", F_OPTIONAL), ("ReadOnly", "boolean", "vim.version.version5", F_OPTIONAL), ("Share", "string", "vim.version.version5", F_OPTIONAL), ("VolumeName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.nfs.param.get.NasMountParams", "VimEsxCLIstoragenfsparamgetNasMountParams", "vmodl.DynamicData", "vim.version.version5", [("MaxQueueDepth", "long", "vim.version.version5", F_OPTIONAL), ("MaxReadTransferSize", "long", "vim.version.version5", F_OPTIONAL), ("MaxWriteTransferSize", "long", "vim.version.version5", F_OPTIONAL), ("VolumeName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.nmp.device.list.NmpDevice", "VimEsxCLIstoragenmpdevicelistNmpDevice", "vmodl.DynamicData", "vim.version.version5", [("Device", "string", "vim.version.version5", F_OPTIONAL), ("DeviceDisplayName", "string", "vim.version.version5", F_OPTIONAL), ("IsBootUSBDevice", "boolean", "vim.version.version5", F_OPTIONAL), ("IsLocalSASDevice", "boolean", "vim.version.version5", F_OPTIONAL), ("IsUSB", "boolean", "vim.version.version5", F_OPTIONAL), ("PathSelectionPolicy", "string", "vim.version.version5", F_OPTIONAL), ("PathSelectionPolicyDeviceConfig", "string", "vim.version.version5", F_OPTIONAL), ("PathSelectionPolicyDeviceCustomConfig", "string", "vim.version.version5", F_OPTIONAL), ("StorageArrayType", "string", "vim.version.version5", F_OPTIONAL), ("StorageArrayTypeDeviceConfig", "string", "vim.version.version5", F_OPTIONAL), ("WorkingPaths", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.nmp.path.list.ScsiPath", "VimEsxCLIstoragenmppathlistScsiPath", "vmodl.DynamicData", "vim.version.version5", [("ArrayPriority", "long", "vim.version.version5", F_OPTIONAL), ("Device", "string", "vim.version.version5", F_OPTIONAL), ("DeviceDisplayName", "string", "vim.version.version5", F_OPTIONAL), ("GroupState", "string", "vim.version.version5", F_OPTIONAL), ("Path", "string", "vim.version.version5", F_OPTIONAL), ("PathSelectionPolicyPathConfig", "string", "vim.version.version5", F_OPTIONAL), ("RuntimeName", "string", "vim.version.version5", F_OPTIONAL), ("StorageArrayTypePathConfig", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.nmp.psp.fixed.deviceconfig.get.FixedDeviceConfiguration", "VimEsxCLIstoragenmppspfixeddeviceconfiggetFixedDeviceConfiguration", "vmodl.DynamicData", "vim.version.version5", [("ConfiguredPreferredPath", "string", "vim.version.version5", F_OPTIONAL), ("Device", "string", "vim.version.version5", F_OPTIONAL), ("PreferredPath", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.nmp.psp.list.PathSelectionPolicy", "VimEsxCLIstoragenmppsplistPathSelectionPolicy", "vmodl.DynamicData", "vim.version.version5", [("Description", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.nmp.psp.roundrobin.deviceconfig.get.RoundRobinDeviceConfiguration", "VimEsxCLIstoragenmppsproundrobindeviceconfiggetRoundRobinDeviceConfiguration", "vmodl.DynamicData", "vim.version.version5", [("ByteLimit", "long", "vim.version.version5", F_OPTIONAL), ("Device", "string", "vim.version.version5", F_OPTIONAL), ("IOOperationLimit", "long", "vim.version.version5", F_OPTIONAL), ("LimitType", "string", "vim.version.version5", F_OPTIONAL), ("UseActiveUnoptimizedPaths", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.nmp.satp.list.StorageArrayTypePlugin", "VimEsxCLIstoragenmpsatplistStorageArrayTypePlugin", "vmodl.DynamicData", "vim.version.version5", [("DefaultPSP", "string", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.nmp.satp.rule.list.StorageArrayTypePluginRule", "VimEsxCLIstoragenmpsatprulelistStorageArrayTypePluginRule", "vmodl.DynamicData", "vim.version.version5", [("ClaimOptions", "string", "vim.version.version5", F_OPTIONAL), ("DefaultPSP", "string", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("Device", "string", "vim.version.version5", F_OPTIONAL), ("Driver", "string", "vim.version.version5", F_OPTIONAL), ("Model", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Options", "string", "vim.version.version5", F_OPTIONAL), ("PSPOptions", "string", "vim.version.version5", F_OPTIONAL), ("RuleGroup", "string", "vim.version.version5", F_OPTIONAL), ("Transport", "string", "vim.version.version5", F_OPTIONAL), ("Vendor", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.san.fc.events.get.FcEvent", "VimEsxCLIstoragesanfceventsgetFcEvent", "vmodl.DynamicData", "vim.version.version5", [("FCEventLog", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.san.fc.list.FcDevice", "VimEsxCLIstoragesanfclistFcDevice", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("NodeName", "string", "vim.version.version5", F_OPTIONAL), ("PortID", "string", "vim.version.version5", F_OPTIONAL), ("PortName", "string", "vim.version.version5", F_OPTIONAL), ("PortState", "string", "vim.version.version5", F_OPTIONAL), ("PortType", "string", "vim.version.version5", F_OPTIONAL), ("Speed", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.san.fc.stats.get.FcStat", "VimEsxCLIstoragesanfcstatsgetFcStat", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("ControlRequests", "long", "vim.version.version5", F_OPTIONAL), ("DumpedFrames", "long", "vim.version.version5", F_OPTIONAL), ("ErrorFrames", "long", "vim.version.version5", F_OPTIONAL), ("InputRequests", "long", "vim.version.version5", F_OPTIONAL), ("InvalidCRCCount", "long", "vim.version.version5", F_OPTIONAL), ("InvalidTxWordCount", "long", "vim.version.version5", F_OPTIONAL), ("LinkFailureCount", "long", "vim.version.version5", F_OPTIONAL), ("LipCount", "long", "vim.version.version5", F_OPTIONAL), ("LossofSignalCount", "long", "vim.version.version5", F_OPTIONAL), ("OutputRequests", "long", "vim.version.version5", F_OPTIONAL), ("PrimSeqProtocolErrCount", "long", "vim.version.version5", F_OPTIONAL), ("RxFrames", "long", "vim.version.version5", F_OPTIONAL), ("TxFrames", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.san.fcoe.list.FcoeDevice", "VimEsxCLIstoragesanfcoelistFcoeDevice", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("ControllerMAC", "string", "vim.version.version5", F_OPTIONAL), ("FCFMAC", "string", "vim.version.version5", F_OPTIONAL), ("NodeName", "string", "vim.version.version5", F_OPTIONAL), ("PortID", "string", "vim.version.version5", F_OPTIONAL), ("PortName", "string", "vim.version.version5", F_OPTIONAL), ("PortState", "string", "vim.version.version5", F_OPTIONAL), ("PortType", "string", "vim.version.version5", F_OPTIONAL), ("Speed", "long", "vim.version.version5", F_OPTIONAL), ("VLANID", "long", "vim.version.version5", F_OPTIONAL), ("VNPortMAC", "string", "vim.version.version5", F_OPTIONAL), ("VmnicName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.san.fcoe.stats.get.FcoeStat", "VimEsxCLIstoragesanfcoestatsgetFcoeStat", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("ControlRequests", "long", "vim.version.version5", F_OPTIONAL), ("DumpedFrames", "long", "vim.version.version5", F_OPTIONAL), ("ErrorFrames", "long", "vim.version.version5", F_OPTIONAL), ("InputRequests", "long", "vim.version.version5", F_OPTIONAL), ("InvalidCRCCount", "long", "vim.version.version5", F_OPTIONAL), ("InvalidTxWordCount", "long", "vim.version.version5", F_OPTIONAL), ("LinkFailureCount", "long", "vim.version.version5", F_OPTIONAL), ("LossofSignalCount", "long", "vim.version.version5", F_OPTIONAL), ("MissDiscAdvCount", "long", "vim.version.version5", F_OPTIONAL), ("OutputRequests", "long", "vim.version.version5", F_OPTIONAL), ("RxFrames", "long", "vim.version.version5", F_OPTIONAL), ("TxFrames", "long", "vim.version.version5", F_OPTIONAL), ("VLinkFailureCount", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.san.iscsi.list.iScsiDevice", "VimEsxCLIstoragesaniscsilistiScsiDevice", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("Driver", "string", "vim.version.version5", F_OPTIONAL), ("State", "string", "vim.version.version5", F_OPTIONAL), ("UID", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.san.iscsi.stats.get.iScsiStat", "VimEsxCLIstoragesaniscsistatsgetiScsiStat", "vmodl.DynamicData", "vim.version.version5", [("Adapter", "string", "vim.version.version5", F_OPTIONAL), ("AsyncEventPDUs", "long", "vim.version.version5", F_OPTIONAL), ("BidirectionalCommandPDUs", "long", "vim.version.version5", F_OPTIONAL), ("CommandPDUs", "long", "vim.version.version5", F_OPTIONAL), ("DatainPDUs", "long", "vim.version.version5", F_OPTIONAL), ("DataoutPDUs", "long", "vim.version.version5", F_OPTIONAL), ("DigestErrors", "long", "vim.version.version5", F_OPTIONAL), ("IODataReceived", "long", "vim.version.version5", F_OPTIONAL), ("IODataSent", "long", "vim.version.version5", F_OPTIONAL), ("LoginRequestPDUs", "long", "vim.version.version5", F_OPTIONAL), ("LoginResponsePDUs", "long", "vim.version.version5", F_OPTIONAL), ("LogoutRequestPDUs", "long", "vim.version.version5", F_OPTIONAL), ("LogoutResponsePDUs", "long", "vim.version.version5", F_OPTIONAL), ("NOPInPDUs", "long", "vim.version.version5", F_OPTIONAL), ("NOPOutPDUs", "long", "vim.version.version5", F_OPTIONAL), ("NoRxDataCount", "long", "vim.version.version5", F_OPTIONAL), ("NoTxBufCount", "long", "vim.version.version5", F_OPTIONAL), ("NodataCommandPDUs", "long", "vim.version.version5", F_OPTIONAL), ("R2TPDUs", "long", "vim.version.version5", F_OPTIONAL), ("ReadCommandPDUs", "long", "vim.version.version5", F_OPTIONAL), ("RejectPDUs", "long", "vim.version.version5", F_OPTIONAL), ("ResponsePDUs", "long", "vim.version.version5", F_OPTIONAL), ("SNACKPDUs", "long", "vim.version.version5", F_OPTIONAL), ("TaskMgmtRequestPDUs", "long", "vim.version.version5", F_OPTIONAL), ("TaskMgmtResponsePDUs", "long", "vim.version.version5", F_OPTIONAL), ("TextRequestPDUs", "long", "vim.version.version5", F_OPTIONAL), ("TextResponsePDUs", "long", "vim.version.version5", F_OPTIONAL), ("Timeouts", "long", "vim.version.version5", F_OPTIONAL), ("TotalNumberofConnections", "long", "vim.version.version5", F_OPTIONAL), ("TotalNumberofSessions", "long", "vim.version.version5", F_OPTIONAL), ("WriteCommandPDUs", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.san.sas.list.SasDevice", "VimEsxCLIstoragesansaslistSasDevice", "vmodl.DynamicData", "vim.version.version5", [("DeviceName", "string", "vim.version.version5", F_OPTIONAL), ("MaximumLinkRate", "long", "vim.version.version5", F_OPTIONAL), ("MinimumLinkRate", "long", "vim.version.version5", F_OPTIONAL), ("NegotiatedLinkRate", "long", "vim.version.version5", F_OPTIONAL), ("PhysicalID", "long", "vim.version.version5", F_OPTIONAL), ("SASAddress", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.san.sas.stats.get.SasStat", "VimEsxCLIstoragesansasstatsgetSasStat", "vmodl.DynamicData", "vim.version.version5", [("DeviceName", "string", "vim.version.version5", F_OPTIONAL), ("InvalidDWORDCount", "long", "vim.version.version5", F_OPTIONAL), ("LossofDWORDSyncCount", "long", "vim.version.version5", F_OPTIONAL), ("PhyResetProblemCount", "long", "vim.version.version5", F_OPTIONAL), ("RunningDisparityErrorCount", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.vflash.cache.get.VFlashCacheInfo", "VimEsxCLIstoragevflashcachegetVFlashCacheInfo", "vmodl.DynamicData", "vim.version.version5", [("WorldID", "long", "vim.version.version5", F_OPTIONAL), ("cachename", "string", "vim.version.version5", F_OPTIONAL), ("vmdkname", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.vflash.cache.stats.get.CacheOperationStats", "VimEsxCLIstoragevflashcachestatsgetCacheOperationStats", "vmodl.DynamicData", "vim.version.version5", [("LastIOoperationtimeinmicroseconds", "long", "vim.version.version5", F_OPTIONAL), ("MeanblocksperIOoperation", "long", "vim.version.version5", F_OPTIONAL), ("NumberofIOblocksinlastoperation", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.vflash.cache.stats.get.CacheIOStats", "VimEsxCLIstoragevflashcachestatsgetCacheIOStats", "vmodl.DynamicData", "vim.version.version5", [("Cachehitrateasapercentage", "long", "vim.version.version5", F_OPTIONAL), ("MaxobservedIOlatencyinmicroseconds", "long", "vim.version.version5", F_OPTIONAL), ("MaxobservedIOPS", "long", "vim.version.version5", F_OPTIONAL), ("MaxobservednumberofKBperIO", "long", "vim.version.version5", F_OPTIONAL), ("MeanIOlatencyinmicroseconds", "long", "vim.version.version5", F_OPTIONAL), ("MeanIOPS", "long", "vim.version.version5", F_OPTIONAL), ("MeancacheIOlatencyinmicroseconds", "long", "vim.version.version5", F_OPTIONAL), ("MeandiskIOlatencyinmicroseconds", "long", "vim.version.version5", F_OPTIONAL), ("MeannumberofKBperIO", "long", "vim.version.version5", F_OPTIONAL), ("TotalIOs", "long", "vim.version.version5", F_OPTIONAL), ("TotalcacheIOs", "long", "vim.version.version5", F_OPTIONAL), ("TotaldiskIOs", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.vflash.cache.stats.get.VFlashCacheStats", "VimEsxCLIstoragevflashcachestatsgetVFlashCacheStats", "vmodl.DynamicData", "vim.version.version5", [("Evict", "vim.EsxCLI.storage.vflash.cache.stats.get.CacheOperationStats[]", "vim.version.version5", F_OPTIONAL), ("Meannumberofcacheblocksinuse", "long", "vim.version.version5", F_OPTIONAL), ("Read", "vim.EsxCLI.storage.vflash.cache.stats.get.CacheIOStats[]", "vim.version.version5", F_OPTIONAL), ("TotalfailedSSDIOs", "long", "vim.version.version5", F_OPTIONAL), ("TotalfaileddiskIOs", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.vflash.device.list.Device", "VimEsxCLIstoragevflashdevicelistDevice", "vmodl.DynamicData", "vim.version.version5", [("Eligibility", "string[]", "vim.version.version5", F_OPTIONAL), ("IsLocal", "boolean", "vim.version.version5", F_OPTIONAL), ("IsUsedinvflash", "boolean", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Size", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.vflash.module.get.ModuleInfo", "VimEsxCLIstoragevflashmodulegetModuleInfo", "vmodl.DynamicData", "vim.version.version5", [("minSupportedModuleVersion", "string", "vim.version.version5", F_OPTIONAL), ("revision", "string", "vim.version.version5", F_OPTIONAL), ("supportedCacheBlockSizeMax", "long", "vim.version.version5", F_OPTIONAL), ("supportedCacheBlockSizeMin", "long", "vim.version.version5", F_OPTIONAL), ("supportedCacheSizeMax", "long", "vim.version.version5", F_OPTIONAL), ("supportedCacheSizeMin", "long", "vim.version.version5", F_OPTIONAL), ("supportedDiskSizeMax", "long", "vim.version.version5", F_OPTIONAL), ("supportedModeMask", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.vflash.module.stats.get.VFlashModuleStats", "VimEsxCLIstoragevflashmodulestatsgetVFlashModuleStats", "vmodl.DynamicData", "vim.version.version5", [("NumActiveVMDKs", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.vmfs.extent.list.FilesystemVMFSExtents", "VimEsxCLIstoragevmfsextentlistFilesystemVMFSExtents", "vmodl.DynamicData", "vim.version.version5", [("DeviceName", "string", "vim.version.version5", F_OPTIONAL), ("ExtentNumber", "long", "vim.version.version5", F_OPTIONAL), ("LVMUUID", "string", "vim.version.version5", F_OPTIONAL), ("Partition", "long", "vim.version.version5", F_OPTIONAL), ("VMFSUUID", "string", "vim.version.version5", F_OPTIONAL), ("VolumeName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.vmfs.snapshot.extent.list.VMFSSnapshotExtent", "VimEsxCLIstoragevmfssnapshotextentlistVMFSSnapshotExtent", "vmodl.DynamicData", "vim.version.version5", [("DeviceName", "string", "vim.version.version5", F_OPTIONAL), ("End", "long", "vim.version.version5", F_OPTIONAL), ("ExtentNumber", "long", "vim.version.version5", F_OPTIONAL), ("LVMUUID", "string", "vim.version.version5", F_OPTIONAL), ("Partition", "long", "vim.version.version5", F_OPTIONAL), ("Start", "long", "vim.version.version5", F_OPTIONAL), ("VMFSUUID", "string", "vim.version.version5", F_OPTIONAL), ("VolumeName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.storage.vmfs.snapshot.list.VMFSSnapshot", "VimEsxCLIstoragevmfssnapshotlistVMFSSnapshot", "vmodl.DynamicData", "vim.version.version5", [("Canmount", "boolean", "vim.version.version5", F_OPTIONAL), ("Canresignature", "boolean", "vim.version.version5", F_OPTIONAL), ("Reasonfornonresignaturability", "string", "vim.version.version5", F_OPTIONAL), ("Reasonforunmountability", "string", "vim.version.version5", F_OPTIONAL), ("UnresolvedExtentCount", "long", "vim.version.version5", F_OPTIONAL), ("VMFSUUID", "string", "vim.version.version5", F_OPTIONAL), ("VolumeName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.boot.device.get.SystemBootDevice", "VimEsxCLIsystembootdevicegetSystemBootDevice", "vmodl.DynamicData", "vim.version.version5", [("BootFilesystemUUID", "string", "vim.version.version5", F_OPTIONAL), ("BootNIC", "string", "vim.version.version5", F_OPTIONAL), ("StatelessBootNIC", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.coredump.file.get.KernelDumpFile", "VimEsxCLIsystemcoredumpfilegetKernelDumpFile", "vmodl.DynamicData", "vim.version.version5", [("Active", "string", "vim.version.version5", F_OPTIONAL), ("Configured", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.coredump.file.list.DumpFile", "VimEsxCLIsystemcoredumpfilelistDumpFile", "vmodl.DynamicData", "vim.version.version5", [("Active", "boolean", "vim.version.version5", F_OPTIONAL), ("Configured", "boolean", "vim.version.version5", F_OPTIONAL), ("Path", "string", "vim.version.version5", F_OPTIONAL), ("Size", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.coredump.network.get.NetworkCoredump", "VimEsxCLIsystemcoredumpnetworkgetNetworkCoredump", "vmodl.DynamicData", "vim.version.version5", [("Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("HostVNic", "string", "vim.version.version5", F_OPTIONAL), ("NetworkServerIP", "string", "vim.version.version5", F_OPTIONAL), ("NetworkServerPort", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.coredump.partition.get.KernelDumpParition", "VimEsxCLIsystemcoredumppartitiongetKernelDumpParition", "vmodl.DynamicData", "vim.version.version5", [("Active", "string", "vim.version.version5", F_OPTIONAL), ("Configured", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.coredump.partition.list.DumpPartition", "VimEsxCLIsystemcoredumppartitionlistDumpPartition", "vmodl.DynamicData", "vim.version.version5", [("Active", "boolean", "vim.version.version5", F_OPTIONAL), ("Configured", "boolean", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Path", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.hostname.get.FullyQualifiedHostName", "VimEsxCLIsystemhostnamegetFullyQualifiedHostName", "vmodl.DynamicData", "vim.version.version5", [("DomainName", "string", "vim.version.version5", F_OPTIONAL), ("FullyQualifiedDomainName", "string", "vim.version.version5", F_OPTIONAL), ("HostName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.module.get.ModuleDetails", "VimEsxCLIsystemmodulegetModuleDetails", "vmodl.DynamicData", "vim.version.version5", [("FileVersion", "string", "vim.version.version5", F_OPTIONAL), ("License", "string", "vim.version.version5", F_OPTIONAL), ("Module", "string", "vim.version.version5", F_OPTIONAL), ("ModuleFile", "string", "vim.version.version5", F_OPTIONAL), ("ProvidedNamespaces", "string", "vim.version.version5", F_OPTIONAL), ("RequiredNamespaces", "string[]", "vim.version.version5", F_OPTIONAL), ("SignatureDigest", "string", "vim.version.version5", F_OPTIONAL), ("SignatureFingerPrint", "string", "vim.version.version5", F_OPTIONAL), ("SignatureIssuer", "string", "vim.version.version5", F_OPTIONAL), ("SignedStatus", "string", "vim.version.version5", F_OPTIONAL), ("Version", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.module.list.Module", "VimEsxCLIsystemmodulelistModule", "vmodl.DynamicData", "vim.version.version5", [("IsEnabled", "boolean", "vim.version.version5", F_OPTIONAL), ("IsLoaded", "boolean", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.module.parameters.list.ModuleParameter", "VimEsxCLIsystemmoduleparameterslistModuleParameter", "vmodl.DynamicData", "vim.version.version5", [("Description", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Type", "string", "vim.version.version5", F_OPTIONAL), ("Value", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.process.list.UserWorld", "VimEsxCLIsystemprocesslistUserWorld", "vmodl.DynamicData", "vim.version.version5", [("CartelGroupId", "long", "vim.version.version5", F_OPTIONAL), ("CartelId", "long", "vim.version.version5", F_OPTIONAL), ("CommandLine", "string", "vim.version.version5", F_OPTIONAL), ("Id", "long", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("ParentCartelId", "long", "vim.version.version5", F_OPTIONAL), ("SecurityDomain", "string", "vim.version.version5", F_OPTIONAL), ("SessionId", "long", "vim.version.version5", F_OPTIONAL), ("WorldFlags", "long", "vim.version.version5", F_OPTIONAL), ("WorldGroupId", "long", "vim.version.version5", F_OPTIONAL), ("WorldState", "string", "vim.version.version5", F_OPTIONAL), ("WorldType", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.process.stats.load.get.ProcessStatsLoadGet", "VimEsxCLIsystemprocessstatsloadgetProcessStatsLoadGet", "vmodl.DynamicData", "vim.version.version5", [("Load1Minute", "string", "vim.version.version5", F_OPTIONAL), ("Load15Minutes", "string", "vim.version.version5", F_OPTIONAL), ("Load5Minutes", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.process.stats.running.get.ProcessStatsRunningGet", "VimEsxCLIsystemprocessstatsrunninggetProcessStatsRunningGet", "vmodl.DynamicData", "vim.version.version5", [("RunningProcesses", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.secpolicy.domain.list.DomainList", "VimEsxCLIsystemsecpolicydomainlistDomainList", "vmodl.DynamicData", "vim.version.version5", [("DomainName", "string", "vim.version.version5", F_OPTIONAL), ("EnforcementLevel", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.settings.advanced.list.SettingsAdvancedOption", "VimEsxCLIsystemsettingsadvancedlistSettingsAdvancedOption", "vmodl.DynamicData", "vim.version.version5", [("DefaultIntValue", "long", "vim.version.version5", F_OPTIONAL), ("DefaultStringValue", "string", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("IntValue", "long", "vim.version.version5", F_OPTIONAL), ("MaxValue", "long", "vim.version.version5", F_OPTIONAL), ("MinValue", "long", "vim.version.version5", F_OPTIONAL), ("Path", "string", "vim.version.version5", F_OPTIONAL), ("StringValue", "string", "vim.version.version5", F_OPTIONAL), ("Type", "string", "vim.version.version5", F_OPTIONAL), ("ValidCharacters", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.settings.kernel.list.SettingsKernel", "VimEsxCLIsystemsettingskernellistSettingsKernel", "vmodl.DynamicData", "vim.version.version5", [("Configured", "string", "vim.version.version5", F_OPTIONAL), ("Default", "string", "vim.version.version5", F_OPTIONAL), ("Description", "string", "vim.version.version5", F_OPTIONAL), ("Name", "string", "vim.version.version5", F_OPTIONAL), ("Runtime", "string", "vim.version.version5", F_OPTIONAL), ("Type", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.settings.keyboard.layout.list.Layout", "VimEsxCLIsystemsettingskeyboardlayoutlistLayout", "vmodl.DynamicData", "vim.version.version5", [("Layout", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.snmp.get.AgentConfig", "VimEsxCLIsystemsnmpgetAgentConfig", "vmodl.DynamicData", "vim.version.version5", [("authentication", "string", "vim.version.version5", F_OPTIONAL), ("communities", "string[]", "vim.version.version5", F_OPTIONAL), ("enable", "boolean", "vim.version.version5", F_OPTIONAL), ("engineid", "string", "vim.version.version5", F_OPTIONAL), ("hwsrc", "string", "vim.version.version5", F_OPTIONAL), ("largestorage", "boolean", "vim.version.version5", F_OPTIONAL), ("loglevel", "string", "vim.version.version5", F_OPTIONAL), ("notraps", "string[]", "vim.version.version5", F_OPTIONAL), ("port", "long", "vim.version.version5", F_OPTIONAL), ("privacy", "string", "vim.version.version5", F_OPTIONAL), ("remoteusers", "string[]", "vim.version.version5", F_OPTIONAL), ("syscontact", "string", "vim.version.version5", F_OPTIONAL), ("syslocation", "string", "vim.version.version5", F_OPTIONAL), ("targets", "string[]", "vim.version.version5", F_OPTIONAL), ("users", "string[]", "vim.version.version5", F_OPTIONAL), ("v3targets", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.snmp.hash.SNMPv3Hash", "VimEsxCLIsystemsnmphashSNMPv3Hash", "vmodl.DynamicData", "vim.version.version5", [("authhash", "string", "vim.version.version5", F_OPTIONAL), ("privhash", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.snmp.test.AgentTest", "VimEsxCLIsystemsnmptestAgentTest", "vmodl.DynamicData", "vim.version.version5", [("comments", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.syslog.config.get.SyslogConfiguration", "VimEsxCLIsystemsyslogconfiggetSyslogConfiguration", "vmodl.DynamicData", "vim.version.version5", [("DefaultNetworkRetryTimeout", "long", "vim.version.version5", F_OPTIONAL), ("LocalLogOutput", "string", "vim.version.version5", F_OPTIONAL), ("LocalLogOutputIsConfigured", "boolean", "vim.version.version5", F_OPTIONAL), ("LocalLogOutputIsPersistent", "boolean", "vim.version.version5", F_OPTIONAL), ("LocalLoggingDefaultRotationSize", "long", "vim.version.version5", F_OPTIONAL), ("LocalLoggingDefaultRotations", "long", "vim.version.version5", F_OPTIONAL), ("LogToUniqueSubdirectory", "boolean", "vim.version.version5", F_OPTIONAL), ("RemoteHost", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.syslog.config.logger.list.LoggerConfiguration", "VimEsxCLIsystemsyslogconfigloggerlistLoggerConfiguration", "vmodl.DynamicData", "vim.version.version5", [("Description", "string", "vim.version.version5", F_OPTIONAL), ("Destination", "string", "vim.version.version5", F_OPTIONAL), ("ID", "string", "vim.version.version5", F_OPTIONAL), ("RotationSize", "long", "vim.version.version5", F_OPTIONAL), ("Rotations", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.version.get.VersionGet", "VimEsxCLIsystemversiongetVersionGet", "vmodl.DynamicData", "vim.version.version5", [("Build", "string", "vim.version.version5", F_OPTIONAL), ("Product", "string", "vim.version.version5", F_OPTIONAL), ("Update", "string", "vim.version.version5", F_OPTIONAL), ("Version", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.visorfs.get.VisorfsStatus", "VimEsxCLIsystemvisorfsgetVisorfsStatus", "vmodl.DynamicData", "vim.version.version5", [("FreeInodePercent", "long", "vim.version.version5", F_OPTIONAL), ("LowestFreeInodePercent", "long", "vim.version.version5", F_OPTIONAL), ("PeakReservedInodes", "long", "vim.version.version5", F_OPTIONAL), ("PeakUnlinkedInodes", "long", "vim.version.version5", F_OPTIONAL), ("PeakUsedInodes", "long", "vim.version.version5", F_OPTIONAL), ("ReservedInodes", "long", "vim.version.version5", F_OPTIONAL), ("TotalInodes", "long", "vim.version.version5", F_OPTIONAL), ("UnlinkedInodes", "long", "vim.version.version5", F_OPTIONAL), ("UsedInodes", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.visorfs.ramdisk.list.VisorfsRamdisk", "VimEsxCLIsystemvisorfsramdisklistVisorfsRamdisk", "vmodl.DynamicData", "vim.version.version5", [("AllocatedInodes", "long", "vim.version.version5", F_OPTIONAL), ("Free", "long", "vim.version.version5", F_OPTIONAL), ("IncludeinCoredumps", "boolean", "vim.version.version5", F_OPTIONAL), ("Maximum", "long", "vim.version.version5", F_OPTIONAL), ("MaximumInodes", "long", "vim.version.version5", F_OPTIONAL), ("MountPoint", "string", "vim.version.version5", F_OPTIONAL), ("PeakUsed", "long", "vim.version.version5", F_OPTIONAL), ("RamdiskName", "string", "vim.version.version5", F_OPTIONAL), ("Reserved", "long", "vim.version.version5", F_OPTIONAL), ("ReservedFree", "long", "vim.version.version5", F_OPTIONAL), ("System", "boolean", "vim.version.version5", F_OPTIONAL), ("Used", "long", "vim.version.version5", F_OPTIONAL), ("UsedInodes", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.system.visorfs.tardisk.list.VisorfsTardisk", "VimEsxCLIsystemvisorfstardisklistVisorfsTardisk", "vmodl.DynamicData", "vim.version.version5", [("Size", "long", "vim.version.version5", F_OPTIONAL), ("System", "boolean", "vim.version.version5", F_OPTIONAL), ("TardiskName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.vm.process.list.VirtualMachine", "VimEsxCLIvmprocesslistVirtualMachine", "vmodl.DynamicData", "vim.version.version5", [("ConfigFile", "string", "vim.version.version5", F_OPTIONAL), ("DisplayName", "string", "vim.version.version5", F_OPTIONAL), ("ProcessID", "long", "vim.version.version5", F_OPTIONAL), ("UUID", "string", "vim.version.version5", F_OPTIONAL), ("VMXCartelID", "long", "vim.version.version5", F_OPTIONAL), ("WorldID", "long", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.vsan.cluster.get.VsanClusterGet", "VimEsxCLIvsanclustergetVsanClusterGet", "vmodl.DynamicData", "vim.version.version5", [("CurrentLocalTime", "string", "vim.version.version5", F_OPTIONAL), ("Enabled", "boolean", "vim.version.version5", F_OPTIONAL), ("LocalNodeHealthState", "string", "vim.version.version5", F_OPTIONAL), ("LocalNodeState", "string", "vim.version.version5", F_OPTIONAL), ("LocalNodeUUID", "string", "vim.version.version5", F_OPTIONAL), ("SubClusterBackupUUID", "string", "vim.version.version5", F_OPTIONAL), ("SubClusterMasterUUID", "string", "vim.version.version5", F_OPTIONAL), ("SubClusterMemberUUIDs", "string[]", "vim.version.version5", F_OPTIONAL), ("SubClusterMembershipEntryRevision", "long", "vim.version.version5", F_OPTIONAL), ("SubClusterMembershipUUID", "string", "vim.version.version5", F_OPTIONAL), ("SubClusterUUID", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.vsan.datastore.name.get.DatastoreName", "VimEsxCLIvsandatastorenamegetDatastoreName", "vmodl.DynamicData", "vim.version.version5", [("Name", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.vsan.network.list.VsanNetworkList", "VimEsxCLIvsannetworklistVsanNetworkList", "vmodl.DynamicData", "vim.version.version5", [("AgentGroupMulticastAddress", "string", "vim.version.version5", F_OPTIONAL), ("AgentGroupMulticastPort", "long", "vim.version.version5", F_OPTIONAL), ("IPProtocol", "string", "vim.version.version5", F_OPTIONAL), ("InterfaceUUID", "string", "vim.version.version5", F_OPTIONAL), ("MasterGroupMulticastAddress", "string", "vim.version.version5", F_OPTIONAL), ("MasterGroupMulticastPort", "long", "vim.version.version5", F_OPTIONAL), ("MulticastTTL", "long", "vim.version.version5", F_OPTIONAL), ("VmkNicName", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.vsan.policy.getdefault.Policy", "VimEsxCLIvsanpolicygetdefaultPolicy", "vmodl.DynamicData", "vim.version.version5", [("PolicyClass", "string", "vim.version.version5", F_OPTIONAL), ("PolicyValue", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.vsan.storage.automode.get.AutoMode", "VimEsxCLIvsanstorageautomodegetAutoMode", "vmodl.DynamicData", "vim.version.version5", [("Enabled", "boolean", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.vsan.storage.list.VsanStorageList", "VimEsxCLIvsanstoragelistVsanStorageList", "vmodl.DynamicData", "vim.version.version5", [("Checksum", "string", "vim.version.version5", F_OPTIONAL), ("ChecksumOK", "boolean", "vim.version.version5", F_OPTIONAL), ("Device", "string", "vim.version.version5", F_OPTIONAL), ("DisplayName", "string", "vim.version.version5", F_OPTIONAL), ("InCMMDS", "boolean", "vim.version.version5", F_OPTIONAL), ("IsSSD", "boolean", "vim.version.version5", F_OPTIONAL), ("Usedbythishost", "boolean", "vim.version.version5", F_OPTIONAL), ("VSANDiskGroupName", "string", "vim.version.version5", F_OPTIONAL), ("VSANDiskGroupUUID", "string", "vim.version.version5", F_OPTIONAL), ("VSANUUID", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.CLIInfo.Example", "VimCLIInfoExample", "vmodl.DynamicData", "vim.version.version5", [("example", "string", "vim.version.version5", F_OPTIONAL), ("description", "string", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.EsxCLI.CLIFault", "VimEsxCLICLIFault", "vmodl.RuntimeFault", "vim.version.version5", [("errMsg", "string[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.CLIInfo.Info", "VimCLIInfoInfo", "vmodl.DynamicData", "vim.version.version5", [("name", "string", "vim.version.version5", F_OPTIONAL), ("displayName", "string", "vim.version.version5", F_OPTIONAL), ("help", "string", "vim.version.version5", F_OPTIONAL), ("method", "vim.CLIInfo.Method[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.CLIInfo.Method", "VimCLIInfoMethod", "vmodl.DynamicData", "vim.version.version5", [("name", "string", "vim.version.version5", F_OPTIONAL), ("displayName", "string", "vim.version.version5", F_OPTIONAL), ("help", "string", "vim.version.version5", F_OPTIONAL), ("param", "vim.CLIInfo.Param[]", "vim.version.version5", F_OPTIONAL), ("ret", "vim.CLIInfo.Param", "vim.version.version5", F_OPTIONAL), ("hints", "vim.KeyValue[]", "vim.version.version5", F_OPTIONAL), ("examples", "vim.CLIInfo.Example[]", "vim.version.version5", F_OPTIONAL)])
CreateDataType("vim.CLIInfo.Param", "VimCLIInfoParam", "vmodl.DynamicData", "vim.version.version5", [("name", "string", "vim.version.version5", F_OPTIONAL), ("displayName", "string", "vim.version.version5", F_OPTIONAL), ("aliases", "string[]", "vim.version.version5", F_OPTIONAL), ("default", "string", "vim.version.version5", F_OPTIONAL), ("constraint", "string[]", "vim.version.version5", F_OPTIONAL), ("help", "string", "vim.version.version5", F_OPTIONAL), ("flag", "boolean", "vim.version.version5", F_OPTIONAL)])
