import os
import unittest
import sys

import inmembrane
import inmembrane.tests
from inmembrane import helpers
from inmembrane.plugins import tmbetadisc_rbf_web

from inmembrane.tests.PluginTestBase import PluginTestBase

class TestTmbetadisc_rbf(PluginTestBase):
  _plugin_name = "tmbetadisc_rbf_web"
  
  def test_tmbetadisc_rbf_web(self): 
    tmbetadisc_rbf_web.annotate(self.params, self.proteins)
    
    self.expected_output = {
        'gi|107836852': {
          'sequence_length': 270, 
          'name': 'outer membrane protein HorF [Helicobacter pylori HPAG1]', 
          'seq': 'MKKFVVFKTLCLSVVLGNSLLAAEGSTEVQKQLEKPKEYKAVKGEKNAWYLGISYQVGQASQSVKNPPKSSEFNYPKFPVGKTDYLAVMQGLGLTVGYKQFFGEKRWFGARYYGFMDYGHAVFGANALTSDNGGACKLNEPCATKVGTMGNLSDMFTYGVGIDTLYNVINKEDASFGFFFGAQIAGNSWGNTTGAFLETKSPYKHTSYSLDPAIFQFLFNLGIRTHIGRHQEFDFGVKIPTINVYYFNHGNLSFTYRRQYSLYVGYRYNF', 
          'is_tmbetadisc_rbf': True, 
        },
        'gi|107837106': {
          'sequence_length': 326, 
          'name': 'heat shock protein [Helicobacter pylori HPAG1]', 
          'seq': 'MRARCSKKSSMRKEKIMTNFEKIIAQNRLKTNAVLTTYCVIFAFIGLLVDAIRINANDLGVALFKLITFQIFPTITTIMFLAAFVIIVVCIQNFSSIMLSGDEYKLIDTSKVLSSKENQIHRLLLELLEEAKLHFEPKLYIINAPYMNAFASGWDESNSLIALTSALIERLDKDELKAVIAHELSHIRHNDIRLTMCVGILSNIMLLVANFSVYFFMGNRKNSGANLARMILLLLQIVLPFLTLILQMYLSRTREYMADSGAAFLMHDNKPMIRALQKISNDYANNDYKGIDQNSTRSAAYLFNAEMFSTHPSIKNRIQSLSRRVI', 
          'is_tmbetadisc_rbf': False, 
        },
        'gi|107837101': {
          'sequence_length': 2417, 
          'name': 'vacuolating cytotoxin (VacA)-like protein [Helicobacter pylori HPAG1]', 
          'seq': 'MAFKKARLISRFISKGSFKLSKISKKIFTLNQILKCEKPLKCHKKTKSIKKLSNRNKSFLKASILLIGALGGLSHLRANECRYWSWSSWGYQDNIESGPNSPTHNSYCLFSSTQGSGTYYLNTLTTYSAGGASFTQKFNGGTLNVGGNIRFGGTGINGGDVGYITGTYDAQTINFNSSHLTTGNSYADGGGATLNFNAANNITINQASFDNSDAGAQKSYMNFKGSNIKVSGSSFKDDTDGGFSFSGNSNNSTISFNQTNFNQGTYNFSNSANLSFTNSAFNQGTYNFNSAQSVFENSSFNQGTYNFNSAQSVFENSAFNQGTYNFNGNASFDNDIFNQGTYNFNTSKVSFSGANTLNSSSPFASLKGSVSFGSDAVFNLNQTLNSNQTYDILTTNGTIQYGVYQSYLWDLINYKGDKAISHVEVGNNTYDVTFDINGQDETLQETFNKQSIITQFLGDDLQQQAQKTYQQDLSNSQSALNNAASDSKVANNDTGYTQSKNATVAKDAQGLENTNQKIQQDEQALEKDLAQIKQLANSTTGFNQQAFNQAQSTEQQDEQTLQNEENTFNIEQESLDKAIANAKHTSPTPSPTPTPTKHTAQNTPPNKVSPTPTPPTQNLPTTNVWNGVYWLQNQTYSKQGVYYIDPNLSGQSGQSANTLSTYTANLFGRSFGVNIQNGTLIIGNNTESVNDNGLIWIGHGGFGYITGTFSAANIYLTNNFKTGEGVSNSDGGGANITFKASDNITMDGLNYNDAETVTKMIQTGASQHSYAAFDALNNISVTNSSFSDMTWGKFSFSAKNISFSNASFSGFTNPGGSSVISANASNSLSFINSRLNGGAVYNLWANSLIFNNTQAVFNVLHSRGTSNFNATTQLLGNTNFTLSSQSLLNFNGDTTLQNNANITLGNKSQAAFKNSLTLDNDSNLSLDNQSVLNANGASAFNNQASLNIYNGSQATFKSLFFNGGTLSLNASSKLNASSASFSNNTTINLDDSVLSASNTSSLNANINFQGASQADFGGNTTINTASFNFDSASSLSFNNLTANGALNFNGYTPSLTKALMSVSGQFVLGNNGDINLSDINIFDNITKSVTYNILNAQKGITGISGANGYEKILFYGMKIQNATYSGNNNIQTWSFINPLNSSQIIQESIKNGDLTIEILNNPNSASNTIFNIAPELYNYQASKQNPTGYSYDYSDNQAGTYYLTSNIKGLFTPKGSQTPQTPGTYSPFNQPLNSLNIYNKGFSSENLKTLLGILSQNSATLKEMIESNQLDNITNINEVLQLLDKIKITQTQKQALLETINHLTDNINQTFNNGNLIIGATQDNVTNSTSSIWFGGNGYSSPCALDSATCSSFRNTYLGQLLGSTSPYLGYINADFKAKSIYITGTIGSGNAFESGGSADVTFQSTNNLVLNKANIEAQATDNIFNLLGQEGIDKIFNQGNLANVLSQMAMEKIKQAGGLGNFIENALSPLSKELPASLQDETLGQLIGQNNLDDLLNNSGVMNAIQNIISKKLSIFGNFVTPSIIENYLAKQSLKSMLDDKGLLNFIGGYIDASELSSILSVILKDITNPPTSLQKDIGVVANDLLNEFLGQDVIKKLESQELVNNIINNIISQGGLSGVYNQGLGSVLPPSLQNALKENDLGALLSPRGLHDFWQKGYFNFLSNGYVFVNNSSFSNATGGSLNFVANKSIIFDGDNTIDFSKYQGALIFASNDVSNINITTLNATNGLSLNAGLNNVSVQKGEICVNLANCPTTKNSSSTNSSVTPTNESLSVHANSFTFLGVIASNGAIDLSQVKNNSVIGTLNLNENATLQANNLTIANAFNNASNSTANINGDFTLNQQATLSTNASGLNVMGNFNSYGDLVFNLSHSVSHAIINAQGSATIMANNNNPLIQFNTSSKETGTYTLINSAKAIYYGYNDQITGGSSLDNYLKLYALIDINGKHMVMTDNGLTYNGQAVNIKDGGLVVGFKDSQNQYIYTSILYNKVKIAVSNDPINNLQAPTLKQYIAQIQGVQSVDSIDQVGGNQAINWLNKIFETKGSPLFAPYYLESHSTKDLTTIAGDIANTLEVIANPNFKNDATNILQINTYTQQMSRLAKLSDTSTFASADFHERLEALKNKRFADAIPNAMDVILKYSQRNRVKNNVWATGVGGASFINGGTGTLYGINVGYDRFIKGVIVGGYAAYGYSGFHGNITQSGSSNVNMGVYSRAFIKRSELTMSLNETWGYNKTFINSYDPLLSIINQSYRYDTWTTNAKINYGYDFMFKDKSVIFKPQVGLAYYYIGLSGLRGIMDDPIYNQFRANADPNKKSVLTINFALESRHYFNKNSYYFVIADVGRDLFINSMGDKMVRFIGNNTLSYRDGGRYNTFASIITGGEIRLFKTFYVNAGIGARFGLDYKDINITGNIGMRYAF', 
          'is_tmbetadisc_rbf': True, 
        },
        'gi|107836588': {
          'sequence_length': 240, 
          'name': 'hypothetical protein HPAG1_0390 [Helicobacter pylori HPAG1]', 
          'seq': 'MGLKKRAILWSLMGFYAGLNALDYDTLDPKYYKYIKYYKAYEDKEVEELIRDLKRANAKSGLILGINTGFFYNHEIMVRTNSSSITGNILNYLFAYGLRFGYQTFRPSFFARLVKPNIIGRRIYIQYYGGAPKKAGFGSVGFQSVMLNGDFLLDFPLPFVGKYLYMGGYMGLGLGVVAHGVNYTAEWGMSFNAGLALTVLEKNRIEFGFKILNNFPFLQSNSSKETWWGAIASIGYQYVF', 
          'is_tmbetadisc_rbf': True, 
        },
        'gi|107837107': {
          'sequence_length': 180, 
          'name': 'GTP cyclohydrolase I [Helicobacter pylori HPAG1]', 
          'seq': 'MENFFNQFFENIGEDKNREGLKETPKRVQELWKFLYKGYKEDPRVALKSAYFQGVCDEMIVAQNIEFYSTCEHHLLPFLGNISLGYIPKEKIVGISAIAKLIEIYSKRLQIQERLTTQITETFDEIIEPRGVIVVCEAKHLCMSMQGVQKQNAIIKTSVLRGLFKKDPKTRAEFMQLLKS', 
          'is_tmbetadisc_rbf': False, 
        },
      }

    #helpers.print_proteins(self.proteins)
    for seqid in self.proteins:
      self.assertEqual(self.proteins[seqid]["is_tmbetadisc_rbf"], 
                       self.expected_output[seqid]["is_tmbetadisc_rbf"])

if __name__ == '__main__':
  unittest.main()
