
import os
from setuptools import setup

# Utility function to read the README file.
# Used for the long_description.  It's nice, because now 1) we have a top level
# README file and 2) it's easier to type in the README file than to put a raw
# string in below ...
def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

setup(
    name='instantlab_apiclient',
    version='0.1',
    author='Andreas Grapentin',
    author_email='andreas.grapentin@student.hpi.uni-potsdam.de',
    description='An API to the instantlab middleware',

    license='MIT',
    keywords='instantlab api',
    url='http://instantlab.org',
    packages=['instantlab_apiclient'],
    long_description=read('README'),
    zip_safe=False
)

