
from intspan import intspan

def test_basic():
    tests = ['1','1-2', '1-3,9-10', '1-3,14,29,92-97']
    for t in tests:
        s = intspan(t)
        assert str(s) == t
        
def test_merge():
    assert str(intspan('1-4,5')) ==  '1-5'
        
def test_out_of_order():
    assert str(intspan('1,0,99,4,7,9,98')) == '0-1,4,7,9,98-99'

def test_discard():
    s = intspan('1-3,14,29,92-97')
    s.discard('2,13,92')
    assert str(s) == '1,3,14,29,93-97'

def test_add():
    s = intspan('1-2')
    s.add('3,29')
    assert str(s) == '1-3,29'
    s.add('92,97,96,95,94')
    assert str(s) == '1-3,29,92,94-97'
    s.add(93)
    assert str(s) == '1-3,29,92-97'
    s.add('14')
    assert str(s) == '1-3,14,29,92-97'
    
def test_iteration():
    
    s = intspan('92,97,96,95,0,94')
    l = [ item for item in s ]
    assert l == [0, 92, 94, 95, 96, 97]
